import "./chunk-DC5AMYBS.js";

// node_modules/@mediapipe/tasks-vision/vision_bundle.mjs
var commonjsGlobal = "undefined" != typeof globalThis ? globalThis : "undefined" != typeof window ? window : "undefined" != typeof global ? global : "undefined" != typeof self ? self : {};
var vision = {};
var fileset_resolver = {};
var supportsSimd;
Object.defineProperty(fileset_resolver, "__esModule", { value: true }), fileset_resolver.FilesetResolver = void 0;
var WASM_SIMD_CHECK = new Uint8Array([0, 97, 115, 109, 1, 0, 0, 0, 1, 5, 1, 96, 0, 1, 123, 3, 2, 1, 0, 10, 10, 1, 8, 0, 65, 0, 253, 15, 253, 98, 11]);
async function isSimdSupported() {
  if (void 0 === supportsSimd) try {
    await WebAssembly.instantiate(WASM_SIMD_CHECK), supportsSimd = true;
  } catch (e) {
    supportsSimd = false;
  }
  return supportsSimd;
}
async function createFileset(e, t = "") {
  const r = await isSimdSupported() ? "wasm_internal" : "wasm_nosimd_internal";
  return { wasmLoaderPath: `${t}/${e}_${r}.js`, wasmBinaryPath: `${t}/${e}_${r}.wasm` };
}
var FilesetResolver$1 = class {
  static isSimdSupported() {
    return isSimdSupported();
  }
  static forAudioTasks(e) {
    return createFileset("audio", e);
  }
  static forTextTasks(e) {
    return createFileset("text", e);
  }
  static forVisionTasks(e) {
    return createFileset("vision", e);
  }
};
fileset_resolver.FilesetResolver = FilesetResolver$1;
var drawing_utils = {};
Object.defineProperty(drawing_utils, "__esModule", { value: true }), drawing_utils.DrawingUtils = void 0;
var DEFAULT_OPTIONS = { color: "white", lineWidth: 4, radius: 6 };
function addDefaultOptions(e) {
  return e = e || {}, Object.assign(Object.assign(Object.assign({}, DEFAULT_OPTIONS), { fillColor: e.color }), e);
}
function resolve(e, t) {
  return e instanceof Function ? e(t) : e;
}
var DrawingUtils$1 = class _DrawingUtils$1 {
  constructor(e) {
    this.ctx = e;
  }
  static clamp(e, t, r) {
    const o = Math.min(t, r), i = Math.max(t, r);
    return Math.max(o, Math.min(i, e));
  }
  static lerp(e, t, r, o, i) {
    const a2 = o * (1 - (e - t) / (r - t)) + i * (1 - (r - e) / (r - t));
    return _DrawingUtils$1.clamp(a2, o, i);
  }
  drawLandmarks(e, t) {
    if (!e) return;
    const r = this.ctx, o = addDefaultOptions(t);
    r.save();
    const i = r.canvas;
    let a2 = 0;
    for (const t2 of e) {
      r.fillStyle = resolve(o.fillColor, { index: a2, from: t2 }), r.strokeStyle = resolve(o.color, { index: a2, from: t2 }), r.lineWidth = resolve(o.lineWidth, { index: a2, from: t2 });
      const e2 = new Path2D();
      e2.arc(t2.x * i.width, t2.y * i.height, resolve(o.radius, { index: a2, from: t2 }), 0, 2 * Math.PI), r.fill(e2), r.stroke(e2), ++a2;
    }
    r.restore();
  }
  drawConnectors(e, t, r) {
    if (!e || !t) return;
    const o = this.ctx, i = addDefaultOptions(r);
    o.save();
    const a2 = o.canvas;
    let n = 0;
    for (const r2 of t) {
      o.beginPath();
      const t2 = e[r2.start], s = e[r2.end];
      t2 && s && (o.strokeStyle = resolve(i.color, { index: n, from: t2, to: s }), o.lineWidth = resolve(i.lineWidth, { index: n, from: t2, to: s }), o.moveTo(t2.x * a2.width, t2.y * a2.height), o.lineTo(s.x * a2.width, s.y * a2.height)), ++n, o.stroke();
    }
    o.restore();
  }
  drawBoundingBox(e, t) {
    const r = this.ctx, o = addDefaultOptions(t);
    r.save(), r.beginPath(), r.lineWidth = resolve(o.lineWidth, {}), r.strokeStyle = resolve(o.color, {}), r.fillStyle = resolve(o.fillColor, {}), r.moveTo(e.originX, e.originY), r.lineTo(e.originX + e.width, e.originY), r.lineTo(e.originX + e.width, e.originY + e.height), r.lineTo(e.originX, e.originY + e.height), r.lineTo(e.originX, e.originY), r.stroke(), r.fill(), r.restore();
  }
};
drawing_utils.DrawingUtils = DrawingUtils$1;
var image = {};
var image_shader_context = {};
Object.defineProperty(image_shader_context, "__esModule", { value: true }), image_shader_context.MPImageShaderContext = image_shader_context.assertNotNull = void 0;
var VERTEX_SHADER = "\n  attribute vec2 aVertex;\n  attribute vec2 aTex;\n  varying vec2 vTex;\n  void main(void) {\n    gl_Position = vec4(aVertex, 0.0, 1.0);\n    vTex = aTex;\n  }";
var FRAGMENT_SHADER = "\n  precision mediump float;\n  varying vec2 vTex;\n  uniform sampler2D inputTexture;\n   void main() {\n     gl_FragColor = texture2D(inputTexture, vTex);\n   }\n ";
function assertNotNull(e, t) {
  if (null === e) throw new Error(`Unable to obtain required WebGL resource: ${t}`);
  return e;
}
image_shader_context.assertNotNull = assertNotNull;
var MPImageShaderBuffers = class {
  constructor(e, t, r, o) {
    this.gl = e, this.vertexArrayObject = t, this.vertexBuffer = r, this.textureBuffer = o;
  }
  bind() {
    this.gl.bindVertexArray(this.vertexArrayObject);
  }
  unbind() {
    this.gl.bindVertexArray(null);
  }
  close() {
    this.gl.deleteVertexArray(this.vertexArrayObject), this.gl.deleteBuffer(this.vertexBuffer), this.gl.deleteBuffer(this.textureBuffer);
  }
};
var MPImageShaderContext = class {
  compileShader(e, t) {
    const r = this.gl, o = assertNotNull(r.createShader(t), "Failed to create WebGL shader");
    if (r.shaderSource(o, e), r.compileShader(o), !r.getShaderParameter(o, r.COMPILE_STATUS)) {
      const e2 = r.getShaderInfoLog(o);
      throw new Error(`Could not compile WebGL shader: ${e2}`);
    }
    return r.attachShader(this.program, o), o;
  }
  setupShaders() {
    const e = this.gl;
    this.program = assertNotNull(e.createProgram(), "Failed to create WebGL program"), this.vertexShader = this.compileShader(VERTEX_SHADER, e.VERTEX_SHADER), this.fragmentShader = this.compileShader(FRAGMENT_SHADER, e.FRAGMENT_SHADER), e.linkProgram(this.program);
    if (!e.getProgramParameter(this.program, e.LINK_STATUS)) {
      const t = e.getProgramInfoLog(this.program);
      throw new Error(`Error during program linking: ${t}`);
    }
    this.aVertex = e.getAttribLocation(this.program, "aVertex"), this.aTex = e.getAttribLocation(this.program, "aTex");
  }
  createBuffers(e) {
    const t = this.gl, r = assertNotNull(t.createVertexArray(), "Failed to create vertex array");
    t.bindVertexArray(r);
    const o = assertNotNull(t.createBuffer(), "Failed to create buffer");
    t.bindBuffer(t.ARRAY_BUFFER, o), t.enableVertexAttribArray(this.aVertex), t.vertexAttribPointer(this.aVertex, 2, t.FLOAT, false, 0, 0), t.bufferData(t.ARRAY_BUFFER, new Float32Array([-1, -1, -1, 1, 1, 1, 1, -1]), t.STATIC_DRAW);
    const i = assertNotNull(t.createBuffer(), "Failed to create buffer");
    t.bindBuffer(t.ARRAY_BUFFER, i), t.enableVertexAttribArray(this.aTex), t.vertexAttribPointer(this.aTex, 2, t.FLOAT, false, 0, 0);
    const a2 = e ? [0, 1, 0, 0, 1, 0, 1, 1] : [0, 0, 0, 1, 1, 1, 1, 0];
    return t.bufferData(t.ARRAY_BUFFER, new Float32Array(a2), t.STATIC_DRAW), t.bindBuffer(t.ARRAY_BUFFER, null), t.bindVertexArray(null), new MPImageShaderBuffers(t, r, o, i);
  }
  getShaderBuffers(e) {
    return e ? (this.shaderBuffersFlipVertically || (this.shaderBuffersFlipVertically = this.createBuffers(true)), this.shaderBuffersFlipVertically) : (this.shaderBuffersPassthrough || (this.shaderBuffersPassthrough = this.createBuffers(false)), this.shaderBuffersPassthrough);
  }
  maybeInitGL(e) {
    if (this.gl) {
      if (e !== this.gl) throw new Error("Cannot change GL context once initialized");
    } else this.gl = e;
  }
  run(e, t, r) {
    this.maybeInitGL(e), this.program || this.setupShaders();
    const o = this.getShaderBuffers(t);
    e.useProgram(this.program), o.bind();
    const i = r();
    return o.unbind(), i;
  }
  bindFramebuffer(e, t) {
    this.maybeInitGL(e), this.framebuffer || (this.framebuffer = assertNotNull(e.createFramebuffer(), "Failed to create framebuffe.")), e.bindFramebuffer(e.FRAMEBUFFER, this.framebuffer), e.framebufferTexture2D(e.FRAMEBUFFER, e.COLOR_ATTACHMENT0, e.TEXTURE_2D, t, 0);
  }
  unbindFramebuffer() {
    var e;
    null === (e = this.gl) || void 0 === e || e.bindFramebuffer(this.gl.FRAMEBUFFER, null);
  }
  close() {
    if (this.program) {
      const e = this.gl;
      e.deleteProgram(this.program), e.deleteShader(this.vertexShader), e.deleteShader(this.fragmentShader);
    }
    this.framebuffer && this.gl.deleteFramebuffer(this.framebuffer), this.shaderBuffersPassthrough && this.shaderBuffersPassthrough.close(), this.shaderBuffersFlipVertically && this.shaderBuffersFlipVertically.close();
  }
};
image_shader_context.MPImageShaderContext = MPImageShaderContext, Object.defineProperty(image, "__esModule", { value: true }), image.MPImage = void 0;
var image_shader_context_1$2 = image_shader_context;
var INSTANCE_COUNT_WARNING_THRESHOLD$1 = 250;
var MPImageType;
!(function(e) {
  e[e.IMAGE_DATA = 0] = "IMAGE_DATA", e[e.IMAGE_BITMAP = 1] = "IMAGE_BITMAP", e[e.WEBGL_TEXTURE = 2] = "WEBGL_TEXTURE";
})(MPImageType || (MPImageType = {}));
var MPImage$1 = class _MPImage$1 {
  constructor(e, t, r, o, i, a2, n) {
    this.containers = e, this.ownsImageBitmap = t, this.ownsWebGLTexture = r, this.canvas = o, this.shaderContext = i, this.width = a2, this.height = n, (this.ownsImageBitmap || this.ownsWebGLTexture) && (--_MPImage$1.instancesBeforeWarning, 0 === _MPImage$1.instancesBeforeWarning && console.error("You seem to be creating MPImage instances without invoking .close(). This leaks resources."));
  }
  hasImageData() {
    return !!this.getContainer(MPImageType.IMAGE_DATA);
  }
  hasImageBitmap() {
    return !!this.getContainer(MPImageType.IMAGE_BITMAP);
  }
  hasWebGLTexture() {
    return !!this.getContainer(MPImageType.WEBGL_TEXTURE);
  }
  getAsImageData() {
    return this.convertToImageData();
  }
  getAsImageBitmap() {
    return this.convertToImageBitmap();
  }
  getAsWebGLTexture() {
    return this.convertToWebGLTexture();
  }
  getContainer(e) {
    switch (e) {
      case MPImageType.IMAGE_DATA:
        return this.containers.find(((e2) => e2 instanceof ImageData));
      case MPImageType.IMAGE_BITMAP:
        return this.containers.find(((e2) => "undefined" != typeof ImageBitmap && e2 instanceof ImageBitmap));
      case MPImageType.WEBGL_TEXTURE:
        return this.containers.find(((e2) => "undefined" != typeof WebGLTexture && e2 instanceof WebGLTexture));
      default:
        throw new Error(`Type is not supported: ${e}`);
    }
  }
  clone() {
    const e = [];
    for (const t of this.containers) {
      let r;
      if (t instanceof ImageData) r = new ImageData(t.data, this.width, this.height);
      else if (t instanceof WebGLTexture) {
        const e2 = this.getGL(), t2 = this.getShaderContext();
        e2.activeTexture(e2.TEXTURE1), r = (0, image_shader_context_1$2.assertNotNull)(e2.createTexture(), "Failed to create texture"), e2.bindTexture(e2.TEXTURE_2D, r), this.configureTextureParams(), e2.texImage2D(e2.TEXTURE_2D, 0, e2.RGBA, this.width, this.height, 0, e2.RGBA, e2.UNSIGNED_BYTE, null), e2.bindTexture(e2.TEXTURE_2D, null), t2.bindFramebuffer(e2, r), t2.run(e2, false, (() => {
          this.bindTexture(), e2.clearColor(0, 0, 0, 0), e2.clear(e2.COLOR_BUFFER_BIT), e2.drawArrays(e2.TRIANGLE_FAN, 0, 4), this.unbindTexture();
        })), t2.unbindFramebuffer(), this.unbindTexture();
      } else {
        if (!(t instanceof ImageBitmap)) throw new Error(`Type is not supported: ${t}`);
        this.convertToWebGLTexture(), this.bindTexture(), r = this.copyTextureToBitmap(), this.unbindTexture();
      }
      e.push(r);
    }
    return new _MPImage$1(e, this.hasImageBitmap(), this.hasWebGLTexture(), this.canvas, this.shaderContext, this.width, this.height);
  }
  getOffscreenCanvas() {
    if (!(this.canvas instanceof OffscreenCanvas)) throw new Error("Conversion to ImageBitmap requires that the MediaPipe Tasks is initialized with an OffscreenCanvas");
    return this.canvas;
  }
  getGL() {
    if (!this.canvas) throw new Error("Conversion to different image formats require that a canvas is passed when iniitializing the image.");
    return this.gl || (this.gl = (0, image_shader_context_1$2.assertNotNull)(this.canvas.getContext("webgl2"), "You cannot use a canvas that is already bound to a different type of rendering context.")), this.gl;
  }
  getShaderContext() {
    return this.shaderContext || (this.shaderContext = new image_shader_context_1$2.MPImageShaderContext()), this.shaderContext;
  }
  convertToImageBitmap() {
    let e = this.getContainer(MPImageType.IMAGE_BITMAP);
    return e || (this.convertToWebGLTexture(), e = this.convertWebGLTextureToImageBitmap(), this.containers.push(e), this.ownsImageBitmap = true), e;
  }
  convertToImageData() {
    let e = this.getContainer(MPImageType.IMAGE_DATA);
    if (!e) {
      const t = this.getGL(), r = this.getShaderContext(), o = new Uint8Array(this.width * this.height * 4), i = this.convertToWebGLTexture();
      r.bindFramebuffer(t, i), t.readPixels(0, 0, this.width, this.height, t.RGBA, t.UNSIGNED_BYTE, o), r.unbindFramebuffer(), e = new ImageData(new Uint8ClampedArray(o.buffer), this.width, this.height), this.containers.push(e);
    }
    return e;
  }
  convertToWebGLTexture() {
    let e = this.getContainer(MPImageType.WEBGL_TEXTURE);
    if (!e) {
      const t = this.getGL();
      e = this.bindTexture();
      const r = this.getContainer(MPImageType.IMAGE_BITMAP) || this.convertToImageData();
      t.texImage2D(t.TEXTURE_2D, 0, t.RGBA, t.RGBA, t.UNSIGNED_BYTE, r), this.unbindTexture();
    }
    return e;
  }
  configureTextureParams() {
    const e = this.getGL();
    e.texParameteri(e.TEXTURE_2D, e.TEXTURE_WRAP_S, e.CLAMP_TO_EDGE), e.texParameteri(e.TEXTURE_2D, e.TEXTURE_WRAP_T, e.CLAMP_TO_EDGE), e.texParameteri(e.TEXTURE_2D, e.TEXTURE_MIN_FILTER, e.LINEAR), e.texParameteri(e.TEXTURE_2D, e.TEXTURE_MAG_FILTER, e.LINEAR);
  }
  bindTexture() {
    const e = this.getGL();
    e.viewport(0, 0, this.width, this.height), e.activeTexture(e.TEXTURE0);
    let t = this.getContainer(MPImageType.WEBGL_TEXTURE);
    return t ? e.bindTexture(e.TEXTURE_2D, t) : (t = (0, image_shader_context_1$2.assertNotNull)(e.createTexture(), "Failed to create texture"), this.containers.push(t), this.ownsWebGLTexture = true, e.bindTexture(e.TEXTURE_2D, t), this.configureTextureParams()), t;
  }
  unbindTexture() {
    this.gl.bindTexture(this.gl.TEXTURE_2D, null);
  }
  copyTextureToBitmap() {
    const e = this.getGL();
    return this.getShaderContext().run(e, true, (() => this.runWithResizedCanvas((() => (e.bindFramebuffer(e.FRAMEBUFFER, null), e.clearColor(0, 0, 0, 0), e.clear(e.COLOR_BUFFER_BIT), e.drawArrays(e.TRIANGLE_FAN, 0, 4), this.getOffscreenCanvas().transferToImageBitmap())))));
  }
  convertWebGLTextureToImageBitmap() {
    this.bindTexture();
    const e = this.copyTextureToBitmap();
    return this.unbindTexture(), e;
  }
  runWithResizedCanvas(e) {
    const t = this.canvas;
    if (t.width === this.width && t.height === this.height) return e();
    const r = t.width, o = t.height;
    t.width = this.width, t.height = this.height;
    const i = e();
    return t.width = r, t.height = o, i;
  }
  close() {
    if (this.ownsImageBitmap && this.getContainer(MPImageType.IMAGE_BITMAP).close(), this.ownsWebGLTexture) {
      this.getGL().deleteTexture(this.getContainer(MPImageType.WEBGL_TEXTURE));
    }
    _MPImage$1.instancesBeforeWarning = -1;
  }
};
image.MPImage = MPImage$1, MPImage$1.instancesBeforeWarning = INSTANCE_COUNT_WARNING_THRESHOLD$1;
var mask = {};
var platform_utils = {};
function isWebKit(e = navigator) {
  const t = e.userAgent;
  return t.includes("Safari") && !t.includes("Chrome");
}
function isIOS() {
  return ["iPad Simulator", "iPhone Simulator", "iPod Simulator", "iPad", "iPhone", "iPod"].includes(navigator.platform) || navigator.userAgent.includes("Mac") && "ontouchend" in document;
}
Object.defineProperty(platform_utils, "__esModule", { value: true }), platform_utils.isIOS = platform_utils.isWebKit = void 0, platform_utils.isWebKit = isWebKit, platform_utils.isIOS = isIOS, Object.defineProperty(mask, "__esModule", { value: true }), mask.MPMask = void 0;
var image_shader_context_1$1 = image_shader_context;
var platform_utils_1$1 = platform_utils;
var INSTANCE_COUNT_WARNING_THRESHOLD = 250;
var MPMaskType;
!(function(e) {
  e[e.UINT8_ARRAY = 0] = "UINT8_ARRAY", e[e.FLOAT32_ARRAY = 1] = "FLOAT32_ARRAY", e[e.WEBGL_TEXTURE = 2] = "WEBGL_TEXTURE";
})(MPMaskType || (MPMaskType = {}));
var MPMask$1 = class _MPMask$1 {
  constructor(e, t, r, o, i, a2) {
    this.containers = e, this.ownsWebGLTexture = t, this.canvas = r, this.shaderContext = o, this.width = i, this.height = a2, this.ownsWebGLTexture && (--_MPMask$1.instancesBeforeWarning, 0 === _MPMask$1.instancesBeforeWarning && console.error("You seem to be creating MPMask instances without invoking .close(). This leaks resources."));
  }
  hasUint8Array() {
    return !!this.getContainer(MPMaskType.UINT8_ARRAY);
  }
  hasFloat32Array() {
    return !!this.getContainer(MPMaskType.FLOAT32_ARRAY);
  }
  hasWebGLTexture() {
    return !!this.getContainer(MPMaskType.WEBGL_TEXTURE);
  }
  getAsUint8Array() {
    return this.convertToUint8Array();
  }
  getAsFloat32Array() {
    return this.convertToFloat32Array();
  }
  getAsWebGLTexture() {
    return this.convertToWebGLTexture();
  }
  getTexImage2DFormat() {
    const e = this.getGL();
    if (!_MPMask$1.texImage2DFormat) if (e.getExtension("EXT_color_buffer_float") && e.getExtension("OES_texture_float_linear") && e.getExtension("EXT_float_blend")) _MPMask$1.texImage2DFormat = e.R32F;
    else {
      if (!e.getExtension("EXT_color_buffer_half_float")) throw new Error("GPU does not fully support 4-channel float32 or float16 formats");
      _MPMask$1.texImage2DFormat = e.R16F;
    }
    return _MPMask$1.texImage2DFormat;
  }
  getContainer(e) {
    switch (e) {
      case MPMaskType.UINT8_ARRAY:
        return this.containers.find(((e2) => e2 instanceof Uint8Array));
      case MPMaskType.FLOAT32_ARRAY:
        return this.containers.find(((e2) => e2 instanceof Float32Array));
      case MPMaskType.WEBGL_TEXTURE:
        return this.containers.find(((e2) => "undefined" != typeof WebGLTexture && e2 instanceof WebGLTexture));
      default:
        throw new Error(`Type is not supported: ${e}`);
    }
  }
  clone() {
    const e = [];
    for (const t of this.containers) {
      let r;
      if (t instanceof Uint8Array) r = new Uint8Array(t);
      else if (t instanceof Float32Array) r = new Float32Array(t);
      else {
        if (!(t instanceof WebGLTexture)) throw new Error(`Type is not supported: ${t}`);
        {
          const e2 = this.getGL(), t2 = this.getShaderContext();
          e2.activeTexture(e2.TEXTURE1), r = (0, image_shader_context_1$1.assertNotNull)(e2.createTexture(), "Failed to create texture"), e2.bindTexture(e2.TEXTURE_2D, r), this.configureTextureParams();
          const o = this.getTexImage2DFormat();
          e2.texImage2D(e2.TEXTURE_2D, 0, o, this.width, this.height, 0, e2.RED, e2.FLOAT, null), e2.bindTexture(e2.TEXTURE_2D, null), t2.bindFramebuffer(e2, r), t2.run(e2, false, (() => {
            this.bindTexture(), e2.clearColor(0, 0, 0, 0), e2.clear(e2.COLOR_BUFFER_BIT), e2.drawArrays(e2.TRIANGLE_FAN, 0, 4), this.unbindTexture();
          })), t2.unbindFramebuffer(), this.unbindTexture();
        }
      }
      e.push(r);
    }
    return new _MPMask$1(e, this.hasWebGLTexture(), this.canvas, this.shaderContext, this.width, this.height);
  }
  getGL() {
    if (!this.canvas) throw new Error("Conversion to different image formats require that a canvas is passed when initializing the image.");
    return this.gl || (this.gl = (0, image_shader_context_1$1.assertNotNull)(this.canvas.getContext("webgl2"), "You cannot use a canvas that is already bound to a different type of rendering context.")), this.gl;
  }
  getShaderContext() {
    return this.shaderContext || (this.shaderContext = new image_shader_context_1$1.MPImageShaderContext()), this.shaderContext;
  }
  convertToFloat32Array() {
    let e = this.getContainer(MPMaskType.FLOAT32_ARRAY);
    if (!e) {
      const t = this.getContainer(MPMaskType.UINT8_ARRAY);
      if (t) e = new Float32Array(t).map(((e2) => e2 / 255));
      else {
        e = new Float32Array(this.width * this.height);
        const t2 = this.getGL(), r = this.getShaderContext(), o = this.convertToWebGLTexture();
        if (r.bindFramebuffer(t2, o), (0, platform_utils_1$1.isIOS)()) {
          const r2 = new Float32Array(this.width * this.height * 4);
          t2.readPixels(0, 0, this.width, this.height, t2.RGBA, t2.FLOAT, r2);
          for (let t3 = 0, o2 = 0; t3 < e.length; ++t3, o2 += 4) e[t3] = r2[o2];
        } else t2.readPixels(0, 0, this.width, this.height, t2.RED, t2.FLOAT, e);
      }
      this.containers.push(e);
    }
    return e;
  }
  convertToUint8Array() {
    let e = this.getContainer(MPMaskType.UINT8_ARRAY);
    if (!e) {
      const t = this.convertToFloat32Array();
      e = new Uint8Array(t.map(((e2) => 255 * e2))), this.containers.push(e);
    }
    return e;
  }
  convertToWebGLTexture() {
    let e = this.getContainer(MPMaskType.WEBGL_TEXTURE);
    if (!e) {
      const t = this.getGL();
      e = this.bindTexture();
      const r = this.convertToFloat32Array(), o = this.getTexImage2DFormat();
      t.texImage2D(t.TEXTURE_2D, 0, o, this.width, this.height, 0, t.RED, t.FLOAT, r), this.unbindTexture();
    }
    return e;
  }
  configureTextureParams() {
    const e = this.getGL();
    e.texParameteri(e.TEXTURE_2D, e.TEXTURE_WRAP_S, e.CLAMP_TO_EDGE), e.texParameteri(e.TEXTURE_2D, e.TEXTURE_WRAP_T, e.CLAMP_TO_EDGE), e.texParameteri(e.TEXTURE_2D, e.TEXTURE_MIN_FILTER, e.NEAREST), e.texParameteri(e.TEXTURE_2D, e.TEXTURE_MAG_FILTER, e.NEAREST);
  }
  bindTexture() {
    const e = this.getGL();
    e.viewport(0, 0, this.width, this.height), e.activeTexture(e.TEXTURE0);
    let t = this.getContainer(MPMaskType.WEBGL_TEXTURE);
    return t ? e.bindTexture(e.TEXTURE_2D, t) : (t = (0, image_shader_context_1$1.assertNotNull)(e.createTexture(), "Failed to create texture"), this.containers.push(t), this.ownsWebGLTexture = true, e.bindTexture(e.TEXTURE_2D, t), this.configureTextureParams()), t;
  }
  unbindTexture() {
    this.gl.bindTexture(this.gl.TEXTURE_2D, null);
  }
  close() {
    if (this.ownsWebGLTexture) {
      this.getGL().deleteTexture(this.getContainer(MPMaskType.WEBGL_TEXTURE));
    }
    _MPMask$1.instancesBeforeWarning = -1;
  }
};
mask.MPMask = MPMask$1, MPMask$1.instancesBeforeWarning = INSTANCE_COUNT_WARNING_THRESHOLD;
var face_detector = {};
var calculator_pb = {};
var googleProtobuf = {};
(function(exports) {
  var $jscomp = $jscomp || {};
  $jscomp.scope = {}, $jscomp.findInternal = function(e, t, r) {
    e instanceof String && (e = String(e));
    for (var o = e.length, i = 0; i < o; i++) {
      var a2 = e[i];
      if (t.call(r, a2, i, e)) return { i, v: a2 };
    }
    return { i: -1, v: void 0 };
  }, $jscomp.ASSUME_ES5 = false, $jscomp.ASSUME_NO_NATIVE_MAP = false, $jscomp.ASSUME_NO_NATIVE_SET = false, $jscomp.SIMPLE_FROUND_POLYFILL = false, $jscomp.defineProperty = $jscomp.ASSUME_ES5 || "function" == typeof Object.defineProperties ? Object.defineProperty : function(e, t, r) {
    e != Array.prototype && e != Object.prototype && (e[t] = r.value);
  }, $jscomp.getGlobal = function(e) {
    return "undefined" != typeof window && window === e ? e : void 0 !== commonjsGlobal && null != commonjsGlobal ? commonjsGlobal : e;
  }, $jscomp.global = $jscomp.getGlobal(commonjsGlobal), $jscomp.polyfill = function(e, t, r, o) {
    if (t) {
      for (r = $jscomp.global, e = e.split("."), o = 0; o < e.length - 1; o++) {
        var i = e[o];
        i in r || (r[i] = {}), r = r[i];
      }
      (t = t(o = r[e = e[e.length - 1]])) != o && null != t && $jscomp.defineProperty(r, e, { configurable: true, writable: true, value: t });
    }
  }, $jscomp.polyfill("Array.prototype.findIndex", (function(e) {
    return e || function(e2, t) {
      return $jscomp.findInternal(this, e2, t).i;
    };
  }), "es6", "es3"), $jscomp.checkStringArgs = function(e, t, r) {
    if (null == e) throw new TypeError("The 'this' value for String.prototype." + r + " must not be null or undefined");
    if (t instanceof RegExp) throw new TypeError("First argument to String.prototype." + r + " must not be a regular expression");
    return e + "";
  }, $jscomp.polyfill("String.prototype.endsWith", (function(e) {
    return e || function(e2, t) {
      var r = $jscomp.checkStringArgs(this, e2, "endsWith");
      e2 += "", void 0 === t && (t = r.length), t = Math.max(0, Math.min(0 | t, r.length));
      for (var o = e2.length; 0 < o && 0 < t; ) if (r[--t] != e2[--o]) return false;
      return 0 >= o;
    };
  }), "es6", "es3"), $jscomp.polyfill("Array.prototype.find", (function(e) {
    return e || function(e2, t) {
      return $jscomp.findInternal(this, e2, t).v;
    };
  }), "es6", "es3"), $jscomp.polyfill("String.prototype.startsWith", (function(e) {
    return e || function(e2, t) {
      var r = $jscomp.checkStringArgs(this, e2, "startsWith");
      e2 += "";
      var o = r.length, i = e2.length;
      t = Math.max(0, Math.min(0 | t, r.length));
      for (var a2 = 0; a2 < i && t < o; ) if (r[t++] != e2[a2++]) return false;
      return a2 >= i;
    };
  }), "es6", "es3"), $jscomp.polyfill("String.prototype.repeat", (function(e) {
    return e || function(e2) {
      var t = $jscomp.checkStringArgs(this, null, "repeat");
      if (0 > e2 || 1342177279 < e2) throw new RangeError("Invalid count value");
      e2 |= 0;
      for (var r = ""; e2; ) 1 & e2 && (r += t), (e2 >>>= 1) && (t += t);
      return r;
    };
  }), "es6", "es3");
  var COMPILED = true, goog = goog || {};
  goog.global = commonjsGlobal || self, goog.exportPath_ = function(e, t, r) {
    e = e.split("."), r = r || goog.global, e[0] in r || void 0 === r.execScript || r.execScript("var " + e[0]);
    for (var o; e.length && (o = e.shift()); ) e.length || void 0 === t ? r = r[o] && r[o] !== Object.prototype[o] ? r[o] : r[o] = {} : r[o] = t;
  }, goog.define = function(e, t) {
    return t;
  }, goog.FEATURESET_YEAR = 2012, goog.DEBUG = true, goog.LOCALE = "en", goog.TRUSTED_SITE = true, goog.STRICT_MODE_COMPATIBLE = false, goog.DISALLOW_TEST_ONLY_CODE = !goog.DEBUG, goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING = false, goog.provide = function(e) {
    if (goog.isInModuleLoader_()) throw Error("goog.provide cannot be used within a module.");
    goog.constructNamespace_(e);
  }, goog.constructNamespace_ = function(e, t) {
    goog.exportPath_(e, t);
  }, goog.getScriptNonce = function(e) {
    return e && e != goog.global ? goog.getScriptNonce_(e.document) : (null === goog.cspNonce_ && (goog.cspNonce_ = goog.getScriptNonce_(goog.global.document)), goog.cspNonce_);
  }, goog.NONCE_PATTERN_ = /^[\w+/_-]+[=]{0,2}$/, goog.cspNonce_ = null, goog.getScriptNonce_ = function(e) {
    return (e = e.querySelector && e.querySelector("script[nonce]")) && (e = e.nonce || e.getAttribute("nonce")) && goog.NONCE_PATTERN_.test(e) ? e : "";
  }, goog.VALID_MODULE_RE_ = /^[a-zA-Z_$][a-zA-Z0-9._$]*$/, goog.module = function(e) {
    if ("string" != typeof e || !e || -1 == e.search(goog.VALID_MODULE_RE_)) throw Error("Invalid module identifier");
    if (!goog.isInGoogModuleLoader_()) throw Error("Module " + e + " has been loaded incorrectly. Note, modules cannot be loaded as normal scripts. They require some kind of pre-processing step. You're likely trying to load a module via a script tag or as a part of a concatenated bundle without rewriting the module. For more info see: https://github.com/google/closure-library/wiki/goog.module:-an-ES6-module-like-alternative-to-goog.provide.");
    if (goog.moduleLoaderState_.moduleName) throw Error("goog.module may only be called once per module.");
    goog.moduleLoaderState_.moduleName = e;
  }, goog.module.get = function(e) {
    return goog.module.getInternal_(e);
  }, goog.module.getInternal_ = function(e) {
    return null;
  }, goog.ModuleType = { ES6: "es6", GOOG: "goog" }, goog.moduleLoaderState_ = null, goog.isInModuleLoader_ = function() {
    return goog.isInGoogModuleLoader_() || goog.isInEs6ModuleLoader_();
  }, goog.isInGoogModuleLoader_ = function() {
    return !!goog.moduleLoaderState_ && goog.moduleLoaderState_.type == goog.ModuleType.GOOG;
  }, goog.isInEs6ModuleLoader_ = function() {
    if (goog.moduleLoaderState_ && goog.moduleLoaderState_.type == goog.ModuleType.ES6) return true;
    var e = goog.global.$jscomp;
    return !!e && ("function" == typeof e.getCurrentModulePath && !!e.getCurrentModulePath());
  }, goog.module.declareLegacyNamespace = function() {
    goog.moduleLoaderState_.declareLegacyNamespace = true;
  }, goog.declareModuleId = function(e) {
    if (goog.moduleLoaderState_) goog.moduleLoaderState_.moduleName = e;
    else {
      var t = goog.global.$jscomp;
      if (!t || "function" != typeof t.getCurrentModulePath) throw Error('Module with namespace "' + e + '" has been loaded incorrectly.');
      t = t.require(t.getCurrentModulePath()), goog.loadedModules_[e] = { exports: t, type: goog.ModuleType.ES6, moduleId: e };
    }
  }, goog.setTestOnly = function(e) {
    if (goog.DISALLOW_TEST_ONLY_CODE) throw e = e || "", Error("Importing test-only code into non-debug environment" + (e ? ": " + e : "."));
  }, goog.forwardDeclare = function(e) {
  }, goog.getObjectByName = function(e, t) {
    e = e.split("."), t = t || goog.global;
    for (var r = 0; r < e.length; r++) if (null == (t = t[e[r]])) return null;
    return t;
  }, goog.globalize = function(e, t) {
    for (var r in t = t || goog.global, e) t[r] = e[r];
  }, goog.addDependency = function(e, t, r, o) {
  }, goog.ENABLE_DEBUG_LOADER = true, goog.logToConsole_ = function(e) {
    goog.global.console && goog.global.console.error(e);
  }, goog.require = function(e) {
  }, goog.requireType = function(e) {
    return {};
  }, goog.basePath = "", goog.nullFunction = function() {
  }, goog.abstractMethod = function() {
    throw Error("unimplemented abstract method");
  }, goog.addSingletonGetter = function(e) {
    e.instance_ = void 0, e.getInstance = function() {
      return e.instance_ ? e.instance_ : (goog.DEBUG && (goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = e), e.instance_ = new e());
    };
  }, goog.instantiatedSingletons_ = [], goog.LOAD_MODULE_USING_EVAL = true, goog.SEAL_MODULE_EXPORTS = goog.DEBUG, goog.loadedModules_ = {}, goog.DEPENDENCIES_ENABLED = !COMPILED, goog.TRANSPILE = "detect", goog.ASSUME_ES_MODULES_TRANSPILED = false, goog.TRANSPILE_TO_LANGUAGE = "", goog.TRANSPILER = "transpile.js", goog.hasBadLetScoping = null, goog.useSafari10Workaround = function() {
    if (null == goog.hasBadLetScoping) {
      try {
        var a = !eval('"use strict";let x = 1; function f() { return typeof x; };f() == "number";');
      } catch (e) {
        a = false;
      }
      goog.hasBadLetScoping = a;
    }
    return goog.hasBadLetScoping;
  }, goog.workaroundSafari10EvalBug = function(e) {
    return "(function(){" + e + "\n;})();\n";
  }, goog.loadModule = function(e) {
    var t = goog.moduleLoaderState_;
    try {
      if (goog.moduleLoaderState_ = { moduleName: "", declareLegacyNamespace: false, type: goog.ModuleType.GOOG }, goog.isFunction(e)) var r = e.call(void 0, {});
      else {
        if ("string" != typeof e) throw Error("Invalid module definition");
        goog.useSafari10Workaround() && (e = goog.workaroundSafari10EvalBug(e)), r = goog.loadModuleFromSource_.call(void 0, e);
      }
      var o = goog.moduleLoaderState_.moduleName;
      if ("string" != typeof o || !o) throw Error('Invalid module name "' + o + '"');
      goog.moduleLoaderState_.declareLegacyNamespace ? goog.constructNamespace_(o, r) : goog.SEAL_MODULE_EXPORTS && Object.seal && "object" == typeof r && null != r && Object.seal(r), goog.loadedModules_[o] = { exports: r, type: goog.ModuleType.GOOG, moduleId: goog.moduleLoaderState_.moduleName };
    } finally {
      goog.moduleLoaderState_ = t;
    }
  }, goog.loadModuleFromSource_ = function(a) {
    return eval(a), {};
  }, goog.normalizePath_ = function(e) {
    e = e.split("/");
    for (var t = 0; t < e.length; ) "." == e[t] ? e.splice(t, 1) : t && ".." == e[t] && e[t - 1] && ".." != e[t - 1] ? e.splice(--t, 2) : t++;
    return e.join("/");
  }, goog.loadFileSync_ = function(e) {
    if (goog.global.CLOSURE_LOAD_FILE_SYNC) return goog.global.CLOSURE_LOAD_FILE_SYNC(e);
    try {
      var t = new goog.global.XMLHttpRequest();
      return t.open("get", e, false), t.send(), 0 == t.status || 200 == t.status ? t.responseText : null;
    } catch (e2) {
      return null;
    }
  }, goog.transpile_ = function(e, t, r) {
    var o = goog.global.$jscomp;
    o || (goog.global.$jscomp = o = {});
    var i = o.transpile;
    if (!i) {
      var a2 = goog.basePath + goog.TRANSPILER, n = goog.loadFileSync_(a2);
      if (n) {
        if ((function() {
          (0, eval)(n + "\n//# sourceURL=" + a2);
        }).call(goog.global), goog.global.$gwtExport && goog.global.$gwtExport.$jscomp && !goog.global.$gwtExport.$jscomp.transpile) throw Error('The transpiler did not properly export the "transpile" method. $gwtExport: ' + JSON.stringify(goog.global.$gwtExport));
        goog.global.$jscomp.transpile = goog.global.$gwtExport.$jscomp.transpile, i = (o = goog.global.$jscomp).transpile;
      }
    }
    return i || (i = o.transpile = function(e2, t2) {
      return goog.logToConsole_(t2 + " requires transpilation but no transpiler was found."), e2;
    }), i(e, t, r);
  }, goog.typeOf = function(e) {
    var t = typeof e;
    if ("object" == t) {
      if (!e) return "null";
      if (e instanceof Array) return "array";
      if (e instanceof Object) return t;
      var r = Object.prototype.toString.call(e);
      if ("[object Window]" == r) return "object";
      if ("[object Array]" == r || "number" == typeof e.length && void 0 !== e.splice && void 0 !== e.propertyIsEnumerable && !e.propertyIsEnumerable("splice")) return "array";
      if ("[object Function]" == r || void 0 !== e.call && void 0 !== e.propertyIsEnumerable && !e.propertyIsEnumerable("call")) return "function";
    } else if ("function" == t && void 0 === e.call) return "object";
    return t;
  }, goog.isArray = function(e) {
    return "array" == goog.typeOf(e);
  }, goog.isArrayLike = function(e) {
    var t = goog.typeOf(e);
    return "array" == t || "object" == t && "number" == typeof e.length;
  }, goog.isDateLike = function(e) {
    return goog.isObject(e) && "function" == typeof e.getFullYear;
  }, goog.isFunction = function(e) {
    return "function" == goog.typeOf(e);
  }, goog.isObject = function(e) {
    var t = typeof e;
    return "object" == t && null != e || "function" == t;
  }, goog.getUid = function(e) {
    return Object.prototype.hasOwnProperty.call(e, goog.UID_PROPERTY_) && e[goog.UID_PROPERTY_] || (e[goog.UID_PROPERTY_] = ++goog.uidCounter_);
  }, goog.hasUid = function(e) {
    return !!e[goog.UID_PROPERTY_];
  }, goog.removeUid = function(e) {
    null !== e && "removeAttribute" in e && e.removeAttribute(goog.UID_PROPERTY_);
    try {
      delete e[goog.UID_PROPERTY_];
    } catch (e2) {
    }
  }, goog.UID_PROPERTY_ = "closure_uid_" + (1e9 * Math.random() >>> 0), goog.uidCounter_ = 0, goog.getHashCode = goog.getUid, goog.removeHashCode = goog.removeUid, goog.cloneObject = function(e) {
    var t = goog.typeOf(e);
    if ("object" == t || "array" == t) {
      if ("function" == typeof e.clone) return e.clone();
      for (var r in t = "array" == t ? [] : {}, e) t[r] = goog.cloneObject(e[r]);
      return t;
    }
    return e;
  }, goog.bindNative_ = function(e, t, r) {
    return e.call.apply(e.bind, arguments);
  }, goog.bindJs_ = function(e, t, r) {
    if (!e) throw Error();
    if (2 < arguments.length) {
      var o = Array.prototype.slice.call(arguments, 2);
      return function() {
        var r2 = Array.prototype.slice.call(arguments);
        return Array.prototype.unshift.apply(r2, o), e.apply(t, r2);
      };
    }
    return function() {
      return e.apply(t, arguments);
    };
  }, goog.bind = function(e, t, r) {
    return Function.prototype.bind && -1 != Function.prototype.bind.toString().indexOf("native code") ? goog.bind = goog.bindNative_ : goog.bind = goog.bindJs_, goog.bind.apply(null, arguments);
  }, goog.partial = function(e, t) {
    var r = Array.prototype.slice.call(arguments, 1);
    return function() {
      var t2 = r.slice();
      return t2.push.apply(t2, arguments), e.apply(this, t2);
    };
  }, goog.mixin = function(e, t) {
    for (var r in t) e[r] = t[r];
  }, goog.now = goog.TRUSTED_SITE && Date.now || function() {
    return +/* @__PURE__ */ new Date();
  }, goog.globalEval = function(e) {
    if (goog.global.execScript) goog.global.execScript(e, "JavaScript");
    else {
      if (!goog.global.eval) throw Error("goog.globalEval not available");
      if (null == goog.evalWorksForGlobals_) {
        try {
          goog.global.eval("var _evalTest_ = 1;");
        } catch (e2) {
        }
        if (void 0 !== goog.global._evalTest_) {
          try {
            delete goog.global._evalTest_;
          } catch (e2) {
          }
          goog.evalWorksForGlobals_ = true;
        } else goog.evalWorksForGlobals_ = false;
      }
      if (goog.evalWorksForGlobals_) goog.global.eval(e);
      else {
        var t = goog.global.document, r = t.createElement("script");
        r.type = "text/javascript", r.defer = false, r.appendChild(t.createTextNode(e)), t.head.appendChild(r), t.head.removeChild(r);
      }
    }
  }, goog.evalWorksForGlobals_ = null, goog.getCssName = function(e, t) {
    if ("." == String(e).charAt(0)) throw Error('className passed in goog.getCssName must not start with ".". You passed: ' + e);
    var r = function(e2) {
      return goog.cssNameMapping_[e2] || e2;
    }, o = function(e2) {
      e2 = e2.split("-");
      for (var t2 = [], o2 = 0; o2 < e2.length; o2++) t2.push(r(e2[o2]));
      return t2.join("-");
    };
    return o = goog.cssNameMapping_ ? "BY_WHOLE" == goog.cssNameMappingStyle_ ? r : o : function(e2) {
      return e2;
    }, e = t ? e + "-" + o(t) : o(e), goog.global.CLOSURE_CSS_NAME_MAP_FN ? goog.global.CLOSURE_CSS_NAME_MAP_FN(e) : e;
  }, goog.setCssNameMapping = function(e, t) {
    goog.cssNameMapping_ = e, goog.cssNameMappingStyle_ = t;
  }, goog.getMsg = function(e, t, r) {
    return r && r.html && (e = e.replace(/</g, "&lt;")), t && (e = e.replace(/\{\$([^}]+)}/g, (function(e2, r2) {
      return null != t && r2 in t ? t[r2] : e2;
    }))), e;
  }, goog.getMsgWithFallback = function(e, t) {
    return e;
  }, goog.exportSymbol = function(e, t, r) {
    goog.exportPath_(e, t, r);
  }, goog.exportProperty = function(e, t, r) {
    e[t] = r;
  }, goog.inherits = function(e, t) {
    function r() {
    }
    r.prototype = t.prototype, e.superClass_ = t.prototype, e.prototype = new r(), e.prototype.constructor = e, e.base = function(e2, r2, o) {
      for (var i = Array(arguments.length - 2), a2 = 2; a2 < arguments.length; a2++) i[a2 - 2] = arguments[a2];
      return t.prototype[r2].apply(e2, i);
    };
  }, goog.scope = function(e) {
    if (goog.isInModuleLoader_()) throw Error("goog.scope is not supported within a module.");
    e.call(goog.global);
  }, goog.defineClass = function(e, t) {
    var r = t.constructor, o = t.statics;
    return r && r != Object.prototype.constructor || (r = function() {
      throw Error("cannot instantiate an interface (no constructor defined).");
    }), r = goog.defineClass.createSealingConstructor_(r, e), e && goog.inherits(r, e), delete t.constructor, delete t.statics, goog.defineClass.applyProperties_(r.prototype, t), null != o && (o instanceof Function ? o(r) : goog.defineClass.applyProperties_(r, o)), r;
  }, goog.defineClass.SEAL_CLASS_INSTANCES = goog.DEBUG, goog.defineClass.createSealingConstructor_ = function(e, t) {
    if (!goog.defineClass.SEAL_CLASS_INSTANCES) return e;
    var r = !goog.defineClass.isUnsealable_(t), o = function() {
      var t2 = e.apply(this, arguments) || this;
      return t2[goog.UID_PROPERTY_] = t2[goog.UID_PROPERTY_], this.constructor === o && r && Object.seal instanceof Function && Object.seal(t2), t2;
    };
    return o;
  }, goog.defineClass.isUnsealable_ = function(e) {
    return e && e.prototype && e.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_];
  }, goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = "constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf".split(" "), goog.defineClass.applyProperties_ = function(e, t) {
    for (var r in t) Object.prototype.hasOwnProperty.call(t, r) && (e[r] = t[r]);
    for (var o = 0; o < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length; o++) r = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[o], Object.prototype.hasOwnProperty.call(t, r) && (e[r] = t[r]);
  }, goog.tagUnsealableClass = function(e) {
  }, goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = "goog_defineClass_legacy_unsealable", goog.TRUSTED_TYPES_POLICY_NAME = "", goog.identity_ = function(e) {
    return e;
  }, goog.createTrustedTypesPolicy = function(e) {
    var t = null, r = goog.global.trustedTypes || goog.global.TrustedTypes;
    if (!r || !r.createPolicy) return t;
    try {
      t = r.createPolicy(e, { createHTML: goog.identity_, createScript: goog.identity_, createScriptURL: goog.identity_, createURL: goog.identity_ });
    } catch (e2) {
      goog.logToConsole_(e2.message);
    }
    return t;
  }, goog.TRUSTED_TYPES_POLICY_ = goog.TRUSTED_TYPES_POLICY_NAME ? goog.createTrustedTypesPolicy(goog.TRUSTED_TYPES_POLICY_NAME + "#base") : null, goog.object = {}, goog.object.is = function(e, t) {
    return e === t ? 0 !== e || 1 / e == 1 / t : e != e && t != t;
  }, goog.object.forEach = function(e, t, r) {
    for (var o in e) t.call(r, e[o], o, e);
  }, goog.object.filter = function(e, t, r) {
    var o, i = {};
    for (o in e) t.call(r, e[o], o, e) && (i[o] = e[o]);
    return i;
  }, goog.object.map = function(e, t, r) {
    var o, i = {};
    for (o in e) i[o] = t.call(r, e[o], o, e);
    return i;
  }, goog.object.some = function(e, t, r) {
    for (var o in e) if (t.call(r, e[o], o, e)) return true;
    return false;
  }, goog.object.every = function(e, t, r) {
    for (var o in e) if (!t.call(r, e[o], o, e)) return false;
    return true;
  }, goog.object.getCount = function(e) {
    var t, r = 0;
    for (t in e) r++;
    return r;
  }, goog.object.getAnyKey = function(e) {
    for (var t in e) return t;
  }, goog.object.getAnyValue = function(e) {
    for (var t in e) return e[t];
  }, goog.object.contains = function(e, t) {
    return goog.object.containsValue(e, t);
  }, goog.object.getValues = function(e) {
    var t, r = [], o = 0;
    for (t in e) r[o++] = e[t];
    return r;
  }, goog.object.getKeys = function(e) {
    var t, r = [], o = 0;
    for (t in e) r[o++] = t;
    return r;
  }, goog.object.getValueByKeys = function(e, t) {
    var r = goog.isArrayLike(t), o = r ? t : arguments;
    for (r = r ? 0 : 1; r < o.length; r++) {
      if (null == e) return;
      e = e[o[r]];
    }
    return e;
  }, goog.object.containsKey = function(e, t) {
    return null !== e && t in e;
  }, goog.object.containsValue = function(e, t) {
    for (var r in e) if (e[r] == t) return true;
    return false;
  }, goog.object.findKey = function(e, t, r) {
    for (var o in e) if (t.call(r, e[o], o, e)) return o;
  }, goog.object.findValue = function(e, t, r) {
    return (t = goog.object.findKey(e, t, r)) && e[t];
  }, goog.object.isEmpty = function(e) {
    for (var t in e) return false;
    return true;
  }, goog.object.clear = function(e) {
    for (var t in e) delete e[t];
  }, goog.object.remove = function(e, t) {
    var r;
    return (r = t in e) && delete e[t], r;
  }, goog.object.add = function(e, t, r) {
    if (null !== e && t in e) throw Error('The object already contains the key "' + t + '"');
    goog.object.set(e, t, r);
  }, goog.object.get = function(e, t, r) {
    return null !== e && t in e ? e[t] : r;
  }, goog.object.set = function(e, t, r) {
    e[t] = r;
  }, goog.object.setIfUndefined = function(e, t, r) {
    return t in e ? e[t] : e[t] = r;
  }, goog.object.setWithReturnValueIfNotSet = function(e, t, r) {
    return t in e ? e[t] : (r = r(), e[t] = r);
  }, goog.object.equals = function(e, t) {
    for (var r in e) if (!(r in t) || e[r] !== t[r]) return false;
    for (var o in t) if (!(o in e)) return false;
    return true;
  }, goog.object.clone = function(e) {
    var t, r = {};
    for (t in e) r[t] = e[t];
    return r;
  }, goog.object.unsafeClone = function(e) {
    var t = goog.typeOf(e);
    if ("object" == t || "array" == t) {
      if (goog.isFunction(e.clone)) return e.clone();
      for (var r in t = "array" == t ? [] : {}, e) t[r] = goog.object.unsafeClone(e[r]);
      return t;
    }
    return e;
  }, goog.object.transpose = function(e) {
    var t, r = {};
    for (t in e) r[e[t]] = t;
    return r;
  }, goog.object.PROTOTYPE_FIELDS_ = "constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf".split(" "), goog.object.extend = function(e, t) {
    for (var r, o, i = 1; i < arguments.length; i++) {
      for (r in o = arguments[i]) e[r] = o[r];
      for (var a2 = 0; a2 < goog.object.PROTOTYPE_FIELDS_.length; a2++) r = goog.object.PROTOTYPE_FIELDS_[a2], Object.prototype.hasOwnProperty.call(o, r) && (e[r] = o[r]);
    }
  }, goog.object.create = function(e) {
    var t = arguments.length;
    if (1 == t && Array.isArray(arguments[0])) return goog.object.create.apply(null, arguments[0]);
    if (t % 2) throw Error("Uneven number of arguments");
    for (var r = {}, o = 0; o < t; o += 2) r[arguments[o]] = arguments[o + 1];
    return r;
  }, goog.object.createSet = function(e) {
    var t = arguments.length;
    if (1 == t && Array.isArray(arguments[0])) return goog.object.createSet.apply(null, arguments[0]);
    for (var r = {}, o = 0; o < t; o++) r[arguments[o]] = true;
    return r;
  }, goog.object.createImmutableView = function(e) {
    var t = e;
    return Object.isFrozen && !Object.isFrozen(e) && (t = Object.create(e), Object.freeze(t)), t;
  }, goog.object.isImmutableView = function(e) {
    return !!Object.isFrozen && Object.isFrozen(e);
  }, goog.object.getAllPropertyNames = function(e, t, r) {
    if (!e) return [];
    if (!Object.getOwnPropertyNames || !Object.getPrototypeOf) return goog.object.getKeys(e);
    for (var o = {}; e && (e !== Object.prototype || t) && (e !== Function.prototype || r); ) {
      for (var i = Object.getOwnPropertyNames(e), a2 = 0; a2 < i.length; a2++) o[i[a2]] = true;
      e = Object.getPrototypeOf(e);
    }
    return goog.object.getKeys(o);
  }, goog.object.getSuperClass = function(e) {
    return (e = Object.getPrototypeOf(e.prototype)) && e.constructor;
  };
  var jspb = { asserts: {} };
  jspb.asserts.doAssertFailure = function(e, t, r, o) {
    var i = "Assertion failed";
    if (r) {
      i += ": " + r;
      var a2 = o;
    } else e && (i += ": " + e, a2 = t);
    throw Error("" + i, a2 || []);
  }, jspb.asserts.assert = function(e, t, r) {
    for (var o = [], i = 2; i < arguments.length; ++i) o[i - 2] = arguments[i];
    return e || jspb.asserts.doAssertFailure("", null, t, o), e;
  }, jspb.asserts.assertString = function(e, t, r) {
    for (var o = [], i = 2; i < arguments.length; ++i) o[i - 2] = arguments[i];
    return "string" != typeof e && jspb.asserts.doAssertFailure("Expected string but got %s: %s.", [goog.typeOf(e), e], t, o), e;
  }, jspb.asserts.assertArray = function(e, t, r) {
    for (var o = [], i = 2; i < arguments.length; ++i) o[i - 2] = arguments[i];
    return Array.isArray(e) || jspb.asserts.doAssertFailure("Expected array but got %s: %s.", [goog.typeOf(e), e], t, o), e;
  }, jspb.asserts.fail = function(e, t) {
    for (var r = [], o = 1; o < arguments.length; ++o) r[o - 1] = arguments[o];
    throw Error("Failure" + (e ? ": " + e : ""), r);
  }, jspb.asserts.assertInstanceof = function(e, t, r, o) {
    for (var i = [], a2 = 3; a2 < arguments.length; ++a2) i[a2 - 3] = arguments[a2];
    return e instanceof t || jspb.asserts.doAssertFailure("Expected instanceof %s but got %s.", [jspb.asserts.getType(t), jspb.asserts.getType(e)], r, i), e;
  }, jspb.asserts.getType = function(e) {
    return e instanceof Function ? e.displayName || e.name || "unknown type name" : e instanceof Object ? e.constructor.displayName || e.constructor.name || Object.prototype.toString.call(e) : null === e ? "null" : typeof e;
  }, jspb.BinaryConstants = {}, jspb.ConstBinaryMessage = function() {
  }, jspb.BinaryMessage = function() {
  }, jspb.BinaryConstants.FieldType = { INVALID: -1, DOUBLE: 1, FLOAT: 2, INT64: 3, UINT64: 4, INT32: 5, FIXED64: 6, FIXED32: 7, BOOL: 8, STRING: 9, GROUP: 10, MESSAGE: 11, BYTES: 12, UINT32: 13, ENUM: 14, SFIXED32: 15, SFIXED64: 16, SINT32: 17, SINT64: 18, FHASH64: 30, VHASH64: 31 }, jspb.BinaryConstants.WireType = { INVALID: -1, VARINT: 0, FIXED64: 1, DELIMITED: 2, START_GROUP: 3, END_GROUP: 4, FIXED32: 5 }, jspb.BinaryConstants.FieldTypeToWireType = function(e) {
    var t = jspb.BinaryConstants.FieldType, r = jspb.BinaryConstants.WireType;
    switch (e) {
      case t.INT32:
      case t.INT64:
      case t.UINT32:
      case t.UINT64:
      case t.SINT32:
      case t.SINT64:
      case t.BOOL:
      case t.ENUM:
      case t.VHASH64:
        return r.VARINT;
      case t.DOUBLE:
      case t.FIXED64:
      case t.SFIXED64:
      case t.FHASH64:
        return r.FIXED64;
      case t.STRING:
      case t.MESSAGE:
      case t.BYTES:
        return r.DELIMITED;
      case t.FLOAT:
      case t.FIXED32:
      case t.SFIXED32:
        return r.FIXED32;
      default:
        return r.INVALID;
    }
  }, jspb.BinaryConstants.INVALID_FIELD_NUMBER = -1, jspb.BinaryConstants.FLOAT32_EPS = 1401298464324817e-60, jspb.BinaryConstants.FLOAT32_MIN = 11754943508222875e-54, jspb.BinaryConstants.FLOAT32_MAX = 34028234663852886e22, jspb.BinaryConstants.FLOAT64_EPS = 5e-324, jspb.BinaryConstants.FLOAT64_MIN = 22250738585072014e-324, jspb.BinaryConstants.FLOAT64_MAX = 17976931348623157e292, jspb.BinaryConstants.TWO_TO_20 = 1048576, jspb.BinaryConstants.TWO_TO_23 = 8388608, jspb.BinaryConstants.TWO_TO_31 = 2147483648, jspb.BinaryConstants.TWO_TO_32 = 4294967296, jspb.BinaryConstants.TWO_TO_52 = 4503599627370496, jspb.BinaryConstants.TWO_TO_63 = 9223372036854776e3, jspb.BinaryConstants.TWO_TO_64 = 18446744073709552e3, jspb.BinaryConstants.ZERO_HASH = "\0\0\0\0\0\0\0\0", goog.debug = {}, goog.debug.Error = function(e) {
    if (Error.captureStackTrace) Error.captureStackTrace(this, goog.debug.Error);
    else {
      var t = Error().stack;
      t && (this.stack = t);
    }
    e && (this.message = String(e)), this.reportErrorToServer = true;
  }, goog.inherits(goog.debug.Error, Error), goog.debug.Error.prototype.name = "CustomError", goog.dom = {}, goog.dom.NodeType = { ELEMENT: 1, ATTRIBUTE: 2, TEXT: 3, CDATA_SECTION: 4, ENTITY_REFERENCE: 5, ENTITY: 6, PROCESSING_INSTRUCTION: 7, COMMENT: 8, DOCUMENT: 9, DOCUMENT_TYPE: 10, DOCUMENT_FRAGMENT: 11, NOTATION: 12 }, goog.asserts = {}, goog.asserts.ENABLE_ASSERTS = goog.DEBUG, goog.asserts.AssertionError = function(e, t) {
    goog.debug.Error.call(this, goog.asserts.subs_(e, t)), this.messagePattern = e;
  }, goog.inherits(goog.asserts.AssertionError, goog.debug.Error), goog.asserts.AssertionError.prototype.name = "AssertionError", goog.asserts.DEFAULT_ERROR_HANDLER = function(e) {
    throw e;
  }, goog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER, goog.asserts.subs_ = function(e, t) {
    for (var r = "", o = (e = e.split("%s")).length - 1, i = 0; i < o; i++) r += e[i] + (i < t.length ? t[i] : "%s");
    return r + e[o];
  }, goog.asserts.doAssertFailure_ = function(e, t, r, o) {
    var i = "Assertion failed";
    if (r) {
      i += ": " + r;
      var a2 = o;
    } else e && (i += ": " + e, a2 = t);
    e = new goog.asserts.AssertionError("" + i, a2 || []), goog.asserts.errorHandler_(e);
  }, goog.asserts.setErrorHandler = function(e) {
    goog.asserts.ENABLE_ASSERTS && (goog.asserts.errorHandler_ = e);
  }, goog.asserts.assert = function(e, t, r) {
    return goog.asserts.ENABLE_ASSERTS && !e && goog.asserts.doAssertFailure_("", null, t, Array.prototype.slice.call(arguments, 2)), e;
  }, goog.asserts.assertExists = function(e, t, r) {
    return goog.asserts.ENABLE_ASSERTS && null == e && goog.asserts.doAssertFailure_("Expected to exist: %s.", [e], t, Array.prototype.slice.call(arguments, 2)), e;
  }, goog.asserts.fail = function(e, t) {
    goog.asserts.ENABLE_ASSERTS && goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure" + (e ? ": " + e : ""), Array.prototype.slice.call(arguments, 1)));
  }, goog.asserts.assertNumber = function(e, t, r) {
    return goog.asserts.ENABLE_ASSERTS && "number" != typeof e && goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(e), e], t, Array.prototype.slice.call(arguments, 2)), e;
  }, goog.asserts.assertString = function(e, t, r) {
    return goog.asserts.ENABLE_ASSERTS && "string" != typeof e && goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(e), e], t, Array.prototype.slice.call(arguments, 2)), e;
  }, goog.asserts.assertFunction = function(e, t, r) {
    return goog.asserts.ENABLE_ASSERTS && !goog.isFunction(e) && goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(e), e], t, Array.prototype.slice.call(arguments, 2)), e;
  }, goog.asserts.assertObject = function(e, t, r) {
    return goog.asserts.ENABLE_ASSERTS && !goog.isObject(e) && goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(e), e], t, Array.prototype.slice.call(arguments, 2)), e;
  }, goog.asserts.assertArray = function(e, t, r) {
    return goog.asserts.ENABLE_ASSERTS && !Array.isArray(e) && goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(e), e], t, Array.prototype.slice.call(arguments, 2)), e;
  }, goog.asserts.assertBoolean = function(e, t, r) {
    return goog.asserts.ENABLE_ASSERTS && "boolean" != typeof e && goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(e), e], t, Array.prototype.slice.call(arguments, 2)), e;
  }, goog.asserts.assertElement = function(e, t, r) {
    return !goog.asserts.ENABLE_ASSERTS || goog.isObject(e) && e.nodeType == goog.dom.NodeType.ELEMENT || goog.asserts.doAssertFailure_("Expected Element but got %s: %s.", [goog.typeOf(e), e], t, Array.prototype.slice.call(arguments, 2)), e;
  }, goog.asserts.assertInstanceof = function(e, t, r, o) {
    return !goog.asserts.ENABLE_ASSERTS || e instanceof t || goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.", [goog.asserts.getType_(t), goog.asserts.getType_(e)], r, Array.prototype.slice.call(arguments, 3)), e;
  }, goog.asserts.assertFinite = function(e, t, r) {
    return !goog.asserts.ENABLE_ASSERTS || "number" == typeof e && isFinite(e) || goog.asserts.doAssertFailure_("Expected %s to be a finite number but it is not.", [e], t, Array.prototype.slice.call(arguments, 2)), e;
  }, goog.asserts.assertObjectPrototypeIsIntact = function() {
    for (var e in Object.prototype) goog.asserts.fail(e + " should not be enumerable in Object.prototype.");
  }, goog.asserts.getType_ = function(e) {
    return e instanceof Function ? e.displayName || e.name || "unknown type name" : e instanceof Object ? e.constructor.displayName || e.constructor.name || Object.prototype.toString.call(e) : null === e ? "null" : typeof e;
  }, goog.array = {}, goog.NATIVE_ARRAY_PROTOTYPES = goog.TRUSTED_SITE, goog.array.ASSUME_NATIVE_FUNCTIONS = 2012 < goog.FEATURESET_YEAR, goog.array.peek = function(e) {
    return e[e.length - 1];
  }, goog.array.last = goog.array.peek, goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.indexOf) ? function(e, t, r) {
    return goog.asserts.assert(null != e.length), Array.prototype.indexOf.call(e, t, r);
  } : function(e, t, r) {
    if (r = null == r ? 0 : 0 > r ? Math.max(0, e.length + r) : r, "string" == typeof e) return "string" != typeof t || 1 != t.length ? -1 : e.indexOf(t, r);
    for (; r < e.length; r++) if (r in e && e[r] === t) return r;
    return -1;
  }, goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.lastIndexOf) ? function(e, t, r) {
    return goog.asserts.assert(null != e.length), Array.prototype.lastIndexOf.call(e, t, null == r ? e.length - 1 : r);
  } : function(e, t, r) {
    if (0 > (r = null == r ? e.length - 1 : r) && (r = Math.max(0, e.length + r)), "string" == typeof e) return "string" != typeof t || 1 != t.length ? -1 : e.lastIndexOf(t, r);
    for (; 0 <= r; r--) if (r in e && e[r] === t) return r;
    return -1;
  }, goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.forEach) ? function(e, t, r) {
    goog.asserts.assert(null != e.length), Array.prototype.forEach.call(e, t, r);
  } : function(e, t, r) {
    for (var o = e.length, i = "string" == typeof e ? e.split("") : e, a2 = 0; a2 < o; a2++) a2 in i && t.call(r, i[a2], a2, e);
  }, goog.array.forEachRight = function(e, t, r) {
    var o = e.length, i = "string" == typeof e ? e.split("") : e;
    for (--o; 0 <= o; --o) o in i && t.call(r, i[o], o, e);
  }, goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.filter) ? function(e, t, r) {
    return goog.asserts.assert(null != e.length), Array.prototype.filter.call(e, t, r);
  } : function(e, t, r) {
    for (var o = e.length, i = [], a2 = 0, n = "string" == typeof e ? e.split("") : e, s = 0; s < o; s++) if (s in n) {
      var p = n[s];
      t.call(r, p, s, e) && (i[a2++] = p);
    }
    return i;
  }, goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.map) ? function(e, t, r) {
    return goog.asserts.assert(null != e.length), Array.prototype.map.call(e, t, r);
  } : function(e, t, r) {
    for (var o = e.length, i = Array(o), a2 = "string" == typeof e ? e.split("") : e, n = 0; n < o; n++) n in a2 && (i[n] = t.call(r, a2[n], n, e));
    return i;
  }, goog.array.reduce = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduce) ? function(e, t, r, o) {
    return goog.asserts.assert(null != e.length), o && (t = goog.bind(t, o)), Array.prototype.reduce.call(e, t, r);
  } : function(e, t, r, o) {
    var i = r;
    return goog.array.forEach(e, (function(r2, a2) {
      i = t.call(o, i, r2, a2, e);
    })), i;
  }, goog.array.reduceRight = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduceRight) ? function(e, t, r, o) {
    return goog.asserts.assert(null != e.length), goog.asserts.assert(null != t), o && (t = goog.bind(t, o)), Array.prototype.reduceRight.call(e, t, r);
  } : function(e, t, r, o) {
    var i = r;
    return goog.array.forEachRight(e, (function(r2, a2) {
      i = t.call(o, i, r2, a2, e);
    })), i;
  }, goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.some) ? function(e, t, r) {
    return goog.asserts.assert(null != e.length), Array.prototype.some.call(e, t, r);
  } : function(e, t, r) {
    for (var o = e.length, i = "string" == typeof e ? e.split("") : e, a2 = 0; a2 < o; a2++) if (a2 in i && t.call(r, i[a2], a2, e)) return true;
    return false;
  }, goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.every) ? function(e, t, r) {
    return goog.asserts.assert(null != e.length), Array.prototype.every.call(e, t, r);
  } : function(e, t, r) {
    for (var o = e.length, i = "string" == typeof e ? e.split("") : e, a2 = 0; a2 < o; a2++) if (a2 in i && !t.call(r, i[a2], a2, e)) return false;
    return true;
  }, goog.array.count = function(e, t, r) {
    var o = 0;
    return goog.array.forEach(e, (function(e2, i, a2) {
      t.call(r, e2, i, a2) && ++o;
    }), r), o;
  }, goog.array.find = function(e, t, r) {
    return 0 > (t = goog.array.findIndex(e, t, r)) ? null : "string" == typeof e ? e.charAt(t) : e[t];
  }, goog.array.findIndex = function(e, t, r) {
    for (var o = e.length, i = "string" == typeof e ? e.split("") : e, a2 = 0; a2 < o; a2++) if (a2 in i && t.call(r, i[a2], a2, e)) return a2;
    return -1;
  }, goog.array.findRight = function(e, t, r) {
    return 0 > (t = goog.array.findIndexRight(e, t, r)) ? null : "string" == typeof e ? e.charAt(t) : e[t];
  }, goog.array.findIndexRight = function(e, t, r) {
    var o = e.length, i = "string" == typeof e ? e.split("") : e;
    for (--o; 0 <= o; o--) if (o in i && t.call(r, i[o], o, e)) return o;
    return -1;
  }, goog.array.contains = function(e, t) {
    return 0 <= goog.array.indexOf(e, t);
  }, goog.array.isEmpty = function(e) {
    return 0 == e.length;
  }, goog.array.clear = function(e) {
    if (!Array.isArray(e)) for (var t = e.length - 1; 0 <= t; t--) delete e[t];
    e.length = 0;
  }, goog.array.insert = function(e, t) {
    goog.array.contains(e, t) || e.push(t);
  }, goog.array.insertAt = function(e, t, r) {
    goog.array.splice(e, r, 0, t);
  }, goog.array.insertArrayAt = function(e, t, r) {
    goog.partial(goog.array.splice, e, r, 0).apply(null, t);
  }, goog.array.insertBefore = function(e, t, r) {
    var o;
    2 == arguments.length || 0 > (o = goog.array.indexOf(e, r)) ? e.push(t) : goog.array.insertAt(e, t, o);
  }, goog.array.remove = function(e, t) {
    var r;
    return (r = 0 <= (t = goog.array.indexOf(e, t))) && goog.array.removeAt(e, t), r;
  }, goog.array.removeLast = function(e, t) {
    return 0 <= (t = goog.array.lastIndexOf(e, t)) && (goog.array.removeAt(e, t), true);
  }, goog.array.removeAt = function(e, t) {
    return goog.asserts.assert(null != e.length), 1 == Array.prototype.splice.call(e, t, 1).length;
  }, goog.array.removeIf = function(e, t, r) {
    return 0 <= (t = goog.array.findIndex(e, t, r)) && (goog.array.removeAt(e, t), true);
  }, goog.array.removeAllIf = function(e, t, r) {
    var o = 0;
    return goog.array.forEachRight(e, (function(i, a2) {
      t.call(r, i, a2, e) && goog.array.removeAt(e, a2) && o++;
    })), o;
  }, goog.array.concat = function(e) {
    return Array.prototype.concat.apply([], arguments);
  }, goog.array.join = function(e) {
    return Array.prototype.concat.apply([], arguments);
  }, goog.array.toArray = function(e) {
    var t = e.length;
    if (0 < t) {
      for (var r = Array(t), o = 0; o < t; o++) r[o] = e[o];
      return r;
    }
    return [];
  }, goog.array.clone = goog.array.toArray, goog.array.extend = function(e, t) {
    for (var r = 1; r < arguments.length; r++) {
      var o = arguments[r];
      if (goog.isArrayLike(o)) {
        var i = e.length || 0, a2 = o.length || 0;
        e.length = i + a2;
        for (var n = 0; n < a2; n++) e[i + n] = o[n];
      } else e.push(o);
    }
  }, goog.array.splice = function(e, t, r, o) {
    return goog.asserts.assert(null != e.length), Array.prototype.splice.apply(e, goog.array.slice(arguments, 1));
  }, goog.array.slice = function(e, t, r) {
    return goog.asserts.assert(null != e.length), 2 >= arguments.length ? Array.prototype.slice.call(e, t) : Array.prototype.slice.call(e, t, r);
  }, goog.array.removeDuplicates = function(e, t, r) {
    t = t || e;
    var o = function(e2) {
      return goog.isObject(e2) ? "o" + goog.getUid(e2) : (typeof e2).charAt(0) + e2;
    };
    r = r || o, o = {};
    for (var i = 0, a2 = 0; a2 < e.length; ) {
      var n = e[a2++], s = r(n);
      Object.prototype.hasOwnProperty.call(o, s) || (o[s] = true, t[i++] = n);
    }
    t.length = i;
  }, goog.array.binarySearch = function(e, t, r) {
    return goog.array.binarySearch_(e, r || goog.array.defaultCompare, false, t);
  }, goog.array.binarySelect = function(e, t, r) {
    return goog.array.binarySearch_(e, t, true, void 0, r);
  }, goog.array.binarySearch_ = function(e, t, r, o, i) {
    for (var a2, n = 0, s = e.length; n < s; ) {
      var p = n + (s - n >>> 1), d = r ? t.call(i, e[p], p, e) : t(o, e[p]);
      0 < d ? n = p + 1 : (s = p, a2 = !d);
    }
    return a2 ? n : -n - 1;
  }, goog.array.sort = function(e, t) {
    e.sort(t || goog.array.defaultCompare);
  }, goog.array.stableSort = function(e, t) {
    for (var r = Array(e.length), o = 0; o < e.length; o++) r[o] = { index: o, value: e[o] };
    var i = t || goog.array.defaultCompare;
    for (goog.array.sort(r, (function(e2, t2) {
      return i(e2.value, t2.value) || e2.index - t2.index;
    })), o = 0; o < e.length; o++) e[o] = r[o].value;
  }, goog.array.sortByKey = function(e, t, r) {
    var o = r || goog.array.defaultCompare;
    goog.array.sort(e, (function(e2, r2) {
      return o(t(e2), t(r2));
    }));
  }, goog.array.sortObjectsByKey = function(e, t, r) {
    goog.array.sortByKey(e, (function(e2) {
      return e2[t];
    }), r);
  }, goog.array.isSorted = function(e, t, r) {
    t = t || goog.array.defaultCompare;
    for (var o = 1; o < e.length; o++) {
      var i = t(e[o - 1], e[o]);
      if (0 < i || 0 == i && r) return false;
    }
    return true;
  }, goog.array.equals = function(e, t, r) {
    if (!goog.isArrayLike(e) || !goog.isArrayLike(t) || e.length != t.length) return false;
    var o = e.length;
    r = r || goog.array.defaultCompareEquality;
    for (var i = 0; i < o; i++) if (!r(e[i], t[i])) return false;
    return true;
  }, goog.array.compare3 = function(e, t, r) {
    r = r || goog.array.defaultCompare;
    for (var o = Math.min(e.length, t.length), i = 0; i < o; i++) {
      var a2 = r(e[i], t[i]);
      if (0 != a2) return a2;
    }
    return goog.array.defaultCompare(e.length, t.length);
  }, goog.array.defaultCompare = function(e, t) {
    return e > t ? 1 : e < t ? -1 : 0;
  }, goog.array.inverseDefaultCompare = function(e, t) {
    return -goog.array.defaultCompare(e, t);
  }, goog.array.defaultCompareEquality = function(e, t) {
    return e === t;
  }, goog.array.binaryInsert = function(e, t, r) {
    return 0 > (r = goog.array.binarySearch(e, t, r)) && (goog.array.insertAt(e, t, -(r + 1)), true);
  }, goog.array.binaryRemove = function(e, t, r) {
    return 0 <= (t = goog.array.binarySearch(e, t, r)) && goog.array.removeAt(e, t);
  }, goog.array.bucket = function(e, t, r) {
    for (var o = {}, i = 0; i < e.length; i++) {
      var a2 = e[i], n = t.call(r, a2, i, e);
      void 0 !== n && (o[n] || (o[n] = [])).push(a2);
    }
    return o;
  }, goog.array.toObject = function(e, t, r) {
    var o = {};
    return goog.array.forEach(e, (function(i, a2) {
      o[t.call(r, i, a2, e)] = i;
    })), o;
  }, goog.array.range = function(e, t, r) {
    var o = [], i = 0, a2 = e;
    if (void 0 !== t && (i = e, a2 = t), 0 > (r = r || 1) * (a2 - i)) return [];
    if (0 < r) for (e = i; e < a2; e += r) o.push(e);
    else for (e = i; e > a2; e += r) o.push(e);
    return o;
  }, goog.array.repeat = function(e, t) {
    for (var r = [], o = 0; o < t; o++) r[o] = e;
    return r;
  }, goog.array.flatten = function(e) {
    for (var t = [], r = 0; r < arguments.length; r++) {
      var o = arguments[r];
      if (Array.isArray(o)) for (var i = 0; i < o.length; i += 8192) {
        var a2 = goog.array.slice(o, i, i + 8192);
        a2 = goog.array.flatten.apply(null, a2);
        for (var n = 0; n < a2.length; n++) t.push(a2[n]);
      }
      else t.push(o);
    }
    return t;
  }, goog.array.rotate = function(e, t) {
    return goog.asserts.assert(null != e.length), e.length && (0 < (t %= e.length) ? Array.prototype.unshift.apply(e, e.splice(-t, t)) : 0 > t && Array.prototype.push.apply(e, e.splice(0, -t))), e;
  }, goog.array.moveItem = function(e, t, r) {
    goog.asserts.assert(0 <= t && t < e.length), goog.asserts.assert(0 <= r && r < e.length), t = Array.prototype.splice.call(e, t, 1), Array.prototype.splice.call(e, r, 0, t[0]);
  }, goog.array.zip = function(e) {
    if (!arguments.length) return [];
    for (var t = [], r = arguments[0].length, o = 1; o < arguments.length; o++) arguments[o].length < r && (r = arguments[o].length);
    for (o = 0; o < r; o++) {
      for (var i = [], a2 = 0; a2 < arguments.length; a2++) i.push(arguments[a2][o]);
      t.push(i);
    }
    return t;
  }, goog.array.shuffle = function(e, t) {
    t = t || Math.random;
    for (var r = e.length - 1; 0 < r; r--) {
      var o = Math.floor(t() * (r + 1)), i = e[r];
      e[r] = e[o], e[o] = i;
    }
  }, goog.array.copyByIndex = function(e, t) {
    var r = [];
    return goog.array.forEach(t, (function(t2) {
      r.push(e[t2]);
    })), r;
  }, goog.array.concatMap = function(e, t, r) {
    return goog.array.concat.apply([], goog.array.map(e, t, r));
  }, goog.crypt = {}, goog.crypt.stringToByteArray = function(e) {
    for (var t = [], r = 0, o = 0; o < e.length; o++) {
      var i = e.charCodeAt(o);
      255 < i && (t[r++] = 255 & i, i >>= 8), t[r++] = i;
    }
    return t;
  }, goog.crypt.byteArrayToString = function(e) {
    if (8192 >= e.length) return String.fromCharCode.apply(null, e);
    for (var t = "", r = 0; r < e.length; r += 8192) {
      var o = goog.array.slice(e, r, r + 8192);
      t += String.fromCharCode.apply(null, o);
    }
    return t;
  }, goog.crypt.byteArrayToHex = function(e, t) {
    return goog.array.map(e, (function(e2) {
      return 1 < (e2 = e2.toString(16)).length ? e2 : "0" + e2;
    })).join(t || "");
  }, goog.crypt.hexToByteArray = function(e) {
    goog.asserts.assert(0 == e.length % 2, "Key string length must be multiple of 2");
    for (var t = [], r = 0; r < e.length; r += 2) t.push(parseInt(e.substring(r, r + 2), 16));
    return t;
  }, goog.crypt.stringToUtf8ByteArray = function(e) {
    for (var t = [], r = 0, o = 0; o < e.length; o++) {
      var i = e.charCodeAt(o);
      128 > i ? t[r++] = i : (2048 > i ? t[r++] = i >> 6 | 192 : (55296 == (64512 & i) && o + 1 < e.length && 56320 == (64512 & e.charCodeAt(o + 1)) ? (i = 65536 + ((1023 & i) << 10) + (1023 & e.charCodeAt(++o)), t[r++] = i >> 18 | 240, t[r++] = i >> 12 & 63 | 128) : t[r++] = i >> 12 | 224, t[r++] = i >> 6 & 63 | 128), t[r++] = 63 & i | 128);
    }
    return t;
  }, goog.crypt.utf8ByteArrayToString = function(e) {
    for (var t = [], r = 0, o = 0; r < e.length; ) {
      var i = e[r++];
      if (128 > i) t[o++] = String.fromCharCode(i);
      else if (191 < i && 224 > i) {
        var a2 = e[r++];
        t[o++] = String.fromCharCode((31 & i) << 6 | 63 & a2);
      } else if (239 < i && 365 > i) {
        a2 = e[r++];
        var n = e[r++];
        i = ((7 & i) << 18 | (63 & a2) << 12 | (63 & n) << 6 | 63 & e[r++]) - 65536, t[o++] = String.fromCharCode(55296 + (i >> 10)), t[o++] = String.fromCharCode(56320 + (1023 & i));
      } else a2 = e[r++], n = e[r++], t[o++] = String.fromCharCode((15 & i) << 12 | (63 & a2) << 6 | 63 & n);
    }
    return t.join("");
  }, goog.crypt.xorByteArray = function(e, t) {
    goog.asserts.assert(e.length == t.length, "XOR array lengths must match");
    for (var r = [], o = 0; o < e.length; o++) r.push(e[o] ^ t[o]);
    return r;
  }, goog.dom.asserts = {}, goog.dom.asserts.assertIsLocation = function(e) {
    if (goog.asserts.ENABLE_ASSERTS) {
      var t = goog.dom.asserts.getWindow_(e);
      t && (!e || !(e instanceof t.Location) && e instanceof t.Element) && goog.asserts.fail("Argument is not a Location (or a non-Element mock); got: %s", goog.dom.asserts.debugStringForType_(e));
    }
    return e;
  }, goog.dom.asserts.assertIsElementType_ = function(e, t) {
    if (goog.asserts.ENABLE_ASSERTS) {
      var r = goog.dom.asserts.getWindow_(e);
      r && void 0 !== r[t] && (e && (e instanceof r[t] || !(e instanceof r.Location || e instanceof r.Element)) || goog.asserts.fail("Argument is not a %s (or a non-Element, non-Location mock); got: %s", t, goog.dom.asserts.debugStringForType_(e)));
    }
    return e;
  }, goog.dom.asserts.assertIsHTMLAnchorElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLAnchorElement");
  }, goog.dom.asserts.assertIsHTMLButtonElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLButtonElement");
  }, goog.dom.asserts.assertIsHTMLLinkElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLLinkElement");
  }, goog.dom.asserts.assertIsHTMLImageElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLImageElement");
  }, goog.dom.asserts.assertIsHTMLAudioElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLAudioElement");
  }, goog.dom.asserts.assertIsHTMLVideoElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLVideoElement");
  }, goog.dom.asserts.assertIsHTMLInputElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLInputElement");
  }, goog.dom.asserts.assertIsHTMLTextAreaElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLTextAreaElement");
  }, goog.dom.asserts.assertIsHTMLCanvasElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLCanvasElement");
  }, goog.dom.asserts.assertIsHTMLEmbedElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLEmbedElement");
  }, goog.dom.asserts.assertIsHTMLFormElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLFormElement");
  }, goog.dom.asserts.assertIsHTMLFrameElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLFrameElement");
  }, goog.dom.asserts.assertIsHTMLIFrameElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLIFrameElement");
  }, goog.dom.asserts.assertIsHTMLObjectElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLObjectElement");
  }, goog.dom.asserts.assertIsHTMLScriptElement = function(e) {
    return goog.dom.asserts.assertIsElementType_(e, "HTMLScriptElement");
  }, goog.dom.asserts.debugStringForType_ = function(e) {
    if (!goog.isObject(e)) return void 0 === e ? "undefined" : null === e ? "null" : typeof e;
    try {
      return e.constructor.displayName || e.constructor.name || Object.prototype.toString.call(e);
    } catch (e2) {
      return "<object could not be stringified>";
    }
  }, goog.dom.asserts.getWindow_ = function(e) {
    try {
      var t = e && e.ownerDocument, r = t && (t.defaultView || t.parentWindow);
      if ((r = r || goog.global).Element && r.Location) return r;
    } catch (e2) {
    }
    return null;
  }, goog.functions = {}, goog.functions.constant = function(e) {
    return function() {
      return e;
    };
  }, goog.functions.FALSE = function() {
    return false;
  }, goog.functions.TRUE = function() {
    return true;
  }, goog.functions.NULL = function() {
    return null;
  }, goog.functions.identity = function(e, t) {
    return e;
  }, goog.functions.error = function(e) {
    return function() {
      throw Error(e);
    };
  }, goog.functions.fail = function(e) {
    return function() {
      throw e;
    };
  }, goog.functions.lock = function(e, t) {
    return t = t || 0, function() {
      return e.apply(this, Array.prototype.slice.call(arguments, 0, t));
    };
  }, goog.functions.nth = function(e) {
    return function() {
      return arguments[e];
    };
  }, goog.functions.partialRight = function(e, t) {
    var r = Array.prototype.slice.call(arguments, 1);
    return function() {
      var t2 = Array.prototype.slice.call(arguments);
      return t2.push.apply(t2, r), e.apply(this, t2);
    };
  }, goog.functions.withReturnValue = function(e, t) {
    return goog.functions.sequence(e, goog.functions.constant(t));
  }, goog.functions.equalTo = function(e, t) {
    return function(r) {
      return t ? e == r : e === r;
    };
  }, goog.functions.compose = function(e, t) {
    var r = arguments, o = r.length;
    return function() {
      var e2;
      o && (e2 = r[o - 1].apply(this, arguments));
      for (var t2 = o - 2; 0 <= t2; t2--) e2 = r[t2].call(this, e2);
      return e2;
    };
  }, goog.functions.sequence = function(e) {
    var t = arguments, r = t.length;
    return function() {
      for (var e2, o = 0; o < r; o++) e2 = t[o].apply(this, arguments);
      return e2;
    };
  }, goog.functions.and = function(e) {
    var t = arguments, r = t.length;
    return function() {
      for (var e2 = 0; e2 < r; e2++) if (!t[e2].apply(this, arguments)) return false;
      return true;
    };
  }, goog.functions.or = function(e) {
    var t = arguments, r = t.length;
    return function() {
      for (var e2 = 0; e2 < r; e2++) if (t[e2].apply(this, arguments)) return true;
      return false;
    };
  }, goog.functions.not = function(e) {
    return function() {
      return !e.apply(this, arguments);
    };
  }, goog.functions.create = function(e, t) {
    var r = function() {
    };
    return r.prototype = e.prototype, r = new r(), e.apply(r, Array.prototype.slice.call(arguments, 1)), r;
  }, goog.functions.CACHE_RETURN_VALUE = true, goog.functions.cacheReturnValue = function(e) {
    var t, r = false;
    return function() {
      return goog.functions.CACHE_RETURN_VALUE ? (r || (t = e(), r = true), t) : e();
    };
  }, goog.functions.once = function(e) {
    var t = e;
    return function() {
      if (t) {
        var e2 = t;
        t = null, e2();
      }
    };
  }, goog.functions.debounce = function(e, t, r) {
    var o = 0;
    return function(i) {
      goog.global.clearTimeout(o);
      var a2 = arguments;
      o = goog.global.setTimeout((function() {
        e.apply(r, a2);
      }), t);
    };
  }, goog.functions.throttle = function(e, t, r) {
    var o = 0, i = false, a2 = [], n = function() {
      o = 0, i && (i = false, s());
    }, s = function() {
      o = goog.global.setTimeout(n, t), e.apply(r, a2);
    };
    return function(e2) {
      a2 = arguments, o ? i = true : s();
    };
  }, goog.functions.rateLimit = function(e, t, r) {
    var o = 0, i = function() {
      o = 0;
    };
    return function(a2) {
      o || (o = goog.global.setTimeout(i, t), e.apply(r, arguments));
    };
  }, goog.dom.HtmlElement = function() {
  }, goog.dom.TagName = function(e) {
    this.tagName_ = e;
  }, goog.dom.TagName.prototype.toString = function() {
    return this.tagName_;
  }, goog.dom.TagName.A = new goog.dom.TagName("A"), goog.dom.TagName.ABBR = new goog.dom.TagName("ABBR"), goog.dom.TagName.ACRONYM = new goog.dom.TagName("ACRONYM"), goog.dom.TagName.ADDRESS = new goog.dom.TagName("ADDRESS"), goog.dom.TagName.APPLET = new goog.dom.TagName("APPLET"), goog.dom.TagName.AREA = new goog.dom.TagName("AREA"), goog.dom.TagName.ARTICLE = new goog.dom.TagName("ARTICLE"), goog.dom.TagName.ASIDE = new goog.dom.TagName("ASIDE"), goog.dom.TagName.AUDIO = new goog.dom.TagName("AUDIO"), goog.dom.TagName.B = new goog.dom.TagName("B"), goog.dom.TagName.BASE = new goog.dom.TagName("BASE"), goog.dom.TagName.BASEFONT = new goog.dom.TagName("BASEFONT"), goog.dom.TagName.BDI = new goog.dom.TagName("BDI"), goog.dom.TagName.BDO = new goog.dom.TagName("BDO"), goog.dom.TagName.BIG = new goog.dom.TagName("BIG"), goog.dom.TagName.BLOCKQUOTE = new goog.dom.TagName("BLOCKQUOTE"), goog.dom.TagName.BODY = new goog.dom.TagName("BODY"), goog.dom.TagName.BR = new goog.dom.TagName("BR"), goog.dom.TagName.BUTTON = new goog.dom.TagName("BUTTON"), goog.dom.TagName.CANVAS = new goog.dom.TagName("CANVAS"), goog.dom.TagName.CAPTION = new goog.dom.TagName("CAPTION"), goog.dom.TagName.CENTER = new goog.dom.TagName("CENTER"), goog.dom.TagName.CITE = new goog.dom.TagName("CITE"), goog.dom.TagName.CODE = new goog.dom.TagName("CODE"), goog.dom.TagName.COL = new goog.dom.TagName("COL"), goog.dom.TagName.COLGROUP = new goog.dom.TagName("COLGROUP"), goog.dom.TagName.COMMAND = new goog.dom.TagName("COMMAND"), goog.dom.TagName.DATA = new goog.dom.TagName("DATA"), goog.dom.TagName.DATALIST = new goog.dom.TagName("DATALIST"), goog.dom.TagName.DD = new goog.dom.TagName("DD"), goog.dom.TagName.DEL = new goog.dom.TagName("DEL"), goog.dom.TagName.DETAILS = new goog.dom.TagName("DETAILS"), goog.dom.TagName.DFN = new goog.dom.TagName("DFN"), goog.dom.TagName.DIALOG = new goog.dom.TagName("DIALOG"), goog.dom.TagName.DIR = new goog.dom.TagName("DIR"), goog.dom.TagName.DIV = new goog.dom.TagName("DIV"), goog.dom.TagName.DL = new goog.dom.TagName("DL"), goog.dom.TagName.DT = new goog.dom.TagName("DT"), goog.dom.TagName.EM = new goog.dom.TagName("EM"), goog.dom.TagName.EMBED = new goog.dom.TagName("EMBED"), goog.dom.TagName.FIELDSET = new goog.dom.TagName("FIELDSET"), goog.dom.TagName.FIGCAPTION = new goog.dom.TagName("FIGCAPTION"), goog.dom.TagName.FIGURE = new goog.dom.TagName("FIGURE"), goog.dom.TagName.FONT = new goog.dom.TagName("FONT"), goog.dom.TagName.FOOTER = new goog.dom.TagName("FOOTER"), goog.dom.TagName.FORM = new goog.dom.TagName("FORM"), goog.dom.TagName.FRAME = new goog.dom.TagName("FRAME"), goog.dom.TagName.FRAMESET = new goog.dom.TagName("FRAMESET"), goog.dom.TagName.H1 = new goog.dom.TagName("H1"), goog.dom.TagName.H2 = new goog.dom.TagName("H2"), goog.dom.TagName.H3 = new goog.dom.TagName("H3"), goog.dom.TagName.H4 = new goog.dom.TagName("H4"), goog.dom.TagName.H5 = new goog.dom.TagName("H5"), goog.dom.TagName.H6 = new goog.dom.TagName("H6"), goog.dom.TagName.HEAD = new goog.dom.TagName("HEAD"), goog.dom.TagName.HEADER = new goog.dom.TagName("HEADER"), goog.dom.TagName.HGROUP = new goog.dom.TagName("HGROUP"), goog.dom.TagName.HR = new goog.dom.TagName("HR"), goog.dom.TagName.HTML = new goog.dom.TagName("HTML"), goog.dom.TagName.I = new goog.dom.TagName("I"), goog.dom.TagName.IFRAME = new goog.dom.TagName("IFRAME"), goog.dom.TagName.IMG = new goog.dom.TagName("IMG"), goog.dom.TagName.INPUT = new goog.dom.TagName("INPUT"), goog.dom.TagName.INS = new goog.dom.TagName("INS"), goog.dom.TagName.ISINDEX = new goog.dom.TagName("ISINDEX"), goog.dom.TagName.KBD = new goog.dom.TagName("KBD"), goog.dom.TagName.KEYGEN = new goog.dom.TagName("KEYGEN"), goog.dom.TagName.LABEL = new goog.dom.TagName("LABEL"), goog.dom.TagName.LEGEND = new goog.dom.TagName("LEGEND"), goog.dom.TagName.LI = new goog.dom.TagName("LI"), goog.dom.TagName.LINK = new goog.dom.TagName("LINK"), goog.dom.TagName.MAIN = new goog.dom.TagName("MAIN"), goog.dom.TagName.MAP = new goog.dom.TagName("MAP"), goog.dom.TagName.MARK = new goog.dom.TagName("MARK"), goog.dom.TagName.MATH = new goog.dom.TagName("MATH"), goog.dom.TagName.MENU = new goog.dom.TagName("MENU"), goog.dom.TagName.MENUITEM = new goog.dom.TagName("MENUITEM"), goog.dom.TagName.META = new goog.dom.TagName("META"), goog.dom.TagName.METER = new goog.dom.TagName("METER"), goog.dom.TagName.NAV = new goog.dom.TagName("NAV"), goog.dom.TagName.NOFRAMES = new goog.dom.TagName("NOFRAMES"), goog.dom.TagName.NOSCRIPT = new goog.dom.TagName("NOSCRIPT"), goog.dom.TagName.OBJECT = new goog.dom.TagName("OBJECT"), goog.dom.TagName.OL = new goog.dom.TagName("OL"), goog.dom.TagName.OPTGROUP = new goog.dom.TagName("OPTGROUP"), goog.dom.TagName.OPTION = new goog.dom.TagName("OPTION"), goog.dom.TagName.OUTPUT = new goog.dom.TagName("OUTPUT"), goog.dom.TagName.P = new goog.dom.TagName("P"), goog.dom.TagName.PARAM = new goog.dom.TagName("PARAM"), goog.dom.TagName.PICTURE = new goog.dom.TagName("PICTURE"), goog.dom.TagName.PRE = new goog.dom.TagName("PRE"), goog.dom.TagName.PROGRESS = new goog.dom.TagName("PROGRESS"), goog.dom.TagName.Q = new goog.dom.TagName("Q"), goog.dom.TagName.RP = new goog.dom.TagName("RP"), goog.dom.TagName.RT = new goog.dom.TagName("RT"), goog.dom.TagName.RTC = new goog.dom.TagName("RTC"), goog.dom.TagName.RUBY = new goog.dom.TagName("RUBY"), goog.dom.TagName.S = new goog.dom.TagName("S"), goog.dom.TagName.SAMP = new goog.dom.TagName("SAMP"), goog.dom.TagName.SCRIPT = new goog.dom.TagName("SCRIPT"), goog.dom.TagName.SECTION = new goog.dom.TagName("SECTION"), goog.dom.TagName.SELECT = new goog.dom.TagName("SELECT"), goog.dom.TagName.SMALL = new goog.dom.TagName("SMALL"), goog.dom.TagName.SOURCE = new goog.dom.TagName("SOURCE"), goog.dom.TagName.SPAN = new goog.dom.TagName("SPAN"), goog.dom.TagName.STRIKE = new goog.dom.TagName("STRIKE"), goog.dom.TagName.STRONG = new goog.dom.TagName("STRONG"), goog.dom.TagName.STYLE = new goog.dom.TagName("STYLE"), goog.dom.TagName.SUB = new goog.dom.TagName("SUB"), goog.dom.TagName.SUMMARY = new goog.dom.TagName("SUMMARY"), goog.dom.TagName.SUP = new goog.dom.TagName("SUP"), goog.dom.TagName.SVG = new goog.dom.TagName("SVG"), goog.dom.TagName.TABLE = new goog.dom.TagName("TABLE"), goog.dom.TagName.TBODY = new goog.dom.TagName("TBODY"), goog.dom.TagName.TD = new goog.dom.TagName("TD"), goog.dom.TagName.TEMPLATE = new goog.dom.TagName("TEMPLATE"), goog.dom.TagName.TEXTAREA = new goog.dom.TagName("TEXTAREA"), goog.dom.TagName.TFOOT = new goog.dom.TagName("TFOOT"), goog.dom.TagName.TH = new goog.dom.TagName("TH"), goog.dom.TagName.THEAD = new goog.dom.TagName("THEAD"), goog.dom.TagName.TIME = new goog.dom.TagName("TIME"), goog.dom.TagName.TITLE = new goog.dom.TagName("TITLE"), goog.dom.TagName.TR = new goog.dom.TagName("TR"), goog.dom.TagName.TRACK = new goog.dom.TagName("TRACK"), goog.dom.TagName.TT = new goog.dom.TagName("TT"), goog.dom.TagName.U = new goog.dom.TagName("U"), goog.dom.TagName.UL = new goog.dom.TagName("UL"), goog.dom.TagName.VAR = new goog.dom.TagName("VAR"), goog.dom.TagName.VIDEO = new goog.dom.TagName("VIDEO"), goog.dom.TagName.WBR = new goog.dom.TagName("WBR"), goog.dom.tags = {}, goog.dom.tags.VOID_TAGS_ = { area: true, base: true, br: true, col: true, command: true, embed: true, hr: true, img: true, input: true, keygen: true, link: true, meta: true, param: true, source: true, track: true, wbr: true }, goog.dom.tags.isVoidTag = function(e) {
    return true === goog.dom.tags.VOID_TAGS_[e];
  }, goog.html = {}, goog.html.trustedtypes = {}, goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY = goog.TRUSTED_TYPES_POLICY_NAME ? goog.createTrustedTypesPolicy(goog.TRUSTED_TYPES_POLICY_NAME + "#html") : null, goog.string = {}, goog.string.TypedString = function() {
  }, goog.string.Const = function(e, t) {
    this.stringConstValueWithSecurityContract__googStringSecurityPrivate_ = e === goog.string.Const.GOOG_STRING_CONSTRUCTOR_TOKEN_PRIVATE_ && t || "", this.STRING_CONST_TYPE_MARKER__GOOG_STRING_SECURITY_PRIVATE_ = goog.string.Const.TYPE_MARKER_;
  }, goog.string.Const.prototype.implementsGoogStringTypedString = true, goog.string.Const.prototype.getTypedStringValue = function() {
    return this.stringConstValueWithSecurityContract__googStringSecurityPrivate_;
  }, goog.DEBUG && (goog.string.Const.prototype.toString = function() {
    return "Const{" + this.stringConstValueWithSecurityContract__googStringSecurityPrivate_ + "}";
  }), goog.string.Const.unwrap = function(e) {
    return e instanceof goog.string.Const && e.constructor === goog.string.Const && e.STRING_CONST_TYPE_MARKER__GOOG_STRING_SECURITY_PRIVATE_ === goog.string.Const.TYPE_MARKER_ ? e.stringConstValueWithSecurityContract__googStringSecurityPrivate_ : (goog.asserts.fail("expected object of type Const, got '" + e + "'"), "type_error:Const");
  }, goog.string.Const.from = function(e) {
    return new goog.string.Const(goog.string.Const.GOOG_STRING_CONSTRUCTOR_TOKEN_PRIVATE_, e);
  }, goog.string.Const.TYPE_MARKER_ = {}, goog.string.Const.GOOG_STRING_CONSTRUCTOR_TOKEN_PRIVATE_ = {}, goog.string.Const.EMPTY = goog.string.Const.from(""), goog.html.SafeScript = function() {
    this.privateDoNotAccessOrElseSafeScriptWrappedValue_ = "", this.SAFE_SCRIPT_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
  }, goog.html.SafeScript.prototype.implementsGoogStringTypedString = true, goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {}, goog.html.SafeScript.fromConstant = function(e) {
    return 0 === (e = goog.string.Const.unwrap(e)).length ? goog.html.SafeScript.EMPTY : goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(e);
  }, goog.html.SafeScript.fromConstantAndArgs = function(e, t) {
    for (var r = [], o = 1; o < arguments.length; o++) r.push(goog.html.SafeScript.stringify_(arguments[o]));
    return goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse("(" + goog.string.Const.unwrap(e) + ")(" + r.join(", ") + ");");
  }, goog.html.SafeScript.fromJson = function(e) {
    return goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(goog.html.SafeScript.stringify_(e));
  }, goog.html.SafeScript.prototype.getTypedStringValue = function() {
    return this.privateDoNotAccessOrElseSafeScriptWrappedValue_.toString();
  }, goog.DEBUG && (goog.html.SafeScript.prototype.toString = function() {
    return "SafeScript{" + this.privateDoNotAccessOrElseSafeScriptWrappedValue_ + "}";
  }), goog.html.SafeScript.unwrap = function(e) {
    return goog.html.SafeScript.unwrapTrustedScript(e).toString();
  }, goog.html.SafeScript.unwrapTrustedScript = function(e) {
    return e instanceof goog.html.SafeScript && e.constructor === goog.html.SafeScript && e.SAFE_SCRIPT_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.SafeScript.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ ? e.privateDoNotAccessOrElseSafeScriptWrappedValue_ : (goog.asserts.fail("expected object of type SafeScript, got '" + e + "' of type " + goog.typeOf(e)), "type_error:SafeScript");
  }, goog.html.SafeScript.stringify_ = function(e) {
    return JSON.stringify(e).replace(/</g, "\\x3c");
  }, goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse = function(e) {
    return new goog.html.SafeScript().initSecurityPrivateDoNotAccessOrElse_(e);
  }, goog.html.SafeScript.prototype.initSecurityPrivateDoNotAccessOrElse_ = function(e) {
    return this.privateDoNotAccessOrElseSafeScriptWrappedValue_ = goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY ? goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY.createScript(e) : e, this;
  }, goog.html.SafeScript.EMPTY = goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(""), goog.fs = {}, goog.fs.url = {}, goog.fs.url.createObjectUrl = function(e) {
    return goog.fs.url.getUrlObject_().createObjectURL(e);
  }, goog.fs.url.revokeObjectUrl = function(e) {
    goog.fs.url.getUrlObject_().revokeObjectURL(e);
  }, goog.fs.url.UrlObject_ = function() {
  }, goog.fs.url.UrlObject_.prototype.createObjectURL = function(e) {
  }, goog.fs.url.UrlObject_.prototype.revokeObjectURL = function(e) {
  }, goog.fs.url.getUrlObject_ = function() {
    var e = goog.fs.url.findUrlObject_();
    if (null != e) return e;
    throw Error("This browser doesn't seem to support blob URLs");
  }, goog.fs.url.findUrlObject_ = function() {
    return void 0 !== goog.global.URL && void 0 !== goog.global.URL.createObjectURL ? goog.global.URL : void 0 !== goog.global.webkitURL && void 0 !== goog.global.webkitURL.createObjectURL ? goog.global.webkitURL : void 0 !== goog.global.createObjectURL ? goog.global : null;
  }, goog.fs.url.browserSupportsObjectUrls = function() {
    return null != goog.fs.url.findUrlObject_();
  }, goog.fs.blob = {}, goog.fs.blob.getBlob = function(e) {
    var t = goog.global.BlobBuilder || goog.global.WebKitBlobBuilder;
    if (void 0 !== t) {
      t = new t();
      for (var r = 0; r < arguments.length; r++) t.append(arguments[r]);
      return t.getBlob();
    }
    return goog.fs.blob.getBlobWithProperties(goog.array.toArray(arguments));
  }, goog.fs.blob.getBlobWithProperties = function(e, t, r) {
    var o = goog.global.BlobBuilder || goog.global.WebKitBlobBuilder;
    if (void 0 !== o) {
      o = new o();
      for (var i = 0; i < e.length; i++) o.append(e[i], r);
      return o.getBlob(t);
    }
    if (void 0 !== goog.global.Blob) return o = {}, t && (o.type = t), r && (o.endings = r), new Blob(e, o);
    throw Error("This browser doesn't seem to support creating Blobs");
  }, goog.i18n = {}, goog.i18n.bidi = {}, goog.i18n.bidi.FORCE_RTL = false, goog.i18n.bidi.IS_RTL = goog.i18n.bidi.FORCE_RTL || ("ar" == goog.LOCALE.substring(0, 2).toLowerCase() || "fa" == goog.LOCALE.substring(0, 2).toLowerCase() || "he" == goog.LOCALE.substring(0, 2).toLowerCase() || "iw" == goog.LOCALE.substring(0, 2).toLowerCase() || "ps" == goog.LOCALE.substring(0, 2).toLowerCase() || "sd" == goog.LOCALE.substring(0, 2).toLowerCase() || "ug" == goog.LOCALE.substring(0, 2).toLowerCase() || "ur" == goog.LOCALE.substring(0, 2).toLowerCase() || "yi" == goog.LOCALE.substring(0, 2).toLowerCase()) && (2 == goog.LOCALE.length || "-" == goog.LOCALE.substring(2, 3) || "_" == goog.LOCALE.substring(2, 3)) || 3 <= goog.LOCALE.length && "ckb" == goog.LOCALE.substring(0, 3).toLowerCase() && (3 == goog.LOCALE.length || "-" == goog.LOCALE.substring(3, 4) || "_" == goog.LOCALE.substring(3, 4)) || 7 <= goog.LOCALE.length && ("-" == goog.LOCALE.substring(2, 3) || "_" == goog.LOCALE.substring(2, 3)) && ("adlm" == goog.LOCALE.substring(3, 7).toLowerCase() || "arab" == goog.LOCALE.substring(3, 7).toLowerCase() || "hebr" == goog.LOCALE.substring(3, 7).toLowerCase() || "nkoo" == goog.LOCALE.substring(3, 7).toLowerCase() || "rohg" == goog.LOCALE.substring(3, 7).toLowerCase() || "thaa" == goog.LOCALE.substring(3, 7).toLowerCase()) || 8 <= goog.LOCALE.length && ("-" == goog.LOCALE.substring(3, 4) || "_" == goog.LOCALE.substring(3, 4)) && ("adlm" == goog.LOCALE.substring(4, 8).toLowerCase() || "arab" == goog.LOCALE.substring(4, 8).toLowerCase() || "hebr" == goog.LOCALE.substring(4, 8).toLowerCase() || "nkoo" == goog.LOCALE.substring(4, 8).toLowerCase() || "rohg" == goog.LOCALE.substring(4, 8).toLowerCase() || "thaa" == goog.LOCALE.substring(4, 8).toLowerCase()), goog.i18n.bidi.Format = { LRE: "‪", RLE: "‫", PDF: "‬", LRM: "‎", RLM: "‏" }, goog.i18n.bidi.Dir = { LTR: 1, RTL: -1, NEUTRAL: 0 }, goog.i18n.bidi.RIGHT = "right", goog.i18n.bidi.LEFT = "left", goog.i18n.bidi.I18N_RIGHT = goog.i18n.bidi.IS_RTL ? goog.i18n.bidi.LEFT : goog.i18n.bidi.RIGHT, goog.i18n.bidi.I18N_LEFT = goog.i18n.bidi.IS_RTL ? goog.i18n.bidi.RIGHT : goog.i18n.bidi.LEFT, goog.i18n.bidi.toDir = function(e, t) {
    return "number" == typeof e ? 0 < e ? goog.i18n.bidi.Dir.LTR : 0 > e ? goog.i18n.bidi.Dir.RTL : t ? null : goog.i18n.bidi.Dir.NEUTRAL : null == e ? null : e ? goog.i18n.bidi.Dir.RTL : goog.i18n.bidi.Dir.LTR;
  }, goog.i18n.bidi.ltrChars_ = "A-Za-zÀ-ÖØ-öø-ʸ̀-֐ऀ-῿‎Ⰰ-\uD801\uD804-\uD839\uD83C-\uDBFF豈-﬜︀-﹯﻽-￿", goog.i18n.bidi.rtlChars_ = "֑-ۯۺ-ࣿ‏\uD802-\uD803\uD83A-\uD83Bיִ-﷿ﹰ-ﻼ", goog.i18n.bidi.htmlSkipReg_ = /<[^>]*>|&[^;]+;/g, goog.i18n.bidi.stripHtmlIfNeeded_ = function(e, t) {
    return t ? e.replace(goog.i18n.bidi.htmlSkipReg_, "") : e;
  }, goog.i18n.bidi.rtlCharReg_ = new RegExp("[" + goog.i18n.bidi.rtlChars_ + "]"), goog.i18n.bidi.ltrCharReg_ = new RegExp("[" + goog.i18n.bidi.ltrChars_ + "]"), goog.i18n.bidi.hasAnyRtl = function(e, t) {
    return goog.i18n.bidi.rtlCharReg_.test(goog.i18n.bidi.stripHtmlIfNeeded_(e, t));
  }, goog.i18n.bidi.hasRtlChar = goog.i18n.bidi.hasAnyRtl, goog.i18n.bidi.hasAnyLtr = function(e, t) {
    return goog.i18n.bidi.ltrCharReg_.test(goog.i18n.bidi.stripHtmlIfNeeded_(e, t));
  }, goog.i18n.bidi.ltrRe_ = new RegExp("^[" + goog.i18n.bidi.ltrChars_ + "]"), goog.i18n.bidi.rtlRe_ = new RegExp("^[" + goog.i18n.bidi.rtlChars_ + "]"), goog.i18n.bidi.isRtlChar = function(e) {
    return goog.i18n.bidi.rtlRe_.test(e);
  }, goog.i18n.bidi.isLtrChar = function(e) {
    return goog.i18n.bidi.ltrRe_.test(e);
  }, goog.i18n.bidi.isNeutralChar = function(e) {
    return !goog.i18n.bidi.isLtrChar(e) && !goog.i18n.bidi.isRtlChar(e);
  }, goog.i18n.bidi.ltrDirCheckRe_ = new RegExp("^[^" + goog.i18n.bidi.rtlChars_ + "]*[" + goog.i18n.bidi.ltrChars_ + "]"), goog.i18n.bidi.rtlDirCheckRe_ = new RegExp("^[^" + goog.i18n.bidi.ltrChars_ + "]*[" + goog.i18n.bidi.rtlChars_ + "]"), goog.i18n.bidi.startsWithRtl = function(e, t) {
    return goog.i18n.bidi.rtlDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(e, t));
  }, goog.i18n.bidi.isRtlText = goog.i18n.bidi.startsWithRtl, goog.i18n.bidi.startsWithLtr = function(e, t) {
    return goog.i18n.bidi.ltrDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(e, t));
  }, goog.i18n.bidi.isLtrText = goog.i18n.bidi.startsWithLtr, goog.i18n.bidi.isRequiredLtrRe_ = /^http:\/\/.*/, goog.i18n.bidi.isNeutralText = function(e, t) {
    return e = goog.i18n.bidi.stripHtmlIfNeeded_(e, t), goog.i18n.bidi.isRequiredLtrRe_.test(e) || !goog.i18n.bidi.hasAnyLtr(e) && !goog.i18n.bidi.hasAnyRtl(e);
  }, goog.i18n.bidi.ltrExitDirCheckRe_ = new RegExp("[" + goog.i18n.bidi.ltrChars_ + "][^" + goog.i18n.bidi.rtlChars_ + "]*$"), goog.i18n.bidi.rtlExitDirCheckRe_ = new RegExp("[" + goog.i18n.bidi.rtlChars_ + "][^" + goog.i18n.bidi.ltrChars_ + "]*$"), goog.i18n.bidi.endsWithLtr = function(e, t) {
    return goog.i18n.bidi.ltrExitDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(e, t));
  }, goog.i18n.bidi.isLtrExitText = goog.i18n.bidi.endsWithLtr, goog.i18n.bidi.endsWithRtl = function(e, t) {
    return goog.i18n.bidi.rtlExitDirCheckRe_.test(goog.i18n.bidi.stripHtmlIfNeeded_(e, t));
  }, goog.i18n.bidi.isRtlExitText = goog.i18n.bidi.endsWithRtl, goog.i18n.bidi.rtlLocalesRe_ = /^(ar|ckb|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|.*[-_](Adlm|Arab|Hebr|Nkoo|Rohg|Thaa))(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)/i, goog.i18n.bidi.isRtlLanguage = function(e) {
    return goog.i18n.bidi.rtlLocalesRe_.test(e);
  }, goog.i18n.bidi.bracketGuardTextRe_ = /(\(.*?\)+)|(\[.*?\]+)|(\{.*?\}+)|(<.*?>+)/g, goog.i18n.bidi.guardBracketInText = function(e, t) {
    return t = (void 0 === t ? goog.i18n.bidi.hasAnyRtl(e) : t) ? goog.i18n.bidi.Format.RLM : goog.i18n.bidi.Format.LRM, e.replace(goog.i18n.bidi.bracketGuardTextRe_, t + "$&" + t);
  }, goog.i18n.bidi.enforceRtlInHtml = function(e) {
    return "<" == e.charAt(0) ? e.replace(/<\w+/, "$& dir=rtl") : "\n<span dir=rtl>" + e + "</span>";
  }, goog.i18n.bidi.enforceRtlInText = function(e) {
    return goog.i18n.bidi.Format.RLE + e + goog.i18n.bidi.Format.PDF;
  }, goog.i18n.bidi.enforceLtrInHtml = function(e) {
    return "<" == e.charAt(0) ? e.replace(/<\w+/, "$& dir=ltr") : "\n<span dir=ltr>" + e + "</span>";
  }, goog.i18n.bidi.enforceLtrInText = function(e) {
    return goog.i18n.bidi.Format.LRE + e + goog.i18n.bidi.Format.PDF;
  }, goog.i18n.bidi.dimensionsRe_ = /:\s*([.\d][.\w]*)\s+([.\d][.\w]*)\s+([.\d][.\w]*)\s+([.\d][.\w]*)/g, goog.i18n.bidi.leftRe_ = /left/gi, goog.i18n.bidi.rightRe_ = /right/gi, goog.i18n.bidi.tempRe_ = /%%%%/g, goog.i18n.bidi.mirrorCSS = function(e) {
    return e.replace(goog.i18n.bidi.dimensionsRe_, ":$1 $4 $3 $2").replace(goog.i18n.bidi.leftRe_, "%%%%").replace(goog.i18n.bidi.rightRe_, goog.i18n.bidi.LEFT).replace(goog.i18n.bidi.tempRe_, goog.i18n.bidi.RIGHT);
  }, goog.i18n.bidi.doubleQuoteSubstituteRe_ = /([\u0591-\u05f2])"/g, goog.i18n.bidi.singleQuoteSubstituteRe_ = /([\u0591-\u05f2])'/g, goog.i18n.bidi.normalizeHebrewQuote = function(e) {
    return e.replace(goog.i18n.bidi.doubleQuoteSubstituteRe_, "$1״").replace(goog.i18n.bidi.singleQuoteSubstituteRe_, "$1׳");
  }, goog.i18n.bidi.wordSeparatorRe_ = /\s+/, goog.i18n.bidi.hasNumeralsRe_ = /[\d\u06f0-\u06f9]/, goog.i18n.bidi.rtlDetectionThreshold_ = 0.4, goog.i18n.bidi.estimateDirection = function(e, t) {
    var r = 0, o = 0, i = false;
    for (e = goog.i18n.bidi.stripHtmlIfNeeded_(e, t).split(goog.i18n.bidi.wordSeparatorRe_), t = 0; t < e.length; t++) {
      var a2 = e[t];
      goog.i18n.bidi.startsWithRtl(a2) ? (r++, o++) : goog.i18n.bidi.isRequiredLtrRe_.test(a2) ? i = true : goog.i18n.bidi.hasAnyLtr(a2) ? o++ : goog.i18n.bidi.hasNumeralsRe_.test(a2) && (i = true);
    }
    return 0 == o ? i ? goog.i18n.bidi.Dir.LTR : goog.i18n.bidi.Dir.NEUTRAL : r / o > goog.i18n.bidi.rtlDetectionThreshold_ ? goog.i18n.bidi.Dir.RTL : goog.i18n.bidi.Dir.LTR;
  }, goog.i18n.bidi.detectRtlDirectionality = function(e, t) {
    return goog.i18n.bidi.estimateDirection(e, t) == goog.i18n.bidi.Dir.RTL;
  }, goog.i18n.bidi.setElementDirAndAlign = function(e, t) {
    e && (t = goog.i18n.bidi.toDir(t)) && (e.style.textAlign = t == goog.i18n.bidi.Dir.RTL ? goog.i18n.bidi.RIGHT : goog.i18n.bidi.LEFT, e.dir = t == goog.i18n.bidi.Dir.RTL ? "rtl" : "ltr");
  }, goog.i18n.bidi.setElementDirByTextDirectionality = function(e, t) {
    switch (goog.i18n.bidi.estimateDirection(t)) {
      case goog.i18n.bidi.Dir.LTR:
        e.dir = "ltr";
        break;
      case goog.i18n.bidi.Dir.RTL:
        e.dir = "rtl";
        break;
      default:
        e.removeAttribute("dir");
    }
  }, goog.i18n.bidi.DirectionalString = function() {
  }, goog.html.TrustedResourceUrl = function(e, t) {
    this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_ = e === goog.html.TrustedResourceUrl.CONSTRUCTOR_TOKEN_PRIVATE_ && t || "", this.TRUSTED_RESOURCE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
  }, goog.html.TrustedResourceUrl.prototype.implementsGoogStringTypedString = true, goog.html.TrustedResourceUrl.prototype.getTypedStringValue = function() {
    return this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_.toString();
  }, goog.html.TrustedResourceUrl.prototype.implementsGoogI18nBidiDirectionalString = true, goog.html.TrustedResourceUrl.prototype.getDirection = function() {
    return goog.i18n.bidi.Dir.LTR;
  }, goog.html.TrustedResourceUrl.prototype.cloneWithParams = function(e, t) {
    var r = goog.html.TrustedResourceUrl.unwrap(this), o = (r = goog.html.TrustedResourceUrl.URL_PARAM_PARSER_.exec(r))[3] || "";
    return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(r[1] + goog.html.TrustedResourceUrl.stringifyParams_("?", r[2] || "", e) + goog.html.TrustedResourceUrl.stringifyParams_("#", o, t));
  }, goog.DEBUG && (goog.html.TrustedResourceUrl.prototype.toString = function() {
    return "TrustedResourceUrl{" + this.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_ + "}";
  }), goog.html.TrustedResourceUrl.unwrap = function(e) {
    return goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(e).toString();
  }, goog.html.TrustedResourceUrl.unwrapTrustedScriptURL = function(e) {
    return e instanceof goog.html.TrustedResourceUrl && e.constructor === goog.html.TrustedResourceUrl && e.TRUSTED_RESOURCE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ ? e.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue_ : (goog.asserts.fail("expected object of type TrustedResourceUrl, got '" + e + "' of type " + goog.typeOf(e)), "type_error:TrustedResourceUrl");
  }, goog.html.TrustedResourceUrl.format = function(e, t) {
    var r = goog.string.Const.unwrap(e);
    if (!goog.html.TrustedResourceUrl.BASE_URL_.test(r)) throw Error("Invalid TrustedResourceUrl format: " + r);
    return e = r.replace(goog.html.TrustedResourceUrl.FORMAT_MARKER_, (function(e2, o) {
      if (!Object.prototype.hasOwnProperty.call(t, o)) throw Error('Found marker, "' + o + '", in format string, "' + r + '", but no valid label mapping found in args: ' + JSON.stringify(t));
      return (e2 = t[o]) instanceof goog.string.Const ? goog.string.Const.unwrap(e2) : encodeURIComponent(String(e2));
    })), goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(e);
  }, goog.html.TrustedResourceUrl.FORMAT_MARKER_ = /%{(\w+)}/g, goog.html.TrustedResourceUrl.BASE_URL_ = /^((https:)?\/\/[0-9a-z.:[\]-]+\/|\/[^/\\]|[^:/\\%]+\/|[^:/\\%]*[?#]|about:blank#)/i, goog.html.TrustedResourceUrl.URL_PARAM_PARSER_ = /^([^?#]*)(\?[^#]*)?(#[\s\S]*)?/, goog.html.TrustedResourceUrl.formatWithParams = function(e, t, r, o) {
    return goog.html.TrustedResourceUrl.format(e, t).cloneWithParams(r, o);
  }, goog.html.TrustedResourceUrl.fromConstant = function(e) {
    return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(goog.string.Const.unwrap(e));
  }, goog.html.TrustedResourceUrl.fromConstants = function(e) {
    for (var t = "", r = 0; r < e.length; r++) t += goog.string.Const.unwrap(e[r]);
    return goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(t);
  }, goog.html.TrustedResourceUrl.fromSafeScript = function(e) {
    return e = goog.fs.blob.getBlobWithProperties([goog.html.SafeScript.unwrap(e)], "text/javascript"), e = goog.fs.url.createObjectUrl(e), goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(e);
  }, goog.html.TrustedResourceUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {}, goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse = function(e) {
    return e = goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY ? goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY.createScriptURL(e) : e, new goog.html.TrustedResourceUrl(goog.html.TrustedResourceUrl.CONSTRUCTOR_TOKEN_PRIVATE_, e);
  }, goog.html.TrustedResourceUrl.stringifyParams_ = function(e, t, r) {
    if (null == r) return t;
    if ("string" == typeof r) return r ? e + encodeURIComponent(r) : "";
    for (var o in r) {
      var i = r[o];
      i = Array.isArray(i) ? i : [i];
      for (var a2 = 0; a2 < i.length; a2++) {
        var n = i[a2];
        null != n && (t || (t = e), t += (t.length > e.length ? "&" : "") + encodeURIComponent(o) + "=" + encodeURIComponent(String(n)));
      }
    }
    return t;
  }, goog.html.TrustedResourceUrl.CONSTRUCTOR_TOKEN_PRIVATE_ = {}, goog.string.internal = {}, goog.string.internal.startsWith = function(e, t) {
    return 0 == e.lastIndexOf(t, 0);
  }, goog.string.internal.endsWith = function(e, t) {
    var r = e.length - t.length;
    return 0 <= r && e.indexOf(t, r) == r;
  }, goog.string.internal.caseInsensitiveStartsWith = function(e, t) {
    return 0 == goog.string.internal.caseInsensitiveCompare(t, e.substr(0, t.length));
  }, goog.string.internal.caseInsensitiveEndsWith = function(e, t) {
    return 0 == goog.string.internal.caseInsensitiveCompare(t, e.substr(e.length - t.length, t.length));
  }, goog.string.internal.caseInsensitiveEquals = function(e, t) {
    return e.toLowerCase() == t.toLowerCase();
  }, goog.string.internal.isEmptyOrWhitespace = function(e) {
    return /^[\s\xa0]*$/.test(e);
  }, goog.string.internal.trim = goog.TRUSTED_SITE && String.prototype.trim ? function(e) {
    return e.trim();
  } : function(e) {
    return /^[\s\xa0]*([\s\S]*?)[\s\xa0]*$/.exec(e)[1];
  }, goog.string.internal.caseInsensitiveCompare = function(e, t) {
    return (e = String(e).toLowerCase()) < (t = String(t).toLowerCase()) ? -1 : e == t ? 0 : 1;
  }, goog.string.internal.newLineToBr = function(e, t) {
    return e.replace(/(\r\n|\r|\n)/g, t ? "<br />" : "<br>");
  }, goog.string.internal.htmlEscape = function(e, t) {
    if (t) e = e.replace(goog.string.internal.AMP_RE_, "&amp;").replace(goog.string.internal.LT_RE_, "&lt;").replace(goog.string.internal.GT_RE_, "&gt;").replace(goog.string.internal.QUOT_RE_, "&quot;").replace(goog.string.internal.SINGLE_QUOTE_RE_, "&#39;").replace(goog.string.internal.NULL_RE_, "&#0;");
    else {
      if (!goog.string.internal.ALL_RE_.test(e)) return e;
      -1 != e.indexOf("&") && (e = e.replace(goog.string.internal.AMP_RE_, "&amp;")), -1 != e.indexOf("<") && (e = e.replace(goog.string.internal.LT_RE_, "&lt;")), -1 != e.indexOf(">") && (e = e.replace(goog.string.internal.GT_RE_, "&gt;")), -1 != e.indexOf('"') && (e = e.replace(goog.string.internal.QUOT_RE_, "&quot;")), -1 != e.indexOf("'") && (e = e.replace(goog.string.internal.SINGLE_QUOTE_RE_, "&#39;")), -1 != e.indexOf("\0") && (e = e.replace(goog.string.internal.NULL_RE_, "&#0;"));
    }
    return e;
  }, goog.string.internal.AMP_RE_ = /&/g, goog.string.internal.LT_RE_ = /</g, goog.string.internal.GT_RE_ = />/g, goog.string.internal.QUOT_RE_ = /"/g, goog.string.internal.SINGLE_QUOTE_RE_ = /'/g, goog.string.internal.NULL_RE_ = /\x00/g, goog.string.internal.ALL_RE_ = /[\x00&<>"']/, goog.string.internal.whitespaceEscape = function(e, t) {
    return goog.string.internal.newLineToBr(e.replace(/  /g, " &#160;"), t);
  }, goog.string.internal.contains = function(e, t) {
    return -1 != e.indexOf(t);
  }, goog.string.internal.caseInsensitiveContains = function(e, t) {
    return goog.string.internal.contains(e.toLowerCase(), t.toLowerCase());
  }, goog.string.internal.compareVersions = function(e, t) {
    var r = 0;
    e = goog.string.internal.trim(String(e)).split("."), t = goog.string.internal.trim(String(t)).split(".");
    for (var o = Math.max(e.length, t.length), i = 0; 0 == r && i < o; i++) {
      var a2 = e[i] || "", n = t[i] || "";
      do {
        if (a2 = /(\d*)(\D*)(.*)/.exec(a2) || ["", "", "", ""], n = /(\d*)(\D*)(.*)/.exec(n) || ["", "", "", ""], 0 == a2[0].length && 0 == n[0].length) break;
        r = 0 == a2[1].length ? 0 : parseInt(a2[1], 10);
        var s = 0 == n[1].length ? 0 : parseInt(n[1], 10);
        r = goog.string.internal.compareElements_(r, s) || goog.string.internal.compareElements_(0 == a2[2].length, 0 == n[2].length) || goog.string.internal.compareElements_(a2[2], n[2]), a2 = a2[3], n = n[3];
      } while (0 == r);
    }
    return r;
  }, goog.string.internal.compareElements_ = function(e, t) {
    return e < t ? -1 : e > t ? 1 : 0;
  }, goog.html.SafeUrl = function(e, t) {
    this.privateDoNotAccessOrElseSafeUrlWrappedValue_ = e === goog.html.SafeUrl.CONSTRUCTOR_TOKEN_PRIVATE_ && t || "", this.SAFE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
  }, goog.html.SafeUrl.INNOCUOUS_STRING = "about:invalid#zClosurez", goog.html.SafeUrl.prototype.implementsGoogStringTypedString = true, goog.html.SafeUrl.prototype.getTypedStringValue = function() {
    return this.privateDoNotAccessOrElseSafeUrlWrappedValue_.toString();
  }, goog.html.SafeUrl.prototype.implementsGoogI18nBidiDirectionalString = true, goog.html.SafeUrl.prototype.getDirection = function() {
    return goog.i18n.bidi.Dir.LTR;
  }, goog.DEBUG && (goog.html.SafeUrl.prototype.toString = function() {
    return "SafeUrl{" + this.privateDoNotAccessOrElseSafeUrlWrappedValue_ + "}";
  }), goog.html.SafeUrl.unwrap = function(e) {
    return e instanceof goog.html.SafeUrl && e.constructor === goog.html.SafeUrl && e.SAFE_URL_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ ? e.privateDoNotAccessOrElseSafeUrlWrappedValue_ : (goog.asserts.fail("expected object of type SafeUrl, got '" + e + "' of type " + goog.typeOf(e)), "type_error:SafeUrl");
  }, goog.html.SafeUrl.fromConstant = function(e) {
    return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(goog.string.Const.unwrap(e));
  }, goog.html.SAFE_MIME_TYPE_PATTERN_ = /^(?:audio\/(?:3gpp2|3gpp|aac|L16|midi|mp3|mp4|mpeg|oga|ogg|opus|x-m4a|x-matroska|x-wav|wav|webm)|image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp|x-icon)|text\/csv|video\/(?:mpeg|mp4|ogg|webm|quicktime|x-matroska))(?:;\w+=(?:\w+|"[\w;,= ]+"))*$/i, goog.html.SafeUrl.isSafeMimeType = function(e) {
    return goog.html.SAFE_MIME_TYPE_PATTERN_.test(e);
  }, goog.html.SafeUrl.fromBlob = function(e) {
    return e = goog.html.SafeUrl.isSafeMimeType(e.type) ? goog.fs.url.createObjectUrl(e) : goog.html.SafeUrl.INNOCUOUS_STRING, goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e);
  }, goog.html.SafeUrl.fromMediaSource = function(e) {
    return goog.asserts.assert("MediaSource" in goog.global, "No support for MediaSource"), e = e instanceof MediaSource ? goog.fs.url.createObjectUrl(e) : goog.html.SafeUrl.INNOCUOUS_STRING, goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e);
  }, goog.html.DATA_URL_PATTERN_ = /^data:(.*);base64,[a-z0-9+\/]+=*$/i, goog.html.SafeUrl.fromDataUrl = function(e) {
    var t = (e = e.replace(/(%0A|%0D)/g, "")).match(goog.html.DATA_URL_PATTERN_);
    return t = t && goog.html.SafeUrl.isSafeMimeType(t[1]), goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(t ? e : goog.html.SafeUrl.INNOCUOUS_STRING);
  }, goog.html.SafeUrl.fromTelUrl = function(e) {
    return goog.string.internal.caseInsensitiveStartsWith(e, "tel:") || (e = goog.html.SafeUrl.INNOCUOUS_STRING), goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e);
  }, goog.html.SIP_URL_PATTERN_ = /^sip[s]?:[+a-z0-9_.!$%&'*\/=^`{|}~-]+@([a-z0-9-]+\.)+[a-z0-9]{2,63}$/i, goog.html.SafeUrl.fromSipUrl = function(e) {
    return goog.html.SIP_URL_PATTERN_.test(decodeURIComponent(e)) || (e = goog.html.SafeUrl.INNOCUOUS_STRING), goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e);
  }, goog.html.SafeUrl.fromFacebookMessengerUrl = function(e) {
    return goog.string.internal.caseInsensitiveStartsWith(e, "fb-messenger://share") || (e = goog.html.SafeUrl.INNOCUOUS_STRING), goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e);
  }, goog.html.SafeUrl.fromWhatsAppUrl = function(e) {
    return goog.string.internal.caseInsensitiveStartsWith(e, "whatsapp://send") || (e = goog.html.SafeUrl.INNOCUOUS_STRING), goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e);
  }, goog.html.SafeUrl.fromSmsUrl = function(e) {
    return goog.string.internal.caseInsensitiveStartsWith(e, "sms:") && goog.html.SafeUrl.isSmsUrlBodyValid_(e) || (e = goog.html.SafeUrl.INNOCUOUS_STRING), goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e);
  }, goog.html.SafeUrl.isSmsUrlBodyValid_ = function(e) {
    var t = e.indexOf("#");
    if (0 < t && (e = e.substring(0, t)), !(t = e.match(/[?&]body=/gi))) return true;
    if (1 < t.length) return false;
    if (!(e = e.match(/[?&]body=([^&]*)/)[1])) return true;
    try {
      decodeURIComponent(e);
    } catch (e2) {
      return false;
    }
    return /^(?:[a-z0-9\-_.~]|%[0-9a-f]{2})+$/i.test(e);
  }, goog.html.SafeUrl.fromSshUrl = function(e) {
    return goog.string.internal.caseInsensitiveStartsWith(e, "ssh://") || (e = goog.html.SafeUrl.INNOCUOUS_STRING), goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e);
  }, goog.html.SafeUrl.sanitizeChromeExtensionUrl = function(e, t) {
    return goog.html.SafeUrl.sanitizeExtensionUrl_(/^chrome-extension:\/\/([^\/]+)\//, e, t);
  }, goog.html.SafeUrl.sanitizeFirefoxExtensionUrl = function(e, t) {
    return goog.html.SafeUrl.sanitizeExtensionUrl_(/^moz-extension:\/\/([^\/]+)\//, e, t);
  }, goog.html.SafeUrl.sanitizeEdgeExtensionUrl = function(e, t) {
    return goog.html.SafeUrl.sanitizeExtensionUrl_(/^ms-browser-extension:\/\/([^\/]+)\//, e, t);
  }, goog.html.SafeUrl.sanitizeExtensionUrl_ = function(e, t, r) {
    return (e = e.exec(t)) ? (e = e[1], -1 == (r instanceof goog.string.Const ? [goog.string.Const.unwrap(r)] : r.map((function(e2) {
      return goog.string.Const.unwrap(e2);
    }))).indexOf(e) && (t = goog.html.SafeUrl.INNOCUOUS_STRING)) : t = goog.html.SafeUrl.INNOCUOUS_STRING, goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(t);
  }, goog.html.SafeUrl.fromTrustedResourceUrl = function(e) {
    return goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(goog.html.TrustedResourceUrl.unwrap(e));
  }, goog.html.SAFE_URL_PATTERN_ = /^(?:(?:https?|mailto|ftp):|[^:/?#]*(?:[/?#]|$))/i, goog.html.SafeUrl.SAFE_URL_PATTERN = goog.html.SAFE_URL_PATTERN_, goog.html.SafeUrl.sanitize = function(e) {
    return e instanceof goog.html.SafeUrl ? e : (e = "object" == typeof e && e.implementsGoogStringTypedString ? e.getTypedStringValue() : String(e), goog.html.SAFE_URL_PATTERN_.test(e) || (e = goog.html.SafeUrl.INNOCUOUS_STRING), goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e));
  }, goog.html.SafeUrl.sanitizeAssertUnchanged = function(e, t) {
    return e instanceof goog.html.SafeUrl ? e : (e = "object" == typeof e && e.implementsGoogStringTypedString ? e.getTypedStringValue() : String(e), t && /^data:/i.test(e) && (t = goog.html.SafeUrl.fromDataUrl(e)).getTypedStringValue() == e ? t : (goog.asserts.assert(goog.html.SAFE_URL_PATTERN_.test(e), "%s does not match the safe URL pattern", e) || (e = goog.html.SafeUrl.INNOCUOUS_STRING), goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(e)));
  }, goog.html.SafeUrl.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {}, goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse = function(e) {
    return new goog.html.SafeUrl(goog.html.SafeUrl.CONSTRUCTOR_TOKEN_PRIVATE_, e);
  }, goog.html.SafeUrl.ABOUT_BLANK = goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse("about:blank"), goog.html.SafeUrl.CONSTRUCTOR_TOKEN_PRIVATE_ = {}, goog.html.SafeStyle = function() {
    this.privateDoNotAccessOrElseSafeStyleWrappedValue_ = "", this.SAFE_STYLE_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
  }, goog.html.SafeStyle.prototype.implementsGoogStringTypedString = true, goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {}, goog.html.SafeStyle.fromConstant = function(e) {
    return 0 === (e = goog.string.Const.unwrap(e)).length ? goog.html.SafeStyle.EMPTY : (goog.asserts.assert(goog.string.internal.endsWith(e, ";"), "Last character of style string is not ';': " + e), goog.asserts.assert(goog.string.internal.contains(e, ":"), `Style string must contain at least one ':', to specify a "name: value" pair: ` + e), goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(e));
  }, goog.html.SafeStyle.prototype.getTypedStringValue = function() {
    return this.privateDoNotAccessOrElseSafeStyleWrappedValue_;
  }, goog.DEBUG && (goog.html.SafeStyle.prototype.toString = function() {
    return "SafeStyle{" + this.privateDoNotAccessOrElseSafeStyleWrappedValue_ + "}";
  }), goog.html.SafeStyle.unwrap = function(e) {
    return e instanceof goog.html.SafeStyle && e.constructor === goog.html.SafeStyle && e.SAFE_STYLE_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.SafeStyle.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ ? e.privateDoNotAccessOrElseSafeStyleWrappedValue_ : (goog.asserts.fail("expected object of type SafeStyle, got '" + e + "' of type " + goog.typeOf(e)), "type_error:SafeStyle");
  }, goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse = function(e) {
    return new goog.html.SafeStyle().initSecurityPrivateDoNotAccessOrElse_(e);
  }, goog.html.SafeStyle.prototype.initSecurityPrivateDoNotAccessOrElse_ = function(e) {
    return this.privateDoNotAccessOrElseSafeStyleWrappedValue_ = e, this;
  }, goog.html.SafeStyle.EMPTY = goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(""), goog.html.SafeStyle.INNOCUOUS_STRING = "zClosurez", goog.html.SafeStyle.create = function(e) {
    var t, r = "";
    for (t in e) {
      if (!/^[-_a-zA-Z0-9]+$/.test(t)) throw Error("Name allows only [-_a-zA-Z0-9], got: " + t);
      var o = e[t];
      null != o && (r += t + ":" + (o = Array.isArray(o) ? goog.array.map(o, goog.html.SafeStyle.sanitizePropertyValue_).join(" ") : goog.html.SafeStyle.sanitizePropertyValue_(o)) + ";");
    }
    return r ? goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(r) : goog.html.SafeStyle.EMPTY;
  }, goog.html.SafeStyle.sanitizePropertyValue_ = function(e) {
    if (e instanceof goog.html.SafeUrl) return 'url("' + goog.html.SafeUrl.unwrap(e).replace(/</g, "%3c").replace(/[\\"]/g, "\\$&") + '")';
    if (e = e instanceof goog.string.Const ? goog.string.Const.unwrap(e) : goog.html.SafeStyle.sanitizePropertyValueString_(String(e)), /[{;}]/.test(e)) throw new goog.asserts.AssertionError("Value does not allow [{;}], got: %s.", [e]);
    return e;
  }, goog.html.SafeStyle.sanitizePropertyValueString_ = function(e) {
    var t = e.replace(goog.html.SafeStyle.FUNCTIONS_RE_, "$1").replace(goog.html.SafeStyle.FUNCTIONS_RE_, "$1").replace(goog.html.SafeStyle.URL_RE_, "url");
    return goog.html.SafeStyle.VALUE_RE_.test(t) ? goog.html.SafeStyle.COMMENT_RE_.test(e) ? (goog.asserts.fail("String value disallows comments, got: " + e), goog.html.SafeStyle.INNOCUOUS_STRING) : goog.html.SafeStyle.hasBalancedQuotes_(e) ? goog.html.SafeStyle.hasBalancedSquareBrackets_(e) ? goog.html.SafeStyle.sanitizeUrl_(e) : (goog.asserts.fail("String value requires balanced square brackets and one identifier per pair of brackets, got: " + e), goog.html.SafeStyle.INNOCUOUS_STRING) : (goog.asserts.fail("String value requires balanced quotes, got: " + e), goog.html.SafeStyle.INNOCUOUS_STRING) : (goog.asserts.fail("String value allows only " + goog.html.SafeStyle.VALUE_ALLOWED_CHARS_ + " and simple functions, got: " + e), goog.html.SafeStyle.INNOCUOUS_STRING);
  }, goog.html.SafeStyle.hasBalancedQuotes_ = function(e) {
    for (var t = true, r = true, o = 0; o < e.length; o++) {
      var i = e.charAt(o);
      "'" == i && r ? t = !t : '"' == i && t && (r = !r);
    }
    return t && r;
  }, goog.html.SafeStyle.hasBalancedSquareBrackets_ = function(e) {
    for (var t = true, r = /^[-_a-zA-Z0-9]$/, o = 0; o < e.length; o++) {
      var i = e.charAt(o);
      if ("]" == i) {
        if (t) return false;
        t = true;
      } else if ("[" == i) {
        if (!t) return false;
        t = false;
      } else if (!t && !r.test(i)) return false;
    }
    return t;
  }, goog.html.SafeStyle.VALUE_ALLOWED_CHARS_ = `[-,."'%_!# a-zA-Z0-9\\[\\]]`, goog.html.SafeStyle.VALUE_RE_ = new RegExp("^" + goog.html.SafeStyle.VALUE_ALLOWED_CHARS_ + "+$"), goog.html.SafeStyle.URL_RE_ = /\b(url\([ \t\n]*)('[ -&(-\[\]-~]*'|"[ !#-\[\]-~]*"|[!#-&*-\[\]-~]*)([ \t\n]*\))/g, goog.html.SafeStyle.ALLOWED_FUNCTIONS_ = "calc cubic-bezier fit-content hsl hsla linear-gradient matrix minmax repeat rgb rgba (rotate|scale|translate)(X|Y|Z|3d)?".split(" "), goog.html.SafeStyle.FUNCTIONS_RE_ = new RegExp("\\b(" + goog.html.SafeStyle.ALLOWED_FUNCTIONS_.join("|") + ")\\([-+*/0-9a-z.%\\[\\], ]+\\)", "g"), goog.html.SafeStyle.COMMENT_RE_ = /\/\*/, goog.html.SafeStyle.sanitizeUrl_ = function(e) {
    return e.replace(goog.html.SafeStyle.URL_RE_, (function(e2, t, r, o) {
      var i = "";
      return r = r.replace(/^(['"])(.*)\1$/, (function(e3, t2, r2) {
        return i = t2, r2;
      })), e2 = goog.html.SafeUrl.sanitize(r).getTypedStringValue(), t + i + e2 + i + o;
    }));
  }, goog.html.SafeStyle.concat = function(e) {
    var t = "", r = function(e2) {
      Array.isArray(e2) ? goog.array.forEach(e2, r) : t += goog.html.SafeStyle.unwrap(e2);
    };
    return goog.array.forEach(arguments, r), t ? goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(t) : goog.html.SafeStyle.EMPTY;
  }, goog.html.SafeStyleSheet = function() {
    this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ = "", this.SAFE_STYLE_SHEET_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_;
  }, goog.html.SafeStyleSheet.prototype.implementsGoogStringTypedString = true, goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {}, goog.html.SafeStyleSheet.createRule = function(e, t) {
    if (goog.string.internal.contains(e, "<")) throw Error("Selector does not allow '<', got: " + e);
    var r = e.replace(/('|")((?!\1)[^\r\n\f\\]|\\[\s\S])*\1/g, "");
    if (!/^[-_a-zA-Z0-9#.:* ,>+~[\]()=^$|]+$/.test(r)) throw Error("Selector allows only [-_a-zA-Z0-9#.:* ,>+~[\\]()=^$|] and strings, got: " + e);
    if (!goog.html.SafeStyleSheet.hasBalancedBrackets_(r)) throw Error("() and [] in selector must be balanced, got: " + e);
    return t instanceof goog.html.SafeStyle || (t = goog.html.SafeStyle.create(t)), e = e + "{" + goog.html.SafeStyle.unwrap(t).replace(/</g, "\\3C ") + "}", goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(e);
  }, goog.html.SafeStyleSheet.hasBalancedBrackets_ = function(e) {
    for (var t = { "(": ")", "[": "]" }, r = [], o = 0; o < e.length; o++) {
      var i = e[o];
      if (t[i]) r.push(t[i]);
      else if (goog.object.contains(t, i) && r.pop() != i) return false;
    }
    return 0 == r.length;
  }, goog.html.SafeStyleSheet.concat = function(e) {
    var t = "", r = function(e2) {
      Array.isArray(e2) ? goog.array.forEach(e2, r) : t += goog.html.SafeStyleSheet.unwrap(e2);
    };
    return goog.array.forEach(arguments, r), goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(t);
  }, goog.html.SafeStyleSheet.fromConstant = function(e) {
    return 0 === (e = goog.string.Const.unwrap(e)).length ? goog.html.SafeStyleSheet.EMPTY : (goog.asserts.assert(!goog.string.internal.contains(e, "<"), "Forbidden '<' character in style sheet string: " + e), goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(e));
  }, goog.html.SafeStyleSheet.prototype.getTypedStringValue = function() {
    return this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_;
  }, goog.DEBUG && (goog.html.SafeStyleSheet.prototype.toString = function() {
    return "SafeStyleSheet{" + this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ + "}";
  }), goog.html.SafeStyleSheet.unwrap = function(e) {
    return e instanceof goog.html.SafeStyleSheet && e.constructor === goog.html.SafeStyleSheet && e.SAFE_STYLE_SHEET_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.SafeStyleSheet.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ ? e.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ : (goog.asserts.fail("expected object of type SafeStyleSheet, got '" + e + "' of type " + goog.typeOf(e)), "type_error:SafeStyleSheet");
  }, goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse = function(e) {
    return new goog.html.SafeStyleSheet().initSecurityPrivateDoNotAccessOrElse_(e);
  }, goog.html.SafeStyleSheet.prototype.initSecurityPrivateDoNotAccessOrElse_ = function(e) {
    return this.privateDoNotAccessOrElseSafeStyleSheetWrappedValue_ = e, this;
  }, goog.html.SafeStyleSheet.EMPTY = goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(""), goog.labs = {}, goog.labs.userAgent = {}, goog.labs.userAgent.util = {}, goog.labs.userAgent.util.getNativeUserAgentString_ = function() {
    var e = goog.labs.userAgent.util.getNavigator_();
    return e && (e = e.userAgent) ? e : "";
  }, goog.labs.userAgent.util.getNavigator_ = function() {
    return goog.global.navigator;
  }, goog.labs.userAgent.util.userAgent_ = goog.labs.userAgent.util.getNativeUserAgentString_(), goog.labs.userAgent.util.setUserAgent = function(e) {
    goog.labs.userAgent.util.userAgent_ = e || goog.labs.userAgent.util.getNativeUserAgentString_();
  }, goog.labs.userAgent.util.getUserAgent = function() {
    return goog.labs.userAgent.util.userAgent_;
  }, goog.labs.userAgent.util.matchUserAgent = function(e) {
    var t = goog.labs.userAgent.util.getUserAgent();
    return goog.string.internal.contains(t, e);
  }, goog.labs.userAgent.util.matchUserAgentIgnoreCase = function(e) {
    var t = goog.labs.userAgent.util.getUserAgent();
    return goog.string.internal.caseInsensitiveContains(t, e);
  }, goog.labs.userAgent.util.extractVersionTuples = function(e) {
    for (var t, r = /(\w[\w ]+)\/([^\s]+)\s*(?:\((.*?)\))?/g, o = []; t = r.exec(e); ) o.push([t[1], t[2], t[3] || void 0]);
    return o;
  }, goog.labs.userAgent.browser = {}, goog.labs.userAgent.browser.matchOpera_ = function() {
    return goog.labs.userAgent.util.matchUserAgent("Opera");
  }, goog.labs.userAgent.browser.matchIE_ = function() {
    return goog.labs.userAgent.util.matchUserAgent("Trident") || goog.labs.userAgent.util.matchUserAgent("MSIE");
  }, goog.labs.userAgent.browser.matchEdgeHtml_ = function() {
    return goog.labs.userAgent.util.matchUserAgent("Edge");
  }, goog.labs.userAgent.browser.matchEdgeChromium_ = function() {
    return goog.labs.userAgent.util.matchUserAgent("Edg/");
  }, goog.labs.userAgent.browser.matchOperaChromium_ = function() {
    return goog.labs.userAgent.util.matchUserAgent("OPR");
  }, goog.labs.userAgent.browser.matchFirefox_ = function() {
    return goog.labs.userAgent.util.matchUserAgent("Firefox") || goog.labs.userAgent.util.matchUserAgent("FxiOS");
  }, goog.labs.userAgent.browser.matchSafari_ = function() {
    return goog.labs.userAgent.util.matchUserAgent("Safari") && !(goog.labs.userAgent.browser.matchChrome_() || goog.labs.userAgent.browser.matchCoast_() || goog.labs.userAgent.browser.matchOpera_() || goog.labs.userAgent.browser.matchEdgeHtml_() || goog.labs.userAgent.browser.matchEdgeChromium_() || goog.labs.userAgent.browser.matchOperaChromium_() || goog.labs.userAgent.browser.matchFirefox_() || goog.labs.userAgent.browser.isSilk() || goog.labs.userAgent.util.matchUserAgent("Android"));
  }, goog.labs.userAgent.browser.matchCoast_ = function() {
    return goog.labs.userAgent.util.matchUserAgent("Coast");
  }, goog.labs.userAgent.browser.matchIosWebview_ = function() {
    return (goog.labs.userAgent.util.matchUserAgent("iPad") || goog.labs.userAgent.util.matchUserAgent("iPhone")) && !goog.labs.userAgent.browser.matchSafari_() && !goog.labs.userAgent.browser.matchChrome_() && !goog.labs.userAgent.browser.matchCoast_() && !goog.labs.userAgent.browser.matchFirefox_() && goog.labs.userAgent.util.matchUserAgent("AppleWebKit");
  }, goog.labs.userAgent.browser.matchChrome_ = function() {
    return (goog.labs.userAgent.util.matchUserAgent("Chrome") || goog.labs.userAgent.util.matchUserAgent("CriOS")) && !goog.labs.userAgent.browser.matchEdgeHtml_();
  }, goog.labs.userAgent.browser.matchAndroidBrowser_ = function() {
    return goog.labs.userAgent.util.matchUserAgent("Android") && !(goog.labs.userAgent.browser.isChrome() || goog.labs.userAgent.browser.isFirefox() || goog.labs.userAgent.browser.isOpera() || goog.labs.userAgent.browser.isSilk());
  }, goog.labs.userAgent.browser.isOpera = goog.labs.userAgent.browser.matchOpera_, goog.labs.userAgent.browser.isIE = goog.labs.userAgent.browser.matchIE_, goog.labs.userAgent.browser.isEdge = goog.labs.userAgent.browser.matchEdgeHtml_, goog.labs.userAgent.browser.isEdgeChromium = goog.labs.userAgent.browser.matchEdgeChromium_, goog.labs.userAgent.browser.isOperaChromium = goog.labs.userAgent.browser.matchOperaChromium_, goog.labs.userAgent.browser.isFirefox = goog.labs.userAgent.browser.matchFirefox_, goog.labs.userAgent.browser.isSafari = goog.labs.userAgent.browser.matchSafari_, goog.labs.userAgent.browser.isCoast = goog.labs.userAgent.browser.matchCoast_, goog.labs.userAgent.browser.isIosWebview = goog.labs.userAgent.browser.matchIosWebview_, goog.labs.userAgent.browser.isChrome = goog.labs.userAgent.browser.matchChrome_, goog.labs.userAgent.browser.isAndroidBrowser = goog.labs.userAgent.browser.matchAndroidBrowser_, goog.labs.userAgent.browser.isSilk = function() {
    return goog.labs.userAgent.util.matchUserAgent("Silk");
  }, goog.labs.userAgent.browser.getVersion = function() {
    function e(e2) {
      return e2 = goog.array.find(e2, o), r[e2] || "";
    }
    var t = goog.labs.userAgent.util.getUserAgent();
    if (goog.labs.userAgent.browser.isIE()) return goog.labs.userAgent.browser.getIEVersion_(t);
    t = goog.labs.userAgent.util.extractVersionTuples(t);
    var r = {};
    goog.array.forEach(t, (function(e2) {
      r[e2[0]] = e2[1];
    }));
    var o = goog.partial(goog.object.containsKey, r);
    return goog.labs.userAgent.browser.isOpera() ? e(["Version", "Opera"]) : goog.labs.userAgent.browser.isEdge() ? e(["Edge"]) : goog.labs.userAgent.browser.isEdgeChromium() ? e(["Edg"]) : goog.labs.userAgent.browser.isChrome() ? e(["Chrome", "CriOS", "HeadlessChrome"]) : (t = t[2]) && t[1] || "";
  }, goog.labs.userAgent.browser.isVersionOrHigher = function(e) {
    return 0 <= goog.string.internal.compareVersions(goog.labs.userAgent.browser.getVersion(), e);
  }, goog.labs.userAgent.browser.getIEVersion_ = function(e) {
    var t = /rv: *([\d\.]*)/.exec(e);
    if (t && t[1]) return t[1];
    t = "";
    var r = /MSIE +([\d\.]+)/.exec(e);
    if (r && r[1]) if (e = /Trident\/(\d.\d)/.exec(e), "7.0" == r[1]) if (e && e[1]) switch (e[1]) {
      case "4.0":
        t = "8.0";
        break;
      case "5.0":
        t = "9.0";
        break;
      case "6.0":
        t = "10.0";
        break;
      case "7.0":
        t = "11.0";
    }
    else t = "7.0";
    else t = r[1];
    return t;
  }, goog.html.SafeHtml = function() {
    this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ = "", this.SAFE_HTML_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_, this.dir_ = null;
  }, goog.html.SafeHtml.ENABLE_ERROR_MESSAGES = goog.DEBUG, goog.html.SafeHtml.SUPPORT_STYLE_ATTRIBUTE = true, goog.html.SafeHtml.prototype.implementsGoogI18nBidiDirectionalString = true, goog.html.SafeHtml.prototype.getDirection = function() {
    return this.dir_;
  }, goog.html.SafeHtml.prototype.implementsGoogStringTypedString = true, goog.html.SafeHtml.prototype.getTypedStringValue = function() {
    return this.privateDoNotAccessOrElseSafeHtmlWrappedValue_.toString();
  }, goog.DEBUG && (goog.html.SafeHtml.prototype.toString = function() {
    return "SafeHtml{" + this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ + "}";
  }), goog.html.SafeHtml.unwrap = function(e) {
    return goog.html.SafeHtml.unwrapTrustedHTML(e).toString();
  }, goog.html.SafeHtml.unwrapTrustedHTML = function(e) {
    return e instanceof goog.html.SafeHtml && e.constructor === goog.html.SafeHtml && e.SAFE_HTML_TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ === goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ ? e.privateDoNotAccessOrElseSafeHtmlWrappedValue_ : (goog.asserts.fail("expected object of type SafeHtml, got '" + e + "' of type " + goog.typeOf(e)), "type_error:SafeHtml");
  }, goog.html.SafeHtml.htmlEscape = function(e) {
    if (e instanceof goog.html.SafeHtml) return e;
    var t = "object" == typeof e, r = null;
    return t && e.implementsGoogI18nBidiDirectionalString && (r = e.getDirection()), e = t && e.implementsGoogStringTypedString ? e.getTypedStringValue() : String(e), goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.internal.htmlEscape(e), r);
  }, goog.html.SafeHtml.htmlEscapePreservingNewlines = function(e) {
    return e instanceof goog.html.SafeHtml ? e : (e = goog.html.SafeHtml.htmlEscape(e), goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.internal.newLineToBr(goog.html.SafeHtml.unwrap(e)), e.getDirection()));
  }, goog.html.SafeHtml.htmlEscapePreservingNewlinesAndSpaces = function(e) {
    return e instanceof goog.html.SafeHtml ? e : (e = goog.html.SafeHtml.htmlEscape(e), goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(goog.string.internal.whitespaceEscape(goog.html.SafeHtml.unwrap(e)), e.getDirection()));
  }, goog.html.SafeHtml.from = goog.html.SafeHtml.htmlEscape, goog.html.SafeHtml.comment = function(e) {
    return goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse("<!--" + goog.string.internal.htmlEscape(e) + "-->", null);
  }, goog.html.SafeHtml.VALID_NAMES_IN_TAG_ = /^[a-zA-Z0-9-]+$/, goog.html.SafeHtml.URL_ATTRIBUTES_ = { action: true, cite: true, data: true, formaction: true, href: true, manifest: true, poster: true, src: true }, goog.html.SafeHtml.NOT_ALLOWED_TAG_NAMES_ = { APPLET: true, BASE: true, EMBED: true, IFRAME: true, LINK: true, MATH: true, META: true, OBJECT: true, SCRIPT: true, STYLE: true, SVG: true, TEMPLATE: true }, goog.html.SafeHtml.create = function(e, t, r) {
    return goog.html.SafeHtml.verifyTagName(String(e)), goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse(String(e), t, r);
  }, goog.html.SafeHtml.verifyTagName = function(e) {
    if (!goog.html.SafeHtml.VALID_NAMES_IN_TAG_.test(e)) throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? "Invalid tag name <" + e + ">." : "");
    if (e.toUpperCase() in goog.html.SafeHtml.NOT_ALLOWED_TAG_NAMES_) throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? "Tag name <" + e + "> is not allowed for SafeHtml." : "");
  }, goog.html.SafeHtml.createIframe = function(e, t, r, o) {
    e && goog.html.TrustedResourceUrl.unwrap(e);
    var i = {};
    return i.src = e || null, i.srcdoc = t && goog.html.SafeHtml.unwrap(t), e = goog.html.SafeHtml.combineAttributes(i, { sandbox: "" }, r), goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("iframe", e, o);
  }, goog.html.SafeHtml.createSandboxIframe = function(e, t, r, o) {
    if (!goog.html.SafeHtml.canUseSandboxIframe()) throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? "The browser does not support sandboxed iframes." : "");
    var i = {};
    return i.src = e ? goog.html.SafeUrl.unwrap(goog.html.SafeUrl.sanitize(e)) : null, i.srcdoc = t || null, i.sandbox = "", e = goog.html.SafeHtml.combineAttributes(i, {}, r), goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("iframe", e, o);
  }, goog.html.SafeHtml.canUseSandboxIframe = function() {
    return goog.global.HTMLIFrameElement && "sandbox" in goog.global.HTMLIFrameElement.prototype;
  }, goog.html.SafeHtml.createScriptSrc = function(e, t) {
    return goog.html.TrustedResourceUrl.unwrap(e), e = goog.html.SafeHtml.combineAttributes({ src: e }, {}, t), goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("script", e);
  }, goog.html.SafeHtml.createScript = function(e, t) {
    for (var r in t) {
      var o = r.toLowerCase();
      if ("language" == o || "src" == o || "text" == o || "type" == o) throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? 'Cannot set "' + o + '" attribute' : "");
    }
    for (r = "", e = goog.array.concat(e), o = 0; o < e.length; o++) r += goog.html.SafeScript.unwrap(e[o]);
    return e = goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(r, goog.i18n.bidi.Dir.NEUTRAL), goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("script", t, e);
  }, goog.html.SafeHtml.createStyle = function(e, t) {
    t = goog.html.SafeHtml.combineAttributes({ type: "text/css" }, {}, t);
    var r = "";
    e = goog.array.concat(e);
    for (var o = 0; o < e.length; o++) r += goog.html.SafeStyleSheet.unwrap(e[o]);
    return e = goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(r, goog.i18n.bidi.Dir.NEUTRAL), goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("style", t, e);
  }, goog.html.SafeHtml.createMetaRefresh = function(e, t) {
    return e = goog.html.SafeUrl.unwrap(goog.html.SafeUrl.sanitize(e)), (goog.labs.userAgent.browser.isIE() || goog.labs.userAgent.browser.isEdge()) && goog.string.internal.contains(e, ";") && (e = "'" + e.replace(/'/g, "%27") + "'"), goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse("meta", { "http-equiv": "refresh", content: (t || 0) + "; url=" + e });
  }, goog.html.SafeHtml.getAttrNameAndValue_ = function(e, t, r) {
    if (r instanceof goog.string.Const) r = goog.string.Const.unwrap(r);
    else if ("style" == t.toLowerCase()) {
      if (!goog.html.SafeHtml.SUPPORT_STYLE_ATTRIBUTE) throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? 'Attribute "style" not supported.' : "");
      r = goog.html.SafeHtml.getStyleValue_(r);
    } else {
      if (/^on/i.test(t)) throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? 'Attribute "' + t + '" requires goog.string.Const value, "' + r + '" given.' : "");
      if (t.toLowerCase() in goog.html.SafeHtml.URL_ATTRIBUTES_) if (r instanceof goog.html.TrustedResourceUrl) r = goog.html.TrustedResourceUrl.unwrap(r);
      else if (r instanceof goog.html.SafeUrl) r = goog.html.SafeUrl.unwrap(r);
      else {
        if ("string" != typeof r) throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? 'Attribute "' + t + '" on tag "' + e + '" requires goog.html.SafeUrl, goog.string.Const, or string, value "' + r + '" given.' : "");
        r = goog.html.SafeUrl.sanitize(r).getTypedStringValue();
      }
    }
    return r.implementsGoogStringTypedString && (r = r.getTypedStringValue()), goog.asserts.assert("string" == typeof r || "number" == typeof r, "String or number value expected, got " + typeof r + " with value: " + r), t + '="' + goog.string.internal.htmlEscape(String(r)) + '"';
  }, goog.html.SafeHtml.getStyleValue_ = function(e) {
    if (!goog.isObject(e)) throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? 'The "style" attribute requires goog.html.SafeStyle or map of style properties, ' + typeof e + " given: " + e : "");
    return e instanceof goog.html.SafeStyle || (e = goog.html.SafeStyle.create(e)), goog.html.SafeStyle.unwrap(e);
  }, goog.html.SafeHtml.createWithDir = function(e, t, r, o) {
    return (t = goog.html.SafeHtml.create(t, r, o)).dir_ = e, t;
  }, goog.html.SafeHtml.join = function(e, t) {
    var r = (e = goog.html.SafeHtml.htmlEscape(e)).getDirection(), o = [], i = function(e2) {
      Array.isArray(e2) ? goog.array.forEach(e2, i) : (e2 = goog.html.SafeHtml.htmlEscape(e2), o.push(goog.html.SafeHtml.unwrap(e2)), e2 = e2.getDirection(), r == goog.i18n.bidi.Dir.NEUTRAL ? r = e2 : e2 != goog.i18n.bidi.Dir.NEUTRAL && r != e2 && (r = null));
    };
    return goog.array.forEach(t, i), goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(o.join(goog.html.SafeHtml.unwrap(e)), r);
  }, goog.html.SafeHtml.concat = function(e) {
    return goog.html.SafeHtml.join(goog.html.SafeHtml.EMPTY, Array.prototype.slice.call(arguments));
  }, goog.html.SafeHtml.concatWithDir = function(e, t) {
    var r = goog.html.SafeHtml.concat(goog.array.slice(arguments, 1));
    return r.dir_ = e, r;
  }, goog.html.SafeHtml.TYPE_MARKER_GOOG_HTML_SECURITY_PRIVATE_ = {}, goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse = function(e, t) {
    return new goog.html.SafeHtml().initSecurityPrivateDoNotAccessOrElse_(e, t);
  }, goog.html.SafeHtml.prototype.initSecurityPrivateDoNotAccessOrElse_ = function(e, t) {
    return this.privateDoNotAccessOrElseSafeHtmlWrappedValue_ = goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY ? goog.html.trustedtypes.PRIVATE_DO_NOT_ACCESS_OR_ELSE_POLICY.createHTML(e) : e, this.dir_ = t, this;
  }, goog.html.SafeHtml.createSafeHtmlTagSecurityPrivateDoNotAccessOrElse = function(e, t, r) {
    var o = null, i = "<" + e + goog.html.SafeHtml.stringifyAttributes(e, t);
    return null == r ? r = [] : Array.isArray(r) || (r = [r]), goog.dom.tags.isVoidTag(e.toLowerCase()) ? (goog.asserts.assert(!r.length, "Void tag <" + e + "> does not allow content."), i += ">") : (o = goog.html.SafeHtml.concat(r), i += ">" + goog.html.SafeHtml.unwrap(o) + "</" + e + ">", o = o.getDirection()), (e = t && t.dir) && (o = /^(ltr|rtl|auto)$/i.test(e) ? goog.i18n.bidi.Dir.NEUTRAL : null), goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(i, o);
  }, goog.html.SafeHtml.stringifyAttributes = function(e, t) {
    var r = "";
    if (t) for (var o in t) {
      if (!goog.html.SafeHtml.VALID_NAMES_IN_TAG_.test(o)) throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? 'Invalid attribute name "' + o + '".' : "");
      var i = t[o];
      null != i && (r += " " + goog.html.SafeHtml.getAttrNameAndValue_(e, o, i));
    }
    return r;
  }, goog.html.SafeHtml.combineAttributes = function(e, t, r) {
    var o, i = {};
    for (o in e) goog.asserts.assert(o.toLowerCase() == o, "Must be lower case"), i[o] = e[o];
    for (o in t) goog.asserts.assert(o.toLowerCase() == o, "Must be lower case"), i[o] = t[o];
    if (r) for (o in r) {
      var a2 = o.toLowerCase();
      if (a2 in e) throw Error(goog.html.SafeHtml.ENABLE_ERROR_MESSAGES ? 'Cannot override "' + a2 + '" attribute, got "' + o + '" with value "' + r[o] + '"' : "");
      a2 in t && delete i[a2], i[o] = r[o];
    }
    return i;
  }, goog.html.SafeHtml.DOCTYPE_HTML = goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse("<!DOCTYPE html>", goog.i18n.bidi.Dir.NEUTRAL), goog.html.SafeHtml.EMPTY = goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse("", goog.i18n.bidi.Dir.NEUTRAL), goog.html.SafeHtml.BR = goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse("<br>", goog.i18n.bidi.Dir.NEUTRAL), goog.html.uncheckedconversions = {}, goog.html.uncheckedconversions.safeHtmlFromStringKnownToSatisfyTypeContract = function(e, t, r) {
    return goog.asserts.assertString(goog.string.Const.unwrap(e), "must provide justification"), goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(e)), "must provide non-empty justification"), goog.html.SafeHtml.createSafeHtmlSecurityPrivateDoNotAccessOrElse(t, r || null);
  }, goog.html.uncheckedconversions.safeScriptFromStringKnownToSatisfyTypeContract = function(e, t) {
    return goog.asserts.assertString(goog.string.Const.unwrap(e), "must provide justification"), goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(e)), "must provide non-empty justification"), goog.html.SafeScript.createSafeScriptSecurityPrivateDoNotAccessOrElse(t);
  }, goog.html.uncheckedconversions.safeStyleFromStringKnownToSatisfyTypeContract = function(e, t) {
    return goog.asserts.assertString(goog.string.Const.unwrap(e), "must provide justification"), goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(e)), "must provide non-empty justification"), goog.html.SafeStyle.createSafeStyleSecurityPrivateDoNotAccessOrElse(t);
  }, goog.html.uncheckedconversions.safeStyleSheetFromStringKnownToSatisfyTypeContract = function(e, t) {
    return goog.asserts.assertString(goog.string.Const.unwrap(e), "must provide justification"), goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(e)), "must provide non-empty justification"), goog.html.SafeStyleSheet.createSafeStyleSheetSecurityPrivateDoNotAccessOrElse(t);
  }, goog.html.uncheckedconversions.safeUrlFromStringKnownToSatisfyTypeContract = function(e, t) {
    return goog.asserts.assertString(goog.string.Const.unwrap(e), "must provide justification"), goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(e)), "must provide non-empty justification"), goog.html.SafeUrl.createSafeUrlSecurityPrivateDoNotAccessOrElse(t);
  }, goog.html.uncheckedconversions.trustedResourceUrlFromStringKnownToSatisfyTypeContract = function(e, t) {
    return goog.asserts.assertString(goog.string.Const.unwrap(e), "must provide justification"), goog.asserts.assert(!goog.string.internal.isEmptyOrWhitespace(goog.string.Const.unwrap(e)), "must provide non-empty justification"), goog.html.TrustedResourceUrl.createTrustedResourceUrlSecurityPrivateDoNotAccessOrElse(t);
  }, goog.dom.safe = {}, goog.dom.safe.InsertAdjacentHtmlPosition = { AFTERBEGIN: "afterbegin", AFTEREND: "afterend", BEFOREBEGIN: "beforebegin", BEFOREEND: "beforeend" }, goog.dom.safe.insertAdjacentHtml = function(e, t, r) {
    e.insertAdjacentHTML(t, goog.html.SafeHtml.unwrapTrustedHTML(r));
  }, goog.dom.safe.SET_INNER_HTML_DISALLOWED_TAGS_ = { MATH: true, SCRIPT: true, STYLE: true, SVG: true, TEMPLATE: true }, goog.dom.safe.isInnerHtmlCleanupRecursive_ = goog.functions.cacheReturnValue((function() {
    if (goog.DEBUG && "undefined" == typeof document) return false;
    var e = document.createElement("div"), t = document.createElement("div");
    return t.appendChild(document.createElement("div")), e.appendChild(t), !(goog.DEBUG && !e.firstChild) && (t = e.firstChild.firstChild, e.innerHTML = goog.html.SafeHtml.unwrapTrustedHTML(goog.html.SafeHtml.EMPTY), !t.parentElement);
  })), goog.dom.safe.unsafeSetInnerHtmlDoNotUseOrElse = function(e, t) {
    if (goog.dom.safe.isInnerHtmlCleanupRecursive_()) for (; e.lastChild; ) e.removeChild(e.lastChild);
    e.innerHTML = goog.html.SafeHtml.unwrapTrustedHTML(t);
  }, goog.dom.safe.setInnerHtml = function(e, t) {
    if (goog.asserts.ENABLE_ASSERTS) {
      var r = e.tagName.toUpperCase();
      if (goog.dom.safe.SET_INNER_HTML_DISALLOWED_TAGS_[r]) throw Error("goog.dom.safe.setInnerHtml cannot be used to set content of " + e.tagName + ".");
    }
    goog.dom.safe.unsafeSetInnerHtmlDoNotUseOrElse(e, t);
  }, goog.dom.safe.setOuterHtml = function(e, t) {
    e.outerHTML = goog.html.SafeHtml.unwrapTrustedHTML(t);
  }, goog.dom.safe.setFormElementAction = function(e, t) {
    t = t instanceof goog.html.SafeUrl ? t : goog.html.SafeUrl.sanitizeAssertUnchanged(t), goog.dom.asserts.assertIsHTMLFormElement(e).action = goog.html.SafeUrl.unwrap(t);
  }, goog.dom.safe.setButtonFormAction = function(e, t) {
    t = t instanceof goog.html.SafeUrl ? t : goog.html.SafeUrl.sanitizeAssertUnchanged(t), goog.dom.asserts.assertIsHTMLButtonElement(e).formAction = goog.html.SafeUrl.unwrap(t);
  }, goog.dom.safe.setInputFormAction = function(e, t) {
    t = t instanceof goog.html.SafeUrl ? t : goog.html.SafeUrl.sanitizeAssertUnchanged(t), goog.dom.asserts.assertIsHTMLInputElement(e).formAction = goog.html.SafeUrl.unwrap(t);
  }, goog.dom.safe.setStyle = function(e, t) {
    e.style.cssText = goog.html.SafeStyle.unwrap(t);
  }, goog.dom.safe.documentWrite = function(e, t) {
    e.write(goog.html.SafeHtml.unwrapTrustedHTML(t));
  }, goog.dom.safe.setAnchorHref = function(e, t) {
    goog.dom.asserts.assertIsHTMLAnchorElement(e), t = t instanceof goog.html.SafeUrl ? t : goog.html.SafeUrl.sanitizeAssertUnchanged(t), e.href = goog.html.SafeUrl.unwrap(t);
  }, goog.dom.safe.setImageSrc = function(e, t) {
    if (goog.dom.asserts.assertIsHTMLImageElement(e), !(t instanceof goog.html.SafeUrl)) {
      var r = /^data:image\//i.test(t);
      t = goog.html.SafeUrl.sanitizeAssertUnchanged(t, r);
    }
    e.src = goog.html.SafeUrl.unwrap(t);
  }, goog.dom.safe.setAudioSrc = function(e, t) {
    if (goog.dom.asserts.assertIsHTMLAudioElement(e), !(t instanceof goog.html.SafeUrl)) {
      var r = /^data:audio\//i.test(t);
      t = goog.html.SafeUrl.sanitizeAssertUnchanged(t, r);
    }
    e.src = goog.html.SafeUrl.unwrap(t);
  }, goog.dom.safe.setVideoSrc = function(e, t) {
    if (goog.dom.asserts.assertIsHTMLVideoElement(e), !(t instanceof goog.html.SafeUrl)) {
      var r = /^data:video\//i.test(t);
      t = goog.html.SafeUrl.sanitizeAssertUnchanged(t, r);
    }
    e.src = goog.html.SafeUrl.unwrap(t);
  }, goog.dom.safe.setEmbedSrc = function(e, t) {
    goog.dom.asserts.assertIsHTMLEmbedElement(e), e.src = goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(t);
  }, goog.dom.safe.setFrameSrc = function(e, t) {
    goog.dom.asserts.assertIsHTMLFrameElement(e), e.src = goog.html.TrustedResourceUrl.unwrap(t);
  }, goog.dom.safe.setIframeSrc = function(e, t) {
    goog.dom.asserts.assertIsHTMLIFrameElement(e), e.src = goog.html.TrustedResourceUrl.unwrap(t);
  }, goog.dom.safe.setIframeSrcdoc = function(e, t) {
    goog.dom.asserts.assertIsHTMLIFrameElement(e), e.srcdoc = goog.html.SafeHtml.unwrapTrustedHTML(t);
  }, goog.dom.safe.setLinkHrefAndRel = function(e, t, r) {
    goog.dom.asserts.assertIsHTMLLinkElement(e), e.rel = r, goog.string.internal.caseInsensitiveContains(r, "stylesheet") ? (goog.asserts.assert(t instanceof goog.html.TrustedResourceUrl, 'URL must be TrustedResourceUrl because "rel" contains "stylesheet"'), e.href = goog.html.TrustedResourceUrl.unwrap(t)) : e.href = t instanceof goog.html.TrustedResourceUrl ? goog.html.TrustedResourceUrl.unwrap(t) : t instanceof goog.html.SafeUrl ? goog.html.SafeUrl.unwrap(t) : goog.html.SafeUrl.unwrap(goog.html.SafeUrl.sanitizeAssertUnchanged(t));
  }, goog.dom.safe.setObjectData = function(e, t) {
    goog.dom.asserts.assertIsHTMLObjectElement(e), e.data = goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(t);
  }, goog.dom.safe.setScriptSrc = function(e, t) {
    goog.dom.asserts.assertIsHTMLScriptElement(e), e.src = goog.html.TrustedResourceUrl.unwrapTrustedScriptURL(t), (t = goog.getScriptNonce()) && e.setAttribute("nonce", t);
  }, goog.dom.safe.setScriptContent = function(e, t) {
    goog.dom.asserts.assertIsHTMLScriptElement(e), e.text = goog.html.SafeScript.unwrapTrustedScript(t), (t = goog.getScriptNonce()) && e.setAttribute("nonce", t);
  }, goog.dom.safe.setLocationHref = function(e, t) {
    goog.dom.asserts.assertIsLocation(e), t = t instanceof goog.html.SafeUrl ? t : goog.html.SafeUrl.sanitizeAssertUnchanged(t), e.href = goog.html.SafeUrl.unwrap(t);
  }, goog.dom.safe.assignLocation = function(e, t) {
    goog.dom.asserts.assertIsLocation(e), t = t instanceof goog.html.SafeUrl ? t : goog.html.SafeUrl.sanitizeAssertUnchanged(t), e.assign(goog.html.SafeUrl.unwrap(t));
  }, goog.dom.safe.replaceLocation = function(e, t) {
    t = t instanceof goog.html.SafeUrl ? t : goog.html.SafeUrl.sanitizeAssertUnchanged(t), e.replace(goog.html.SafeUrl.unwrap(t));
  }, goog.dom.safe.openInWindow = function(e, t, r, o, i) {
    return e = e instanceof goog.html.SafeUrl ? e : goog.html.SafeUrl.sanitizeAssertUnchanged(e), t = t || goog.global, r = r instanceof goog.string.Const ? goog.string.Const.unwrap(r) : r || "", t.open(goog.html.SafeUrl.unwrap(e), r, o, i);
  }, goog.dom.safe.parseFromStringHtml = function(e, t) {
    return goog.dom.safe.parseFromString(e, t, "text/html");
  }, goog.dom.safe.parseFromString = function(e, t, r) {
    return e.parseFromString(goog.html.SafeHtml.unwrapTrustedHTML(t), r);
  }, goog.dom.safe.createImageFromBlob = function(e) {
    if (!/^image\/.*/g.test(e.type)) throw Error("goog.dom.safe.createImageFromBlob only accepts MIME type image/.*.");
    var t = goog.global.URL.createObjectURL(e);
    return (e = new goog.global.Image()).onload = function() {
      goog.global.URL.revokeObjectURL(t);
    }, goog.dom.safe.setImageSrc(e, goog.html.uncheckedconversions.safeUrlFromStringKnownToSatisfyTypeContract(goog.string.Const.from("Image blob URL."), t)), e;
  }, goog.string.DETECT_DOUBLE_ESCAPING = false, goog.string.FORCE_NON_DOM_HTML_UNESCAPING = false, goog.string.Unicode = { NBSP: " " }, goog.string.startsWith = goog.string.internal.startsWith, goog.string.endsWith = goog.string.internal.endsWith, goog.string.caseInsensitiveStartsWith = goog.string.internal.caseInsensitiveStartsWith, goog.string.caseInsensitiveEndsWith = goog.string.internal.caseInsensitiveEndsWith, goog.string.caseInsensitiveEquals = goog.string.internal.caseInsensitiveEquals, goog.string.subs = function(e, t) {
    for (var r = e.split("%s"), o = "", i = Array.prototype.slice.call(arguments, 1); i.length && 1 < r.length; ) o += r.shift() + i.shift();
    return o + r.join("%s");
  }, goog.string.collapseWhitespace = function(e) {
    return e.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "");
  }, goog.string.isEmptyOrWhitespace = goog.string.internal.isEmptyOrWhitespace, goog.string.isEmptyString = function(e) {
    return 0 == e.length;
  }, goog.string.isEmpty = goog.string.isEmptyOrWhitespace, goog.string.isEmptyOrWhitespaceSafe = function(e) {
    return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(e));
  }, goog.string.isEmptySafe = goog.string.isEmptyOrWhitespaceSafe, goog.string.isBreakingWhitespace = function(e) {
    return !/[^\t\n\r ]/.test(e);
  }, goog.string.isAlpha = function(e) {
    return !/[^a-zA-Z]/.test(e);
  }, goog.string.isNumeric = function(e) {
    return !/[^0-9]/.test(e);
  }, goog.string.isAlphaNumeric = function(e) {
    return !/[^a-zA-Z0-9]/.test(e);
  }, goog.string.isSpace = function(e) {
    return " " == e;
  }, goog.string.isUnicodeChar = function(e) {
    return 1 == e.length && " " <= e && "~" >= e || "" <= e && "�" >= e;
  }, goog.string.stripNewlines = function(e) {
    return e.replace(/(\r\n|\r|\n)+/g, " ");
  }, goog.string.canonicalizeNewlines = function(e) {
    return e.replace(/(\r\n|\r|\n)/g, "\n");
  }, goog.string.normalizeWhitespace = function(e) {
    return e.replace(/\xa0|\s/g, " ");
  }, goog.string.normalizeSpaces = function(e) {
    return e.replace(/\xa0|[ \t]+/g, " ");
  }, goog.string.collapseBreakingSpaces = function(e) {
    return e.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "");
  }, goog.string.trim = goog.string.internal.trim, goog.string.trimLeft = function(e) {
    return e.replace(/^[\s\xa0]+/, "");
  }, goog.string.trimRight = function(e) {
    return e.replace(/[\s\xa0]+$/, "");
  }, goog.string.caseInsensitiveCompare = goog.string.internal.caseInsensitiveCompare, goog.string.numberAwareCompare_ = function(e, t, r) {
    if (e == t) return 0;
    if (!e) return -1;
    if (!t) return 1;
    for (var o = e.toLowerCase().match(r), i = t.toLowerCase().match(r), a2 = Math.min(o.length, i.length), n = 0; n < a2; n++) {
      r = o[n];
      var s = i[n];
      if (r != s) return e = parseInt(r, 10), !isNaN(e) && (t = parseInt(s, 10), !isNaN(t) && e - t) ? e - t : r < s ? -1 : 1;
    }
    return o.length != i.length ? o.length - i.length : e < t ? -1 : 1;
  }, goog.string.intAwareCompare = function(e, t) {
    return goog.string.numberAwareCompare_(e, t, /\d+|\D+/g);
  }, goog.string.floatAwareCompare = function(e, t) {
    return goog.string.numberAwareCompare_(e, t, /\d+|\.\d+|\D+/g);
  }, goog.string.numerateCompare = goog.string.floatAwareCompare, goog.string.urlEncode = function(e) {
    return encodeURIComponent(String(e));
  }, goog.string.urlDecode = function(e) {
    return decodeURIComponent(e.replace(/\+/g, " "));
  }, goog.string.newLineToBr = goog.string.internal.newLineToBr, goog.string.htmlEscape = function(e, t) {
    return e = goog.string.internal.htmlEscape(e, t), goog.string.DETECT_DOUBLE_ESCAPING && (e = e.replace(goog.string.E_RE_, "&#101;")), e;
  }, goog.string.E_RE_ = /e/g, goog.string.unescapeEntities = function(e) {
    return goog.string.contains(e, "&") ? !goog.string.FORCE_NON_DOM_HTML_UNESCAPING && "document" in goog.global ? goog.string.unescapeEntitiesUsingDom_(e) : goog.string.unescapePureXmlEntities_(e) : e;
  }, goog.string.unescapeEntitiesWithDocument = function(e, t) {
    return goog.string.contains(e, "&") ? goog.string.unescapeEntitiesUsingDom_(e, t) : e;
  }, goog.string.unescapeEntitiesUsingDom_ = function(e, t) {
    var r = { "&amp;": "&", "&lt;": "<", "&gt;": ">", "&quot;": '"' }, o = t ? t.createElement("div") : goog.global.document.createElement("div");
    return e.replace(goog.string.HTML_ENTITY_PATTERN_, (function(e2, t2) {
      var i = r[e2];
      return i || ("#" == t2.charAt(0) && (t2 = Number("0" + t2.substr(1)), isNaN(t2) || (i = String.fromCharCode(t2))), i || (goog.dom.safe.setInnerHtml(o, goog.html.uncheckedconversions.safeHtmlFromStringKnownToSatisfyTypeContract(goog.string.Const.from("Single HTML entity."), e2 + " ")), i = o.firstChild.nodeValue.slice(0, -1)), r[e2] = i);
    }));
  }, goog.string.unescapePureXmlEntities_ = function(e) {
    return e.replace(/&([^;]+);/g, (function(e2, t) {
      switch (t) {
        case "amp":
          return "&";
        case "lt":
          return "<";
        case "gt":
          return ">";
        case "quot":
          return '"';
        default:
          return "#" != t.charAt(0) || (t = Number("0" + t.substr(1)), isNaN(t)) ? e2 : String.fromCharCode(t);
      }
    }));
  }, goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g, goog.string.whitespaceEscape = function(e, t) {
    return goog.string.newLineToBr(e.replace(/  /g, " &#160;"), t);
  }, goog.string.preserveSpaces = function(e) {
    return e.replace(/(^|[\n ]) /g, "$1" + goog.string.Unicode.NBSP);
  }, goog.string.stripQuotes = function(e, t) {
    for (var r = t.length, o = 0; o < r; o++) {
      var i = 1 == r ? t : t.charAt(o);
      if (e.charAt(0) == i && e.charAt(e.length - 1) == i) return e.substring(1, e.length - 1);
    }
    return e;
  }, goog.string.truncate = function(e, t, r) {
    return r && (e = goog.string.unescapeEntities(e)), e.length > t && (e = e.substring(0, t - 3) + "..."), r && (e = goog.string.htmlEscape(e)), e;
  }, goog.string.truncateMiddle = function(e, t, r, o) {
    if (r && (e = goog.string.unescapeEntities(e)), o && e.length > t) {
      o > t && (o = t);
      var i = e.length - o;
      e = e.substring(0, t - o) + "..." + e.substring(i);
    } else e.length > t && (o = Math.floor(t / 2), i = e.length - o, e = e.substring(0, o + t % 2) + "..." + e.substring(i));
    return r && (e = goog.string.htmlEscape(e)), e;
  }, goog.string.specialEscapeChars_ = { "\0": "\\0", "\b": "\\b", "\f": "\\f", "\n": "\\n", "\r": "\\r", "	": "\\t", "\v": "\\x0B", '"': '\\"', "\\": "\\\\", "<": "\\u003C" }, goog.string.jsEscapeCache_ = { "'": "\\'" }, goog.string.quote = function(e) {
    e = String(e);
    for (var t = ['"'], r = 0; r < e.length; r++) {
      var o = e.charAt(r), i = o.charCodeAt(0);
      t[r + 1] = goog.string.specialEscapeChars_[o] || (31 < i && 127 > i ? o : goog.string.escapeChar(o));
    }
    return t.push('"'), t.join("");
  }, goog.string.escapeString = function(e) {
    for (var t = [], r = 0; r < e.length; r++) t[r] = goog.string.escapeChar(e.charAt(r));
    return t.join("");
  }, goog.string.escapeChar = function(e) {
    if (e in goog.string.jsEscapeCache_) return goog.string.jsEscapeCache_[e];
    if (e in goog.string.specialEscapeChars_) return goog.string.jsEscapeCache_[e] = goog.string.specialEscapeChars_[e];
    var t = e.charCodeAt(0);
    if (31 < t && 127 > t) var r = e;
    else 256 > t ? (r = "\\x", (16 > t || 256 < t) && (r += "0")) : (r = "\\u", 4096 > t && (r += "0")), r += t.toString(16).toUpperCase();
    return goog.string.jsEscapeCache_[e] = r;
  }, goog.string.contains = goog.string.internal.contains, goog.string.caseInsensitiveContains = goog.string.internal.caseInsensitiveContains, goog.string.countOf = function(e, t) {
    return e && t ? e.split(t).length - 1 : 0;
  }, goog.string.removeAt = function(e, t, r) {
    var o = e;
    return 0 <= t && t < e.length && 0 < r && (o = e.substr(0, t) + e.substr(t + r, e.length - t - r)), o;
  }, goog.string.remove = function(e, t) {
    return e.replace(t, "");
  }, goog.string.removeAll = function(e, t) {
    return t = new RegExp(goog.string.regExpEscape(t), "g"), e.replace(t, "");
  }, goog.string.replaceAll = function(e, t, r) {
    return t = new RegExp(goog.string.regExpEscape(t), "g"), e.replace(t, r.replace(/\$/g, "$$$$"));
  }, goog.string.regExpEscape = function(e) {
    return String(e).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
  }, goog.string.repeat = String.prototype.repeat ? function(e, t) {
    return e.repeat(t);
  } : function(e, t) {
    return Array(t + 1).join(e);
  }, goog.string.padNumber = function(e, t, r) {
    return -1 == (r = (e = void 0 !== r ? e.toFixed(r) : String(e)).indexOf(".")) && (r = e.length), goog.string.repeat("0", Math.max(0, t - r)) + e;
  }, goog.string.makeSafe = function(e) {
    return null == e ? "" : String(e);
  }, goog.string.buildString = function(e) {
    return Array.prototype.join.call(arguments, "");
  }, goog.string.getRandomString = function() {
    return Math.floor(2147483648 * Math.random()).toString(36) + Math.abs(Math.floor(2147483648 * Math.random()) ^ goog.now()).toString(36);
  }, goog.string.compareVersions = goog.string.internal.compareVersions, goog.string.hashCode = function(e) {
    for (var t = 0, r = 0; r < e.length; ++r) t = 31 * t + e.charCodeAt(r) >>> 0;
    return t;
  }, goog.string.uniqueStringCounter_ = 2147483648 * Math.random() | 0, goog.string.createUniqueString = function() {
    return "goog_" + goog.string.uniqueStringCounter_++;
  }, goog.string.toNumber = function(e) {
    var t = Number(e);
    return 0 == t && goog.string.isEmptyOrWhitespace(e) ? NaN : t;
  }, goog.string.isLowerCamelCase = function(e) {
    return /^[a-z]+([A-Z][a-z]*)*$/.test(e);
  }, goog.string.isUpperCamelCase = function(e) {
    return /^([A-Z][a-z]*)+$/.test(e);
  }, goog.string.toCamelCase = function(e) {
    return String(e).replace(/\-([a-z])/g, (function(e2, t) {
      return t.toUpperCase();
    }));
  }, goog.string.toSelectorCase = function(e) {
    return String(e).replace(/([A-Z])/g, "-$1").toLowerCase();
  }, goog.string.toTitleCase = function(e, t) {
    return t = "string" == typeof t ? goog.string.regExpEscape(t) : "\\s", e.replace(new RegExp("(^" + (t ? "|[" + t + "]+" : "") + ")([a-z])", "g"), (function(e2, t2, r) {
      return t2 + r.toUpperCase();
    }));
  }, goog.string.capitalize = function(e) {
    return String(e.charAt(0)).toUpperCase() + String(e.substr(1)).toLowerCase();
  }, goog.string.parseInt = function(e) {
    return isFinite(e) && (e = String(e)), "string" == typeof e ? /^\s*-?0x/i.test(e) ? parseInt(e, 16) : parseInt(e, 10) : NaN;
  }, goog.string.splitLimit = function(e, t, r) {
    e = e.split(t);
    for (var o = []; 0 < r && e.length; ) o.push(e.shift()), r--;
    return e.length && o.push(e.join(t)), o;
  }, goog.string.lastComponent = function(e, t) {
    if (!t) return e;
    "string" == typeof t && (t = [t]);
    for (var r = -1, o = 0; o < t.length; o++) if ("" != t[o]) {
      var i = e.lastIndexOf(t[o]);
      i > r && (r = i);
    }
    return -1 == r ? e : e.slice(r + 1);
  }, goog.string.editDistance = function(e, t) {
    var r = [], o = [];
    if (e == t) return 0;
    if (!e.length || !t.length) return Math.max(e.length, t.length);
    for (var i = 0; i < t.length + 1; i++) r[i] = i;
    for (i = 0; i < e.length; i++) {
      o[0] = i + 1;
      for (var a2 = 0; a2 < t.length; a2++) o[a2 + 1] = Math.min(o[a2] + 1, r[a2 + 1] + 1, r[a2] + Number(e[i] != t[a2]));
      for (a2 = 0; a2 < r.length; a2++) r[a2] = o[a2];
    }
    return o[t.length];
  }, goog.labs.userAgent.engine = {}, goog.labs.userAgent.engine.isPresto = function() {
    return goog.labs.userAgent.util.matchUserAgent("Presto");
  }, goog.labs.userAgent.engine.isTrident = function() {
    return goog.labs.userAgent.util.matchUserAgent("Trident") || goog.labs.userAgent.util.matchUserAgent("MSIE");
  }, goog.labs.userAgent.engine.isEdge = function() {
    return goog.labs.userAgent.util.matchUserAgent("Edge");
  }, goog.labs.userAgent.engine.isWebKit = function() {
    return goog.labs.userAgent.util.matchUserAgentIgnoreCase("WebKit") && !goog.labs.userAgent.engine.isEdge();
  }, goog.labs.userAgent.engine.isGecko = function() {
    return goog.labs.userAgent.util.matchUserAgent("Gecko") && !goog.labs.userAgent.engine.isWebKit() && !goog.labs.userAgent.engine.isTrident() && !goog.labs.userAgent.engine.isEdge();
  }, goog.labs.userAgent.engine.getVersion = function() {
    var e = goog.labs.userAgent.util.getUserAgent();
    if (e) {
      e = goog.labs.userAgent.util.extractVersionTuples(e);
      var t, r = goog.labs.userAgent.engine.getEngineTuple_(e);
      if (r) return "Gecko" == r[0] ? goog.labs.userAgent.engine.getVersionForKey_(e, "Firefox") : r[1];
      if ((e = e[0]) && (t = e[2]) && (t = /Trident\/([^\s;]+)/.exec(t))) return t[1];
    }
    return "";
  }, goog.labs.userAgent.engine.getEngineTuple_ = function(e) {
    if (!goog.labs.userAgent.engine.isEdge()) return e[1];
    for (var t = 0; t < e.length; t++) {
      var r = e[t];
      if ("Edge" == r[0]) return r;
    }
  }, goog.labs.userAgent.engine.isVersionOrHigher = function(e) {
    return 0 <= goog.string.compareVersions(goog.labs.userAgent.engine.getVersion(), e);
  }, goog.labs.userAgent.engine.getVersionForKey_ = function(e, t) {
    return (e = goog.array.find(e, (function(e2) {
      return t == e2[0];
    }))) && e[1] || "";
  }, goog.labs.userAgent.platform = {}, goog.labs.userAgent.platform.isAndroid = function() {
    return goog.labs.userAgent.util.matchUserAgent("Android");
  }, goog.labs.userAgent.platform.isIpod = function() {
    return goog.labs.userAgent.util.matchUserAgent("iPod");
  }, goog.labs.userAgent.platform.isIphone = function() {
    return goog.labs.userAgent.util.matchUserAgent("iPhone") && !goog.labs.userAgent.util.matchUserAgent("iPod") && !goog.labs.userAgent.util.matchUserAgent("iPad");
  }, goog.labs.userAgent.platform.isIpad = function() {
    return goog.labs.userAgent.util.matchUserAgent("iPad");
  }, goog.labs.userAgent.platform.isIos = function() {
    return goog.labs.userAgent.platform.isIphone() || goog.labs.userAgent.platform.isIpad() || goog.labs.userAgent.platform.isIpod();
  }, goog.labs.userAgent.platform.isMacintosh = function() {
    return goog.labs.userAgent.util.matchUserAgent("Macintosh");
  }, goog.labs.userAgent.platform.isLinux = function() {
    return goog.labs.userAgent.util.matchUserAgent("Linux");
  }, goog.labs.userAgent.platform.isWindows = function() {
    return goog.labs.userAgent.util.matchUserAgent("Windows");
  }, goog.labs.userAgent.platform.isChromeOS = function() {
    return goog.labs.userAgent.util.matchUserAgent("CrOS");
  }, goog.labs.userAgent.platform.isChromecast = function() {
    return goog.labs.userAgent.util.matchUserAgent("CrKey");
  }, goog.labs.userAgent.platform.isKaiOS = function() {
    return goog.labs.userAgent.util.matchUserAgentIgnoreCase("KaiOS");
  }, goog.labs.userAgent.platform.getVersion = function() {
    var e = goog.labs.userAgent.util.getUserAgent(), t = "";
    return goog.labs.userAgent.platform.isWindows() ? t = (e = (t = /Windows (?:NT|Phone) ([0-9.]+)/).exec(e)) ? e[1] : "0.0" : goog.labs.userAgent.platform.isIos() ? t = (e = (t = /(?:iPhone|iPod|iPad|CPU)\s+OS\s+(\S+)/).exec(e)) && e[1].replace(/_/g, ".") : goog.labs.userAgent.platform.isMacintosh() ? t = (e = (t = /Mac OS X ([0-9_.]+)/).exec(e)) ? e[1].replace(/_/g, ".") : "10" : goog.labs.userAgent.platform.isKaiOS() ? t = (e = (t = /(?:KaiOS)\/(\S+)/i).exec(e)) && e[1] : goog.labs.userAgent.platform.isAndroid() ? t = (e = (t = /Android\s+([^\);]+)(\)|;)/).exec(e)) && e[1] : goog.labs.userAgent.platform.isChromeOS() && (t = (e = (t = /(?:CrOS\s+(?:i686|x86_64)\s+([0-9.]+))/).exec(e)) && e[1]), t || "";
  }, goog.labs.userAgent.platform.isVersionOrHigher = function(e) {
    return 0 <= goog.string.compareVersions(goog.labs.userAgent.platform.getVersion(), e);
  }, goog.reflect = {}, goog.reflect.object = function(e, t) {
    return t;
  }, goog.reflect.objectProperty = function(e, t) {
    return e;
  }, goog.reflect.sinkValue = function(e) {
    return goog.reflect.sinkValue[" "](e), e;
  }, goog.reflect.sinkValue[" "] = goog.nullFunction, goog.reflect.canAccessProperty = function(e, t) {
    try {
      return goog.reflect.sinkValue(e[t]), true;
    } catch (e2) {
    }
    return false;
  }, goog.reflect.cache = function(e, t, r, o) {
    return o = o ? o(t) : t, Object.prototype.hasOwnProperty.call(e, o) ? e[o] : e[o] = r(t);
  }, goog.userAgent = {}, goog.userAgent.ASSUME_IE = false, goog.userAgent.ASSUME_EDGE = false, goog.userAgent.ASSUME_GECKO = false, goog.userAgent.ASSUME_WEBKIT = false, goog.userAgent.ASSUME_MOBILE_WEBKIT = false, goog.userAgent.ASSUME_OPERA = false, goog.userAgent.ASSUME_ANY_VERSION = false, goog.userAgent.BROWSER_KNOWN_ = goog.userAgent.ASSUME_IE || goog.userAgent.ASSUME_EDGE || goog.userAgent.ASSUME_GECKO || goog.userAgent.ASSUME_MOBILE_WEBKIT || goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_OPERA, goog.userAgent.getUserAgentString = function() {
    return goog.labs.userAgent.util.getUserAgent();
  }, goog.userAgent.getNavigatorTyped = function() {
    return goog.global.navigator || null;
  }, goog.userAgent.getNavigator = function() {
    return goog.userAgent.getNavigatorTyped();
  }, goog.userAgent.OPERA = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_OPERA : goog.labs.userAgent.browser.isOpera(), goog.userAgent.IE = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_IE : goog.labs.userAgent.browser.isIE(), goog.userAgent.EDGE = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_EDGE : goog.labs.userAgent.engine.isEdge(), goog.userAgent.EDGE_OR_IE = goog.userAgent.EDGE || goog.userAgent.IE, goog.userAgent.GECKO = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_GECKO : goog.labs.userAgent.engine.isGecko(), goog.userAgent.WEBKIT = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_MOBILE_WEBKIT : goog.labs.userAgent.engine.isWebKit(), goog.userAgent.isMobile_ = function() {
    return goog.userAgent.WEBKIT && goog.labs.userAgent.util.matchUserAgent("Mobile");
  }, goog.userAgent.MOBILE = goog.userAgent.ASSUME_MOBILE_WEBKIT || goog.userAgent.isMobile_(), goog.userAgent.SAFARI = goog.userAgent.WEBKIT, goog.userAgent.determinePlatform_ = function() {
    var e = goog.userAgent.getNavigatorTyped();
    return e && e.platform || "";
  }, goog.userAgent.PLATFORM = goog.userAgent.determinePlatform_(), goog.userAgent.ASSUME_MAC = false, goog.userAgent.ASSUME_WINDOWS = false, goog.userAgent.ASSUME_LINUX = false, goog.userAgent.ASSUME_X11 = false, goog.userAgent.ASSUME_ANDROID = false, goog.userAgent.ASSUME_IPHONE = false, goog.userAgent.ASSUME_IPAD = false, goog.userAgent.ASSUME_IPOD = false, goog.userAgent.ASSUME_KAIOS = false, goog.userAgent.PLATFORM_KNOWN_ = goog.userAgent.ASSUME_MAC || goog.userAgent.ASSUME_WINDOWS || goog.userAgent.ASSUME_LINUX || goog.userAgent.ASSUME_X11 || goog.userAgent.ASSUME_ANDROID || goog.userAgent.ASSUME_IPHONE || goog.userAgent.ASSUME_IPAD || goog.userAgent.ASSUME_IPOD, goog.userAgent.MAC = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_MAC : goog.labs.userAgent.platform.isMacintosh();
  goog.userAgent.WINDOWS = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_WINDOWS : goog.labs.userAgent.platform.isWindows(), goog.userAgent.isLegacyLinux_ = function() {
    return goog.labs.userAgent.platform.isLinux() || goog.labs.userAgent.platform.isChromeOS();
  }, goog.userAgent.LINUX = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_LINUX : goog.userAgent.isLegacyLinux_(), goog.userAgent.isX11_ = function() {
    var e = goog.userAgent.getNavigatorTyped();
    return !!e && goog.string.contains(e.appVersion || "", "X11");
  }, goog.userAgent.X11 = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_X11 : goog.userAgent.isX11_(), goog.userAgent.ANDROID = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_ANDROID : goog.labs.userAgent.platform.isAndroid(), goog.userAgent.IPHONE = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_IPHONE : goog.labs.userAgent.platform.isIphone(), goog.userAgent.IPAD = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_IPAD : goog.labs.userAgent.platform.isIpad(), goog.userAgent.IPOD = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_IPOD : goog.labs.userAgent.platform.isIpod(), goog.userAgent.IOS = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_IPHONE || goog.userAgent.ASSUME_IPAD || goog.userAgent.ASSUME_IPOD : goog.labs.userAgent.platform.isIos(), goog.userAgent.KAIOS = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_KAIOS : goog.labs.userAgent.platform.isKaiOS(), goog.userAgent.determineVersion_ = function() {
    var e = "", t = goog.userAgent.getVersionRegexResult_();
    return t && (e = t ? t[1] : ""), goog.userAgent.IE && (null != (t = goog.userAgent.getDocumentMode_()) && t > parseFloat(e)) ? String(t) : e;
  }, goog.userAgent.getVersionRegexResult_ = function() {
    var e = goog.userAgent.getUserAgentString();
    return goog.userAgent.GECKO ? /rv:([^\);]+)(\)|;)/.exec(e) : goog.userAgent.EDGE ? /Edge\/([\d\.]+)/.exec(e) : goog.userAgent.IE ? /\b(?:MSIE|rv)[: ]([^\);]+)(\)|;)/.exec(e) : goog.userAgent.WEBKIT ? /WebKit\/(\S+)/.exec(e) : goog.userAgent.OPERA ? /(?:Version)[ \/]?(\S+)/.exec(e) : void 0;
  }, goog.userAgent.getDocumentMode_ = function() {
    var e = goog.global.document;
    return e ? e.documentMode : void 0;
  }, goog.userAgent.VERSION = goog.userAgent.determineVersion_(), goog.userAgent.compare = function(e, t) {
    return goog.string.compareVersions(e, t);
  }, goog.userAgent.isVersionOrHigherCache_ = {}, goog.userAgent.isVersionOrHigher = function(e) {
    return goog.userAgent.ASSUME_ANY_VERSION || goog.reflect.cache(goog.userAgent.isVersionOrHigherCache_, e, (function() {
      return 0 <= goog.string.compareVersions(goog.userAgent.VERSION, e);
    }));
  }, goog.userAgent.isVersion = goog.userAgent.isVersionOrHigher, goog.userAgent.isDocumentModeOrHigher = function(e) {
    return Number(goog.userAgent.DOCUMENT_MODE) >= e;
  }, goog.userAgent.isDocumentMode = goog.userAgent.isDocumentModeOrHigher, goog.userAgent.DOCUMENT_MODE = (function() {
    if (goog.global.document && goog.userAgent.IE) {
      var e = goog.userAgent.getDocumentMode_();
      return e || (parseInt(goog.userAgent.VERSION, 10) || void 0);
    }
  })(), goog.userAgent.product = {}, goog.userAgent.product.ASSUME_FIREFOX = false, goog.userAgent.product.ASSUME_IPHONE = false, goog.userAgent.product.ASSUME_IPAD = false, goog.userAgent.product.ASSUME_ANDROID = false, goog.userAgent.product.ASSUME_CHROME = false, goog.userAgent.product.ASSUME_SAFARI = false, goog.userAgent.product.PRODUCT_KNOWN_ = goog.userAgent.ASSUME_IE || goog.userAgent.ASSUME_EDGE || goog.userAgent.ASSUME_OPERA || goog.userAgent.product.ASSUME_FIREFOX || goog.userAgent.product.ASSUME_IPHONE || goog.userAgent.product.ASSUME_IPAD || goog.userAgent.product.ASSUME_ANDROID || goog.userAgent.product.ASSUME_CHROME || goog.userAgent.product.ASSUME_SAFARI, goog.userAgent.product.OPERA = goog.userAgent.OPERA, goog.userAgent.product.IE = goog.userAgent.IE, goog.userAgent.product.EDGE = goog.userAgent.EDGE, goog.userAgent.product.FIREFOX = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_FIREFOX : goog.labs.userAgent.browser.isFirefox(), goog.userAgent.product.isIphoneOrIpod_ = function() {
    return goog.labs.userAgent.platform.isIphone() || goog.labs.userAgent.platform.isIpod();
  }, goog.userAgent.product.IPHONE = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_IPHONE : goog.userAgent.product.isIphoneOrIpod_(), goog.userAgent.product.IPAD = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_IPAD : goog.labs.userAgent.platform.isIpad(), goog.userAgent.product.ANDROID = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_ANDROID : goog.labs.userAgent.browser.isAndroidBrowser(), goog.userAgent.product.CHROME = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_CHROME : goog.labs.userAgent.browser.isChrome(), goog.userAgent.product.isSafariDesktop_ = function() {
    return goog.labs.userAgent.browser.isSafari() && !goog.labs.userAgent.platform.isIos();
  }, goog.userAgent.product.SAFARI = goog.userAgent.product.PRODUCT_KNOWN_ ? goog.userAgent.product.ASSUME_SAFARI : goog.userAgent.product.isSafariDesktop_(), goog.crypt.base64 = {}, goog.crypt.base64.DEFAULT_ALPHABET_COMMON_ = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", goog.crypt.base64.ENCODED_VALS = goog.crypt.base64.DEFAULT_ALPHABET_COMMON_ + "+/=", goog.crypt.base64.ENCODED_VALS_WEBSAFE = goog.crypt.base64.DEFAULT_ALPHABET_COMMON_ + "-_.", goog.crypt.base64.Alphabet = { DEFAULT: 0, NO_PADDING: 1, WEBSAFE: 2, WEBSAFE_DOT_PADDING: 3, WEBSAFE_NO_PADDING: 4 }, goog.crypt.base64.paddingChars_ = "=.", goog.crypt.base64.isPadding_ = function(e) {
    return goog.string.contains(goog.crypt.base64.paddingChars_, e);
  }, goog.crypt.base64.byteToCharMaps_ = {}, goog.crypt.base64.charToByteMap_ = null, goog.crypt.base64.ASSUME_NATIVE_SUPPORT_ = goog.userAgent.GECKO || goog.userAgent.WEBKIT && !goog.userAgent.product.SAFARI || goog.userAgent.OPERA, goog.crypt.base64.HAS_NATIVE_ENCODE_ = goog.crypt.base64.ASSUME_NATIVE_SUPPORT_ || "function" == typeof goog.global.btoa, goog.crypt.base64.HAS_NATIVE_DECODE_ = goog.crypt.base64.ASSUME_NATIVE_SUPPORT_ || !goog.userAgent.product.SAFARI && !goog.userAgent.IE && "function" == typeof goog.global.atob, goog.crypt.base64.encodeByteArray = function(e, t) {
    goog.asserts.assert(goog.isArrayLike(e), "encodeByteArray takes an array as a parameter"), void 0 === t && (t = goog.crypt.base64.Alphabet.DEFAULT), goog.crypt.base64.init_(), t = goog.crypt.base64.byteToCharMaps_[t];
    for (var r = [], o = 0; o < e.length; o += 3) {
      var i = e[o], a2 = o + 1 < e.length, n = a2 ? e[o + 1] : 0, s = o + 2 < e.length, p = s ? e[o + 2] : 0, d = i >> 2;
      i = (3 & i) << 4 | n >> 4, n = (15 & n) << 2 | p >> 6, p &= 63, s || (p = 64, a2 || (n = 64)), r.push(t[d], t[i], t[n] || "", t[p] || "");
    }
    return r.join("");
  }, goog.crypt.base64.encodeString = function(e, t) {
    return goog.crypt.base64.HAS_NATIVE_ENCODE_ && !t ? goog.global.btoa(e) : goog.crypt.base64.encodeByteArray(goog.crypt.stringToByteArray(e), t);
  }, goog.crypt.base64.decodeString = function(e, t) {
    if (goog.crypt.base64.HAS_NATIVE_DECODE_ && !t) return goog.global.atob(e);
    var r = "";
    return goog.crypt.base64.decodeStringInternal_(e, (function(e2) {
      r += String.fromCharCode(e2);
    })), r;
  }, goog.crypt.base64.decodeStringToByteArray = function(e, t) {
    var r = [];
    return goog.crypt.base64.decodeStringInternal_(e, (function(e2) {
      r.push(e2);
    })), r;
  }, goog.crypt.base64.decodeStringToUint8Array = function(e) {
    goog.asserts.assert(!goog.userAgent.IE || goog.userAgent.isVersionOrHigher("10"), "Browser does not support typed arrays");
    var t = e.length, r = 3 * t / 4;
    r % 3 ? r = Math.floor(r) : goog.crypt.base64.isPadding_(e[t - 1]) && (r = goog.crypt.base64.isPadding_(e[t - 2]) ? r - 2 : r - 1);
    var o = new Uint8Array(r), i = 0;
    return goog.crypt.base64.decodeStringInternal_(e, (function(e2) {
      o[i++] = e2;
    })), o.subarray(0, i);
  }, goog.crypt.base64.decodeStringInternal_ = function(e, t) {
    function r(t2) {
      for (; o < e.length; ) {
        var r2 = e.charAt(o++), i2 = goog.crypt.base64.charToByteMap_[r2];
        if (null != i2) return i2;
        if (!goog.string.isEmptyOrWhitespace(r2)) throw Error("Unknown base64 encoding at char: " + r2);
      }
      return t2;
    }
    goog.crypt.base64.init_();
    for (var o = 0; ; ) {
      var i = r(-1), a2 = r(0), n = r(64), s = r(64);
      if (64 === s && -1 === i) break;
      t(i << 2 | a2 >> 4), 64 != n && (t(a2 << 4 & 240 | n >> 2), 64 != s && t(n << 6 & 192 | s));
    }
  }, goog.crypt.base64.init_ = function() {
    if (!goog.crypt.base64.charToByteMap_) {
      goog.crypt.base64.charToByteMap_ = {};
      for (var e = goog.crypt.base64.DEFAULT_ALPHABET_COMMON_.split(""), t = ["+/=", "+/", "-_=", "-_.", "-_"], r = 0; 5 > r; r++) {
        var o = e.concat(t[r].split(""));
        goog.crypt.base64.byteToCharMaps_[r] = o;
        for (var i = 0; i < o.length; i++) {
          var a2 = o[i], n = goog.crypt.base64.charToByteMap_[a2];
          void 0 === n ? goog.crypt.base64.charToByteMap_[a2] = i : goog.asserts.assert(n === i);
        }
      }
    }
  }, jspb.utils = {}, jspb.utils.split64Low = 0, jspb.utils.split64High = 0, jspb.utils.splitUint64 = function(e) {
    var t = e >>> 0;
    e = Math.floor((e - t) / jspb.BinaryConstants.TWO_TO_32) >>> 0, jspb.utils.split64Low = t, jspb.utils.split64High = e;
  }, jspb.utils.splitInt64 = function(e) {
    var t = 0 > e, r = (e = Math.abs(e)) >>> 0;
    e = Math.floor((e - r) / jspb.BinaryConstants.TWO_TO_32), e >>>= 0, t && (e = ~e >>> 0, 4294967295 < (r = 1 + (~r >>> 0)) && (r = 0, 4294967295 < ++e && (e = 0))), jspb.utils.split64Low = r, jspb.utils.split64High = e;
  }, jspb.utils.splitZigzag64 = function(e) {
    var t = 0 > e;
    e = 2 * Math.abs(e), jspb.utils.splitUint64(e), e = jspb.utils.split64Low;
    var r = jspb.utils.split64High;
    t && (0 == e ? 0 == r ? r = e = 4294967295 : (r--, e = 4294967295) : e--), jspb.utils.split64Low = e, jspb.utils.split64High = r;
  }, jspb.utils.splitFloat32 = function(e) {
    var t = 0 > e ? 1 : 0;
    if (0 === (e = t ? -e : e)) 0 < 1 / e ? (jspb.utils.split64High = 0, jspb.utils.split64Low = 0) : (jspb.utils.split64High = 0, jspb.utils.split64Low = 2147483648);
    else if (isNaN(e)) jspb.utils.split64High = 0, jspb.utils.split64Low = 2147483647;
    else if (e > jspb.BinaryConstants.FLOAT32_MAX) jspb.utils.split64High = 0, jspb.utils.split64Low = (t << 31 | 2139095040) >>> 0;
    else if (e < jspb.BinaryConstants.FLOAT32_MIN) e = Math.round(e / Math.pow(2, -149)), jspb.utils.split64High = 0, jspb.utils.split64Low = (t << 31 | e) >>> 0;
    else {
      var r = Math.floor(Math.log(e) / Math.LN2);
      e *= Math.pow(2, -r), 16777216 <= (e = Math.round(e * jspb.BinaryConstants.TWO_TO_23)) && ++r, jspb.utils.split64High = 0, jspb.utils.split64Low = (t << 31 | r + 127 << 23 | 8388607 & e) >>> 0;
    }
  }, jspb.utils.splitFloat64 = function(e) {
    var t = 0 > e ? 1 : 0;
    if (0 === (e = t ? -e : e)) jspb.utils.split64High = 0 < 1 / e ? 0 : 2147483648, jspb.utils.split64Low = 0;
    else if (isNaN(e)) jspb.utils.split64High = 2147483647, jspb.utils.split64Low = 4294967295;
    else if (e > jspb.BinaryConstants.FLOAT64_MAX) jspb.utils.split64High = (t << 31 | 2146435072) >>> 0, jspb.utils.split64Low = 0;
    else if (e < jspb.BinaryConstants.FLOAT64_MIN) {
      var r = e / Math.pow(2, -1074);
      e = r / jspb.BinaryConstants.TWO_TO_32, jspb.utils.split64High = (t << 31 | e) >>> 0, jspb.utils.split64Low = r >>> 0;
    } else {
      var o = 0;
      if (2 <= (r = e)) for (; 2 <= r && 1023 > o; ) o++, r /= 2;
      else for (; 1 > r && -1022 < o; ) r *= 2, o--;
      e = (r = e * Math.pow(2, -o)) * jspb.BinaryConstants.TWO_TO_20 & 1048575, r = r * jspb.BinaryConstants.TWO_TO_52 >>> 0, jspb.utils.split64High = (t << 31 | o + 1023 << 20 | e) >>> 0, jspb.utils.split64Low = r;
    }
  }, jspb.utils.splitHash64 = function(e) {
    var t = e.charCodeAt(0), r = e.charCodeAt(1), o = e.charCodeAt(2), i = e.charCodeAt(3), a2 = e.charCodeAt(4), n = e.charCodeAt(5), s = e.charCodeAt(6);
    e = e.charCodeAt(7), jspb.utils.split64Low = t + (r << 8) + (o << 16) + (i << 24) >>> 0, jspb.utils.split64High = a2 + (n << 8) + (s << 16) + (e << 24) >>> 0;
  }, jspb.utils.joinUint64 = function(e, t) {
    return t * jspb.BinaryConstants.TWO_TO_32 + (e >>> 0);
  }, jspb.utils.joinInt64 = function(e, t) {
    var r = 2147483648 & t;
    return r && (t = ~t >>> 0, 0 == (e = 1 + ~e >>> 0) && (t = t + 1 >>> 0)), e = jspb.utils.joinUint64(e, t), r ? -e : e;
  }, jspb.utils.toZigzag64 = function(e, t, r) {
    var o = t >> 31;
    return r(e << 1 ^ o, (t << 1 | e >>> 31) ^ o);
  }, jspb.utils.joinZigzag64 = function(e, t) {
    return jspb.utils.fromZigzag64(e, t, jspb.utils.joinInt64);
  }, jspb.utils.fromZigzag64 = function(e, t, r) {
    var o = -(1 & e);
    return r((e >>> 1 | t << 31) ^ o, t >>> 1 ^ o);
  }, jspb.utils.joinFloat32 = function(e, t) {
    t = 2 * (e >> 31) + 1;
    var r = e >>> 23 & 255;
    return e &= 8388607, 255 == r ? e ? NaN : 1 / 0 * t : 0 == r ? t * Math.pow(2, -149) * e : t * Math.pow(2, r - 150) * (e + Math.pow(2, 23));
  }, jspb.utils.joinFloat64 = function(e, t) {
    var r = 2 * (t >> 31) + 1, o = t >>> 20 & 2047;
    return e = jspb.BinaryConstants.TWO_TO_32 * (1048575 & t) + e, 2047 == o ? e ? NaN : 1 / 0 * r : 0 == o ? r * Math.pow(2, -1074) * e : r * Math.pow(2, o - 1075) * (e + jspb.BinaryConstants.TWO_TO_52);
  }, jspb.utils.joinHash64 = function(e, t) {
    return String.fromCharCode(e >>> 0 & 255, e >>> 8 & 255, e >>> 16 & 255, e >>> 24 & 255, t >>> 0 & 255, t >>> 8 & 255, t >>> 16 & 255, t >>> 24 & 255);
  }, jspb.utils.DIGITS = "0123456789abcdef".split(""), jspb.utils.ZERO_CHAR_CODE_ = 48, jspb.utils.A_CHAR_CODE_ = 97, jspb.utils.joinUnsignedDecimalString = function(e, t) {
    function r(e2, t2) {
      return e2 = e2 ? String(e2) : "", t2 ? "0000000".slice(e2.length) + e2 : e2;
    }
    if (2097151 >= t) return "" + jspb.utils.joinUint64(e, t);
    var o = (e >>> 24 | t << 8) >>> 0 & 16777215;
    return e = (16777215 & e) + 6777216 * o + 6710656 * (t = t >> 16 & 65535), o += 8147497 * t, t *= 2, 1e7 <= e && (o += Math.floor(e / 1e7), e %= 1e7), 1e7 <= o && (t += Math.floor(o / 1e7), o %= 1e7), r(t, 0) + r(o, t) + r(e, 1);
  }, jspb.utils.joinSignedDecimalString = function(e, t) {
    var r = 2147483648 & t;
    return r && (t = ~t + (0 == (e = 1 + ~e >>> 0) ? 1 : 0) >>> 0), e = jspb.utils.joinUnsignedDecimalString(e, t), r ? "-" + e : e;
  }, jspb.utils.hash64ToDecimalString = function(e, t) {
    jspb.utils.splitHash64(e), e = jspb.utils.split64Low;
    var r = jspb.utils.split64High;
    return t ? jspb.utils.joinSignedDecimalString(e, r) : jspb.utils.joinUnsignedDecimalString(e, r);
  }, jspb.utils.hash64ArrayToDecimalStrings = function(e, t) {
    for (var r = Array(e.length), o = 0; o < e.length; o++) r[o] = jspb.utils.hash64ToDecimalString(e[o], t);
    return r;
  }, jspb.utils.decimalStringToHash64 = function(e) {
    function t(e2, t2) {
      for (var r2 = 0; 8 > r2 && (1 !== e2 || 0 < t2); r2++) t2 = e2 * o[r2] + t2, o[r2] = 255 & t2, t2 >>>= 8;
    }
    jspb.asserts.assert(0 < e.length);
    var r = false;
    "-" === e[0] && (r = true, e = e.slice(1));
    for (var o = [0, 0, 0, 0, 0, 0, 0, 0], i = 0; i < e.length; i++) t(10, e.charCodeAt(i) - jspb.utils.ZERO_CHAR_CODE_);
    return r && ((function() {
      for (var e2 = 0; 8 > e2; e2++) o[e2] = 255 & ~o[e2];
    })(), t(1, 1)), goog.crypt.byteArrayToString(o);
  }, jspb.utils.splitDecimalString = function(e) {
    jspb.utils.splitHash64(jspb.utils.decimalStringToHash64(e));
  }, jspb.utils.toHexDigit_ = function(e) {
    return String.fromCharCode(10 > e ? jspb.utils.ZERO_CHAR_CODE_ + e : jspb.utils.A_CHAR_CODE_ - 10 + e);
  }, jspb.utils.fromHexCharCode_ = function(e) {
    return e >= jspb.utils.A_CHAR_CODE_ ? e - jspb.utils.A_CHAR_CODE_ + 10 : e - jspb.utils.ZERO_CHAR_CODE_;
  }, jspb.utils.hash64ToHexString = function(e) {
    var t = Array(18);
    t[0] = "0", t[1] = "x";
    for (var r = 0; 8 > r; r++) {
      var o = e.charCodeAt(7 - r);
      t[2 * r + 2] = jspb.utils.toHexDigit_(o >> 4), t[2 * r + 3] = jspb.utils.toHexDigit_(15 & o);
    }
    return t.join("");
  }, jspb.utils.hexStringToHash64 = function(e) {
    e = e.toLowerCase(), jspb.asserts.assert(18 == e.length), jspb.asserts.assert("0" == e[0]), jspb.asserts.assert("x" == e[1]);
    for (var t = "", r = 0; 8 > r; r++) {
      var o = jspb.utils.fromHexCharCode_(e.charCodeAt(2 * r + 2)), i = jspb.utils.fromHexCharCode_(e.charCodeAt(2 * r + 3));
      t = String.fromCharCode(16 * o + i) + t;
    }
    return t;
  }, jspb.utils.hash64ToNumber = function(e, t) {
    jspb.utils.splitHash64(e), e = jspb.utils.split64Low;
    var r = jspb.utils.split64High;
    return t ? jspb.utils.joinInt64(e, r) : jspb.utils.joinUint64(e, r);
  }, jspb.utils.numberToHash64 = function(e) {
    return jspb.utils.splitInt64(e), jspb.utils.joinHash64(jspb.utils.split64Low, jspb.utils.split64High);
  }, jspb.utils.countVarints = function(e, t, r) {
    for (var o = 0, i = t; i < r; i++) o += e[i] >> 7;
    return r - t - o;
  }, jspb.utils.countVarintFields = function(e, t, r, o) {
    var i = 0;
    if (128 > (o = 8 * o + jspb.BinaryConstants.WireType.VARINT)) for (; t < r && e[t++] == o; ) for (i++; ; ) {
      var a2 = e[t++];
      if (0 == (128 & a2)) break;
    }
    else for (; t < r; ) {
      for (a2 = o; 128 < a2; ) {
        if (e[t] != (127 & a2 | 128)) return i;
        t++, a2 >>= 7;
      }
      if (e[t++] != a2) break;
      for (i++; 0 != (128 & (a2 = e[t++])); ) ;
    }
    return i;
  }, jspb.utils.countFixedFields_ = function(e, t, r, o, i) {
    var a2 = 0;
    if (128 > o) for (; t < r && e[t++] == o; ) a2++, t += i;
    else for (; t < r; ) {
      for (var n = o; 128 < n; ) {
        if (e[t++] != (127 & n | 128)) return a2;
        n >>= 7;
      }
      if (e[t++] != n) break;
      a2++, t += i;
    }
    return a2;
  }, jspb.utils.countFixed32Fields = function(e, t, r, o) {
    return jspb.utils.countFixedFields_(e, t, r, 8 * o + jspb.BinaryConstants.WireType.FIXED32, 4);
  }, jspb.utils.countFixed64Fields = function(e, t, r, o) {
    return jspb.utils.countFixedFields_(e, t, r, 8 * o + jspb.BinaryConstants.WireType.FIXED64, 8);
  }, jspb.utils.countDelimitedFields = function(e, t, r, o) {
    var i = 0;
    for (o = 8 * o + jspb.BinaryConstants.WireType.DELIMITED; t < r; ) {
      for (var a2 = o; 128 < a2; ) {
        if (e[t++] != (127 & a2 | 128)) return i;
        a2 >>= 7;
      }
      if (e[t++] != a2) break;
      i++;
      for (var n = 0, s = 1; n += (127 & (a2 = e[t++])) * s, s *= 128, 0 != (128 & a2); ) ;
      t += n;
    }
    return i;
  }, jspb.utils.debugBytesToTextFormat = function(e) {
    var t = '"';
    if (e) {
      e = jspb.utils.byteSourceToUint8Array(e);
      for (var r = 0; r < e.length; r++) t += "\\x", 16 > e[r] && (t += "0"), t += e[r].toString(16);
    }
    return t + '"';
  }, jspb.utils.debugScalarToTextFormat = function(e) {
    return "string" == typeof e ? goog.string.quote(e) : e.toString();
  }, jspb.utils.stringToByteArray = function(e) {
    for (var t = new Uint8Array(e.length), r = 0; r < e.length; r++) {
      var o = e.charCodeAt(r);
      if (255 < o) throw Error("Conversion error: string contains codepoint outside of byte range");
      t[r] = o;
    }
    return t;
  }, jspb.utils.byteSourceToUint8Array = function(e) {
    return e.constructor === Uint8Array ? e : e.constructor === ArrayBuffer || e.constructor === Array ? new Uint8Array(e) : e.constructor === String ? goog.crypt.base64.decodeStringToUint8Array(e) : e instanceof Uint8Array ? new Uint8Array(e.buffer, e.byteOffset, e.byteLength) : (jspb.asserts.fail("Type not convertible to Uint8Array."), new Uint8Array(0));
  }, jspb.BinaryDecoder = function(e, t, r) {
    this.bytes_ = null, this.cursor_ = this.end_ = this.start_ = 0, this.error_ = false, e && this.setBlock(e, t, r);
  }, jspb.BinaryDecoder.instanceCache_ = [], jspb.BinaryDecoder.alloc = function(e, t, r) {
    if (jspb.BinaryDecoder.instanceCache_.length) {
      var o = jspb.BinaryDecoder.instanceCache_.pop();
      return e && o.setBlock(e, t, r), o;
    }
    return new jspb.BinaryDecoder(e, t, r);
  }, jspb.BinaryDecoder.prototype.free = function() {
    this.clear(), 100 > jspb.BinaryDecoder.instanceCache_.length && jspb.BinaryDecoder.instanceCache_.push(this);
  }, jspb.BinaryDecoder.prototype.clone = function() {
    return jspb.BinaryDecoder.alloc(this.bytes_, this.start_, this.end_ - this.start_);
  }, jspb.BinaryDecoder.prototype.clear = function() {
    this.bytes_ = null, this.cursor_ = this.end_ = this.start_ = 0, this.error_ = false;
  }, jspb.BinaryDecoder.prototype.getBuffer = function() {
    return this.bytes_;
  }, jspb.BinaryDecoder.prototype.setBlock = function(e, t, r) {
    this.bytes_ = jspb.utils.byteSourceToUint8Array(e), this.start_ = void 0 !== t ? t : 0, this.end_ = void 0 !== r ? this.start_ + r : this.bytes_.length, this.cursor_ = this.start_;
  }, jspb.BinaryDecoder.prototype.getEnd = function() {
    return this.end_;
  }, jspb.BinaryDecoder.prototype.setEnd = function(e) {
    this.end_ = e;
  }, jspb.BinaryDecoder.prototype.reset = function() {
    this.cursor_ = this.start_;
  }, jspb.BinaryDecoder.prototype.getCursor = function() {
    return this.cursor_;
  }, jspb.BinaryDecoder.prototype.setCursor = function(e) {
    this.cursor_ = e;
  }, jspb.BinaryDecoder.prototype.advance = function(e) {
    this.cursor_ += e, jspb.asserts.assert(this.cursor_ <= this.end_);
  }, jspb.BinaryDecoder.prototype.atEnd = function() {
    return this.cursor_ == this.end_;
  }, jspb.BinaryDecoder.prototype.pastEnd = function() {
    return this.cursor_ > this.end_;
  }, jspb.BinaryDecoder.prototype.getError = function() {
    return this.error_ || 0 > this.cursor_ || this.cursor_ > this.end_;
  }, jspb.BinaryDecoder.prototype.readSplitVarint64 = function(e) {
    for (var t = 128, r = 0, o = 0, i = 0; 4 > i && 128 <= t; i++) r |= (127 & (t = this.bytes_[this.cursor_++])) << 7 * i;
    if (128 <= t && (r |= (127 & (t = this.bytes_[this.cursor_++])) << 28, o |= (127 & t) >> 4), 128 <= t) for (i = 0; 5 > i && 128 <= t; i++) o |= (127 & (t = this.bytes_[this.cursor_++])) << 7 * i + 3;
    if (128 > t) return e(r >>> 0, o >>> 0);
    jspb.asserts.fail("Failed to read varint, encoding is invalid."), this.error_ = true;
  }, jspb.BinaryDecoder.prototype.readSplitZigzagVarint64 = function(e) {
    return this.readSplitVarint64((function(t, r) {
      return jspb.utils.fromZigzag64(t, r, e);
    }));
  }, jspb.BinaryDecoder.prototype.readSplitFixed64 = function(e) {
    var t = this.bytes_, r = this.cursor_;
    this.cursor_ += 8;
    for (var o = 0, i = 0, a2 = r + 7; a2 >= r; a2--) o = o << 8 | t[a2], i = i << 8 | t[a2 + 4];
    return e(o, i);
  }, jspb.BinaryDecoder.prototype.skipVarint = function() {
    for (; 128 & this.bytes_[this.cursor_]; ) this.cursor_++;
    this.cursor_++;
  }, jspb.BinaryDecoder.prototype.unskipVarint = function(e) {
    for (; 128 < e; ) this.cursor_--, e >>>= 7;
    this.cursor_--;
  }, jspb.BinaryDecoder.prototype.readUnsignedVarint32 = function() {
    var e = this.bytes_, t = e[this.cursor_ + 0], r = 127 & t;
    return 128 > t ? (this.cursor_ += 1, jspb.asserts.assert(this.cursor_ <= this.end_), r) : (r |= (127 & (t = e[this.cursor_ + 1])) << 7, 128 > t ? (this.cursor_ += 2, jspb.asserts.assert(this.cursor_ <= this.end_), r) : (r |= (127 & (t = e[this.cursor_ + 2])) << 14, 128 > t ? (this.cursor_ += 3, jspb.asserts.assert(this.cursor_ <= this.end_), r) : (r |= (127 & (t = e[this.cursor_ + 3])) << 21, 128 > t ? (this.cursor_ += 4, jspb.asserts.assert(this.cursor_ <= this.end_), r) : (r |= (15 & (t = e[this.cursor_ + 4])) << 28, 128 > t ? (this.cursor_ += 5, jspb.asserts.assert(this.cursor_ <= this.end_), r >>> 0) : (this.cursor_ += 5, 128 <= e[this.cursor_++] && 128 <= e[this.cursor_++] && 128 <= e[this.cursor_++] && 128 <= e[this.cursor_++] && 128 <= e[this.cursor_++] && jspb.asserts.assert(false), jspb.asserts.assert(this.cursor_ <= this.end_), r)))));
  }, jspb.BinaryDecoder.prototype.readSignedVarint32 = function() {
    return ~~this.readUnsignedVarint32();
  }, jspb.BinaryDecoder.prototype.readUnsignedVarint32String = function() {
    return this.readUnsignedVarint32().toString();
  }, jspb.BinaryDecoder.prototype.readSignedVarint32String = function() {
    return this.readSignedVarint32().toString();
  }, jspb.BinaryDecoder.prototype.readZigzagVarint32 = function() {
    var e = this.readUnsignedVarint32();
    return e >>> 1 ^ -(1 & e);
  }, jspb.BinaryDecoder.prototype.readUnsignedVarint64 = function() {
    return this.readSplitVarint64(jspb.utils.joinUint64);
  }, jspb.BinaryDecoder.prototype.readUnsignedVarint64String = function() {
    return this.readSplitVarint64(jspb.utils.joinUnsignedDecimalString);
  }, jspb.BinaryDecoder.prototype.readSignedVarint64 = function() {
    return this.readSplitVarint64(jspb.utils.joinInt64);
  }, jspb.BinaryDecoder.prototype.readSignedVarint64String = function() {
    return this.readSplitVarint64(jspb.utils.joinSignedDecimalString);
  }, jspb.BinaryDecoder.prototype.readZigzagVarint64 = function() {
    return this.readSplitVarint64(jspb.utils.joinZigzag64);
  }, jspb.BinaryDecoder.prototype.readZigzagVarintHash64 = function() {
    return this.readSplitZigzagVarint64(jspb.utils.joinHash64);
  }, jspb.BinaryDecoder.prototype.readZigzagVarint64String = function() {
    return this.readSplitZigzagVarint64(jspb.utils.joinSignedDecimalString);
  }, jspb.BinaryDecoder.prototype.readUint8 = function() {
    var e = this.bytes_[this.cursor_ + 0];
    return this.cursor_ += 1, jspb.asserts.assert(this.cursor_ <= this.end_), e;
  }, jspb.BinaryDecoder.prototype.readUint16 = function() {
    var e = this.bytes_[this.cursor_ + 0], t = this.bytes_[this.cursor_ + 1];
    return this.cursor_ += 2, jspb.asserts.assert(this.cursor_ <= this.end_), e << 0 | t << 8;
  }, jspb.BinaryDecoder.prototype.readUint32 = function() {
    var e = this.bytes_[this.cursor_ + 0], t = this.bytes_[this.cursor_ + 1], r = this.bytes_[this.cursor_ + 2], o = this.bytes_[this.cursor_ + 3];
    return this.cursor_ += 4, jspb.asserts.assert(this.cursor_ <= this.end_), (e << 0 | t << 8 | r << 16 | o << 24) >>> 0;
  }, jspb.BinaryDecoder.prototype.readUint64 = function() {
    var e = this.readUint32(), t = this.readUint32();
    return jspb.utils.joinUint64(e, t);
  }, jspb.BinaryDecoder.prototype.readUint64String = function() {
    var e = this.readUint32(), t = this.readUint32();
    return jspb.utils.joinUnsignedDecimalString(e, t);
  }, jspb.BinaryDecoder.prototype.readInt8 = function() {
    var e = this.bytes_[this.cursor_ + 0];
    return this.cursor_ += 1, jspb.asserts.assert(this.cursor_ <= this.end_), e << 24 >> 24;
  }, jspb.BinaryDecoder.prototype.readInt16 = function() {
    var e = this.bytes_[this.cursor_ + 0], t = this.bytes_[this.cursor_ + 1];
    return this.cursor_ += 2, jspb.asserts.assert(this.cursor_ <= this.end_), (e << 0 | t << 8) << 16 >> 16;
  }, jspb.BinaryDecoder.prototype.readInt32 = function() {
    var e = this.bytes_[this.cursor_ + 0], t = this.bytes_[this.cursor_ + 1], r = this.bytes_[this.cursor_ + 2], o = this.bytes_[this.cursor_ + 3];
    return this.cursor_ += 4, jspb.asserts.assert(this.cursor_ <= this.end_), e << 0 | t << 8 | r << 16 | o << 24;
  }, jspb.BinaryDecoder.prototype.readInt64 = function() {
    var e = this.readUint32(), t = this.readUint32();
    return jspb.utils.joinInt64(e, t);
  }, jspb.BinaryDecoder.prototype.readInt64String = function() {
    var e = this.readUint32(), t = this.readUint32();
    return jspb.utils.joinSignedDecimalString(e, t);
  }, jspb.BinaryDecoder.prototype.readFloat = function() {
    var e = this.readUint32();
    return jspb.utils.joinFloat32(e, 0);
  }, jspb.BinaryDecoder.prototype.readDouble = function() {
    var e = this.readUint32(), t = this.readUint32();
    return jspb.utils.joinFloat64(e, t);
  }, jspb.BinaryDecoder.prototype.readBool = function() {
    return !!this.bytes_[this.cursor_++];
  }, jspb.BinaryDecoder.prototype.readEnum = function() {
    return this.readSignedVarint32();
  }, jspb.BinaryDecoder.prototype.readString = function(e) {
    var t = this.bytes_, r = this.cursor_;
    e = r + e;
    for (var o = [], i = ""; r < e; ) {
      var a2 = t[r++];
      if (128 > a2) o.push(a2);
      else {
        if (192 > a2) continue;
        if (224 > a2) {
          var n = t[r++];
          o.push((31 & a2) << 6 | 63 & n);
        } else if (240 > a2) {
          n = t[r++];
          var s = t[r++];
          o.push((15 & a2) << 12 | (63 & n) << 6 | 63 & s);
        } else if (248 > a2) {
          a2 = (7 & a2) << 18 | (63 & (n = t[r++])) << 12 | (63 & (s = t[r++])) << 6 | 63 & t[r++], a2 -= 65536, o.push(55296 + (a2 >> 10 & 1023), 56320 + (1023 & a2));
        }
      }
      8192 <= o.length && (i += String.fromCharCode.apply(null, o), o.length = 0);
    }
    return i += goog.crypt.byteArrayToString(o), this.cursor_ = r, i;
  }, jspb.BinaryDecoder.prototype.readStringWithLength = function() {
    var e = this.readUnsignedVarint32();
    return this.readString(e);
  }, jspb.BinaryDecoder.prototype.readBytes = function(e) {
    if (0 > e || this.cursor_ + e > this.bytes_.length) return this.error_ = true, jspb.asserts.fail("Invalid byte length!"), new Uint8Array(0);
    var t = this.bytes_.subarray(this.cursor_, this.cursor_ + e);
    return this.cursor_ += e, jspb.asserts.assert(this.cursor_ <= this.end_), t;
  }, jspb.BinaryDecoder.prototype.readVarintHash64 = function() {
    return this.readSplitVarint64(jspb.utils.joinHash64);
  }, jspb.BinaryDecoder.prototype.readFixedHash64 = function() {
    var e = this.bytes_, t = this.cursor_, r = e[t + 0], o = e[t + 1], i = e[t + 2], a2 = e[t + 3], n = e[t + 4], s = e[t + 5], p = e[t + 6];
    return e = e[t + 7], this.cursor_ += 8, String.fromCharCode(r, o, i, a2, n, s, p, e);
  }, jspb.BinaryReader = function(e, t, r) {
    this.decoder_ = jspb.BinaryDecoder.alloc(e, t, r), this.fieldCursor_ = this.decoder_.getCursor(), this.nextField_ = jspb.BinaryConstants.INVALID_FIELD_NUMBER, this.nextWireType_ = jspb.BinaryConstants.WireType.INVALID, this.error_ = false, this.readCallbacks_ = null;
  }, jspb.BinaryReader.instanceCache_ = [], jspb.BinaryReader.alloc = function(e, t, r) {
    if (jspb.BinaryReader.instanceCache_.length) {
      var o = jspb.BinaryReader.instanceCache_.pop();
      return e && o.decoder_.setBlock(e, t, r), o;
    }
    return new jspb.BinaryReader(e, t, r);
  }, jspb.BinaryReader.prototype.alloc = jspb.BinaryReader.alloc, jspb.BinaryReader.prototype.free = function() {
    this.decoder_.clear(), this.nextField_ = jspb.BinaryConstants.INVALID_FIELD_NUMBER, this.nextWireType_ = jspb.BinaryConstants.WireType.INVALID, this.error_ = false, this.readCallbacks_ = null, 100 > jspb.BinaryReader.instanceCache_.length && jspb.BinaryReader.instanceCache_.push(this);
  }, jspb.BinaryReader.prototype.getFieldCursor = function() {
    return this.fieldCursor_;
  }, jspb.BinaryReader.prototype.getCursor = function() {
    return this.decoder_.getCursor();
  }, jspb.BinaryReader.prototype.getBuffer = function() {
    return this.decoder_.getBuffer();
  }, jspb.BinaryReader.prototype.getFieldNumber = function() {
    return this.nextField_;
  }, goog.exportProperty(jspb.BinaryReader.prototype, "getFieldNumber", jspb.BinaryReader.prototype.getFieldNumber), jspb.BinaryReader.prototype.getWireType = function() {
    return this.nextWireType_;
  }, jspb.BinaryReader.prototype.isDelimited = function() {
    return this.nextWireType_ == jspb.BinaryConstants.WireType.DELIMITED;
  }, goog.exportProperty(jspb.BinaryReader.prototype, "isDelimited", jspb.BinaryReader.prototype.isDelimited), jspb.BinaryReader.prototype.isEndGroup = function() {
    return this.nextWireType_ == jspb.BinaryConstants.WireType.END_GROUP;
  }, goog.exportProperty(jspb.BinaryReader.prototype, "isEndGroup", jspb.BinaryReader.prototype.isEndGroup), jspb.BinaryReader.prototype.getError = function() {
    return this.error_ || this.decoder_.getError();
  }, jspb.BinaryReader.prototype.setBlock = function(e, t, r) {
    this.decoder_.setBlock(e, t, r), this.nextField_ = jspb.BinaryConstants.INVALID_FIELD_NUMBER, this.nextWireType_ = jspb.BinaryConstants.WireType.INVALID;
  }, jspb.BinaryReader.prototype.reset = function() {
    this.decoder_.reset(), this.nextField_ = jspb.BinaryConstants.INVALID_FIELD_NUMBER, this.nextWireType_ = jspb.BinaryConstants.WireType.INVALID;
  }, jspb.BinaryReader.prototype.advance = function(e) {
    this.decoder_.advance(e);
  }, jspb.BinaryReader.prototype.nextField = function() {
    if (this.decoder_.atEnd()) return false;
    if (this.getError()) return jspb.asserts.fail("Decoder hit an error"), false;
    this.fieldCursor_ = this.decoder_.getCursor();
    var e = this.decoder_.readUnsignedVarint32(), t = e >>> 3;
    return (e &= 7) != jspb.BinaryConstants.WireType.VARINT && e != jspb.BinaryConstants.WireType.FIXED32 && e != jspb.BinaryConstants.WireType.FIXED64 && e != jspb.BinaryConstants.WireType.DELIMITED && e != jspb.BinaryConstants.WireType.START_GROUP && e != jspb.BinaryConstants.WireType.END_GROUP ? (jspb.asserts.fail("Invalid wire type: %s (at position %s)", e, this.fieldCursor_), this.error_ = true, false) : (this.nextField_ = t, this.nextWireType_ = e, true);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "nextField", jspb.BinaryReader.prototype.nextField), jspb.BinaryReader.prototype.unskipHeader = function() {
    this.decoder_.unskipVarint(this.nextField_ << 3 | this.nextWireType_);
  }, jspb.BinaryReader.prototype.skipMatchingFields = function() {
    var e = this.nextField_;
    for (this.unskipHeader(); this.nextField() && this.getFieldNumber() == e; ) this.skipField();
    this.decoder_.atEnd() || this.unskipHeader();
  }, jspb.BinaryReader.prototype.skipVarintField = function() {
    this.nextWireType_ != jspb.BinaryConstants.WireType.VARINT ? (jspb.asserts.fail("Invalid wire type for skipVarintField"), this.skipField()) : this.decoder_.skipVarint();
  }, jspb.BinaryReader.prototype.skipDelimitedField = function() {
    if (this.nextWireType_ != jspb.BinaryConstants.WireType.DELIMITED) jspb.asserts.fail("Invalid wire type for skipDelimitedField"), this.skipField();
    else {
      var e = this.decoder_.readUnsignedVarint32();
      this.decoder_.advance(e);
    }
  }, jspb.BinaryReader.prototype.skipFixed32Field = function() {
    this.nextWireType_ != jspb.BinaryConstants.WireType.FIXED32 ? (jspb.asserts.fail("Invalid wire type for skipFixed32Field"), this.skipField()) : this.decoder_.advance(4);
  }, jspb.BinaryReader.prototype.skipFixed64Field = function() {
    this.nextWireType_ != jspb.BinaryConstants.WireType.FIXED64 ? (jspb.asserts.fail("Invalid wire type for skipFixed64Field"), this.skipField()) : this.decoder_.advance(8);
  }, jspb.BinaryReader.prototype.skipGroup = function() {
    for (var e = this.nextField_; ; ) {
      if (!this.nextField()) {
        jspb.asserts.fail("Unmatched start-group tag: stream EOF"), this.error_ = true;
        break;
      }
      if (this.nextWireType_ == jspb.BinaryConstants.WireType.END_GROUP) {
        this.nextField_ != e && (jspb.asserts.fail("Unmatched end-group tag"), this.error_ = true);
        break;
      }
      this.skipField();
    }
  }, jspb.BinaryReader.prototype.skipField = function() {
    switch (this.nextWireType_) {
      case jspb.BinaryConstants.WireType.VARINT:
        this.skipVarintField();
        break;
      case jspb.BinaryConstants.WireType.FIXED64:
        this.skipFixed64Field();
        break;
      case jspb.BinaryConstants.WireType.DELIMITED:
        this.skipDelimitedField();
        break;
      case jspb.BinaryConstants.WireType.FIXED32:
        this.skipFixed32Field();
        break;
      case jspb.BinaryConstants.WireType.START_GROUP:
        this.skipGroup();
        break;
      default:
        jspb.asserts.fail("Invalid wire encoding for field.");
    }
  }, jspb.BinaryReader.prototype.registerReadCallback = function(e, t) {
    null === this.readCallbacks_ && (this.readCallbacks_ = {}), jspb.asserts.assert(!this.readCallbacks_[e]), this.readCallbacks_[e] = t;
  }, jspb.BinaryReader.prototype.runReadCallback = function(e) {
    return jspb.asserts.assert(null !== this.readCallbacks_), e = this.readCallbacks_[e], jspb.asserts.assert(e), e(this);
  }, jspb.BinaryReader.prototype.readAny = function(e) {
    this.nextWireType_ = jspb.BinaryConstants.FieldTypeToWireType(e);
    var t = jspb.BinaryConstants.FieldType;
    switch (e) {
      case t.DOUBLE:
        return this.readDouble();
      case t.FLOAT:
        return this.readFloat();
      case t.INT64:
        return this.readInt64();
      case t.UINT64:
        return this.readUint64();
      case t.INT32:
        return this.readInt32();
      case t.FIXED64:
        return this.readFixed64();
      case t.FIXED32:
        return this.readFixed32();
      case t.BOOL:
        return this.readBool();
      case t.STRING:
        return this.readString();
      case t.GROUP:
        jspb.asserts.fail("Group field type not supported in readAny()");
      case t.MESSAGE:
        jspb.asserts.fail("Message field type not supported in readAny()");
      case t.BYTES:
        return this.readBytes();
      case t.UINT32:
        return this.readUint32();
      case t.ENUM:
        return this.readEnum();
      case t.SFIXED32:
        return this.readSfixed32();
      case t.SFIXED64:
        return this.readSfixed64();
      case t.SINT32:
        return this.readSint32();
      case t.SINT64:
        return this.readSint64();
      case t.FHASH64:
        return this.readFixedHash64();
      case t.VHASH64:
        return this.readVarintHash64();
      default:
        jspb.asserts.fail("Invalid field type in readAny()");
    }
    return 0;
  }, jspb.BinaryReader.prototype.readMessage = function(e, t) {
    jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.DELIMITED);
    var r = this.decoder_.getEnd(), o = this.decoder_.readUnsignedVarint32();
    o = this.decoder_.getCursor() + o, this.decoder_.setEnd(o), t(e, this), this.decoder_.setCursor(o), this.decoder_.setEnd(r);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readMessage", jspb.BinaryReader.prototype.readMessage), jspb.BinaryReader.prototype.readGroup = function(e, t, r) {
    jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.START_GROUP), jspb.asserts.assert(this.nextField_ == e), r(t, this), this.error_ || this.nextWireType_ == jspb.BinaryConstants.WireType.END_GROUP || (jspb.asserts.fail("Group submessage did not end with an END_GROUP tag"), this.error_ = true);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readGroup", jspb.BinaryReader.prototype.readGroup), jspb.BinaryReader.prototype.getFieldDecoder = function() {
    jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.DELIMITED);
    var e = this.decoder_.readUnsignedVarint32(), t = this.decoder_.getCursor(), r = t + e;
    return e = jspb.BinaryDecoder.alloc(this.decoder_.getBuffer(), t, e), this.decoder_.setCursor(r), e;
  }, jspb.BinaryReader.prototype.readInt32 = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readSignedVarint32();
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readInt32", jspb.BinaryReader.prototype.readInt32), jspb.BinaryReader.prototype.readInt32String = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readSignedVarint32String();
  }, jspb.BinaryReader.prototype.readInt64 = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readSignedVarint64();
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readInt64", jspb.BinaryReader.prototype.readInt64), jspb.BinaryReader.prototype.readInt64String = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readSignedVarint64String();
  }, jspb.BinaryReader.prototype.readUint32 = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readUnsignedVarint32();
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readUint32", jspb.BinaryReader.prototype.readUint32), jspb.BinaryReader.prototype.readUint32String = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readUnsignedVarint32String();
  }, jspb.BinaryReader.prototype.readUint64 = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readUnsignedVarint64();
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readUint64", jspb.BinaryReader.prototype.readUint64), jspb.BinaryReader.prototype.readUint64String = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readUnsignedVarint64String();
  }, jspb.BinaryReader.prototype.readSint32 = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readZigzagVarint32();
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readSint32", jspb.BinaryReader.prototype.readSint32), jspb.BinaryReader.prototype.readSint64 = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readZigzagVarint64();
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readSint64", jspb.BinaryReader.prototype.readSint64), jspb.BinaryReader.prototype.readSint64String = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readZigzagVarint64String();
  }, jspb.BinaryReader.prototype.readFixed32 = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED32), this.decoder_.readUint32();
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readFixed32", jspb.BinaryReader.prototype.readFixed32), jspb.BinaryReader.prototype.readFixed64 = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED64), this.decoder_.readUint64();
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readFixed64", jspb.BinaryReader.prototype.readFixed64), jspb.BinaryReader.prototype.readFixed64String = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED64), this.decoder_.readUint64String();
  }, jspb.BinaryReader.prototype.readSfixed32 = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED32), this.decoder_.readInt32();
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readSfixed32", jspb.BinaryReader.prototype.readSfixed32), jspb.BinaryReader.prototype.readSfixed32String = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED32), this.decoder_.readInt32().toString();
  }, jspb.BinaryReader.prototype.readSfixed64 = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED64), this.decoder_.readInt64();
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readSfixed64", jspb.BinaryReader.prototype.readSfixed64), jspb.BinaryReader.prototype.readSfixed64String = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED64), this.decoder_.readInt64String();
  }, jspb.BinaryReader.prototype.readFloat = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED32), this.decoder_.readFloat();
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readFloat", jspb.BinaryReader.prototype.readFloat), jspb.BinaryReader.prototype.readDouble = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED64), this.decoder_.readDouble();
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readDouble", jspb.BinaryReader.prototype.readDouble), jspb.BinaryReader.prototype.readBool = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), !!this.decoder_.readUnsignedVarint32();
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readBool", jspb.BinaryReader.prototype.readBool), jspb.BinaryReader.prototype.readEnum = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readSignedVarint64();
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readEnum", jspb.BinaryReader.prototype.readEnum), jspb.BinaryReader.prototype.readString = function() {
    jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.DELIMITED);
    var e = this.decoder_.readUnsignedVarint32();
    return this.decoder_.readString(e);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readString", jspb.BinaryReader.prototype.readString), jspb.BinaryReader.prototype.readBytes = function() {
    jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.DELIMITED);
    var e = this.decoder_.readUnsignedVarint32();
    return this.decoder_.readBytes(e);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readBytes", jspb.BinaryReader.prototype.readBytes), jspb.BinaryReader.prototype.readVarintHash64 = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readVarintHash64();
  }, jspb.BinaryReader.prototype.readSintHash64 = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readZigzagVarintHash64();
  }, jspb.BinaryReader.prototype.readSplitVarint64 = function(e) {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readSplitVarint64(e);
  }, jspb.BinaryReader.prototype.readSplitZigzagVarint64 = function(e) {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.VARINT), this.decoder_.readSplitVarint64((function(t, r) {
      return jspb.utils.fromZigzag64(t, r, e);
    }));
  }, jspb.BinaryReader.prototype.readFixedHash64 = function() {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED64), this.decoder_.readFixedHash64();
  }, jspb.BinaryReader.prototype.readSplitFixed64 = function(e) {
    return jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.FIXED64), this.decoder_.readSplitFixed64(e);
  }, jspb.BinaryReader.prototype.readPackedField_ = function(e) {
    jspb.asserts.assert(this.nextWireType_ == jspb.BinaryConstants.WireType.DELIMITED);
    var t = this.decoder_.readUnsignedVarint32();
    t = this.decoder_.getCursor() + t;
    for (var r = []; this.decoder_.getCursor() < t; ) r.push(e.call(this.decoder_));
    return r;
  }, jspb.BinaryReader.prototype.readPackedInt32 = function() {
    return this.readPackedField_(this.decoder_.readSignedVarint32);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readPackedInt32", jspb.BinaryReader.prototype.readPackedInt32), jspb.BinaryReader.prototype.readPackedInt32String = function() {
    return this.readPackedField_(this.decoder_.readSignedVarint32String);
  }, jspb.BinaryReader.prototype.readPackedInt64 = function() {
    return this.readPackedField_(this.decoder_.readSignedVarint64);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readPackedInt64", jspb.BinaryReader.prototype.readPackedInt64), jspb.BinaryReader.prototype.readPackedInt64String = function() {
    return this.readPackedField_(this.decoder_.readSignedVarint64String);
  }, jspb.BinaryReader.prototype.readPackedUint32 = function() {
    return this.readPackedField_(this.decoder_.readUnsignedVarint32);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readPackedUint32", jspb.BinaryReader.prototype.readPackedUint32), jspb.BinaryReader.prototype.readPackedUint32String = function() {
    return this.readPackedField_(this.decoder_.readUnsignedVarint32String);
  }, jspb.BinaryReader.prototype.readPackedUint64 = function() {
    return this.readPackedField_(this.decoder_.readUnsignedVarint64);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readPackedUint64", jspb.BinaryReader.prototype.readPackedUint64), jspb.BinaryReader.prototype.readPackedUint64String = function() {
    return this.readPackedField_(this.decoder_.readUnsignedVarint64String);
  }, jspb.BinaryReader.prototype.readPackedSint32 = function() {
    return this.readPackedField_(this.decoder_.readZigzagVarint32);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readPackedSint32", jspb.BinaryReader.prototype.readPackedSint32), jspb.BinaryReader.prototype.readPackedSint64 = function() {
    return this.readPackedField_(this.decoder_.readZigzagVarint64);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readPackedSint64", jspb.BinaryReader.prototype.readPackedSint64), jspb.BinaryReader.prototype.readPackedSint64String = function() {
    return this.readPackedField_(this.decoder_.readZigzagVarint64String);
  }, jspb.BinaryReader.prototype.readPackedFixed32 = function() {
    return this.readPackedField_(this.decoder_.readUint32);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readPackedFixed32", jspb.BinaryReader.prototype.readPackedFixed32), jspb.BinaryReader.prototype.readPackedFixed64 = function() {
    return this.readPackedField_(this.decoder_.readUint64);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readPackedFixed64", jspb.BinaryReader.prototype.readPackedFixed64), jspb.BinaryReader.prototype.readPackedFixed64String = function() {
    return this.readPackedField_(this.decoder_.readUint64String);
  }, jspb.BinaryReader.prototype.readPackedSfixed32 = function() {
    return this.readPackedField_(this.decoder_.readInt32);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readPackedSfixed32", jspb.BinaryReader.prototype.readPackedSfixed32), jspb.BinaryReader.prototype.readPackedSfixed64 = function() {
    return this.readPackedField_(this.decoder_.readInt64);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readPackedSfixed64", jspb.BinaryReader.prototype.readPackedSfixed64), jspb.BinaryReader.prototype.readPackedSfixed64String = function() {
    return this.readPackedField_(this.decoder_.readInt64String);
  }, jspb.BinaryReader.prototype.readPackedFloat = function() {
    return this.readPackedField_(this.decoder_.readFloat);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readPackedFloat", jspb.BinaryReader.prototype.readPackedFloat), jspb.BinaryReader.prototype.readPackedDouble = function() {
    return this.readPackedField_(this.decoder_.readDouble);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readPackedDouble", jspb.BinaryReader.prototype.readPackedDouble), jspb.BinaryReader.prototype.readPackedBool = function() {
    return this.readPackedField_(this.decoder_.readBool);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readPackedBool", jspb.BinaryReader.prototype.readPackedBool), jspb.BinaryReader.prototype.readPackedEnum = function() {
    return this.readPackedField_(this.decoder_.readEnum);
  }, goog.exportProperty(jspb.BinaryReader.prototype, "readPackedEnum", jspb.BinaryReader.prototype.readPackedEnum), jspb.BinaryReader.prototype.readPackedVarintHash64 = function() {
    return this.readPackedField_(this.decoder_.readVarintHash64);
  }, jspb.BinaryReader.prototype.readPackedFixedHash64 = function() {
    return this.readPackedField_(this.decoder_.readFixedHash64);
  }, jspb.BinaryEncoder = function() {
    this.buffer_ = [];
  }, jspb.BinaryEncoder.prototype.length = function() {
    return this.buffer_.length;
  }, jspb.BinaryEncoder.prototype.end = function() {
    var e = this.buffer_;
    return this.buffer_ = [], e;
  }, jspb.BinaryEncoder.prototype.writeSplitVarint64 = function(e, t) {
    for (jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(t == Math.floor(t)), jspb.asserts.assert(0 <= e && e < jspb.BinaryConstants.TWO_TO_32), jspb.asserts.assert(0 <= t && t < jspb.BinaryConstants.TWO_TO_32); 0 < t || 127 < e; ) this.buffer_.push(127 & e | 128), e = (e >>> 7 | t << 25) >>> 0, t >>>= 7;
    this.buffer_.push(e);
  }, jspb.BinaryEncoder.prototype.writeSplitFixed64 = function(e, t) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(t == Math.floor(t)), jspb.asserts.assert(0 <= e && e < jspb.BinaryConstants.TWO_TO_32), jspb.asserts.assert(0 <= t && t < jspb.BinaryConstants.TWO_TO_32), this.writeUint32(e), this.writeUint32(t);
  }, jspb.BinaryEncoder.prototype.writeUnsignedVarint32 = function(e) {
    for (jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(0 <= e && e < jspb.BinaryConstants.TWO_TO_32); 127 < e; ) this.buffer_.push(127 & e | 128), e >>>= 7;
    this.buffer_.push(e);
  }, jspb.BinaryEncoder.prototype.writeSignedVarint32 = function(e) {
    if (jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(e >= -jspb.BinaryConstants.TWO_TO_31 && e < jspb.BinaryConstants.TWO_TO_31), 0 <= e) this.writeUnsignedVarint32(e);
    else {
      for (var t = 0; 9 > t; t++) this.buffer_.push(127 & e | 128), e >>= 7;
      this.buffer_.push(1);
    }
  }, jspb.BinaryEncoder.prototype.writeUnsignedVarint64 = function(e) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(0 <= e && e < jspb.BinaryConstants.TWO_TO_64), jspb.utils.splitInt64(e), this.writeSplitVarint64(jspb.utils.split64Low, jspb.utils.split64High);
  }, jspb.BinaryEncoder.prototype.writeSignedVarint64 = function(e) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(e >= -jspb.BinaryConstants.TWO_TO_63 && e < jspb.BinaryConstants.TWO_TO_63), jspb.utils.splitInt64(e), this.writeSplitVarint64(jspb.utils.split64Low, jspb.utils.split64High);
  }, jspb.BinaryEncoder.prototype.writeZigzagVarint32 = function(e) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(e >= -jspb.BinaryConstants.TWO_TO_31 && e < jspb.BinaryConstants.TWO_TO_31), this.writeUnsignedVarint32((e << 1 ^ e >> 31) >>> 0);
  }, jspb.BinaryEncoder.prototype.writeZigzagVarint64 = function(e) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(e >= -jspb.BinaryConstants.TWO_TO_63 && e < jspb.BinaryConstants.TWO_TO_63), jspb.utils.splitZigzag64(e), this.writeSplitVarint64(jspb.utils.split64Low, jspb.utils.split64High);
  }, jspb.BinaryEncoder.prototype.writeZigzagVarint64String = function(e) {
    this.writeZigzagVarintHash64(jspb.utils.decimalStringToHash64(e));
  }, jspb.BinaryEncoder.prototype.writeZigzagVarintHash64 = function(e) {
    var t = this;
    jspb.utils.splitHash64(e), jspb.utils.toZigzag64(jspb.utils.split64Low, jspb.utils.split64High, (function(e2, r) {
      t.writeSplitVarint64(e2 >>> 0, r >>> 0);
    }));
  }, jspb.BinaryEncoder.prototype.writeUint8 = function(e) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(0 <= e && 256 > e), this.buffer_.push(e >>> 0 & 255);
  }, jspb.BinaryEncoder.prototype.writeUint16 = function(e) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(0 <= e && 65536 > e), this.buffer_.push(e >>> 0 & 255), this.buffer_.push(e >>> 8 & 255);
  }, jspb.BinaryEncoder.prototype.writeUint32 = function(e) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(0 <= e && e < jspb.BinaryConstants.TWO_TO_32), this.buffer_.push(e >>> 0 & 255), this.buffer_.push(e >>> 8 & 255), this.buffer_.push(e >>> 16 & 255), this.buffer_.push(e >>> 24 & 255);
  }, jspb.BinaryEncoder.prototype.writeUint64 = function(e) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(0 <= e && e < jspb.BinaryConstants.TWO_TO_64), jspb.utils.splitUint64(e), this.writeUint32(jspb.utils.split64Low), this.writeUint32(jspb.utils.split64High);
  }, jspb.BinaryEncoder.prototype.writeInt8 = function(e) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(-128 <= e && 128 > e), this.buffer_.push(e >>> 0 & 255);
  }, jspb.BinaryEncoder.prototype.writeInt16 = function(e) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(-32768 <= e && 32768 > e), this.buffer_.push(e >>> 0 & 255), this.buffer_.push(e >>> 8 & 255);
  }, jspb.BinaryEncoder.prototype.writeInt32 = function(e) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(e >= -jspb.BinaryConstants.TWO_TO_31 && e < jspb.BinaryConstants.TWO_TO_31), this.buffer_.push(e >>> 0 & 255), this.buffer_.push(e >>> 8 & 255), this.buffer_.push(e >>> 16 & 255), this.buffer_.push(e >>> 24 & 255);
  }, jspb.BinaryEncoder.prototype.writeInt64 = function(e) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(e >= -jspb.BinaryConstants.TWO_TO_63 && e < jspb.BinaryConstants.TWO_TO_63), jspb.utils.splitInt64(e), this.writeSplitFixed64(jspb.utils.split64Low, jspb.utils.split64High);
  }, jspb.BinaryEncoder.prototype.writeInt64String = function(e) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(+e >= -jspb.BinaryConstants.TWO_TO_63 && +e < jspb.BinaryConstants.TWO_TO_63), jspb.utils.splitHash64(jspb.utils.decimalStringToHash64(e)), this.writeSplitFixed64(jspb.utils.split64Low, jspb.utils.split64High);
  }, jspb.BinaryEncoder.prototype.writeFloat = function(e) {
    jspb.asserts.assert(1 / 0 === e || -1 / 0 === e || isNaN(e) || e >= -jspb.BinaryConstants.FLOAT32_MAX && e <= jspb.BinaryConstants.FLOAT32_MAX), jspb.utils.splitFloat32(e), this.writeUint32(jspb.utils.split64Low);
  }, jspb.BinaryEncoder.prototype.writeDouble = function(e) {
    jspb.asserts.assert(1 / 0 === e || -1 / 0 === e || isNaN(e) || e >= -jspb.BinaryConstants.FLOAT64_MAX && e <= jspb.BinaryConstants.FLOAT64_MAX), jspb.utils.splitFloat64(e), this.writeUint32(jspb.utils.split64Low), this.writeUint32(jspb.utils.split64High);
  }, jspb.BinaryEncoder.prototype.writeBool = function(e) {
    jspb.asserts.assert("boolean" == typeof e || "number" == typeof e), this.buffer_.push(e ? 1 : 0);
  }, jspb.BinaryEncoder.prototype.writeEnum = function(e) {
    jspb.asserts.assert(e == Math.floor(e)), jspb.asserts.assert(e >= -jspb.BinaryConstants.TWO_TO_31 && e < jspb.BinaryConstants.TWO_TO_31), this.writeSignedVarint32(e);
  }, jspb.BinaryEncoder.prototype.writeBytes = function(e) {
    this.buffer_.push.apply(this.buffer_, e);
  }, jspb.BinaryEncoder.prototype.writeVarintHash64 = function(e) {
    jspb.utils.splitHash64(e), this.writeSplitVarint64(jspb.utils.split64Low, jspb.utils.split64High);
  }, jspb.BinaryEncoder.prototype.writeFixedHash64 = function(e) {
    jspb.utils.splitHash64(e), this.writeUint32(jspb.utils.split64Low), this.writeUint32(jspb.utils.split64High);
  }, jspb.BinaryEncoder.prototype.writeString = function(e) {
    var t = this.buffer_.length;
    jspb.asserts.assertString(e);
    for (var r = 0; r < e.length; r++) {
      var o = e.charCodeAt(r);
      if (128 > o) this.buffer_.push(o);
      else if (2048 > o) this.buffer_.push(o >> 6 | 192), this.buffer_.push(63 & o | 128);
      else if (65536 > o) if (55296 <= o && 56319 >= o && r + 1 < e.length) {
        var i = e.charCodeAt(r + 1);
        56320 <= i && 57343 >= i && (o = 1024 * (o - 55296) + i - 56320 + 65536, this.buffer_.push(o >> 18 | 240), this.buffer_.push(o >> 12 & 63 | 128), this.buffer_.push(o >> 6 & 63 | 128), this.buffer_.push(63 & o | 128), r++);
      } else this.buffer_.push(o >> 12 | 224), this.buffer_.push(o >> 6 & 63 | 128), this.buffer_.push(63 & o | 128);
    }
    return this.buffer_.length - t;
  }, jspb.arith = {}, jspb.arith.UInt64 = function(e, t) {
    this.lo = e, this.hi = t;
  }, jspb.arith.UInt64.prototype.cmp = function(e) {
    return this.hi < e.hi || this.hi == e.hi && this.lo < e.lo ? -1 : this.hi == e.hi && this.lo == e.lo ? 0 : 1;
  }, jspb.arith.UInt64.prototype.rightShift = function() {
    return new jspb.arith.UInt64((this.lo >>> 1 | (1 & this.hi) << 31) >>> 0, this.hi >>> 1 >>> 0);
  }, jspb.arith.UInt64.prototype.leftShift = function() {
    return new jspb.arith.UInt64(this.lo << 1 >>> 0, (this.hi << 1 | this.lo >>> 31) >>> 0);
  }, jspb.arith.UInt64.prototype.msb = function() {
    return !!(2147483648 & this.hi);
  }, jspb.arith.UInt64.prototype.lsb = function() {
    return !!(1 & this.lo);
  }, jspb.arith.UInt64.prototype.zero = function() {
    return 0 == this.lo && 0 == this.hi;
  }, jspb.arith.UInt64.prototype.add = function(e) {
    return new jspb.arith.UInt64((this.lo + e.lo & 4294967295) >>> 0 >>> 0, ((this.hi + e.hi & 4294967295) >>> 0) + (4294967296 <= this.lo + e.lo ? 1 : 0) >>> 0);
  }, jspb.arith.UInt64.prototype.sub = function(e) {
    return new jspb.arith.UInt64((this.lo - e.lo & 4294967295) >>> 0 >>> 0, ((this.hi - e.hi & 4294967295) >>> 0) - (0 > this.lo - e.lo ? 1 : 0) >>> 0);
  }, jspb.arith.UInt64.mul32x32 = function(e, t) {
    var r = 65535 & e, o = 65535 & t, i = t >>> 16;
    for (t = r * o + 65536 * (r * i & 65535) + 65536 * ((e >>>= 16) * o & 65535), r = e * i + (r * i >>> 16) + (e * o >>> 16); 4294967296 <= t; ) t -= 4294967296, r += 1;
    return new jspb.arith.UInt64(t >>> 0, r >>> 0);
  }, jspb.arith.UInt64.prototype.mul = function(e) {
    var t = jspb.arith.UInt64.mul32x32(this.lo, e);
    return (e = jspb.arith.UInt64.mul32x32(this.hi, e)).hi = e.lo, e.lo = 0, t.add(e);
  }, jspb.arith.UInt64.prototype.div = function(e) {
    if (0 == e) return [];
    var t = new jspb.arith.UInt64(0, 0), r = new jspb.arith.UInt64(this.lo, this.hi);
    e = new jspb.arith.UInt64(e, 0);
    for (var o = new jspb.arith.UInt64(1, 0); !e.msb(); ) e = e.leftShift(), o = o.leftShift();
    for (; !o.zero(); ) 0 >= e.cmp(r) && (t = t.add(o), r = r.sub(e)), e = e.rightShift(), o = o.rightShift();
    return [t, r];
  }, jspb.arith.UInt64.prototype.toString = function() {
    for (var e = "", t = this; !t.zero(); ) {
      var r = (t = t.div(10))[0];
      e = t[1].lo + e, t = r;
    }
    return "" == e && (e = "0"), e;
  }, jspb.arith.UInt64.fromString = function(e) {
    for (var t = new jspb.arith.UInt64(0, 0), r = new jspb.arith.UInt64(0, 0), o = 0; o < e.length; o++) {
      if ("0" > e[o] || "9" < e[o]) return null;
      var i = parseInt(e[o], 10);
      r.lo = i, t = t.mul(10).add(r);
    }
    return t;
  }, jspb.arith.UInt64.prototype.clone = function() {
    return new jspb.arith.UInt64(this.lo, this.hi);
  }, jspb.arith.Int64 = function(e, t) {
    this.lo = e, this.hi = t;
  }, jspb.arith.Int64.prototype.add = function(e) {
    return new jspb.arith.Int64((this.lo + e.lo & 4294967295) >>> 0 >>> 0, ((this.hi + e.hi & 4294967295) >>> 0) + (4294967296 <= this.lo + e.lo ? 1 : 0) >>> 0);
  }, jspb.arith.Int64.prototype.sub = function(e) {
    return new jspb.arith.Int64((this.lo - e.lo & 4294967295) >>> 0 >>> 0, ((this.hi - e.hi & 4294967295) >>> 0) - (0 > this.lo - e.lo ? 1 : 0) >>> 0);
  }, jspb.arith.Int64.prototype.clone = function() {
    return new jspb.arith.Int64(this.lo, this.hi);
  }, jspb.arith.Int64.prototype.toString = function() {
    var e = 0 != (2147483648 & this.hi), t = new jspb.arith.UInt64(this.lo, this.hi);
    return e && (t = new jspb.arith.UInt64(0, 0).sub(t)), (e ? "-" : "") + t.toString();
  }, jspb.arith.Int64.fromString = function(e) {
    var t = 0 < e.length && "-" == e[0];
    return t && (e = e.substring(1)), null === (e = jspb.arith.UInt64.fromString(e)) ? null : (t && (e = new jspb.arith.UInt64(0, 0).sub(e)), new jspb.arith.Int64(e.lo, e.hi));
  }, jspb.BinaryWriter = function() {
    this.blocks_ = [], this.totalLength_ = 0, this.encoder_ = new jspb.BinaryEncoder(), this.bookmarks_ = [];
  }, jspb.BinaryWriter.prototype.appendUint8Array_ = function(e) {
    var t = this.encoder_.end();
    this.blocks_.push(t), this.blocks_.push(e), this.totalLength_ += t.length + e.length;
  }, jspb.BinaryWriter.prototype.beginDelimited_ = function(e) {
    return this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), e = this.encoder_.end(), this.blocks_.push(e), this.totalLength_ += e.length, e.push(this.totalLength_), e;
  }, jspb.BinaryWriter.prototype.endDelimited_ = function(e) {
    var t = e.pop();
    for (t = this.totalLength_ + this.encoder_.length() - t, jspb.asserts.assert(0 <= t); 127 < t; ) e.push(127 & t | 128), t >>>= 7, this.totalLength_++;
    e.push(t), this.totalLength_++;
  }, jspb.BinaryWriter.prototype.writeSerializedMessage = function(e, t, r) {
    this.appendUint8Array_(e.subarray(t, r));
  }, jspb.BinaryWriter.prototype.maybeWriteSerializedMessage = function(e, t, r) {
    null != e && null != t && null != r && this.writeSerializedMessage(e, t, r);
  }, jspb.BinaryWriter.prototype.reset = function() {
    this.blocks_ = [], this.encoder_.end(), this.totalLength_ = 0, this.bookmarks_ = [];
  }, jspb.BinaryWriter.prototype.getResultBuffer = function() {
    jspb.asserts.assert(0 == this.bookmarks_.length);
    for (var e = new Uint8Array(this.totalLength_ + this.encoder_.length()), t = this.blocks_, r = t.length, o = 0, i = 0; i < r; i++) {
      var a2 = t[i];
      e.set(a2, o), o += a2.length;
    }
    return t = this.encoder_.end(), e.set(t, o), o += t.length, jspb.asserts.assert(o == e.length), this.blocks_ = [e], e;
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "getResultBuffer", jspb.BinaryWriter.prototype.getResultBuffer), jspb.BinaryWriter.prototype.getResultBase64String = function(e) {
    return goog.crypt.base64.encodeByteArray(this.getResultBuffer(), e);
  }, jspb.BinaryWriter.prototype.beginSubMessage = function(e) {
    this.bookmarks_.push(this.beginDelimited_(e));
  }, jspb.BinaryWriter.prototype.endSubMessage = function() {
    jspb.asserts.assert(0 <= this.bookmarks_.length), this.endDelimited_(this.bookmarks_.pop());
  }, jspb.BinaryWriter.prototype.writeFieldHeader_ = function(e, t) {
    jspb.asserts.assert(1 <= e && e == Math.floor(e)), this.encoder_.writeUnsignedVarint32(8 * e + t);
  }, jspb.BinaryWriter.prototype.writeAny = function(e, t, r) {
    var o = jspb.BinaryConstants.FieldType;
    switch (e) {
      case o.DOUBLE:
        this.writeDouble(t, r);
        break;
      case o.FLOAT:
        this.writeFloat(t, r);
        break;
      case o.INT64:
        this.writeInt64(t, r);
        break;
      case o.UINT64:
        this.writeUint64(t, r);
        break;
      case o.INT32:
        this.writeInt32(t, r);
        break;
      case o.FIXED64:
        this.writeFixed64(t, r);
        break;
      case o.FIXED32:
        this.writeFixed32(t, r);
        break;
      case o.BOOL:
        this.writeBool(t, r);
        break;
      case o.STRING:
        this.writeString(t, r);
        break;
      case o.GROUP:
        jspb.asserts.fail("Group field type not supported in writeAny()");
        break;
      case o.MESSAGE:
        jspb.asserts.fail("Message field type not supported in writeAny()");
        break;
      case o.BYTES:
        this.writeBytes(t, r);
        break;
      case o.UINT32:
        this.writeUint32(t, r);
        break;
      case o.ENUM:
        this.writeEnum(t, r);
        break;
      case o.SFIXED32:
        this.writeSfixed32(t, r);
        break;
      case o.SFIXED64:
        this.writeSfixed64(t, r);
        break;
      case o.SINT32:
        this.writeSint32(t, r);
        break;
      case o.SINT64:
        this.writeSint64(t, r);
        break;
      case o.FHASH64:
        this.writeFixedHash64(t, r);
        break;
      case o.VHASH64:
        this.writeVarintHash64(t, r);
        break;
      default:
        jspb.asserts.fail("Invalid field type in writeAny()");
    }
  }, jspb.BinaryWriter.prototype.writeUnsignedVarint32_ = function(e, t) {
    null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeUnsignedVarint32(t));
  }, jspb.BinaryWriter.prototype.writeSignedVarint32_ = function(e, t) {
    null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeSignedVarint32(t));
  }, jspb.BinaryWriter.prototype.writeUnsignedVarint64_ = function(e, t) {
    null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeUnsignedVarint64(t));
  }, jspb.BinaryWriter.prototype.writeSignedVarint64_ = function(e, t) {
    null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeSignedVarint64(t));
  }, jspb.BinaryWriter.prototype.writeZigzagVarint32_ = function(e, t) {
    null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeZigzagVarint32(t));
  }, jspb.BinaryWriter.prototype.writeZigzagVarint64_ = function(e, t) {
    null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeZigzagVarint64(t));
  }, jspb.BinaryWriter.prototype.writeZigzagVarint64String_ = function(e, t) {
    null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeZigzagVarint64String(t));
  }, jspb.BinaryWriter.prototype.writeZigzagVarintHash64_ = function(e, t) {
    null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeZigzagVarintHash64(t));
  }, jspb.BinaryWriter.prototype.writeInt32 = function(e, t) {
    null != t && (jspb.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_31 && t < jspb.BinaryConstants.TWO_TO_31), this.writeSignedVarint32_(e, t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeInt32", jspb.BinaryWriter.prototype.writeInt32), jspb.BinaryWriter.prototype.writeInt32String = function(e, t) {
    null != t && (t = parseInt(t, 10), jspb.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_31 && t < jspb.BinaryConstants.TWO_TO_31), this.writeSignedVarint32_(e, t));
  }, jspb.BinaryWriter.prototype.writeInt64 = function(e, t) {
    null != t && (jspb.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_63 && t < jspb.BinaryConstants.TWO_TO_63), this.writeSignedVarint64_(e, t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeInt64", jspb.BinaryWriter.prototype.writeInt64), jspb.BinaryWriter.prototype.writeInt64String = function(e, t) {
    null != t && (t = jspb.arith.Int64.fromString(t), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeSplitVarint64(t.lo, t.hi));
  }, jspb.BinaryWriter.prototype.writeUint32 = function(e, t) {
    null != t && (jspb.asserts.assert(0 <= t && t < jspb.BinaryConstants.TWO_TO_32), this.writeUnsignedVarint32_(e, t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeUint32", jspb.BinaryWriter.prototype.writeUint32), jspb.BinaryWriter.prototype.writeUint32String = function(e, t) {
    null != t && (t = parseInt(t, 10), jspb.asserts.assert(0 <= t && t < jspb.BinaryConstants.TWO_TO_32), this.writeUnsignedVarint32_(e, t));
  }, jspb.BinaryWriter.prototype.writeUint64 = function(e, t) {
    null != t && (jspb.asserts.assert(0 <= t && t < jspb.BinaryConstants.TWO_TO_64), this.writeUnsignedVarint64_(e, t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeUint64", jspb.BinaryWriter.prototype.writeUint64), jspb.BinaryWriter.prototype.writeUint64String = function(e, t) {
    null != t && (t = jspb.arith.UInt64.fromString(t), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeSplitVarint64(t.lo, t.hi));
  }, jspb.BinaryWriter.prototype.writeSint32 = function(e, t) {
    null != t && (jspb.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_31 && t < jspb.BinaryConstants.TWO_TO_31), this.writeZigzagVarint32_(e, t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeSint32", jspb.BinaryWriter.prototype.writeSint32), jspb.BinaryWriter.prototype.writeSint64 = function(e, t) {
    null != t && (jspb.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_63 && t < jspb.BinaryConstants.TWO_TO_63), this.writeZigzagVarint64_(e, t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeSint64", jspb.BinaryWriter.prototype.writeSint64), jspb.BinaryWriter.prototype.writeSintHash64 = function(e, t) {
    null != t && this.writeZigzagVarintHash64_(e, t);
  }, jspb.BinaryWriter.prototype.writeSint64String = function(e, t) {
    null != t && this.writeZigzagVarint64String_(e, t);
  }, jspb.BinaryWriter.prototype.writeFixed32 = function(e, t) {
    null != t && (jspb.asserts.assert(0 <= t && t < jspb.BinaryConstants.TWO_TO_32), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED32), this.encoder_.writeUint32(t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeFixed32", jspb.BinaryWriter.prototype.writeFixed32), jspb.BinaryWriter.prototype.writeFixed64 = function(e, t) {
    null != t && (jspb.asserts.assert(0 <= t && t < jspb.BinaryConstants.TWO_TO_64), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED64), this.encoder_.writeUint64(t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeFixed64", jspb.BinaryWriter.prototype.writeFixed64), jspb.BinaryWriter.prototype.writeFixed64String = function(e, t) {
    null != t && (t = jspb.arith.UInt64.fromString(t), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED64), this.encoder_.writeSplitFixed64(t.lo, t.hi));
  }, jspb.BinaryWriter.prototype.writeSfixed32 = function(e, t) {
    null != t && (jspb.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_31 && t < jspb.BinaryConstants.TWO_TO_31), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED32), this.encoder_.writeInt32(t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeSfixed32", jspb.BinaryWriter.prototype.writeSfixed32), jspb.BinaryWriter.prototype.writeSfixed64 = function(e, t) {
    null != t && (jspb.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_63 && t < jspb.BinaryConstants.TWO_TO_63), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED64), this.encoder_.writeInt64(t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeSfixed64", jspb.BinaryWriter.prototype.writeSfixed64), jspb.BinaryWriter.prototype.writeSfixed64String = function(e, t) {
    null != t && (t = jspb.arith.Int64.fromString(t), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED64), this.encoder_.writeSplitFixed64(t.lo, t.hi));
  }, jspb.BinaryWriter.prototype.writeFloat = function(e, t) {
    null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED32), this.encoder_.writeFloat(t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeFloat", jspb.BinaryWriter.prototype.writeFloat), jspb.BinaryWriter.prototype.writeDouble = function(e, t) {
    null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED64), this.encoder_.writeDouble(t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeDouble", jspb.BinaryWriter.prototype.writeDouble), jspb.BinaryWriter.prototype.writeBool = function(e, t) {
    null != t && (jspb.asserts.assert("boolean" == typeof t || "number" == typeof t), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeBool(t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeBool", jspb.BinaryWriter.prototype.writeBool), jspb.BinaryWriter.prototype.writeEnum = function(e, t) {
    null != t && (jspb.asserts.assert(t >= -jspb.BinaryConstants.TWO_TO_31 && t < jspb.BinaryConstants.TWO_TO_31), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeSignedVarint32(t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeEnum", jspb.BinaryWriter.prototype.writeEnum), jspb.BinaryWriter.prototype.writeString = function(e, t) {
    null != t && (e = this.beginDelimited_(e), this.encoder_.writeString(t), this.endDelimited_(e));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeString", jspb.BinaryWriter.prototype.writeString), jspb.BinaryWriter.prototype.writeBytes = function(e, t) {
    null != t && (t = jspb.utils.byteSourceToUint8Array(t), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(t.length), this.appendUint8Array_(t));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeBytes", jspb.BinaryWriter.prototype.writeBytes), jspb.BinaryWriter.prototype.writeMessage = function(e, t, r) {
    null != t && (e = this.beginDelimited_(e), r(t, this), this.endDelimited_(e));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeMessage", jspb.BinaryWriter.prototype.writeMessage), jspb.BinaryWriter.prototype.writeMessageSet = function(e, t, r) {
    null != t && (this.writeFieldHeader_(1, jspb.BinaryConstants.WireType.START_GROUP), this.writeFieldHeader_(2, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeSignedVarint32(e), e = this.beginDelimited_(3), r(t, this), this.endDelimited_(e), this.writeFieldHeader_(1, jspb.BinaryConstants.WireType.END_GROUP));
  }, jspb.BinaryWriter.prototype.writeGroup = function(e, t, r) {
    null != t && (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.START_GROUP), r(t, this), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.END_GROUP));
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeGroup", jspb.BinaryWriter.prototype.writeGroup), jspb.BinaryWriter.prototype.writeFixedHash64 = function(e, t) {
    null != t && (jspb.asserts.assert(8 == t.length), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED64), this.encoder_.writeFixedHash64(t));
  }, jspb.BinaryWriter.prototype.writeVarintHash64 = function(e, t) {
    null != t && (jspb.asserts.assert(8 == t.length), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeVarintHash64(t));
  }, jspb.BinaryWriter.prototype.writeSplitFixed64 = function(e, t, r) {
    this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.FIXED64), this.encoder_.writeSplitFixed64(t, r);
  }, jspb.BinaryWriter.prototype.writeSplitVarint64 = function(e, t, r) {
    this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT), this.encoder_.writeSplitVarint64(t, r);
  }, jspb.BinaryWriter.prototype.writeSplitZigzagVarint64 = function(e, t, r) {
    this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.VARINT);
    var o = this.encoder_;
    jspb.utils.toZigzag64(t, r, (function(e2, t2) {
      o.writeSplitVarint64(e2 >>> 0, t2 >>> 0);
    }));
  }, jspb.BinaryWriter.prototype.writeRepeatedInt32 = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeSignedVarint32_(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedInt32", jspb.BinaryWriter.prototype.writeRepeatedInt32), jspb.BinaryWriter.prototype.writeRepeatedInt32String = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeInt32String(e, t[r]);
  }, jspb.BinaryWriter.prototype.writeRepeatedInt64 = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeSignedVarint64_(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedInt64", jspb.BinaryWriter.prototype.writeRepeatedInt64), jspb.BinaryWriter.prototype.writeRepeatedSplitFixed64 = function(e, t, r, o) {
    if (null != t) for (var i = 0; i < t.length; i++) this.writeSplitFixed64(e, r(t[i]), o(t[i]));
  }, jspb.BinaryWriter.prototype.writeRepeatedSplitVarint64 = function(e, t, r, o) {
    if (null != t) for (var i = 0; i < t.length; i++) this.writeSplitVarint64(e, r(t[i]), o(t[i]));
  }, jspb.BinaryWriter.prototype.writeRepeatedSplitZigzagVarint64 = function(e, t, r, o) {
    if (null != t) for (var i = 0; i < t.length; i++) this.writeSplitZigzagVarint64(e, r(t[i]), o(t[i]));
  }, jspb.BinaryWriter.prototype.writeRepeatedInt64String = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeInt64String(e, t[r]);
  }, jspb.BinaryWriter.prototype.writeRepeatedUint32 = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeUnsignedVarint32_(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedUint32", jspb.BinaryWriter.prototype.writeRepeatedUint32), jspb.BinaryWriter.prototype.writeRepeatedUint32String = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeUint32String(e, t[r]);
  }, jspb.BinaryWriter.prototype.writeRepeatedUint64 = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeUnsignedVarint64_(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedUint64", jspb.BinaryWriter.prototype.writeRepeatedUint64), jspb.BinaryWriter.prototype.writeRepeatedUint64String = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeUint64String(e, t[r]);
  }, jspb.BinaryWriter.prototype.writeRepeatedSint32 = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeZigzagVarint32_(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedSint32", jspb.BinaryWriter.prototype.writeRepeatedSint32), jspb.BinaryWriter.prototype.writeRepeatedSint64 = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeZigzagVarint64_(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedSint64", jspb.BinaryWriter.prototype.writeRepeatedSint64), jspb.BinaryWriter.prototype.writeRepeatedSint64String = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeZigzagVarint64String_(e, t[r]);
  }, jspb.BinaryWriter.prototype.writeRepeatedSintHash64 = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeZigzagVarintHash64_(e, t[r]);
  }, jspb.BinaryWriter.prototype.writeRepeatedFixed32 = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeFixed32(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedFixed32", jspb.BinaryWriter.prototype.writeRepeatedFixed32), jspb.BinaryWriter.prototype.writeRepeatedFixed64 = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeFixed64(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedFixed64", jspb.BinaryWriter.prototype.writeRepeatedFixed64), jspb.BinaryWriter.prototype.writeRepeatedFixed64String = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeFixed64String(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedFixed64String", jspb.BinaryWriter.prototype.writeRepeatedFixed64String), jspb.BinaryWriter.prototype.writeRepeatedSfixed32 = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeSfixed32(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedSfixed32", jspb.BinaryWriter.prototype.writeRepeatedSfixed32), jspb.BinaryWriter.prototype.writeRepeatedSfixed64 = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeSfixed64(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedSfixed64", jspb.BinaryWriter.prototype.writeRepeatedSfixed64), jspb.BinaryWriter.prototype.writeRepeatedSfixed64String = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeSfixed64String(e, t[r]);
  }, jspb.BinaryWriter.prototype.writeRepeatedFloat = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeFloat(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedFloat", jspb.BinaryWriter.prototype.writeRepeatedFloat), jspb.BinaryWriter.prototype.writeRepeatedDouble = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeDouble(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedDouble", jspb.BinaryWriter.prototype.writeRepeatedDouble), jspb.BinaryWriter.prototype.writeRepeatedBool = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeBool(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedBool", jspb.BinaryWriter.prototype.writeRepeatedBool), jspb.BinaryWriter.prototype.writeRepeatedEnum = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeEnum(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedEnum", jspb.BinaryWriter.prototype.writeRepeatedEnum), jspb.BinaryWriter.prototype.writeRepeatedString = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeString(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedString", jspb.BinaryWriter.prototype.writeRepeatedString), jspb.BinaryWriter.prototype.writeRepeatedBytes = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeBytes(e, t[r]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedBytes", jspb.BinaryWriter.prototype.writeRepeatedBytes), jspb.BinaryWriter.prototype.writeRepeatedMessage = function(e, t, r) {
    if (null != t) for (var o = 0; o < t.length; o++) {
      var i = this.beginDelimited_(e);
      r(t[o], this), this.endDelimited_(i);
    }
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedMessage", jspb.BinaryWriter.prototype.writeRepeatedMessage), jspb.BinaryWriter.prototype.writeRepeatedGroup = function(e, t, r) {
    if (null != t) for (var o = 0; o < t.length; o++) this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.START_GROUP), r(t[o], this), this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.END_GROUP);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writeRepeatedGroup", jspb.BinaryWriter.prototype.writeRepeatedGroup), jspb.BinaryWriter.prototype.writeRepeatedFixedHash64 = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeFixedHash64(e, t[r]);
  }, jspb.BinaryWriter.prototype.writeRepeatedVarintHash64 = function(e, t) {
    if (null != t) for (var r = 0; r < t.length; r++) this.writeVarintHash64(e, t[r]);
  }, jspb.BinaryWriter.prototype.writePackedInt32 = function(e, t) {
    if (null != t && t.length) {
      e = this.beginDelimited_(e);
      for (var r = 0; r < t.length; r++) this.encoder_.writeSignedVarint32(t[r]);
      this.endDelimited_(e);
    }
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writePackedInt32", jspb.BinaryWriter.prototype.writePackedInt32), jspb.BinaryWriter.prototype.writePackedInt32String = function(e, t) {
    if (null != t && t.length) {
      e = this.beginDelimited_(e);
      for (var r = 0; r < t.length; r++) this.encoder_.writeSignedVarint32(parseInt(t[r], 10));
      this.endDelimited_(e);
    }
  }, jspb.BinaryWriter.prototype.writePackedInt64 = function(e, t) {
    if (null != t && t.length) {
      e = this.beginDelimited_(e);
      for (var r = 0; r < t.length; r++) this.encoder_.writeSignedVarint64(t[r]);
      this.endDelimited_(e);
    }
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writePackedInt64", jspb.BinaryWriter.prototype.writePackedInt64), jspb.BinaryWriter.prototype.writePackedSplitFixed64 = function(e, t, r, o) {
    if (null != t) {
      e = this.beginDelimited_(e);
      for (var i = 0; i < t.length; i++) this.encoder_.writeSplitFixed64(r(t[i]), o(t[i]));
      this.endDelimited_(e);
    }
  }, jspb.BinaryWriter.prototype.writePackedSplitVarint64 = function(e, t, r, o) {
    if (null != t) {
      e = this.beginDelimited_(e);
      for (var i = 0; i < t.length; i++) this.encoder_.writeSplitVarint64(r(t[i]), o(t[i]));
      this.endDelimited_(e);
    }
  }, jspb.BinaryWriter.prototype.writePackedSplitZigzagVarint64 = function(e, t, r, o) {
    if (null != t) {
      e = this.beginDelimited_(e);
      for (var i = this.encoder_, a2 = 0; a2 < t.length; a2++) jspb.utils.toZigzag64(r(t[a2]), o(t[a2]), (function(e2, t2) {
        i.writeSplitVarint64(e2 >>> 0, t2 >>> 0);
      }));
      this.endDelimited_(e);
    }
  }, jspb.BinaryWriter.prototype.writePackedInt64String = function(e, t) {
    if (null != t && t.length) {
      e = this.beginDelimited_(e);
      for (var r = 0; r < t.length; r++) {
        var o = jspb.arith.Int64.fromString(t[r]);
        this.encoder_.writeSplitVarint64(o.lo, o.hi);
      }
      this.endDelimited_(e);
    }
  }, jspb.BinaryWriter.prototype.writePackedUint32 = function(e, t) {
    if (null != t && t.length) {
      e = this.beginDelimited_(e);
      for (var r = 0; r < t.length; r++) this.encoder_.writeUnsignedVarint32(t[r]);
      this.endDelimited_(e);
    }
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writePackedUint32", jspb.BinaryWriter.prototype.writePackedUint32), jspb.BinaryWriter.prototype.writePackedUint32String = function(e, t) {
    if (null != t && t.length) {
      e = this.beginDelimited_(e);
      for (var r = 0; r < t.length; r++) this.encoder_.writeUnsignedVarint32(parseInt(t[r], 10));
      this.endDelimited_(e);
    }
  }, jspb.BinaryWriter.prototype.writePackedUint64 = function(e, t) {
    if (null != t && t.length) {
      e = this.beginDelimited_(e);
      for (var r = 0; r < t.length; r++) this.encoder_.writeUnsignedVarint64(t[r]);
      this.endDelimited_(e);
    }
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writePackedUint64", jspb.BinaryWriter.prototype.writePackedUint64), jspb.BinaryWriter.prototype.writePackedUint64String = function(e, t) {
    if (null != t && t.length) {
      e = this.beginDelimited_(e);
      for (var r = 0; r < t.length; r++) {
        var o = jspb.arith.UInt64.fromString(t[r]);
        this.encoder_.writeSplitVarint64(o.lo, o.hi);
      }
      this.endDelimited_(e);
    }
  }, jspb.BinaryWriter.prototype.writePackedSint32 = function(e, t) {
    if (null != t && t.length) {
      e = this.beginDelimited_(e);
      for (var r = 0; r < t.length; r++) this.encoder_.writeZigzagVarint32(t[r]);
      this.endDelimited_(e);
    }
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writePackedSint32", jspb.BinaryWriter.prototype.writePackedSint32), jspb.BinaryWriter.prototype.writePackedSint64 = function(e, t) {
    if (null != t && t.length) {
      e = this.beginDelimited_(e);
      for (var r = 0; r < t.length; r++) this.encoder_.writeZigzagVarint64(t[r]);
      this.endDelimited_(e);
    }
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writePackedSint64", jspb.BinaryWriter.prototype.writePackedSint64), jspb.BinaryWriter.prototype.writePackedSint64String = function(e, t) {
    if (null != t && t.length) {
      e = this.beginDelimited_(e);
      for (var r = 0; r < t.length; r++) this.encoder_.writeZigzagVarintHash64(jspb.utils.decimalStringToHash64(t[r]));
      this.endDelimited_(e);
    }
  }, jspb.BinaryWriter.prototype.writePackedSintHash64 = function(e, t) {
    if (null != t && t.length) {
      e = this.beginDelimited_(e);
      for (var r = 0; r < t.length; r++) this.encoder_.writeZigzagVarintHash64(t[r]);
      this.endDelimited_(e);
    }
  }, jspb.BinaryWriter.prototype.writePackedFixed32 = function(e, t) {
    if (null != t && t.length) for (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(4 * t.length), e = 0; e < t.length; e++) this.encoder_.writeUint32(t[e]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writePackedFixed32", jspb.BinaryWriter.prototype.writePackedFixed32), jspb.BinaryWriter.prototype.writePackedFixed64 = function(e, t) {
    if (null != t && t.length) for (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(8 * t.length), e = 0; e < t.length; e++) this.encoder_.writeUint64(t[e]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writePackedFixed64", jspb.BinaryWriter.prototype.writePackedFixed64), jspb.BinaryWriter.prototype.writePackedFixed64String = function(e, t) {
    if (null != t && t.length) for (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(8 * t.length), e = 0; e < t.length; e++) {
      var r = jspb.arith.UInt64.fromString(t[e]);
      this.encoder_.writeSplitFixed64(r.lo, r.hi);
    }
  }, jspb.BinaryWriter.prototype.writePackedSfixed32 = function(e, t) {
    if (null != t && t.length) for (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(4 * t.length), e = 0; e < t.length; e++) this.encoder_.writeInt32(t[e]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writePackedSfixed32", jspb.BinaryWriter.prototype.writePackedSfixed32), jspb.BinaryWriter.prototype.writePackedSfixed64 = function(e, t) {
    if (null != t && t.length) for (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(8 * t.length), e = 0; e < t.length; e++) this.encoder_.writeInt64(t[e]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writePackedSfixed64", jspb.BinaryWriter.prototype.writePackedSfixed64), jspb.BinaryWriter.prototype.writePackedSfixed64String = function(e, t) {
    if (null != t && t.length) for (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(8 * t.length), e = 0; e < t.length; e++) this.encoder_.writeInt64String(t[e]);
  }, jspb.BinaryWriter.prototype.writePackedFloat = function(e, t) {
    if (null != t && t.length) for (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(4 * t.length), e = 0; e < t.length; e++) this.encoder_.writeFloat(t[e]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writePackedFloat", jspb.BinaryWriter.prototype.writePackedFloat), jspb.BinaryWriter.prototype.writePackedDouble = function(e, t) {
    if (null != t && t.length) for (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(8 * t.length), e = 0; e < t.length; e++) this.encoder_.writeDouble(t[e]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writePackedDouble", jspb.BinaryWriter.prototype.writePackedDouble), jspb.BinaryWriter.prototype.writePackedBool = function(e, t) {
    if (null != t && t.length) for (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(t.length), e = 0; e < t.length; e++) this.encoder_.writeBool(t[e]);
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writePackedBool", jspb.BinaryWriter.prototype.writePackedBool), jspb.BinaryWriter.prototype.writePackedEnum = function(e, t) {
    if (null != t && t.length) {
      e = this.beginDelimited_(e);
      for (var r = 0; r < t.length; r++) this.encoder_.writeEnum(t[r]);
      this.endDelimited_(e);
    }
  }, goog.exportProperty(jspb.BinaryWriter.prototype, "writePackedEnum", jspb.BinaryWriter.prototype.writePackedEnum), jspb.BinaryWriter.prototype.writePackedFixedHash64 = function(e, t) {
    if (null != t && t.length) for (this.writeFieldHeader_(e, jspb.BinaryConstants.WireType.DELIMITED), this.encoder_.writeUnsignedVarint32(8 * t.length), e = 0; e < t.length; e++) this.encoder_.writeFixedHash64(t[e]);
  }, jspb.BinaryWriter.prototype.writePackedVarintHash64 = function(e, t) {
    if (null != t && t.length) {
      e = this.beginDelimited_(e);
      for (var r = 0; r < t.length; r++) this.encoder_.writeVarintHash64(t[r]);
      this.endDelimited_(e);
    }
  }, jspb.Map = function(e, t) {
    this.arr_ = e, this.valueCtor_ = t, this.map_ = {}, this.arrClean = true, 0 < this.arr_.length && this.loadFromArray_();
  }, goog.exportSymbol("jspb.Map", jspb.Map), jspb.Map.prototype.loadFromArray_ = function() {
    for (var e = 0; e < this.arr_.length; e++) {
      var t = this.arr_[e], r = t[0];
      this.map_[r.toString()] = new jspb.Map.Entry_(r, t[1]);
    }
    this.arrClean = true;
  }, jspb.Map.prototype.toArray = function() {
    if (this.arrClean) {
      if (this.valueCtor_) {
        var e, t = this.map_;
        for (e in t) if (Object.prototype.hasOwnProperty.call(t, e)) {
          var r = t[e].valueWrapper;
          r && r.toArray();
        }
      }
    } else {
      for (this.arr_.length = 0, (t = this.stringKeys_()).sort(), e = 0; e < t.length; e++) {
        var o = this.map_[t[e]];
        (r = o.valueWrapper) && r.toArray(), this.arr_.push([o.key, o.value]);
      }
      this.arrClean = true;
    }
    return this.arr_;
  }, goog.exportProperty(jspb.Map.prototype, "toArray", jspb.Map.prototype.toArray), jspb.Map.prototype.toObject = function(e, t) {
    for (var r = this.toArray(), o = [], i = 0; i < r.length; i++) {
      var a2 = this.map_[r[i][0].toString()];
      this.wrapEntry_(a2);
      var n = a2.valueWrapper;
      n ? (jspb.asserts.assert(t), o.push([a2.key, t(e, n)])) : o.push([a2.key, a2.value]);
    }
    return o;
  }, goog.exportProperty(jspb.Map.prototype, "toObject", jspb.Map.prototype.toObject), jspb.Map.fromObject = function(e, t, r) {
    t = new jspb.Map([], t);
    for (var o = 0; o < e.length; o++) {
      var i = e[o][0], a2 = r(e[o][1]);
      t.set(i, a2);
    }
    return t;
  }, goog.exportProperty(jspb.Map, "fromObject", jspb.Map.fromObject), jspb.Map.ArrayIteratorIterable_ = function(e) {
    this.idx_ = 0, this.arr_ = e;
  }, jspb.Map.ArrayIteratorIterable_.prototype.next = function() {
    return this.idx_ < this.arr_.length ? { done: false, value: this.arr_[this.idx_++] } : { done: true, value: void 0 };
  }, "undefined" != typeof Symbol && (jspb.Map.ArrayIteratorIterable_.prototype[Symbol.iterator] = function() {
    return this;
  }), jspb.Map.prototype.getLength = function() {
    return this.stringKeys_().length;
  }, goog.exportProperty(jspb.Map.prototype, "getLength", jspb.Map.prototype.getLength), jspb.Map.prototype.clear = function() {
    this.map_ = {}, this.arrClean = false;
  }, goog.exportProperty(jspb.Map.prototype, "clear", jspb.Map.prototype.clear), jspb.Map.prototype.del = function(e) {
    e = e.toString();
    var t = this.map_.hasOwnProperty(e);
    return delete this.map_[e], this.arrClean = false, t;
  }, goog.exportProperty(jspb.Map.prototype, "del", jspb.Map.prototype.del), jspb.Map.prototype.getEntryList = function() {
    var e = [], t = this.stringKeys_();
    t.sort();
    for (var r = 0; r < t.length; r++) {
      var o = this.map_[t[r]];
      e.push([o.key, o.value]);
    }
    return e;
  }, goog.exportProperty(jspb.Map.prototype, "getEntryList", jspb.Map.prototype.getEntryList), jspb.Map.prototype.entries = function() {
    var e = [], t = this.stringKeys_();
    t.sort();
    for (var r = 0; r < t.length; r++) {
      var o = this.map_[t[r]];
      e.push([o.key, this.wrapEntry_(o)]);
    }
    return new jspb.Map.ArrayIteratorIterable_(e);
  }, goog.exportProperty(jspb.Map.prototype, "entries", jspb.Map.prototype.entries), jspb.Map.prototype.keys = function() {
    var e = [], t = this.stringKeys_();
    t.sort();
    for (var r = 0; r < t.length; r++) e.push(this.map_[t[r]].key);
    return new jspb.Map.ArrayIteratorIterable_(e);
  }, goog.exportProperty(jspb.Map.prototype, "keys", jspb.Map.prototype.keys), jspb.Map.prototype.values = function() {
    var e = [], t = this.stringKeys_();
    t.sort();
    for (var r = 0; r < t.length; r++) e.push(this.wrapEntry_(this.map_[t[r]]));
    return new jspb.Map.ArrayIteratorIterable_(e);
  }, goog.exportProperty(jspb.Map.prototype, "values", jspb.Map.prototype.values), jspb.Map.prototype.forEach = function(e, t) {
    var r = this.stringKeys_();
    r.sort();
    for (var o = 0; o < r.length; o++) {
      var i = this.map_[r[o]];
      e.call(t, this.wrapEntry_(i), i.key, this);
    }
  }, goog.exportProperty(jspb.Map.prototype, "forEach", jspb.Map.prototype.forEach), jspb.Map.prototype.set = function(e, t) {
    var r = new jspb.Map.Entry_(e);
    return this.valueCtor_ ? (r.valueWrapper = t, r.value = t.toArray()) : r.value = t, this.map_[e.toString()] = r, this.arrClean = false, this;
  }, goog.exportProperty(jspb.Map.prototype, "set", jspb.Map.prototype.set), jspb.Map.prototype.wrapEntry_ = function(e) {
    return this.valueCtor_ ? (e.valueWrapper || (e.valueWrapper = new this.valueCtor_(e.value)), e.valueWrapper) : e.value;
  }, jspb.Map.prototype.get = function(e) {
    if (e = this.map_[e.toString()]) return this.wrapEntry_(e);
  }, goog.exportProperty(jspb.Map.prototype, "get", jspb.Map.prototype.get), jspb.Map.prototype.has = function(e) {
    return e.toString() in this.map_;
  }, goog.exportProperty(jspb.Map.prototype, "has", jspb.Map.prototype.has), jspb.Map.prototype.serializeBinary = function(e, t, r, o, i) {
    var a2 = this.stringKeys_();
    a2.sort();
    for (var n = 0; n < a2.length; n++) {
      var s = this.map_[a2[n]];
      t.beginSubMessage(e), r.call(t, 1, s.key), this.valueCtor_ ? o.call(t, 2, this.wrapEntry_(s), i) : o.call(t, 2, s.value), t.endSubMessage();
    }
  }, goog.exportProperty(jspb.Map.prototype, "serializeBinary", jspb.Map.prototype.serializeBinary), jspb.Map.deserializeBinary = function(e, t, r, o, i, a2, n) {
    for (; t.nextField() && !t.isEndGroup(); ) {
      var s = t.getFieldNumber();
      1 == s ? a2 = r.call(t) : 2 == s && (e.valueCtor_ ? (jspb.asserts.assert(i), n || (n = new e.valueCtor_()), o.call(t, n, i)) : n = o.call(t));
    }
    jspb.asserts.assert(null != a2), jspb.asserts.assert(null != n), e.set(a2, n);
  }, goog.exportProperty(jspb.Map, "deserializeBinary", jspb.Map.deserializeBinary), jspb.Map.prototype.stringKeys_ = function() {
    var e, t = this.map_, r = [];
    for (e in t) Object.prototype.hasOwnProperty.call(t, e) && r.push(e);
    return r;
  }, jspb.Map.Entry_ = function(e, t) {
    this.key = e, this.value = t, this.valueWrapper = void 0;
  }, jspb.ExtensionFieldInfo = function(e, t, r, o, i) {
    this.fieldIndex = e, this.fieldName = t, this.ctor = r, this.toObjectFn = o, this.isRepeated = i;
  }, goog.exportSymbol("jspb.ExtensionFieldInfo", jspb.ExtensionFieldInfo), jspb.ExtensionFieldBinaryInfo = function(e, t, r, o, i, a2) {
    this.fieldInfo = e, this.binaryReaderFn = t, this.binaryWriterFn = r, this.binaryMessageSerializeFn = o, this.binaryMessageDeserializeFn = i, this.isPacked = a2;
  }, goog.exportSymbol("jspb.ExtensionFieldBinaryInfo", jspb.ExtensionFieldBinaryInfo), jspb.ExtensionFieldInfo.prototype.isMessageType = function() {
    return !!this.ctor;
  }, goog.exportProperty(jspb.ExtensionFieldInfo.prototype, "isMessageType", jspb.ExtensionFieldInfo.prototype.isMessageType), jspb.Message = function() {
  }, goog.exportSymbol("jspb.Message", jspb.Message), jspb.Message.GENERATE_TO_OBJECT = true, goog.exportProperty(jspb.Message, "GENERATE_TO_OBJECT", jspb.Message.GENERATE_TO_OBJECT), jspb.Message.GENERATE_FROM_OBJECT = !goog.DISALLOW_TEST_ONLY_CODE, goog.exportProperty(jspb.Message, "GENERATE_FROM_OBJECT", jspb.Message.GENERATE_FROM_OBJECT), jspb.Message.GENERATE_TO_STRING = true, jspb.Message.ASSUME_LOCAL_ARRAYS = false, jspb.Message.SERIALIZE_EMPTY_TRAILING_FIELDS = true, jspb.Message.SUPPORTS_UINT8ARRAY_ = "function" == typeof Uint8Array, jspb.Message.prototype.getJsPbMessageId = function() {
    return this.messageId_;
  }, goog.exportProperty(jspb.Message.prototype, "getJsPbMessageId", jspb.Message.prototype.getJsPbMessageId), jspb.Message.getIndex_ = function(e, t) {
    return t + e.arrayIndexOffset_;
  }, jspb.Message.hiddenES6Property_ = function() {
  }, jspb.Message.getFieldNumber_ = function(e, t) {
    return t - e.arrayIndexOffset_;
  }, jspb.Message.initialize = function(e, t, r, o, i, a2) {
    if (e.wrappers_ = null, t || (t = r ? [r] : []), e.messageId_ = r ? String(r) : void 0, e.arrayIndexOffset_ = 0 === r ? -1 : 0, e.array = t, jspb.Message.initPivotAndExtensionObject_(e, o), e.convertedPrimitiveFields_ = {}, jspb.Message.SERIALIZE_EMPTY_TRAILING_FIELDS || (e.repeatedFields = i), i) for (t = 0; t < i.length; t++) (r = i[t]) < e.pivot_ ? (r = jspb.Message.getIndex_(e, r), e.array[r] = e.array[r] || jspb.Message.EMPTY_LIST_SENTINEL_) : (jspb.Message.maybeInitEmptyExtensionObject_(e), e.extensionObject_[r] = e.extensionObject_[r] || jspb.Message.EMPTY_LIST_SENTINEL_);
    if (a2 && a2.length) for (t = 0; t < a2.length; t++) jspb.Message.computeOneofCase(e, a2[t]);
  }, goog.exportProperty(jspb.Message, "initialize", jspb.Message.initialize), jspb.Message.EMPTY_LIST_SENTINEL_ = goog.DEBUG && Object.freeze ? Object.freeze([]) : [], jspb.Message.isArray_ = function(e) {
    return jspb.Message.ASSUME_LOCAL_ARRAYS ? e instanceof Array : Array.isArray(e);
  }, jspb.Message.isExtensionObject_ = function(e) {
    return !(null === e || "object" != typeof e || jspb.Message.isArray_(e) || jspb.Message.SUPPORTS_UINT8ARRAY_ && e instanceof Uint8Array);
  }, jspb.Message.initPivotAndExtensionObject_ = function(e, t) {
    var r = e.array.length, o = -1;
    if (r && (o = r - 1, r = e.array[o], jspb.Message.isExtensionObject_(r))) return e.pivot_ = jspb.Message.getFieldNumber_(e, o), void (e.extensionObject_ = r);
    -1 < t ? (e.pivot_ = Math.max(t, jspb.Message.getFieldNumber_(e, o + 1)), e.extensionObject_ = null) : e.pivot_ = Number.MAX_VALUE;
  }, jspb.Message.maybeInitEmptyExtensionObject_ = function(e) {
    var t = jspb.Message.getIndex_(e, e.pivot_);
    e.array[t] || (e.extensionObject_ = e.array[t] = {});
  }, jspb.Message.toObjectList = function(e, t, r) {
    for (var o = [], i = 0; i < e.length; i++) o[i] = t.call(e[i], r, e[i]);
    return o;
  }, goog.exportProperty(jspb.Message, "toObjectList", jspb.Message.toObjectList), jspb.Message.toObjectExtension = function(e, t, r, o, i) {
    for (var a2 in r) {
      var n = r[a2], s = o.call(e, n);
      if (null != s) {
        for (var p in n.fieldName) if (n.fieldName.hasOwnProperty(p)) break;
        t[p] = n.toObjectFn ? n.isRepeated ? jspb.Message.toObjectList(s, n.toObjectFn, i) : n.toObjectFn(i, s) : s;
      }
    }
  }, goog.exportProperty(jspb.Message, "toObjectExtension", jspb.Message.toObjectExtension), jspb.Message.serializeBinaryExtensions = function(e, t, r, o) {
    for (var i in r) {
      var a2 = r[i], n = a2.fieldInfo;
      if (!a2.binaryWriterFn) throw Error("Message extension present that was generated without binary serialization support");
      var s = o.call(e, n);
      if (null != s) if (n.isMessageType()) {
        if (!a2.binaryMessageSerializeFn) throw Error("Message extension present holding submessage without binary support enabled, and message is being serialized to binary format");
        a2.binaryWriterFn.call(t, n.fieldIndex, s, a2.binaryMessageSerializeFn);
      } else a2.binaryWriterFn.call(t, n.fieldIndex, s);
    }
  }, goog.exportProperty(jspb.Message, "serializeBinaryExtensions", jspb.Message.serializeBinaryExtensions), jspb.Message.readBinaryExtension = function(e, t, r, o, i) {
    var a2 = r[t.getFieldNumber()];
    if (a2) {
      if (r = a2.fieldInfo, !a2.binaryReaderFn) throw Error("Deserializing extension whose generated code does not support binary format");
      if (r.isMessageType()) {
        var n = new r.ctor();
        a2.binaryReaderFn.call(t, n, a2.binaryMessageDeserializeFn);
      } else n = a2.binaryReaderFn.call(t);
      r.isRepeated && !a2.isPacked ? (t = o.call(e, r)) ? t.push(n) : i.call(e, r, [n]) : i.call(e, r, n);
    } else t.skipField();
  }, goog.exportProperty(jspb.Message, "readBinaryExtension", jspb.Message.readBinaryExtension), jspb.Message.getField = function(e, t) {
    if (t < e.pivot_) {
      t = jspb.Message.getIndex_(e, t);
      var r = e.array[t];
      return r === jspb.Message.EMPTY_LIST_SENTINEL_ ? e.array[t] = [] : r;
    }
    if (e.extensionObject_) return (r = e.extensionObject_[t]) === jspb.Message.EMPTY_LIST_SENTINEL_ ? e.extensionObject_[t] = [] : r;
  }, goog.exportProperty(jspb.Message, "getField", jspb.Message.getField), jspb.Message.getRepeatedField = function(e, t) {
    return jspb.Message.getField(e, t);
  }, goog.exportProperty(jspb.Message, "getRepeatedField", jspb.Message.getRepeatedField), jspb.Message.getOptionalFloatingPointField = function(e, t) {
    return null == (e = jspb.Message.getField(e, t)) ? e : +e;
  }, goog.exportProperty(jspb.Message, "getOptionalFloatingPointField", jspb.Message.getOptionalFloatingPointField), jspb.Message.getBooleanField = function(e, t) {
    return null == (e = jspb.Message.getField(e, t)) ? e : !!e;
  }, goog.exportProperty(jspb.Message, "getBooleanField", jspb.Message.getBooleanField), jspb.Message.getRepeatedFloatingPointField = function(e, t) {
    var r = jspb.Message.getRepeatedField(e, t);
    if (e.convertedPrimitiveFields_ || (e.convertedPrimitiveFields_ = {}), !e.convertedPrimitiveFields_[t]) {
      for (var o = 0; o < r.length; o++) r[o] = +r[o];
      e.convertedPrimitiveFields_[t] = true;
    }
    return r;
  }, goog.exportProperty(jspb.Message, "getRepeatedFloatingPointField", jspb.Message.getRepeatedFloatingPointField), jspb.Message.getRepeatedBooleanField = function(e, t) {
    var r = jspb.Message.getRepeatedField(e, t);
    if (e.convertedPrimitiveFields_ || (e.convertedPrimitiveFields_ = {}), !e.convertedPrimitiveFields_[t]) {
      for (var o = 0; o < r.length; o++) r[o] = !!r[o];
      e.convertedPrimitiveFields_[t] = true;
    }
    return r;
  }, goog.exportProperty(jspb.Message, "getRepeatedBooleanField", jspb.Message.getRepeatedBooleanField), jspb.Message.bytesAsB64 = function(e) {
    return null == e || "string" == typeof e ? e : jspb.Message.SUPPORTS_UINT8ARRAY_ && e instanceof Uint8Array ? goog.crypt.base64.encodeByteArray(e) : (jspb.asserts.fail("Cannot coerce to b64 string: " + goog.typeOf(e)), null);
  }, goog.exportProperty(jspb.Message, "bytesAsB64", jspb.Message.bytesAsB64), jspb.Message.bytesAsU8 = function(e) {
    return null == e || e instanceof Uint8Array ? e : "string" == typeof e ? goog.crypt.base64.decodeStringToUint8Array(e) : (jspb.asserts.fail("Cannot coerce to Uint8Array: " + goog.typeOf(e)), null);
  }, goog.exportProperty(jspb.Message, "bytesAsU8", jspb.Message.bytesAsU8), jspb.Message.bytesListAsB64 = function(e) {
    return jspb.Message.assertConsistentTypes_(e), e.length && "string" != typeof e[0] ? goog.array.map(e, jspb.Message.bytesAsB64) : e;
  }, goog.exportProperty(jspb.Message, "bytesListAsB64", jspb.Message.bytesListAsB64), jspb.Message.bytesListAsU8 = function(e) {
    return jspb.Message.assertConsistentTypes_(e), !e.length || e[0] instanceof Uint8Array ? e : goog.array.map(e, jspb.Message.bytesAsU8);
  }, goog.exportProperty(jspb.Message, "bytesListAsU8", jspb.Message.bytesListAsU8), jspb.Message.assertConsistentTypes_ = function(e) {
    if (goog.DEBUG && e && 1 < e.length) {
      var t = goog.typeOf(e[0]);
      goog.array.forEach(e, (function(e2) {
        goog.typeOf(e2) != t && jspb.asserts.fail("Inconsistent type in JSPB repeated field array. Got " + goog.typeOf(e2) + " expected " + t);
      }));
    }
  }, jspb.Message.getFieldWithDefault = function(e, t, r) {
    return null == (e = jspb.Message.getField(e, t)) ? r : e;
  }, goog.exportProperty(jspb.Message, "getFieldWithDefault", jspb.Message.getFieldWithDefault), jspb.Message.getBooleanFieldWithDefault = function(e, t, r) {
    return null == (e = jspb.Message.getBooleanField(e, t)) ? r : e;
  }, goog.exportProperty(jspb.Message, "getBooleanFieldWithDefault", jspb.Message.getBooleanFieldWithDefault), jspb.Message.getFloatingPointFieldWithDefault = function(e, t, r) {
    return null == (e = jspb.Message.getOptionalFloatingPointField(e, t)) ? r : e;
  }, goog.exportProperty(jspb.Message, "getFloatingPointFieldWithDefault", jspb.Message.getFloatingPointFieldWithDefault), jspb.Message.getFieldProto3 = jspb.Message.getFieldWithDefault, goog.exportProperty(jspb.Message, "getFieldProto3", jspb.Message.getFieldProto3), jspb.Message.getMapField = function(e, t, r, o) {
    if (e.wrappers_ || (e.wrappers_ = {}), t in e.wrappers_) return e.wrappers_[t];
    var i = jspb.Message.getField(e, t);
    if (!i) {
      if (r) return;
      i = [], jspb.Message.setField(e, t, i);
    }
    return e.wrappers_[t] = new jspb.Map(i, o);
  }, goog.exportProperty(jspb.Message, "getMapField", jspb.Message.getMapField), jspb.Message.setField = function(e, t, r) {
    return jspb.asserts.assertInstanceof(e, jspb.Message), t < e.pivot_ ? e.array[jspb.Message.getIndex_(e, t)] = r : (jspb.Message.maybeInitEmptyExtensionObject_(e), e.extensionObject_[t] = r), e;
  }, goog.exportProperty(jspb.Message, "setField", jspb.Message.setField), jspb.Message.setProto3IntField = function(e, t, r) {
    return jspb.Message.setFieldIgnoringDefault_(e, t, r, 0);
  }, goog.exportProperty(jspb.Message, "setProto3IntField", jspb.Message.setProto3IntField), jspb.Message.setProto3FloatField = function(e, t, r) {
    return jspb.Message.setFieldIgnoringDefault_(e, t, r, 0);
  }, goog.exportProperty(jspb.Message, "setProto3FloatField", jspb.Message.setProto3FloatField), jspb.Message.setProto3BooleanField = function(e, t, r) {
    return jspb.Message.setFieldIgnoringDefault_(e, t, r, false);
  }, goog.exportProperty(jspb.Message, "setProto3BooleanField", jspb.Message.setProto3BooleanField), jspb.Message.setProto3StringField = function(e, t, r) {
    return jspb.Message.setFieldIgnoringDefault_(e, t, r, "");
  }, goog.exportProperty(jspb.Message, "setProto3StringField", jspb.Message.setProto3StringField), jspb.Message.setProto3BytesField = function(e, t, r) {
    return jspb.Message.setFieldIgnoringDefault_(e, t, r, "");
  }, goog.exportProperty(jspb.Message, "setProto3BytesField", jspb.Message.setProto3BytesField), jspb.Message.setProto3EnumField = function(e, t, r) {
    return jspb.Message.setFieldIgnoringDefault_(e, t, r, 0);
  }, goog.exportProperty(jspb.Message, "setProto3EnumField", jspb.Message.setProto3EnumField), jspb.Message.setProto3StringIntField = function(e, t, r) {
    return jspb.Message.setFieldIgnoringDefault_(e, t, r, "0");
  }, goog.exportProperty(jspb.Message, "setProto3StringIntField", jspb.Message.setProto3StringIntField), jspb.Message.setFieldIgnoringDefault_ = function(e, t, r, o) {
    return jspb.asserts.assertInstanceof(e, jspb.Message), r !== o ? jspb.Message.setField(e, t, r) : t < e.pivot_ ? e.array[jspb.Message.getIndex_(e, t)] = null : (jspb.Message.maybeInitEmptyExtensionObject_(e), delete e.extensionObject_[t]), e;
  }, jspb.Message.addToRepeatedField = function(e, t, r, o) {
    return jspb.asserts.assertInstanceof(e, jspb.Message), t = jspb.Message.getRepeatedField(e, t), null != o ? t.splice(o, 0, r) : t.push(r), e;
  }, goog.exportProperty(jspb.Message, "addToRepeatedField", jspb.Message.addToRepeatedField), jspb.Message.setOneofField = function(e, t, r, o) {
    return jspb.asserts.assertInstanceof(e, jspb.Message), (r = jspb.Message.computeOneofCase(e, r)) && r !== t && void 0 !== o && (e.wrappers_ && r in e.wrappers_ && (e.wrappers_[r] = void 0), jspb.Message.setField(e, r, void 0)), jspb.Message.setField(e, t, o);
  }, goog.exportProperty(jspb.Message, "setOneofField", jspb.Message.setOneofField), jspb.Message.computeOneofCase = function(e, t) {
    for (var r, o, i = 0; i < t.length; i++) {
      var a2 = t[i], n = jspb.Message.getField(e, a2);
      null != n && (r = a2, o = n, jspb.Message.setField(e, a2, void 0));
    }
    return r ? (jspb.Message.setField(e, r, o), r) : 0;
  }, goog.exportProperty(jspb.Message, "computeOneofCase", jspb.Message.computeOneofCase), jspb.Message.getWrapperField = function(e, t, r, o) {
    if (e.wrappers_ || (e.wrappers_ = {}), !e.wrappers_[r]) {
      var i = jspb.Message.getField(e, r);
      (o || i) && (e.wrappers_[r] = new t(i));
    }
    return e.wrappers_[r];
  }, goog.exportProperty(jspb.Message, "getWrapperField", jspb.Message.getWrapperField), jspb.Message.getRepeatedWrapperField = function(e, t, r) {
    return jspb.Message.wrapRepeatedField_(e, t, r), (t = e.wrappers_[r]) == jspb.Message.EMPTY_LIST_SENTINEL_ && (t = e.wrappers_[r] = []), t;
  }, goog.exportProperty(jspb.Message, "getRepeatedWrapperField", jspb.Message.getRepeatedWrapperField), jspb.Message.wrapRepeatedField_ = function(e, t, r) {
    if (e.wrappers_ || (e.wrappers_ = {}), !e.wrappers_[r]) {
      for (var o = jspb.Message.getRepeatedField(e, r), i = [], a2 = 0; a2 < o.length; a2++) i[a2] = new t(o[a2]);
      e.wrappers_[r] = i;
    }
  }, jspb.Message.setWrapperField = function(e, t, r) {
    jspb.asserts.assertInstanceof(e, jspb.Message), e.wrappers_ || (e.wrappers_ = {});
    var o = r ? r.toArray() : r;
    return e.wrappers_[t] = r, jspb.Message.setField(e, t, o);
  }, goog.exportProperty(jspb.Message, "setWrapperField", jspb.Message.setWrapperField), jspb.Message.setOneofWrapperField = function(e, t, r, o) {
    jspb.asserts.assertInstanceof(e, jspb.Message), e.wrappers_ || (e.wrappers_ = {});
    var i = o ? o.toArray() : o;
    return e.wrappers_[t] = o, jspb.Message.setOneofField(e, t, r, i);
  }, goog.exportProperty(jspb.Message, "setOneofWrapperField", jspb.Message.setOneofWrapperField), jspb.Message.setRepeatedWrapperField = function(e, t, r) {
    jspb.asserts.assertInstanceof(e, jspb.Message), e.wrappers_ || (e.wrappers_ = {}), r = r || [];
    for (var o = [], i = 0; i < r.length; i++) o[i] = r[i].toArray();
    return e.wrappers_[t] = r, jspb.Message.setField(e, t, o);
  }, goog.exportProperty(jspb.Message, "setRepeatedWrapperField", jspb.Message.setRepeatedWrapperField), jspb.Message.addToRepeatedWrapperField = function(e, t, r, o, i) {
    jspb.Message.wrapRepeatedField_(e, o, t);
    var a2 = e.wrappers_[t];
    return a2 || (a2 = e.wrappers_[t] = []), r = r || new o(), e = jspb.Message.getRepeatedField(e, t), null != i ? (a2.splice(i, 0, r), e.splice(i, 0, r.toArray())) : (a2.push(r), e.push(r.toArray())), r;
  }, goog.exportProperty(jspb.Message, "addToRepeatedWrapperField", jspb.Message.addToRepeatedWrapperField), jspb.Message.toMap = function(e, t, r, o) {
    for (var i = {}, a2 = 0; a2 < e.length; a2++) i[t.call(e[a2])] = r ? r.call(e[a2], o, e[a2]) : e[a2];
    return i;
  }, goog.exportProperty(jspb.Message, "toMap", jspb.Message.toMap), jspb.Message.prototype.syncMapFields_ = function() {
    if (this.wrappers_) for (var e in this.wrappers_) {
      var t = this.wrappers_[e];
      if (Array.isArray(t)) for (var r = 0; r < t.length; r++) t[r] && t[r].toArray();
      else t && t.toArray();
    }
  }, jspb.Message.prototype.toArray = function() {
    return this.syncMapFields_(), this.array;
  }, goog.exportProperty(jspb.Message.prototype, "toArray", jspb.Message.prototype.toArray), jspb.Message.GENERATE_TO_STRING && (jspb.Message.prototype.toString = function() {
    return this.syncMapFields_(), this.array.toString();
  }), jspb.Message.prototype.getExtension = function(e) {
    if (this.extensionObject_) {
      this.wrappers_ || (this.wrappers_ = {});
      var t = e.fieldIndex;
      if (e.isRepeated) {
        if (e.isMessageType()) return this.wrappers_[t] || (this.wrappers_[t] = goog.array.map(this.extensionObject_[t] || [], (function(t2) {
          return new e.ctor(t2);
        }))), this.wrappers_[t];
      } else if (e.isMessageType()) return !this.wrappers_[t] && this.extensionObject_[t] && (this.wrappers_[t] = new e.ctor(this.extensionObject_[t])), this.wrappers_[t];
      return this.extensionObject_[t];
    }
  }, goog.exportProperty(jspb.Message.prototype, "getExtension", jspb.Message.prototype.getExtension), jspb.Message.prototype.setExtension = function(e, t) {
    this.wrappers_ || (this.wrappers_ = {}), jspb.Message.maybeInitEmptyExtensionObject_(this);
    var r = e.fieldIndex;
    return e.isRepeated ? (t = t || [], e.isMessageType() ? (this.wrappers_[r] = t, this.extensionObject_[r] = goog.array.map(t, (function(e2) {
      return e2.toArray();
    }))) : this.extensionObject_[r] = t) : e.isMessageType() ? (this.wrappers_[r] = t, this.extensionObject_[r] = t ? t.toArray() : t) : this.extensionObject_[r] = t, this;
  }, goog.exportProperty(jspb.Message.prototype, "setExtension", jspb.Message.prototype.setExtension), jspb.Message.difference = function(e, t) {
    if (!(e instanceof t.constructor)) throw Error("Messages have different types.");
    var r = e.toArray();
    t = t.toArray();
    var o = [], i = 0, a2 = r.length > t.length ? r.length : t.length;
    for (e.getJsPbMessageId() && (o[0] = e.getJsPbMessageId(), i = 1); i < a2; i++) jspb.Message.compareFields(r[i], t[i]) || (o[i] = t[i]);
    return new e.constructor(o);
  }, goog.exportProperty(jspb.Message, "difference", jspb.Message.difference), jspb.Message.equals = function(e, t) {
    return e == t || !(!e || !t) && e instanceof t.constructor && jspb.Message.compareFields(e.toArray(), t.toArray());
  }, goog.exportProperty(jspb.Message, "equals", jspb.Message.equals), jspb.Message.compareExtensions = function(e, t) {
    e = e || {}, t = t || {};
    var r, o = {};
    for (r in e) o[r] = 0;
    for (r in t) o[r] = 0;
    for (r in o) if (!jspb.Message.compareFields(e[r], t[r])) return false;
    return true;
  }, goog.exportProperty(jspb.Message, "compareExtensions", jspb.Message.compareExtensions), jspb.Message.compareFields = function(e, t) {
    if (e == t) return true;
    if (!goog.isObject(e) || !goog.isObject(t)) return !!("number" == typeof e && isNaN(e) || "number" == typeof t && isNaN(t)) && String(e) == String(t);
    if (e.constructor != t.constructor) return false;
    if (jspb.Message.SUPPORTS_UINT8ARRAY_ && e.constructor === Uint8Array) {
      if (e.length != t.length) return false;
      for (var r = 0; r < e.length; r++) if (e[r] != t[r]) return false;
      return true;
    }
    if (e.constructor === Array) {
      var o = void 0, i = void 0, a2 = Math.max(e.length, t.length);
      for (r = 0; r < a2; r++) {
        var n = e[r], s = t[r];
        if (n && n.constructor == Object && (jspb.asserts.assert(void 0 === o), jspb.asserts.assert(r === e.length - 1), o = n, n = void 0), s && s.constructor == Object && (jspb.asserts.assert(void 0 === i), jspb.asserts.assert(r === t.length - 1), i = s, s = void 0), !jspb.Message.compareFields(n, s)) return false;
      }
      return !o && !i || (o = o || {}, i = i || {}, jspb.Message.compareExtensions(o, i));
    }
    if (e.constructor === Object) return jspb.Message.compareExtensions(e, t);
    throw Error("Invalid type in JSPB array");
  }, goog.exportProperty(jspb.Message, "compareFields", jspb.Message.compareFields), jspb.Message.prototype.cloneMessage = function() {
    return jspb.Message.cloneMessage(this);
  }, goog.exportProperty(jspb.Message.prototype, "cloneMessage", jspb.Message.prototype.cloneMessage), jspb.Message.prototype.clone = function() {
    return jspb.Message.cloneMessage(this);
  }, goog.exportProperty(jspb.Message.prototype, "clone", jspb.Message.prototype.clone), jspb.Message.clone = function(e) {
    return jspb.Message.cloneMessage(e);
  }, goog.exportProperty(jspb.Message, "clone", jspb.Message.clone), jspb.Message.cloneMessage = function(e) {
    return new e.constructor(jspb.Message.clone_(e.toArray()));
  }, jspb.Message.copyInto = function(e, t) {
    jspb.asserts.assertInstanceof(e, jspb.Message), jspb.asserts.assertInstanceof(t, jspb.Message), jspb.asserts.assert(e.constructor == t.constructor, "Copy source and target message should have the same type."), e = jspb.Message.clone(e);
    for (var r = t.toArray(), o = e.toArray(), i = r.length = 0; i < o.length; i++) r[i] = o[i];
    t.wrappers_ = e.wrappers_, t.extensionObject_ = e.extensionObject_;
  }, goog.exportProperty(jspb.Message, "copyInto", jspb.Message.copyInto), jspb.Message.clone_ = function(e) {
    if (Array.isArray(e)) {
      for (var t = Array(e.length), r = 0; r < e.length; r++) {
        var o = e[r];
        null != o && (t[r] = "object" == typeof o ? jspb.Message.clone_(jspb.asserts.assert(o)) : o);
      }
      return t;
    }
    if (jspb.Message.SUPPORTS_UINT8ARRAY_ && e instanceof Uint8Array) return new Uint8Array(e);
    for (r in t = {}, e) null != (o = e[r]) && (t[r] = "object" == typeof o ? jspb.Message.clone_(jspb.asserts.assert(o)) : o);
    return t;
  }, jspb.Message.registerMessageType = function(e, t) {
    t.messageId = e;
  }, goog.exportProperty(jspb.Message, "registerMessageType", jspb.Message.registerMessageType), jspb.Message.messageSetExtensions = {}, jspb.Message.messageSetExtensionsBinary = {}, jspb.Export = {}, exports.Map = jspb.Map, exports.Message = jspb.Message, exports.BinaryReader = jspb.BinaryReader, exports.BinaryWriter = jspb.BinaryWriter, exports.ExtensionFieldInfo = jspb.ExtensionFieldInfo, exports.ExtensionFieldBinaryInfo = jspb.ExtensionFieldBinaryInfo, exports.exportSymbol = goog.exportSymbol, exports.inherits = goog.inherits, exports.object = { extend: goog.object.extend }, exports.typeOf = goog.typeOf;
})(googleProtobuf);
var calculator_options_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.CalculatorOptions", null, o), proto.mediapipe.CalculatorOptions = function(e2) {
    t.Message.initialize(this, e2, 0, 2, null, null);
  }, r.inherits(proto.mediapipe.CalculatorOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.CalculatorOptions.displayName = "proto.mediapipe.CalculatorOptions"), proto.mediapipe.CalculatorOptions.extensions = {}, proto.mediapipe.CalculatorOptions.extensionsBinary = {}, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.CalculatorOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.CalculatorOptions.toObject(e2, this);
  }, proto.mediapipe.CalculatorOptions.toObject = function(e2, r2) {
    var o2, i = { mergeFields: null == (o2 = t.Message.getBooleanField(r2, 1)) ? void 0 : o2 };
    return t.Message.toObjectExtension(r2, i, proto.mediapipe.CalculatorOptions.extensions, proto.mediapipe.CalculatorOptions.prototype.getExtension, e2), e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.CalculatorOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.CalculatorOptions();
    return proto.mediapipe.CalculatorOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.CalculatorOptions.deserializeBinaryFromReader = function(e2, r2) {
    for (; r2.nextField() && !r2.isEndGroup(); ) {
      if (1 === r2.getFieldNumber()) {
        var o2 = r2.readBool();
        e2.setMergeFields(o2);
      } else t.Message.readBinaryExtension(e2, r2, proto.mediapipe.CalculatorOptions.extensionsBinary, proto.mediapipe.CalculatorOptions.prototype.getExtension, proto.mediapipe.CalculatorOptions.prototype.setExtension);
    }
    return e2;
  }, proto.mediapipe.CalculatorOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.CalculatorOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.CalculatorOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeBool(1, o2), t.Message.serializeBinaryExtensions(e2, r2, proto.mediapipe.CalculatorOptions.extensionsBinary, proto.mediapipe.CalculatorOptions.prototype.getExtension);
  }, proto.mediapipe.CalculatorOptions.prototype.getMergeFields = function() {
    return t.Message.getBooleanFieldWithDefault(this, 1, false);
  }, proto.mediapipe.CalculatorOptions.prototype.setMergeFields = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.CalculatorOptions.prototype.clearMergeFields = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.CalculatorOptions.prototype.hasMergeFields = function() {
    return null != t.Message.getField(this, 1);
  }, r.object.extend(e, proto.mediapipe);
})(calculator_options_pb);
var any_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.google.protobuf.Any", null, o), proto.google.protobuf.Any = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.google.protobuf.Any, t.Message), r.DEBUG && !COMPILED && (proto.google.protobuf.Any.displayName = "proto.google.protobuf.Any"), t.Message.GENERATE_TO_OBJECT && (proto.google.protobuf.Any.prototype.toObject = function(e2) {
    return proto.google.protobuf.Any.toObject(e2, this);
  }, proto.google.protobuf.Any.toObject = function(e2, r2) {
    var o2 = { typeUrl: t.Message.getFieldWithDefault(r2, 1, ""), value: r2.getValue_asB64() };
    return e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.google.protobuf.Any.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.google.protobuf.Any();
    return proto.google.protobuf.Any.deserializeBinaryFromReader(o2, r2);
  }, proto.google.protobuf.Any.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setTypeUrl(r2);
          break;
        case 2:
          r2 = t2.readBytes();
          e2.setValue(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.google.protobuf.Any.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.google.protobuf.Any.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.google.protobuf.Any.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    (r2 = e2.getTypeUrl()).length > 0 && t2.writeString(1, r2), (r2 = e2.getValue_asU8()).length > 0 && t2.writeBytes(2, r2);
  }, proto.google.protobuf.Any.prototype.getTypeUrl = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.google.protobuf.Any.prototype.setTypeUrl = function(e2) {
    return t.Message.setProto3StringField(this, 1, e2);
  }, proto.google.protobuf.Any.prototype.getValue = function() {
    return t.Message.getFieldWithDefault(this, 2, "");
  }, proto.google.protobuf.Any.prototype.getValue_asB64 = function() {
    return t.Message.bytesAsB64(this.getValue());
  }, proto.google.protobuf.Any.prototype.getValue_asU8 = function() {
    return t.Message.bytesAsU8(this.getValue());
  }, proto.google.protobuf.Any.prototype.setValue = function(e2) {
    return t.Message.setProto3BytesField(this, 2, e2);
  }, r.object.extend(e, proto.google.protobuf), proto.google.protobuf.Any.prototype.getTypeName = function() {
    return this.getTypeUrl().split("/").pop();
  }, proto.google.protobuf.Any.prototype.pack = function(e2, t2, r2) {
    r2 || (r2 = "type.googleapis.com/"), "/" != r2.substr(-1) ? this.setTypeUrl(r2 + "/" + t2) : this.setTypeUrl(r2 + t2), this.setValue(e2);
  }, proto.google.protobuf.Any.prototype.unpack = function(e2, t2) {
    return this.getTypeName() == t2 ? e2(this.getValue_asU8()) : null;
  };
})(any_pb);
var mediapipe_options_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.MediaPipeOptions", null, o), proto.mediapipe.MediaPipeOptions = function(e2) {
    t.Message.initialize(this, e2, 0, 1, null, null);
  }, r.inherits(proto.mediapipe.MediaPipeOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.MediaPipeOptions.displayName = "proto.mediapipe.MediaPipeOptions"), proto.mediapipe.MediaPipeOptions.extensions = {}, proto.mediapipe.MediaPipeOptions.extensionsBinary = {}, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.MediaPipeOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.MediaPipeOptions.toObject(e2, this);
  }, proto.mediapipe.MediaPipeOptions.toObject = function(e2, r2) {
    var o2 = {};
    return t.Message.toObjectExtension(r2, o2, proto.mediapipe.MediaPipeOptions.extensions, proto.mediapipe.MediaPipeOptions.prototype.getExtension, e2), e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.MediaPipeOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.MediaPipeOptions();
    return proto.mediapipe.MediaPipeOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.MediaPipeOptions.deserializeBinaryFromReader = function(e2, r2) {
    for (; r2.nextField() && !r2.isEndGroup(); ) {
      r2.getFieldNumber();
      t.Message.readBinaryExtension(e2, r2, proto.mediapipe.MediaPipeOptions.extensionsBinary, proto.mediapipe.MediaPipeOptions.prototype.getExtension, proto.mediapipe.MediaPipeOptions.prototype.setExtension);
    }
    return e2;
  }, proto.mediapipe.MediaPipeOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.MediaPipeOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.MediaPipeOptions.serializeBinaryToWriter = function(e2, r2) {
    t.Message.serializeBinaryExtensions(e2, r2, proto.mediapipe.MediaPipeOptions.extensionsBinary, proto.mediapipe.MediaPipeOptions.prototype.getExtension);
  }, r.object.extend(e, proto.mediapipe);
})(mediapipe_options_pb);
var packet_factory_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.PacketFactoryConfig", null, o), r.exportSymbol("proto.mediapipe.PacketFactoryOptions", null, o), r.exportSymbol("proto.mediapipe.PacketManagerConfig", null, o), proto.mediapipe.PacketFactoryOptions = function(e2) {
    t.Message.initialize(this, e2, 0, 1, null, null);
  }, r.inherits(proto.mediapipe.PacketFactoryOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.PacketFactoryOptions.displayName = "proto.mediapipe.PacketFactoryOptions"), proto.mediapipe.PacketFactoryOptions.extensions = {}, proto.mediapipe.PacketFactoryOptions.extensionsBinary = {}, proto.mediapipe.PacketFactoryConfig = function(e2) {
    t.Message.initialize(this, e2, 0, 500, null, null);
  }, r.inherits(proto.mediapipe.PacketFactoryConfig, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.PacketFactoryConfig.displayName = "proto.mediapipe.PacketFactoryConfig"), proto.mediapipe.PacketManagerConfig = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.PacketManagerConfig.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.PacketManagerConfig, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.PacketManagerConfig.displayName = "proto.mediapipe.PacketManagerConfig"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.PacketFactoryOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.PacketFactoryOptions.toObject(e2, this);
  }, proto.mediapipe.PacketFactoryOptions.toObject = function(e2, r2) {
    var o2 = {};
    return t.Message.toObjectExtension(r2, o2, proto.mediapipe.PacketFactoryOptions.extensions, proto.mediapipe.PacketFactoryOptions.prototype.getExtension, e2), e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.PacketFactoryOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.PacketFactoryOptions();
    return proto.mediapipe.PacketFactoryOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.PacketFactoryOptions.deserializeBinaryFromReader = function(e2, r2) {
    for (; r2.nextField() && !r2.isEndGroup(); ) {
      r2.getFieldNumber();
      t.Message.readBinaryExtension(e2, r2, proto.mediapipe.PacketFactoryOptions.extensionsBinary, proto.mediapipe.PacketFactoryOptions.prototype.getExtension, proto.mediapipe.PacketFactoryOptions.prototype.setExtension);
    }
    return e2;
  }, proto.mediapipe.PacketFactoryOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.PacketFactoryOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.PacketFactoryOptions.serializeBinaryToWriter = function(e2, r2) {
    t.Message.serializeBinaryExtensions(e2, r2, proto.mediapipe.PacketFactoryOptions.extensionsBinary, proto.mediapipe.PacketFactoryOptions.prototype.getExtension);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.PacketFactoryConfig.prototype.toObject = function(e2) {
    return proto.mediapipe.PacketFactoryConfig.toObject(e2, this);
  }, proto.mediapipe.PacketFactoryConfig.toObject = function(e2, r2) {
    var o2, i = { packetFactory: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, outputSidePacket: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, externalOutput: null == (o2 = t.Message.getField(r2, 1002)) ? void 0 : o2, options: (o2 = r2.getOptions()) && proto.mediapipe.PacketFactoryOptions.toObject(e2, o2) };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.PacketFactoryConfig.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.PacketFactoryConfig();
    return proto.mediapipe.PacketFactoryConfig.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.PacketFactoryConfig.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setPacketFactory(r2);
          break;
        case 2:
          r2 = t2.readString();
          e2.setOutputSidePacket(r2);
          break;
        case 1002:
          r2 = t2.readString();
          e2.setExternalOutput(r2);
          break;
        case 3:
          r2 = new proto.mediapipe.PacketFactoryOptions();
          t2.readMessage(r2, proto.mediapipe.PacketFactoryOptions.deserializeBinaryFromReader), e2.setOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.PacketFactoryConfig.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.PacketFactoryConfig.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.PacketFactoryConfig.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeString(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeString(2, o2), null != (o2 = t.Message.getField(e2, 1002)) && r2.writeString(1002, o2), null != (o2 = e2.getOptions()) && r2.writeMessage(3, o2, proto.mediapipe.PacketFactoryOptions.serializeBinaryToWriter);
  }, proto.mediapipe.PacketFactoryConfig.prototype.getPacketFactory = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.mediapipe.PacketFactoryConfig.prototype.setPacketFactory = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.PacketFactoryConfig.prototype.clearPacketFactory = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.PacketFactoryConfig.prototype.hasPacketFactory = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.PacketFactoryConfig.prototype.getOutputSidePacket = function() {
    return t.Message.getFieldWithDefault(this, 2, "");
  }, proto.mediapipe.PacketFactoryConfig.prototype.setOutputSidePacket = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.PacketFactoryConfig.prototype.clearOutputSidePacket = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.PacketFactoryConfig.prototype.hasOutputSidePacket = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.PacketFactoryConfig.prototype.getExternalOutput = function() {
    return t.Message.getFieldWithDefault(this, 1002, "");
  }, proto.mediapipe.PacketFactoryConfig.prototype.setExternalOutput = function(e2) {
    return t.Message.setField(this, 1002, e2);
  }, proto.mediapipe.PacketFactoryConfig.prototype.clearExternalOutput = function() {
    return t.Message.setField(this, 1002, void 0);
  }, proto.mediapipe.PacketFactoryConfig.prototype.hasExternalOutput = function() {
    return null != t.Message.getField(this, 1002);
  }, proto.mediapipe.PacketFactoryConfig.prototype.getOptions = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.PacketFactoryOptions, 3);
  }, proto.mediapipe.PacketFactoryConfig.prototype.setOptions = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.PacketFactoryConfig.prototype.clearOptions = function() {
    return this.setOptions(void 0);
  }, proto.mediapipe.PacketFactoryConfig.prototype.hasOptions = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.PacketManagerConfig.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.PacketManagerConfig.prototype.toObject = function(e2) {
    return proto.mediapipe.PacketManagerConfig.toObject(e2, this);
  }, proto.mediapipe.PacketManagerConfig.toObject = function(e2, r2) {
    var o2 = { packetList: t.Message.toObjectList(r2.getPacketList(), proto.mediapipe.PacketFactoryConfig.toObject, e2) };
    return e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.PacketManagerConfig.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.PacketManagerConfig();
    return proto.mediapipe.PacketManagerConfig.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.PacketManagerConfig.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new proto.mediapipe.PacketFactoryConfig();
        t2.readMessage(r2, proto.mediapipe.PacketFactoryConfig.deserializeBinaryFromReader), e2.addPacket(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.PacketManagerConfig.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.PacketManagerConfig.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.PacketManagerConfig.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    (r2 = e2.getPacketList()).length > 0 && t2.writeRepeatedMessage(1, r2, proto.mediapipe.PacketFactoryConfig.serializeBinaryToWriter);
  }, proto.mediapipe.PacketManagerConfig.prototype.getPacketList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.PacketFactoryConfig, 1);
  }, proto.mediapipe.PacketManagerConfig.prototype.setPacketList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.PacketManagerConfig.prototype.addPacket = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.PacketFactoryConfig, r2);
  }, proto.mediapipe.PacketManagerConfig.prototype.clearPacketList = function() {
    return this.setPacketList([]);
  }, r.object.extend(e, proto.mediapipe);
})(packet_factory_pb);
var packet_generator_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.PacketGeneratorConfig", null, o), r.exportSymbol("proto.mediapipe.PacketGeneratorOptions", null, o), proto.mediapipe.PacketGeneratorOptions = function(e2) {
    t.Message.initialize(this, e2, 0, 2, null, null);
  }, r.inherits(proto.mediapipe.PacketGeneratorOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.PacketGeneratorOptions.displayName = "proto.mediapipe.PacketGeneratorOptions"), proto.mediapipe.PacketGeneratorOptions.extensions = {}, proto.mediapipe.PacketGeneratorOptions.extensionsBinary = {}, proto.mediapipe.PacketGeneratorConfig = function(e2) {
    t.Message.initialize(this, e2, 0, 500, proto.mediapipe.PacketGeneratorConfig.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.PacketGeneratorConfig, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.PacketGeneratorConfig.displayName = "proto.mediapipe.PacketGeneratorConfig"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.PacketGeneratorOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.PacketGeneratorOptions.toObject(e2, this);
  }, proto.mediapipe.PacketGeneratorOptions.toObject = function(e2, r2) {
    var o2 = { mergeFields: t.Message.getBooleanFieldWithDefault(r2, 1, true) };
    return t.Message.toObjectExtension(r2, o2, proto.mediapipe.PacketGeneratorOptions.extensions, proto.mediapipe.PacketGeneratorOptions.prototype.getExtension, e2), e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.PacketGeneratorOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.PacketGeneratorOptions();
    return proto.mediapipe.PacketGeneratorOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.PacketGeneratorOptions.deserializeBinaryFromReader = function(e2, r2) {
    for (; r2.nextField() && !r2.isEndGroup(); ) {
      if (1 === r2.getFieldNumber()) {
        var o2 = r2.readBool();
        e2.setMergeFields(o2);
      } else t.Message.readBinaryExtension(e2, r2, proto.mediapipe.PacketGeneratorOptions.extensionsBinary, proto.mediapipe.PacketGeneratorOptions.prototype.getExtension, proto.mediapipe.PacketGeneratorOptions.prototype.setExtension);
    }
    return e2;
  }, proto.mediapipe.PacketGeneratorOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.PacketGeneratorOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.PacketGeneratorOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeBool(1, o2), t.Message.serializeBinaryExtensions(e2, r2, proto.mediapipe.PacketGeneratorOptions.extensionsBinary, proto.mediapipe.PacketGeneratorOptions.prototype.getExtension);
  }, proto.mediapipe.PacketGeneratorOptions.prototype.getMergeFields = function() {
    return t.Message.getBooleanFieldWithDefault(this, 1, true);
  }, proto.mediapipe.PacketGeneratorOptions.prototype.setMergeFields = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.PacketGeneratorOptions.prototype.clearMergeFields = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.PacketGeneratorOptions.prototype.hasMergeFields = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.PacketGeneratorConfig.repeatedFields_ = [2, 1002, 3, 1003], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.PacketGeneratorConfig.prototype.toObject = function(e2) {
    return proto.mediapipe.PacketGeneratorConfig.toObject(e2, this);
  }, proto.mediapipe.PacketGeneratorConfig.toObject = function(e2, r2) {
    var o2, i = { packetGenerator: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, inputSidePacketList: null == (o2 = t.Message.getRepeatedField(r2, 2)) ? void 0 : o2, externalInputList: null == (o2 = t.Message.getRepeatedField(r2, 1002)) ? void 0 : o2, outputSidePacketList: null == (o2 = t.Message.getRepeatedField(r2, 3)) ? void 0 : o2, externalOutputList: null == (o2 = t.Message.getRepeatedField(r2, 1003)) ? void 0 : o2, options: (o2 = r2.getOptions()) && proto.mediapipe.PacketGeneratorOptions.toObject(e2, o2) };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.PacketGeneratorConfig.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.PacketGeneratorConfig();
    return proto.mediapipe.PacketGeneratorConfig.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.PacketGeneratorConfig.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setPacketGenerator(r2);
          break;
        case 2:
          r2 = t2.readString();
          e2.addInputSidePacket(r2);
          break;
        case 1002:
          r2 = t2.readString();
          e2.addExternalInput(r2);
          break;
        case 3:
          r2 = t2.readString();
          e2.addOutputSidePacket(r2);
          break;
        case 1003:
          r2 = t2.readString();
          e2.addExternalOutput(r2);
          break;
        case 4:
          r2 = new proto.mediapipe.PacketGeneratorOptions();
          t2.readMessage(r2, proto.mediapipe.PacketGeneratorOptions.deserializeBinaryFromReader), e2.setOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.PacketGeneratorConfig.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.PacketGeneratorConfig.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.PacketGeneratorConfig.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeString(1, o2), (o2 = e2.getInputSidePacketList()).length > 0 && r2.writeRepeatedString(2, o2), (o2 = e2.getExternalInputList()).length > 0 && r2.writeRepeatedString(1002, o2), (o2 = e2.getOutputSidePacketList()).length > 0 && r2.writeRepeatedString(3, o2), (o2 = e2.getExternalOutputList()).length > 0 && r2.writeRepeatedString(1003, o2), null != (o2 = e2.getOptions()) && r2.writeMessage(4, o2, proto.mediapipe.PacketGeneratorOptions.serializeBinaryToWriter);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.getPacketGenerator = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.mediapipe.PacketGeneratorConfig.prototype.setPacketGenerator = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.clearPacketGenerator = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.hasPacketGenerator = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.getInputSidePacketList = function() {
    return t.Message.getRepeatedField(this, 2);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.setInputSidePacketList = function(e2) {
    return t.Message.setField(this, 2, e2 || []);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.addInputSidePacket = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 2, e2, r2);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.clearInputSidePacketList = function() {
    return this.setInputSidePacketList([]);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.getExternalInputList = function() {
    return t.Message.getRepeatedField(this, 1002);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.setExternalInputList = function(e2) {
    return t.Message.setField(this, 1002, e2 || []);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.addExternalInput = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 1002, e2, r2);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.clearExternalInputList = function() {
    return this.setExternalInputList([]);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.getOutputSidePacketList = function() {
    return t.Message.getRepeatedField(this, 3);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.setOutputSidePacketList = function(e2) {
    return t.Message.setField(this, 3, e2 || []);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.addOutputSidePacket = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 3, e2, r2);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.clearOutputSidePacketList = function() {
    return this.setOutputSidePacketList([]);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.getExternalOutputList = function() {
    return t.Message.getRepeatedField(this, 1003);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.setExternalOutputList = function(e2) {
    return t.Message.setField(this, 1003, e2 || []);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.addExternalOutput = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 1003, e2, r2);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.clearExternalOutputList = function() {
    return this.setExternalOutputList([]);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.getOptions = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.PacketGeneratorOptions, 4);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.setOptions = function(e2) {
    return t.Message.setWrapperField(this, 4, e2);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.clearOptions = function() {
    return this.setOptions(void 0);
  }, proto.mediapipe.PacketGeneratorConfig.prototype.hasOptions = function() {
    return null != t.Message.getField(this, 4);
  }, r.object.extend(e, proto.mediapipe);
})(packet_generator_pb);
var status_handler_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = mediapipe_options_pb;
  r.object.extend(proto, i), r.exportSymbol("proto.mediapipe.StatusHandlerConfig", null, o), proto.mediapipe.StatusHandlerConfig = function(e2) {
    t.Message.initialize(this, e2, 0, 500, proto.mediapipe.StatusHandlerConfig.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.StatusHandlerConfig, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.StatusHandlerConfig.displayName = "proto.mediapipe.StatusHandlerConfig"), proto.mediapipe.StatusHandlerConfig.repeatedFields_ = [2, 1002], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.StatusHandlerConfig.prototype.toObject = function(e2) {
    return proto.mediapipe.StatusHandlerConfig.toObject(e2, this);
  }, proto.mediapipe.StatusHandlerConfig.toObject = function(e2, r2) {
    var o2, a2 = { statusHandler: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, inputSidePacketList: null == (o2 = t.Message.getRepeatedField(r2, 2)) ? void 0 : o2, externalInputList: null == (o2 = t.Message.getRepeatedField(r2, 1002)) ? void 0 : o2, options: (o2 = r2.getOptions()) && i.MediaPipeOptions.toObject(e2, o2) };
    return e2 && (a2.$jspbMessageInstance = r2), a2;
  }), proto.mediapipe.StatusHandlerConfig.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.StatusHandlerConfig();
    return proto.mediapipe.StatusHandlerConfig.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.StatusHandlerConfig.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setStatusHandler(r2);
          break;
        case 2:
          r2 = t2.readString();
          e2.addInputSidePacket(r2);
          break;
        case 1002:
          r2 = t2.readString();
          e2.addExternalInput(r2);
          break;
        case 3:
          r2 = new i.MediaPipeOptions();
          t2.readMessage(r2, i.MediaPipeOptions.deserializeBinaryFromReader), e2.setOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.StatusHandlerConfig.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.StatusHandlerConfig.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.StatusHandlerConfig.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeString(1, o2), (o2 = e2.getInputSidePacketList()).length > 0 && r2.writeRepeatedString(2, o2), (o2 = e2.getExternalInputList()).length > 0 && r2.writeRepeatedString(1002, o2), null != (o2 = e2.getOptions()) && r2.writeMessage(3, o2, i.MediaPipeOptions.serializeBinaryToWriter);
  }, proto.mediapipe.StatusHandlerConfig.prototype.getStatusHandler = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.mediapipe.StatusHandlerConfig.prototype.setStatusHandler = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.StatusHandlerConfig.prototype.clearStatusHandler = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.StatusHandlerConfig.prototype.hasStatusHandler = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.StatusHandlerConfig.prototype.getInputSidePacketList = function() {
    return t.Message.getRepeatedField(this, 2);
  }, proto.mediapipe.StatusHandlerConfig.prototype.setInputSidePacketList = function(e2) {
    return t.Message.setField(this, 2, e2 || []);
  }, proto.mediapipe.StatusHandlerConfig.prototype.addInputSidePacket = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 2, e2, r2);
  }, proto.mediapipe.StatusHandlerConfig.prototype.clearInputSidePacketList = function() {
    return this.setInputSidePacketList([]);
  }, proto.mediapipe.StatusHandlerConfig.prototype.getExternalInputList = function() {
    return t.Message.getRepeatedField(this, 1002);
  }, proto.mediapipe.StatusHandlerConfig.prototype.setExternalInputList = function(e2) {
    return t.Message.setField(this, 1002, e2 || []);
  }, proto.mediapipe.StatusHandlerConfig.prototype.addExternalInput = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 1002, e2, r2);
  }, proto.mediapipe.StatusHandlerConfig.prototype.clearExternalInputList = function() {
    return this.setExternalInputList([]);
  }, proto.mediapipe.StatusHandlerConfig.prototype.getOptions = function() {
    return t.Message.getWrapperField(this, i.MediaPipeOptions, 3);
  }, proto.mediapipe.StatusHandlerConfig.prototype.setOptions = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.StatusHandlerConfig.prototype.clearOptions = function() {
    return this.setOptions(void 0);
  }, proto.mediapipe.StatusHandlerConfig.prototype.hasOptions = function() {
    return null != t.Message.getField(this, 3);
  }, r.object.extend(e, proto.mediapipe);
})(status_handler_pb);
var stream_handler_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = mediapipe_options_pb;
  r.object.extend(proto, i), r.exportSymbol("proto.mediapipe.InputStreamHandlerConfig", null, o), r.exportSymbol("proto.mediapipe.OutputStreamHandlerConfig", null, o), proto.mediapipe.InputStreamHandlerConfig = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.InputStreamHandlerConfig, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.InputStreamHandlerConfig.displayName = "proto.mediapipe.InputStreamHandlerConfig"), proto.mediapipe.OutputStreamHandlerConfig = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.OutputStreamHandlerConfig.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.OutputStreamHandlerConfig, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.OutputStreamHandlerConfig.displayName = "proto.mediapipe.OutputStreamHandlerConfig"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.InputStreamHandlerConfig.prototype.toObject = function(e2) {
    return proto.mediapipe.InputStreamHandlerConfig.toObject(e2, this);
  }, proto.mediapipe.InputStreamHandlerConfig.toObject = function(e2, r2) {
    var o2, a2 = { inputStreamHandler: t.Message.getFieldWithDefault(r2, 1, "DefaultInputStreamHandler"), options: (o2 = r2.getOptions()) && i.MediaPipeOptions.toObject(e2, o2) };
    return e2 && (a2.$jspbMessageInstance = r2), a2;
  }), proto.mediapipe.InputStreamHandlerConfig.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.InputStreamHandlerConfig();
    return proto.mediapipe.InputStreamHandlerConfig.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.InputStreamHandlerConfig.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setInputStreamHandler(r2);
          break;
        case 3:
          r2 = new i.MediaPipeOptions();
          t2.readMessage(r2, i.MediaPipeOptions.deserializeBinaryFromReader), e2.setOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.InputStreamHandlerConfig.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.InputStreamHandlerConfig.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.InputStreamHandlerConfig.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeString(1, o2), null != (o2 = e2.getOptions()) && r2.writeMessage(3, o2, i.MediaPipeOptions.serializeBinaryToWriter);
  }, proto.mediapipe.InputStreamHandlerConfig.prototype.getInputStreamHandler = function() {
    return t.Message.getFieldWithDefault(this, 1, "DefaultInputStreamHandler");
  }, proto.mediapipe.InputStreamHandlerConfig.prototype.setInputStreamHandler = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.InputStreamHandlerConfig.prototype.clearInputStreamHandler = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.InputStreamHandlerConfig.prototype.hasInputStreamHandler = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.InputStreamHandlerConfig.prototype.getOptions = function() {
    return t.Message.getWrapperField(this, i.MediaPipeOptions, 3);
  }, proto.mediapipe.InputStreamHandlerConfig.prototype.setOptions = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.InputStreamHandlerConfig.prototype.clearOptions = function() {
    return this.setOptions(void 0);
  }, proto.mediapipe.InputStreamHandlerConfig.prototype.hasOptions = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.OutputStreamHandlerConfig.repeatedFields_ = [2], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.OutputStreamHandlerConfig.prototype.toObject = function(e2) {
    return proto.mediapipe.OutputStreamHandlerConfig.toObject(e2, this);
  }, proto.mediapipe.OutputStreamHandlerConfig.toObject = function(e2, r2) {
    var o2, a2 = { outputStreamHandler: t.Message.getFieldWithDefault(r2, 1, "InOrderOutputStreamHandler"), inputSidePacketList: null == (o2 = t.Message.getRepeatedField(r2, 2)) ? void 0 : o2, options: (o2 = r2.getOptions()) && i.MediaPipeOptions.toObject(e2, o2) };
    return e2 && (a2.$jspbMessageInstance = r2), a2;
  }), proto.mediapipe.OutputStreamHandlerConfig.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.OutputStreamHandlerConfig();
    return proto.mediapipe.OutputStreamHandlerConfig.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.OutputStreamHandlerConfig.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setOutputStreamHandler(r2);
          break;
        case 2:
          r2 = t2.readString();
          e2.addInputSidePacket(r2);
          break;
        case 3:
          r2 = new i.MediaPipeOptions();
          t2.readMessage(r2, i.MediaPipeOptions.deserializeBinaryFromReader), e2.setOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.OutputStreamHandlerConfig.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.OutputStreamHandlerConfig.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.OutputStreamHandlerConfig.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeString(1, o2), (o2 = e2.getInputSidePacketList()).length > 0 && r2.writeRepeatedString(2, o2), null != (o2 = e2.getOptions()) && r2.writeMessage(3, o2, i.MediaPipeOptions.serializeBinaryToWriter);
  }, proto.mediapipe.OutputStreamHandlerConfig.prototype.getOutputStreamHandler = function() {
    return t.Message.getFieldWithDefault(this, 1, "InOrderOutputStreamHandler");
  }, proto.mediapipe.OutputStreamHandlerConfig.prototype.setOutputStreamHandler = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.OutputStreamHandlerConfig.prototype.clearOutputStreamHandler = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.OutputStreamHandlerConfig.prototype.hasOutputStreamHandler = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.OutputStreamHandlerConfig.prototype.getInputSidePacketList = function() {
    return t.Message.getRepeatedField(this, 2);
  }, proto.mediapipe.OutputStreamHandlerConfig.prototype.setInputSidePacketList = function(e2) {
    return t.Message.setField(this, 2, e2 || []);
  }, proto.mediapipe.OutputStreamHandlerConfig.prototype.addInputSidePacket = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 2, e2, r2);
  }, proto.mediapipe.OutputStreamHandlerConfig.prototype.clearInputSidePacketList = function() {
    return this.setInputSidePacketList([]);
  }, proto.mediapipe.OutputStreamHandlerConfig.prototype.getOptions = function() {
    return t.Message.getWrapperField(this, i.MediaPipeOptions, 3);
  }, proto.mediapipe.OutputStreamHandlerConfig.prototype.setOptions = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.OutputStreamHandlerConfig.prototype.clearOptions = function() {
    return this.setOptions(void 0);
  }, proto.mediapipe.OutputStreamHandlerConfig.prototype.hasOptions = function() {
    return null != t.Message.getField(this, 3);
  }, r.object.extend(e, proto.mediapipe);
})(stream_handler_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_options_pb;
  r.object.extend(proto, i);
  var a2 = any_pb;
  r.object.extend(proto, a2);
  var n = mediapipe_options_pb;
  r.object.extend(proto, n);
  var s = packet_factory_pb;
  r.object.extend(proto, s);
  var p = packet_generator_pb;
  r.object.extend(proto, p);
  var d = status_handler_pb;
  r.object.extend(proto, d);
  var l = stream_handler_pb;
  r.object.extend(proto, l), r.exportSymbol("proto.mediapipe.CalculatorGraphConfig", null, o), r.exportSymbol("proto.mediapipe.CalculatorGraphConfig.Node", null, o), r.exportSymbol("proto.mediapipe.ExecutorConfig", null, o), r.exportSymbol("proto.mediapipe.InputCollection", null, o), r.exportSymbol("proto.mediapipe.InputCollection.InputType", null, o), r.exportSymbol("proto.mediapipe.InputCollectionSet", null, o), r.exportSymbol("proto.mediapipe.InputStreamInfo", null, o), r.exportSymbol("proto.mediapipe.ProfilerConfig", null, o), proto.mediapipe.ExecutorConfig = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.ExecutorConfig, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.ExecutorConfig.displayName = "proto.mediapipe.ExecutorConfig"), proto.mediapipe.InputCollection = function(e2) {
    t.Message.initialize(this, e2, 0, 500, proto.mediapipe.InputCollection.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.InputCollection, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.InputCollection.displayName = "proto.mediapipe.InputCollection"), proto.mediapipe.InputCollectionSet = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.InputCollectionSet.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.InputCollectionSet, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.InputCollectionSet.displayName = "proto.mediapipe.InputCollectionSet"), proto.mediapipe.InputStreamInfo = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.InputStreamInfo, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.InputStreamInfo.displayName = "proto.mediapipe.InputStreamInfo"), proto.mediapipe.ProfilerConfig = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.ProfilerConfig.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.ProfilerConfig, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.ProfilerConfig.displayName = "proto.mediapipe.ProfilerConfig"), proto.mediapipe.CalculatorGraphConfig = function(e2) {
    t.Message.initialize(this, e2, 0, 500, proto.mediapipe.CalculatorGraphConfig.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.CalculatorGraphConfig, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.CalculatorGraphConfig.displayName = "proto.mediapipe.CalculatorGraphConfig"), proto.mediapipe.CalculatorGraphConfig.Node = function(e2) {
    t.Message.initialize(this, e2, 0, 500, proto.mediapipe.CalculatorGraphConfig.Node.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.CalculatorGraphConfig.Node, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.CalculatorGraphConfig.Node.displayName = "proto.mediapipe.CalculatorGraphConfig.Node"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.ExecutorConfig.prototype.toObject = function(e2) {
    return proto.mediapipe.ExecutorConfig.toObject(e2, this);
  }, proto.mediapipe.ExecutorConfig.toObject = function(e2, r2) {
    var o2, i2 = { name: t.Message.getFieldWithDefault(r2, 1, ""), type: t.Message.getFieldWithDefault(r2, 2, ""), options: (o2 = r2.getOptions()) && n.MediaPipeOptions.toObject(e2, o2) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.ExecutorConfig.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.ExecutorConfig();
    return proto.mediapipe.ExecutorConfig.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.ExecutorConfig.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setName(r2);
          break;
        case 2:
          r2 = t2.readString();
          e2.setType(r2);
          break;
        case 3:
          r2 = new n.MediaPipeOptions();
          t2.readMessage(r2, n.MediaPipeOptions.deserializeBinaryFromReader), e2.setOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.ExecutorConfig.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.ExecutorConfig.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.ExecutorConfig.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    (r2 = e2.getName()).length > 0 && t2.writeString(1, r2), (r2 = e2.getType()).length > 0 && t2.writeString(2, r2), null != (r2 = e2.getOptions()) && t2.writeMessage(3, r2, n.MediaPipeOptions.serializeBinaryToWriter);
  }, proto.mediapipe.ExecutorConfig.prototype.getName = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.mediapipe.ExecutorConfig.prototype.setName = function(e2) {
    return t.Message.setProto3StringField(this, 1, e2);
  }, proto.mediapipe.ExecutorConfig.prototype.getType = function() {
    return t.Message.getFieldWithDefault(this, 2, "");
  }, proto.mediapipe.ExecutorConfig.prototype.setType = function(e2) {
    return t.Message.setProto3StringField(this, 2, e2);
  }, proto.mediapipe.ExecutorConfig.prototype.getOptions = function() {
    return t.Message.getWrapperField(this, n.MediaPipeOptions, 3);
  }, proto.mediapipe.ExecutorConfig.prototype.setOptions = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.ExecutorConfig.prototype.clearOptions = function() {
    return this.setOptions(void 0);
  }, proto.mediapipe.ExecutorConfig.prototype.hasOptions = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.InputCollection.repeatedFields_ = [2, 1002], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.InputCollection.prototype.toObject = function(e2) {
    return proto.mediapipe.InputCollection.toObject(e2, this);
  }, proto.mediapipe.InputCollection.toObject = function(e2, r2) {
    var o2, i2 = { name: t.Message.getFieldWithDefault(r2, 1, ""), sidePacketNameList: null == (o2 = t.Message.getRepeatedField(r2, 2)) ? void 0 : o2, externalInputNameList: null == (o2 = t.Message.getRepeatedField(r2, 1002)) ? void 0 : o2, inputType: t.Message.getFieldWithDefault(r2, 3, 0), fileName: t.Message.getFieldWithDefault(r2, 4, "") };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.InputCollection.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.InputCollection();
    return proto.mediapipe.InputCollection.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.InputCollection.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setName(r2);
          break;
        case 2:
          r2 = t2.readString();
          e2.addSidePacketName(r2);
          break;
        case 1002:
          r2 = t2.readString();
          e2.addExternalInputName(r2);
          break;
        case 3:
          r2 = t2.readEnum();
          e2.setInputType(r2);
          break;
        case 4:
          r2 = t2.readString();
          e2.setFileName(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.InputCollection.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.InputCollection.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.InputCollection.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    (r2 = e2.getName()).length > 0 && t2.writeString(1, r2), (r2 = e2.getSidePacketNameList()).length > 0 && t2.writeRepeatedString(2, r2), (r2 = e2.getExternalInputNameList()).length > 0 && t2.writeRepeatedString(1002, r2), 0 !== (r2 = e2.getInputType()) && t2.writeEnum(3, r2), (r2 = e2.getFileName()).length > 0 && t2.writeString(4, r2);
  }, proto.mediapipe.InputCollection.InputType = { UNKNOWN: 0, RECORDIO: 1, FOREIGN_RECORDIO: 2, FOREIGN_CSV_TEXT: 3, INVALID_UPPER_BOUND: 4 }, proto.mediapipe.InputCollection.prototype.getName = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.mediapipe.InputCollection.prototype.setName = function(e2) {
    return t.Message.setProto3StringField(this, 1, e2);
  }, proto.mediapipe.InputCollection.prototype.getSidePacketNameList = function() {
    return t.Message.getRepeatedField(this, 2);
  }, proto.mediapipe.InputCollection.prototype.setSidePacketNameList = function(e2) {
    return t.Message.setField(this, 2, e2 || []);
  }, proto.mediapipe.InputCollection.prototype.addSidePacketName = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 2, e2, r2);
  }, proto.mediapipe.InputCollection.prototype.clearSidePacketNameList = function() {
    return this.setSidePacketNameList([]);
  }, proto.mediapipe.InputCollection.prototype.getExternalInputNameList = function() {
    return t.Message.getRepeatedField(this, 1002);
  }, proto.mediapipe.InputCollection.prototype.setExternalInputNameList = function(e2) {
    return t.Message.setField(this, 1002, e2 || []);
  }, proto.mediapipe.InputCollection.prototype.addExternalInputName = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 1002, e2, r2);
  }, proto.mediapipe.InputCollection.prototype.clearExternalInputNameList = function() {
    return this.setExternalInputNameList([]);
  }, proto.mediapipe.InputCollection.prototype.getInputType = function() {
    return t.Message.getFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.InputCollection.prototype.setInputType = function(e2) {
    return t.Message.setProto3EnumField(this, 3, e2);
  }, proto.mediapipe.InputCollection.prototype.getFileName = function() {
    return t.Message.getFieldWithDefault(this, 4, "");
  }, proto.mediapipe.InputCollection.prototype.setFileName = function(e2) {
    return t.Message.setProto3StringField(this, 4, e2);
  }, proto.mediapipe.InputCollectionSet.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.InputCollectionSet.prototype.toObject = function(e2) {
    return proto.mediapipe.InputCollectionSet.toObject(e2, this);
  }, proto.mediapipe.InputCollectionSet.toObject = function(e2, r2) {
    var o2 = { inputCollectionList: t.Message.toObjectList(r2.getInputCollectionList(), proto.mediapipe.InputCollection.toObject, e2) };
    return e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.InputCollectionSet.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.InputCollectionSet();
    return proto.mediapipe.InputCollectionSet.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.InputCollectionSet.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new proto.mediapipe.InputCollection();
        t2.readMessage(r2, proto.mediapipe.InputCollection.deserializeBinaryFromReader), e2.addInputCollection(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.InputCollectionSet.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.InputCollectionSet.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.InputCollectionSet.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    (r2 = e2.getInputCollectionList()).length > 0 && t2.writeRepeatedMessage(1, r2, proto.mediapipe.InputCollection.serializeBinaryToWriter);
  }, proto.mediapipe.InputCollectionSet.prototype.getInputCollectionList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.InputCollection, 1);
  }, proto.mediapipe.InputCollectionSet.prototype.setInputCollectionList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.InputCollectionSet.prototype.addInputCollection = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.InputCollection, r2);
  }, proto.mediapipe.InputCollectionSet.prototype.clearInputCollectionList = function() {
    return this.setInputCollectionList([]);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.InputStreamInfo.prototype.toObject = function(e2) {
    return proto.mediapipe.InputStreamInfo.toObject(e2, this);
  }, proto.mediapipe.InputStreamInfo.toObject = function(e2, r2) {
    var o2 = { tagIndex: t.Message.getFieldWithDefault(r2, 1, ""), backEdge: t.Message.getBooleanFieldWithDefault(r2, 2, false) };
    return e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.InputStreamInfo.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.InputStreamInfo();
    return proto.mediapipe.InputStreamInfo.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.InputStreamInfo.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setTagIndex(r2);
          break;
        case 2:
          r2 = t2.readBool();
          e2.setBackEdge(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.InputStreamInfo.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.InputStreamInfo.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.InputStreamInfo.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    (r2 = e2.getTagIndex()).length > 0 && t2.writeString(1, r2), (r2 = e2.getBackEdge()) && t2.writeBool(2, r2);
  }, proto.mediapipe.InputStreamInfo.prototype.getTagIndex = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.mediapipe.InputStreamInfo.prototype.setTagIndex = function(e2) {
    return t.Message.setProto3StringField(this, 1, e2);
  }, proto.mediapipe.InputStreamInfo.prototype.getBackEdge = function() {
    return t.Message.getBooleanFieldWithDefault(this, 2, false);
  }, proto.mediapipe.InputStreamInfo.prototype.setBackEdge = function(e2) {
    return t.Message.setProto3BooleanField(this, 2, e2);
  }, proto.mediapipe.ProfilerConfig.repeatedFields_ = [8], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.ProfilerConfig.prototype.toObject = function(e2) {
    return proto.mediapipe.ProfilerConfig.toObject(e2, this);
  }, proto.mediapipe.ProfilerConfig.toObject = function(e2, r2) {
    var o2, i2 = { histogramIntervalSizeUsec: t.Message.getFieldWithDefault(r2, 1, 0), numHistogramIntervals: t.Message.getFieldWithDefault(r2, 2, 0), enableInputOutputLatency: t.Message.getBooleanFieldWithDefault(r2, 3, false), enableProfiler: t.Message.getBooleanFieldWithDefault(r2, 4, false), enableStreamLatency: t.Message.getBooleanFieldWithDefault(r2, 5, false), usePacketTimestampForAddedPacket: t.Message.getBooleanFieldWithDefault(r2, 6, false), traceLogCapacity: t.Message.getFieldWithDefault(r2, 7, 0), traceEventTypesDisabledList: null == (o2 = t.Message.getRepeatedField(r2, 8)) ? void 0 : o2, traceLogPath: t.Message.getFieldWithDefault(r2, 9, ""), traceLogCount: t.Message.getFieldWithDefault(r2, 10, 0), traceLogIntervalUsec: t.Message.getFieldWithDefault(r2, 11, 0), traceLogMarginUsec: t.Message.getFieldWithDefault(r2, 12, 0), traceLogDurationEvents: t.Message.getBooleanFieldWithDefault(r2, 13, false), traceLogIntervalCount: t.Message.getFieldWithDefault(r2, 14, 0), traceLogDisabled: t.Message.getBooleanFieldWithDefault(r2, 15, false), traceEnabled: t.Message.getBooleanFieldWithDefault(r2, 16, false), traceLogInstantEvents: t.Message.getBooleanFieldWithDefault(r2, 17, false), calculatorFilter: t.Message.getFieldWithDefault(r2, 18, "") };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.ProfilerConfig.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.ProfilerConfig();
    return proto.mediapipe.ProfilerConfig.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.ProfilerConfig.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readInt64();
          e2.setHistogramIntervalSizeUsec(r2);
          break;
        case 2:
          r2 = t2.readInt64();
          e2.setNumHistogramIntervals(r2);
          break;
        case 3:
          r2 = t2.readBool();
          e2.setEnableInputOutputLatency(r2);
          break;
        case 4:
          r2 = t2.readBool();
          e2.setEnableProfiler(r2);
          break;
        case 5:
          r2 = t2.readBool();
          e2.setEnableStreamLatency(r2);
          break;
        case 6:
          r2 = t2.readBool();
          e2.setUsePacketTimestampForAddedPacket(r2);
          break;
        case 7:
          r2 = t2.readInt64();
          e2.setTraceLogCapacity(r2);
          break;
        case 8:
          for (var o2 = t2.isDelimited() ? t2.readPackedInt32() : [t2.readInt32()], i2 = 0; i2 < o2.length; i2++) e2.addTraceEventTypesDisabled(o2[i2]);
          break;
        case 9:
          r2 = t2.readString();
          e2.setTraceLogPath(r2);
          break;
        case 10:
          r2 = t2.readInt32();
          e2.setTraceLogCount(r2);
          break;
        case 11:
          r2 = t2.readInt64();
          e2.setTraceLogIntervalUsec(r2);
          break;
        case 12:
          r2 = t2.readInt64();
          e2.setTraceLogMarginUsec(r2);
          break;
        case 13:
          r2 = t2.readBool();
          e2.setTraceLogDurationEvents(r2);
          break;
        case 14:
          r2 = t2.readInt32();
          e2.setTraceLogIntervalCount(r2);
          break;
        case 15:
          r2 = t2.readBool();
          e2.setTraceLogDisabled(r2);
          break;
        case 16:
          r2 = t2.readBool();
          e2.setTraceEnabled(r2);
          break;
        case 17:
          r2 = t2.readBool();
          e2.setTraceLogInstantEvents(r2);
          break;
        case 18:
          r2 = t2.readString();
          e2.setCalculatorFilter(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.ProfilerConfig.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.ProfilerConfig.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.ProfilerConfig.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    0 !== (r2 = e2.getHistogramIntervalSizeUsec()) && t2.writeInt64(1, r2), 0 !== (r2 = e2.getNumHistogramIntervals()) && t2.writeInt64(2, r2), (r2 = e2.getEnableInputOutputLatency()) && t2.writeBool(3, r2), (r2 = e2.getEnableProfiler()) && t2.writeBool(4, r2), (r2 = e2.getEnableStreamLatency()) && t2.writeBool(5, r2), (r2 = e2.getUsePacketTimestampForAddedPacket()) && t2.writeBool(6, r2), 0 !== (r2 = e2.getTraceLogCapacity()) && t2.writeInt64(7, r2), (r2 = e2.getTraceEventTypesDisabledList()).length > 0 && t2.writePackedInt32(8, r2), (r2 = e2.getTraceLogPath()).length > 0 && t2.writeString(9, r2), 0 !== (r2 = e2.getTraceLogCount()) && t2.writeInt32(10, r2), 0 !== (r2 = e2.getTraceLogIntervalUsec()) && t2.writeInt64(11, r2), 0 !== (r2 = e2.getTraceLogMarginUsec()) && t2.writeInt64(12, r2), (r2 = e2.getTraceLogDurationEvents()) && t2.writeBool(13, r2), 0 !== (r2 = e2.getTraceLogIntervalCount()) && t2.writeInt32(14, r2), (r2 = e2.getTraceLogDisabled()) && t2.writeBool(15, r2), (r2 = e2.getTraceEnabled()) && t2.writeBool(16, r2), (r2 = e2.getTraceLogInstantEvents()) && t2.writeBool(17, r2), (r2 = e2.getCalculatorFilter()).length > 0 && t2.writeString(18, r2);
  }, proto.mediapipe.ProfilerConfig.prototype.getHistogramIntervalSizeUsec = function() {
    return t.Message.getFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.ProfilerConfig.prototype.setHistogramIntervalSizeUsec = function(e2) {
    return t.Message.setProto3IntField(this, 1, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getNumHistogramIntervals = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.ProfilerConfig.prototype.setNumHistogramIntervals = function(e2) {
    return t.Message.setProto3IntField(this, 2, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getEnableInputOutputLatency = function() {
    return t.Message.getBooleanFieldWithDefault(this, 3, false);
  }, proto.mediapipe.ProfilerConfig.prototype.setEnableInputOutputLatency = function(e2) {
    return t.Message.setProto3BooleanField(this, 3, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getEnableProfiler = function() {
    return t.Message.getBooleanFieldWithDefault(this, 4, false);
  }, proto.mediapipe.ProfilerConfig.prototype.setEnableProfiler = function(e2) {
    return t.Message.setProto3BooleanField(this, 4, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getEnableStreamLatency = function() {
    return t.Message.getBooleanFieldWithDefault(this, 5, false);
  }, proto.mediapipe.ProfilerConfig.prototype.setEnableStreamLatency = function(e2) {
    return t.Message.setProto3BooleanField(this, 5, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getUsePacketTimestampForAddedPacket = function() {
    return t.Message.getBooleanFieldWithDefault(this, 6, false);
  }, proto.mediapipe.ProfilerConfig.prototype.setUsePacketTimestampForAddedPacket = function(e2) {
    return t.Message.setProto3BooleanField(this, 6, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getTraceLogCapacity = function() {
    return t.Message.getFieldWithDefault(this, 7, 0);
  }, proto.mediapipe.ProfilerConfig.prototype.setTraceLogCapacity = function(e2) {
    return t.Message.setProto3IntField(this, 7, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getTraceEventTypesDisabledList = function() {
    return t.Message.getRepeatedField(this, 8);
  }, proto.mediapipe.ProfilerConfig.prototype.setTraceEventTypesDisabledList = function(e2) {
    return t.Message.setField(this, 8, e2 || []);
  }, proto.mediapipe.ProfilerConfig.prototype.addTraceEventTypesDisabled = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 8, e2, r2);
  }, proto.mediapipe.ProfilerConfig.prototype.clearTraceEventTypesDisabledList = function() {
    return this.setTraceEventTypesDisabledList([]);
  }, proto.mediapipe.ProfilerConfig.prototype.getTraceLogPath = function() {
    return t.Message.getFieldWithDefault(this, 9, "");
  }, proto.mediapipe.ProfilerConfig.prototype.setTraceLogPath = function(e2) {
    return t.Message.setProto3StringField(this, 9, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getTraceLogCount = function() {
    return t.Message.getFieldWithDefault(this, 10, 0);
  }, proto.mediapipe.ProfilerConfig.prototype.setTraceLogCount = function(e2) {
    return t.Message.setProto3IntField(this, 10, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getTraceLogIntervalUsec = function() {
    return t.Message.getFieldWithDefault(this, 11, 0);
  }, proto.mediapipe.ProfilerConfig.prototype.setTraceLogIntervalUsec = function(e2) {
    return t.Message.setProto3IntField(this, 11, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getTraceLogMarginUsec = function() {
    return t.Message.getFieldWithDefault(this, 12, 0);
  }, proto.mediapipe.ProfilerConfig.prototype.setTraceLogMarginUsec = function(e2) {
    return t.Message.setProto3IntField(this, 12, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getTraceLogDurationEvents = function() {
    return t.Message.getBooleanFieldWithDefault(this, 13, false);
  }, proto.mediapipe.ProfilerConfig.prototype.setTraceLogDurationEvents = function(e2) {
    return t.Message.setProto3BooleanField(this, 13, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getTraceLogIntervalCount = function() {
    return t.Message.getFieldWithDefault(this, 14, 0);
  }, proto.mediapipe.ProfilerConfig.prototype.setTraceLogIntervalCount = function(e2) {
    return t.Message.setProto3IntField(this, 14, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getTraceLogDisabled = function() {
    return t.Message.getBooleanFieldWithDefault(this, 15, false);
  }, proto.mediapipe.ProfilerConfig.prototype.setTraceLogDisabled = function(e2) {
    return t.Message.setProto3BooleanField(this, 15, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getTraceEnabled = function() {
    return t.Message.getBooleanFieldWithDefault(this, 16, false);
  }, proto.mediapipe.ProfilerConfig.prototype.setTraceEnabled = function(e2) {
    return t.Message.setProto3BooleanField(this, 16, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getTraceLogInstantEvents = function() {
    return t.Message.getBooleanFieldWithDefault(this, 17, false);
  }, proto.mediapipe.ProfilerConfig.prototype.setTraceLogInstantEvents = function(e2) {
    return t.Message.setProto3BooleanField(this, 17, e2);
  }, proto.mediapipe.ProfilerConfig.prototype.getCalculatorFilter = function() {
    return t.Message.getFieldWithDefault(this, 18, "");
  }, proto.mediapipe.ProfilerConfig.prototype.setCalculatorFilter = function(e2) {
    return t.Message.setProto3StringField(this, 18, e2);
  }, proto.mediapipe.CalculatorGraphConfig.repeatedFields_ = [1, 6, 7, 9, 10, 15, 16, 17, 14, 1002], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.CalculatorGraphConfig.prototype.toObject = function(e2) {
    return proto.mediapipe.CalculatorGraphConfig.toObject(e2, this);
  }, proto.mediapipe.CalculatorGraphConfig.toObject = function(e2, r2) {
    var o2, i2 = { nodeList: t.Message.toObjectList(r2.getNodeList(), proto.mediapipe.CalculatorGraphConfig.Node.toObject, e2), packetFactoryList: t.Message.toObjectList(r2.getPacketFactoryList(), s.PacketFactoryConfig.toObject, e2), packetGeneratorList: t.Message.toObjectList(r2.getPacketGeneratorList(), p.PacketGeneratorConfig.toObject, e2), numThreads: t.Message.getFieldWithDefault(r2, 8, 0), statusHandlerList: t.Message.toObjectList(r2.getStatusHandlerList(), d.StatusHandlerConfig.toObject, e2), inputStreamList: null == (o2 = t.Message.getRepeatedField(r2, 10)) ? void 0 : o2, outputStreamList: null == (o2 = t.Message.getRepeatedField(r2, 15)) ? void 0 : o2, inputSidePacketList: null == (o2 = t.Message.getRepeatedField(r2, 16)) ? void 0 : o2, outputSidePacketList: null == (o2 = t.Message.getRepeatedField(r2, 17)) ? void 0 : o2, maxQueueSize: t.Message.getFieldWithDefault(r2, 11, 0), reportDeadlock: t.Message.getBooleanFieldWithDefault(r2, 21, false), inputStreamHandler: (o2 = r2.getInputStreamHandler()) && l.InputStreamHandlerConfig.toObject(e2, o2), outputStreamHandler: (o2 = r2.getOutputStreamHandler()) && l.OutputStreamHandlerConfig.toObject(e2, o2), executorList: t.Message.toObjectList(r2.getExecutorList(), proto.mediapipe.ExecutorConfig.toObject, e2), profilerConfig: (o2 = r2.getProfilerConfig()) && proto.mediapipe.ProfilerConfig.toObject(e2, o2), pb_package: t.Message.getFieldWithDefault(r2, 19, ""), type: t.Message.getFieldWithDefault(r2, 20, ""), options: (o2 = r2.getOptions()) && n.MediaPipeOptions.toObject(e2, o2), graphOptionsList: t.Message.toObjectList(r2.getGraphOptionsList(), a2.Any.toObject, e2) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.CalculatorGraphConfig.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.CalculatorGraphConfig();
    return proto.mediapipe.CalculatorGraphConfig.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.CalculatorGraphConfig.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new proto.mediapipe.CalculatorGraphConfig.Node();
          t2.readMessage(r2, proto.mediapipe.CalculatorGraphConfig.Node.deserializeBinaryFromReader), e2.addNode(r2);
          break;
        case 6:
          r2 = new s.PacketFactoryConfig();
          t2.readMessage(r2, s.PacketFactoryConfig.deserializeBinaryFromReader), e2.addPacketFactory(r2);
          break;
        case 7:
          r2 = new p.PacketGeneratorConfig();
          t2.readMessage(r2, p.PacketGeneratorConfig.deserializeBinaryFromReader), e2.addPacketGenerator(r2);
          break;
        case 8:
          r2 = t2.readInt32();
          e2.setNumThreads(r2);
          break;
        case 9:
          r2 = new d.StatusHandlerConfig();
          t2.readMessage(r2, d.StatusHandlerConfig.deserializeBinaryFromReader), e2.addStatusHandler(r2);
          break;
        case 10:
          r2 = t2.readString();
          e2.addInputStream(r2);
          break;
        case 15:
          r2 = t2.readString();
          e2.addOutputStream(r2);
          break;
        case 16:
          r2 = t2.readString();
          e2.addInputSidePacket(r2);
          break;
        case 17:
          r2 = t2.readString();
          e2.addOutputSidePacket(r2);
          break;
        case 11:
          r2 = t2.readInt32();
          e2.setMaxQueueSize(r2);
          break;
        case 21:
          r2 = t2.readBool();
          e2.setReportDeadlock(r2);
          break;
        case 12:
          r2 = new l.InputStreamHandlerConfig();
          t2.readMessage(r2, l.InputStreamHandlerConfig.deserializeBinaryFromReader), e2.setInputStreamHandler(r2);
          break;
        case 13:
          r2 = new l.OutputStreamHandlerConfig();
          t2.readMessage(r2, l.OutputStreamHandlerConfig.deserializeBinaryFromReader), e2.setOutputStreamHandler(r2);
          break;
        case 14:
          r2 = new proto.mediapipe.ExecutorConfig();
          t2.readMessage(r2, proto.mediapipe.ExecutorConfig.deserializeBinaryFromReader), e2.addExecutor(r2);
          break;
        case 18:
          r2 = new proto.mediapipe.ProfilerConfig();
          t2.readMessage(r2, proto.mediapipe.ProfilerConfig.deserializeBinaryFromReader), e2.setProfilerConfig(r2);
          break;
        case 19:
          r2 = t2.readString();
          e2.setPackage(r2);
          break;
        case 20:
          r2 = t2.readString();
          e2.setType(r2);
          break;
        case 1001:
          r2 = new n.MediaPipeOptions();
          t2.readMessage(r2, n.MediaPipeOptions.deserializeBinaryFromReader), e2.setOptions(r2);
          break;
        case 1002:
          r2 = new a2.Any();
          t2.readMessage(r2, a2.Any.deserializeBinaryFromReader), e2.addGraphOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.CalculatorGraphConfig.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.CalculatorGraphConfig.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.CalculatorGraphConfig.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    (r2 = e2.getNodeList()).length > 0 && t2.writeRepeatedMessage(1, r2, proto.mediapipe.CalculatorGraphConfig.Node.serializeBinaryToWriter), (r2 = e2.getPacketFactoryList()).length > 0 && t2.writeRepeatedMessage(6, r2, s.PacketFactoryConfig.serializeBinaryToWriter), (r2 = e2.getPacketGeneratorList()).length > 0 && t2.writeRepeatedMessage(7, r2, p.PacketGeneratorConfig.serializeBinaryToWriter), 0 !== (r2 = e2.getNumThreads()) && t2.writeInt32(8, r2), (r2 = e2.getStatusHandlerList()).length > 0 && t2.writeRepeatedMessage(9, r2, d.StatusHandlerConfig.serializeBinaryToWriter), (r2 = e2.getInputStreamList()).length > 0 && t2.writeRepeatedString(10, r2), (r2 = e2.getOutputStreamList()).length > 0 && t2.writeRepeatedString(15, r2), (r2 = e2.getInputSidePacketList()).length > 0 && t2.writeRepeatedString(16, r2), (r2 = e2.getOutputSidePacketList()).length > 0 && t2.writeRepeatedString(17, r2), 0 !== (r2 = e2.getMaxQueueSize()) && t2.writeInt32(11, r2), (r2 = e2.getReportDeadlock()) && t2.writeBool(21, r2), null != (r2 = e2.getInputStreamHandler()) && t2.writeMessage(12, r2, l.InputStreamHandlerConfig.serializeBinaryToWriter), null != (r2 = e2.getOutputStreamHandler()) && t2.writeMessage(13, r2, l.OutputStreamHandlerConfig.serializeBinaryToWriter), (r2 = e2.getExecutorList()).length > 0 && t2.writeRepeatedMessage(14, r2, proto.mediapipe.ExecutorConfig.serializeBinaryToWriter), null != (r2 = e2.getProfilerConfig()) && t2.writeMessage(18, r2, proto.mediapipe.ProfilerConfig.serializeBinaryToWriter), (r2 = e2.getPackage()).length > 0 && t2.writeString(19, r2), (r2 = e2.getType()).length > 0 && t2.writeString(20, r2), null != (r2 = e2.getOptions()) && t2.writeMessage(1001, r2, n.MediaPipeOptions.serializeBinaryToWriter), (r2 = e2.getGraphOptionsList()).length > 0 && t2.writeRepeatedMessage(1002, r2, a2.Any.serializeBinaryToWriter);
  }, proto.mediapipe.CalculatorGraphConfig.Node.repeatedFields_ = [3, 4, 5, 6, 8, 13, 17, 1005], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.CalculatorGraphConfig.Node.prototype.toObject = function(e2) {
    return proto.mediapipe.CalculatorGraphConfig.Node.toObject(e2, this);
  }, proto.mediapipe.CalculatorGraphConfig.Node.toObject = function(e2, r2) {
    var o2, n2 = { name: t.Message.getFieldWithDefault(r2, 1, ""), calculator: t.Message.getFieldWithDefault(r2, 2, ""), inputStreamList: null == (o2 = t.Message.getRepeatedField(r2, 3)) ? void 0 : o2, outputStreamList: null == (o2 = t.Message.getRepeatedField(r2, 4)) ? void 0 : o2, inputSidePacketList: null == (o2 = t.Message.getRepeatedField(r2, 5)) ? void 0 : o2, outputSidePacketList: null == (o2 = t.Message.getRepeatedField(r2, 6)) ? void 0 : o2, options: (o2 = r2.getOptions()) && i.CalculatorOptions.toObject(e2, o2), nodeOptionsList: t.Message.toObjectList(r2.getNodeOptionsList(), a2.Any.toObject, e2), sourceLayer: t.Message.getFieldWithDefault(r2, 9, 0), bufferSizeHint: t.Message.getFieldWithDefault(r2, 10, 0), inputStreamHandler: (o2 = r2.getInputStreamHandler()) && l.InputStreamHandlerConfig.toObject(e2, o2), outputStreamHandler: (o2 = r2.getOutputStreamHandler()) && l.OutputStreamHandlerConfig.toObject(e2, o2), inputStreamInfoList: t.Message.toObjectList(r2.getInputStreamInfoList(), proto.mediapipe.InputStreamInfo.toObject, e2), executor: t.Message.getFieldWithDefault(r2, 14, ""), profilerConfig: (o2 = r2.getProfilerConfig()) && proto.mediapipe.ProfilerConfig.toObject(e2, o2), maxInFlight: t.Message.getFieldWithDefault(r2, 16, 0), optionValueList: null == (o2 = t.Message.getRepeatedField(r2, 17)) ? void 0 : o2, externalInputList: null == (o2 = t.Message.getRepeatedField(r2, 1005)) ? void 0 : o2 };
    return e2 && (n2.$jspbMessageInstance = r2), n2;
  }), proto.mediapipe.CalculatorGraphConfig.Node.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.CalculatorGraphConfig.Node();
    return proto.mediapipe.CalculatorGraphConfig.Node.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setName(r2);
          break;
        case 2:
          r2 = t2.readString();
          e2.setCalculator(r2);
          break;
        case 3:
          r2 = t2.readString();
          e2.addInputStream(r2);
          break;
        case 4:
          r2 = t2.readString();
          e2.addOutputStream(r2);
          break;
        case 5:
          r2 = t2.readString();
          e2.addInputSidePacket(r2);
          break;
        case 6:
          r2 = t2.readString();
          e2.addOutputSidePacket(r2);
          break;
        case 7:
          r2 = new i.CalculatorOptions();
          t2.readMessage(r2, i.CalculatorOptions.deserializeBinaryFromReader), e2.setOptions(r2);
          break;
        case 8:
          r2 = new a2.Any();
          t2.readMessage(r2, a2.Any.deserializeBinaryFromReader), e2.addNodeOptions(r2);
          break;
        case 9:
          r2 = t2.readInt32();
          e2.setSourceLayer(r2);
          break;
        case 10:
          r2 = t2.readInt32();
          e2.setBufferSizeHint(r2);
          break;
        case 11:
          r2 = new l.InputStreamHandlerConfig();
          t2.readMessage(r2, l.InputStreamHandlerConfig.deserializeBinaryFromReader), e2.setInputStreamHandler(r2);
          break;
        case 12:
          r2 = new l.OutputStreamHandlerConfig();
          t2.readMessage(r2, l.OutputStreamHandlerConfig.deserializeBinaryFromReader), e2.setOutputStreamHandler(r2);
          break;
        case 13:
          r2 = new proto.mediapipe.InputStreamInfo();
          t2.readMessage(r2, proto.mediapipe.InputStreamInfo.deserializeBinaryFromReader), e2.addInputStreamInfo(r2);
          break;
        case 14:
          r2 = t2.readString();
          e2.setExecutor(r2);
          break;
        case 15:
          r2 = new proto.mediapipe.ProfilerConfig();
          t2.readMessage(r2, proto.mediapipe.ProfilerConfig.deserializeBinaryFromReader), e2.setProfilerConfig(r2);
          break;
        case 16:
          r2 = t2.readInt32();
          e2.setMaxInFlight(r2);
          break;
        case 17:
          r2 = t2.readString();
          e2.addOptionValue(r2);
          break;
        case 1005:
          r2 = t2.readString();
          e2.addExternalInput(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.CalculatorGraphConfig.Node.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.CalculatorGraphConfig.Node.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    (r2 = e2.getName()).length > 0 && t2.writeString(1, r2), (r2 = e2.getCalculator()).length > 0 && t2.writeString(2, r2), (r2 = e2.getInputStreamList()).length > 0 && t2.writeRepeatedString(3, r2), (r2 = e2.getOutputStreamList()).length > 0 && t2.writeRepeatedString(4, r2), (r2 = e2.getInputSidePacketList()).length > 0 && t2.writeRepeatedString(5, r2), (r2 = e2.getOutputSidePacketList()).length > 0 && t2.writeRepeatedString(6, r2), null != (r2 = e2.getOptions()) && t2.writeMessage(7, r2, i.CalculatorOptions.serializeBinaryToWriter), (r2 = e2.getNodeOptionsList()).length > 0 && t2.writeRepeatedMessage(8, r2, a2.Any.serializeBinaryToWriter), 0 !== (r2 = e2.getSourceLayer()) && t2.writeInt32(9, r2), 0 !== (r2 = e2.getBufferSizeHint()) && t2.writeInt32(10, r2), null != (r2 = e2.getInputStreamHandler()) && t2.writeMessage(11, r2, l.InputStreamHandlerConfig.serializeBinaryToWriter), null != (r2 = e2.getOutputStreamHandler()) && t2.writeMessage(12, r2, l.OutputStreamHandlerConfig.serializeBinaryToWriter), (r2 = e2.getInputStreamInfoList()).length > 0 && t2.writeRepeatedMessage(13, r2, proto.mediapipe.InputStreamInfo.serializeBinaryToWriter), (r2 = e2.getExecutor()).length > 0 && t2.writeString(14, r2), null != (r2 = e2.getProfilerConfig()) && t2.writeMessage(15, r2, proto.mediapipe.ProfilerConfig.serializeBinaryToWriter), 0 !== (r2 = e2.getMaxInFlight()) && t2.writeInt32(16, r2), (r2 = e2.getOptionValueList()).length > 0 && t2.writeRepeatedString(17, r2), (r2 = e2.getExternalInputList()).length > 0 && t2.writeRepeatedString(1005, r2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getName = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setName = function(e2) {
    return t.Message.setProto3StringField(this, 1, e2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getCalculator = function() {
    return t.Message.getFieldWithDefault(this, 2, "");
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setCalculator = function(e2) {
    return t.Message.setProto3StringField(this, 2, e2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getInputStreamList = function() {
    return t.Message.getRepeatedField(this, 3);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setInputStreamList = function(e2) {
    return t.Message.setField(this, 3, e2 || []);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.addInputStream = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 3, e2, r2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearInputStreamList = function() {
    return this.setInputStreamList([]);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getOutputStreamList = function() {
    return t.Message.getRepeatedField(this, 4);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setOutputStreamList = function(e2) {
    return t.Message.setField(this, 4, e2 || []);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.addOutputStream = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 4, e2, r2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearOutputStreamList = function() {
    return this.setOutputStreamList([]);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getInputSidePacketList = function() {
    return t.Message.getRepeatedField(this, 5);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setInputSidePacketList = function(e2) {
    return t.Message.setField(this, 5, e2 || []);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.addInputSidePacket = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 5, e2, r2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearInputSidePacketList = function() {
    return this.setInputSidePacketList([]);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getOutputSidePacketList = function() {
    return t.Message.getRepeatedField(this, 6);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setOutputSidePacketList = function(e2) {
    return t.Message.setField(this, 6, e2 || []);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.addOutputSidePacket = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 6, e2, r2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearOutputSidePacketList = function() {
    return this.setOutputSidePacketList([]);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getOptions = function() {
    return t.Message.getWrapperField(this, i.CalculatorOptions, 7);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setOptions = function(e2) {
    return t.Message.setWrapperField(this, 7, e2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearOptions = function() {
    return this.setOptions(void 0);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.hasOptions = function() {
    return null != t.Message.getField(this, 7);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getNodeOptionsList = function() {
    return t.Message.getRepeatedWrapperField(this, a2.Any, 8);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setNodeOptionsList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 8, e2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.addNodeOptions = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 8, e2, proto.google.protobuf.Any, r2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearNodeOptionsList = function() {
    return this.setNodeOptionsList([]);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getSourceLayer = function() {
    return t.Message.getFieldWithDefault(this, 9, 0);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setSourceLayer = function(e2) {
    return t.Message.setProto3IntField(this, 9, e2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getBufferSizeHint = function() {
    return t.Message.getFieldWithDefault(this, 10, 0);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setBufferSizeHint = function(e2) {
    return t.Message.setProto3IntField(this, 10, e2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getInputStreamHandler = function() {
    return t.Message.getWrapperField(this, l.InputStreamHandlerConfig, 11);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setInputStreamHandler = function(e2) {
    return t.Message.setWrapperField(this, 11, e2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearInputStreamHandler = function() {
    return this.setInputStreamHandler(void 0);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.hasInputStreamHandler = function() {
    return null != t.Message.getField(this, 11);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getOutputStreamHandler = function() {
    return t.Message.getWrapperField(this, l.OutputStreamHandlerConfig, 12);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setOutputStreamHandler = function(e2) {
    return t.Message.setWrapperField(this, 12, e2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearOutputStreamHandler = function() {
    return this.setOutputStreamHandler(void 0);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.hasOutputStreamHandler = function() {
    return null != t.Message.getField(this, 12);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getInputStreamInfoList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.InputStreamInfo, 13);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setInputStreamInfoList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 13, e2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.addInputStreamInfo = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 13, e2, proto.mediapipe.InputStreamInfo, r2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearInputStreamInfoList = function() {
    return this.setInputStreamInfoList([]);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getExecutor = function() {
    return t.Message.getFieldWithDefault(this, 14, "");
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setExecutor = function(e2) {
    return t.Message.setProto3StringField(this, 14, e2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getProfilerConfig = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.ProfilerConfig, 15);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setProfilerConfig = function(e2) {
    return t.Message.setWrapperField(this, 15, e2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearProfilerConfig = function() {
    return this.setProfilerConfig(void 0);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.hasProfilerConfig = function() {
    return null != t.Message.getField(this, 15);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getMaxInFlight = function() {
    return t.Message.getFieldWithDefault(this, 16, 0);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setMaxInFlight = function(e2) {
    return t.Message.setProto3IntField(this, 16, e2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getOptionValueList = function() {
    return t.Message.getRepeatedField(this, 17);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setOptionValueList = function(e2) {
    return t.Message.setField(this, 17, e2 || []);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.addOptionValue = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 17, e2, r2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearOptionValueList = function() {
    return this.setOptionValueList([]);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.getExternalInputList = function() {
    return t.Message.getRepeatedField(this, 1005);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.setExternalInputList = function(e2) {
    return t.Message.setField(this, 1005, e2 || []);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.addExternalInput = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 1005, e2, r2);
  }, proto.mediapipe.CalculatorGraphConfig.Node.prototype.clearExternalInputList = function() {
    return this.setExternalInputList([]);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getNodeList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.CalculatorGraphConfig.Node, 1);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setNodeList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.addNode = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.CalculatorGraphConfig.Node, r2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.clearNodeList = function() {
    return this.setNodeList([]);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getPacketFactoryList = function() {
    return t.Message.getRepeatedWrapperField(this, s.PacketFactoryConfig, 6);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setPacketFactoryList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 6, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.addPacketFactory = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 6, e2, proto.mediapipe.PacketFactoryConfig, r2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.clearPacketFactoryList = function() {
    return this.setPacketFactoryList([]);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getPacketGeneratorList = function() {
    return t.Message.getRepeatedWrapperField(this, p.PacketGeneratorConfig, 7);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setPacketGeneratorList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 7, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.addPacketGenerator = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 7, e2, proto.mediapipe.PacketGeneratorConfig, r2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.clearPacketGeneratorList = function() {
    return this.setPacketGeneratorList([]);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getNumThreads = function() {
    return t.Message.getFieldWithDefault(this, 8, 0);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setNumThreads = function(e2) {
    return t.Message.setProto3IntField(this, 8, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getStatusHandlerList = function() {
    return t.Message.getRepeatedWrapperField(this, d.StatusHandlerConfig, 9);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setStatusHandlerList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 9, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.addStatusHandler = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 9, e2, proto.mediapipe.StatusHandlerConfig, r2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.clearStatusHandlerList = function() {
    return this.setStatusHandlerList([]);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getInputStreamList = function() {
    return t.Message.getRepeatedField(this, 10);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setInputStreamList = function(e2) {
    return t.Message.setField(this, 10, e2 || []);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.addInputStream = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 10, e2, r2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.clearInputStreamList = function() {
    return this.setInputStreamList([]);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getOutputStreamList = function() {
    return t.Message.getRepeatedField(this, 15);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setOutputStreamList = function(e2) {
    return t.Message.setField(this, 15, e2 || []);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.addOutputStream = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 15, e2, r2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.clearOutputStreamList = function() {
    return this.setOutputStreamList([]);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getInputSidePacketList = function() {
    return t.Message.getRepeatedField(this, 16);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setInputSidePacketList = function(e2) {
    return t.Message.setField(this, 16, e2 || []);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.addInputSidePacket = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 16, e2, r2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.clearInputSidePacketList = function() {
    return this.setInputSidePacketList([]);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getOutputSidePacketList = function() {
    return t.Message.getRepeatedField(this, 17);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setOutputSidePacketList = function(e2) {
    return t.Message.setField(this, 17, e2 || []);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.addOutputSidePacket = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 17, e2, r2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.clearOutputSidePacketList = function() {
    return this.setOutputSidePacketList([]);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getMaxQueueSize = function() {
    return t.Message.getFieldWithDefault(this, 11, 0);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setMaxQueueSize = function(e2) {
    return t.Message.setProto3IntField(this, 11, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getReportDeadlock = function() {
    return t.Message.getBooleanFieldWithDefault(this, 21, false);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setReportDeadlock = function(e2) {
    return t.Message.setProto3BooleanField(this, 21, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getInputStreamHandler = function() {
    return t.Message.getWrapperField(this, l.InputStreamHandlerConfig, 12);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setInputStreamHandler = function(e2) {
    return t.Message.setWrapperField(this, 12, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.clearInputStreamHandler = function() {
    return this.setInputStreamHandler(void 0);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.hasInputStreamHandler = function() {
    return null != t.Message.getField(this, 12);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getOutputStreamHandler = function() {
    return t.Message.getWrapperField(this, l.OutputStreamHandlerConfig, 13);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setOutputStreamHandler = function(e2) {
    return t.Message.setWrapperField(this, 13, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.clearOutputStreamHandler = function() {
    return this.setOutputStreamHandler(void 0);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.hasOutputStreamHandler = function() {
    return null != t.Message.getField(this, 13);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getExecutorList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.ExecutorConfig, 14);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setExecutorList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 14, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.addExecutor = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 14, e2, proto.mediapipe.ExecutorConfig, r2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.clearExecutorList = function() {
    return this.setExecutorList([]);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getProfilerConfig = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.ProfilerConfig, 18);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setProfilerConfig = function(e2) {
    return t.Message.setWrapperField(this, 18, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.clearProfilerConfig = function() {
    return this.setProfilerConfig(void 0);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.hasProfilerConfig = function() {
    return null != t.Message.getField(this, 18);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getPackage = function() {
    return t.Message.getFieldWithDefault(this, 19, "");
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setPackage = function(e2) {
    return t.Message.setProto3StringField(this, 19, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getType = function() {
    return t.Message.getFieldWithDefault(this, 20, "");
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setType = function(e2) {
    return t.Message.setProto3StringField(this, 20, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getOptions = function() {
    return t.Message.getWrapperField(this, n.MediaPipeOptions, 1001);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setOptions = function(e2) {
    return t.Message.setWrapperField(this, 1001, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.clearOptions = function() {
    return this.setOptions(void 0);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.hasOptions = function() {
    return null != t.Message.getField(this, 1001);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.getGraphOptionsList = function() {
    return t.Message.getRepeatedWrapperField(this, a2.Any, 1002);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.setGraphOptionsList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1002, e2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.addGraphOptions = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1002, e2, proto.google.protobuf.Any, r2);
  }, proto.mediapipe.CalculatorGraphConfig.prototype.clearGraphOptionsList = function() {
    return this.setGraphOptionsList([]);
  }, r.object.extend(e, proto.mediapipe);
})(calculator_pb);
var detection_pb = {};
var location_data_pb = {};
var rasterization_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.Rasterization", null, o), r.exportSymbol("proto.mediapipe.Rasterization.Interval", null, o), proto.mediapipe.Rasterization = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.Rasterization.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.Rasterization, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.Rasterization.displayName = "proto.mediapipe.Rasterization"), proto.mediapipe.Rasterization.Interval = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.Rasterization.Interval, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.Rasterization.Interval.displayName = "proto.mediapipe.Rasterization.Interval"), proto.mediapipe.Rasterization.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.Rasterization.prototype.toObject = function(e2) {
    return proto.mediapipe.Rasterization.toObject(e2, this);
  }, proto.mediapipe.Rasterization.toObject = function(e2, r2) {
    var o2 = { intervalList: t.Message.toObjectList(r2.getIntervalList(), proto.mediapipe.Rasterization.Interval.toObject, e2) };
    return e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.Rasterization.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.Rasterization();
    return proto.mediapipe.Rasterization.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.Rasterization.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new proto.mediapipe.Rasterization.Interval();
        t2.readMessage(r2, proto.mediapipe.Rasterization.Interval.deserializeBinaryFromReader), e2.addInterval(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.Rasterization.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.Rasterization.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.Rasterization.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    (r2 = e2.getIntervalList()).length > 0 && t2.writeRepeatedMessage(1, r2, proto.mediapipe.Rasterization.Interval.serializeBinaryToWriter);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.Rasterization.Interval.prototype.toObject = function(e2) {
    return proto.mediapipe.Rasterization.Interval.toObject(e2, this);
  }, proto.mediapipe.Rasterization.Interval.toObject = function(e2, r2) {
    var o2, i = { y: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, leftX: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, rightX: null == (o2 = t.Message.getField(r2, 3)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.Rasterization.Interval.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.Rasterization.Interval();
    return proto.mediapipe.Rasterization.Interval.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.Rasterization.Interval.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readInt32();
          e2.setY(r2);
          break;
        case 2:
          r2 = t2.readInt32();
          e2.setLeftX(r2);
          break;
        case 3:
          r2 = t2.readInt32();
          e2.setRightX(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.Rasterization.Interval.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.Rasterization.Interval.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.Rasterization.Interval.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeInt32(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeInt32(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeInt32(3, o2);
  }, proto.mediapipe.Rasterization.Interval.prototype.getY = function() {
    return t.Message.getFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.Rasterization.Interval.prototype.setY = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.Rasterization.Interval.prototype.clearY = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.Rasterization.Interval.prototype.hasY = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.Rasterization.Interval.prototype.getLeftX = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.Rasterization.Interval.prototype.setLeftX = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.Rasterization.Interval.prototype.clearLeftX = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.Rasterization.Interval.prototype.hasLeftX = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.Rasterization.Interval.prototype.getRightX = function() {
    return t.Message.getFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.Rasterization.Interval.prototype.setRightX = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.Rasterization.Interval.prototype.clearRightX = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.Rasterization.Interval.prototype.hasRightX = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.Rasterization.prototype.getIntervalList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.Rasterization.Interval, 1);
  }, proto.mediapipe.Rasterization.prototype.setIntervalList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.Rasterization.prototype.addInterval = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.Rasterization.Interval, r2);
  }, proto.mediapipe.Rasterization.prototype.clearIntervalList = function() {
    return this.setIntervalList([]);
  }, r.object.extend(e, proto.mediapipe);
})(rasterization_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = rasterization_pb;
  r.object.extend(proto, i), r.exportSymbol("proto.mediapipe.LocationData", null, o), r.exportSymbol("proto.mediapipe.LocationData.BinaryMask", null, o), r.exportSymbol("proto.mediapipe.LocationData.BoundingBox", null, o), r.exportSymbol("proto.mediapipe.LocationData.Format", null, o), r.exportSymbol("proto.mediapipe.LocationData.RelativeBoundingBox", null, o), r.exportSymbol("proto.mediapipe.LocationData.RelativeKeypoint", null, o), proto.mediapipe.LocationData = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.LocationData.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.LocationData, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.LocationData.displayName = "proto.mediapipe.LocationData"), proto.mediapipe.LocationData.BoundingBox = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.LocationData.BoundingBox, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.LocationData.BoundingBox.displayName = "proto.mediapipe.LocationData.BoundingBox"), proto.mediapipe.LocationData.RelativeBoundingBox = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.LocationData.RelativeBoundingBox, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.LocationData.RelativeBoundingBox.displayName = "proto.mediapipe.LocationData.RelativeBoundingBox"), proto.mediapipe.LocationData.BinaryMask = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.LocationData.BinaryMask, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.LocationData.BinaryMask.displayName = "proto.mediapipe.LocationData.BinaryMask"), proto.mediapipe.LocationData.RelativeKeypoint = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.LocationData.RelativeKeypoint, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.LocationData.RelativeKeypoint.displayName = "proto.mediapipe.LocationData.RelativeKeypoint"), proto.mediapipe.LocationData.repeatedFields_ = [5], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.LocationData.prototype.toObject = function(e2) {
    return proto.mediapipe.LocationData.toObject(e2, this);
  }, proto.mediapipe.LocationData.toObject = function(e2, r2) {
    var o2, i2 = { format: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, boundingBox: (o2 = r2.getBoundingBox()) && proto.mediapipe.LocationData.BoundingBox.toObject(e2, o2), relativeBoundingBox: (o2 = r2.getRelativeBoundingBox()) && proto.mediapipe.LocationData.RelativeBoundingBox.toObject(e2, o2), mask: (o2 = r2.getMask()) && proto.mediapipe.LocationData.BinaryMask.toObject(e2, o2), relativeKeypointsList: t.Message.toObjectList(r2.getRelativeKeypointsList(), proto.mediapipe.LocationData.RelativeKeypoint.toObject, e2) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.LocationData.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.LocationData();
    return proto.mediapipe.LocationData.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.LocationData.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readEnum();
          e2.setFormat(r2);
          break;
        case 2:
          r2 = new proto.mediapipe.LocationData.BoundingBox();
          t2.readMessage(r2, proto.mediapipe.LocationData.BoundingBox.deserializeBinaryFromReader), e2.setBoundingBox(r2);
          break;
        case 3:
          r2 = new proto.mediapipe.LocationData.RelativeBoundingBox();
          t2.readMessage(r2, proto.mediapipe.LocationData.RelativeBoundingBox.deserializeBinaryFromReader), e2.setRelativeBoundingBox(r2);
          break;
        case 4:
          r2 = new proto.mediapipe.LocationData.BinaryMask();
          t2.readMessage(r2, proto.mediapipe.LocationData.BinaryMask.deserializeBinaryFromReader), e2.setMask(r2);
          break;
        case 5:
          r2 = new proto.mediapipe.LocationData.RelativeKeypoint();
          t2.readMessage(r2, proto.mediapipe.LocationData.RelativeKeypoint.deserializeBinaryFromReader), e2.addRelativeKeypoints(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.LocationData.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.LocationData.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.LocationData.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeEnum(1, o2), null != (o2 = e2.getBoundingBox()) && r2.writeMessage(2, o2, proto.mediapipe.LocationData.BoundingBox.serializeBinaryToWriter), null != (o2 = e2.getRelativeBoundingBox()) && r2.writeMessage(3, o2, proto.mediapipe.LocationData.RelativeBoundingBox.serializeBinaryToWriter), null != (o2 = e2.getMask()) && r2.writeMessage(4, o2, proto.mediapipe.LocationData.BinaryMask.serializeBinaryToWriter), (o2 = e2.getRelativeKeypointsList()).length > 0 && r2.writeRepeatedMessage(5, o2, proto.mediapipe.LocationData.RelativeKeypoint.serializeBinaryToWriter);
  }, proto.mediapipe.LocationData.Format = { GLOBAL: 0, BOUNDING_BOX: 1, RELATIVE_BOUNDING_BOX: 2, MASK: 3 }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.LocationData.BoundingBox.prototype.toObject = function(e2) {
    return proto.mediapipe.LocationData.BoundingBox.toObject(e2, this);
  }, proto.mediapipe.LocationData.BoundingBox.toObject = function(e2, r2) {
    var o2, i2 = { xmin: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, ymin: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, width: null == (o2 = t.Message.getField(r2, 3)) ? void 0 : o2, height: null == (o2 = t.Message.getField(r2, 4)) ? void 0 : o2 };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.LocationData.BoundingBox.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.LocationData.BoundingBox();
    return proto.mediapipe.LocationData.BoundingBox.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.LocationData.BoundingBox.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readInt32();
          e2.setXmin(r2);
          break;
        case 2:
          r2 = t2.readInt32();
          e2.setYmin(r2);
          break;
        case 3:
          r2 = t2.readInt32();
          e2.setWidth(r2);
          break;
        case 4:
          r2 = t2.readInt32();
          e2.setHeight(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.LocationData.BoundingBox.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.LocationData.BoundingBox.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.LocationData.BoundingBox.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeInt32(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeInt32(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeInt32(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeInt32(4, o2);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.getXmin = function() {
    return t.Message.getFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.setXmin = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.clearXmin = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.hasXmin = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.getYmin = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.setYmin = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.clearYmin = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.hasYmin = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.getWidth = function() {
    return t.Message.getFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.setWidth = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.clearWidth = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.hasWidth = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.getHeight = function() {
    return t.Message.getFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.setHeight = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.clearHeight = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.LocationData.BoundingBox.prototype.hasHeight = function() {
    return null != t.Message.getField(this, 4);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.LocationData.RelativeBoundingBox.prototype.toObject = function(e2) {
    return proto.mediapipe.LocationData.RelativeBoundingBox.toObject(e2, this);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.toObject = function(e2, r2) {
    var o2, i2 = { xmin: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 1)) ? void 0 : o2, ymin: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 2)) ? void 0 : o2, width: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 3)) ? void 0 : o2, height: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 4)) ? void 0 : o2 };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.LocationData.RelativeBoundingBox.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.LocationData.RelativeBoundingBox();
    return proto.mediapipe.LocationData.RelativeBoundingBox.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readFloat();
          e2.setXmin(r2);
          break;
        case 2:
          r2 = t2.readFloat();
          e2.setYmin(r2);
          break;
        case 3:
          r2 = t2.readFloat();
          e2.setWidth(r2);
          break;
        case 4:
          r2 = t2.readFloat();
          e2.setHeight(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.LocationData.RelativeBoundingBox.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.LocationData.RelativeBoundingBox.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeFloat(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeFloat(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeFloat(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeFloat(4, o2);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.getXmin = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.setXmin = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.clearXmin = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.hasXmin = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.getYmin = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.setYmin = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.clearYmin = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.hasYmin = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.getWidth = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.setWidth = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.clearWidth = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.hasWidth = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.getHeight = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.setHeight = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.clearHeight = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.LocationData.RelativeBoundingBox.prototype.hasHeight = function() {
    return null != t.Message.getField(this, 4);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.LocationData.BinaryMask.prototype.toObject = function(e2) {
    return proto.mediapipe.LocationData.BinaryMask.toObject(e2, this);
  }, proto.mediapipe.LocationData.BinaryMask.toObject = function(e2, r2) {
    var o2, a2 = { width: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, height: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, rasterization: (o2 = r2.getRasterization()) && i.Rasterization.toObject(e2, o2) };
    return e2 && (a2.$jspbMessageInstance = r2), a2;
  }), proto.mediapipe.LocationData.BinaryMask.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.LocationData.BinaryMask();
    return proto.mediapipe.LocationData.BinaryMask.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.LocationData.BinaryMask.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readInt32();
          e2.setWidth(r2);
          break;
        case 2:
          r2 = t2.readInt32();
          e2.setHeight(r2);
          break;
        case 3:
          r2 = new i.Rasterization();
          t2.readMessage(r2, i.Rasterization.deserializeBinaryFromReader), e2.setRasterization(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.LocationData.BinaryMask.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.LocationData.BinaryMask.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.LocationData.BinaryMask.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeInt32(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeInt32(2, o2), null != (o2 = e2.getRasterization()) && r2.writeMessage(3, o2, i.Rasterization.serializeBinaryToWriter);
  }, proto.mediapipe.LocationData.BinaryMask.prototype.getWidth = function() {
    return t.Message.getFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.LocationData.BinaryMask.prototype.setWidth = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.LocationData.BinaryMask.prototype.clearWidth = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.LocationData.BinaryMask.prototype.hasWidth = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.LocationData.BinaryMask.prototype.getHeight = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.LocationData.BinaryMask.prototype.setHeight = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.LocationData.BinaryMask.prototype.clearHeight = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.LocationData.BinaryMask.prototype.hasHeight = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.LocationData.BinaryMask.prototype.getRasterization = function() {
    return t.Message.getWrapperField(this, i.Rasterization, 3);
  }, proto.mediapipe.LocationData.BinaryMask.prototype.setRasterization = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.LocationData.BinaryMask.prototype.clearRasterization = function() {
    return this.setRasterization(void 0);
  }, proto.mediapipe.LocationData.BinaryMask.prototype.hasRasterization = function() {
    return null != t.Message.getField(this, 3);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.LocationData.RelativeKeypoint.prototype.toObject = function(e2) {
    return proto.mediapipe.LocationData.RelativeKeypoint.toObject(e2, this);
  }, proto.mediapipe.LocationData.RelativeKeypoint.toObject = function(e2, r2) {
    var o2, i2 = { x: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 1)) ? void 0 : o2, y: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 2)) ? void 0 : o2, keypointLabel: null == (o2 = t.Message.getField(r2, 3)) ? void 0 : o2, score: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 4)) ? void 0 : o2 };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.LocationData.RelativeKeypoint.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.LocationData.RelativeKeypoint();
    return proto.mediapipe.LocationData.RelativeKeypoint.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.LocationData.RelativeKeypoint.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readFloat();
          e2.setX(r2);
          break;
        case 2:
          r2 = t2.readFloat();
          e2.setY(r2);
          break;
        case 3:
          r2 = t2.readString();
          e2.setKeypointLabel(r2);
          break;
        case 4:
          r2 = t2.readFloat();
          e2.setScore(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.LocationData.RelativeKeypoint.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.LocationData.RelativeKeypoint.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeFloat(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeFloat(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeString(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeFloat(4, o2);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.getX = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.setX = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.clearX = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.hasX = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.getY = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.setY = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.clearY = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.hasY = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.getKeypointLabel = function() {
    return t.Message.getFieldWithDefault(this, 3, "");
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.setKeypointLabel = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.clearKeypointLabel = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.hasKeypointLabel = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.getScore = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.setScore = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.clearScore = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.LocationData.RelativeKeypoint.prototype.hasScore = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.LocationData.prototype.getFormat = function() {
    return t.Message.getFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.LocationData.prototype.setFormat = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.LocationData.prototype.clearFormat = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.LocationData.prototype.hasFormat = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.LocationData.prototype.getBoundingBox = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.LocationData.BoundingBox, 2);
  }, proto.mediapipe.LocationData.prototype.setBoundingBox = function(e2) {
    return t.Message.setWrapperField(this, 2, e2);
  }, proto.mediapipe.LocationData.prototype.clearBoundingBox = function() {
    return this.setBoundingBox(void 0);
  }, proto.mediapipe.LocationData.prototype.hasBoundingBox = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.LocationData.prototype.getRelativeBoundingBox = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.LocationData.RelativeBoundingBox, 3);
  }, proto.mediapipe.LocationData.prototype.setRelativeBoundingBox = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.LocationData.prototype.clearRelativeBoundingBox = function() {
    return this.setRelativeBoundingBox(void 0);
  }, proto.mediapipe.LocationData.prototype.hasRelativeBoundingBox = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.LocationData.prototype.getMask = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.LocationData.BinaryMask, 4);
  }, proto.mediapipe.LocationData.prototype.setMask = function(e2) {
    return t.Message.setWrapperField(this, 4, e2);
  }, proto.mediapipe.LocationData.prototype.clearMask = function() {
    return this.setMask(void 0);
  }, proto.mediapipe.LocationData.prototype.hasMask = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.LocationData.prototype.getRelativeKeypointsList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.LocationData.RelativeKeypoint, 5);
  }, proto.mediapipe.LocationData.prototype.setRelativeKeypointsList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 5, e2);
  }, proto.mediapipe.LocationData.prototype.addRelativeKeypoints = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 5, e2, proto.mediapipe.LocationData.RelativeKeypoint, r2);
  }, proto.mediapipe.LocationData.prototype.clearRelativeKeypointsList = function() {
    return this.setRelativeKeypointsList([]);
  }, r.object.extend(e, proto.mediapipe);
})(location_data_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = location_data_pb;
  r.object.extend(proto, i), r.exportSymbol("proto.mediapipe.Detection", null, o), r.exportSymbol("proto.mediapipe.Detection.AssociatedDetection", null, o), r.exportSymbol("proto.mediapipe.DetectionList", null, o), proto.mediapipe.Detection = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.Detection.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.Detection, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.Detection.displayName = "proto.mediapipe.Detection"), proto.mediapipe.Detection.AssociatedDetection = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.Detection.AssociatedDetection, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.Detection.AssociatedDetection.displayName = "proto.mediapipe.Detection.AssociatedDetection"), proto.mediapipe.DetectionList = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.DetectionList.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.DetectionList, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.DetectionList.displayName = "proto.mediapipe.DetectionList"), proto.mediapipe.Detection.repeatedFields_ = [1, 2, 3, 8, 9], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.Detection.prototype.toObject = function(e2) {
    return proto.mediapipe.Detection.toObject(e2, this);
  }, proto.mediapipe.Detection.toObject = function(e2, r2) {
    var o2, a2 = { labelList: null == (o2 = t.Message.getRepeatedField(r2, 1)) ? void 0 : o2, labelIdList: null == (o2 = t.Message.getRepeatedField(r2, 2)) ? void 0 : o2, scoreList: null == (o2 = t.Message.getRepeatedFloatingPointField(r2, 3)) ? void 0 : o2, locationData: (o2 = r2.getLocationData()) && i.LocationData.toObject(e2, o2), featureTag: null == (o2 = t.Message.getField(r2, 5)) ? void 0 : o2, trackId: null == (o2 = t.Message.getField(r2, 6)) ? void 0 : o2, detectionId: null == (o2 = t.Message.getField(r2, 7)) ? void 0 : o2, associatedDetectionsList: t.Message.toObjectList(r2.getAssociatedDetectionsList(), proto.mediapipe.Detection.AssociatedDetection.toObject, e2), displayNameList: null == (o2 = t.Message.getRepeatedField(r2, 9)) ? void 0 : o2, timestampUsec: null == (o2 = t.Message.getField(r2, 10)) ? void 0 : o2 };
    return e2 && (a2.$jspbMessageInstance = r2), a2;
  }), proto.mediapipe.Detection.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.Detection();
    return proto.mediapipe.Detection.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.Detection.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.addLabel(r2);
          break;
        case 2:
          for (var o2 = t2.isDelimited() ? t2.readPackedInt32() : [t2.readInt32()], a2 = 0; a2 < o2.length; a2++) e2.addLabelId(o2[a2]);
          break;
        case 3:
          for (o2 = t2.isDelimited() ? t2.readPackedFloat() : [t2.readFloat()], a2 = 0; a2 < o2.length; a2++) e2.addScore(o2[a2]);
          break;
        case 4:
          r2 = new i.LocationData();
          t2.readMessage(r2, i.LocationData.deserializeBinaryFromReader), e2.setLocationData(r2);
          break;
        case 5:
          r2 = t2.readString();
          e2.setFeatureTag(r2);
          break;
        case 6:
          r2 = t2.readString();
          e2.setTrackId(r2);
          break;
        case 7:
          r2 = t2.readInt64();
          e2.setDetectionId(r2);
          break;
        case 8:
          r2 = new proto.mediapipe.Detection.AssociatedDetection();
          t2.readMessage(r2, proto.mediapipe.Detection.AssociatedDetection.deserializeBinaryFromReader), e2.addAssociatedDetections(r2);
          break;
        case 9:
          r2 = t2.readString();
          e2.addDisplayName(r2);
          break;
        case 10:
          r2 = t2.readInt64();
          e2.setTimestampUsec(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.Detection.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.Detection.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.Detection.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    (o2 = e2.getLabelList()).length > 0 && r2.writeRepeatedString(1, o2), (o2 = e2.getLabelIdList()).length > 0 && r2.writePackedInt32(2, o2), (o2 = e2.getScoreList()).length > 0 && r2.writePackedFloat(3, o2), null != (o2 = e2.getLocationData()) && r2.writeMessage(4, o2, i.LocationData.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 5)) && r2.writeString(5, o2), null != (o2 = t.Message.getField(e2, 6)) && r2.writeString(6, o2), null != (o2 = t.Message.getField(e2, 7)) && r2.writeInt64(7, o2), (o2 = e2.getAssociatedDetectionsList()).length > 0 && r2.writeRepeatedMessage(8, o2, proto.mediapipe.Detection.AssociatedDetection.serializeBinaryToWriter), (o2 = e2.getDisplayNameList()).length > 0 && r2.writeRepeatedString(9, o2), null != (o2 = t.Message.getField(e2, 10)) && r2.writeInt64(10, o2);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.Detection.AssociatedDetection.prototype.toObject = function(e2) {
    return proto.mediapipe.Detection.AssociatedDetection.toObject(e2, this);
  }, proto.mediapipe.Detection.AssociatedDetection.toObject = function(e2, r2) {
    var o2, i2 = { id: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, confidence: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 2)) ? void 0 : o2 };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.Detection.AssociatedDetection.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.Detection.AssociatedDetection();
    return proto.mediapipe.Detection.AssociatedDetection.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.Detection.AssociatedDetection.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readInt32();
          e2.setId(r2);
          break;
        case 2:
          r2 = t2.readFloat();
          e2.setConfidence(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.Detection.AssociatedDetection.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.Detection.AssociatedDetection.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.Detection.AssociatedDetection.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeInt32(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeFloat(2, o2);
  }, proto.mediapipe.Detection.AssociatedDetection.prototype.getId = function() {
    return t.Message.getFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.Detection.AssociatedDetection.prototype.setId = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.Detection.AssociatedDetection.prototype.clearId = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.Detection.AssociatedDetection.prototype.hasId = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.Detection.AssociatedDetection.prototype.getConfidence = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.Detection.AssociatedDetection.prototype.setConfidence = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.Detection.AssociatedDetection.prototype.clearConfidence = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.Detection.AssociatedDetection.prototype.hasConfidence = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.Detection.prototype.getLabelList = function() {
    return t.Message.getRepeatedField(this, 1);
  }, proto.mediapipe.Detection.prototype.setLabelList = function(e2) {
    return t.Message.setField(this, 1, e2 || []);
  }, proto.mediapipe.Detection.prototype.addLabel = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 1, e2, r2);
  }, proto.mediapipe.Detection.prototype.clearLabelList = function() {
    return this.setLabelList([]);
  }, proto.mediapipe.Detection.prototype.getLabelIdList = function() {
    return t.Message.getRepeatedField(this, 2);
  }, proto.mediapipe.Detection.prototype.setLabelIdList = function(e2) {
    return t.Message.setField(this, 2, e2 || []);
  }, proto.mediapipe.Detection.prototype.addLabelId = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 2, e2, r2);
  }, proto.mediapipe.Detection.prototype.clearLabelIdList = function() {
    return this.setLabelIdList([]);
  }, proto.mediapipe.Detection.prototype.getScoreList = function() {
    return t.Message.getRepeatedFloatingPointField(this, 3);
  }, proto.mediapipe.Detection.prototype.setScoreList = function(e2) {
    return t.Message.setField(this, 3, e2 || []);
  }, proto.mediapipe.Detection.prototype.addScore = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 3, e2, r2);
  }, proto.mediapipe.Detection.prototype.clearScoreList = function() {
    return this.setScoreList([]);
  }, proto.mediapipe.Detection.prototype.getLocationData = function() {
    return t.Message.getWrapperField(this, i.LocationData, 4);
  }, proto.mediapipe.Detection.prototype.setLocationData = function(e2) {
    return t.Message.setWrapperField(this, 4, e2);
  }, proto.mediapipe.Detection.prototype.clearLocationData = function() {
    return this.setLocationData(void 0);
  }, proto.mediapipe.Detection.prototype.hasLocationData = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.Detection.prototype.getFeatureTag = function() {
    return t.Message.getFieldWithDefault(this, 5, "");
  }, proto.mediapipe.Detection.prototype.setFeatureTag = function(e2) {
    return t.Message.setField(this, 5, e2);
  }, proto.mediapipe.Detection.prototype.clearFeatureTag = function() {
    return t.Message.setField(this, 5, void 0);
  }, proto.mediapipe.Detection.prototype.hasFeatureTag = function() {
    return null != t.Message.getField(this, 5);
  }, proto.mediapipe.Detection.prototype.getTrackId = function() {
    return t.Message.getFieldWithDefault(this, 6, "");
  }, proto.mediapipe.Detection.prototype.setTrackId = function(e2) {
    return t.Message.setField(this, 6, e2);
  }, proto.mediapipe.Detection.prototype.clearTrackId = function() {
    return t.Message.setField(this, 6, void 0);
  }, proto.mediapipe.Detection.prototype.hasTrackId = function() {
    return null != t.Message.getField(this, 6);
  }, proto.mediapipe.Detection.prototype.getDetectionId = function() {
    return t.Message.getFieldWithDefault(this, 7, 0);
  }, proto.mediapipe.Detection.prototype.setDetectionId = function(e2) {
    return t.Message.setField(this, 7, e2);
  }, proto.mediapipe.Detection.prototype.clearDetectionId = function() {
    return t.Message.setField(this, 7, void 0);
  }, proto.mediapipe.Detection.prototype.hasDetectionId = function() {
    return null != t.Message.getField(this, 7);
  }, proto.mediapipe.Detection.prototype.getAssociatedDetectionsList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.Detection.AssociatedDetection, 8);
  }, proto.mediapipe.Detection.prototype.setAssociatedDetectionsList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 8, e2);
  }, proto.mediapipe.Detection.prototype.addAssociatedDetections = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 8, e2, proto.mediapipe.Detection.AssociatedDetection, r2);
  }, proto.mediapipe.Detection.prototype.clearAssociatedDetectionsList = function() {
    return this.setAssociatedDetectionsList([]);
  }, proto.mediapipe.Detection.prototype.getDisplayNameList = function() {
    return t.Message.getRepeatedField(this, 9);
  }, proto.mediapipe.Detection.prototype.setDisplayNameList = function(e2) {
    return t.Message.setField(this, 9, e2 || []);
  }, proto.mediapipe.Detection.prototype.addDisplayName = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 9, e2, r2);
  }, proto.mediapipe.Detection.prototype.clearDisplayNameList = function() {
    return this.setDisplayNameList([]);
  }, proto.mediapipe.Detection.prototype.getTimestampUsec = function() {
    return t.Message.getFieldWithDefault(this, 10, 0);
  }, proto.mediapipe.Detection.prototype.setTimestampUsec = function(e2) {
    return t.Message.setField(this, 10, e2);
  }, proto.mediapipe.Detection.prototype.clearTimestampUsec = function() {
    return t.Message.setField(this, 10, void 0);
  }, proto.mediapipe.Detection.prototype.hasTimestampUsec = function() {
    return null != t.Message.getField(this, 10);
  }, proto.mediapipe.DetectionList.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.DetectionList.prototype.toObject = function(e2) {
    return proto.mediapipe.DetectionList.toObject(e2, this);
  }, proto.mediapipe.DetectionList.toObject = function(e2, r2) {
    var o2 = { detectionList: t.Message.toObjectList(r2.getDetectionList(), proto.mediapipe.Detection.toObject, e2) };
    return e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.DetectionList.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.DetectionList();
    return proto.mediapipe.DetectionList.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.DetectionList.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new proto.mediapipe.Detection();
        t2.readMessage(r2, proto.mediapipe.Detection.deserializeBinaryFromReader), e2.addDetection(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.DetectionList.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.DetectionList.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.DetectionList.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    (r2 = e2.getDetectionList()).length > 0 && t2.writeRepeatedMessage(1, r2, proto.mediapipe.Detection.serializeBinaryToWriter);
  }, proto.mediapipe.DetectionList.prototype.getDetectionList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.Detection, 1);
  }, proto.mediapipe.DetectionList.prototype.setDetectionList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.DetectionList.prototype.addDetection = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.Detection, r2);
  }, proto.mediapipe.DetectionList.prototype.clearDetectionList = function() {
    return this.setDetectionList([]);
  }, r.object.extend(e, proto.mediapipe);
})(detection_pb);
var base_options_pb = {};
var acceleration_pb = {};
var inference_calculator_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2), r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions", null, o), r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate", null, o), r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate.DelegateCase", null, o), r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu", null, o), r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.Api", null, o), r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.InferenceUsage", null, o), r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi", null, o), r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite", null, o), r.exportSymbol("proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack", null, o), proto.mediapipe.InferenceCalculatorOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.InferenceCalculatorOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.InferenceCalculatorOptions.displayName = "proto.mediapipe.InferenceCalculatorOptions"), proto.mediapipe.InferenceCalculatorOptions.Delegate = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, proto.mediapipe.InferenceCalculatorOptions.Delegate.oneofGroups_);
  }, r.inherits(proto.mediapipe.InferenceCalculatorOptions.Delegate, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.InferenceCalculatorOptions.Delegate.displayName = "proto.mediapipe.InferenceCalculatorOptions.Delegate"), proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.displayName = "proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite"), proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.displayName = "proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu"), proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.displayName = "proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi"), proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.displayName = "proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.InferenceCalculatorOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.InferenceCalculatorOptions.toObject(e2, this);
  }, proto.mediapipe.InferenceCalculatorOptions.toObject = function(e2, r2) {
    var o2, i2 = { modelPath: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, useGpu: t.Message.getBooleanFieldWithDefault(r2, 2, false), useNnapi: t.Message.getBooleanFieldWithDefault(r2, 3, false), cpuNumThread: t.Message.getFieldWithDefault(r2, 4, -1), delegate: (o2 = r2.getDelegate()) && proto.mediapipe.InferenceCalculatorOptions.Delegate.toObject(e2, o2) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.InferenceCalculatorOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.InferenceCalculatorOptions();
    return proto.mediapipe.InferenceCalculatorOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.InferenceCalculatorOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setModelPath(r2);
          break;
        case 2:
          r2 = t2.readBool();
          e2.setUseGpu(r2);
          break;
        case 3:
          r2 = t2.readBool();
          e2.setUseNnapi(r2);
          break;
        case 4:
          r2 = t2.readInt32();
          e2.setCpuNumThread(r2);
          break;
        case 5:
          r2 = new proto.mediapipe.InferenceCalculatorOptions.Delegate();
          t2.readMessage(r2, proto.mediapipe.InferenceCalculatorOptions.Delegate.deserializeBinaryFromReader), e2.setDelegate(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.InferenceCalculatorOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.InferenceCalculatorOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeString(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeBool(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeBool(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeInt32(4, o2), null != (o2 = e2.getDelegate()) && r2.writeMessage(5, o2, proto.mediapipe.InferenceCalculatorOptions.Delegate.serializeBinaryToWriter);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.oneofGroups_ = [[1, 2, 3, 4]], proto.mediapipe.InferenceCalculatorOptions.Delegate.DelegateCase = { DELEGATE_NOT_SET: 0, TFLITE: 1, GPU: 2, NNAPI: 3, XNNPACK: 4 }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.getDelegateCase = function() {
    return t.Message.computeOneofCase(this, proto.mediapipe.InferenceCalculatorOptions.Delegate.oneofGroups_[0]);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.toObject = function(e2) {
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.toObject(e2, this);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.toObject = function(e2, t2) {
    var r2, o2 = { tflite: (r2 = t2.getTflite()) && proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.toObject(e2, r2), gpu: (r2 = t2.getGpu()) && proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.toObject(e2, r2), nnapi: (r2 = t2.getNnapi()) && proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.toObject(e2, r2), xnnpack: (r2 = t2.getXnnpack()) && proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.InferenceCalculatorOptions.Delegate.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.InferenceCalculatorOptions.Delegate();
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite();
          t2.readMessage(r2, proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.deserializeBinaryFromReader), e2.setTflite(r2);
          break;
        case 2:
          r2 = new proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu();
          t2.readMessage(r2, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.deserializeBinaryFromReader), e2.setGpu(r2);
          break;
        case 3:
          r2 = new proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi();
          t2.readMessage(r2, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.deserializeBinaryFromReader), e2.setNnapi(r2);
          break;
        case 4:
          r2 = new proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack();
          t2.readMessage(r2, proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.deserializeBinaryFromReader), e2.setXnnpack(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    null != (r2 = e2.getTflite()) && t2.writeMessage(1, r2, proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.serializeBinaryToWriter), null != (r2 = e2.getGpu()) && t2.writeMessage(2, r2, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.serializeBinaryToWriter), null != (r2 = e2.getNnapi()) && t2.writeMessage(3, r2, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.serializeBinaryToWriter), null != (r2 = e2.getXnnpack()) && t2.writeMessage(4, r2, proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.serializeBinaryToWriter);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.prototype.toObject = function(e2) {
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.toObject(e2, this);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.toObject = function(e2, t2) {
    var r2 = {};
    return e2 && (r2.$jspbMessageInstance = t2), r2;
  }), proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite();
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      t2.getFieldNumber();
      t2.skipField();
    }
    return e2;
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite.serializeBinaryToWriter = function(e2, t2) {
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.toObject = function(e2) {
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.toObject(e2, this);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.toObject = function(e2, r2) {
    var o2, i2 = { useAdvancedGpuApi: t.Message.getBooleanFieldWithDefault(r2, 1, false), api: t.Message.getFieldWithDefault(r2, 4, 0), allowPrecisionLoss: t.Message.getBooleanFieldWithDefault(r2, 3, true), cachedKernelPath: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, serializedModelDir: null == (o2 = t.Message.getField(r2, 7)) ? void 0 : o2, modelToken: null == (o2 = t.Message.getField(r2, 8)) ? void 0 : o2, usage: t.Message.getFieldWithDefault(r2, 5, 2) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu();
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readBool();
          e2.setUseAdvancedGpuApi(r2);
          break;
        case 4:
          r2 = t2.readEnum();
          e2.setApi(r2);
          break;
        case 3:
          r2 = t2.readBool();
          e2.setAllowPrecisionLoss(r2);
          break;
        case 2:
          r2 = t2.readString();
          e2.setCachedKernelPath(r2);
          break;
        case 7:
          r2 = t2.readString();
          e2.setSerializedModelDir(r2);
          break;
        case 8:
          r2 = t2.readString();
          e2.setModelToken(r2);
          break;
        case 5:
          r2 = t2.readEnum();
          e2.setUsage(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeBool(1, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeEnum(4, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeBool(3, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeString(2, o2), null != (o2 = t.Message.getField(e2, 7)) && r2.writeString(7, o2), null != (o2 = t.Message.getField(e2, 8)) && r2.writeString(8, o2), null != (o2 = t.Message.getField(e2, 5)) && r2.writeEnum(5, o2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.Api = { ANY: 0, OPENGL: 1, OPENCL: 2 }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.InferenceUsage = { UNSPECIFIED: 0, FAST_SINGLE_ANSWER: 1, SUSTAINED_SPEED: 2 }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.getUseAdvancedGpuApi = function() {
    return t.Message.getBooleanFieldWithDefault(this, 1, false);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.setUseAdvancedGpuApi = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.clearUseAdvancedGpuApi = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.hasUseAdvancedGpuApi = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.getApi = function() {
    return t.Message.getFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.setApi = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.clearApi = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.hasApi = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.getAllowPrecisionLoss = function() {
    return t.Message.getBooleanFieldWithDefault(this, 3, true);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.setAllowPrecisionLoss = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.clearAllowPrecisionLoss = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.hasAllowPrecisionLoss = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.getCachedKernelPath = function() {
    return t.Message.getFieldWithDefault(this, 2, "");
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.setCachedKernelPath = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.clearCachedKernelPath = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.hasCachedKernelPath = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.getSerializedModelDir = function() {
    return t.Message.getFieldWithDefault(this, 7, "");
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.setSerializedModelDir = function(e2) {
    return t.Message.setField(this, 7, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.clearSerializedModelDir = function() {
    return t.Message.setField(this, 7, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.hasSerializedModelDir = function() {
    return null != t.Message.getField(this, 7);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.getModelToken = function() {
    return t.Message.getFieldWithDefault(this, 8, "");
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.setModelToken = function(e2) {
    return t.Message.setField(this, 8, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.clearModelToken = function() {
    return t.Message.setField(this, 8, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.hasModelToken = function() {
    return null != t.Message.getField(this, 8);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.getUsage = function() {
    return t.Message.getFieldWithDefault(this, 5, 2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.setUsage = function(e2) {
    return t.Message.setField(this, 5, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.clearUsage = function() {
    return t.Message.setField(this, 5, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu.prototype.hasUsage = function() {
    return null != t.Message.getField(this, 5);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.toObject = function(e2) {
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.toObject(e2, this);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.toObject = function(e2, r2) {
    var o2, i2 = { cacheDir: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, modelToken: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, acceleratorName: null == (o2 = t.Message.getField(r2, 3)) ? void 0 : o2 };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi();
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setCacheDir(r2);
          break;
        case 2:
          r2 = t2.readString();
          e2.setModelToken(r2);
          break;
        case 3:
          r2 = t2.readString();
          e2.setAcceleratorName(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeString(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeString(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeString(3, o2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.getCacheDir = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.setCacheDir = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.clearCacheDir = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.hasCacheDir = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.getModelToken = function() {
    return t.Message.getFieldWithDefault(this, 2, "");
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.setModelToken = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.clearModelToken = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.hasModelToken = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.getAcceleratorName = function() {
    return t.Message.getFieldWithDefault(this, 3, "");
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.setAcceleratorName = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.clearAcceleratorName = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi.prototype.hasAcceleratorName = function() {
    return null != t.Message.getField(this, 3);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.prototype.toObject = function(e2) {
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.toObject(e2, this);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.toObject = function(e2, r2) {
    var o2 = { numThreads: t.Message.getFieldWithDefault(r2, 1, -1) };
    return e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack();
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = t2.readInt32();
        e2.setNumThreads(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.serializeBinaryToWriter = function(e2, r2) {
    var o2;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeInt32(1, o2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.prototype.getNumThreads = function() {
    return t.Message.getFieldWithDefault(this, 1, -1);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.prototype.setNumThreads = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.prototype.clearNumThreads = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack.prototype.hasNumThreads = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.getTflite = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.InferenceCalculatorOptions.Delegate.TfLite, 1);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.setTflite = function(e2) {
    return t.Message.setOneofWrapperField(this, 1, proto.mediapipe.InferenceCalculatorOptions.Delegate.oneofGroups_[0], e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.clearTflite = function() {
    return this.setTflite(void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.hasTflite = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.getGpu = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.InferenceCalculatorOptions.Delegate.Gpu, 2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.setGpu = function(e2) {
    return t.Message.setOneofWrapperField(this, 2, proto.mediapipe.InferenceCalculatorOptions.Delegate.oneofGroups_[0], e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.clearGpu = function() {
    return this.setGpu(void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.hasGpu = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.getNnapi = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.InferenceCalculatorOptions.Delegate.Nnapi, 3);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.setNnapi = function(e2) {
    return t.Message.setOneofWrapperField(this, 3, proto.mediapipe.InferenceCalculatorOptions.Delegate.oneofGroups_[0], e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.clearNnapi = function() {
    return this.setNnapi(void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.hasNnapi = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.getXnnpack = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.InferenceCalculatorOptions.Delegate.Xnnpack, 4);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.setXnnpack = function(e2) {
    return t.Message.setOneofWrapperField(this, 4, proto.mediapipe.InferenceCalculatorOptions.Delegate.oneofGroups_[0], e2);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.clearXnnpack = function() {
    return this.setXnnpack(void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.Delegate.prototype.hasXnnpack = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.InferenceCalculatorOptions.ext = new t.ExtensionFieldInfo(336783863, { ext: 0 }, proto.mediapipe.InferenceCalculatorOptions, proto.mediapipe.InferenceCalculatorOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[336783863] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.InferenceCalculatorOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.InferenceCalculatorOptions.serializeBinaryToWriter, proto.mediapipe.InferenceCalculatorOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[336783863] = proto.mediapipe.InferenceCalculatorOptions.ext, proto.mediapipe.InferenceCalculatorOptions.prototype.getModelPath = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.setModelPath = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.clearModelPath = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.hasModelPath = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.getUseGpu = function() {
    return t.Message.getBooleanFieldWithDefault(this, 2, false);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.setUseGpu = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.clearUseGpu = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.hasUseGpu = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.getUseNnapi = function() {
    return t.Message.getBooleanFieldWithDefault(this, 3, false);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.setUseNnapi = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.clearUseNnapi = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.hasUseNnapi = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.getCpuNumThread = function() {
    return t.Message.getFieldWithDefault(this, 4, -1);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.setCpuNumThread = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.clearCpuNumThread = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.hasCpuNumThread = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.getDelegate = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.InferenceCalculatorOptions.Delegate, 5);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.setDelegate = function(e2) {
    return t.Message.setWrapperField(this, 5, e2);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.clearDelegate = function() {
    return this.setDelegate(void 0);
  }, proto.mediapipe.InferenceCalculatorOptions.prototype.hasDelegate = function() {
    return null != t.Message.getField(this, 5);
  }, proto.mediapipe.InferenceCalculatorOptions.ext = new t.ExtensionFieldInfo(336783863, { ext: 0 }, proto.mediapipe.InferenceCalculatorOptions, proto.mediapipe.InferenceCalculatorOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[336783863] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.InferenceCalculatorOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.InferenceCalculatorOptions.serializeBinaryToWriter, proto.mediapipe.InferenceCalculatorOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[336783863] = proto.mediapipe.InferenceCalculatorOptions.ext, r.object.extend(e, proto.mediapipe);
})(inference_calculator_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = inference_calculator_pb;
  r.object.extend(proto, i), r.exportSymbol("proto.mediapipe.tasks.core.proto.Acceleration", null, o), r.exportSymbol("proto.mediapipe.tasks.core.proto.Acceleration.DelegateCase", null, o), proto.mediapipe.tasks.core.proto.Acceleration = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, proto.mediapipe.tasks.core.proto.Acceleration.oneofGroups_);
  }, r.inherits(proto.mediapipe.tasks.core.proto.Acceleration, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.core.proto.Acceleration.displayName = "proto.mediapipe.tasks.core.proto.Acceleration"), proto.mediapipe.tasks.core.proto.Acceleration.oneofGroups_ = [[1, 2, 4, 5]], proto.mediapipe.tasks.core.proto.Acceleration.DelegateCase = { DELEGATE_NOT_SET: 0, XNNPACK: 1, GPU: 2, TFLITE: 4, NNAPI: 5 }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.getDelegateCase = function() {
    return t.Message.computeOneofCase(this, proto.mediapipe.tasks.core.proto.Acceleration.oneofGroups_[0]);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.core.proto.Acceleration.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.core.proto.Acceleration.toObject(e2, this);
  }, proto.mediapipe.tasks.core.proto.Acceleration.toObject = function(e2, t2) {
    var r2, o2 = { xnnpack: (r2 = t2.getXnnpack()) && i.InferenceCalculatorOptions.Delegate.Xnnpack.toObject(e2, r2), gpu: (r2 = t2.getGpu()) && i.InferenceCalculatorOptions.Delegate.Gpu.toObject(e2, r2), tflite: (r2 = t2.getTflite()) && i.InferenceCalculatorOptions.Delegate.TfLite.toObject(e2, r2), nnapi: (r2 = t2.getNnapi()) && i.InferenceCalculatorOptions.Delegate.Nnapi.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.tasks.core.proto.Acceleration.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.core.proto.Acceleration();
    return proto.mediapipe.tasks.core.proto.Acceleration.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.core.proto.Acceleration.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new i.InferenceCalculatorOptions.Delegate.Xnnpack();
          t2.readMessage(r2, i.InferenceCalculatorOptions.Delegate.Xnnpack.deserializeBinaryFromReader), e2.setXnnpack(r2);
          break;
        case 2:
          r2 = new i.InferenceCalculatorOptions.Delegate.Gpu();
          t2.readMessage(r2, i.InferenceCalculatorOptions.Delegate.Gpu.deserializeBinaryFromReader), e2.setGpu(r2);
          break;
        case 4:
          r2 = new i.InferenceCalculatorOptions.Delegate.TfLite();
          t2.readMessage(r2, i.InferenceCalculatorOptions.Delegate.TfLite.deserializeBinaryFromReader), e2.setTflite(r2);
          break;
        case 5:
          r2 = new i.InferenceCalculatorOptions.Delegate.Nnapi();
          t2.readMessage(r2, i.InferenceCalculatorOptions.Delegate.Nnapi.deserializeBinaryFromReader), e2.setNnapi(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.core.proto.Acceleration.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.core.proto.Acceleration.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    null != (r2 = e2.getXnnpack()) && t2.writeMessage(1, r2, i.InferenceCalculatorOptions.Delegate.Xnnpack.serializeBinaryToWriter), null != (r2 = e2.getGpu()) && t2.writeMessage(2, r2, i.InferenceCalculatorOptions.Delegate.Gpu.serializeBinaryToWriter), null != (r2 = e2.getTflite()) && t2.writeMessage(4, r2, i.InferenceCalculatorOptions.Delegate.TfLite.serializeBinaryToWriter), null != (r2 = e2.getNnapi()) && t2.writeMessage(5, r2, i.InferenceCalculatorOptions.Delegate.Nnapi.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.getXnnpack = function() {
    return t.Message.getWrapperField(this, i.InferenceCalculatorOptions.Delegate.Xnnpack, 1);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.setXnnpack = function(e2) {
    return t.Message.setOneofWrapperField(this, 1, proto.mediapipe.tasks.core.proto.Acceleration.oneofGroups_[0], e2);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.clearXnnpack = function() {
    return this.setXnnpack(void 0);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.hasXnnpack = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.getGpu = function() {
    return t.Message.getWrapperField(this, i.InferenceCalculatorOptions.Delegate.Gpu, 2);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.setGpu = function(e2) {
    return t.Message.setOneofWrapperField(this, 2, proto.mediapipe.tasks.core.proto.Acceleration.oneofGroups_[0], e2);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.clearGpu = function() {
    return this.setGpu(void 0);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.hasGpu = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.getTflite = function() {
    return t.Message.getWrapperField(this, i.InferenceCalculatorOptions.Delegate.TfLite, 4);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.setTflite = function(e2) {
    return t.Message.setOneofWrapperField(this, 4, proto.mediapipe.tasks.core.proto.Acceleration.oneofGroups_[0], e2);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.clearTflite = function() {
    return this.setTflite(void 0);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.hasTflite = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.getNnapi = function() {
    return t.Message.getWrapperField(this, i.InferenceCalculatorOptions.Delegate.Nnapi, 5);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.setNnapi = function(e2) {
    return t.Message.setOneofWrapperField(this, 5, proto.mediapipe.tasks.core.proto.Acceleration.oneofGroups_[0], e2);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.clearNnapi = function() {
    return this.setNnapi(void 0);
  }, proto.mediapipe.tasks.core.proto.Acceleration.prototype.hasNnapi = function() {
    return null != t.Message.getField(this, 5);
  }, r.object.extend(e, proto.mediapipe.tasks.core.proto);
})(acceleration_pb);
var external_file_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.tasks.core.proto.ExternalFile", null, o), r.exportSymbol("proto.mediapipe.tasks.core.proto.FileDescriptorMeta", null, o), r.exportSymbol("proto.mediapipe.tasks.core.proto.FilePointerMeta", null, o), proto.mediapipe.tasks.core.proto.ExternalFile = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.core.proto.ExternalFile, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.core.proto.ExternalFile.displayName = "proto.mediapipe.tasks.core.proto.ExternalFile"), proto.mediapipe.tasks.core.proto.FileDescriptorMeta = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.core.proto.FileDescriptorMeta, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.core.proto.FileDescriptorMeta.displayName = "proto.mediapipe.tasks.core.proto.FileDescriptorMeta"), proto.mediapipe.tasks.core.proto.FilePointerMeta = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.core.proto.FilePointerMeta, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.core.proto.FilePointerMeta.displayName = "proto.mediapipe.tasks.core.proto.FilePointerMeta"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.core.proto.ExternalFile.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.core.proto.ExternalFile.toObject(e2, this);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.toObject = function(e2, r2) {
    var o2, i = { fileContent: r2.getFileContent_asB64(), fileName: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, fileDescriptorMeta: (o2 = r2.getFileDescriptorMeta()) && proto.mediapipe.tasks.core.proto.FileDescriptorMeta.toObject(e2, o2), filePointerMeta: (o2 = r2.getFilePointerMeta()) && proto.mediapipe.tasks.core.proto.FilePointerMeta.toObject(e2, o2) };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.tasks.core.proto.ExternalFile.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.core.proto.ExternalFile();
    return proto.mediapipe.tasks.core.proto.ExternalFile.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readBytes();
          e2.setFileContent(r2);
          break;
        case 2:
          r2 = t2.readString();
          e2.setFileName(r2);
          break;
        case 3:
          r2 = new proto.mediapipe.tasks.core.proto.FileDescriptorMeta();
          t2.readMessage(r2, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.deserializeBinaryFromReader), e2.setFileDescriptorMeta(r2);
          break;
        case 4:
          r2 = new proto.mediapipe.tasks.core.proto.FilePointerMeta();
          t2.readMessage(r2, proto.mediapipe.tasks.core.proto.FilePointerMeta.deserializeBinaryFromReader), e2.setFilePointerMeta(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.core.proto.ExternalFile.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.core.proto.ExternalFile.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeBytes(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeString(2, o2), null != (o2 = e2.getFileDescriptorMeta()) && r2.writeMessage(3, o2, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.serializeBinaryToWriter), null != (o2 = e2.getFilePointerMeta()) && r2.writeMessage(4, o2, proto.mediapipe.tasks.core.proto.FilePointerMeta.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.getFileContent = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.getFileContent_asB64 = function() {
    return t.Message.bytesAsB64(this.getFileContent());
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.getFileContent_asU8 = function() {
    return t.Message.bytesAsU8(this.getFileContent());
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.setFileContent = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.clearFileContent = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.hasFileContent = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.getFileName = function() {
    return t.Message.getFieldWithDefault(this, 2, "");
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.setFileName = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.clearFileName = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.hasFileName = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.getFileDescriptorMeta = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.tasks.core.proto.FileDescriptorMeta, 3);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.setFileDescriptorMeta = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.clearFileDescriptorMeta = function() {
    return this.setFileDescriptorMeta(void 0);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.hasFileDescriptorMeta = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.getFilePointerMeta = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.tasks.core.proto.FilePointerMeta, 4);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.setFilePointerMeta = function(e2) {
    return t.Message.setWrapperField(this, 4, e2);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.clearFilePointerMeta = function() {
    return this.setFilePointerMeta(void 0);
  }, proto.mediapipe.tasks.core.proto.ExternalFile.prototype.hasFilePointerMeta = function() {
    return null != t.Message.getField(this, 4);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.core.proto.FileDescriptorMeta.toObject(e2, this);
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.toObject = function(e2, r2) {
    var o2, i = { fd: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, length: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, offset: null == (o2 = t.Message.getField(r2, 3)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.tasks.core.proto.FileDescriptorMeta.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.core.proto.FileDescriptorMeta();
    return proto.mediapipe.tasks.core.proto.FileDescriptorMeta.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readInt32();
          e2.setFd(r2);
          break;
        case 2:
          r2 = t2.readInt64();
          e2.setLength(r2);
          break;
        case 3:
          r2 = t2.readInt64();
          e2.setOffset(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.core.proto.FileDescriptorMeta.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeInt32(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeInt64(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeInt64(3, o2);
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.getFd = function() {
    return t.Message.getFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.setFd = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.clearFd = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.hasFd = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.getLength = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.setLength = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.clearLength = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.hasLength = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.getOffset = function() {
    return t.Message.getFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.setOffset = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.clearOffset = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.tasks.core.proto.FileDescriptorMeta.prototype.hasOffset = function() {
    return null != t.Message.getField(this, 3);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.core.proto.FilePointerMeta.toObject(e2, this);
  }, proto.mediapipe.tasks.core.proto.FilePointerMeta.toObject = function(e2, r2) {
    var o2, i = { pointer: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, length: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.tasks.core.proto.FilePointerMeta.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.core.proto.FilePointerMeta();
    return proto.mediapipe.tasks.core.proto.FilePointerMeta.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.core.proto.FilePointerMeta.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readUint64();
          e2.setPointer(r2);
          break;
        case 2:
          r2 = t2.readInt64();
          e2.setLength(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.core.proto.FilePointerMeta.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.core.proto.FilePointerMeta.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeUint64(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeInt64(2, o2);
  }, proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.getPointer = function() {
    return t.Message.getFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.setPointer = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.clearPointer = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.hasPointer = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.getLength = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.setLength = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.clearLength = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.core.proto.FilePointerMeta.prototype.hasLength = function() {
    return null != t.Message.getField(this, 2);
  }, r.object.extend(e, proto.mediapipe.tasks.core.proto);
})(external_file_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = acceleration_pb;
  r.object.extend(proto, i);
  var a2 = external_file_pb;
  r.object.extend(proto, a2), r.exportSymbol("proto.mediapipe.tasks.core.proto.BaseOptions", null, o), proto.mediapipe.tasks.core.proto.BaseOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.core.proto.BaseOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.core.proto.BaseOptions.displayName = "proto.mediapipe.tasks.core.proto.BaseOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.core.proto.BaseOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.core.proto.BaseOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.core.proto.BaseOptions.toObject = function(e2, r2) {
    var o2, n = { modelAsset: (o2 = r2.getModelAsset()) && a2.ExternalFile.toObject(e2, o2), useStreamMode: t.Message.getBooleanFieldWithDefault(r2, 2, false), acceleration: (o2 = r2.getAcceleration()) && i.Acceleration.toObject(e2, o2) };
    return e2 && (n.$jspbMessageInstance = r2), n;
  }), proto.mediapipe.tasks.core.proto.BaseOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.core.proto.BaseOptions();
    return proto.mediapipe.tasks.core.proto.BaseOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.core.proto.BaseOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new a2.ExternalFile();
          t2.readMessage(r2, a2.ExternalFile.deserializeBinaryFromReader), e2.setModelAsset(r2);
          break;
        case 2:
          r2 = t2.readBool();
          e2.setUseStreamMode(r2);
          break;
        case 3:
          r2 = new i.Acceleration();
          t2.readMessage(r2, i.Acceleration.deserializeBinaryFromReader), e2.setAcceleration(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.core.proto.BaseOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.core.proto.BaseOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.core.proto.BaseOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getModelAsset()) && r2.writeMessage(1, o2, a2.ExternalFile.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 2)) && r2.writeBool(2, o2), null != (o2 = e2.getAcceleration()) && r2.writeMessage(3, o2, i.Acceleration.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.core.proto.BaseOptions.prototype.getModelAsset = function() {
    return t.Message.getWrapperField(this, a2.ExternalFile, 1);
  }, proto.mediapipe.tasks.core.proto.BaseOptions.prototype.setModelAsset = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.core.proto.BaseOptions.prototype.clearModelAsset = function() {
    return this.setModelAsset(void 0);
  }, proto.mediapipe.tasks.core.proto.BaseOptions.prototype.hasModelAsset = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.core.proto.BaseOptions.prototype.getUseStreamMode = function() {
    return t.Message.getBooleanFieldWithDefault(this, 2, false);
  }, proto.mediapipe.tasks.core.proto.BaseOptions.prototype.setUseStreamMode = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.core.proto.BaseOptions.prototype.clearUseStreamMode = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.core.proto.BaseOptions.prototype.hasUseStreamMode = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.core.proto.BaseOptions.prototype.getAcceleration = function() {
    return t.Message.getWrapperField(this, i.Acceleration, 3);
  }, proto.mediapipe.tasks.core.proto.BaseOptions.prototype.setAcceleration = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.tasks.core.proto.BaseOptions.prototype.clearAcceleration = function() {
    return this.setAcceleration(void 0);
  }, proto.mediapipe.tasks.core.proto.BaseOptions.prototype.hasAcceleration = function() {
    return null != t.Message.getField(this, 3);
  }, r.object.extend(e, proto.mediapipe.tasks.core.proto);
})(base_options_pb);
var face_detector_graph_options_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = base_options_pb;
  r.object.extend(proto, n), r.exportSymbol("proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions", null, o), proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.displayName = "proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.toObject = function(e2, r2) {
    var o2, i2 = { baseOptions: (o2 = r2.getBaseOptions()) && n.BaseOptions.toObject(e2, o2), minDetectionConfidence: t.Message.getFloatingPointFieldWithDefault(r2, 2, 0.5), minSuppressionThreshold: t.Message.getFloatingPointFieldWithDefault(r2, 3, 0.5), numFaces: null == (o2 = t.Message.getField(r2, 4)) ? void 0 : o2 };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions();
    return proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new n.BaseOptions();
          t2.readMessage(r2, n.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
          break;
        case 2:
          r2 = t2.readFloat();
          e2.setMinDetectionConfidence(r2);
          break;
        case 3:
          r2 = t2.readFloat();
          e2.setMinSuppressionThreshold(r2);
          break;
        case 4:
          r2 = t2.readInt32();
          e2.setNumFaces(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getBaseOptions()) && r2.writeMessage(1, o2, n.BaseOptions.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 2)) && r2.writeFloat(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeFloat(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeInt32(4, o2);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.ext = new t.ExtensionFieldInfo(502141897, { ext: 0 }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[502141897] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[502141897] = proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.ext, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, n.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.getMinDetectionConfidence = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0.5);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.setMinDetectionConfidence = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.clearMinDetectionConfidence = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.hasMinDetectionConfidence = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.getMinSuppressionThreshold = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 3, 0.5);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.setMinSuppressionThreshold = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.clearMinSuppressionThreshold = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.hasMinSuppressionThreshold = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.getNumFaces = function() {
    return t.Message.getFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.setNumFaces = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.clearNumFaces = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.prototype.hasNumFaces = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.ext = new t.ExtensionFieldInfo(502141897, { ext: 0 }, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[502141897] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[502141897] = proto.mediapipe.tasks.vision.face_detector.proto.FaceDetectorGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.face_detector.proto);
})(face_detector_graph_options_pb);
var detection_result = {};
Object.defineProperty(detection_result, "__esModule", { value: true }), detection_result.convertFromDetectionProto = void 0;
var DEFAULT_CATEGORY_INDEX = -1;
function convertFromDetectionProto(e) {
  var t, r, o, i, a2, n, s, p, d, l, g, c, u;
  const m = e.getScoreList(), f = e.getLabelIdList(), h = e.getLabelList(), y = e.getDisplayNameList(), b = { categories: [], keypoints: [] };
  for (let e2 = 0; e2 < m.length; e2++) b.categories.push({ score: m[e2], index: null !== (t = f[e2]) && void 0 !== t ? t : DEFAULT_CATEGORY_INDEX, categoryName: null !== (r = h[e2]) && void 0 !== r ? r : "", displayName: null !== (o = y[e2]) && void 0 !== o ? o : "" });
  const _ = null === (i = e.getLocationData()) || void 0 === i ? void 0 : i.getBoundingBox();
  if (_ && (b.boundingBox = { originX: null !== (a2 = _.getXmin()) && void 0 !== a2 ? a2 : 0, originY: null !== (n = _.getYmin()) && void 0 !== n ? n : 0, width: null !== (s = _.getWidth()) && void 0 !== s ? s : 0, height: null !== (p = _.getHeight()) && void 0 !== p ? p : 0, angle: 0 }), null === (d = e.getLocationData()) || void 0 === d ? void 0 : d.getRelativeKeypointsList().length) for (const t2 of e.getLocationData().getRelativeKeypointsList()) b.keypoints.push({ x: null !== (l = t2.getX()) && void 0 !== l ? l : 0, y: null !== (g = t2.getY()) && void 0 !== g ? g : 0, score: null !== (c = t2.getScore()) && void 0 !== c ? c : 0, label: null !== (u = t2.getKeypointLabel()) && void 0 !== u ? u : "" });
  return b;
}
detection_result.convertFromDetectionProto = convertFromDetectionProto;
var vision_task_runner = {};
var rect_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.NormalizedRect", null, o), r.exportSymbol("proto.mediapipe.Rect", null, o), proto.mediapipe.Rect = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.Rect, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.Rect.displayName = "proto.mediapipe.Rect"), proto.mediapipe.NormalizedRect = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.NormalizedRect, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.NormalizedRect.displayName = "proto.mediapipe.NormalizedRect"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.Rect.prototype.toObject = function(e2) {
    return proto.mediapipe.Rect.toObject(e2, this);
  }, proto.mediapipe.Rect.toObject = function(e2, r2) {
    var o2, i = { xCenter: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, yCenter: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, height: null == (o2 = t.Message.getField(r2, 3)) ? void 0 : o2, width: null == (o2 = t.Message.getField(r2, 4)) ? void 0 : o2, rotation: t.Message.getFloatingPointFieldWithDefault(r2, 5, 0), rectId: null == (o2 = t.Message.getField(r2, 6)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.Rect.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.Rect();
    return proto.mediapipe.Rect.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.Rect.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readInt32();
          e2.setXCenter(r2);
          break;
        case 2:
          r2 = t2.readInt32();
          e2.setYCenter(r2);
          break;
        case 3:
          r2 = t2.readInt32();
          e2.setHeight(r2);
          break;
        case 4:
          r2 = t2.readInt32();
          e2.setWidth(r2);
          break;
        case 5:
          r2 = t2.readFloat();
          e2.setRotation(r2);
          break;
        case 6:
          r2 = t2.readInt64();
          e2.setRectId(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.Rect.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.Rect.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.Rect.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeInt32(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeInt32(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeInt32(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeInt32(4, o2), null != (o2 = t.Message.getField(e2, 5)) && r2.writeFloat(5, o2), null != (o2 = t.Message.getField(e2, 6)) && r2.writeInt64(6, o2);
  }, proto.mediapipe.Rect.prototype.getXCenter = function() {
    return t.Message.getFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.Rect.prototype.setXCenter = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.Rect.prototype.clearXCenter = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.Rect.prototype.hasXCenter = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.Rect.prototype.getYCenter = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.Rect.prototype.setYCenter = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.Rect.prototype.clearYCenter = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.Rect.prototype.hasYCenter = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.Rect.prototype.getHeight = function() {
    return t.Message.getFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.Rect.prototype.setHeight = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.Rect.prototype.clearHeight = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.Rect.prototype.hasHeight = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.Rect.prototype.getWidth = function() {
    return t.Message.getFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.Rect.prototype.setWidth = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.Rect.prototype.clearWidth = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.Rect.prototype.hasWidth = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.Rect.prototype.getRotation = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 5, 0);
  }, proto.mediapipe.Rect.prototype.setRotation = function(e2) {
    return t.Message.setField(this, 5, e2);
  }, proto.mediapipe.Rect.prototype.clearRotation = function() {
    return t.Message.setField(this, 5, void 0);
  }, proto.mediapipe.Rect.prototype.hasRotation = function() {
    return null != t.Message.getField(this, 5);
  }, proto.mediapipe.Rect.prototype.getRectId = function() {
    return t.Message.getFieldWithDefault(this, 6, 0);
  }, proto.mediapipe.Rect.prototype.setRectId = function(e2) {
    return t.Message.setField(this, 6, e2);
  }, proto.mediapipe.Rect.prototype.clearRectId = function() {
    return t.Message.setField(this, 6, void 0);
  }, proto.mediapipe.Rect.prototype.hasRectId = function() {
    return null != t.Message.getField(this, 6);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.NormalizedRect.prototype.toObject = function(e2) {
    return proto.mediapipe.NormalizedRect.toObject(e2, this);
  }, proto.mediapipe.NormalizedRect.toObject = function(e2, r2) {
    var o2, i = { xCenter: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 1)) ? void 0 : o2, yCenter: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 2)) ? void 0 : o2, height: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 3)) ? void 0 : o2, width: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 4)) ? void 0 : o2, rotation: t.Message.getFloatingPointFieldWithDefault(r2, 5, 0), rectId: null == (o2 = t.Message.getField(r2, 6)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.NormalizedRect.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.NormalizedRect();
    return proto.mediapipe.NormalizedRect.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.NormalizedRect.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readFloat();
          e2.setXCenter(r2);
          break;
        case 2:
          r2 = t2.readFloat();
          e2.setYCenter(r2);
          break;
        case 3:
          r2 = t2.readFloat();
          e2.setHeight(r2);
          break;
        case 4:
          r2 = t2.readFloat();
          e2.setWidth(r2);
          break;
        case 5:
          r2 = t2.readFloat();
          e2.setRotation(r2);
          break;
        case 6:
          r2 = t2.readInt64();
          e2.setRectId(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.NormalizedRect.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.NormalizedRect.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.NormalizedRect.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeFloat(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeFloat(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeFloat(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeFloat(4, o2), null != (o2 = t.Message.getField(e2, 5)) && r2.writeFloat(5, o2), null != (o2 = t.Message.getField(e2, 6)) && r2.writeInt64(6, o2);
  }, proto.mediapipe.NormalizedRect.prototype.getXCenter = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.NormalizedRect.prototype.setXCenter = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.NormalizedRect.prototype.clearXCenter = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.NormalizedRect.prototype.hasXCenter = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.NormalizedRect.prototype.getYCenter = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.NormalizedRect.prototype.setYCenter = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.NormalizedRect.prototype.clearYCenter = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.NormalizedRect.prototype.hasYCenter = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.NormalizedRect.prototype.getHeight = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.NormalizedRect.prototype.setHeight = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.NormalizedRect.prototype.clearHeight = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.NormalizedRect.prototype.hasHeight = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.NormalizedRect.prototype.getWidth = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.NormalizedRect.prototype.setWidth = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.NormalizedRect.prototype.clearWidth = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.NormalizedRect.prototype.hasWidth = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.NormalizedRect.prototype.getRotation = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 5, 0);
  }, proto.mediapipe.NormalizedRect.prototype.setRotation = function(e2) {
    return t.Message.setField(this, 5, e2);
  }, proto.mediapipe.NormalizedRect.prototype.clearRotation = function() {
    return t.Message.setField(this, 5, void 0);
  }, proto.mediapipe.NormalizedRect.prototype.hasRotation = function() {
    return null != t.Message.getField(this, 5);
  }, proto.mediapipe.NormalizedRect.prototype.getRectId = function() {
    return t.Message.getFieldWithDefault(this, 6, 0);
  }, proto.mediapipe.NormalizedRect.prototype.setRectId = function(e2) {
    return t.Message.setField(this, 6, e2);
  }, proto.mediapipe.NormalizedRect.prototype.clearRectId = function() {
    return t.Message.setField(this, 6, void 0);
  }, proto.mediapipe.NormalizedRect.prototype.hasRectId = function() {
    return null != t.Message.getField(this, 6);
  }, r.object.extend(e, proto.mediapipe);
})(rect_pb);
var task_runner = {};
var graph_runner = {};
!(function(e) {
  Object.defineProperty(e, "__esModule", { value: true }), e.createGraphRunner = e.createMediaPipeLib = e.GraphRunner = e.CALCULATOR_GRAPH_CONFIG_LISTENER_NAME = void 0;
  const t = platform_utils;
  e.CALCULATOR_GRAPH_CONFIG_LISTENER_NAME = "__graph_config__";
  class r {
    constructor(e2, r2) {
      this.autoResizeCanvas = true, this.wasmModule = e2, this.audioPtr = null, this.audioSize = 0, this.hasMultiStreamSupport = "function" == typeof this.wasmModule._addIntToInputStream, void 0 !== r2 ? this.wasmModule.canvas = r2 : "undefined" == typeof OffscreenCanvas || (0, t.isWebKit)() ? (console.warn("OffscreenCanvas not supported and GraphRunner constructor glCanvas parameter is undefined. Creating backup canvas."), this.wasmModule.canvas = document.createElement("canvas")) : this.wasmModule.canvas = new OffscreenCanvas(1, 1);
    }
    async initializeGraph(e2) {
      const t2 = await fetch(e2), r2 = await t2.arrayBuffer(), o2 = !(e2.endsWith(".pbtxt") || e2.endsWith(".textproto"));
      this.setGraph(new Uint8Array(r2), o2);
    }
    setGraphFromString(e2) {
      this.setGraph(new TextEncoder().encode(e2), false);
    }
    setGraph(e2, t2) {
      const r2 = e2.length, o2 = this.wasmModule._malloc(r2);
      this.wasmModule.HEAPU8.set(e2, o2), t2 ? this.wasmModule._changeBinaryGraph(r2, o2) : this.wasmModule._changeTextGraph(r2, o2), this.wasmModule._free(o2);
    }
    configureAudio(e2, t2, r2, o2, i2) {
      this.wasmModule._configureAudio || console.warn('Attempting to use configureAudio without support for input audio. Is build dep ":gl_graph_runner_audio" missing?'), o2 = o2 || "input_audio", this.wrapStringPtr(o2, ((o3) => {
        i2 = i2 || "audio_header", this.wrapStringPtr(i2, ((i3) => {
          this.wasmModule._configureAudio(o3, i3, e2, t2, r2);
        }));
      }));
    }
    setAutoResizeCanvas(e2) {
      this.autoResizeCanvas = e2;
    }
    setAutoRenderToScreen(e2) {
      this.wasmModule._setAutoRenderToScreen(e2);
    }
    bindTextureToStream(e2, t2) {
      if (!this.wasmModule.canvas) throw new Error("No OpenGL canvas configured.");
      t2 ? this.wasmModule._bindTextureToStream(t2) : console.assert(this.wasmModule._bindTextureToCanvas());
      const r2 = this.wasmModule.canvas.getContext("webgl2") || this.wasmModule.canvas.getContext("webgl");
      if (!r2) throw new Error("Failed to obtain WebGL context from the provided canvas. `getContext()` should only be invoked with `webgl` or `webgl2`.");
      let o2, i2;
      return r2.texImage2D(r2.TEXTURE_2D, 0, r2.RGBA, r2.RGBA, r2.UNSIGNED_BYTE, e2), e2.videoWidth ? (o2 = e2.videoWidth, i2 = e2.videoHeight) : e2.naturalWidth ? (o2 = e2.naturalWidth, i2 = e2.naturalHeight) : (o2 = e2.width, i2 = e2.height), !this.autoResizeCanvas || o2 === this.wasmModule.canvas.width && i2 === this.wasmModule.canvas.height || (this.wasmModule.canvas.width = o2, this.wasmModule.canvas.height = i2), [o2, i2];
    }
    processGl(e2, t2) {
      const [r2, o2] = this.bindTextureToStream(e2), i2 = this.wasmModule._malloc(16);
      this.wasmModule.HEAPU32[i2 / 4] = r2, this.wasmModule.HEAPU32[i2 / 4 + 1] = o2, this.wasmModule.HEAPF64[i2 / 8 + 1] = t2, this.wasmModule._processGl(i2), this.wasmModule._free(i2);
    }
    wrapStringPtr(e2, t2) {
      this.hasMultiStreamSupport || console.error("No wasm multistream support detected: ensure dependency inclusion of :gl_graph_runner_internal_multi_input target");
      const r2 = this.wasmModule.stringToNewUTF8(e2);
      t2(r2), this.wasmModule._free(r2);
    }
    wrapStringPtrPtr(e2, t2) {
      this.hasMultiStreamSupport || console.error("No wasm multistream support detected: ensure dependency inclusion of :gl_graph_runner_internal_multi_input target");
      const r2 = new Uint32Array(e2.length);
      for (let t3 = 0; t3 < e2.length; t3++) r2[t3] = this.wasmModule.stringToNewUTF8(e2[t3]);
      const o2 = this.wasmModule._malloc(4 * r2.length);
      this.wasmModule.HEAPU32.set(r2, o2 >> 2), t2(o2);
      for (const e3 of r2) this.wasmModule._free(e3);
      this.wasmModule._free(o2);
    }
    getCalculatorGraphConfig(t2, r2) {
      const o2 = e.CALCULATOR_GRAPH_CONFIG_LISTENER_NAME;
      this.setListener(o2, ((e2) => {
        t2(e2);
      })), this.wrapStringPtr(o2, ((e2) => {
        this.wasmModule._getGraphConfig(e2, r2);
      })), delete this.wasmModule.simpleListeners[o2];
    }
    setListener(e2, t2) {
      this.wasmModule.simpleListeners = this.wasmModule.simpleListeners || {}, this.wasmModule.simpleListeners[e2] = t2;
    }
    setVectorListener(e2, t2) {
      let r2 = [];
      this.wasmModule.simpleListeners = this.wasmModule.simpleListeners || {}, this.wasmModule.simpleListeners[e2] = (e3, o2, i2) => {
        o2 ? (t2(r2, i2), r2 = []) : r2.push(e3);
      };
    }
    attachErrorListener(e2) {
      this.wasmModule.errorListener = e2;
    }
    attachEmptyPacketListener(e2, t2) {
      this.wasmModule.emptyPacketListeners = this.wasmModule.emptyPacketListeners || {}, this.wasmModule.emptyPacketListeners[e2] = t2;
    }
    addAudioToStream(e2, t2, r2) {
      this.addAudioToStreamWithShape(e2, 0, 0, t2, r2);
    }
    addAudioToStreamWithShape(e2, t2, r2, o2, i2) {
      const a2 = 4 * e2.length;
      this.audioSize !== a2 && (this.audioPtr && this.wasmModule._free(this.audioPtr), this.audioPtr = this.wasmModule._malloc(a2), this.audioSize = a2), this.wasmModule.HEAPF32.set(e2, this.audioPtr / 4), this.wrapStringPtr(o2, ((e3) => {
        this.wasmModule._addAudioToInputStream(this.audioPtr, t2, r2, e3, i2);
      }));
    }
    addGpuBufferToStream(e2, t2, r2) {
      this.wrapStringPtr(t2, ((t3) => {
        const [o2, i2] = this.bindTextureToStream(e2, t3);
        this.wasmModule._addBoundTextureToStream(t3, o2, i2, r2);
      }));
    }
    addBoolToStream(e2, t2, r2) {
      this.wrapStringPtr(t2, ((t3) => {
        this.wasmModule._addBoolToInputStream(e2, t3, r2);
      }));
    }
    addDoubleToStream(e2, t2, r2) {
      this.wrapStringPtr(t2, ((t3) => {
        this.wasmModule._addDoubleToInputStream(e2, t3, r2);
      }));
    }
    addFloatToStream(e2, t2, r2) {
      this.wrapStringPtr(t2, ((t3) => {
        this.wasmModule._addFloatToInputStream(e2, t3, r2);
      }));
    }
    addIntToStream(e2, t2, r2) {
      this.wrapStringPtr(t2, ((t3) => {
        this.wasmModule._addIntToInputStream(e2, t3, r2);
      }));
    }
    addStringToStream(e2, t2, r2) {
      this.wrapStringPtr(t2, ((t3) => {
        this.wrapStringPtr(e2, ((e3) => {
          this.wasmModule._addStringToInputStream(e3, t3, r2);
        }));
      }));
    }
    addStringRecordToStream(e2, t2, r2) {
      this.wrapStringPtr(t2, ((t3) => {
        this.wrapStringPtrPtr(Object.keys(e2), ((o2) => {
          this.wrapStringPtrPtr(Object.values(e2), ((i2) => {
            this.wasmModule._addFlatHashMapToInputStream(o2, i2, Object.keys(e2).length, t3, r2);
          }));
        }));
      }));
    }
    addProtoToStream(e2, t2, r2, o2) {
      this.wrapStringPtr(r2, ((r3) => {
        this.wrapStringPtr(t2, ((t3) => {
          const i2 = this.wasmModule._malloc(e2.length);
          this.wasmModule.HEAPU8.set(e2, i2), this.wasmModule._addProtoToInputStream(i2, e2.length, t3, r3, o2), this.wasmModule._free(i2);
        }));
      }));
    }
    addEmptyPacketToStream(e2, t2) {
      this.wrapStringPtr(e2, ((e3) => {
        this.wasmModule._addEmptyPacketToInputStream(e3, t2);
      }));
    }
    addBoolToInputSidePacket(e2, t2) {
      this.wrapStringPtr(t2, ((t3) => {
        this.wasmModule._addBoolToInputSidePacket(e2, t3);
      }));
    }
    addDoubleToInputSidePacket(e2, t2) {
      this.wrapStringPtr(t2, ((t3) => {
        this.wasmModule._addDoubleToInputSidePacket(e2, t3);
      }));
    }
    addFloatToInputSidePacket(e2, t2) {
      this.wrapStringPtr(t2, ((t3) => {
        this.wasmModule._addFloatToInputSidePacket(e2, t3);
      }));
    }
    addIntToInputSidePacket(e2, t2) {
      this.wrapStringPtr(t2, ((t3) => {
        this.wasmModule._addIntToInputSidePacket(e2, t3);
      }));
    }
    addStringToInputSidePacket(e2, t2) {
      this.wrapStringPtr(t2, ((t3) => {
        this.wrapStringPtr(e2, ((e3) => {
          this.wasmModule._addStringToInputSidePacket(e3, t3);
        }));
      }));
    }
    addProtoToInputSidePacket(e2, t2, r2) {
      this.wrapStringPtr(r2, ((r3) => {
        this.wrapStringPtr(t2, ((t3) => {
          const o2 = this.wasmModule._malloc(e2.length);
          this.wasmModule.HEAPU8.set(e2, o2), this.wasmModule._addProtoToInputSidePacket(o2, e2.length, t3, r3), this.wasmModule._free(o2);
        }));
      }));
    }
    attachBoolListener(e2, t2) {
      this.setListener(e2, t2), this.wrapStringPtr(e2, ((e3) => {
        this.wasmModule._attachBoolListener(e3);
      }));
    }
    attachBoolVectorListener(e2, t2) {
      this.setVectorListener(e2, t2), this.wrapStringPtr(e2, ((e3) => {
        this.wasmModule._attachBoolVectorListener(e3);
      }));
    }
    attachIntListener(e2, t2) {
      this.setListener(e2, t2), this.wrapStringPtr(e2, ((e3) => {
        this.wasmModule._attachIntListener(e3);
      }));
    }
    attachIntVectorListener(e2, t2) {
      this.setVectorListener(e2, t2), this.wrapStringPtr(e2, ((e3) => {
        this.wasmModule._attachIntVectorListener(e3);
      }));
    }
    attachDoubleListener(e2, t2) {
      this.setListener(e2, t2), this.wrapStringPtr(e2, ((e3) => {
        this.wasmModule._attachDoubleListener(e3);
      }));
    }
    attachDoubleVectorListener(e2, t2) {
      this.setVectorListener(e2, t2), this.wrapStringPtr(e2, ((e3) => {
        this.wasmModule._attachDoubleVectorListener(e3);
      }));
    }
    attachFloatListener(e2, t2) {
      this.setListener(e2, t2), this.wrapStringPtr(e2, ((e3) => {
        this.wasmModule._attachFloatListener(e3);
      }));
    }
    attachFloatVectorListener(e2, t2) {
      this.setVectorListener(e2, t2), this.wrapStringPtr(e2, ((e3) => {
        this.wasmModule._attachFloatVectorListener(e3);
      }));
    }
    attachStringListener(e2, t2) {
      this.setListener(e2, t2), this.wrapStringPtr(e2, ((e3) => {
        this.wasmModule._attachStringListener(e3);
      }));
    }
    attachStringVectorListener(e2, t2) {
      this.setVectorListener(e2, t2), this.wrapStringPtr(e2, ((e3) => {
        this.wasmModule._attachStringVectorListener(e3);
      }));
    }
    attachProtoListener(e2, t2, r2) {
      this.setListener(e2, t2), this.wrapStringPtr(e2, ((e3) => {
        this.wasmModule._attachProtoListener(e3, r2 || false);
      }));
    }
    attachProtoVectorListener(e2, t2, r2) {
      this.setVectorListener(e2, t2), this.wrapStringPtr(e2, ((e3) => {
        this.wasmModule._attachProtoVectorListener(e3, r2 || false);
      }));
    }
    attachAudioListener(e2, t2, r2) {
      this.wasmModule._attachAudioListener || console.warn('Attempting to use attachAudioListener without support for output audio. Is build dep ":gl_graph_runner_audio_out" missing?'), this.setListener(e2, ((e3, r3) => {
        const o2 = new Float32Array(e3.buffer, e3.byteOffset, e3.length / 4);
        t2(o2, r3);
      })), this.wrapStringPtr(e2, ((e3) => {
        this.wasmModule._attachAudioListener(e3, r2 || false);
      }));
    }
    finishProcessing() {
      this.wasmModule._waitUntilIdle();
    }
    closeGraph() {
      this.wasmModule._closeGraph(), this.wasmModule.simpleListeners = void 0, this.wasmModule.emptyPacketListeners = void 0;
    }
  }
  async function o(e2) {
    if ("function" != typeof importScripts) {
      const t2 = document.createElement("script");
      return t2.setAttribute("src", e2), t2.setAttribute("crossorigin", "anonymous"), new Promise(((e3) => {
        t2.addEventListener("load", (() => {
          e3();
        }), false), t2.addEventListener("error", (() => {
          e3();
        }), false), document.body.appendChild(t2);
      }));
    }
    importScripts(e2.toString());
  }
  async function i(e2, t2, r2, i2, a2) {
    const n = [];
    if (t2 && n.push(t2), r2 && n.push(r2), n.length && await Promise.all(n.map(o)), !self.ModuleFactory) throw new Error("ModuleFactory not set.");
    if (self.Module && a2) {
      const e3 = self.Module;
      e3.locateFile = a2.locateFile, a2.mainScriptUrlOrBlob && (e3.mainScriptUrlOrBlob = a2.mainScriptUrlOrBlob);
    }
    const s = await self.ModuleFactory(self.Module || a2);
    return self.ModuleFactory = self.Module = void 0, new e2(s, i2);
  }
  e.GraphRunner = r, e.createMediaPipeLib = i, e.createGraphRunner = async function(e2, t2, o2, a2) {
    return i(r, e2, t2, o2, a2);
  };
})(graph_runner);
var register_model_resources_graph_service = {};
function SupportModelResourcesGraphService(e) {
  return class extends e {
    registerModelResourcesGraphService() {
      this.wasmModule._registerModelResourcesGraphService();
    }
  };
}
Object.defineProperty(register_model_resources_graph_service, "__esModule", { value: true }), register_model_resources_graph_service.SupportModelResourcesGraphService = void 0, register_model_resources_graph_service.SupportModelResourcesGraphService = SupportModelResourcesGraphService, Object.defineProperty(task_runner, "__esModule", { value: true }), task_runner.TaskRunner = task_runner.createTaskRunner = task_runner.CachedGraphRunner = void 0;
var inference_calculator_pb_1 = inference_calculator_pb;
var calculator_pb_1 = calculator_pb;
var acceleration_pb_1 = acceleration_pb;
var external_file_pb_1 = external_file_pb;
var graph_runner_1$1 = graph_runner;
var register_model_resources_graph_service_1$1 = register_model_resources_graph_service;
var FREE_MEMORY_STREAM = "free_memory";
var UNUSED_STREAM_SUFFIX = "_unused_out";
var CachedGraphRunnerType = (0, register_model_resources_graph_service_1$1.SupportModelResourcesGraphService)(graph_runner_1$1.GraphRunner);
var CachedGraphRunner = class extends CachedGraphRunnerType {
};
async function createTaskRunner(e, t, r, o) {
  const i = { locateFile: () => r.wasmBinaryPath.toString() }, a2 = await (0, graph_runner_1$1.createMediaPipeLib)(e, r.wasmLoaderPath, r.assetLoaderPath, t, i);
  return await a2.setOptions(o), a2;
}
task_runner.CachedGraphRunner = CachedGraphRunner, task_runner.createTaskRunner = createTaskRunner;
var TaskRunner = class {
  static async createInstance(e, t, r, o) {
    return createTaskRunner(e, t, r, o);
  }
  constructor(e) {
    this.graphRunner = e, this.processingErrors = [], this.latestOutputTimestamp = 0, this.graphRunner.setAutoRenderToScreen(false);
  }
  applyOptions(e, t = true) {
    var r, o, i, a2, n, s;
    if (t) {
      const t2 = e.baseOptions || {};
      if ((null === (r = e.baseOptions) || void 0 === r ? void 0 : r.modelAssetBuffer) && (null === (o = e.baseOptions) || void 0 === o ? void 0 : o.modelAssetPath)) throw new Error("Cannot set both baseOptions.modelAssetPath and baseOptions.modelAssetBuffer");
      if (!((null === (i = this.baseOptions.getModelAsset()) || void 0 === i ? void 0 : i.hasFileContent()) || (null === (a2 = this.baseOptions.getModelAsset()) || void 0 === a2 ? void 0 : a2.hasFileName()) || (null === (n = e.baseOptions) || void 0 === n ? void 0 : n.modelAssetBuffer) || (null === (s = e.baseOptions) || void 0 === s ? void 0 : s.modelAssetPath))) throw new Error("Either baseOptions.modelAssetPath or baseOptions.modelAssetBuffer must be set");
      if (this.setAcceleration(t2), t2.modelAssetPath) return fetch(t2.modelAssetPath.toString()).then(((e2) => {
        if (e2.ok) return e2.arrayBuffer();
        throw new Error(`Failed to fetch model: ${t2.modelAssetPath} (${e2.status})`);
      })).then(((e2) => {
        try {
          this.graphRunner.wasmModule.FS_unlink("/model.dat");
        } catch (e3) {
        }
        this.graphRunner.wasmModule.FS_createDataFile("/", "model.dat", new Uint8Array(e2), true, false, false), this.setExternalFile("/model.dat"), this.refreshGraph(), this.onGraphRefreshed();
      }));
      this.setExternalFile(t2.modelAssetBuffer);
    }
    return this.refreshGraph(), this.onGraphRefreshed(), Promise.resolve();
  }
  onGraphRefreshed() {
  }
  getCalculatorGraphConfig() {
    let e;
    if (this.graphRunner.getCalculatorGraphConfig(((t) => {
      e = calculator_pb_1.CalculatorGraphConfig.deserializeBinary(t);
    })), !e) throw new Error("Failed to retrieve CalculatorGraphConfig");
    return e;
  }
  setGraph(e, t) {
    this.graphRunner.attachErrorListener(((e2, t2) => {
      this.processingErrors.push(new Error(t2));
    })), this.graphRunner.registerModelResourcesGraphService(), this.graphRunner.setGraph(e, t), this.keepaliveNode = void 0, this.handleErrors();
  }
  finishProcessing() {
    this.graphRunner.finishProcessing(), this.handleErrors();
  }
  setLatestOutputTimestamp(e) {
    this.latestOutputTimestamp = Math.max(this.latestOutputTimestamp, e);
  }
  getSynctheticTimestamp() {
    return this.latestOutputTimestamp + 1;
  }
  handleErrors() {
    try {
      const e = this.processingErrors.length;
      if (1 === e) throw new Error(this.processingErrors[0].message);
      if (e > 1) throw new Error("Encountered multiple errors: " + this.processingErrors.map(((e2) => e2.message)).join(", "));
    } finally {
      this.processingErrors = [];
    }
  }
  setExternalFile(e) {
    const t = this.baseOptions.getModelAsset() || new external_file_pb_1.ExternalFile();
    "string" == typeof e ? (t.setFileName(e), t.clearFileContent()) : e instanceof Uint8Array && (t.setFileContent(e), t.clearFileName()), this.baseOptions.setModelAsset(t);
  }
  setAcceleration(e) {
    let t = this.baseOptions.getAcceleration();
    t || (t = new acceleration_pb_1.Acceleration(), t.setTflite(new inference_calculator_pb_1.InferenceCalculatorOptions.Delegate.TfLite())), "delegate" in e && ("GPU" === e.delegate ? t.setGpu(new inference_calculator_pb_1.InferenceCalculatorOptions.Delegate.Gpu()) : t.setTflite(new inference_calculator_pb_1.InferenceCalculatorOptions.Delegate.TfLite())), this.baseOptions.setAcceleration(t);
  }
  addKeepaliveNode(e) {
    this.keepaliveNode = new calculator_pb_1.CalculatorGraphConfig.Node(), this.keepaliveNode.setCalculator("PassThroughCalculator"), this.keepaliveNode.addInputStream(FREE_MEMORY_STREAM), this.keepaliveNode.addOutputStream(FREE_MEMORY_STREAM + UNUSED_STREAM_SUFFIX), e.addInputStream(FREE_MEMORY_STREAM), e.addNode(this.keepaliveNode);
  }
  keepStreamAlive(e) {
    this.keepaliveNode.addInputStream(e), this.keepaliveNode.addOutputStream(e + UNUSED_STREAM_SUFFIX);
  }
  freeKeepaliveStreams() {
    this.graphRunner.addBoolToStream(true, FREE_MEMORY_STREAM, this.latestOutputTimestamp);
  }
  close() {
    this.keepaliveNode = void 0, this.graphRunner.closeGraph();
  }
};
task_runner.TaskRunner = TaskRunner;
var graph_runner_image_lib = {};
function SupportImage(e) {
  return class extends e {
    get wasmImageModule() {
      return this.wasmModule;
    }
    addGpuBufferAsImageToStream(e2, t, r) {
      this.wrapStringPtr(t, ((t2) => {
        const [o, i] = this.bindTextureToStream(e2, t2);
        this.wasmImageModule._addBoundTextureAsImageToStream(t2, o, i, r);
      }));
    }
    attachImageListener(e2, t) {
      this.setListener(e2, t), this.wrapStringPtr(e2, ((e3) => {
        this.wasmImageModule._attachImageListener(e3);
      }));
    }
    attachImageVectorListener(e2, t) {
      this.setVectorListener(e2, t), this.wrapStringPtr(e2, ((e3) => {
        this.wasmImageModule._attachImageVectorListener(e3);
      }));
    }
  };
}
Object.defineProperty(graph_runner_image_lib, "__esModule", { value: true }), graph_runner_image_lib.SupportImage = void 0, graph_runner_image_lib.SupportImage = SupportImage, Object.defineProperty(vision_task_runner, "__esModule", { value: true }), vision_task_runner.VisionTaskRunner = vision_task_runner.VisionGraphRunner = void 0;
var rect_pb_1 = rect_pb;
var task_runner_1 = task_runner;
var image_1$1 = image;
var image_shader_context_1 = image_shader_context;
var mask_1$1 = mask;
var graph_runner_1 = graph_runner;
var graph_runner_image_lib_1 = graph_runner_image_lib;
var platform_utils_1 = platform_utils;
var register_model_resources_graph_service_1 = register_model_resources_graph_service;
var GraphRunnerVisionType = (0, register_model_resources_graph_service_1.SupportModelResourcesGraphService)((0, graph_runner_image_lib_1.SupportImage)(graph_runner_1.GraphRunner));
var VisionGraphRunner = class extends GraphRunnerVisionType {
};
function createCanvas() {
  return "undefined" != typeof OffscreenCanvas && !(0, platform_utils_1.isWebKit)() ? void 0 : document.createElement("canvas");
}
vision_task_runner.VisionGraphRunner = VisionGraphRunner;
var VisionTaskRunner = class extends task_runner_1.TaskRunner {
  static async createVisionInstance(e, t, r) {
    var o;
    const i = null !== (o = r.canvas) && void 0 !== o ? o : createCanvas();
    return task_runner_1.TaskRunner.createInstance(e, i, t, r);
  }
  constructor(e, t, r, o) {
    super(e), this.graphRunner = e, this.imageStreamName = t, this.normRectStreamName = r, this.roiAllowed = o, this.shaderContext = new image_shader_context_1.MPImageShaderContext();
  }
  applyOptions(e, t = true) {
    if ("runningMode" in e) {
      const t2 = !!e.runningMode && "IMAGE" !== e.runningMode;
      this.baseOptions.setUseStreamMode(t2);
    }
    if (void 0 !== e.canvas && this.graphRunner.wasmModule.canvas !== e.canvas) throw new Error("You must create a new task to reset the canvas.");
    return super.applyOptions(e, t);
  }
  processImageData(e, t) {
    var r;
    if (null === (r = this.baseOptions) || void 0 === r ? void 0 : r.getUseStreamMode()) throw new Error("Task is not initialized with image mode. 'runningMode' must be set to 'IMAGE'.");
    this.process(e, t, this.getSynctheticTimestamp());
  }
  processVideoData(e, t, r) {
    var o;
    if (!(null === (o = this.baseOptions) || void 0 === o ? void 0 : o.getUseStreamMode())) throw new Error("Task is not initialized with video mode. 'runningMode' must be set to 'VIDEO'.");
    this.process(e, t, r);
  }
  getImageSourceSize(e) {
    return void 0 !== e.videoWidth ? [e.videoWidth, e.videoHeight] : void 0 !== e.naturalWidth ? [e.naturalWidth, e.naturalHeight] : [e.width, e.height];
  }
  convertToNormalizedRect(e, t) {
    const r = new rect_pb_1.NormalizedRect();
    if (null == t ? void 0 : t.regionOfInterest) {
      if (!this.roiAllowed) throw new Error("This task doesn't support region-of-interest.");
      const e2 = t.regionOfInterest;
      if (e2.left >= e2.right || e2.top >= e2.bottom) throw new Error("Expected RectF with left < right and top < bottom.");
      if (e2.left < 0 || e2.top < 0 || e2.right > 1 || e2.bottom > 1) throw new Error("Expected RectF values to be in [0,1].");
      r.setXCenter((e2.left + e2.right) / 2), r.setYCenter((e2.top + e2.bottom) / 2), r.setWidth(e2.right - e2.left), r.setHeight(e2.bottom - e2.top);
    } else r.setXCenter(0.5), r.setYCenter(0.5), r.setWidth(1), r.setHeight(1);
    if (null == t ? void 0 : t.rotationDegrees) {
      if ((null == t ? void 0 : t.rotationDegrees) % 90 != 0) throw new Error("Expected rotation to be a multiple of 90°.");
      if (r.setRotation(-Math.PI * t.rotationDegrees / 180), (null == t ? void 0 : t.rotationDegrees) % 180 != 0) {
        const [t2, o] = this.getImageSourceSize(e), i = r.getHeight() * o / t2, a2 = r.getWidth() * t2 / o;
        r.setWidth(i), r.setHeight(a2);
      }
    }
    return r;
  }
  process(e, t, r) {
    if (this.normRectStreamName) {
      const o = this.convertToNormalizedRect(e, t);
      this.graphRunner.addProtoToStream(o.serializeBinary(), "mediapipe.NormalizedRect", this.normRectStreamName, r);
    }
    this.graphRunner.addGpuBufferAsImageToStream(e, this.imageStreamName, null != r ? r : performance.now()), this.finishProcessing();
  }
  convertToMPImage(e, t) {
    const { data: r, width: o, height: i } = e, a2 = o * i;
    let n;
    if (r instanceof Uint8Array) if (r.length === 3 * a2) {
      const e2 = new Uint8ClampedArray(4 * a2);
      for (let t2 = 0; t2 < a2; ++t2) e2[4 * t2] = r[3 * t2], e2[4 * t2 + 1] = r[3 * t2 + 1], e2[4 * t2 + 2] = r[3 * t2 + 2], e2[4 * t2 + 3] = 255;
      n = new ImageData(e2, o, i);
    } else {
      if (r.length !== 4 * a2) throw new Error("Unsupported channel count: " + r.length / a2);
      n = new ImageData(new Uint8ClampedArray(r.buffer, r.byteOffset, r.length), o, i);
    }
    else {
      if (!(r instanceof WebGLTexture)) throw new Error(`Unsupported format: ${r.constructor.name}`);
      n = r;
    }
    const s = new image_1$1.MPImage([n], false, false, this.graphRunner.wasmModule.canvas, this.shaderContext, o, i);
    return t ? s.clone() : s;
  }
  convertToMPMask(e, t) {
    const { data: r, width: o, height: i } = e, a2 = o * i;
    let n;
    if (r instanceof Uint8Array || r instanceof Float32Array) {
      if (r.length !== a2) throw new Error("Unsupported channel count: " + r.length / a2);
      n = r;
    } else n = r;
    const s = new mask_1$1.MPMask([n], false, this.graphRunner.wasmModule.canvas, this.shaderContext, o, i);
    return t ? s.clone() : s;
  }
  close() {
    this.shaderContext.close(), super.close();
  }
};
vision_task_runner.VisionTaskRunner = VisionTaskRunner;
var face_detector_options = {};
Object.defineProperty(face_detector_options, "__esModule", { value: true });
var face_detector_result = {};
Object.defineProperty(face_detector_result, "__esModule", { value: true }), (function(e) {
  var t = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2);
    var i2 = Object.getOwnPropertyDescriptor(t2, r2);
    i2 && !("get" in i2 ? !t2.__esModule : i2.writable || i2.configurable) || (i2 = { enumerable: true, get: function() {
      return t2[r2];
    } }), Object.defineProperty(e2, o2, i2);
  } : function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2), e2[o2] = t2[r2];
  }), r = commonjsGlobal && commonjsGlobal.__exportStar || function(e2, r2) {
    for (var o2 in e2) "default" === o2 || Object.prototype.hasOwnProperty.call(r2, o2) || t(r2, e2, o2);
  };
  Object.defineProperty(e, "__esModule", { value: true }), e.FaceDetector = void 0;
  const o = calculator_pb, i = calculator_options_pb, a2 = detection_pb, n = base_options_pb, s = face_detector_graph_options_pb, p = detection_result, d = vision_task_runner, l = "image_in", g = "norm_rect_in", c = "detections";
  r(face_detector_options, e), r(face_detector_result, e);
  class u extends d.VisionTaskRunner {
    static createFromOptions(e2, t2) {
      return d.VisionTaskRunner.createVisionInstance(u, e2, t2);
    }
    static createFromModelBuffer(e2, t2) {
      return d.VisionTaskRunner.createVisionInstance(u, e2, { baseOptions: { modelAssetBuffer: t2 } });
    }
    static async createFromModelPath(e2, t2) {
      return d.VisionTaskRunner.createVisionInstance(u, e2, { baseOptions: { modelAssetPath: t2 } });
    }
    constructor(e2, t2) {
      super(new d.VisionGraphRunner(e2, t2), l, g, false), this.result = { detections: [] }, this.options = new s.FaceDetectorGraphOptions(), this.options.setBaseOptions(new n.BaseOptions()), this.options.setMinDetectionConfidence(0.5), this.options.setMinSuppressionThreshold(0.3);
    }
    get baseOptions() {
      return this.options.getBaseOptions();
    }
    set baseOptions(e2) {
      this.options.setBaseOptions(e2);
    }
    setOptions(e2) {
      var t2, r2;
      return "minDetectionConfidence" in e2 && this.options.setMinDetectionConfidence(null !== (t2 = e2.minDetectionConfidence) && void 0 !== t2 ? t2 : 0.5), "minSuppressionThreshold" in e2 && this.options.setMinSuppressionThreshold(null !== (r2 = e2.minSuppressionThreshold) && void 0 !== r2 ? r2 : 0.3), this.applyOptions(e2);
    }
    detect(e2, t2) {
      return this.result = { detections: [] }, this.processImageData(e2, t2), this.result;
    }
    detectForVideo(e2, t2, r2) {
      return this.result = { detections: [] }, this.processVideoData(e2, r2, t2), this.result;
    }
    addJsFaceDetections(e2) {
      for (const t2 of e2) {
        const e3 = a2.Detection.deserializeBinary(t2);
        this.result.detections.push((0, p.convertFromDetectionProto)(e3));
      }
    }
    refreshGraph() {
      const e2 = new o.CalculatorGraphConfig();
      e2.addInputStream(l), e2.addInputStream(g), e2.addOutputStream(c);
      const t2 = new i.CalculatorOptions();
      t2.setExtension(s.FaceDetectorGraphOptions.ext, this.options);
      const r2 = new o.CalculatorGraphConfig.Node();
      r2.setCalculator("mediapipe.tasks.vision.face_detector.FaceDetectorGraph"), r2.addInputStream("IMAGE:" + l), r2.addInputStream("NORM_RECT:" + g), r2.addOutputStream("DETECTIONS:" + c), r2.setOptions(t2), e2.addNode(r2), this.graphRunner.attachProtoVectorListener(c, ((e3, t3) => {
        this.addJsFaceDetections(e3), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(c, ((e3) => {
        this.setLatestOutputTimestamp(e3);
      }));
      const a3 = e2.serializeBinary();
      this.setGraph(new Uint8Array(a3), true);
    }
  }
  e.FaceDetector = u;
})(face_detector);
var face_landmarker = {};
var classification_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.Classification", null, o), r.exportSymbol("proto.mediapipe.ClassificationList", null, o), r.exportSymbol("proto.mediapipe.ClassificationListCollection", null, o), proto.mediapipe.Classification = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.Classification, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.Classification.displayName = "proto.mediapipe.Classification"), proto.mediapipe.ClassificationList = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.ClassificationList.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.ClassificationList, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.ClassificationList.displayName = "proto.mediapipe.ClassificationList"), proto.mediapipe.ClassificationListCollection = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.ClassificationListCollection.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.ClassificationListCollection, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.ClassificationListCollection.displayName = "proto.mediapipe.ClassificationListCollection"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.Classification.prototype.toObject = function(e2) {
    return proto.mediapipe.Classification.toObject(e2, this);
  }, proto.mediapipe.Classification.toObject = function(e2, r2) {
    var o2, i = { index: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, score: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 2)) ? void 0 : o2, label: null == (o2 = t.Message.getField(r2, 3)) ? void 0 : o2, displayName: null == (o2 = t.Message.getField(r2, 4)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.Classification.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.Classification();
    return proto.mediapipe.Classification.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.Classification.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readInt32();
          e2.setIndex(r2);
          break;
        case 2:
          r2 = t2.readFloat();
          e2.setScore(r2);
          break;
        case 3:
          r2 = t2.readString();
          e2.setLabel(r2);
          break;
        case 4:
          r2 = t2.readString();
          e2.setDisplayName(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.Classification.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.Classification.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.Classification.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeInt32(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeFloat(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeString(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeString(4, o2);
  }, proto.mediapipe.Classification.prototype.getIndex = function() {
    return t.Message.getFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.Classification.prototype.setIndex = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.Classification.prototype.clearIndex = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.Classification.prototype.hasIndex = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.Classification.prototype.getScore = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.Classification.prototype.setScore = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.Classification.prototype.clearScore = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.Classification.prototype.hasScore = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.Classification.prototype.getLabel = function() {
    return t.Message.getFieldWithDefault(this, 3, "");
  }, proto.mediapipe.Classification.prototype.setLabel = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.Classification.prototype.clearLabel = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.Classification.prototype.hasLabel = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.Classification.prototype.getDisplayName = function() {
    return t.Message.getFieldWithDefault(this, 4, "");
  }, proto.mediapipe.Classification.prototype.setDisplayName = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.Classification.prototype.clearDisplayName = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.Classification.prototype.hasDisplayName = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.ClassificationList.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.ClassificationList.prototype.toObject = function(e2) {
    return proto.mediapipe.ClassificationList.toObject(e2, this);
  }, proto.mediapipe.ClassificationList.toObject = function(e2, r2) {
    var o2 = { classificationList: t.Message.toObjectList(r2.getClassificationList(), proto.mediapipe.Classification.toObject, e2) };
    return e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.ClassificationList.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.ClassificationList();
    return proto.mediapipe.ClassificationList.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.ClassificationList.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new proto.mediapipe.Classification();
        t2.readMessage(r2, proto.mediapipe.Classification.deserializeBinaryFromReader), e2.addClassification(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.ClassificationList.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.ClassificationList.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.ClassificationList.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    (r2 = e2.getClassificationList()).length > 0 && t2.writeRepeatedMessage(1, r2, proto.mediapipe.Classification.serializeBinaryToWriter);
  }, proto.mediapipe.ClassificationList.prototype.getClassificationList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.Classification, 1);
  }, proto.mediapipe.ClassificationList.prototype.setClassificationList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.ClassificationList.prototype.addClassification = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.Classification, r2);
  }, proto.mediapipe.ClassificationList.prototype.clearClassificationList = function() {
    return this.setClassificationList([]);
  }, proto.mediapipe.ClassificationListCollection.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.ClassificationListCollection.prototype.toObject = function(e2) {
    return proto.mediapipe.ClassificationListCollection.toObject(e2, this);
  }, proto.mediapipe.ClassificationListCollection.toObject = function(e2, r2) {
    var o2 = { classificationListList: t.Message.toObjectList(r2.getClassificationListList(), proto.mediapipe.ClassificationList.toObject, e2) };
    return e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.ClassificationListCollection.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.ClassificationListCollection();
    return proto.mediapipe.ClassificationListCollection.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.ClassificationListCollection.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new proto.mediapipe.ClassificationList();
        t2.readMessage(r2, proto.mediapipe.ClassificationList.deserializeBinaryFromReader), e2.addClassificationList(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.ClassificationListCollection.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.ClassificationListCollection.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.ClassificationListCollection.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    (r2 = e2.getClassificationListList()).length > 0 && t2.writeRepeatedMessage(1, r2, proto.mediapipe.ClassificationList.serializeBinaryToWriter);
  }, proto.mediapipe.ClassificationListCollection.prototype.getClassificationListList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.ClassificationList, 1);
  }, proto.mediapipe.ClassificationListCollection.prototype.setClassificationListList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.ClassificationListCollection.prototype.addClassificationList = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.ClassificationList, r2);
  }, proto.mediapipe.ClassificationListCollection.prototype.clearClassificationListList = function() {
    return this.setClassificationListList([]);
  }, r.object.extend(e, proto.mediapipe);
})(classification_pb);
var landmark_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.Landmark", null, o), r.exportSymbol("proto.mediapipe.LandmarkList", null, o), r.exportSymbol("proto.mediapipe.LandmarkListCollection", null, o), r.exportSymbol("proto.mediapipe.NormalizedLandmark", null, o), r.exportSymbol("proto.mediapipe.NormalizedLandmarkList", null, o), r.exportSymbol("proto.mediapipe.NormalizedLandmarkListCollection", null, o), proto.mediapipe.Landmark = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.Landmark, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.Landmark.displayName = "proto.mediapipe.Landmark"), proto.mediapipe.LandmarkList = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.LandmarkList.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.LandmarkList, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.LandmarkList.displayName = "proto.mediapipe.LandmarkList"), proto.mediapipe.LandmarkListCollection = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.LandmarkListCollection.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.LandmarkListCollection, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.LandmarkListCollection.displayName = "proto.mediapipe.LandmarkListCollection"), proto.mediapipe.NormalizedLandmark = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.NormalizedLandmark, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.NormalizedLandmark.displayName = "proto.mediapipe.NormalizedLandmark"), proto.mediapipe.NormalizedLandmarkList = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.NormalizedLandmarkList.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.NormalizedLandmarkList, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.NormalizedLandmarkList.displayName = "proto.mediapipe.NormalizedLandmarkList"), proto.mediapipe.NormalizedLandmarkListCollection = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.NormalizedLandmarkListCollection.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.NormalizedLandmarkListCollection, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.NormalizedLandmarkListCollection.displayName = "proto.mediapipe.NormalizedLandmarkListCollection"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.Landmark.prototype.toObject = function(e2) {
    return proto.mediapipe.Landmark.toObject(e2, this);
  }, proto.mediapipe.Landmark.toObject = function(e2, r2) {
    var o2, i = { x: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 1)) ? void 0 : o2, y: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 2)) ? void 0 : o2, z: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 3)) ? void 0 : o2, visibility: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 4)) ? void 0 : o2, presence: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 5)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.Landmark.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.Landmark();
    return proto.mediapipe.Landmark.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.Landmark.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readFloat();
          e2.setX(r2);
          break;
        case 2:
          r2 = t2.readFloat();
          e2.setY(r2);
          break;
        case 3:
          r2 = t2.readFloat();
          e2.setZ(r2);
          break;
        case 4:
          r2 = t2.readFloat();
          e2.setVisibility(r2);
          break;
        case 5:
          r2 = t2.readFloat();
          e2.setPresence(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.Landmark.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.Landmark.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.Landmark.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeFloat(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeFloat(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeFloat(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeFloat(4, o2), null != (o2 = t.Message.getField(e2, 5)) && r2.writeFloat(5, o2);
  }, proto.mediapipe.Landmark.prototype.getX = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.Landmark.prototype.setX = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.Landmark.prototype.clearX = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.Landmark.prototype.hasX = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.Landmark.prototype.getY = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.Landmark.prototype.setY = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.Landmark.prototype.clearY = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.Landmark.prototype.hasY = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.Landmark.prototype.getZ = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.Landmark.prototype.setZ = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.Landmark.prototype.clearZ = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.Landmark.prototype.hasZ = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.Landmark.prototype.getVisibility = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.Landmark.prototype.setVisibility = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.Landmark.prototype.clearVisibility = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.Landmark.prototype.hasVisibility = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.Landmark.prototype.getPresence = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 5, 0);
  }, proto.mediapipe.Landmark.prototype.setPresence = function(e2) {
    return t.Message.setField(this, 5, e2);
  }, proto.mediapipe.Landmark.prototype.clearPresence = function() {
    return t.Message.setField(this, 5, void 0);
  }, proto.mediapipe.Landmark.prototype.hasPresence = function() {
    return null != t.Message.getField(this, 5);
  }, proto.mediapipe.LandmarkList.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.LandmarkList.prototype.toObject = function(e2) {
    return proto.mediapipe.LandmarkList.toObject(e2, this);
  }, proto.mediapipe.LandmarkList.toObject = function(e2, r2) {
    var o2 = { landmarkList: t.Message.toObjectList(r2.getLandmarkList(), proto.mediapipe.Landmark.toObject, e2) };
    return e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.LandmarkList.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.LandmarkList();
    return proto.mediapipe.LandmarkList.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.LandmarkList.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new proto.mediapipe.Landmark();
        t2.readMessage(r2, proto.mediapipe.Landmark.deserializeBinaryFromReader), e2.addLandmark(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.LandmarkList.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.LandmarkList.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.LandmarkList.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    (r2 = e2.getLandmarkList()).length > 0 && t2.writeRepeatedMessage(1, r2, proto.mediapipe.Landmark.serializeBinaryToWriter);
  }, proto.mediapipe.LandmarkList.prototype.getLandmarkList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.Landmark, 1);
  }, proto.mediapipe.LandmarkList.prototype.setLandmarkList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.LandmarkList.prototype.addLandmark = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.Landmark, r2);
  }, proto.mediapipe.LandmarkList.prototype.clearLandmarkList = function() {
    return this.setLandmarkList([]);
  }, proto.mediapipe.LandmarkListCollection.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.LandmarkListCollection.prototype.toObject = function(e2) {
    return proto.mediapipe.LandmarkListCollection.toObject(e2, this);
  }, proto.mediapipe.LandmarkListCollection.toObject = function(e2, r2) {
    var o2 = { landmarkListList: t.Message.toObjectList(r2.getLandmarkListList(), proto.mediapipe.LandmarkList.toObject, e2) };
    return e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.LandmarkListCollection.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.LandmarkListCollection();
    return proto.mediapipe.LandmarkListCollection.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.LandmarkListCollection.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new proto.mediapipe.LandmarkList();
        t2.readMessage(r2, proto.mediapipe.LandmarkList.deserializeBinaryFromReader), e2.addLandmarkList(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.LandmarkListCollection.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.LandmarkListCollection.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.LandmarkListCollection.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    (r2 = e2.getLandmarkListList()).length > 0 && t2.writeRepeatedMessage(1, r2, proto.mediapipe.LandmarkList.serializeBinaryToWriter);
  }, proto.mediapipe.LandmarkListCollection.prototype.getLandmarkListList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.LandmarkList, 1);
  }, proto.mediapipe.LandmarkListCollection.prototype.setLandmarkListList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.LandmarkListCollection.prototype.addLandmarkList = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.LandmarkList, r2);
  }, proto.mediapipe.LandmarkListCollection.prototype.clearLandmarkListList = function() {
    return this.setLandmarkListList([]);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.NormalizedLandmark.prototype.toObject = function(e2) {
    return proto.mediapipe.NormalizedLandmark.toObject(e2, this);
  }, proto.mediapipe.NormalizedLandmark.toObject = function(e2, r2) {
    var o2, i = { x: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 1)) ? void 0 : o2, y: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 2)) ? void 0 : o2, z: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 3)) ? void 0 : o2, visibility: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 4)) ? void 0 : o2, presence: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 5)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.NormalizedLandmark.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.NormalizedLandmark();
    return proto.mediapipe.NormalizedLandmark.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.NormalizedLandmark.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readFloat();
          e2.setX(r2);
          break;
        case 2:
          r2 = t2.readFloat();
          e2.setY(r2);
          break;
        case 3:
          r2 = t2.readFloat();
          e2.setZ(r2);
          break;
        case 4:
          r2 = t2.readFloat();
          e2.setVisibility(r2);
          break;
        case 5:
          r2 = t2.readFloat();
          e2.setPresence(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.NormalizedLandmark.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.NormalizedLandmark.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.NormalizedLandmark.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeFloat(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeFloat(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeFloat(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeFloat(4, o2), null != (o2 = t.Message.getField(e2, 5)) && r2.writeFloat(5, o2);
  }, proto.mediapipe.NormalizedLandmark.prototype.getX = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.NormalizedLandmark.prototype.setX = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.NormalizedLandmark.prototype.clearX = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.NormalizedLandmark.prototype.hasX = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.NormalizedLandmark.prototype.getY = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.NormalizedLandmark.prototype.setY = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.NormalizedLandmark.prototype.clearY = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.NormalizedLandmark.prototype.hasY = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.NormalizedLandmark.prototype.getZ = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.NormalizedLandmark.prototype.setZ = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.NormalizedLandmark.prototype.clearZ = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.NormalizedLandmark.prototype.hasZ = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.NormalizedLandmark.prototype.getVisibility = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.NormalizedLandmark.prototype.setVisibility = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.NormalizedLandmark.prototype.clearVisibility = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.NormalizedLandmark.prototype.hasVisibility = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.NormalizedLandmark.prototype.getPresence = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 5, 0);
  }, proto.mediapipe.NormalizedLandmark.prototype.setPresence = function(e2) {
    return t.Message.setField(this, 5, e2);
  }, proto.mediapipe.NormalizedLandmark.prototype.clearPresence = function() {
    return t.Message.setField(this, 5, void 0);
  }, proto.mediapipe.NormalizedLandmark.prototype.hasPresence = function() {
    return null != t.Message.getField(this, 5);
  }, proto.mediapipe.NormalizedLandmarkList.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.NormalizedLandmarkList.prototype.toObject = function(e2) {
    return proto.mediapipe.NormalizedLandmarkList.toObject(e2, this);
  }, proto.mediapipe.NormalizedLandmarkList.toObject = function(e2, r2) {
    var o2 = { landmarkList: t.Message.toObjectList(r2.getLandmarkList(), proto.mediapipe.NormalizedLandmark.toObject, e2) };
    return e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.NormalizedLandmarkList.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.NormalizedLandmarkList();
    return proto.mediapipe.NormalizedLandmarkList.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.NormalizedLandmarkList.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new proto.mediapipe.NormalizedLandmark();
        t2.readMessage(r2, proto.mediapipe.NormalizedLandmark.deserializeBinaryFromReader), e2.addLandmark(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.NormalizedLandmarkList.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.NormalizedLandmarkList.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.NormalizedLandmarkList.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    (r2 = e2.getLandmarkList()).length > 0 && t2.writeRepeatedMessage(1, r2, proto.mediapipe.NormalizedLandmark.serializeBinaryToWriter);
  }, proto.mediapipe.NormalizedLandmarkList.prototype.getLandmarkList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.NormalizedLandmark, 1);
  }, proto.mediapipe.NormalizedLandmarkList.prototype.setLandmarkList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.NormalizedLandmarkList.prototype.addLandmark = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.NormalizedLandmark, r2);
  }, proto.mediapipe.NormalizedLandmarkList.prototype.clearLandmarkList = function() {
    return this.setLandmarkList([]);
  }, proto.mediapipe.NormalizedLandmarkListCollection.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.NormalizedLandmarkListCollection.prototype.toObject = function(e2) {
    return proto.mediapipe.NormalizedLandmarkListCollection.toObject(e2, this);
  }, proto.mediapipe.NormalizedLandmarkListCollection.toObject = function(e2, r2) {
    var o2 = { landmarkListList: t.Message.toObjectList(r2.getLandmarkListList(), proto.mediapipe.NormalizedLandmarkList.toObject, e2) };
    return e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.NormalizedLandmarkListCollection.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.NormalizedLandmarkListCollection();
    return proto.mediapipe.NormalizedLandmarkListCollection.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.NormalizedLandmarkListCollection.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new proto.mediapipe.NormalizedLandmarkList();
        t2.readMessage(r2, proto.mediapipe.NormalizedLandmarkList.deserializeBinaryFromReader), e2.addLandmarkList(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.NormalizedLandmarkListCollection.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.NormalizedLandmarkListCollection.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.NormalizedLandmarkListCollection.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    (r2 = e2.getLandmarkListList()).length > 0 && t2.writeRepeatedMessage(1, r2, proto.mediapipe.NormalizedLandmarkList.serializeBinaryToWriter);
  }, proto.mediapipe.NormalizedLandmarkListCollection.prototype.getLandmarkListList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.NormalizedLandmarkList, 1);
  }, proto.mediapipe.NormalizedLandmarkListCollection.prototype.setLandmarkListList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.NormalizedLandmarkListCollection.prototype.addLandmarkList = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.NormalizedLandmarkList, r2);
  }, proto.mediapipe.NormalizedLandmarkListCollection.prototype.clearLandmarkListList = function() {
    return this.setLandmarkListList([]);
  }, r.object.extend(e, proto.mediapipe);
})(landmark_pb);
var face_geometry_pb = {};
var matrix_data_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.MatrixData", null, o), r.exportSymbol("proto.mediapipe.MatrixData.Layout", null, o), proto.mediapipe.MatrixData = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.MatrixData.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.MatrixData, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.MatrixData.displayName = "proto.mediapipe.MatrixData"), proto.mediapipe.MatrixData.repeatedFields_ = [3], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.MatrixData.prototype.toObject = function(e2) {
    return proto.mediapipe.MatrixData.toObject(e2, this);
  }, proto.mediapipe.MatrixData.toObject = function(e2, r2) {
    var o2, i = { rows: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, cols: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, packedDataList: null == (o2 = t.Message.getRepeatedFloatingPointField(r2, 3)) ? void 0 : o2, layout: t.Message.getFieldWithDefault(r2, 4, 0) };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.MatrixData.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.MatrixData();
    return proto.mediapipe.MatrixData.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.MatrixData.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readInt32();
          e2.setRows(r2);
          break;
        case 2:
          r2 = t2.readInt32();
          e2.setCols(r2);
          break;
        case 3:
          for (var o2 = t2.isDelimited() ? t2.readPackedFloat() : [t2.readFloat()], i = 0; i < o2.length; i++) e2.addPackedData(o2[i]);
          break;
        case 4:
          r2 = t2.readEnum();
          e2.setLayout(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.MatrixData.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.MatrixData.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.MatrixData.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeInt32(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeInt32(2, o2), (o2 = e2.getPackedDataList()).length > 0 && r2.writePackedFloat(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeEnum(4, o2);
  }, proto.mediapipe.MatrixData.Layout = { COLUMN_MAJOR: 0, ROW_MAJOR: 1 }, proto.mediapipe.MatrixData.prototype.getRows = function() {
    return t.Message.getFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.MatrixData.prototype.setRows = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.MatrixData.prototype.clearRows = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.MatrixData.prototype.hasRows = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.MatrixData.prototype.getCols = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.MatrixData.prototype.setCols = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.MatrixData.prototype.clearCols = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.MatrixData.prototype.hasCols = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.MatrixData.prototype.getPackedDataList = function() {
    return t.Message.getRepeatedFloatingPointField(this, 3);
  }, proto.mediapipe.MatrixData.prototype.setPackedDataList = function(e2) {
    return t.Message.setField(this, 3, e2 || []);
  }, proto.mediapipe.MatrixData.prototype.addPackedData = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 3, e2, r2);
  }, proto.mediapipe.MatrixData.prototype.clearPackedDataList = function() {
    return this.setPackedDataList([]);
  }, proto.mediapipe.MatrixData.prototype.getLayout = function() {
    return t.Message.getFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.MatrixData.prototype.setLayout = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.MatrixData.prototype.clearLayout = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.MatrixData.prototype.hasLayout = function() {
    return null != t.Message.getField(this, 4);
  }, r.object.extend(e, proto.mediapipe);
})(matrix_data_pb);
var mesh_3d_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d", null, o), r.exportSymbol("proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.PrimitiveType", null, o), r.exportSymbol("proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.VertexType", null, o), proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.displayName = "proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d"), proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.repeatedFields_ = [3, 4], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.toObject = function(e2, r2) {
    var o2, i = { vertexType: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, primitiveType: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, vertexBufferList: null == (o2 = t.Message.getRepeatedFloatingPointField(r2, 3)) ? void 0 : o2, indexBufferList: null == (o2 = t.Message.getRepeatedField(r2, 4)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d();
    return proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readEnum();
          e2.setVertexType(r2);
          break;
        case 2:
          r2 = t2.readEnum();
          e2.setPrimitiveType(r2);
          break;
        case 3:
          for (var o2 = t2.isDelimited() ? t2.readPackedFloat() : [t2.readFloat()], i = 0; i < o2.length; i++) e2.addVertexBuffer(o2[i]);
          break;
        case 4:
          for (o2 = t2.isDelimited() ? t2.readPackedUint32() : [t2.readUint32()], i = 0; i < o2.length; i++) e2.addIndexBuffer(o2[i]);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeEnum(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeEnum(2, o2), (o2 = e2.getVertexBufferList()).length > 0 && r2.writeRepeatedFloat(3, o2), (o2 = e2.getIndexBufferList()).length > 0 && r2.writeRepeatedUint32(4, o2);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.VertexType = { VERTEX_PT: 0 }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.PrimitiveType = { TRIANGLE: 0 }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.getVertexType = function() {
    return t.Message.getFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.setVertexType = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.clearVertexType = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.hasVertexType = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.getPrimitiveType = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.setPrimitiveType = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.clearPrimitiveType = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.hasPrimitiveType = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.getVertexBufferList = function() {
    return t.Message.getRepeatedFloatingPointField(this, 3);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.setVertexBufferList = function(e2) {
    return t.Message.setField(this, 3, e2 || []);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.addVertexBuffer = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 3, e2, r2);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.clearVertexBufferList = function() {
    return this.setVertexBufferList([]);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.getIndexBufferList = function() {
    return t.Message.getRepeatedField(this, 4);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.setIndexBufferList = function(e2) {
    return t.Message.setField(this, 4, e2 || []);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.addIndexBuffer = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 4, e2, r2);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.Mesh3d.prototype.clearIndexBufferList = function() {
    return this.setIndexBufferList([]);
  }, r.object.extend(e, proto.mediapipe.tasks.vision.face_geometry.proto);
})(mesh_3d_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = matrix_data_pb;
  r.object.extend(proto, i);
  var a2 = mesh_3d_pb;
  r.object.extend(proto, a2), r.exportSymbol("proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry", null, o), proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.displayName = "proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.toObject = function(e2, t2) {
    var r2, o2 = { mesh: (r2 = t2.getMesh()) && a2.Mesh3d.toObject(e2, r2), poseTransformMatrix: (r2 = t2.getPoseTransformMatrix()) && i.MatrixData.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry();
    return proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new a2.Mesh3d();
          t2.readMessage(r2, a2.Mesh3d.deserializeBinaryFromReader), e2.setMesh(r2);
          break;
        case 2:
          r2 = new i.MatrixData();
          t2.readMessage(r2, i.MatrixData.deserializeBinaryFromReader), e2.setPoseTransformMatrix(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    null != (r2 = e2.getMesh()) && t2.writeMessage(1, r2, a2.Mesh3d.serializeBinaryToWriter), null != (r2 = e2.getPoseTransformMatrix()) && t2.writeMessage(2, r2, i.MatrixData.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.getMesh = function() {
    return t.Message.getWrapperField(this, a2.Mesh3d, 1);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.setMesh = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.clearMesh = function() {
    return this.setMesh(void 0);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.hasMesh = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.getPoseTransformMatrix = function() {
    return t.Message.getWrapperField(this, i.MatrixData, 2);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.setPoseTransformMatrix = function(e2) {
    return t.Message.setWrapperField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.clearPoseTransformMatrix = function() {
    return this.setPoseTransformMatrix(void 0);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometry.prototype.hasPoseTransformMatrix = function() {
    return null != t.Message.getField(this, 2);
  }, r.object.extend(e, proto.mediapipe.tasks.vision.face_geometry.proto);
})(face_geometry_pb);
var face_landmarker_graph_options_pb = {};
var face_geometry_graph_options_pb = {};
var geometry_pipeline_calculator_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_options_pb;
  r.object.extend(proto, i);
  var a2 = external_file_pb;
  r.object.extend(proto, a2), r.exportSymbol("proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions", null, o), proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.displayName = "proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.toObject = function(e2, t2) {
    var r2, o2 = { metadataFile: (r2 = t2.getMetadataFile()) && a2.ExternalFile.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions();
    return proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new a2.ExternalFile();
        t2.readMessage(r2, a2.ExternalFile.deserializeBinaryFromReader), e2.setMetadataFile(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    null != (r2 = e2.getMetadataFile()) && t2.writeMessage(1, r2, a2.ExternalFile.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.ext = new t.ExtensionFieldInfo(512499200, { ext: 0 }, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.toObject, 0), i.CalculatorOptions.extensionsBinary[512499200] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.deserializeBinaryFromReader, false), i.CalculatorOptions.extensions[512499200] = proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.ext, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.prototype.getMetadataFile = function() {
    return t.Message.getWrapperField(this, a2.ExternalFile, 1);
  }, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.prototype.setMetadataFile = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.prototype.clearMetadataFile = function() {
    return this.setMetadataFile(void 0);
  }, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.prototype.hasMetadataFile = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.ext = new t.ExtensionFieldInfo(512499200, { ext: 0 }, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.toObject, 0), i.CalculatorOptions.extensionsBinary[512499200] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.deserializeBinaryFromReader, false), i.CalculatorOptions.extensions[512499200] = proto.mediapipe.tasks.vision.face_geometry.FaceGeometryPipelineCalculatorOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.face_geometry);
})(geometry_pipeline_calculator_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_options_pb;
  r.object.extend(proto, i);
  var a2 = geometry_pipeline_calculator_pb;
  r.object.extend(proto, a2), r.exportSymbol("proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions", null, o), proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.displayName = "proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.toObject = function(e2, t2) {
    var r2, o2 = { geometryPipelineOptions: (r2 = t2.getGeometryPipelineOptions()) && a2.FaceGeometryPipelineCalculatorOptions.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions();
    return proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new a2.FaceGeometryPipelineCalculatorOptions();
        t2.readMessage(r2, a2.FaceGeometryPipelineCalculatorOptions.deserializeBinaryFromReader), e2.setGeometryPipelineOptions(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    null != (r2 = e2.getGeometryPipelineOptions()) && t2.writeMessage(1, r2, a2.FaceGeometryPipelineCalculatorOptions.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.ext = new t.ExtensionFieldInfo(515723506, { ext: 0 }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.toObject, 0), i.CalculatorOptions.extensionsBinary[515723506] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.deserializeBinaryFromReader, false), i.CalculatorOptions.extensions[515723506] = proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.ext, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.prototype.getGeometryPipelineOptions = function() {
    return t.Message.getWrapperField(this, a2.FaceGeometryPipelineCalculatorOptions, 1);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.prototype.setGeometryPipelineOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.prototype.clearGeometryPipelineOptions = function() {
    return this.setGeometryPipelineOptions(void 0);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.prototype.hasGeometryPipelineOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.ext = new t.ExtensionFieldInfo(515723506, { ext: 0 }, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.toObject, 0), i.CalculatorOptions.extensionsBinary[515723506] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.deserializeBinaryFromReader, false), i.CalculatorOptions.extensions[515723506] = proto.mediapipe.tasks.vision.face_geometry.proto.FaceGeometryGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.face_geometry.proto);
})(face_geometry_graph_options_pb);
var face_landmarks_detector_graph_options_pb = {};
var face_blendshapes_graph_options_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = base_options_pb;
  r.object.extend(proto, n), r.exportSymbol("proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions", null, o), proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.displayName = "proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.toObject = function(e2, t2) {
    var r2, o2 = { baseOptions: (r2 = t2.getBaseOptions()) && n.BaseOptions.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions();
    return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new n.BaseOptions();
        t2.readMessage(r2, n.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    null != (r2 = e2.getBaseOptions()) && t2.writeMessage(1, r2, n.BaseOptions.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.ext = new t.ExtensionFieldInfo(508981768, { ext: 0 }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[508981768] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[508981768] = proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.ext, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, n.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.ext = new t.ExtensionFieldInfo(508981768, { ext: 0 }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[508981768] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[508981768] = proto.mediapipe.tasks.vision.face_landmarker.proto.FaceBlendshapesGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.face_landmarker.proto);
})(face_blendshapes_graph_options_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = base_options_pb;
  r.object.extend(proto, n);
  var s = face_blendshapes_graph_options_pb;
  r.object.extend(proto, s), r.exportSymbol("proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions", null, o), proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.displayName = "proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.toObject = function(e2, r2) {
    var o2, i2 = { baseOptions: (o2 = r2.getBaseOptions()) && n.BaseOptions.toObject(e2, o2), minDetectionConfidence: t.Message.getFloatingPointFieldWithDefault(r2, 2, 0.5), smoothLandmarks: null == (o2 = t.Message.getBooleanField(r2, 4)) ? void 0 : o2, faceBlendshapesGraphOptions: (o2 = r2.getFaceBlendshapesGraphOptions()) && s.FaceBlendshapesGraphOptions.toObject(e2, o2) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions();
    return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new n.BaseOptions();
          t2.readMessage(r2, n.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
          break;
        case 2:
          r2 = t2.readFloat();
          e2.setMinDetectionConfidence(r2);
          break;
        case 4:
          r2 = t2.readBool();
          e2.setSmoothLandmarks(r2);
          break;
        case 3:
          r2 = new s.FaceBlendshapesGraphOptions();
          t2.readMessage(r2, s.FaceBlendshapesGraphOptions.deserializeBinaryFromReader), e2.setFaceBlendshapesGraphOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getBaseOptions()) && r2.writeMessage(1, o2, n.BaseOptions.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 2)) && r2.writeFloat(2, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeBool(4, o2), null != (o2 = e2.getFaceBlendshapesGraphOptions()) && r2.writeMessage(3, o2, s.FaceBlendshapesGraphOptions.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.ext = new t.ExtensionFieldInfo(508968149, { ext: 0 }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[508968149] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[508968149] = proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.ext, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, n.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.getMinDetectionConfidence = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0.5);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.setMinDetectionConfidence = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.clearMinDetectionConfidence = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.hasMinDetectionConfidence = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.getSmoothLandmarks = function() {
    return t.Message.getBooleanFieldWithDefault(this, 4, false);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.setSmoothLandmarks = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.clearSmoothLandmarks = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.hasSmoothLandmarks = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.getFaceBlendshapesGraphOptions = function() {
    return t.Message.getWrapperField(this, s.FaceBlendshapesGraphOptions, 3);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.setFaceBlendshapesGraphOptions = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.clearFaceBlendshapesGraphOptions = function() {
    return this.setFaceBlendshapesGraphOptions(void 0);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.prototype.hasFaceBlendshapesGraphOptions = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.ext = new t.ExtensionFieldInfo(508968149, { ext: 0 }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[508968149] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[508968149] = proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarksDetectorGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.face_landmarker.proto);
})(face_landmarks_detector_graph_options_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = base_options_pb;
  r.object.extend(proto, n);
  var s = face_detector_graph_options_pb;
  r.object.extend(proto, s);
  var p = face_geometry_graph_options_pb;
  r.object.extend(proto, p);
  var d = face_landmarks_detector_graph_options_pb;
  r.object.extend(proto, d), r.exportSymbol("proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions", null, o), proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.displayName = "proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.toObject = function(e2, r2) {
    var o2, i2 = { baseOptions: (o2 = r2.getBaseOptions()) && n.BaseOptions.toObject(e2, o2), faceDetectorGraphOptions: (o2 = r2.getFaceDetectorGraphOptions()) && s.FaceDetectorGraphOptions.toObject(e2, o2), faceLandmarksDetectorGraphOptions: (o2 = r2.getFaceLandmarksDetectorGraphOptions()) && d.FaceLandmarksDetectorGraphOptions.toObject(e2, o2), minTrackingConfidence: t.Message.getFloatingPointFieldWithDefault(r2, 4, 0.5), faceGeometryGraphOptions: (o2 = r2.getFaceGeometryGraphOptions()) && p.FaceGeometryGraphOptions.toObject(e2, o2) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions();
    return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new n.BaseOptions();
          t2.readMessage(r2, n.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
          break;
        case 2:
          r2 = new s.FaceDetectorGraphOptions();
          t2.readMessage(r2, s.FaceDetectorGraphOptions.deserializeBinaryFromReader), e2.setFaceDetectorGraphOptions(r2);
          break;
        case 3:
          r2 = new d.FaceLandmarksDetectorGraphOptions();
          t2.readMessage(r2, d.FaceLandmarksDetectorGraphOptions.deserializeBinaryFromReader), e2.setFaceLandmarksDetectorGraphOptions(r2);
          break;
        case 4:
          r2 = t2.readFloat();
          e2.setMinTrackingConfidence(r2);
          break;
        case 5:
          r2 = new p.FaceGeometryGraphOptions();
          t2.readMessage(r2, p.FaceGeometryGraphOptions.deserializeBinaryFromReader), e2.setFaceGeometryGraphOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getBaseOptions()) && r2.writeMessage(1, o2, n.BaseOptions.serializeBinaryToWriter), null != (o2 = e2.getFaceDetectorGraphOptions()) && r2.writeMessage(2, o2, s.FaceDetectorGraphOptions.serializeBinaryToWriter), null != (o2 = e2.getFaceLandmarksDetectorGraphOptions()) && r2.writeMessage(3, o2, d.FaceLandmarksDetectorGraphOptions.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 4)) && r2.writeFloat(4, o2), null != (o2 = e2.getFaceGeometryGraphOptions()) && r2.writeMessage(5, o2, p.FaceGeometryGraphOptions.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.ext = new t.ExtensionFieldInfo(508968150, { ext: 0 }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[508968150] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[508968150] = proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.ext, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, n.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.getFaceDetectorGraphOptions = function() {
    return t.Message.getWrapperField(this, s.FaceDetectorGraphOptions, 2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.setFaceDetectorGraphOptions = function(e2) {
    return t.Message.setWrapperField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.clearFaceDetectorGraphOptions = function() {
    return this.setFaceDetectorGraphOptions(void 0);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.hasFaceDetectorGraphOptions = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.getFaceLandmarksDetectorGraphOptions = function() {
    return t.Message.getWrapperField(this, d.FaceLandmarksDetectorGraphOptions, 3);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.setFaceLandmarksDetectorGraphOptions = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.clearFaceLandmarksDetectorGraphOptions = function() {
    return this.setFaceLandmarksDetectorGraphOptions(void 0);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.hasFaceLandmarksDetectorGraphOptions = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.getMinTrackingConfidence = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 4, 0.5);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.setMinTrackingConfidence = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.clearMinTrackingConfidence = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.hasMinTrackingConfidence = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.getFaceGeometryGraphOptions = function() {
    return t.Message.getWrapperField(this, p.FaceGeometryGraphOptions, 5);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.setFaceGeometryGraphOptions = function(e2) {
    return t.Message.setWrapperField(this, 5, e2);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.clearFaceGeometryGraphOptions = function() {
    return this.setFaceGeometryGraphOptions(void 0);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.prototype.hasFaceGeometryGraphOptions = function() {
    return null != t.Message.getField(this, 5);
  }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.ext = new t.ExtensionFieldInfo(508968150, { ext: 0 }, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[508968150] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[508968150] = proto.mediapipe.tasks.vision.face_landmarker.proto.FaceLandmarkerGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.face_landmarker.proto);
})(face_landmarker_graph_options_pb);
var classifier_result = {};
Object.defineProperty(classifier_result, "__esModule", { value: true }), classifier_result.convertFromClassificationResultProto = classifier_result.convertFromClassifications = void 0;
var DEFAULT_INDEX$1 = -1;
var DEFAULT_SCORE = 0;
function convertFromClassifications(e, t = DEFAULT_INDEX$1, r = "") {
  return { categories: e.map(((e2) => {
    var t2, r2, o, i;
    return { index: null !== (t2 = e2.getIndex()) && void 0 !== t2 ? t2 : DEFAULT_INDEX$1, score: null !== (r2 = e2.getScore()) && void 0 !== r2 ? r2 : DEFAULT_SCORE, categoryName: null !== (o = e2.getLabel()) && void 0 !== o ? o : "", displayName: null !== (i = e2.getDisplayName()) && void 0 !== i ? i : "" };
  })), headIndex: t, headName: r };
}
function convertFromClassificationsProto(e) {
  var t, r;
  return convertFromClassifications(null !== (r = null === (t = e.getClassificationList()) || void 0 === t ? void 0 : t.getClassificationList()) && void 0 !== r ? r : [], e.getHeadIndex(), e.getHeadName());
}
function convertFromClassificationResultProto(e) {
  const t = { classifications: e.getClassificationsList().map(((e2) => convertFromClassificationsProto(e2))) };
  return e.hasTimestampMs() && (t.timestampMs = e.getTimestampMs()), t;
}
classifier_result.convertFromClassifications = convertFromClassifications, classifier_result.convertFromClassificationResultProto = convertFromClassificationResultProto;
var landmark_result = {};
function convertToLandmarks(e) {
  var t, r, o;
  const i = [];
  for (const a2 of e.getLandmarkList()) i.push({ x: null !== (t = a2.getX()) && void 0 !== t ? t : 0, y: null !== (r = a2.getY()) && void 0 !== r ? r : 0, z: null !== (o = a2.getZ()) && void 0 !== o ? o : 0 });
  return i;
}
function convertToWorldLandmarks(e) {
  var t, r, o;
  const i = [];
  for (const a2 of e.getLandmarkList()) i.push({ x: null !== (t = a2.getX()) && void 0 !== t ? t : 0, y: null !== (r = a2.getY()) && void 0 !== r ? r : 0, z: null !== (o = a2.getZ()) && void 0 !== o ? o : 0 });
  return i;
}
Object.defineProperty(landmark_result, "__esModule", { value: true }), landmark_result.convertToWorldLandmarks = landmark_result.convertToLandmarks = void 0, landmark_result.convertToLandmarks = convertToLandmarks, landmark_result.convertToWorldLandmarks = convertToWorldLandmarks;
var face_landmarks_connections = {};
var exports2;
exports2 = face_landmarks_connections, Object.defineProperty(exports2, "__esModule", { value: true }), exports2.FACE_LANDMARKS_TESSELATION = exports2.FACE_LANDMARKS_CONTOURS = exports2.FACE_LANDMARKS_FACE_OVAL = exports2.FACE_LANDMARKS_RIGHT_IRIS = exports2.FACE_LANDMARKS_RIGHT_EYEBROW = exports2.FACE_LANDMARKS_RIGHT_EYE = exports2.FACE_LANDMARKS_LEFT_IRIS = exports2.FACE_LANDMARKS_LEFT_EYEBROW = exports2.FACE_LANDMARKS_LEFT_EYE = exports2.FACE_LANDMARKS_LIPS = void 0, exports2.FACE_LANDMARKS_LIPS = [{ start: 61, end: 146 }, { start: 146, end: 91 }, { start: 91, end: 181 }, { start: 181, end: 84 }, { start: 84, end: 17 }, { start: 17, end: 314 }, { start: 314, end: 405 }, { start: 405, end: 321 }, { start: 321, end: 375 }, { start: 375, end: 291 }, { start: 61, end: 185 }, { start: 185, end: 40 }, { start: 40, end: 39 }, { start: 39, end: 37 }, { start: 37, end: 0 }, { start: 0, end: 267 }, { start: 267, end: 269 }, { start: 269, end: 270 }, { start: 270, end: 409 }, { start: 409, end: 291 }, { start: 78, end: 95 }, { start: 95, end: 88 }, { start: 88, end: 178 }, { start: 178, end: 87 }, { start: 87, end: 14 }, { start: 14, end: 317 }, { start: 317, end: 402 }, { start: 402, end: 318 }, { start: 318, end: 324 }, { start: 324, end: 308 }, { start: 78, end: 191 }, { start: 191, end: 80 }, { start: 80, end: 81 }, { start: 81, end: 82 }, { start: 82, end: 13 }, { start: 13, end: 312 }, { start: 312, end: 311 }, { start: 311, end: 310 }, { start: 310, end: 415 }, { start: 415, end: 308 }], exports2.FACE_LANDMARKS_LEFT_EYE = [{ start: 263, end: 249 }, { start: 249, end: 390 }, { start: 390, end: 373 }, { start: 373, end: 374 }, { start: 374, end: 380 }, { start: 380, end: 381 }, { start: 381, end: 382 }, { start: 382, end: 362 }, { start: 263, end: 466 }, { start: 466, end: 388 }, { start: 388, end: 387 }, { start: 387, end: 386 }, { start: 386, end: 385 }, { start: 385, end: 384 }, { start: 384, end: 398 }, { start: 398, end: 362 }], exports2.FACE_LANDMARKS_LEFT_EYEBROW = [{ start: 276, end: 283 }, { start: 283, end: 282 }, { start: 282, end: 295 }, { start: 295, end: 285 }, { start: 300, end: 293 }, { start: 293, end: 334 }, { start: 334, end: 296 }, { start: 296, end: 336 }], exports2.FACE_LANDMARKS_LEFT_IRIS = [{ start: 474, end: 475 }, { start: 475, end: 476 }, { start: 476, end: 477 }, { start: 477, end: 474 }], exports2.FACE_LANDMARKS_RIGHT_EYE = [{ start: 33, end: 7 }, { start: 7, end: 163 }, { start: 163, end: 144 }, { start: 144, end: 145 }, { start: 145, end: 153 }, { start: 153, end: 154 }, { start: 154, end: 155 }, { start: 155, end: 133 }, { start: 33, end: 246 }, { start: 246, end: 161 }, { start: 161, end: 160 }, { start: 160, end: 159 }, { start: 159, end: 158 }, { start: 158, end: 157 }, { start: 157, end: 173 }, { start: 173, end: 133 }], exports2.FACE_LANDMARKS_RIGHT_EYEBROW = [{ start: 46, end: 53 }, { start: 53, end: 52 }, { start: 52, end: 65 }, { start: 65, end: 55 }, { start: 70, end: 63 }, { start: 63, end: 105 }, { start: 105, end: 66 }, { start: 66, end: 107 }], exports2.FACE_LANDMARKS_RIGHT_IRIS = [{ start: 469, end: 470 }, { start: 470, end: 471 }, { start: 471, end: 472 }, { start: 472, end: 469 }], exports2.FACE_LANDMARKS_FACE_OVAL = [{ start: 10, end: 338 }, { start: 338, end: 297 }, { start: 297, end: 332 }, { start: 332, end: 284 }, { start: 284, end: 251 }, { start: 251, end: 389 }, { start: 389, end: 356 }, { start: 356, end: 454 }, { start: 454, end: 323 }, { start: 323, end: 361 }, { start: 361, end: 288 }, { start: 288, end: 397 }, { start: 397, end: 365 }, { start: 365, end: 379 }, { start: 379, end: 378 }, { start: 378, end: 400 }, { start: 400, end: 377 }, { start: 377, end: 152 }, { start: 152, end: 148 }, { start: 148, end: 176 }, { start: 176, end: 149 }, { start: 149, end: 150 }, { start: 150, end: 136 }, { start: 136, end: 172 }, { start: 172, end: 58 }, { start: 58, end: 132 }, { start: 132, end: 93 }, { start: 93, end: 234 }, { start: 234, end: 127 }, { start: 127, end: 162 }, { start: 162, end: 21 }, { start: 21, end: 54 }, { start: 54, end: 103 }, { start: 103, end: 67 }, { start: 67, end: 109 }, { start: 109, end: 10 }], exports2.FACE_LANDMARKS_CONTOURS = [...exports2.FACE_LANDMARKS_LIPS, ...exports2.FACE_LANDMARKS_LEFT_EYE, ...exports2.FACE_LANDMARKS_LEFT_EYEBROW, ...exports2.FACE_LANDMARKS_RIGHT_EYE, ...exports2.FACE_LANDMARKS_RIGHT_EYEBROW, ...exports2.FACE_LANDMARKS_FACE_OVAL], exports2.FACE_LANDMARKS_TESSELATION = [{ start: 127, end: 34 }, { start: 34, end: 139 }, { start: 139, end: 127 }, { start: 11, end: 0 }, { start: 0, end: 37 }, { start: 37, end: 11 }, { start: 232, end: 231 }, { start: 231, end: 120 }, { start: 120, end: 232 }, { start: 72, end: 37 }, { start: 37, end: 39 }, { start: 39, end: 72 }, { start: 128, end: 121 }, { start: 121, end: 47 }, { start: 47, end: 128 }, { start: 232, end: 121 }, { start: 121, end: 128 }, { start: 128, end: 232 }, { start: 104, end: 69 }, { start: 69, end: 67 }, { start: 67, end: 104 }, { start: 175, end: 171 }, { start: 171, end: 148 }, { start: 148, end: 175 }, { start: 118, end: 50 }, { start: 50, end: 101 }, { start: 101, end: 118 }, { start: 73, end: 39 }, { start: 39, end: 40 }, { start: 40, end: 73 }, { start: 9, end: 151 }, { start: 151, end: 108 }, { start: 108, end: 9 }, { start: 48, end: 115 }, { start: 115, end: 131 }, { start: 131, end: 48 }, { start: 194, end: 204 }, { start: 204, end: 211 }, { start: 211, end: 194 }, { start: 74, end: 40 }, { start: 40, end: 185 }, { start: 185, end: 74 }, { start: 80, end: 42 }, { start: 42, end: 183 }, { start: 183, end: 80 }, { start: 40, end: 92 }, { start: 92, end: 186 }, { start: 186, end: 40 }, { start: 230, end: 229 }, { start: 229, end: 118 }, { start: 118, end: 230 }, { start: 202, end: 212 }, { start: 212, end: 214 }, { start: 214, end: 202 }, { start: 83, end: 18 }, { start: 18, end: 17 }, { start: 17, end: 83 }, { start: 76, end: 61 }, { start: 61, end: 146 }, { start: 146, end: 76 }, { start: 160, end: 29 }, { start: 29, end: 30 }, { start: 30, end: 160 }, { start: 56, end: 157 }, { start: 157, end: 173 }, { start: 173, end: 56 }, { start: 106, end: 204 }, { start: 204, end: 194 }, { start: 194, end: 106 }, { start: 135, end: 214 }, { start: 214, end: 192 }, { start: 192, end: 135 }, { start: 203, end: 165 }, { start: 165, end: 98 }, { start: 98, end: 203 }, { start: 21, end: 71 }, { start: 71, end: 68 }, { start: 68, end: 21 }, { start: 51, end: 45 }, { start: 45, end: 4 }, { start: 4, end: 51 }, { start: 144, end: 24 }, { start: 24, end: 23 }, { start: 23, end: 144 }, { start: 77, end: 146 }, { start: 146, end: 91 }, { start: 91, end: 77 }, { start: 205, end: 50 }, { start: 50, end: 187 }, { start: 187, end: 205 }, { start: 201, end: 200 }, { start: 200, end: 18 }, { start: 18, end: 201 }, { start: 91, end: 106 }, { start: 106, end: 182 }, { start: 182, end: 91 }, { start: 90, end: 91 }, { start: 91, end: 181 }, { start: 181, end: 90 }, { start: 85, end: 84 }, { start: 84, end: 17 }, { start: 17, end: 85 }, { start: 206, end: 203 }, { start: 203, end: 36 }, { start: 36, end: 206 }, { start: 148, end: 171 }, { start: 171, end: 140 }, { start: 140, end: 148 }, { start: 92, end: 40 }, { start: 40, end: 39 }, { start: 39, end: 92 }, { start: 193, end: 189 }, { start: 189, end: 244 }, { start: 244, end: 193 }, { start: 159, end: 158 }, { start: 158, end: 28 }, { start: 28, end: 159 }, { start: 247, end: 246 }, { start: 246, end: 161 }, { start: 161, end: 247 }, { start: 236, end: 3 }, { start: 3, end: 196 }, { start: 196, end: 236 }, { start: 54, end: 68 }, { start: 68, end: 104 }, { start: 104, end: 54 }, { start: 193, end: 168 }, { start: 168, end: 8 }, { start: 8, end: 193 }, { start: 117, end: 228 }, { start: 228, end: 31 }, { start: 31, end: 117 }, { start: 189, end: 193 }, { start: 193, end: 55 }, { start: 55, end: 189 }, { start: 98, end: 97 }, { start: 97, end: 99 }, { start: 99, end: 98 }, { start: 126, end: 47 }, { start: 47, end: 100 }, { start: 100, end: 126 }, { start: 166, end: 79 }, { start: 79, end: 218 }, { start: 218, end: 166 }, { start: 155, end: 154 }, { start: 154, end: 26 }, { start: 26, end: 155 }, { start: 209, end: 49 }, { start: 49, end: 131 }, { start: 131, end: 209 }, { start: 135, end: 136 }, { start: 136, end: 150 }, { start: 150, end: 135 }, { start: 47, end: 126 }, { start: 126, end: 217 }, { start: 217, end: 47 }, { start: 223, end: 52 }, { start: 52, end: 53 }, { start: 53, end: 223 }, { start: 45, end: 51 }, { start: 51, end: 134 }, { start: 134, end: 45 }, { start: 211, end: 170 }, { start: 170, end: 140 }, { start: 140, end: 211 }, { start: 67, end: 69 }, { start: 69, end: 108 }, { start: 108, end: 67 }, { start: 43, end: 106 }, { start: 106, end: 91 }, { start: 91, end: 43 }, { start: 230, end: 119 }, { start: 119, end: 120 }, { start: 120, end: 230 }, { start: 226, end: 130 }, { start: 130, end: 247 }, { start: 247, end: 226 }, { start: 63, end: 53 }, { start: 53, end: 52 }, { start: 52, end: 63 }, { start: 238, end: 20 }, { start: 20, end: 242 }, { start: 242, end: 238 }, { start: 46, end: 70 }, { start: 70, end: 156 }, { start: 156, end: 46 }, { start: 78, end: 62 }, { start: 62, end: 96 }, { start: 96, end: 78 }, { start: 46, end: 53 }, { start: 53, end: 63 }, { start: 63, end: 46 }, { start: 143, end: 34 }, { start: 34, end: 227 }, { start: 227, end: 143 }, { start: 123, end: 117 }, { start: 117, end: 111 }, { start: 111, end: 123 }, { start: 44, end: 125 }, { start: 125, end: 19 }, { start: 19, end: 44 }, { start: 236, end: 134 }, { start: 134, end: 51 }, { start: 51, end: 236 }, { start: 216, end: 206 }, { start: 206, end: 205 }, { start: 205, end: 216 }, { start: 154, end: 153 }, { start: 153, end: 22 }, { start: 22, end: 154 }, { start: 39, end: 37 }, { start: 37, end: 167 }, { start: 167, end: 39 }, { start: 200, end: 201 }, { start: 201, end: 208 }, { start: 208, end: 200 }, { start: 36, end: 142 }, { start: 142, end: 100 }, { start: 100, end: 36 }, { start: 57, end: 212 }, { start: 212, end: 202 }, { start: 202, end: 57 }, { start: 20, end: 60 }, { start: 60, end: 99 }, { start: 99, end: 20 }, { start: 28, end: 158 }, { start: 158, end: 157 }, { start: 157, end: 28 }, { start: 35, end: 226 }, { start: 226, end: 113 }, { start: 113, end: 35 }, { start: 160, end: 159 }, { start: 159, end: 27 }, { start: 27, end: 160 }, { start: 204, end: 202 }, { start: 202, end: 210 }, { start: 210, end: 204 }, { start: 113, end: 225 }, { start: 225, end: 46 }, { start: 46, end: 113 }, { start: 43, end: 202 }, { start: 202, end: 204 }, { start: 204, end: 43 }, { start: 62, end: 76 }, { start: 76, end: 77 }, { start: 77, end: 62 }, { start: 137, end: 123 }, { start: 123, end: 116 }, { start: 116, end: 137 }, { start: 41, end: 38 }, { start: 38, end: 72 }, { start: 72, end: 41 }, { start: 203, end: 129 }, { start: 129, end: 142 }, { start: 142, end: 203 }, { start: 64, end: 98 }, { start: 98, end: 240 }, { start: 240, end: 64 }, { start: 49, end: 102 }, { start: 102, end: 64 }, { start: 64, end: 49 }, { start: 41, end: 73 }, { start: 73, end: 74 }, { start: 74, end: 41 }, { start: 212, end: 216 }, { start: 216, end: 207 }, { start: 207, end: 212 }, { start: 42, end: 74 }, { start: 74, end: 184 }, { start: 184, end: 42 }, { start: 169, end: 170 }, { start: 170, end: 211 }, { start: 211, end: 169 }, { start: 170, end: 149 }, { start: 149, end: 176 }, { start: 176, end: 170 }, { start: 105, end: 66 }, { start: 66, end: 69 }, { start: 69, end: 105 }, { start: 122, end: 6 }, { start: 6, end: 168 }, { start: 168, end: 122 }, { start: 123, end: 147 }, { start: 147, end: 187 }, { start: 187, end: 123 }, { start: 96, end: 77 }, { start: 77, end: 90 }, { start: 90, end: 96 }, { start: 65, end: 55 }, { start: 55, end: 107 }, { start: 107, end: 65 }, { start: 89, end: 90 }, { start: 90, end: 180 }, { start: 180, end: 89 }, { start: 101, end: 100 }, { start: 100, end: 120 }, { start: 120, end: 101 }, { start: 63, end: 105 }, { start: 105, end: 104 }, { start: 104, end: 63 }, { start: 93, end: 137 }, { start: 137, end: 227 }, { start: 227, end: 93 }, { start: 15, end: 86 }, { start: 86, end: 85 }, { start: 85, end: 15 }, { start: 129, end: 102 }, { start: 102, end: 49 }, { start: 49, end: 129 }, { start: 14, end: 87 }, { start: 87, end: 86 }, { start: 86, end: 14 }, { start: 55, end: 8 }, { start: 8, end: 9 }, { start: 9, end: 55 }, { start: 100, end: 47 }, { start: 47, end: 121 }, { start: 121, end: 100 }, { start: 145, end: 23 }, { start: 23, end: 22 }, { start: 22, end: 145 }, { start: 88, end: 89 }, { start: 89, end: 179 }, { start: 179, end: 88 }, { start: 6, end: 122 }, { start: 122, end: 196 }, { start: 196, end: 6 }, { start: 88, end: 95 }, { start: 95, end: 96 }, { start: 96, end: 88 }, { start: 138, end: 172 }, { start: 172, end: 136 }, { start: 136, end: 138 }, { start: 215, end: 58 }, { start: 58, end: 172 }, { start: 172, end: 215 }, { start: 115, end: 48 }, { start: 48, end: 219 }, { start: 219, end: 115 }, { start: 42, end: 80 }, { start: 80, end: 81 }, { start: 81, end: 42 }, { start: 195, end: 3 }, { start: 3, end: 51 }, { start: 51, end: 195 }, { start: 43, end: 146 }, { start: 146, end: 61 }, { start: 61, end: 43 }, { start: 171, end: 175 }, { start: 175, end: 199 }, { start: 199, end: 171 }, { start: 81, end: 82 }, { start: 82, end: 38 }, { start: 38, end: 81 }, { start: 53, end: 46 }, { start: 46, end: 225 }, { start: 225, end: 53 }, { start: 144, end: 163 }, { start: 163, end: 110 }, { start: 110, end: 144 }, { start: 52, end: 65 }, { start: 65, end: 66 }, { start: 66, end: 52 }, { start: 229, end: 228 }, { start: 228, end: 117 }, { start: 117, end: 229 }, { start: 34, end: 127 }, { start: 127, end: 234 }, { start: 234, end: 34 }, { start: 107, end: 108 }, { start: 108, end: 69 }, { start: 69, end: 107 }, { start: 109, end: 108 }, { start: 108, end: 151 }, { start: 151, end: 109 }, { start: 48, end: 64 }, { start: 64, end: 235 }, { start: 235, end: 48 }, { start: 62, end: 78 }, { start: 78, end: 191 }, { start: 191, end: 62 }, { start: 129, end: 209 }, { start: 209, end: 126 }, { start: 126, end: 129 }, { start: 111, end: 35 }, { start: 35, end: 143 }, { start: 143, end: 111 }, { start: 117, end: 123 }, { start: 123, end: 50 }, { start: 50, end: 117 }, { start: 222, end: 65 }, { start: 65, end: 52 }, { start: 52, end: 222 }, { start: 19, end: 125 }, { start: 125, end: 141 }, { start: 141, end: 19 }, { start: 221, end: 55 }, { start: 55, end: 65 }, { start: 65, end: 221 }, { start: 3, end: 195 }, { start: 195, end: 197 }, { start: 197, end: 3 }, { start: 25, end: 7 }, { start: 7, end: 33 }, { start: 33, end: 25 }, { start: 220, end: 237 }, { start: 237, end: 44 }, { start: 44, end: 220 }, { start: 70, end: 71 }, { start: 71, end: 139 }, { start: 139, end: 70 }, { start: 122, end: 193 }, { start: 193, end: 245 }, { start: 245, end: 122 }, { start: 247, end: 130 }, { start: 130, end: 33 }, { start: 33, end: 247 }, { start: 71, end: 21 }, { start: 21, end: 162 }, { start: 162, end: 71 }, { start: 170, end: 169 }, { start: 169, end: 150 }, { start: 150, end: 170 }, { start: 188, end: 174 }, { start: 174, end: 196 }, { start: 196, end: 188 }, { start: 216, end: 186 }, { start: 186, end: 92 }, { start: 92, end: 216 }, { start: 2, end: 97 }, { start: 97, end: 167 }, { start: 167, end: 2 }, { start: 141, end: 125 }, { start: 125, end: 241 }, { start: 241, end: 141 }, { start: 164, end: 167 }, { start: 167, end: 37 }, { start: 37, end: 164 }, { start: 72, end: 38 }, { start: 38, end: 12 }, { start: 12, end: 72 }, { start: 38, end: 82 }, { start: 82, end: 13 }, { start: 13, end: 38 }, { start: 63, end: 68 }, { start: 68, end: 71 }, { start: 71, end: 63 }, { start: 226, end: 35 }, { start: 35, end: 111 }, { start: 111, end: 226 }, { start: 101, end: 50 }, { start: 50, end: 205 }, { start: 205, end: 101 }, { start: 206, end: 92 }, { start: 92, end: 165 }, { start: 165, end: 206 }, { start: 209, end: 198 }, { start: 198, end: 217 }, { start: 217, end: 209 }, { start: 165, end: 167 }, { start: 167, end: 97 }, { start: 97, end: 165 }, { start: 220, end: 115 }, { start: 115, end: 218 }, { start: 218, end: 220 }, { start: 133, end: 112 }, { start: 112, end: 243 }, { start: 243, end: 133 }, { start: 239, end: 238 }, { start: 238, end: 241 }, { start: 241, end: 239 }, { start: 214, end: 135 }, { start: 135, end: 169 }, { start: 169, end: 214 }, { start: 190, end: 173 }, { start: 173, end: 133 }, { start: 133, end: 190 }, { start: 171, end: 208 }, { start: 208, end: 32 }, { start: 32, end: 171 }, { start: 125, end: 44 }, { start: 44, end: 237 }, { start: 237, end: 125 }, { start: 86, end: 87 }, { start: 87, end: 178 }, { start: 178, end: 86 }, { start: 85, end: 86 }, { start: 86, end: 179 }, { start: 179, end: 85 }, { start: 84, end: 85 }, { start: 85, end: 180 }, { start: 180, end: 84 }, { start: 83, end: 84 }, { start: 84, end: 181 }, { start: 181, end: 83 }, { start: 201, end: 83 }, { start: 83, end: 182 }, { start: 182, end: 201 }, { start: 137, end: 93 }, { start: 93, end: 132 }, { start: 132, end: 137 }, { start: 76, end: 62 }, { start: 62, end: 183 }, { start: 183, end: 76 }, { start: 61, end: 76 }, { start: 76, end: 184 }, { start: 184, end: 61 }, { start: 57, end: 61 }, { start: 61, end: 185 }, { start: 185, end: 57 }, { start: 212, end: 57 }, { start: 57, end: 186 }, { start: 186, end: 212 }, { start: 214, end: 207 }, { start: 207, end: 187 }, { start: 187, end: 214 }, { start: 34, end: 143 }, { start: 143, end: 156 }, { start: 156, end: 34 }, { start: 79, end: 239 }, { start: 239, end: 237 }, { start: 237, end: 79 }, { start: 123, end: 137 }, { start: 137, end: 177 }, { start: 177, end: 123 }, { start: 44, end: 1 }, { start: 1, end: 4 }, { start: 4, end: 44 }, { start: 201, end: 194 }, { start: 194, end: 32 }, { start: 32, end: 201 }, { start: 64, end: 102 }, { start: 102, end: 129 }, { start: 129, end: 64 }, { start: 213, end: 215 }, { start: 215, end: 138 }, { start: 138, end: 213 }, { start: 59, end: 166 }, { start: 166, end: 219 }, { start: 219, end: 59 }, { start: 242, end: 99 }, { start: 99, end: 97 }, { start: 97, end: 242 }, { start: 2, end: 94 }, { start: 94, end: 141 }, { start: 141, end: 2 }, { start: 75, end: 59 }, { start: 59, end: 235 }, { start: 235, end: 75 }, { start: 24, end: 110 }, { start: 110, end: 228 }, { start: 228, end: 24 }, { start: 25, end: 130 }, { start: 130, end: 226 }, { start: 226, end: 25 }, { start: 23, end: 24 }, { start: 24, end: 229 }, { start: 229, end: 23 }, { start: 22, end: 23 }, { start: 23, end: 230 }, { start: 230, end: 22 }, { start: 26, end: 22 }, { start: 22, end: 231 }, { start: 231, end: 26 }, { start: 112, end: 26 }, { start: 26, end: 232 }, { start: 232, end: 112 }, { start: 189, end: 190 }, { start: 190, end: 243 }, { start: 243, end: 189 }, { start: 221, end: 56 }, { start: 56, end: 190 }, { start: 190, end: 221 }, { start: 28, end: 56 }, { start: 56, end: 221 }, { start: 221, end: 28 }, { start: 27, end: 28 }, { start: 28, end: 222 }, { start: 222, end: 27 }, { start: 29, end: 27 }, { start: 27, end: 223 }, { start: 223, end: 29 }, { start: 30, end: 29 }, { start: 29, end: 224 }, { start: 224, end: 30 }, { start: 247, end: 30 }, { start: 30, end: 225 }, { start: 225, end: 247 }, { start: 238, end: 79 }, { start: 79, end: 20 }, { start: 20, end: 238 }, { start: 166, end: 59 }, { start: 59, end: 75 }, { start: 75, end: 166 }, { start: 60, end: 75 }, { start: 75, end: 240 }, { start: 240, end: 60 }, { start: 147, end: 177 }, { start: 177, end: 215 }, { start: 215, end: 147 }, { start: 20, end: 79 }, { start: 79, end: 166 }, { start: 166, end: 20 }, { start: 187, end: 147 }, { start: 147, end: 213 }, { start: 213, end: 187 }, { start: 112, end: 233 }, { start: 233, end: 244 }, { start: 244, end: 112 }, { start: 233, end: 128 }, { start: 128, end: 245 }, { start: 245, end: 233 }, { start: 128, end: 114 }, { start: 114, end: 188 }, { start: 188, end: 128 }, { start: 114, end: 217 }, { start: 217, end: 174 }, { start: 174, end: 114 }, { start: 131, end: 115 }, { start: 115, end: 220 }, { start: 220, end: 131 }, { start: 217, end: 198 }, { start: 198, end: 236 }, { start: 236, end: 217 }, { start: 198, end: 131 }, { start: 131, end: 134 }, { start: 134, end: 198 }, { start: 177, end: 132 }, { start: 132, end: 58 }, { start: 58, end: 177 }, { start: 143, end: 35 }, { start: 35, end: 124 }, { start: 124, end: 143 }, { start: 110, end: 163 }, { start: 163, end: 7 }, { start: 7, end: 110 }, { start: 228, end: 110 }, { start: 110, end: 25 }, { start: 25, end: 228 }, { start: 356, end: 389 }, { start: 389, end: 368 }, { start: 368, end: 356 }, { start: 11, end: 302 }, { start: 302, end: 267 }, { start: 267, end: 11 }, { start: 452, end: 350 }, { start: 350, end: 349 }, { start: 349, end: 452 }, { start: 302, end: 303 }, { start: 303, end: 269 }, { start: 269, end: 302 }, { start: 357, end: 343 }, { start: 343, end: 277 }, { start: 277, end: 357 }, { start: 452, end: 453 }, { start: 453, end: 357 }, { start: 357, end: 452 }, { start: 333, end: 332 }, { start: 332, end: 297 }, { start: 297, end: 333 }, { start: 175, end: 152 }, { start: 152, end: 377 }, { start: 377, end: 175 }, { start: 347, end: 348 }, { start: 348, end: 330 }, { start: 330, end: 347 }, { start: 303, end: 304 }, { start: 304, end: 270 }, { start: 270, end: 303 }, { start: 9, end: 336 }, { start: 336, end: 337 }, { start: 337, end: 9 }, { start: 278, end: 279 }, { start: 279, end: 360 }, { start: 360, end: 278 }, { start: 418, end: 262 }, { start: 262, end: 431 }, { start: 431, end: 418 }, { start: 304, end: 408 }, { start: 408, end: 409 }, { start: 409, end: 304 }, { start: 310, end: 415 }, { start: 415, end: 407 }, { start: 407, end: 310 }, { start: 270, end: 409 }, { start: 409, end: 410 }, { start: 410, end: 270 }, { start: 450, end: 348 }, { start: 348, end: 347 }, { start: 347, end: 450 }, { start: 422, end: 430 }, { start: 430, end: 434 }, { start: 434, end: 422 }, { start: 313, end: 314 }, { start: 314, end: 17 }, { start: 17, end: 313 }, { start: 306, end: 307 }, { start: 307, end: 375 }, { start: 375, end: 306 }, { start: 387, end: 388 }, { start: 388, end: 260 }, { start: 260, end: 387 }, { start: 286, end: 414 }, { start: 414, end: 398 }, { start: 398, end: 286 }, { start: 335, end: 406 }, { start: 406, end: 418 }, { start: 418, end: 335 }, { start: 364, end: 367 }, { start: 367, end: 416 }, { start: 416, end: 364 }, { start: 423, end: 358 }, { start: 358, end: 327 }, { start: 327, end: 423 }, { start: 251, end: 284 }, { start: 284, end: 298 }, { start: 298, end: 251 }, { start: 281, end: 5 }, { start: 5, end: 4 }, { start: 4, end: 281 }, { start: 373, end: 374 }, { start: 374, end: 253 }, { start: 253, end: 373 }, { start: 307, end: 320 }, { start: 320, end: 321 }, { start: 321, end: 307 }, { start: 425, end: 427 }, { start: 427, end: 411 }, { start: 411, end: 425 }, { start: 421, end: 313 }, { start: 313, end: 18 }, { start: 18, end: 421 }, { start: 321, end: 405 }, { start: 405, end: 406 }, { start: 406, end: 321 }, { start: 320, end: 404 }, { start: 404, end: 405 }, { start: 405, end: 320 }, { start: 315, end: 16 }, { start: 16, end: 17 }, { start: 17, end: 315 }, { start: 426, end: 425 }, { start: 425, end: 266 }, { start: 266, end: 426 }, { start: 377, end: 400 }, { start: 400, end: 369 }, { start: 369, end: 377 }, { start: 322, end: 391 }, { start: 391, end: 269 }, { start: 269, end: 322 }, { start: 417, end: 465 }, { start: 465, end: 464 }, { start: 464, end: 417 }, { start: 386, end: 257 }, { start: 257, end: 258 }, { start: 258, end: 386 }, { start: 466, end: 260 }, { start: 260, end: 388 }, { start: 388, end: 466 }, { start: 456, end: 399 }, { start: 399, end: 419 }, { start: 419, end: 456 }, { start: 284, end: 332 }, { start: 332, end: 333 }, { start: 333, end: 284 }, { start: 417, end: 285 }, { start: 285, end: 8 }, { start: 8, end: 417 }, { start: 346, end: 340 }, { start: 340, end: 261 }, { start: 261, end: 346 }, { start: 413, end: 441 }, { start: 441, end: 285 }, { start: 285, end: 413 }, { start: 327, end: 460 }, { start: 460, end: 328 }, { start: 328, end: 327 }, { start: 355, end: 371 }, { start: 371, end: 329 }, { start: 329, end: 355 }, { start: 392, end: 439 }, { start: 439, end: 438 }, { start: 438, end: 392 }, { start: 382, end: 341 }, { start: 341, end: 256 }, { start: 256, end: 382 }, { start: 429, end: 420 }, { start: 420, end: 360 }, { start: 360, end: 429 }, { start: 364, end: 394 }, { start: 394, end: 379 }, { start: 379, end: 364 }, { start: 277, end: 343 }, { start: 343, end: 437 }, { start: 437, end: 277 }, { start: 443, end: 444 }, { start: 444, end: 283 }, { start: 283, end: 443 }, { start: 275, end: 440 }, { start: 440, end: 363 }, { start: 363, end: 275 }, { start: 431, end: 262 }, { start: 262, end: 369 }, { start: 369, end: 431 }, { start: 297, end: 338 }, { start: 338, end: 337 }, { start: 337, end: 297 }, { start: 273, end: 375 }, { start: 375, end: 321 }, { start: 321, end: 273 }, { start: 450, end: 451 }, { start: 451, end: 349 }, { start: 349, end: 450 }, { start: 446, end: 342 }, { start: 342, end: 467 }, { start: 467, end: 446 }, { start: 293, end: 334 }, { start: 334, end: 282 }, { start: 282, end: 293 }, { start: 458, end: 461 }, { start: 461, end: 462 }, { start: 462, end: 458 }, { start: 276, end: 353 }, { start: 353, end: 383 }, { start: 383, end: 276 }, { start: 308, end: 324 }, { start: 324, end: 325 }, { start: 325, end: 308 }, { start: 276, end: 300 }, { start: 300, end: 293 }, { start: 293, end: 276 }, { start: 372, end: 345 }, { start: 345, end: 447 }, { start: 447, end: 372 }, { start: 352, end: 345 }, { start: 345, end: 340 }, { start: 340, end: 352 }, { start: 274, end: 1 }, { start: 1, end: 19 }, { start: 19, end: 274 }, { start: 456, end: 248 }, { start: 248, end: 281 }, { start: 281, end: 456 }, { start: 436, end: 427 }, { start: 427, end: 425 }, { start: 425, end: 436 }, { start: 381, end: 256 }, { start: 256, end: 252 }, { start: 252, end: 381 }, { start: 269, end: 391 }, { start: 391, end: 393 }, { start: 393, end: 269 }, { start: 200, end: 199 }, { start: 199, end: 428 }, { start: 428, end: 200 }, { start: 266, end: 330 }, { start: 330, end: 329 }, { start: 329, end: 266 }, { start: 287, end: 273 }, { start: 273, end: 422 }, { start: 422, end: 287 }, { start: 250, end: 462 }, { start: 462, end: 328 }, { start: 328, end: 250 }, { start: 258, end: 286 }, { start: 286, end: 384 }, { start: 384, end: 258 }, { start: 265, end: 353 }, { start: 353, end: 342 }, { start: 342, end: 265 }, { start: 387, end: 259 }, { start: 259, end: 257 }, { start: 257, end: 387 }, { start: 424, end: 431 }, { start: 431, end: 430 }, { start: 430, end: 424 }, { start: 342, end: 353 }, { start: 353, end: 276 }, { start: 276, end: 342 }, { start: 273, end: 335 }, { start: 335, end: 424 }, { start: 424, end: 273 }, { start: 292, end: 325 }, { start: 325, end: 307 }, { start: 307, end: 292 }, { start: 366, end: 447 }, { start: 447, end: 345 }, { start: 345, end: 366 }, { start: 271, end: 303 }, { start: 303, end: 302 }, { start: 302, end: 271 }, { start: 423, end: 266 }, { start: 266, end: 371 }, { start: 371, end: 423 }, { start: 294, end: 455 }, { start: 455, end: 460 }, { start: 460, end: 294 }, { start: 279, end: 278 }, { start: 278, end: 294 }, { start: 294, end: 279 }, { start: 271, end: 272 }, { start: 272, end: 304 }, { start: 304, end: 271 }, { start: 432, end: 434 }, { start: 434, end: 427 }, { start: 427, end: 432 }, { start: 272, end: 407 }, { start: 407, end: 408 }, { start: 408, end: 272 }, { start: 394, end: 430 }, { start: 430, end: 431 }, { start: 431, end: 394 }, { start: 395, end: 369 }, { start: 369, end: 400 }, { start: 400, end: 395 }, { start: 334, end: 333 }, { start: 333, end: 299 }, { start: 299, end: 334 }, { start: 351, end: 417 }, { start: 417, end: 168 }, { start: 168, end: 351 }, { start: 352, end: 280 }, { start: 280, end: 411 }, { start: 411, end: 352 }, { start: 325, end: 319 }, { start: 319, end: 320 }, { start: 320, end: 325 }, { start: 295, end: 296 }, { start: 296, end: 336 }, { start: 336, end: 295 }, { start: 319, end: 403 }, { start: 403, end: 404 }, { start: 404, end: 319 }, { start: 330, end: 348 }, { start: 348, end: 349 }, { start: 349, end: 330 }, { start: 293, end: 298 }, { start: 298, end: 333 }, { start: 333, end: 293 }, { start: 323, end: 454 }, { start: 454, end: 447 }, { start: 447, end: 323 }, { start: 15, end: 16 }, { start: 16, end: 315 }, { start: 315, end: 15 }, { start: 358, end: 429 }, { start: 429, end: 279 }, { start: 279, end: 358 }, { start: 14, end: 15 }, { start: 15, end: 316 }, { start: 316, end: 14 }, { start: 285, end: 336 }, { start: 336, end: 9 }, { start: 9, end: 285 }, { start: 329, end: 349 }, { start: 349, end: 350 }, { start: 350, end: 329 }, { start: 374, end: 380 }, { start: 380, end: 252 }, { start: 252, end: 374 }, { start: 318, end: 402 }, { start: 402, end: 403 }, { start: 403, end: 318 }, { start: 6, end: 197 }, { start: 197, end: 419 }, { start: 419, end: 6 }, { start: 318, end: 319 }, { start: 319, end: 325 }, { start: 325, end: 318 }, { start: 367, end: 364 }, { start: 364, end: 365 }, { start: 365, end: 367 }, { start: 435, end: 367 }, { start: 367, end: 397 }, { start: 397, end: 435 }, { start: 344, end: 438 }, { start: 438, end: 439 }, { start: 439, end: 344 }, { start: 272, end: 271 }, { start: 271, end: 311 }, { start: 311, end: 272 }, { start: 195, end: 5 }, { start: 5, end: 281 }, { start: 281, end: 195 }, { start: 273, end: 287 }, { start: 287, end: 291 }, { start: 291, end: 273 }, { start: 396, end: 428 }, { start: 428, end: 199 }, { start: 199, end: 396 }, { start: 311, end: 271 }, { start: 271, end: 268 }, { start: 268, end: 311 }, { start: 283, end: 444 }, { start: 444, end: 445 }, { start: 445, end: 283 }, { start: 373, end: 254 }, { start: 254, end: 339 }, { start: 339, end: 373 }, { start: 282, end: 334 }, { start: 334, end: 296 }, { start: 296, end: 282 }, { start: 449, end: 347 }, { start: 347, end: 346 }, { start: 346, end: 449 }, { start: 264, end: 447 }, { start: 447, end: 454 }, { start: 454, end: 264 }, { start: 336, end: 296 }, { start: 296, end: 299 }, { start: 299, end: 336 }, { start: 338, end: 10 }, { start: 10, end: 151 }, { start: 151, end: 338 }, { start: 278, end: 439 }, { start: 439, end: 455 }, { start: 455, end: 278 }, { start: 292, end: 407 }, { start: 407, end: 415 }, { start: 415, end: 292 }, { start: 358, end: 371 }, { start: 371, end: 355 }, { start: 355, end: 358 }, { start: 340, end: 345 }, { start: 345, end: 372 }, { start: 372, end: 340 }, { start: 346, end: 347 }, { start: 347, end: 280 }, { start: 280, end: 346 }, { start: 442, end: 443 }, { start: 443, end: 282 }, { start: 282, end: 442 }, { start: 19, end: 94 }, { start: 94, end: 370 }, { start: 370, end: 19 }, { start: 441, end: 442 }, { start: 442, end: 295 }, { start: 295, end: 441 }, { start: 248, end: 419 }, { start: 419, end: 197 }, { start: 197, end: 248 }, { start: 263, end: 255 }, { start: 255, end: 359 }, { start: 359, end: 263 }, { start: 440, end: 275 }, { start: 275, end: 274 }, { start: 274, end: 440 }, { start: 300, end: 383 }, { start: 383, end: 368 }, { start: 368, end: 300 }, { start: 351, end: 412 }, { start: 412, end: 465 }, { start: 465, end: 351 }, { start: 263, end: 467 }, { start: 467, end: 466 }, { start: 466, end: 263 }, { start: 301, end: 368 }, { start: 368, end: 389 }, { start: 389, end: 301 }, { start: 395, end: 378 }, { start: 378, end: 379 }, { start: 379, end: 395 }, { start: 412, end: 351 }, { start: 351, end: 419 }, { start: 419, end: 412 }, { start: 436, end: 426 }, { start: 426, end: 322 }, { start: 322, end: 436 }, { start: 2, end: 164 }, { start: 164, end: 393 }, { start: 393, end: 2 }, { start: 370, end: 462 }, { start: 462, end: 461 }, { start: 461, end: 370 }, { start: 164, end: 0 }, { start: 0, end: 267 }, { start: 267, end: 164 }, { start: 302, end: 11 }, { start: 11, end: 12 }, { start: 12, end: 302 }, { start: 268, end: 12 }, { start: 12, end: 13 }, { start: 13, end: 268 }, { start: 293, end: 300 }, { start: 300, end: 301 }, { start: 301, end: 293 }, { start: 446, end: 261 }, { start: 261, end: 340 }, { start: 340, end: 446 }, { start: 330, end: 266 }, { start: 266, end: 425 }, { start: 425, end: 330 }, { start: 426, end: 423 }, { start: 423, end: 391 }, { start: 391, end: 426 }, { start: 429, end: 355 }, { start: 355, end: 437 }, { start: 437, end: 429 }, { start: 391, end: 327 }, { start: 327, end: 326 }, { start: 326, end: 391 }, { start: 440, end: 457 }, { start: 457, end: 438 }, { start: 438, end: 440 }, { start: 341, end: 382 }, { start: 382, end: 362 }, { start: 362, end: 341 }, { start: 459, end: 457 }, { start: 457, end: 461 }, { start: 461, end: 459 }, { start: 434, end: 430 }, { start: 430, end: 394 }, { start: 394, end: 434 }, { start: 414, end: 463 }, { start: 463, end: 362 }, { start: 362, end: 414 }, { start: 396, end: 369 }, { start: 369, end: 262 }, { start: 262, end: 396 }, { start: 354, end: 461 }, { start: 461, end: 457 }, { start: 457, end: 354 }, { start: 316, end: 403 }, { start: 403, end: 402 }, { start: 402, end: 316 }, { start: 315, end: 404 }, { start: 404, end: 403 }, { start: 403, end: 315 }, { start: 314, end: 405 }, { start: 405, end: 404 }, { start: 404, end: 314 }, { start: 313, end: 406 }, { start: 406, end: 405 }, { start: 405, end: 313 }, { start: 421, end: 418 }, { start: 418, end: 406 }, { start: 406, end: 421 }, { start: 366, end: 401 }, { start: 401, end: 361 }, { start: 361, end: 366 }, { start: 306, end: 408 }, { start: 408, end: 407 }, { start: 407, end: 306 }, { start: 291, end: 409 }, { start: 409, end: 408 }, { start: 408, end: 291 }, { start: 287, end: 410 }, { start: 410, end: 409 }, { start: 409, end: 287 }, { start: 432, end: 436 }, { start: 436, end: 410 }, { start: 410, end: 432 }, { start: 434, end: 416 }, { start: 416, end: 411 }, { start: 411, end: 434 }, { start: 264, end: 368 }, { start: 368, end: 383 }, { start: 383, end: 264 }, { start: 309, end: 438 }, { start: 438, end: 457 }, { start: 457, end: 309 }, { start: 352, end: 376 }, { start: 376, end: 401 }, { start: 401, end: 352 }, { start: 274, end: 275 }, { start: 275, end: 4 }, { start: 4, end: 274 }, { start: 421, end: 428 }, { start: 428, end: 262 }, { start: 262, end: 421 }, { start: 294, end: 327 }, { start: 327, end: 358 }, { start: 358, end: 294 }, { start: 433, end: 416 }, { start: 416, end: 367 }, { start: 367, end: 433 }, { start: 289, end: 455 }, { start: 455, end: 439 }, { start: 439, end: 289 }, { start: 462, end: 370 }, { start: 370, end: 326 }, { start: 326, end: 462 }, { start: 2, end: 326 }, { start: 326, end: 370 }, { start: 370, end: 2 }, { start: 305, end: 460 }, { start: 460, end: 455 }, { start: 455, end: 305 }, { start: 254, end: 449 }, { start: 449, end: 448 }, { start: 448, end: 254 }, { start: 255, end: 261 }, { start: 261, end: 446 }, { start: 446, end: 255 }, { start: 253, end: 450 }, { start: 450, end: 449 }, { start: 449, end: 253 }, { start: 252, end: 451 }, { start: 451, end: 450 }, { start: 450, end: 252 }, { start: 256, end: 452 }, { start: 452, end: 451 }, { start: 451, end: 256 }, { start: 341, end: 453 }, { start: 453, end: 452 }, { start: 452, end: 341 }, { start: 413, end: 464 }, { start: 464, end: 463 }, { start: 463, end: 413 }, { start: 441, end: 413 }, { start: 413, end: 414 }, { start: 414, end: 441 }, { start: 258, end: 442 }, { start: 442, end: 441 }, { start: 441, end: 258 }, { start: 257, end: 443 }, { start: 443, end: 442 }, { start: 442, end: 257 }, { start: 259, end: 444 }, { start: 444, end: 443 }, { start: 443, end: 259 }, { start: 260, end: 445 }, { start: 445, end: 444 }, { start: 444, end: 260 }, { start: 467, end: 342 }, { start: 342, end: 445 }, { start: 445, end: 467 }, { start: 459, end: 458 }, { start: 458, end: 250 }, { start: 250, end: 459 }, { start: 289, end: 392 }, { start: 392, end: 290 }, { start: 290, end: 289 }, { start: 290, end: 328 }, { start: 328, end: 460 }, { start: 460, end: 290 }, { start: 376, end: 433 }, { start: 433, end: 435 }, { start: 435, end: 376 }, { start: 250, end: 290 }, { start: 290, end: 392 }, { start: 392, end: 250 }, { start: 411, end: 416 }, { start: 416, end: 433 }, { start: 433, end: 411 }, { start: 341, end: 463 }, { start: 463, end: 464 }, { start: 464, end: 341 }, { start: 453, end: 464 }, { start: 464, end: 465 }, { start: 465, end: 453 }, { start: 357, end: 465 }, { start: 465, end: 412 }, { start: 412, end: 357 }, { start: 343, end: 412 }, { start: 412, end: 399 }, { start: 399, end: 343 }, { start: 360, end: 363 }, { start: 363, end: 440 }, { start: 440, end: 360 }, { start: 437, end: 399 }, { start: 399, end: 456 }, { start: 456, end: 437 }, { start: 420, end: 456 }, { start: 456, end: 363 }, { start: 363, end: 420 }, { start: 401, end: 435 }, { start: 435, end: 288 }, { start: 288, end: 401 }, { start: 372, end: 383 }, { start: 383, end: 353 }, { start: 353, end: 372 }, { start: 339, end: 255 }, { start: 255, end: 249 }, { start: 249, end: 339 }, { start: 448, end: 261 }, { start: 261, end: 255 }, { start: 255, end: 448 }, { start: 133, end: 243 }, { start: 243, end: 190 }, { start: 190, end: 133 }, { start: 133, end: 155 }, { start: 155, end: 112 }, { start: 112, end: 133 }, { start: 33, end: 246 }, { start: 246, end: 247 }, { start: 247, end: 33 }, { start: 33, end: 130 }, { start: 130, end: 25 }, { start: 25, end: 33 }, { start: 398, end: 384 }, { start: 384, end: 286 }, { start: 286, end: 398 }, { start: 362, end: 398 }, { start: 398, end: 414 }, { start: 414, end: 362 }, { start: 362, end: 463 }, { start: 463, end: 341 }, { start: 341, end: 362 }, { start: 263, end: 359 }, { start: 359, end: 467 }, { start: 467, end: 263 }, { start: 263, end: 249 }, { start: 249, end: 255 }, { start: 255, end: 263 }, { start: 466, end: 467 }, { start: 467, end: 260 }, { start: 260, end: 466 }, { start: 75, end: 60 }, { start: 60, end: 166 }, { start: 166, end: 75 }, { start: 238, end: 239 }, { start: 239, end: 79 }, { start: 79, end: 238 }, { start: 162, end: 127 }, { start: 127, end: 139 }, { start: 139, end: 162 }, { start: 72, end: 11 }, { start: 11, end: 37 }, { start: 37, end: 72 }, { start: 121, end: 232 }, { start: 232, end: 120 }, { start: 120, end: 121 }, { start: 73, end: 72 }, { start: 72, end: 39 }, { start: 39, end: 73 }, { start: 114, end: 128 }, { start: 128, end: 47 }, { start: 47, end: 114 }, { start: 233, end: 232 }, { start: 232, end: 128 }, { start: 128, end: 233 }, { start: 103, end: 104 }, { start: 104, end: 67 }, { start: 67, end: 103 }, { start: 152, end: 175 }, { start: 175, end: 148 }, { start: 148, end: 152 }, { start: 119, end: 118 }, { start: 118, end: 101 }, { start: 101, end: 119 }, { start: 74, end: 73 }, { start: 73, end: 40 }, { start: 40, end: 74 }, { start: 107, end: 9 }, { start: 9, end: 108 }, { start: 108, end: 107 }, { start: 49, end: 48 }, { start: 48, end: 131 }, { start: 131, end: 49 }, { start: 32, end: 194 }, { start: 194, end: 211 }, { start: 211, end: 32 }, { start: 184, end: 74 }, { start: 74, end: 185 }, { start: 185, end: 184 }, { start: 191, end: 80 }, { start: 80, end: 183 }, { start: 183, end: 191 }, { start: 185, end: 40 }, { start: 40, end: 186 }, { start: 186, end: 185 }, { start: 119, end: 230 }, { start: 230, end: 118 }, { start: 118, end: 119 }, { start: 210, end: 202 }, { start: 202, end: 214 }, { start: 214, end: 210 }, { start: 84, end: 83 }, { start: 83, end: 17 }, { start: 17, end: 84 }, { start: 77, end: 76 }, { start: 76, end: 146 }, { start: 146, end: 77 }, { start: 161, end: 160 }, { start: 160, end: 30 }, { start: 30, end: 161 }, { start: 190, end: 56 }, { start: 56, end: 173 }, { start: 173, end: 190 }, { start: 182, end: 106 }, { start: 106, end: 194 }, { start: 194, end: 182 }, { start: 138, end: 135 }, { start: 135, end: 192 }, { start: 192, end: 138 }, { start: 129, end: 203 }, { start: 203, end: 98 }, { start: 98, end: 129 }, { start: 54, end: 21 }, { start: 21, end: 68 }, { start: 68, end: 54 }, { start: 5, end: 51 }, { start: 51, end: 4 }, { start: 4, end: 5 }, { start: 145, end: 144 }, { start: 144, end: 23 }, { start: 23, end: 145 }, { start: 90, end: 77 }, { start: 77, end: 91 }, { start: 91, end: 90 }, { start: 207, end: 205 }, { start: 205, end: 187 }, { start: 187, end: 207 }, { start: 83, end: 201 }, { start: 201, end: 18 }, { start: 18, end: 83 }, { start: 181, end: 91 }, { start: 91, end: 182 }, { start: 182, end: 181 }, { start: 180, end: 90 }, { start: 90, end: 181 }, { start: 181, end: 180 }, { start: 16, end: 85 }, { start: 85, end: 17 }, { start: 17, end: 16 }, { start: 205, end: 206 }, { start: 206, end: 36 }, { start: 36, end: 205 }, { start: 176, end: 148 }, { start: 148, end: 140 }, { start: 140, end: 176 }, { start: 165, end: 92 }, { start: 92, end: 39 }, { start: 39, end: 165 }, { start: 245, end: 193 }, { start: 193, end: 244 }, { start: 244, end: 245 }, { start: 27, end: 159 }, { start: 159, end: 28 }, { start: 28, end: 27 }, { start: 30, end: 247 }, { start: 247, end: 161 }, { start: 161, end: 30 }, { start: 174, end: 236 }, { start: 236, end: 196 }, { start: 196, end: 174 }, { start: 103, end: 54 }, { start: 54, end: 104 }, { start: 104, end: 103 }, { start: 55, end: 193 }, { start: 193, end: 8 }, { start: 8, end: 55 }, { start: 111, end: 117 }, { start: 117, end: 31 }, { start: 31, end: 111 }, { start: 221, end: 189 }, { start: 189, end: 55 }, { start: 55, end: 221 }, { start: 240, end: 98 }, { start: 98, end: 99 }, { start: 99, end: 240 }, { start: 142, end: 126 }, { start: 126, end: 100 }, { start: 100, end: 142 }, { start: 219, end: 166 }, { start: 166, end: 218 }, { start: 218, end: 219 }, { start: 112, end: 155 }, { start: 155, end: 26 }, { start: 26, end: 112 }, { start: 198, end: 209 }, { start: 209, end: 131 }, { start: 131, end: 198 }, { start: 169, end: 135 }, { start: 135, end: 150 }, { start: 150, end: 169 }, { start: 114, end: 47 }, { start: 47, end: 217 }, { start: 217, end: 114 }, { start: 224, end: 223 }, { start: 223, end: 53 }, { start: 53, end: 224 }, { start: 220, end: 45 }, { start: 45, end: 134 }, { start: 134, end: 220 }, { start: 32, end: 211 }, { start: 211, end: 140 }, { start: 140, end: 32 }, { start: 109, end: 67 }, { start: 67, end: 108 }, { start: 108, end: 109 }, { start: 146, end: 43 }, { start: 43, end: 91 }, { start: 91, end: 146 }, { start: 231, end: 230 }, { start: 230, end: 120 }, { start: 120, end: 231 }, { start: 113, end: 226 }, { start: 226, end: 247 }, { start: 247, end: 113 }, { start: 105, end: 63 }, { start: 63, end: 52 }, { start: 52, end: 105 }, { start: 241, end: 238 }, { start: 238, end: 242 }, { start: 242, end: 241 }, { start: 124, end: 46 }, { start: 46, end: 156 }, { start: 156, end: 124 }, { start: 95, end: 78 }, { start: 78, end: 96 }, { start: 96, end: 95 }, { start: 70, end: 46 }, { start: 46, end: 63 }, { start: 63, end: 70 }, { start: 116, end: 143 }, { start: 143, end: 227 }, { start: 227, end: 116 }, { start: 116, end: 123 }, { start: 123, end: 111 }, { start: 111, end: 116 }, { start: 1, end: 44 }, { start: 44, end: 19 }, { start: 19, end: 1 }, { start: 3, end: 236 }, { start: 236, end: 51 }, { start: 51, end: 3 }, { start: 207, end: 216 }, { start: 216, end: 205 }, { start: 205, end: 207 }, { start: 26, end: 154 }, { start: 154, end: 22 }, { start: 22, end: 26 }, { start: 165, end: 39 }, { start: 39, end: 167 }, { start: 167, end: 165 }, { start: 199, end: 200 }, { start: 200, end: 208 }, { start: 208, end: 199 }, { start: 101, end: 36 }, { start: 36, end: 100 }, { start: 100, end: 101 }, { start: 43, end: 57 }, { start: 57, end: 202 }, { start: 202, end: 43 }, { start: 242, end: 20 }, { start: 20, end: 99 }, { start: 99, end: 242 }, { start: 56, end: 28 }, { start: 28, end: 157 }, { start: 157, end: 56 }, { start: 124, end: 35 }, { start: 35, end: 113 }, { start: 113, end: 124 }, { start: 29, end: 160 }, { start: 160, end: 27 }, { start: 27, end: 29 }, { start: 211, end: 204 }, { start: 204, end: 210 }, { start: 210, end: 211 }, { start: 124, end: 113 }, { start: 113, end: 46 }, { start: 46, end: 124 }, { start: 106, end: 43 }, { start: 43, end: 204 }, { start: 204, end: 106 }, { start: 96, end: 62 }, { start: 62, end: 77 }, { start: 77, end: 96 }, { start: 227, end: 137 }, { start: 137, end: 116 }, { start: 116, end: 227 }, { start: 73, end: 41 }, { start: 41, end: 72 }, { start: 72, end: 73 }, { start: 36, end: 203 }, { start: 203, end: 142 }, { start: 142, end: 36 }, { start: 235, end: 64 }, { start: 64, end: 240 }, { start: 240, end: 235 }, { start: 48, end: 49 }, { start: 49, end: 64 }, { start: 64, end: 48 }, { start: 42, end: 41 }, { start: 41, end: 74 }, { start: 74, end: 42 }, { start: 214, end: 212 }, { start: 212, end: 207 }, { start: 207, end: 214 }, { start: 183, end: 42 }, { start: 42, end: 184 }, { start: 184, end: 183 }, { start: 210, end: 169 }, { start: 169, end: 211 }, { start: 211, end: 210 }, { start: 140, end: 170 }, { start: 170, end: 176 }, { start: 176, end: 140 }, { start: 104, end: 105 }, { start: 105, end: 69 }, { start: 69, end: 104 }, { start: 193, end: 122 }, { start: 122, end: 168 }, { start: 168, end: 193 }, { start: 50, end: 123 }, { start: 123, end: 187 }, { start: 187, end: 50 }, { start: 89, end: 96 }, { start: 96, end: 90 }, { start: 90, end: 89 }, { start: 66, end: 65 }, { start: 65, end: 107 }, { start: 107, end: 66 }, { start: 179, end: 89 }, { start: 89, end: 180 }, { start: 180, end: 179 }, { start: 119, end: 101 }, { start: 101, end: 120 }, { start: 120, end: 119 }, { start: 68, end: 63 }, { start: 63, end: 104 }, { start: 104, end: 68 }, { start: 234, end: 93 }, { start: 93, end: 227 }, { start: 227, end: 234 }, { start: 16, end: 15 }, { start: 15, end: 85 }, { start: 85, end: 16 }, { start: 209, end: 129 }, { start: 129, end: 49 }, { start: 49, end: 209 }, { start: 15, end: 14 }, { start: 14, end: 86 }, { start: 86, end: 15 }, { start: 107, end: 55 }, { start: 55, end: 9 }, { start: 9, end: 107 }, { start: 120, end: 100 }, { start: 100, end: 121 }, { start: 121, end: 120 }, { start: 153, end: 145 }, { start: 145, end: 22 }, { start: 22, end: 153 }, { start: 178, end: 88 }, { start: 88, end: 179 }, { start: 179, end: 178 }, { start: 197, end: 6 }, { start: 6, end: 196 }, { start: 196, end: 197 }, { start: 89, end: 88 }, { start: 88, end: 96 }, { start: 96, end: 89 }, { start: 135, end: 138 }, { start: 138, end: 136 }, { start: 136, end: 135 }, { start: 138, end: 215 }, { start: 215, end: 172 }, { start: 172, end: 138 }, { start: 218, end: 115 }, { start: 115, end: 219 }, { start: 219, end: 218 }, { start: 41, end: 42 }, { start: 42, end: 81 }, { start: 81, end: 41 }, { start: 5, end: 195 }, { start: 195, end: 51 }, { start: 51, end: 5 }, { start: 57, end: 43 }, { start: 43, end: 61 }, { start: 61, end: 57 }, { start: 208, end: 171 }, { start: 171, end: 199 }, { start: 199, end: 208 }, { start: 41, end: 81 }, { start: 81, end: 38 }, { start: 38, end: 41 }, { start: 224, end: 53 }, { start: 53, end: 225 }, { start: 225, end: 224 }, { start: 24, end: 144 }, { start: 144, end: 110 }, { start: 110, end: 24 }, { start: 105, end: 52 }, { start: 52, end: 66 }, { start: 66, end: 105 }, { start: 118, end: 229 }, { start: 229, end: 117 }, { start: 117, end: 118 }, { start: 227, end: 34 }, { start: 34, end: 234 }, { start: 234, end: 227 }, { start: 66, end: 107 }, { start: 107, end: 69 }, { start: 69, end: 66 }, { start: 10, end: 109 }, { start: 109, end: 151 }, { start: 151, end: 10 }, { start: 219, end: 48 }, { start: 48, end: 235 }, { start: 235, end: 219 }, { start: 183, end: 62 }, { start: 62, end: 191 }, { start: 191, end: 183 }, { start: 142, end: 129 }, { start: 129, end: 126 }, { start: 126, end: 142 }, { start: 116, end: 111 }, { start: 111, end: 143 }, { start: 143, end: 116 }, { start: 118, end: 117 }, { start: 117, end: 50 }, { start: 50, end: 118 }, { start: 223, end: 222 }, { start: 222, end: 52 }, { start: 52, end: 223 }, { start: 94, end: 19 }, { start: 19, end: 141 }, { start: 141, end: 94 }, { start: 222, end: 221 }, { start: 221, end: 65 }, { start: 65, end: 222 }, { start: 196, end: 3 }, { start: 3, end: 197 }, { start: 197, end: 196 }, { start: 45, end: 220 }, { start: 220, end: 44 }, { start: 44, end: 45 }, { start: 156, end: 70 }, { start: 70, end: 139 }, { start: 139, end: 156 }, { start: 188, end: 122 }, { start: 122, end: 245 }, { start: 245, end: 188 }, { start: 139, end: 71 }, { start: 71, end: 162 }, { start: 162, end: 139 }, { start: 149, end: 170 }, { start: 170, end: 150 }, { start: 150, end: 149 }, { start: 122, end: 188 }, { start: 188, end: 196 }, { start: 196, end: 122 }, { start: 206, end: 216 }, { start: 216, end: 92 }, { start: 92, end: 206 }, { start: 164, end: 2 }, { start: 2, end: 167 }, { start: 167, end: 164 }, { start: 242, end: 141 }, { start: 141, end: 241 }, { start: 241, end: 242 }, { start: 0, end: 164 }, { start: 164, end: 37 }, { start: 37, end: 0 }, { start: 11, end: 72 }, { start: 72, end: 12 }, { start: 12, end: 11 }, { start: 12, end: 38 }, { start: 38, end: 13 }, { start: 13, end: 12 }, { start: 70, end: 63 }, { start: 63, end: 71 }, { start: 71, end: 70 }, { start: 31, end: 226 }, { start: 226, end: 111 }, { start: 111, end: 31 }, { start: 36, end: 101 }, { start: 101, end: 205 }, { start: 205, end: 36 }, { start: 203, end: 206 }, { start: 206, end: 165 }, { start: 165, end: 203 }, { start: 126, end: 209 }, { start: 209, end: 217 }, { start: 217, end: 126 }, { start: 98, end: 165 }, { start: 165, end: 97 }, { start: 97, end: 98 }, { start: 237, end: 220 }, { start: 220, end: 218 }, { start: 218, end: 237 }, { start: 237, end: 239 }, { start: 239, end: 241 }, { start: 241, end: 237 }, { start: 210, end: 214 }, { start: 214, end: 169 }, { start: 169, end: 210 }, { start: 140, end: 171 }, { start: 171, end: 32 }, { start: 32, end: 140 }, { start: 241, end: 125 }, { start: 125, end: 237 }, { start: 237, end: 241 }, { start: 179, end: 86 }, { start: 86, end: 178 }, { start: 178, end: 179 }, { start: 180, end: 85 }, { start: 85, end: 179 }, { start: 179, end: 180 }, { start: 181, end: 84 }, { start: 84, end: 180 }, { start: 180, end: 181 }, { start: 182, end: 83 }, { start: 83, end: 181 }, { start: 181, end: 182 }, { start: 194, end: 201 }, { start: 201, end: 182 }, { start: 182, end: 194 }, { start: 177, end: 137 }, { start: 137, end: 132 }, { start: 132, end: 177 }, { start: 184, end: 76 }, { start: 76, end: 183 }, { start: 183, end: 184 }, { start: 185, end: 61 }, { start: 61, end: 184 }, { start: 184, end: 185 }, { start: 186, end: 57 }, { start: 57, end: 185 }, { start: 185, end: 186 }, { start: 216, end: 212 }, { start: 212, end: 186 }, { start: 186, end: 216 }, { start: 192, end: 214 }, { start: 214, end: 187 }, { start: 187, end: 192 }, { start: 139, end: 34 }, { start: 34, end: 156 }, { start: 156, end: 139 }, { start: 218, end: 79 }, { start: 79, end: 237 }, { start: 237, end: 218 }, { start: 147, end: 123 }, { start: 123, end: 177 }, { start: 177, end: 147 }, { start: 45, end: 44 }, { start: 44, end: 4 }, { start: 4, end: 45 }, { start: 208, end: 201 }, { start: 201, end: 32 }, { start: 32, end: 208 }, { start: 98, end: 64 }, { start: 64, end: 129 }, { start: 129, end: 98 }, { start: 192, end: 213 }, { start: 213, end: 138 }, { start: 138, end: 192 }, { start: 235, end: 59 }, { start: 59, end: 219 }, { start: 219, end: 235 }, { start: 141, end: 242 }, { start: 242, end: 97 }, { start: 97, end: 141 }, { start: 97, end: 2 }, { start: 2, end: 141 }, { start: 141, end: 97 }, { start: 240, end: 75 }, { start: 75, end: 235 }, { start: 235, end: 240 }, { start: 229, end: 24 }, { start: 24, end: 228 }, { start: 228, end: 229 }, { start: 31, end: 25 }, { start: 25, end: 226 }, { start: 226, end: 31 }, { start: 230, end: 23 }, { start: 23, end: 229 }, { start: 229, end: 230 }, { start: 231, end: 22 }, { start: 22, end: 230 }, { start: 230, end: 231 }, { start: 232, end: 26 }, { start: 26, end: 231 }, { start: 231, end: 232 }, { start: 233, end: 112 }, { start: 112, end: 232 }, { start: 232, end: 233 }, { start: 244, end: 189 }, { start: 189, end: 243 }, { start: 243, end: 244 }, { start: 189, end: 221 }, { start: 221, end: 190 }, { start: 190, end: 189 }, { start: 222, end: 28 }, { start: 28, end: 221 }, { start: 221, end: 222 }, { start: 223, end: 27 }, { start: 27, end: 222 }, { start: 222, end: 223 }, { start: 224, end: 29 }, { start: 29, end: 223 }, { start: 223, end: 224 }, { start: 225, end: 30 }, { start: 30, end: 224 }, { start: 224, end: 225 }, { start: 113, end: 247 }, { start: 247, end: 225 }, { start: 225, end: 113 }, { start: 99, end: 60 }, { start: 60, end: 240 }, { start: 240, end: 99 }, { start: 213, end: 147 }, { start: 147, end: 215 }, { start: 215, end: 213 }, { start: 60, end: 20 }, { start: 20, end: 166 }, { start: 166, end: 60 }, { start: 192, end: 187 }, { start: 187, end: 213 }, { start: 213, end: 192 }, { start: 243, end: 112 }, { start: 112, end: 244 }, { start: 244, end: 243 }, { start: 244, end: 233 }, { start: 233, end: 245 }, { start: 245, end: 244 }, { start: 245, end: 128 }, { start: 128, end: 188 }, { start: 188, end: 245 }, { start: 188, end: 114 }, { start: 114, end: 174 }, { start: 174, end: 188 }, { start: 134, end: 131 }, { start: 131, end: 220 }, { start: 220, end: 134 }, { start: 174, end: 217 }, { start: 217, end: 236 }, { start: 236, end: 174 }, { start: 236, end: 198 }, { start: 198, end: 134 }, { start: 134, end: 236 }, { start: 215, end: 177 }, { start: 177, end: 58 }, { start: 58, end: 215 }, { start: 156, end: 143 }, { start: 143, end: 124 }, { start: 124, end: 156 }, { start: 25, end: 110 }, { start: 110, end: 7 }, { start: 7, end: 25 }, { start: 31, end: 228 }, { start: 228, end: 25 }, { start: 25, end: 31 }, { start: 264, end: 356 }, { start: 356, end: 368 }, { start: 368, end: 264 }, { start: 0, end: 11 }, { start: 11, end: 267 }, { start: 267, end: 0 }, { start: 451, end: 452 }, { start: 452, end: 349 }, { start: 349, end: 451 }, { start: 267, end: 302 }, { start: 302, end: 269 }, { start: 269, end: 267 }, { start: 350, end: 357 }, { start: 357, end: 277 }, { start: 277, end: 350 }, { start: 350, end: 452 }, { start: 452, end: 357 }, { start: 357, end: 350 }, { start: 299, end: 333 }, { start: 333, end: 297 }, { start: 297, end: 299 }, { start: 396, end: 175 }, { start: 175, end: 377 }, { start: 377, end: 396 }, { start: 280, end: 347 }, { start: 347, end: 330 }, { start: 330, end: 280 }, { start: 269, end: 303 }, { start: 303, end: 270 }, { start: 270, end: 269 }, { start: 151, end: 9 }, { start: 9, end: 337 }, { start: 337, end: 151 }, { start: 344, end: 278 }, { start: 278, end: 360 }, { start: 360, end: 344 }, { start: 424, end: 418 }, { start: 418, end: 431 }, { start: 431, end: 424 }, { start: 270, end: 304 }, { start: 304, end: 409 }, { start: 409, end: 270 }, { start: 272, end: 310 }, { start: 310, end: 407 }, { start: 407, end: 272 }, { start: 322, end: 270 }, { start: 270, end: 410 }, { start: 410, end: 322 }, { start: 449, end: 450 }, { start: 450, end: 347 }, { start: 347, end: 449 }, { start: 432, end: 422 }, { start: 422, end: 434 }, { start: 434, end: 432 }, { start: 18, end: 313 }, { start: 313, end: 17 }, { start: 17, end: 18 }, { start: 291, end: 306 }, { start: 306, end: 375 }, { start: 375, end: 291 }, { start: 259, end: 387 }, { start: 387, end: 260 }, { start: 260, end: 259 }, { start: 424, end: 335 }, { start: 335, end: 418 }, { start: 418, end: 424 }, { start: 434, end: 364 }, { start: 364, end: 416 }, { start: 416, end: 434 }, { start: 391, end: 423 }, { start: 423, end: 327 }, { start: 327, end: 391 }, { start: 301, end: 251 }, { start: 251, end: 298 }, { start: 298, end: 301 }, { start: 275, end: 281 }, { start: 281, end: 4 }, { start: 4, end: 275 }, { start: 254, end: 373 }, { start: 373, end: 253 }, { start: 253, end: 254 }, { start: 375, end: 307 }, { start: 307, end: 321 }, { start: 321, end: 375 }, { start: 280, end: 425 }, { start: 425, end: 411 }, { start: 411, end: 280 }, { start: 200, end: 421 }, { start: 421, end: 18 }, { start: 18, end: 200 }, { start: 335, end: 321 }, { start: 321, end: 406 }, { start: 406, end: 335 }, { start: 321, end: 320 }, { start: 320, end: 405 }, { start: 405, end: 321 }, { start: 314, end: 315 }, { start: 315, end: 17 }, { start: 17, end: 314 }, { start: 423, end: 426 }, { start: 426, end: 266 }, { start: 266, end: 423 }, { start: 396, end: 377 }, { start: 377, end: 369 }, { start: 369, end: 396 }, { start: 270, end: 322 }, { start: 322, end: 269 }, { start: 269, end: 270 }, { start: 413, end: 417 }, { start: 417, end: 464 }, { start: 464, end: 413 }, { start: 385, end: 386 }, { start: 386, end: 258 }, { start: 258, end: 385 }, { start: 248, end: 456 }, { start: 456, end: 419 }, { start: 419, end: 248 }, { start: 298, end: 284 }, { start: 284, end: 333 }, { start: 333, end: 298 }, { start: 168, end: 417 }, { start: 417, end: 8 }, { start: 8, end: 168 }, { start: 448, end: 346 }, { start: 346, end: 261 }, { start: 261, end: 448 }, { start: 417, end: 413 }, { start: 413, end: 285 }, { start: 285, end: 417 }, { start: 326, end: 327 }, { start: 327, end: 328 }, { start: 328, end: 326 }, { start: 277, end: 355 }, { start: 355, end: 329 }, { start: 329, end: 277 }, { start: 309, end: 392 }, { start: 392, end: 438 }, { start: 438, end: 309 }, { start: 381, end: 382 }, { start: 382, end: 256 }, { start: 256, end: 381 }, { start: 279, end: 429 }, { start: 429, end: 360 }, { start: 360, end: 279 }, { start: 365, end: 364 }, { start: 364, end: 379 }, { start: 379, end: 365 }, { start: 355, end: 277 }, { start: 277, end: 437 }, { start: 437, end: 355 }, { start: 282, end: 443 }, { start: 443, end: 283 }, { start: 283, end: 282 }, { start: 281, end: 275 }, { start: 275, end: 363 }, { start: 363, end: 281 }, { start: 395, end: 431 }, { start: 431, end: 369 }, { start: 369, end: 395 }, { start: 299, end: 297 }, { start: 297, end: 337 }, { start: 337, end: 299 }, { start: 335, end: 273 }, { start: 273, end: 321 }, { start: 321, end: 335 }, { start: 348, end: 450 }, { start: 450, end: 349 }, { start: 349, end: 348 }, { start: 359, end: 446 }, { start: 446, end: 467 }, { start: 467, end: 359 }, { start: 283, end: 293 }, { start: 293, end: 282 }, { start: 282, end: 283 }, { start: 250, end: 458 }, { start: 458, end: 462 }, { start: 462, end: 250 }, { start: 300, end: 276 }, { start: 276, end: 383 }, { start: 383, end: 300 }, { start: 292, end: 308 }, { start: 308, end: 325 }, { start: 325, end: 292 }, { start: 283, end: 276 }, { start: 276, end: 293 }, { start: 293, end: 283 }, { start: 264, end: 372 }, { start: 372, end: 447 }, { start: 447, end: 264 }, { start: 346, end: 352 }, { start: 352, end: 340 }, { start: 340, end: 346 }, { start: 354, end: 274 }, { start: 274, end: 19 }, { start: 19, end: 354 }, { start: 363, end: 456 }, { start: 456, end: 281 }, { start: 281, end: 363 }, { start: 426, end: 436 }, { start: 436, end: 425 }, { start: 425, end: 426 }, { start: 380, end: 381 }, { start: 381, end: 252 }, { start: 252, end: 380 }, { start: 267, end: 269 }, { start: 269, end: 393 }, { start: 393, end: 267 }, { start: 421, end: 200 }, { start: 200, end: 428 }, { start: 428, end: 421 }, { start: 371, end: 266 }, { start: 266, end: 329 }, { start: 329, end: 371 }, { start: 432, end: 287 }, { start: 287, end: 422 }, { start: 422, end: 432 }, { start: 290, end: 250 }, { start: 250, end: 328 }, { start: 328, end: 290 }, { start: 385, end: 258 }, { start: 258, end: 384 }, { start: 384, end: 385 }, { start: 446, end: 265 }, { start: 265, end: 342 }, { start: 342, end: 446 }, { start: 386, end: 387 }, { start: 387, end: 257 }, { start: 257, end: 386 }, { start: 422, end: 424 }, { start: 424, end: 430 }, { start: 430, end: 422 }, { start: 445, end: 342 }, { start: 342, end: 276 }, { start: 276, end: 445 }, { start: 422, end: 273 }, { start: 273, end: 424 }, { start: 424, end: 422 }, { start: 306, end: 292 }, { start: 292, end: 307 }, { start: 307, end: 306 }, { start: 352, end: 366 }, { start: 366, end: 345 }, { start: 345, end: 352 }, { start: 268, end: 271 }, { start: 271, end: 302 }, { start: 302, end: 268 }, { start: 358, end: 423 }, { start: 423, end: 371 }, { start: 371, end: 358 }, { start: 327, end: 294 }, { start: 294, end: 460 }, { start: 460, end: 327 }, { start: 331, end: 279 }, { start: 279, end: 294 }, { start: 294, end: 331 }, { start: 303, end: 271 }, { start: 271, end: 304 }, { start: 304, end: 303 }, { start: 436, end: 432 }, { start: 432, end: 427 }, { start: 427, end: 436 }, { start: 304, end: 272 }, { start: 272, end: 408 }, { start: 408, end: 304 }, { start: 395, end: 394 }, { start: 394, end: 431 }, { start: 431, end: 395 }, { start: 378, end: 395 }, { start: 395, end: 400 }, { start: 400, end: 378 }, { start: 296, end: 334 }, { start: 334, end: 299 }, { start: 299, end: 296 }, { start: 6, end: 351 }, { start: 351, end: 168 }, { start: 168, end: 6 }, { start: 376, end: 352 }, { start: 352, end: 411 }, { start: 411, end: 376 }, { start: 307, end: 325 }, { start: 325, end: 320 }, { start: 320, end: 307 }, { start: 285, end: 295 }, { start: 295, end: 336 }, { start: 336, end: 285 }, { start: 320, end: 319 }, { start: 319, end: 404 }, { start: 404, end: 320 }, { start: 329, end: 330 }, { start: 330, end: 349 }, { start: 349, end: 329 }, { start: 334, end: 293 }, { start: 293, end: 333 }, { start: 333, end: 334 }, { start: 366, end: 323 }, { start: 323, end: 447 }, { start: 447, end: 366 }, { start: 316, end: 15 }, { start: 15, end: 315 }, { start: 315, end: 316 }, { start: 331, end: 358 }, { start: 358, end: 279 }, { start: 279, end: 331 }, { start: 317, end: 14 }, { start: 14, end: 316 }, { start: 316, end: 317 }, { start: 8, end: 285 }, { start: 285, end: 9 }, { start: 9, end: 8 }, { start: 277, end: 329 }, { start: 329, end: 350 }, { start: 350, end: 277 }, { start: 253, end: 374 }, { start: 374, end: 252 }, { start: 252, end: 253 }, { start: 319, end: 318 }, { start: 318, end: 403 }, { start: 403, end: 319 }, { start: 351, end: 6 }, { start: 6, end: 419 }, { start: 419, end: 351 }, { start: 324, end: 318 }, { start: 318, end: 325 }, { start: 325, end: 324 }, { start: 397, end: 367 }, { start: 367, end: 365 }, { start: 365, end: 397 }, { start: 288, end: 435 }, { start: 435, end: 397 }, { start: 397, end: 288 }, { start: 278, end: 344 }, { start: 344, end: 439 }, { start: 439, end: 278 }, { start: 310, end: 272 }, { start: 272, end: 311 }, { start: 311, end: 310 }, { start: 248, end: 195 }, { start: 195, end: 281 }, { start: 281, end: 248 }, { start: 375, end: 273 }, { start: 273, end: 291 }, { start: 291, end: 375 }, { start: 175, end: 396 }, { start: 396, end: 199 }, { start: 199, end: 175 }, { start: 312, end: 311 }, { start: 311, end: 268 }, { start: 268, end: 312 }, { start: 276, end: 283 }, { start: 283, end: 445 }, { start: 445, end: 276 }, { start: 390, end: 373 }, { start: 373, end: 339 }, { start: 339, end: 390 }, { start: 295, end: 282 }, { start: 282, end: 296 }, { start: 296, end: 295 }, { start: 448, end: 449 }, { start: 449, end: 346 }, { start: 346, end: 448 }, { start: 356, end: 264 }, { start: 264, end: 454 }, { start: 454, end: 356 }, { start: 337, end: 336 }, { start: 336, end: 299 }, { start: 299, end: 337 }, { start: 337, end: 338 }, { start: 338, end: 151 }, { start: 151, end: 337 }, { start: 294, end: 278 }, { start: 278, end: 455 }, { start: 455, end: 294 }, { start: 308, end: 292 }, { start: 292, end: 415 }, { start: 415, end: 308 }, { start: 429, end: 358 }, { start: 358, end: 355 }, { start: 355, end: 429 }, { start: 265, end: 340 }, { start: 340, end: 372 }, { start: 372, end: 265 }, { start: 352, end: 346 }, { start: 346, end: 280 }, { start: 280, end: 352 }, { start: 295, end: 442 }, { start: 442, end: 282 }, { start: 282, end: 295 }, { start: 354, end: 19 }, { start: 19, end: 370 }, { start: 370, end: 354 }, { start: 285, end: 441 }, { start: 441, end: 295 }, { start: 295, end: 285 }, { start: 195, end: 248 }, { start: 248, end: 197 }, { start: 197, end: 195 }, { start: 457, end: 440 }, { start: 440, end: 274 }, { start: 274, end: 457 }, { start: 301, end: 300 }, { start: 300, end: 368 }, { start: 368, end: 301 }, { start: 417, end: 351 }, { start: 351, end: 465 }, { start: 465, end: 417 }, { start: 251, end: 301 }, { start: 301, end: 389 }, { start: 389, end: 251 }, { start: 394, end: 395 }, { start: 395, end: 379 }, { start: 379, end: 394 }, { start: 399, end: 412 }, { start: 412, end: 419 }, { start: 419, end: 399 }, { start: 410, end: 436 }, { start: 436, end: 322 }, { start: 322, end: 410 }, { start: 326, end: 2 }, { start: 2, end: 393 }, { start: 393, end: 326 }, { start: 354, end: 370 }, { start: 370, end: 461 }, { start: 461, end: 354 }, { start: 393, end: 164 }, { start: 164, end: 267 }, { start: 267, end: 393 }, { start: 268, end: 302 }, { start: 302, end: 12 }, { start: 12, end: 268 }, { start: 312, end: 268 }, { start: 268, end: 13 }, { start: 13, end: 312 }, { start: 298, end: 293 }, { start: 293, end: 301 }, { start: 301, end: 298 }, { start: 265, end: 446 }, { start: 446, end: 340 }, { start: 340, end: 265 }, { start: 280, end: 330 }, { start: 330, end: 425 }, { start: 425, end: 280 }, { start: 322, end: 426 }, { start: 426, end: 391 }, { start: 391, end: 322 }, { start: 420, end: 429 }, { start: 429, end: 437 }, { start: 437, end: 420 }, { start: 393, end: 391 }, { start: 391, end: 326 }, { start: 326, end: 393 }, { start: 344, end: 440 }, { start: 440, end: 438 }, { start: 438, end: 344 }, { start: 458, end: 459 }, { start: 459, end: 461 }, { start: 461, end: 458 }, { start: 364, end: 434 }, { start: 434, end: 394 }, { start: 394, end: 364 }, { start: 428, end: 396 }, { start: 396, end: 262 }, { start: 262, end: 428 }, { start: 274, end: 354 }, { start: 354, end: 457 }, { start: 457, end: 274 }, { start: 317, end: 316 }, { start: 316, end: 402 }, { start: 402, end: 317 }, { start: 316, end: 315 }, { start: 315, end: 403 }, { start: 403, end: 316 }, { start: 315, end: 314 }, { start: 314, end: 404 }, { start: 404, end: 315 }, { start: 314, end: 313 }, { start: 313, end: 405 }, { start: 405, end: 314 }, { start: 313, end: 421 }, { start: 421, end: 406 }, { start: 406, end: 313 }, { start: 323, end: 366 }, { start: 366, end: 361 }, { start: 361, end: 323 }, { start: 292, end: 306 }, { start: 306, end: 407 }, { start: 407, end: 292 }, { start: 306, end: 291 }, { start: 291, end: 408 }, { start: 408, end: 306 }, { start: 291, end: 287 }, { start: 287, end: 409 }, { start: 409, end: 291 }, { start: 287, end: 432 }, { start: 432, end: 410 }, { start: 410, end: 287 }, { start: 427, end: 434 }, { start: 434, end: 411 }, { start: 411, end: 427 }, { start: 372, end: 264 }, { start: 264, end: 383 }, { start: 383, end: 372 }, { start: 459, end: 309 }, { start: 309, end: 457 }, { start: 457, end: 459 }, { start: 366, end: 352 }, { start: 352, end: 401 }, { start: 401, end: 366 }, { start: 1, end: 274 }, { start: 274, end: 4 }, { start: 4, end: 1 }, { start: 418, end: 421 }, { start: 421, end: 262 }, { start: 262, end: 418 }, { start: 331, end: 294 }, { start: 294, end: 358 }, { start: 358, end: 331 }, { start: 435, end: 433 }, { start: 433, end: 367 }, { start: 367, end: 435 }, { start: 392, end: 289 }, { start: 289, end: 439 }, { start: 439, end: 392 }, { start: 328, end: 462 }, { start: 462, end: 326 }, { start: 326, end: 328 }, { start: 94, end: 2 }, { start: 2, end: 370 }, { start: 370, end: 94 }, { start: 289, end: 305 }, { start: 305, end: 455 }, { start: 455, end: 289 }, { start: 339, end: 254 }, { start: 254, end: 448 }, { start: 448, end: 339 }, { start: 359, end: 255 }, { start: 255, end: 446 }, { start: 446, end: 359 }, { start: 254, end: 253 }, { start: 253, end: 449 }, { start: 449, end: 254 }, { start: 253, end: 252 }, { start: 252, end: 450 }, { start: 450, end: 253 }, { start: 252, end: 256 }, { start: 256, end: 451 }, { start: 451, end: 252 }, { start: 256, end: 341 }, { start: 341, end: 452 }, { start: 452, end: 256 }, { start: 414, end: 413 }, { start: 413, end: 463 }, { start: 463, end: 414 }, { start: 286, end: 441 }, { start: 441, end: 414 }, { start: 414, end: 286 }, { start: 286, end: 258 }, { start: 258, end: 441 }, { start: 441, end: 286 }, { start: 258, end: 257 }, { start: 257, end: 442 }, { start: 442, end: 258 }, { start: 257, end: 259 }, { start: 259, end: 443 }, { start: 443, end: 257 }, { start: 259, end: 260 }, { start: 260, end: 444 }, { start: 444, end: 259 }, { start: 260, end: 467 }, { start: 467, end: 445 }, { start: 445, end: 260 }, { start: 309, end: 459 }, { start: 459, end: 250 }, { start: 250, end: 309 }, { start: 305, end: 289 }, { start: 289, end: 290 }, { start: 290, end: 305 }, { start: 305, end: 290 }, { start: 290, end: 460 }, { start: 460, end: 305 }, { start: 401, end: 376 }, { start: 376, end: 435 }, { start: 435, end: 401 }, { start: 309, end: 250 }, { start: 250, end: 392 }, { start: 392, end: 309 }, { start: 376, end: 411 }, { start: 411, end: 433 }, { start: 433, end: 376 }, { start: 453, end: 341 }, { start: 341, end: 464 }, { start: 464, end: 453 }, { start: 357, end: 453 }, { start: 453, end: 465 }, { start: 465, end: 357 }, { start: 343, end: 357 }, { start: 357, end: 412 }, { start: 412, end: 343 }, { start: 437, end: 343 }, { start: 343, end: 399 }, { start: 399, end: 437 }, { start: 344, end: 360 }, { start: 360, end: 440 }, { start: 440, end: 344 }, { start: 420, end: 437 }, { start: 437, end: 456 }, { start: 456, end: 420 }, { start: 360, end: 420 }, { start: 420, end: 363 }, { start: 363, end: 360 }, { start: 361, end: 401 }, { start: 401, end: 288 }, { start: 288, end: 361 }, { start: 265, end: 372 }, { start: 372, end: 353 }, { start: 353, end: 265 }, { start: 390, end: 339 }, { start: 339, end: 249 }, { start: 249, end: 390 }, { start: 339, end: 448 }, { start: 448, end: 255 }, { start: 255, end: 339 }];
var face_landmarker_options = {};
Object.defineProperty(face_landmarker_options, "__esModule", { value: true });
var face_landmarker_result = {};
Object.defineProperty(face_landmarker_result, "__esModule", { value: true }), (function(e) {
  var t = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2);
    var i2 = Object.getOwnPropertyDescriptor(t2, r2);
    i2 && !("get" in i2 ? !t2.__esModule : i2.writable || i2.configurable) || (i2 = { enumerable: true, get: function() {
      return t2[r2];
    } }), Object.defineProperty(e2, o2, i2);
  } : function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2), e2[o2] = t2[r2];
  }), r = commonjsGlobal && commonjsGlobal.__exportStar || function(e2, r2) {
    for (var o2 in e2) "default" === o2 || Object.prototype.hasOwnProperty.call(r2, o2) || t(r2, e2, o2);
  };
  Object.defineProperty(e, "__esModule", { value: true }), e.FaceLandmarker = void 0;
  const o = calculator_pb, i = calculator_options_pb, a2 = classification_pb, n = landmark_pb, s = base_options_pb, p = face_detector_graph_options_pb, d = face_geometry_pb, l = face_landmarker_graph_options_pb, g = face_landmarks_detector_graph_options_pb, c = classifier_result, u = landmark_result, m = vision_task_runner, f = face_landmarks_connections;
  r(face_landmarker_options, e), r(face_landmarker_result, e);
  const h = "image_in", y = "norm_rect", b = "face_landmarks", _ = "blendshapes", O = "face_geometry", F = 0.5;
  class M extends m.VisionTaskRunner {
    static createFromOptions(e2, t2) {
      return m.VisionTaskRunner.createVisionInstance(M, e2, t2);
    }
    static createFromModelBuffer(e2, t2) {
      return m.VisionTaskRunner.createVisionInstance(M, e2, { baseOptions: { modelAssetBuffer: t2 } });
    }
    static createFromModelPath(e2, t2) {
      return m.VisionTaskRunner.createVisionInstance(M, e2, { baseOptions: { modelAssetPath: t2 } });
    }
    constructor(e2, t2) {
      super(new m.VisionGraphRunner(e2, t2), h, y, false), this.result = { faceLandmarks: [], faceBlendshapes: [], facialTransformationMatrixes: [] }, this.outputFaceBlendshapes = false, this.outputFacialTransformationMatrixes = false, this.options = new l.FaceLandmarkerGraphOptions(), this.options.setBaseOptions(new s.BaseOptions()), this.faceLandmarksDetectorGraphOptions = new g.FaceLandmarksDetectorGraphOptions(), this.options.setFaceLandmarksDetectorGraphOptions(this.faceLandmarksDetectorGraphOptions), this.faceDetectorGraphOptions = new p.FaceDetectorGraphOptions(), this.options.setFaceDetectorGraphOptions(this.faceDetectorGraphOptions), this.initDefaults();
    }
    get baseOptions() {
      return this.options.getBaseOptions();
    }
    set baseOptions(e2) {
      this.options.setBaseOptions(e2);
    }
    setOptions(e2) {
      var t2, r2, o2, i2;
      return "numFaces" in e2 && this.faceDetectorGraphOptions.setNumFaces(null !== (t2 = e2.numFaces) && void 0 !== t2 ? t2 : 1), "minFaceDetectionConfidence" in e2 && this.faceDetectorGraphOptions.setMinDetectionConfidence(null !== (r2 = e2.minFaceDetectionConfidence) && void 0 !== r2 ? r2 : F), "minTrackingConfidence" in e2 && this.options.setMinTrackingConfidence(null !== (o2 = e2.minTrackingConfidence) && void 0 !== o2 ? o2 : F), "minFacePresenceConfidence" in e2 && this.faceLandmarksDetectorGraphOptions.setMinDetectionConfidence(null !== (i2 = e2.minFacePresenceConfidence) && void 0 !== i2 ? i2 : F), "outputFaceBlendshapes" in e2 && (this.outputFaceBlendshapes = !!e2.outputFaceBlendshapes), "outputFacialTransformationMatrixes" in e2 && (this.outputFacialTransformationMatrixes = !!e2.outputFacialTransformationMatrixes), this.applyOptions(e2);
    }
    detect(e2, t2) {
      return this.resetResults(), this.processImageData(e2, t2), this.result;
    }
    detectForVideo(e2, t2, r2) {
      return this.resetResults(), this.processVideoData(e2, r2, t2), this.result;
    }
    resetResults() {
      this.result = { faceLandmarks: [], faceBlendshapes: [], facialTransformationMatrixes: [] };
    }
    initDefaults() {
      this.faceDetectorGraphOptions.setNumFaces(1), this.faceDetectorGraphOptions.setMinDetectionConfidence(F), this.faceLandmarksDetectorGraphOptions.setMinDetectionConfidence(F), this.options.setMinTrackingConfidence(F);
    }
    addJsLandmarks(e2) {
      for (const t2 of e2) {
        const e3 = n.NormalizedLandmarkList.deserializeBinary(t2);
        this.result.faceLandmarks.push((0, u.convertToLandmarks)(e3));
      }
    }
    addBlenshape(e2) {
      var t2;
      if (this.outputFaceBlendshapes) for (const r2 of e2) {
        const e3 = a2.ClassificationList.deserializeBinary(r2);
        this.result.faceBlendshapes.push((0, c.convertFromClassifications)(null !== (t2 = e3.getClassificationList()) && void 0 !== t2 ? t2 : []));
      }
    }
    addFacialTransformationMatrixes(e2) {
      var t2, r2, o2;
      if (this.outputFacialTransformationMatrixes) for (const i2 of e2) {
        const e3 = d.FaceGeometry.deserializeBinary(i2).getPoseTransformMatrix();
        e3 && this.result.facialTransformationMatrixes.push({ rows: null !== (t2 = e3.getRows()) && void 0 !== t2 ? t2 : 0, columns: null !== (r2 = e3.getCols()) && void 0 !== r2 ? r2 : 0, data: null !== (o2 = e3.getPackedDataList()) && void 0 !== o2 ? o2 : [] });
      }
    }
    refreshGraph() {
      const e2 = new o.CalculatorGraphConfig();
      e2.addInputStream(h), e2.addInputStream(y), e2.addOutputStream(b);
      const t2 = new i.CalculatorOptions();
      t2.setExtension(l.FaceLandmarkerGraphOptions.ext, this.options);
      const r2 = new o.CalculatorGraphConfig.Node();
      r2.setCalculator("mediapipe.tasks.vision.face_landmarker.FaceLandmarkerGraph"), r2.addInputStream("IMAGE:" + h), r2.addInputStream("NORM_RECT:" + y), r2.addOutputStream("NORM_LANDMARKS:" + b), r2.setOptions(t2), e2.addNode(r2), this.graphRunner.attachProtoVectorListener(b, ((e3, t3) => {
        this.addJsLandmarks(e3), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(b, ((e3) => {
        this.setLatestOutputTimestamp(e3);
      })), this.outputFaceBlendshapes && (e2.addOutputStream(_), r2.addOutputStream("BLENDSHAPES:" + _), this.graphRunner.attachProtoVectorListener(_, ((e3, t3) => {
        this.addBlenshape(e3), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(_, ((e3) => {
        this.setLatestOutputTimestamp(e3);
      }))), this.outputFacialTransformationMatrixes && (e2.addOutputStream(O), r2.addOutputStream("FACE_GEOMETRY:" + O), this.graphRunner.attachProtoVectorListener(O, ((e3, t3) => {
        this.addFacialTransformationMatrixes(e3), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(O, ((e3) => {
        this.setLatestOutputTimestamp(e3);
      })));
      const a3 = e2.serializeBinary();
      this.setGraph(new Uint8Array(a3), true);
    }
  }
  e.FaceLandmarker = M, M.FACE_LANDMARKS_LIPS = f.FACE_LANDMARKS_LIPS, M.FACE_LANDMARKS_LEFT_EYE = f.FACE_LANDMARKS_LEFT_EYE, M.FACE_LANDMARKS_LEFT_EYEBROW = f.FACE_LANDMARKS_LEFT_EYEBROW, M.FACE_LANDMARKS_LEFT_IRIS = f.FACE_LANDMARKS_LEFT_IRIS, M.FACE_LANDMARKS_RIGHT_EYE = f.FACE_LANDMARKS_RIGHT_EYE, M.FACE_LANDMARKS_RIGHT_EYEBROW = f.FACE_LANDMARKS_RIGHT_EYEBROW, M.FACE_LANDMARKS_RIGHT_IRIS = f.FACE_LANDMARKS_RIGHT_IRIS, M.FACE_LANDMARKS_FACE_OVAL = f.FACE_LANDMARKS_FACE_OVAL, M.FACE_LANDMARKS_CONTOURS = f.FACE_LANDMARKS_CONTOURS, M.FACE_LANDMARKS_TESSELATION = f.FACE_LANDMARKS_TESSELATION;
})(face_landmarker);
var face_stylizer = {};
var face_stylizer_graph_options_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = base_options_pb;
  r.object.extend(proto, n);
  var s = face_landmarker_graph_options_pb;
  r.object.extend(proto, s), r.exportSymbol("proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions", null, o), proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.displayName = "proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.toObject = function(e2, r2) {
    var o2, i2 = { baseOptions: (o2 = r2.getBaseOptions()) && n.BaseOptions.toObject(e2, o2), faceLandmarkerGraphOptions: (o2 = r2.getFaceLandmarkerGraphOptions()) && s.FaceLandmarkerGraphOptions.toObject(e2, o2), faceAlignmentSize: t.Message.getFieldWithDefault(r2, 3, 256) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions();
    return proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new n.BaseOptions();
          t2.readMessage(r2, n.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
          break;
        case 2:
          r2 = new s.FaceLandmarkerGraphOptions();
          t2.readMessage(r2, s.FaceLandmarkerGraphOptions.deserializeBinaryFromReader), e2.setFaceLandmarkerGraphOptions(r2);
          break;
        case 3:
          r2 = t2.readInt32();
          e2.setFaceAlignmentSize(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getBaseOptions()) && r2.writeMessage(1, o2, n.BaseOptions.serializeBinaryToWriter), null != (o2 = e2.getFaceLandmarkerGraphOptions()) && r2.writeMessage(2, o2, s.FaceLandmarkerGraphOptions.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 3)) && r2.writeInt32(3, o2);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.ext = new t.ExtensionFieldInfo(513916220, { ext: 0 }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[513916220] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[513916220] = proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.ext, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, n.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.getFaceLandmarkerGraphOptions = function() {
    return t.Message.getWrapperField(this, s.FaceLandmarkerGraphOptions, 2);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.setFaceLandmarkerGraphOptions = function(e2) {
    return t.Message.setWrapperField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.clearFaceLandmarkerGraphOptions = function() {
    return this.setFaceLandmarkerGraphOptions(void 0);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.hasFaceLandmarkerGraphOptions = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.getFaceAlignmentSize = function() {
    return t.Message.getFieldWithDefault(this, 3, 256);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.setFaceAlignmentSize = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.clearFaceAlignmentSize = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.prototype.hasFaceAlignmentSize = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.ext = new t.ExtensionFieldInfo(513916220, { ext: 0 }, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[513916220] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[513916220] = proto.mediapipe.tasks.vision.face_stylizer.proto.FaceStylizerGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.face_stylizer.proto);
})(face_stylizer_graph_options_pb);
var face_stylizer_options = {};
Object.defineProperty(face_stylizer_options, "__esModule", { value: true }), (function(e) {
  var t = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2);
    var i2 = Object.getOwnPropertyDescriptor(t2, r2);
    i2 && !("get" in i2 ? !t2.__esModule : i2.writable || i2.configurable) || (i2 = { enumerable: true, get: function() {
      return t2[r2];
    } }), Object.defineProperty(e2, o2, i2);
  } : function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2), e2[o2] = t2[r2];
  }), r = commonjsGlobal && commonjsGlobal.__exportStar || function(e2, r2) {
    for (var o2 in e2) "default" === o2 || Object.prototype.hasOwnProperty.call(r2, o2) || t(r2, e2, o2);
  };
  Object.defineProperty(e, "__esModule", { value: true }), e.FaceStylizer = void 0;
  const o = calculator_pb, i = calculator_options_pb, a2 = base_options_pb, n = face_stylizer_graph_options_pb, s = vision_task_runner;
  r(face_stylizer_options, e);
  const p = "image_in", d = "norm_rect", l = "stylized_image";
  class g extends s.VisionTaskRunner {
    static createFromOptions(e2, t2) {
      return s.VisionTaskRunner.createVisionInstance(g, e2, t2);
    }
    static createFromModelBuffer(e2, t2) {
      return s.VisionTaskRunner.createVisionInstance(g, e2, { baseOptions: { modelAssetBuffer: t2 } });
    }
    static createFromModelPath(e2, t2) {
      return s.VisionTaskRunner.createVisionInstance(g, e2, { baseOptions: { modelAssetPath: t2 } });
    }
    constructor(e2, t2) {
      super(new s.VisionGraphRunner(e2, t2), p, d, true), this.options = new n.FaceStylizerGraphOptions(), this.options.setBaseOptions(new a2.BaseOptions());
    }
    get baseOptions() {
      return this.options.getBaseOptions();
    }
    set baseOptions(e2) {
      this.options.setBaseOptions(e2);
    }
    setOptions(e2) {
      return super.applyOptions(e2);
    }
    stylize(e2, t2, r2) {
      const o2 = "function" != typeof t2 ? t2 : {};
      if (this.userCallback = "function" == typeof t2 ? t2 : r2, this.processImageData(e2, null != o2 ? o2 : {}), !this.userCallback) return this.result;
    }
    stylizeForVideo(e2, t2, r2, o2) {
      const i2 = "function" != typeof r2 ? r2 : {};
      if (this.userCallback = "function" == typeof r2 ? r2 : o2, this.processVideoData(e2, i2, t2), this.userCallback = void 0, !this.userCallback) return this.result;
    }
    refreshGraph() {
      const e2 = new o.CalculatorGraphConfig();
      e2.addInputStream(p), e2.addInputStream(d), e2.addOutputStream(l);
      const t2 = new i.CalculatorOptions();
      t2.setExtension(n.FaceStylizerGraphOptions.ext, this.options);
      const r2 = new o.CalculatorGraphConfig.Node();
      r2.setCalculator("mediapipe.tasks.vision.face_stylizer.FaceStylizerGraph"), r2.addInputStream("IMAGE:" + p), r2.addInputStream("NORM_RECT:" + d), r2.addOutputStream("STYLIZED_IMAGE:" + l), r2.setOptions(t2), e2.addNode(r2), this.graphRunner.attachImageListener(l, ((e3, t3) => {
        const r3 = this.convertToMPImage(e3, !this.userCallback);
        this.result = r3, this.userCallback && this.userCallback(r3), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(l, ((e3) => {
        this.result = null, this.userCallback && this.userCallback(null), this.setLatestOutputTimestamp(e3);
      }));
      const a3 = e2.serializeBinary();
      this.setGraph(new Uint8Array(a3), true);
    }
  }
  e.FaceStylizer = g;
})(face_stylizer);
var gesture_recognizer = {};
var gesture_classifier_graph_options_pb = {};
var classifier_options_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.tasks.components.processors.proto.ClassifierOptions", null, o), proto.mediapipe.tasks.components.processors.proto.ClassifierOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.tasks.components.processors.proto.ClassifierOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.displayName = "proto.mediapipe.tasks.components.processors.proto.ClassifierOptions"), proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.repeatedFields_ = [4, 5], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.toObject = function(e2, r2) {
    var o2, i = { displayNamesLocale: t.Message.getFieldWithDefault(r2, 1, "en"), maxResults: t.Message.getFieldWithDefault(r2, 2, -1), scoreThreshold: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 3)) ? void 0 : o2, categoryAllowlistList: null == (o2 = t.Message.getRepeatedField(r2, 4)) ? void 0 : o2, categoryDenylistList: null == (o2 = t.Message.getRepeatedField(r2, 5)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.components.processors.proto.ClassifierOptions();
    return proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setDisplayNamesLocale(r2);
          break;
        case 2:
          r2 = t2.readInt32();
          e2.setMaxResults(r2);
          break;
        case 3:
          r2 = t2.readFloat();
          e2.setScoreThreshold(r2);
          break;
        case 4:
          r2 = t2.readString();
          e2.addCategoryAllowlist(r2);
          break;
        case 5:
          r2 = t2.readString();
          e2.addCategoryDenylist(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeString(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeInt32(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeFloat(3, o2), (o2 = e2.getCategoryAllowlistList()).length > 0 && r2.writeRepeatedString(4, o2), (o2 = e2.getCategoryDenylistList()).length > 0 && r2.writeRepeatedString(5, o2);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.getDisplayNamesLocale = function() {
    return t.Message.getFieldWithDefault(this, 1, "en");
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.setDisplayNamesLocale = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.clearDisplayNamesLocale = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.hasDisplayNamesLocale = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.getMaxResults = function() {
    return t.Message.getFieldWithDefault(this, 2, -1);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.setMaxResults = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.clearMaxResults = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.hasMaxResults = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.getScoreThreshold = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.setScoreThreshold = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.clearScoreThreshold = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.hasScoreThreshold = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.getCategoryAllowlistList = function() {
    return t.Message.getRepeatedField(this, 4);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.setCategoryAllowlistList = function(e2) {
    return t.Message.setField(this, 4, e2 || []);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.addCategoryAllowlist = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 4, e2, r2);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.clearCategoryAllowlistList = function() {
    return this.setCategoryAllowlistList([]);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.getCategoryDenylistList = function() {
    return t.Message.getRepeatedField(this, 5);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.setCategoryDenylistList = function(e2) {
    return t.Message.setField(this, 5, e2 || []);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.addCategoryDenylist = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 5, e2, r2);
  }, proto.mediapipe.tasks.components.processors.proto.ClassifierOptions.prototype.clearCategoryDenylistList = function() {
    return this.setCategoryDenylistList([]);
  }, r.object.extend(e, proto.mediapipe.tasks.components.processors.proto);
})(classifier_options_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = classifier_options_pb;
  r.object.extend(proto, n);
  var s = base_options_pb;
  r.object.extend(proto, s), r.exportSymbol("proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions", null, o), proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.displayName = "proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.toObject = function(e2, t2) {
    var r2, o2 = { baseOptions: (r2 = t2.getBaseOptions()) && s.BaseOptions.toObject(e2, r2), classifierOptions: (r2 = t2.getClassifierOptions()) && n.ClassifierOptions.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions();
    return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new s.BaseOptions();
          t2.readMessage(r2, s.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
          break;
        case 2:
          r2 = new n.ClassifierOptions();
          t2.readMessage(r2, n.ClassifierOptions.deserializeBinaryFromReader), e2.setClassifierOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    null != (r2 = e2.getBaseOptions()) && t2.writeMessage(1, r2, s.BaseOptions.serializeBinaryToWriter), null != (r2 = e2.getClassifierOptions()) && t2.writeMessage(2, r2, n.ClassifierOptions.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.ext = new t.ExtensionFieldInfo(478825465, { ext: 0 }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[478825465] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[478825465] = proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.ext, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, s.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.getClassifierOptions = function() {
    return t.Message.getWrapperField(this, n.ClassifierOptions, 2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.setClassifierOptions = function(e2) {
    return t.Message.setWrapperField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.clearClassifierOptions = function() {
    return this.setClassifierOptions(void 0);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.prototype.hasClassifierOptions = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.ext = new t.ExtensionFieldInfo(478825465, { ext: 0 }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[478825465] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[478825465] = proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureClassifierGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.gesture_recognizer.proto);
})(gesture_classifier_graph_options_pb);
var gesture_recognizer_graph_options_pb = {};
var hand_gesture_recognizer_graph_options_pb = {};
var gesture_embedder_graph_options_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = base_options_pb;
  r.object.extend(proto, n), r.exportSymbol("proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions", null, o), proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.displayName = "proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.toObject = function(e2, t2) {
    var r2, o2 = { baseOptions: (r2 = t2.getBaseOptions()) && n.BaseOptions.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions();
    return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new n.BaseOptions();
        t2.readMessage(r2, n.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    null != (r2 = e2.getBaseOptions()) && t2.writeMessage(1, r2, n.BaseOptions.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.ext = new t.ExtensionFieldInfo(478825422, { ext: 0 }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[478825422] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[478825422] = proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.ext, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, n.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.ext = new t.ExtensionFieldInfo(478825422, { ext: 0 }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[478825422] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[478825422] = proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureEmbedderGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.gesture_recognizer.proto);
})(gesture_embedder_graph_options_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = base_options_pb;
  r.object.extend(proto, n);
  var s = gesture_classifier_graph_options_pb;
  r.object.extend(proto, s);
  var p = gesture_embedder_graph_options_pb;
  r.object.extend(proto, p), r.exportSymbol("proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions", null, o), proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.displayName = "proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.toObject = function(e2, t2) {
    var r2, o2 = { baseOptions: (r2 = t2.getBaseOptions()) && n.BaseOptions.toObject(e2, r2), gestureEmbedderGraphOptions: (r2 = t2.getGestureEmbedderGraphOptions()) && p.GestureEmbedderGraphOptions.toObject(e2, r2), cannedGestureClassifierGraphOptions: (r2 = t2.getCannedGestureClassifierGraphOptions()) && s.GestureClassifierGraphOptions.toObject(e2, r2), customGestureClassifierGraphOptions: (r2 = t2.getCustomGestureClassifierGraphOptions()) && s.GestureClassifierGraphOptions.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions();
    return proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new n.BaseOptions();
          t2.readMessage(r2, n.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
          break;
        case 2:
          r2 = new p.GestureEmbedderGraphOptions();
          t2.readMessage(r2, p.GestureEmbedderGraphOptions.deserializeBinaryFromReader), e2.setGestureEmbedderGraphOptions(r2);
          break;
        case 3:
          r2 = new s.GestureClassifierGraphOptions();
          t2.readMessage(r2, s.GestureClassifierGraphOptions.deserializeBinaryFromReader), e2.setCannedGestureClassifierGraphOptions(r2);
          break;
        case 4:
          r2 = new s.GestureClassifierGraphOptions();
          t2.readMessage(r2, s.GestureClassifierGraphOptions.deserializeBinaryFromReader), e2.setCustomGestureClassifierGraphOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    null != (r2 = e2.getBaseOptions()) && t2.writeMessage(1, r2, n.BaseOptions.serializeBinaryToWriter), null != (r2 = e2.getGestureEmbedderGraphOptions()) && t2.writeMessage(2, r2, p.GestureEmbedderGraphOptions.serializeBinaryToWriter), null != (r2 = e2.getCannedGestureClassifierGraphOptions()) && t2.writeMessage(3, r2, s.GestureClassifierGraphOptions.serializeBinaryToWriter), null != (r2 = e2.getCustomGestureClassifierGraphOptions()) && t2.writeMessage(4, r2, s.GestureClassifierGraphOptions.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.ext = new t.ExtensionFieldInfo(463370452, { ext: 0 }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[463370452] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[463370452] = proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.ext, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, n.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.getGestureEmbedderGraphOptions = function() {
    return t.Message.getWrapperField(this, p.GestureEmbedderGraphOptions, 2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.setGestureEmbedderGraphOptions = function(e2) {
    return t.Message.setWrapperField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.clearGestureEmbedderGraphOptions = function() {
    return this.setGestureEmbedderGraphOptions(void 0);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.hasGestureEmbedderGraphOptions = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.getCannedGestureClassifierGraphOptions = function() {
    return t.Message.getWrapperField(this, s.GestureClassifierGraphOptions, 3);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.setCannedGestureClassifierGraphOptions = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.clearCannedGestureClassifierGraphOptions = function() {
    return this.setCannedGestureClassifierGraphOptions(void 0);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.hasCannedGestureClassifierGraphOptions = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.getCustomGestureClassifierGraphOptions = function() {
    return t.Message.getWrapperField(this, s.GestureClassifierGraphOptions, 4);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.setCustomGestureClassifierGraphOptions = function(e2) {
    return t.Message.setWrapperField(this, 4, e2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.clearCustomGestureClassifierGraphOptions = function() {
    return this.setCustomGestureClassifierGraphOptions(void 0);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.prototype.hasCustomGestureClassifierGraphOptions = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.ext = new t.ExtensionFieldInfo(463370452, { ext: 0 }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[463370452] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[463370452] = proto.mediapipe.tasks.vision.gesture_recognizer.proto.HandGestureRecognizerGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.gesture_recognizer.proto);
})(hand_gesture_recognizer_graph_options_pb);
var hand_landmarker_graph_options_pb = {};
var hand_detector_graph_options_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = base_options_pb;
  r.object.extend(proto, n), r.exportSymbol("proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions", null, o), proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.displayName = "proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.toObject = function(e2, r2) {
    var o2, i2 = { baseOptions: (o2 = r2.getBaseOptions()) && n.BaseOptions.toObject(e2, o2), minDetectionConfidence: t.Message.getFloatingPointFieldWithDefault(r2, 2, 0.5), numHands: null == (o2 = t.Message.getField(r2, 3)) ? void 0 : o2 };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions();
    return proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new n.BaseOptions();
          t2.readMessage(r2, n.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
          break;
        case 2:
          r2 = t2.readFloat();
          e2.setMinDetectionConfidence(r2);
          break;
        case 3:
          r2 = t2.readInt32();
          e2.setNumHands(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getBaseOptions()) && r2.writeMessage(1, o2, n.BaseOptions.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 2)) && r2.writeFloat(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeInt32(3, o2);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.ext = new t.ExtensionFieldInfo(464864288, { ext: 0 }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[464864288] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[464864288] = proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.ext, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, n.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.getMinDetectionConfidence = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0.5);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.setMinDetectionConfidence = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.clearMinDetectionConfidence = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.hasMinDetectionConfidence = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.getNumHands = function() {
    return t.Message.getFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.setNumHands = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.clearNumHands = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.prototype.hasNumHands = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.ext = new t.ExtensionFieldInfo(464864288, { ext: 0 }, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[464864288] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[464864288] = proto.mediapipe.tasks.vision.hand_detector.proto.HandDetectorGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.hand_detector.proto);
})(hand_detector_graph_options_pb);
var hand_landmarks_detector_graph_options_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = base_options_pb;
  r.object.extend(proto, n), r.exportSymbol("proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions", null, o), proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.displayName = "proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.toObject = function(e2, r2) {
    var o2, i2 = { baseOptions: (o2 = r2.getBaseOptions()) && n.BaseOptions.toObject(e2, o2), minDetectionConfidence: t.Message.getFloatingPointFieldWithDefault(r2, 2, 0.5) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions();
    return proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new n.BaseOptions();
          t2.readMessage(r2, n.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
          break;
        case 2:
          r2 = t2.readFloat();
          e2.setMinDetectionConfidence(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getBaseOptions()) && r2.writeMessage(1, o2, n.BaseOptions.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 2)) && r2.writeFloat(2, o2);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.ext = new t.ExtensionFieldInfo(474472470, { ext: 0 }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[474472470] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[474472470] = proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.ext, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, n.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.getMinDetectionConfidence = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0.5);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.setMinDetectionConfidence = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.clearMinDetectionConfidence = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.prototype.hasMinDetectionConfidence = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.ext = new t.ExtensionFieldInfo(474472470, { ext: 0 }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[474472470] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[474472470] = proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarksDetectorGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.hand_landmarker.proto);
})(hand_landmarks_detector_graph_options_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = base_options_pb;
  r.object.extend(proto, n);
  var s = hand_detector_graph_options_pb;
  r.object.extend(proto, s);
  var p = hand_landmarks_detector_graph_options_pb;
  r.object.extend(proto, p), r.exportSymbol("proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions", null, o), proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.displayName = "proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.toObject = function(e2, r2) {
    var o2, i2 = { baseOptions: (o2 = r2.getBaseOptions()) && n.BaseOptions.toObject(e2, o2), handDetectorGraphOptions: (o2 = r2.getHandDetectorGraphOptions()) && s.HandDetectorGraphOptions.toObject(e2, o2), handLandmarksDetectorGraphOptions: (o2 = r2.getHandLandmarksDetectorGraphOptions()) && p.HandLandmarksDetectorGraphOptions.toObject(e2, o2), minTrackingConfidence: t.Message.getFloatingPointFieldWithDefault(r2, 4, 0.5) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions();
    return proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new n.BaseOptions();
          t2.readMessage(r2, n.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
          break;
        case 2:
          r2 = new s.HandDetectorGraphOptions();
          t2.readMessage(r2, s.HandDetectorGraphOptions.deserializeBinaryFromReader), e2.setHandDetectorGraphOptions(r2);
          break;
        case 3:
          r2 = new p.HandLandmarksDetectorGraphOptions();
          t2.readMessage(r2, p.HandLandmarksDetectorGraphOptions.deserializeBinaryFromReader), e2.setHandLandmarksDetectorGraphOptions(r2);
          break;
        case 4:
          r2 = t2.readFloat();
          e2.setMinTrackingConfidence(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getBaseOptions()) && r2.writeMessage(1, o2, n.BaseOptions.serializeBinaryToWriter), null != (o2 = e2.getHandDetectorGraphOptions()) && r2.writeMessage(2, o2, s.HandDetectorGraphOptions.serializeBinaryToWriter), null != (o2 = e2.getHandLandmarksDetectorGraphOptions()) && r2.writeMessage(3, o2, p.HandLandmarksDetectorGraphOptions.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 4)) && r2.writeFloat(4, o2);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.ext = new t.ExtensionFieldInfo(462713202, { ext: 0 }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[462713202] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[462713202] = proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.ext, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, n.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.getHandDetectorGraphOptions = function() {
    return t.Message.getWrapperField(this, s.HandDetectorGraphOptions, 2);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.setHandDetectorGraphOptions = function(e2) {
    return t.Message.setWrapperField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.clearHandDetectorGraphOptions = function() {
    return this.setHandDetectorGraphOptions(void 0);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.hasHandDetectorGraphOptions = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.getHandLandmarksDetectorGraphOptions = function() {
    return t.Message.getWrapperField(this, p.HandLandmarksDetectorGraphOptions, 3);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.setHandLandmarksDetectorGraphOptions = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.clearHandLandmarksDetectorGraphOptions = function() {
    return this.setHandLandmarksDetectorGraphOptions(void 0);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.hasHandLandmarksDetectorGraphOptions = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.getMinTrackingConfidence = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 4, 0.5);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.setMinTrackingConfidence = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.clearMinTrackingConfidence = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.prototype.hasMinTrackingConfidence = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.ext = new t.ExtensionFieldInfo(462713202, { ext: 0 }, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[462713202] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[462713202] = proto.mediapipe.tasks.vision.hand_landmarker.proto.HandLandmarkerGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.hand_landmarker.proto);
})(hand_landmarker_graph_options_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = base_options_pb;
  r.object.extend(proto, n);
  var s = hand_gesture_recognizer_graph_options_pb;
  r.object.extend(proto, s);
  var p = hand_landmarker_graph_options_pb;
  r.object.extend(proto, p), r.exportSymbol("proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions", null, o), proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.displayName = "proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.toObject = function(e2, t2) {
    var r2, o2 = { baseOptions: (r2 = t2.getBaseOptions()) && n.BaseOptions.toObject(e2, r2), handLandmarkerGraphOptions: (r2 = t2.getHandLandmarkerGraphOptions()) && p.HandLandmarkerGraphOptions.toObject(e2, r2), handGestureRecognizerGraphOptions: (r2 = t2.getHandGestureRecognizerGraphOptions()) && s.HandGestureRecognizerGraphOptions.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions();
    return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new n.BaseOptions();
          t2.readMessage(r2, n.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
          break;
        case 2:
          r2 = new p.HandLandmarkerGraphOptions();
          t2.readMessage(r2, p.HandLandmarkerGraphOptions.deserializeBinaryFromReader), e2.setHandLandmarkerGraphOptions(r2);
          break;
        case 3:
          r2 = new s.HandGestureRecognizerGraphOptions();
          t2.readMessage(r2, s.HandGestureRecognizerGraphOptions.deserializeBinaryFromReader), e2.setHandGestureRecognizerGraphOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    null != (r2 = e2.getBaseOptions()) && t2.writeMessage(1, r2, n.BaseOptions.serializeBinaryToWriter), null != (r2 = e2.getHandLandmarkerGraphOptions()) && t2.writeMessage(2, r2, p.HandLandmarkerGraphOptions.serializeBinaryToWriter), null != (r2 = e2.getHandGestureRecognizerGraphOptions()) && t2.writeMessage(3, r2, s.HandGestureRecognizerGraphOptions.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.ext = new t.ExtensionFieldInfo(479097054, { ext: 0 }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[479097054] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[479097054] = proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.ext, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, n.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.getHandLandmarkerGraphOptions = function() {
    return t.Message.getWrapperField(this, p.HandLandmarkerGraphOptions, 2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.setHandLandmarkerGraphOptions = function(e2) {
    return t.Message.setWrapperField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.clearHandLandmarkerGraphOptions = function() {
    return this.setHandLandmarkerGraphOptions(void 0);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.hasHandLandmarkerGraphOptions = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.getHandGestureRecognizerGraphOptions = function() {
    return t.Message.getWrapperField(this, s.HandGestureRecognizerGraphOptions, 3);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.setHandGestureRecognizerGraphOptions = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.clearHandGestureRecognizerGraphOptions = function() {
    return this.setHandGestureRecognizerGraphOptions(void 0);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.prototype.hasHandGestureRecognizerGraphOptions = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.ext = new t.ExtensionFieldInfo(479097054, { ext: 0 }, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[479097054] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[479097054] = proto.mediapipe.tasks.vision.gesture_recognizer.proto.GestureRecognizerGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.gesture_recognizer.proto);
})(gesture_recognizer_graph_options_pb);
var classifier_options = {};
Object.defineProperty(classifier_options, "__esModule", { value: true }), classifier_options.convertClassifierOptionsToProto = void 0;
var classifier_options_pb_1 = classifier_options_pb;
function convertClassifierOptionsToProto(e, t) {
  const r = t ? t.clone() : new classifier_options_pb_1.ClassifierOptions();
  return void 0 !== e.displayNamesLocale ? r.setDisplayNamesLocale(e.displayNamesLocale) : void 0 === e.displayNamesLocale && r.clearDisplayNamesLocale(), void 0 !== e.maxResults ? r.setMaxResults(e.maxResults) : "maxResults" in e && r.clearMaxResults(), void 0 !== e.scoreThreshold ? r.setScoreThreshold(e.scoreThreshold) : "scoreThreshold" in e && r.clearScoreThreshold(), void 0 !== e.categoryAllowlist ? r.setCategoryAllowlistList(e.categoryAllowlist) : "categoryAllowlist" in e && r.clearCategoryAllowlistList(), void 0 !== e.categoryDenylist ? r.setCategoryDenylistList(e.categoryDenylist) : "categoryDenylist" in e && r.clearCategoryDenylistList(), r;
}
classifier_options.convertClassifierOptionsToProto = convertClassifierOptionsToProto;
var hand_landmarks_connections = {};
Object.defineProperty(hand_landmarks_connections, "__esModule", { value: true }), hand_landmarks_connections.HAND_CONNECTIONS = void 0, hand_landmarks_connections.HAND_CONNECTIONS = [{ start: 0, end: 1 }, { start: 1, end: 2 }, { start: 2, end: 3 }, { start: 3, end: 4 }, { start: 0, end: 5 }, { start: 5, end: 6 }, { start: 6, end: 7 }, { start: 7, end: 8 }, { start: 5, end: 9 }, { start: 9, end: 10 }, { start: 10, end: 11 }, { start: 11, end: 12 }, { start: 9, end: 13 }, { start: 13, end: 14 }, { start: 14, end: 15 }, { start: 15, end: 16 }, { start: 13, end: 17 }, { start: 0, end: 17 }, { start: 17, end: 18 }, { start: 18, end: 19 }, { start: 19, end: 20 }];
var gesture_recognizer_options = {};
Object.defineProperty(gesture_recognizer_options, "__esModule", { value: true });
var gesture_recognizer_result = {};
Object.defineProperty(gesture_recognizer_result, "__esModule", { value: true }), (function(e) {
  var t = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2);
    var i2 = Object.getOwnPropertyDescriptor(t2, r2);
    i2 && !("get" in i2 ? !t2.__esModule : i2.writable || i2.configurable) || (i2 = { enumerable: true, get: function() {
      return t2[r2];
    } }), Object.defineProperty(e2, o2, i2);
  } : function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2), e2[o2] = t2[r2];
  }), r = commonjsGlobal && commonjsGlobal.__exportStar || function(e2, r2) {
    for (var o2 in e2) "default" === o2 || Object.prototype.hasOwnProperty.call(r2, o2) || t(r2, e2, o2);
  };
  Object.defineProperty(e, "__esModule", { value: true }), e.GestureRecognizer = void 0;
  const o = calculator_pb, i = calculator_options_pb, a2 = classification_pb, n = landmark_pb, s = base_options_pb, p = gesture_classifier_graph_options_pb, d = gesture_recognizer_graph_options_pb, l = hand_gesture_recognizer_graph_options_pb, g = hand_detector_graph_options_pb, c = hand_landmarker_graph_options_pb, u = hand_landmarks_detector_graph_options_pb, m = classifier_options, f = vision_task_runner, h = hand_landmarks_connections;
  r(gesture_recognizer_options, e), r(gesture_recognizer_result, e);
  const y = "image_in", b = "norm_rect", _ = "hand_gestures", O = "hand_landmarks", F = "world_hand_landmarks", M = "handedness", R = 0.5;
  class v extends f.VisionTaskRunner {
    static createFromOptions(e2, t2) {
      return f.VisionTaskRunner.createVisionInstance(v, e2, t2);
    }
    static createFromModelBuffer(e2, t2) {
      return f.VisionTaskRunner.createVisionInstance(v, e2, { baseOptions: { modelAssetBuffer: t2 } });
    }
    static createFromModelPath(e2, t2) {
      return f.VisionTaskRunner.createVisionInstance(v, e2, { baseOptions: { modelAssetPath: t2 } });
    }
    constructor(e2, t2) {
      super(new f.VisionGraphRunner(e2, t2), y, b, false), this.gestures = [], this.landmarks = [], this.worldLandmarks = [], this.handednesses = [], this.options = new d.GestureRecognizerGraphOptions(), this.options.setBaseOptions(new s.BaseOptions()), this.handLandmarkerGraphOptions = new c.HandLandmarkerGraphOptions(), this.options.setHandLandmarkerGraphOptions(this.handLandmarkerGraphOptions), this.handLandmarksDetectorGraphOptions = new u.HandLandmarksDetectorGraphOptions(), this.handLandmarkerGraphOptions.setHandLandmarksDetectorGraphOptions(this.handLandmarksDetectorGraphOptions), this.handDetectorGraphOptions = new g.HandDetectorGraphOptions(), this.handLandmarkerGraphOptions.setHandDetectorGraphOptions(this.handDetectorGraphOptions), this.handGestureRecognizerGraphOptions = new l.HandGestureRecognizerGraphOptions(), this.options.setHandGestureRecognizerGraphOptions(this.handGestureRecognizerGraphOptions), this.handDetectorGraphOptions.setMinDetectionConfidence(R), this.handLandmarkerGraphOptions.setMinTrackingConfidence(R), this.handLandmarksDetectorGraphOptions.setMinDetectionConfidence(R);
    }
    get baseOptions() {
      return this.options.getBaseOptions();
    }
    set baseOptions(e2) {
      this.options.setBaseOptions(e2);
    }
    setOptions(e2) {
      var t2, r2, o2, i2, a3, n2, s2, d2;
      if (this.handDetectorGraphOptions.setNumHands(null !== (t2 = e2.numHands) && void 0 !== t2 ? t2 : 1), "minHandDetectionConfidence" in e2 && this.handDetectorGraphOptions.setMinDetectionConfidence(null !== (r2 = e2.minHandDetectionConfidence) && void 0 !== r2 ? r2 : R), "minTrackingConfidence" in e2 && this.handLandmarkerGraphOptions.setMinTrackingConfidence(null !== (o2 = e2.minTrackingConfidence) && void 0 !== o2 ? o2 : R), "minHandPresenceConfidence" in e2 && this.handLandmarksDetectorGraphOptions.setMinDetectionConfidence(null !== (i2 = e2.minHandPresenceConfidence) && void 0 !== i2 ? i2 : R), e2.cannedGesturesClassifierOptions) {
        const t3 = new p.GestureClassifierGraphOptions();
        t3.setClassifierOptions((0, m.convertClassifierOptionsToProto)(e2.cannedGesturesClassifierOptions, null === (a3 = this.handGestureRecognizerGraphOptions.getCannedGestureClassifierGraphOptions()) || void 0 === a3 ? void 0 : a3.getClassifierOptions())), this.handGestureRecognizerGraphOptions.setCannedGestureClassifierGraphOptions(t3);
      } else void 0 === e2.cannedGesturesClassifierOptions && (null === (n2 = this.handGestureRecognizerGraphOptions.getCannedGestureClassifierGraphOptions()) || void 0 === n2 || n2.clearClassifierOptions());
      if (e2.customGesturesClassifierOptions) {
        const t3 = new p.GestureClassifierGraphOptions();
        t3.setClassifierOptions((0, m.convertClassifierOptionsToProto)(e2.customGesturesClassifierOptions, null === (s2 = this.handGestureRecognizerGraphOptions.getCustomGestureClassifierGraphOptions()) || void 0 === s2 ? void 0 : s2.getClassifierOptions())), this.handGestureRecognizerGraphOptions.setCustomGestureClassifierGraphOptions(t3);
      } else void 0 === e2.customGesturesClassifierOptions && (null === (d2 = this.handGestureRecognizerGraphOptions.getCustomGestureClassifierGraphOptions()) || void 0 === d2 || d2.clearClassifierOptions());
      return this.applyOptions(e2);
    }
    recognize(e2, t2) {
      return this.resetResults(), this.processImageData(e2, t2), this.processResults();
    }
    recognizeForVideo(e2, t2, r2) {
      return this.resetResults(), this.processVideoData(e2, r2, t2), this.processResults();
    }
    resetResults() {
      this.gestures = [], this.landmarks = [], this.worldLandmarks = [], this.handednesses = [];
    }
    processResults() {
      return 0 === this.gestures.length ? { gestures: [], landmarks: [], worldLandmarks: [], handednesses: [] } : { gestures: this.gestures, landmarks: this.landmarks, worldLandmarks: this.worldLandmarks, handednesses: this.handednesses };
    }
    toJsCategories(e2, t2 = true) {
      var r2, o2, i2;
      const n2 = [];
      for (const s2 of e2) {
        const e3 = a2.ClassificationList.deserializeBinary(s2), p2 = [];
        for (const a3 of e3.getClassificationList()) {
          const e4 = t2 && a3.hasIndex() ? a3.getIndex() : -1;
          p2.push({ score: null !== (r2 = a3.getScore()) && void 0 !== r2 ? r2 : 0, index: e4, categoryName: null !== (o2 = a3.getLabel()) && void 0 !== o2 ? o2 : "", displayName: null !== (i2 = a3.getDisplayName()) && void 0 !== i2 ? i2 : "" });
        }
        n2.push(p2);
      }
      return n2;
    }
    addJsLandmarks(e2) {
      var t2, r2, o2;
      for (const i2 of e2) {
        const e3 = n.NormalizedLandmarkList.deserializeBinary(i2), a3 = [];
        for (const i3 of e3.getLandmarkList()) a3.push({ x: null !== (t2 = i3.getX()) && void 0 !== t2 ? t2 : 0, y: null !== (r2 = i3.getY()) && void 0 !== r2 ? r2 : 0, z: null !== (o2 = i3.getZ()) && void 0 !== o2 ? o2 : 0 });
        this.landmarks.push(a3);
      }
    }
    adddJsWorldLandmarks(e2) {
      var t2, r2, o2;
      for (const i2 of e2) {
        const e3 = n.LandmarkList.deserializeBinary(i2), a3 = [];
        for (const i3 of e3.getLandmarkList()) a3.push({ x: null !== (t2 = i3.getX()) && void 0 !== t2 ? t2 : 0, y: null !== (r2 = i3.getY()) && void 0 !== r2 ? r2 : 0, z: null !== (o2 = i3.getZ()) && void 0 !== o2 ? o2 : 0 });
        this.worldLandmarks.push(a3);
      }
    }
    refreshGraph() {
      const e2 = new o.CalculatorGraphConfig();
      e2.addInputStream(y), e2.addInputStream(b), e2.addOutputStream(_), e2.addOutputStream(O), e2.addOutputStream(F), e2.addOutputStream(M);
      const t2 = new i.CalculatorOptions();
      t2.setExtension(d.GestureRecognizerGraphOptions.ext, this.options);
      const r2 = new o.CalculatorGraphConfig.Node();
      r2.setCalculator("mediapipe.tasks.vision.gesture_recognizer.GestureRecognizerGraph"), r2.addInputStream("IMAGE:" + y), r2.addInputStream("NORM_RECT:" + b), r2.addOutputStream("HAND_GESTURES:" + _), r2.addOutputStream("LANDMARKS:" + O), r2.addOutputStream("WORLD_LANDMARKS:" + F), r2.addOutputStream("HANDEDNESS:" + M), r2.setOptions(t2), e2.addNode(r2), this.graphRunner.attachProtoVectorListener(O, ((e3, t3) => {
        this.addJsLandmarks(e3), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(O, ((e3) => {
        this.setLatestOutputTimestamp(e3);
      })), this.graphRunner.attachProtoVectorListener(F, ((e3, t3) => {
        this.adddJsWorldLandmarks(e3), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(F, ((e3) => {
        this.setLatestOutputTimestamp(e3);
      })), this.graphRunner.attachProtoVectorListener(_, ((e3, t3) => {
        this.gestures.push(...this.toJsCategories(e3, false)), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(_, ((e3) => {
        this.setLatestOutputTimestamp(e3);
      })), this.graphRunner.attachProtoVectorListener(M, ((e3, t3) => {
        this.handednesses.push(...this.toJsCategories(e3)), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(M, ((e3) => {
        this.setLatestOutputTimestamp(e3);
      }));
      const a3 = e2.serializeBinary();
      this.setGraph(new Uint8Array(a3), true);
    }
  }
  e.GestureRecognizer = v, v.HAND_CONNECTIONS = h.HAND_CONNECTIONS;
})(gesture_recognizer);
var hand_landmarker = {};
var hand_landmarker_options = {};
Object.defineProperty(hand_landmarker_options, "__esModule", { value: true });
var hand_landmarker_result = {};
Object.defineProperty(hand_landmarker_result, "__esModule", { value: true }), (function(e) {
  var t = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2);
    var i2 = Object.getOwnPropertyDescriptor(t2, r2);
    i2 && !("get" in i2 ? !t2.__esModule : i2.writable || i2.configurable) || (i2 = { enumerable: true, get: function() {
      return t2[r2];
    } }), Object.defineProperty(e2, o2, i2);
  } : function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2), e2[o2] = t2[r2];
  }), r = commonjsGlobal && commonjsGlobal.__exportStar || function(e2, r2) {
    for (var o2 in e2) "default" === o2 || Object.prototype.hasOwnProperty.call(r2, o2) || t(r2, e2, o2);
  };
  Object.defineProperty(e, "__esModule", { value: true }), e.HandLandmarker = void 0;
  const o = calculator_pb, i = calculator_options_pb, a2 = classification_pb, n = landmark_pb, s = base_options_pb, p = hand_detector_graph_options_pb, d = hand_landmarker_graph_options_pb, l = hand_landmarks_detector_graph_options_pb, g = landmark_result, c = vision_task_runner, u = hand_landmarks_connections;
  r(hand_landmarker_options, e), r(hand_landmarker_result, e);
  const m = "image_in", f = "norm_rect", h = "hand_landmarks", y = "world_hand_landmarks", b = "handedness", _ = 0.5;
  class O extends c.VisionTaskRunner {
    static createFromOptions(e2, t2) {
      return c.VisionTaskRunner.createVisionInstance(O, e2, t2);
    }
    static createFromModelBuffer(e2, t2) {
      return c.VisionTaskRunner.createVisionInstance(O, e2, { baseOptions: { modelAssetBuffer: t2 } });
    }
    static createFromModelPath(e2, t2) {
      return c.VisionTaskRunner.createVisionInstance(O, e2, { baseOptions: { modelAssetPath: t2 } });
    }
    constructor(e2, t2) {
      super(new c.VisionGraphRunner(e2, t2), m, f, false), this.landmarks = [], this.worldLandmarks = [], this.handednesses = [], this.options = new d.HandLandmarkerGraphOptions(), this.options.setBaseOptions(new s.BaseOptions()), this.handLandmarksDetectorGraphOptions = new l.HandLandmarksDetectorGraphOptions(), this.options.setHandLandmarksDetectorGraphOptions(this.handLandmarksDetectorGraphOptions), this.handDetectorGraphOptions = new p.HandDetectorGraphOptions(), this.options.setHandDetectorGraphOptions(this.handDetectorGraphOptions), this.initDefaults();
    }
    get baseOptions() {
      return this.options.getBaseOptions();
    }
    set baseOptions(e2) {
      this.options.setBaseOptions(e2);
    }
    setOptions(e2) {
      var t2, r2, o2, i2;
      return "numHands" in e2 && this.handDetectorGraphOptions.setNumHands(null !== (t2 = e2.numHands) && void 0 !== t2 ? t2 : 1), "minHandDetectionConfidence" in e2 && this.handDetectorGraphOptions.setMinDetectionConfidence(null !== (r2 = e2.minHandDetectionConfidence) && void 0 !== r2 ? r2 : _), "minTrackingConfidence" in e2 && this.options.setMinTrackingConfidence(null !== (o2 = e2.minTrackingConfidence) && void 0 !== o2 ? o2 : _), "minHandPresenceConfidence" in e2 && this.handLandmarksDetectorGraphOptions.setMinDetectionConfidence(null !== (i2 = e2.minHandPresenceConfidence) && void 0 !== i2 ? i2 : _), this.applyOptions(e2);
    }
    detect(e2, t2) {
      return this.resetResults(), this.processImageData(e2, t2), this.processResults();
    }
    detectForVideo(e2, t2, r2) {
      return this.resetResults(), this.processVideoData(e2, r2, t2), this.processResults();
    }
    resetResults() {
      this.landmarks = [], this.worldLandmarks = [], this.handednesses = [];
    }
    processResults() {
      return { landmarks: this.landmarks, worldLandmarks: this.worldLandmarks, handednesses: this.handednesses };
    }
    initDefaults() {
      this.handDetectorGraphOptions.setNumHands(1), this.handDetectorGraphOptions.setMinDetectionConfidence(_), this.handLandmarksDetectorGraphOptions.setMinDetectionConfidence(_), this.options.setMinTrackingConfidence(_);
    }
    toJsCategories(e2) {
      var t2, r2, o2, i2;
      const n2 = [];
      for (const s2 of e2) {
        const e3 = a2.ClassificationList.deserializeBinary(s2), p2 = [];
        for (const a3 of e3.getClassificationList()) p2.push({ score: null !== (t2 = a3.getScore()) && void 0 !== t2 ? t2 : 0, index: null !== (r2 = a3.getIndex()) && void 0 !== r2 ? r2 : -1, categoryName: null !== (o2 = a3.getLabel()) && void 0 !== o2 ? o2 : "", displayName: null !== (i2 = a3.getDisplayName()) && void 0 !== i2 ? i2 : "" });
        n2.push(p2);
      }
      return n2;
    }
    addJsLandmarks(e2) {
      for (const t2 of e2) {
        const e3 = n.NormalizedLandmarkList.deserializeBinary(t2);
        this.landmarks.push((0, g.convertToLandmarks)(e3));
      }
    }
    adddJsWorldLandmarks(e2) {
      for (const t2 of e2) {
        const e3 = n.LandmarkList.deserializeBinary(t2);
        this.worldLandmarks.push((0, g.convertToWorldLandmarks)(e3));
      }
    }
    refreshGraph() {
      const e2 = new o.CalculatorGraphConfig();
      e2.addInputStream(m), e2.addInputStream(f), e2.addOutputStream(h), e2.addOutputStream(y), e2.addOutputStream(b);
      const t2 = new i.CalculatorOptions();
      t2.setExtension(d.HandLandmarkerGraphOptions.ext, this.options);
      const r2 = new o.CalculatorGraphConfig.Node();
      r2.setCalculator("mediapipe.tasks.vision.hand_landmarker.HandLandmarkerGraph"), r2.addInputStream("IMAGE:" + m), r2.addInputStream("NORM_RECT:" + f), r2.addOutputStream("LANDMARKS:" + h), r2.addOutputStream("WORLD_LANDMARKS:" + y), r2.addOutputStream("HANDEDNESS:" + b), r2.setOptions(t2), e2.addNode(r2), this.graphRunner.attachProtoVectorListener(h, ((e3, t3) => {
        this.addJsLandmarks(e3), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(h, ((e3) => {
        this.setLatestOutputTimestamp(e3);
      })), this.graphRunner.attachProtoVectorListener(y, ((e3, t3) => {
        this.adddJsWorldLandmarks(e3), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(y, ((e3) => {
        this.setLatestOutputTimestamp(e3);
      })), this.graphRunner.attachProtoVectorListener(b, ((e3, t3) => {
        this.handednesses.push(...this.toJsCategories(e3)), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(b, ((e3) => {
        this.setLatestOutputTimestamp(e3);
      }));
      const a3 = e2.serializeBinary();
      this.setGraph(new Uint8Array(a3), true);
    }
  }
  e.HandLandmarker = O, O.HAND_CONNECTIONS = u.HAND_CONNECTIONS;
})(hand_landmarker);
var image_classifier = {};
var classifications_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = classification_pb;
  r.object.extend(proto, i), r.exportSymbol("proto.mediapipe.tasks.components.containers.proto.ClassificationResult", null, o), r.exportSymbol("proto.mediapipe.tasks.components.containers.proto.Classifications", null, o), proto.mediapipe.tasks.components.containers.proto.Classifications = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.components.containers.proto.Classifications, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.components.containers.proto.Classifications.displayName = "proto.mediapipe.tasks.components.containers.proto.Classifications"), proto.mediapipe.tasks.components.containers.proto.ClassificationResult = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.tasks.components.containers.proto.ClassificationResult.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.tasks.components.containers.proto.ClassificationResult, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.components.containers.proto.ClassificationResult.displayName = "proto.mediapipe.tasks.components.containers.proto.ClassificationResult"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.components.containers.proto.Classifications.toObject(e2, this);
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.toObject = function(e2, r2) {
    var o2, a2 = { classificationList: (o2 = r2.getClassificationList()) && i.ClassificationList.toObject(e2, o2), headIndex: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, headName: null == (o2 = t.Message.getField(r2, 3)) ? void 0 : o2 };
    return e2 && (a2.$jspbMessageInstance = r2), a2;
  }), proto.mediapipe.tasks.components.containers.proto.Classifications.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.components.containers.proto.Classifications();
    return proto.mediapipe.tasks.components.containers.proto.Classifications.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 4:
          var r2 = new i.ClassificationList();
          t2.readMessage(r2, i.ClassificationList.deserializeBinaryFromReader), e2.setClassificationList(r2);
          break;
        case 2:
          r2 = t2.readInt32();
          e2.setHeadIndex(r2);
          break;
        case 3:
          r2 = t2.readString();
          e2.setHeadName(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.components.containers.proto.Classifications.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getClassificationList()) && r2.writeMessage(4, o2, i.ClassificationList.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 2)) && r2.writeInt32(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeString(3, o2);
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.getClassificationList = function() {
    return t.Message.getWrapperField(this, i.ClassificationList, 4);
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.setClassificationList = function(e2) {
    return t.Message.setWrapperField(this, 4, e2);
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.clearClassificationList = function() {
    return this.setClassificationList(void 0);
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.hasClassificationList = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.getHeadIndex = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.setHeadIndex = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.clearHeadIndex = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.hasHeadIndex = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.getHeadName = function() {
    return t.Message.getFieldWithDefault(this, 3, "");
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.setHeadName = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.clearHeadName = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.tasks.components.containers.proto.Classifications.prototype.hasHeadName = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.tasks.components.containers.proto.ClassificationResult.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.components.containers.proto.ClassificationResult.toObject(e2, this);
  }, proto.mediapipe.tasks.components.containers.proto.ClassificationResult.toObject = function(e2, r2) {
    var o2, i2 = { classificationsList: t.Message.toObjectList(r2.getClassificationsList(), proto.mediapipe.tasks.components.containers.proto.Classifications.toObject, e2), timestampMs: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2 };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.tasks.components.containers.proto.ClassificationResult.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.components.containers.proto.ClassificationResult();
    return proto.mediapipe.tasks.components.containers.proto.ClassificationResult.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.components.containers.proto.ClassificationResult.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new proto.mediapipe.tasks.components.containers.proto.Classifications();
          t2.readMessage(r2, proto.mediapipe.tasks.components.containers.proto.Classifications.deserializeBinaryFromReader), e2.addClassifications(r2);
          break;
        case 2:
          r2 = t2.readInt64();
          e2.setTimestampMs(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.components.containers.proto.ClassificationResult.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.components.containers.proto.ClassificationResult.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    (o2 = e2.getClassificationsList()).length > 0 && r2.writeRepeatedMessage(1, o2, proto.mediapipe.tasks.components.containers.proto.Classifications.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 2)) && r2.writeInt64(2, o2);
  }, proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.getClassificationsList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.tasks.components.containers.proto.Classifications, 1);
  }, proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.setClassificationsList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.addClassifications = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.tasks.components.containers.proto.Classifications, r2);
  }, proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.clearClassificationsList = function() {
    return this.setClassificationsList([]);
  }, proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.getTimestampMs = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.setTimestampMs = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.clearTimestampMs = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.components.containers.proto.ClassificationResult.prototype.hasTimestampMs = function() {
    return null != t.Message.getField(this, 2);
  }, r.object.extend(e, proto.mediapipe.tasks.components.containers.proto);
})(classifications_pb);
var image_classifier_graph_options_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = classifier_options_pb;
  r.object.extend(proto, n);
  var s = base_options_pb;
  r.object.extend(proto, s), r.exportSymbol("proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions", null, o), proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.displayName = "proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.toObject = function(e2, t2) {
    var r2, o2 = { baseOptions: (r2 = t2.getBaseOptions()) && s.BaseOptions.toObject(e2, r2), classifierOptions: (r2 = t2.getClassifierOptions()) && n.ClassifierOptions.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions();
    return proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new s.BaseOptions();
          t2.readMessage(r2, s.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
          break;
        case 2:
          r2 = new n.ClassifierOptions();
          t2.readMessage(r2, n.ClassifierOptions.deserializeBinaryFromReader), e2.setClassifierOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    null != (r2 = e2.getBaseOptions()) && t2.writeMessage(1, r2, s.BaseOptions.serializeBinaryToWriter), null != (r2 = e2.getClassifierOptions()) && t2.writeMessage(2, r2, n.ClassifierOptions.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.ext = new t.ExtensionFieldInfo(456383383, { ext: 0 }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[456383383] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[456383383] = proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.ext, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, s.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.getClassifierOptions = function() {
    return t.Message.getWrapperField(this, n.ClassifierOptions, 2);
  }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.setClassifierOptions = function(e2) {
    return t.Message.setWrapperField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.clearClassifierOptions = function() {
    return this.setClassifierOptions(void 0);
  }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.prototype.hasClassifierOptions = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.ext = new t.ExtensionFieldInfo(456383383, { ext: 0 }, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[456383383] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[456383383] = proto.mediapipe.tasks.vision.image_classifier.proto.ImageClassifierGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.image_classifier.proto);
})(image_classifier_graph_options_pb);
var image_classifier_options = {};
Object.defineProperty(image_classifier_options, "__esModule", { value: true });
var image_classifier_result = {};
Object.defineProperty(image_classifier_result, "__esModule", { value: true }), (function(e) {
  var t = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2);
    var i2 = Object.getOwnPropertyDescriptor(t2, r2);
    i2 && !("get" in i2 ? !t2.__esModule : i2.writable || i2.configurable) || (i2 = { enumerable: true, get: function() {
      return t2[r2];
    } }), Object.defineProperty(e2, o2, i2);
  } : function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2), e2[o2] = t2[r2];
  }), r = commonjsGlobal && commonjsGlobal.__exportStar || function(e2, r2) {
    for (var o2 in e2) "default" === o2 || Object.prototype.hasOwnProperty.call(r2, o2) || t(r2, e2, o2);
  };
  Object.defineProperty(e, "__esModule", { value: true }), e.ImageClassifier = void 0;
  const o = calculator_pb, i = calculator_options_pb, a2 = classifications_pb, n = base_options_pb, s = image_classifier_graph_options_pb, p = classifier_options, d = classifier_result, l = vision_task_runner, g = "input_image", c = "norm_rect", u = "classifications";
  r(image_classifier_options, e), r(image_classifier_result, e);
  class m extends l.VisionTaskRunner {
    static createFromOptions(e2, t2) {
      return l.VisionTaskRunner.createVisionInstance(m, e2, t2);
    }
    static createFromModelBuffer(e2, t2) {
      return l.VisionTaskRunner.createVisionInstance(m, e2, { baseOptions: { modelAssetBuffer: t2 } });
    }
    static createFromModelPath(e2, t2) {
      return l.VisionTaskRunner.createVisionInstance(m, e2, { baseOptions: { modelAssetPath: t2 } });
    }
    constructor(e2, t2) {
      super(new l.VisionGraphRunner(e2, t2), g, c, true), this.classificationResult = { classifications: [] }, this.options = new s.ImageClassifierGraphOptions(), this.options.setBaseOptions(new n.BaseOptions());
    }
    get baseOptions() {
      return this.options.getBaseOptions();
    }
    set baseOptions(e2) {
      this.options.setBaseOptions(e2);
    }
    setOptions(e2) {
      return this.options.setClassifierOptions((0, p.convertClassifierOptionsToProto)(e2, this.options.getClassifierOptions())), this.applyOptions(e2);
    }
    classify(e2, t2) {
      return this.classificationResult = { classifications: [] }, this.processImageData(e2, t2), this.classificationResult;
    }
    classifyForVideo(e2, t2, r2) {
      return this.classificationResult = { classifications: [] }, this.processVideoData(e2, r2, t2), this.classificationResult;
    }
    refreshGraph() {
      const e2 = new o.CalculatorGraphConfig();
      e2.addInputStream(g), e2.addInputStream(c), e2.addOutputStream(u);
      const t2 = new i.CalculatorOptions();
      t2.setExtension(s.ImageClassifierGraphOptions.ext, this.options);
      const r2 = new o.CalculatorGraphConfig.Node();
      r2.setCalculator("mediapipe.tasks.vision.image_classifier.ImageClassifierGraph"), r2.addInputStream("IMAGE:" + g), r2.addInputStream("NORM_RECT:" + c), r2.addOutputStream("CLASSIFICATIONS:" + u), r2.setOptions(t2), e2.addNode(r2), this.graphRunner.attachProtoListener(u, ((e3, t3) => {
        this.classificationResult = (0, d.convertFromClassificationResultProto)(a2.ClassificationResult.deserializeBinary(e3)), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(u, ((e3) => {
        this.setLatestOutputTimestamp(e3);
      }));
      const n2 = e2.serializeBinary();
      this.setGraph(new Uint8Array(n2), true);
    }
  }
  e.ImageClassifier = m;
})(image_classifier);
var image_embedder = {};
var embeddings_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.tasks.components.containers.proto.Embedding", null, o), r.exportSymbol("proto.mediapipe.tasks.components.containers.proto.Embedding.EmbeddingCase", null, o), r.exportSymbol("proto.mediapipe.tasks.components.containers.proto.EmbeddingResult", null, o), r.exportSymbol("proto.mediapipe.tasks.components.containers.proto.FloatEmbedding", null, o), r.exportSymbol("proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding", null, o), proto.mediapipe.tasks.components.containers.proto.FloatEmbedding = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.tasks.components.containers.proto.FloatEmbedding, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.displayName = "proto.mediapipe.tasks.components.containers.proto.FloatEmbedding"), proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.displayName = "proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding"), proto.mediapipe.tasks.components.containers.proto.Embedding = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, proto.mediapipe.tasks.components.containers.proto.Embedding.oneofGroups_);
  }, r.inherits(proto.mediapipe.tasks.components.containers.proto.Embedding, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.components.containers.proto.Embedding.displayName = "proto.mediapipe.tasks.components.containers.proto.Embedding"), proto.mediapipe.tasks.components.containers.proto.EmbeddingResult = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.tasks.components.containers.proto.EmbeddingResult, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.displayName = "proto.mediapipe.tasks.components.containers.proto.EmbeddingResult"), proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.toObject(e2, this);
  }, proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.toObject = function(e2, r2) {
    var o2, i = { valuesList: null == (o2 = t.Message.getRepeatedFloatingPointField(r2, 1)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.components.containers.proto.FloatEmbedding();
    return proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) for (var r2 = t2.isDelimited() ? t2.readPackedFloat() : [t2.readFloat()], o2 = 0; o2 < r2.length; o2++) e2.addValues(r2[o2]);
      else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    (r2 = e2.getValuesList()).length > 0 && t2.writePackedFloat(1, r2);
  }, proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.prototype.getValuesList = function() {
    return t.Message.getRepeatedFloatingPointField(this, 1);
  }, proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.prototype.setValuesList = function(e2) {
    return t.Message.setField(this, 1, e2 || []);
  }, proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.prototype.addValues = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 1, e2, r2);
  }, proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.prototype.clearValuesList = function() {
    return this.setValuesList([]);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.toObject(e2, this);
  }, proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.toObject = function(e2, t2) {
    var r2 = { values: t2.getValues_asB64() };
    return e2 && (r2.$jspbMessageInstance = t2), r2;
  }), proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding();
    return proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = t2.readBytes();
        e2.setValues(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.serializeBinaryToWriter = function(e2, r2) {
    var o2;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeBytes(1, o2);
  }, proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.getValues = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.getValues_asB64 = function() {
    return t.Message.bytesAsB64(this.getValues());
  }, proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.getValues_asU8 = function() {
    return t.Message.bytesAsU8(this.getValues());
  }, proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.setValues = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.clearValues = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.prototype.hasValues = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.oneofGroups_ = [[1, 2]], proto.mediapipe.tasks.components.containers.proto.Embedding.EmbeddingCase = { EMBEDDING_NOT_SET: 0, FLOAT_EMBEDDING: 1, QUANTIZED_EMBEDDING: 2 }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.getEmbeddingCase = function() {
    return t.Message.computeOneofCase(this, proto.mediapipe.tasks.components.containers.proto.Embedding.oneofGroups_[0]);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.components.containers.proto.Embedding.toObject(e2, this);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.toObject = function(e2, r2) {
    var o2, i = { floatEmbedding: (o2 = r2.getFloatEmbedding()) && proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.toObject(e2, o2), quantizedEmbedding: (o2 = r2.getQuantizedEmbedding()) && proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.toObject(e2, o2), headIndex: null == (o2 = t.Message.getField(r2, 3)) ? void 0 : o2, headName: null == (o2 = t.Message.getField(r2, 4)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.tasks.components.containers.proto.Embedding.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.components.containers.proto.Embedding();
    return proto.mediapipe.tasks.components.containers.proto.Embedding.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new proto.mediapipe.tasks.components.containers.proto.FloatEmbedding();
          t2.readMessage(r2, proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.deserializeBinaryFromReader), e2.setFloatEmbedding(r2);
          break;
        case 2:
          r2 = new proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding();
          t2.readMessage(r2, proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.deserializeBinaryFromReader), e2.setQuantizedEmbedding(r2);
          break;
        case 3:
          r2 = t2.readInt32();
          e2.setHeadIndex(r2);
          break;
        case 4:
          r2 = t2.readString();
          e2.setHeadName(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.components.containers.proto.Embedding.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getFloatEmbedding()) && r2.writeMessage(1, o2, proto.mediapipe.tasks.components.containers.proto.FloatEmbedding.serializeBinaryToWriter), null != (o2 = e2.getQuantizedEmbedding()) && r2.writeMessage(2, o2, proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 3)) && r2.writeInt32(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeString(4, o2);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.getFloatEmbedding = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.tasks.components.containers.proto.FloatEmbedding, 1);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.setFloatEmbedding = function(e2) {
    return t.Message.setOneofWrapperField(this, 1, proto.mediapipe.tasks.components.containers.proto.Embedding.oneofGroups_[0], e2);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.clearFloatEmbedding = function() {
    return this.setFloatEmbedding(void 0);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.hasFloatEmbedding = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.getQuantizedEmbedding = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.tasks.components.containers.proto.QuantizedEmbedding, 2);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.setQuantizedEmbedding = function(e2) {
    return t.Message.setOneofWrapperField(this, 2, proto.mediapipe.tasks.components.containers.proto.Embedding.oneofGroups_[0], e2);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.clearQuantizedEmbedding = function() {
    return this.setQuantizedEmbedding(void 0);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.hasQuantizedEmbedding = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.getHeadIndex = function() {
    return t.Message.getFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.setHeadIndex = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.clearHeadIndex = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.hasHeadIndex = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.getHeadName = function() {
    return t.Message.getFieldWithDefault(this, 4, "");
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.setHeadName = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.clearHeadName = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.tasks.components.containers.proto.Embedding.prototype.hasHeadName = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.toObject(e2, this);
  }, proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.toObject = function(e2, r2) {
    var o2, i = { embeddingsList: t.Message.toObjectList(r2.getEmbeddingsList(), proto.mediapipe.tasks.components.containers.proto.Embedding.toObject, e2), timestampMs: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.components.containers.proto.EmbeddingResult();
    return proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new proto.mediapipe.tasks.components.containers.proto.Embedding();
          t2.readMessage(r2, proto.mediapipe.tasks.components.containers.proto.Embedding.deserializeBinaryFromReader), e2.addEmbeddings(r2);
          break;
        case 2:
          r2 = t2.readInt64();
          e2.setTimestampMs(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    (o2 = e2.getEmbeddingsList()).length > 0 && r2.writeRepeatedMessage(1, o2, proto.mediapipe.tasks.components.containers.proto.Embedding.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 2)) && r2.writeInt64(2, o2);
  }, proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.getEmbeddingsList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.tasks.components.containers.proto.Embedding, 1);
  }, proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.setEmbeddingsList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.addEmbeddings = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.tasks.components.containers.proto.Embedding, r2);
  }, proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.clearEmbeddingsList = function() {
    return this.setEmbeddingsList([]);
  }, proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.getTimestampMs = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.setTimestampMs = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.clearTimestampMs = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.components.containers.proto.EmbeddingResult.prototype.hasTimestampMs = function() {
    return null != t.Message.getField(this, 2);
  }, r.object.extend(e, proto.mediapipe.tasks.components.containers.proto);
})(embeddings_pb);
var image_embedder_graph_options_pb = {};
var embedder_options_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.tasks.components.processors.proto.EmbedderOptions", null, o), proto.mediapipe.tasks.components.processors.proto.EmbedderOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.components.processors.proto.EmbedderOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.displayName = "proto.mediapipe.tasks.components.processors.proto.EmbedderOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.toObject = function(e2, r2) {
    var o2, i = { l2Normalize: null == (o2 = t.Message.getBooleanField(r2, 1)) ? void 0 : o2, quantize: null == (o2 = t.Message.getBooleanField(r2, 2)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.components.processors.proto.EmbedderOptions();
    return proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readBool();
          e2.setL2Normalize(r2);
          break;
        case 2:
          r2 = t2.readBool();
          e2.setQuantize(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeBool(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeBool(2, o2);
  }, proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.getL2Normalize = function() {
    return t.Message.getBooleanFieldWithDefault(this, 1, false);
  }, proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.setL2Normalize = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.clearL2Normalize = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.hasL2Normalize = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.getQuantize = function() {
    return t.Message.getBooleanFieldWithDefault(this, 2, false);
  }, proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.setQuantize = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.clearQuantize = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.components.processors.proto.EmbedderOptions.prototype.hasQuantize = function() {
    return null != t.Message.getField(this, 2);
  }, r.object.extend(e, proto.mediapipe.tasks.components.processors.proto);
})(embedder_options_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = embedder_options_pb;
  r.object.extend(proto, n);
  var s = base_options_pb;
  r.object.extend(proto, s), r.exportSymbol("proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions", null, o), proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.displayName = "proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.toObject = function(e2, t2) {
    var r2, o2 = { baseOptions: (r2 = t2.getBaseOptions()) && s.BaseOptions.toObject(e2, r2), embedderOptions: (r2 = t2.getEmbedderOptions()) && n.EmbedderOptions.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions();
    return proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new s.BaseOptions();
          t2.readMessage(r2, s.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
          break;
        case 2:
          r2 = new n.EmbedderOptions();
          t2.readMessage(r2, n.EmbedderOptions.deserializeBinaryFromReader), e2.setEmbedderOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    null != (r2 = e2.getBaseOptions()) && t2.writeMessage(1, r2, s.BaseOptions.serializeBinaryToWriter), null != (r2 = e2.getEmbedderOptions()) && t2.writeMessage(2, r2, n.EmbedderOptions.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.ext = new t.ExtensionFieldInfo(476348187, { ext: 0 }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[476348187] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[476348187] = proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.ext, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, s.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.getEmbedderOptions = function() {
    return t.Message.getWrapperField(this, n.EmbedderOptions, 2);
  }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.setEmbedderOptions = function(e2) {
    return t.Message.setWrapperField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.clearEmbedderOptions = function() {
    return this.setEmbedderOptions(void 0);
  }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.prototype.hasEmbedderOptions = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.ext = new t.ExtensionFieldInfo(476348187, { ext: 0 }, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[476348187] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[476348187] = proto.mediapipe.tasks.vision.image_embedder.proto.ImageEmbedderGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.image_embedder.proto);
})(image_embedder_graph_options_pb);
var embedder_options = {};
Object.defineProperty(embedder_options, "__esModule", { value: true }), embedder_options.convertEmbedderOptionsToProto = void 0;
var embedder_options_pb_1 = embedder_options_pb;
function convertEmbedderOptionsToProto(e, t) {
  const r = t ? t.clone() : new embedder_options_pb_1.EmbedderOptions();
  return void 0 !== e.l2Normalize ? r.setL2Normalize(e.l2Normalize) : "l2Normalize" in e && r.clearL2Normalize(), void 0 !== e.quantize ? r.setQuantize(e.quantize) : "quantize" in e && r.clearQuantize(), r;
}
embedder_options.convertEmbedderOptionsToProto = convertEmbedderOptionsToProto;
var embedder_result = {};
Object.defineProperty(embedder_result, "__esModule", { value: true }), embedder_result.convertFromEmbeddingResultProto = void 0;
var DEFAULT_INDEX = -1;
function convertFromEmbeddingsProto(e) {
  var t, r, o, i;
  const a2 = { headIndex: null !== (t = e.getHeadIndex()) && void 0 !== t ? t : DEFAULT_INDEX, headName: null !== (r = e.getHeadName()) && void 0 !== r ? r : "" };
  if (e.hasFloatEmbedding()) a2.floatEmbedding = e.getFloatEmbedding().getValuesList();
  else {
    const t2 = null !== (i = null === (o = e.getQuantizedEmbedding()) || void 0 === o ? void 0 : o.getValues()) && void 0 !== i ? i : "";
    a2.quantizedEmbedding = "string" == typeof t2 ? Uint8Array.from(atob(t2), ((e2) => e2.charCodeAt(0))) : t2;
  }
  return a2;
}
function convertFromEmbeddingResultProto(e) {
  return { embeddings: e.getEmbeddingsList().map(((e2) => convertFromEmbeddingsProto(e2))), timestampMs: e.getTimestampMs() };
}
embedder_result.convertFromEmbeddingResultProto = convertFromEmbeddingResultProto;
var cosine_similarity = {};
function computeCosineSimilarity(e, t) {
  if (e.floatEmbedding && t.floatEmbedding) return compute(e.floatEmbedding, t.floatEmbedding);
  if (e.quantizedEmbedding && t.quantizedEmbedding) return compute(convertToBytes(e.quantizedEmbedding), convertToBytes(t.quantizedEmbedding));
  throw new Error("Cannot compute cosine similarity between quantized and float embeddings.");
}
function convertToBytes(e) {
  return Array.from(e, ((e2) => e2 > 127 ? e2 - 256 : e2));
}
function compute(e, t) {
  if (e.length !== t.length) throw new Error(`Cannot compute cosine similarity between embeddings of different sizes (${e.length} vs. ${t.length}).`);
  let r = 0, o = 0, i = 0;
  for (let a2 = 0; a2 < e.length; a2++) r += e[a2] * t[a2], o += e[a2] * e[a2], i += t[a2] * t[a2];
  if (o <= 0 || i <= 0) throw new Error("Cannot compute cosine similarity on embedding with 0 norm.");
  return r / Math.sqrt(o * i);
}
Object.defineProperty(cosine_similarity, "__esModule", { value: true }), cosine_similarity.computeCosineSimilarity = void 0, cosine_similarity.computeCosineSimilarity = computeCosineSimilarity;
var image_embedder_options = {};
Object.defineProperty(image_embedder_options, "__esModule", { value: true });
var image_embedder_result = {};
Object.defineProperty(image_embedder_result, "__esModule", { value: true }), (function(e) {
  var t = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2);
    var i2 = Object.getOwnPropertyDescriptor(t2, r2);
    i2 && !("get" in i2 ? !t2.__esModule : i2.writable || i2.configurable) || (i2 = { enumerable: true, get: function() {
      return t2[r2];
    } }), Object.defineProperty(e2, o2, i2);
  } : function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2), e2[o2] = t2[r2];
  }), r = commonjsGlobal && commonjsGlobal.__exportStar || function(e2, r2) {
    for (var o2 in e2) "default" === o2 || Object.prototype.hasOwnProperty.call(r2, o2) || t(r2, e2, o2);
  };
  Object.defineProperty(e, "__esModule", { value: true }), e.ImageEmbedder = void 0;
  const o = calculator_pb, i = calculator_options_pb, a2 = embeddings_pb, n = base_options_pb, s = image_embedder_graph_options_pb, p = embedder_options, d = embedder_result, l = cosine_similarity, g = vision_task_runner, c = "image_in", u = "norm_rect", m = "embeddings_out";
  r(image_embedder_options, e), r(image_embedder_result, e);
  class f extends g.VisionTaskRunner {
    static createFromOptions(e2, t2) {
      return g.VisionTaskRunner.createVisionInstance(f, e2, t2);
    }
    static createFromModelBuffer(e2, t2) {
      return g.VisionTaskRunner.createVisionInstance(f, e2, { baseOptions: { modelAssetBuffer: t2 } });
    }
    static createFromModelPath(e2, t2) {
      return g.VisionTaskRunner.createVisionInstance(f, e2, { baseOptions: { modelAssetPath: t2 } });
    }
    constructor(e2, t2) {
      super(new g.VisionGraphRunner(e2, t2), c, u, true), this.options = new s.ImageEmbedderGraphOptions(), this.embeddings = { embeddings: [] }, this.options.setBaseOptions(new n.BaseOptions());
    }
    get baseOptions() {
      return this.options.getBaseOptions();
    }
    set baseOptions(e2) {
      this.options.setBaseOptions(e2);
    }
    setOptions(e2) {
      return this.options.setEmbedderOptions((0, p.convertEmbedderOptionsToProto)(e2, this.options.getEmbedderOptions())), this.applyOptions(e2);
    }
    embed(e2, t2) {
      return this.processImageData(e2, t2), this.embeddings;
    }
    embedForVideo(e2, t2, r2) {
      return this.processVideoData(e2, r2, t2), this.embeddings;
    }
    static cosineSimilarity(e2, t2) {
      return (0, l.computeCosineSimilarity)(e2, t2);
    }
    addJsImageEmdedding(e2) {
      const t2 = a2.EmbeddingResult.deserializeBinary(e2);
      this.embeddings = (0, d.convertFromEmbeddingResultProto)(t2);
    }
    refreshGraph() {
      const e2 = new o.CalculatorGraphConfig();
      e2.addInputStream(c), e2.addInputStream(u), e2.addOutputStream(m);
      const t2 = new i.CalculatorOptions();
      t2.setExtension(s.ImageEmbedderGraphOptions.ext, this.options);
      const r2 = new o.CalculatorGraphConfig.Node();
      r2.setCalculator("mediapipe.tasks.vision.image_embedder.ImageEmbedderGraph"), r2.addInputStream("IMAGE:" + c), r2.addInputStream("NORM_RECT:" + u), r2.addOutputStream("EMBEDDINGS:" + m), r2.setOptions(t2), e2.addNode(r2), this.graphRunner.attachProtoListener(m, ((e3, t3) => {
        this.addJsImageEmdedding(e3), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(m, ((e3) => {
        this.setLatestOutputTimestamp(e3);
      }));
      const a3 = e2.serializeBinary();
      this.setGraph(new Uint8Array(a3), true);
    }
  }
  e.ImageEmbedder = f;
})(image_embedder);
var image_segmenter = {};
var tensors_to_segmentation_calculator_pb = {};
var segmenter_options_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions", null, o), r.exportSymbol("proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.Activation", null, o), r.exportSymbol("proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.OutputType", null, o), proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.displayName = "proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.toObject = function(e2, r2) {
    var o2, i = { outputType: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, activation: t.Message.getFieldWithDefault(r2, 2, 0) };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions();
    return proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readEnum();
          e2.setOutputType(r2);
          break;
        case 2:
          r2 = t2.readEnum();
          e2.setActivation(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeEnum(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeEnum(2, o2);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.OutputType = { UNSPECIFIED: 0, CATEGORY_MASK: 1, CONFIDENCE_MASK: 2 }, proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.Activation = { NONE: 0, SIGMOID: 1, SOFTMAX: 2 }, proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.getOutputType = function() {
    return t.Message.getFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.setOutputType = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.clearOutputType = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.hasOutputType = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.getActivation = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.setActivation = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.clearActivation = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.SegmenterOptions.prototype.hasActivation = function() {
    return null != t.Message.getField(this, 2);
  }, r.object.extend(e, proto.mediapipe.tasks.vision.image_segmenter.proto);
})(segmenter_options_pb);
var label_map_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.LabelMapItem", null, o), proto.mediapipe.LabelMapItem = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.LabelMapItem.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.LabelMapItem, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.LabelMapItem.displayName = "proto.mediapipe.LabelMapItem"), proto.mediapipe.LabelMapItem.repeatedFields_ = [3], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.LabelMapItem.prototype.toObject = function(e2) {
    return proto.mediapipe.LabelMapItem.toObject(e2, this);
  }, proto.mediapipe.LabelMapItem.toObject = function(e2, r2) {
    var o2, i = { name: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, displayName: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, childNameList: null == (o2 = t.Message.getRepeatedField(r2, 3)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.LabelMapItem.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.LabelMapItem();
    return proto.mediapipe.LabelMapItem.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.LabelMapItem.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setName(r2);
          break;
        case 2:
          r2 = t2.readString();
          e2.setDisplayName(r2);
          break;
        case 3:
          r2 = t2.readString();
          e2.addChildName(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.LabelMapItem.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.LabelMapItem.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.LabelMapItem.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeString(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeString(2, o2), (o2 = e2.getChildNameList()).length > 0 && r2.writeRepeatedString(3, o2);
  }, proto.mediapipe.LabelMapItem.prototype.getName = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.mediapipe.LabelMapItem.prototype.setName = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.LabelMapItem.prototype.clearName = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.LabelMapItem.prototype.hasName = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.LabelMapItem.prototype.getDisplayName = function() {
    return t.Message.getFieldWithDefault(this, 2, "");
  }, proto.mediapipe.LabelMapItem.prototype.setDisplayName = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.LabelMapItem.prototype.clearDisplayName = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.LabelMapItem.prototype.hasDisplayName = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.LabelMapItem.prototype.getChildNameList = function() {
    return t.Message.getRepeatedField(this, 3);
  }, proto.mediapipe.LabelMapItem.prototype.setChildNameList = function(e2) {
    return t.Message.setField(this, 3, e2 || []);
  }, proto.mediapipe.LabelMapItem.prototype.addChildName = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 3, e2, r2);
  }, proto.mediapipe.LabelMapItem.prototype.clearChildNameList = function() {
    return this.setChildNameList([]);
  }, r.object.extend(e, proto.mediapipe);
})(label_map_pb), (function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_options_pb;
  r.object.extend(proto, i);
  var a2 = segmenter_options_pb;
  r.object.extend(proto, a2);
  var n = label_map_pb;
  r.object.extend(proto, n), r.exportSymbol("proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions", null, o), proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.displayName = "proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.toObject = function(e2, t2) {
    var r2, o2 = { segmenterOptions: (r2 = t2.getSegmenterOptions()) && a2.SegmenterOptions.toObject(e2, r2), labelItemsMap: (r2 = t2.getLabelItemsMap()) ? r2.toObject(e2, proto.mediapipe.LabelMapItem.toObject) : [] };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions();
    return proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.deserializeBinaryFromReader = function(e2, r2) {
    for (; r2.nextField() && !r2.isEndGroup(); ) {
      switch (r2.getFieldNumber()) {
        case 1:
          var o2 = new a2.SegmenterOptions();
          r2.readMessage(o2, a2.SegmenterOptions.deserializeBinaryFromReader), e2.setSegmenterOptions(o2);
          break;
        case 2:
          o2 = e2.getLabelItemsMap();
          r2.readMessage(o2, (function(e3, r3) {
            t.Map.deserializeBinary(e3, r3, t.BinaryReader.prototype.readInt64, t.BinaryReader.prototype.readMessage, proto.mediapipe.LabelMapItem.deserializeBinaryFromReader, 0, new proto.mediapipe.LabelMapItem());
          }));
          break;
        default:
          r2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getSegmenterOptions()) && r2.writeMessage(1, o2, a2.SegmenterOptions.serializeBinaryToWriter), (o2 = e2.getLabelItemsMap(true)) && o2.getLength() > 0 && o2.serializeBinary(2, r2, t.BinaryWriter.prototype.writeInt64, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.LabelMapItem.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.ext = new t.ExtensionFieldInfo(458105876, { ext: 0 }, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.toObject, 0), i.CalculatorOptions.extensionsBinary[458105876] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.serializeBinaryToWriter, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.deserializeBinaryFromReader, false), i.CalculatorOptions.extensions[458105876] = proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.ext, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.getSegmenterOptions = function() {
    return t.Message.getWrapperField(this, a2.SegmenterOptions, 1);
  }, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.setSegmenterOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.clearSegmenterOptions = function() {
    return this.setSegmenterOptions(void 0);
  }, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.hasSegmenterOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.getLabelItemsMap = function(e2) {
    return t.Message.getMapField(this, 2, e2, proto.mediapipe.LabelMapItem);
  }, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.prototype.clearLabelItemsMap = function() {
    return this.getLabelItemsMap().clear(), this;
  }, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.ext = new t.ExtensionFieldInfo(458105876, { ext: 0 }, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.toObject, 0), i.CalculatorOptions.extensionsBinary[458105876] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.serializeBinaryToWriter, proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.deserializeBinaryFromReader, false), i.CalculatorOptions.extensions[458105876] = proto.mediapipe.tasks.TensorsToSegmentationCalculatorOptions.ext, r.object.extend(e, proto.mediapipe.tasks);
})(tensors_to_segmentation_calculator_pb);
var image_segmenter_graph_options_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = base_options_pb;
  r.object.extend(proto, n);
  var s = segmenter_options_pb;
  r.object.extend(proto, s), r.exportSymbol("proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions", null, o), proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.displayName = "proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.toObject = function(e2, r2) {
    var o2, i2 = { baseOptions: (o2 = r2.getBaseOptions()) && n.BaseOptions.toObject(e2, o2), displayNamesLocale: t.Message.getFieldWithDefault(r2, 2, "en"), segmenterOptions: (o2 = r2.getSegmenterOptions()) && s.SegmenterOptions.toObject(e2, o2) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions();
    return proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new n.BaseOptions();
          t2.readMessage(r2, n.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
          break;
        case 2:
          r2 = t2.readString();
          e2.setDisplayNamesLocale(r2);
          break;
        case 3:
          r2 = new s.SegmenterOptions();
          t2.readMessage(r2, s.SegmenterOptions.deserializeBinaryFromReader), e2.setSegmenterOptions(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getBaseOptions()) && r2.writeMessage(1, o2, n.BaseOptions.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 2)) && r2.writeString(2, o2), null != (o2 = e2.getSegmenterOptions()) && r2.writeMessage(3, o2, s.SegmenterOptions.serializeBinaryToWriter);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.ext = new t.ExtensionFieldInfo(458105758, { ext: 0 }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[458105758] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[458105758] = proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.ext, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, n.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.getDisplayNamesLocale = function() {
    return t.Message.getFieldWithDefault(this, 2, "en");
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.setDisplayNamesLocale = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.clearDisplayNamesLocale = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.hasDisplayNamesLocale = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.getSegmenterOptions = function() {
    return t.Message.getWrapperField(this, s.SegmenterOptions, 3);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.setSegmenterOptions = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.clearSegmenterOptions = function() {
    return this.setSegmenterOptions(void 0);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.prototype.hasSegmenterOptions = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.ext = new t.ExtensionFieldInfo(458105758, { ext: 0 }, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[458105758] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[458105758] = proto.mediapipe.tasks.vision.image_segmenter.proto.ImageSegmenterGraphOptions.ext, r.object.extend(e, proto.mediapipe.tasks.vision.image_segmenter.proto);
})(image_segmenter_graph_options_pb);
var image_segmenter_result = {};
Object.defineProperty(image_segmenter_result, "__esModule", { value: true }), image_segmenter_result.ImageSegmenterResult = void 0;
var ImageSegmenterResult = class {
  constructor(e, t, r) {
    this.confidenceMasks = e, this.categoryMask = t, this.qualityScores = r;
  }
  close() {
    var e, t;
    null === (e = this.confidenceMasks) || void 0 === e || e.forEach(((e2) => {
      e2.close();
    })), null === (t = this.categoryMask) || void 0 === t || t.close();
  }
};
image_segmenter_result.ImageSegmenterResult = ImageSegmenterResult;
var image_segmenter_options = {};
Object.defineProperty(image_segmenter_options, "__esModule", { value: true }), (function(e) {
  var t = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2);
    var i2 = Object.getOwnPropertyDescriptor(t2, r2);
    i2 && !("get" in i2 ? !t2.__esModule : i2.writable || i2.configurable) || (i2 = { enumerable: true, get: function() {
      return t2[r2];
    } }), Object.defineProperty(e2, o2, i2);
  } : function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2), e2[o2] = t2[r2];
  }), r = commonjsGlobal && commonjsGlobal.__exportStar || function(e2, r2) {
    for (var o2 in e2) "default" === o2 || Object.prototype.hasOwnProperty.call(r2, o2) || t(r2, e2, o2);
  };
  Object.defineProperty(e, "__esModule", { value: true }), e.ImageSegmenter = void 0;
  const o = calculator_pb, i = calculator_options_pb, a2 = base_options_pb, n = tensors_to_segmentation_calculator_pb, s = image_segmenter_graph_options_pb, p = segmenter_options_pb, d = vision_task_runner, l = image_segmenter_result;
  r(image_segmenter_options, e), r(image_segmenter_result, e);
  const g = "image_in", c = "norm_rect", u = "confidence_masks", m = "category_mask", f = "quality_scores", h = "mediapipe.tasks.TensorsToSegmentationCalculator";
  class y extends d.VisionTaskRunner {
    static createFromOptions(e2, t2) {
      return d.VisionTaskRunner.createVisionInstance(y, e2, t2);
    }
    static createFromModelBuffer(e2, t2) {
      return d.VisionTaskRunner.createVisionInstance(y, e2, { baseOptions: { modelAssetBuffer: t2 } });
    }
    static createFromModelPath(e2, t2) {
      return d.VisionTaskRunner.createVisionInstance(y, e2, { baseOptions: { modelAssetPath: t2 } });
    }
    constructor(e2, t2) {
      super(new d.VisionGraphRunner(e2, t2), g, c, false), this.labels = [], this.outputCategoryMask = false, this.outputConfidenceMasks = true, this.options = new s.ImageSegmenterGraphOptions(), this.segmenterOptions = new p.SegmenterOptions(), this.options.setSegmenterOptions(this.segmenterOptions), this.options.setBaseOptions(new a2.BaseOptions());
    }
    get baseOptions() {
      return this.options.getBaseOptions();
    }
    set baseOptions(e2) {
      this.options.setBaseOptions(e2);
    }
    setOptions(e2) {
      var t2, r2;
      return void 0 !== e2.displayNamesLocale ? this.options.setDisplayNamesLocale(e2.displayNamesLocale) : "displayNamesLocale" in e2 && this.options.clearDisplayNamesLocale(), "outputCategoryMask" in e2 && (this.outputCategoryMask = null !== (t2 = e2.outputCategoryMask) && void 0 !== t2 && t2), "outputConfidenceMasks" in e2 && (this.outputConfidenceMasks = null === (r2 = e2.outputConfidenceMasks) || void 0 === r2 || r2), super.applyOptions(e2);
    }
    onGraphRefreshed() {
      this.populateLabels();
    }
    populateLabels() {
      var e2, t2, r2;
      const o2 = this.getCalculatorGraphConfig().getNodeList().filter(((e3) => e3.getName().includes(h)));
      if (this.labels = [], o2.length > 1) throw new Error(`The graph has more than one ${h}.`);
      if (1 === o2.length) {
        (null !== (r2 = null === (t2 = null === (e2 = o2[0].getOptions()) || void 0 === e2 ? void 0 : e2.getExtension(n.TensorsToSegmentationCalculatorOptions.ext)) || void 0 === t2 ? void 0 : t2.getLabelItemsMap()) && void 0 !== r2 ? r2 : /* @__PURE__ */ new Map()).forEach(((e3, t3) => {
          this.labels[Number(t3)] = e3.getName();
        }));
      }
    }
    segment(e2, t2, r2) {
      const o2 = "function" != typeof t2 ? t2 : {};
      return this.userCallback = "function" == typeof t2 ? t2 : r2, this.reset(), this.processImageData(e2, o2), this.processResults();
    }
    segmentForVideo(e2, t2, r2, o2) {
      const i2 = "function" != typeof r2 ? r2 : {};
      return this.userCallback = "function" == typeof r2 ? r2 : o2, this.reset(), this.processVideoData(e2, i2, t2), this.processResults();
    }
    getLabels() {
      return this.labels;
    }
    reset() {
      this.categoryMask = void 0, this.confidenceMasks = void 0, this.qualityScores = void 0;
    }
    processResults() {
      try {
        const e2 = new l.ImageSegmenterResult(this.confidenceMasks, this.categoryMask, this.qualityScores);
        if (!this.userCallback) return e2;
        this.userCallback(e2);
      } finally {
        this.freeKeepaliveStreams();
      }
    }
    refreshGraph() {
      const e2 = new o.CalculatorGraphConfig();
      e2.addInputStream(g), e2.addInputStream(c);
      const t2 = new i.CalculatorOptions();
      t2.setExtension(s.ImageSegmenterGraphOptions.ext, this.options);
      const r2 = new o.CalculatorGraphConfig.Node();
      r2.setCalculator("mediapipe.tasks.vision.image_segmenter.ImageSegmenterGraph"), r2.addInputStream("IMAGE:" + g), r2.addInputStream("NORM_RECT:" + c), r2.setOptions(t2), e2.addNode(r2), this.addKeepaliveNode(e2), this.outputConfidenceMasks && (e2.addOutputStream(u), r2.addOutputStream("CONFIDENCE_MASKS:" + u), this.keepStreamAlive(u), this.graphRunner.attachImageVectorListener(u, ((e3, t3) => {
        this.confidenceMasks = e3.map(((e4) => this.convertToMPMask(e4, !this.userCallback))), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(u, ((e3) => {
        this.confidenceMasks = [], this.setLatestOutputTimestamp(e3);
      }))), this.outputCategoryMask && (e2.addOutputStream(m), r2.addOutputStream("CATEGORY_MASK:" + m), this.keepStreamAlive(m), this.graphRunner.attachImageListener(m, ((e3, t3) => {
        this.categoryMask = this.convertToMPMask(e3, !this.userCallback), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(m, ((e3) => {
        this.categoryMask = void 0, this.setLatestOutputTimestamp(e3);
      }))), e2.addOutputStream(f), r2.addOutputStream("QUALITY_SCORES:" + f), this.graphRunner.attachFloatVectorListener(f, ((e3, t3) => {
        this.qualityScores = e3, this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(f, ((e3) => {
        this.categoryMask = void 0, this.setLatestOutputTimestamp(e3);
      }));
      const a3 = e2.serializeBinary();
      this.setGraph(new Uint8Array(a3), true);
    }
  }
  e.ImageSegmenter = y;
})(image_segmenter);
var interactive_segmenter = {};
var color_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")();
  r.exportSymbol("proto.mediapipe.Color", null, o), r.exportSymbol("proto.mediapipe.ColorMap", null, o), proto.mediapipe.Color = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.Color, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.Color.displayName = "proto.mediapipe.Color"), proto.mediapipe.ColorMap = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.ColorMap, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.ColorMap.displayName = "proto.mediapipe.ColorMap"), t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.Color.prototype.toObject = function(e2) {
    return proto.mediapipe.Color.toObject(e2, this);
  }, proto.mediapipe.Color.toObject = function(e2, r2) {
    var o2, i = { r: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, g: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, b: null == (o2 = t.Message.getField(r2, 3)) ? void 0 : o2 };
    return e2 && (i.$jspbMessageInstance = r2), i;
  }), proto.mediapipe.Color.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.Color();
    return proto.mediapipe.Color.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.Color.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readInt32();
          e2.setR(r2);
          break;
        case 2:
          r2 = t2.readInt32();
          e2.setG(r2);
          break;
        case 3:
          r2 = t2.readInt32();
          e2.setB(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.Color.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.Color.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.Color.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeInt32(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeInt32(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeInt32(3, o2);
  }, proto.mediapipe.Color.prototype.getR = function() {
    return t.Message.getFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.Color.prototype.setR = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.Color.prototype.clearR = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.Color.prototype.hasR = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.Color.prototype.getG = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.Color.prototype.setG = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.Color.prototype.clearG = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.Color.prototype.hasG = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.Color.prototype.getB = function() {
    return t.Message.getFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.Color.prototype.setB = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.Color.prototype.clearB = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.Color.prototype.hasB = function() {
    return null != t.Message.getField(this, 3);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.ColorMap.prototype.toObject = function(e2) {
    return proto.mediapipe.ColorMap.toObject(e2, this);
  }, proto.mediapipe.ColorMap.toObject = function(e2, t2) {
    var r2, o2 = { labelToColorMap: (r2 = t2.getLabelToColorMap()) ? r2.toObject(e2, proto.mediapipe.Color.toObject) : [] };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.ColorMap.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.ColorMap();
    return proto.mediapipe.ColorMap.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.ColorMap.deserializeBinaryFromReader = function(e2, r2) {
    for (; r2.nextField() && !r2.isEndGroup(); ) {
      if (1 === r2.getFieldNumber()) {
        var o2 = e2.getLabelToColorMap();
        r2.readMessage(o2, (function(e3, r3) {
          t.Map.deserializeBinary(e3, r3, t.BinaryReader.prototype.readString, t.BinaryReader.prototype.readMessage, proto.mediapipe.Color.deserializeBinaryFromReader, "", new proto.mediapipe.Color());
        }));
      } else r2.skipField();
    }
    return e2;
  }, proto.mediapipe.ColorMap.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.ColorMap.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.ColorMap.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    (o2 = e2.getLabelToColorMap(true)) && o2.getLength() > 0 && o2.serializeBinary(1, r2, t.BinaryWriter.prototype.writeString, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.Color.serializeBinaryToWriter);
  }, proto.mediapipe.ColorMap.prototype.getLabelToColorMap = function(e2) {
    return t.Message.getMapField(this, 1, e2, proto.mediapipe.Color);
  }, proto.mediapipe.ColorMap.prototype.clearLabelToColorMap = function() {
    return this.getLabelToColorMap().clear(), this;
  }, r.object.extend(e, proto.mediapipe);
})(color_pb);
var render_data_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = color_pb;
  r.object.extend(proto, i), r.exportSymbol("proto.mediapipe.RenderAnnotation", null, o), r.exportSymbol("proto.mediapipe.RenderAnnotation.Arrow", null, o), r.exportSymbol("proto.mediapipe.RenderAnnotation.DataCase", null, o), r.exportSymbol("proto.mediapipe.RenderAnnotation.FilledOval", null, o), r.exportSymbol("proto.mediapipe.RenderAnnotation.FilledRectangle", null, o), r.exportSymbol("proto.mediapipe.RenderAnnotation.FilledRoundedRectangle", null, o), r.exportSymbol("proto.mediapipe.RenderAnnotation.GradientLine", null, o), r.exportSymbol("proto.mediapipe.RenderAnnotation.Line", null, o), r.exportSymbol("proto.mediapipe.RenderAnnotation.Line.LineType", null, o), r.exportSymbol("proto.mediapipe.RenderAnnotation.Oval", null, o), r.exportSymbol("proto.mediapipe.RenderAnnotation.Point", null, o), r.exportSymbol("proto.mediapipe.RenderAnnotation.Rectangle", null, o), r.exportSymbol("proto.mediapipe.RenderAnnotation.RoundedRectangle", null, o), r.exportSymbol("proto.mediapipe.RenderAnnotation.Scribble", null, o), r.exportSymbol("proto.mediapipe.RenderAnnotation.Text", null, o), r.exportSymbol("proto.mediapipe.RenderData", null, o), r.exportSymbol("proto.mediapipe.RenderViewport", null, o), proto.mediapipe.RenderData = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.RenderData.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.RenderData, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderData.displayName = "proto.mediapipe.RenderData"), proto.mediapipe.RenderAnnotation = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, proto.mediapipe.RenderAnnotation.oneofGroups_);
  }, r.inherits(proto.mediapipe.RenderAnnotation, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderAnnotation.displayName = "proto.mediapipe.RenderAnnotation"), proto.mediapipe.RenderAnnotation.Rectangle = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.RenderAnnotation.Rectangle, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderAnnotation.Rectangle.displayName = "proto.mediapipe.RenderAnnotation.Rectangle"), proto.mediapipe.RenderAnnotation.FilledRectangle = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.RenderAnnotation.FilledRectangle, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderAnnotation.FilledRectangle.displayName = "proto.mediapipe.RenderAnnotation.FilledRectangle"), proto.mediapipe.RenderAnnotation.RoundedRectangle = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.RenderAnnotation.RoundedRectangle, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderAnnotation.RoundedRectangle.displayName = "proto.mediapipe.RenderAnnotation.RoundedRectangle"), proto.mediapipe.RenderAnnotation.FilledRoundedRectangle = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.RenderAnnotation.FilledRoundedRectangle, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.displayName = "proto.mediapipe.RenderAnnotation.FilledRoundedRectangle"), proto.mediapipe.RenderAnnotation.Oval = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.RenderAnnotation.Oval, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderAnnotation.Oval.displayName = "proto.mediapipe.RenderAnnotation.Oval"), proto.mediapipe.RenderAnnotation.FilledOval = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.RenderAnnotation.FilledOval, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderAnnotation.FilledOval.displayName = "proto.mediapipe.RenderAnnotation.FilledOval"), proto.mediapipe.RenderAnnotation.Point = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.RenderAnnotation.Point, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderAnnotation.Point.displayName = "proto.mediapipe.RenderAnnotation.Point"), proto.mediapipe.RenderAnnotation.Line = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.RenderAnnotation.Line, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderAnnotation.Line.displayName = "proto.mediapipe.RenderAnnotation.Line"), proto.mediapipe.RenderAnnotation.GradientLine = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.RenderAnnotation.GradientLine, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderAnnotation.GradientLine.displayName = "proto.mediapipe.RenderAnnotation.GradientLine"), proto.mediapipe.RenderAnnotation.Scribble = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.RenderAnnotation.Scribble.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.RenderAnnotation.Scribble, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderAnnotation.Scribble.displayName = "proto.mediapipe.RenderAnnotation.Scribble"), proto.mediapipe.RenderAnnotation.Arrow = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.RenderAnnotation.Arrow, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderAnnotation.Arrow.displayName = "proto.mediapipe.RenderAnnotation.Arrow"), proto.mediapipe.RenderAnnotation.Text = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.RenderAnnotation.Text, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderAnnotation.Text.displayName = "proto.mediapipe.RenderAnnotation.Text"), proto.mediapipe.RenderViewport = function(e2) {
    t.Message.initialize(this, e2, 0, -1, null, null);
  }, r.inherits(proto.mediapipe.RenderViewport, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.RenderViewport.displayName = "proto.mediapipe.RenderViewport"), proto.mediapipe.RenderData.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderData.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderData.toObject(e2, this);
  }, proto.mediapipe.RenderData.toObject = function(e2, r2) {
    var o2, i2 = { renderAnnotationsList: t.Message.toObjectList(r2.getRenderAnnotationsList(), proto.mediapipe.RenderAnnotation.toObject, e2), sceneClass: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, sceneViewport: (o2 = r2.getSceneViewport()) && proto.mediapipe.RenderViewport.toObject(e2, o2) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.RenderData.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderData();
    return proto.mediapipe.RenderData.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderData.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new proto.mediapipe.RenderAnnotation();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.deserializeBinaryFromReader), e2.addRenderAnnotations(r2);
          break;
        case 2:
          r2 = t2.readString();
          e2.setSceneClass(r2);
          break;
        case 3:
          r2 = new proto.mediapipe.RenderViewport();
          t2.readMessage(r2, proto.mediapipe.RenderViewport.deserializeBinaryFromReader), e2.setSceneViewport(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.RenderData.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderData.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderData.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    (o2 = e2.getRenderAnnotationsList()).length > 0 && r2.writeRepeatedMessage(1, o2, proto.mediapipe.RenderAnnotation.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 2)) && r2.writeString(2, o2), null != (o2 = e2.getSceneViewport()) && r2.writeMessage(3, o2, proto.mediapipe.RenderViewport.serializeBinaryToWriter);
  }, proto.mediapipe.RenderData.prototype.getRenderAnnotationsList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.RenderAnnotation, 1);
  }, proto.mediapipe.RenderData.prototype.setRenderAnnotationsList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.RenderData.prototype.addRenderAnnotations = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.RenderAnnotation, r2);
  }, proto.mediapipe.RenderData.prototype.clearRenderAnnotationsList = function() {
    return this.setRenderAnnotationsList([]);
  }, proto.mediapipe.RenderData.prototype.getSceneClass = function() {
    return t.Message.getFieldWithDefault(this, 2, "");
  }, proto.mediapipe.RenderData.prototype.setSceneClass = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.RenderData.prototype.clearSceneClass = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.RenderData.prototype.hasSceneClass = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.RenderData.prototype.getSceneViewport = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderViewport, 3);
  }, proto.mediapipe.RenderData.prototype.setSceneViewport = function(e2) {
    return t.Message.setWrapperField(this, 3, e2);
  }, proto.mediapipe.RenderData.prototype.clearSceneViewport = function() {
    return this.setSceneViewport(void 0);
  }, proto.mediapipe.RenderData.prototype.hasSceneViewport = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.RenderAnnotation.oneofGroups_ = [[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 14, 15]], proto.mediapipe.RenderAnnotation.DataCase = { DATA_NOT_SET: 0, RECTANGLE: 1, FILLED_RECTANGLE: 2, OVAL: 3, FILLED_OVAL: 4, POINT: 5, LINE: 6, ARROW: 7, TEXT: 8, ROUNDED_RECTANGLE: 9, FILLED_ROUNDED_RECTANGLE: 10, GRADIENT_LINE: 14, SCRIBBLE: 15 }, proto.mediapipe.RenderAnnotation.prototype.getDataCase = function() {
    return t.Message.computeOneofCase(this, proto.mediapipe.RenderAnnotation.oneofGroups_[0]);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderAnnotation.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderAnnotation.toObject(e2, this);
  }, proto.mediapipe.RenderAnnotation.toObject = function(e2, r2) {
    var o2, a2 = { rectangle: (o2 = r2.getRectangle()) && proto.mediapipe.RenderAnnotation.Rectangle.toObject(e2, o2), filledRectangle: (o2 = r2.getFilledRectangle()) && proto.mediapipe.RenderAnnotation.FilledRectangle.toObject(e2, o2), oval: (o2 = r2.getOval()) && proto.mediapipe.RenderAnnotation.Oval.toObject(e2, o2), filledOval: (o2 = r2.getFilledOval()) && proto.mediapipe.RenderAnnotation.FilledOval.toObject(e2, o2), point: (o2 = r2.getPoint()) && proto.mediapipe.RenderAnnotation.Point.toObject(e2, o2), line: (o2 = r2.getLine()) && proto.mediapipe.RenderAnnotation.Line.toObject(e2, o2), arrow: (o2 = r2.getArrow()) && proto.mediapipe.RenderAnnotation.Arrow.toObject(e2, o2), text: (o2 = r2.getText()) && proto.mediapipe.RenderAnnotation.Text.toObject(e2, o2), roundedRectangle: (o2 = r2.getRoundedRectangle()) && proto.mediapipe.RenderAnnotation.RoundedRectangle.toObject(e2, o2), filledRoundedRectangle: (o2 = r2.getFilledRoundedRectangle()) && proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.toObject(e2, o2), gradientLine: (o2 = r2.getGradientLine()) && proto.mediapipe.RenderAnnotation.GradientLine.toObject(e2, o2), scribble: (o2 = r2.getScribble()) && proto.mediapipe.RenderAnnotation.Scribble.toObject(e2, o2), thickness: t.Message.getFloatingPointFieldWithDefault(r2, 11, 1), color: (o2 = r2.getColor()) && i.Color.toObject(e2, o2), sceneTag: null == (o2 = t.Message.getField(r2, 13)) ? void 0 : o2 };
    return e2 && (a2.$jspbMessageInstance = r2), a2;
  }), proto.mediapipe.RenderAnnotation.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderAnnotation();
    return proto.mediapipe.RenderAnnotation.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderAnnotation.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new proto.mediapipe.RenderAnnotation.Rectangle();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.Rectangle.deserializeBinaryFromReader), e2.setRectangle(r2);
          break;
        case 2:
          r2 = new proto.mediapipe.RenderAnnotation.FilledRectangle();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.FilledRectangle.deserializeBinaryFromReader), e2.setFilledRectangle(r2);
          break;
        case 3:
          r2 = new proto.mediapipe.RenderAnnotation.Oval();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.Oval.deserializeBinaryFromReader), e2.setOval(r2);
          break;
        case 4:
          r2 = new proto.mediapipe.RenderAnnotation.FilledOval();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.FilledOval.deserializeBinaryFromReader), e2.setFilledOval(r2);
          break;
        case 5:
          r2 = new proto.mediapipe.RenderAnnotation.Point();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.Point.deserializeBinaryFromReader), e2.setPoint(r2);
          break;
        case 6:
          r2 = new proto.mediapipe.RenderAnnotation.Line();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.Line.deserializeBinaryFromReader), e2.setLine(r2);
          break;
        case 7:
          r2 = new proto.mediapipe.RenderAnnotation.Arrow();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.Arrow.deserializeBinaryFromReader), e2.setArrow(r2);
          break;
        case 8:
          r2 = new proto.mediapipe.RenderAnnotation.Text();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.Text.deserializeBinaryFromReader), e2.setText(r2);
          break;
        case 9:
          r2 = new proto.mediapipe.RenderAnnotation.RoundedRectangle();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.RoundedRectangle.deserializeBinaryFromReader), e2.setRoundedRectangle(r2);
          break;
        case 10:
          r2 = new proto.mediapipe.RenderAnnotation.FilledRoundedRectangle();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.deserializeBinaryFromReader), e2.setFilledRoundedRectangle(r2);
          break;
        case 14:
          r2 = new proto.mediapipe.RenderAnnotation.GradientLine();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.GradientLine.deserializeBinaryFromReader), e2.setGradientLine(r2);
          break;
        case 15:
          r2 = new proto.mediapipe.RenderAnnotation.Scribble();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.Scribble.deserializeBinaryFromReader), e2.setScribble(r2);
          break;
        case 11:
          r2 = t2.readDouble();
          e2.setThickness(r2);
          break;
        case 12:
          r2 = new i.Color();
          t2.readMessage(r2, i.Color.deserializeBinaryFromReader), e2.setColor(r2);
          break;
        case 13:
          r2 = t2.readString();
          e2.setSceneTag(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.RenderAnnotation.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderAnnotation.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderAnnotation.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getRectangle()) && r2.writeMessage(1, o2, proto.mediapipe.RenderAnnotation.Rectangle.serializeBinaryToWriter), null != (o2 = e2.getFilledRectangle()) && r2.writeMessage(2, o2, proto.mediapipe.RenderAnnotation.FilledRectangle.serializeBinaryToWriter), null != (o2 = e2.getOval()) && r2.writeMessage(3, o2, proto.mediapipe.RenderAnnotation.Oval.serializeBinaryToWriter), null != (o2 = e2.getFilledOval()) && r2.writeMessage(4, o2, proto.mediapipe.RenderAnnotation.FilledOval.serializeBinaryToWriter), null != (o2 = e2.getPoint()) && r2.writeMessage(5, o2, proto.mediapipe.RenderAnnotation.Point.serializeBinaryToWriter), null != (o2 = e2.getLine()) && r2.writeMessage(6, o2, proto.mediapipe.RenderAnnotation.Line.serializeBinaryToWriter), null != (o2 = e2.getArrow()) && r2.writeMessage(7, o2, proto.mediapipe.RenderAnnotation.Arrow.serializeBinaryToWriter), null != (o2 = e2.getText()) && r2.writeMessage(8, o2, proto.mediapipe.RenderAnnotation.Text.serializeBinaryToWriter), null != (o2 = e2.getRoundedRectangle()) && r2.writeMessage(9, o2, proto.mediapipe.RenderAnnotation.RoundedRectangle.serializeBinaryToWriter), null != (o2 = e2.getFilledRoundedRectangle()) && r2.writeMessage(10, o2, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.serializeBinaryToWriter), null != (o2 = e2.getGradientLine()) && r2.writeMessage(14, o2, proto.mediapipe.RenderAnnotation.GradientLine.serializeBinaryToWriter), null != (o2 = e2.getScribble()) && r2.writeMessage(15, o2, proto.mediapipe.RenderAnnotation.Scribble.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 11)) && r2.writeDouble(11, o2), null != (o2 = e2.getColor()) && r2.writeMessage(12, o2, i.Color.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 13)) && r2.writeString(13, o2);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderAnnotation.Rectangle.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderAnnotation.Rectangle.toObject(e2, this);
  }, proto.mediapipe.RenderAnnotation.Rectangle.toObject = function(e2, r2) {
    var o2, i2 = { left: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 1)) ? void 0 : o2, top: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 2)) ? void 0 : o2, right: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 3)) ? void 0 : o2, bottom: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 4)) ? void 0 : o2, normalized: t.Message.getBooleanFieldWithDefault(r2, 5, false), rotation: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 6)) ? void 0 : o2, topLeftThickness: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 7)) ? void 0 : o2 };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.RenderAnnotation.Rectangle.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderAnnotation.Rectangle();
    return proto.mediapipe.RenderAnnotation.Rectangle.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderAnnotation.Rectangle.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readDouble();
          e2.setLeft(r2);
          break;
        case 2:
          r2 = t2.readDouble();
          e2.setTop(r2);
          break;
        case 3:
          r2 = t2.readDouble();
          e2.setRight(r2);
          break;
        case 4:
          r2 = t2.readDouble();
          e2.setBottom(r2);
          break;
        case 5:
          r2 = t2.readBool();
          e2.setNormalized(r2);
          break;
        case 6:
          r2 = t2.readDouble();
          e2.setRotation(r2);
          break;
        case 7:
          r2 = t2.readDouble();
          e2.setTopLeftThickness(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderAnnotation.Rectangle.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderAnnotation.Rectangle.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeDouble(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeDouble(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeDouble(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeDouble(4, o2), null != (o2 = t.Message.getField(e2, 5)) && r2.writeBool(5, o2), null != (o2 = t.Message.getField(e2, 6)) && r2.writeDouble(6, o2), null != (o2 = t.Message.getField(e2, 7)) && r2.writeDouble(7, o2);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.getLeft = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.setLeft = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.clearLeft = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.hasLeft = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.getTop = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.setTop = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.clearTop = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.hasTop = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.getRight = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.setRight = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.clearRight = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.hasRight = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.getBottom = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.setBottom = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.clearBottom = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.hasBottom = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.getNormalized = function() {
    return t.Message.getBooleanFieldWithDefault(this, 5, false);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.setNormalized = function(e2) {
    return t.Message.setField(this, 5, e2);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.clearNormalized = function() {
    return t.Message.setField(this, 5, void 0);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.hasNormalized = function() {
    return null != t.Message.getField(this, 5);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.getRotation = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 6, 0);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.setRotation = function(e2) {
    return t.Message.setField(this, 6, e2);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.clearRotation = function() {
    return t.Message.setField(this, 6, void 0);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.hasRotation = function() {
    return null != t.Message.getField(this, 6);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.getTopLeftThickness = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 7, 0);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.setTopLeftThickness = function(e2) {
    return t.Message.setField(this, 7, e2);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.clearTopLeftThickness = function() {
    return t.Message.setField(this, 7, void 0);
  }, proto.mediapipe.RenderAnnotation.Rectangle.prototype.hasTopLeftThickness = function() {
    return null != t.Message.getField(this, 7);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderAnnotation.FilledRectangle.toObject(e2, this);
  }, proto.mediapipe.RenderAnnotation.FilledRectangle.toObject = function(e2, t2) {
    var r2, o2 = { rectangle: (r2 = t2.getRectangle()) && proto.mediapipe.RenderAnnotation.Rectangle.toObject(e2, r2), fillColor: (r2 = t2.getFillColor()) && i.Color.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.RenderAnnotation.FilledRectangle.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderAnnotation.FilledRectangle();
    return proto.mediapipe.RenderAnnotation.FilledRectangle.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderAnnotation.FilledRectangle.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new proto.mediapipe.RenderAnnotation.Rectangle();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.Rectangle.deserializeBinaryFromReader), e2.setRectangle(r2);
          break;
        case 2:
          r2 = new i.Color();
          t2.readMessage(r2, i.Color.deserializeBinaryFromReader), e2.setFillColor(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderAnnotation.FilledRectangle.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderAnnotation.FilledRectangle.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    null != (r2 = e2.getRectangle()) && t2.writeMessage(1, r2, proto.mediapipe.RenderAnnotation.Rectangle.serializeBinaryToWriter), null != (r2 = e2.getFillColor()) && t2.writeMessage(2, r2, i.Color.serializeBinaryToWriter);
  }, proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.getRectangle = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.Rectangle, 1);
  }, proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.setRectangle = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.clearRectangle = function() {
    return this.setRectangle(void 0);
  }, proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.hasRectangle = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.getFillColor = function() {
    return t.Message.getWrapperField(this, i.Color, 2);
  }, proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.setFillColor = function(e2) {
    return t.Message.setWrapperField(this, 2, e2);
  }, proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.clearFillColor = function() {
    return this.setFillColor(void 0);
  }, proto.mediapipe.RenderAnnotation.FilledRectangle.prototype.hasFillColor = function() {
    return null != t.Message.getField(this, 2);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderAnnotation.RoundedRectangle.toObject(e2, this);
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.toObject = function(e2, r2) {
    var o2, i2 = { rectangle: (o2 = r2.getRectangle()) && proto.mediapipe.RenderAnnotation.Rectangle.toObject(e2, o2), cornerRadius: t.Message.getFieldWithDefault(r2, 2, 0), lineType: t.Message.getFieldWithDefault(r2, 3, 4) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.RenderAnnotation.RoundedRectangle.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderAnnotation.RoundedRectangle();
    return proto.mediapipe.RenderAnnotation.RoundedRectangle.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new proto.mediapipe.RenderAnnotation.Rectangle();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.Rectangle.deserializeBinaryFromReader), e2.setRectangle(r2);
          break;
        case 2:
          r2 = t2.readInt32();
          e2.setCornerRadius(r2);
          break;
        case 3:
          r2 = t2.readInt32();
          e2.setLineType(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderAnnotation.RoundedRectangle.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getRectangle()) && r2.writeMessage(1, o2, proto.mediapipe.RenderAnnotation.Rectangle.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 2)) && r2.writeInt32(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeInt32(3, o2);
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.getRectangle = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.Rectangle, 1);
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.setRectangle = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.clearRectangle = function() {
    return this.setRectangle(void 0);
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.hasRectangle = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.getCornerRadius = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.setCornerRadius = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.clearCornerRadius = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.hasCornerRadius = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.getLineType = function() {
    return t.Message.getFieldWithDefault(this, 3, 4);
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.setLineType = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.clearLineType = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.RenderAnnotation.RoundedRectangle.prototype.hasLineType = function() {
    return null != t.Message.getField(this, 3);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.toObject(e2, this);
  }, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.toObject = function(e2, t2) {
    var r2, o2 = { roundedRectangle: (r2 = t2.getRoundedRectangle()) && proto.mediapipe.RenderAnnotation.RoundedRectangle.toObject(e2, r2), fillColor: (r2 = t2.getFillColor()) && i.Color.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderAnnotation.FilledRoundedRectangle();
    return proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new proto.mediapipe.RenderAnnotation.RoundedRectangle();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.RoundedRectangle.deserializeBinaryFromReader), e2.setRoundedRectangle(r2);
          break;
        case 2:
          r2 = new i.Color();
          t2.readMessage(r2, i.Color.deserializeBinaryFromReader), e2.setFillColor(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    null != (r2 = e2.getRoundedRectangle()) && t2.writeMessage(1, r2, proto.mediapipe.RenderAnnotation.RoundedRectangle.serializeBinaryToWriter), null != (r2 = e2.getFillColor()) && t2.writeMessage(2, r2, i.Color.serializeBinaryToWriter);
  }, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.getRoundedRectangle = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.RoundedRectangle, 1);
  }, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.setRoundedRectangle = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.clearRoundedRectangle = function() {
    return this.setRoundedRectangle(void 0);
  }, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.hasRoundedRectangle = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.getFillColor = function() {
    return t.Message.getWrapperField(this, i.Color, 2);
  }, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.setFillColor = function(e2) {
    return t.Message.setWrapperField(this, 2, e2);
  }, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.clearFillColor = function() {
    return this.setFillColor(void 0);
  }, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle.prototype.hasFillColor = function() {
    return null != t.Message.getField(this, 2);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderAnnotation.Oval.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderAnnotation.Oval.toObject(e2, this);
  }, proto.mediapipe.RenderAnnotation.Oval.toObject = function(e2, t2) {
    var r2, o2 = { rectangle: (r2 = t2.getRectangle()) && proto.mediapipe.RenderAnnotation.Rectangle.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.RenderAnnotation.Oval.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderAnnotation.Oval();
    return proto.mediapipe.RenderAnnotation.Oval.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderAnnotation.Oval.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new proto.mediapipe.RenderAnnotation.Rectangle();
        t2.readMessage(r2, proto.mediapipe.RenderAnnotation.Rectangle.deserializeBinaryFromReader), e2.setRectangle(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.RenderAnnotation.Oval.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderAnnotation.Oval.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderAnnotation.Oval.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    null != (r2 = e2.getRectangle()) && t2.writeMessage(1, r2, proto.mediapipe.RenderAnnotation.Rectangle.serializeBinaryToWriter);
  }, proto.mediapipe.RenderAnnotation.Oval.prototype.getRectangle = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.Rectangle, 1);
  }, proto.mediapipe.RenderAnnotation.Oval.prototype.setRectangle = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.RenderAnnotation.Oval.prototype.clearRectangle = function() {
    return this.setRectangle(void 0);
  }, proto.mediapipe.RenderAnnotation.Oval.prototype.hasRectangle = function() {
    return null != t.Message.getField(this, 1);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderAnnotation.FilledOval.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderAnnotation.FilledOval.toObject(e2, this);
  }, proto.mediapipe.RenderAnnotation.FilledOval.toObject = function(e2, t2) {
    var r2, o2 = { oval: (r2 = t2.getOval()) && proto.mediapipe.RenderAnnotation.Oval.toObject(e2, r2), fillColor: (r2 = t2.getFillColor()) && i.Color.toObject(e2, r2) };
    return e2 && (o2.$jspbMessageInstance = t2), o2;
  }), proto.mediapipe.RenderAnnotation.FilledOval.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderAnnotation.FilledOval();
    return proto.mediapipe.RenderAnnotation.FilledOval.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderAnnotation.FilledOval.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new proto.mediapipe.RenderAnnotation.Oval();
          t2.readMessage(r2, proto.mediapipe.RenderAnnotation.Oval.deserializeBinaryFromReader), e2.setOval(r2);
          break;
        case 2:
          r2 = new i.Color();
          t2.readMessage(r2, i.Color.deserializeBinaryFromReader), e2.setFillColor(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.RenderAnnotation.FilledOval.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderAnnotation.FilledOval.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderAnnotation.FilledOval.serializeBinaryToWriter = function(e2, t2) {
    var r2 = void 0;
    null != (r2 = e2.getOval()) && t2.writeMessage(1, r2, proto.mediapipe.RenderAnnotation.Oval.serializeBinaryToWriter), null != (r2 = e2.getFillColor()) && t2.writeMessage(2, r2, i.Color.serializeBinaryToWriter);
  }, proto.mediapipe.RenderAnnotation.FilledOval.prototype.getOval = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.Oval, 1);
  }, proto.mediapipe.RenderAnnotation.FilledOval.prototype.setOval = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.RenderAnnotation.FilledOval.prototype.clearOval = function() {
    return this.setOval(void 0);
  }, proto.mediapipe.RenderAnnotation.FilledOval.prototype.hasOval = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.RenderAnnotation.FilledOval.prototype.getFillColor = function() {
    return t.Message.getWrapperField(this, i.Color, 2);
  }, proto.mediapipe.RenderAnnotation.FilledOval.prototype.setFillColor = function(e2) {
    return t.Message.setWrapperField(this, 2, e2);
  }, proto.mediapipe.RenderAnnotation.FilledOval.prototype.clearFillColor = function() {
    return this.setFillColor(void 0);
  }, proto.mediapipe.RenderAnnotation.FilledOval.prototype.hasFillColor = function() {
    return null != t.Message.getField(this, 2);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderAnnotation.Point.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderAnnotation.Point.toObject(e2, this);
  }, proto.mediapipe.RenderAnnotation.Point.toObject = function(e2, r2) {
    var o2, i2 = { x: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 1)) ? void 0 : o2, y: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 2)) ? void 0 : o2, normalized: t.Message.getBooleanFieldWithDefault(r2, 3, false) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.RenderAnnotation.Point.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderAnnotation.Point();
    return proto.mediapipe.RenderAnnotation.Point.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderAnnotation.Point.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readDouble();
          e2.setX(r2);
          break;
        case 2:
          r2 = t2.readDouble();
          e2.setY(r2);
          break;
        case 3:
          r2 = t2.readBool();
          e2.setNormalized(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.RenderAnnotation.Point.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderAnnotation.Point.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderAnnotation.Point.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeDouble(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeDouble(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeBool(3, o2);
  }, proto.mediapipe.RenderAnnotation.Point.prototype.getX = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.RenderAnnotation.Point.prototype.setX = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.RenderAnnotation.Point.prototype.clearX = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.RenderAnnotation.Point.prototype.hasX = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.RenderAnnotation.Point.prototype.getY = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.RenderAnnotation.Point.prototype.setY = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.RenderAnnotation.Point.prototype.clearY = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.RenderAnnotation.Point.prototype.hasY = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.RenderAnnotation.Point.prototype.getNormalized = function() {
    return t.Message.getBooleanFieldWithDefault(this, 3, false);
  }, proto.mediapipe.RenderAnnotation.Point.prototype.setNormalized = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.RenderAnnotation.Point.prototype.clearNormalized = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.RenderAnnotation.Point.prototype.hasNormalized = function() {
    return null != t.Message.getField(this, 3);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderAnnotation.Line.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderAnnotation.Line.toObject(e2, this);
  }, proto.mediapipe.RenderAnnotation.Line.toObject = function(e2, r2) {
    var o2, i2 = { xStart: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 1)) ? void 0 : o2, yStart: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 2)) ? void 0 : o2, xEnd: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 3)) ? void 0 : o2, yEnd: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 4)) ? void 0 : o2, normalized: t.Message.getBooleanFieldWithDefault(r2, 5, false), lineType: t.Message.getFieldWithDefault(r2, 6, 1) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.RenderAnnotation.Line.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderAnnotation.Line();
    return proto.mediapipe.RenderAnnotation.Line.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderAnnotation.Line.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readDouble();
          e2.setXStart(r2);
          break;
        case 2:
          r2 = t2.readDouble();
          e2.setYStart(r2);
          break;
        case 3:
          r2 = t2.readDouble();
          e2.setXEnd(r2);
          break;
        case 4:
          r2 = t2.readDouble();
          e2.setYEnd(r2);
          break;
        case 5:
          r2 = t2.readBool();
          e2.setNormalized(r2);
          break;
        case 6:
          r2 = t2.readEnum();
          e2.setLineType(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.RenderAnnotation.Line.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderAnnotation.Line.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderAnnotation.Line.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeDouble(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeDouble(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeDouble(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeDouble(4, o2), null != (o2 = t.Message.getField(e2, 5)) && r2.writeBool(5, o2), null != (o2 = t.Message.getField(e2, 6)) && r2.writeEnum(6, o2);
  }, proto.mediapipe.RenderAnnotation.Line.LineType = { UNKNOWN: 0, SOLID: 1, DASHED: 2 }, proto.mediapipe.RenderAnnotation.Line.prototype.getXStart = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.setXStart = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.clearXStart = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.hasXStart = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.getYStart = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.setYStart = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.clearYStart = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.hasYStart = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.getXEnd = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.setXEnd = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.clearXEnd = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.hasXEnd = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.getYEnd = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.setYEnd = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.clearYEnd = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.hasYEnd = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.getNormalized = function() {
    return t.Message.getBooleanFieldWithDefault(this, 5, false);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.setNormalized = function(e2) {
    return t.Message.setField(this, 5, e2);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.clearNormalized = function() {
    return t.Message.setField(this, 5, void 0);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.hasNormalized = function() {
    return null != t.Message.getField(this, 5);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.getLineType = function() {
    return t.Message.getFieldWithDefault(this, 6, 1);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.setLineType = function(e2) {
    return t.Message.setField(this, 6, e2);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.clearLineType = function() {
    return t.Message.setField(this, 6, void 0);
  }, proto.mediapipe.RenderAnnotation.Line.prototype.hasLineType = function() {
    return null != t.Message.getField(this, 6);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderAnnotation.GradientLine.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderAnnotation.GradientLine.toObject(e2, this);
  }, proto.mediapipe.RenderAnnotation.GradientLine.toObject = function(e2, r2) {
    var o2, a2 = { xStart: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 1)) ? void 0 : o2, yStart: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 2)) ? void 0 : o2, xEnd: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 3)) ? void 0 : o2, yEnd: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 4)) ? void 0 : o2, normalized: t.Message.getBooleanFieldWithDefault(r2, 5, false), color1: (o2 = r2.getColor1()) && i.Color.toObject(e2, o2), color2: (o2 = r2.getColor2()) && i.Color.toObject(e2, o2) };
    return e2 && (a2.$jspbMessageInstance = r2), a2;
  }), proto.mediapipe.RenderAnnotation.GradientLine.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderAnnotation.GradientLine();
    return proto.mediapipe.RenderAnnotation.GradientLine.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderAnnotation.GradientLine.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readDouble();
          e2.setXStart(r2);
          break;
        case 2:
          r2 = t2.readDouble();
          e2.setYStart(r2);
          break;
        case 3:
          r2 = t2.readDouble();
          e2.setXEnd(r2);
          break;
        case 4:
          r2 = t2.readDouble();
          e2.setYEnd(r2);
          break;
        case 5:
          r2 = t2.readBool();
          e2.setNormalized(r2);
          break;
        case 6:
          r2 = new i.Color();
          t2.readMessage(r2, i.Color.deserializeBinaryFromReader), e2.setColor1(r2);
          break;
        case 7:
          r2 = new i.Color();
          t2.readMessage(r2, i.Color.deserializeBinaryFromReader), e2.setColor2(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderAnnotation.GradientLine.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderAnnotation.GradientLine.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeDouble(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeDouble(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeDouble(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeDouble(4, o2), null != (o2 = t.Message.getField(e2, 5)) && r2.writeBool(5, o2), null != (o2 = e2.getColor1()) && r2.writeMessage(6, o2, i.Color.serializeBinaryToWriter), null != (o2 = e2.getColor2()) && r2.writeMessage(7, o2, i.Color.serializeBinaryToWriter);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.getXStart = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.setXStart = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.clearXStart = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.hasXStart = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.getYStart = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.setYStart = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.clearYStart = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.hasYStart = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.getXEnd = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.setXEnd = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.clearXEnd = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.hasXEnd = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.getYEnd = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.setYEnd = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.clearYEnd = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.hasYEnd = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.getNormalized = function() {
    return t.Message.getBooleanFieldWithDefault(this, 5, false);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.setNormalized = function(e2) {
    return t.Message.setField(this, 5, e2);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.clearNormalized = function() {
    return t.Message.setField(this, 5, void 0);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.hasNormalized = function() {
    return null != t.Message.getField(this, 5);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.getColor1 = function() {
    return t.Message.getWrapperField(this, i.Color, 6);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.setColor1 = function(e2) {
    return t.Message.setWrapperField(this, 6, e2);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.clearColor1 = function() {
    return this.setColor1(void 0);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.hasColor1 = function() {
    return null != t.Message.getField(this, 6);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.getColor2 = function() {
    return t.Message.getWrapperField(this, i.Color, 7);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.setColor2 = function(e2) {
    return t.Message.setWrapperField(this, 7, e2);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.clearColor2 = function() {
    return this.setColor2(void 0);
  }, proto.mediapipe.RenderAnnotation.GradientLine.prototype.hasColor2 = function() {
    return null != t.Message.getField(this, 7);
  }, proto.mediapipe.RenderAnnotation.Scribble.repeatedFields_ = [1], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderAnnotation.Scribble.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderAnnotation.Scribble.toObject(e2, this);
  }, proto.mediapipe.RenderAnnotation.Scribble.toObject = function(e2, r2) {
    var o2 = { pointList: t.Message.toObjectList(r2.getPointList(), proto.mediapipe.RenderAnnotation.Point.toObject, e2) };
    return e2 && (o2.$jspbMessageInstance = r2), o2;
  }), proto.mediapipe.RenderAnnotation.Scribble.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderAnnotation.Scribble();
    return proto.mediapipe.RenderAnnotation.Scribble.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderAnnotation.Scribble.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      if (1 === t2.getFieldNumber()) {
        var r2 = new proto.mediapipe.RenderAnnotation.Point();
        t2.readMessage(r2, proto.mediapipe.RenderAnnotation.Point.deserializeBinaryFromReader), e2.addPoint(r2);
      } else t2.skipField();
    }
    return e2;
  }, proto.mediapipe.RenderAnnotation.Scribble.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderAnnotation.Scribble.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderAnnotation.Scribble.serializeBinaryToWriter = function(e2, t2) {
    var r2;
    (r2 = e2.getPointList()).length > 0 && t2.writeRepeatedMessage(1, r2, proto.mediapipe.RenderAnnotation.Point.serializeBinaryToWriter);
  }, proto.mediapipe.RenderAnnotation.Scribble.prototype.getPointList = function() {
    return t.Message.getRepeatedWrapperField(this, proto.mediapipe.RenderAnnotation.Point, 1);
  }, proto.mediapipe.RenderAnnotation.Scribble.prototype.setPointList = function(e2) {
    return t.Message.setRepeatedWrapperField(this, 1, e2);
  }, proto.mediapipe.RenderAnnotation.Scribble.prototype.addPoint = function(e2, r2) {
    return t.Message.addToRepeatedWrapperField(this, 1, e2, proto.mediapipe.RenderAnnotation.Point, r2);
  }, proto.mediapipe.RenderAnnotation.Scribble.prototype.clearPointList = function() {
    return this.setPointList([]);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderAnnotation.Arrow.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderAnnotation.Arrow.toObject(e2, this);
  }, proto.mediapipe.RenderAnnotation.Arrow.toObject = function(e2, r2) {
    var o2, i2 = { xStart: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 1)) ? void 0 : o2, yStart: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 2)) ? void 0 : o2, xEnd: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 3)) ? void 0 : o2, yEnd: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 4)) ? void 0 : o2, normalized: t.Message.getBooleanFieldWithDefault(r2, 5, false) };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.RenderAnnotation.Arrow.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderAnnotation.Arrow();
    return proto.mediapipe.RenderAnnotation.Arrow.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderAnnotation.Arrow.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readDouble();
          e2.setXStart(r2);
          break;
        case 2:
          r2 = t2.readDouble();
          e2.setYStart(r2);
          break;
        case 3:
          r2 = t2.readDouble();
          e2.setXEnd(r2);
          break;
        case 4:
          r2 = t2.readDouble();
          e2.setYEnd(r2);
          break;
        case 5:
          r2 = t2.readBool();
          e2.setNormalized(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderAnnotation.Arrow.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderAnnotation.Arrow.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeDouble(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeDouble(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeDouble(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeDouble(4, o2), null != (o2 = t.Message.getField(e2, 5)) && r2.writeBool(5, o2);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.getXStart = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 1, 0);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.setXStart = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.clearXStart = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.hasXStart = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.getYStart = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.setYStart = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.clearYStart = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.hasYStart = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.getXEnd = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.setXEnd = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.clearXEnd = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.hasXEnd = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.getYEnd = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.setYEnd = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.clearYEnd = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.hasYEnd = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.getNormalized = function() {
    return t.Message.getBooleanFieldWithDefault(this, 5, false);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.setNormalized = function(e2) {
    return t.Message.setField(this, 5, e2);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.clearNormalized = function() {
    return t.Message.setField(this, 5, void 0);
  }, proto.mediapipe.RenderAnnotation.Arrow.prototype.hasNormalized = function() {
    return null != t.Message.getField(this, 5);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderAnnotation.Text.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderAnnotation.Text.toObject(e2, this);
  }, proto.mediapipe.RenderAnnotation.Text.toObject = function(e2, r2) {
    var o2, a2 = { displayText: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, left: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 2)) ? void 0 : o2, baseline: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 3)) ? void 0 : o2, fontHeight: t.Message.getFloatingPointFieldWithDefault(r2, 4, 8), normalized: t.Message.getBooleanFieldWithDefault(r2, 5, false), fontFace: t.Message.getFieldWithDefault(r2, 6, 0), centerHorizontally: t.Message.getBooleanFieldWithDefault(r2, 7, false), centerVertically: t.Message.getBooleanFieldWithDefault(r2, 8, false), outlineThickness: t.Message.getFloatingPointFieldWithDefault(r2, 11, 0), outlineColor: (o2 = r2.getOutlineColor()) && i.Color.toObject(e2, o2) };
    return e2 && (a2.$jspbMessageInstance = r2), a2;
  }), proto.mediapipe.RenderAnnotation.Text.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderAnnotation.Text();
    return proto.mediapipe.RenderAnnotation.Text.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderAnnotation.Text.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setDisplayText(r2);
          break;
        case 2:
          r2 = t2.readDouble();
          e2.setLeft(r2);
          break;
        case 3:
          r2 = t2.readDouble();
          e2.setBaseline(r2);
          break;
        case 4:
          r2 = t2.readDouble();
          e2.setFontHeight(r2);
          break;
        case 5:
          r2 = t2.readBool();
          e2.setNormalized(r2);
          break;
        case 6:
          r2 = t2.readInt32();
          e2.setFontFace(r2);
          break;
        case 7:
          r2 = t2.readBool();
          e2.setCenterHorizontally(r2);
          break;
        case 8:
          r2 = t2.readBool();
          e2.setCenterVertically(r2);
          break;
        case 11:
          r2 = t2.readDouble();
          e2.setOutlineThickness(r2);
          break;
        case 12:
          r2 = new i.Color();
          t2.readMessage(r2, i.Color.deserializeBinaryFromReader), e2.setOutlineColor(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.RenderAnnotation.Text.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderAnnotation.Text.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderAnnotation.Text.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeString(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeDouble(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeDouble(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeDouble(4, o2), null != (o2 = t.Message.getField(e2, 5)) && r2.writeBool(5, o2), null != (o2 = t.Message.getField(e2, 6)) && r2.writeInt32(6, o2), null != (o2 = t.Message.getField(e2, 7)) && r2.writeBool(7, o2), null != (o2 = t.Message.getField(e2, 8)) && r2.writeBool(8, o2), null != (o2 = t.Message.getField(e2, 11)) && r2.writeDouble(11, o2), null != (o2 = e2.getOutlineColor()) && r2.writeMessage(12, o2, i.Color.serializeBinaryToWriter);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.getDisplayText = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.mediapipe.RenderAnnotation.Text.prototype.setDisplayText = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.clearDisplayText = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.hasDisplayText = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.getLeft = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.setLeft = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.clearLeft = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.hasLeft = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.getBaseline = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.setBaseline = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.clearBaseline = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.hasBaseline = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.getFontHeight = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 4, 8);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.setFontHeight = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.clearFontHeight = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.hasFontHeight = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.getNormalized = function() {
    return t.Message.getBooleanFieldWithDefault(this, 5, false);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.setNormalized = function(e2) {
    return t.Message.setField(this, 5, e2);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.clearNormalized = function() {
    return t.Message.setField(this, 5, void 0);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.hasNormalized = function() {
    return null != t.Message.getField(this, 5);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.getFontFace = function() {
    return t.Message.getFieldWithDefault(this, 6, 0);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.setFontFace = function(e2) {
    return t.Message.setField(this, 6, e2);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.clearFontFace = function() {
    return t.Message.setField(this, 6, void 0);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.hasFontFace = function() {
    return null != t.Message.getField(this, 6);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.getCenterHorizontally = function() {
    return t.Message.getBooleanFieldWithDefault(this, 7, false);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.setCenterHorizontally = function(e2) {
    return t.Message.setField(this, 7, e2);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.clearCenterHorizontally = function() {
    return t.Message.setField(this, 7, void 0);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.hasCenterHorizontally = function() {
    return null != t.Message.getField(this, 7);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.getCenterVertically = function() {
    return t.Message.getBooleanFieldWithDefault(this, 8, false);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.setCenterVertically = function(e2) {
    return t.Message.setField(this, 8, e2);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.clearCenterVertically = function() {
    return t.Message.setField(this, 8, void 0);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.hasCenterVertically = function() {
    return null != t.Message.getField(this, 8);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.getOutlineThickness = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 11, 0);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.setOutlineThickness = function(e2) {
    return t.Message.setField(this, 11, e2);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.clearOutlineThickness = function() {
    return t.Message.setField(this, 11, void 0);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.hasOutlineThickness = function() {
    return null != t.Message.getField(this, 11);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.getOutlineColor = function() {
    return t.Message.getWrapperField(this, i.Color, 12);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.setOutlineColor = function(e2) {
    return t.Message.setWrapperField(this, 12, e2);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.clearOutlineColor = function() {
    return this.setOutlineColor(void 0);
  }, proto.mediapipe.RenderAnnotation.Text.prototype.hasOutlineColor = function() {
    return null != t.Message.getField(this, 12);
  }, proto.mediapipe.RenderAnnotation.prototype.getRectangle = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.Rectangle, 1);
  }, proto.mediapipe.RenderAnnotation.prototype.setRectangle = function(e2) {
    return t.Message.setOneofWrapperField(this, 1, proto.mediapipe.RenderAnnotation.oneofGroups_[0], e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearRectangle = function() {
    return this.setRectangle(void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasRectangle = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.RenderAnnotation.prototype.getFilledRectangle = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.FilledRectangle, 2);
  }, proto.mediapipe.RenderAnnotation.prototype.setFilledRectangle = function(e2) {
    return t.Message.setOneofWrapperField(this, 2, proto.mediapipe.RenderAnnotation.oneofGroups_[0], e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearFilledRectangle = function() {
    return this.setFilledRectangle(void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasFilledRectangle = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.RenderAnnotation.prototype.getOval = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.Oval, 3);
  }, proto.mediapipe.RenderAnnotation.prototype.setOval = function(e2) {
    return t.Message.setOneofWrapperField(this, 3, proto.mediapipe.RenderAnnotation.oneofGroups_[0], e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearOval = function() {
    return this.setOval(void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasOval = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.RenderAnnotation.prototype.getFilledOval = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.FilledOval, 4);
  }, proto.mediapipe.RenderAnnotation.prototype.setFilledOval = function(e2) {
    return t.Message.setOneofWrapperField(this, 4, proto.mediapipe.RenderAnnotation.oneofGroups_[0], e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearFilledOval = function() {
    return this.setFilledOval(void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasFilledOval = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.RenderAnnotation.prototype.getPoint = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.Point, 5);
  }, proto.mediapipe.RenderAnnotation.prototype.setPoint = function(e2) {
    return t.Message.setOneofWrapperField(this, 5, proto.mediapipe.RenderAnnotation.oneofGroups_[0], e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearPoint = function() {
    return this.setPoint(void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasPoint = function() {
    return null != t.Message.getField(this, 5);
  }, proto.mediapipe.RenderAnnotation.prototype.getLine = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.Line, 6);
  }, proto.mediapipe.RenderAnnotation.prototype.setLine = function(e2) {
    return t.Message.setOneofWrapperField(this, 6, proto.mediapipe.RenderAnnotation.oneofGroups_[0], e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearLine = function() {
    return this.setLine(void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasLine = function() {
    return null != t.Message.getField(this, 6);
  }, proto.mediapipe.RenderAnnotation.prototype.getArrow = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.Arrow, 7);
  }, proto.mediapipe.RenderAnnotation.prototype.setArrow = function(e2) {
    return t.Message.setOneofWrapperField(this, 7, proto.mediapipe.RenderAnnotation.oneofGroups_[0], e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearArrow = function() {
    return this.setArrow(void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasArrow = function() {
    return null != t.Message.getField(this, 7);
  }, proto.mediapipe.RenderAnnotation.prototype.getText = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.Text, 8);
  }, proto.mediapipe.RenderAnnotation.prototype.setText = function(e2) {
    return t.Message.setOneofWrapperField(this, 8, proto.mediapipe.RenderAnnotation.oneofGroups_[0], e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearText = function() {
    return this.setText(void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasText = function() {
    return null != t.Message.getField(this, 8);
  }, proto.mediapipe.RenderAnnotation.prototype.getRoundedRectangle = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.RoundedRectangle, 9);
  }, proto.mediapipe.RenderAnnotation.prototype.setRoundedRectangle = function(e2) {
    return t.Message.setOneofWrapperField(this, 9, proto.mediapipe.RenderAnnotation.oneofGroups_[0], e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearRoundedRectangle = function() {
    return this.setRoundedRectangle(void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasRoundedRectangle = function() {
    return null != t.Message.getField(this, 9);
  }, proto.mediapipe.RenderAnnotation.prototype.getFilledRoundedRectangle = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.FilledRoundedRectangle, 10);
  }, proto.mediapipe.RenderAnnotation.prototype.setFilledRoundedRectangle = function(e2) {
    return t.Message.setOneofWrapperField(this, 10, proto.mediapipe.RenderAnnotation.oneofGroups_[0], e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearFilledRoundedRectangle = function() {
    return this.setFilledRoundedRectangle(void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasFilledRoundedRectangle = function() {
    return null != t.Message.getField(this, 10);
  }, proto.mediapipe.RenderAnnotation.prototype.getGradientLine = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.GradientLine, 14);
  }, proto.mediapipe.RenderAnnotation.prototype.setGradientLine = function(e2) {
    return t.Message.setOneofWrapperField(this, 14, proto.mediapipe.RenderAnnotation.oneofGroups_[0], e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearGradientLine = function() {
    return this.setGradientLine(void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasGradientLine = function() {
    return null != t.Message.getField(this, 14);
  }, proto.mediapipe.RenderAnnotation.prototype.getScribble = function() {
    return t.Message.getWrapperField(this, proto.mediapipe.RenderAnnotation.Scribble, 15);
  }, proto.mediapipe.RenderAnnotation.prototype.setScribble = function(e2) {
    return t.Message.setOneofWrapperField(this, 15, proto.mediapipe.RenderAnnotation.oneofGroups_[0], e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearScribble = function() {
    return this.setScribble(void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasScribble = function() {
    return null != t.Message.getField(this, 15);
  }, proto.mediapipe.RenderAnnotation.prototype.getThickness = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 11, 1);
  }, proto.mediapipe.RenderAnnotation.prototype.setThickness = function(e2) {
    return t.Message.setField(this, 11, e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearThickness = function() {
    return t.Message.setField(this, 11, void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasThickness = function() {
    return null != t.Message.getField(this, 11);
  }, proto.mediapipe.RenderAnnotation.prototype.getColor = function() {
    return t.Message.getWrapperField(this, i.Color, 12);
  }, proto.mediapipe.RenderAnnotation.prototype.setColor = function(e2) {
    return t.Message.setWrapperField(this, 12, e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearColor = function() {
    return this.setColor(void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasColor = function() {
    return null != t.Message.getField(this, 12);
  }, proto.mediapipe.RenderAnnotation.prototype.getSceneTag = function() {
    return t.Message.getFieldWithDefault(this, 13, "");
  }, proto.mediapipe.RenderAnnotation.prototype.setSceneTag = function(e2) {
    return t.Message.setField(this, 13, e2);
  }, proto.mediapipe.RenderAnnotation.prototype.clearSceneTag = function() {
    return t.Message.setField(this, 13, void 0);
  }, proto.mediapipe.RenderAnnotation.prototype.hasSceneTag = function() {
    return null != t.Message.getField(this, 13);
  }, t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.RenderViewport.prototype.toObject = function(e2) {
    return proto.mediapipe.RenderViewport.toObject(e2, this);
  }, proto.mediapipe.RenderViewport.toObject = function(e2, r2) {
    var o2, i2 = { id: null == (o2 = t.Message.getField(r2, 1)) ? void 0 : o2, widthPx: null == (o2 = t.Message.getField(r2, 2)) ? void 0 : o2, heightPx: null == (o2 = t.Message.getField(r2, 3)) ? void 0 : o2, composeOnVideo: null == (o2 = t.Message.getBooleanField(r2, 4)) ? void 0 : o2 };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.RenderViewport.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.RenderViewport();
    return proto.mediapipe.RenderViewport.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.RenderViewport.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = t2.readString();
          e2.setId(r2);
          break;
        case 2:
          r2 = t2.readInt32();
          e2.setWidthPx(r2);
          break;
        case 3:
          r2 = t2.readInt32();
          e2.setHeightPx(r2);
          break;
        case 4:
          r2 = t2.readBool();
          e2.setComposeOnVideo(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.RenderViewport.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.RenderViewport.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.RenderViewport.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = t.Message.getField(e2, 1)) && r2.writeString(1, o2), null != (o2 = t.Message.getField(e2, 2)) && r2.writeInt32(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeInt32(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeBool(4, o2);
  }, proto.mediapipe.RenderViewport.prototype.getId = function() {
    return t.Message.getFieldWithDefault(this, 1, "");
  }, proto.mediapipe.RenderViewport.prototype.setId = function(e2) {
    return t.Message.setField(this, 1, e2);
  }, proto.mediapipe.RenderViewport.prototype.clearId = function() {
    return t.Message.setField(this, 1, void 0);
  }, proto.mediapipe.RenderViewport.prototype.hasId = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.RenderViewport.prototype.getWidthPx = function() {
    return t.Message.getFieldWithDefault(this, 2, 0);
  }, proto.mediapipe.RenderViewport.prototype.setWidthPx = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.RenderViewport.prototype.clearWidthPx = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.RenderViewport.prototype.hasWidthPx = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.RenderViewport.prototype.getHeightPx = function() {
    return t.Message.getFieldWithDefault(this, 3, 0);
  }, proto.mediapipe.RenderViewport.prototype.setHeightPx = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.RenderViewport.prototype.clearHeightPx = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.RenderViewport.prototype.hasHeightPx = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.RenderViewport.prototype.getComposeOnVideo = function() {
    return t.Message.getBooleanFieldWithDefault(this, 4, false);
  }, proto.mediapipe.RenderViewport.prototype.setComposeOnVideo = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.RenderViewport.prototype.clearComposeOnVideo = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.RenderViewport.prototype.hasComposeOnVideo = function() {
    return null != t.Message.getField(this, 4);
  }, r.object.extend(e, proto.mediapipe);
})(render_data_pb);
var interactive_segmenter_result = {};
Object.defineProperty(interactive_segmenter_result, "__esModule", { value: true }), interactive_segmenter_result.InteractiveSegmenterResult = void 0;
var InteractiveSegmenterResult = class {
  constructor(e, t, r) {
    this.confidenceMasks = e, this.categoryMask = t, this.qualityScores = r;
  }
  close() {
    var e, t;
    null === (e = this.confidenceMasks) || void 0 === e || e.forEach(((e2) => {
      e2.close();
    })), null === (t = this.categoryMask) || void 0 === t || t.close();
  }
};
interactive_segmenter_result.InteractiveSegmenterResult = InteractiveSegmenterResult;
var interactive_segmenter_options = {};
Object.defineProperty(interactive_segmenter_options, "__esModule", { value: true }), (function(e) {
  var t = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2);
    var i2 = Object.getOwnPropertyDescriptor(t2, r2);
    i2 && !("get" in i2 ? !t2.__esModule : i2.writable || i2.configurable) || (i2 = { enumerable: true, get: function() {
      return t2[r2];
    } }), Object.defineProperty(e2, o2, i2);
  } : function(e2, t2, r2, o2) {
    void 0 === o2 && (o2 = r2), e2[o2] = t2[r2];
  }), r = commonjsGlobal && commonjsGlobal.__exportStar || function(e2, r2) {
    for (var o2 in e2) "default" === o2 || Object.prototype.hasOwnProperty.call(r2, o2) || t(r2, e2, o2);
  };
  Object.defineProperty(e, "__esModule", { value: true }), e.InteractiveSegmenter = void 0;
  const o = calculator_pb, i = calculator_options_pb, a2 = base_options_pb, n = image_segmenter_graph_options_pb, s = segmenter_options_pb, p = vision_task_runner, d = color_pb, l = render_data_pb, g = interactive_segmenter_result;
  r(interactive_segmenter_options, e), r(interactive_segmenter_result, e);
  const c = "image_in", u = "norm_rect_in", m = "roi_in", f = "confidence_masks", h = "category_mask", y = "quality_scores";
  class b extends p.VisionTaskRunner {
    static createFromOptions(e2, t2) {
      return p.VisionTaskRunner.createVisionInstance(b, e2, t2);
    }
    static createFromModelBuffer(e2, t2) {
      return p.VisionTaskRunner.createVisionInstance(b, e2, { baseOptions: { modelAssetBuffer: t2 } });
    }
    static createFromModelPath(e2, t2) {
      return p.VisionTaskRunner.createVisionInstance(b, e2, { baseOptions: { modelAssetPath: t2 } });
    }
    constructor(e2, t2) {
      super(new p.VisionGraphRunner(e2, t2), c, u, false), this.outputCategoryMask = false, this.outputConfidenceMasks = true, this.options = new n.ImageSegmenterGraphOptions(), this.segmenterOptions = new s.SegmenterOptions(), this.options.setSegmenterOptions(this.segmenterOptions), this.options.setBaseOptions(new a2.BaseOptions());
    }
    get baseOptions() {
      return this.options.getBaseOptions();
    }
    set baseOptions(e2) {
      this.options.setBaseOptions(e2);
    }
    setOptions(e2) {
      var t2, r2;
      return "outputCategoryMask" in e2 && (this.outputCategoryMask = null !== (t2 = e2.outputCategoryMask) && void 0 !== t2 && t2), "outputConfidenceMasks" in e2 && (this.outputConfidenceMasks = null === (r2 = e2.outputConfidenceMasks) || void 0 === r2 || r2), super.applyOptions(e2);
    }
    segment(e2, t2, r2, o2) {
      const i2 = "function" != typeof r2 ? r2 : {};
      return this.userCallback = "function" == typeof r2 ? r2 : o2, this.reset(), this.processRenderData(t2, this.getSynctheticTimestamp()), this.processImageData(e2, i2), this.processResults();
    }
    reset() {
      this.confidenceMasks = void 0, this.categoryMask = void 0, this.qualityScores = void 0;
    }
    processResults() {
      try {
        const e2 = new g.InteractiveSegmenterResult(this.confidenceMasks, this.categoryMask, this.qualityScores);
        if (!this.userCallback) return e2;
        this.userCallback(e2);
      } finally {
        this.freeKeepaliveStreams();
      }
    }
    refreshGraph() {
      const e2 = new o.CalculatorGraphConfig();
      e2.addInputStream(c), e2.addInputStream(m), e2.addInputStream(u);
      const t2 = new i.CalculatorOptions();
      t2.setExtension(n.ImageSegmenterGraphOptions.ext, this.options);
      const r2 = new o.CalculatorGraphConfig.Node();
      r2.setCalculator("mediapipe.tasks.vision.interactive_segmenter.InteractiveSegmenterGraph"), r2.addInputStream("IMAGE:" + c), r2.addInputStream("ROI:" + m), r2.addInputStream("NORM_RECT:" + u), r2.setOptions(t2), e2.addNode(r2), this.addKeepaliveNode(e2), this.outputConfidenceMasks && (e2.addOutputStream(f), r2.addOutputStream("CONFIDENCE_MASKS:" + f), this.keepStreamAlive(f), this.graphRunner.attachImageVectorListener(f, ((e3, t3) => {
        this.confidenceMasks = e3.map(((e4) => this.convertToMPMask(e4, !this.userCallback))), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(f, ((e3) => {
        this.confidenceMasks = [], this.setLatestOutputTimestamp(e3);
      }))), this.outputCategoryMask && (e2.addOutputStream(h), r2.addOutputStream("CATEGORY_MASK:" + h), this.keepStreamAlive(h), this.graphRunner.attachImageListener(h, ((e3, t3) => {
        this.categoryMask = this.convertToMPMask(e3, !this.userCallback), this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(h, ((e3) => {
        this.categoryMask = void 0, this.setLatestOutputTimestamp(e3);
      }))), e2.addOutputStream(y), r2.addOutputStream("QUALITY_SCORES:" + y), this.graphRunner.attachFloatVectorListener(y, ((e3, t3) => {
        this.qualityScores = e3, this.setLatestOutputTimestamp(t3);
      })), this.graphRunner.attachEmptyPacketListener(y, ((e3) => {
        this.categoryMask = void 0, this.setLatestOutputTimestamp(e3);
      }));
      const a3 = e2.serializeBinary();
      this.setGraph(new Uint8Array(a3), true);
    }
    processRenderData(e2, t2) {
      const r2 = new l.RenderData(), o2 = new l.RenderAnnotation(), i2 = new d.Color();
      if (i2.setR(255), o2.setColor(i2), e2.keypoint && e2.scribble) throw new Error("Cannot provide both keypoint and scribble.");
      if (e2.keypoint) {
        const t3 = new l.RenderAnnotation.Point();
        t3.setNormalized(true), t3.setX(e2.keypoint.x), t3.setY(e2.keypoint.y), o2.setPoint(t3);
      } else {
        if (!e2.scribble) throw new Error("Must provide either a keypoint or a scribble.");
        {
          const t3 = new l.RenderAnnotation.Scribble();
          for (const r3 of e2.scribble) {
            const e3 = new l.RenderAnnotation.Point();
            e3.setNormalized(true), e3.setX(r3.x), e3.setY(r3.y), t3.addPoint(e3);
          }
          o2.setScribble(t3);
        }
      }
      r2.addRenderAnnotations(o2), this.graphRunner.addProtoToStream(r2.serializeBinary(), "mediapipe.RenderData", m, t2);
    }
  }
  e.InteractiveSegmenter = b;
})(interactive_segmenter);
var object_detector = {};
var object_detector_options_pb = {};
!(function(e) {
  var t = googleProtobuf, r = t, o = "undefined" != typeof globalThis && globalThis || "undefined" != typeof window && window || void 0 !== o && o || "undefined" != typeof self && self || (function() {
    return this;
  }).call(null) || Function("return this")(), i = calculator_pb;
  r.object.extend(proto, i);
  var a2 = calculator_options_pb;
  r.object.extend(proto, a2);
  var n = base_options_pb;
  r.object.extend(proto, n), r.exportSymbol("proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions", null, o), proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions = function(e2) {
    t.Message.initialize(this, e2, 0, -1, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.repeatedFields_, null);
  }, r.inherits(proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions, t.Message), r.DEBUG && !COMPILED && (proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.displayName = "proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions"), proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.repeatedFields_ = [5, 6], t.Message.GENERATE_TO_OBJECT && (proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.toObject = function(e2) {
    return proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.toObject(e2, this);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.toObject = function(e2, r2) {
    var o2, i2 = { baseOptions: (o2 = r2.getBaseOptions()) && n.BaseOptions.toObject(e2, o2), displayNamesLocale: t.Message.getFieldWithDefault(r2, 2, "en"), maxResults: t.Message.getFieldWithDefault(r2, 3, -1), scoreThreshold: null == (o2 = t.Message.getOptionalFloatingPointField(r2, 4)) ? void 0 : o2, categoryAllowlistList: null == (o2 = t.Message.getRepeatedField(r2, 5)) ? void 0 : o2, categoryDenylistList: null == (o2 = t.Message.getRepeatedField(r2, 6)) ? void 0 : o2 };
    return e2 && (i2.$jspbMessageInstance = r2), i2;
  }), proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.deserializeBinary = function(e2) {
    var r2 = new t.BinaryReader(e2), o2 = new proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions();
    return proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.deserializeBinaryFromReader(o2, r2);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.deserializeBinaryFromReader = function(e2, t2) {
    for (; t2.nextField() && !t2.isEndGroup(); ) {
      switch (t2.getFieldNumber()) {
        case 1:
          var r2 = new n.BaseOptions();
          t2.readMessage(r2, n.BaseOptions.deserializeBinaryFromReader), e2.setBaseOptions(r2);
          break;
        case 2:
          r2 = t2.readString();
          e2.setDisplayNamesLocale(r2);
          break;
        case 3:
          r2 = t2.readInt32();
          e2.setMaxResults(r2);
          break;
        case 4:
          r2 = t2.readFloat();
          e2.setScoreThreshold(r2);
          break;
        case 5:
          r2 = t2.readString();
          e2.addCategoryAllowlist(r2);
          break;
        case 6:
          r2 = t2.readString();
          e2.addCategoryDenylist(r2);
          break;
        default:
          t2.skipField();
      }
    }
    return e2;
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.serializeBinary = function() {
    var e2 = new t.BinaryWriter();
    return proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.serializeBinaryToWriter(this, e2), e2.getResultBuffer();
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.serializeBinaryToWriter = function(e2, r2) {
    var o2 = void 0;
    null != (o2 = e2.getBaseOptions()) && r2.writeMessage(1, o2, n.BaseOptions.serializeBinaryToWriter), null != (o2 = t.Message.getField(e2, 2)) && r2.writeString(2, o2), null != (o2 = t.Message.getField(e2, 3)) && r2.writeInt32(3, o2), null != (o2 = t.Message.getField(e2, 4)) && r2.writeFloat(4, o2), (o2 = e2.getCategoryAllowlistList()).length > 0 && r2.writeRepeatedString(5, o2), (o2 = e2.getCategoryDenylistList()).length > 0 && r2.writeRepeatedString(6, o2);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.ext = new t.ExtensionFieldInfo(443442058, { ext: 0 }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[443442058] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMessage, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.serializeBinaryToWriter, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.deserializeBinaryFromReader, false), a2.CalculatorOptions.extensions[443442058] = proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.ext, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.getBaseOptions = function() {
    return t.Message.getWrapperField(this, n.BaseOptions, 1);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.setBaseOptions = function(e2) {
    return t.Message.setWrapperField(this, 1, e2);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.clearBaseOptions = function() {
    return this.setBaseOptions(void 0);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.hasBaseOptions = function() {
    return null != t.Message.getField(this, 1);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.getDisplayNamesLocale = function() {
    return t.Message.getFieldWithDefault(this, 2, "en");
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.setDisplayNamesLocale = function(e2) {
    return t.Message.setField(this, 2, e2);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.clearDisplayNamesLocale = function() {
    return t.Message.setField(this, 2, void 0);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.hasDisplayNamesLocale = function() {
    return null != t.Message.getField(this, 2);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.getMaxResults = function() {
    return t.Message.getFieldWithDefault(this, 3, -1);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.setMaxResults = function(e2) {
    return t.Message.setField(this, 3, e2);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.clearMaxResults = function() {
    return t.Message.setField(this, 3, void 0);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.hasMaxResults = function() {
    return null != t.Message.getField(this, 3);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.getScoreThreshold = function() {
    return t.Message.getFloatingPointFieldWithDefault(this, 4, 0);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.setScoreThreshold = function(e2) {
    return t.Message.setField(this, 4, e2);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.clearScoreThreshold = function() {
    return t.Message.setField(this, 4, void 0);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.hasScoreThreshold = function() {
    return null != t.Message.getField(this, 4);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.getCategoryAllowlistList = function() {
    return t.Message.getRepeatedField(this, 5);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.setCategoryAllowlistList = function(e2) {
    return t.Message.setField(this, 5, e2 || []);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.addCategoryAllowlist = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 5, e2, r2);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.clearCategoryAllowlistList = function() {
    return this.setCategoryAllowlistList([]);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.getCategoryDenylistList = function() {
    return t.Message.getRepeatedField(this, 6);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.setCategoryDenylistList = function(e2) {
    return t.Message.setField(this, 6, e2 || []);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.addCategoryDenylist = function(e2, r2) {
    return t.Message.addToRepeatedField(this, 6, e2, r2);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.prototype.clearCategoryDenylistList = function() {
    return this.setCategoryDenylistList([]);
  }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.ext = new t.ExtensionFieldInfo(443442058, { ext: 0 }, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions, proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.toObject, 0), a2.CalculatorOptions.extensionsBinary[443442058] = new t.ExtensionFieldBinaryInfo(proto.mediapipe.tasks.vision.object_detector.proto.ObjectDetectorOptions.ext, t.BinaryReader.prototype.readMessage, t.BinaryWriter.prototype.writeMe