import {
  Events
} from "./chunk-OAEA5FZL.js";
import {
  addAfterEffect,
  addEffect,
  applyProps,
  clear,
  context,
  createPortal,
  createStore,
  extend,
  preload,
  require_with_selector,
  suspend,
  useFrame,
  useInstanceHandle,
  useLoader,
  useThree
} from "./chunk-6EC3FN6M.js";
import {
  AddEquation,
  AdditiveBlending,
  AlwaysStencilFunc,
  AmbientLight,
  AnimationClip,
  AnimationMixer,
  AudioListener,
  AudioLoader,
  BackSide,
  BatchedMesh,
  Bone,
  Box2,
  Box3,
  BoxGeometry,
  BufferAttribute,
  BufferGeometry,
  ByteType,
  Camera,
  CameraHelper,
  CanvasTexture,
  CatmullRomCurve3,
  ClampToEdgeWrapping,
  Clock,
  Color,
  CompressedTexture,
  CubeCamera,
  CubeReflectionMapping,
  CubeTextureLoader,
  CubicBezierCurve3,
  Curve,
  CurvePath,
  CustomBlending,
  CylinderGeometry,
  DataTexture,
  DataTextureLoader,
  DataUtils,
  DefaultLoadingManager,
  DepthFormat,
  DepthStencilFormat,
  DepthTexture,
  DirectionalLight,
  DoubleSide,
  DstAlphaFactor,
  DstColorFactor,
  DynamicDrawUsage,
  EdgesGeometry,
  EllipseCurve,
  EqualStencilFunc,
  EquirectangularReflectionMapping,
  Euler,
  EventDispatcher,
  ExtrudeGeometry,
  FileLoader,
  Float32BufferAttribute,
  FloatType,
  FrontSide,
  Frustum,
  GridHelper,
  Group,
  HalfFloatType,
  IcosahedronGeometry,
  ImageBitmapLoader,
  InstancedBufferAttribute,
  InstancedBufferGeometry,
  InstancedInterleavedBuffer,
  InstancedMesh,
  IntType,
  InterleavedBuffer,
  InterleavedBufferAttribute,
  Interpolant,
  InterpolateDiscrete,
  InterpolateLinear,
  KeepStencilOp,
  Line,
  Line3,
  LineBasicMaterial,
  LineLoop,
  LineSegments,
  LinearFilter,
  LinearMipMapLinearFilter,
  LinearMipmapLinearFilter,
  LinearMipmapNearestFilter,
  LinearSRGBColorSpace,
  Loader,
  LoaderUtils,
  LoadingManager,
  MOUSE,
  Material,
  MathUtils,
  Matrix3,
  Matrix4,
  Mesh,
  MeshBasicMaterial,
  MeshDepthMaterial,
  MeshDistanceMaterial,
  MeshLambertMaterial,
  MeshNormalMaterial,
  MeshPhongMaterial,
  MeshPhysicalMaterial,
  MeshStandardMaterial,
  MirroredRepeatWrapping,
  NearestFilter,
  NearestMipmapLinearFilter,
  NearestMipmapNearestFilter,
  NoBlending,
  NoToneMapping,
  NormalBlending,
  NotEqualStencilFunc,
  NumberKeyframeTrack,
  Object3D,
  OctahedronGeometry,
  OneFactor,
  OneMinusSrcAlphaFactor,
  OrthographicCamera,
  Path,
  PerspectiveCamera,
  Plane,
  PlaneGeometry,
  PointLight,
  Points,
  PointsMaterial,
  PropertyBinding,
  QuadraticBezierCurve3,
  Quaternion,
  QuaternionKeyframeTrack,
  REVISION,
  RGBADepthPacking,
  RGBAFormat,
  RGBAIntegerFormat,
  RGBA_ASTC_4x4_Format,
  RGBA_ASTC_6x6_Format,
  RGBA_BPTC_Format,
  RGBA_ETC2_EAC_Format,
  RGBA_PVRTC_4BPPV1_Format,
  RGBA_S3TC_DXT5_Format,
  RGB_ETC1_Format,
  RGB_ETC2_Format,
  RGB_PVRTC_4BPPV1_Format,
  RGB_S3TC_DXT1_Format,
  RGFormat,
  RGIntegerFormat,
  RawShaderMaterial,
  Ray,
  Raycaster,
  RedFormat,
  RedIntegerFormat,
  RepeatWrapping,
  ReplaceStencilOp,
  SRGBColorSpace,
  Scene,
  ShaderChunk,
  ShaderMaterial,
  Shape,
  ShapePath,
  ShapeUtils,
  ShortType,
  Skeleton,
  SkeletonHelper,
  SkinnedMesh,
  Sphere,
  SphereGeometry,
  Spherical,
  SpotLight,
  SrcAlphaFactor,
  TOUCH,
  Texture,
  TextureLoader,
  TorusGeometry,
  Triangle,
  TriangleFanDrawMode,
  TriangleStripDrawMode,
  TrianglesDrawMode,
  UVMapping,
  Uint16BufferAttribute,
  Uint32BufferAttribute,
  Uniform,
  UniformsLib,
  UniformsUtils,
  UnsignedByteType,
  UnsignedInt248Type,
  UnsignedIntType,
  UnsignedShortType,
  Vector2,
  Vector3,
  Vector4,
  VectorKeyframeTrack,
  VideoTexture,
  WebGLCubeRenderTarget,
  WebGLRenderTarget,
  WebGLRenderer,
  WireframeGeometry,
  ZeroFactor
} from "./chunk-3BFRGDWE.js";
import "./chunk-R535KVNV.js";
import {
  require_client
} from "./chunk-657DEKJR.js";
import "./chunk-CIKVT7NJ.js";
import {
  require_react
} from "./chunk-PD3NECQZ.js";
import {
  __commonJS,
  __export,
  __publicField,
  __toESM
} from "./chunk-DC5AMYBS.js";

// node_modules/stats.js/build/stats.min.js
var require_stats_min = __commonJS({
  "node_modules/stats.js/build/stats.min.js"(exports2, module2) {
    (function(f2, e2) {
      "object" === typeof exports2 && "undefined" !== typeof module2 ? module2.exports = e2() : "function" === typeof define && define.amd ? define(e2) : f2.Stats = e2();
    })(exports2, function() {
      var f2 = function() {
        function e2(a7) {
          c2.appendChild(a7.dom);
          return a7;
        }
        function u(a7) {
          for (var d2 = 0; d2 < c2.children.length; d2++) c2.children[d2].style.display = d2 === a7 ? "block" : "none";
          l2 = a7;
        }
        var l2 = 0, c2 = document.createElement("div");
        c2.style.cssText = "position:fixed;top:0;left:0;cursor:pointer;opacity:0.9;z-index:10000";
        c2.addEventListener("click", function(a7) {
          a7.preventDefault();
          u(++l2 % c2.children.length);
        }, false);
        var k = (performance || Date).now(), g = k, a6 = 0, r2 = e2(new f2.Panel("FPS", "#0ff", "#002")), h = e2(new f2.Panel("MS", "#0f0", "#020"));
        if (self.performance && self.performance.memory) var t3 = e2(new f2.Panel("MB", "#f08", "#201"));
        u(0);
        return { REVISION: 16, dom: c2, addPanel: e2, showPanel: u, begin: function() {
          k = (performance || Date).now();
        }, end: function() {
          a6++;
          var c5 = (performance || Date).now();
          h.update(c5 - k, 200);
          if (c5 > g + 1e3 && (r2.update(1e3 * a6 / (c5 - g), 100), g = c5, a6 = 0, t3)) {
            var d2 = performance.memory;
            t3.update(d2.usedJSHeapSize / 1048576, d2.jsHeapSizeLimit / 1048576);
          }
          return c5;
        }, update: function() {
          k = this.end();
        }, domElement: c2, setMode: u };
      };
      f2.Panel = function(e2, f3, l2) {
        var c2 = Infinity, k = 0, g = Math.round, a6 = g(window.devicePixelRatio || 1), r2 = 80 * a6, h = 48 * a6, t3 = 3 * a6, v5 = 2 * a6, d2 = 3 * a6, m = 15 * a6, n2 = 74 * a6, p2 = 30 * a6, q = document.createElement("canvas");
        q.width = r2;
        q.height = h;
        q.style.cssText = "width:80px;height:48px";
        var b5 = q.getContext("2d");
        b5.font = "bold " + 9 * a6 + "px Helvetica,Arial,sans-serif";
        b5.textBaseline = "top";
        b5.fillStyle = l2;
        b5.fillRect(0, 0, r2, h);
        b5.fillStyle = f3;
        b5.fillText(e2, t3, v5);
        b5.fillRect(d2, m, n2, p2);
        b5.fillStyle = l2;
        b5.globalAlpha = 0.9;
        b5.fillRect(d2, m, n2, p2);
        return { dom: q, update: function(h2, w) {
          c2 = Math.min(c2, h2);
          k = Math.max(k, h2);
          b5.fillStyle = l2;
          b5.globalAlpha = 1;
          b5.fillRect(0, 0, r2, m);
          b5.fillStyle = f3;
          b5.fillText(g(h2) + " " + e2 + " (" + g(c2) + "-" + g(k) + ")", t3, v5);
          b5.drawImage(q, d2 + a6, m, n2 - a6, p2, d2, m, n2 - a6, p2);
          b5.fillRect(d2 + n2 - a6, m, a6, p2);
          b5.fillStyle = l2;
          b5.globalAlpha = 0.9;
          b5.fillRect(d2 + n2 - a6, m, a6, g((1 - h2 / w) * p2));
        } };
      };
      return f2;
    });
  }
});

// node_modules/@babel/runtime/helpers/esm/extends.js
function _extends() {
  return _extends = Object.assign ? Object.assign.bind() : function(n2) {
    for (var e2 = 1; e2 < arguments.length; e2++) {
      var t3 = arguments[e2];
      for (var r2 in t3) ({}).hasOwnProperty.call(t3, r2) && (n2[r2] = t3[r2]);
    }
    return n2;
  }, _extends.apply(null, arguments);
}

// node_modules/@react-three/drei/web/Html.js
var React = __toESM(require_react());
var ReactDOM = __toESM(require_client());
var v1 = new Vector3();
var v2 = new Vector3();
var v3 = new Vector3();
var v4 = new Vector2();
function defaultCalculatePosition(el, camera, size2) {
  const objectPos = v1.setFromMatrixPosition(el.matrixWorld);
  objectPos.project(camera);
  const widthHalf = size2.width / 2;
  const heightHalf = size2.height / 2;
  return [objectPos.x * widthHalf + widthHalf, -(objectPos.y * heightHalf) + heightHalf];
}
function isObjectBehindCamera(el, camera) {
  const objectPos = v1.setFromMatrixPosition(el.matrixWorld);
  const cameraPos = v2.setFromMatrixPosition(camera.matrixWorld);
  const deltaCamObj = objectPos.sub(cameraPos);
  const camDir = camera.getWorldDirection(v3);
  return deltaCamObj.angleTo(camDir) > Math.PI / 2;
}
function isObjectVisible(el, camera, raycaster, occlude) {
  const elPos = v1.setFromMatrixPosition(el.matrixWorld);
  const screenPos = elPos.clone();
  screenPos.project(camera);
  v4.set(screenPos.x, screenPos.y);
  raycaster.setFromCamera(v4, camera);
  const intersects = raycaster.intersectObjects(occlude, true);
  if (intersects.length) {
    const intersectionDistance = intersects[0].distance;
    const pointDistance = elPos.distanceTo(raycaster.ray.origin);
    return pointDistance < intersectionDistance;
  }
  return true;
}
function objectScale(el, camera) {
  if (camera instanceof OrthographicCamera) {
    return camera.zoom;
  } else if (camera instanceof PerspectiveCamera) {
    const objectPos = v1.setFromMatrixPosition(el.matrixWorld);
    const cameraPos = v2.setFromMatrixPosition(camera.matrixWorld);
    const vFOV = camera.fov * Math.PI / 180;
    const dist = objectPos.distanceTo(cameraPos);
    const scaleFOV = 2 * Math.tan(vFOV / 2) * dist;
    return 1 / scaleFOV;
  } else {
    return 1;
  }
}
function objectZIndex(el, camera, zIndexRange) {
  if (camera instanceof PerspectiveCamera || camera instanceof OrthographicCamera) {
    const objectPos = v1.setFromMatrixPosition(el.matrixWorld);
    const cameraPos = v2.setFromMatrixPosition(camera.matrixWorld);
    const dist = objectPos.distanceTo(cameraPos);
    const A = (zIndexRange[1] - zIndexRange[0]) / (camera.far - camera.near);
    const B = zIndexRange[1] - A * camera.far;
    return Math.round(A * dist + B);
  }
  return void 0;
}
var epsilon = (value) => Math.abs(value) < 1e-10 ? 0 : value;
function getCSSMatrix(matrix6, multipliers, prepend = "") {
  let matrix3d = "matrix3d(";
  for (let i4 = 0; i4 !== 16; i4++) {
    matrix3d += epsilon(multipliers[i4] * matrix6.elements[i4]) + (i4 !== 15 ? "," : ")");
  }
  return prepend + matrix3d;
}
var getCameraCSSMatrix = /* @__PURE__ */ ((multipliers) => {
  return (matrix6) => getCSSMatrix(matrix6, multipliers);
})([1, -1, 1, 1, 1, -1, 1, 1, 1, -1, 1, 1, 1, -1, 1, 1]);
var getObjectCSSMatrix = /* @__PURE__ */ ((scaleMultipliers) => {
  return (matrix6, factor) => getCSSMatrix(matrix6, scaleMultipliers(factor), "translate(-50%,-50%)");
})((f2) => [1 / f2, 1 / f2, 1 / f2, 1, -1 / f2, -1 / f2, -1 / f2, -1, 1 / f2, 1 / f2, 1 / f2, 1, 1, 1, 1, 1]);
function isRefObject(ref) {
  return ref && typeof ref === "object" && "current" in ref;
}
var Html = React.forwardRef(({
  children,
  eps: eps2 = 1e-3,
  style,
  className,
  prepend,
  center: center3,
  fullscreen,
  portal,
  distanceFactor,
  sprite = false,
  transform = false,
  occlude,
  onOcclude,
  castShadow,
  receiveShadow,
  material,
  geometry: geometry3,
  zIndexRange = [16777271, 0],
  calculatePosition = defaultCalculatePosition,
  as = "div",
  wrapperClass,
  pointerEvents = "auto",
  ...props
}, ref) => {
  const {
    gl,
    camera,
    scene,
    size: size2,
    raycaster,
    events,
    viewport
  } = useThree();
  const [el] = React.useState(() => document.createElement(as));
  const root = React.useRef(null);
  const group = React.useRef(null);
  const oldZoom = React.useRef(0);
  const oldPosition = React.useRef([0, 0]);
  const transformOuterRef = React.useRef(null);
  const transformInnerRef = React.useRef(null);
  const target2 = (portal == null ? void 0 : portal.current) || events.connected || gl.domElement.parentNode;
  const occlusionMeshRef = React.useRef(null);
  const isMeshSizeSet = React.useRef(false);
  const isRayCastOcclusion = React.useMemo(() => {
    return occlude && occlude !== "blending" || Array.isArray(occlude) && occlude.length && isRefObject(occlude[0]);
  }, [occlude]);
  React.useLayoutEffect(() => {
    const el2 = gl.domElement;
    if (occlude && occlude === "blending") {
      el2.style.zIndex = `${Math.floor(zIndexRange[0] / 2)}`;
      el2.style.position = "absolute";
      el2.style.pointerEvents = "none";
    } else {
      el2.style.zIndex = null;
      el2.style.position = null;
      el2.style.pointerEvents = null;
    }
  }, [occlude]);
  React.useLayoutEffect(() => {
    if (group.current) {
      const currentRoot = root.current = ReactDOM.createRoot(el);
      scene.updateMatrixWorld();
      if (transform) {
        el.style.cssText = `position:absolute;top:0;left:0;pointer-events:none;overflow:hidden;`;
      } else {
        const vec = calculatePosition(group.current, camera, size2);
        el.style.cssText = `position:absolute;top:0;left:0;transform:translate3d(${vec[0]}px,${vec[1]}px,0);transform-origin:0 0;`;
      }
      if (target2) {
        if (prepend) target2.prepend(el);
        else target2.appendChild(el);
      }
      return () => {
        if (target2) target2.removeChild(el);
        currentRoot.unmount();
      };
    }
  }, [target2, transform]);
  React.useLayoutEffect(() => {
    if (wrapperClass) el.className = wrapperClass;
  }, [wrapperClass]);
  const styles2 = React.useMemo(() => {
    if (transform) {
      return {
        position: "absolute",
        top: 0,
        left: 0,
        width: size2.width,
        height: size2.height,
        transformStyle: "preserve-3d",
        pointerEvents: "none"
      };
    } else {
      return {
        position: "absolute",
        transform: center3 ? "translate3d(-50%,-50%,0)" : "none",
        ...fullscreen && {
          top: -size2.height / 2,
          left: -size2.width / 2,
          width: size2.width,
          height: size2.height
        },
        ...style
      };
    }
  }, [style, center3, fullscreen, size2, transform]);
  const transformInnerStyles = React.useMemo(() => ({
    position: "absolute",
    pointerEvents
  }), [pointerEvents]);
  React.useLayoutEffect(() => {
    isMeshSizeSet.current = false;
    if (transform) {
      var _root$current;
      (_root$current = root.current) == null || _root$current.render(React.createElement("div", {
        ref: transformOuterRef,
        style: styles2
      }, React.createElement("div", {
        ref: transformInnerRef,
        style: transformInnerStyles
      }, React.createElement("div", {
        ref,
        className,
        style,
        children
      }))));
    } else {
      var _root$current2;
      (_root$current2 = root.current) == null || _root$current2.render(React.createElement("div", {
        ref,
        style: styles2,
        className,
        children
      }));
    }
  });
  const visible = React.useRef(true);
  useFrame((gl2) => {
    if (group.current) {
      camera.updateMatrixWorld();
      group.current.updateWorldMatrix(true, false);
      const vec = transform ? oldPosition.current : calculatePosition(group.current, camera, size2);
      if (transform || Math.abs(oldZoom.current - camera.zoom) > eps2 || Math.abs(oldPosition.current[0] - vec[0]) > eps2 || Math.abs(oldPosition.current[1] - vec[1]) > eps2) {
        const isBehindCamera = isObjectBehindCamera(group.current, camera);
        let raytraceTarget = false;
        if (isRayCastOcclusion) {
          if (Array.isArray(occlude)) {
            raytraceTarget = occlude.map((item) => item.current);
          } else if (occlude !== "blending") {
            raytraceTarget = [scene];
          }
        }
        const previouslyVisible = visible.current;
        if (raytraceTarget) {
          const isvisible = isObjectVisible(group.current, camera, raycaster, raytraceTarget);
          visible.current = isvisible && !isBehindCamera;
        } else {
          visible.current = !isBehindCamera;
        }
        if (previouslyVisible !== visible.current) {
          if (onOcclude) onOcclude(!visible.current);
          else el.style.display = visible.current ? "block" : "none";
        }
        const halfRange = Math.floor(zIndexRange[0] / 2);
        const zRange = occlude ? isRayCastOcclusion ? [zIndexRange[0], halfRange] : [halfRange - 1, 0] : zIndexRange;
        el.style.zIndex = `${objectZIndex(group.current, camera, zRange)}`;
        if (transform) {
          const [widthHalf, heightHalf] = [size2.width / 2, size2.height / 2];
          const fov = camera.projectionMatrix.elements[5] * heightHalf;
          const {
            isOrthographicCamera: isOrthographicCamera3,
            top,
            left,
            bottom,
            right
          } = camera;
          const cameraMatrix = getCameraCSSMatrix(camera.matrixWorldInverse);
          const cameraTransform = isOrthographicCamera3 ? `scale(${fov})translate(${epsilon(-(right + left) / 2)}px,${epsilon((top + bottom) / 2)}px)` : `translateZ(${fov}px)`;
          let matrix6 = group.current.matrixWorld;
          if (sprite) {
            matrix6 = camera.matrixWorldInverse.clone().transpose().copyPosition(matrix6).scale(group.current.scale);
            matrix6.elements[3] = matrix6.elements[7] = matrix6.elements[11] = 0;
            matrix6.elements[15] = 1;
          }
          el.style.width = size2.width + "px";
          el.style.height = size2.height + "px";
          el.style.perspective = isOrthographicCamera3 ? "" : `${fov}px`;
          if (transformOuterRef.current && transformInnerRef.current) {
            transformOuterRef.current.style.transform = `${cameraTransform}${cameraMatrix}translate(${widthHalf}px,${heightHalf}px)`;
            transformInnerRef.current.style.transform = getObjectCSSMatrix(matrix6, 1 / ((distanceFactor || 10) / 400));
          }
        } else {
          const scale5 = distanceFactor === void 0 ? 1 : objectScale(group.current, camera) * distanceFactor;
          el.style.transform = `translate3d(${vec[0]}px,${vec[1]}px,0) scale(${scale5})`;
        }
        oldPosition.current = vec;
        oldZoom.current = camera.zoom;
      }
    }
    if (!isRayCastOcclusion && occlusionMeshRef.current && !isMeshSizeSet.current) {
      if (transform) {
        if (transformOuterRef.current) {
          const el2 = transformOuterRef.current.children[0];
          if (el2 != null && el2.clientWidth && el2 != null && el2.clientHeight) {
            const {
              isOrthographicCamera: isOrthographicCamera3
            } = camera;
            if (isOrthographicCamera3 || geometry3) {
              if (props.scale) {
                if (!Array.isArray(props.scale)) {
                  occlusionMeshRef.current.scale.setScalar(1 / props.scale);
                } else if (props.scale instanceof Vector3) {
                  occlusionMeshRef.current.scale.copy(props.scale.clone().divideScalar(1));
                } else {
                  occlusionMeshRef.current.scale.set(1 / props.scale[0], 1 / props.scale[1], 1 / props.scale[2]);
                }
              }
            } else {
              const ratio = (distanceFactor || 10) / 400;
              const w = el2.clientWidth * ratio;
              const h = el2.clientHeight * ratio;
              occlusionMeshRef.current.scale.set(w, h, 1);
            }
            isMeshSizeSet.current = true;
          }
        }
      } else {
        const ele = el.children[0];
        if (ele != null && ele.clientWidth && ele != null && ele.clientHeight) {
          const ratio = 1 / viewport.factor;
          const w = ele.clientWidth * ratio;
          const h = ele.clientHeight * ratio;
          occlusionMeshRef.current.scale.set(w, h, 1);
          isMeshSizeSet.current = true;
        }
        occlusionMeshRef.current.lookAt(gl2.camera.position);
      }
    }
  });
  const shaders = React.useMemo(() => ({
    vertexShader: !transform ? (
      /* glsl */
      `
          /*
            This shader is from the THREE's SpriteMaterial.
            We need to turn the backing plane into a Sprite
            (make it always face the camera) if "transfrom"
            is false.
          */
          #include <common>

          void main() {
            vec2 center = vec2(0., 1.);
            float rotation = 0.0;

            // This is somewhat arbitrary, but it seems to work well
            // Need to figure out how to derive this dynamically if it even matters
            float size = 0.03;

            vec4 mvPosition = modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );
            vec2 scale;
            scale.x = length( vec3( modelMatrix[ 0 ].x, modelMatrix[ 0 ].y, modelMatrix[ 0 ].z ) );
            scale.y = length( vec3( modelMatrix[ 1 ].x, modelMatrix[ 1 ].y, modelMatrix[ 1 ].z ) );

            bool isPerspective = isPerspectiveMatrix( projectionMatrix );
            if ( isPerspective ) scale *= - mvPosition.z;

            vec2 alignedPosition = ( position.xy - ( center - vec2( 0.5 ) ) ) * scale * size;
            vec2 rotatedPosition;
            rotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;
            rotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;
            mvPosition.xy += rotatedPosition;

            gl_Position = projectionMatrix * mvPosition;
          }
      `
    ) : void 0,
    fragmentShader: (
      /* glsl */
      `
        void main() {
          gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
        }
      `
    )
  }), [transform]);
  return React.createElement("group", _extends({}, props, {
    ref: group
  }), occlude && !isRayCastOcclusion && React.createElement("mesh", {
    castShadow,
    receiveShadow,
    ref: occlusionMeshRef
  }, geometry3 || React.createElement("planeGeometry", null), material || React.createElement("shaderMaterial", {
    side: DoubleSide,
    vertexShader: shaders.vertexShader,
    fragmentShader: shaders.fragmentShader
  })));
});

// node_modules/@react-three/drei/web/CycleRaycast.js
var React2 = __toESM(require_react());
function CycleRaycast({
  onChanged,
  portal,
  preventDefault = true,
  scroll = true,
  keyCode = 9
}) {
  const cycle = React2.useRef(0);
  const setEvents = useThree((state) => state.setEvents);
  const get = useThree((state) => state.get);
  const gl = useThree((state) => state.gl);
  React2.useEffect(() => {
    var _portal$current;
    let hits = [];
    let lastEvent = void 0;
    const prev = get().events.filter;
    const target2 = (_portal$current = portal == null ? void 0 : portal.current) !== null && _portal$current !== void 0 ? _portal$current : gl.domElement.parentNode;
    const renderStatus = () => target2 && onChanged && onChanged(hits, Math.round(cycle.current) % hits.length);
    setEvents({
      filter: (intersections, state) => {
        let clone2 = [...intersections];
        if (clone2.length !== hits.length || !hits.every((hit) => clone2.map((e2) => e2.object.uuid).includes(hit.object.uuid))) {
          cycle.current = 0;
          hits = clone2;
          renderStatus();
        }
        if (prev) clone2 = prev(clone2, state);
        for (let i4 = 0; i4 < Math.round(cycle.current) % clone2.length; i4++) {
          const first2 = clone2.shift();
          clone2 = [...clone2, first2];
        }
        return clone2;
      }
    });
    const refresh = (fn) => {
      var _get$events$handlers, _get$events$handlers2;
      cycle.current = fn(cycle.current);
      (_get$events$handlers = get().events.handlers) == null || _get$events$handlers.onPointerCancel(void 0);
      (_get$events$handlers2 = get().events.handlers) == null || _get$events$handlers2.onPointerMove(lastEvent);
      renderStatus();
    };
    const tabEvent = (event) => {
      if ((event.keyCode || event.which) === keyCode) {
        if (preventDefault) event.preventDefault();
        if (hits.length > 1) refresh((current) => current + 1);
      }
    };
    const wheelEvent = (event) => {
      if (preventDefault) event.preventDefault();
      let delta = 0;
      if (!event) event = window.event;
      if (event.wheelDelta) delta = event.wheelDelta / 120;
      else if (event.detail) delta = -event.detail / 3;
      if (hits.length > 1) refresh((current) => Math.abs(current - delta));
    };
    const moveEvent = (event) => lastEvent = event;
    document.addEventListener("pointermove", moveEvent, {
      passive: true
    });
    if (scroll) document.addEventListener("wheel", wheelEvent);
    if (keyCode !== void 0) document.addEventListener("keydown", tabEvent);
    return () => {
      setEvents({
        filter: prev
      });
      if (keyCode !== void 0) document.removeEventListener("keydown", tabEvent);
      if (scroll) document.removeEventListener("wheel", wheelEvent);
      document.removeEventListener("pointermove", moveEvent);
    };
  }, [gl, get, setEvents, preventDefault, scroll, keyCode]);
  return null;
}

// node_modules/@react-three/drei/web/useCursor.js
var React3 = __toESM(require_react());
function useCursor(hovered, onPointerOver = "pointer", onPointerOut = "auto", container = document.body) {
  React3.useEffect(() => {
    if (hovered) {
      container.style.cursor = onPointerOver;
      return () => void (container.style.cursor = onPointerOut);
    }
  }, [hovered]);
}

// node_modules/@react-three/drei/web/Loader.js
var React6 = __toESM(require_react());

// node_modules/@react-three/drei/core/Progress.js
var React5 = __toESM(require_react());

// node_modules/zustand/esm/react.mjs
var import_react = __toESM(require_react(), 1);
var identity = (arg) => arg;
function useStore(api, selector = identity) {
  const slice2 = import_react.default.useSyncExternalStore(
    api.subscribe,
    import_react.default.useCallback(() => selector(api.getState()), [api, selector]),
    import_react.default.useCallback(() => selector(api.getInitialState()), [api, selector])
  );
  import_react.default.useDebugValue(slice2);
  return slice2;
}
var createImpl = (createState) => {
  const api = createStore(createState);
  const useBoundStore = (selector) => useStore(api, selector);
  Object.assign(useBoundStore, api);
  return useBoundStore;
};
var create = ((createState) => createState ? createImpl(createState) : createImpl);

// node_modules/@react-three/drei/core/Progress.js
var saveLastTotalLoaded = 0;
var useProgress = create((set) => {
  DefaultLoadingManager.onStart = (item, loaded, total) => {
    set({
      active: true,
      item,
      loaded,
      total,
      progress: (loaded - saveLastTotalLoaded) / (total - saveLastTotalLoaded) * 100
    });
  };
  DefaultLoadingManager.onLoad = () => {
    set({
      active: false
    });
  };
  DefaultLoadingManager.onError = (item) => set((state) => ({
    errors: [...state.errors, item]
  }));
  DefaultLoadingManager.onProgress = (item, loaded, total) => {
    if (loaded === total) {
      saveLastTotalLoaded = total;
    }
    set({
      active: true,
      item,
      loaded,
      total,
      progress: (loaded - saveLastTotalLoaded) / (total - saveLastTotalLoaded) * 100 || 100
    });
  };
  return {
    errors: [],
    active: false,
    progress: 0,
    item: "",
    loaded: 0,
    total: 0
  };
});
function Progress({
  children
}) {
  const result = useProgress();
  return React5.createElement(React5.Fragment, null, children == null ? void 0 : children(result));
}

// node_modules/@react-three/drei/web/Loader.js
var defaultDataInterpolation = (p2) => `Loading ${p2.toFixed(2)}%`;
function Loader2({
  containerStyles,
  innerStyles,
  barStyles,
  dataStyles,
  dataInterpolation = defaultDataInterpolation,
  initialState = (active) => active
}) {
  const {
    active,
    progress
  } = useProgress();
  const progressRef = React6.useRef(0);
  const rafRef = React6.useRef(0);
  const progressSpanRef = React6.useRef(null);
  const [shown, setShown] = React6.useState(initialState(active));
  React6.useEffect(() => {
    let t3;
    if (active !== shown) t3 = setTimeout(() => setShown(active), 300);
    return () => clearTimeout(t3);
  }, [shown, active]);
  const updateProgress = React6.useCallback(() => {
    if (!progressSpanRef.current) return;
    progressRef.current += (progress - progressRef.current) / 2;
    if (progressRef.current > 0.95 * progress || progress === 100) progressRef.current = progress;
    progressSpanRef.current.innerText = dataInterpolation(progressRef.current);
    if (progressRef.current < progress) rafRef.current = requestAnimationFrame(updateProgress);
  }, [dataInterpolation, progress]);
  React6.useEffect(() => {
    updateProgress();
    return () => cancelAnimationFrame(rafRef.current);
  }, [updateProgress]);
  return shown ? React6.createElement("div", {
    style: {
      ...styles.container,
      opacity: active ? 1 : 0,
      ...containerStyles
    }
  }, React6.createElement("div", null, React6.createElement("div", {
    style: {
      ...styles.inner,
      ...innerStyles
    }
  }, React6.createElement("div", {
    style: {
      ...styles.bar,
      transform: `scaleX(${progress / 100})`,
      ...barStyles
    }
  }), React6.createElement("span", {
    ref: progressSpanRef,
    style: {
      ...styles.data,
      ...dataStyles
    }
  })))) : null;
}
var styles = {
  container: {
    position: "absolute",
    top: 0,
    left: 0,
    width: "100%",
    height: "100%",
    background: "#171717",
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    transition: "opacity 300ms ease",
    zIndex: 1e3
  },
  inner: {
    width: 100,
    height: 3,
    background: "#272727",
    textAlign: "center"
  },
  bar: {
    height: 3,
    width: "100%",
    background: "white",
    transition: "transform 200ms",
    transformOrigin: "left center"
  },
  data: {
    display: "inline-block",
    position: "relative",
    fontVariantNumeric: "tabular-nums",
    marginTop: "0.8em",
    color: "#f0f0f0",
    fontSize: "0.6em",
    fontFamily: `-apple-system, BlinkMacSystemFont, "Inter", "Segoe UI", "Helvetica Neue", Helvetica, Arial, Roboto, Ubuntu, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol"`,
    whiteSpace: "nowrap"
  }
};

// node_modules/@react-three/drei/web/DragControls.js
var React8 = __toESM(require_react());

// node_modules/@use-gesture/core/dist/maths-0ab39ae9.esm.js
function clamp(v5, min, max2) {
  return Math.max(min, Math.min(v5, max2));
}
var V = {
  toVector(v5, fallback) {
    if (v5 === void 0) v5 = fallback;
    return Array.isArray(v5) ? v5 : [v5, v5];
  },
  add(v13, v22) {
    return [v13[0] + v22[0], v13[1] + v22[1]];
  },
  sub(v13, v22) {
    return [v13[0] - v22[0], v13[1] - v22[1]];
  },
  addTo(v13, v22) {
    v13[0] += v22[0];
    v13[1] += v22[1];
  },
  subTo(v13, v22) {
    v13[0] -= v22[0];
    v13[1] -= v22[1];
  }
};
function rubberband(distance3, dimension, constant) {
  if (dimension === 0 || Math.abs(dimension) === Infinity) return Math.pow(distance3, constant * 5);
  return distance3 * dimension * constant / (dimension + constant * distance3);
}
function rubberbandIfOutOfBounds(position2, min, max2, constant = 0.15) {
  if (constant === 0) return clamp(position2, min, max2);
  if (position2 < min) return -rubberband(min - position2, max2 - min, constant) + min;
  if (position2 > max2) return +rubberband(position2 - max2, max2 - min, constant) + max2;
  return position2;
}
function computeRubberband(bounds, [Vx, Vy], [Rx, Ry]) {
  const [[X0, X1], [Y0, Y1]] = bounds;
  return [rubberbandIfOutOfBounds(Vx, X0, X1, Rx), rubberbandIfOutOfBounds(Vy, Y0, Y1, Ry)];
}

// node_modules/@use-gesture/core/dist/actions-fe213e88.esm.js
function _toPrimitive(input, hint) {
  if (typeof input !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}
function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function ownKeys(e2, r2) {
  var t3 = Object.keys(e2);
  if (Object.getOwnPropertySymbols) {
    var o2 = Object.getOwnPropertySymbols(e2);
    r2 && (o2 = o2.filter(function(r3) {
      return Object.getOwnPropertyDescriptor(e2, r3).enumerable;
    })), t3.push.apply(t3, o2);
  }
  return t3;
}
function _objectSpread2(e2) {
  for (var r2 = 1; r2 < arguments.length; r2++) {
    var t3 = null != arguments[r2] ? arguments[r2] : {};
    r2 % 2 ? ownKeys(Object(t3), true).forEach(function(r3) {
      _defineProperty(e2, r3, t3[r3]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e2, Object.getOwnPropertyDescriptors(t3)) : ownKeys(Object(t3)).forEach(function(r3) {
      Object.defineProperty(e2, r3, Object.getOwnPropertyDescriptor(t3, r3));
    });
  }
  return e2;
}
var EVENT_TYPE_MAP = {
  pointer: {
    start: "down",
    change: "move",
    end: "up"
  },
  mouse: {
    start: "down",
    change: "move",
    end: "up"
  },
  touch: {
    start: "start",
    change: "move",
    end: "end"
  },
  gesture: {
    start: "start",
    change: "change",
    end: "end"
  }
};
function capitalize(string) {
  if (!string) return "";
  return string[0].toUpperCase() + string.slice(1);
}
var actionsWithoutCaptureSupported = ["enter", "leave"];
function hasCapture(capture = false, actionKey) {
  return capture && !actionsWithoutCaptureSupported.includes(actionKey);
}
function toHandlerProp(device, action = "", capture = false) {
  const deviceProps = EVENT_TYPE_MAP[device];
  const actionKey = deviceProps ? deviceProps[action] || action : action;
  return "on" + capitalize(device) + capitalize(actionKey) + (hasCapture(capture, actionKey) ? "Capture" : "");
}
var pointerCaptureEvents = ["gotpointercapture", "lostpointercapture"];
function parseProp(prop) {
  let eventKey = prop.substring(2).toLowerCase();
  const passive = !!~eventKey.indexOf("passive");
  if (passive) eventKey = eventKey.replace("passive", "");
  const captureKey = pointerCaptureEvents.includes(eventKey) ? "capturecapture" : "capture";
  const capture = !!~eventKey.indexOf(captureKey);
  if (capture) eventKey = eventKey.replace("capture", "");
  return {
    device: eventKey,
    capture,
    passive
  };
}
function toDomEventType(device, action = "") {
  const deviceProps = EVENT_TYPE_MAP[device];
  const actionKey = deviceProps ? deviceProps[action] || action : action;
  return device + actionKey;
}
function isTouch(event) {
  return "touches" in event;
}
function getPointerType(event) {
  if (isTouch(event)) return "touch";
  if ("pointerType" in event) return event.pointerType;
  return "mouse";
}
function getCurrentTargetTouchList(event) {
  return Array.from(event.touches).filter((e2) => {
    var _event$currentTarget, _event$currentTarget$;
    return e2.target === event.currentTarget || ((_event$currentTarget = event.currentTarget) === null || _event$currentTarget === void 0 || (_event$currentTarget$ = _event$currentTarget.contains) === null || _event$currentTarget$ === void 0 ? void 0 : _event$currentTarget$.call(_event$currentTarget, e2.target));
  });
}
function getTouchList(event) {
  return event.type === "touchend" || event.type === "touchcancel" ? event.changedTouches : event.targetTouches;
}
function getValueEvent(event) {
  return isTouch(event) ? getTouchList(event)[0] : event;
}
function distanceAngle(P1, P2) {
  try {
    const dx = P2.clientX - P1.clientX;
    const dy = P2.clientY - P1.clientY;
    const cx = (P2.clientX + P1.clientX) / 2;
    const cy = (P2.clientY + P1.clientY) / 2;
    const distance3 = Math.hypot(dx, dy);
    const angle = -(Math.atan2(dx, dy) * 180) / Math.PI;
    const origin2 = [cx, cy];
    return {
      angle,
      distance: distance3,
      origin: origin2
    };
  } catch (_unused) {
  }
  return null;
}
function touchIds(event) {
  return getCurrentTargetTouchList(event).map((touch) => touch.identifier);
}
function touchDistanceAngle(event, ids) {
  const [P1, P2] = Array.from(event.touches).filter((touch) => ids.includes(touch.identifier));
  return distanceAngle(P1, P2);
}
function pointerId(event) {
  const valueEvent = getValueEvent(event);
  return isTouch(event) ? valueEvent.identifier : valueEvent.pointerId;
}
function pointerValues(event) {
  const valueEvent = getValueEvent(event);
  return [valueEvent.clientX, valueEvent.clientY];
}
var LINE_HEIGHT = 40;
var PAGE_HEIGHT = 800;
function wheelValues(event) {
  let {
    deltaX,
    deltaY,
    deltaMode
  } = event;
  if (deltaMode === 1) {
    deltaX *= LINE_HEIGHT;
    deltaY *= LINE_HEIGHT;
  } else if (deltaMode === 2) {
    deltaX *= PAGE_HEIGHT;
    deltaY *= PAGE_HEIGHT;
  }
  return [deltaX, deltaY];
}
function scrollValues(event) {
  var _ref, _ref2;
  const {
    scrollX,
    scrollY,
    scrollLeft,
    scrollTop
  } = event.currentTarget;
  return [(_ref = scrollX !== null && scrollX !== void 0 ? scrollX : scrollLeft) !== null && _ref !== void 0 ? _ref : 0, (_ref2 = scrollY !== null && scrollY !== void 0 ? scrollY : scrollTop) !== null && _ref2 !== void 0 ? _ref2 : 0];
}
function getEventDetails(event) {
  const payload = {};
  if ("buttons" in event) payload.buttons = event.buttons;
  if ("shiftKey" in event) {
    const {
      shiftKey,
      altKey,
      metaKey,
      ctrlKey
    } = event;
    Object.assign(payload, {
      shiftKey,
      altKey,
      metaKey,
      ctrlKey
    });
  }
  return payload;
}
function call(v5, ...args) {
  if (typeof v5 === "function") {
    return v5(...args);
  } else {
    return v5;
  }
}
function noop() {
}
function chain(...fns) {
  if (fns.length === 0) return noop;
  if (fns.length === 1) return fns[0];
  return function() {
    let result;
    for (const fn of fns) {
      result = fn.apply(this, arguments) || result;
    }
    return result;
  };
}
function assignDefault(value, fallback) {
  return Object.assign({}, fallback, value || {});
}
var BEFORE_LAST_KINEMATICS_DELAY = 32;
var Engine = class {
  constructor(ctrl, args, key) {
    this.ctrl = ctrl;
    this.args = args;
    this.key = key;
    if (!this.state) {
      this.state = {};
      this.computeValues([0, 0]);
      this.computeInitial();
      if (this.init) this.init();
      this.reset();
    }
  }
  get state() {
    return this.ctrl.state[this.key];
  }
  set state(state) {
    this.ctrl.state[this.key] = state;
  }
  get shared() {
    return this.ctrl.state.shared;
  }
  get eventStore() {
    return this.ctrl.gestureEventStores[this.key];
  }
  get timeoutStore() {
    return this.ctrl.gestureTimeoutStores[this.key];
  }
  get config() {
    return this.ctrl.config[this.key];
  }
  get sharedConfig() {
    return this.ctrl.config.shared;
  }
  get handler() {
    return this.ctrl.handlers[this.key];
  }
  reset() {
    const {
      state,
      shared,
      ingKey,
      args
    } = this;
    shared[ingKey] = state._active = state.active = state._blocked = state._force = false;
    state._step = [false, false];
    state.intentional = false;
    state._movement = [0, 0];
    state._distance = [0, 0];
    state._direction = [0, 0];
    state._delta = [0, 0];
    state._bounds = [[-Infinity, Infinity], [-Infinity, Infinity]];
    state.args = args;
    state.axis = void 0;
    state.memo = void 0;
    state.elapsedTime = state.timeDelta = 0;
    state.direction = [0, 0];
    state.distance = [0, 0];
    state.overflow = [0, 0];
    state._movementBound = [false, false];
    state.velocity = [0, 0];
    state.movement = [0, 0];
    state.delta = [0, 0];
    state.timeStamp = 0;
  }
  start(event) {
    const state = this.state;
    const config = this.config;
    if (!state._active) {
      this.reset();
      this.computeInitial();
      state._active = true;
      state.target = event.target;
      state.currentTarget = event.currentTarget;
      state.lastOffset = config.from ? call(config.from, state) : state.offset;
      state.offset = state.lastOffset;
      state.startTime = state.timeStamp = event.timeStamp;
    }
  }
  computeValues(values) {
    const state = this.state;
    state._values = values;
    state.values = this.config.transform(values);
  }
  computeInitial() {
    const state = this.state;
    state._initial = state._values;
    state.initial = state.values;
  }
  compute(event) {
    const {
      state,
      config,
      shared
    } = this;
    state.args = this.args;
    let dt = 0;
    if (event) {
      state.event = event;
      if (config.preventDefault && event.cancelable) state.event.preventDefault();
      state.type = event.type;
      shared.touches = this.ctrl.pointerIds.size || this.ctrl.touchIds.size;
      shared.locked = !!document.pointerLockElement;
      Object.assign(shared, getEventDetails(event));
      shared.down = shared.pressed = shared.buttons % 2 === 1 || shared.touches > 0;
      dt = event.timeStamp - state.timeStamp;
      state.timeStamp = event.timeStamp;
      state.elapsedTime = state.timeStamp - state.startTime;
    }
    if (state._active) {
      const _absoluteDelta = state._delta.map(Math.abs);
      V.addTo(state._distance, _absoluteDelta);
    }
    if (this.axisIntent) this.axisIntent(event);
    const [_m0, _m13] = state._movement;
    const [t0, t1] = config.threshold;
    const {
      _step,
      values
    } = state;
    if (config.hasCustomTransform) {
      if (_step[0] === false) _step[0] = Math.abs(_m0) >= t0 && values[0];
      if (_step[1] === false) _step[1] = Math.abs(_m13) >= t1 && values[1];
    } else {
      if (_step[0] === false) _step[0] = Math.abs(_m0) >= t0 && Math.sign(_m0) * t0;
      if (_step[1] === false) _step[1] = Math.abs(_m13) >= t1 && Math.sign(_m13) * t1;
    }
    state.intentional = _step[0] !== false || _step[1] !== false;
    if (!state.intentional) return;
    const movement = [0, 0];
    if (config.hasCustomTransform) {
      const [v0, v13] = values;
      movement[0] = _step[0] !== false ? v0 - _step[0] : 0;
      movement[1] = _step[1] !== false ? v13 - _step[1] : 0;
    } else {
      movement[0] = _step[0] !== false ? _m0 - _step[0] : 0;
      movement[1] = _step[1] !== false ? _m13 - _step[1] : 0;
    }
    if (this.restrictToAxis && !state._blocked) this.restrictToAxis(movement);
    const previousOffset = state.offset;
    const gestureIsActive = state._active && !state._blocked || state.active;
    if (gestureIsActive) {
      state.first = state._active && !state.active;
      state.last = !state._active && state.active;
      state.active = shared[this.ingKey] = state._active;
      if (event) {
        if (state.first) {
          if ("bounds" in config) state._bounds = call(config.bounds, state);
          if (this.setup) this.setup();
        }
        state.movement = movement;
        this.computeOffset();
      }
    }
    const [ox, oy] = state.offset;
    const [[x0, x1], [y0, y1]] = state._bounds;
    state.overflow = [ox < x0 ? -1 : ox > x1 ? 1 : 0, oy < y0 ? -1 : oy > y1 ? 1 : 0];
    state._movementBound[0] = state.overflow[0] ? state._movementBound[0] === false ? state._movement[0] : state._movementBound[0] : false;
    state._movementBound[1] = state.overflow[1] ? state._movementBound[1] === false ? state._movement[1] : state._movementBound[1] : false;
    const rubberband2 = state._active ? config.rubberband || [0, 0] : [0, 0];
    state.offset = computeRubberband(state._bounds, state.offset, rubberband2);
    state.delta = V.sub(state.offset, previousOffset);
    this.computeMovement();
    if (gestureIsActive && (!state.last || dt > BEFORE_LAST_KINEMATICS_DELAY)) {
      state.delta = V.sub(state.offset, previousOffset);
      const absoluteDelta = state.delta.map(Math.abs);
      V.addTo(state.distance, absoluteDelta);
      state.direction = state.delta.map(Math.sign);
      state._direction = state._delta.map(Math.sign);
      if (!state.first && dt > 0) {
        state.velocity = [absoluteDelta[0] / dt, absoluteDelta[1] / dt];
        state.timeDelta = dt;
      }
    }
  }
  emit() {
    const state = this.state;
    const shared = this.shared;
    const config = this.config;
    if (!state._active) this.clean();
    if ((state._blocked || !state.intentional) && !state._force && !config.triggerAllEvents) return;
    const memo = this.handler(_objectSpread2(_objectSpread2(_objectSpread2({}, shared), state), {}, {
      [this.aliasKey]: state.values
    }));
    if (memo !== void 0) state.memo = memo;
  }
  clean() {
    this.eventStore.clean();
    this.timeoutStore.clean();
  }
};
function selectAxis([dx, dy], threshold) {
  const absDx = Math.abs(dx);
  const absDy = Math.abs(dy);
  if (absDx > absDy && absDx > threshold) {
    return "x";
  }
  if (absDy > absDx && absDy > threshold) {
    return "y";
  }
  return void 0;
}
var CoordinatesEngine = class extends Engine {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "aliasKey", "xy");
  }
  reset() {
    super.reset();
    this.state.axis = void 0;
  }
  init() {
    this.state.offset = [0, 0];
    this.state.lastOffset = [0, 0];
  }
  computeOffset() {
    this.state.offset = V.add(this.state.lastOffset, this.state.movement);
  }
  computeMovement() {
    this.state.movement = V.sub(this.state.offset, this.state.lastOffset);
  }
  axisIntent(event) {
    const state = this.state;
    const config = this.config;
    if (!state.axis && event) {
      const threshold = typeof config.axisThreshold === "object" ? config.axisThreshold[getPointerType(event)] : config.axisThreshold;
      state.axis = selectAxis(state._movement, threshold);
    }
    state._blocked = (config.lockDirection || !!config.axis) && !state.axis || !!config.axis && config.axis !== state.axis;
  }
  restrictToAxis(v5) {
    if (this.config.axis || this.config.lockDirection) {
      switch (this.state.axis) {
        case "x":
          v5[1] = 0;
          break;
        case "y":
          v5[0] = 0;
          break;
      }
    }
  }
};
var identity2 = (v5) => v5;
var DEFAULT_RUBBERBAND = 0.15;
var commonConfigResolver = {
  enabled(value = true) {
    return value;
  },
  eventOptions(value, _k, config) {
    return _objectSpread2(_objectSpread2({}, config.shared.eventOptions), value);
  },
  preventDefault(value = false) {
    return value;
  },
  triggerAllEvents(value = false) {
    return value;
  },
  rubberband(value = 0) {
    switch (value) {
      case true:
        return [DEFAULT_RUBBERBAND, DEFAULT_RUBBERBAND];
      case false:
        return [0, 0];
      default:
        return V.toVector(value);
    }
  },
  from(value) {
    if (typeof value === "function") return value;
    if (value != null) return V.toVector(value);
  },
  transform(value, _k, config) {
    const transform = value || config.shared.transform;
    this.hasCustomTransform = !!transform;
    if (true) {
      const originalTransform = transform || identity2;
      return (v5) => {
        const r2 = originalTransform(v5);
        if (!isFinite(r2[0]) || !isFinite(r2[1])) {
          console.warn(`[@use-gesture]: config.transform() must produce a valid result, but it was: [${r2[0]},${[1]}]`);
        }
        return r2;
      };
    }
    return transform || identity2;
  },
  threshold(value) {
    return V.toVector(value, 0);
  }
};
if (true) {
  Object.assign(commonConfigResolver, {
    domTarget(value) {
      if (value !== void 0) {
        throw Error(`[@use-gesture]: \`domTarget\` option has been renamed to \`target\`.`);
      }
      return NaN;
    },
    lockDirection(value) {
      if (value !== void 0) {
        throw Error(`[@use-gesture]: \`lockDirection\` option has been merged with \`axis\`. Use it as in \`{ axis: 'lock' }\``);
      }
      return NaN;
    },
    initial(value) {
      if (value !== void 0) {
        throw Error(`[@use-gesture]: \`initial\` option has been renamed to \`from\`.`);
      }
      return NaN;
    }
  });
}
var DEFAULT_AXIS_THRESHOLD = 0;
var coordinatesConfigResolver = _objectSpread2(_objectSpread2({}, commonConfigResolver), {}, {
  axis(_v4, _k, {
    axis
  }) {
    this.lockDirection = axis === "lock";
    if (!this.lockDirection) return axis;
  },
  axisThreshold(value = DEFAULT_AXIS_THRESHOLD) {
    return value;
  },
  bounds(value = {}) {
    if (typeof value === "function") {
      return (state) => coordinatesConfigResolver.bounds(value(state));
    }
    if ("current" in value) {
      return () => value.current;
    }
    if (typeof HTMLElement === "function" && value instanceof HTMLElement) {
      return value;
    }
    const {
      left = -Infinity,
      right = Infinity,
      top = -Infinity,
      bottom = Infinity
    } = value;
    return [[left, right], [top, bottom]];
  }
});
var KEYS_DELTA_MAP = {
  ArrowRight: (displacement, factor = 1) => [displacement * factor, 0],
  ArrowLeft: (displacement, factor = 1) => [-1 * displacement * factor, 0],
  ArrowUp: (displacement, factor = 1) => [0, -1 * displacement * factor],
  ArrowDown: (displacement, factor = 1) => [0, displacement * factor]
};
var DragEngine = class extends CoordinatesEngine {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "ingKey", "dragging");
  }
  reset() {
    super.reset();
    const state = this.state;
    state._pointerId = void 0;
    state._pointerActive = false;
    state._keyboardActive = false;
    state._preventScroll = false;
    state._delayed = false;
    state.swipe = [0, 0];
    state.tap = false;
    state.canceled = false;
    state.cancel = this.cancel.bind(this);
  }
  setup() {
    const state = this.state;
    if (state._bounds instanceof HTMLElement) {
      const boundRect = state._bounds.getBoundingClientRect();
      const targetRect = state.currentTarget.getBoundingClientRect();
      const _bounds = {
        left: boundRect.left - targetRect.left + state.offset[0],
        right: boundRect.right - targetRect.right + state.offset[0],
        top: boundRect.top - targetRect.top + state.offset[1],
        bottom: boundRect.bottom - targetRect.bottom + state.offset[1]
      };
      state._bounds = coordinatesConfigResolver.bounds(_bounds);
    }
  }
  cancel() {
    const state = this.state;
    if (state.canceled) return;
    state.canceled = true;
    state._active = false;
    setTimeout(() => {
      this.compute();
      this.emit();
    }, 0);
  }
  setActive() {
    this.state._active = this.state._pointerActive || this.state._keyboardActive;
  }
  clean() {
    this.pointerClean();
    this.state._pointerActive = false;
    this.state._keyboardActive = false;
    super.clean();
  }
  pointerDown(event) {
    const config = this.config;
    const state = this.state;
    if (event.buttons != null && (Array.isArray(config.pointerButtons) ? !config.pointerButtons.includes(event.buttons) : config.pointerButtons !== -1 && config.pointerButtons !== event.buttons)) return;
    const ctrlIds = this.ctrl.setEventIds(event);
    if (config.pointerCapture) {
      event.target.setPointerCapture(event.pointerId);
    }
    if (ctrlIds && ctrlIds.size > 1 && state._pointerActive) return;
    this.start(event);
    this.setupPointer(event);
    state._pointerId = pointerId(event);
    state._pointerActive = true;
    this.computeValues(pointerValues(event));
    this.computeInitial();
    if (config.preventScrollAxis && getPointerType(event) !== "mouse") {
      state._active = false;
      this.setupScrollPrevention(event);
    } else if (config.delay > 0) {
      this.setupDelayTrigger(event);
      if (config.triggerAllEvents) {
        this.compute(event);
        this.emit();
      }
    } else {
      this.startPointerDrag(event);
    }
  }
  startPointerDrag(event) {
    const state = this.state;
    state._active = true;
    state._preventScroll = true;
    state._delayed = false;
    this.compute(event);
    this.emit();
  }
  pointerMove(event) {
    const state = this.state;
    const config = this.config;
    if (!state._pointerActive) return;
    const id = pointerId(event);
    if (state._pointerId !== void 0 && id !== state._pointerId) return;
    const _values = pointerValues(event);
    if (document.pointerLockElement === event.target) {
      state._delta = [event.movementX, event.movementY];
    } else {
      state._delta = V.sub(_values, state._values);
      this.computeValues(_values);
    }
    V.addTo(state._movement, state._delta);
    this.compute(event);
    if (state._delayed && state.intentional) {
      this.timeoutStore.remove("dragDelay");
      state.active = false;
      this.startPointerDrag(event);
      return;
    }
    if (config.preventScrollAxis && !state._preventScroll) {
      if (state.axis) {
        if (state.axis === config.preventScrollAxis || config.preventScrollAxis === "xy") {
          state._active = false;
          this.clean();
          return;
        } else {
          this.timeoutStore.remove("startPointerDrag");
          this.startPointerDrag(event);
          return;
        }
      } else {
        return;
      }
    }
    this.emit();
  }
  pointerUp(event) {
    this.ctrl.setEventIds(event);
    try {
      if (this.config.pointerCapture && event.target.hasPointerCapture(event.pointerId)) {
        ;
        event.target.releasePointerCapture(event.pointerId);
      }
    } catch (_unused) {
      if (true) {
        console.warn(`[@use-gesture]: If you see this message, it's likely that you're using an outdated version of \`@react-three/fiber\`. 

Please upgrade to the latest version.`);
      }
    }
    const state = this.state;
    const config = this.config;
    if (!state._active || !state._pointerActive) return;
    const id = pointerId(event);
    if (state._pointerId !== void 0 && id !== state._pointerId) return;
    this.state._pointerActive = false;
    this.setActive();
    this.compute(event);
    const [dx, dy] = state._distance;
    state.tap = dx <= config.tapsThreshold && dy <= config.tapsThreshold;
    if (state.tap && config.filterTaps) {
      state._force = true;
    } else {
      const [_dx, _dy] = state._delta;
      const [_mx, _my] = state._movement;
      const [svx, svy] = config.swipe.velocity;
      const [sx, sy] = config.swipe.distance;
      const sdt = config.swipe.duration;
      if (state.elapsedTime < sdt) {
        const _vx = Math.abs(_dx / state.timeDelta);
        const _vy = Math.abs(_dy / state.timeDelta);
        if (_vx > svx && Math.abs(_mx) > sx) state.swipe[0] = Math.sign(_dx);
        if (_vy > svy && Math.abs(_my) > sy) state.swipe[1] = Math.sign(_dy);
      }
    }
    this.emit();
  }
  pointerClick(event) {
    if (!this.state.tap && event.detail > 0) {
      event.preventDefault();
      event.stopPropagation();
    }
  }
  setupPointer(event) {
    const config = this.config;
    const device = config.device;
    if (true) {
      try {
        if (device === "pointer" && config.preventScrollDelay === void 0) {
          const currentTarget = "uv" in event ? event.sourceEvent.currentTarget : event.currentTarget;
          const style = window.getComputedStyle(currentTarget);
          if (style.touchAction === "auto") {
            console.warn(`[@use-gesture]: The drag target has its \`touch-action\` style property set to \`auto\`. It is recommended to add \`touch-action: 'none'\` so that the drag gesture behaves correctly on touch-enabled devices. For more information read this: https://use-gesture.netlify.app/docs/extras/#touch-action.

This message will only show in development mode. It won't appear in production. If this is intended, you can ignore it.`, currentTarget);
          }
        }
      } catch (_unused2) {
      }
    }
    if (config.pointerLock) {
      event.currentTarget.requestPointerLock();
    }
    if (!config.pointerCapture) {
      this.eventStore.add(this.sharedConfig.window, device, "change", this.pointerMove.bind(this));
      this.eventStore.add(this.sharedConfig.window, device, "end", this.pointerUp.bind(this));
      this.eventStore.add(this.sharedConfig.window, device, "cancel", this.pointerUp.bind(this));
    }
  }
  pointerClean() {
    if (this.config.pointerLock && document.pointerLockElement === this.state.currentTarget) {
      document.exitPointerLock();
    }
  }
  preventScroll(event) {
    if (this.state._preventScroll && event.cancelable) {
      event.preventDefault();
    }
  }
  setupScrollPrevention(event) {
    this.state._preventScroll = false;
    persistEvent(event);
    const remove = this.eventStore.add(this.sharedConfig.window, "touch", "change", this.preventScroll.bind(this), {
      passive: false
    });
    this.eventStore.add(this.sharedConfig.window, "touch", "end", remove);
    this.eventStore.add(this.sharedConfig.window, "touch", "cancel", remove);
    this.timeoutStore.add("startPointerDrag", this.startPointerDrag.bind(this), this.config.preventScrollDelay, event);
  }
  setupDelayTrigger(event) {
    this.state._delayed = true;
    this.timeoutStore.add("dragDelay", () => {
      this.state._step = [0, 0];
      this.startPointerDrag(event);
    }, this.config.delay);
  }
  keyDown(event) {
    const deltaFn = KEYS_DELTA_MAP[event.key];
    if (deltaFn) {
      const state = this.state;
      const factor = event.shiftKey ? 10 : event.altKey ? 0.1 : 1;
      this.start(event);
      state._delta = deltaFn(this.config.keyboardDisplacement, factor);
      state._keyboardActive = true;
      V.addTo(state._movement, state._delta);
      this.compute(event);
      this.emit();
    }
  }
  keyUp(event) {
    if (!(event.key in KEYS_DELTA_MAP)) return;
    this.state._keyboardActive = false;
    this.setActive();
    this.compute(event);
    this.emit();
  }
  bind(bindFunction) {
    const device = this.config.device;
    bindFunction(device, "start", this.pointerDown.bind(this));
    if (this.config.pointerCapture) {
      bindFunction(device, "change", this.pointerMove.bind(this));
      bindFunction(device, "end", this.pointerUp.bind(this));
      bindFunction(device, "cancel", this.pointerUp.bind(this));
      bindFunction("lostPointerCapture", "", this.pointerUp.bind(this));
    }
    if (this.config.keys) {
      bindFunction("key", "down", this.keyDown.bind(this));
      bindFunction("key", "up", this.keyUp.bind(this));
    }
    if (this.config.filterTaps) {
      bindFunction("click", "", this.pointerClick.bind(this), {
        capture: true,
        passive: false
      });
    }
  }
};
function persistEvent(event) {
  "persist" in event && typeof event.persist === "function" && event.persist();
}
var isBrowser = typeof window !== "undefined" && window.document && window.document.createElement;
function supportsTouchEvents() {
  return isBrowser && "ontouchstart" in window;
}
function isTouchScreen() {
  return supportsTouchEvents() || isBrowser && window.navigator.maxTouchPoints > 1;
}
function supportsPointerEvents() {
  return isBrowser && "onpointerdown" in window;
}
function supportsPointerLock() {
  return isBrowser && "exitPointerLock" in window.document;
}
function supportsGestureEvents() {
  try {
    return "constructor" in GestureEvent;
  } catch (e2) {
    return false;
  }
}
var SUPPORT = {
  isBrowser,
  gesture: supportsGestureEvents(),
  touch: supportsTouchEvents(),
  touchscreen: isTouchScreen(),
  pointer: supportsPointerEvents(),
  pointerLock: supportsPointerLock()
};
var DEFAULT_PREVENT_SCROLL_DELAY = 250;
var DEFAULT_DRAG_DELAY = 180;
var DEFAULT_SWIPE_VELOCITY = 0.5;
var DEFAULT_SWIPE_DISTANCE = 50;
var DEFAULT_SWIPE_DURATION = 250;
var DEFAULT_KEYBOARD_DISPLACEMENT = 10;
var DEFAULT_DRAG_AXIS_THRESHOLD = {
  mouse: 0,
  touch: 0,
  pen: 8
};
var dragConfigResolver = _objectSpread2(_objectSpread2({}, coordinatesConfigResolver), {}, {
  device(_v4, _k, {
    pointer: {
      touch = false,
      lock = false,
      mouse = false
    } = {}
  }) {
    this.pointerLock = lock && SUPPORT.pointerLock;
    if (SUPPORT.touch && touch) return "touch";
    if (this.pointerLock) return "mouse";
    if (SUPPORT.pointer && !mouse) return "pointer";
    if (SUPPORT.touch) return "touch";
    return "mouse";
  },
  preventScrollAxis(value, _k, {
    preventScroll
  }) {
    this.preventScrollDelay = typeof preventScroll === "number" ? preventScroll : preventScroll || preventScroll === void 0 && value ? DEFAULT_PREVENT_SCROLL_DELAY : void 0;
    if (!SUPPORT.touchscreen || preventScroll === false) return void 0;
    return value ? value : preventScroll !== void 0 ? "y" : void 0;
  },
  pointerCapture(_v4, _k, {
    pointer: {
      capture = true,
      buttons = 1,
      keys = true
    } = {}
  }) {
    this.pointerButtons = buttons;
    this.keys = keys;
    return !this.pointerLock && this.device === "pointer" && capture;
  },
  threshold(value, _k, {
    filterTaps = false,
    tapsThreshold = 3,
    axis = void 0
  }) {
    const threshold = V.toVector(value, filterTaps ? tapsThreshold : axis ? 1 : 0);
    this.filterTaps = filterTaps;
    this.tapsThreshold = tapsThreshold;
    return threshold;
  },
  swipe({
    velocity = DEFAULT_SWIPE_VELOCITY,
    distance: distance3 = DEFAULT_SWIPE_DISTANCE,
    duration = DEFAULT_SWIPE_DURATION
  } = {}) {
    return {
      velocity: this.transform(V.toVector(velocity)),
      distance: this.transform(V.toVector(distance3)),
      duration
    };
  },
  delay(value = 0) {
    switch (value) {
      case true:
        return DEFAULT_DRAG_DELAY;
      case false:
        return 0;
      default:
        return value;
    }
  },
  axisThreshold(value) {
    if (!value) return DEFAULT_DRAG_AXIS_THRESHOLD;
    return _objectSpread2(_objectSpread2({}, DEFAULT_DRAG_AXIS_THRESHOLD), value);
  },
  keyboardDisplacement(value = DEFAULT_KEYBOARD_DISPLACEMENT) {
    return value;
  }
});
if (true) {
  Object.assign(dragConfigResolver, {
    useTouch(value) {
      if (value !== void 0) {
        throw Error(`[@use-gesture]: \`useTouch\` option has been renamed to \`pointer.touch\`. Use it as in \`{ pointer: { touch: true } }\`.`);
      }
      return NaN;
    },
    experimental_preventWindowScrollY(value) {
      if (value !== void 0) {
        throw Error(`[@use-gesture]: \`experimental_preventWindowScrollY\` option has been renamed to \`preventScroll\`.`);
      }
      return NaN;
    },
    swipeVelocity(value) {
      if (value !== void 0) {
        throw Error(`[@use-gesture]: \`swipeVelocity\` option has been renamed to \`swipe.velocity\`. Use it as in \`{ swipe: { velocity: 0.5 } }\`.`);
      }
      return NaN;
    },
    swipeDistance(value) {
      if (value !== void 0) {
        throw Error(`[@use-gesture]: \`swipeDistance\` option has been renamed to \`swipe.distance\`. Use it as in \`{ swipe: { distance: 50 } }\`.`);
      }
      return NaN;
    },
    swipeDuration(value) {
      if (value !== void 0) {
        throw Error(`[@use-gesture]: \`swipeDuration\` option has been renamed to \`swipe.duration\`. Use it as in \`{ swipe: { duration: 250 } }\`.`);
      }
      return NaN;
    }
  });
}
function clampStateInternalMovementToBounds(state) {
  const [ox, oy] = state.overflow;
  const [dx, dy] = state._delta;
  const [dirx, diry] = state._direction;
  if (ox < 0 && dx > 0 && dirx < 0 || ox > 0 && dx < 0 && dirx > 0) {
    state._movement[0] = state._movementBound[0];
  }
  if (oy < 0 && dy > 0 && diry < 0 || oy > 0 && dy < 0 && diry > 0) {
    state._movement[1] = state._movementBound[1];
  }
}
var SCALE_ANGLE_RATIO_INTENT_DEG = 30;
var PINCH_WHEEL_RATIO = 100;
var PinchEngine = class extends Engine {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "ingKey", "pinching");
    _defineProperty(this, "aliasKey", "da");
  }
  init() {
    this.state.offset = [1, 0];
    this.state.lastOffset = [1, 0];
    this.state._pointerEvents = /* @__PURE__ */ new Map();
  }
  reset() {
    super.reset();
    const state = this.state;
    state._touchIds = [];
    state.canceled = false;
    state.cancel = this.cancel.bind(this);
    state.turns = 0;
  }
  computeOffset() {
    const {
      type,
      movement,
      lastOffset
    } = this.state;
    if (type === "wheel") {
      this.state.offset = V.add(movement, lastOffset);
    } else {
      this.state.offset = [(1 + movement[0]) * lastOffset[0], movement[1] + lastOffset[1]];
    }
  }
  computeMovement() {
    const {
      offset,
      lastOffset
    } = this.state;
    this.state.movement = [offset[0] / lastOffset[0], offset[1] - lastOffset[1]];
  }
  axisIntent() {
    const state = this.state;
    const [_m0, _m13] = state._movement;
    if (!state.axis) {
      const axisMovementDifference = Math.abs(_m0) * SCALE_ANGLE_RATIO_INTENT_DEG - Math.abs(_m13);
      if (axisMovementDifference < 0) state.axis = "angle";
      else if (axisMovementDifference > 0) state.axis = "scale";
    }
  }
  restrictToAxis(v5) {
    if (this.config.lockDirection) {
      if (this.state.axis === "scale") v5[1] = 0;
      else if (this.state.axis === "angle") v5[0] = 0;
    }
  }
  cancel() {
    const state = this.state;
    if (state.canceled) return;
    setTimeout(() => {
      state.canceled = true;
      state._active = false;
      this.compute();
      this.emit();
    }, 0);
  }
  touchStart(event) {
    this.ctrl.setEventIds(event);
    const state = this.state;
    const ctrlTouchIds = this.ctrl.touchIds;
    if (state._active) {
      if (state._touchIds.every((id) => ctrlTouchIds.has(id))) return;
    }
    if (ctrlTouchIds.size < 2) return;
    this.start(event);
    state._touchIds = Array.from(ctrlTouchIds).slice(0, 2);
    const payload = touchDistanceAngle(event, state._touchIds);
    if (!payload) return;
    this.pinchStart(event, payload);
  }
  pointerStart(event) {
    if (event.buttons != null && event.buttons % 2 !== 1) return;
    this.ctrl.setEventIds(event);
    event.target.setPointerCapture(event.pointerId);
    const state = this.state;
    const _pointerEvents = state._pointerEvents;
    const ctrlPointerIds = this.ctrl.pointerIds;
    if (state._active) {
      if (Array.from(_pointerEvents.keys()).every((id) => ctrlPointerIds.has(id))) return;
    }
    if (_pointerEvents.size < 2) {
      _pointerEvents.set(event.pointerId, event);
    }
    if (state._pointerEvents.size < 2) return;
    this.start(event);
    const payload = distanceAngle(...Array.from(_pointerEvents.values()));
    if (!payload) return;
    this.pinchStart(event, payload);
  }
  pinchStart(event, payload) {
    const state = this.state;
    state.origin = payload.origin;
    this.computeValues([payload.distance, payload.angle]);
    this.computeInitial();
    this.compute(event);
    this.emit();
  }
  touchMove(event) {
    if (!this.state._active) return;
    const payload = touchDistanceAngle(event, this.state._touchIds);
    if (!payload) return;
    this.pinchMove(event, payload);
  }
  pointerMove(event) {
    const _pointerEvents = this.state._pointerEvents;
    if (_pointerEvents.has(event.pointerId)) {
      _pointerEvents.set(event.pointerId, event);
    }
    if (!this.state._active) return;
    const payload = distanceAngle(...Array.from(_pointerEvents.values()));
    if (!payload) return;
    this.pinchMove(event, payload);
  }
  pinchMove(event, payload) {
    const state = this.state;
    const prev_a = state._values[1];
    const delta_a = payload.angle - prev_a;
    let delta_turns = 0;
    if (Math.abs(delta_a) > 270) delta_turns += Math.sign(delta_a);
    this.computeValues([payload.distance, payload.angle - 360 * delta_turns]);
    state.origin = payload.origin;
    state.turns = delta_turns;
    state._movement = [state._values[0] / state._initial[0] - 1, state._values[1] - state._initial[1]];
    this.compute(event);
    this.emit();
  }
  touchEnd(event) {
    this.ctrl.setEventIds(event);
    if (!this.state._active) return;
    if (this.state._touchIds.some((id) => !this.ctrl.touchIds.has(id))) {
      this.state._active = false;
      this.compute(event);
      this.emit();
    }
  }
  pointerEnd(event) {
    const state = this.state;
    this.ctrl.setEventIds(event);
    try {
      event.target.releasePointerCapture(event.pointerId);
    } catch (_unused) {
    }
    if (state._pointerEvents.has(event.pointerId)) {
      state._pointerEvents.delete(event.pointerId);
    }
    if (!state._active) return;
    if (state._pointerEvents.size < 2) {
      state._active = false;
      this.compute(event);
      this.emit();
    }
  }
  gestureStart(event) {
    if (event.cancelable) event.preventDefault();
    const state = this.state;
    if (state._active) return;
    this.start(event);
    this.computeValues([event.scale, event.rotation]);
    state.origin = [event.clientX, event.clientY];
    this.compute(event);
    this.emit();
  }
  gestureMove(event) {
    if (event.cancelable) event.preventDefault();
    if (!this.state._active) return;
    const state = this.state;
    this.computeValues([event.scale, event.rotation]);
    state.origin = [event.clientX, event.clientY];
    const _previousMovement = state._movement;
    state._movement = [event.scale - 1, event.rotation];
    state._delta = V.sub(state._movement, _previousMovement);
    this.compute(event);
    this.emit();
  }
  gestureEnd(event) {
    if (!this.state._active) return;
    this.state._active = false;
    this.compute(event);
    this.emit();
  }
  wheel(event) {
    const modifierKey = this.config.modifierKey;
    if (modifierKey && (Array.isArray(modifierKey) ? !modifierKey.find((k) => event[k]) : !event[modifierKey])) return;
    if (!this.state._active) this.wheelStart(event);
    else this.wheelChange(event);
    this.timeoutStore.add("wheelEnd", this.wheelEnd.bind(this));
  }
  wheelStart(event) {
    this.start(event);
    this.wheelChange(event);
  }
  wheelChange(event) {
    const isR3f = "uv" in event;
    if (!isR3f) {
      if (event.cancelable) {
        event.preventDefault();
      }
      if (!event.defaultPrevented) {
        console.warn(`[@use-gesture]: To properly support zoom on trackpads, try using the \`target\` option.

This message will only appear in development mode.`);
      }
    }
    const state = this.state;
    state._delta = [-wheelValues(event)[1] / PINCH_WHEEL_RATIO * state.offset[0], 0];
    V.addTo(state._movement, state._delta);
    clampStateInternalMovementToBounds(state);
    this.state.origin = [event.clientX, event.clientY];
    this.compute(event);
    this.emit();
  }
  wheelEnd() {
    if (!this.state._active) return;
    this.state._active = false;
    this.compute();
    this.emit();
  }
  bind(bindFunction) {
    const device = this.config.device;
    if (!!device) {
      bindFunction(device, "start", this[device + "Start"].bind(this));
      bindFunction(device, "change", this[device + "Move"].bind(this));
      bindFunction(device, "end", this[device + "End"].bind(this));
      bindFunction(device, "cancel", this[device + "End"].bind(this));
      bindFunction("lostPointerCapture", "", this[device + "End"].bind(this));
    }
    if (this.config.pinchOnWheel) {
      bindFunction("wheel", "", this.wheel.bind(this), {
        passive: false
      });
    }
  }
};
var pinchConfigResolver = _objectSpread2(_objectSpread2({}, commonConfigResolver), {}, {
  device(_v4, _k, {
    shared,
    pointer: {
      touch = false
    } = {}
  }) {
    const sharedConfig = shared;
    if (sharedConfig.target && !SUPPORT.touch && SUPPORT.gesture) return "gesture";
    if (SUPPORT.touch && touch) return "touch";
    if (SUPPORT.touchscreen) {
      if (SUPPORT.pointer) return "pointer";
      if (SUPPORT.touch) return "touch";
    }
  },
  bounds(_v4, _k, {
    scaleBounds = {},
    angleBounds = {}
  }) {
    const _scaleBounds = (state) => {
      const D = assignDefault(call(scaleBounds, state), {
        min: -Infinity,
        max: Infinity
      });
      return [D.min, D.max];
    };
    const _angleBounds = (state) => {
      const A = assignDefault(call(angleBounds, state), {
        min: -Infinity,
        max: Infinity
      });
      return [A.min, A.max];
    };
    if (typeof scaleBounds !== "function" && typeof angleBounds !== "function") return [_scaleBounds(), _angleBounds()];
    return (state) => [_scaleBounds(state), _angleBounds(state)];
  },
  threshold(value, _k, config) {
    this.lockDirection = config.axis === "lock";
    const threshold = V.toVector(value, this.lockDirection ? [0.1, 3] : 0);
    return threshold;
  },
  modifierKey(value) {
    if (value === void 0) return "ctrlKey";
    return value;
  },
  pinchOnWheel(value = true) {
    return value;
  }
});
var MoveEngine = class extends CoordinatesEngine {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "ingKey", "moving");
  }
  move(event) {
    if (this.config.mouseOnly && event.pointerType !== "mouse") return;
    if (!this.state._active) this.moveStart(event);
    else this.moveChange(event);
    this.timeoutStore.add("moveEnd", this.moveEnd.bind(this));
  }
  moveStart(event) {
    this.start(event);
    this.computeValues(pointerValues(event));
    this.compute(event);
    this.computeInitial();
    this.emit();
  }
  moveChange(event) {
    if (!this.state._active) return;
    const values = pointerValues(event);
    const state = this.state;
    state._delta = V.sub(values, state._values);
    V.addTo(state._movement, state._delta);
    this.computeValues(values);
    this.compute(event);
    this.emit();
  }
  moveEnd(event) {
    if (!this.state._active) return;
    this.state._active = false;
    this.compute(event);
    this.emit();
  }
  bind(bindFunction) {
    bindFunction("pointer", "change", this.move.bind(this));
    bindFunction("pointer", "leave", this.moveEnd.bind(this));
  }
};
var moveConfigResolver = _objectSpread2(_objectSpread2({}, coordinatesConfigResolver), {}, {
  mouseOnly: (value = true) => value
});
var ScrollEngine = class extends CoordinatesEngine {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "ingKey", "scrolling");
  }
  scroll(event) {
    if (!this.state._active) this.start(event);
    this.scrollChange(event);
    this.timeoutStore.add("scrollEnd", this.scrollEnd.bind(this));
  }
  scrollChange(event) {
    if (event.cancelable) event.preventDefault();
    const state = this.state;
    const values = scrollValues(event);
    state._delta = V.sub(values, state._values);
    V.addTo(state._movement, state._delta);
    this.computeValues(values);
    this.compute(event);
    this.emit();
  }
  scrollEnd() {
    if (!this.state._active) return;
    this.state._active = false;
    this.compute();
    this.emit();
  }
  bind(bindFunction) {
    bindFunction("scroll", "", this.scroll.bind(this));
  }
};
var scrollConfigResolver = coordinatesConfigResolver;
var WheelEngine = class extends CoordinatesEngine {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "ingKey", "wheeling");
  }
  wheel(event) {
    if (!this.state._active) this.start(event);
    this.wheelChange(event);
    this.timeoutStore.add("wheelEnd", this.wheelEnd.bind(this));
  }
  wheelChange(event) {
    const state = this.state;
    state._delta = wheelValues(event);
    V.addTo(state._movement, state._delta);
    clampStateInternalMovementToBounds(state);
    this.compute(event);
    this.emit();
  }
  wheelEnd() {
    if (!this.state._active) return;
    this.state._active = false;
    this.compute();
    this.emit();
  }
  bind(bindFunction) {
    bindFunction("wheel", "", this.wheel.bind(this));
  }
};
var wheelConfigResolver = coordinatesConfigResolver;
var HoverEngine = class extends CoordinatesEngine {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "ingKey", "hovering");
  }
  enter(event) {
    if (this.config.mouseOnly && event.pointerType !== "mouse") return;
    this.start(event);
    this.computeValues(pointerValues(event));
    this.compute(event);
    this.emit();
  }
  leave(event) {
    if (this.config.mouseOnly && event.pointerType !== "mouse") return;
    const state = this.state;
    if (!state._active) return;
    state._active = false;
    const values = pointerValues(event);
    state._movement = state._delta = V.sub(values, state._values);
    this.computeValues(values);
    this.compute(event);
    state.delta = state.movement;
    this.emit();
  }
  bind(bindFunction) {
    bindFunction("pointer", "enter", this.enter.bind(this));
    bindFunction("pointer", "leave", this.leave.bind(this));
  }
};
var hoverConfigResolver = _objectSpread2(_objectSpread2({}, coordinatesConfigResolver), {}, {
  mouseOnly: (value = true) => value
});
var EngineMap = /* @__PURE__ */ new Map();
var ConfigResolverMap = /* @__PURE__ */ new Map();
function registerAction(action) {
  EngineMap.set(action.key, action.engine);
  ConfigResolverMap.set(action.key, action.resolver);
}
var dragAction = {
  key: "drag",
  engine: DragEngine,
  resolver: dragConfigResolver
};
var hoverAction = {
  key: "hover",
  engine: HoverEngine,
  resolver: hoverConfigResolver
};
var moveAction = {
  key: "move",
  engine: MoveEngine,
  resolver: moveConfigResolver
};
var pinchAction = {
  key: "pinch",
  engine: PinchEngine,
  resolver: pinchConfigResolver
};
var scrollAction = {
  key: "scroll",
  engine: ScrollEngine,
  resolver: scrollConfigResolver
};
var wheelAction = {
  key: "wheel",
  engine: WheelEngine,
  resolver: wheelConfigResolver
};

// node_modules/@use-gesture/react/dist/use-gesture-react.esm.js
var import_react2 = __toESM(require_react());

// node_modules/@use-gesture/core/dist/use-gesture-core.esm.js
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target2 = {};
  var sourceKeys = Object.keys(source);
  var key, i4;
  for (i4 = 0; i4 < sourceKeys.length; i4++) {
    key = sourceKeys[i4];
    if (excluded.indexOf(key) >= 0) continue;
    target2[key] = source[key];
  }
  return target2;
}
function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};
  var target2 = _objectWithoutPropertiesLoose(source, excluded);
  var key, i4;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i4 = 0; i4 < sourceSymbolKeys.length; i4++) {
      key = sourceSymbolKeys[i4];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target2[key] = source[key];
    }
  }
  return target2;
}
var sharedConfigResolver = {
  target(value) {
    if (value) {
      return () => "current" in value ? value.current : value;
    }
    return void 0;
  },
  enabled(value = true) {
    return value;
  },
  window(value = SUPPORT.isBrowser ? window : void 0) {
    return value;
  },
  eventOptions({
    passive = true,
    capture = false
  } = {}) {
    return {
      passive,
      capture
    };
  },
  transform(value) {
    return value;
  }
};
var _excluded = ["target", "eventOptions", "window", "enabled", "transform"];
function resolveWith(config = {}, resolvers) {
  const result = {};
  for (const [key, resolver] of Object.entries(resolvers)) {
    switch (typeof resolver) {
      case "function":
        if (true) {
          const r2 = resolver.call(result, config[key], key, config);
          if (!Number.isNaN(r2)) result[key] = r2;
        } else {
          result[key] = resolver.call(result, config[key], key, config);
        }
        break;
      case "object":
        result[key] = resolveWith(config[key], resolver);
        break;
      case "boolean":
        if (resolver) result[key] = config[key];
        break;
    }
  }
  return result;
}
function parse(newConfig, gestureKey, _config = {}) {
  const _ref = newConfig, {
    target: target2,
    eventOptions,
    window: window2,
    enabled,
    transform
  } = _ref, rest = _objectWithoutProperties(_ref, _excluded);
  _config.shared = resolveWith({
    target: target2,
    eventOptions,
    window: window2,
    enabled,
    transform
  }, sharedConfigResolver);
  if (gestureKey) {
    const resolver = ConfigResolverMap.get(gestureKey);
    _config[gestureKey] = resolveWith(_objectSpread2({
      shared: _config.shared
    }, rest), resolver);
  } else {
    for (const key in rest) {
      const resolver = ConfigResolverMap.get(key);
      if (resolver) {
        _config[key] = resolveWith(_objectSpread2({
          shared: _config.shared
        }, rest[key]), resolver);
      } else if (true) {
        if (!["drag", "pinch", "scroll", "wheel", "move", "hover"].includes(key)) {
          if (key === "domTarget") {
            throw Error(`[@use-gesture]: \`domTarget\` option has been renamed to \`target\`.`);
          }
          console.warn(`[@use-gesture]: Unknown config key \`${key}\` was used. Please read the documentation for further information.`);
        }
      }
    }
  }
  return _config;
}
var EventStore = class {
  constructor(ctrl, gestureKey) {
    _defineProperty(this, "_listeners", /* @__PURE__ */ new Set());
    this._ctrl = ctrl;
    this._gestureKey = gestureKey;
  }
  add(element, device, action, handler, options) {
    const listeners = this._listeners;
    const type = toDomEventType(device, action);
    const _options = this._gestureKey ? this._ctrl.config[this._gestureKey].eventOptions : {};
    const eventOptions = _objectSpread2(_objectSpread2({}, _options), options);
    element.addEventListener(type, handler, eventOptions);
    const remove = () => {
      element.removeEventListener(type, handler, eventOptions);
      listeners.delete(remove);
    };
    listeners.add(remove);
    return remove;
  }
  clean() {
    this._listeners.forEach((remove) => remove());
    this._listeners.clear();
  }
};
var TimeoutStore = class {
  constructor() {
    _defineProperty(this, "_timeouts", /* @__PURE__ */ new Map());
  }
  add(key, callback, ms = 140, ...args) {
    this.remove(key);
    this._timeouts.set(key, window.setTimeout(callback, ms, ...args));
  }
  remove(key) {
    const timeout = this._timeouts.get(key);
    if (timeout) window.clearTimeout(timeout);
  }
  clean() {
    this._timeouts.forEach((timeout) => void window.clearTimeout(timeout));
    this._timeouts.clear();
  }
};
var Controller = class {
  constructor(handlers) {
    _defineProperty(this, "gestures", /* @__PURE__ */ new Set());
    _defineProperty(this, "_targetEventStore", new EventStore(this));
    _defineProperty(this, "gestureEventStores", {});
    _defineProperty(this, "gestureTimeoutStores", {});
    _defineProperty(this, "handlers", {});
    _defineProperty(this, "config", {});
    _defineProperty(this, "pointerIds", /* @__PURE__ */ new Set());
    _defineProperty(this, "touchIds", /* @__PURE__ */ new Set());
    _defineProperty(this, "state", {
      shared: {
        shiftKey: false,
        metaKey: false,
        ctrlKey: false,
        altKey: false
      }
    });
    resolveGestures(this, handlers);
  }
  setEventIds(event) {
    if (isTouch(event)) {
      this.touchIds = new Set(touchIds(event));
      return this.touchIds;
    } else if ("pointerId" in event) {
      if (event.type === "pointerup" || event.type === "pointercancel") this.pointerIds.delete(event.pointerId);
      else if (event.type === "pointerdown") this.pointerIds.add(event.pointerId);
      return this.pointerIds;
    }
  }
  applyHandlers(handlers, nativeHandlers) {
    this.handlers = handlers;
    this.nativeHandlers = nativeHandlers;
  }
  applyConfig(config, gestureKey) {
    this.config = parse(config, gestureKey, this.config);
  }
  clean() {
    this._targetEventStore.clean();
    for (const key of this.gestures) {
      this.gestureEventStores[key].clean();
      this.gestureTimeoutStores[key].clean();
    }
  }
  effect() {
    if (this.config.shared.target) this.bind();
    return () => this._targetEventStore.clean();
  }
  bind(...args) {
    const sharedConfig = this.config.shared;
    const props = {};
    let target2;
    if (sharedConfig.target) {
      target2 = sharedConfig.target();
      if (!target2) return;
    }
    if (sharedConfig.enabled) {
      for (const gestureKey of this.gestures) {
        const gestureConfig = this.config[gestureKey];
        const bindFunction = bindToProps(props, gestureConfig.eventOptions, !!target2);
        if (gestureConfig.enabled) {
          const Engine2 = EngineMap.get(gestureKey);
          new Engine2(this, args, gestureKey).bind(bindFunction);
        }
      }
      const nativeBindFunction = bindToProps(props, sharedConfig.eventOptions, !!target2);
      for (const eventKey in this.nativeHandlers) {
        nativeBindFunction(eventKey, "", (event) => this.nativeHandlers[eventKey](_objectSpread2(_objectSpread2({}, this.state.shared), {}, {
          event,
          args
        })), void 0, true);
      }
    }
    for (const handlerProp in props) {
      props[handlerProp] = chain(...props[handlerProp]);
    }
    if (!target2) return props;
    for (const handlerProp in props) {
      const {
        device,
        capture,
        passive
      } = parseProp(handlerProp);
      this._targetEventStore.add(target2, device, "", props[handlerProp], {
        capture,
        passive
      });
    }
  }
};
function setupGesture(ctrl, gestureKey) {
  ctrl.gestures.add(gestureKey);
  ctrl.gestureEventStores[gestureKey] = new EventStore(ctrl, gestureKey);
  ctrl.gestureTimeoutStores[gestureKey] = new TimeoutStore();
}
function resolveGestures(ctrl, internalHandlers) {
  if (internalHandlers.drag) setupGesture(ctrl, "drag");
  if (internalHandlers.wheel) setupGesture(ctrl, "wheel");
  if (internalHandlers.scroll) setupGesture(ctrl, "scroll");
  if (internalHandlers.move) setupGesture(ctrl, "move");
  if (internalHandlers.pinch) setupGesture(ctrl, "pinch");
  if (internalHandlers.hover) setupGesture(ctrl, "hover");
}
var bindToProps = (props, eventOptions, withPassiveOption) => (device, action, handler, options = {}, isNative = false) => {
  var _options$capture, _options$passive;
  const capture = (_options$capture = options.capture) !== null && _options$capture !== void 0 ? _options$capture : eventOptions.capture;
  const passive = (_options$passive = options.passive) !== null && _options$passive !== void 0 ? _options$passive : eventOptions.passive;
  let handlerProp = isNative ? device : toHandlerProp(device, action, capture);
  if (withPassiveOption && passive) handlerProp += "Passive";
  props[handlerProp] = props[handlerProp] || [];
  props[handlerProp].push(handler);
};
var RE_NOT_NATIVE = /^on(Drag|Wheel|Scroll|Move|Pinch|Hover)/;
function sortHandlers(_handlers) {
  const native = {};
  const handlers = {};
  const actions = /* @__PURE__ */ new Set();
  for (let key in _handlers) {
    if (RE_NOT_NATIVE.test(key)) {
      actions.add(RegExp.lastMatch);
      handlers[key] = _handlers[key];
    } else {
      native[key] = _handlers[key];
    }
  }
  return [handlers, native, actions];
}
function registerGesture(actions, handlers, handlerKey, key, internalHandlers, config) {
  if (!actions.has(handlerKey)) return;
  if (!EngineMap.has(key)) {
    if (true) {
      console.warn(`[@use-gesture]: You've created a custom handler that that uses the \`${key}\` gesture but isn't properly configured.

Please add \`${key}Action\` when creating your handler.`);
    }
    return;
  }
  const startKey = handlerKey + "Start";
  const endKey = handlerKey + "End";
  const fn = (state) => {
    let memo = void 0;
    if (state.first && startKey in handlers) handlers[startKey](state);
    if (handlerKey in handlers) memo = handlers[handlerKey](state);
    if (state.last && endKey in handlers) handlers[endKey](state);
    return memo;
  };
  internalHandlers[key] = fn;
  config[key] = config[key] || {};
}
function parseMergedHandlers(mergedHandlers, mergedConfig) {
  const [handlers, nativeHandlers, actions] = sortHandlers(mergedHandlers);
  const internalHandlers = {};
  registerGesture(actions, handlers, "onDrag", "drag", internalHandlers, mergedConfig);
  registerGesture(actions, handlers, "onWheel", "wheel", internalHandlers, mergedConfig);
  registerGesture(actions, handlers, "onScroll", "scroll", internalHandlers, mergedConfig);
  registerGesture(actions, handlers, "onPinch", "pinch", internalHandlers, mergedConfig);
  registerGesture(actions, handlers, "onMove", "move", internalHandlers, mergedConfig);
  registerGesture(actions, handlers, "onHover", "hover", internalHandlers, mergedConfig);
  return {
    handlers: internalHandlers,
    config: mergedConfig,
    nativeHandlers
  };
}

// node_modules/@use-gesture/react/dist/use-gesture-react.esm.js
function useRecognizers(handlers, config = {}, gestureKey, nativeHandlers) {
  const ctrl = import_react2.default.useMemo(() => new Controller(handlers), []);
  ctrl.applyHandlers(handlers, nativeHandlers);
  ctrl.applyConfig(config, gestureKey);
  import_react2.default.useEffect(ctrl.effect.bind(ctrl));
  import_react2.default.useEffect(() => {
    return ctrl.clean.bind(ctrl);
  }, []);
  if (config.target === void 0) {
    return ctrl.bind.bind(ctrl);
  }
  return void 0;
}
function createUseGesture(actions) {
  actions.forEach(registerAction);
  return function useGesture2(_handlers, _config) {
    const {
      handlers,
      nativeHandlers,
      config
    } = parseMergedHandlers(_handlers, _config || {});
    return useRecognizers(handlers, config, void 0, nativeHandlers);
  };
}
function useGesture(handlers, config) {
  const hook = createUseGesture([dragAction, pinchAction, scrollAction, wheelAction, moveAction, hoverAction]);
  return hook(handlers, config || {});
}

// node_modules/@react-three/drei/web/DragControls.js
var initialModelPosition = new Vector3();
var mousePosition2D = new Vector2();
var mousePosition3D = new Vector3();
var dragOffset = new Vector3();
var dragPlaneNormal = new Vector3();
var dragPlane = new Plane();
var DragControls = React8.forwardRef(({
  autoTransform = true,
  matrix: matrix6,
  axisLock,
  dragLimits,
  onHover,
  onDragStart,
  onDrag,
  onDragEnd,
  children,
  dragConfig,
  ...props
}, fRef) => {
  const defaultControls = useThree((state) => state.controls);
  const {
    camera,
    size: size2,
    raycaster,
    invalidate
  } = useThree();
  const ref = React8.useRef(null);
  const bind = useGesture({
    onHover: ({
      hovering
    }) => onHover && onHover(hovering !== null && hovering !== void 0 ? hovering : false),
    onDragStart: ({
      event
    }) => {
      if (defaultControls) defaultControls.enabled = false;
      const {
        point
      } = event;
      ref.current.matrix.decompose(initialModelPosition, new Quaternion(), new Vector3());
      mousePosition3D.copy(point);
      dragOffset.copy(mousePosition3D).sub(initialModelPosition);
      onDragStart && onDragStart(initialModelPosition);
      invalidate();
    },
    onDrag: ({
      xy: [dragX, dragY],
      intentional
    }) => {
      if (!intentional) return;
      const normalizedMouseX = (dragX - size2.left) / size2.width * 2 - 1;
      const normalizedMouseY = -((dragY - size2.top) / size2.height) * 2 + 1;
      mousePosition2D.set(normalizedMouseX, normalizedMouseY);
      raycaster.setFromCamera(mousePosition2D, camera);
      if (!axisLock) {
        camera.getWorldDirection(dragPlaneNormal).negate();
      } else {
        switch (axisLock) {
          case "x":
            dragPlaneNormal.set(1, 0, 0);
            break;
          case "y":
            dragPlaneNormal.set(0, 1, 0);
            break;
          case "z":
            dragPlaneNormal.set(0, 0, 1);
            break;
        }
      }
      dragPlane.setFromNormalAndCoplanarPoint(dragPlaneNormal, mousePosition3D);
      raycaster.ray.intersectPlane(dragPlane, mousePosition3D);
      const previousLocalMatrix = ref.current.matrix.clone();
      const previousWorldMatrix = ref.current.matrixWorld.clone();
      const intendedNewPosition = new Vector3(mousePosition3D.x - dragOffset.x, mousePosition3D.y - dragOffset.y, mousePosition3D.z - dragOffset.z);
      if (dragLimits) {
        intendedNewPosition.x = dragLimits[0] ? Math.max(Math.min(intendedNewPosition.x, dragLimits[0][1]), dragLimits[0][0]) : intendedNewPosition.x;
        intendedNewPosition.y = dragLimits[1] ? Math.max(Math.min(intendedNewPosition.y, dragLimits[1][1]), dragLimits[1][0]) : intendedNewPosition.y;
        intendedNewPosition.z = dragLimits[2] ? Math.max(Math.min(intendedNewPosition.z, dragLimits[2][1]), dragLimits[2][0]) : intendedNewPosition.z;
      }
      if (autoTransform) {
        ref.current.matrix.setPosition(intendedNewPosition);
        const deltaLocalMatrix = ref.current.matrix.clone().multiply(previousLocalMatrix.invert());
        const deltaWorldMatrix = ref.current.matrix.clone().multiply(previousWorldMatrix.invert());
        onDrag && onDrag(ref.current.matrix, deltaLocalMatrix, ref.current.matrixWorld, deltaWorldMatrix);
      } else {
        const tempMatrix4 = new Matrix4().copy(ref.current.matrix);
        tempMatrix4.setPosition(intendedNewPosition);
        const deltaLocalMatrix = tempMatrix4.clone().multiply(previousLocalMatrix.invert());
        const deltaWorldMatrix = tempMatrix4.clone().multiply(previousWorldMatrix.invert());
        onDrag && onDrag(tempMatrix4, deltaLocalMatrix, ref.current.matrixWorld, deltaWorldMatrix);
      }
      invalidate();
    },
    onDragEnd: () => {
      if (defaultControls) defaultControls.enabled = true;
      onDragEnd && onDragEnd();
      invalidate();
    }
  }, {
    drag: {
      filterTaps: true,
      threshold: 1,
      ...typeof dragConfig === "object" ? dragConfig : {}
    }
  });
  React8.useImperativeHandle(fRef, () => ref.current, []);
  React8.useLayoutEffect(() => {
    if (!matrix6) return;
    ref.current.matrix = matrix6;
  }, [matrix6]);
  return React8.createElement("group", _extends({
    ref
  }, bind(), {
    matrix: matrix6,
    matrixAutoUpdate: false
  }, props), children);
});

// node_modules/@react-three/drei/web/ScrollControls.js
var React9 = __toESM(require_react());
var ReactDOM2 = __toESM(require_client());

// node_modules/maath/dist/objectSpread2-284232a6.esm.js
function _defineProperty2(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function ownKeys2(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    if (enumerableOnly) {
      symbols = symbols.filter(function(sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
    }
    keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread22(target2) {
  for (var i4 = 1; i4 < arguments.length; i4++) {
    var source = arguments[i4] != null ? arguments[i4] : {};
    if (i4 % 2) {
      ownKeys2(Object(source), true).forEach(function(key) {
        _defineProperty2(target2, key, source[key]);
      });
    } else if (Object.getOwnPropertyDescriptors) {
      Object.defineProperties(target2, Object.getOwnPropertyDescriptors(source));
    } else {
      ownKeys2(Object(source)).forEach(function(key) {
        Object.defineProperty(target2, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }
  }
  return target2;
}

// node_modules/maath/dist/isNativeReflectConstruct-5594d075.esm.js
function _setPrototypeOf(o2, p2) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf2(o3, p3) {
    o3.__proto__ = p3;
    return o3;
  };
  return _setPrototypeOf(o2, p2);
}
function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === "function") return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e2) {
    return false;
  }
}

// node_modules/maath/dist/matrix-baa530bf.esm.js
function determinant2() {
  for (var _len = arguments.length, terms = new Array(_len), _key = 0; _key < _len; _key++) {
    terms[_key] = arguments[_key];
  }
  var a6 = terms[0], b5 = terms[1], c2 = terms[2], d2 = terms[3];
  return a6 * d2 - b5 * c2;
}
function determinant3() {
  for (var _len2 = arguments.length, terms = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
    terms[_key2] = arguments[_key2];
  }
  var a6 = terms[0], b5 = terms[1], c2 = terms[2], d2 = terms[3], e2 = terms[4], f2 = terms[5], g = terms[6], h = terms[7], i4 = terms[8];
  return a6 * e2 * i4 + b5 * f2 * g + c2 * d2 * h - c2 * e2 * g - b5 * d2 * i4 - a6 * f2 * h;
}
function determinant4() {
  for (var _len3 = arguments.length, terms = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
    terms[_key3] = arguments[_key3];
  }
  terms[0];
  terms[1];
  terms[2];
  terms[3];
  terms[4];
  terms[5];
  terms[6];
  terms[7];
  terms[8];
  terms[9];
  terms[10];
  terms[11];
  terms[12];
  terms[13];
  terms[14];
}
function getMinor(matrix6, r2, c2) {
  var _matrixTranspose = matrix6.clone().transpose();
  var x = [];
  var l2 = _matrixTranspose.elements.length;
  var n2 = Math.sqrt(l2);
  for (var i4 = 0; i4 < l2; i4++) {
    var element = _matrixTranspose.elements[i4];
    var row = Math.floor(i4 / n2);
    var col3 = i4 % n2;
    if (row !== r2 - 1 && col3 !== c2 - 1) {
      x.push(element);
    }
  }
  return determinant3.apply(void 0, x);
}
function matrixSum3(m1, m2) {
  var sum = [];
  var m1Array = m1.toArray();
  var m2Array = m2.toArray();
  for (var i4 = 0; i4 < m1Array.length; i4++) {
    sum[i4] = m1Array[i4] + m2Array[i4];
  }
  return new Matrix3().fromArray(sum);
}
var matrix = Object.freeze({
  __proto__: null,
  determinant2,
  determinant3,
  determinant4,
  getMinor,
  matrixSum3
});

// node_modules/maath/dist/triangle-b62b9067.esm.js
function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}
function _iterableToArrayLimit(arr, i4) {
  var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];
  if (_i == null) return;
  var _arr = [];
  var _n = true;
  var _d = false;
  var _s, _e;
  try {
    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);
      if (i4 && _arr.length === i4) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }
  return _arr;
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i4 = 0, arr2 = new Array(len); i4 < len; i4++) arr2[i4] = arr[i4];
  return arr2;
}
function _unsupportedIterableToArray(o2, minLen) {
  if (!o2) return;
  if (typeof o2 === "string") return _arrayLikeToArray(o2, minLen);
  var n2 = Object.prototype.toString.call(o2).slice(8, -1);
  if (n2 === "Object" && o2.constructor) n2 = o2.constructor.name;
  if (n2 === "Map" || n2 === "Set") return Array.from(o2);
  if (n2 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n2)) return _arrayLikeToArray(o2, minLen);
}
function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _slicedToArray(arr, i4) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i4) || _unsupportedIterableToArray(arr, i4) || _nonIterableRest();
}
function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray(arr);
}
function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}
function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
}
function _construct(Parent, args, Class) {
  if (_isNativeReflectConstruct()) {
    _construct = Reflect.construct;
  } else {
    _construct = function _construct2(Parent2, args2, Class2) {
      var a6 = [null];
      a6.push.apply(a6, args2);
      var Constructor = Function.bind.apply(Parent2, a6);
      var instance2 = new Constructor();
      if (Class2) _setPrototypeOf(instance2, Class2.prototype);
      return instance2;
    };
  }
  return _construct.apply(null, arguments);
}
function isPointInTriangle(point, triangle4) {
  var _triangle$ = _slicedToArray(triangle4[0], 2), ax = _triangle$[0], ay = _triangle$[1];
  var _triangle$2 = _slicedToArray(triangle4[1], 2), bx = _triangle$2[0], by = _triangle$2[1];
  var _triangle$3 = _slicedToArray(triangle4[2], 2), cx = _triangle$3[0], cy = _triangle$3[1];
  var _point = _slicedToArray(point, 2), px = _point[0], py = _point[1];
  var matrix6 = new Matrix4();
  matrix6.set(ax, ay, ax * ax + ay * ay, 1, bx, by, bx * bx + by * by, 1, cx, cy, cx * cx + cy * cy, 1, px, py, px * px + py * py, 1);
  return matrix6.determinant() <= 0;
}
function triangleDeterminant(triangle4) {
  var _triangle$4 = _slicedToArray(triangle4[0], 2), x1 = _triangle$4[0], y1 = _triangle$4[1];
  var _triangle$5 = _slicedToArray(triangle4[1], 2), x2 = _triangle$5[0], y2 = _triangle$5[1];
  var _triangle$6 = _slicedToArray(triangle4[2], 2), x3 = _triangle$6[0], y3 = _triangle$6[1];
  return determinant3(x1, y1, 1, x2, y2, 1, x3, y3, 1);
}
function arePointsCollinear(points) {
  return triangleDeterminant(points) === 0;
}
function isTriangleClockwise(triangle4) {
  return triangleDeterminant(triangle4) < 0;
}
function getCircumcircle(triangle4) {
  var _triangle$7 = _slicedToArray(triangle4[0], 2), ax = _triangle$7[0], ay = _triangle$7[1];
  var _triangle$8 = _slicedToArray(triangle4[1], 2), bx = _triangle$8[0], by = _triangle$8[1];
  var _triangle$9 = _slicedToArray(triangle4[2], 2), cx = _triangle$9[0], cy = _triangle$9[1];
  if (arePointsCollinear(triangle4)) return null;
  var m = new Matrix4();
  m.set(1, 1, 1, 1, ax * ax + ay * ay, ax, ay, 1, bx * bx + by * by, bx, by, 1, cx * cx + cy * cy, cx, cy, 1);
  var m11 = getMinor(m, 1, 1);
  var m13 = getMinor(m, 1, 3);
  var m12 = getMinor(m, 1, 2);
  var m14 = getMinor(m, 1, 4);
  var x0 = 0.5 * (m12 / m11);
  var y0 = 0.5 * (m13 / m11);
  var r2 = x0 * x0 + y0 * y0 + m14 / m11;
  return {
    x: Math.abs(x0) === 0 ? 0 : x0,
    y: Math.abs(y0) === 0 ? 0 : -y0,
    r: Math.sqrt(r2)
  };
}
function isPointInCircumcircle(point, triangle4) {
  var _ref = Array.isArray(triangle4[0]) ? triangle4[0] : triangle4[0].toArray(), _ref2 = _slicedToArray(_ref, 2), ax = _ref2[0], ay = _ref2[1];
  var _ref3 = Array.isArray(triangle4[1]) ? triangle4[1] : triangle4[1].toArray(), _ref4 = _slicedToArray(_ref3, 2), bx = _ref4[0], by = _ref4[1];
  var _ref5 = Array.isArray(triangle4[2]) ? triangle4[2] : triangle4[2].toArray(), _ref6 = _slicedToArray(_ref5, 2), cx = _ref6[0], cy = _ref6[1];
  var _point2 = _slicedToArray(point, 2), px = _point2[0], py = _point2[1];
  if (arePointsCollinear(triangle4)) throw new Error("Collinear points don't form a triangle");
  var x1mpx = ax - px;
  var aympy = ay - py;
  var bxmpx = bx - px;
  var bympy = by - py;
  var cxmpx = cx - px;
  var cympy = cy - py;
  var d2 = determinant3(x1mpx, aympy, x1mpx * x1mpx + aympy * aympy, bxmpx, bympy, bxmpx * bxmpx + bympy * bympy, cxmpx, cympy, cxmpx * cxmpx + cympy * cympy);
  if (d2 === 0) {
    return true;
  }
  return !isTriangleClockwise(triangle4) ? d2 > 0 : d2 < 0;
}
var mv1 = new Vector2();
var mv2 = new Vector2();
function doThreePointsMakeARight(points) {
  var _points$map = points.map(function(p4) {
    if (Array.isArray(p4)) {
      return _construct(Vector2, _toConsumableArray(p4));
    }
    return p4;
  }), _points$map2 = _slicedToArray(_points$map, 3), p1 = _points$map2[0], p2 = _points$map2[1], p3 = _points$map2[2];
  if (arePointsCollinear(points)) return false;
  var p2p1 = mv1.subVectors(p2, p1);
  var p3p1 = mv2.subVectors(p3, p1);
  var cross2 = p3p1.cross(p2p1);
  return cross2 > 0;
}
var triangle = Object.freeze({
  __proto__: null,
  isPointInTriangle,
  triangleDeterminant,
  arePointsCollinear,
  isTriangleClockwise,
  getCircumcircle,
  isPointInCircumcircle,
  doThreePointsMakeARight
});

// node_modules/maath/dist/misc-19a3ec46.esm.js
function clamp2(value, min, max2) {
  return Math.max(min, Math.min(max2, value));
}
function repeat(t3, length3) {
  return clamp2(t3 - Math.floor(t3 / length3) * length3, 0, length3);
}
function deltaAngle(current, target2) {
  var delta = repeat(target2 - current, Math.PI * 2);
  if (delta > Math.PI) delta -= Math.PI * 2;
  return delta;
}
function degToRad(degrees) {
  return degrees / 180 * Math.PI;
}
function radToDeg(radians) {
  return radians * 180 / Math.PI;
}
function fibonacciOnSphere(buffer2, _ref) {
  var _ref$radius = _ref.radius, radius = _ref$radius === void 0 ? 1 : _ref$radius;
  var samples = buffer2.length / 3;
  var offset = 2 / samples;
  var increment = Math.PI * (3 - 2.2360679775);
  for (var i4 = 0; i4 < buffer2.length; i4 += 3) {
    var y = i4 * offset - 1 + offset / 2;
    var distance3 = Math.sqrt(1 - Math.pow(y, 2));
    var phi = i4 % samples * increment;
    var x = Math.cos(phi) * distance3;
    var z = Math.sin(phi) * distance3;
    buffer2[i4] = x * radius;
    buffer2[i4 + 1] = y * radius;
    buffer2[i4 + 2] = z * radius;
  }
}
function vectorEquals(a6, b5) {
  var eps2 = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : Number.EPSILON;
  return Math.abs(a6.x - b5.x) < eps2 && Math.abs(a6.y - b5.y) < eps2 && Math.abs(a6.z - b5.z) < eps2;
}
function lexicographic(a6, b5) {
  if (a6.x === b5.x) {
    if (typeof a6.z !== "undefined") {
      if (a6.y === b5.y) {
        return a6.z - b5.z;
      }
    }
    return a6.y - b5.y;
  }
  return a6.x - b5.x;
}
function convexHull(_points) {
  var points = _points.sort(lexicographic);
  var lUpper = [points[0], points[1]];
  for (var i4 = 2; i4 < points.length; i4++) {
    lUpper.push(points[i4]);
    while (lUpper.length > 2 && doThreePointsMakeARight(_toConsumableArray(lUpper.slice(-3)))) {
      lUpper.splice(lUpper.length - 2, 1);
    }
  }
  var lLower = [points[points.length - 1], points[points.length - 2]];
  for (var _i = points.length - 3; _i >= 0; _i--) {
    lLower.push(points[_i]);
    while (lLower.length > 2 && doThreePointsMakeARight(_toConsumableArray(lLower.slice(-3)))) {
      lLower.splice(lLower.length - 2, 1);
    }
  }
  lLower.splice(0, 1);
  lLower.splice(lLower.length - 1, 1);
  var c2 = [].concat(lUpper, lLower);
  return c2;
}
function remap(x, _ref2, _ref3) {
  var _ref4 = _slicedToArray(_ref2, 2), low1 = _ref4[0], high1 = _ref4[1];
  var _ref5 = _slicedToArray(_ref3, 2), low2 = _ref5[0], high2 = _ref5[1];
  return low2 + (x - low1) * (high2 - low2) / (high1 - low1);
}
function fade(t3) {
  return t3 * t3 * t3 * (t3 * (t3 * 6 - 15) + 10);
}
function lerp(v0, v13, t3) {
  return v0 * (1 - t3) + v13 * t3;
}
function inverseLerp(v0, v13, t3) {
  return (t3 - v0) / (v13 - v0);
}
function normalize(x, y, z) {
  var m = Math.sqrt(x * x + y * y + z * z);
  return [x / m, y / m, z / m];
}
function pointOnCubeToPointOnSphere(x, y, z) {
  var x2 = x * x;
  var y2 = y * y;
  var z2 = z * z;
  var nx = x * Math.sqrt(1 - (y2 + z2) / 2 + y2 * z2 / 3);
  var ny = y * Math.sqrt(1 - (z2 + x2) / 2 + z2 * x2 / 3);
  var nz = z * Math.sqrt(1 - (x2 + y2) / 2 + x2 * y2 / 3);
  return [nx, ny, nz];
}
function rotateVectorOnVector(a6, b5) {
  var v5 = new Vector3().crossVectors(a6, b5);
  var c2 = a6.dot(b5);
  var i4 = new Matrix3().identity();
  var vx = new Matrix3().set(0, -v5.z, v5.y, v5.z, 0, -v5.x, -v5.y, v5.x, 0);
  var vxsquared = new Matrix3().multiplyMatrices(vx, vx).multiplyScalar(1 / (1 + c2));
  var _final = matrixSum3(matrixSum3(i4, vx), vxsquared);
  return _final;
}
function pointToCoordinate(x, y, z) {
  var lat = Math.asin(y);
  var lon = Math.atan2(x, -z);
  return [lat, lon];
}
function coordinateToPoint(lat, lon) {
  var y = Math.sin(lat);
  var r2 = Math.cos(lat);
  var x = Math.sin(lon) * r2;
  var z = -Math.cos(lon) * r2;
  return [x, y, z];
}
function planeSegmentIntersection(plane, segment) {
  var _segment = _slicedToArray(segment, 2), a6 = _segment[0], b5 = _segment[1];
  var matrix6 = rotateVectorOnVector(plane.normal, new Vector3(0, 1, 0));
  var t3 = inverseLerp(a6.clone().applyMatrix3(matrix6).y, b5.clone().applyMatrix3(matrix6).y, 0);
  return new Vector3().lerpVectors(a6, b5, t3);
}
function pointToPlaneDistance(p2, plane) {
  var d2 = plane.normal.dot(p2);
  return d2;
}
function getIndexFrom3D(coords, sides) {
  var _coords = _slicedToArray(coords, 3), ix = _coords[0], iy = _coords[1], iz = _coords[2];
  var _sides = _slicedToArray(sides, 2), rx = _sides[0], ry = _sides[1];
  return iz * rx * ry + iy * rx + ix;
}
function get3DFromIndex(index2, size2) {
  var _size = _slicedToArray(size2, 2), rx = _size[0], ry = _size[1];
  var a6 = rx * ry;
  var z = index2 / a6;
  var b5 = index2 - a6 * z;
  var y = b5 / rx;
  var x = b5 % rx;
  return [x, y, z];
}
function getIndexFrom2D(coords, size2) {
  return coords[0] + size2[0] * coords[1];
}
function get2DFromIndex(index2, columns) {
  var x = index2 % columns;
  var y = Math.floor(index2 / columns);
  return [x, y];
}
var misc = Object.freeze({
  __proto__: null,
  clamp: clamp2,
  repeat,
  deltaAngle,
  degToRad,
  radToDeg,
  fibonacciOnSphere,
  vectorEquals,
  lexicographic,
  convexHull,
  remap,
  fade,
  lerp,
  inverseLerp,
  normalize,
  pointOnCubeToPointOnSphere,
  rotateVectorOnVector,
  pointToCoordinate,
  coordinateToPoint,
  planeSegmentIntersection,
  pointToPlaneDistance,
  getIndexFrom3D,
  get3DFromIndex,
  getIndexFrom2D,
  get2DFromIndex
});

// node_modules/maath/dist/vector2-d2bf51f1.esm.js
function zero() {
  return [0, 0];
}
function one() {
  return [1, 1];
}
function add(a6, b5) {
  return [a6[0] + b5[0], a6[1] + b5[1]];
}
function addValue(a6, n2) {
  return [a6[0] + n2, a6[1] + n2];
}
function sub(a6, b5) {
  return [a6[0] - b5[0], a6[1] - b5[1]];
}
function subValue(a6, n2) {
  return [a6[0] - n2, a6[1] - n2];
}
function scale(a6, n2) {
  return [a6[0] * n2, a6[1] * n2];
}
function dot(a6, b5) {
  return a6[0] * b5[0] + a6[1] * b5[1];
}
function lengthSqr(a6) {
  return a6[0] * a6[0] + a6[1] * a6[1];
}
function length(a6) {
  return Math.sqrt(a6[0] * a6[0] + a6[1] * a6[1]);
}
function distance(a6, b5) {
  return Math.sqrt((a6[0] - b5[0]) * (a6[0] - b5[0]) + (a6[1] - b5[1]) * (a6[1] - b5[1]));
}
var vector2 = Object.freeze({
  __proto__: null,
  zero,
  one,
  add,
  addValue,
  sub,
  subValue,
  scale,
  dot,
  lengthSqr,
  length,
  distance
});

// node_modules/maath/dist/vector3-0a088b7f.esm.js
function zero2() {
  return [0, 0, 0];
}
function one2() {
  return [1, 1, 1];
}
function add2(a6, b5) {
  return [a6[0] + b5[0], a6[1] + b5[1], a6[2] + b5[2]];
}
function addValue2(a6, n2) {
  return [a6[0] + n2, a6[1] + n2, a6[2] + n2];
}
function sub2(a6, b5) {
  return [a6[0] - b5[0], a6[1] - b5[1], a6[2] - b5[2]];
}
function subValue2(a6, n2) {
  return [a6[0] - n2, a6[1] - n2, a6[2] - n2];
}
function scale2(a6, n2) {
  return [a6[0] * n2, a6[1] * n2, a6[2] * n2];
}
function dot2(a6, b5) {
  return a6[0] * b5[0] + a6[1] * b5[1] + a6[2] * b5[2];
}
function cross(a6, b5) {
  var x = a6[1] * b5[2] - a6[2] * b5[1];
  var y = a6[2] * b5[0] - a6[0] * b5[2];
  var z = a6[0] * b5[1] - a6[1] * b5[0];
  return [x, y, z];
}
function lengthSqr2(a6) {
  return a6[0] * a6[0] + a6[1] * a6[1] + a6[2] * a6[2];
}
function length2(a6) {
  return Math.sqrt(a6[0] * a6[0] + a6[1] * a6[1] + a6[2] * a6[2]);
}
function distance2(a6, b5) {
  return Math.sqrt((a6[0] - b5[0]) * (a6[0] - b5[0]) + (a6[1] - b5[1]) * (a6[1] - b5[1]) + (a6[2] - b5[2]) * (a6[2] - b5[2]));
}
var vector3 = Object.freeze({
  __proto__: null,
  zero: zero2,
  one: one2,
  add: add2,
  addValue: addValue2,
  sub: sub2,
  subValue: subValue2,
  scale: scale2,
  dot: dot2,
  cross,
  lengthSqr: lengthSqr2,
  length: length2,
  distance: distance2
});

// node_modules/maath/dist/buffer-59a95d05.esm.js
function swizzle(buffer2) {
  var stride = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 3;
  var swizzle2 = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : "xyz";
  var o2 = {
    x: 0,
    y: 0,
    z: 0
  };
  for (var _i = 0; _i < buffer2.length; _i += stride) {
    o2.x = buffer2[_i];
    o2.y = buffer2[_i + 1];
    o2.z = buffer2[_i + 2];
    var _swizzle$split = swizzle2.split(""), _swizzle$split2 = _slicedToArray(_swizzle$split, 3), x = _swizzle$split2[0], y = _swizzle$split2[1], z = _swizzle$split2[2];
    buffer2[_i] = o2[x];
    buffer2[_i + 1] = o2[y];
    if (stride === 3) {
      buffer2[_i + 2] = o2[z];
    }
  }
  return buffer2;
}
function addAxis(buffer2, size2) {
  var valueGenerator = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : function() {
    return Math.random();
  };
  var newSize = size2 + 1;
  var newBuffer = new Float32Array(buffer2.length / size2 * newSize);
  for (var _i2 = 0; _i2 < buffer2.length; _i2 += size2) {
    var _j = _i2 / size2 * newSize;
    newBuffer[_j] = buffer2[_i2];
    newBuffer[_j + 1] = buffer2[_i2 + 1];
    if (size2 === 2) {
      newBuffer[_j + 2] = valueGenerator(_j);
    }
    if (size2 === 3) {
      newBuffer[_j + 2] = buffer2[_i2 + 2];
      newBuffer[_j + 3] = valueGenerator(_j);
    }
  }
  return newBuffer;
}
function lerp2(bufferA, bufferB, _final, t3) {
  for (var _i3 = 0; _i3 < bufferA.length; _i3++) {
    _final[_i3] = lerp(bufferA[_i3], bufferB[_i3], t3);
  }
}
function translate(buffer2, translationVector) {
  var stride = translationVector.length;
  for (var _i4 = 0; _i4 < buffer2.length; _i4 += stride) {
    buffer2[_i4] += translationVector[0];
    buffer2[_i4 + 1] += translationVector[1];
    buffer2[_i4 + 2] += translationVector[2];
  }
  return buffer2;
}
function rotate(buffer2, rotation3) {
  var defaultRotation = {
    center: [0, 0, 0],
    q: new Quaternion().identity()
  };
  var v5 = new Vector3();
  var _defaultRotation$rota = _objectSpread22(_objectSpread22({}, defaultRotation), rotation3), q = _defaultRotation$rota.q, center3 = _defaultRotation$rota.center;
  for (var _i5 = 0; _i5 < buffer2.length; _i5 += 3) {
    v5.set(buffer2[_i5] - center3[0], buffer2[_i5 + 1] - center3[1], buffer2[_i5 + 2] - center3[2]);
    v5.applyQuaternion(q);
    buffer2[_i5] = v5.x + center3[0];
    buffer2[_i5 + 1] = v5.y + center3[1];
    buffer2[_i5 + 2] = v5.z + center3[1];
  }
  return buffer2;
}
function map(buffer2, stride, callback) {
  for (var _i6 = 0, _j2 = 0; _i6 < buffer2.length; _i6 += stride, _j2++) {
    if (stride === 3) {
      var res = callback([buffer2[_i6], buffer2[_i6 + 1], buffer2[_i6 + 2]], _j2);
      buffer2.set(res, _i6);
    } else {
      buffer2.set(callback([buffer2[_i6], buffer2[_i6 + 1]], _j2), _i6);
    }
  }
  return buffer2;
}
function reduce(b5, stride, callback, acc) {
  for (var _i7 = 0, _j3 = 0; _i7 < b5.length; _i7 += stride, _j3++) {
    if (stride === 2) {
      acc = callback(acc, [b5[_i7], b5[_i7 + 1]], _j3);
    } else {
      acc = callback(acc, [b5[_i7], b5[_i7 + 1], b5[_i7 + 2]], _j3);
    }
  }
  return acc;
}
function expand(b5, stride, opts) {
  var defaultExpandOptions = {
    center: [0, 0, 0]
  };
  var _defaultExpandOptions = _objectSpread22(_objectSpread22({}, defaultExpandOptions), opts), center3 = _defaultExpandOptions.center, distance3 = _defaultExpandOptions.distance;
  for (var _i8 = 0; _i8 < b5.length; _i8 += stride) {
    b5[_i8] = (b5[_i8] - center3[0]) * (1 + distance3) + center3[0];
    b5[_i8 + 1] = (b5[_i8 + 1] - center3[1]) * (1 + distance3) + center3[1];
    if (stride === 3) {
      b5[_i8 + 2] = (b5[_i8 + 2] - center3[1]) * (1 + distance3) + center3[2];
    }
  }
  return b5;
}
function center(myBuffer, stride) {
  return reduce(myBuffer, stride, function(acc, point) {
    if (stride === 3) {
      acc = add2(acc, point);
    } else {
      acc = add(acc, point);
    }
    return acc;
  }, zero());
}
function sort(myBuffer, stride, callback) {
  var indices = Int16Array.from({
    length: myBuffer.length / stride
  }, function(_, i4) {
    return i4;
  });
  indices.sort(function(a6, b5) {
    var pa = myBuffer.slice(a6 * stride, a6 * stride + stride);
    var pb = myBuffer.slice(b5 * stride, b5 * stride + stride);
    return callback(pa, pb);
  });
  var prevBuffer = myBuffer.slice(0);
  for (var _i9 = 0; _i9 < indices.length; _i9++) {
    var _j4 = indices[_i9];
    myBuffer.set(prevBuffer.slice(_j4 * stride, _j4 * stride + stride), _i9 * 3);
  }
  return myBuffer;
}
var buffer = Object.freeze({
  __proto__: null,
  swizzle,
  addAxis,
  lerp: lerp2,
  translate,
  rotate,
  map,
  reduce,
  expand,
  center,
  sort
});

// node_modules/maath/dist/classCallCheck-9098b006.esm.js
function _classCallCheck(instance2, Constructor) {
  if (!(instance2 instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

// node_modules/maath/dist/index-0332b2ed.esm.js
function _defineProperties(target2, props) {
  for (var i4 = 0; i4 < props.length; i4++) {
    var descriptor = props[i4];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target2, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}
var Grad = function Grad2(x, y, z) {
  var _this = this;
  _classCallCheck(this, Grad2);
  _defineProperty2(this, "dot2", function(x2, y2) {
    return _this.x * x2 + _this.y * y2;
  });
  _defineProperty2(this, "dot3", function(x2, y2, z2) {
    return _this.x * x2 + _this.y * y2 + _this.z * z2;
  });
  this.x = x;
  this.y = y;
  this.z = z;
};
var grad3 = [new Grad(1, 1, 0), new Grad(-1, 1, 0), new Grad(1, -1, 0), new Grad(-1, -1, 0), new Grad(1, 0, 1), new Grad(-1, 0, 1), new Grad(1, 0, -1), new Grad(-1, 0, -1), new Grad(0, 1, 1), new Grad(0, -1, 1), new Grad(0, 1, -1), new Grad(0, -1, -1)];
var p = [151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180];
var perm = new Array(512);
var gradP = new Array(512);
var seed = function seed2(_seed) {
  if (_seed > 0 && _seed < 1) {
    _seed *= 65536;
  }
  _seed = Math.floor(_seed);
  if (_seed < 256) {
    _seed |= _seed << 8;
  }
  for (var i4 = 0; i4 < 256; i4++) {
    var v5;
    if (i4 & 1) {
      v5 = p[i4] ^ _seed & 255;
    } else {
      v5 = p[i4] ^ _seed >> 8 & 255;
    }
    perm[i4] = perm[i4 + 256] = v5;
    gradP[i4] = gradP[i4 + 256] = grad3[v5 % 12];
  }
};
seed(0);
var F2 = 0.5 * (Math.sqrt(3) - 1);
var G2 = (3 - Math.sqrt(3)) / 6;
var F3 = 1 / 3;
var G3 = 1 / 6;
var simplex2 = function simplex22(xin, yin) {
  var n0, n1, n2;
  var s2 = (xin + yin) * F2;
  var i4 = Math.floor(xin + s2);
  var j = Math.floor(yin + s2);
  var t3 = (i4 + j) * G2;
  var x0 = xin - i4 + t3;
  var y0 = yin - j + t3;
  var i1, j1;
  if (x0 > y0) {
    i1 = 1;
    j1 = 0;
  } else {
    i1 = 0;
    j1 = 1;
  }
  var x1 = x0 - i1 + G2;
  var y1 = y0 - j1 + G2;
  var x2 = x0 - 1 + 2 * G2;
  var y2 = y0 - 1 + 2 * G2;
  i4 &= 255;
  j &= 255;
  var gi0 = gradP[i4 + perm[j]];
  var gi1 = gradP[i4 + i1 + perm[j + j1]];
  var gi2 = gradP[i4 + 1 + perm[j + 1]];
  var t0 = 0.5 - x0 * x0 - y0 * y0;
  if (t0 < 0) {
    n0 = 0;
  } else {
    t0 *= t0;
    n0 = t0 * t0 * gi0.dot2(x0, y0);
  }
  var t1 = 0.5 - x1 * x1 - y1 * y1;
  if (t1 < 0) {
    n1 = 0;
  } else {
    t1 *= t1;
    n1 = t1 * t1 * gi1.dot2(x1, y1);
  }
  var t22 = 0.5 - x2 * x2 - y2 * y2;
  if (t22 < 0) {
    n2 = 0;
  } else {
    t22 *= t22;
    n2 = t22 * t22 * gi2.dot2(x2, y2);
  }
  return 70 * (n0 + n1 + n2);
};
var simplex3 = function simplex32(xin, yin, zin) {
  var n0, n1, n2, n3;
  var s2 = (xin + yin + zin) * F3;
  var i4 = Math.floor(xin + s2);
  var j = Math.floor(yin + s2);
  var k = Math.floor(zin + s2);
  var t3 = (i4 + j + k) * G3;
  var x0 = xin - i4 + t3;
  var y0 = yin - j + t3;
  var z0 = zin - k + t3;
  var i1, j1, k1;
  var i22, j2, k2;
  if (x0 >= y0) {
    if (y0 >= z0) {
      i1 = 1;
      j1 = 0;
      k1 = 0;
      i22 = 1;
      j2 = 1;
      k2 = 0;
    } else if (x0 >= z0) {
      i1 = 1;
      j1 = 0;
      k1 = 0;
      i22 = 1;
      j2 = 0;
      k2 = 1;
    } else {
      i1 = 0;
      j1 = 0;
      k1 = 1;
      i22 = 1;
      j2 = 0;
      k2 = 1;
    }
  } else {
    if (y0 < z0) {
      i1 = 0;
      j1 = 0;
      k1 = 1;
      i22 = 0;
      j2 = 1;
      k2 = 1;
    } else if (x0 < z0) {
      i1 = 0;
      j1 = 1;
      k1 = 0;
      i22 = 0;
      j2 = 1;
      k2 = 1;
    } else {
      i1 = 0;
      j1 = 1;
      k1 = 0;
      i22 = 1;
      j2 = 1;
      k2 = 0;
    }
  }
  var x1 = x0 - i1 + G3;
  var y1 = y0 - j1 + G3;
  var z1 = z0 - k1 + G3;
  var x2 = x0 - i22 + 2 * G3;
  var y2 = y0 - j2 + 2 * G3;
  var z2 = z0 - k2 + 2 * G3;
  var x3 = x0 - 1 + 3 * G3;
  var y3 = y0 - 1 + 3 * G3;
  var z3 = z0 - 1 + 3 * G3;
  i4 &= 255;
  j &= 255;
  k &= 255;
  var gi0 = gradP[i4 + perm[j + perm[k]]];
  var gi1 = gradP[i4 + i1 + perm[j + j1 + perm[k + k1]]];
  var gi2 = gradP[i4 + i22 + perm[j + j2 + perm[k + k2]]];
  var gi3 = gradP[i4 + 1 + perm[j + 1 + perm[k + 1]]];
  var t0 = 0.6 - x0 * x0 - y0 * y0 - z0 * z0;
  if (t0 < 0) {
    n0 = 0;
  } else {
    t0 *= t0;
    n0 = t0 * t0 * gi0.dot3(x0, y0, z0);
  }
  var t1 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1;
  if (t1 < 0) {
    n1 = 0;
  } else {
    t1 *= t1;
    n1 = t1 * t1 * gi1.dot3(x1, y1, z1);
  }
  var t22 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2;
  if (t22 < 0) {
    n2 = 0;
  } else {
    t22 *= t22;
    n2 = t22 * t22 * gi2.dot3(x2, y2, z2);
  }
  var t32 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3;
  if (t32 < 0) {
    n3 = 0;
  } else {
    t32 *= t32;
    n3 = t32 * t32 * gi3.dot3(x3, y3, z3);
  }
  return 32 * (n0 + n1 + n2 + n3);
};
var perlin2 = function perlin22(x, y) {
  var X = Math.floor(x), Y = Math.floor(y);
  x = x - X;
  y = y - Y;
  X = X & 255;
  Y = Y & 255;
  var n00 = gradP[X + perm[Y]].dot2(x, y);
  var n01 = gradP[X + perm[Y + 1]].dot2(x, y - 1);
  var n10 = gradP[X + 1 + perm[Y]].dot2(x - 1, y);
  var n11 = gradP[X + 1 + perm[Y + 1]].dot2(x - 1, y - 1);
  var u = fade(x);
  return lerp(lerp(n00, n10, u), lerp(n01, n11, u), fade(y));
};
var perlin3 = function perlin32(x, y, z) {
  var X = Math.floor(x), Y = Math.floor(y), Z = Math.floor(z);
  x = x - X;
  y = y - Y;
  z = z - Z;
  X = X & 255;
  Y = Y & 255;
  Z = Z & 255;
  var n000 = gradP[X + perm[Y + perm[Z]]].dot3(x, y, z);
  var n001 = gradP[X + perm[Y + perm[Z + 1]]].dot3(x, y, z - 1);
  var n010 = gradP[X + perm[Y + 1 + perm[Z]]].dot3(x, y - 1, z);
  var n011 = gradP[X + perm[Y + 1 + perm[Z + 1]]].dot3(x, y - 1, z - 1);
  var n100 = gradP[X + 1 + perm[Y + perm[Z]]].dot3(x - 1, y, z);
  var n101 = gradP[X + 1 + perm[Y + perm[Z + 1]]].dot3(x - 1, y, z - 1);
  var n110 = gradP[X + 1 + perm[Y + 1 + perm[Z]]].dot3(x - 1, y - 1, z);
  var n111 = gradP[X + 1 + perm[Y + 1 + perm[Z + 1]]].dot3(x - 1, y - 1, z - 1);
  var u = fade(x);
  var v5 = fade(y);
  var w = fade(z);
  return lerp(lerp(lerp(n000, n100, u), lerp(n001, n101, u), w), lerp(lerp(n010, n110, u), lerp(n011, n111, u), w), v5);
};
var noise = Object.freeze({
  __proto__: null,
  seed,
  simplex2,
  simplex3,
  perlin2,
  perlin3
});
var TAU = Math.PI * 2;
var FlashGen = (function() {
  function FlashGen2(props) {
    _classCallCheck(this, FlashGen2);
    _defineProperty2(this, "nextBurstTime", 0);
    _defineProperty2(this, "nextFlashEndTime", 0);
    _defineProperty2(this, "flashesDone", 0);
    _defineProperty2(this, "isFlashing", false);
    _defineProperty2(this, "currentCount", 0);
    _defineProperty2(this, "flashIntensity", 0);
    _defineProperty2(this, "isDecaying", false);
    _defineProperty2(this, "autoBurst", true);
    _defineProperty2(this, "decaySpeed", 40);
    _defineProperty2(this, "minInterval", 5e3);
    _defineProperty2(this, "maxInterval", 1e4);
    _defineProperty2(this, "minDuration", 50);
    _defineProperty2(this, "maxDuration", 300);
    _defineProperty2(this, "count", 5);
    Object.assign(this, props);
  }
  _createClass(FlashGen2, [{
    key: "scheduleNextBurst",
    value: function scheduleNextBurst(currentTime) {
      var burstInterval = Math.random() * (this.maxInterval - this.minInterval) + this.minInterval;
      this.nextBurstTime = currentTime + burstInterval / 1e3;
      this.flashesDone = 0;
      this.isFlashing = false;
    }
  }, {
    key: "burst",
    value: function burst() {
      this.nextBurstTime = 0;
      this.flashesDone = 0;
      this.isFlashing = false;
    }
  }, {
    key: "update",
    value: function update2(currentTime, delta) {
      if (currentTime > this.nextBurstTime && this.currentCount === 0) {
        this.currentCount = Math.floor(Math.random() * this.count) + 1;
      }
      if (this.flashesDone < this.currentCount && currentTime > this.nextBurstTime) {
        if (!this.isFlashing) {
          this.isFlashing = true;
          this.flashIntensity = 1;
          var flashDuration = Math.random() * (this.maxDuration - this.minDuration) + this.minDuration;
          this.nextFlashEndTime = currentTime + flashDuration / 1e3;
        } else if (this.isFlashing && currentTime > this.nextFlashEndTime) {
          this.isFlashing = false;
          this.isDecaying = true;
          this.flashesDone++;
          if (this.flashesDone >= this.currentCount) {
            this.currentCount = 0;
            if (this.autoBurst) this.scheduleNextBurst(currentTime);
          }
        }
      }
      if (this.isDecaying) {
        this.flashIntensity -= delta * this.decaySpeed;
        this.flashIntensity = Math.max(0, Math.min(1, this.flashIntensity));
        if (this.flashIntensity <= 0) {
          this.isDecaying = false;
          this.flashIntensity = 0;
        }
      }
      return this.flashIntensity;
    }
  }]);
  return FlashGen2;
})();
function normalizeSeed(seed3) {
  if (typeof seed3 === "number") {
    seed3 = Math.abs(seed3);
  } else if (typeof seed3 === "string") {
    var string = seed3;
    seed3 = 0;
    for (var i4 = 0; i4 < string.length; i4++) {
      seed3 = (seed3 + (i4 + 1) * (string.charCodeAt(i4) % 96)) % 2147483647;
    }
  }
  if (seed3 === 0) {
    seed3 = 311;
  }
  return seed3;
}
function lcgRandom(seed3) {
  var state = normalizeSeed(seed3);
  return function() {
    var result = state * 48271 % 2147483647;
    state = result;
    return result / 2147483647;
  };
}
var Generator = function Generator2(_seed) {
  var _this = this;
  _classCallCheck(this, Generator2);
  _defineProperty2(this, "seed", 0);
  _defineProperty2(this, "init", function(seed3) {
    _this.seed = seed3;
    _this.value = lcgRandom(seed3);
  });
  _defineProperty2(this, "value", lcgRandom(this.seed));
  this.init(_seed);
};
var defaultGen = new Generator(Math.random());
var defaultSphere = {
  radius: 1,
  center: [0, 0, 0]
};
function onSphere(buffer2, sphere) {
  var rng = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : defaultGen;
  var _defaultSphere$sphere = _objectSpread22(_objectSpread22({}, defaultSphere), sphere), radius = _defaultSphere$sphere.radius, center3 = _defaultSphere$sphere.center;
  for (var i4 = 0; i4 < buffer2.length; i4 += 3) {
    var u = rng.value();
    var v5 = rng.value();
    var theta = Math.acos(2 * v5 - 1);
    var phi = TAU * u;
    buffer2[i4] = Math.sin(theta) * Math.cos(phi) * radius + center3[0];
    buffer2[i4 + 1] = Math.sin(theta) * Math.sin(phi) * radius + center3[1];
    buffer2[i4 + 2] = Math.cos(theta) * radius + center3[2];
  }
  return buffer2;
}
function inSphere(buffer2, sphere) {
  var rng = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : defaultGen;
  var _defaultSphere$sphere2 = _objectSpread22(_objectSpread22({}, defaultSphere), sphere), radius = _defaultSphere$sphere2.radius, center3 = _defaultSphere$sphere2.center;
  for (var i4 = 0; i4 < buffer2.length; i4 += 3) {
    var u = Math.pow(rng.value(), 1 / 3);
    var x = rng.value() * 2 - 1;
    var y = rng.value() * 2 - 1;
    var z = rng.value() * 2 - 1;
    var mag = Math.sqrt(x * x + y * y + z * z);
    x = u * x / mag;
    y = u * y / mag;
    z = u * z / mag;
    buffer2[i4] = x * radius + center3[0];
    buffer2[i4 + 1] = y * radius + center3[1];
    buffer2[i4 + 2] = z * radius + center3[2];
  }
  return buffer2;
}
var defaultCircle = {
  radius: 1,
  center: [0, 0]
};
function inCircle(buffer2, circle) {
  var rng = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : defaultGen;
  var _defaultCircle$circle = _objectSpread22(_objectSpread22({}, defaultCircle), circle), radius = _defaultCircle$circle.radius, center3 = _defaultCircle$circle.center;
  for (var i4 = 0; i4 < buffer2.length; i4 += 2) {
    var r2 = radius * Math.sqrt(rng.value());
    var theta = rng.value() * TAU;
    buffer2[i4] = Math.sin(theta) * r2 + center3[0];
    buffer2[i4 + 1] = Math.cos(theta) * r2 + center3[1];
  }
  return buffer2;
}
function onCircle(buffer2, circle) {
  var rng = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : defaultGen;
  var _defaultCircle$circle2 = _objectSpread22(_objectSpread22({}, defaultCircle), circle), radius = _defaultCircle$circle2.radius, center3 = _defaultCircle$circle2.center;
  for (var i4 = 0; i4 < buffer2.length; i4 += 2) {
    var theta = rng.value() * TAU;
    buffer2[i4] = Math.sin(theta) * radius + center3[0];
    buffer2[i4 + 1] = Math.cos(theta) * radius + center3[1];
  }
  return buffer2;
}
var defaultRect = {
  sides: 1,
  center: [0, 0]
};
function inRect(buffer2, rect) {
  var rng = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : defaultGen;
  var _defaultRect$rect = _objectSpread22(_objectSpread22({}, defaultRect), rect), sides = _defaultRect$rect.sides, center3 = _defaultRect$rect.center;
  var sideX = typeof sides === "number" ? sides : sides[0];
  var sideY = typeof sides === "number" ? sides : sides[1];
  for (var i4 = 0; i4 < buffer2.length; i4 += 2) {
    buffer2[i4] = (rng.value() - 0.5) * sideX + center3[0];
    buffer2[i4 + 1] = (rng.value() - 0.5) * sideY + center3[1];
  }
  return buffer2;
}
function onRect(buffer2, rect) {
  return buffer2;
}
function inBox(buffer2, box) {
  var rng = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : defaultGen;
  var _defaultBox$box = _objectSpread22(_objectSpread22({}, defaultBox), box), sides = _defaultBox$box.sides, center3 = _defaultBox$box.center;
  var sideX = typeof sides === "number" ? sides : sides[0];
  var sideY = typeof sides === "number" ? sides : sides[1];
  var sideZ = typeof sides === "number" ? sides : sides[2];
  for (var i4 = 0; i4 < buffer2.length; i4 += 3) {
    buffer2[i4] = (rng.value() - 0.5) * sideX + center3[0];
    buffer2[i4 + 1] = (rng.value() - 0.5) * sideY + center3[1];
    buffer2[i4 + 2] = (rng.value() - 0.5) * sideZ + center3[2];
  }
  return buffer2;
}
var defaultBox = {
  sides: 1,
  center: [0, 0, 0]
};
function onBox(buffer2, box) {
  var rng = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : defaultGen;
  var _defaultBox$box2 = _objectSpread22(_objectSpread22({}, defaultBox), box), sides = _defaultBox$box2.sides, center3 = _defaultBox$box2.center;
  var sideX = typeof sides === "number" ? sides : sides[0];
  var sideY = typeof sides === "number" ? sides : sides[1];
  var sideZ = typeof sides === "number" ? sides : sides[2];
  for (var i4 = 0; i4 < buffer2.length; i4 += 3) {
    buffer2[i4] = (rng.value() - 0.5) * sideX + center3[0];
    buffer2[i4 + 1] = (rng.value() - 0.5) * sideY + center3[1];
    buffer2[i4 + 2] = (rng.value() - 0.5) * sideZ + center3[2];
  }
  return buffer2;
}
var index = Object.freeze({
  __proto__: null,
  FlashGen,
  Generator,
  onSphere,
  inSphere,
  inCircle,
  onCircle,
  inRect,
  onRect,
  inBox,
  onBox,
  noise
});

// node_modules/maath/dist/easing-0f4db1c0.esm.js
var rsqw = function rsqw2(t3) {
  var delta = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 0.01;
  var a6 = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : 1;
  var f2 = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : 1 / (2 * Math.PI);
  return a6 / Math.atan(1 / delta) * Math.atan(Math.sin(2 * Math.PI * t3 * f2) / delta);
};
var exp = function exp2(t3) {
  return 1 / (1 + t3 + 0.48 * t3 * t3 + 0.235 * t3 * t3 * t3);
};
var linear = function linear2(t3) {
  return t3;
};
var sine = {
  "in": function _in(x) {
    return 1 - Math.cos(x * Math.PI / 2);
  },
  out: function out(x) {
    return Math.sin(x * Math.PI / 2);
  },
  inOut: function inOut(x) {
    return -(Math.cos(Math.PI * x) - 1) / 2;
  }
};
var cubic = {
  "in": function _in2(x) {
    return x * x * x;
  },
  out: function out2(x) {
    return 1 - Math.pow(1 - x, 3);
  },
  inOut: function inOut2(x) {
    return x < 0.5 ? 4 * x * x * x : 1 - Math.pow(-2 * x + 2, 3) / 2;
  }
};
var quint = {
  "in": function _in3(x) {
    return x * x * x * x * x;
  },
  out: function out3(x) {
    return 1 - Math.pow(1 - x, 5);
  },
  inOut: function inOut3(x) {
    return x < 0.5 ? 16 * x * x * x * x * x : 1 - Math.pow(-2 * x + 2, 5) / 2;
  }
};
var circ = {
  "in": function _in4(x) {
    return 1 - Math.sqrt(1 - Math.pow(x, 2));
  },
  out: function out4(x) {
    return Math.sqrt(1 - Math.pow(x - 1, 2));
  },
  inOut: function inOut4(x) {
    return x < 0.5 ? (1 - Math.sqrt(1 - Math.pow(2 * x, 2))) / 2 : (Math.sqrt(1 - Math.pow(-2 * x + 2, 2)) + 1) / 2;
  }
};
var quart = {
  "in": function _in5(t3) {
    return t3 * t3 * t3 * t3;
  },
  out: function out5(t3) {
    return 1 - --t3 * t3 * t3 * t3;
  },
  inOut: function inOut5(t3) {
    return t3 < 0.5 ? 8 * t3 * t3 * t3 * t3 : 1 - 8 * --t3 * t3 * t3 * t3;
  }
};
var expo = {
  "in": function _in6(x) {
    return x === 0 ? 0 : Math.pow(2, 10 * x - 10);
  },
  out: function out6(x) {
    return x === 1 ? 1 : 1 - Math.pow(2, -10 * x);
  },
  inOut: function inOut6(x) {
    return x === 0 ? 0 : x === 1 ? 1 : x < 0.5 ? Math.pow(2, 20 * x - 10) / 2 : (2 - Math.pow(2, -20 * x + 10)) / 2;
  }
};
function damp(current, prop, target2) {
  var smoothTime = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : 0.25;
  var delta = arguments.length > 4 && arguments[4] !== void 0 ? arguments[4] : 0.01;
  var maxSpeed = arguments.length > 5 && arguments[5] !== void 0 ? arguments[5] : Infinity;
  var easing2 = arguments.length > 6 && arguments[6] !== void 0 ? arguments[6] : exp;
  var eps2 = arguments.length > 7 && arguments[7] !== void 0 ? arguments[7] : 1e-3;
  var vel = "velocity_" + prop;
  if (current.__damp === void 0) current.__damp = {};
  if (current.__damp[vel] === void 0) current.__damp[vel] = 0;
  if (Math.abs(current[prop] - target2) <= eps2) {
    current[prop] = target2;
    return false;
  }
  smoothTime = Math.max(1e-4, smoothTime);
  var omega = 2 / smoothTime;
  var t3 = easing2(omega * delta);
  var change = current[prop] - target2;
  var originalTo = target2;
  var maxChange = maxSpeed * smoothTime;
  change = Math.min(Math.max(change, -maxChange), maxChange);
  target2 = current[prop] - change;
  var temp5 = (current.__damp[vel] + omega * change) * delta;
  current.__damp[vel] = (current.__damp[vel] - omega * temp5) * t3;
  var output = target2 + (change + temp5) * t3;
  if (originalTo - current[prop] > 0 === output > originalTo) {
    output = originalTo;
    current.__damp[vel] = (output - originalTo) / delta;
  }
  current[prop] = output;
  return true;
}
var isCamera = function isCamera2(v5) {
  return v5 && v5.isCamera;
};
var isLight = function isLight2(v5) {
  return v5 && v5.isLight;
};
var vl3d = new Vector3();
var _q1 = new Quaternion();
var _q2 = new Quaternion();
var _m1 = new Matrix4();
var _position = new Vector3();
function dampLookAt(current, target2, smoothTime, delta, maxSpeed, easing2, eps2) {
  if (typeof target2 === "number") vl3d.setScalar(target2);
  else if (Array.isArray(target2)) vl3d.set(target2[0], target2[1], target2[2]);
  else vl3d.copy(target2);
  var parent = current.parent;
  current.updateWorldMatrix(true, false);
  _position.setFromMatrixPosition(current.matrixWorld);
  if (isCamera(current) || isLight(current)) _m1.lookAt(_position, vl3d, current.up);
  else _m1.lookAt(vl3d, _position, current.up);
  dampQ(current.quaternion, _q2.setFromRotationMatrix(_m1), smoothTime, delta, maxSpeed, easing2, eps2);
  if (parent) {
    _m1.extractRotation(parent.matrixWorld);
    _q1.setFromRotationMatrix(_m1);
    dampQ(current.quaternion, _q2.copy(current.quaternion).premultiply(_q1.invert()), smoothTime, delta, maxSpeed, easing2, eps2);
  }
}
function dampAngle(current, prop, target2, smoothTime, delta, maxSpeed, easing2, eps2) {
  return damp(current, prop, current[prop] + deltaAngle(current[prop], target2), smoothTime, delta, maxSpeed, easing2, eps2);
}
var v2d = new Vector2();
var a2;
var b2;
function damp2(current, target2, smoothTime, delta, maxSpeed, easing2, eps2) {
  if (typeof target2 === "number") v2d.setScalar(target2);
  else if (Array.isArray(target2)) v2d.set(target2[0], target2[1]);
  else v2d.copy(target2);
  a2 = damp(current, "x", v2d.x, smoothTime, delta, maxSpeed, easing2, eps2);
  b2 = damp(current, "y", v2d.y, smoothTime, delta, maxSpeed, easing2, eps2);
  return a2 || b2;
}
var v3d = new Vector3();
var a3;
var b3;
var c3;
function damp3(current, target2, smoothTime, delta, maxSpeed, easing2, eps2) {
  if (typeof target2 === "number") v3d.setScalar(target2);
  else if (Array.isArray(target2)) v3d.set(target2[0], target2[1], target2[2]);
  else v3d.copy(target2);
  a3 = damp(current, "x", v3d.x, smoothTime, delta, maxSpeed, easing2, eps2);
  b3 = damp(current, "y", v3d.y, smoothTime, delta, maxSpeed, easing2, eps2);
  c3 = damp(current, "z", v3d.z, smoothTime, delta, maxSpeed, easing2, eps2);
  return a3 || b3 || c3;
}
var v4d = new Vector4();
var a4;
var b4;
var c4;
var d4;
function damp4(current, target2, smoothTime, delta, maxSpeed, easing2, eps2) {
  if (typeof target2 === "number") v4d.setScalar(target2);
  else if (Array.isArray(target2)) v4d.set(target2[0], target2[1], target2[2], target2[3]);
  else v4d.copy(target2);
  a4 = damp(current, "x", v4d.x, smoothTime, delta, maxSpeed, easing2, eps2);
  b4 = damp(current, "y", v4d.y, smoothTime, delta, maxSpeed, easing2, eps2);
  c4 = damp(current, "z", v4d.z, smoothTime, delta, maxSpeed, easing2, eps2);
  d4 = damp(current, "w", v4d.w, smoothTime, delta, maxSpeed, easing2, eps2);
  return a4 || b4 || c4 || d4;
}
var rot = new Euler();
var aE;
var bE;
var cE;
function dampE(current, target2, smoothTime, delta, maxSpeed, easing2, eps2) {
  if (Array.isArray(target2)) rot.set(target2[0], target2[1], target2[2], target2[3]);
  else rot.copy(target2);
  aE = dampAngle(current, "x", rot.x, smoothTime, delta, maxSpeed, easing2, eps2);
  bE = dampAngle(current, "y", rot.y, smoothTime, delta, maxSpeed, easing2, eps2);
  cE = dampAngle(current, "z", rot.z, smoothTime, delta, maxSpeed, easing2, eps2);
  return aE || bE || cE;
}
var col = new Color();
var aC;
var bC;
var cC;
function dampC(current, target2, smoothTime, delta, maxSpeed, easing2, eps2) {
  if (target2 instanceof Color) col.copy(target2);
  else if (Array.isArray(target2)) col.setRGB(target2[0], target2[1], target2[2]);
  else col.set(target2);
  aC = damp(current, "r", col.r, smoothTime, delta, maxSpeed, easing2, eps2);
  bC = damp(current, "g", col.g, smoothTime, delta, maxSpeed, easing2, eps2);
  cC = damp(current, "b", col.b, smoothTime, delta, maxSpeed, easing2, eps2);
  return aC || bC || cC;
}
var qt = new Quaternion();
var v4result = new Vector4();
var v4velocity = new Vector4();
var v4error = new Vector4();
var aQ;
var bQ;
var cQ;
var dQ;
function dampQ(current, target2, smoothTime, delta, maxSpeed, easing2, eps2) {
  var cur = current;
  if (Array.isArray(target2)) qt.set(target2[0], target2[1], target2[2], target2[3]);
  else qt.copy(target2);
  var multi = current.dot(qt) > 0 ? 1 : -1;
  qt.x *= multi;
  qt.y *= multi;
  qt.z *= multi;
  qt.w *= multi;
  aQ = damp(current, "x", qt.x, smoothTime, delta, maxSpeed, easing2, eps2);
  bQ = damp(current, "y", qt.y, smoothTime, delta, maxSpeed, easing2, eps2);
  cQ = damp(current, "z", qt.z, smoothTime, delta, maxSpeed, easing2, eps2);
  dQ = damp(current, "w", qt.w, smoothTime, delta, maxSpeed, easing2, eps2);
  v4result.set(current.x, current.y, current.z, current.w).normalize();
  v4velocity.set(cur.__damp.velocity_x, cur.__damp.velocity_y, cur.__damp.velocity_z, cur.__damp.velocity_w);
  v4error.copy(v4result).multiplyScalar(v4velocity.dot(v4result) / v4result.dot(v4result));
  cur.__damp.velocity_x -= v4error.x;
  cur.__damp.velocity_y -= v4error.y;
  cur.__damp.velocity_z -= v4error.z;
  cur.__damp.velocity_w -= v4error.w;
  current.set(v4result.x, v4result.y, v4result.z, v4result.w);
  return aQ || bQ || cQ || dQ;
}
var spherical = new Spherical();
var aS;
var bS;
var cS;
function dampS(current, target2, smoothTime, delta, maxSpeed, easing2, eps2) {
  if (Array.isArray(target2)) spherical.set(target2[0], target2[1], target2[2]);
  else spherical.copy(target2);
  aS = damp(current, "radius", spherical.radius, smoothTime, delta, maxSpeed, easing2, eps2);
  bS = dampAngle(current, "phi", spherical.phi, smoothTime, delta, maxSpeed, easing2, eps2);
  cS = dampAngle(current, "theta", spherical.theta, smoothTime, delta, maxSpeed, easing2, eps2);
  return aS || bS || cS;
}
var mat = new Matrix4();
var mPos = new Vector3();
var mRot = new Quaternion();
var mSca = new Vector3();
var aM;
var bM;
var cM;
function dampM(current, target2, smoothTime, delta, maxSpeed, easing2, eps2) {
  var cur = current;
  if (cur.__damp === void 0) {
    cur.__damp = {
      position: new Vector3(),
      rotation: new Quaternion(),
      scale: new Vector3()
    };
    current.decompose(cur.__damp.position, cur.__damp.rotation, cur.__damp.scale);
  }
  if (Array.isArray(target2)) mat.set.apply(mat, _toConsumableArray(target2));
  else mat.copy(target2);
  mat.decompose(mPos, mRot, mSca);
  aM = damp3(cur.__damp.position, mPos, smoothTime, delta, maxSpeed, easing2, eps2);
  bM = dampQ(cur.__damp.rotation, mRot, smoothTime, delta, maxSpeed, easing2, eps2);
  cM = damp3(cur.__damp.scale, mSca, smoothTime, delta, maxSpeed, easing2, eps2);
  current.compose(cur.__damp.position, cur.__damp.rotation, cur.__damp.scale);
  return aM || bM || cM;
}
var easing = Object.freeze({
  __proto__: null,
  rsqw,
  exp,
  linear,
  sine,
  cubic,
  quint,
  circ,
  quart,
  expo,
  damp,
  dampLookAt,
  dampAngle,
  damp2,
  damp3,
  damp4,
  dampE,
  dampC,
  dampQ,
  dampS,
  dampM
});

// node_modules/maath/dist/geometry-0fb11825.esm.js
function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}
function _getPrototypeOf(o2) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf2(o3) {
    return o3.__proto__ || Object.getPrototypeOf(o3);
  };
  return _getPrototypeOf(o2);
}
function _assertThisInitialized(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _possibleConstructorReturn(self2, call3) {
  if (call3 && (typeof call3 === "object" || typeof call3 === "function")) {
    return call3;
  } else if (call3 !== void 0) {
    throw new TypeError("Derived constructors may only return object or undefined");
  }
  return _assertThisInitialized(self2);
}
function _createSuper(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn(this, result);
  };
}
var RoundedPlaneGeometry = (function(_THREE$BufferGeometry) {
  _inherits(RoundedPlaneGeometry2, _THREE$BufferGeometry);
  var _super = _createSuper(RoundedPlaneGeometry2);
  function RoundedPlaneGeometry2() {
    var _this;
    var width = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : 2;
    var height = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 1;
    var radius = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : 0.2;
    var segments = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : 16;
    _classCallCheck(this, RoundedPlaneGeometry2);
    _this = _super.call(this);
    _this.parameters = {
      width,
      height,
      radius,
      segments
    };
    var wi = width / 2 - radius;
    var hi = height / 2 - radius;
    var ul = radius / width;
    var ur = (width - radius) / width;
    var vl = radius / height;
    var vh = (height - radius) / height;
    var positions = [wi, hi, 0, -wi, hi, 0, -wi, -hi, 0, wi, -hi, 0];
    var uvs = [ur, vh, ul, vh, ul, vl, ur, vl];
    var n2 = [3 * (segments + 1) + 3, 3 * (segments + 1) + 4, segments + 4, segments + 5, 2 * (segments + 1) + 4, 2, 1, 2 * (segments + 1) + 3, 3, 4 * (segments + 1) + 3, 4, 0];
    var indices = [n2[0], n2[1], n2[2], n2[0], n2[2], n2[3], n2[4], n2[5], n2[6], n2[4], n2[6], n2[7], n2[8], n2[9], n2[10], n2[8], n2[10], n2[11]];
    var phi, cos, sin, xc, yc, uc, vc, idx;
    for (var i4 = 0; i4 < 4; i4++) {
      xc = i4 < 1 || i4 > 2 ? wi : -wi;
      yc = i4 < 2 ? hi : -hi;
      uc = i4 < 1 || i4 > 2 ? ur : ul;
      vc = i4 < 2 ? vh : vl;
      for (var j = 0; j <= segments; j++) {
        phi = Math.PI / 2 * (i4 + j / segments);
        cos = Math.cos(phi);
        sin = Math.sin(phi);
        positions.push(xc + radius * cos, yc + radius * sin, 0);
        uvs.push(uc + ul * cos, vc + vl * sin);
        if (j < segments) {
          idx = (segments + 1) * i4 + j + 4;
          indices.push(i4, idx, idx + 1);
        }
      }
    }
    _this.setIndex(new BufferAttribute(new Uint32Array(indices), 1));
    _this.setAttribute("position", new BufferAttribute(new Float32Array(positions), 3));
    _this.setAttribute("uv", new BufferAttribute(new Float32Array(uvs), 2));
    return _this;
  }
  return RoundedPlaneGeometry2;
})(BufferGeometry);
function applyCylindricalUV(bufferGeometry) {
  var uvs = [];
  for (var i4 = 0; i4 < bufferGeometry.attributes.position.array.length / 3; i4++) {
    var x = bufferGeometry.attributes.position.array[i4 * 3 + 0];
    var y = bufferGeometry.attributes.position.array[i4 * 3 + 1];
    var z = bufferGeometry.attributes.position.array[i4 * 3 + 2];
    uvs.push(Math.atan2(x, z) / Math.PI * 0.5 + 0.5, y / Math.PI * 0.5 + 0.5);
  }
  if (bufferGeometry.attributes.uv) delete bufferGeometry.attributes.uv;
  bufferGeometry.setAttribute("uv", new Float32BufferAttribute(uvs, 2));
  bufferGeometry.attributes.uv.needsUpdate = true;
  return bufferGeometry;
}
function applySphereUV(bufferGeometry) {
  var uvs = [];
  var vertices = [];
  for (var i4 = 0; i4 < bufferGeometry.attributes.position.array.length / 3; i4++) {
    var x = bufferGeometry.attributes.position.array[i4 * 3 + 0];
    var y = bufferGeometry.attributes.position.array[i4 * 3 + 1];
    var z = bufferGeometry.attributes.position.array[i4 * 3 + 2];
    vertices.push(new Vector3(x, y, z));
  }
  var polarVertices = vertices.map(cartesian2polar);
  for (var _i = 0; _i < polarVertices.length / 3; _i++) {
    var tri = new Triangle(vertices[_i * 3 + 0], vertices[_i * 3 + 1], vertices[_i * 3 + 2]);
    var normal2 = tri.getNormal(new Vector3());
    for (var f2 = 0; f2 < 3; f2++) {
      var vertex = polarVertices[_i * 3 + f2];
      if (vertex.theta === 0 && (vertex.phi === 0 || vertex.phi === Math.PI)) {
        var alignedVertice = vertex.phi === 0 ? _i * 3 + 1 : _i * 3 + 0;
        vertex = {
          r: vertex.r,
          phi: vertex.phi,
          theta: polarVertices[alignedVertice].theta
        };
      }
      if (vertex.theta === Math.PI && cartesian2polar(normal2).theta < Math.PI / 2) {
        vertex.theta = -Math.PI;
      }
      var canvasPoint = polar2canvas(vertex);
      uvs.push(1 - canvasPoint.x, 1 - canvasPoint.y);
    }
  }
  if (bufferGeometry.attributes.uv) delete bufferGeometry.attributes.uv;
  bufferGeometry.setAttribute("uv", new Float32BufferAttribute(uvs, 2));
  bufferGeometry.attributes.uv.needsUpdate = true;
  return bufferGeometry;
}
function cartesian2polar(position2) {
  var r2 = Math.sqrt(position2.x * position2.x + position2.z * position2.z + position2.y * position2.y);
  return {
    r: r2,
    phi: Math.acos(position2.y / r2),
    theta: Math.atan2(position2.z, position2.x)
  };
}
function polar2canvas(polarPoint) {
  return {
    y: polarPoint.phi / Math.PI,
    x: (polarPoint.theta + Math.PI) / (2 * Math.PI)
  };
}
function applyBoxUV(bufferGeometry) {
  bufferGeometry.computeBoundingBox();
  var bboxSize = bufferGeometry.boundingBox.getSize(new Vector3());
  var boxSize = Math.min(bboxSize.x, bboxSize.y, bboxSize.z);
  var boxGeometry = new BoxGeometry(boxSize, boxSize, boxSize);
  var cube = new Mesh(boxGeometry);
  cube.rotation.set(0, 0, 0);
  cube.updateWorldMatrix(true, false);
  var transformMatrix = cube.matrix.clone().invert();
  var uvBbox = new Box3(new Vector3(-boxSize / 2, -boxSize / 2, -boxSize / 2), new Vector3(boxSize / 2, boxSize / 2, boxSize / 2));
  _applyBoxUV(bufferGeometry, transformMatrix, uvBbox, boxSize);
  bufferGeometry.attributes.uv.needsUpdate = true;
  return bufferGeometry;
}
function _applyBoxUV(geom, transformMatrix, bbox, bbox_max_size) {
  var coords = [];
  coords.length = 2 * geom.attributes.position.array.length / 3;
  var makeUVs = function makeUVs2(v02, v14, v23) {
    v02.applyMatrix4(transformMatrix);
    v14.applyMatrix4(transformMatrix);
    v23.applyMatrix4(transformMatrix);
    var n2 = new Vector3();
    n2.crossVectors(v14.clone().sub(v02), v14.clone().sub(v23)).normalize();
    n2.x = Math.abs(n2.x);
    n2.y = Math.abs(n2.y);
    n2.z = Math.abs(n2.z);
    var uv0 = new Vector2();
    var uv1 = new Vector2();
    var uv2 = new Vector2();
    if (n2.y > n2.x && n2.y > n2.z) {
      uv0.x = (v02.x - bbox.min.x) / bbox_max_size;
      uv0.y = (bbox.max.z - v02.z) / bbox_max_size;
      uv1.x = (v14.x - bbox.min.x) / bbox_max_size;
      uv1.y = (bbox.max.z - v14.z) / bbox_max_size;
      uv2.x = (v23.x - bbox.min.x) / bbox_max_size;
      uv2.y = (bbox.max.z - v23.z) / bbox_max_size;
    } else if (n2.x > n2.y && n2.x > n2.z) {
      uv0.x = (v02.z - bbox.min.z) / bbox_max_size;
      uv0.y = (v02.y - bbox.min.y) / bbox_max_size;
      uv1.x = (v14.z - bbox.min.z) / bbox_max_size;
      uv1.y = (v14.y - bbox.min.y) / bbox_max_size;
      uv2.x = (v23.z - bbox.min.z) / bbox_max_size;
      uv2.y = (v23.y - bbox.min.y) / bbox_max_size;
    } else if (n2.z > n2.y && n2.z > n2.x) {
      uv0.x = (v02.x - bbox.min.x) / bbox_max_size;
      uv0.y = (v02.y - bbox.min.y) / bbox_max_size;
      uv1.x = (v14.x - bbox.min.x) / bbox_max_size;
      uv1.y = (v14.y - bbox.min.y) / bbox_max_size;
      uv2.x = (v23.x - bbox.min.x) / bbox_max_size;
      uv2.y = (v23.y - bbox.min.y) / bbox_max_size;
    }
    return {
      uv0,
      uv1,
      uv2
    };
  };
  if (geom.index) {
    for (var vi = 0; vi < geom.index.array.length; vi += 3) {
      var idx0 = geom.index.array[vi];
      var idx1 = geom.index.array[vi + 1];
      var idx2 = geom.index.array[vi + 2];
      var vx0 = geom.attributes.position.array[3 * idx0];
      var vy0 = geom.attributes.position.array[3 * idx0 + 1];
      var vz0 = geom.attributes.position.array[3 * idx0 + 2];
      var vx1 = geom.attributes.position.array[3 * idx1];
      var vy1 = geom.attributes.position.array[3 * idx1 + 1];
      var vz1 = geom.attributes.position.array[3 * idx1 + 2];
      var vx2 = geom.attributes.position.array[3 * idx2];
      var vy2 = geom.attributes.position.array[3 * idx2 + 1];
      var vz2 = geom.attributes.position.array[3 * idx2 + 2];
      var v0 = new Vector3(vx0, vy0, vz0);
      var v13 = new Vector3(vx1, vy1, vz1);
      var v22 = new Vector3(vx2, vy2, vz2);
      var uvs = makeUVs(v0, v13, v22);
      coords[2 * idx0] = uvs.uv0.x;
      coords[2 * idx0 + 1] = uvs.uv0.y;
      coords[2 * idx1] = uvs.uv1.x;
      coords[2 * idx1 + 1] = uvs.uv1.y;
      coords[2 * idx2] = uvs.uv2.x;
      coords[2 * idx2 + 1] = uvs.uv2.y;
    }
  } else {
    for (var _vi = 0; _vi < geom.attributes.position.array.length; _vi += 9) {
      var _vx = geom.attributes.position.array[_vi];
      var _vy = geom.attributes.position.array[_vi + 1];
      var _vz = geom.attributes.position.array[_vi + 2];
      var _vx2 = geom.attributes.position.array[_vi + 3];
      var _vy2 = geom.attributes.position.array[_vi + 4];
      var _vz2 = geom.attributes.position.array[_vi + 5];
      var _vx3 = geom.attributes.position.array[_vi + 6];
      var _vy3 = geom.attributes.position.array[_vi + 7];
      var _vz3 = geom.attributes.position.array[_vi + 8];
      var _v4 = new Vector3(_vx, _vy, _vz);
      var _v26 = new Vector3(_vx2, _vy2, _vz2);
      var _v32 = new Vector3(_vx3, _vy3, _vz3);
      var _uvs = makeUVs(_v4, _v26, _v32);
      var _idx = _vi / 3;
      var _idx2 = _idx + 1;
      var _idx3 = _idx + 2;
      coords[2 * _idx] = _uvs.uv0.x;
      coords[2 * _idx + 1] = _uvs.uv0.y;
      coords[2 * _idx2] = _uvs.uv1.x;
      coords[2 * _idx2 + 1] = _uvs.uv1.y;
      coords[2 * _idx3] = _uvs.uv2.x;
      coords[2 * _idx3 + 1] = _uvs.uv2.y;
    }
  }
  if (geom.attributes.uv) delete geom.attributes.uv;
  geom.setAttribute("uv", new Float32BufferAttribute(coords, 2));
}
var geometry = Object.freeze({
  __proto__: null,
  RoundedPlaneGeometry,
  applyCylindricalUV,
  applySphereUV,
  applyBoxUV
});

// node_modules/maath/dist/three-eb2ad8c0.esm.js
function bufferToVectors(buffer2) {
  var stride = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 3;
  var p2 = [];
  for (var i4 = 0, j = 0; i4 < buffer2.length; i4 += stride, j++) {
    if (stride === 3) {
      p2[j] = new Vector3(buffer2[i4], buffer2[i4 + 1], buffer2[i4 + 2]);
    } else {
      p2[j] = new Vector2(buffer2[i4], buffer2[i4 + 1]);
    }
  }
  return p2;
}
function vectorsToBuffer(vectorArray) {
  var l2 = vectorArray.length;
  var stride = vectorArray[0].hasOwnProperty("z") ? 3 : 2;
  var buffer2 = new Float32Array(l2 * stride);
  for (var i4 = 0; i4 < l2; i4++) {
    var j = i4 * stride;
    buffer2[j] = vectorArray[i4].x;
    buffer2[j + 1] = vectorArray[i4].y;
    if (stride === 3) {
      buffer2[j + 2] = vectorArray[i4].z;
    }
  }
  return buffer2;
}
var three = Object.freeze({
  __proto__: null,
  bufferToVectors,
  vectorsToBuffer
});

// node_modules/@react-three/drei/web/ScrollControls.js
var context2 = React9.createContext(null);
function useScroll() {
  return React9.useContext(context2);
}
function ScrollControls({
  eps: eps2 = 1e-5,
  enabled = true,
  infinite,
  horizontal,
  pages = 1,
  distance: distance3 = 1,
  damping = 0.25,
  maxSpeed = Infinity,
  prepend = false,
  style = {},
  children
}) {
  const {
    get,
    setEvents,
    gl,
    size: size2,
    invalidate,
    events
  } = useThree();
  const [el] = React9.useState(() => document.createElement("div"));
  const [fill] = React9.useState(() => document.createElement("div"));
  const [fixed] = React9.useState(() => document.createElement("div"));
  const target2 = gl.domElement.parentNode;
  const scroll = React9.useRef(0);
  const state = React9.useMemo(() => {
    const state2 = {
      el,
      eps: eps2,
      fill,
      fixed,
      horizontal,
      damping,
      offset: 0,
      delta: 0,
      scroll,
      pages,
      // 0-1 for a range between from -> from + distance
      range(from, distance4, margin = 0) {
        const start = from - margin;
        const end = start + distance4 + margin * 2;
        return this.offset < start ? 0 : this.offset > end ? 1 : (this.offset - start) / (end - start);
      },
      // 0-1-0 for a range between from -> from + distance
      curve(from, distance4, margin = 0) {
        return Math.sin(this.range(from, distance4, margin) * Math.PI);
      },
      // true/false for a range between from -> from + distance
      visible(from, distance4, margin = 0) {
        const start = from - margin;
        const end = start + distance4 + margin * 2;
        return this.offset >= start && this.offset <= end;
      }
    };
    return state2;
  }, [eps2, damping, horizontal, pages]);
  React9.useEffect(() => {
    el.style.position = "absolute";
    el.style.width = "100%";
    el.style.height = "100%";
    el.style[horizontal ? "overflowX" : "overflowY"] = "auto";
    el.style[horizontal ? "overflowY" : "overflowX"] = "hidden";
    el.style.top = "0px";
    el.style.left = "0px";
    for (const key in style) {
      el.style[key] = style[key];
    }
    fixed.style.position = "sticky";
    fixed.style.top = "0px";
    fixed.style.left = "0px";
    fixed.style.width = "100%";
    fixed.style.height = "100%";
    fixed.style.overflow = "hidden";
    el.appendChild(fixed);
    fill.style.height = horizontal ? "100%" : `${pages * distance3 * 100}%`;
    fill.style.width = horizontal ? `${pages * distance3 * 100}%` : "100%";
    fill.style.pointerEvents = "none";
    el.appendChild(fill);
    if (prepend) target2.prepend(el);
    else target2.appendChild(el);
    el[horizontal ? "scrollLeft" : "scrollTop"] = 1;
    const oldTarget = events.connected || gl.domElement;
    requestAnimationFrame(() => events.connect == null ? void 0 : events.connect(el));
    const oldCompute = get().events.compute;
    setEvents({
      compute(event, state2) {
        const {
          left,
          top
        } = target2.getBoundingClientRect();
        const offsetX = event.clientX - left;
        const offsetY = event.clientY - top;
        state2.pointer.set(offsetX / state2.size.width * 2 - 1, -(offsetY / state2.size.height) * 2 + 1);
        state2.raycaster.setFromCamera(state2.pointer, state2.camera);
      }
    });
    return () => {
      target2.removeChild(el);
      setEvents({
        compute: oldCompute
      });
      events.connect == null || events.connect(oldTarget);
    };
  }, [pages, distance3, horizontal, el, fill, fixed, target2]);
  React9.useEffect(() => {
    if (events.connected === el) {
      const containerLength = size2[horizontal ? "width" : "height"];
      const scrollLength = el[horizontal ? "scrollWidth" : "scrollHeight"];
      const scrollThreshold = scrollLength - containerLength;
      let current = 0;
      let disableScroll = true;
      let firstRun = true;
      const onScroll = () => {
        if (!enabled || firstRun) return;
        invalidate();
        current = el[horizontal ? "scrollLeft" : "scrollTop"];
        scroll.current = current / scrollThreshold;
        if (infinite) {
          if (!disableScroll) {
            if (current >= scrollThreshold) {
              const damp5 = 1 - state.offset;
              el[horizontal ? "scrollLeft" : "scrollTop"] = 1;
              scroll.current = state.offset = -damp5;
              disableScroll = true;
            } else if (current <= 0) {
              const damp5 = 1 + state.offset;
              el[horizontal ? "scrollLeft" : "scrollTop"] = scrollLength;
              scroll.current = state.offset = damp5;
              disableScroll = true;
            }
          }
          if (disableScroll) setTimeout(() => disableScroll = false, 40);
        }
      };
      el.addEventListener("scroll", onScroll, {
        passive: true
      });
      requestAnimationFrame(() => firstRun = false);
      const onWheel = (e2) => el.scrollLeft += e2.deltaY / 2;
      if (horizontal) el.addEventListener("wheel", onWheel, {
        passive: true
      });
      return () => {
        el.removeEventListener("scroll", onScroll);
        if (horizontal) el.removeEventListener("wheel", onWheel);
      };
    }
  }, [el, events, size2, infinite, state, invalidate, horizontal, enabled]);
  let last = 0;
  useFrame((_, delta) => {
    last = state.offset;
    easing.damp(state, "offset", scroll.current, damping, delta, maxSpeed, void 0, eps2);
    easing.damp(state, "delta", Math.abs(last - state.offset), damping, delta, maxSpeed, void 0, eps2);
    if (state.delta > eps2) invalidate();
  });
  return React9.createElement(context2.Provider, {
    value: state
  }, children);
}
var ScrollCanvas = React9.forwardRef(({
  children
}, ref) => {
  const group = React9.useRef(null);
  React9.useImperativeHandle(ref, () => group.current, []);
  const state = useScroll();
  const {
    width,
    height
  } = useThree((state2) => state2.viewport);
  useFrame(() => {
    group.current.position.x = state.horizontal ? -width * (state.pages - 1) * state.offset : 0;
    group.current.position.y = state.horizontal ? 0 : height * (state.pages - 1) * state.offset;
  });
  return React9.createElement("group", {
    ref: group
  }, children);
});
var ScrollHtml = React9.forwardRef(({
  children,
  style,
  ...props
}, ref) => {
  const state = useScroll();
  const group = React9.useRef(null);
  React9.useImperativeHandle(ref, () => group.current, []);
  const {
    width,
    height
  } = useThree((state2) => state2.size);
  const fiberState = React9.useContext(context);
  const root = React9.useMemo(() => ReactDOM2.createRoot(state.fixed), [state.fixed]);
  useFrame(() => {
    if (state.delta > state.eps) {
      group.current.style.transform = `translate3d(${state.horizontal ? -width * (state.pages - 1) * state.offset : 0}px,${state.horizontal ? 0 : height * (state.pages - 1) * -state.offset}px,0)`;
    }
  });
  root.render(React9.createElement("div", _extends({
    ref: group,
    style: {
      ...style,
      position: "absolute",
      top: 0,
      left: 0,
      willChange: "transform"
    }
  }, props), React9.createElement(context2.Provider, {
    value: state
  }, React9.createElement(context.Provider, {
    value: fiberState
  }, children))));
  return null;
});
var Scroll = React9.forwardRef(({
  html,
  ...props
}, ref) => {
  const El = html ? ScrollHtml : ScrollCanvas;
  return React9.createElement(El, _extends({
    ref
  }, props));
});

// node_modules/@react-three/drei/web/PresentationControls.js
var React10 = __toESM(require_react());
function PresentationControls({
  enabled = true,
  snap,
  global: global2,
  domElement,
  cursor = true,
  children,
  speed = 1,
  rotation: rotation3 = [0, 0, 0],
  zoom = 1,
  polar = [0, Math.PI / 2],
  azimuth = [-Infinity, Infinity],
  damping = 0.25
}) {
  const events = useThree((state) => state.events);
  const gl = useThree((state) => state.gl);
  const explDomElement = domElement || events.connected || gl.domElement;
  const {
    size: size2
  } = useThree();
  const rPolar = React10.useMemo(() => [rotation3[0] + polar[0], rotation3[0] + polar[1]], [rotation3[0], polar[0], polar[1]]);
  const rAzimuth = React10.useMemo(() => [rotation3[1] + azimuth[0], rotation3[1] + azimuth[1]], [rotation3[1], azimuth[0], azimuth[1]]);
  const rInitial = React10.useMemo(() => [MathUtils.clamp(rotation3[0], ...rPolar), MathUtils.clamp(rotation3[1], ...rAzimuth), rotation3[2]], [rotation3[0], rotation3[1], rotation3[2], rPolar, rAzimuth]);
  React10.useEffect(() => {
    if (global2 && cursor && enabled) {
      explDomElement.style.cursor = "grab";
      gl.domElement.style.cursor = "";
      return () => {
        explDomElement.style.cursor = "default";
        gl.domElement.style.cursor = "default";
      };
    }
  }, [global2, cursor, explDomElement, enabled]);
  const [animation] = React10.useState({
    scale: 1,
    rotation: rInitial,
    damping
  });
  const ref = React10.useRef(null);
  useFrame((state, delta) => {
    easing.damp3(ref.current.scale, animation.scale, animation.damping, delta);
    easing.dampE(ref.current.rotation, animation.rotation, animation.damping, delta);
  });
  const bind = useGesture({
    onHover: ({
      last
    }) => {
      if (cursor && !global2 && enabled) explDomElement.style.cursor = last ? "auto" : "grab";
    },
    onDrag: ({
      down,
      delta: [x, y],
      memo: [oldY, oldX] = animation.rotation || rInitial
    }) => {
      if (!enabled) return [y, x];
      if (cursor) explDomElement.style.cursor = down ? "grabbing" : "grab";
      x = MathUtils.clamp(oldX + x / size2.width * Math.PI * speed, ...rAzimuth);
      y = MathUtils.clamp(oldY + y / size2.height * Math.PI * speed, ...rPolar);
      animation.scale = down && y > rPolar[1] / 2 ? zoom : 1;
      animation.rotation = snap && !down ? rInitial : [y, x, 0];
      animation.damping = snap && !down && typeof snap !== "boolean" ? snap : damping;
      return [y, x];
    }
  }, {
    target: global2 ? explDomElement : void 0
  });
  return React10.createElement("group", _extends({
    ref
  }, bind == null ? void 0 : bind()), children);
}

// node_modules/@react-three/drei/web/KeyboardControls.js
var React11 = __toESM(require_react());

// node_modules/zustand/esm/middleware.mjs
var subscribeWithSelectorImpl = (fn) => (set, get, api) => {
  const origSubscribe = api.subscribe;
  api.subscribe = ((selector, optListener, options) => {
    let listener = selector;
    if (optListener) {
      const equalityFn = (options == null ? void 0 : options.equalityFn) || Object.is;
      let currentSlice = selector(api.getState());
      listener = (state) => {
        const nextSlice = selector(state);
        if (!equalityFn(currentSlice, nextSlice)) {
          const previousSlice = currentSlice;
          optListener(currentSlice = nextSlice, previousSlice);
        }
      };
      if (options == null ? void 0 : options.fireImmediately) {
        optListener(currentSlice, currentSlice);
      }
    }
    return origSubscribe(listener);
  });
  const initialState = fn(set, get, api);
  return initialState;
};
var subscribeWithSelector = subscribeWithSelectorImpl;

// node_modules/@react-three/drei/web/KeyboardControls.js
var context3 = React11.createContext(null);
function KeyboardControls({
  map: map2,
  children,
  onChange,
  domElement
}) {
  const key = map2.map((item) => item.name + item.keys).join("-");
  const useControls = React11.useMemo(() => {
    return create(subscribeWithSelector(() => map2.reduce((prev, cur) => ({
      ...prev,
      [cur.name]: false
    }), {})));
  }, [key]);
  const api = React11.useMemo(() => [useControls.subscribe, useControls.getState, useControls], [key]);
  const set = useControls.setState;
  React11.useEffect(() => {
    const config = map2.map(({
      name,
      keys,
      up
    }) => ({
      keys,
      up,
      fn: (value) => {
        set({
          [name]: value
        });
        if (onChange) onChange(name, value, api[1]());
      }
    }));
    const keyMap = config.reduce((out7, {
      keys,
      fn,
      up = true
    }) => {
      keys.forEach((key2) => out7[key2] = {
        fn,
        pressed: false,
        up
      });
      return out7;
    }, {});
    const downHandler = ({
      key: key2,
      code
    }) => {
      const obj = keyMap[key2] || keyMap[code];
      if (!obj) return;
      const {
        fn,
        pressed,
        up
      } = obj;
      obj.pressed = true;
      if (up || !pressed) fn(true);
    };
    const upHandler = ({
      key: key2,
      code
    }) => {
      const obj = keyMap[key2] || keyMap[code];
      if (!obj) return;
      const {
        fn,
        up
      } = obj;
      obj.pressed = false;
      if (up) fn(false);
    };
    const source = domElement || window;
    source.addEventListener("keydown", downHandler, {
      passive: true
    });
    source.addEventListener("keyup", upHandler, {
      passive: true
    });
    return () => {
      source.removeEventListener("keydown", downHandler);
      source.removeEventListener("keyup", upHandler);
    };
  }, [domElement, key]);
  return React11.createElement(context3.Provider, {
    value: api,
    children
  });
}
function useKeyboardControls(sel) {
  const [sub3, get, store] = React11.useContext(context3);
  if (sel) return store(sel);
  else return [sub3, get];
}

// node_modules/@react-three/drei/web/Select.js
var React13 = __toESM(require_react());

// node_modules/three-stdlib/math/ConvexHull.js
var _v1 = new Vector3();
var _line3 = new Line3();
var _plane = new Plane();
var _closestPoint = new Vector3();
var _triangle = new Triangle();

// node_modules/three-stdlib/misc/ConvexObjectBreaker.js
var _v12 = new Vector3();

// node_modules/three-stdlib/misc/Gyroscope.js
var _translationObject = new Vector3();
var _quaternionObject = new Quaternion();
var _scaleObject = new Vector3();
var _translationWorld = new Vector3();
var _quaternionWorld = new Quaternion();
var _scaleWorld = new Vector3();

// node_modules/three-stdlib/_polyfill/constants.js
var version = (() => parseInt(REVISION.replace(/\D+/g, "")))();

// node_modules/three-stdlib/_polyfill/uv1.js
var UV1 = version >= 125 ? "uv1" : "uv2";

// node_modules/three-stdlib/renderers/CSS2DRenderer.js
var _vector = new Vector3();
var _viewMatrix = new Matrix4();
var _viewProjectionMatrix = new Matrix4();
var _a = new Vector3();
var _b = new Vector3();

// node_modules/three-stdlib/renderers/CSS3DRenderer.js
var _position2 = new Vector3();
var _quaternion = new Quaternion();
var _scale = new Vector3();
var _matrix = new Matrix4();
var _matrix2 = new Matrix4();

// node_modules/three-stdlib/modifiers/CurveModifier.js
var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField2 = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var CHANNELS = 4;
var TEXTURE_WIDTH = 1024;
var TEXTURE_HEIGHT = 4;
var initSplineTexture = (numberOfCurves = 1) => {
  const dataArray2 = new Float32Array(TEXTURE_WIDTH * TEXTURE_HEIGHT * numberOfCurves * CHANNELS);
  const dataTexture = new DataTexture(dataArray2, TEXTURE_WIDTH, TEXTURE_HEIGHT * numberOfCurves, RGBAFormat, FloatType);
  dataTexture.wrapS = RepeatWrapping;
  dataTexture.wrapT = RepeatWrapping;
  dataTexture.magFilter = NearestFilter;
  dataTexture.needsUpdate = true;
  return dataTexture;
};
var updateSplineTexture = (texture, splineCurve, offset = 0) => {
  const numberOfPoints = Math.floor(TEXTURE_WIDTH * (TEXTURE_HEIGHT / 4));
  splineCurve.arcLengthDivisions = numberOfPoints / 2;
  splineCurve.updateArcLengths();
  const points = splineCurve.getSpacedPoints(numberOfPoints);
  const frenetFrames = splineCurve.computeFrenetFrames(numberOfPoints, true);
  for (let i4 = 0; i4 < numberOfPoints; i4++) {
    const rowOffset = Math.floor(i4 / TEXTURE_WIDTH);
    const rowIndex = i4 % TEXTURE_WIDTH;
    let pt = points[i4];
    setTextureValue(texture, rowIndex, pt.x, pt.y, pt.z, 0 + rowOffset + TEXTURE_HEIGHT * offset);
    pt = frenetFrames.tangents[i4];
    setTextureValue(texture, rowIndex, pt.x, pt.y, pt.z, 1 + rowOffset + TEXTURE_HEIGHT * offset);
    pt = frenetFrames.normals[i4];
    setTextureValue(texture, rowIndex, pt.x, pt.y, pt.z, 2 + rowOffset + TEXTURE_HEIGHT * offset);
    pt = frenetFrames.binormals[i4];
    setTextureValue(texture, rowIndex, pt.x, pt.y, pt.z, 3 + rowOffset + TEXTURE_HEIGHT * offset);
  }
  texture.needsUpdate = true;
};
var setTextureValue = (texture, index2, x, y, z, o2) => {
  const image = texture.image;
  const { data } = image;
  const i4 = CHANNELS * TEXTURE_WIDTH * o2;
  data[index2 * CHANNELS + i4 + 0] = x;
  data[index2 * CHANNELS + i4 + 1] = y;
  data[index2 * CHANNELS + i4 + 2] = z;
  data[index2 * CHANNELS + i4 + 3] = 1;
};
var getUniforms = (splineTexture) => ({
  spineTexture: { value: splineTexture },
  pathOffset: { type: "f", value: 0 },
  // time of path curve
  pathSegment: { type: "f", value: 1 },
  // fractional length of path
  spineOffset: { type: "f", value: 161 },
  spineLength: { type: "f", value: 400 },
  flow: { type: "i", value: 1 }
});
function modifyShader(material, uniforms, numberOfCurves = 1) {
  if (material.__ok)
    return;
  material.__ok = true;
  material.onBeforeCompile = (shader) => {
    if (shader.__modified)
      return;
    shader.__modified = true;
    Object.assign(shader.uniforms, uniforms);
    const vertexShader3 = (
      /* glsl */
      `
		uniform sampler2D spineTexture;
		uniform float pathOffset;
		uniform float pathSegment;
		uniform float spineOffset;
		uniform float spineLength;
		uniform int flow;

		float textureLayers = ${TEXTURE_HEIGHT * numberOfCurves}.;
		float textureStacks = ${TEXTURE_HEIGHT / 4}.;

		${shader.vertexShader}
		`.replace("#include <beginnormal_vertex>", "").replace("#include <defaultnormal_vertex>", "").replace("#include <begin_vertex>", "").replace(
        /void\s*main\s*\(\)\s*\{/,
        /* glsl */
        `
        void main() {
        #include <beginnormal_vertex>

        vec4 worldPos = modelMatrix * vec4(position, 1.);

        bool bend = flow > 0;
        float xWeight = bend ? 0. : 1.;

        #ifdef USE_INSTANCING
        float pathOffsetFromInstanceMatrix = instanceMatrix[3][2];
        float spineLengthFromInstanceMatrix = instanceMatrix[3][0];
        float spinePortion = bend ? (worldPos.x + spineOffset) / spineLengthFromInstanceMatrix : 0.;
        float mt = (spinePortion * pathSegment + pathOffset + pathOffsetFromInstanceMatrix)*textureStacks;
        #else
        float spinePortion = bend ? (worldPos.x + spineOffset) / spineLength : 0.;
        float mt = (spinePortion * pathSegment + pathOffset)*textureStacks;
        #endif

        mt = mod(mt, textureStacks);
        float rowOffset = floor(mt);

        #ifdef USE_INSTANCING
        rowOffset += instanceMatrix[3][1] * ${TEXTURE_HEIGHT}.;
        #endif

        vec3 spinePos = texture2D(spineTexture, vec2(mt, (0. + rowOffset + 0.5) / textureLayers)).xyz;
        vec3 a =        texture2D(spineTexture, vec2(mt, (1. + rowOffset + 0.5) / textureLayers)).xyz;
        vec3 b =        texture2D(spineTexture, vec2(mt, (2. + rowOffset + 0.5) / textureLayers)).xyz;
        vec3 c =        texture2D(spineTexture, vec2(mt, (3. + rowOffset + 0.5) / textureLayers)).xyz;
        mat3 basis = mat3(a, b, c);

        vec3 transformed = basis
          * vec3(worldPos.x * xWeight, worldPos.y * 1., worldPos.z * 1.)
          + spinePos;

        vec3 transformedNormal = normalMatrix * (basis * objectNormal);
			`
      ).replace(
        "#include <project_vertex>",
        /* glsl */
        `vec4 mvPosition = modelViewMatrix * vec4( transformed, 1.0 );
				gl_Position = projectionMatrix * mvPosition;`
      )
    );
    shader.vertexShader = vertexShader3;
  };
}
var Flow = class {
  /**
   * @param {Mesh} mesh The mesh to clone and modify to bend around the curve
   * @param {number} numberOfCurves The amount of space that should preallocated for additional curves
   */
  constructor(mesh, numberOfCurves = 1) {
    __publicField2(this, "curveArray");
    __publicField2(this, "curveLengthArray");
    __publicField2(this, "object3D");
    __publicField2(this, "splineTexure");
    __publicField2(this, "uniforms");
    const obj3D = mesh.clone();
    const splineTexure = initSplineTexture(numberOfCurves);
    const uniforms = getUniforms(splineTexure);
    obj3D.traverse((child) => {
      if (child instanceof Mesh || child instanceof InstancedMesh) {
        child.material = child.material.clone();
        modifyShader(child.material, uniforms, numberOfCurves);
      }
    });
    this.curveArray = new Array(numberOfCurves);
    this.curveLengthArray = new Array(numberOfCurves);
    this.object3D = obj3D;
    this.splineTexure = splineTexure;
    this.uniforms = uniforms;
  }
  updateCurve(index2, curve) {
    if (index2 >= this.curveArray.length)
      throw Error("Index out of range for Flow");
    const curveLength = curve.getLength();
    this.uniforms.spineLength.value = curveLength;
    this.curveLengthArray[index2] = curveLength;
    this.curveArray[index2] = curve;
    updateSplineTexture(this.splineTexure, curve, index2);
  }
  moveAlongCurve(amount) {
    this.uniforms.pathOffset.value += amount;
  }
};
var matrix2 = new Matrix4();

// node_modules/three-stdlib/utils/BufferGeometryUtils.js
function mergeVertices(geometry3, tolerance = 1e-4) {
  tolerance = Math.max(tolerance, Number.EPSILON);
  const hashToIndex = {};
  const indices = geometry3.getIndex();
  const positions = geometry3.getAttribute("position");
  const vertexCount = indices ? indices.count : positions.count;
  let nextIndex = 0;
  const attributeNames = Object.keys(geometry3.attributes);
  const attrArrays = {};
  const morphAttrsArrays = {};
  const newIndices = [];
  const getters = ["getX", "getY", "getZ", "getW"];
  for (let i4 = 0, l2 = attributeNames.length; i4 < l2; i4++) {
    const name = attributeNames[i4];
    attrArrays[name] = [];
    const morphAttr = geometry3.morphAttributes[name];
    if (morphAttr) {
      morphAttrsArrays[name] = new Array(morphAttr.length).fill(0).map(() => []);
    }
  }
  const decimalShift = Math.log10(1 / tolerance);
  const shiftMultiplier = Math.pow(10, decimalShift);
  for (let i4 = 0; i4 < vertexCount; i4++) {
    const index2 = indices ? indices.getX(i4) : i4;
    let hash = "";
    for (let j = 0, l2 = attributeNames.length; j < l2; j++) {
      const name = attributeNames[j];
      const attribute = geometry3.getAttribute(name);
      const itemSize = attribute.itemSize;
      for (let k = 0; k < itemSize; k++) {
        hash += `${~~(attribute[getters[k]](index2) * shiftMultiplier)},`;
      }
    }
    if (hash in hashToIndex) {
      newIndices.push(hashToIndex[hash]);
    } else {
      for (let j = 0, l2 = attributeNames.length; j < l2; j++) {
        const name = attributeNames[j];
        const attribute = geometry3.getAttribute(name);
        const morphAttr = geometry3.morphAttributes[name];
        const itemSize = attribute.itemSize;
        const newarray = attrArrays[name];
        const newMorphArrays = morphAttrsArrays[name];
        for (let k = 0; k < itemSize; k++) {
          const getterFunc = getters[k];
          newarray.push(attribute[getterFunc](index2));
          if (morphAttr) {
            for (let m = 0, ml = morphAttr.length; m < ml; m++) {
              newMorphArrays[m].push(morphAttr[m][getterFunc](index2));
            }
          }
        }
      }
      hashToIndex[hash] = nextIndex;
      newIndices.push(nextIndex);
      nextIndex++;
    }
  }
  const result = geometry3.clone();
  for (let i4 = 0, l2 = attributeNames.length; i4 < l2; i4++) {
    const name = attributeNames[i4];
    const oldAttribute = geometry3.getAttribute(name);
    const buffer2 = new oldAttribute.array.constructor(attrArrays[name]);
    const attribute = new BufferAttribute(buffer2, oldAttribute.itemSize, oldAttribute.normalized);
    result.setAttribute(name, attribute);
    if (name in morphAttrsArrays) {
      for (let j = 0; j < morphAttrsArrays[name].length; j++) {
        const oldMorphAttribute = geometry3.morphAttributes[name][j];
        const buffer22 = new oldMorphAttribute.array.constructor(morphAttrsArrays[name][j]);
        const morphAttribute = new BufferAttribute(buffer22, oldMorphAttribute.itemSize, oldMorphAttribute.normalized);
        result.morphAttributes[name][j] = morphAttribute;
      }
    }
  }
  result.setIndex(newIndices);
  return result;
}
function toTrianglesDrawMode(geometry3, drawMode) {
  if (drawMode === TrianglesDrawMode) {
    console.warn("THREE.BufferGeometryUtils.toTrianglesDrawMode(): Geometry already defined as triangles.");
    return geometry3;
  }
  if (drawMode === TriangleFanDrawMode || drawMode === TriangleStripDrawMode) {
    let index2 = geometry3.getIndex();
    if (index2 === null) {
      const indices = [];
      const position2 = geometry3.getAttribute("position");
      if (position2 !== void 0) {
        for (let i4 = 0; i4 < position2.count; i4++) {
          indices.push(i4);
        }
        geometry3.setIndex(indices);
        index2 = geometry3.getIndex();
      } else {
        console.error(
          "THREE.BufferGeometryUtils.toTrianglesDrawMode(): Undefined position attribute. Processing not possible."
        );
        return geometry3;
      }
    }
    const numberOfTriangles = index2.count - 2;
    const newIndices = [];
    if (index2) {
      if (drawMode === TriangleFanDrawMode) {
        for (let i4 = 1; i4 <= numberOfTriangles; i4++) {
          newIndices.push(index2.getX(0));
          newIndices.push(index2.getX(i4));
          newIndices.push(index2.getX(i4 + 1));
        }
      } else {
        for (let i4 = 0; i4 < numberOfTriangles; i4++) {
          if (i4 % 2 === 0) {
            newIndices.push(index2.getX(i4));
            newIndices.push(index2.getX(i4 + 1));
            newIndices.push(index2.getX(i4 + 2));
          } else {
            newIndices.push(index2.getX(i4 + 2));
            newIndices.push(index2.getX(i4 + 1));
            newIndices.push(index2.getX(i4));
          }
        }
      }
    }
    if (newIndices.length / 3 !== numberOfTriangles) {
      console.error("THREE.BufferGeometryUtils.toTrianglesDrawMode(): Unable to generate correct amount of triangles.");
    }
    const newGeometry = geometry3.clone();
    newGeometry.setIndex(newIndices);
    newGeometry.clearGroups();
    return newGeometry;
  } else {
    console.error("THREE.BufferGeometryUtils.toTrianglesDrawMode(): Unknown draw mode:", drawMode);
    return geometry3;
  }
}
function toCreasedNormals(geometry3, creaseAngle = Math.PI / 3) {
  const creaseDot = Math.cos(creaseAngle);
  const hashMultiplier = (1 + 1e-10) * 100;
  const verts = [new Vector3(), new Vector3(), new Vector3()];
  const tempVec1 = new Vector3();
  const tempVec2 = new Vector3();
  const tempNorm = new Vector3();
  const tempNorm2 = new Vector3();
  function hashVertex(v5) {
    const x = ~~(v5.x * hashMultiplier);
    const y = ~~(v5.y * hashMultiplier);
    const z = ~~(v5.z * hashMultiplier);
    return `${x},${y},${z}`;
  }
  const resultGeometry = geometry3.index ? geometry3.toNonIndexed() : geometry3;
  const posAttr = resultGeometry.attributes.position;
  const vertexMap = {};
  for (let i4 = 0, l2 = posAttr.count / 3; i4 < l2; i4++) {
    const i32 = 3 * i4;
    const a6 = verts[0].fromBufferAttribute(posAttr, i32 + 0);
    const b5 = verts[1].fromBufferAttribute(posAttr, i32 + 1);
    const c2 = verts[2].fromBufferAttribute(posAttr, i32 + 2);
    tempVec1.subVectors(c2, b5);
    tempVec2.subVectors(a6, b5);
    const normal2 = new Vector3().crossVectors(tempVec1, tempVec2).normalize();
    for (let n2 = 0; n2 < 3; n2++) {
      const vert = verts[n2];
      const hash = hashVertex(vert);
      if (!(hash in vertexMap)) {
        vertexMap[hash] = [];
      }
      vertexMap[hash].push(normal2);
    }
  }
  const normalArray = new Float32Array(posAttr.count * 3);
  const normAttr = new BufferAttribute(normalArray, 3, false);
  for (let i4 = 0, l2 = posAttr.count / 3; i4 < l2; i4++) {
    const i32 = 3 * i4;
    const a6 = verts[0].fromBufferAttribute(posAttr, i32 + 0);
    const b5 = verts[1].fromBufferAttribute(posAttr, i32 + 1);
    const c2 = verts[2].fromBufferAttribute(posAttr, i32 + 2);
    tempVec1.subVectors(c2, b5);
    tempVec2.subVectors(a6, b5);
    tempNorm.crossVectors(tempVec1, tempVec2).normalize();
    for (let n2 = 0; n2 < 3; n2++) {
      const vert = verts[n2];
      const hash = hashVertex(vert);
      const otherNormals = vertexMap[hash];
      tempNorm2.set(0, 0, 0);
      for (let k = 0, lk = otherNormals.length; k < lk; k++) {
        const otherNorm = otherNormals[k];
        if (tempNorm.dot(otherNorm) > creaseDot) {
          tempNorm2.add(otherNorm);
        }
      }
      tempNorm2.normalize();
      normAttr.setXYZ(i32 + n2, tempNorm2.x, tempNorm2.y, tempNorm2.z);
    }
  }
  resultGeometry.setAttribute("normal", normAttr);
  return resultGeometry;
}

// node_modules/three-stdlib/modifiers/SimplifyModifier.js
var cb = new Vector3();
var ab = new Vector3();

// node_modules/three-stdlib/exporters/GLTFExporter.js
var __defProp2 = Object.defineProperty;
var __defNormalProp2 = (obj, key, value) => key in obj ? __defProp2(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField3 = (obj, key, value) => {
  __defNormalProp2(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
async function readAsDataURL(blob) {
  const buffer2 = await blob.arrayBuffer();
  const data = btoa(String.fromCharCode(...new Uint8Array(buffer2)));
  return `data:${blob.type || ""};base64,${data}`;
}
var _renderer;
var fullscreenQuadGeometry;
var fullscreenQuadMaterial;
var fullscreenQuad;
function decompress(texture, maxTextureSize = Infinity, renderer = null) {
  if (!fullscreenQuadGeometry)
    fullscreenQuadGeometry = new PlaneGeometry(2, 2, 1, 1);
  if (!fullscreenQuadMaterial)
    fullscreenQuadMaterial = new ShaderMaterial({
      uniforms: { blitTexture: new Uniform(texture) },
      vertexShader: (
        /* glsl */
        `
        varying vec2 vUv;
        void main(){
            vUv = uv;
            gl_Position = vec4(position.xy * 1.0,0.,.999999);
        }
      `
      ),
      fragmentShader: (
        /* glsl */
        `
          uniform sampler2D blitTexture; 
          varying vec2 vUv;

          void main(){ 
              gl_FragColor = vec4(vUv.xy, 0, 1);
              
              #ifdef IS_SRGB
              gl_FragColor = LinearTosRGB( texture2D( blitTexture, vUv) );
              #else
              gl_FragColor = texture2D( blitTexture, vUv);
              #endif
          }
      `
      )
    });
  fullscreenQuadMaterial.uniforms.blitTexture.value = texture;
  fullscreenQuadMaterial.defines.IS_SRGB = "colorSpace" in texture ? texture.colorSpace === "srgb" : texture.encoding === 3001;
  fullscreenQuadMaterial.needsUpdate = true;
  if (!fullscreenQuad) {
    fullscreenQuad = new Mesh(fullscreenQuadGeometry, fullscreenQuadMaterial);
    fullscreenQuad.frustrumCulled = false;
  }
  const _camera = new PerspectiveCamera();
  const _scene = new Scene();
  _scene.add(fullscreenQuad);
  if (!renderer) {
    renderer = _renderer = new WebGLRenderer({ antialias: false });
  }
  renderer.setSize(Math.min(texture.image.width, maxTextureSize), Math.min(texture.image.height, maxTextureSize));
  renderer.clear();
  renderer.render(_scene, _camera);
  const readableTexture = new Texture(renderer.domElement);
  readableTexture.minFilter = texture.minFilter;
  readableTexture.magFilter = texture.magFilter;
  readableTexture.wrapS = texture.wrapS;
  readableTexture.wrapT = texture.wrapT;
  readableTexture.name = texture.name;
  if (_renderer) {
    _renderer.dispose();
    _renderer = null;
  }
  return readableTexture;
}
var KHR_mesh_quantization_ExtraAttrTypes = {
  POSITION: [
    "byte",
    "byte normalized",
    "unsigned byte",
    "unsigned byte normalized",
    "short",
    "short normalized",
    "unsigned short",
    "unsigned short normalized"
  ],
  NORMAL: ["byte normalized", "short normalized"],
  TANGENT: ["byte normalized", "short normalized"],
  TEXCOORD: ["byte", "byte normalized", "unsigned byte", "short", "short normalized", "unsigned short"]
};
var GLTFExporter = (() => {
  class GLTFExporter2 {
    constructor() {
      this.pluginCallbacks = [];
      this.register(function(writer) {
        return new GLTFLightExtension(writer);
      });
      this.register(function(writer) {
        return new GLTFMaterialsUnlitExtension(writer);
      });
      this.register(function(writer) {
        return new GLTFMaterialsTransmissionExtension(writer);
      });
      this.register(function(writer) {
        return new GLTFMaterialsVolumeExtension(writer);
      });
      this.register(function(writer) {
        return new GLTFMaterialsIorExtension(writer);
      });
      this.register(function(writer) {
        return new GLTFMaterialsSpecularExtension(writer);
      });
      this.register(function(writer) {
        return new GLTFMaterialsClearcoatExtension(writer);
      });
      this.register(function(writer) {
        return new GLTFMaterialsIridescenceExtension(writer);
      });
      this.register(function(writer) {
        return new GLTFMaterialsSheenExtension(writer);
      });
      this.register(function(writer) {
        return new GLTFMaterialsAnisotropyExtension(writer);
      });
      this.register(function(writer) {
        return new GLTFMaterialsEmissiveStrengthExtension(writer);
      });
    }
    register(callback) {
      if (this.pluginCallbacks.indexOf(callback) === -1) {
        this.pluginCallbacks.push(callback);
      }
      return this;
    }
    unregister(callback) {
      if (this.pluginCallbacks.indexOf(callback) !== -1) {
        this.pluginCallbacks.splice(this.pluginCallbacks.indexOf(callback), 1);
      }
      return this;
    }
    /**
     * Parse scenes and generate GLTF output
     * @param  {Scene or [THREE.Scenes]} input   Scene or Array of THREE.Scenes
     * @param  {Function} onDone  Callback on completed
     * @param  {Function} onError  Callback on errors
     * @param  {Object} options options
     */
    parse(input, onDone, onError, options) {
      const writer = new GLTFWriter();
      const plugins = [];
      for (let i4 = 0, il = this.pluginCallbacks.length; i4 < il; i4++) {
        plugins.push(this.pluginCallbacks[i4](writer));
      }
      writer.setPlugins(plugins);
      writer.write(input, onDone, options).catch(onError);
    }
    parseAsync(input, options) {
      const scope = this;
      return new Promise(function(resolve, reject) {
        scope.parse(input, resolve, reject, options);
      });
    }
  }
  __publicField3(GLTFExporter2, "Utils", {
    insertKeyframe: function(track, time) {
      const tolerance = 1e-3;
      const valueSize = track.getValueSize();
      const times = new track.TimeBufferType(track.times.length + 1);
      const values = new track.ValueBufferType(track.values.length + valueSize);
      const interpolant = track.createInterpolant(new track.ValueBufferType(valueSize));
      let index2;
      if (track.times.length === 0) {
        times[0] = time;
        for (let i4 = 0; i4 < valueSize; i4++) {
          values[i4] = 0;
        }
        index2 = 0;
      } else if (time < track.times[0]) {
        if (Math.abs(track.times[0] - time) < tolerance)
          return 0;
        times[0] = time;
        times.set(track.times, 1);
        values.set(interpolant.evaluate(time), 0);
        values.set(track.values, valueSize);
        index2 = 0;
      } else if (time > track.times[track.times.length - 1]) {
        if (Math.abs(track.times[track.times.length - 1] - time) < tolerance) {
          return track.times.length - 1;
        }
        times[times.length - 1] = time;
        times.set(track.times, 0);
        values.set(track.values, 0);
        values.set(interpolant.evaluate(time), track.values.length);
        index2 = times.length - 1;
      } else {
        for (let i4 = 0; i4 < track.times.length; i4++) {
          if (Math.abs(track.times[i4] - time) < tolerance)
            return i4;
          if (track.times[i4] < time && track.times[i4 + 1] > time) {
            times.set(track.times.slice(0, i4 + 1), 0);
            times[i4 + 1] = time;
            times.set(track.times.slice(i4 + 1), i4 + 2);
            values.set(track.values.slice(0, (i4 + 1) * valueSize), 0);
            values.set(interpolant.evaluate(time), (i4 + 1) * valueSize);
            values.set(track.values.slice((i4 + 1) * valueSize), (i4 + 2) * valueSize);
            index2 = i4 + 1;
            break;
          }
        }
      }
      track.times = times;
      track.values = values;
      return index2;
    },
    mergeMorphTargetTracks: function(clip, root) {
      const tracks = [];
      const mergedTracks = {};
      const sourceTracks = clip.tracks;
      for (let i4 = 0; i4 < sourceTracks.length; ++i4) {
        let sourceTrack = sourceTracks[i4];
        const sourceTrackBinding = PropertyBinding.parseTrackName(sourceTrack.name);
        const sourceTrackNode = PropertyBinding.findNode(root, sourceTrackBinding.nodeName);
        if (sourceTrackBinding.propertyName !== "morphTargetInfluences" || sourceTrackBinding.propertyIndex === void 0) {
          tracks.push(sourceTrack);
          continue;
        }
        if (sourceTrack.createInterpolant !== sourceTrack.InterpolantFactoryMethodDiscrete && sourceTrack.createInterpolant !== sourceTrack.InterpolantFactoryMethodLinear) {
          if (sourceTrack.createInterpolant.isInterpolantFactoryMethodGLTFCubicSpline) {
            throw new Error("THREE.GLTFExporter: Cannot merge tracks with glTF CUBICSPLINE interpolation.");
          }
          console.warn("THREE.GLTFExporter: Morph target interpolation mode not yet supported. Using LINEAR instead.");
          sourceTrack = sourceTrack.clone();
          sourceTrack.setInterpolation(InterpolateLinear);
        }
        const targetCount = sourceTrackNode.morphTargetInfluences.length;
        const targetIndex = sourceTrackNode.morphTargetDictionary[sourceTrackBinding.propertyIndex];
        if (targetIndex === void 0) {
          throw new Error("THREE.GLTFExporter: Morph target name not found: " + sourceTrackBinding.propertyIndex);
        }
        let mergedTrack;
        if (mergedTracks[sourceTrackNode.uuid] === void 0) {
          mergedTrack = sourceTrack.clone();
          const values = new mergedTrack.ValueBufferType(targetCount * mergedTrack.times.length);
          for (let j = 0; j < mergedTrack.times.length; j++) {
            values[j * targetCount + targetIndex] = mergedTrack.values[j];
          }
          mergedTrack.name = (sourceTrackBinding.nodeName || "") + ".morphTargetInfluences";
          mergedTrack.values = values;
          mergedTracks[sourceTrackNode.uuid] = mergedTrack;
          tracks.push(mergedTrack);
          continue;
        }
        const sourceInterpolant = sourceTrack.createInterpolant(new sourceTrack.ValueBufferType(1));
        mergedTrack = mergedTracks[sourceTrackNode.uuid];
        for (let j = 0; j < mergedTrack.times.length; j++) {
          mergedTrack.values[j * targetCount + targetIndex] = sourceInterpolant.evaluate(mergedTrack.times[j]);
        }
        for (let j = 0; j < sourceTrack.times.length; j++) {
          const keyframeIndex = this.insertKeyframe(mergedTrack, sourceTrack.times[j]);
          mergedTrack.values[keyframeIndex * targetCount + targetIndex] = sourceTrack.values[j];
        }
      }
      clip.tracks = tracks;
      return clip;
    }
  });
  return GLTFExporter2;
})();
var WEBGL_CONSTANTS = {
  POINTS: 0,
  LINES: 1,
  LINE_LOOP: 2,
  LINE_STRIP: 3,
  TRIANGLES: 4,
  TRIANGLE_STRIP: 5,
  TRIANGLE_FAN: 6,
  BYTE: 5120,
  UNSIGNED_BYTE: 5121,
  SHORT: 5122,
  UNSIGNED_SHORT: 5123,
  INT: 5124,
  UNSIGNED_INT: 5125,
  FLOAT: 5126,
  ARRAY_BUFFER: 34962,
  ELEMENT_ARRAY_BUFFER: 34963,
  NEAREST: 9728,
  LINEAR: 9729,
  NEAREST_MIPMAP_NEAREST: 9984,
  LINEAR_MIPMAP_NEAREST: 9985,
  NEAREST_MIPMAP_LINEAR: 9986,
  LINEAR_MIPMAP_LINEAR: 9987,
  CLAMP_TO_EDGE: 33071,
  MIRRORED_REPEAT: 33648,
  REPEAT: 10497
};
var KHR_MESH_QUANTIZATION = "KHR_mesh_quantization";
var THREE_TO_WEBGL = {};
THREE_TO_WEBGL[NearestFilter] = WEBGL_CONSTANTS.NEAREST;
THREE_TO_WEBGL[NearestMipmapNearestFilter] = WEBGL_CONSTANTS.NEAREST_MIPMAP_NEAREST;
THREE_TO_WEBGL[NearestMipmapLinearFilter] = WEBGL_CONSTANTS.NEAREST_MIPMAP_LINEAR;
THREE_TO_WEBGL[LinearFilter] = WEBGL_CONSTANTS.LINEAR;
THREE_TO_WEBGL[LinearMipmapNearestFilter] = WEBGL_CONSTANTS.LINEAR_MIPMAP_NEAREST;
THREE_TO_WEBGL[LinearMipmapLinearFilter] = WEBGL_CONSTANTS.LINEAR_MIPMAP_LINEAR;
THREE_TO_WEBGL[ClampToEdgeWrapping] = WEBGL_CONSTANTS.CLAMP_TO_EDGE;
THREE_TO_WEBGL[RepeatWrapping] = WEBGL_CONSTANTS.REPEAT;
THREE_TO_WEBGL[MirroredRepeatWrapping] = WEBGL_CONSTANTS.MIRRORED_REPEAT;
var PATH_PROPERTIES = {
  scale: "scale",
  position: "translation",
  quaternion: "rotation",
  morphTargetInfluences: "weights"
};
var DEFAULT_SPECULAR_COLOR = new Color();
var GLB_HEADER_BYTES = 12;
var GLB_HEADER_MAGIC = 1179937895;
var GLB_VERSION = 2;
var GLB_CHUNK_PREFIX_BYTES = 8;
var GLB_CHUNK_TYPE_JSON = 1313821514;
var GLB_CHUNK_TYPE_BIN = 5130562;
function equalArray(array1, array2) {
  return array1.length === array2.length && array1.every(function(element, index2) {
    return element === array2[index2];
  });
}
function stringToArrayBuffer(text) {
  return new TextEncoder().encode(text).buffer;
}
function isIdentityMatrix(matrix6) {
  return equalArray(matrix6.elements, [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]);
}
function getMinMax(attribute, start, count) {
  const output = {
    min: new Array(attribute.itemSize).fill(Number.POSITIVE_INFINITY),
    max: new Array(attribute.itemSize).fill(Number.NEGATIVE_INFINITY)
  };
  for (let i4 = start; i4 < start + count; i4++) {
    for (let a6 = 0; a6 < attribute.itemSize; a6++) {
      let value;
      if (attribute.itemSize > 4) {
        value = attribute.array[i4 * attribute.itemSize + a6];
      } else {
        if (a6 === 0)
          value = attribute.getX(i4);
        else if (a6 === 1)
          value = attribute.getY(i4);
        else if (a6 === 2)
          value = attribute.getZ(i4);
        else if (a6 === 3)
          value = attribute.getW(i4);
        if (attribute.normalized === true) {
          value = MathUtils.normalize(value, attribute.array);
        }
      }
      output.min[a6] = Math.min(output.min[a6], value);
      output.max[a6] = Math.max(output.max[a6], value);
    }
  }
  return output;
}
function getPaddedBufferSize(bufferSize) {
  return Math.ceil(bufferSize / 4) * 4;
}
function getPaddedArrayBuffer(arrayBuffer, paddingByte = 0) {
  const paddedLength = getPaddedBufferSize(arrayBuffer.byteLength);
  if (paddedLength !== arrayBuffer.byteLength) {
    const array = new Uint8Array(paddedLength);
    array.set(new Uint8Array(arrayBuffer));
    if (paddingByte !== 0) {
      for (let i4 = arrayBuffer.byteLength; i4 < paddedLength; i4++) {
        array[i4] = paddingByte;
      }
    }
    return array.buffer;
  }
  return arrayBuffer;
}
function getCanvas() {
  if (typeof document === "undefined" && typeof OffscreenCanvas !== "undefined") {
    return new OffscreenCanvas(1, 1);
  }
  return document.createElement("canvas");
}
function getToBlobPromise(canvas, mimeType) {
  if (canvas.toBlob !== void 0) {
    return new Promise((resolve) => canvas.toBlob(resolve, mimeType));
  }
  let quality;
  if (mimeType === "image/jpeg") {
    quality = 0.92;
  } else if (mimeType === "image/webp") {
    quality = 0.8;
  }
  return canvas.convertToBlob({
    type: mimeType,
    quality
  });
}
var GLTFWriter = class {
  constructor() {
    this.plugins = [];
    this.options = {};
    this.pending = [];
    this.buffers = [];
    this.byteOffset = 0;
    this.buffers = [];
    this.nodeMap = /* @__PURE__ */ new Map();
    this.skins = [];
    this.extensionsUsed = {};
    this.extensionsRequired = {};
    this.uids = /* @__PURE__ */ new Map();
    this.uid = 0;
    this.json = {
      asset: {
        version: "2.0",
        generator: "THREE.GLTFExporter"
      }
    };
    this.cache = {
      meshes: /* @__PURE__ */ new Map(),
      attributes: /* @__PURE__ */ new Map(),
      attributesNormalized: /* @__PURE__ */ new Map(),
      materials: /* @__PURE__ */ new Map(),
      textures: /* @__PURE__ */ new Map(),
      images: /* @__PURE__ */ new Map()
    };
  }
  setPlugins(plugins) {
    this.plugins = plugins;
  }
  /**
   * Parse scenes and generate GLTF output
   * @param  {Scene or [THREE.Scenes]} input   Scene or Array of THREE.Scenes
   * @param  {Function} onDone  Callback on completed
   * @param  {Object} options options
   */
  async write(input, onDone, options = {}) {
    this.options = Object.assign(
      {
        // default options
        binary: false,
        trs: false,
        onlyVisible: true,
        maxTextureSize: Infinity,
        animations: [],
        includeCustomExtensions: false
      },
      options
    );
    if (this.options.animations.length > 0) {
      this.options.trs = true;
    }
    this.processInput(input);
    await Promise.all(this.pending);
    const writer = this;
    const buffers = writer.buffers;
    const json = writer.json;
    options = writer.options;
    const extensionsUsed = writer.extensionsUsed;
    const extensionsRequired = writer.extensionsRequired;
    const blob = new Blob(buffers, { type: "application/octet-stream" });
    const extensionsUsedList = Object.keys(extensionsUsed);
    const extensionsRequiredList = Object.keys(extensionsRequired);
    if (extensionsUsedList.length > 0)
      json.extensionsUsed = extensionsUsedList;
    if (extensionsRequiredList.length > 0)
      json.extensionsRequired = extensionsRequiredList;
    if (json.buffers && json.buffers.length > 0)
      json.buffers[0].byteLength = blob.size;
    if (options.binary === true) {
      blob.arrayBuffer().then((result) => {
        const binaryChunk = getPaddedArrayBuffer(result);
        const binaryChunkPrefix = new DataView(new ArrayBuffer(GLB_CHUNK_PREFIX_BYTES));
        binaryChunkPrefix.setUint32(0, binaryChunk.byteLength, true);
        binaryChunkPrefix.setUint32(4, GLB_CHUNK_TYPE_BIN, true);
        const jsonChunk = getPaddedArrayBuffer(stringToArrayBuffer(JSON.stringify(json)), 32);
        const jsonChunkPrefix = new DataView(new ArrayBuffer(GLB_CHUNK_PREFIX_BYTES));
        jsonChunkPrefix.setUint32(0, jsonChunk.byteLength, true);
        jsonChunkPrefix.setUint32(4, GLB_CHUNK_TYPE_JSON, true);
        const header = new ArrayBuffer(GLB_HEADER_BYTES);
        const headerView = new DataView(header);
        headerView.setUint32(0, GLB_HEADER_MAGIC, true);
        headerView.setUint32(4, GLB_VERSION, true);
        const totalByteLength = GLB_HEADER_BYTES + jsonChunkPrefix.byteLength + jsonChunk.byteLength + binaryChunkPrefix.byteLength + binaryChunk.byteLength;
        headerView.setUint32(8, totalByteLength, true);
        const glbBlob = new Blob([header, jsonChunkPrefix, jsonChunk, binaryChunkPrefix, binaryChunk], {
          type: "application/octet-stream"
        });
        glbBlob.arrayBuffer().then(onDone);
      });
    } else {
      if (json.buffers && json.buffers.length > 0) {
        readAsDataURL(blob).then((uri) => {
          json.buffers[0].uri = uri;
          onDone(json);
        });
      } else {
        onDone(json);
      }
    }
  }
  /**
   * Serializes a userData.
   *
   * @param {THREE.Object3D|THREE.Material} object
   * @param {Object} objectDef
   */
  serializeUserData(object, objectDef) {
    if (Object.keys(object.userData).length === 0)
      return;
    const options = this.options;
    const extensionsUsed = this.extensionsUsed;
    try {
      const json = JSON.parse(JSON.stringify(object.userData));
      if (options.includeCustomExtensions && json.gltfExtensions) {
        if (objectDef.extensions === void 0)
          objectDef.extensions = {};
        for (const extensionName in json.gltfExtensions) {
          objectDef.extensions[extensionName] = json.gltfExtensions[extensionName];
          extensionsUsed[extensionName] = true;
        }
        delete json.gltfExtensions;
      }
      if (Object.keys(json).length > 0)
        objectDef.extras = json;
    } catch (error) {
      console.warn(
        "THREE.GLTFExporter: userData of '" + object.name + "' won't be serialized because of JSON.stringify error - " + error.message
      );
    }
  }
  /**
   * Returns ids for buffer attributes.
   * @param  {Object} object
   * @return {Integer}
   */
  getUID(attribute, isRelativeCopy = false) {
    if (this.uids.has(attribute) === false) {
      const uids2 = /* @__PURE__ */ new Map();
      uids2.set(true, this.uid++);
      uids2.set(false, this.uid++);
      this.uids.set(attribute, uids2);
    }
    const uids = this.uids.get(attribute);
    return uids.get(isRelativeCopy);
  }
  /**
   * Checks if normal attribute values are normalized.
   *
   * @param {BufferAttribute} normal
   * @returns {Boolean}
   */
  isNormalizedNormalAttribute(normal2) {
    const cache = this.cache;
    if (cache.attributesNormalized.has(normal2))
      return false;
    const v5 = new Vector3();
    for (let i4 = 0, il = normal2.count; i4 < il; i4++) {
      if (Math.abs(v5.fromBufferAttribute(normal2, i4).length() - 1) > 5e-4)
        return false;
    }
    return true;
  }
  /**
   * Creates normalized normal buffer attribute.
   *
   * @param {BufferAttribute} normal
   * @returns {BufferAttribute}
   *
   */
  createNormalizedNormalAttribute(normal2) {
    const cache = this.cache;
    if (cache.attributesNormalized.has(normal2))
      return cache.attributesNormalized.get(normal2);
    const attribute = normal2.clone();
    const v5 = new Vector3();
    for (let i4 = 0, il = attribute.count; i4 < il; i4++) {
      v5.fromBufferAttribute(attribute, i4);
      if (v5.x === 0 && v5.y === 0 && v5.z === 0) {
        v5.setX(1);
      } else {
        v5.normalize();
      }
      attribute.setXYZ(i4, v5.x, v5.y, v5.z);
    }
    cache.attributesNormalized.set(normal2, attribute);
    return attribute;
  }
  /**
   * Applies a texture transform, if present, to the map definition. Requires
   * the KHR_texture_transform extension.
   *
   * @param {Object} mapDef
   * @param {THREE.Texture} texture
   */
  applyTextureTransform(mapDef, texture) {
    let didTransform = false;
    const transformDef = {};
    if (texture.offset.x !== 0 || texture.offset.y !== 0) {
      transformDef.offset = texture.offset.toArray();
      didTransform = true;
    }
    if (texture.rotation !== 0) {
      transformDef.rotation = texture.rotation;
      didTransform = true;
    }
    if (texture.repeat.x !== 1 || texture.repeat.y !== 1) {
      transformDef.scale = texture.repeat.toArray();
      didTransform = true;
    }
    if (didTransform) {
      mapDef.extensions = mapDef.extensions || {};
      mapDef.extensions["KHR_texture_transform"] = transformDef;
      this.extensionsUsed["KHR_texture_transform"] = true;
    }
  }
  buildMetalRoughTexture(metalnessMap, roughnessMap) {
    if (metalnessMap === roughnessMap)
      return metalnessMap;
    function getEncodingConversion(map2) {
      if ("colorSpace" in map2 ? map2.colorSpace === "srgb" : map2.encoding === 3001) {
        return function SRGBToLinear(c2) {
          return c2 < 0.04045 ? c2 * 0.0773993808 : Math.pow(c2 * 0.9478672986 + 0.0521327014, 2.4);
        };
      }
      return function LinearToLinear(c2) {
        return c2;
      };
    }
    console.warn("THREE.GLTFExporter: Merged metalnessMap and roughnessMap textures.");
    if (metalnessMap instanceof CompressedTexture) {
      metalnessMap = decompress(metalnessMap);
    }
    if (roughnessMap instanceof CompressedTexture) {
      roughnessMap = decompress(roughnessMap);
    }
    const metalness = metalnessMap ? metalnessMap.image : null;
    const roughness = roughnessMap ? roughnessMap.image : null;
    const width = Math.max(metalness ? metalness.width : 0, roughness ? roughness.width : 0);
    const height = Math.max(metalness ? metalness.height : 0, roughness ? roughness.height : 0);
    const canvas = getCanvas();
    canvas.width = width;
    canvas.height = height;
    const context12 = canvas.getContext("2d");
    context12.fillStyle = "#00ffff";
    context12.fillRect(0, 0, width, height);
    const composite = context12.getImageData(0, 0, width, height);
    if (metalness) {
      context12.drawImage(metalness, 0, 0, width, height);
      const convert = getEncodingConversion(metalnessMap);
      const data = context12.getImageData(0, 0, width, height).data;
      for (let i4 = 2; i4 < data.length; i4 += 4) {
        composite.data[i4] = convert(data[i4] / 256) * 256;
      }
    }
    if (roughness) {
      context12.drawImage(roughness, 0, 0, width, height);
      const convert = getEncodingConversion(roughnessMap);
      const data = context12.getImageData(0, 0, width, height).data;
      for (let i4 = 1; i4 < data.length; i4 += 4) {
        composite.data[i4] = convert(data[i4] / 256) * 256;
      }
    }
    context12.putImageData(composite, 0, 0);
    const reference = metalnessMap || roughnessMap;
    const texture = reference.clone();
    texture.source = new Texture(canvas).source;
    if ("colorSpace" in texture)
      texture.colorSpace = "";
    else
      texture.encoding = 3e3;
    texture.channel = (metalnessMap || roughnessMap).channel;
    if (metalnessMap && roughnessMap && metalnessMap.channel !== roughnessMap.channel) {
      console.warn("THREE.GLTFExporter: UV channels for metalnessMap and roughnessMap textures must match.");
    }
    return texture;
  }
  /**
   * Process a buffer to append to the default one.
   * @param  {ArrayBuffer} buffer
   * @return {Integer}
   */
  processBuffer(buffer2) {
    const json = this.json;
    const buffers = this.buffers;
    if (!json.buffers)
      json.buffers = [{ byteLength: 0 }];
    buffers.push(buffer2);
    return 0;
  }
  /**
   * Process and generate a BufferView
   * @param  {BufferAttribute} attribute
   * @param  {number} componentType
   * @param  {number} start
   * @param  {number} count
   * @param  {number} target (Optional) Target usage of the BufferView
   * @return {Object}
   */
  processBufferView(attribute, componentType, start, count, target2) {
    const json = this.json;
    if (!json.bufferViews)
      json.bufferViews = [];
    let componentSize;
    switch (componentType) {
      case WEBGL_CONSTANTS.BYTE:
      case WEBGL_CONSTANTS.UNSIGNED_BYTE:
        componentSize = 1;
        break;
      case WEBGL_CONSTANTS.SHORT:
      case WEBGL_CONSTANTS.UNSIGNED_SHORT:
        componentSize = 2;
        break;
      default:
        componentSize = 4;
    }
    let byteStride = attribute.itemSize * componentSize;
    if (target2 === WEBGL_CONSTANTS.ARRAY_BUFFER) {
      byteStride = Math.ceil(byteStride / 4) * 4;
    }
    const byteLength = getPaddedBufferSize(count * byteStride);
    const dataView = new DataView(new ArrayBuffer(byteLength));
    let offset = 0;
    for (let i4 = start; i4 < start + count; i4++) {
      for (let a6 = 0; a6 < attribute.itemSize; a6++) {
        let value;
        if (attribute.itemSize > 4) {
          value = attribute.array[i4 * attribute.itemSize + a6];
        } else {
          if (a6 === 0)
            value = attribute.getX(i4);
          else if (a6 === 1)
            value = attribute.getY(i4);
          else if (a6 === 2)
            value = attribute.getZ(i4);
          else if (a6 === 3)
            value = attribute.getW(i4);
          if (attribute.normalized === true) {
            value = MathUtils.normalize(value, attribute.array);
          }
        }
        if (componentType === WEBGL_CONSTANTS.FLOAT) {
          dataView.setFloat32(offset, value, true);
        } else if (componentType === WEBGL_CONSTANTS.INT) {
          dataView.setInt32(offset, value, true);
        } else if (componentType === WEBGL_CONSTANTS.UNSIGNED_INT) {
          dataView.setUint32(offset, value, true);
        } else if (componentType === WEBGL_CONSTANTS.SHORT) {
          dataView.setInt16(offset, value, true);
        } else if (componentType === WEBGL_CONSTANTS.UNSIGNED_SHORT) {
          dataView.setUint16(offset, value, true);
        } else if (componentType === WEBGL_CONSTANTS.BYTE) {
          dataView.setInt8(offset, value);
        } else if (componentType === WEBGL_CONSTANTS.UNSIGNED_BYTE) {
          dataView.setUint8(offset, value);
        }
        offset += componentSize;
      }
      if (offset % byteStride !== 0) {
        offset += byteStride - offset % byteStride;
      }
    }
    const bufferViewDef = {
      buffer: this.processBuffer(dataView.buffer),
      byteOffset: this.byteOffset,
      byteLength
    };
    if (target2 !== void 0)
      bufferViewDef.target = target2;
    if (target2 === WEBGL_CONSTANTS.ARRAY_BUFFER) {
      bufferViewDef.byteStride = byteStride;
    }
    this.byteOffset += byteLength;
    json.bufferViews.push(bufferViewDef);
    const output = {
      id: json.bufferViews.length - 1,
      byteLength: 0
    };
    return output;
  }
  /**
   * Process and generate a BufferView from an image Blob.
   * @param {Blob} blob
   * @return {Promise<Integer>}
   */
  processBufferViewImage(blob) {
    const writer = this;
    const json = writer.json;
    if (!json.bufferViews)
      json.bufferViews = [];
    return blob.arrayBuffer().then((result) => {
      const buffer2 = getPaddedArrayBuffer(result);
      const bufferViewDef = {
        buffer: writer.processBuffer(buffer2),
        byteOffset: writer.byteOffset,
        byteLength: buffer2.byteLength
      };
      writer.byteOffset += buffer2.byteLength;
      return json.bufferViews.push(bufferViewDef) - 1;
    });
  }
  /**
   * Process attribute to generate an accessor
   * @param  {BufferAttribute} attribute Attribute to process
   * @param  {THREE.BufferGeometry} geometry (Optional) Geometry used for truncated draw range
   * @param  {Integer} start (Optional)
   * @param  {Integer} count (Optional)
   * @return {Integer|null} Index of the processed accessor on the "accessors" array
   */
  processAccessor(attribute, geometry3, start, count) {
    const json = this.json;
    const types2 = {
      1: "SCALAR",
      2: "VEC2",
      3: "VEC3",
      4: "VEC4",
      9: "MAT3",
      16: "MAT4"
    };
    let componentType;
    if (attribute.array.constructor === Float32Array) {
      componentType = WEBGL_CONSTANTS.FLOAT;
    } else if (attribute.array.constructor === Int32Array) {
      componentType = WEBGL_CONSTANTS.INT;
    } else if (attribute.array.constructor === Uint32Array) {
      componentType = WEBGL_CONSTANTS.UNSIGNED_INT;
    } else if (attribute.array.constructor === Int16Array) {
      componentType = WEBGL_CONSTANTS.SHORT;
    } else if (attribute.array.constructor === Uint16Array) {
      componentType = WEBGL_CONSTANTS.UNSIGNED_SHORT;
    } else if (attribute.array.constructor === Int8Array) {
      componentType = WEBGL_CONSTANTS.BYTE;
    } else if (attribute.array.constructor === Uint8Array) {
      componentType = WEBGL_CONSTANTS.UNSIGNED_BYTE;
    } else {
      throw new Error(
        "THREE.GLTFExporter: Unsupported bufferAttribute component type: " + attribute.array.constructor.name
      );
    }
    if (start === void 0)
      start = 0;
    if (count === void 0)
      count = attribute.count;
    if (count === 0)
      return null;
    const minMax = getMinMax(attribute, start, count);
    let bufferViewTarget;
    if (geometry3 !== void 0) {
      bufferViewTarget = attribute === geometry3.index ? WEBGL_CONSTANTS.ELEMENT_ARRAY_BUFFER : WEBGL_CONSTANTS.ARRAY_BUFFER;
    }
    const bufferView = this.processBufferView(attribute, componentType, start, count, bufferViewTarget);
    const accessorDef = {
      bufferView: bufferView.id,
      byteOffset: bufferView.byteOffset,
      componentType,
      count,
      max: minMax.max,
      min: minMax.min,
      type: types2[attribute.itemSize]
    };
    if (attribute.normalized === true)
      accessorDef.normalized = true;
    if (!json.accessors)
      json.accessors = [];
    return json.accessors.push(accessorDef) - 1;
  }
  /**
   * Process image
   * @param  {Image} image to process
   * @param  {Integer} format of the image (RGBAFormat)
   * @param  {Boolean} flipY before writing out the image
   * @param  {String} mimeType export format
   * @return {Integer}     Index of the processed texture in the "images" array
   */
  processImage(image, format, flipY, mimeType = "image/png") {
    if (image !== null) {
      const writer = this;
      const cache = writer.cache;
      const json = writer.json;
      const options = writer.options;
      const pending = writer.pending;
      if (!cache.images.has(image))
        cache.images.set(image, {});
      const cachedImages = cache.images.get(image);
      const key = mimeType + ":flipY/" + flipY.toString();
      if (cachedImages[key] !== void 0)
        return cachedImages[key];
      if (!json.images)
        json.images = [];
      const imageDef = { mimeType };
      const canvas = getCanvas();
      canvas.width = Math.min(image.width, options.maxTextureSize);
      canvas.height = Math.min(image.height, options.maxTextureSize);
      const ctx = canvas.getContext("2d");
      if (flipY === true) {
        ctx.translate(0, canvas.height);
        ctx.scale(1, -1);
      }
      if (image.data !== void 0) {
        if (format !== RGBAFormat) {
          console.error("GLTFExporter: Only RGBAFormat is supported.", format);
        }
        if (image.width > options.maxTextureSize || image.height > options.maxTextureSize) {
          console.warn("GLTFExporter: Image size is bigger than maxTextureSize", image);
        }
        const data = new Uint8ClampedArray(image.height * image.width * 4);
        for (let i4 = 0; i4 < data.length; i4 += 4) {
          data[i4 + 0] = image.data[i4 + 0];
          data[i4 + 1] = image.data[i4 + 1];
          data[i4 + 2] = image.data[i4 + 2];
          data[i4 + 3] = image.data[i4 + 3];
        }
        ctx.putImageData(new ImageData(data, image.width, image.height), 0, 0);
      } else {
        ctx.drawImage(image, 0, 0, canvas.width, canvas.height);
      }
      if (options.binary === true) {
        pending.push(
          getToBlobPromise(canvas, mimeType).then((blob) => writer.processBufferViewImage(blob)).then((bufferViewIndex) => {
            imageDef.bufferView = bufferViewIndex;
          })
        );
      } else {
        if (canvas.toDataURL !== void 0) {
          imageDef.uri = canvas.toDataURL(mimeType);
        } else {
          pending.push(
            getToBlobPromise(canvas, mimeType).then(readAsDataURL).then((uri) => {
              imageDef.uri = uri;
            })
          );
        }
      }
      const index2 = json.images.push(imageDef) - 1;
      cachedImages[key] = index2;
      return index2;
    } else {
      throw new Error("THREE.GLTFExporter: No valid image data found. Unable to process texture.");
    }
  }
  /**
   * Process sampler
   * @param  {Texture} map Texture to process
   * @return {Integer}     Index of the processed texture in the "samplers" array
   */
  processSampler(map2) {
    const json = this.json;
    if (!json.samplers)
      json.samplers = [];
    const samplerDef = {
      magFilter: THREE_TO_WEBGL[map2.magFilter],
      minFilter: THREE_TO_WEBGL[map2.minFilter],
      wrapS: THREE_TO_WEBGL[map2.wrapS],
      wrapT: THREE_TO_WEBGL[map2.wrapT]
    };
    return json.samplers.push(samplerDef) - 1;
  }
  /**
   * Process texture
   * @param  {Texture} map Map to process
   * @return {Integer} Index of the processed texture in the "textures" array
   */
  processTexture(map2) {
    const writer = this;
    const options = writer.options;
    const cache = this.cache;
    const json = this.json;
    if (cache.textures.has(map2))
      return cache.textures.get(map2);
    if (!json.textures)
      json.textures = [];
    if (map2 instanceof CompressedTexture) {
      map2 = decompress(map2, options.maxTextureSize);
    }
    let mimeType = map2.userData.mimeType;
    if (mimeType === "image/webp")
      mimeType = "image/png";
    const textureDef = {
      sampler: this.processSampler(map2),
      source: this.processImage(map2.image, map2.format, map2.flipY, mimeType)
    };
    if (map2.name)
      textureDef.name = map2.name;
    this._invokeAll(function(ext) {
      ext.writeTexture && ext.writeTexture(map2, textureDef);
    });
    const index2 = json.textures.push(textureDef) - 1;
    cache.textures.set(map2, index2);
    return index2;
  }
  /**
   * Process material
   * @param  {THREE.Material} material Material to process
   * @return {Integer|null} Index of the processed material in the "materials" array
   */
  processMaterial(material) {
    const cache = this.cache;
    const json = this.json;
    if (cache.materials.has(material))
      return cache.materials.get(material);
    if (material.isShaderMaterial) {
      console.warn("GLTFExporter: THREE.ShaderMaterial not supported.");
      return null;
    }
    if (!json.materials)
      json.materials = [];
    const materialDef = { pbrMetallicRoughness: {} };
    if (material.isMeshStandardMaterial !== true && material.isMeshBasicMaterial !== true) {
      console.warn("GLTFExporter: Use MeshStandardMaterial or MeshBasicMaterial for best results.");
    }
    const color = material.color.toArray().concat([material.opacity]);
    if (!equalArray(color, [1, 1, 1, 1])) {
      materialDef.pbrMetallicRoughness.baseColorFactor = color;
    }
    if (material.isMeshStandardMaterial) {
      materialDef.pbrMetallicRoughness.metallicFactor = material.metalness;
      materialDef.pbrMetallicRoughness.roughnessFactor = material.roughness;
    } else {
      materialDef.pbrMetallicRoughness.metallicFactor = 0.5;
      materialDef.pbrMetallicRoughness.roughnessFactor = 0.5;
    }
    if (material.metalnessMap || material.roughnessMap) {
      const metalRoughTexture = this.buildMetalRoughTexture(material.metalnessMap, material.roughnessMap);
      const metalRoughMapDef = {
        index: this.processTexture(metalRoughTexture),
        channel: metalRoughTexture.channel
      };
      this.applyTextureTransform(metalRoughMapDef, metalRoughTexture);
      materialDef.pbrMetallicRoughness.metallicRoughnessTexture = metalRoughMapDef;
    }
    if (material.map) {
      const baseColorMapDef = {
        index: this.processTexture(material.map),
        texCoord: material.map.channel
      };
      this.applyTextureTransform(baseColorMapDef, material.map);
      materialDef.pbrMetallicRoughness.baseColorTexture = baseColorMapDef;
    }
    if (material.emissive) {
      const emissive = material.emissive;
      const maxEmissiveComponent = Math.max(emissive.r, emissive.g, emissive.b);
      if (maxEmissiveComponent > 0) {
        materialDef.emissiveFactor = material.emissive.toArray();
      }
      if (material.emissiveMap) {
        const emissiveMapDef = {
          index: this.processTexture(material.emissiveMap),
          texCoord: material.emissiveMap.channel
        };
        this.applyTextureTransform(emissiveMapDef, material.emissiveMap);
        materialDef.emissiveTexture = emissiveMapDef;
      }
    }
    if (material.normalMap) {
      const normalMapDef = {
        index: this.processTexture(material.normalMap),
        texCoord: material.normalMap.channel
      };
      if (material.normalScale && material.normalScale.x !== 1) {
        normalMapDef.scale = material.normalScale.x;
      }
      this.applyTextureTransform(normalMapDef, material.normalMap);
      materialDef.normalTexture = normalMapDef;
    }
    if (material.aoMap) {
      const occlusionMapDef = {
        index: this.processTexture(material.aoMap),
        texCoord: material.aoMap.channel
      };
      if (material.aoMapIntensity !== 1) {
        occlusionMapDef.strength = material.aoMapIntensity;
      }
      this.applyTextureTransform(occlusionMapDef, material.aoMap);
      materialDef.occlusionTexture = occlusionMapDef;
    }
    if (material.transparent) {
      materialDef.alphaMode = "BLEND";
    } else {
      if (material.alphaTest > 0) {
        materialDef.alphaMode = "MASK";
        materialDef.alphaCutoff = material.alphaTest;
      }
    }
    if (material.side === DoubleSide)
      materialDef.doubleSided = true;
    if (material.name !== "")
      materialDef.name = material.name;
    this.serializeUserData(material, materialDef);
    this._invokeAll(function(ext) {
      ext.writeMaterial && ext.writeMaterial(material, materialDef);
    });
    const index2 = json.materials.push(materialDef) - 1;
    cache.materials.set(material, index2);
    return index2;
  }
  /**
   * Process mesh
   * @param  {THREE.Mesh} mesh Mesh to process
   * @return {Integer|null} Index of the processed mesh in the "meshes" array
   */
  processMesh(mesh) {
    const cache = this.cache;
    const json = this.json;
    const meshCacheKeyParts = [mesh.geometry.uuid];
    if (Array.isArray(mesh.material)) {
      for (let i4 = 0, l2 = mesh.material.length; i4 < l2; i4++) {
        meshCacheKeyParts.push(mesh.material[i4].uuid);
      }
    } else {
      meshCacheKeyParts.push(mesh.material.uuid);
    }
    const meshCacheKey = meshCacheKeyParts.join(":");
    if (cache.meshes.has(meshCacheKey))
      return cache.meshes.get(meshCacheKey);
    const geometry3 = mesh.geometry;
    let mode;
    if (mesh.isLineSegments) {
      mode = WEBGL_CONSTANTS.LINES;
    } else if (mesh.isLineLoop) {
      mode = WEBGL_CONSTANTS.LINE_LOOP;
    } else if (mesh.isLine) {
      mode = WEBGL_CONSTANTS.LINE_STRIP;
    } else if (mesh.isPoints) {
      mode = WEBGL_CONSTANTS.POINTS;
    } else {
      mode = mesh.material.wireframe ? WEBGL_CONSTANTS.LINES : WEBGL_CONSTANTS.TRIANGLES;
    }
    const meshDef = {};
    const attributes = {};
    const primitives = [];
    const targets = [];
    const nameConversion = {
      ...version >= 152 ? {
        uv: "TEXCOORD_0",
        uv1: "TEXCOORD_1",
        uv2: "TEXCOORD_2",
        uv3: "TEXCOORD_3"
      } : {
        uv: "TEXCOORD_0",
        uv2: "TEXCOORD_1"
      },
      color: "COLOR_0",
      skinWeight: "WEIGHTS_0",
      skinIndex: "JOINTS_0"
    };
    const originalNormal = geometry3.getAttribute("normal");
    if (originalNormal !== void 0 && !this.isNormalizedNormalAttribute(originalNormal)) {
      console.warn("THREE.GLTFExporter: Creating normalized normal attribute from the non-normalized one.");
      geometry3.setAttribute("normal", this.createNormalizedNormalAttribute(originalNormal));
    }
    let modifiedAttribute = null;
    for (let attributeName in geometry3.attributes) {
      if (attributeName.slice(0, 5) === "morph")
        continue;
      const attribute = geometry3.attributes[attributeName];
      attributeName = nameConversion[attributeName] || attributeName.toUpperCase();
      const validVertexAttributes = /^(POSITION|NORMAL|TANGENT|TEXCOORD_\d+|COLOR_\d+|JOINTS_\d+|WEIGHTS_\d+)$/;
      if (!validVertexAttributes.test(attributeName))
        attributeName = "_" + attributeName;
      if (cache.attributes.has(this.getUID(attribute))) {
        attributes[attributeName] = cache.attributes.get(this.getUID(attribute));
        continue;
      }
      modifiedAttribute = null;
      const array = attribute.array;
      if (attributeName === "JOINTS_0" && !(array instanceof Uint16Array) && !(array instanceof Uint8Array)) {
        console.warn('GLTFExporter: Attribute "skinIndex" converted to type UNSIGNED_SHORT.');
        modifiedAttribute = new BufferAttribute(new Uint16Array(array), attribute.itemSize, attribute.normalized);
      }
      const accessor = this.processAccessor(modifiedAttribute || attribute, geometry3);
      if (accessor !== null) {
        if (!attributeName.startsWith("_")) {
          this.detectMeshQuantization(attributeName, attribute);
        }
        attributes[attributeName] = accessor;
        cache.attributes.set(this.getUID(attribute), accessor);
      }
    }
    if (originalNormal !== void 0)
      geometry3.setAttribute("normal", originalNormal);
    if (Object.keys(attributes).length === 0)
      return null;
    if (mesh.morphTargetInfluences !== void 0 && mesh.morphTargetInfluences.length > 0) {
      const weights = [];
      const targetNames = [];
      const reverseDictionary = {};
      if (mesh.morphTargetDictionary !== void 0) {
        for (const key in mesh.morphTargetDictionary) {
          reverseDictionary[mesh.morphTargetDictionary[key]] = key;
        }
      }
      for (let i4 = 0; i4 < mesh.morphTargetInfluences.length; ++i4) {
        const target2 = {};
        let warned2 = false;
        for (const attributeName in geometry3.morphAttributes) {
          if (attributeName !== "position" && attributeName !== "normal") {
            if (!warned2) {
              console.warn("GLTFExporter: Only POSITION and NORMAL morph are supported.");
              warned2 = true;
            }
            continue;
          }
          const attribute = geometry3.morphAttributes[attributeName][i4];
          const gltfAttributeName = attributeName.toUpperCase();
          const baseAttribute = geometry3.attributes[attributeName];
          if (cache.attributes.has(this.getUID(attribute, true))) {
            target2[gltfAttributeName] = cache.attributes.get(this.getUID(attribute, true));
            continue;
          }
          const relativeAttribute = attribute.clone();
          if (!geometry3.morphTargetsRelative) {
            for (let j = 0, jl = attribute.count; j < jl; j++) {
              for (let a6 = 0; a6 < attribute.itemSize; a6++) {
                if (a6 === 0)
                  relativeAttribute.setX(j, attribute.getX(j) - baseAttribute.getX(j));
                if (a6 === 1)
                  relativeAttribute.setY(j, attribute.getY(j) - baseAttribute.getY(j));
                if (a6 === 2)
                  relativeAttribute.setZ(j, attribute.getZ(j) - baseAttribute.getZ(j));
                if (a6 === 3)
                  relativeAttribute.setW(j, attribute.getW(j) - baseAttribute.getW(j));
              }
            }
          }
          target2[gltfAttributeName] = this.processAccessor(relativeAttribute, geometry3);
          cache.attributes.set(this.getUID(baseAttribute, true), target2[gltfAttributeName]);
        }
        targets.push(target2);
        weights.push(mesh.morphTargetInfluences[i4]);
        if (mesh.morphTargetDictionary !== void 0)
          targetNames.push(reverseDictionary[i4]);
      }
      meshDef.weights = weights;
      if (targetNames.length > 0) {
        meshDef.extras = {};
        meshDef.extras.targetNames = targetNames;
      }
    }
    const isMultiMaterial = Array.isArray(mesh.material);
    if (isMultiMaterial && geometry3.groups.length === 0)
      return null;
    const materials = isMultiMaterial ? mesh.material : [mesh.material];
    const groups = isMultiMaterial ? geometry3.groups : [{ materialIndex: 0, start: void 0, count: void 0 }];
    for (let i4 = 0, il = groups.length; i4 < il; i4++) {
      const primitive = {
        mode,
        attributes
      };
      this.serializeUserData(geometry3, primitive);
      if (targets.length > 0)
        primitive.targets = targets;
      if (geometry3.index !== null) {
        let cacheKey = this.getUID(geometry3.index);
        if (groups[i4].start !== void 0 || groups[i4].count !== void 0) {
          cacheKey += ":" + groups[i4].start + ":" + groups[i4].count;
        }
        if (cache.attributes.has(cacheKey)) {
          primitive.indices = cache.attributes.get(cacheKey);
        } else {
          primitive.indices = this.processAccessor(geometry3.index, geometry3, groups[i4].start, groups[i4].count);
          cache.attributes.set(cacheKey, primitive.indices);
        }
        if (primitive.indices === null)
          delete primitive.indices;
      }
      const material = this.processMaterial(materials[groups[i4].materialIndex]);
      if (material !== null)
        primitive.material = material;
      primitives.push(primitive);
    }
    meshDef.primitives = primitives;
    if (!json.meshes)
      json.meshes = [];
    this._invokeAll(function(ext) {
      ext.writeMesh && ext.writeMesh(mesh, meshDef);
    });
    const index2 = json.meshes.push(meshDef) - 1;
    cache.meshes.set(meshCacheKey, index2);
    return index2;
  }
  /**
   * If a vertex attribute with a
   * [non-standard data type](https://registry.khronos.org/glTF/specs/2.0/glTF-2.0.html#meshes-overview)
   * is used, it is checked whether it is a valid data type according to the
   * [KHR_mesh_quantization](https://github.com/KhronosGroup/glTF/blob/main/extensions/2.0/Khronos/KHR_mesh_quantization/README.md)
   * extension.
   * In this case the extension is automatically added to the list of used extensions.
   *
   * @param {string} attributeName
   * @param {THREE.BufferAttribute} attribute
   */
  detectMeshQuantization(attributeName, attribute) {
    if (this.extensionsUsed[KHR_MESH_QUANTIZATION])
      return;
    let attrType = void 0;
    switch (attribute.array.constructor) {
      case Int8Array:
        attrType = "byte";
        break;
      case Uint8Array:
        attrType = "unsigned byte";
        break;
      case Int16Array:
        attrType = "short";
        break;
      case Uint16Array:
        attrType = "unsigned short";
        break;
      default:
        return;
    }
    if (attribute.normalized)
      attrType += " normalized";
    const attrNamePrefix = attributeName.split("_", 1)[0];
    if (KHR_mesh_quantization_ExtraAttrTypes[attrNamePrefix] && KHR_mesh_quantization_ExtraAttrTypes[attrNamePrefix].includes(attrType)) {
      this.extensionsUsed[KHR_MESH_QUANTIZATION] = true;
      this.extensionsRequired[KHR_MESH_QUANTIZATION] = true;
    }
  }
  /**
   * Process camera
   * @param  {THREE.Camera} camera Camera to process
   * @return {Integer}      Index of the processed mesh in the "camera" array
   */
  processCamera(camera) {
    const json = this.json;
    if (!json.cameras)
      json.cameras = [];
    const isOrtho = camera.isOrthographicCamera;
    const cameraDef = {
      type: isOrtho ? "orthographic" : "perspective"
    };
    if (isOrtho) {
      cameraDef.orthographic = {
        xmag: camera.right * 2,
        ymag: camera.top * 2,
        zfar: camera.far <= 0 ? 1e-3 : camera.far,
        znear: camera.near < 0 ? 0 : camera.near
      };
    } else {
      cameraDef.perspective = {
        aspectRatio: camera.aspect,
        yfov: MathUtils.degToRad(camera.fov),
        zfar: camera.far <= 0 ? 1e-3 : camera.far,
        znear: camera.near < 0 ? 0 : camera.near
      };
    }
    if (camera.name !== "")
      cameraDef.name = camera.type;
    return json.cameras.push(cameraDef) - 1;
  }
  /**
   * Creates glTF animation entry from AnimationClip object.
   *
   * Status:
   * - Only properties listed in PATH_PROPERTIES may be animated.
   *
   * @param {THREE.AnimationClip} clip
   * @param {THREE.Object3D} root
   * @return {number|null}
   */
  processAnimation(clip, root) {
    const json = this.json;
    const nodeMap = this.nodeMap;
    if (!json.animations)
      json.animations = [];
    clip = GLTFExporter.Utils.mergeMorphTargetTracks(clip.clone(), root);
    const tracks = clip.tracks;
    const channels = [];
    const samplers = [];
    for (let i4 = 0; i4 < tracks.length; ++i4) {
      const track = tracks[i4];
      const trackBinding = PropertyBinding.parseTrackName(track.name);
      let trackNode = PropertyBinding.findNode(root, trackBinding.nodeName);
      const trackProperty = PATH_PROPERTIES[trackBinding.propertyName];
      if (trackBinding.objectName === "bones") {
        if (trackNode.isSkinnedMesh === true) {
          trackNode = trackNode.skeleton.getBoneByName(trackBinding.objectIndex);
        } else {
          trackNode = void 0;
        }
      }
      if (!trackNode || !trackProperty) {
        console.warn('THREE.GLTFExporter: Could not export animation track "%s".', track.name);
        return null;
      }
      const inputItemSize = 1;
      let outputItemSize = track.values.length / track.times.length;
      if (trackProperty === PATH_PROPERTIES.morphTargetInfluences) {
        outputItemSize /= trackNode.morphTargetInfluences.length;
      }
      let interpolation;
      if (track.createInterpolant.isInterpolantFactoryMethodGLTFCubicSpline === true) {
        interpolation = "CUBICSPLINE";
        outputItemSize /= 3;
      } else if (track.getInterpolation() === InterpolateDiscrete) {
        interpolation = "STEP";
      } else {
        interpolation = "LINEAR";
      }
      samplers.push({
        input: this.processAccessor(new BufferAttribute(track.times, inputItemSize)),
        output: this.processAccessor(new BufferAttribute(track.values, outputItemSize)),
        interpolation
      });
      channels.push({
        sampler: samplers.length - 1,
        target: {
          node: nodeMap.get(trackNode),
          path: trackProperty
        }
      });
    }
    json.animations.push({
      name: clip.name || "clip_" + json.animations.length,
      samplers,
      channels
    });
    return json.animations.length - 1;
  }
  /**
   * @param {THREE.Object3D} object
   * @return {number|null}
   */
  processSkin(object) {
    const json = this.json;
    const nodeMap = this.nodeMap;
    const node = json.nodes[nodeMap.get(object)];
    const skeleton = object.skeleton;
    if (skeleton === void 0)
      return null;
    const rootJoint = object.skeleton.bones[0];
    if (rootJoint === void 0)
      return null;
    const joints = [];
    const inverseBindMatrices = new Float32Array(skeleton.bones.length * 16);
    const temporaryBoneInverse = new Matrix4();
    for (let i4 = 0; i4 < skeleton.bones.length; ++i4) {
      joints.push(nodeMap.get(skeleton.bones[i4]));
      temporaryBoneInverse.copy(skeleton.boneInverses[i4]);
      temporaryBoneInverse.multiply(object.bindMatrix).toArray(inverseBindMatrices, i4 * 16);
    }
    if (json.skins === void 0)
      json.skins = [];
    json.skins.push({
      inverseBindMatrices: this.processAccessor(new BufferAttribute(inverseBindMatrices, 16)),
      joints,
      skeleton: nodeMap.get(rootJoint)
    });
    const skinIndex = node.skin = json.skins.length - 1;
    return skinIndex;
  }
  /**
   * Process Object3D node
   * @param  {THREE.Object3D} node Object3D to processNode
   * @return {Integer} Index of the node in the nodes list
   */
  processNode(object) {
    const json = this.json;
    const options = this.options;
    const nodeMap = this.nodeMap;
    if (!json.nodes)
      json.nodes = [];
    const nodeDef = {};
    if (options.trs) {
      const rotation3 = object.quaternion.toArray();
      const position2 = object.position.toArray();
      const scale5 = object.scale.toArray();
      if (!equalArray(rotation3, [0, 0, 0, 1])) {
        nodeDef.rotation = rotation3;
      }
      if (!equalArray(position2, [0, 0, 0])) {
        nodeDef.translation = position2;
      }
      if (!equalArray(scale5, [1, 1, 1])) {
        nodeDef.scale = scale5;
      }
    } else {
      if (object.matrixAutoUpdate) {
        object.updateMatrix();
      }
      if (isIdentityMatrix(object.matrix) === false) {
        nodeDef.matrix = object.matrix.elements;
      }
    }
    if (object.name !== "")
      nodeDef.name = String(object.name);
    this.serializeUserData(object, nodeDef);
    if (object.isMesh || object.isLine || object.isPoints) {
      const meshIndex = this.processMesh(object);
      if (meshIndex !== null)
        nodeDef.mesh = meshIndex;
    } else if (object.isCamera) {
      nodeDef.camera = this.processCamera(object);
    }
    if (object.isSkinnedMesh)
      this.skins.push(object);
    if (object.children.length > 0) {
      const children = [];
      for (let i4 = 0, l2 = object.children.length; i4 < l2; i4++) {
        const child = object.children[i4];
        if (child.visible || options.onlyVisible === false) {
          const nodeIndex2 = this.processNode(child);
          if (nodeIndex2 !== null)
            children.push(nodeIndex2);
        }
      }
      if (children.length > 0)
        nodeDef.children = children;
    }
    this._invokeAll(function(ext) {
      ext.writeNode && ext.writeNode(object, nodeDef);
    });
    const nodeIndex = json.nodes.push(nodeDef) - 1;
    nodeMap.set(object, nodeIndex);
    return nodeIndex;
  }
  /**
   * Process Scene
   * @param  {Scene} node Scene to process
   */
  processScene(scene) {
    const json = this.json;
    const options = this.options;
    if (!json.scenes) {
      json.scenes = [];
      json.scene = 0;
    }
    const sceneDef = {};
    if (scene.name !== "")
      sceneDef.name = scene.name;
    json.scenes.push(sceneDef);
    const nodes = [];
    for (let i4 = 0, l2 = scene.children.length; i4 < l2; i4++) {
      const child = scene.children[i4];
      if (child.visible || options.onlyVisible === false) {
        const nodeIndex = this.processNode(child);
        if (nodeIndex !== null)
          nodes.push(nodeIndex);
      }
    }
    if (nodes.length > 0)
      sceneDef.nodes = nodes;
    this.serializeUserData(scene, sceneDef);
  }
  /**
   * Creates a Scene to hold a list of objects and parse it
   * @param  {Array} objects List of objects to process
   */
  processObjects(objects) {
    const scene = new Scene();
    scene.name = "AuxScene";
    for (let i4 = 0; i4 < objects.length; i4++) {
      scene.children.push(objects[i4]);
    }
    this.processScene(scene);
  }
  /**
   * @param {THREE.Object3D|Array<THREE.Object3D>} input
   */
  processInput(input) {
    const options = this.options;
    input = input instanceof Array ? input : [input];
    this._invokeAll(function(ext) {
      ext.beforeParse && ext.beforeParse(input);
    });
    const objectsWithoutScene = [];
    for (let i4 = 0; i4 < input.length; i4++) {
      if (input[i4] instanceof Scene) {
        this.processScene(input[i4]);
      } else {
        objectsWithoutScene.push(input[i4]);
      }
    }
    if (objectsWithoutScene.length > 0)
      this.processObjects(objectsWithoutScene);
    for (let i4 = 0; i4 < this.skins.length; ++i4) {
      this.processSkin(this.skins[i4]);
    }
    for (let i4 = 0; i4 < options.animations.length; ++i4) {
      this.processAnimation(options.animations[i4], input[0]);
    }
    this._invokeAll(function(ext) {
      ext.afterParse && ext.afterParse(input);
    });
  }
  _invokeAll(func) {
    for (let i4 = 0, il = this.plugins.length; i4 < il; i4++) {
      func(this.plugins[i4]);
    }
  }
};
var GLTFLightExtension = class {
  constructor(writer) {
    this.writer = writer;
    this.name = "KHR_lights_punctual";
  }
  writeNode(light, nodeDef) {
    if (!light.isLight)
      return;
    if (!light.isDirectionalLight && !light.isPointLight && !light.isSpotLight) {
      console.warn("THREE.GLTFExporter: Only directional, point, and spot lights are supported.", light);
      return;
    }
    const writer = this.writer;
    const json = writer.json;
    const extensionsUsed = writer.extensionsUsed;
    const lightDef = {};
    if (light.name)
      lightDef.name = light.name;
    lightDef.color = light.color.toArray();
    lightDef.intensity = light.intensity;
    if (light.isDirectionalLight) {
      lightDef.type = "directional";
    } else if (light.isPointLight) {
      lightDef.type = "point";
      if (light.distance > 0)
        lightDef.range = light.distance;
    } else if (light.isSpotLight) {
      lightDef.type = "spot";
      if (light.distance > 0)
        lightDef.range = light.distance;
      lightDef.spot = {};
      lightDef.spot.innerConeAngle = (light.penumbra - 1) * light.angle * -1;
      lightDef.spot.outerConeAngle = light.angle;
    }
    if (light.decay !== void 0 && light.decay !== 2) {
      console.warn(
        "THREE.GLTFExporter: Light decay may be lost. glTF is physically-based, and expects light.decay=2."
      );
    }
    if (light.target && (light.target.parent !== light || light.target.position.x !== 0 || light.target.position.y !== 0 || light.target.position.z !== -1)) {
      console.warn(
        "THREE.GLTFExporter: Light direction may be lost. For best results, make light.target a child of the light with position 0,0,-1."
      );
    }
    if (!extensionsUsed[this.name]) {
      json.extensions = json.extensions || {};
      json.extensions[this.name] = { lights: [] };
      extensionsUsed[this.name] = true;
    }
    const lights = json.extensions[this.name].lights;
    lights.push(lightDef);
    nodeDef.extensions = nodeDef.extensions || {};
    nodeDef.extensions[this.name] = { light: lights.length - 1 };
  }
};
var GLTFMaterialsUnlitExtension = class {
  constructor(writer) {
    this.writer = writer;
    this.name = "KHR_materials_unlit";
  }
  writeMaterial(material, materialDef) {
    if (!material.isMeshBasicMaterial)
      return;
    const writer = this.writer;
    const extensionsUsed = writer.extensionsUsed;
    materialDef.extensions = materialDef.extensions || {};
    materialDef.extensions[this.name] = {};
    extensionsUsed[this.name] = true;
    materialDef.pbrMetallicRoughness.metallicFactor = 0;
    materialDef.pbrMetallicRoughness.roughnessFactor = 0.9;
  }
};
var GLTFMaterialsClearcoatExtension = class {
  constructor(writer) {
    this.writer = writer;
    this.name = "KHR_materials_clearcoat";
  }
  writeMaterial(material, materialDef) {
    if (!material.isMeshPhysicalMaterial || material.clearcoat === 0)
      return;
    const writer = this.writer;
    const extensionsUsed = writer.extensionsUsed;
    const extensionDef = {};
    extensionDef.clearcoatFactor = material.clearcoat;
    if (material.clearcoatMap) {
      const clearcoatMapDef = {
        index: writer.processTexture(material.clearcoatMap),
        texCoord: material.clearcoatMap.channel
      };
      writer.applyTextureTransform(clearcoatMapDef, material.clearcoatMap);
      extensionDef.clearcoatTexture = clearcoatMapDef;
    }
    extensionDef.clearcoatRoughnessFactor = material.clearcoatRoughness;
    if (material.clearcoatRoughnessMap) {
      const clearcoatRoughnessMapDef = {
        index: writer.processTexture(material.clearcoatRoughnessMap),
        texCoord: material.clearcoatRoughnessMap.channel
      };
      writer.applyTextureTransform(clearcoatRoughnessMapDef, material.clearcoatRoughnessMap);
      extensionDef.clearcoatRoughnessTexture = clearcoatRoughnessMapDef;
    }
    if (material.clearcoatNormalMap) {
      const clearcoatNormalMapDef = {
        index: writer.processTexture(material.clearcoatNormalMap),
        texCoord: material.clearcoatNormalMap.channel
      };
      writer.applyTextureTransform(clearcoatNormalMapDef, material.clearcoatNormalMap);
      extensionDef.clearcoatNormalTexture = clearcoatNormalMapDef;
    }
    materialDef.extensions = materialDef.extensions || {};
    materialDef.extensions[this.name] = extensionDef;
    extensionsUsed[this.name] = true;
  }
};
var GLTFMaterialsIridescenceExtension = class {
  constructor(writer) {
    this.writer = writer;
    this.name = "KHR_materials_iridescence";
  }
  writeMaterial(material, materialDef) {
    if (!material.isMeshPhysicalMaterial || material.iridescence === 0)
      return;
    const writer = this.writer;
    const extensionsUsed = writer.extensionsUsed;
    const extensionDef = {};
    extensionDef.iridescenceFactor = material.iridescence;
    if (material.iridescenceMap) {
      const iridescenceMapDef = {
        index: writer.processTexture(material.iridescenceMap),
        texCoord: material.iridescenceMap.channel
      };
      writer.applyTextureTransform(iridescenceMapDef, material.iridescenceMap);
      extensionDef.iridescenceTexture = iridescenceMapDef;
    }
    extensionDef.iridescenceIor = material.iridescenceIOR;
    extensionDef.iridescenceThicknessMinimum = material.iridescenceThicknessRange[0];
    extensionDef.iridescenceThicknessMaximum = material.iridescenceThicknessRange[1];
    if (material.iridescenceThicknessMap) {
      const iridescenceThicknessMapDef = {
        index: writer.processTexture(material.iridescenceThicknessMap),
        texCoord: material.iridescenceThicknessMap.channel
      };
      writer.applyTextureTransform(iridescenceThicknessMapDef, material.iridescenceThicknessMap);
      extensionDef.iridescenceThicknessTexture = iridescenceThicknessMapDef;
    }
    materialDef.extensions = materialDef.extensions || {};
    materialDef.extensions[this.name] = extensionDef;
    extensionsUsed[this.name] = true;
  }
};
var GLTFMaterialsTransmissionExtension = class {
  constructor(writer) {
    this.writer = writer;
    this.name = "KHR_materials_transmission";
  }
  writeMaterial(material, materialDef) {
    if (!material.isMeshPhysicalMaterial || material.transmission === 0)
      return;
    const writer = this.writer;
    const extensionsUsed = writer.extensionsUsed;
    const extensionDef = {};
    extensionDef.transmissionFactor = material.transmission;
    if (material.transmissionMap) {
      const transmissionMapDef = {
        index: writer.processTexture(material.transmissionMap),
        texCoord: material.transmissionMap.channel
      };
      writer.applyTextureTransform(transmissionMapDef, material.transmissionMap);
      extensionDef.transmissionTexture = transmissionMapDef;
    }
    materialDef.extensions = materialDef.extensions || {};
    materialDef.extensions[this.name] = extensionDef;
    extensionsUsed[this.name] = true;
  }
};
var GLTFMaterialsVolumeExtension = class {
  constructor(writer) {
    this.writer = writer;
    this.name = "KHR_materials_volume";
  }
  writeMaterial(material, materialDef) {
    if (!material.isMeshPhysicalMaterial || material.transmission === 0)
      return;
    const writer = this.writer;
    const extensionsUsed = writer.extensionsUsed;
    const extensionDef = {};
    extensionDef.thicknessFactor = material.thickness;
    if (material.thicknessMap) {
      const thicknessMapDef = {
        index: writer.processTexture(material.thicknessMap),
        texCoord: material.thicknessMap.channel
      };
      writer.applyTextureTransform(thicknessMapDef, material.thicknessMap);
      extensionDef.thicknessTexture = thicknessMapDef;
    }
    extensionDef.attenuationDistance = material.attenuationDistance;
    extensionDef.attenuationColor = material.attenuationColor.toArray();
    materialDef.extensions = materialDef.extensions || {};
    materialDef.extensions[this.name] = extensionDef;
    extensionsUsed[this.name] = true;
  }
};
var GLTFMaterialsIorExtension = class {
  constructor(writer) {
    this.writer = writer;
    this.name = "KHR_materials_ior";
  }
  writeMaterial(material, materialDef) {
    if (!material.isMeshPhysicalMaterial || material.ior === 1.5)
      return;
    const writer = this.writer;
    const extensionsUsed = writer.extensionsUsed;
    const extensionDef = {};
    extensionDef.ior = material.ior;
    materialDef.extensions = materialDef.extensions || {};
    materialDef.extensions[this.name] = extensionDef;
    extensionsUsed[this.name] = true;
  }
};
var GLTFMaterialsSpecularExtension = class {
  constructor(writer) {
    this.writer = writer;
    this.name = "KHR_materials_specular";
  }
  writeMaterial(material, materialDef) {
    if (!material.isMeshPhysicalMaterial || material.specularIntensity === 1 && material.specularColor.equals(DEFAULT_SPECULAR_COLOR) && !material.specularIntensityMap && !material.specularColorTexture)
      return;
    const writer = this.writer;
    const extensionsUsed = writer.extensionsUsed;
    const extensionDef = {};
    if (material.specularIntensityMap) {
      const specularIntensityMapDef = {
        index: writer.processTexture(material.specularIntensityMap),
        texCoord: material.specularIntensityMap.channel
      };
      writer.applyTextureTransform(specularIntensityMapDef, material.specularIntensityMap);
      extensionDef.specularTexture = specularIntensityMapDef;
    }
    if (material.specularColorMap) {
      const specularColorMapDef = {
        index: writer.processTexture(material.specularColorMap),
        texCoord: material.specularColorMap.channel
      };
      writer.applyTextureTransform(specularColorMapDef, material.specularColorMap);
      extensionDef.specularColorTexture = specularColorMapDef;
    }
    extensionDef.specularFactor = material.specularIntensity;
    extensionDef.specularColorFactor = material.specularColor.toArray();
    materialDef.extensions = materialDef.extensions || {};
    materialDef.extensions[this.name] = extensionDef;
    extensionsUsed[this.name] = true;
  }
};
var GLTFMaterialsSheenExtension = class {
  constructor(writer) {
    this.writer = writer;
    this.name = "KHR_materials_sheen";
  }
  writeMaterial(material, materialDef) {
    if (!material.isMeshPhysicalMaterial || material.sheen == 0)
      return;
    const writer = this.writer;
    const extensionsUsed = writer.extensionsUsed;
    const extensionDef = {};
    if (material.sheenRoughnessMap) {
      const sheenRoughnessMapDef = {
        index: writer.processTexture(material.sheenRoughnessMap),
        texCoord: material.sheenRoughnessMap.channel
      };
      writer.applyTextureTransform(sheenRoughnessMapDef, material.sheenRoughnessMap);
      extensionDef.sheenRoughnessTexture = sheenRoughnessMapDef;
    }
    if (material.sheenColorMap) {
      const sheenColorMapDef = {
        index: writer.processTexture(material.sheenColorMap),
        texCoord: material.sheenColorMap.channel
      };
      writer.applyTextureTransform(sheenColorMapDef, material.sheenColorMap);
      extensionDef.sheenColorTexture = sheenColorMapDef;
    }
    extensionDef.sheenRoughnessFactor = material.sheenRoughness;
    extensionDef.sheenColorFactor = material.sheenColor.toArray();
    materialDef.extensions = materialDef.extensions || {};
    materialDef.extensions[this.name] = extensionDef;
    extensionsUsed[this.name] = true;
  }
};
var GLTFMaterialsAnisotropyExtension = class {
  constructor(writer) {
    this.writer = writer;
    this.name = "KHR_materials_anisotropy";
  }
  writeMaterial(material, materialDef) {
    if (!material.isMeshPhysicalMaterial || material.anisotropy == 0)
      return;
    const writer = this.writer;
    const extensionsUsed = writer.extensionsUsed;
    const extensionDef = {};
    if (material.anisotropyMap) {
      const anisotropyMapDef = { index: writer.processTexture(material.anisotropyMap) };
      writer.applyTextureTransform(anisotropyMapDef, material.anisotropyMap);
      extensionDef.anisotropyTexture = anisotropyMapDef;
    }
    extensionDef.anisotropyStrength = material.anisotropy;
    extensionDef.anisotropyRotation = material.anisotropyRotation;
    materialDef.extensions = materialDef.extensions || {};
    materialDef.extensions[this.name] = extensionDef;
    extensionsUsed[this.name] = true;
  }
};
var GLTFMaterialsEmissiveStrengthExtension = class {
  constructor(writer) {
    this.writer = writer;
    this.name = "KHR_materials_emissive_strength";
  }
  writeMaterial(material, materialDef) {
    if (!material.isMeshStandardMaterial || material.emissiveIntensity === 1)
      return;
    const writer = this.writer;
    const extensionsUsed = writer.extensionsUsed;
    const extensionDef = {};
    extensionDef.emissiveStrength = material.emissiveIntensity;
    materialDef.extensions = materialDef.extensions || {};
    materialDef.extensions[this.name] = extensionDef;
    extensionsUsed[this.name] = true;
  }
};

// node_modules/three-stdlib/node_modules/fflate/esm/browser.js
var ch2 = {};
var wk = (function(c2, id, msg, transfer, cb2) {
  var w = new Worker(ch2[id] || (ch2[id] = URL.createObjectURL(new Blob([c2], { type: "text/javascript" }))));
  w.onerror = function(e2) {
    return cb2(e2.error, null);
  };
  w.onmessage = function(e2) {
    return cb2(null, e2.data);
  };
  w.postMessage(msg, transfer);
  return w;
});
var u8 = Uint8Array;
var u16 = Uint16Array;
var u32 = Uint32Array;
var fleb = new u8([
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  3,
  3,
  3,
  3,
  4,
  4,
  4,
  4,
  5,
  5,
  5,
  5,
  0,
  /* unused */
  0,
  0,
  /* impossible */
  0
]);
var fdeb = new u8([
  0,
  0,
  0,
  0,
  1,
  1,
  2,
  2,
  3,
  3,
  4,
  4,
  5,
  5,
  6,
  6,
  7,
  7,
  8,
  8,
  9,
  9,
  10,
  10,
  11,
  11,
  12,
  12,
  13,
  13,
  /* unused */
  0,
  0
]);
var clim = new u8([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);
var freb = function(eb, start) {
  var b5 = new u16(31);
  for (var i4 = 0; i4 < 31; ++i4) {
    b5[i4] = start += 1 << eb[i4 - 1];
  }
  var r2 = new u32(b5[30]);
  for (var i4 = 1; i4 < 30; ++i4) {
    for (var j = b5[i4]; j < b5[i4 + 1]; ++j) {
      r2[j] = j - b5[i4] << 5 | i4;
    }
  }
  return [b5, r2];
};
var _a2 = freb(fleb, 2);
var fl = _a2[0];
var revfl = _a2[1];
fl[28] = 258, revfl[258] = 28;
var _b2 = freb(fdeb, 0);
var fd = _b2[0];
var revfd = _b2[1];
var rev = new u16(32768);
for (i4 = 0; i4 < 32768; ++i4) {
  x = (i4 & 43690) >>> 1 | (i4 & 21845) << 1;
  x = (x & 52428) >>> 2 | (x & 13107) << 2;
  x = (x & 61680) >>> 4 | (x & 3855) << 4;
  rev[i4] = ((x & 65280) >>> 8 | (x & 255) << 8) >>> 1;
}
var x;
var i4;
var hMap = (function(cd, mb, r2) {
  var s2 = cd.length;
  var i4 = 0;
  var l2 = new u16(mb);
  for (; i4 < s2; ++i4)
    ++l2[cd[i4] - 1];
  var le = new u16(mb);
  for (i4 = 0; i4 < mb; ++i4) {
    le[i4] = le[i4 - 1] + l2[i4 - 1] << 1;
  }
  var co;
  if (r2) {
    co = new u16(1 << mb);
    var rvb = 15 - mb;
    for (i4 = 0; i4 < s2; ++i4) {
      if (cd[i4]) {
        var sv = i4 << 4 | cd[i4];
        var r_1 = mb - cd[i4];
        var v5 = le[cd[i4] - 1]++ << r_1;
        for (var m = v5 | (1 << r_1) - 1; v5 <= m; ++v5) {
          co[rev[v5] >>> rvb] = sv;
        }
      }
    }
  } else {
    co = new u16(s2);
    for (i4 = 0; i4 < s2; ++i4) {
      if (cd[i4]) {
        co[i4] = rev[le[cd[i4] - 1]++] >>> 15 - cd[i4];
      }
    }
  }
  return co;
});
var flt = new u8(288);
for (i4 = 0; i4 < 144; ++i4)
  flt[i4] = 8;
var i4;
for (i4 = 144; i4 < 256; ++i4)
  flt[i4] = 9;
var i4;
for (i4 = 256; i4 < 280; ++i4)
  flt[i4] = 7;
var i4;
for (i4 = 280; i4 < 288; ++i4)
  flt[i4] = 8;
var i4;
var fdt = new u8(32);
for (i4 = 0; i4 < 32; ++i4)
  fdt[i4] = 5;
var i4;
var flm = hMap(flt, 9, 0);
var flrm = hMap(flt, 9, 1);
var fdm = hMap(fdt, 5, 0);
var fdrm = hMap(fdt, 5, 1);
var max = function(a6) {
  var m = a6[0];
  for (var i4 = 1; i4 < a6.length; ++i4) {
    if (a6[i4] > m)
      m = a6[i4];
  }
  return m;
};
var bits = function(d2, p2, m) {
  var o2 = p2 / 8 | 0;
  return (d2[o2] | d2[o2 + 1] << 8) >> (p2 & 7) & m;
};
var bits16 = function(d2, p2) {
  var o2 = p2 / 8 | 0;
  return (d2[o2] | d2[o2 + 1] << 8 | d2[o2 + 2] << 16) >> (p2 & 7);
};
var shft = function(p2) {
  return (p2 / 8 | 0) + (p2 & 7 && 1);
};
var slc = function(v5, s2, e2) {
  if (s2 == null || s2 < 0)
    s2 = 0;
  if (e2 == null || e2 > v5.length)
    e2 = v5.length;
  var n2 = new (v5 instanceof u16 ? u16 : v5 instanceof u32 ? u32 : u8)(e2 - s2);
  n2.set(v5.subarray(s2, e2));
  return n2;
};
var inflt = function(dat, buf, st) {
  var sl = dat.length;
  if (!sl || st && !st.l && sl < 5)
    return buf || new u8(0);
  var noBuf = !buf || st;
  var noSt = !st || st.i;
  if (!st)
    st = {};
  if (!buf)
    buf = new u8(sl * 3);
  var cbuf = function(l3) {
    var bl = buf.length;
    if (l3 > bl) {
      var nbuf = new u8(Math.max(bl * 2, l3));
      nbuf.set(buf);
      buf = nbuf;
    }
  };
  var final = st.f || 0, pos = st.p || 0, bt = st.b || 0, lm = st.l, dm = st.d, lbt = st.m, dbt = st.n;
  var tbts = sl * 8;
  do {
    if (!lm) {
      st.f = final = bits(dat, pos, 1);
      var type = bits(dat, pos + 1, 3);
      pos += 3;
      if (!type) {
        var s2 = shft(pos) + 4, l2 = dat[s2 - 4] | dat[s2 - 3] << 8, t3 = s2 + l2;
        if (t3 > sl) {
          if (noSt)
            throw "unexpected EOF";
          break;
        }
        if (noBuf)
          cbuf(bt + l2);
        buf.set(dat.subarray(s2, t3), bt);
        st.b = bt += l2, st.p = pos = t3 * 8;
        continue;
      } else if (type == 1)
        lm = flrm, dm = fdrm, lbt = 9, dbt = 5;
      else if (type == 2) {
        var hLit = bits(dat, pos, 31) + 257, hcLen = bits(dat, pos + 10, 15) + 4;
        var tl = hLit + bits(dat, pos + 5, 31) + 1;
        pos += 14;
        var ldt = new u8(tl);
        var clt = new u8(19);
        for (var i4 = 0; i4 < hcLen; ++i4) {
          clt[clim[i4]] = bits(dat, pos + i4 * 3, 7);
        }
        pos += hcLen * 3;
        var clb = max(clt), clbmsk = (1 << clb) - 1;
        var clm = hMap(clt, clb, 1);
        for (var i4 = 0; i4 < tl; ) {
          var r2 = clm[bits(dat, pos, clbmsk)];
          pos += r2 & 15;
          var s2 = r2 >>> 4;
          if (s2 < 16) {
            ldt[i4++] = s2;
          } else {
            var c2 = 0, n2 = 0;
            if (s2 == 16)
              n2 = 3 + bits(dat, pos, 3), pos += 2, c2 = ldt[i4 - 1];
            else if (s2 == 17)
              n2 = 3 + bits(dat, pos, 7), pos += 3;
            else if (s2 == 18)
              n2 = 11 + bits(dat, pos, 127), pos += 7;
            while (n2--)
              ldt[i4++] = c2;
          }
        }
        var lt = ldt.subarray(0, hLit), dt = ldt.subarray(hLit);
        lbt = max(lt);
        dbt = max(dt);
        lm = hMap(lt, lbt, 1);
        dm = hMap(dt, dbt, 1);
      } else
        throw "invalid block type";
      if (pos > tbts) {
        if (noSt)
          throw "unexpected EOF";
        break;
      }
    }
    if (noBuf)
      cbuf(bt + 131072);
    var lms = (1 << lbt) - 1, dms = (1 << dbt) - 1;
    var lpos = pos;
    for (; ; lpos = pos) {
      var c2 = lm[bits16(dat, pos) & lms], sym = c2 >>> 4;
      pos += c2 & 15;
      if (pos > tbts) {
        if (noSt)
          throw "unexpected EOF";
        break;
      }
      if (!c2)
        throw "invalid length/literal";
      if (sym < 256)
        buf[bt++] = sym;
      else if (sym == 256) {
        lpos = pos, lm = null;
        break;
      } else {
        var add3 = sym - 254;
        if (sym > 264) {
          var i4 = sym - 257, b5 = fleb[i4];
          add3 = bits(dat, pos, (1 << b5) - 1) + fl[i4];
          pos += b5;
        }
        var d2 = dm[bits16(dat, pos) & dms], dsym = d2 >>> 4;
        if (!d2)
          throw "invalid distance";
        pos += d2 & 15;
        var dt = fd[dsym];
        if (dsym > 3) {
          var b5 = fdeb[dsym];
          dt += bits16(dat, pos) & (1 << b5) - 1, pos += b5;
        }
        if (pos > tbts) {
          if (noSt)
            throw "unexpected EOF";
          break;
        }
        if (noBuf)
          cbuf(bt + 131072);
        var end = bt + add3;
        for (; bt < end; bt += 4) {
          buf[bt] = buf[bt - dt];
          buf[bt + 1] = buf[bt + 1 - dt];
          buf[bt + 2] = buf[bt + 2 - dt];
          buf[bt + 3] = buf[bt + 3 - dt];
        }
        bt = end;
      }
    }
    st.l = lm, st.p = lpos, st.b = bt;
    if (lm)
      final = 1, st.m = lbt, st.d = dm, st.n = dbt;
  } while (!final);
  return bt == buf.length ? buf : slc(buf, 0, bt);
};
var wbits = function(d2, p2, v5) {
  v5 <<= p2 & 7;
  var o2 = p2 / 8 | 0;
  d2[o2] |= v5;
  d2[o2 + 1] |= v5 >>> 8;
};
var wbits16 = function(d2, p2, v5) {
  v5 <<= p2 & 7;
  var o2 = p2 / 8 | 0;
  d2[o2] |= v5;
  d2[o2 + 1] |= v5 >>> 8;
  d2[o2 + 2] |= v5 >>> 16;
};
var hTree = function(d2, mb) {
  var t3 = [];
  for (var i4 = 0; i4 < d2.length; ++i4) {
    if (d2[i4])
      t3.push({ s: i4, f: d2[i4] });
  }
  var s2 = t3.length;
  var t22 = t3.slice();
  if (!s2)
    return [et, 0];
  if (s2 == 1) {
    var v5 = new u8(t3[0].s + 1);
    v5[t3[0].s] = 1;
    return [v5, 1];
  }
  t3.sort(function(a6, b5) {
    return a6.f - b5.f;
  });
  t3.push({ s: -1, f: 25001 });
  var l2 = t3[0], r2 = t3[1], i0 = 0, i1 = 1, i22 = 2;
  t3[0] = { s: -1, f: l2.f + r2.f, l: l2, r: r2 };
  while (i1 != s2 - 1) {
    l2 = t3[t3[i0].f < t3[i22].f ? i0++ : i22++];
    r2 = t3[i0 != i1 && t3[i0].f < t3[i22].f ? i0++ : i22++];
    t3[i1++] = { s: -1, f: l2.f + r2.f, l: l2, r: r2 };
  }
  var maxSym = t22[0].s;
  for (var i4 = 1; i4 < s2; ++i4) {
    if (t22[i4].s > maxSym)
      maxSym = t22[i4].s;
  }
  var tr = new u16(maxSym + 1);
  var mbt = ln(t3[i1 - 1], tr, 0);
  if (mbt > mb) {
    var i4 = 0, dt = 0;
    var lft = mbt - mb, cst = 1 << lft;
    t22.sort(function(a6, b5) {
      return tr[b5.s] - tr[a6.s] || a6.f - b5.f;
    });
    for (; i4 < s2; ++i4) {
      var i2_1 = t22[i4].s;
      if (tr[i2_1] > mb) {
        dt += cst - (1 << mbt - tr[i2_1]);
        tr[i2_1] = mb;
      } else
        break;
    }
    dt >>>= lft;
    while (dt > 0) {
      var i2_2 = t22[i4].s;
      if (tr[i2_2] < mb)
        dt -= 1 << mb - tr[i2_2]++ - 1;
      else
        ++i4;
    }
    for (; i4 >= 0 && dt; --i4) {
      var i2_3 = t22[i4].s;
      if (tr[i2_3] == mb) {
        --tr[i2_3];
        ++dt;
      }
    }
    mbt = mb;
  }
  return [new u8(tr), mbt];
};
var ln = function(n2, l2, d2) {
  return n2.s == -1 ? Math.max(ln(n2.l, l2, d2 + 1), ln(n2.r, l2, d2 + 1)) : l2[n2.s] = d2;
};
var lc = function(c2) {
  var s2 = c2.length;
  while (s2 && !c2[--s2])
    ;
  var cl = new u16(++s2);
  var cli = 0, cln = c2[0], cls = 1;
  var w = function(v5) {
    cl[cli++] = v5;
  };
  for (var i4 = 1; i4 <= s2; ++i4) {
    if (c2[i4] == cln && i4 != s2)
      ++cls;
    else {
      if (!cln && cls > 2) {
        for (; cls > 138; cls -= 138)
          w(32754);
        if (cls > 2) {
          w(cls > 10 ? cls - 11 << 5 | 28690 : cls - 3 << 5 | 12305);
          cls = 0;
        }
      } else if (cls > 3) {
        w(cln), --cls;
        for (; cls > 6; cls -= 6)
          w(8304);
        if (cls > 2)
          w(cls - 3 << 5 | 8208), cls = 0;
      }
      while (cls--)
        w(cln);
      cls = 1;
      cln = c2[i4];
    }
  }
  return [cl.subarray(0, cli), s2];
};
var clen = function(cf, cl) {
  var l2 = 0;
  for (var i4 = 0; i4 < cl.length; ++i4)
    l2 += cf[i4] * cl[i4];
  return l2;
};
var wfblk = function(out7, pos, dat) {
  var s2 = dat.length;
  var o2 = shft(pos + 2);
  out7[o2] = s2 & 255;
  out7[o2 + 1] = s2 >>> 8;
  out7[o2 + 2] = out7[o2] ^ 255;
  out7[o2 + 3] = out7[o2 + 1] ^ 255;
  for (var i4 = 0; i4 < s2; ++i4)
    out7[o2 + i4 + 4] = dat[i4];
  return (o2 + 4 + s2) * 8;
};
var wblk = function(dat, out7, final, syms, lf, df, eb, li, bs, bl, p2) {
  wbits(out7, p2++, final);
  ++lf[256];
  var _a4 = hTree(lf, 15), dlt = _a4[0], mlb = _a4[1];
  var _b3 = hTree(df, 15), ddt = _b3[0], mdb = _b3[1];
  var _c = lc(dlt), lclt = _c[0], nlc = _c[1];
  var _d = lc(ddt), lcdt = _d[0], ndc = _d[1];
  var lcfreq = new u16(19);
  for (var i4 = 0; i4 < lclt.length; ++i4)
    lcfreq[lclt[i4] & 31]++;
  for (var i4 = 0; i4 < lcdt.length; ++i4)
    lcfreq[lcdt[i4] & 31]++;
  var _e = hTree(lcfreq, 7), lct = _e[0], mlcb = _e[1];
  var nlcc = 19;
  for (; nlcc > 4 && !lct[clim[nlcc - 1]]; --nlcc)
    ;
  var flen = bl + 5 << 3;
  var ftlen = clen(lf, flt) + clen(df, fdt) + eb;
  var dtlen = clen(lf, dlt) + clen(df, ddt) + eb + 14 + 3 * nlcc + clen(lcfreq, lct) + (2 * lcfreq[16] + 3 * lcfreq[17] + 7 * lcfreq[18]);
  if (flen <= ftlen && flen <= dtlen)
    return wfblk(out7, p2, dat.subarray(bs, bs + bl));
  var lm, ll, dm, dl;
  wbits(out7, p2, 1 + (dtlen < ftlen)), p2 += 2;
  if (dtlen < ftlen) {
    lm = hMap(dlt, mlb, 0), ll = dlt, dm = hMap(ddt, mdb, 0), dl = ddt;
    var llm = hMap(lct, mlcb, 0);
    wbits(out7, p2, nlc - 257);
    wbits(out7, p2 + 5, ndc - 1);
    wbits(out7, p2 + 10, nlcc - 4);
    p2 += 14;
    for (var i4 = 0; i4 < nlcc; ++i4)
      wbits(out7, p2 + 3 * i4, lct[clim[i4]]);
    p2 += 3 * nlcc;
    var lcts = [lclt, lcdt];
    for (var it = 0; it < 2; ++it) {
      var clct = lcts[it];
      for (var i4 = 0; i4 < clct.length; ++i4) {
        var len = clct[i4] & 31;
        wbits(out7, p2, llm[len]), p2 += lct[len];
        if (len > 15)
          wbits(out7, p2, clct[i4] >>> 5 & 127), p2 += clct[i4] >>> 12;
      }
    }
  } else {
    lm = flm, ll = flt, dm = fdm, dl = fdt;
  }
  for (var i4 = 0; i4 < li; ++i4) {
    if (syms[i4] > 255) {
      var len = syms[i4] >>> 18 & 31;
      wbits16(out7, p2, lm[len + 257]), p2 += ll[len + 257];
      if (len > 7)
        wbits(out7, p2, syms[i4] >>> 23 & 31), p2 += fleb[len];
      var dst = syms[i4] & 31;
      wbits16(out7, p2, dm[dst]), p2 += dl[dst];
      if (dst > 3)
        wbits16(out7, p2, syms[i4] >>> 5 & 8191), p2 += fdeb[dst];
    } else {
      wbits16(out7, p2, lm[syms[i4]]), p2 += ll[syms[i4]];
    }
  }
  wbits16(out7, p2, lm[256]);
  return p2 + ll[256];
};
var deo = new u32([65540, 131080, 131088, 131104, 262176, 1048704, 1048832, 2114560, 2117632]);
var et = new u8(0);
var dflt = function(dat, lvl, plvl, pre, post, lst) {
  var s2 = dat.length;
  var o2 = new u8(pre + s2 + 5 * (1 + Math.ceil(s2 / 7e3)) + post);
  var w = o2.subarray(pre, o2.length - post);
  var pos = 0;
  if (!lvl || s2 < 8) {
    for (var i4 = 0; i4 <= s2; i4 += 65535) {
      var e2 = i4 + 65535;
      if (e2 < s2) {
        pos = wfblk(w, pos, dat.subarray(i4, e2));
      } else {
        w[i4] = lst;
        pos = wfblk(w, pos, dat.subarray(i4, s2));
      }
    }
  } else {
    var opt = deo[lvl - 1];
    var n2 = opt >>> 13, c2 = opt & 8191;
    var msk_1 = (1 << plvl) - 1;
    var prev = new u16(32768), head = new u16(msk_1 + 1);
    var bs1_1 = Math.ceil(plvl / 3), bs2_1 = 2 * bs1_1;
    var hsh = function(i5) {
      return (dat[i5] ^ dat[i5 + 1] << bs1_1 ^ dat[i5 + 2] << bs2_1) & msk_1;
    };
    var syms = new u32(25e3);
    var lf = new u16(288), df = new u16(32);
    var lc_1 = 0, eb = 0, i4 = 0, li = 0, wi = 0, bs = 0;
    for (; i4 < s2; ++i4) {
      var hv = hsh(i4);
      var imod = i4 & 32767, pimod = head[hv];
      prev[imod] = pimod;
      head[hv] = imod;
      if (wi <= i4) {
        var rem = s2 - i4;
        if ((lc_1 > 7e3 || li > 24576) && rem > 423) {
          pos = wblk(dat, w, 0, syms, lf, df, eb, li, bs, i4 - bs, pos);
          li = lc_1 = eb = 0, bs = i4;
          for (var j = 0; j < 286; ++j)
            lf[j] = 0;
          for (var j = 0; j < 30; ++j)
            df[j] = 0;
        }
        var l2 = 2, d2 = 0, ch_1 = c2, dif = imod - pimod & 32767;
        if (rem > 2 && hv == hsh(i4 - dif)) {
          var maxn = Math.min(n2, rem) - 1;
          var maxd = Math.min(32767, i4);
          var ml = Math.min(258, rem);
          while (dif <= maxd && --ch_1 && imod != pimod) {
            if (dat[i4 + l2] == dat[i4 + l2 - dif]) {
              var nl = 0;
              for (; nl < ml && dat[i4 + nl] == dat[i4 + nl - dif]; ++nl)
                ;
              if (nl > l2) {
                l2 = nl, d2 = dif;
                if (nl > maxn)
                  break;
                var mmd = Math.min(dif, nl - 2);
                var md = 0;
                for (var j = 0; j < mmd; ++j) {
                  var ti = i4 - dif + j + 32768 & 32767;
                  var pti = prev[ti];
                  var cd = ti - pti + 32768 & 32767;
                  if (cd > md)
                    md = cd, pimod = ti;
                }
              }
            }
            imod = pimod, pimod = prev[imod];
            dif += imod - pimod + 32768 & 32767;
          }
        }
        if (d2) {
          syms[li++] = 268435456 | revfl[l2] << 18 | revfd[d2];
          var lin = revfl[l2] & 31, din = revfd[d2] & 31;
          eb += fleb[lin] + fdeb[din];
          ++lf[257 + lin];
          ++df[din];
          wi = i4 + l2;
          ++lc_1;
        } else {
          syms[li++] = dat[i4];
          ++lf[dat[i4]];
        }
      }
    }
    pos = wblk(dat, w, lst, syms, lf, df, eb, li, bs, i4 - bs, pos);
    if (!lst && pos & 7)
      pos = wfblk(w, pos + 1, et);
  }
  return slc(o2, 0, pre + shft(pos) + post);
};
var crct = (function() {
  var t3 = new Int32Array(256);
  for (var i4 = 0; i4 < 256; ++i4) {
    var c2 = i4, k = 9;
    while (--k)
      c2 = (c2 & 1 && -306674912) ^ c2 >>> 1;
    t3[i4] = c2;
  }
  return t3;
})();
var crc = function() {
  var c2 = -1;
  return {
    p: function(d2) {
      var cr = c2;
      for (var i4 = 0; i4 < d2.length; ++i4)
        cr = crct[cr & 255 ^ d2[i4]] ^ cr >>> 8;
      c2 = cr;
    },
    d: function() {
      return ~c2;
    }
  };
};
var adler = function() {
  var a6 = 1, b5 = 0;
  return {
    p: function(d2) {
      var n2 = a6, m = b5;
      var l2 = d2.length;
      for (var i4 = 0; i4 != l2; ) {
        var e2 = Math.min(i4 + 2655, l2);
        for (; i4 < e2; ++i4)
          m += n2 += d2[i4];
        n2 = (n2 & 65535) + 15 * (n2 >> 16), m = (m & 65535) + 15 * (m >> 16);
      }
      a6 = n2, b5 = m;
    },
    d: function() {
      a6 %= 65521, b5 %= 65521;
      return (a6 & 255) << 24 | a6 >>> 8 << 16 | (b5 & 255) << 8 | b5 >>> 8;
    }
  };
};
var dopt = function(dat, opt, pre, post, st) {
  return dflt(dat, opt.level == null ? 6 : opt.level, opt.mem == null ? Math.ceil(Math.max(8, Math.min(13, Math.log(dat.length))) * 1.5) : 12 + opt.mem, pre, post, !st);
};
var mrg = function(a6, b5) {
  var o2 = {};
  for (var k in a6)
    o2[k] = a6[k];
  for (var k in b5)
    o2[k] = b5[k];
  return o2;
};
var wcln = function(fn, fnStr, td2) {
  var dt = fn();
  var st = fn.toString();
  var ks = st.slice(st.indexOf("[") + 1, st.lastIndexOf("]")).replace(/ /g, "").split(",");
  for (var i4 = 0; i4 < dt.length; ++i4) {
    var v5 = dt[i4], k = ks[i4];
    if (typeof v5 == "function") {
      fnStr += ";" + k + "=";
      var st_1 = v5.toString();
      if (v5.prototype) {
        if (st_1.indexOf("[native code]") != -1) {
          var spInd = st_1.indexOf(" ", 8) + 1;
          fnStr += st_1.slice(spInd, st_1.indexOf("(", spInd));
        } else {
          fnStr += st_1;
          for (var t3 in v5.prototype)
            fnStr += ";" + k + ".prototype." + t3 + "=" + v5.prototype[t3].toString();
        }
      } else
        fnStr += st_1;
    } else
      td2[k] = v5;
  }
  return [fnStr, td2];
};
var ch = [];
var cbfs = function(v5) {
  var tl = [];
  for (var k in v5) {
    if (v5[k] instanceof u8 || v5[k] instanceof u16 || v5[k] instanceof u32)
      tl.push((v5[k] = new v5[k].constructor(v5[k])).buffer);
  }
  return tl;
};
var wrkr = function(fns, init3, id, cb2) {
  var _a4;
  if (!ch[id]) {
    var fnStr = "", td_1 = {}, m = fns.length - 1;
    for (var i4 = 0; i4 < m; ++i4)
      _a4 = wcln(fns[i4], fnStr, td_1), fnStr = _a4[0], td_1 = _a4[1];
    ch[id] = wcln(fns[m], fnStr, td_1);
  }
  var td2 = mrg({}, ch[id][1]);
  return wk(ch[id][0] + ";onmessage=function(e){for(var k in e.data)self[k]=e.data[k];onmessage=" + init3.toString() + "}", id, td2, cbfs(td2), cb2);
};
var bInflt = function() {
  return [u8, u16, u32, fleb, fdeb, clim, fl, fd, flrm, fdrm, rev, hMap, max, bits, bits16, shft, slc, inflt, inflateSync, pbf, gu8];
};
var bDflt = function() {
  return [u8, u16, u32, fleb, fdeb, clim, revfl, revfd, flm, flt, fdm, fdt, rev, deo, et, hMap, wbits, wbits16, hTree, ln, lc, clen, wfblk, wblk, shft, slc, dflt, dopt, deflateSync, pbf];
};
var guze = function() {
  return [gzs, gzl];
};
var zule = function() {
  return [zlv];
};
var pbf = function(msg) {
  return postMessage(msg, [msg.buffer]);
};
var gu8 = function(o2) {
  return o2 && o2.size && new u8(o2.size);
};
var astrm = function(strm) {
  strm.ondata = function(dat, final) {
    return postMessage([dat, final], [dat.buffer]);
  };
  return function(ev) {
    return strm.push(ev.data[0], ev.data[1]);
  };
};
var astrmify = function(fns, strm, opts, init3, id) {
  var t3;
  var w = wrkr(fns, init3, id, function(err, dat) {
    if (err)
      w.terminate(), strm.ondata.call(strm, err);
    else {
      if (dat[1])
        w.terminate();
      strm.ondata.call(strm, err, dat[0], dat[1]);
    }
  });
  w.postMessage(opts);
  strm.push = function(d2, f2) {
    if (t3)
      throw "stream finished";
    if (!strm.ondata)
      throw "no stream handler";
    w.postMessage([d2, t3 = f2], [d2.buffer]);
  };
  strm.terminate = function() {
    w.terminate();
  };
};
var b22 = function(d2, b5) {
  return d2[b5] | d2[b5 + 1] << 8;
};
var b42 = function(d2, b5) {
  return (d2[b5] | d2[b5 + 1] << 8 | d2[b5 + 2] << 16 | d2[b5 + 3] << 24) >>> 0;
};
var b8 = function(d2, b5) {
  return b42(d2, b5) + b42(d2, b5 + 4) * 4294967296;
};
var wbytes = function(d2, b5, v5) {
  for (; v5; ++b5)
    d2[b5] = v5, v5 >>>= 8;
};
var gzh = function(c2, o2) {
  var fn = o2.filename;
  c2[0] = 31, c2[1] = 139, c2[2] = 8, c2[8] = o2.level < 2 ? 4 : o2.level == 9 ? 2 : 0, c2[9] = 3;
  if (o2.mtime != 0)
    wbytes(c2, 4, Math.floor(new Date(o2.mtime || Date.now()) / 1e3));
  if (fn) {
    c2[3] = 8;
    for (var i4 = 0; i4 <= fn.length; ++i4)
      c2[i4 + 10] = fn.charCodeAt(i4);
  }
};
var gzs = function(d2) {
  if (d2[0] != 31 || d2[1] != 139 || d2[2] != 8)
    throw "invalid gzip data";
  var flg = d2[3];
  var st = 10;
  if (flg & 4)
    st += d2[10] | (d2[11] << 8) + 2;
  for (var zs = (flg >> 3 & 1) + (flg >> 4 & 1); zs > 0; zs -= !d2[st++])
    ;
  return st + (flg & 2);
};
var gzl = function(d2) {
  var l2 = d2.length;
  return (d2[l2 - 4] | d2[l2 - 3] << 8 | d2[l2 - 2] << 16 | d2[l2 - 1] << 24) >>> 0;
};
var gzhl = function(o2) {
  return 10 + (o2.filename && o2.filename.length + 1 || 0);
};
var zlh = function(c2, o2) {
  var lv = o2.level, fl2 = lv == 0 ? 0 : lv < 6 ? 1 : lv == 9 ? 3 : 2;
  c2[0] = 120, c2[1] = fl2 << 6 | (fl2 ? 32 - 2 * fl2 : 1);
};
var zlv = function(d2) {
  if ((d2[0] & 15) != 8 || d2[0] >>> 4 > 7 || (d2[0] << 8 | d2[1]) % 31)
    throw "invalid zlib data";
  if (d2[1] & 32)
    throw "invalid zlib data: preset dictionaries not supported";
};
function AsyncCmpStrm(opts, cb2) {
  if (!cb2 && typeof opts == "function")
    cb2 = opts, opts = {};
  this.ondata = cb2;
  return opts;
}
var Deflate = (function() {
  function Deflate2(opts, cb2) {
    if (!cb2 && typeof opts == "function")
      cb2 = opts, opts = {};
    this.ondata = cb2;
    this.o = opts || {};
  }
  Deflate2.prototype.p = function(c2, f2) {
    this.ondata(dopt(c2, this.o, 0, 0, !f2), f2);
  };
  Deflate2.prototype.push = function(chunk, final) {
    if (this.d)
      throw "stream finished";
    if (!this.ondata)
      throw "no stream handler";
    this.d = final;
    this.p(chunk, final || false);
  };
  return Deflate2;
})();
var AsyncDeflate = /* @__PURE__ */ (function() {
  function AsyncDeflate2(opts, cb2) {
    astrmify([
      bDflt,
      function() {
        return [astrm, Deflate];
      }
    ], this, AsyncCmpStrm.call(this, opts, cb2), function(ev) {
      var strm = new Deflate(ev.data);
      onmessage = astrm(strm);
    }, 6);
  }
  return AsyncDeflate2;
})();
function deflateSync(data, opts) {
  return dopt(data, opts || {}, 0, 0);
}
var Inflate = (function() {
  function Inflate2(cb2) {
    this.s = {};
    this.p = new u8(0);
    this.ondata = cb2;
  }
  Inflate2.prototype.e = function(c2) {
    if (this.d)
      throw "stream finished";
    if (!this.ondata)
      throw "no stream handler";
    var l2 = this.p.length;
    var n2 = new u8(l2 + c2.length);
    n2.set(this.p), n2.set(c2, l2), this.p = n2;
  };
  Inflate2.prototype.c = function(final) {
    this.d = this.s.i = final || false;
    var bts = this.s.b;
    var dt = inflt(this.p, this.o, this.s);
    this.ondata(slc(dt, bts, this.s.b), this.d);
    this.o = slc(dt, this.s.b - 32768), this.s.b = this.o.length;
    this.p = slc(this.p, this.s.p / 8 | 0), this.s.p &= 7;
  };
  Inflate2.prototype.push = function(chunk, final) {
    this.e(chunk), this.c(final);
  };
  return Inflate2;
})();
var AsyncInflate = /* @__PURE__ */ (function() {
  function AsyncInflate2(cb2) {
    this.ondata = cb2;
    astrmify([
      bInflt,
      function() {
        return [astrm, Inflate];
      }
    ], this, 0, function() {
      var strm = new Inflate();
      onmessage = astrm(strm);
    }, 7);
  }
  return AsyncInflate2;
})();
function inflateSync(data, out7) {
  return inflt(data, out7);
}
var Gzip = (function() {
  function Gzip2(opts, cb2) {
    this.c = crc();
    this.l = 0;
    this.v = 1;
    Deflate.call(this, opts, cb2);
  }
  Gzip2.prototype.push = function(chunk, final) {
    Deflate.prototype.push.call(this, chunk, final);
  };
  Gzip2.prototype.p = function(c2, f2) {
    this.c.p(c2);
    this.l += c2.length;
    var raw = dopt(c2, this.o, this.v && gzhl(this.o), f2 && 8, !f2);
    if (this.v)
      gzh(raw, this.o), this.v = 0;
    if (f2)
      wbytes(raw, raw.length - 8, this.c.d()), wbytes(raw, raw.length - 4, this.l);
    this.ondata(raw, f2);
  };
  return Gzip2;
})();
var Gunzip = (function() {
  function Gunzip2(cb2) {
    this.v = 1;
    Inflate.call(this, cb2);
  }
  Gunzip2.prototype.push = function(chunk, final) {
    Inflate.prototype.e.call(this, chunk);
    if (this.v) {
      var s2 = this.p.length > 3 ? gzs(this.p) : 4;
      if (s2 >= this.p.length && !final)
        return;
      this.p = this.p.subarray(s2), this.v = 0;
    }
    if (final) {
      if (this.p.length < 8)
        throw "invalid gzip stream";
      this.p = this.p.subarray(0, -8);
    }
    Inflate.prototype.c.call(this, final);
  };
  return Gunzip2;
})();
var AsyncGunzip = /* @__PURE__ */ (function() {
  function AsyncGunzip2(cb2) {
    this.ondata = cb2;
    astrmify([
      bInflt,
      guze,
      function() {
        return [astrm, Inflate, Gunzip];
      }
    ], this, 0, function() {
      var strm = new Gunzip();
      onmessage = astrm(strm);
    }, 9);
  }
  return AsyncGunzip2;
})();
var Zlib = (function() {
  function Zlib2(opts, cb2) {
    this.c = adler();
    this.v = 1;
    Deflate.call(this, opts, cb2);
  }
  Zlib2.prototype.push = function(chunk, final) {
    Deflate.prototype.push.call(this, chunk, final);
  };
  Zlib2.prototype.p = function(c2, f2) {
    this.c.p(c2);
    var raw = dopt(c2, this.o, this.v && 2, f2 && 4, !f2);
    if (this.v)
      zlh(raw, this.o), this.v = 0;
    if (f2)
      wbytes(raw, raw.length - 4, this.c.d());
    this.ondata(raw, f2);
  };
  return Zlib2;
})();
var Unzlib = (function() {
  function Unzlib2(cb2) {
    this.v = 1;
    Inflate.call(this, cb2);
  }
  Unzlib2.prototype.push = function(chunk, final) {
    Inflate.prototype.e.call(this, chunk);
    if (this.v) {
      if (this.p.length < 2 && !final)
        return;
      this.p = this.p.subarray(2), this.v = 0;
    }
    if (final) {
      if (this.p.length < 4)
        throw "invalid zlib stream";
      this.p = this.p.subarray(0, -4);
    }
    Inflate.prototype.c.call(this, final);
  };
  return Unzlib2;
})();
var AsyncUnzlib = /* @__PURE__ */ (function() {
  function AsyncUnzlib2(cb2) {
    this.ondata = cb2;
    astrmify([
      bInflt,
      zule,
      function() {
        return [astrm, Inflate, Unzlib];
      }
    ], this, 0, function() {
      var strm = new Unzlib();
      onmessage = astrm(strm);
    }, 11);
  }
  return AsyncUnzlib2;
})();
function unzlibSync(data, out7) {
  return inflt((zlv(data), data.subarray(2, -4)), out7);
}
var Decompress = (function() {
  function Decompress2(cb2) {
    this.G = Gunzip;
    this.I = Inflate;
    this.Z = Unzlib;
    this.ondata = cb2;
  }
  Decompress2.prototype.push = function(chunk, final) {
    if (!this.ondata)
      throw "no stream handler";
    if (!this.s) {
      if (this.p && this.p.length) {
        var n2 = new u8(this.p.length + chunk.length);
        n2.set(this.p), n2.set(chunk, this.p.length);
      } else
        this.p = chunk;
      if (this.p.length > 2) {
        var _this_1 = this;
        var cb2 = function() {
          _this_1.ondata.apply(_this_1, arguments);
        };
        this.s = this.p[0] == 31 && this.p[1] == 139 && this.p[2] == 8 ? new this.G(cb2) : (this.p[0] & 15) != 8 || this.p[0] >> 4 > 7 || (this.p[0] << 8 | this.p[1]) % 31 ? new this.I(cb2) : new this.Z(cb2);
        this.s.push(this.p, final);
        this.p = null;
      }
    } else
      this.s.push(chunk, final);
  };
  return Decompress2;
})();
var AsyncDecompress = (function() {
  function AsyncDecompress2(cb2) {
    this.G = AsyncGunzip;
    this.I = AsyncInflate;
    this.Z = AsyncUnzlib;
    this.ondata = cb2;
  }
  AsyncDecompress2.prototype.push = function(chunk, final) {
    Decompress.prototype.push.call(this, chunk, final);
  };
  return AsyncDecompress2;
})();
var te = typeof TextEncoder != "undefined" && new TextEncoder();
var td = typeof TextDecoder != "undefined" && new TextDecoder();
var tds = 0;
try {
  td.decode(et, { stream: true });
  tds = 1;
} catch (e2) {
}
var dutf8 = function(d2) {
  for (var r2 = "", i4 = 0; ; ) {
    var c2 = d2[i4++];
    var eb = (c2 > 127) + (c2 > 223) + (c2 > 239);
    if (i4 + eb > d2.length)
      return [r2, slc(d2, i4 - 1)];
    if (!eb)
      r2 += String.fromCharCode(c2);
    else if (eb == 3) {
      c2 = ((c2 & 15) << 18 | (d2[i4++] & 63) << 12 | (d2[i4++] & 63) << 6 | d2[i4++] & 63) - 65536, r2 += String.fromCharCode(55296 | c2 >> 10, 56320 | c2 & 1023);
    } else if (eb & 1)
      r2 += String.fromCharCode((c2 & 31) << 6 | d2[i4++] & 63);
    else
      r2 += String.fromCharCode((c2 & 15) << 12 | (d2[i4++] & 63) << 6 | d2[i4++] & 63);
  }
};
var DecodeUTF8 = (function() {
  function DecodeUTF82(cb2) {
    this.ondata = cb2;
    if (tds)
      this.t = new TextDecoder();
    else
      this.p = et;
  }
  DecodeUTF82.prototype.push = function(chunk, final) {
    if (!this.ondata)
      throw "no callback";
    final = !!final;
    if (this.t) {
      this.ondata(this.t.decode(chunk, { stream: true }), final);
      if (final) {
        if (this.t.decode().length)
          throw "invalid utf-8 data";
        this.t = null;
      }
      return;
    }
    if (!this.p)
      throw "stream finished";
    var dat = new u8(this.p.length + chunk.length);
    dat.set(this.p);
    dat.set(chunk, this.p.length);
    var _a4 = dutf8(dat), ch3 = _a4[0], np = _a4[1];
    if (final) {
      if (np.length)
        throw "invalid utf-8 data";
      this.p = null;
    } else
      this.p = np;
    this.ondata(ch3, final);
  };
  return DecodeUTF82;
})();
var EncodeUTF8 = (function() {
  function EncodeUTF82(cb2) {
    this.ondata = cb2;
  }
  EncodeUTF82.prototype.push = function(chunk, final) {
    if (!this.ondata)
      throw "no callback";
    if (this.d)
      throw "stream finished";
    this.ondata(strToU8(chunk), this.d = final || false);
  };
  return EncodeUTF82;
})();
function strToU8(str, latin1) {
  if (latin1) {
    var ar_1 = new u8(str.length);
    for (var i4 = 0; i4 < str.length; ++i4)
      ar_1[i4] = str.charCodeAt(i4);
    return ar_1;
  }
  if (te)
    return te.encode(str);
  var l2 = str.length;
  var ar = new u8(str.length + (str.length >> 1));
  var ai = 0;
  var w = function(v5) {
    ar[ai++] = v5;
  };
  for (var i4 = 0; i4 < l2; ++i4) {
    if (ai + 5 > ar.length) {
      var n2 = new u8(ai + 8 + (l2 - i4 << 1));
      n2.set(ar);
      ar = n2;
    }
    var c2 = str.charCodeAt(i4);
    if (c2 < 128 || latin1)
      w(c2);
    else if (c2 < 2048)
      w(192 | c2 >> 6), w(128 | c2 & 63);
    else if (c2 > 55295 && c2 < 57344)
      c2 = 65536 + (c2 & 1023 << 10) | str.charCodeAt(++i4) & 1023, w(240 | c2 >> 18), w(128 | c2 >> 12 & 63), w(128 | c2 >> 6 & 63), w(128 | c2 & 63);
    else
      w(224 | c2 >> 12), w(128 | c2 >> 6 & 63), w(128 | c2 & 63);
  }
  return slc(ar, 0, ai);
}
function strFromU8(dat, latin1) {
  if (latin1) {
    var r2 = "";
    for (var i4 = 0; i4 < dat.length; i4 += 16384)
      r2 += String.fromCharCode.apply(null, dat.subarray(i4, i4 + 16384));
    return r2;
  } else if (td)
    return td.decode(dat);
  else {
    var _a4 = dutf8(dat), out7 = _a4[0], ext = _a4[1];
    if (ext.length)
      throw "invalid utf-8 data";
    return out7;
  }
}
var dbf = function(l2) {
  return l2 == 1 ? 3 : l2 < 6 ? 2 : l2 == 9 ? 1 : 0;
};
var z64e = function(d2, b5) {
  for (; b22(d2, b5) != 1; b5 += 4 + b22(d2, b5 + 2))
    ;
  return [b8(d2, b5 + 12), b8(d2, b5 + 4), b8(d2, b5 + 20)];
};
var exfl = function(ex) {
  var le = 0;
  if (ex) {
    for (var k in ex) {
      var l2 = ex[k].length;
      if (l2 > 65535)
        throw "extra field too long";
      le += l2 + 4;
    }
  }
  return le;
};
var wzh = function(d2, b5, f2, fn, u, c2, ce, co) {
  var fl2 = fn.length, ex = f2.extra, col3 = co && co.length;
  var exl = exfl(ex);
  wbytes(d2, b5, ce != null ? 33639248 : 67324752), b5 += 4;
  if (ce != null)
    d2[b5++] = 20, d2[b5++] = f2.os;
  d2[b5] = 20, b5 += 2;
  d2[b5++] = f2.flag << 1 | (c2 == null && 8), d2[b5++] = u && 8;
  d2[b5++] = f2.compression & 255, d2[b5++] = f2.compression >> 8;
  var dt = new Date(f2.mtime == null ? Date.now() : f2.mtime), y = dt.getFullYear() - 1980;
  if (y < 0 || y > 119)
    throw "date not in range 1980-2099";
  wbytes(d2, b5, y << 25 | dt.getMonth() + 1 << 21 | dt.getDate() << 16 | dt.getHours() << 11 | dt.getMinutes() << 5 | dt.getSeconds() >>> 1), b5 += 4;
  if (c2 != null) {
    wbytes(d2, b5, f2.crc);
    wbytes(d2, b5 + 4, c2);
    wbytes(d2, b5 + 8, f2.size);
  }
  wbytes(d2, b5 + 12, fl2);
  wbytes(d2, b5 + 14, exl), b5 += 16;
  if (ce != null) {
    wbytes(d2, b5, col3);
    wbytes(d2, b5 + 6, f2.attrs);
    wbytes(d2, b5 + 10, ce), b5 += 14;
  }
  d2.set(fn, b5);
  b5 += fl2;
  if (exl) {
    for (var k in ex) {
      var exf = ex[k], l2 = exf.length;
      wbytes(d2, b5, +k);
      wbytes(d2, b5 + 2, l2);
      d2.set(exf, b5 + 4), b5 += 4 + l2;
    }
  }
  if (col3)
    d2.set(co, b5), b5 += col3;
  return b5;
};
var wzf = function(o2, b5, c2, d2, e2) {
  wbytes(o2, b5, 101010256);
  wbytes(o2, b5 + 8, c2);
  wbytes(o2, b5 + 10, c2);
  wbytes(o2, b5 + 12, d2);
  wbytes(o2, b5 + 16, e2);
};
var ZipPassThrough = (function() {
  function ZipPassThrough2(filename) {
    this.filename = filename;
    this.c = crc();
    this.size = 0;
    this.compression = 0;
  }
  ZipPassThrough2.prototype.process = function(chunk, final) {
    this.ondata(null, chunk, final);
  };
  ZipPassThrough2.prototype.push = function(chunk, final) {
    if (!this.ondata)
      throw "no callback - add to ZIP archive before pushing";
    this.c.p(chunk);
    this.size += chunk.length;
    if (final)
      this.crc = this.c.d();
    this.process(chunk, final || false);
  };
  return ZipPassThrough2;
})();
var ZipDeflate = (function() {
  function ZipDeflate2(filename, opts) {
    var _this_1 = this;
    if (!opts)
      opts = {};
    ZipPassThrough.call(this, filename);
    this.d = new Deflate(opts, function(dat, final) {
      _this_1.ondata(null, dat, final);
    });
    this.compression = 8;
    this.flag = dbf(opts.level);
  }
  ZipDeflate2.prototype.process = function(chunk, final) {
    try {
      this.d.push(chunk, final);
    } catch (e2) {
      this.ondata(e2, null, final);
    }
  };
  ZipDeflate2.prototype.push = function(chunk, final) {
    ZipPassThrough.prototype.push.call(this, chunk, final);
  };
  return ZipDeflate2;
})();
var AsyncZipDeflate = (function() {
  function AsyncZipDeflate2(filename, opts) {
    var _this_1 = this;
    if (!opts)
      opts = {};
    ZipPassThrough.call(this, filename);
    this.d = new AsyncDeflate(opts, function(err, dat, final) {
      _this_1.ondata(err, dat, final);
    });
    this.compression = 8;
    this.flag = dbf(opts.level);
    this.terminate = this.d.terminate;
  }
  AsyncZipDeflate2.prototype.process = function(chunk, final) {
    this.d.push(chunk, final);
  };
  AsyncZipDeflate2.prototype.push = function(chunk, final) {
    ZipPassThrough.prototype.push.call(this, chunk, final);
  };
  return AsyncZipDeflate2;
})();
var Zip = (function() {
  function Zip2(cb2) {
    this.ondata = cb2;
    this.u = [];
    this.d = 1;
  }
  Zip2.prototype.add = function(file) {
    var _this_1 = this;
    if (this.d & 2)
      throw "stream finished";
    var f2 = strToU8(file.filename), fl2 = f2.length;
    var com = file.comment, o2 = com && strToU8(com);
    var u = fl2 != file.filename.length || o2 && com.length != o2.length;
    var hl = fl2 + exfl(file.extra) + 30;
    if (fl2 > 65535)
      throw "filename too long";
    var header = new u8(hl);
    wzh(header, 0, file, f2, u);
    var chks = [header];
    var pAll = function() {
      for (var _i = 0, chks_1 = chks; _i < chks_1.length; _i++) {
        var chk = chks_1[_i];
        _this_1.ondata(null, chk, false);
      }
      chks = [];
    };
    var tr = this.d;
    this.d = 0;
    var ind = this.u.length;
    var uf = mrg(file, {
      f: f2,
      u,
      o: o2,
      t: function() {
        if (file.terminate)
          file.terminate();
      },
      r: function() {
        pAll();
        if (tr) {
          var nxt = _this_1.u[ind + 1];
          if (nxt)
            nxt.r();
          else
            _this_1.d = 1;
        }
        tr = 1;
      }
    });
    var cl = 0;
    file.ondata = function(err, dat, final) {
      if (err) {
        _this_1.ondata(err, dat, final);
        _this_1.terminate();
      } else {
        cl += dat.length;
        chks.push(dat);
        if (final) {
          var dd = new u8(16);
          wbytes(dd, 0, 134695760);
          wbytes(dd, 4, file.crc);
          wbytes(dd, 8, cl);
          wbytes(dd, 12, file.size);
          chks.push(dd);
          uf.c = cl, uf.b = hl + cl + 16, uf.crc = file.crc, uf.size = file.size;
          if (tr)
            uf.r();
          tr = 1;
        } else if (tr)
          pAll();
      }
    };
    this.u.push(uf);
  };
  Zip2.prototype.end = function() {
    var _this_1 = this;
    if (this.d & 2) {
      if (this.d & 1)
        throw "stream finishing";
      throw "stream finished";
    }
    if (this.d)
      this.e();
    else
      this.u.push({
        r: function() {
          if (!(_this_1.d & 1))
            return;
          _this_1.u.splice(-1, 1);
          _this_1.e();
        },
        t: function() {
        }
      });
    this.d = 3;
  };
  Zip2.prototype.e = function() {
    var bt = 0, l2 = 0, tl = 0;
    for (var _i = 0, _a4 = this.u; _i < _a4.length; _i++) {
      var f2 = _a4[_i];
      tl += 46 + f2.f.length + exfl(f2.extra) + (f2.o ? f2.o.length : 0);
    }
    var out7 = new u8(tl + 22);
    for (var _b3 = 0, _c = this.u; _b3 < _c.length; _b3++) {
      var f2 = _c[_b3];
      wzh(out7, bt, f2, f2.f, f2.u, f2.c, l2, f2.o);
      bt += 46 + f2.f.length + exfl(f2.extra) + (f2.o ? f2.o.length : 0), l2 += f2.b;
    }
    wzf(out7, bt, this.u.length, tl, l2);
    this.ondata(null, out7, true);
    this.d = 2;
  };
  Zip2.prototype.terminate = function() {
    for (var _i = 0, _a4 = this.u; _i < _a4.length; _i++) {
      var f2 = _a4[_i];
      f2.t();
    }
    this.d = 2;
  };
  return Zip2;
})();
var UnzipPassThrough = (function() {
  function UnzipPassThrough2() {
  }
  UnzipPassThrough2.prototype.push = function(data, final) {
    this.ondata(null, data, final);
  };
  UnzipPassThrough2.compression = 0;
  return UnzipPassThrough2;
})();
var UnzipInflate = (function() {
  function UnzipInflate2() {
    var _this_1 = this;
    this.i = new Inflate(function(dat, final) {
      _this_1.ondata(null, dat, final);
    });
  }
  UnzipInflate2.prototype.push = function(data, final) {
    try {
      this.i.push(data, final);
    } catch (e2) {
      this.ondata(e2, data, final);
    }
  };
  UnzipInflate2.compression = 8;
  return UnzipInflate2;
})();
var AsyncUnzipInflate = (function() {
  function AsyncUnzipInflate2(_, sz) {
    var _this_1 = this;
    if (sz < 32e4) {
      this.i = new Inflate(function(dat, final) {
        _this_1.ondata(null, dat, final);
      });
    } else {
      this.i = new AsyncInflate(function(err, dat, final) {
        _this_1.ondata(err, dat, final);
      });
      this.terminate = this.i.terminate;
    }
  }
  AsyncUnzipInflate2.prototype.push = function(data, final) {
    if (this.i.terminate)
      data = slc(data, 0);
    this.i.push(data, final);
  };
  AsyncUnzipInflate2.compression = 8;
  return AsyncUnzipInflate2;
})();
var Unzip = (function() {
  function Unzip2(cb2) {
    this.onfile = cb2;
    this.k = [];
    this.o = {
      0: UnzipPassThrough
    };
    this.p = et;
  }
  Unzip2.prototype.push = function(chunk, final) {
    var _this_1 = this;
    if (!this.onfile)
      throw "no callback";
    if (!this.p)
      throw "stream finished";
    if (this.c > 0) {
      var len = Math.min(this.c, chunk.length);
      var toAdd = chunk.subarray(0, len);
      this.c -= len;
      if (this.d)
        this.d.push(toAdd, !this.c);
      else
        this.k[0].push(toAdd);
      chunk = chunk.subarray(len);
      if (chunk.length)
        return this.push(chunk, final);
    } else {
      var f2 = 0, i4 = 0, is = void 0, buf = void 0;
      if (!this.p.length)
        buf = chunk;
      else if (!chunk.length)
        buf = this.p;
      else {
        buf = new u8(this.p.length + chunk.length);
        buf.set(this.p), buf.set(chunk, this.p.length);
      }
      var l2 = buf.length, oc = this.c, add3 = oc && this.d;
      var _loop_2 = function() {
        var _a4;
        var sig = b42(buf, i4);
        if (sig == 67324752) {
          f2 = 1, is = i4;
          this_1.d = null;
          this_1.c = 0;
          var bf = b22(buf, i4 + 6), cmp_1 = b22(buf, i4 + 8), u = bf & 2048, dd = bf & 8, fnl = b22(buf, i4 + 26), es = b22(buf, i4 + 28);
          if (l2 > i4 + 30 + fnl + es) {
            var chks_2 = [];
            this_1.k.unshift(chks_2);
            f2 = 2;
            var sc_1 = b42(buf, i4 + 18), su_1 = b42(buf, i4 + 22);
            var fn_1 = strFromU8(buf.subarray(i4 + 30, i4 += 30 + fnl), !u);
            if (sc_1 == 4294967295) {
              _a4 = dd ? [-2] : z64e(buf, i4), sc_1 = _a4[0], su_1 = _a4[1];
            } else if (dd)
              sc_1 = -1;
            i4 += es;
            this_1.c = sc_1;
            var d_1;
            var file_1 = {
              name: fn_1,
              compression: cmp_1,
              start: function() {
                if (!file_1.ondata)
                  throw "no callback";
                if (!sc_1)
                  file_1.ondata(null, et, true);
                else {
                  var ctr = _this_1.o[cmp_1];
                  if (!ctr)
                    throw "unknown compression type " + cmp_1;
                  d_1 = sc_1 < 0 ? new ctr(fn_1) : new ctr(fn_1, sc_1, su_1);
                  d_1.ondata = function(err, dat3, final2) {
                    file_1.ondata(err, dat3, final2);
                  };
                  for (var _i = 0, chks_3 = chks_2; _i < chks_3.length; _i++) {
                    var dat2 = chks_3[_i];
                    d_1.push(dat2, false);
                  }
                  if (_this_1.k[0] == chks_2 && _this_1.c)
                    _this_1.d = d_1;
                  else
                    d_1.push(et, true);
                }
              },
              terminate: function() {
                if (d_1 && d_1.terminate)
                  d_1.terminate();
              }
            };
            if (sc_1 >= 0)
              file_1.size = sc_1, file_1.originalSize = su_1;
            this_1.onfile(file_1);
          }
          return "break";
        } else if (oc) {
          if (sig == 134695760) {
            is = i4 += 12 + (oc == -2 && 8), f2 = 3, this_1.c = 0;
            return "break";
          } else if (sig == 33639248) {
            is = i4 -= 4, f2 = 3, this_1.c = 0;
            return "break";
          }
        }
      };
      var this_1 = this;
      for (; i4 < l2 - 4; ++i4) {
        var state_1 = _loop_2();
        if (state_1 === "break")
          break;
      }
      this.p = et;
      if (oc < 0) {
        var dat = f2 ? buf.subarray(0, is - 12 - (oc == -2 && 8) - (b42(buf, is - 16) == 134695760 && 4)) : buf.subarray(0, i4);
        if (add3)
          add3.push(dat, !!f2);
        else
          this.k[+(f2 == 2)].push(dat);
      }
      if (f2 & 2)
        return this.push(buf.subarray(i4), final);
      this.p = buf.subarray(i4);
    }
    if (final) {
      if (this.c)
        throw "invalid zip file";
      this.p = null;
    }
  };
  Unzip2.prototype.register = function(decoder) {
    this.o[decoder.compression] = decoder;
  };
  return Unzip2;
})();

// node_modules/three-stdlib/exporters/DRACOExporter.js
var __defProp3 = Object.defineProperty;
var __defNormalProp3 = (obj, key, value) => key in obj ? __defProp3(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField4 = (obj, key, value) => {
  __defNormalProp3(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var DRACOExporter = (() => {
  const _DRACOExporter = class {
    parse(object, options = {
      decodeSpeed: 5,
      encodeSpeed: 5,
      encoderMethod: _DRACOExporter.MESH_EDGEBREAKER_ENCODING,
      quantization: [16, 8, 8, 8, 8],
      exportUvs: true,
      exportNormals: true,
      exportColor: false
    }) {
      if (object instanceof BufferGeometry && object.isBufferGeometry) {
        throw new Error("DRACOExporter: The first parameter of parse() is now an instance of Mesh or Points.");
      }
      if (DracoEncoderModule === void 0) {
        throw new Error("THREE.DRACOExporter: required the draco_encoder to work.");
      }
      const geometry3 = object.geometry;
      const dracoEncoder = DracoEncoderModule();
      const encoder = new dracoEncoder.Encoder();
      let builder;
      let dracoObject;
      if (!geometry3.isBufferGeometry) {
        throw new Error(
          "THREE.DRACOExporter.parse(geometry, options): geometry is not a THREE.BufferGeometry instance."
        );
      }
      if (object instanceof Mesh && object.isMesh) {
        builder = new dracoEncoder.MeshBuilder();
        dracoObject = new dracoEncoder.Mesh();
        const vertices = geometry3.getAttribute("position");
        builder.AddFloatAttributeToMesh(
          dracoObject,
          dracoEncoder.POSITION,
          vertices.count,
          vertices.itemSize,
          vertices.array
        );
        const faces = geometry3.getIndex();
        if (faces !== null) {
          builder.AddFacesToMesh(dracoObject, faces.count / 3, faces.array);
        } else {
          const faces2 = new (vertices.count > 65535 ? Uint32Array : Uint16Array)(vertices.count);
          for (let i4 = 0; i4 < faces2.length; i4++) {
            faces2[i4] = i4;
          }
          builder.AddFacesToMesh(dracoObject, vertices.count, faces2);
        }
        if (options.exportNormals) {
          const normals = geometry3.getAttribute("normal");
          if (normals !== void 0) {
            builder.AddFloatAttributeToMesh(
              dracoObject,
              dracoEncoder.NORMAL,
              normals.count,
              normals.itemSize,
              normals.array
            );
          }
        }
        if (options.exportUvs) {
          const uvs = geometry3.getAttribute("uv");
          if (uvs !== void 0) {
            builder.AddFloatAttributeToMesh(dracoObject, dracoEncoder.TEX_COORD, uvs.count, uvs.itemSize, uvs.array);
          }
        }
        if (options.exportColor) {
          const colors2 = geometry3.getAttribute("color");
          if (colors2 !== void 0) {
            builder.AddFloatAttributeToMesh(
              dracoObject,
              dracoEncoder.COLOR,
              colors2.count,
              colors2.itemSize,
              colors2.array
            );
          }
        }
      } else if (object instanceof Points && object.isPoints) {
        builder = new dracoEncoder.PointCloudBuilder();
        dracoObject = new dracoEncoder.PointCloud();
        const vertices = geometry3.getAttribute("position");
        builder.AddFloatAttribute(dracoObject, dracoEncoder.POSITION, vertices.count, vertices.itemSize, vertices.array);
        if (options.exportColor) {
          const colors2 = geometry3.getAttribute("color");
          if (colors2 !== void 0) {
            builder.AddFloatAttribute(dracoObject, dracoEncoder.COLOR, colors2.count, colors2.itemSize, colors2.array);
          }
        }
      } else {
        throw new Error("DRACOExporter: Unsupported object type.");
      }
      const encodedData = new dracoEncoder.DracoInt8Array();
      const encodeSpeed = options.encodeSpeed !== void 0 ? options.encodeSpeed : 5;
      const decodeSpeed = options.decodeSpeed !== void 0 ? options.decodeSpeed : 5;
      encoder.SetSpeedOptions(encodeSpeed, decodeSpeed);
      if (options.encoderMethod !== void 0) {
        encoder.SetEncodingMethod(options.encoderMethod);
      }
      if (options.quantization !== void 0) {
        for (let i4 = 0; i4 < 5; i4++) {
          if (options.quantization[i4] !== void 0) {
            encoder.SetAttributeQuantization(i4, options.quantization[i4]);
          }
        }
      }
      let length3;
      if (object instanceof Mesh && object.isMesh) {
        length3 = encoder.EncodeMeshToDracoBuffer(dracoObject, encodedData);
      } else {
        length3 = encoder.EncodePointCloudToDracoBuffer(dracoObject, true, encodedData);
      }
      dracoEncoder.destroy(dracoObject);
      if (length3 === 0) {
        throw new Error("THREE.DRACOExporter: Draco encoding failed.");
      }
      const outputData = new Int8Array(new ArrayBuffer(length3));
      for (let i4 = 0; i4 < length3; i4++) {
        outputData[i4] = encodedData.GetValue(i4);
      }
      dracoEncoder.destroy(encodedData);
      dracoEncoder.destroy(encoder);
      dracoEncoder.destroy(builder);
      return outputData;
    }
  };
  let DRACOExporter2 = _DRACOExporter;
  __publicField4(DRACOExporter2, "MESH_EDGEBREAKER_ENCODING", 1);
  __publicField4(DRACOExporter2, "MESH_SEQUENTIAL_ENCODING", 0);
  __publicField4(DRACOExporter2, "POINT_CLOUD", 0);
  __publicField4(DRACOExporter2, "TRIANGULAR_MESH", 1);
  __publicField4(DRACOExporter2, "INVALID", -1);
  __publicField4(DRACOExporter2, "POSITION", 0);
  __publicField4(DRACOExporter2, "NORMAL", 1);
  __publicField4(DRACOExporter2, "COLOR", 2);
  __publicField4(DRACOExporter2, "TEX_COORD", 3);
  __publicField4(DRACOExporter2, "GENERIC", 4);
  return DRACOExporter2;
})();

// node_modules/three-stdlib/animation/CCDIKSolver.js
var _q = new Quaternion();
var _targetPos = new Vector3();
var _targetVec = new Vector3();
var _effectorPos = new Vector3();
var _effectorVec = new Vector3();
var _linkPos = new Vector3();
var _invLinkQ = new Quaternion();
var _linkScale = new Vector3();
var _axis = new Vector3();
var _vector2 = new Vector3();
var _matrix3 = new Matrix4();

// node_modules/three-stdlib/animation/MMDPhysics.js
var _position3 = new Vector3();
var _quaternion2 = new Quaternion();
var _scale2 = new Vector3();
var _matrixWorldInv = new Matrix4();

// node_modules/three-stdlib/animation/MMDAnimationHelper.js
var _q3 = new Quaternion();

// node_modules/three-stdlib/objects/BatchedMesh.js
var ID_ATTR_NAME = "_batch_id_";
var _identityMatrix = new Matrix4();
var _zeroScaleMatrix = (() => new Matrix4().set(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1))();
var batchingParsVertex = (
  /* glsl */
  `
#ifdef BATCHING
	attribute float ${ID_ATTR_NAME};
	uniform highp sampler2D batchingTexture;
	mat4 getBatchingMatrix( const in float i ) {

		int size = textureSize( batchingTexture, 0 ).x;
		int j = int( i ) * 4;
		int x = j % size;
		int y = j / size;
		vec4 v1 = texelFetch( batchingTexture, ivec2( x, y ), 0 );
		vec4 v2 = texelFetch( batchingTexture, ivec2( x + 1, y ), 0 );
		vec4 v3 = texelFetch( batchingTexture, ivec2( x + 2, y ), 0 );
		vec4 v4 = texelFetch( batchingTexture, ivec2( x + 3, y ), 0 );
		return mat4( v1, v2, v3, v4 );

	}
#endif
`
);
var batchingbaseVertex = (
  /* glsl */
  `
#ifdef BATCHING
	mat4 batchingMatrix = getBatchingMatrix( ${ID_ATTR_NAME} );
#endif
`
);

// node_modules/three-stdlib/objects/Reflector.js
var __defProp4 = Object.defineProperty;
var __defNormalProp4 = (obj, key, value) => key in obj ? __defProp4(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField5 = (obj, key, value) => {
  __defNormalProp4(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var Reflector = (() => {
  const _Reflector = class extends Mesh {
    constructor(geometry3, options = {}) {
      super(geometry3);
      this.isReflector = true;
      this.type = "Reflector";
      this.camera = new PerspectiveCamera();
      const scope = this;
      const color = options.color !== void 0 ? new Color(options.color) : new Color(8355711);
      const textureWidth = options.textureWidth || 512;
      const textureHeight = options.textureHeight || 512;
      const clipBias = options.clipBias || 0;
      const shader = options.shader || _Reflector.ReflectorShader;
      const multisample = options.multisample !== void 0 ? options.multisample : 4;
      const reflectorPlane = new Plane();
      const normal2 = new Vector3();
      const reflectorWorldPosition = new Vector3();
      const cameraWorldPosition = new Vector3();
      const rotationMatrix2 = new Matrix4();
      const lookAtPosition = new Vector3(0, 0, -1);
      const clipPlane = new Vector4();
      const view = new Vector3();
      const target2 = new Vector3();
      const q = new Vector4();
      const textureMatrix = new Matrix4();
      const virtualCamera = this.camera;
      const renderTarget = new WebGLRenderTarget(textureWidth, textureHeight, {
        samples: multisample,
        type: HalfFloatType
      });
      const material = new ShaderMaterial({
        uniforms: UniformsUtils.clone(shader.uniforms),
        fragmentShader: shader.fragmentShader,
        vertexShader: shader.vertexShader
      });
      material.uniforms["tDiffuse"].value = renderTarget.texture;
      material.uniforms["color"].value = color;
      material.uniforms["textureMatrix"].value = textureMatrix;
      this.material = material;
      this.onBeforeRender = function(renderer, scene, camera) {
        reflectorWorldPosition.setFromMatrixPosition(scope.matrixWorld);
        cameraWorldPosition.setFromMatrixPosition(camera.matrixWorld);
        rotationMatrix2.extractRotation(scope.matrixWorld);
        normal2.set(0, 0, 1);
        normal2.applyMatrix4(rotationMatrix2);
        view.subVectors(reflectorWorldPosition, cameraWorldPosition);
        if (view.dot(normal2) > 0)
          return;
        view.reflect(normal2).negate();
        view.add(reflectorWorldPosition);
        rotationMatrix2.extractRotation(camera.matrixWorld);
        lookAtPosition.set(0, 0, -1);
        lookAtPosition.applyMatrix4(rotationMatrix2);
        lookAtPosition.add(cameraWorldPosition);
        target2.subVectors(reflectorWorldPosition, lookAtPosition);
        target2.reflect(normal2).negate();
        target2.add(reflectorWorldPosition);
        virtualCamera.position.copy(view);
        virtualCamera.up.set(0, 1, 0);
        virtualCamera.up.applyMatrix4(rotationMatrix2);
        virtualCamera.up.reflect(normal2);
        virtualCamera.lookAt(target2);
        virtualCamera.far = camera.far;
        virtualCamera.updateMatrixWorld();
        virtualCamera.projectionMatrix.copy(camera.projectionMatrix);
        textureMatrix.set(0.5, 0, 0, 0.5, 0, 0.5, 0, 0.5, 0, 0, 0.5, 0.5, 0, 0, 0, 1);
        textureMatrix.multiply(virtualCamera.projectionMatrix);
        textureMatrix.multiply(virtualCamera.matrixWorldInverse);
        textureMatrix.multiply(scope.matrixWorld);
        reflectorPlane.setFromNormalAndCoplanarPoint(normal2, reflectorWorldPosition);
        reflectorPlane.applyMatrix4(virtualCamera.matrixWorldInverse);
        clipPlane.set(
          reflectorPlane.normal.x,
          reflectorPlane.normal.y,
          reflectorPlane.normal.z,
          reflectorPlane.constant
        );
        const projectionMatrix = virtualCamera.projectionMatrix;
        q.x = (Math.sign(clipPlane.x) + projectionMatrix.elements[8]) / projectionMatrix.elements[0];
        q.y = (Math.sign(clipPlane.y) + projectionMatrix.elements[9]) / projectionMatrix.elements[5];
        q.z = -1;
        q.w = (1 + projectionMatrix.elements[10]) / projectionMatrix.elements[14];
        clipPlane.multiplyScalar(2 / clipPlane.dot(q));
        projectionMatrix.elements[2] = clipPlane.x;
        projectionMatrix.elements[6] = clipPlane.y;
        projectionMatrix.elements[10] = clipPlane.z + 1 - clipBias;
        projectionMatrix.elements[14] = clipPlane.w;
        scope.visible = false;
        const currentRenderTarget = renderer.getRenderTarget();
        const currentXrEnabled = renderer.xr.enabled;
        const currentShadowAutoUpdate = renderer.shadowMap.autoUpdate;
        const currentToneMapping = renderer.toneMapping;
        let isSRGB = false;
        if ("outputColorSpace" in renderer)
          isSRGB = renderer.outputColorSpace === "srgb";
        else
          isSRGB = renderer.outputEncoding === 3001;
        renderer.xr.enabled = false;
        renderer.shadowMap.autoUpdate = false;
        if ("outputColorSpace" in renderer)
          renderer.outputColorSpace = "srgb-linear";
        else
          renderer.outputEncoding = 3e3;
        renderer.toneMapping = NoToneMapping;
        renderer.setRenderTarget(renderTarget);
        renderer.state.buffers.depth.setMask(true);
        if (renderer.autoClear === false)
          renderer.clear();
        renderer.render(scene, virtualCamera);
        renderer.xr.enabled = currentXrEnabled;
        renderer.shadowMap.autoUpdate = currentShadowAutoUpdate;
        renderer.toneMapping = currentToneMapping;
        if ("outputColorSpace" in renderer)
          renderer.outputColorSpace = isSRGB ? "srgb" : "srgb-linear";
        else
          renderer.outputEncoding = isSRGB ? 3001 : 3e3;
        renderer.setRenderTarget(currentRenderTarget);
        const viewport = camera.viewport;
        if (viewport !== void 0) {
          renderer.state.viewport(viewport);
        }
        scope.visible = true;
      };
      this.getRenderTarget = function() {
        return renderTarget;
      };
      this.dispose = function() {
        renderTarget.dispose();
        scope.material.dispose();
      };
    }
  };
  let Reflector2 = _Reflector;
  __publicField5(Reflector2, "ReflectorShader", {
    uniforms: {
      color: {
        value: null
      },
      tDiffuse: {
        value: null
      },
      textureMatrix: {
        value: null
      }
    },
    vertexShader: (
      /* glsl */
      `
		uniform mat4 textureMatrix;
		varying vec4 vUv;

		#include <common>
		#include <logdepthbuf_pars_vertex>

		void main() {

			vUv = textureMatrix * vec4( position, 1.0 );

			gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

			#include <logdepthbuf_vertex>

		}`
    ),
    fragmentShader: (
      /* glsl */
      `
		uniform vec3 color;
		uniform sampler2D tDiffuse;
		varying vec4 vUv;

		#include <logdepthbuf_pars_fragment>

		float blendOverlay( float base, float blend ) {

			return( base < 0.5 ? ( 2.0 * base * blend ) : ( 1.0 - 2.0 * ( 1.0 - base ) * ( 1.0 - blend ) ) );

		}

		vec3 blendOverlay( vec3 base, vec3 blend ) {

			return vec3( blendOverlay( base.r, blend.r ), blendOverlay( base.g, blend.g ), blendOverlay( base.b, blend.b ) );

		}

		void main() {

			#include <logdepthbuf_fragment>

			vec4 base = texture2DProj( tDiffuse, vUv );
			gl_FragColor = vec4( blendOverlay( base.rgb, color ), 1.0 );

			#include <tonemapping_fragment>
			#include <${version >= 154 ? "colorspace_fragment" : "encodings_fragment"}>

		}`
    )
  });
  return Reflector2;
})();

// node_modules/three-stdlib/objects/Refractor.js
var __defProp5 = Object.defineProperty;
var __defNormalProp5 = (obj, key, value) => key in obj ? __defProp5(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField6 = (obj, key, value) => {
  __defNormalProp5(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var Refractor = (() => {
  const _Refractor = class extends Mesh {
    constructor(geometry3, options = {}) {
      super(geometry3);
      this.isRefractor = true;
      this.type = "Refractor";
      this.camera = new PerspectiveCamera();
      const scope = this;
      const color = options.color !== void 0 ? new Color(options.color) : new Color(8355711);
      const textureWidth = options.textureWidth || 512;
      const textureHeight = options.textureHeight || 512;
      const clipBias = options.clipBias || 0;
      const shader = options.shader || _Refractor.RefractorShader;
      const multisample = options.multisample !== void 0 ? options.multisample : 4;
      const virtualCamera = this.camera;
      virtualCamera.matrixAutoUpdate = false;
      virtualCamera.userData.refractor = true;
      const refractorPlane = new Plane();
      const textureMatrix = new Matrix4();
      const renderTarget = new WebGLRenderTarget(textureWidth, textureHeight, {
        samples: multisample,
        type: HalfFloatType
      });
      this.material = new ShaderMaterial({
        uniforms: UniformsUtils.clone(shader.uniforms),
        vertexShader: shader.vertexShader,
        fragmentShader: shader.fragmentShader,
        transparent: true
        // ensures, refractors are drawn from farthest to closest
      });
      this.material.uniforms["color"].value = color;
      this.material.uniforms["tDiffuse"].value = renderTarget.texture;
      this.material.uniforms["textureMatrix"].value = textureMatrix;
      const visible = (function() {
        const refractorWorldPosition = new Vector3();
        const cameraWorldPosition = new Vector3();
        const rotationMatrix2 = new Matrix4();
        const view = new Vector3();
        const normal2 = new Vector3();
        return function visible2(camera) {
          refractorWorldPosition.setFromMatrixPosition(scope.matrixWorld);
          cameraWorldPosition.setFromMatrixPosition(camera.matrixWorld);
          view.subVectors(refractorWorldPosition, cameraWorldPosition);
          rotationMatrix2.extractRotation(scope.matrixWorld);
          normal2.set(0, 0, 1);
          normal2.applyMatrix4(rotationMatrix2);
          return view.dot(normal2) < 0;
        };
      })();
      const updateRefractorPlane = (function() {
        const normal2 = new Vector3();
        const position2 = new Vector3();
        const quaternion = new Quaternion();
        const scale5 = new Vector3();
        return function updateRefractorPlane2() {
          scope.matrixWorld.decompose(position2, quaternion, scale5);
          normal2.set(0, 0, 1).applyQuaternion(quaternion).normalize();
          normal2.negate();
          refractorPlane.setFromNormalAndCoplanarPoint(normal2, position2);
        };
      })();
      const updateVirtualCamera = (function() {
        const clipPlane = new Plane();
        const clipVector = new Vector4();
        const q = new Vector4();
        return function updateVirtualCamera2(camera) {
          virtualCamera.matrixWorld.copy(camera.matrixWorld);
          virtualCamera.matrixWorldInverse.copy(virtualCamera.matrixWorld).invert();
          virtualCamera.projectionMatrix.copy(camera.projectionMatrix);
          virtualCamera.far = camera.far;
          clipPlane.copy(refractorPlane);
          clipPlane.applyMatrix4(virtualCamera.matrixWorldInverse);
          clipVector.set(clipPlane.normal.x, clipPlane.normal.y, clipPlane.normal.z, clipPlane.constant);
          const projectionMatrix = virtualCamera.projectionMatrix;
          q.x = (Math.sign(clipVector.x) + projectionMatrix.elements[8]) / projectionMatrix.elements[0];
          q.y = (Math.sign(clipVector.y) + projectionMatrix.elements[9]) / projectionMatrix.elements[5];
          q.z = -1;
          q.w = (1 + projectionMatrix.elements[10]) / projectionMatrix.elements[14];
          clipVector.multiplyScalar(2 / clipVector.dot(q));
          projectionMatrix.elements[2] = clipVector.x;
          projectionMatrix.elements[6] = clipVector.y;
          projectionMatrix.elements[10] = clipVector.z + 1 - clipBias;
          projectionMatrix.elements[14] = clipVector.w;
        };
      })();
      function updateTextureMatrix(camera) {
        textureMatrix.set(0.5, 0, 0, 0.5, 0, 0.5, 0, 0.5, 0, 0, 0.5, 0.5, 0, 0, 0, 1);
        textureMatrix.multiply(camera.projectionMatrix);
        textureMatrix.multiply(camera.matrixWorldInverse);
        textureMatrix.multiply(scope.matrixWorld);
      }
      function render(renderer, scene, camera) {
        scope.visible = false;
        const currentRenderTarget = renderer.getRenderTarget();
        const currentXrEnabled = renderer.xr.enabled;
        const currentShadowAutoUpdate = renderer.shadowMap.autoUpdate;
        const currentToneMapping = renderer.toneMapping;
        let isSRGB = false;
        if ("outputColorSpace" in renderer)
          isSRGB = renderer.outputColorSpace === "srgb";
        else
          isSRGB = renderer.outputEncoding === 3001;
        renderer.xr.enabled = false;
        renderer.shadowMap.autoUpdate = false;
        if ("outputColorSpace" in renderer)
          renderer.outputColorSpace = "srgb-linear";
        else
          renderer.outputEncoding = 3e3;
        renderer.toneMapping = NoToneMapping;
        renderer.setRenderTarget(renderTarget);
        if (renderer.autoClear === false)
          renderer.clear();
        renderer.render(scene, virtualCamera);
        renderer.xr.enabled = currentXrEnabled;
        renderer.shadowMap.autoUpdate = currentShadowAutoUpdate;
        renderer.toneMapping = currentToneMapping;
        renderer.setRenderTarget(currentRenderTarget);
        if ("outputColorSpace" in renderer)
          renderer.outputColorSpace = isSRGB ? "srgb" : "srgb-linear";
        else
          renderer.outputEncoding = isSRGB ? 3001 : 3e3;
        const viewport = camera.viewport;
        if (viewport !== void 0) {
          renderer.state.viewport(viewport);
        }
        scope.visible = true;
      }
      this.onBeforeRender = function(renderer, scene, camera) {
        if (camera.userData.refractor === true)
          return;
        if (!visible(camera) === true)
          return;
        updateRefractorPlane();
        updateTextureMatrix(camera);
        updateVirtualCamera(camera);
        render(renderer, scene, camera);
      };
      this.getRenderTarget = function() {
        return renderTarget;
      };
      this.dispose = function() {
        renderTarget.dispose();
        scope.material.dispose();
      };
    }
  };
  let Refractor2 = _Refractor;
  __publicField6(Refractor2, "RefractorShader", {
    uniforms: {
      color: {
        value: null
      },
      tDiffuse: {
        value: null
      },
      textureMatrix: {
        value: null
      }
    },
    vertexShader: (
      /* glsl */
      `

		uniform mat4 textureMatrix;

		varying vec4 vUv;

		void main() {

			vUv = textureMatrix * vec4( position, 1.0 );
			gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

		}`
    ),
    fragmentShader: (
      /* glsl */
      `

		uniform vec3 color;
		uniform sampler2D tDiffuse;

		varying vec4 vUv;

		float blendOverlay( float base, float blend ) {

			return( base < 0.5 ? ( 2.0 * base * blend ) : ( 1.0 - 2.0 * ( 1.0 - base ) * ( 1.0 - blend ) ) );

		}

		vec3 blendOverlay( vec3 base, vec3 blend ) {

			return vec3( blendOverlay( base.r, blend.r ), blendOverlay( base.g, blend.g ), blendOverlay( base.b, blend.b ) );

		}

		void main() {

			vec4 base = texture2DProj( tDiffuse, vUv );
			gl_FragColor = vec4( blendOverlay( base.rgb, color ), 1.0 );

			#include <tonemapping_fragment>
			#include <${version >= 154 ? "colorspace_fragment" : "encodings_fragment"}>

		}`
    )
  });
  return Refractor2;
})();

// node_modules/three-stdlib/objects/ShadowMesh.js
var _shadowMatrix = new Matrix4();

// node_modules/three-stdlib/objects/Lensflare.js
var Lensflare = (() => {
  class Lensflare2 extends Mesh {
    constructor() {
      super(Lensflare2.Geometry, new MeshBasicMaterial({ opacity: 0, transparent: true }));
      this.isLensflare = true;
      this.type = "Lensflare";
      this.frustumCulled = false;
      this.renderOrder = Infinity;
      const positionScreen = new Vector3();
      const positionView = new Vector3();
      const tempMap = new Texture({ width: 16, height: 16 });
      tempMap.isFramebufferTexture = true;
      tempMap.magFilter = NearestFilter;
      tempMap.minFilter = NearestFilter;
      tempMap.generateMipmaps = false;
      tempMap.needsUpdate = true;
      const occlusionMap = new Texture({ width: 16, height: 16 });
      occlusionMap.isFramebufferTexture = true;
      occlusionMap.magFilter = NearestFilter;
      occlusionMap.minFilter = NearestFilter;
      occlusionMap.generateMipmaps = false;
      occlusionMap.needsUpdate = true;
      const geometry3 = Lensflare2.Geometry;
      const material1a = new RawShaderMaterial({
        uniforms: {
          scale: { value: null },
          screenPosition: { value: null }
        },
        vertexShader: (
          /* glsl */
          `

				precision highp float;

				uniform vec3 screenPosition;
				uniform vec2 scale;

				attribute vec3 position;

				void main() {

					gl_Position = vec4( position.xy * scale + screenPosition.xy, screenPosition.z, 1.0 );

				}`
        ),
        fragmentShader: (
          /* glsl */
          `

				precision highp float;

				void main() {

					gl_FragColor = vec4( 1.0, 0.0, 1.0, 1.0 );

				}`
        ),
        depthTest: true,
        depthWrite: false,
        transparent: false
      });
      const material1b = new RawShaderMaterial({
        uniforms: {
          map: { value: tempMap },
          scale: { value: null },
          screenPosition: { value: null }
        },
        vertexShader: (
          /* glsl */
          `

				precision highp float;

				uniform vec3 screenPosition;
				uniform vec2 scale;

				attribute vec3 position;
				attribute vec2 uv;

				varying vec2 vUV;

				void main() {

					vUV = uv;

					gl_Position = vec4( position.xy * scale + screenPosition.xy, screenPosition.z, 1.0 );

				}`
        ),
        fragmentShader: (
          /* glsl */
          `

				precision highp float;

				uniform sampler2D map;

				varying vec2 vUV;

				void main() {

					gl_FragColor = texture2D( map, vUV );

				}`
        ),
        depthTest: false,
        depthWrite: false,
        transparent: false
      });
      const mesh1 = new Mesh(geometry3, material1a);
      const elements = [];
      const shader = LensflareElement.Shader;
      const material2 = new RawShaderMaterial({
        uniforms: {
          map: { value: null },
          occlusionMap: { value: occlusionMap },
          color: { value: new Color(16777215) },
          scale: { value: new Vector2() },
          screenPosition: { value: new Vector3() }
        },
        vertexShader: shader.vertexShader,
        fragmentShader: shader.fragmentShader,
        blending: AdditiveBlending,
        transparent: true,
        depthWrite: false
      });
      const mesh2 = new Mesh(geometry3, material2);
      this.addElement = function(element) {
        elements.push(element);
      };
      const scale5 = new Vector2();
      const screenPositionPixels = new Vector2();
      const validArea = new Box2();
      const viewport = new Vector4();
      this.onBeforeRender = function(renderer, scene, camera) {
        renderer.getCurrentViewport(viewport);
        const invAspect = viewport.w / viewport.z;
        const halfViewportWidth = viewport.z / 2;
        const halfViewportHeight = viewport.w / 2;
        let size2 = 16 / viewport.w;
        scale5.set(size2 * invAspect, size2);
        validArea.min.set(viewport.x, viewport.y);
        validArea.max.set(viewport.x + (viewport.z - 16), viewport.y + (viewport.w - 16));
        positionView.setFromMatrixPosition(this.matrixWorld);
        positionView.applyMatrix4(camera.matrixWorldInverse);
        if (positionView.z > 0)
          return;
        positionScreen.copy(positionView).applyMatrix4(camera.projectionMatrix);
        screenPositionPixels.x = viewport.x + positionScreen.x * halfViewportWidth + halfViewportWidth - 8;
        screenPositionPixels.y = viewport.y + positionScreen.y * halfViewportHeight + halfViewportHeight - 8;
        if (validArea.containsPoint(screenPositionPixels)) {
          renderer.copyFramebufferToTexture(screenPositionPixels, tempMap);
          let uniforms = material1a.uniforms;
          uniforms["scale"].value = scale5;
          uniforms["screenPosition"].value = positionScreen;
          renderer.renderBufferDirect(camera, null, geometry3, material1a, mesh1, null);
          renderer.copyFramebufferToTexture(screenPositionPixels, occlusionMap);
          uniforms = material1b.uniforms;
          uniforms["scale"].value = scale5;
          uniforms["screenPosition"].value = positionScreen;
          renderer.renderBufferDirect(camera, null, geometry3, material1b, mesh1, null);
          const vecX = -positionScreen.x * 2;
          const vecY = -positionScreen.y * 2;
          for (let i4 = 0, l2 = elements.length; i4 < l2; i4++) {
            const element = elements[i4];
            const uniforms2 = material2.uniforms;
            uniforms2["color"].value.copy(element.color);
            uniforms2["map"].value = element.texture;
            uniforms2["screenPosition"].value.x = positionScreen.x + vecX * element.distance;
            uniforms2["screenPosition"].value.y = positionScreen.y + vecY * element.distance;
            size2 = element.size / viewport.w;
            const invAspect2 = viewport.w / viewport.z;
            uniforms2["scale"].value.set(size2 * invAspect2, size2);
            material2.uniformsNeedUpdate = true;
            renderer.renderBufferDirect(camera, null, geometry3, material2, mesh2, null);
          }
        }
      };
      this.dispose = function() {
        material1a.dispose();
        material1b.dispose();
        material2.dispose();
        tempMap.dispose();
        occlusionMap.dispose();
        for (let i4 = 0, l2 = elements.length; i4 < l2; i4++) {
          elements[i4].texture.dispose();
        }
      };
    }
  }
  const _geometry = new BufferGeometry();
  const interleavedBuffer = new InterleavedBuffer(
    new Float32Array([-1, -1, 0, 0, 0, 1, -1, 0, 1, 0, 1, 1, 0, 1, 1, -1, 1, 0, 0, 1]),
    5
  );
  _geometry.setIndex([0, 1, 2, 0, 2, 3]);
  _geometry.setAttribute("position", new InterleavedBufferAttribute(interleavedBuffer, 3, 0, false));
  _geometry.setAttribute("uv", new InterleavedBufferAttribute(interleavedBuffer, 2, 3, false));
  Lensflare2.Geometry = _geometry;
  return Lensflare2;
})();
var LensflareElement = (() => {
  class LensflareElement2 {
    constructor(texture, size2 = 1, distance3 = 0, color = new Color(16777215)) {
      this.texture = texture;
      this.size = size2;
      this.distance = distance3;
      this.color = color;
    }
  }
  LensflareElement2.Shader = {
    uniforms: {
      map: { value: null },
      occlusionMap: { value: null },
      color: { value: null },
      scale: { value: null },
      screenPosition: { value: null }
    },
    vertexShader: (
      /* glsl */
      `

      precision highp float;

      uniform vec3 screenPosition;
      uniform vec2 scale;

      uniform sampler2D occlusionMap;

      attribute vec3 position;
      attribute vec2 uv;

      varying vec2 vUV;
      varying float vVisibility;

      void main() {

        vUV = uv;

        vec2 pos = position.xy;

        vec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) );
        visibility += texture2D( occlusionMap, vec2( 0.5, 0.1 ) );
        visibility += texture2D( occlusionMap, vec2( 0.9, 0.1 ) );
        visibility += texture2D( occlusionMap, vec2( 0.9, 0.5 ) );
        visibility += texture2D( occlusionMap, vec2( 0.9, 0.9 ) );
        visibility += texture2D( occlusionMap, vec2( 0.5, 0.9 ) );
        visibility += texture2D( occlusionMap, vec2( 0.1, 0.9 ) );
        visibility += texture2D( occlusionMap, vec2( 0.1, 0.5 ) );
        visibility += texture2D( occlusionMap, vec2( 0.5, 0.5 ) );

        vVisibility =        visibility.r / 9.0;
        vVisibility *= 1.0 - visibility.g / 9.0;
        vVisibility *=       visibility.b / 9.0;

        gl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );

      }
    `
    ),
    fragmentShader: (
      /* glsl */
      `

      precision highp float;

      uniform sampler2D map;
      uniform vec3 color;

      varying vec2 vUV;
      varying float vVisibility;

      void main() {

        vec4 texture = texture2D( map, vUV );
        texture.a *= vVisibility;
        gl_FragColor = texture;
        gl_FragColor.rgb *= color;

      }
    `
    )
  };
  return LensflareElement2;
})();

// node_modules/three-stdlib/objects/MarchingCubes.js
var MarchingCubes = class extends Mesh {
  constructor(resolution, material, enableUvs = false, enableColors = false, maxPolyCount = 1e4) {
    const geometry3 = new BufferGeometry();
    super(geometry3, material);
    this.isMarchingCubes = true;
    const scope = this;
    const vlist = new Float32Array(12 * 3);
    const nlist = new Float32Array(12 * 3);
    const clist = new Float32Array(12 * 3);
    this.enableUvs = enableUvs;
    this.enableColors = enableColors;
    this.init = function(resolution2) {
      this.resolution = resolution2;
      this.isolation = 80;
      this.size = resolution2;
      this.size2 = this.size * this.size;
      this.size3 = this.size2 * this.size;
      this.halfsize = this.size / 2;
      this.delta = 2 / this.size;
      this.yd = this.size;
      this.zd = this.size2;
      this.field = new Float32Array(this.size3);
      this.normal_cache = new Float32Array(this.size3 * 3);
      this.palette = new Float32Array(this.size3 * 3);
      this.count = 0;
      const maxVertexCount = maxPolyCount * 3;
      this.positionArray = new Float32Array(maxVertexCount * 3);
      const positionAttribute = new BufferAttribute(this.positionArray, 3);
      positionAttribute.setUsage(DynamicDrawUsage);
      geometry3.setAttribute("position", positionAttribute);
      this.normalArray = new Float32Array(maxVertexCount * 3);
      const normalAttribute = new BufferAttribute(this.normalArray, 3);
      normalAttribute.setUsage(DynamicDrawUsage);
      geometry3.setAttribute("normal", normalAttribute);
      if (this.enableUvs) {
        this.uvArray = new Float32Array(maxVertexCount * 2);
        const uvAttribute = new BufferAttribute(this.uvArray, 2);
        uvAttribute.setUsage(DynamicDrawUsage);
        geometry3.setAttribute("uv", uvAttribute);
      }
      if (this.enableColors) {
        this.colorArray = new Float32Array(maxVertexCount * 3);
        const colorAttribute = new BufferAttribute(this.colorArray, 3);
        colorAttribute.setUsage(DynamicDrawUsage);
        geometry3.setAttribute("color", colorAttribute);
      }
      geometry3.boundingSphere = new Sphere(new Vector3(), 1);
    };
    function lerp3(a6, b5, t3) {
      return a6 + (b5 - a6) * t3;
    }
    function VIntX(q, offset, isol, x, y, z, valp1, valp2, c_offset1, c_offset2) {
      const mu = (isol - valp1) / (valp2 - valp1), nc = scope.normal_cache;
      vlist[offset + 0] = x + mu * scope.delta;
      vlist[offset + 1] = y;
      vlist[offset + 2] = z;
      nlist[offset + 0] = lerp3(nc[q + 0], nc[q + 3], mu);
      nlist[offset + 1] = lerp3(nc[q + 1], nc[q + 4], mu);
      nlist[offset + 2] = lerp3(nc[q + 2], nc[q + 5], mu);
      clist[offset + 0] = lerp3(scope.palette[c_offset1 * 3 + 0], scope.palette[c_offset2 * 3 + 0], mu);
      clist[offset + 1] = lerp3(scope.palette[c_offset1 * 3 + 1], scope.palette[c_offset2 * 3 + 1], mu);
      clist[offset + 2] = lerp3(scope.palette[c_offset1 * 3 + 2], scope.palette[c_offset2 * 3 + 2], mu);
    }
    function VIntY(q, offset, isol, x, y, z, valp1, valp2, c_offset1, c_offset2) {
      const mu = (isol - valp1) / (valp2 - valp1), nc = scope.normal_cache;
      vlist[offset + 0] = x;
      vlist[offset + 1] = y + mu * scope.delta;
      vlist[offset + 2] = z;
      const q22 = q + scope.yd * 3;
      nlist[offset + 0] = lerp3(nc[q + 0], nc[q22 + 0], mu);
      nlist[offset + 1] = lerp3(nc[q + 1], nc[q22 + 1], mu);
      nlist[offset + 2] = lerp3(nc[q + 2], nc[q22 + 2], mu);
      clist[offset + 0] = lerp3(scope.palette[c_offset1 * 3 + 0], scope.palette[c_offset2 * 3 + 0], mu);
      clist[offset + 1] = lerp3(scope.palette[c_offset1 * 3 + 1], scope.palette[c_offset2 * 3 + 1], mu);
      clist[offset + 2] = lerp3(scope.palette[c_offset1 * 3 + 2], scope.palette[c_offset2 * 3 + 2], mu);
    }
    function VIntZ(q, offset, isol, x, y, z, valp1, valp2, c_offset1, c_offset2) {
      const mu = (isol - valp1) / (valp2 - valp1), nc = scope.normal_cache;
      vlist[offset + 0] = x;
      vlist[offset + 1] = y;
      vlist[offset + 2] = z + mu * scope.delta;
      const q22 = q + scope.zd * 3;
      nlist[offset + 0] = lerp3(nc[q + 0], nc[q22 + 0], mu);
      nlist[offset + 1] = lerp3(nc[q + 1], nc[q22 + 1], mu);
      nlist[offset + 2] = lerp3(nc[q + 2], nc[q22 + 2], mu);
      clist[offset + 0] = lerp3(scope.palette[c_offset1 * 3 + 0], scope.palette[c_offset2 * 3 + 0], mu);
      clist[offset + 1] = lerp3(scope.palette[c_offset1 * 3 + 1], scope.palette[c_offset2 * 3 + 1], mu);
      clist[offset + 2] = lerp3(scope.palette[c_offset1 * 3 + 2], scope.palette[c_offset2 * 3 + 2], mu);
    }
    function compNorm(q) {
      const q3 = q * 3;
      if (scope.normal_cache[q3] === 0) {
        scope.normal_cache[q3 + 0] = scope.field[q - 1] - scope.field[q + 1];
        scope.normal_cache[q3 + 1] = scope.field[q - scope.yd] - scope.field[q + scope.yd];
        scope.normal_cache[q3 + 2] = scope.field[q - scope.zd] - scope.field[q + scope.zd];
      }
    }
    function polygonize(fx, fy, fz, q, isol) {
      const q12 = q + 1, qy = q + scope.yd, qz = q + scope.zd, q1y = q12 + scope.yd, q1z = q12 + scope.zd, qyz = q + scope.yd + scope.zd, q1yz = q12 + scope.yd + scope.zd;
      let cubeindex = 0;
      const field0 = scope.field[q], field1 = scope.field[q12], field2 = scope.field[qy], field3 = scope.field[q1y], field4 = scope.field[qz], field5 = scope.field[q1z], field6 = scope.field[qyz], field7 = scope.field[q1yz];
      if (field0 < isol)
        cubeindex |= 1;
      if (field1 < isol)
        cubeindex |= 2;
      if (field2 < isol)
        cubeindex |= 8;
      if (field3 < isol)
        cubeindex |= 4;
      if (field4 < isol)
        cubeindex |= 16;
      if (field5 < isol)
        cubeindex |= 32;
      if (field6 < isol)
        cubeindex |= 128;
      if (field7 < isol)
        cubeindex |= 64;
      const bits2 = edgeTable[cubeindex];
      if (bits2 === 0)
        return 0;
      const d2 = scope.delta, fx2 = fx + d2, fy2 = fy + d2, fz2 = fz + d2;
      if (bits2 & 1) {
        compNorm(q);
        compNorm(q12);
        VIntX(q * 3, 0, isol, fx, fy, fz, field0, field1, q, q12);
      }
      if (bits2 & 2) {
        compNorm(q12);
        compNorm(q1y);
        VIntY(q12 * 3, 3, isol, fx2, fy, fz, field1, field3, q12, q1y);
      }
      if (bits2 & 4) {
        compNorm(qy);
        compNorm(q1y);
        VIntX(qy * 3, 6, isol, fx, fy2, fz, field2, field3, qy, q1y);
      }
      if (bits2 & 8) {
        compNorm(q);
        compNorm(qy);
        VIntY(q * 3, 9, isol, fx, fy, fz, field0, field2, q, qy);
      }
      if (bits2 & 16) {
        compNorm(qz);
        compNorm(q1z);
        VIntX(qz * 3, 12, isol, fx, fy, fz2, field4, field5, qz, q1z);
      }
      if (bits2 & 32) {
        compNorm(q1z);
        compNorm(q1yz);
        VIntY(q1z * 3, 15, isol, fx2, fy, fz2, field5, field7, q1z, q1yz);
      }
      if (bits2 & 64) {
        compNorm(qyz);
        compNorm(q1yz);
        VIntX(qyz * 3, 18, isol, fx, fy2, fz2, field6, field7, qyz, q1yz);
      }
      if (bits2 & 128) {
        compNorm(qz);
        compNorm(qyz);
        VIntY(qz * 3, 21, isol, fx, fy, fz2, field4, field6, qz, qyz);
      }
      if (bits2 & 256) {
        compNorm(q);
        compNorm(qz);
        VIntZ(q * 3, 24, isol, fx, fy, fz, field0, field4, q, qz);
      }
      if (bits2 & 512) {
        compNorm(q12);
        compNorm(q1z);
        VIntZ(q12 * 3, 27, isol, fx2, fy, fz, field1, field5, q12, q1z);
      }
      if (bits2 & 1024) {
        compNorm(q1y);
        compNorm(q1yz);
        VIntZ(q1y * 3, 30, isol, fx2, fy2, fz, field3, field7, q1y, q1yz);
      }
      if (bits2 & 2048) {
        compNorm(qy);
        compNorm(qyz);
        VIntZ(qy * 3, 33, isol, fx, fy2, fz, field2, field6, qy, qyz);
      }
      cubeindex <<= 4;
      let o1, o2, o3, numtris = 0, i4 = 0;
      while (triTable[cubeindex + i4] != -1) {
        o1 = cubeindex + i4;
        o2 = o1 + 1;
        o3 = o1 + 2;
        posnormtriv(vlist, nlist, clist, 3 * triTable[o1], 3 * triTable[o2], 3 * triTable[o3]);
        i4 += 3;
        numtris++;
      }
      return numtris;
    }
    function posnormtriv(pos, norm, colors2, o1, o2, o3) {
      const c2 = scope.count * 3;
      scope.positionArray[c2 + 0] = pos[o1];
      scope.positionArray[c2 + 1] = pos[o1 + 1];
      scope.positionArray[c2 + 2] = pos[o1 + 2];
      scope.positionArray[c2 + 3] = pos[o2];
      scope.positionArray[c2 + 4] = pos[o2 + 1];
      scope.positionArray[c2 + 5] = pos[o2 + 2];
      scope.positionArray[c2 + 6] = pos[o3];
      scope.positionArray[c2 + 7] = pos[o3 + 1];
      scope.positionArray[c2 + 8] = pos[o3 + 2];
      if (scope.material.flatShading === true) {
        const nx = (norm[o1 + 0] + norm[o2 + 0] + norm[o3 + 0]) / 3;
        const ny = (norm[o1 + 1] + norm[o2 + 1] + norm[o3 + 1]) / 3;
        const nz = (norm[o1 + 2] + norm[o2 + 2] + norm[o3 + 2]) / 3;
        scope.normalArray[c2 + 0] = nx;
        scope.normalArray[c2 + 1] = ny;
        scope.normalArray[c2 + 2] = nz;
        scope.normalArray[c2 + 3] = nx;
        scope.normalArray[c2 + 4] = ny;
        scope.normalArray[c2 + 5] = nz;
        scope.normalArray[c2 + 6] = nx;
        scope.normalArray[c2 + 7] = ny;
        scope.normalArray[c2 + 8] = nz;
      } else {
        scope.normalArray[c2 + 0] = norm[o1 + 0];
        scope.normalArray[c2 + 1] = norm[o1 + 1];
        scope.normalArray[c2 + 2] = norm[o1 + 2];
        scope.normalArray[c2 + 3] = norm[o2 + 0];
        scope.normalArray[c2 + 4] = norm[o2 + 1];
        scope.normalArray[c2 + 5] = norm[o2 + 2];
        scope.normalArray[c2 + 6] = norm[o3 + 0];
        scope.normalArray[c2 + 7] = norm[o3 + 1];
        scope.normalArray[c2 + 8] = norm[o3 + 2];
      }
      if (scope.enableUvs) {
        const d2 = scope.count * 2;
        scope.uvArray[d2 + 0] = pos[o1 + 0];
        scope.uvArray[d2 + 1] = pos[o1 + 2];
        scope.uvArray[d2 + 2] = pos[o2 + 0];
        scope.uvArray[d2 + 3] = pos[o2 + 2];
        scope.uvArray[d2 + 4] = pos[o3 + 0];
        scope.uvArray[d2 + 5] = pos[o3 + 2];
      }
      if (scope.enableColors) {
        scope.colorArray[c2 + 0] = colors2[o1 + 0];
        scope.colorArray[c2 + 1] = colors2[o1 + 1];
        scope.colorArray[c2 + 2] = colors2[o1 + 2];
        scope.colorArray[c2 + 3] = colors2[o2 + 0];
        scope.colorArray[c2 + 4] = colors2[o2 + 1];
        scope.colorArray[c2 + 5] = colors2[o2 + 2];
        scope.colorArray[c2 + 6] = colors2[o3 + 0];
        scope.colorArray[c2 + 7] = colors2[o3 + 1];
        scope.colorArray[c2 + 8] = colors2[o3 + 2];
      }
      scope.count += 3;
    }
    this.addBall = function(ballx, bally, ballz, strength, subtract, colors2) {
      const sign = Math.sign(strength);
      strength = Math.abs(strength);
      const userDefineColor = !(colors2 === void 0 || colors2 === null);
      let ballColor = new Color(ballx, bally, ballz);
      if (userDefineColor) {
        try {
          ballColor = colors2 instanceof Color ? colors2 : Array.isArray(colors2) ? new Color(
            Math.min(Math.abs(colors2[0]), 1),
            Math.min(Math.abs(colors2[1]), 1),
            Math.min(Math.abs(colors2[2]), 1)
          ) : new Color(colors2);
        } catch (err) {
          ballColor = new Color(ballx, bally, ballz);
        }
      }
      const radius = this.size * Math.sqrt(strength / subtract), zs = ballz * this.size, ys = bally * this.size, xs = ballx * this.size;
      let min_z = Math.floor(zs - radius);
      if (min_z < 1)
        min_z = 1;
      let max_z = Math.floor(zs + radius);
      if (max_z > this.size - 1)
        max_z = this.size - 1;
      let min_y = Math.floor(ys - radius);
      if (min_y < 1)
        min_y = 1;
      let max_y = Math.floor(ys + radius);
      if (max_y > this.size - 1)
        max_y = this.size - 1;
      let min_x = Math.floor(xs - radius);
      if (min_x < 1)
        min_x = 1;
      let max_x = Math.floor(xs + radius);
      if (max_x > this.size - 1)
        max_x = this.size - 1;
      let x, y, z, y_offset, z_offset, fx, fy, fz, fz2, fy2, val;
      for (z = min_z; z < max_z; z++) {
        z_offset = this.size2 * z;
        fz = z / this.size - ballz;
        fz2 = fz * fz;
        for (y = min_y; y < max_y; y++) {
          y_offset = z_offset + this.size * y;
          fy = y / this.size - bally;
          fy2 = fy * fy;
          for (x = min_x; x < max_x; x++) {
            fx = x / this.size - ballx;
            val = strength / (1e-6 + fx * fx + fy2 + fz2) - subtract;
            if (val > 0) {
              this.field[y_offset + x] += val * sign;
              const ratio = Math.sqrt((x - xs) * (x - xs) + (y - ys) * (y - ys) + (z - zs) * (z - zs)) / radius;
              const contrib = 1 - ratio * ratio * ratio * (ratio * (ratio * 6 - 15) + 10);
              this.palette[(y_offset + x) * 3 + 0] += ballColor.r * contrib;
              this.palette[(y_offset + x) * 3 + 1] += ballColor.g * contrib;
              this.palette[(y_offset + x) * 3 + 2] += ballColor.b * contrib;
            }
          }
        }
      }
    };
    this.addPlaneX = function(strength, subtract) {
      const size2 = this.size, yd = this.yd, zd = this.zd, field = this.field;
      let x, y, z, xx, val, xdiv, cxy, dist = size2 * Math.sqrt(strength / subtract);
      if (dist > size2)
        dist = size2;
      for (x = 0; x < dist; x++) {
        xdiv = x / size2;
        xx = xdiv * xdiv;
        val = strength / (1e-4 + xx) - subtract;
        if (val > 0) {
          for (y = 0; y < size2; y++) {
            cxy = x + y * yd;
            for (z = 0; z < size2; z++) {
              field[zd * z + cxy] += val;
            }
          }
        }
      }
    };
    this.addPlaneY = function(strength, subtract) {
      const size2 = this.size, yd = this.yd, zd = this.zd, field = this.field;
      let x, y, z, yy, val, ydiv, cy, cxy, dist = size2 * Math.sqrt(strength / subtract);
      if (dist > size2)
        dist = size2;
      for (y = 0; y < dist; y++) {
        ydiv = y / size2;
        yy = ydiv * ydiv;
        val = strength / (1e-4 + yy) - subtract;
        if (val > 0) {
          cy = y * yd;
          for (x = 0; x < size2; x++) {
            cxy = cy + x;
            for (z = 0; z < size2; z++)
              field[zd * z + cxy] += val;
          }
        }
      }
    };
    this.addPlaneZ = function(strength, subtract) {
      const size2 = this.size, yd = this.yd, zd = this.zd, field = this.field;
      let x, y, z, zz, val, zdiv, cz, cyz, dist = size2 * Math.sqrt(strength / subtract);
      if (dist > size2)
        dist = size2;
      for (z = 0; z < dist; z++) {
        zdiv = z / size2;
        zz = zdiv * zdiv;
        val = strength / (1e-4 + zz) - subtract;
        if (val > 0) {
          cz = zd * z;
          for (y = 0; y < size2; y++) {
            cyz = cz + y * yd;
            for (x = 0; x < size2; x++)
              field[cyz + x] += val;
          }
        }
      }
    };
    this.setCell = function(x, y, z, value) {
      const index2 = this.size2 * z + this.size * y + x;
      this.field[index2] = value;
    };
    this.getCell = function(x, y, z) {
      const index2 = this.size2 * z + this.size * y + x;
      return this.field[index2];
    };
    this.blur = function(intensity = 1) {
      const field = this.field;
      const fieldCopy = field.slice();
      const size2 = this.size;
      const size22 = this.size2;
      for (let x = 0; x < size2; x++) {
        for (let y = 0; y < size2; y++) {
          for (let z = 0; z < size2; z++) {
            const index2 = size22 * z + size2 * y + x;
            let val = fieldCopy[index2];
            let count = 1;
            for (let x2 = -1; x2 <= 1; x2 += 2) {
              const x3 = x2 + x;
              if (x3 < 0 || x3 >= size2)
                continue;
              for (let y2 = -1; y2 <= 1; y2 += 2) {
                const y3 = y2 + y;
                if (y3 < 0 || y3 >= size2)
                  continue;
                for (let z2 = -1; z2 <= 1; z2 += 2) {
                  const z3 = z2 + z;
                  if (z3 < 0 || z3 >= size2)
                    continue;
                  const index22 = size22 * z3 + size2 * y3 + x3;
                  const val2 = fieldCopy[index22];
                  count++;
                  val += intensity * (val2 - val) / count;
                }
              }
            }
            field[index2] = val;
          }
        }
      }
    };
    this.reset = function() {
      for (let i4 = 0; i4 < this.size3; i4++) {
        this.normal_cache[i4 * 3] = 0;
        this.field[i4] = 0;
        this.palette[i4 * 3] = this.palette[i4 * 3 + 1] = this.palette[i4 * 3 + 2] = 0;
      }
    };
    this.update = function() {
      this.count = 0;
      const smin2 = this.size - 2;
      for (let z = 1; z < smin2; z++) {
        const z_offset = this.size2 * z;
        const fz = (z - this.halfsize) / this.halfsize;
        for (let y = 1; y < smin2; y++) {
          const y_offset = z_offset + this.size * y;
          const fy = (y - this.halfsize) / this.halfsize;
          for (let x = 1; x < smin2; x++) {
            const fx = (x - this.halfsize) / this.halfsize;
            const q = y_offset + x;
            polygonize(fx, fy, fz, q, this.isolation);
          }
        }
      }
      this.geometry.setDrawRange(0, this.count);
      geometry3.getAttribute("position").needsUpdate = true;
      geometry3.getAttribute("normal").needsUpdate = true;
      if (this.enableUvs)
        geometry3.getAttribute("uv").needsUpdate = true;
      if (this.enableColors)
        geometry3.getAttribute("color").needsUpdate = true;
      if (this.count / 3 > maxPolyCount)
        console.warn(
          "THREE.MarchingCubes: Geometry buffers too small for rendering. Please create an instance with a higher poly count."
        );
    };
    this.init(resolution);
  }
};
var edgeTable = new Int32Array([
  0,
  265,
  515,
  778,
  1030,
  1295,
  1541,
  1804,
  2060,
  2309,
  2575,
  2822,
  3082,
  3331,
  3593,
  3840,
  400,
  153,
  915,
  666,
  1430,
  1183,
  1941,
  1692,
  2460,
  2197,
  2975,
  2710,
  3482,
  3219,
  3993,
  3728,
  560,
  825,
  51,
  314,
  1590,
  1855,
  1077,
  1340,
  2620,
  2869,
  2111,
  2358,
  3642,
  3891,
  3129,
  3376,
  928,
  681,
  419,
  170,
  1958,
  1711,
  1445,
  1196,
  2988,
  2725,
  2479,
  2214,
  4010,
  3747,
  3497,
  3232,
  1120,
  1385,
  1635,
  1898,
  102,
  367,
  613,
  876,
  3180,
  3429,
  3695,
  3942,
  2154,
  2403,
  2665,
  2912,
  1520,
  1273,
  2035,
  1786,
  502,
  255,
  1013,
  764,
  3580,
  3317,
  4095,
  3830,
  2554,
  2291,
  3065,
  2800,
  1616,
  1881,
  1107,
  1370,
  598,
  863,
  85,
  348,
  3676,
  3925,
  3167,
  3414,
  2650,
  2899,
  2137,
  2384,
  1984,
  1737,
  1475,
  1226,
  966,
  719,
  453,
  204,
  4044,
  3781,
  3535,
  3270,
  3018,
  2755,
  2505,
  2240,
  2240,
  2505,
  2755,
  3018,
  3270,
  3535,
  3781,
  4044,
  204,
  453,
  719,
  966,
  1226,
  1475,
  1737,
  1984,
  2384,
  2137,
  2899,
  2650,
  3414,
  3167,
  3925,
  3676,
  348,
  85,
  863,
  598,
  1370,
  1107,
  1881,
  1616,
  2800,
  3065,
  2291,
  2554,
  3830,
  4095,
  3317,
  3580,
  764,
  1013,
  255,
  502,
  1786,
  2035,
  1273,
  1520,
  2912,
  2665,
  2403,
  2154,
  3942,
  3695,
  3429,
  3180,
  876,
  613,
  367,
  102,
  1898,
  1635,
  1385,
  1120,
  3232,
  3497,
  3747,
  4010,
  2214,
  2479,
  2725,
  2988,
  1196,
  1445,
  1711,
  1958,
  170,
  419,
  681,
  928,
  3376,
  3129,
  3891,
  3642,
  2358,
  2111,
  2869,
  2620,
  1340,
  1077,
  1855,
  1590,
  314,
  51,
  825,
  560,
  3728,
  3993,
  3219,
  3482,
  2710,
  2975,
  2197,
  2460,
  1692,
  1941,
  1183,
  1430,
  666,
  915,
  153,
  400,
  3840,
  3593,
  3331,
  3082,
  2822,
  2575,
  2309,
  2060,
  1804,
  1541,
  1295,
  1030,
  778,
  515,
  265,
  0
]);
var triTable = new Int32Array([
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  8,
  3,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  1,
  9,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  8,
  3,
  9,
  8,
  1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  2,
  10,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  8,
  3,
  1,
  2,
  10,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  2,
  10,
  0,
  2,
  9,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  2,
  8,
  3,
  2,
  10,
  8,
  10,
  9,
  8,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  3,
  11,
  2,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  11,
  2,
  8,
  11,
  0,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  9,
  0,
  2,
  3,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  11,
  2,
  1,
  9,
  11,
  9,
  8,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  3,
  10,
  1,
  11,
  10,
  3,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  10,
  1,
  0,
  8,
  10,
  8,
  11,
  10,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  3,
  9,
  0,
  3,
  11,
  9,
  11,
  10,
  9,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  8,
  10,
  10,
  8,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  4,
  7,
  8,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  4,
  3,
  0,
  7,
  3,
  4,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  1,
  9,
  8,
  4,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  4,
  1,
  9,
  4,
  7,
  1,
  7,
  3,
  1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  2,
  10,
  8,
  4,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  3,
  4,
  7,
  3,
  0,
  4,
  1,
  2,
  10,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  2,
  10,
  9,
  0,
  2,
  8,
  4,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  2,
  10,
  9,
  2,
  9,
  7,
  2,
  7,
  3,
  7,
  9,
  4,
  -1,
  -1,
  -1,
  -1,
  8,
  4,
  7,
  3,
  11,
  2,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  11,
  4,
  7,
  11,
  2,
  4,
  2,
  0,
  4,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  0,
  1,
  8,
  4,
  7,
  2,
  3,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  4,
  7,
  11,
  9,
  4,
  11,
  9,
  11,
  2,
  9,
  2,
  1,
  -1,
  -1,
  -1,
  -1,
  3,
  10,
  1,
  3,
  11,
  10,
  7,
  8,
  4,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  11,
  10,
  1,
  4,
  11,
  1,
  0,
  4,
  7,
  11,
  4,
  -1,
  -1,
  -1,
  -1,
  4,
  7,
  8,
  9,
  0,
  11,
  9,
  11,
  10,
  11,
  0,
  3,
  -1,
  -1,
  -1,
  -1,
  4,
  7,
  11,
  4,
  11,
  9,
  9,
  11,
  10,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  5,
  4,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  5,
  4,
  0,
  8,
  3,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  5,
  4,
  1,
  5,
  0,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  8,
  5,
  4,
  8,
  3,
  5,
  3,
  1,
  5,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  2,
  10,
  9,
  5,
  4,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  3,
  0,
  8,
  1,
  2,
  10,
  4,
  9,
  5,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  5,
  2,
  10,
  5,
  4,
  2,
  4,
  0,
  2,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  2,
  10,
  5,
  3,
  2,
  5,
  3,
  5,
  4,
  3,
  4,
  8,
  -1,
  -1,
  -1,
  -1,
  9,
  5,
  4,
  2,
  3,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  11,
  2,
  0,
  8,
  11,
  4,
  9,
  5,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  5,
  4,
  0,
  1,
  5,
  2,
  3,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  2,
  1,
  5,
  2,
  5,
  8,
  2,
  8,
  11,
  4,
  8,
  5,
  -1,
  -1,
  -1,
  -1,
  10,
  3,
  11,
  10,
  1,
  3,
  9,
  5,
  4,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  4,
  9,
  5,
  0,
  8,
  1,
  8,
  10,
  1,
  8,
  11,
  10,
  -1,
  -1,
  -1,
  -1,
  5,
  4,
  0,
  5,
  0,
  11,
  5,
  11,
  10,
  11,
  0,
  3,
  -1,
  -1,
  -1,
  -1,
  5,
  4,
  8,
  5,
  8,
  10,
  10,
  8,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  7,
  8,
  5,
  7,
  9,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  3,
  0,
  9,
  5,
  3,
  5,
  7,
  3,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  7,
  8,
  0,
  1,
  7,
  1,
  5,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  5,
  3,
  3,
  5,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  7,
  8,
  9,
  5,
  7,
  10,
  1,
  2,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  10,
  1,
  2,
  9,
  5,
  0,
  5,
  3,
  0,
  5,
  7,
  3,
  -1,
  -1,
  -1,
  -1,
  8,
  0,
  2,
  8,
  2,
  5,
  8,
  5,
  7,
  10,
  5,
  2,
  -1,
  -1,
  -1,
  -1,
  2,
  10,
  5,
  2,
  5,
  3,
  3,
  5,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  7,
  9,
  5,
  7,
  8,
  9,
  3,
  11,
  2,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  5,
  7,
  9,
  7,
  2,
  9,
  2,
  0,
  2,
  7,
  11,
  -1,
  -1,
  -1,
  -1,
  2,
  3,
  11,
  0,
  1,
  8,
  1,
  7,
  8,
  1,
  5,
  7,
  -1,
  -1,
  -1,
  -1,
  11,
  2,
  1,
  11,
  1,
  7,
  7,
  1,
  5,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  5,
  8,
  8,
  5,
  7,
  10,
  1,
  3,
  10,
  3,
  11,
  -1,
  -1,
  -1,
  -1,
  5,
  7,
  0,
  5,
  0,
  9,
  7,
  11,
  0,
  1,
  0,
  10,
  11,
  10,
  0,
  -1,
  11,
  10,
  0,
  11,
  0,
  3,
  10,
  5,
  0,
  8,
  0,
  7,
  5,
  7,
  0,
  -1,
  11,
  10,
  5,
  7,
  11,
  5,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  10,
  6,
  5,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  8,
  3,
  5,
  10,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  0,
  1,
  5,
  10,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  8,
  3,
  1,
  9,
  8,
  5,
  10,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  6,
  5,
  2,
  6,
  1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  6,
  5,
  1,
  2,
  6,
  3,
  0,
  8,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  6,
  5,
  9,
  0,
  6,
  0,
  2,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  5,
  9,
  8,
  5,
  8,
  2,
  5,
  2,
  6,
  3,
  2,
  8,
  -1,
  -1,
  -1,
  -1,
  2,
  3,
  11,
  10,
  6,
  5,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  11,
  0,
  8,
  11,
  2,
  0,
  10,
  6,
  5,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  1,
  9,
  2,
  3,
  11,
  5,
  10,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  5,
  10,
  6,
  1,
  9,
  2,
  9,
  11,
  2,
  9,
  8,
  11,
  -1,
  -1,
  -1,
  -1,
  6,
  3,
  11,
  6,
  5,
  3,
  5,
  1,
  3,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  8,
  11,
  0,
  11,
  5,
  0,
  5,
  1,
  5,
  11,
  6,
  -1,
  -1,
  -1,
  -1,
  3,
  11,
  6,
  0,
  3,
  6,
  0,
  6,
  5,
  0,
  5,
  9,
  -1,
  -1,
  -1,
  -1,
  6,
  5,
  9,
  6,
  9,
  11,
  11,
  9,
  8,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  5,
  10,
  6,
  4,
  7,
  8,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  4,
  3,
  0,
  4,
  7,
  3,
  6,
  5,
  10,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  9,
  0,
  5,
  10,
  6,
  8,
  4,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  10,
  6,
  5,
  1,
  9,
  7,
  1,
  7,
  3,
  7,
  9,
  4,
  -1,
  -1,
  -1,
  -1,
  6,
  1,
  2,
  6,
  5,
  1,
  4,
  7,
  8,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  2,
  5,
  5,
  2,
  6,
  3,
  0,
  4,
  3,
  4,
  7,
  -1,
  -1,
  -1,
  -1,
  8,
  4,
  7,
  9,
  0,
  5,
  0,
  6,
  5,
  0,
  2,
  6,
  -1,
  -1,
  -1,
  -1,
  7,
  3,
  9,
  7,
  9,
  4,
  3,
  2,
  9,
  5,
  9,
  6,
  2,
  6,
  9,
  -1,
  3,
  11,
  2,
  7,
  8,
  4,
  10,
  6,
  5,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  5,
  10,
  6,
  4,
  7,
  2,
  4,
  2,
  0,
  2,
  7,
  11,
  -1,
  -1,
  -1,
  -1,
  0,
  1,
  9,
  4,
  7,
  8,
  2,
  3,
  11,
  5,
  10,
  6,
  -1,
  -1,
  -1,
  -1,
  9,
  2,
  1,
  9,
  11,
  2,
  9,
  4,
  11,
  7,
  11,
  4,
  5,
  10,
  6,
  -1,
  8,
  4,
  7,
  3,
  11,
  5,
  3,
  5,
  1,
  5,
  11,
  6,
  -1,
  -1,
  -1,
  -1,
  5,
  1,
  11,
  5,
  11,
  6,
  1,
  0,
  11,
  7,
  11,
  4,
  0,
  4,
  11,
  -1,
  0,
  5,
  9,
  0,
  6,
  5,
  0,
  3,
  6,
  11,
  6,
  3,
  8,
  4,
  7,
  -1,
  6,
  5,
  9,
  6,
  9,
  11,
  4,
  7,
  9,
  7,
  11,
  9,
  -1,
  -1,
  -1,
  -1,
  10,
  4,
  9,
  6,
  4,
  10,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  4,
  10,
  6,
  4,
  9,
  10,
  0,
  8,
  3,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  10,
  0,
  1,
  10,
  6,
  0,
  6,
  4,
  0,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  8,
  3,
  1,
  8,
  1,
  6,
  8,
  6,
  4,
  6,
  1,
  10,
  -1,
  -1,
  -1,
  -1,
  1,
  4,
  9,
  1,
  2,
  4,
  2,
  6,
  4,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  3,
  0,
  8,
  1,
  2,
  9,
  2,
  4,
  9,
  2,
  6,
  4,
  -1,
  -1,
  -1,
  -1,
  0,
  2,
  4,
  4,
  2,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  8,
  3,
  2,
  8,
  2,
  4,
  4,
  2,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  10,
  4,
  9,
  10,
  6,
  4,
  11,
  2,
  3,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  8,
  2,
  2,
  8,
  11,
  4,
  9,
  10,
  4,
  10,
  6,
  -1,
  -1,
  -1,
  -1,
  3,
  11,
  2,
  0,
  1,
  6,
  0,
  6,
  4,
  6,
  1,
  10,
  -1,
  -1,
  -1,
  -1,
  6,
  4,
  1,
  6,
  1,
  10,
  4,
  8,
  1,
  2,
  1,
  11,
  8,
  11,
  1,
  -1,
  9,
  6,
  4,
  9,
  3,
  6,
  9,
  1,
  3,
  11,
  6,
  3,
  -1,
  -1,
  -1,
  -1,
  8,
  11,
  1,
  8,
  1,
  0,
  11,
  6,
  1,
  9,
  1,
  4,
  6,
  4,
  1,
  -1,
  3,
  11,
  6,
  3,
  6,
  0,
  0,
  6,
  4,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  6,
  4,
  8,
  11,
  6,
  8,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  7,
  10,
  6,
  7,
  8,
  10,
  8,
  9,
  10,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  7,
  3,
  0,
  10,
  7,
  0,
  9,
  10,
  6,
  7,
  10,
  -1,
  -1,
  -1,
  -1,
  10,
  6,
  7,
  1,
  10,
  7,
  1,
  7,
  8,
  1,
  8,
  0,
  -1,
  -1,
  -1,
  -1,
  10,
  6,
  7,
  10,
  7,
  1,
  1,
  7,
  3,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  2,
  6,
  1,
  6,
  8,
  1,
  8,
  9,
  8,
  6,
  7,
  -1,
  -1,
  -1,
  -1,
  2,
  6,
  9,
  2,
  9,
  1,
  6,
  7,
  9,
  0,
  9,
  3,
  7,
  3,
  9,
  -1,
  7,
  8,
  0,
  7,
  0,
  6,
  6,
  0,
  2,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  7,
  3,
  2,
  6,
  7,
  2,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  2,
  3,
  11,
  10,
  6,
  8,
  10,
  8,
  9,
  8,
  6,
  7,
  -1,
  -1,
  -1,
  -1,
  2,
  0,
  7,
  2,
  7,
  11,
  0,
  9,
  7,
  6,
  7,
  10,
  9,
  10,
  7,
  -1,
  1,
  8,
  0,
  1,
  7,
  8,
  1,
  10,
  7,
  6,
  7,
  10,
  2,
  3,
  11,
  -1,
  11,
  2,
  1,
  11,
  1,
  7,
  10,
  6,
  1,
  6,
  7,
  1,
  -1,
  -1,
  -1,
  -1,
  8,
  9,
  6,
  8,
  6,
  7,
  9,
  1,
  6,
  11,
  6,
  3,
  1,
  3,
  6,
  -1,
  0,
  9,
  1,
  11,
  6,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  7,
  8,
  0,
  7,
  0,
  6,
  3,
  11,
  0,
  11,
  6,
  0,
  -1,
  -1,
  -1,
  -1,
  7,
  11,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  7,
  6,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  3,
  0,
  8,
  11,
  7,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  1,
  9,
  11,
  7,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  8,
  1,
  9,
  8,
  3,
  1,
  11,
  7,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  10,
  1,
  2,
  6,
  11,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  2,
  10,
  3,
  0,
  8,
  6,
  11,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  2,
  9,
  0,
  2,
  10,
  9,
  6,
  11,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  6,
  11,
  7,
  2,
  10,
  3,
  10,
  8,
  3,
  10,
  9,
  8,
  -1,
  -1,
  -1,
  -1,
  7,
  2,
  3,
  6,
  2,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  7,
  0,
  8,
  7,
  6,
  0,
  6,
  2,
  0,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  2,
  7,
  6,
  2,
  3,
  7,
  0,
  1,
  9,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  6,
  2,
  1,
  8,
  6,
  1,
  9,
  8,
  8,
  7,
  6,
  -1,
  -1,
  -1,
  -1,
  10,
  7,
  6,
  10,
  1,
  7,
  1,
  3,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  10,
  7,
  6,
  1,
  7,
  10,
  1,
  8,
  7,
  1,
  0,
  8,
  -1,
  -1,
  -1,
  -1,
  0,
  3,
  7,
  0,
  7,
  10,
  0,
  10,
  9,
  6,
  10,
  7,
  -1,
  -1,
  -1,
  -1,
  7,
  6,
  10,
  7,
  10,
  8,
  8,
  10,
  9,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  6,
  8,
  4,
  11,
  8,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  3,
  6,
  11,
  3,
  0,
  6,
  0,
  4,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  8,
  6,
  11,
  8,
  4,
  6,
  9,
  0,
  1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  4,
  6,
  9,
  6,
  3,
  9,
  3,
  1,
  11,
  3,
  6,
  -1,
  -1,
  -1,
  -1,
  6,
  8,
  4,
  6,
  11,
  8,
  2,
  10,
  1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  2,
  10,
  3,
  0,
  11,
  0,
  6,
  11,
  0,
  4,
  6,
  -1,
  -1,
  -1,
  -1,
  4,
  11,
  8,
  4,
  6,
  11,
  0,
  2,
  9,
  2,
  10,
  9,
  -1,
  -1,
  -1,
  -1,
  10,
  9,
  3,
  10,
  3,
  2,
  9,
  4,
  3,
  11,
  3,
  6,
  4,
  6,
  3,
  -1,
  8,
  2,
  3,
  8,
  4,
  2,
  4,
  6,
  2,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  4,
  2,
  4,
  6,
  2,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  9,
  0,
  2,
  3,
  4,
  2,
  4,
  6,
  4,
  3,
  8,
  -1,
  -1,
  -1,
  -1,
  1,
  9,
  4,
  1,
  4,
  2,
  2,
  4,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  8,
  1,
  3,
  8,
  6,
  1,
  8,
  4,
  6,
  6,
  10,
  1,
  -1,
  -1,
  -1,
  -1,
  10,
  1,
  0,
  10,
  0,
  6,
  6,
  0,
  4,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  4,
  6,
  3,
  4,
  3,
  8,
  6,
  10,
  3,
  0,
  3,
  9,
  10,
  9,
  3,
  -1,
  10,
  9,
  4,
  6,
  10,
  4,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  4,
  9,
  5,
  7,
  6,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  8,
  3,
  4,
  9,
  5,
  11,
  7,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  5,
  0,
  1,
  5,
  4,
  0,
  7,
  6,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  11,
  7,
  6,
  8,
  3,
  4,
  3,
  5,
  4,
  3,
  1,
  5,
  -1,
  -1,
  -1,
  -1,
  9,
  5,
  4,
  10,
  1,
  2,
  7,
  6,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  6,
  11,
  7,
  1,
  2,
  10,
  0,
  8,
  3,
  4,
  9,
  5,
  -1,
  -1,
  -1,
  -1,
  7,
  6,
  11,
  5,
  4,
  10,
  4,
  2,
  10,
  4,
  0,
  2,
  -1,
  -1,
  -1,
  -1,
  3,
  4,
  8,
  3,
  5,
  4,
  3,
  2,
  5,
  10,
  5,
  2,
  11,
  7,
  6,
  -1,
  7,
  2,
  3,
  7,
  6,
  2,
  5,
  4,
  9,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  5,
  4,
  0,
  8,
  6,
  0,
  6,
  2,
  6,
  8,
  7,
  -1,
  -1,
  -1,
  -1,
  3,
  6,
  2,
  3,
  7,
  6,
  1,
  5,
  0,
  5,
  4,
  0,
  -1,
  -1,
  -1,
  -1,
  6,
  2,
  8,
  6,
  8,
  7,
  2,
  1,
  8,
  4,
  8,
  5,
  1,
  5,
  8,
  -1,
  9,
  5,
  4,
  10,
  1,
  6,
  1,
  7,
  6,
  1,
  3,
  7,
  -1,
  -1,
  -1,
  -1,
  1,
  6,
  10,
  1,
  7,
  6,
  1,
  0,
  7,
  8,
  7,
  0,
  9,
  5,
  4,
  -1,
  4,
  0,
  10,
  4,
  10,
  5,
  0,
  3,
  10,
  6,
  10,
  7,
  3,
  7,
  10,
  -1,
  7,
  6,
  10,
  7,
  10,
  8,
  5,
  4,
  10,
  4,
  8,
  10,
  -1,
  -1,
  -1,
  -1,
  6,
  9,
  5,
  6,
  11,
  9,
  11,
  8,
  9,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  3,
  6,
  11,
  0,
  6,
  3,
  0,
  5,
  6,
  0,
  9,
  5,
  -1,
  -1,
  -1,
  -1,
  0,
  11,
  8,
  0,
  5,
  11,
  0,
  1,
  5,
  5,
  6,
  11,
  -1,
  -1,
  -1,
  -1,
  6,
  11,
  3,
  6,
  3,
  5,
  5,
  3,
  1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  2,
  10,
  9,
  5,
  11,
  9,
  11,
  8,
  11,
  5,
  6,
  -1,
  -1,
  -1,
  -1,
  0,
  11,
  3,
  0,
  6,
  11,
  0,
  9,
  6,
  5,
  6,
  9,
  1,
  2,
  10,
  -1,
  11,
  8,
  5,
  11,
  5,
  6,
  8,
  0,
  5,
  10,
  5,
  2,
  0,
  2,
  5,
  -1,
  6,
  11,
  3,
  6,
  3,
  5,
  2,
  10,
  3,
  10,
  5,
  3,
  -1,
  -1,
  -1,
  -1,
  5,
  8,
  9,
  5,
  2,
  8,
  5,
  6,
  2,
  3,
  8,
  2,
  -1,
  -1,
  -1,
  -1,
  9,
  5,
  6,
  9,
  6,
  0,
  0,
  6,
  2,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  5,
  8,
  1,
  8,
  0,
  5,
  6,
  8,
  3,
  8,
  2,
  6,
  2,
  8,
  -1,
  1,
  5,
  6,
  2,
  1,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  3,
  6,
  1,
  6,
  10,
  3,
  8,
  6,
  5,
  6,
  9,
  8,
  9,
  6,
  -1,
  10,
  1,
  0,
  10,
  0,
  6,
  9,
  5,
  0,
  5,
  6,
  0,
  -1,
  -1,
  -1,
  -1,
  0,
  3,
  8,
  5,
  6,
  10,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  10,
  5,
  6,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  11,
  5,
  10,
  7,
  5,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  11,
  5,
  10,
  11,
  7,
  5,
  8,
  3,
  0,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  5,
  11,
  7,
  5,
  10,
  11,
  1,
  9,
  0,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  10,
  7,
  5,
  10,
  11,
  7,
  9,
  8,
  1,
  8,
  3,
  1,
  -1,
  -1,
  -1,
  -1,
  11,
  1,
  2,
  11,
  7,
  1,
  7,
  5,
  1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  8,
  3,
  1,
  2,
  7,
  1,
  7,
  5,
  7,
  2,
  11,
  -1,
  -1,
  -1,
  -1,
  9,
  7,
  5,
  9,
  2,
  7,
  9,
  0,
  2,
  2,
  11,
  7,
  -1,
  -1,
  -1,
  -1,
  7,
  5,
  2,
  7,
  2,
  11,
  5,
  9,
  2,
  3,
  2,
  8,
  9,
  8,
  2,
  -1,
  2,
  5,
  10,
  2,
  3,
  5,
  3,
  7,
  5,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  8,
  2,
  0,
  8,
  5,
  2,
  8,
  7,
  5,
  10,
  2,
  5,
  -1,
  -1,
  -1,
  -1,
  9,
  0,
  1,
  5,
  10,
  3,
  5,
  3,
  7,
  3,
  10,
  2,
  -1,
  -1,
  -1,
  -1,
  9,
  8,
  2,
  9,
  2,
  1,
  8,
  7,
  2,
  10,
  2,
  5,
  7,
  5,
  2,
  -1,
  1,
  3,
  5,
  3,
  7,
  5,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  8,
  7,
  0,
  7,
  1,
  1,
  7,
  5,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  0,
  3,
  9,
  3,
  5,
  5,
  3,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  8,
  7,
  5,
  9,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  5,
  8,
  4,
  5,
  10,
  8,
  10,
  11,
  8,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  5,
  0,
  4,
  5,
  11,
  0,
  5,
  10,
  11,
  11,
  3,
  0,
  -1,
  -1,
  -1,
  -1,
  0,
  1,
  9,
  8,
  4,
  10,
  8,
  10,
  11,
  10,
  4,
  5,
  -1,
  -1,
  -1,
  -1,
  10,
  11,
  4,
  10,
  4,
  5,
  11,
  3,
  4,
  9,
  4,
  1,
  3,
  1,
  4,
  -1,
  2,
  5,
  1,
  2,
  8,
  5,
  2,
  11,
  8,
  4,
  5,
  8,
  -1,
  -1,
  -1,
  -1,
  0,
  4,
  11,
  0,
  11,
  3,
  4,
  5,
  11,
  2,
  11,
  1,
  5,
  1,
  11,
  -1,
  0,
  2,
  5,
  0,
  5,
  9,
  2,
  11,
  5,
  4,
  5,
  8,
  11,
  8,
  5,
  -1,
  9,
  4,
  5,
  2,
  11,
  3,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  2,
  5,
  10,
  3,
  5,
  2,
  3,
  4,
  5,
  3,
  8,
  4,
  -1,
  -1,
  -1,
  -1,
  5,
  10,
  2,
  5,
  2,
  4,
  4,
  2,
  0,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  3,
  10,
  2,
  3,
  5,
  10,
  3,
  8,
  5,
  4,
  5,
  8,
  0,
  1,
  9,
  -1,
  5,
  10,
  2,
  5,
  2,
  4,
  1,
  9,
  2,
  9,
  4,
  2,
  -1,
  -1,
  -1,
  -1,
  8,
  4,
  5,
  8,
  5,
  3,
  3,
  5,
  1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  4,
  5,
  1,
  0,
  5,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  8,
  4,
  5,
  8,
  5,
  3,
  9,
  0,
  5,
  0,
  3,
  5,
  -1,
  -1,
  -1,
  -1,
  9,
  4,
  5,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  4,
  11,
  7,
  4,
  9,
  11,
  9,
  10,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  8,
  3,
  4,
  9,
  7,
  9,
  11,
  7,
  9,
  10,
  11,
  -1,
  -1,
  -1,
  -1,
  1,
  10,
  11,
  1,
  11,
  4,
  1,
  4,
  0,
  7,
  4,
  11,
  -1,
  -1,
  -1,
  -1,
  3,
  1,
  4,
  3,
  4,
  8,
  1,
  10,
  4,
  7,
  4,
  11,
  10,
  11,
  4,
  -1,
  4,
  11,
  7,
  9,
  11,
  4,
  9,
  2,
  11,
  9,
  1,
  2,
  -1,
  -1,
  -1,
  -1,
  9,
  7,
  4,
  9,
  11,
  7,
  9,
  1,
  11,
  2,
  11,
  1,
  0,
  8,
  3,
  -1,
  11,
  7,
  4,
  11,
  4,
  2,
  2,
  4,
  0,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  11,
  7,
  4,
  11,
  4,
  2,
  8,
  3,
  4,
  3,
  2,
  4,
  -1,
  -1,
  -1,
  -1,
  2,
  9,
  10,
  2,
  7,
  9,
  2,
  3,
  7,
  7,
  4,
  9,
  -1,
  -1,
  -1,
  -1,
  9,
  10,
  7,
  9,
  7,
  4,
  10,
  2,
  7,
  8,
  7,
  0,
  2,
  0,
  7,
  -1,
  3,
  7,
  10,
  3,
  10,
  2,
  7,
  4,
  10,
  1,
  10,
  0,
  4,
  0,
  10,
  -1,
  1,
  10,
  2,
  8,
  7,
  4,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  4,
  9,
  1,
  4,
  1,
  7,
  7,
  1,
  3,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  4,
  9,
  1,
  4,
  1,
  7,
  0,
  8,
  1,
  8,
  7,
  1,
  -1,
  -1,
  -1,
  -1,
  4,
  0,
  3,
  7,
  4,
  3,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  4,
  8,
  7,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  10,
  8,
  10,
  11,
  8,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  3,
  0,
  9,
  3,
  9,
  11,
  11,
  9,
  10,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  1,
  10,
  0,
  10,
  8,
  8,
  10,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  3,
  1,
  10,
  11,
  3,
  10,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  2,
  11,
  1,
  11,
  9,
  9,
  11,
  8,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  3,
  0,
  9,
  3,
  9,
  11,
  1,
  2,
  9,
  2,
  11,
  9,
  -1,
  -1,
  -1,
  -1,
  0,
  2,
  11,
  8,
  0,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  3,
  2,
  11,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  2,
  3,
  8,
  2,
  8,
  10,
  10,
  8,
  9,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  9,
  10,
  2,
  0,
  9,
  2,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  2,
  3,
  8,
  2,
  8,
  10,
  0,
  1,
  8,
  1,
  10,
  8,
  -1,
  -1,
  -1,
  -1,
  1,
  10,
  2,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  3,
  8,
  9,
  1,
  8,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  9,
  1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  0,
  3,
  8,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1
]);

// node_modules/three-stdlib/math/SimplexNoise.js
var __defProp6 = Object.defineProperty;
var __defNormalProp6 = (obj, key, value) => key in obj ? __defProp6(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField7 = (obj, key, value) => {
  __defNormalProp6(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var SimplexNoise = class {
  /**
   * You can pass in a random number generator object if you like.
   * It is assumed to have a random() method.
   */
  constructor(r2 = Math) {
    __publicField7(this, "grad3", [
      [1, 1, 0],
      [-1, 1, 0],
      [1, -1, 0],
      [-1, -1, 0],
      [1, 0, 1],
      [-1, 0, 1],
      [1, 0, -1],
      [-1, 0, -1],
      [0, 1, 1],
      [0, -1, 1],
      [0, 1, -1],
      [0, -1, -1]
    ]);
    __publicField7(this, "grad4", [
      [0, 1, 1, 1],
      [0, 1, 1, -1],
      [0, 1, -1, 1],
      [0, 1, -1, -1],
      [0, -1, 1, 1],
      [0, -1, 1, -1],
      [0, -1, -1, 1],
      [0, -1, -1, -1],
      [1, 0, 1, 1],
      [1, 0, 1, -1],
      [1, 0, -1, 1],
      [1, 0, -1, -1],
      [-1, 0, 1, 1],
      [-1, 0, 1, -1],
      [-1, 0, -1, 1],
      [-1, 0, -1, -1],
      [1, 1, 0, 1],
      [1, 1, 0, -1],
      [1, -1, 0, 1],
      [1, -1, 0, -1],
      [-1, 1, 0, 1],
      [-1, 1, 0, -1],
      [-1, -1, 0, 1],
      [-1, -1, 0, -1],
      [1, 1, 1, 0],
      [1, 1, -1, 0],
      [1, -1, 1, 0],
      [1, -1, -1, 0],
      [-1, 1, 1, 0],
      [-1, 1, -1, 0],
      [-1, -1, 1, 0],
      [-1, -1, -1, 0]
    ]);
    __publicField7(this, "p", []);
    __publicField7(this, "perm", []);
    __publicField7(this, "simplex", [
      [0, 1, 2, 3],
      [0, 1, 3, 2],
      [0, 0, 0, 0],
      [0, 2, 3, 1],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [1, 2, 3, 0],
      [0, 2, 1, 3],
      [0, 0, 0, 0],
      [0, 3, 1, 2],
      [0, 3, 2, 1],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [1, 3, 2, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [1, 2, 0, 3],
      [0, 0, 0, 0],
      [1, 3, 0, 2],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [2, 3, 0, 1],
      [2, 3, 1, 0],
      [1, 0, 2, 3],
      [1, 0, 3, 2],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [2, 0, 3, 1],
      [0, 0, 0, 0],
      [2, 1, 3, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [2, 0, 1, 3],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [3, 0, 1, 2],
      [3, 0, 2, 1],
      [0, 0, 0, 0],
      [3, 1, 2, 0],
      [2, 1, 0, 3],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [0, 0, 0, 0],
      [3, 1, 0, 2],
      [0, 0, 0, 0],
      [3, 2, 0, 1],
      [3, 2, 1, 0]
    ]);
    __publicField7(this, "dot", (g, x, y) => {
      return g[0] * x + g[1] * y;
    });
    __publicField7(this, "dot3", (g, x, y, z) => {
      return g[0] * x + g[1] * y + g[2] * z;
    });
    __publicField7(this, "dot4", (g, x, y, z, w) => {
      return g[0] * x + g[1] * y + g[2] * z + g[3] * w;
    });
    __publicField7(this, "noise", (xin, yin) => {
      let n0;
      let n1;
      let n2;
      const F22 = 0.5 * (Math.sqrt(3) - 1);
      const s2 = (xin + yin) * F22;
      const i4 = Math.floor(xin + s2);
      const j = Math.floor(yin + s2);
      const G22 = (3 - Math.sqrt(3)) / 6;
      const t3 = (i4 + j) * G22;
      const X0 = i4 - t3;
      const Y0 = j - t3;
      const x0 = xin - X0;
      const y0 = yin - Y0;
      let i1 = 0;
      let j1 = 1;
      if (x0 > y0) {
        i1 = 1;
        j1 = 0;
      }
      const x1 = x0 - i1 + G22;
      const y1 = y0 - j1 + G22;
      const x2 = x0 - 1 + 2 * G22;
      const y2 = y0 - 1 + 2 * G22;
      const ii = i4 & 255;
      const jj = j & 255;
      const gi0 = this.perm[ii + this.perm[jj]] % 12;
      const gi1 = this.perm[ii + i1 + this.perm[jj + j1]] % 12;
      const gi2 = this.perm[ii + 1 + this.perm[jj + 1]] % 12;
      let t0 = 0.5 - x0 * x0 - y0 * y0;
      if (t0 < 0) {
        n0 = 0;
      } else {
        t0 *= t0;
        n0 = t0 * t0 * this.dot(this.grad3[gi0], x0, y0);
      }
      let t1 = 0.5 - x1 * x1 - y1 * y1;
      if (t1 < 0) {
        n1 = 0;
      } else {
        t1 *= t1;
        n1 = t1 * t1 * this.dot(this.grad3[gi1], x1, y1);
      }
      let t22 = 0.5 - x2 * x2 - y2 * y2;
      if (t22 < 0) {
        n2 = 0;
      } else {
        t22 *= t22;
        n2 = t22 * t22 * this.dot(this.grad3[gi2], x2, y2);
      }
      return 70 * (n0 + n1 + n2);
    });
    __publicField7(this, "noise3d", (xin, yin, zin) => {
      let n0;
      let n1;
      let n2;
      let n3;
      const F32 = 1 / 3;
      const s2 = (xin + yin + zin) * F32;
      const i4 = Math.floor(xin + s2);
      const j = Math.floor(yin + s2);
      const k = Math.floor(zin + s2);
      const G32 = 1 / 6;
      const t3 = (i4 + j + k) * G32;
      const X0 = i4 - t3;
      const Y0 = j - t3;
      const Z0 = k - t3;
      const x0 = xin - X0;
      const y0 = yin - Y0;
      const z0 = zin - Z0;
      let i1;
      let j1;
      let k1;
      let i22;
      let j2;
      let k2;
      if (x0 >= y0) {
        if (y0 >= z0) {
          i1 = 1;
          j1 = 0;
          k1 = 0;
          i22 = 1;
          j2 = 1;
          k2 = 0;
        } else if (x0 >= z0) {
          i1 = 1;
          j1 = 0;
          k1 = 0;
          i22 = 1;
          j2 = 0;
          k2 = 1;
        } else {
          i1 = 0;
          j1 = 0;
          k1 = 1;
          i22 = 1;
          j2 = 0;
          k2 = 1;
        }
      } else {
        if (y0 < z0) {
          i1 = 0;
          j1 = 0;
          k1 = 1;
          i22 = 0;
          j2 = 1;
          k2 = 1;
        } else if (x0 < z0) {
          i1 = 0;
          j1 = 1;
          k1 = 0;
          i22 = 0;
          j2 = 1;
          k2 = 1;
        } else {
          i1 = 0;
          j1 = 1;
          k1 = 0;
          i22 = 1;
          j2 = 1;
          k2 = 0;
        }
      }
      const x1 = x0 - i1 + G32;
      const y1 = y0 - j1 + G32;
      const z1 = z0 - k1 + G32;
      const x2 = x0 - i22 + 2 * G32;
      const y2 = y0 - j2 + 2 * G32;
      const z2 = z0 - k2 + 2 * G32;
      const x3 = x0 - 1 + 3 * G32;
      const y3 = y0 - 1 + 3 * G32;
      const z3 = z0 - 1 + 3 * G32;
      const ii = i4 & 255;
      const jj = j & 255;
      const kk = k & 255;
      const gi0 = this.perm[ii + this.perm[jj + this.perm[kk]]] % 12;
      const gi1 = this.perm[ii + i1 + this.perm[jj + j1 + this.perm[kk + k1]]] % 12;
      const gi2 = this.perm[ii + i22 + this.perm[jj + j2 + this.perm[kk + k2]]] % 12;
      const gi3 = this.perm[ii + 1 + this.perm[jj + 1 + this.perm[kk + 1]]] % 12;
      let t0 = 0.6 - x0 * x0 - y0 * y0 - z0 * z0;
      if (t0 < 0) {
        n0 = 0;
      } else {
        t0 *= t0;
        n0 = t0 * t0 * this.dot3(this.grad3[gi0], x0, y0, z0);
      }
      let t1 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1;
      if (t1 < 0) {
        n1 = 0;
      } else {
        t1 *= t1;
        n1 = t1 * t1 * this.dot3(this.grad3[gi1], x1, y1, z1);
      }
      let t22 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2;
      if (t22 < 0) {
        n2 = 0;
      } else {
        t22 *= t22;
        n2 = t22 * t22 * this.dot3(this.grad3[gi2], x2, y2, z2);
      }
      let t32 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3;
      if (t32 < 0) {
        n3 = 0;
      } else {
        t32 *= t32;
        n3 = t32 * t32 * this.dot3(this.grad3[gi3], x3, y3, z3);
      }
      return 32 * (n0 + n1 + n2 + n3);
    });
    __publicField7(this, "noise4d", (x, y, z, w) => {
      const grad4 = this.grad4;
      const simplex = this.simplex;
      const perm2 = this.perm;
      const F4 = (Math.sqrt(5) - 1) / 4;
      const G4 = (5 - Math.sqrt(5)) / 20;
      let n0;
      let n1;
      let n2;
      let n3;
      let n4;
      const s2 = (x + y + z + w) * F4;
      const i4 = Math.floor(x + s2);
      const j = Math.floor(y + s2);
      const k = Math.floor(z + s2);
      const l2 = Math.floor(w + s2);
      const t3 = (i4 + j + k + l2) * G4;
      const X0 = i4 - t3;
      const Y0 = j - t3;
      const Z0 = k - t3;
      const W0 = l2 - t3;
      const x0 = x - X0;
      const y0 = y - Y0;
      const z0 = z - Z0;
      const w0 = w - W0;
      const c1 = x0 > y0 ? 32 : 0;
      const c2 = x0 > z0 ? 16 : 0;
      const c32 = y0 > z0 ? 8 : 0;
      const c42 = x0 > w0 ? 4 : 0;
      const c5 = y0 > w0 ? 2 : 0;
      const c6 = z0 > w0 ? 1 : 0;
      const c7 = c1 + c2 + c32 + c42 + c5 + c6;
      let i1;
      let j1;
      let k1;
      let l1;
      let i22;
      let j2;
      let k2;
      let l22;
      let i32;
      let j3;
      let k3;
      let l3;
      i1 = simplex[c7][0] >= 3 ? 1 : 0;
      j1 = simplex[c7][1] >= 3 ? 1 : 0;
      k1 = simplex[c7][2] >= 3 ? 1 : 0;
      l1 = simplex[c7][3] >= 3 ? 1 : 0;
      i22 = simplex[c7][0] >= 2 ? 1 : 0;
      j2 = simplex[c7][1] >= 2 ? 1 : 0;
      k2 = simplex[c7][2] >= 2 ? 1 : 0;
      l22 = simplex[c7][3] >= 2 ? 1 : 0;
      i32 = simplex[c7][0] >= 1 ? 1 : 0;
      j3 = simplex[c7][1] >= 1 ? 1 : 0;
      k3 = simplex[c7][2] >= 1 ? 1 : 0;
      l3 = simplex[c7][3] >= 1 ? 1 : 0;
      const x1 = x0 - i1 + G4;
      const y1 = y0 - j1 + G4;
      const z1 = z0 - k1 + G4;
      const w1 = w0 - l1 + G4;
      const x2 = x0 - i22 + 2 * G4;
      const y2 = y0 - j2 + 2 * G4;
      const z2 = z0 - k2 + 2 * G4;
      const w2 = w0 - l22 + 2 * G4;
      const x3 = x0 - i32 + 3 * G4;
      const y3 = y0 - j3 + 3 * G4;
      const z3 = z0 - k3 + 3 * G4;
      const w3 = w0 - l3 + 3 * G4;
      const x4 = x0 - 1 + 4 * G4;
      const y4 = y0 - 1 + 4 * G4;
      const z4 = z0 - 1 + 4 * G4;
      const w4 = w0 - 1 + 4 * G4;
      const ii = i4 & 255;
      const jj = j & 255;
      const kk = k & 255;
      const ll = l2 & 255;
      const gi0 = perm2[ii + perm2[jj + perm2[kk + perm2[ll]]]] % 32;
      const gi1 = perm2[ii + i1 + perm2[jj + j1 + perm2[kk + k1 + perm2[ll + l1]]]] % 32;
      const gi2 = perm2[ii + i22 + perm2[jj + j2 + perm2[kk + k2 + perm2[ll + l22]]]] % 32;
      const gi3 = perm2[ii + i32 + perm2[jj + j3 + perm2[kk + k3 + perm2[ll + l3]]]] % 32;
      const gi4 = perm2[ii + 1 + perm2[jj + 1 + perm2[kk + 1 + perm2[ll + 1]]]] % 32;
      let t0 = 0.6 - x0 * x0 - y0 * y0 - z0 * z0 - w0 * w0;
      if (t0 < 0) {
        n0 = 0;
      } else {
        t0 *= t0;
        n0 = t0 * t0 * this.dot4(grad4[gi0], x0, y0, z0, w0);
      }
      let t1 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1 - w1 * w1;
      if (t1 < 0) {
        n1 = 0;
      } else {
        t1 *= t1;
        n1 = t1 * t1 * this.dot4(grad4[gi1], x1, y1, z1, w1);
      }
      let t22 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2 - w2 * w2;
      if (t22 < 0) {
        n2 = 0;
      } else {
        t22 *= t22;
        n2 = t22 * t22 * this.dot4(grad4[gi2], x2, y2, z2, w2);
      }
      let t32 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3 - w3 * w3;
      if (t32 < 0) {
        n3 = 0;
      } else {
        t32 *= t32;
        n3 = t32 * t32 * this.dot4(grad4[gi3], x3, y3, z3, w3);
      }
      let t4 = 0.6 - x4 * x4 - y4 * y4 - z4 * z4 - w4 * w4;
      if (t4 < 0) {
        n4 = 0;
      } else {
        t4 *= t4;
        n4 = t4 * t4 * this.dot4(grad4[gi4], x4, y4, z4, w4);
      }
      return 27 * (n0 + n1 + n2 + n3 + n4);
    });
    for (let i4 = 0; i4 < 256; i4++) {
      this.p[i4] = Math.floor(r2.random() * 256);
    }
    for (let i4 = 0; i4 < 512; i4++) {
      this.perm[i4] = this.p[i4 & 255];
    }
  }
};

// node_modules/three-stdlib/geometries/LightningStrike.js
var __defProp7 = Object.defineProperty;
var __defNormalProp7 = (obj, key, value) => key in obj ? __defProp7(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField8 = (obj, key, value) => {
  __defNormalProp7(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var LightningStrike = (() => {
  const _LightningStrike = class extends BufferGeometry {
    constructor(rayParameters = {}) {
      super();
      this.isLightningStrike = true;
      this.type = "LightningStrike";
      this.init(_LightningStrike.copyParameters(rayParameters, rayParameters));
      this.createMesh();
    }
    static createRandomGenerator() {
      const numSeeds = 2053;
      const seeds = [];
      for (let i4 = 0; i4 < numSeeds; i4++) {
        seeds.push(Math.random());
      }
      const generator = {
        currentSeed: 0,
        random: function() {
          const value = seeds[generator.currentSeed];
          generator.currentSeed = (generator.currentSeed + 1) % numSeeds;
          return value;
        },
        getSeed: function() {
          return generator.currentSeed / numSeeds;
        },
        setSeed: function(seed3) {
          generator.currentSeed = Math.floor(seed3 * numSeeds) % numSeeds;
        }
      };
      return generator;
    }
    static copyParameters(dest = {}, source = {}) {
      const vecCopy = function(v5) {
        if (source === dest) {
          return v5;
        } else {
          return v5.clone();
        }
      };
      dest.sourceOffset = source.sourceOffset !== void 0 ? vecCopy(source.sourceOffset) : new Vector3(0, 100, 0), dest.destOffset = source.destOffset !== void 0 ? vecCopy(source.destOffset) : new Vector3(0, 0, 0), dest.timeScale = source.timeScale !== void 0 ? source.timeScale : 1, dest.roughness = source.roughness !== void 0 ? source.roughness : 0.9, dest.straightness = source.straightness !== void 0 ? source.straightness : 0.7, dest.up0 = source.up0 !== void 0 ? vecCopy(source.up0) : new Vector3(0, 0, 1);
      dest.up1 = source.up1 !== void 0 ? vecCopy(source.up1) : new Vector3(0, 0, 1), dest.radius0 = source.radius0 !== void 0 ? source.radius0 : 1, dest.radius1 = source.radius1 !== void 0 ? source.radius1 : 1, dest.radius0Factor = source.radius0Factor !== void 0 ? source.radius0Factor : 0.5, dest.radius1Factor = source.radius1Factor !== void 0 ? source.radius1Factor : 0.2, dest.minRadius = source.minRadius !== void 0 ? source.minRadius : 0.2, // These parameters should not be changed after lightning creation. They can be changed but the ray will change its form abruptly:
      dest.isEternal = source.isEternal !== void 0 ? source.isEternal : source.birthTime === void 0 || source.deathTime === void 0, dest.birthTime = source.birthTime, dest.deathTime = source.deathTime, dest.propagationTimeFactor = source.propagationTimeFactor !== void 0 ? source.propagationTimeFactor : 0.1, dest.vanishingTimeFactor = source.vanishingTimeFactor !== void 0 ? source.vanishingTimeFactor : 0.9, dest.subrayPeriod = source.subrayPeriod !== void 0 ? source.subrayPeriod : 4, dest.subrayDutyCycle = source.subrayDutyCycle !== void 0 ? source.subrayDutyCycle : 0.6;
      dest.maxIterations = source.maxIterations !== void 0 ? source.maxIterations : 9;
      dest.isStatic = source.isStatic !== void 0 ? source.isStatic : false;
      dest.ramification = source.ramification !== void 0 ? source.ramification : 5;
      dest.maxSubrayRecursion = source.maxSubrayRecursion !== void 0 ? source.maxSubrayRecursion : 3;
      dest.recursionProbability = source.recursionProbability !== void 0 ? source.recursionProbability : 0.6;
      dest.generateUVs = source.generateUVs !== void 0 ? source.generateUVs : false;
      dest.randomGenerator = source.randomGenerator, dest.noiseSeed = source.noiseSeed, dest.onDecideSubrayCreation = source.onDecideSubrayCreation, dest.onSubrayCreation = source.onSubrayCreation;
      return dest;
    }
    update(time) {
      if (this.isStatic)
        return;
      if (this.rayParameters.isEternal || this.rayParameters.birthTime <= time && time <= this.rayParameters.deathTime) {
        this.updateMesh(time);
        if (time < this.subrays[0].endPropagationTime) {
          this.state = _LightningStrike.RAY_PROPAGATING;
        } else if (time > this.subrays[0].beginVanishingTime) {
          this.state = _LightningStrike.RAY_VANISHING;
        } else {
          this.state = _LightningStrike.RAY_STEADY;
        }
        this.visible = true;
      } else {
        this.visible = false;
        if (time < this.rayParameters.birthTime) {
          this.state = _LightningStrike.RAY_UNBORN;
        } else {
          this.state = _LightningStrike.RAY_EXTINGUISHED;
        }
      }
    }
    init(rayParameters) {
      this.rayParameters = rayParameters;
      this.maxIterations = rayParameters.maxIterations !== void 0 ? Math.floor(rayParameters.maxIterations) : 9;
      rayParameters.maxIterations = this.maxIterations;
      this.isStatic = rayParameters.isStatic !== void 0 ? rayParameters.isStatic : false;
      rayParameters.isStatic = this.isStatic;
      this.ramification = rayParameters.ramification !== void 0 ? Math.floor(rayParameters.ramification) : 5;
      rayParameters.ramification = this.ramification;
      this.maxSubrayRecursion = rayParameters.maxSubrayRecursion !== void 0 ? Math.floor(rayParameters.maxSubrayRecursion) : 3;
      rayParameters.maxSubrayRecursion = this.maxSubrayRecursion;
      this.recursionProbability = rayParameters.recursionProbability !== void 0 ? rayParameters.recursionProbability : 0.6;
      rayParameters.recursionProbability = this.recursionProbability;
      this.generateUVs = rayParameters.generateUVs !== void 0 ? rayParameters.generateUVs : false;
      rayParameters.generateUVs = this.generateUVs;
      if (rayParameters.randomGenerator !== void 0) {
        this.randomGenerator = rayParameters.randomGenerator;
        this.seedGenerator = rayParameters.randomGenerator;
        if (rayParameters.noiseSeed !== void 0) {
          this.seedGenerator.setSeed(rayParameters.noiseSeed);
        }
      } else {
        this.randomGenerator = _LightningStrike.createRandomGenerator();
        this.seedGenerator = Math;
      }
      if (rayParameters.onDecideSubrayCreation !== void 0) {
        this.onDecideSubrayCreation = rayParameters.onDecideSubrayCreation;
      } else {
        this.createDefaultSubrayCreationCallbacks();
        if (rayParameters.onSubrayCreation !== void 0) {
          this.onSubrayCreation = rayParameters.onSubrayCreation;
        }
      }
      this.state = _LightningStrike.RAY_INITIALIZED;
      this.maxSubrays = Math.ceil(1 + Math.pow(this.ramification, Math.max(0, this.maxSubrayRecursion - 1)));
      rayParameters.maxSubrays = this.maxSubrays;
      this.maxRaySegments = 2 * (1 << this.maxIterations);
      this.subrays = [];
      for (let i4 = 0; i4 < this.maxSubrays; i4++) {
        this.subrays.push(this.createSubray());
      }
      this.raySegments = [];
      for (let i4 = 0; i4 < this.maxRaySegments; i4++) {
        this.raySegments.push(this.createSegment());
      }
      this.time = 0;
      this.timeFraction = 0;
      this.currentSegmentCallback = null;
      this.currentCreateTriangleVertices = this.generateUVs ? this.createTriangleVerticesWithUVs : this.createTriangleVerticesWithoutUVs;
      this.numSubrays = 0;
      this.currentSubray = null;
      this.currentSegmentIndex = 0;
      this.isInitialSegment = false;
      this.subrayProbability = 0;
      this.currentVertex = 0;
      this.currentIndex = 0;
      this.currentCoordinate = 0;
      this.currentUVCoordinate = 0;
      this.vertices = null;
      this.uvs = null;
      this.indices = null;
      this.positionAttribute = null;
      this.uvsAttribute = null;
      this.simplexX = new SimplexNoise(this.seedGenerator);
      this.simplexY = new SimplexNoise(this.seedGenerator);
      this.simplexZ = new SimplexNoise(this.seedGenerator);
      this.forwards = new Vector3();
      this.forwardsFill = new Vector3();
      this.side = new Vector3();
      this.down = new Vector3();
      this.middlePos = new Vector3();
      this.middleLinPos = new Vector3();
      this.newPos = new Vector3();
      this.vPos = new Vector3();
      this.cross1 = new Vector3();
    }
    createMesh() {
      const maxDrawableSegmentsPerSubRay = 1 << this.maxIterations;
      const maxVerts = 3 * (maxDrawableSegmentsPerSubRay + 1) * this.maxSubrays;
      const maxIndices = 18 * maxDrawableSegmentsPerSubRay * this.maxSubrays;
      this.vertices = new Float32Array(maxVerts * 3);
      this.indices = new Uint32Array(maxIndices);
      if (this.generateUVs) {
        this.uvs = new Float32Array(maxVerts * 2);
      }
      this.fillMesh(0);
      this.setIndex(new Uint32BufferAttribute(this.indices, 1));
      this.positionAttribute = new Float32BufferAttribute(this.vertices, 3);
      this.setAttribute("position", this.positionAttribute);
      if (this.generateUVs) {
        this.uvsAttribute = new Float32BufferAttribute(new Float32Array(this.uvs), 2);
        this.setAttribute("uv", this.uvsAttribute);
      }
      if (!this.isStatic) {
        this.index.usage = DynamicDrawUsage;
        this.positionAttribute.usage = DynamicDrawUsage;
        if (this.generateUVs) {
          this.uvsAttribute.usage = DynamicDrawUsage;
        }
      }
      this.vertices = this.positionAttribute.array;
      this.indices = this.index.array;
      if (this.generateUVs) {
        this.uvs = this.uvsAttribute.array;
      }
    }
    updateMesh(time) {
      this.fillMesh(time);
      this.drawRange.count = this.currentIndex;
      this.index.needsUpdate = true;
      this.positionAttribute.needsUpdate = true;
      if (this.generateUVs) {
        this.uvsAttribute.needsUpdate = true;
      }
    }
    fillMesh(time) {
      const scope = this;
      this.currentVertex = 0;
      this.currentIndex = 0;
      this.currentCoordinate = 0;
      this.currentUVCoordinate = 0;
      this.fractalRay(time, function fillVertices(segment) {
        const subray = scope.currentSubray;
        if (time < subray.birthTime) {
          return;
        } else if (this.rayParameters.isEternal && scope.currentSubray.recursion == 0) {
          scope.createPrism(segment);
          scope.onDecideSubrayCreation(segment, scope);
        } else if (time < subray.endPropagationTime) {
          if (scope.timeFraction >= segment.fraction0 * subray.propagationTimeFactor) {
            scope.createPrism(segment);
            scope.onDecideSubrayCreation(segment, scope);
          }
        } else if (time < subray.beginVanishingTime) {
          scope.createPrism(segment);
          scope.onDecideSubrayCreation(segment, scope);
        } else {
          if (scope.timeFraction <= subray.vanishingTimeFactor + segment.fraction1 * (1 - subray.vanishingTimeFactor)) {
            scope.createPrism(segment);
          }
          scope.onDecideSubrayCreation(segment, scope);
        }
      });
    }
    addNewSubray() {
      return this.subrays[this.numSubrays++];
    }
    initSubray(subray, rayParameters) {
      subray.pos0.copy(rayParameters.sourceOffset);
      subray.pos1.copy(rayParameters.destOffset);
      subray.up0.copy(rayParameters.up0);
      subray.up1.copy(rayParameters.up1);
      subray.radius0 = rayParameters.radius0;
      subray.radius1 = rayParameters.radius1;
      subray.birthTime = rayParameters.birthTime;
      subray.deathTime = rayParameters.deathTime;
      subray.timeScale = rayParameters.timeScale;
      subray.roughness = rayParameters.roughness;
      subray.straightness = rayParameters.straightness;
      subray.propagationTimeFactor = rayParameters.propagationTimeFactor;
      subray.vanishingTimeFactor = rayParameters.vanishingTimeFactor;
      subray.maxIterations = this.maxIterations;
      subray.seed = rayParameters.noiseSeed !== void 0 ? rayParameters.noiseSeed : 0;
      subray.recursion = 0;
    }
    fractalRay(time, segmentCallback) {
      this.time = time;
      this.currentSegmentCallback = segmentCallback;
      this.numSubrays = 0;
      this.initSubray(this.addNewSubray(), this.rayParameters);
      for (let subrayIndex = 0; subrayIndex < this.numSubrays; subrayIndex++) {
        const subray = this.subrays[subrayIndex];
        this.currentSubray = subray;
        this.randomGenerator.setSeed(subray.seed);
        subray.endPropagationTime = MathUtils.lerp(subray.birthTime, subray.deathTime, subray.propagationTimeFactor);
        subray.beginVanishingTime = MathUtils.lerp(subray.deathTime, subray.birthTime, 1 - subray.vanishingTimeFactor);
        const random1 = this.randomGenerator.random;
        subray.linPos0.set(random1(), random1(), random1()).multiplyScalar(1e3);
        subray.linPos1.set(random1(), random1(), random1()).multiplyScalar(1e3);
        this.timeFraction = (time - subray.birthTime) / (subray.deathTime - subray.birthTime);
        this.currentSegmentIndex = 0;
        this.isInitialSegment = true;
        const segment = this.getNewSegment();
        segment.iteration = 0;
        segment.pos0.copy(subray.pos0);
        segment.pos1.copy(subray.pos1);
        segment.linPos0.copy(subray.linPos0);
        segment.linPos1.copy(subray.linPos1);
        segment.up0.copy(subray.up0);
        segment.up1.copy(subray.up1);
        segment.radius0 = subray.radius0;
        segment.radius1 = subray.radius1;
        segment.fraction0 = 0;
        segment.fraction1 = 1;
        segment.positionVariationFactor = 1 - subray.straightness;
        this.subrayProbability = this.ramification * Math.pow(this.recursionProbability, subray.recursion) / (1 << subray.maxIterations);
        this.fractalRayRecursive(segment);
      }
      this.currentSegmentCallback = null;
      this.currentSubray = null;
    }
    fractalRayRecursive(segment) {
      if (segment.iteration >= this.currentSubray.maxIterations) {
        this.currentSegmentCallback(segment);
        return;
      }
      this.forwards.subVectors(segment.pos1, segment.pos0);
      let lForwards = this.forwards.length();
      if (lForwards < 1e-6) {
        this.forwards.set(0, 0, 0.01);
        lForwards = this.forwards.length();
      }
      const middleRadius = (segment.radius0 + segment.radius1) * 0.5;
      const middleFraction = (segment.fraction0 + segment.fraction1) * 0.5;
      const timeDimension = this.time * this.currentSubray.timeScale * Math.pow(2, segment.iteration);
      this.middlePos.lerpVectors(segment.pos0, segment.pos1, 0.5);
      this.middleLinPos.lerpVectors(segment.linPos0, segment.linPos1, 0.5);
      const p2 = this.middleLinPos;
      this.newPos.set(
        this.simplexX.noise4d(p2.x, p2.y, p2.z, timeDimension),
        this.simplexY.noise4d(p2.x, p2.y, p2.z, timeDimension),
        this.simplexZ.noise4d(p2.x, p2.y, p2.z, timeDimension)
      );
      this.newPos.multiplyScalar(segment.positionVariationFactor * lForwards);
      this.newPos.add(this.middlePos);
      const newSegment1 = this.getNewSegment();
      newSegment1.pos0.copy(segment.pos0);
      newSegment1.pos1.copy(this.newPos);
      newSegment1.linPos0.copy(segment.linPos0);
      newSegment1.linPos1.copy(this.middleLinPos);
      newSegment1.up0.copy(segment.up0);
      newSegment1.up1.copy(segment.up1);
      newSegment1.radius0 = segment.radius0;
      newSegment1.radius1 = middleRadius;
      newSegment1.fraction0 = segment.fraction0;
      newSegment1.fraction1 = middleFraction;
      newSegment1.positionVariationFactor = segment.positionVariationFactor * this.currentSubray.roughness;
      newSegment1.iteration = segment.iteration + 1;
      const newSegment2 = this.getNewSegment();
      newSegment2.pos0.copy(this.newPos);
      newSegment2.pos1.copy(segment.pos1);
      newSegment2.linPos0.copy(this.middleLinPos);
      newSegment2.linPos1.copy(segment.linPos1);
      this.cross1.crossVectors(segment.up0, this.forwards.normalize());
      newSegment2.up0.crossVectors(this.forwards, this.cross1).normalize();
      newSegment2.up1.copy(segment.up1);
      newSegment2.radius0 = middleRadius;
      newSegment2.radius1 = segment.radius1;
      newSegment2.fraction0 = middleFraction;
      newSegment2.fraction1 = segment.fraction1;
      newSegment2.positionVariationFactor = segment.positionVariationFactor * this.currentSubray.roughness;
      newSegment2.iteration = segment.iteration + 1;
      this.fractalRayRecursive(newSegment1);
      this.fractalRayRecursive(newSegment2);
    }
    createPrism(segment) {
      this.forwardsFill.subVectors(segment.pos1, segment.pos0).normalize();
      if (this.isInitialSegment) {
        this.currentCreateTriangleVertices(segment.pos0, segment.up0, this.forwardsFill, segment.radius0, 0);
        this.isInitialSegment = false;
      }
      this.currentCreateTriangleVertices(
        segment.pos1,
        segment.up0,
        this.forwardsFill,
        segment.radius1,
        segment.fraction1
      );
      this.createPrismFaces();
    }
    createTriangleVerticesWithoutUVs(pos, up, forwards, radius) {
      this.side.crossVectors(up, forwards).multiplyScalar(radius * _LightningStrike.COS30DEG);
      this.down.copy(up).multiplyScalar(-radius * _LightningStrike.SIN30DEG);
      const p2 = this.vPos;
      const v5 = this.vertices;
      p2.copy(pos).sub(this.side).add(this.down);
      v5[this.currentCoordinate++] = p2.x;
      v5[this.currentCoordinate++] = p2.y;
      v5[this.currentCoordinate++] = p2.z;
      p2.copy(pos).add(this.side).add(this.down);
      v5[this.currentCoordinate++] = p2.x;
      v5[this.currentCoordinate++] = p2.y;
      v5[this.currentCoordinate++] = p2.z;
      p2.copy(up).multiplyScalar(radius).add(pos);
      v5[this.currentCoordinate++] = p2.x;
      v5[this.currentCoordinate++] = p2.y;
      v5[this.currentCoordinate++] = p2.z;
      this.currentVertex += 3;
    }
    createTriangleVerticesWithUVs(pos, up, forwards, radius, u) {
      this.side.crossVectors(up, forwards).multiplyScalar(radius * _LightningStrike.COS30DEG);
      this.down.copy(up).multiplyScalar(-radius * _LightningStrike.SIN30DEG);
      const p2 = this.vPos;
      const v5 = this.vertices;
      const uv = this.uvs;
      p2.copy(pos).sub(this.side).add(this.down);
      v5[this.currentCoordinate++] = p2.x;
      v5[this.currentCoordinate++] = p2.y;
      v5[this.currentCoordinate++] = p2.z;
      uv[this.currentUVCoordinate++] = u;
      uv[this.currentUVCoordinate++] = 0;
      p2.copy(pos).add(this.side).add(this.down);
      v5[this.currentCoordinate++] = p2.x;
      v5[this.currentCoordinate++] = p2.y;
      v5[this.currentCoordinate++] = p2.z;
      uv[this.currentUVCoordinate++] = u;
      uv[this.currentUVCoordinate++] = 0.5;
      p2.copy(up).multiplyScalar(radius).add(pos);
      v5[this.currentCoordinate++] = p2.x;
      v5[this.currentCoordinate++] = p2.y;
      v5[this.currentCoordinate++] = p2.z;
      uv[this.currentUVCoordinate++] = u;
      uv[this.currentUVCoordinate++] = 1;
      this.currentVertex += 3;
    }
    createPrismFaces(vertex) {
      const indices = this.indices;
      vertex = this.currentVertex - 6;
      indices[this.currentIndex++] = vertex + 1;
      indices[this.currentIndex++] = vertex + 2;
      indices[this.currentIndex++] = vertex + 5;
      indices[this.currentIndex++] = vertex + 1;
      indices[this.currentIndex++] = vertex + 5;
      indices[this.currentIndex++] = vertex + 4;
      indices[this.currentIndex++] = vertex + 0;
      indices[this.currentIndex++] = vertex + 1;
      indices[this.currentIndex++] = vertex + 4;
      indices[this.currentIndex++] = vertex + 0;
      indices[this.currentIndex++] = vertex + 4;
      indices[this.currentIndex++] = vertex + 3;
      indices[this.currentIndex++] = vertex + 2;
      indices[this.currentIndex++] = vertex + 0;
      indices[this.currentIndex++] = vertex + 3;
      indices[this.currentIndex++] = vertex + 2;
      indices[this.currentIndex++] = vertex + 3;
      indices[this.currentIndex++] = vertex + 5;
    }
    createDefaultSubrayCreationCallbacks() {
      const random1 = this.randomGenerator.random;
      this.onDecideSubrayCreation = function(segment, lightningStrike) {
        const subray = lightningStrike.currentSubray;
        const period = lightningStrike.rayParameters.subrayPeriod;
        const dutyCycle = lightningStrike.rayParameters.subrayDutyCycle;
        const phase0 = lightningStrike.rayParameters.isEternal && subray.recursion == 0 ? -random1() * period : MathUtils.lerp(subray.birthTime, subray.endPropagationTime, segment.fraction0) - random1() * period;
        const phase = lightningStrike.time - phase0;
        const currentCycle = Math.floor(phase / period);
        const childSubraySeed = random1() * (currentCycle + 1);
        const isActive = phase % period <= dutyCycle * period;
        let probability = 0;
        if (isActive) {
          probability = lightningStrike.subrayProbability;
        }
        if (subray.recursion < lightningStrike.maxSubrayRecursion && lightningStrike.numSubrays < lightningStrike.maxSubrays && random1() < probability) {
          const childSubray = lightningStrike.addNewSubray();
          const parentSeed = lightningStrike.randomGenerator.getSeed();
          childSubray.seed = childSubraySeed;
          lightningStrike.randomGenerator.setSeed(childSubraySeed);
          childSubray.recursion = subray.recursion + 1;
          childSubray.maxIterations = Math.max(1, subray.maxIterations - 1);
          childSubray.linPos0.set(random1(), random1(), random1()).multiplyScalar(1e3);
          childSubray.linPos1.set(random1(), random1(), random1()).multiplyScalar(1e3);
          childSubray.up0.copy(subray.up0);
          childSubray.up1.copy(subray.up1);
          childSubray.radius0 = segment.radius0 * lightningStrike.rayParameters.radius0Factor;
          childSubray.radius1 = Math.min(
            lightningStrike.rayParameters.minRadius,
            segment.radius1 * lightningStrike.rayParameters.radius1Factor
          );
          childSubray.birthTime = phase0 + currentCycle * period;
          childSubray.deathTime = childSubray.birthTime + period * dutyCycle;
          if (!lightningStrike.rayParameters.isEternal && subray.recursion == 0) {
            childSubray.birthTime = Math.max(childSubray.birthTime, subray.birthTime);
            childSubray.deathTime = Math.min(childSubray.deathTime, subray.deathTime);
          }
          childSubray.timeScale = subray.timeScale * 2;
          childSubray.roughness = subray.roughness;
          childSubray.straightness = subray.straightness;
          childSubray.propagationTimeFactor = subray.propagationTimeFactor;
          childSubray.vanishingTimeFactor = subray.vanishingTimeFactor;
          lightningStrike.onSubrayCreation(segment, subray, childSubray, lightningStrike);
          lightningStrike.randomGenerator.setSeed(parentSeed);
        }
      };
      const vec1Pos = new Vector3();
      const vec2Forward = new Vector3();
      const vec3Side = new Vector3();
      const vec4Up = new Vector3();
      this.onSubrayCreation = function(segment, parentSubray, childSubray, lightningStrike) {
        lightningStrike.subrayCylinderPosition(segment, parentSubray, childSubray, 0.5, 0.6, 0.2);
      };
      this.subrayConePosition = function(segment, parentSubray, childSubray, heightFactor, sideWidthFactor, minSideWidthFactor) {
        childSubray.pos0.copy(segment.pos0);
        vec1Pos.subVectors(parentSubray.pos1, parentSubray.pos0);
        vec2Forward.copy(vec1Pos).normalize();
        vec1Pos.multiplyScalar(segment.fraction0 + (1 - segment.fraction0) * (random1() * heightFactor));
        const length3 = vec1Pos.length();
        vec3Side.crossVectors(parentSubray.up0, vec2Forward);
        const angle = 2 * Math.PI * random1();
        vec3Side.multiplyScalar(Math.cos(angle));
        vec4Up.copy(parentSubray.up0).multiplyScalar(Math.sin(angle));
        childSubray.pos1.copy(vec3Side).add(vec4Up).multiplyScalar(length3 * sideWidthFactor * (minSideWidthFactor + random1() * (1 - minSideWidthFactor))).add(vec1Pos).add(parentSubray.pos0);
      };
      this.subrayCylinderPosition = function(segment, parentSubray, childSubray, heightFactor, sideWidthFactor, minSideWidthFactor) {
        childSubray.pos0.copy(segment.pos0);
        vec1Pos.subVectors(parentSubray.pos1, parentSubray.pos0);
        vec2Forward.copy(vec1Pos).normalize();
        vec1Pos.multiplyScalar(segment.fraction0 + (1 - segment.fraction0) * ((2 * random1() - 1) * heightFactor));
        const length3 = vec1Pos.length();
        vec3Side.crossVectors(parentSubray.up0, vec2Forward);
        const angle = 2 * Math.PI * random1();
        vec3Side.multiplyScalar(Math.cos(angle));
        vec4Up.copy(parentSubray.up0).multiplyScalar(Math.sin(angle));
        childSubray.pos1.copy(vec3Side).add(vec4Up).multiplyScalar(length3 * sideWidthFactor * (minSideWidthFactor + random1() * (1 - minSideWidthFactor))).add(vec1Pos).add(parentSubray.pos0);
      };
    }
    createSubray() {
      return {
        seed: 0,
        maxIterations: 0,
        recursion: 0,
        pos0: new Vector3(),
        pos1: new Vector3(),
        linPos0: new Vector3(),
        linPos1: new Vector3(),
        up0: new Vector3(),
        up1: new Vector3(),
        radius0: 0,
        radius1: 0,
        birthTime: 0,
        deathTime: 0,
        timeScale: 0,
        roughness: 0,
        straightness: 0,
        propagationTimeFactor: 0,
        vanishingTimeFactor: 0,
        endPropagationTime: 0,
        beginVanishingTime: 0
      };
    }
    createSegment() {
      return {
        iteration: 0,
        pos0: new Vector3(),
        pos1: new Vector3(),
        linPos0: new Vector3(),
        linPos1: new Vector3(),
        up0: new Vector3(),
        up1: new Vector3(),
        radius0: 0,
        radius1: 0,
        fraction0: 0,
        fraction1: 0,
        positionVariationFactor: 0
      };
    }
    getNewSegment() {
      return this.raySegments[this.currentSegmentIndex++];
    }
    copy(source) {
      super.copy(source);
      this.init(_LightningStrike.copyParameters({}, source.rayParameters));
      return this;
    }
    clone() {
      return new this.constructor(_LightningStrike.copyParameters({}, this.rayParameters));
    }
  };
  let LightningStrike2 = _LightningStrike;
  __publicField8(LightningStrike2, "RAY_INITIALIZED", 0);
  __publicField8(LightningStrike2, "RAY_UNBORN", 1);
  __publicField8(LightningStrike2, "RAY_PROPAGATING", 2);
  __publicField8(LightningStrike2, "RAY_STEADY", 3);
  __publicField8(LightningStrike2, "RAY_VANISHING", 4);
  __publicField8(LightningStrike2, "RAY_EXTINGUISHED", 5);
  __publicField8(LightningStrike2, "COS30DEG", Math.cos(30 * Math.PI / 180));
  __publicField8(LightningStrike2, "SIN30DEG", Math.sin(30 * Math.PI / 180));
  return LightningStrike2;
})();

// node_modules/three-stdlib/objects/ReflectorForSSRPass.js
var __defProp8 = Object.defineProperty;
var __defNormalProp8 = (obj, key, value) => key in obj ? __defProp8(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField9 = (obj, key, value) => {
  __defNormalProp8(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var ReflectorForSSRPass = (() => {
  const _ReflectorForSSRPass = class extends Mesh {
    constructor(geometry3, options = {}) {
      super(geometry3);
      this.isReflectorForSSRPass = true;
      this.type = "ReflectorForSSRPass";
      const scope = this;
      const color = options.color !== void 0 ? new Color(options.color) : new Color(8355711);
      const textureWidth = options.textureWidth || 512;
      const textureHeight = options.textureHeight || 512;
      const clipBias = options.clipBias || 0;
      const shader = options.shader || _ReflectorForSSRPass.ReflectorShader;
      const useDepthTexture = options.useDepthTexture === true;
      const yAxis2 = new Vector3(0, 1, 0);
      const vecTemp0 = new Vector3();
      const vecTemp1 = new Vector3();
      scope.needsUpdate = false;
      scope.maxDistance = _ReflectorForSSRPass.ReflectorShader.uniforms.maxDistance.value;
      scope.opacity = _ReflectorForSSRPass.ReflectorShader.uniforms.opacity.value;
      scope.color = color;
      scope.resolution = options.resolution || new Vector2(window.innerWidth, window.innerHeight);
      scope._distanceAttenuation = _ReflectorForSSRPass.ReflectorShader.defines.DISTANCE_ATTENUATION;
      Object.defineProperty(scope, "distanceAttenuation", {
        get() {
          return scope._distanceAttenuation;
        },
        set(val) {
          if (scope._distanceAttenuation === val)
            return;
          scope._distanceAttenuation = val;
          scope.material.defines.DISTANCE_ATTENUATION = val;
          scope.material.needsUpdate = true;
        }
      });
      scope._fresnel = _ReflectorForSSRPass.ReflectorShader.defines.FRESNEL;
      Object.defineProperty(scope, "fresnel", {
        get() {
          return scope._fresnel;
        },
        set(val) {
          if (scope._fresnel === val)
            return;
          scope._fresnel = val;
          scope.material.defines.FRESNEL = val;
          scope.material.needsUpdate = true;
        }
      });
      const normal2 = new Vector3();
      const reflectorWorldPosition = new Vector3();
      const cameraWorldPosition = new Vector3();
      const rotationMatrix2 = new Matrix4();
      const lookAtPosition = new Vector3(0, 0, -1);
      const view = new Vector3();
      const target2 = new Vector3();
      const textureMatrix = new Matrix4();
      const virtualCamera = new PerspectiveCamera();
      let depthTexture;
      if (useDepthTexture) {
        depthTexture = new DepthTexture();
        depthTexture.type = UnsignedShortType;
        depthTexture.minFilter = NearestFilter;
        depthTexture.magFilter = NearestFilter;
      }
      const parameters = {
        depthTexture: useDepthTexture ? depthTexture : null,
        type: HalfFloatType
      };
      const renderTarget = new WebGLRenderTarget(textureWidth, textureHeight, parameters);
      const material = new ShaderMaterial({
        transparent: useDepthTexture,
        defines: Object.assign({}, _ReflectorForSSRPass.ReflectorShader.defines, {
          useDepthTexture
        }),
        uniforms: UniformsUtils.clone(shader.uniforms),
        fragmentShader: shader.fragmentShader,
        vertexShader: shader.vertexShader
      });
      material.uniforms["tDiffuse"].value = renderTarget.texture;
      material.uniforms["color"].value = scope.color;
      material.uniforms["textureMatrix"].value = textureMatrix;
      if (useDepthTexture) {
        material.uniforms["tDepth"].value = renderTarget.depthTexture;
      }
      this.material = material;
      const globalPlane = new Plane(new Vector3(0, 1, 0), clipBias);
      const globalPlanes = [globalPlane];
      this.doRender = function(renderer, scene, camera) {
        material.uniforms["maxDistance"].value = scope.maxDistance;
        material.uniforms["color"].value = scope.color;
        material.uniforms["opacity"].value = scope.opacity;
        vecTemp0.copy(camera.position).normalize();
        vecTemp1.copy(vecTemp0).reflect(yAxis2);
        material.uniforms["fresnelCoe"].value = (vecTemp0.dot(vecTemp1) + 1) / 2;
        reflectorWorldPosition.setFromMatrixPosition(scope.matrixWorld);
        cameraWorldPosition.setFromMatrixPosition(camera.matrixWorld);
        rotationMatrix2.extractRotation(scope.matrixWorld);
        normal2.set(0, 0, 1);
        normal2.applyMatrix4(rotationMatrix2);
        view.subVectors(reflectorWorldPosition, cameraWorldPosition);
        if (view.dot(normal2) > 0)
          return;
        view.reflect(normal2).negate();
        view.add(reflectorWorldPosition);
        rotationMatrix2.extractRotation(camera.matrixWorld);
        lookAtPosition.set(0, 0, -1);
        lookAtPosition.applyMatrix4(rotationMatrix2);
        lookAtPosition.add(cameraWorldPosition);
        target2.subVectors(reflectorWorldPosition, lookAtPosition);
        target2.reflect(normal2).negate();
        target2.add(reflectorWorldPosition);
        virtualCamera.position.copy(view);
        virtualCamera.up.set(0, 1, 0);
        virtualCamera.up.applyMatrix4(rotationMatrix2);
        virtualCamera.up.reflect(normal2);
        virtualCamera.lookAt(target2);
        virtualCamera.far = camera.far;
        virtualCamera.updateMatrixWorld();
        virtualCamera.projectionMatrix.copy(camera.projectionMatrix);
        material.uniforms["virtualCameraNear"].value = camera.near;
        material.uniforms["virtualCameraFar"].value = camera.far;
        material.uniforms["virtualCameraMatrixWorld"].value = virtualCamera.matrixWorld;
        material.uniforms["virtualCameraProjectionMatrix"].value = camera.projectionMatrix;
        material.uniforms["virtualCameraProjectionMatrixInverse"].value = camera.projectionMatrixInverse;
        material.uniforms["resolution"].value = scope.resolution;
        textureMatrix.set(0.5, 0, 0, 0.5, 0, 0.5, 0, 0.5, 0, 0, 0.5, 0.5, 0, 0, 0, 1);
        textureMatrix.multiply(virtualCamera.projectionMatrix);
        textureMatrix.multiply(virtualCamera.matrixWorldInverse);
        textureMatrix.multiply(scope.matrixWorld);
        const currentRenderTarget = renderer.getRenderTarget();
        const currentXrEnabled = renderer.xr.enabled;
        const currentShadowAutoUpdate = renderer.shadowMap.autoUpdate;
        const currentClippingPlanes = renderer.clippingPlanes;
        renderer.xr.enabled = false;
        renderer.shadowMap.autoUpdate = false;
        renderer.clippingPlanes = globalPlanes;
        renderer.setRenderTarget(renderTarget);
        renderer.state.buffers.depth.setMask(true);
        if (renderer.autoClear === false)
          renderer.clear();
        renderer.render(scene, virtualCamera);
        renderer.xr.enabled = currentXrEnabled;
        renderer.shadowMap.autoUpdate = currentShadowAutoUpdate;
        renderer.clippingPlanes = currentClippingPlanes;
        renderer.setRenderTarget(currentRenderTarget);
        const viewport = camera.viewport;
        if (viewport !== void 0) {
          renderer.state.viewport(viewport);
        }
      };
      this.getRenderTarget = function() {
        return renderTarget;
      };
    }
  };
  let ReflectorForSSRPass2 = _ReflectorForSSRPass;
  __publicField9(ReflectorForSSRPass2, "ReflectorShader", {
    defines: {
      DISTANCE_ATTENUATION: true,
      FRESNEL: true
    },
    uniforms: {
      color: { value: null },
      tDiffuse: { value: null },
      tDepth: { value: null },
      textureMatrix: { value: new Matrix4() },
      maxDistance: { value: 180 },
      opacity: { value: 0.5 },
      fresnelCoe: { value: null },
      virtualCameraNear: { value: null },
      virtualCameraFar: { value: null },
      virtualCameraProjectionMatrix: { value: new Matrix4() },
      virtualCameraMatrixWorld: { value: new Matrix4() },
      virtualCameraProjectionMatrixInverse: { value: new Matrix4() },
      resolution: { value: new Vector2() }
    },
    vertexShader: (
      /* glsl */
      `
		uniform mat4 textureMatrix;
		varying vec4 vUv;

		void main() {

			vUv = textureMatrix * vec4( position, 1.0 );

			gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

		}`
    ),
    fragmentShader: (
      /* glsl */
      `
		uniform vec3 color;
		uniform sampler2D tDiffuse;
		uniform sampler2D tDepth;
		uniform float maxDistance;
		uniform float opacity;
		uniform float fresnelCoe;
		uniform float virtualCameraNear;
		uniform float virtualCameraFar;
		uniform mat4 virtualCameraProjectionMatrix;
		uniform mat4 virtualCameraProjectionMatrixInverse;
		uniform mat4 virtualCameraMatrixWorld;
		uniform vec2 resolution;
		varying vec4 vUv;
		#include <packing>
		float blendOverlay( float base, float blend ) {
			return( base < 0.5 ? ( 2.0 * base * blend ) : ( 1.0 - 2.0 * ( 1.0 - base ) * ( 1.0 - blend ) ) );
		}
		vec3 blendOverlay( vec3 base, vec3 blend ) {
			return vec3( blendOverlay( base.r, blend.r ), blendOverlay( base.g, blend.g ), blendOverlay( base.b, blend.b ) );
		}
		float getDepth( const in vec2 uv ) {
			return texture2D( tDepth, uv ).x;
		}
		float getViewZ( const in float depth ) {
			return perspectiveDepthToViewZ( depth, virtualCameraNear, virtualCameraFar );
		}
		vec3 getViewPosition( const in vec2 uv, const in float depth/*clip space*/, const in float clipW ) {
			vec4 clipPosition = vec4( ( vec3( uv, depth ) - 0.5 ) * 2.0, 1.0 );//ndc
			clipPosition *= clipW; //clip
			return ( virtualCameraProjectionMatrixInverse * clipPosition ).xyz;//view
		}
		void main() {
			vec4 base = texture2DProj( tDiffuse, vUv );
			#ifdef useDepthTexture
				vec2 uv=(gl_FragCoord.xy-.5)/resolution.xy;
				uv.x=1.-uv.x;
				float depth = texture2DProj( tDepth, vUv ).r;
				float viewZ = getViewZ( depth );
				float clipW = virtualCameraProjectionMatrix[2][3] * viewZ+virtualCameraProjectionMatrix[3][3];
				vec3 viewPosition=getViewPosition( uv, depth, clipW );
				vec3 worldPosition=(virtualCameraMatrixWorld*vec4(viewPosition,1)).xyz;
				if(worldPosition.y>maxDistance) discard;
				float op=opacity;
				#ifdef DISTANCE_ATTENUATION
					float ratio=1.-(worldPosition.y/maxDistance);
					float attenuation=ratio*ratio;
					op=opacity*attenuation;
				#endif
				#ifdef FRESNEL
					op*=fresnelCoe;
				#endif
				gl_FragColor = vec4( blendOverlay( base.rgb, color ), op );
			#else
				gl_FragColor = vec4( blendOverlay( base.rgb, color ), 1.0 );
			#endif
		}
	`
    )
  });
  return ReflectorForSSRPass2;
})();

// node_modules/three-stdlib/objects/Sky.js
var __defProp9 = Object.defineProperty;
var __defNormalProp9 = (obj, key, value) => key in obj ? __defProp9(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField10 = (obj, key, value) => {
  __defNormalProp9(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var Sky = (() => {
  const SkyShader = {
    uniforms: {
      turbidity: { value: 2 },
      rayleigh: { value: 1 },
      mieCoefficient: { value: 5e-3 },
      mieDirectionalG: { value: 0.8 },
      sunPosition: { value: new Vector3() },
      up: { value: new Vector3(0, 1, 0) }
    },
    vertexShader: (
      /* glsl */
      `
      uniform vec3 sunPosition;
      uniform float rayleigh;
      uniform float turbidity;
      uniform float mieCoefficient;
      uniform vec3 up;

      varying vec3 vWorldPosition;
      varying vec3 vSunDirection;
      varying float vSunfade;
      varying vec3 vBetaR;
      varying vec3 vBetaM;
      varying float vSunE;

      // constants for atmospheric scattering
      const float e = 2.71828182845904523536028747135266249775724709369995957;
      const float pi = 3.141592653589793238462643383279502884197169;

      // wavelength of used primaries, according to preetham
      const vec3 lambda = vec3( 680E-9, 550E-9, 450E-9 );
      // this pre-calcuation replaces older TotalRayleigh(vec3 lambda) function:
      // (8.0 * pow(pi, 3.0) * pow(pow(n, 2.0) - 1.0, 2.0) * (6.0 + 3.0 * pn)) / (3.0 * N * pow(lambda, vec3(4.0)) * (6.0 - 7.0 * pn))
      const vec3 totalRayleigh = vec3( 5.804542996261093E-6, 1.3562911419845635E-5, 3.0265902468824876E-5 );

      // mie stuff
      // K coefficient for the primaries
      const float v = 4.0;
      const vec3 K = vec3( 0.686, 0.678, 0.666 );
      // MieConst = pi * pow( ( 2.0 * pi ) / lambda, vec3( v - 2.0 ) ) * K
      const vec3 MieConst = vec3( 1.8399918514433978E14, 2.7798023919660528E14, 4.0790479543861094E14 );

      // earth shadow hack
      // cutoffAngle = pi / 1.95;
      const float cutoffAngle = 1.6110731556870734;
      const float steepness = 1.5;
      const float EE = 1000.0;

      float sunIntensity( float zenithAngleCos ) {
        zenithAngleCos = clamp( zenithAngleCos, -1.0, 1.0 );
        return EE * max( 0.0, 1.0 - pow( e, -( ( cutoffAngle - acos( zenithAngleCos ) ) / steepness ) ) );
      }

      vec3 totalMie( float T ) {
        float c = ( 0.2 * T ) * 10E-18;
        return 0.434 * c * MieConst;
      }

      void main() {

        vec4 worldPosition = modelMatrix * vec4( position, 1.0 );
        vWorldPosition = worldPosition.xyz;

        gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );
        gl_Position.z = gl_Position.w; // set z to camera.far

        vSunDirection = normalize( sunPosition );

        vSunE = sunIntensity( dot( vSunDirection, up ) );

        vSunfade = 1.0 - clamp( 1.0 - exp( ( sunPosition.y / 450000.0 ) ), 0.0, 1.0 );

        float rayleighCoefficient = rayleigh - ( 1.0 * ( 1.0 - vSunfade ) );

      // extinction (absorbtion + out scattering)
      // rayleigh coefficients
        vBetaR = totalRayleigh * rayleighCoefficient;

      // mie coefficients
        vBetaM = totalMie( turbidity ) * mieCoefficient;

      }
    `
    ),
    fragmentShader: (
      /* glsl */
      `
      varying vec3 vWorldPosition;
      varying vec3 vSunDirection;
      varying float vSunfade;
      varying vec3 vBetaR;
      varying vec3 vBetaM;
      varying float vSunE;

      uniform float mieDirectionalG;
      uniform vec3 up;

      const vec3 cameraPos = vec3( 0.0, 0.0, 0.0 );

      // constants for atmospheric scattering
      const float pi = 3.141592653589793238462643383279502884197169;

      const float n = 1.0003; // refractive index of air
      const float N = 2.545E25; // number of molecules per unit volume for air at 288.15K and 1013mb (sea level -45 celsius)

      // optical length at zenith for molecules
      const float rayleighZenithLength = 8.4E3;
      const float mieZenithLength = 1.25E3;
      // 66 arc seconds -> degrees, and the cosine of that
      const float sunAngularDiameterCos = 0.999956676946448443553574619906976478926848692873900859324;

      // 3.0 / ( 16.0 * pi )
      const float THREE_OVER_SIXTEENPI = 0.05968310365946075;
      // 1.0 / ( 4.0 * pi )
      const float ONE_OVER_FOURPI = 0.07957747154594767;

      float rayleighPhase( float cosTheta ) {
        return THREE_OVER_SIXTEENPI * ( 1.0 + pow( cosTheta, 2.0 ) );
      }

      float hgPhase( float cosTheta, float g ) {
        float g2 = pow( g, 2.0 );
        float inverse = 1.0 / pow( 1.0 - 2.0 * g * cosTheta + g2, 1.5 );
        return ONE_OVER_FOURPI * ( ( 1.0 - g2 ) * inverse );
      }

      void main() {

        vec3 direction = normalize( vWorldPosition - cameraPos );

      // optical length
      // cutoff angle at 90 to avoid singularity in next formula.
        float zenithAngle = acos( max( 0.0, dot( up, direction ) ) );
        float inverse = 1.0 / ( cos( zenithAngle ) + 0.15 * pow( 93.885 - ( ( zenithAngle * 180.0 ) / pi ), -1.253 ) );
        float sR = rayleighZenithLength * inverse;
        float sM = mieZenithLength * inverse;

      // combined extinction factor
        vec3 Fex = exp( -( vBetaR * sR + vBetaM * sM ) );

      // in scattering
        float cosTheta = dot( direction, vSunDirection );

        float rPhase = rayleighPhase( cosTheta * 0.5 + 0.5 );
        vec3 betaRTheta = vBetaR * rPhase;

        float mPhase = hgPhase( cosTheta, mieDirectionalG );
        vec3 betaMTheta = vBetaM * mPhase;

        vec3 Lin = pow( vSunE * ( ( betaRTheta + betaMTheta ) / ( vBetaR + vBetaM ) ) * ( 1.0 - Fex ), vec3( 1.5 ) );
        Lin *= mix( vec3( 1.0 ), pow( vSunE * ( ( betaRTheta + betaMTheta ) / ( vBetaR + vBetaM ) ) * Fex, vec3( 1.0 / 2.0 ) ), clamp( pow( 1.0 - dot( up, vSunDirection ), 5.0 ), 0.0, 1.0 ) );

      // nightsky
        float theta = acos( direction.y ); // elevation --> y-axis, [-pi/2, pi/2]
        float phi = atan( direction.z, direction.x ); // azimuth --> x-axis [-pi/2, pi/2]
        vec2 uv = vec2( phi, theta ) / vec2( 2.0 * pi, pi ) + vec2( 0.5, 0.0 );
        vec3 L0 = vec3( 0.1 ) * Fex;

      // composition + solar disc
        float sundisk = smoothstep( sunAngularDiameterCos, sunAngularDiameterCos + 0.00002, cosTheta );
        L0 += ( vSunE * 19000.0 * Fex ) * sundisk;

        vec3 texColor = ( Lin + L0 ) * 0.04 + vec3( 0.0, 0.0003, 0.00075 );

        vec3 retColor = pow( texColor, vec3( 1.0 / ( 1.2 + ( 1.2 * vSunfade ) ) ) );

        gl_FragColor = vec4( retColor, 1.0 );

      #include <tonemapping_fragment>
      #include <${version >= 154 ? "colorspace_fragment" : "encodings_fragment"}>

      }
    `
    )
  };
  const material = new ShaderMaterial({
    name: "SkyShader",
    fragmentShader: SkyShader.fragmentShader,
    vertexShader: SkyShader.vertexShader,
    uniforms: UniformsUtils.clone(SkyShader.uniforms),
    side: BackSide,
    depthWrite: false
  });
  class Sky22 extends Mesh {
    constructor() {
      super(new BoxGeometry(1, 1, 1), material);
    }
  }
  __publicField10(Sky22, "SkyShader", SkyShader);
  __publicField10(Sky22, "material", material);
  return Sky22;
})();

// node_modules/three-stdlib/objects/Water2.js
var __defProp10 = Object.defineProperty;
var __defNormalProp10 = (obj, key, value) => key in obj ? __defProp10(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField11 = (obj, key, value) => {
  __defNormalProp10(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var Water2 = (() => {
  const _Water2 = class extends Mesh {
    constructor(geometry3, options = {}) {
      super(geometry3);
      this.isWater = true;
      this.type = "Water";
      const scope = this;
      const color = options.color !== void 0 ? new Color(options.color) : new Color(16777215);
      const textureWidth = options.textureWidth || 512;
      const textureHeight = options.textureHeight || 512;
      const clipBias = options.clipBias || 0;
      const flowDirection = options.flowDirection || new Vector2(1, 0);
      const flowSpeed = options.flowSpeed || 0.03;
      const reflectivity = options.reflectivity || 0.02;
      const scale5 = options.scale || 1;
      const shader = options.shader || _Water2.WaterShader;
      const encoding = options.encoding !== void 0 ? options.encoding : 3e3;
      const flowMap = options.flowMap || void 0;
      const normalMap0 = options.normalMap0;
      const normalMap1 = options.normalMap1;
      const cycle = 0.15;
      const halfCycle = cycle * 0.5;
      const textureMatrix = new Matrix4();
      const clock = new Clock();
      if (Reflector === void 0) {
        console.error("THREE.Water: Required component Reflector not found.");
        return;
      }
      if (Refractor === void 0) {
        console.error("THREE.Water: Required component Refractor not found.");
        return;
      }
      const reflector = new Reflector(geometry3, {
        textureWidth,
        textureHeight,
        clipBias,
        encoding
      });
      const refractor = new Refractor(geometry3, {
        textureWidth,
        textureHeight,
        clipBias,
        encoding
      });
      reflector.matrixAutoUpdate = false;
      refractor.matrixAutoUpdate = false;
      this.material = new ShaderMaterial({
        uniforms: UniformsUtils.merge([UniformsLib["fog"], shader.uniforms]),
        vertexShader: shader.vertexShader,
        fragmentShader: shader.fragmentShader,
        transparent: true,
        fog: true
      });
      if (flowMap !== void 0) {
        this.material.defines.USE_FLOWMAP = "";
        this.material.uniforms["tFlowMap"] = {
          type: "t",
          value: flowMap
        };
      } else {
        this.material.uniforms["flowDirection"] = {
          type: "v2",
          value: flowDirection
        };
      }
      normalMap0.wrapS = normalMap0.wrapT = RepeatWrapping;
      normalMap1.wrapS = normalMap1.wrapT = RepeatWrapping;
      this.material.uniforms["tReflectionMap"].value = reflector.getRenderTarget().texture;
      this.material.uniforms["tRefractionMap"].value = refractor.getRenderTarget().texture;
      this.material.uniforms["tNormalMap0"].value = normalMap0;
      this.material.uniforms["tNormalMap1"].value = normalMap1;
      this.material.uniforms["color"].value = color;
      this.material.uniforms["reflectivity"].value = reflectivity;
      this.material.uniforms["textureMatrix"].value = textureMatrix;
      this.material.uniforms["config"].value.x = 0;
      this.material.uniforms["config"].value.y = halfCycle;
      this.material.uniforms["config"].value.z = halfCycle;
      this.material.uniforms["config"].value.w = scale5;
      function updateTextureMatrix(camera) {
        textureMatrix.set(0.5, 0, 0, 0.5, 0, 0.5, 0, 0.5, 0, 0, 0.5, 0.5, 0, 0, 0, 1);
        textureMatrix.multiply(camera.projectionMatrix);
        textureMatrix.multiply(camera.matrixWorldInverse);
        textureMatrix.multiply(scope.matrixWorld);
      }
      function updateFlow() {
        const delta = clock.getDelta();
        const config = scope.material.uniforms["config"];
        config.value.x += flowSpeed * delta;
        config.value.y = config.value.x + halfCycle;
        if (config.value.x >= cycle) {
          config.value.x = 0;
          config.value.y = halfCycle;
        } else if (config.value.y >= cycle) {
          config.value.y = config.value.y - cycle;
        }
      }
      this.onBeforeRender = function(renderer, scene, camera) {
        updateTextureMatrix(camera);
        updateFlow();
        scope.visible = false;
        reflector.matrixWorld.copy(scope.matrixWorld);
        refractor.matrixWorld.copy(scope.matrixWorld);
        reflector.onBeforeRender(renderer, scene, camera);
        refractor.onBeforeRender(renderer, scene, camera);
        scope.visible = true;
      };
    }
  };
  let Water22 = _Water2;
  __publicField11(Water22, "WaterShader", {
    uniforms: {
      color: {
        value: null
      },
      reflectivity: {
        value: 0
      },
      tReflectionMap: {
        value: null
      },
      tRefractionMap: {
        value: null
      },
      tNormalMap0: {
        value: null
      },
      tNormalMap1: {
        value: null
      },
      textureMatrix: {
        value: null
      },
      config: {
        value: new Vector4()
      }
    },
    vertexShader: (
      /* glsl */
      `

		#include <common>
		#include <fog_pars_vertex>
		#include <logdepthbuf_pars_vertex>

		uniform mat4 textureMatrix;

		varying vec4 vCoord;
		varying vec2 vUv;
		varying vec3 vToEye;

		void main() {

			vUv = uv;
			vCoord = textureMatrix * vec4( position, 1.0 );

			vec4 worldPosition = modelMatrix * vec4( position, 1.0 );
			vToEye = cameraPosition - worldPosition.xyz;

			vec4 mvPosition =  viewMatrix * worldPosition; // used in fog_vertex
			gl_Position = projectionMatrix * mvPosition;

			#include <logdepthbuf_vertex>
			#include <fog_vertex>

		}`
    ),
    fragmentShader: (
      /* glsl */
      `

		#include <common>
		#include <fog_pars_fragment>
		#include <logdepthbuf_pars_fragment>

		uniform sampler2D tReflectionMap;
		uniform sampler2D tRefractionMap;
		uniform sampler2D tNormalMap0;
		uniform sampler2D tNormalMap1;

		#ifdef USE_FLOWMAP
			uniform sampler2D tFlowMap;
		#else
			uniform vec2 flowDirection;
		#endif

		uniform vec3 color;
		uniform float reflectivity;
		uniform vec4 config;

		varying vec4 vCoord;
		varying vec2 vUv;
		varying vec3 vToEye;

		void main() {

			#include <logdepthbuf_fragment>

			float flowMapOffset0 = config.x;
			float flowMapOffset1 = config.y;
			float halfCycle = config.z;
			float scale = config.w;

			vec3 toEye = normalize( vToEye );

			// determine flow direction
			vec2 flow;
			#ifdef USE_FLOWMAP
				flow = texture2D( tFlowMap, vUv ).rg * 2.0 - 1.0;
			#else
				flow = flowDirection;
			#endif
			flow.x *= - 1.0;

			// sample normal maps (distort uvs with flowdata)
			vec4 normalColor0 = texture2D( tNormalMap0, ( vUv * scale ) + flow * flowMapOffset0 );
			vec4 normalColor1 = texture2D( tNormalMap1, ( vUv * scale ) + flow * flowMapOffset1 );

			// linear interpolate to get the final normal color
			float flowLerp = abs( halfCycle - flowMapOffset0 ) / halfCycle;
			vec4 normalColor = mix( normalColor0, normalColor1, flowLerp );

			// calculate normal vector
			vec3 normal = normalize( vec3( normalColor.r * 2.0 - 1.0, normalColor.b,  normalColor.g * 2.0 - 1.0 ) );

			// calculate the fresnel term to blend reflection and refraction maps
			float theta = max( dot( toEye, normal ), 0.0 );
			float reflectance = reflectivity + ( 1.0 - reflectivity ) * pow( ( 1.0 - theta ), 5.0 );

			// calculate final uv coords
			vec3 coord = vCoord.xyz / vCoord.w;
			vec2 uv = coord.xy + coord.z * normal.xz * 0.05;

			vec4 reflectColor = texture2D( tReflectionMap, vec2( 1.0 - uv.x, uv.y ) );
			vec4 refractColor = texture2D( tRefractionMap, uv );

			// multiply water color with the mix of both textures
			gl_FragColor = vec4( color, 1.0 ) * mix( refractColor, reflectColor, reflectance );

			#include <tonemapping_fragment>
			#include <${version >= 154 ? "colorspace_fragment" : "encodings_fragment"}>
			#include <fog_fragment>

		}`
    )
  });
  return Water22;
})();

// node_modules/three-stdlib/objects/GroundProjectedEnv.js
var isCubeTexture = (def) => def && def.isCubeTexture;
var GroundProjectedEnv = class extends Mesh {
  constructor(texture, options) {
    var _a4, _b3;
    const isCubeMap = isCubeTexture(texture);
    const w = (_b3 = isCubeMap ? (_a4 = texture.image[0]) == null ? void 0 : _a4.width : texture.image.width) != null ? _b3 : 1024;
    const cubeSize = w / 4;
    const _lodMax = Math.floor(Math.log2(cubeSize));
    const _cubeSize = Math.pow(2, _lodMax);
    const width = 3 * Math.max(_cubeSize, 16 * 7);
    const height = 4 * _cubeSize;
    const defines = [
      isCubeMap ? "#define ENVMAP_TYPE_CUBE" : "",
      `#define CUBEUV_TEXEL_WIDTH ${1 / width}`,
      `#define CUBEUV_TEXEL_HEIGHT ${1 / height}`,
      `#define CUBEUV_MAX_MIP ${_lodMax}.0`
    ];
    const vertexShader3 = (
      /* glsl */
      `
        varying vec3 vWorldPosition;
        void main() 
        {
            vec4 worldPosition = ( modelMatrix * vec4( position, 1.0 ) );
            vWorldPosition = worldPosition.xyz;
            
            gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );
        }
        `
    );
    const fragmentShader3 = defines.join("\n") + /* glsl */
    `
        #define ENVMAP_TYPE_CUBE_UV
        varying vec3 vWorldPosition;
        uniform float radius;
        uniform float height;
        uniform float angle;
        #ifdef ENVMAP_TYPE_CUBE
            uniform samplerCube map;
        #else
            uniform sampler2D map;
        #endif
        // From: https://www.shadertoy.com/view/4tsBD7
        float diskIntersectWithBackFaceCulling( vec3 ro, vec3 rd, vec3 c, vec3 n, float r ) 
        {
            float d = dot ( rd, n );
            
            if( d > 0.0 ) { return 1e6; }
            
            vec3  o = ro - c;
            float t = - dot( n, o ) / d;
            vec3  q = o + rd * t;
            
            return ( dot( q, q ) < r * r ) ? t : 1e6;
        }
        // From: https://www.iquilezles.org/www/articles/intersectors/intersectors.htm
        float sphereIntersect( vec3 ro, vec3 rd, vec3 ce, float ra ) 
        {
            vec3 oc = ro - ce;
            float b = dot( oc, rd );
            float c = dot( oc, oc ) - ra * ra;
            float h = b * b - c;
            
            if( h < 0.0 ) { return -1.0; }
            
            h = sqrt( h );
            
            return - b + h;
        }
        vec3 project() 
        {
            vec3 p = normalize( vWorldPosition );
            vec3 camPos = cameraPosition;
            camPos.y -= height;
            float intersection = sphereIntersect( camPos, p, vec3( 0.0 ), radius );
            if( intersection > 0.0 ) {
                
                vec3 h = vec3( 0.0, - height, 0.0 );
                float intersection2 = diskIntersectWithBackFaceCulling( camPos, p, h, vec3( 0.0, 1.0, 0.0 ), radius );
                p = ( camPos + min( intersection, intersection2 ) * p ) / radius;
            } else {
                p = vec3( 0.0, 1.0, 0.0 );
            }
            return p;
        }
        #include <common>
        #include <cube_uv_reflection_fragment>
        void main() 
        {
            vec3 projectedWorldPosition = project();
            
            #ifdef ENVMAP_TYPE_CUBE
                vec3 outcolor = textureCube( map, projectedWorldPosition ).rgb;
            #else
                vec3 direction = normalize( projectedWorldPosition );
                vec2 uv = equirectUv( direction );
                vec3 outcolor = texture2D( map, uv ).rgb;
            #endif
            gl_FragColor = vec4( outcolor, 1.0 );
            #include <tonemapping_fragment>
            #include <${version >= 154 ? "colorspace_fragment" : "encodings_fragment"}>
        }
        `;
    const uniforms = {
      map: { value: texture },
      height: { value: (options == null ? void 0 : options.height) || 15 },
      radius: { value: (options == null ? void 0 : options.radius) || 100 }
    };
    const geometry3 = new IcosahedronGeometry(1, 16);
    const material = new ShaderMaterial({
      uniforms,
      fragmentShader: fragmentShader3,
      vertexShader: vertexShader3,
      side: DoubleSide
    });
    super(geometry3, material);
  }
  set radius(radius) {
    this.material.uniforms.radius.value = radius;
  }
  get radius() {
    return this.material.uniforms.radius.value;
  }
  set height(height) {
    this.material.uniforms.height.value = height;
  }
  get height() {
    return this.material.uniforms.height.value;
  }
};

// node_modules/three-stdlib/utils/RoughnessMipmapper.js
var _mipmapMaterial = _getMipmapMaterial();
var _mesh = new Mesh(new PlaneGeometry(2, 2), _mipmapMaterial);
var _flatCamera = new OrthographicCamera(0, 1, 0, 1, 0, 1);
function _getMipmapMaterial() {
  var shaderMaterial2 = new RawShaderMaterial({
    uniforms: {
      roughnessMap: { value: null },
      normalMap: { value: null },
      texelSize: { value: new Vector2(1, 1) }
    },
    vertexShader: (
      /* glsl */
      `
			precision mediump float;
			precision mediump int;

			attribute vec3 position;
			attribute vec2 uv;

			varying vec2 vUv;

			void main() {

				vUv = uv;

				gl_Position = vec4( position, 1.0 );

			}
		`
    ),
    fragmentShader: (
      /* glsl */
      `
			precision mediump float;
			precision mediump int;

			varying vec2 vUv;

			uniform sampler2D roughnessMap;
			uniform sampler2D normalMap;
			uniform vec2 texelSize;

			#define ENVMAP_TYPE_CUBE_UV

			vec4 envMapTexelToLinear( vec4 a ) { return a; }

			#include <cube_uv_reflection_fragment>

			float roughnessToVariance( float roughness ) {

				float variance = 0.0;

				if ( roughness >= r1 ) {

					variance = ( r0 - roughness ) * ( v1 - v0 ) / ( r0 - r1 ) + v0;

				} else if ( roughness >= r4 ) {

					variance = ( r1 - roughness ) * ( v4 - v1 ) / ( r1 - r4 ) + v1;

				} else if ( roughness >= r5 ) {

					variance = ( r4 - roughness ) * ( v5 - v4 ) / ( r4 - r5 ) + v4;

				} else {

					float roughness2 = roughness * roughness;

					variance = 1.79 * roughness2 * roughness2;

				}

				return variance;

			}

			float varianceToRoughness( float variance ) {

				float roughness = 0.0;

				if ( variance >= v1 ) {

					roughness = ( v0 - variance ) * ( r1 - r0 ) / ( v0 - v1 ) + r0;

				} else if ( variance >= v4 ) {

					roughness = ( v1 - variance ) * ( r4 - r1 ) / ( v1 - v4 ) + r1;

				} else if ( variance >= v5 ) {

					roughness = ( v4 - variance ) * ( r5 - r4 ) / ( v4 - v5 ) + r4;

				} else {

					roughness = pow( 0.559 * variance, 0.25 ); // 0.559 = 1.0 / 1.79

				}

				return roughness;

			}

			void main() {

				gl_FragColor = texture2D( roughnessMap, vUv, - 1.0 );

				if ( texelSize.x == 0.0 ) return;

				float roughness = gl_FragColor.g;

				float variance = roughnessToVariance( roughness );

				vec3 avgNormal;

				for ( float x = - 1.0; x < 2.0; x += 2.0 ) {

					for ( float y = - 1.0; y < 2.0; y += 2.0 ) {

						vec2 uv = vUv + vec2( x, y ) * 0.25 * texelSize;

						avgNormal += normalize( texture2D( normalMap, uv, - 1.0 ).xyz - 0.5 );

					}

				}

				variance += 1.0 - 0.25 * length( avgNormal );

				gl_FragColor.g = varianceToRoughness( variance );

			}
		`
    ),
    blending: NoBlending,
    depthTest: false,
    depthWrite: false
  });
  shaderMaterial2.type = "RoughnessMipmapper";
  return shaderMaterial2;
}

// node_modules/three-stdlib/utils/SkeletonUtils.js
function retarget(target2, source, options = {}) {
  const pos = new Vector3(), quat = new Quaternion(), scale5 = new Vector3(), bindBoneMatrix = new Matrix4(), relativeMatrix = new Matrix4(), globalMatrix = new Matrix4();
  options.preserveMatrix = options.preserveMatrix !== void 0 ? options.preserveMatrix : true;
  options.preservePosition = options.preservePosition !== void 0 ? options.preservePosition : true;
  options.preserveHipPosition = options.preserveHipPosition !== void 0 ? options.preserveHipPosition : false;
  options.useTargetMatrix = options.useTargetMatrix !== void 0 ? options.useTargetMatrix : false;
  options.hip = options.hip !== void 0 ? options.hip : "hip";
  options.names = options.names || {};
  const sourceBones = source.isObject3D ? source.skeleton.bones : getBones(source), bones = target2.isObject3D ? target2.skeleton.bones : getBones(target2);
  let bindBones, bone, name, boneTo, bonesPosition;
  if (target2.isObject3D) {
    target2.skeleton.pose();
  } else {
    options.useTargetMatrix = true;
    options.preserveMatrix = false;
  }
  if (options.preservePosition) {
    bonesPosition = [];
    for (let i4 = 0; i4 < bones.length; i4++) {
      bonesPosition.push(bones[i4].position.clone());
    }
  }
  if (options.preserveMatrix) {
    target2.updateMatrixWorld();
    target2.matrixWorld.identity();
    for (let i4 = 0; i4 < target2.children.length; ++i4) {
      target2.children[i4].updateMatrixWorld(true);
    }
  }
  if (options.offsets) {
    bindBones = [];
    for (let i4 = 0; i4 < bones.length; ++i4) {
      bone = bones[i4];
      name = options.names[bone.name] || bone.name;
      if (options.offsets[name]) {
        bone.matrix.multiply(options.offsets[name]);
        bone.matrix.decompose(bone.position, bone.quaternion, bone.scale);
        bone.updateMatrixWorld();
      }
      bindBones.push(bone.matrixWorld.clone());
    }
  }
  for (let i4 = 0; i4 < bones.length; ++i4) {
    bone = bones[i4];
    name = options.names[bone.name] || bone.name;
    boneTo = getBoneByName(name, sourceBones);
    globalMatrix.copy(bone.matrixWorld);
    if (boneTo) {
      boneTo.updateMatrixWorld();
      if (options.useTargetMatrix) {
        relativeMatrix.copy(boneTo.matrixWorld);
      } else {
        relativeMatrix.copy(target2.matrixWorld).invert();
        relativeMatrix.multiply(boneTo.matrixWorld);
      }
      scale5.setFromMatrixScale(relativeMatrix);
      relativeMatrix.scale(scale5.set(1 / scale5.x, 1 / scale5.y, 1 / scale5.z));
      globalMatrix.makeRotationFromQuaternion(quat.setFromRotationMatrix(relativeMatrix));
      if (target2.isObject3D) {
        const boneIndex = bones.indexOf(bone), wBindMatrix = bindBones ? bindBones[boneIndex] : bindBoneMatrix.copy(target2.skeleton.boneInverses[boneIndex]).invert();
        globalMatrix.multiply(wBindMatrix);
      }
      globalMatrix.copyPosition(relativeMatrix);
    }
    if (bone.parent && bone.parent.isBone) {
      bone.matrix.copy(bone.parent.matrixWorld).invert();
      bone.matrix.multiply(globalMatrix);
    } else {
      bone.matrix.copy(globalMatrix);
    }
    if (options.preserveHipPosition && name === options.hip) {
      bone.matrix.setPosition(pos.set(0, bone.position.y, 0));
    }
    bone.matrix.decompose(bone.position, bone.quaternion, bone.scale);
    bone.updateMatrixWorld();
  }
  if (options.preservePosition) {
    for (let i4 = 0; i4 < bones.length; ++i4) {
      bone = bones[i4];
      name = options.names[bone.name] || bone.name;
      if (name !== options.hip) {
        bone.position.copy(bonesPosition[i4]);
      }
    }
  }
  if (options.preserveMatrix) {
    target2.updateMatrixWorld(true);
  }
}
function retargetClip(target2, source, clip, options = {}) {
  options.useFirstFramePosition = options.useFirstFramePosition !== void 0 ? options.useFirstFramePosition : false;
  options.fps = options.fps !== void 0 ? options.fps : 30;
  options.names = options.names || [];
  if (!source.isObject3D) {
    source = getHelperFromSkeleton(source);
  }
  const numFrames = Math.round(clip.duration * (options.fps / 1e3) * 1e3), delta = 1 / options.fps, convertedTracks = [], mixer = new AnimationMixer(source), bones = getBones(target2.skeleton), boneDatas = [];
  let positionOffset, bone, boneTo, boneData, name;
  mixer.clipAction(clip).play();
  mixer.update(0);
  source.updateMatrixWorld();
  for (let i4 = 0; i4 < numFrames; ++i4) {
    const time = i4 * delta;
    retarget(target2, source, options);
    for (let j = 0; j < bones.length; ++j) {
      name = options.names[bones[j].name] || bones[j].name;
      boneTo = getBoneByName(name, source.skeleton);
      if (boneTo) {
        bone = bones[j];
        boneData = boneDatas[j] = boneDatas[j] || { bone };
        if (options.hip === name) {
          if (!boneData.pos) {
            boneData.pos = {
              times: new Float32Array(numFrames),
              values: new Float32Array(numFrames * 3)
            };
          }
          if (options.useFirstFramePosition) {
            if (i4 === 0) {
              positionOffset = bone.position.clone();
            }
            bone.position.sub(positionOffset);
          }
          boneData.pos.times[i4] = time;
          bone.position.toArray(boneData.pos.values, i4 * 3);
        }
        if (!boneData.quat) {
          boneData.quat = {
            times: new Float32Array(numFrames),
            values: new Float32Array(numFrames * 4)
          };
        }
        boneData.quat.times[i4] = time;
        bone.quaternion.toArray(boneData.quat.values, i4 * 4);
      }
    }
    mixer.update(delta);
    source.updateMatrixWorld();
  }
  for (let i4 = 0; i4 < boneDatas.length; ++i4) {
    boneData = boneDatas[i4];
    if (boneData) {
      if (boneData.pos) {
        convertedTracks.push(
          new VectorKeyframeTrack(
            ".bones[" + boneData.bone.name + "].position",
            boneData.pos.times,
            boneData.pos.values
          )
        );
      }
      convertedTracks.push(
        new QuaternionKeyframeTrack(
          ".bones[" + boneData.bone.name + "].quaternion",
          boneData.quat.times,
          boneData.quat.values
        )
      );
    }
  }
  mixer.uncacheAction(clip);
  return new AnimationClip(clip.name, -1, convertedTracks);
}
function clone(source) {
  const sourceLookup = /* @__PURE__ */ new Map();
  const cloneLookup = /* @__PURE__ */ new Map();
  const clone2 = source.clone();
  parallelTraverse(source, clone2, function(sourceNode, clonedNode) {
    sourceLookup.set(clonedNode, sourceNode);
    cloneLookup.set(sourceNode, clonedNode);
  });
  clone2.traverse(function(node) {
    if (!node.isSkinnedMesh)
      return;
    const clonedMesh = node;
    const sourceMesh = sourceLookup.get(node);
    const sourceBones = sourceMesh.skeleton.bones;
    clonedMesh.skeleton = sourceMesh.skeleton.clone();
    clonedMesh.bindMatrix.copy(sourceMesh.bindMatrix);
    clonedMesh.skeleton.bones = sourceBones.map(function(bone) {
      return cloneLookup.get(bone);
    });
    clonedMesh.bind(clonedMesh.skeleton, clonedMesh.bindMatrix);
  });
  return clone2;
}
function getBoneByName(name, skeleton) {
  for (let i4 = 0, bones = getBones(skeleton); i4 < bones.length; i4++) {
    if (name === bones[i4].name)
      return bones[i4];
  }
}
function getBones(skeleton) {
  return Array.isArray(skeleton) ? skeleton : skeleton.bones;
}
function getHelperFromSkeleton(skeleton) {
  const source = new SkeletonHelper(skeleton.bones[0]);
  source.skeleton = skeleton;
  return source;
}
function parallelTraverse(a6, b5, callback) {
  callback(a6, b5);
  for (let i4 = 0; i4 < a6.children.length; i4++) {
    parallelTraverse(a6.children[i4], b5.children[i4], callback);
  }
}
var SkeletonUtils = { retarget, retargetClip, clone };

// node_modules/three-stdlib/shaders/UnpackDepthRGBAShader.js
var UnpackDepthRGBAShader = {
  uniforms: {
    tDiffuse: { value: null },
    opacity: { value: 1 }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform float opacity;

    uniform sampler2D tDiffuse;

    varying vec2 vUv;

    #include <packing>

    void main() {

    	float depth = 1.0 - unpackRGBAToDepth( texture2D( tDiffuse, vUv ) );
    	gl_FragColor = vec4( vec3( depth ), opacity );

    }
  `
  )
};

// node_modules/three-stdlib/shaders/BokehShader2.js
var BokehShader2 = {
  uniforms: {
    textureWidth: { value: 1 },
    textureHeight: { value: 1 },
    focalDepth: { value: 1 },
    focalLength: { value: 24 },
    fstop: { value: 0.9 },
    tColor: { value: null },
    tDepth: { value: null },
    maxblur: { value: 1 },
    showFocus: { value: 0 },
    manualdof: { value: 0 },
    vignetting: { value: 0 },
    depthblur: { value: 0 },
    threshold: { value: 0.5 },
    gain: { value: 2 },
    bias: { value: 0.5 },
    fringe: { value: 0.7 },
    znear: { value: 0.1 },
    zfar: { value: 100 },
    noise: { value: 1 },
    dithering: { value: 1e-4 },
    pentagon: { value: 0 },
    shaderFocus: { value: 1 },
    focusCoords: { value: new Vector2() }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    #include <common>

    varying vec2 vUv;

    uniform sampler2D tColor;
    uniform sampler2D tDepth;
    uniform float textureWidth;
    uniform float textureHeight;

    uniform float focalDepth;  //focal distance value in meters, but you may use autofocus option below
    uniform float focalLength; //focal length in mm
    uniform float fstop; //f-stop value
    uniform bool showFocus; //show debug focus point and focal range (red = focal point, green = focal range)

    /*
    make sure that these two values are the same for your camera, otherwise distances will be wrong.
    */

    uniform float znear; // camera clipping start
    uniform float zfar; // camera clipping end

    //------------------------------------------
    //user variables

    const int samples = SAMPLES; //samples on the first ring
    const int rings = RINGS; //ring count

    const int maxringsamples = rings * samples;

    uniform bool manualdof; // manual dof calculation
    float ndofstart = 1.0; // near dof blur start
    float ndofdist = 2.0; // near dof blur falloff distance
    float fdofstart = 1.0; // far dof blur start
    float fdofdist = 3.0; // far dof blur falloff distance

    float CoC = 0.03; //circle of confusion size in mm (35mm film = 0.03mm)

    uniform bool vignetting; // use optical lens vignetting

    float vignout = 1.3; // vignetting outer border
    float vignin = 0.0; // vignetting inner border
    float vignfade = 22.0; // f-stops till vignete fades

    uniform bool shaderFocus;
    // disable if you use external focalDepth value

    uniform vec2 focusCoords;
    // autofocus point on screen (0.0,0.0 - left lower corner, 1.0,1.0 - upper right)
    // if center of screen use vec2(0.5, 0.5);

    uniform float maxblur;
    //clamp value of max blur (0.0 = no blur, 1.0 default)

    uniform float threshold; // highlight threshold;
    uniform float gain; // highlight gain;

    uniform float bias; // bokeh edge bias
    uniform float fringe; // bokeh chromatic aberration / fringing

    uniform bool noise; //use noise instead of pattern for sample dithering

    uniform float dithering;

    uniform bool depthblur; // blur the depth buffer
    float dbsize = 1.25; // depth blur size

    /*
    next part is experimental
    not looking good with small sample and ring count
    looks okay starting from samples = 4, rings = 4
    */

    uniform bool pentagon; //use pentagon as bokeh shape?
    float feather = 0.4; //pentagon shape feather

    //------------------------------------------

    float penta(vec2 coords) {
    	//pentagonal shape
    	float scale = float(rings) - 1.3;
    	vec4  HS0 = vec4( 1.0,         0.0,         0.0,  1.0);
    	vec4  HS1 = vec4( 0.309016994, 0.951056516, 0.0,  1.0);
    	vec4  HS2 = vec4(-0.809016994, 0.587785252, 0.0,  1.0);
    	vec4  HS3 = vec4(-0.809016994,-0.587785252, 0.0,  1.0);
    	vec4  HS4 = vec4( 0.309016994,-0.951056516, 0.0,  1.0);
    	vec4  HS5 = vec4( 0.0        ,0.0         , 1.0,  1.0);

    	vec4  one = vec4( 1.0 );

    	vec4 P = vec4((coords),vec2(scale, scale));

    	vec4 dist = vec4(0.0);
    	float inorout = -4.0;

    	dist.x = dot( P, HS0 );
    	dist.y = dot( P, HS1 );
    	dist.z = dot( P, HS2 );
    	dist.w = dot( P, HS3 );

    	dist = smoothstep( -feather, feather, dist );

    	inorout += dot( dist, one );

    	dist.x = dot( P, HS4 );
    	dist.y = HS5.w - abs( P.z );

    	dist = smoothstep( -feather, feather, dist );
    	inorout += dist.x;

    	return clamp( inorout, 0.0, 1.0 );
    }

    float bdepth(vec2 coords) {
    	// Depth buffer blur
    	float d = 0.0;
    	float kernel[9];
    	vec2 offset[9];

    	vec2 wh = vec2(1.0/textureWidth,1.0/textureHeight) * dbsize;

    	offset[0] = vec2(-wh.x,-wh.y);
    	offset[1] = vec2( 0.0, -wh.y);
    	offset[2] = vec2( wh.x -wh.y);

    	offset[3] = vec2(-wh.x,  0.0);
    	offset[4] = vec2( 0.0,   0.0);
    	offset[5] = vec2( wh.x,  0.0);

    	offset[6] = vec2(-wh.x, wh.y);
    	offset[7] = vec2( 0.0,  wh.y);
    	offset[8] = vec2( wh.x, wh.y);

    	kernel[0] = 1.0/16.0;   kernel[1] = 2.0/16.0;   kernel[2] = 1.0/16.0;
    	kernel[3] = 2.0/16.0;   kernel[4] = 4.0/16.0;   kernel[5] = 2.0/16.0;
    	kernel[6] = 1.0/16.0;   kernel[7] = 2.0/16.0;   kernel[8] = 1.0/16.0;

    	for( int i=0; i<9; i++ ) {
    		float tmp = texture2D(tDepth, coords + offset[i]).r;
    		d += tmp * kernel[i];
    	}

    	return d;
    }

    vec3 color(vec2 coords,float blur) {
    	//processing the sample

    	vec3 col = vec3(0.0);
    	vec2 texel = vec2(1.0/textureWidth,1.0/textureHeight);

    	col.r = texture2D(tColor,coords + vec2(0.0,1.0)*texel*fringe*blur).r;
    	col.g = texture2D(tColor,coords + vec2(-0.866,-0.5)*texel*fringe*blur).g;
    	col.b = texture2D(tColor,coords + vec2(0.866,-0.5)*texel*fringe*blur).b;

    	vec3 lumcoeff = vec3(0.299,0.587,0.114);
    	float lum = dot(col.rgb, lumcoeff);
    	float thresh = max((lum-threshold)*gain, 0.0);
    	return col+mix(vec3(0.0),col,thresh*blur);
    }

    vec3 debugFocus(vec3 col, float blur, float depth) {
    	float edge = 0.002*depth; //distance based edge smoothing
    	float m = clamp(smoothstep(0.0,edge,blur),0.0,1.0);
    	float e = clamp(smoothstep(1.0-edge,1.0,blur),0.0,1.0);

    	col = mix(col,vec3(1.0,0.5,0.0),(1.0-m)*0.6);
    	col = mix(col,vec3(0.0,0.5,1.0),((1.0-e)-(1.0-m))*0.2);

    	return col;
    }

    float linearize(float depth) {
    	return -zfar * znear / (depth * (zfar - znear) - zfar);
    }

    float vignette() {
    	float dist = distance(vUv.xy, vec2(0.5,0.5));
    	dist = smoothstep(vignout+(fstop/vignfade), vignin+(fstop/vignfade), dist);
    	return clamp(dist,0.0,1.0);
    }

    float gather(float i, float j, int ringsamples, inout vec3 col, float w, float h, float blur) {
    	float rings2 = float(rings);
    	float step = PI*2.0 / float(ringsamples);
    	float pw = cos(j*step)*i;
    	float ph = sin(j*step)*i;
    	float p = 1.0;
    	if (pentagon) {
    		p = penta(vec2(pw,ph));
    	}
    	col += color(vUv.xy + vec2(pw*w,ph*h), blur) * mix(1.0, i/rings2, bias) * p;
    	return 1.0 * mix(1.0, i /rings2, bias) * p;
    }

    void main() {
    	//scene depth calculation

    	float depth = linearize(texture2D(tDepth,vUv.xy).x);

    	// Blur depth?
    	if ( depthblur ) {
    		depth = linearize(bdepth(vUv.xy));
    	}

    	//focal plane calculation

    	float fDepth = focalDepth;

    	if (shaderFocus) {

    		fDepth = linearize(texture2D(tDepth,focusCoords).x);

    	}

    	// dof blur factor calculation

    	float blur = 0.0;

    	if (manualdof) {
    		float a = depth-fDepth; // Focal plane
    		float b = (a-fdofstart)/fdofdist; // Far DoF
    		float c = (-a-ndofstart)/ndofdist; // Near Dof
    		blur = (a>0.0) ? b : c;
    	} else {
    		float f = focalLength; // focal length in mm
    		float d = fDepth*1000.0; // focal plane in mm
    		float o = depth*1000.0; // depth in mm

    		float a = (o*f)/(o-f);
    		float b = (d*f)/(d-f);
    		float c = (d-f)/(d*fstop*CoC);

    		blur = abs(a-b)*c;
    	}

    	blur = clamp(blur,0.0,1.0);

    	// calculation of pattern for dithering

    	vec2 noise = vec2(rand(vUv.xy), rand( vUv.xy + vec2( 0.4, 0.6 ) ) )*dithering*blur;

    	// getting blur x and y step factor

    	float w = (1.0/textureWidth)*blur*maxblur+noise.x;
    	float h = (1.0/textureHeight)*blur*maxblur+noise.y;

    	// calculation of final color

    	vec3 col = vec3(0.0);

    	if(blur < 0.05) {
    		//some optimization thingy
    		col = texture2D(tColor, vUv.xy).rgb;
    	} else {
    		col = texture2D(tColor, vUv.xy).rgb;
    		float s = 1.0;
    		int ringsamples;

    		for (int i = 1; i <= rings; i++) {
    			/*unboxstart*/
    			ringsamples = i * samples;

    			for (int j = 0 ; j < maxringsamples ; j++) {
    				if (j >= ringsamples) break;
    				s += gather(float(i), float(j), ringsamples, col, w, h, blur);
    			}
    			/*unboxend*/
    		}

    		col /= s; //divide by sample count
    	}

    	if (showFocus) {
    		col = debugFocus(col, blur, depth);
    	}

    	if (vignetting) {
    		col *= vignette();
    	}

    	gl_FragColor.rgb = col;
    	gl_FragColor.a = 1.0;
    } 
  `
  )
};

// node_modules/three-stdlib/math/MeshSurfaceSampler.js
var _face = new Triangle();
var _color = new Vector3();
var MeshSurfaceSampler = class {
  constructor(mesh) {
    let geometry3 = mesh.geometry;
    if (geometry3.index) {
      console.warn("THREE.MeshSurfaceSampler: Converting geometry to non-indexed BufferGeometry.");
      geometry3 = geometry3.toNonIndexed();
    }
    this.geometry = geometry3;
    this.randomFunction = Math.random;
    this.positionAttribute = this.geometry.getAttribute("position");
    this.colorAttribute = this.geometry.getAttribute("color");
    this.weightAttribute = null;
    this.distribution = null;
  }
  setWeightAttribute(name) {
    this.weightAttribute = name ? this.geometry.getAttribute(name) : null;
    return this;
  }
  build() {
    const positionAttribute = this.positionAttribute;
    const weightAttribute = this.weightAttribute;
    const faceWeights = new Float32Array(positionAttribute.count / 3);
    for (let i4 = 0; i4 < positionAttribute.count; i4 += 3) {
      let faceWeight = 1;
      if (weightAttribute) {
        faceWeight = weightAttribute.getX(i4) + weightAttribute.getX(i4 + 1) + weightAttribute.getX(i4 + 2);
      }
      _face.a.fromBufferAttribute(positionAttribute, i4);
      _face.b.fromBufferAttribute(positionAttribute, i4 + 1);
      _face.c.fromBufferAttribute(positionAttribute, i4 + 2);
      faceWeight *= _face.getArea();
      faceWeights[i4 / 3] = faceWeight;
    }
    this.distribution = new Float32Array(positionAttribute.count / 3);
    let cumulativeTotal = 0;
    for (let i4 = 0; i4 < faceWeights.length; i4++) {
      cumulativeTotal += faceWeights[i4];
      this.distribution[i4] = cumulativeTotal;
    }
    return this;
  }
  setRandomGenerator(randomFunction) {
    this.randomFunction = randomFunction;
    return this;
  }
  sample(targetPosition3, targetNormal, targetColor) {
    const faceIndex = this.sampleFaceIndex();
    return this.sampleFace(faceIndex, targetPosition3, targetNormal, targetColor);
  }
  sampleFaceIndex() {
    const cumulativeTotal = this.distribution[this.distribution.length - 1];
    return this.binarySearch(this.randomFunction() * cumulativeTotal);
  }
  binarySearch(x) {
    const dist = this.distribution;
    let start = 0;
    let end = dist.length - 1;
    let index2 = -1;
    while (start <= end) {
      const mid = Math.ceil((start + end) / 2);
      if (mid === 0 || dist[mid - 1] <= x && dist[mid] > x) {
        index2 = mid;
        break;
      } else if (x < dist[mid]) {
        end = mid - 1;
      } else {
        start = mid + 1;
      }
    }
    return index2;
  }
  sampleFace(faceIndex, targetPosition3, targetNormal, targetColor) {
    let u = this.randomFunction();
    let v5 = this.randomFunction();
    if (u + v5 > 1) {
      u = 1 - u;
      v5 = 1 - v5;
    }
    _face.a.fromBufferAttribute(this.positionAttribute, faceIndex * 3);
    _face.b.fromBufferAttribute(this.positionAttribute, faceIndex * 3 + 1);
    _face.c.fromBufferAttribute(this.positionAttribute, faceIndex * 3 + 2);
    targetPosition3.set(0, 0, 0).addScaledVector(_face.a, u).addScaledVector(_face.b, v5).addScaledVector(_face.c, 1 - (u + v5));
    if (targetNormal !== void 0) {
      _face.getNormal(targetNormal);
    }
    if (targetColor !== void 0 && this.colorAttribute !== void 0) {
      _face.a.fromBufferAttribute(this.colorAttribute, faceIndex * 3);
      _face.b.fromBufferAttribute(this.colorAttribute, faceIndex * 3 + 1);
      _face.c.fromBufferAttribute(this.colorAttribute, faceIndex * 3 + 2);
      _color.set(0, 0, 0).addScaledVector(_face.a, u).addScaledVector(_face.b, v5).addScaledVector(_face.c, 1 - (u + v5));
      targetColor.r = _color.x;
      targetColor.g = _color.y;
      targetColor.b = _color.z;
    }
    return this;
  }
};

// node_modules/three-stdlib/math/OBB.js
var a = {
  c: null,
  // center
  u: [new Vector3(), new Vector3(), new Vector3()],
  // basis vectors
  e: []
  // half width
};
var b = {
  c: null,
  // center
  u: [new Vector3(), new Vector3(), new Vector3()],
  // basis vectors
  e: []
  // half width
};
var R = [[], [], []];
var AbsR = [[], [], []];
var t = [];
var xAxis = new Vector3();
var yAxis = new Vector3();
var zAxis = new Vector3();
var v12 = new Vector3();
var size = new Vector3();
var closestPoint = new Vector3();
var rotationMatrix = new Matrix3();
var aabb = new Box3();
var matrix3 = new Matrix4();
var inverse = new Matrix4();
var localRay = new Ray();
var OBB = class {
  constructor(center3 = new Vector3(), halfSize = new Vector3(), rotation3 = new Matrix3()) {
    this.center = center3;
    this.halfSize = halfSize;
    this.rotation = rotation3;
  }
  set(center3, halfSize, rotation3) {
    this.center = center3;
    this.halfSize = halfSize;
    this.rotation = rotation3;
    return this;
  }
  copy(obb26) {
    this.center.copy(obb26.center);
    this.halfSize.copy(obb26.halfSize);
    this.rotation.copy(obb26.rotation);
    return this;
  }
  clone() {
    return new this.constructor().copy(this);
  }
  getSize(result) {
    return result.copy(this.halfSize).multiplyScalar(2);
  }
  /**
   * Reference: Closest Point on OBB to Point in Real-Time Collision Detection
   * by Christer Ericson (chapter 5.1.4)
   */
  clampPoint(point, result) {
    const halfSize = this.halfSize;
    v12.subVectors(point, this.center);
    this.rotation.extractBasis(xAxis, yAxis, zAxis);
    result.copy(this.center);
    const x = MathUtils.clamp(v12.dot(xAxis), -halfSize.x, halfSize.x);
    result.add(xAxis.multiplyScalar(x));
    const y = MathUtils.clamp(v12.dot(yAxis), -halfSize.y, halfSize.y);
    result.add(yAxis.multiplyScalar(y));
    const z = MathUtils.clamp(v12.dot(zAxis), -halfSize.z, halfSize.z);
    result.add(zAxis.multiplyScalar(z));
    return result;
  }
  containsPoint(point) {
    v12.subVectors(point, this.center);
    this.rotation.extractBasis(xAxis, yAxis, zAxis);
    return Math.abs(v12.dot(xAxis)) <= this.halfSize.x && Math.abs(v12.dot(yAxis)) <= this.halfSize.y && Math.abs(v12.dot(zAxis)) <= this.halfSize.z;
  }
  intersectsBox3(box3) {
    return this.intersectsOBB(obb.fromBox3(box3));
  }
  intersectsSphere(sphere) {
    this.clampPoint(sphere.center, closestPoint);
    return closestPoint.distanceToSquared(sphere.center) <= sphere.radius * sphere.radius;
  }
  /**
   * Reference: OBB-OBB Intersection in Real-Time Collision Detection
   * by Christer Ericson (chapter 4.4.1)
   *
   */
  intersectsOBB(obb26, epsilon2 = Number.EPSILON) {
    a.c = this.center;
    a.e[0] = this.halfSize.x;
    a.e[1] = this.halfSize.y;
    a.e[2] = this.halfSize.z;
    this.rotation.extractBasis(a.u[0], a.u[1], a.u[2]);
    b.c = obb26.center;
    b.e[0] = obb26.halfSize.x;
    b.e[1] = obb26.halfSize.y;
    b.e[2] = obb26.halfSize.z;
    obb26.rotation.extractBasis(b.u[0], b.u[1], b.u[2]);
    for (let i4 = 0; i4 < 3; i4++) {
      for (let j = 0; j < 3; j++) {
        R[i4][j] = a.u[i4].dot(b.u[j]);
      }
    }
    v12.subVectors(b.c, a.c);
    t[0] = v12.dot(a.u[0]);
    t[1] = v12.dot(a.u[1]);
    t[2] = v12.dot(a.u[2]);
    for (let i4 = 0; i4 < 3; i4++) {
      for (let j = 0; j < 3; j++) {
        AbsR[i4][j] = Math.abs(R[i4][j]) + epsilon2;
      }
    }
    let ra, rb;
    for (let i4 = 0; i4 < 3; i4++) {
      ra = a.e[i4];
      rb = b.e[0] * AbsR[i4][0] + b.e[1] * AbsR[i4][1] + b.e[2] * AbsR[i4][2];
      if (Math.abs(t[i4]) > ra + rb)
        return false;
    }
    for (let i4 = 0; i4 < 3; i4++) {
      ra = a.e[0] * AbsR[0][i4] + a.e[1] * AbsR[1][i4] + a.e[2] * AbsR[2][i4];
      rb = b.e[i4];
      if (Math.abs(t[0] * R[0][i4] + t[1] * R[1][i4] + t[2] * R[2][i4]) > ra + rb)
        return false;
    }
    ra = a.e[1] * AbsR[2][0] + a.e[2] * AbsR[1][0];
    rb = b.e[1] * AbsR[0][2] + b.e[2] * AbsR[0][1];
    if (Math.abs(t[2] * R[1][0] - t[1] * R[2][0]) > ra + rb)
      return false;
    ra = a.e[1] * AbsR[2][1] + a.e[2] * AbsR[1][1];
    rb = b.e[0] * AbsR[0][2] + b.e[2] * AbsR[0][0];
    if (Math.abs(t[2] * R[1][1] - t[1] * R[2][1]) > ra + rb)
      return false;
    ra = a.e[1] * AbsR[2][2] + a.e[2] * AbsR[1][2];
    rb = b.e[0] * AbsR[0][1] + b.e[1] * AbsR[0][0];
    if (Math.abs(t[2] * R[1][2] - t[1] * R[2][2]) > ra + rb)
      return false;
    ra = a.e[0] * AbsR[2][0] + a.e[2] * AbsR[0][0];
    rb = b.e[1] * AbsR[1][2] + b.e[2] * AbsR[1][1];
    if (Math.abs(t[0] * R[2][0] - t[2] * R[0][0]) > ra + rb)
      return false;
    ra = a.e[0] * AbsR[2][1] + a.e[2] * AbsR[0][1];
    rb = b.e[0] * AbsR[1][2] + b.e[2] * AbsR[1][0];
    if (Math.abs(t[0] * R[2][1] - t[2] * R[0][1]) > ra + rb)
      return false;
    ra = a.e[0] * AbsR[2][2] + a.e[2] * AbsR[0][2];
    rb = b.e[0] * AbsR[1][1] + b.e[1] * AbsR[1][0];
    if (Math.abs(t[0] * R[2][2] - t[2] * R[0][2]) > ra + rb)
      return false;
    ra = a.e[0] * AbsR[1][0] + a.e[1] * AbsR[0][0];
    rb = b.e[1] * AbsR[2][2] + b.e[2] * AbsR[2][1];
    if (Math.abs(t[1] * R[0][0] - t[0] * R[1][0]) > ra + rb)
      return false;
    ra = a.e[0] * AbsR[1][1] + a.e[1] * AbsR[0][1];
    rb = b.e[0] * AbsR[2][2] + b.e[2] * AbsR[2][0];
    if (Math.abs(t[1] * R[0][1] - t[0] * R[1][1]) > ra + rb)
      return false;
    ra = a.e[0] * AbsR[1][2] + a.e[1] * AbsR[0][2];
    rb = b.e[0] * AbsR[2][1] + b.e[1] * AbsR[2][0];
    if (Math.abs(t[1] * R[0][2] - t[0] * R[1][2]) > ra + rb)
      return false;
    return true;
  }
  /**
   * Reference: Testing Box Against Plane in Real-Time Collision Detection
   * by Christer Ericson (chapter 5.2.3)
   */
  intersectsPlane(plane) {
    this.rotation.extractBasis(xAxis, yAxis, zAxis);
    const r2 = this.halfSize.x * Math.abs(plane.normal.dot(xAxis)) + this.halfSize.y * Math.abs(plane.normal.dot(yAxis)) + this.halfSize.z * Math.abs(plane.normal.dot(zAxis));
    const d2 = plane.normal.dot(this.center) - plane.constant;
    return Math.abs(d2) <= r2;
  }
  /**
   * Performs a ray/OBB intersection test and stores the intersection point
   * to the given 3D vector. If no intersection is detected, *null* is returned.
   */
  intersectRay(ray4, result) {
    this.getSize(size);
    aabb.setFromCenterAndSize(v12.set(0, 0, 0), size);
    matrix3.setFromMatrix3(this.rotation);
    matrix3.setPosition(this.center);
    inverse.copy(matrix3).invert();
    localRay.copy(ray4).applyMatrix4(inverse);
    if (localRay.intersectBox(aabb, result)) {
      return result.applyMatrix4(matrix3);
    } else {
      return null;
    }
  }
  /**
   * Performs a ray/OBB intersection test. Returns either true or false if
   * there is a intersection or not.
   */
  intersectsRay(ray4) {
    return this.intersectRay(ray4, v12) !== null;
  }
  fromBox3(box3) {
    box3.getCenter(this.center);
    box3.getSize(this.halfSize).multiplyScalar(0.5);
    this.rotation.identity();
    return this;
  }
  equals(obb26) {
    return obb26.center.equals(this.center) && obb26.halfSize.equals(this.halfSize) && obb26.rotation.equals(this.rotation);
  }
  applyMatrix4(matrix22) {
    const e2 = matrix22.elements;
    let sx = v12.set(e2[0], e2[1], e2[2]).length();
    const sy = v12.set(e2[4], e2[5], e2[6]).length();
    const sz = v12.set(e2[8], e2[9], e2[10]).length();
    const det = matrix22.determinant();
    if (det < 0)
      sx = -sx;
    rotationMatrix.setFromMatrix4(matrix22);
    const invSX = 1 / sx;
    const invSY = 1 / sy;
    const invSZ = 1 / sz;
    rotationMatrix.elements[0] *= invSX;
    rotationMatrix.elements[1] *= invSX;
    rotationMatrix.elements[2] *= invSX;
    rotationMatrix.elements[3] *= invSY;
    rotationMatrix.elements[4] *= invSY;
    rotationMatrix.elements[5] *= invSY;
    rotationMatrix.elements[6] *= invSZ;
    rotationMatrix.elements[7] *= invSZ;
    rotationMatrix.elements[8] *= invSZ;
    this.rotation.multiply(rotationMatrix);
    this.halfSize.x *= sx;
    this.halfSize.y *= sy;
    this.halfSize.z *= sz;
    v12.setFromMatrixPosition(matrix22);
    this.center.add(v12);
    return this;
  }
};
var obb = new OBB();

// node_modules/three-stdlib/math/Capsule.js
var _v13 = new Vector3();
var _v2 = new Vector3();
var _v3 = new Vector3();
var EPS = 1e-10;
var Capsule = class _Capsule {
  constructor(start = new Vector3(0, 0, 0), end = new Vector3(0, 1, 0), radius = 1) {
    this.start = start;
    this.end = end;
    this.radius = radius;
  }
  clone() {
    return new _Capsule(this.start.clone(), this.end.clone(), this.radius);
  }
  set(start, end, radius) {
    this.start.copy(start);
    this.end.copy(end);
    this.radius = radius;
  }
  copy(capsule) {
    this.start.copy(capsule.start);
    this.end.copy(capsule.end);
    this.radius = capsule.radius;
  }
  getCenter(target2) {
    return target2.copy(this.end).add(this.start).multiplyScalar(0.5);
  }
  translate(v5) {
    this.start.add(v5);
    this.end.add(v5);
  }
  checkAABBAxis(p1x, p1y, p2x, p2y, minx, maxx, miny, maxy, radius) {
    return (minx - p1x < radius || minx - p2x < radius) && (p1x - maxx < radius || p2x - maxx < radius) && (miny - p1y < radius || miny - p2y < radius) && (p1y - maxy < radius || p2y - maxy < radius);
  }
  intersectsBox(box) {
    return this.checkAABBAxis(
      this.start.x,
      this.start.y,
      this.end.x,
      this.end.y,
      box.min.x,
      box.max.x,
      box.min.y,
      box.max.y,
      this.radius
    ) && this.checkAABBAxis(
      this.start.x,
      this.start.z,
      this.end.x,
      this.end.z,
      box.min.x,
      box.max.x,
      box.min.z,
      box.max.z,
      this.radius
    ) && this.checkAABBAxis(
      this.start.y,
      this.start.z,
      this.end.y,
      this.end.z,
      box.min.y,
      box.max.y,
      box.min.z,
      box.max.z,
      this.radius
    );
  }
  lineLineMinimumPoints(line1, line2) {
    const r2 = _v13.copy(line1.end).sub(line1.start);
    const s2 = _v2.copy(line2.end).sub(line2.start);
    const w = _v3.copy(line2.start).sub(line1.start);
    const a6 = r2.dot(s2), b5 = r2.dot(r2), c2 = s2.dot(s2), d2 = s2.dot(w), e2 = r2.dot(w);
    let t1, t22;
    const divisor = b5 * c2 - a6 * a6;
    if (Math.abs(divisor) < EPS) {
      const d1 = -d2 / c2;
      const d22 = (a6 - d2) / c2;
      if (Math.abs(d1 - 0.5) < Math.abs(d22 - 0.5)) {
        t1 = 0;
        t22 = d1;
      } else {
        t1 = 1;
        t22 = d22;
      }
    } else {
      t1 = (d2 * a6 + e2 * c2) / divisor;
      t22 = (t1 * a6 - d2) / c2;
    }
    t22 = Math.max(0, Math.min(1, t22));
    t1 = Math.max(0, Math.min(1, t1));
    const point1 = r2.multiplyScalar(t1).add(line1.start);
    const point2 = s2.multiplyScalar(t22).add(line2.start);
    return [point1, point2];
  }
};

// node_modules/three-stdlib/math/ImprovedNoise.js
function init() {
  const _p2 = [
    151,
    160,
    137,
    91,
    90,
    15,
    131,
    13,
    201,
    95,
    96,
    53,
    194,
    233,
    7,
    225,
    140,
    36,
    103,
    30,
    69,
    142,
    8,
    99,
    37,
    240,
    21,
    10,
    23,
    190,
    6,
    148,
    247,
    120,
    234,
    75,
    0,
    26,
    197,
    62,
    94,
    252,
    219,
    203,
    117,
    35,
    11,
    32,
    57,
    177,
    33,
    88,
    237,
    149,
    56,
    87,
    174,
    20,
    125,
    136,
    171,
    168,
    68,
    175,
    74,
    165,
    71,
    134,
    139,
    48,
    27,
    166,
    77,
    146,
    158,
    231,
    83,
    111,
    229,
    122,
    60,
    211,
    133,
    230,
    220,
    105,
    92,
    41,
    55,
    46,
    245,
    40,
    244,
    102,
    143,
    54,
    65,
    25,
    63,
    161,
    1,
    216,
    80,
    73,
    209,
    76,
    132,
    187,
    208,
    89,
    18,
    169,
    200,
    196,
    135,
    130,
    116,
    188,
    159,
    86,
    164,
    100,
    109,
    198,
    173,
    186,
    3,
    64,
    52,
    217,
    226,
    250,
    124,
    123,
    5,
    202,
    38,
    147,
    118,
    126,
    255,
    82,
    85,
    212,
    207,
    206,
    59,
    227,
    47,
    16,
    58,
    17,
    182,
    189,
    28,
    42,
    223,
    183,
    170,
    213,
    119,
    248,
    152,
    2,
    44,
    154,
    163,
    70,
    221,
    153,
    101,
    155,
    167,
    43,
    172,
    9,
    129,
    22,
    39,
    253,
    19,
    98,
    108,
    110,
    79,
    113,
    224,
    232,
    178,
    185,
    112,
    104,
    218,
    246,
    97,
    228,
    251,
    34,
    242,
    193,
    238,
    210,
    144,
    12,
    191,
    179,
    162,
    241,
    81,
    51,
    145,
    235,
    249,
    14,
    239,
    107,
    49,
    192,
    214,
    31,
    181,
    199,
    106,
    157,
    184,
    84,
    204,
    176,
    115,
    121,
    50,
    45,
    127,
    4,
    150,
    254,
    138,
    236,
    205,
    93,
    222,
    114,
    67,
    29,
    24,
    72,
    243,
    141,
    128,
    195,
    78,
    66,
    215,
    61,
    156,
    180
  ];
  for (let i4 = 0; i4 < 256; i4++) {
    _p2[256 + i4] = _p2[i4];
  }
  return _p2;
}
var _p = init();

// node_modules/three-stdlib/math/Octree.js
var _v14 = new Vector3();
var _v22 = new Vector3();
var _plane2 = new Plane();
var _line1 = new Line3();
var _line2 = new Line3();
var _sphere = new Sphere();
var _capsule = new Capsule();

// node_modules/three-stdlib/controls/EventDispatcher.js
var __defProp11 = Object.defineProperty;
var __defNormalProp11 = (obj, key, value) => key in obj ? __defProp11(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField12 = (obj, key, value) => {
  __defNormalProp11(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var EventDispatcher2 = class {
  constructor() {
    __publicField12(this, "_listeners");
  }
  /**
   * Adds a listener to an event type.
   * @param type The type of event to listen to.
   * @param listener The function that gets called when the event is fired.
   */
  addEventListener(type, listener) {
    if (this._listeners === void 0)
      this._listeners = {};
    const listeners = this._listeners;
    if (listeners[type] === void 0) {
      listeners[type] = [];
    }
    if (listeners[type].indexOf(listener) === -1) {
      listeners[type].push(listener);
    }
  }
  /**
      * Checks if listener is added to an event type.
      * @param type The type of event to listen to.
      * @param listener The function that gets called when the event is fired.
      */
  hasEventListener(type, listener) {
    if (this._listeners === void 0)
      return false;
    const listeners = this._listeners;
    return listeners[type] !== void 0 && listeners[type].indexOf(listener) !== -1;
  }
  /**
      * Removes a listener from an event type.
      * @param type The type of the listener that gets removed.
      * @param listener The listener function that gets removed.
      */
  removeEventListener(type, listener) {
    if (this._listeners === void 0)
      return;
    const listeners = this._listeners;
    const listenerArray = listeners[type];
    if (listenerArray !== void 0) {
      const index2 = listenerArray.indexOf(listener);
      if (index2 !== -1) {
        listenerArray.splice(index2, 1);
      }
    }
  }
  /**
      * Fire an event type.
      * @param event The event that gets fired.
      */
  dispatchEvent(event) {
    if (this._listeners === void 0)
      return;
    const listeners = this._listeners;
    const listenerArray = listeners[event.type];
    if (listenerArray !== void 0) {
      event.target = this;
      const array = listenerArray.slice(0);
      for (let i4 = 0, l2 = array.length; i4 < l2; i4++) {
        array[i4].call(this, event);
      }
      event.target = null;
    }
  }
};

// node_modules/three-stdlib/controls/FirstPersonControls.js
var __defProp12 = Object.defineProperty;
var __defNormalProp12 = (obj, key, value) => key in obj ? __defProp12(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField13 = (obj, key, value) => {
  __defNormalProp12(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var targetPosition = new Vector3();
var FirstPersonControls = class extends EventDispatcher2 {
  constructor(object, domElement) {
    super();
    __publicField13(this, "object");
    __publicField13(this, "domElement");
    __publicField13(this, "enabled", true);
    __publicField13(this, "movementSpeed", 1);
    __publicField13(this, "lookSpeed", 5e-3);
    __publicField13(this, "lookVertical", true);
    __publicField13(this, "autoForward", false);
    __publicField13(this, "activeLook", true);
    __publicField13(this, "heightSpeed", false);
    __publicField13(this, "heightCoef", 1);
    __publicField13(this, "heightMin", 0);
    __publicField13(this, "heightMax", 1);
    __publicField13(this, "constrainVertical", false);
    __publicField13(this, "verticalMin", 0);
    __publicField13(this, "verticalMax", Math.PI);
    __publicField13(this, "mouseDragOn", false);
    __publicField13(this, "autoSpeedFactor", 0);
    __publicField13(this, "mouseX", 0);
    __publicField13(this, "mouseY", 0);
    __publicField13(this, "moveForward", false);
    __publicField13(this, "moveBackward", false);
    __publicField13(this, "moveLeft", false);
    __publicField13(this, "moveRight", false);
    __publicField13(this, "moveUp", false);
    __publicField13(this, "moveDown", false);
    __publicField13(this, "viewHalfX", 0);
    __publicField13(this, "viewHalfY", 0);
    __publicField13(this, "lat", 0);
    __publicField13(this, "lon", 0);
    __publicField13(this, "lookDirection", new Vector3());
    __publicField13(this, "spherical", new Spherical());
    __publicField13(this, "target", new Vector3());
    __publicField13(this, "connect", (domElement2) => {
      domElement2.setAttribute("tabindex", "-1");
      domElement2.style.touchAction = "none";
      domElement2.addEventListener("contextmenu", this.contextmenu);
      domElement2.addEventListener("mousemove", this.onMouseMove);
      domElement2.addEventListener("mousedown", this.onMouseDown);
      domElement2.addEventListener("mouseup", this.onMouseUp);
      this.domElement = domElement2;
      window.addEventListener("keydown", this.onKeyDown);
      window.addEventListener("keyup", this.onKeyUp);
      this.handleResize();
    });
    __publicField13(this, "dispose", () => {
      var _a4, _b3, _c, _d;
      (_a4 = this.domElement) == null ? void 0 : _a4.removeEventListener("contextmenu", this.contextmenu);
      (_b3 = this.domElement) == null ? void 0 : _b3.removeEventListener("mousedown", this.onMouseDown);
      (_c = this.domElement) == null ? void 0 : _c.removeEventListener("mousemove", this.onMouseMove);
      (_d = this.domElement) == null ? void 0 : _d.removeEventListener("mouseup", this.onMouseUp);
      window.removeEventListener("keydown", this.onKeyDown);
      window.removeEventListener("keyup", this.onKeyUp);
    });
    __publicField13(this, "handleResize", () => {
      if (this.domElement) {
        this.viewHalfX = this.domElement.offsetWidth / 2;
        this.viewHalfY = this.domElement.offsetHeight / 2;
      }
    });
    __publicField13(this, "onMouseDown", (event) => {
      var _a4;
      (_a4 = this.domElement) == null ? void 0 : _a4.focus();
      if (this.activeLook) {
        switch (event.button) {
          case 0:
            this.moveForward = true;
            break;
          case 2:
            this.moveBackward = true;
            break;
        }
      }
      this.mouseDragOn = true;
    });
    __publicField13(this, "onMouseUp", (event) => {
      if (this.activeLook) {
        switch (event.button) {
          case 0:
            this.moveForward = false;
            break;
          case 2:
            this.moveBackward = false;
            break;
        }
      }
      this.mouseDragOn = false;
    });
    __publicField13(this, "onMouseMove", (event) => {
      if (this.domElement) {
        this.mouseX = event.pageX - this.domElement.offsetLeft - this.viewHalfX;
        this.mouseY = event.pageY - this.domElement.offsetTop - this.viewHalfY;
      }
    });
    __publicField13(this, "onKeyDown", (event) => {
      switch (event.code) {
        case "ArrowUp":
        case "KeyW":
          this.moveForward = true;
          break;
        case "ArrowLeft":
        case "KeyA":
          this.moveLeft = true;
          break;
        case "ArrowDown":
        case "KeyS":
          this.moveBackward = true;
          break;
        case "ArrowRight":
        case "KeyD":
          this.moveRight = true;
          break;
        case "KeyR":
          this.moveUp = true;
          break;
        case "KeyF":
          this.moveDown = true;
          break;
      }
    });
    __publicField13(this, "onKeyUp", (event) => {
      switch (event.code) {
        case "ArrowUp":
        case "KeyW":
          this.moveForward = false;
          break;
        case "ArrowLeft":
        case "KeyA":
          this.moveLeft = false;
          break;
        case "ArrowDown":
        case "KeyS":
          this.moveBackward = false;
          break;
        case "ArrowRight":
        case "KeyD":
          this.moveRight = false;
          break;
        case "KeyR":
          this.moveUp = false;
          break;
        case "KeyF":
          this.moveDown = false;
          break;
      }
    });
    __publicField13(this, "lookAt", (x, y, z) => {
      if (x instanceof Vector3) {
        this.target.copy(x);
      } else if (y && z) {
        this.target.set(x, y, z);
      }
      this.object.lookAt(this.target);
      this.setOrientation();
      return this;
    });
    __publicField13(this, "update", (delta) => {
      if (!this.enabled)
        return;
      if (this.heightSpeed) {
        const y = MathUtils.clamp(this.object.position.y, this.heightMin, this.heightMax);
        const heightDelta = y - this.heightMin;
        this.autoSpeedFactor = delta * (heightDelta * this.heightCoef);
      } else {
        this.autoSpeedFactor = 0;
      }
      const actualMoveSpeed = delta * this.movementSpeed;
      if (this.moveForward || this.autoForward && !this.moveBackward) {
        this.object.translateZ(-(actualMoveSpeed + this.autoSpeedFactor));
      }
      if (this.moveBackward)
        this.object.translateZ(actualMoveSpeed);
      if (this.moveLeft)
        this.object.translateX(-actualMoveSpeed);
      if (this.moveRight)
        this.object.translateX(actualMoveSpeed);
      if (this.moveUp)
        this.object.translateY(actualMoveSpeed);
      if (this.moveDown)
        this.object.translateY(-actualMoveSpeed);
      let actualLookSpeed = delta * this.lookSpeed;
      if (!this.activeLook) {
        actualLookSpeed = 0;
      }
      let verticalLookRatio = 1;
      if (this.constrainVertical) {
        verticalLookRatio = Math.PI / (this.verticalMax - this.verticalMin);
      }
      this.lon -= this.mouseX * actualLookSpeed;
      if (this.lookVertical)
        this.lat -= this.mouseY * actualLookSpeed * verticalLookRatio;
      this.lat = Math.max(-85, Math.min(85, this.lat));
      let phi = MathUtils.degToRad(90 - this.lat);
      const theta = MathUtils.degToRad(this.lon);
      if (this.constrainVertical) {
        phi = MathUtils.mapLinear(phi, 0, Math.PI, this.verticalMin, this.verticalMax);
      }
      const position2 = this.object.position;
      targetPosition.setFromSphericalCoords(1, phi, theta).add(position2);
      this.object.lookAt(targetPosition);
    });
    __publicField13(this, "contextmenu", (event) => event.preventDefault());
    __publicField13(this, "setOrientation", () => {
      this.lookDirection.set(0, 0, -1).applyQuaternion(this.object.quaternion);
      this.spherical.setFromVector3(this.lookDirection);
      this.lat = 90 - MathUtils.radToDeg(this.spherical.phi);
      this.lon = MathUtils.radToDeg(this.spherical.theta);
    });
    this.object = object;
    this.domElement = domElement;
    this.setOrientation();
    if (domElement)
      this.connect(domElement);
  }
};

// node_modules/three-stdlib/controls/TransformControls.js
var __defProp13 = Object.defineProperty;
var __defNormalProp13 = (obj, key, value) => key in obj ? __defProp13(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField14 = (obj, key, value) => {
  __defNormalProp13(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var TransformControls = class extends Object3D {
  constructor(camera, domElement) {
    super();
    __publicField14(this, "isTransformControls", true);
    __publicField14(this, "visible", false);
    __publicField14(this, "domElement");
    __publicField14(this, "raycaster", new Raycaster());
    __publicField14(this, "gizmo");
    __publicField14(this, "plane");
    __publicField14(this, "tempVector", new Vector3());
    __publicField14(this, "tempVector2", new Vector3());
    __publicField14(this, "tempQuaternion", new Quaternion());
    __publicField14(this, "unit", {
      X: new Vector3(1, 0, 0),
      Y: new Vector3(0, 1, 0),
      Z: new Vector3(0, 0, 1)
    });
    __publicField14(this, "pointStart", new Vector3());
    __publicField14(this, "pointEnd", new Vector3());
    __publicField14(this, "offset", new Vector3());
    __publicField14(this, "rotationAxis", new Vector3());
    __publicField14(this, "startNorm", new Vector3());
    __publicField14(this, "endNorm", new Vector3());
    __publicField14(this, "rotationAngle", 0);
    __publicField14(this, "cameraPosition", new Vector3());
    __publicField14(this, "cameraQuaternion", new Quaternion());
    __publicField14(this, "cameraScale", new Vector3());
    __publicField14(this, "parentPosition", new Vector3());
    __publicField14(this, "parentQuaternion", new Quaternion());
    __publicField14(this, "parentQuaternionInv", new Quaternion());
    __publicField14(this, "parentScale", new Vector3());
    __publicField14(this, "worldPositionStart", new Vector3());
    __publicField14(this, "worldQuaternionStart", new Quaternion());
    __publicField14(this, "worldScaleStart", new Vector3());
    __publicField14(this, "worldPosition", new Vector3());
    __publicField14(this, "worldQuaternion", new Quaternion());
    __publicField14(this, "worldQuaternionInv", new Quaternion());
    __publicField14(this, "worldScale", new Vector3());
    __publicField14(this, "eye", new Vector3());
    __publicField14(this, "positionStart", new Vector3());
    __publicField14(this, "quaternionStart", new Quaternion());
    __publicField14(this, "scaleStart", new Vector3());
    __publicField14(this, "camera");
    __publicField14(this, "object");
    __publicField14(this, "enabled", true);
    __publicField14(this, "axis", null);
    __publicField14(this, "mode", "translate");
    __publicField14(this, "translationSnap", null);
    __publicField14(this, "rotationSnap", null);
    __publicField14(this, "scaleSnap", null);
    __publicField14(this, "space", "world");
    __publicField14(this, "size", 1);
    __publicField14(this, "dragging", false);
    __publicField14(this, "showX", true);
    __publicField14(this, "showY", true);
    __publicField14(this, "showZ", true);
    __publicField14(this, "changeEvent", { type: "change" });
    __publicField14(this, "mouseDownEvent", { type: "mouseDown", mode: this.mode });
    __publicField14(this, "mouseUpEvent", { type: "mouseUp", mode: this.mode });
    __publicField14(this, "objectChangeEvent", { type: "objectChange" });
    __publicField14(this, "intersectObjectWithRay", (object, raycaster, includeInvisible) => {
      const allIntersections = raycaster.intersectObject(object, true);
      for (let i4 = 0; i4 < allIntersections.length; i4++) {
        if (allIntersections[i4].object.visible || includeInvisible) {
          return allIntersections[i4];
        }
      }
      return false;
    });
    __publicField14(this, "attach", (object) => {
      this.object = object;
      this.visible = true;
      return this;
    });
    __publicField14(this, "detach", () => {
      this.object = void 0;
      this.visible = false;
      this.axis = null;
      return this;
    });
    __publicField14(this, "reset", () => {
      if (!this.enabled)
        return this;
      if (this.dragging) {
        if (this.object !== void 0) {
          this.object.position.copy(this.positionStart);
          this.object.quaternion.copy(this.quaternionStart);
          this.object.scale.copy(this.scaleStart);
          this.dispatchEvent(this.changeEvent);
          this.dispatchEvent(this.objectChangeEvent);
          this.pointStart.copy(this.pointEnd);
        }
      }
      return this;
    });
    __publicField14(this, "updateMatrixWorld", () => {
      if (this.object !== void 0) {
        this.object.updateMatrixWorld();
        if (this.object.parent === null) {
          console.error("TransformControls: The attached 3D object must be a part of the scene graph.");
        } else {
          this.object.parent.matrixWorld.decompose(this.parentPosition, this.parentQuaternion, this.parentScale);
        }
        this.object.matrixWorld.decompose(this.worldPosition, this.worldQuaternion, this.worldScale);
        this.parentQuaternionInv.copy(this.parentQuaternion).invert();
        this.worldQuaternionInv.copy(this.worldQuaternion).invert();
      }
      this.camera.updateMatrixWorld();
      this.camera.matrixWorld.decompose(this.cameraPosition, this.cameraQuaternion, this.cameraScale);
      this.eye.copy(this.cameraPosition).sub(this.worldPosition).normalize();
      super.updateMatrixWorld();
    });
    __publicField14(this, "pointerHover", (pointer) => {
      if (this.object === void 0 || this.dragging === true)
        return;
      this.raycaster.setFromCamera(pointer, this.camera);
      const intersect = this.intersectObjectWithRay(this.gizmo.picker[this.mode], this.raycaster);
      if (intersect) {
        this.axis = intersect.object.name;
      } else {
        this.axis = null;
      }
    });
    __publicField14(this, "pointerDown", (pointer) => {
      if (this.object === void 0 || this.dragging === true || pointer.button !== 0)
        return;
      if (this.axis !== null) {
        this.raycaster.setFromCamera(pointer, this.camera);
        const planeIntersect = this.intersectObjectWithRay(this.plane, this.raycaster, true);
        if (planeIntersect) {
          let space = this.space;
          if (this.mode === "scale") {
            space = "local";
          } else if (this.axis === "E" || this.axis === "XYZE" || this.axis === "XYZ") {
            space = "world";
          }
          if (space === "local" && this.mode === "rotate") {
            const snap = this.rotationSnap;
            if (this.axis === "X" && snap)
              this.object.rotation.x = Math.round(this.object.rotation.x / snap) * snap;
            if (this.axis === "Y" && snap)
              this.object.rotation.y = Math.round(this.object.rotation.y / snap) * snap;
            if (this.axis === "Z" && snap)
              this.object.rotation.z = Math.round(this.object.rotation.z / snap) * snap;
          }
          this.object.updateMatrixWorld();
          if (this.object.parent) {
            this.object.parent.updateMatrixWorld();
          }
          this.positionStart.copy(this.object.position);
          this.quaternionStart.copy(this.object.quaternion);
          this.scaleStart.copy(this.object.scale);
          this.object.matrixWorld.decompose(this.worldPositionStart, this.worldQuaternionStart, this.worldScaleStart);
          this.pointStart.copy(planeIntersect.point).sub(this.worldPositionStart);
        }
        this.dragging = true;
        this.mouseDownEvent.mode = this.mode;
        this.dispatchEvent(this.mouseDownEvent);
      }
    });
    __publicField14(this, "pointerMove", (pointer) => {
      const axis = this.axis;
      const mode = this.mode;
      const object = this.object;
      let space = this.space;
      if (mode === "scale") {
        space = "local";
      } else if (axis === "E" || axis === "XYZE" || axis === "XYZ") {
        space = "world";
      }
      if (object === void 0 || axis === null || this.dragging === false || pointer.button !== -1)
        return;
      this.raycaster.setFromCamera(pointer, this.camera);
      const planeIntersect = this.intersectObjectWithRay(this.plane, this.raycaster, true);
      if (!planeIntersect)
        return;
      this.pointEnd.copy(planeIntersect.point).sub(this.worldPositionStart);
      if (mode === "translate") {
        this.offset.copy(this.pointEnd).sub(this.pointStart);
        if (space === "local" && axis !== "XYZ") {
          this.offset.applyQuaternion(this.worldQuaternionInv);
        }
        if (axis.indexOf("X") === -1)
          this.offset.x = 0;
        if (axis.indexOf("Y") === -1)
          this.offset.y = 0;
        if (axis.indexOf("Z") === -1)
          this.offset.z = 0;
        if (space === "local" && axis !== "XYZ") {
          this.offset.applyQuaternion(this.quaternionStart).divide(this.parentScale);
        } else {
          this.offset.applyQuaternion(this.parentQuaternionInv).divide(this.parentScale);
        }
        object.position.copy(this.offset).add(this.positionStart);
        if (this.translationSnap) {
          if (space === "local") {
            object.position.applyQuaternion(this.tempQuaternion.copy(this.quaternionStart).invert());
            if (axis.search("X") !== -1) {
              object.position.x = Math.round(object.position.x / this.translationSnap) * this.translationSnap;
            }
            if (axis.search("Y") !== -1) {
              object.position.y = Math.round(object.position.y / this.translationSnap) * this.translationSnap;
            }
            if (axis.search("Z") !== -1) {
              object.position.z = Math.round(object.position.z / this.translationSnap) * this.translationSnap;
            }
            object.position.applyQuaternion(this.quaternionStart);
          }
          if (space === "world") {
            if (object.parent) {
              object.position.add(this.tempVector.setFromMatrixPosition(object.parent.matrixWorld));
            }
            if (axis.search("X") !== -1) {
              object.position.x = Math.round(object.position.x / this.translationSnap) * this.translationSnap;
            }
            if (axis.search("Y") !== -1) {
              object.position.y = Math.round(object.position.y / this.translationSnap) * this.translationSnap;
            }
            if (axis.search("Z") !== -1) {
              object.position.z = Math.round(object.position.z / this.translationSnap) * this.translationSnap;
            }
            if (object.parent) {
              object.position.sub(this.tempVector.setFromMatrixPosition(object.parent.matrixWorld));
            }
          }
        }
      } else if (mode === "scale") {
        if (axis.search("XYZ") !== -1) {
          let d2 = this.pointEnd.length() / this.pointStart.length();
          if (this.pointEnd.dot(this.pointStart) < 0)
            d2 *= -1;
          this.tempVector2.set(d2, d2, d2);
        } else {
          this.tempVector.copy(this.pointStart);
          this.tempVector2.copy(this.pointEnd);
          this.tempVector.applyQuaternion(this.worldQuaternionInv);
          this.tempVector2.applyQuaternion(this.worldQuaternionInv);
          this.tempVector2.divide(this.tempVector);
          if (axis.search("X") === -1) {
            this.tempVector2.x = 1;
          }
          if (axis.search("Y") === -1) {
            this.tempVector2.y = 1;
          }
          if (axis.search("Z") === -1) {
            this.tempVector2.z = 1;
          }
        }
        object.scale.copy(this.scaleStart).multiply(this.tempVector2);
        if (this.scaleSnap && this.object) {
          if (axis.search("X") !== -1) {
            this.object.scale.x = Math.round(object.scale.x / this.scaleSnap) * this.scaleSnap || this.scaleSnap;
          }
          if (axis.search("Y") !== -1) {
            object.scale.y = Math.round(object.scale.y / this.scaleSnap) * this.scaleSnap || this.scaleSnap;
          }
          if (axis.search("Z") !== -1) {
            object.scale.z = Math.round(object.scale.z / this.scaleSnap) * this.scaleSnap || this.scaleSnap;
          }
        }
      } else if (mode === "rotate") {
        this.offset.copy(this.pointEnd).sub(this.pointStart);
        const ROTATION_SPEED = 20 / this.worldPosition.distanceTo(this.tempVector.setFromMatrixPosition(this.camera.matrixWorld));
        if (axis === "E") {
          this.rotationAxis.copy(this.eye);
          this.rotationAngle = this.pointEnd.angleTo(this.pointStart);
          this.startNorm.copy(this.pointStart).normalize();
          this.endNorm.copy(this.pointEnd).normalize();
          this.rotationAngle *= this.endNorm.cross(this.startNorm).dot(this.eye) < 0 ? 1 : -1;
        } else if (axis === "XYZE") {
          this.rotationAxis.copy(this.offset).cross(this.eye).normalize();
          this.rotationAngle = this.offset.dot(this.tempVector.copy(this.rotationAxis).cross(this.eye)) * ROTATION_SPEED;
        } else if (axis === "X" || axis === "Y" || axis === "Z") {
          this.rotationAxis.copy(this.unit[axis]);
          this.tempVector.copy(this.unit[axis]);
          if (space === "local") {
            this.tempVector.applyQuaternion(this.worldQuaternion);
          }
          this.rotationAngle = this.offset.dot(this.tempVector.cross(this.eye).normalize()) * ROTATION_SPEED;
        }
        if (this.rotationSnap) {
          this.rotationAngle = Math.round(this.rotationAngle / this.rotationSnap) * this.rotationSnap;
        }
        if (space === "local" && axis !== "E" && axis !== "XYZE") {
          object.quaternion.copy(this.quaternionStart);
          object.quaternion.multiply(this.tempQuaternion.setFromAxisAngle(this.rotationAxis, this.rotationAngle)).normalize();
        } else {
          this.rotationAxis.applyQuaternion(this.parentQuaternionInv);
          object.quaternion.copy(this.tempQuaternion.setFromAxisAngle(this.rotationAxis, this.rotationAngle));
          object.quaternion.multiply(this.quaternionStart).normalize();
        }
      }
      this.dispatchEvent(this.changeEvent);
      this.dispatchEvent(this.objectChangeEvent);
    });
    __publicField14(this, "pointerUp", (pointer) => {
      if (pointer.button !== 0)
        return;
      if (this.dragging && this.axis !== null) {
        this.mouseUpEvent.mode = this.mode;
        this.dispatchEvent(this.mouseUpEvent);
      }
      this.dragging = false;
      this.axis = null;
    });
    __publicField14(this, "getPointer", (event) => {
      var _a4;
      if (this.domElement && ((_a4 = this.domElement.ownerDocument) == null ? void 0 : _a4.pointerLockElement)) {
        return {
          x: 0,
          y: 0,
          button: event.button
        };
      } else {
        const pointer = event.changedTouches ? event.changedTouches[0] : event;
        const rect = this.domElement.getBoundingClientRect();
        return {
          x: (pointer.clientX - rect.left) / rect.width * 2 - 1,
          y: -(pointer.clientY - rect.top) / rect.height * 2 + 1,
          button: event.button
        };
      }
    });
    __publicField14(this, "onPointerHover", (event) => {
      if (!this.enabled)
        return;
      switch (event.pointerType) {
        case "mouse":
        case "pen":
          this.pointerHover(this.getPointer(event));
          break;
      }
    });
    __publicField14(this, "onPointerDown", (event) => {
      if (!this.enabled || !this.domElement)
        return;
      this.domElement.style.touchAction = "none";
      this.domElement.ownerDocument.addEventListener("pointermove", this.onPointerMove);
      this.pointerHover(this.getPointer(event));
      this.pointerDown(this.getPointer(event));
    });
    __publicField14(this, "onPointerMove", (event) => {
      if (!this.enabled)
        return;
      this.pointerMove(this.getPointer(event));
    });
    __publicField14(this, "onPointerUp", (event) => {
      if (!this.enabled || !this.domElement)
        return;
      this.domElement.style.touchAction = "";
      this.domElement.ownerDocument.removeEventListener("pointermove", this.onPointerMove);
      this.pointerUp(this.getPointer(event));
    });
    __publicField14(this, "getMode", () => this.mode);
    __publicField14(this, "setMode", (mode) => {
      this.mode = mode;
    });
    __publicField14(this, "setTranslationSnap", (translationSnap) => {
      this.translationSnap = translationSnap;
    });
    __publicField14(this, "setRotationSnap", (rotationSnap) => {
      this.rotationSnap = rotationSnap;
    });
    __publicField14(this, "setScaleSnap", (scaleSnap) => {
      this.scaleSnap = scaleSnap;
    });
    __publicField14(this, "setSize", (size2) => {
      this.size = size2;
    });
    __publicField14(this, "setSpace", (space) => {
      this.space = space;
    });
    __publicField14(this, "update", () => {
      console.warn(
        "THREE.TransformControls: update function has no more functionality and therefore has been deprecated."
      );
    });
    __publicField14(this, "connect", (domElement2) => {
      if (domElement2 === document) {
        console.error(
          'THREE.OrbitControls: "document" should not be used as the target "domElement". Please use "renderer.domElement" instead.'
        );
      }
      this.domElement = domElement2;
      this.domElement.addEventListener("pointerdown", this.onPointerDown);
      this.domElement.addEventListener("pointermove", this.onPointerHover);
      this.domElement.ownerDocument.addEventListener("pointerup", this.onPointerUp);
    });
    __publicField14(this, "dispose", () => {
      var _a4, _b3, _c, _d, _e, _f;
      (_a4 = this.domElement) == null ? void 0 : _a4.removeEventListener("pointerdown", this.onPointerDown);
      (_b3 = this.domElement) == null ? void 0 : _b3.removeEventListener("pointermove", this.onPointerHover);
      (_d = (_c = this.domElement) == null ? void 0 : _c.ownerDocument) == null ? void 0 : _d.removeEventListener("pointermove", this.onPointerMove);
      (_f = (_e = this.domElement) == null ? void 0 : _e.ownerDocument) == null ? void 0 : _f.removeEventListener("pointerup", this.onPointerUp);
      this.traverse((child) => {
        const mesh = child;
        if (mesh.geometry) {
          mesh.geometry.dispose();
        }
        if (mesh.material) {
          mesh.material.dispose();
        }
      });
    });
    this.domElement = domElement;
    this.camera = camera;
    this.gizmo = new TransformControlsGizmo();
    this.add(this.gizmo);
    this.plane = new TransformControlsPlane();
    this.add(this.plane);
    const defineProperty = (propName, defaultValue) => {
      let propValue = defaultValue;
      Object.defineProperty(this, propName, {
        get: function() {
          return propValue !== void 0 ? propValue : defaultValue;
        },
        set: function(value) {
          if (propValue !== value) {
            propValue = value;
            this.plane[propName] = value;
            this.gizmo[propName] = value;
            this.dispatchEvent({ type: propName + "-changed", value });
            this.dispatchEvent(this.changeEvent);
          }
        }
      });
      this[propName] = defaultValue;
      this.plane[propName] = defaultValue;
      this.gizmo[propName] = defaultValue;
    };
    defineProperty("camera", this.camera);
    defineProperty("object", this.object);
    defineProperty("enabled", this.enabled);
    defineProperty("axis", this.axis);
    defineProperty("mode", this.mode);
    defineProperty("translationSnap", this.translationSnap);
    defineProperty("rotationSnap", this.rotationSnap);
    defineProperty("scaleSnap", this.scaleSnap);
    defineProperty("space", this.space);
    defineProperty("size", this.size);
    defineProperty("dragging", this.dragging);
    defineProperty("showX", this.showX);
    defineProperty("showY", this.showY);
    defineProperty("showZ", this.showZ);
    defineProperty("worldPosition", this.worldPosition);
    defineProperty("worldPositionStart", this.worldPositionStart);
    defineProperty("worldQuaternion", this.worldQuaternion);
    defineProperty("worldQuaternionStart", this.worldQuaternionStart);
    defineProperty("cameraPosition", this.cameraPosition);
    defineProperty("cameraQuaternion", this.cameraQuaternion);
    defineProperty("pointStart", this.pointStart);
    defineProperty("pointEnd", this.pointEnd);
    defineProperty("rotationAxis", this.rotationAxis);
    defineProperty("rotationAngle", this.rotationAngle);
    defineProperty("eye", this.eye);
    if (domElement !== void 0)
      this.connect(domElement);
  }
};
var TransformControlsGizmo = class extends Object3D {
  constructor() {
    super();
    __publicField14(this, "isTransformControlsGizmo", true);
    __publicField14(this, "type", "TransformControlsGizmo");
    __publicField14(this, "tempVector", new Vector3(0, 0, 0));
    __publicField14(this, "tempEuler", new Euler());
    __publicField14(this, "alignVector", new Vector3(0, 1, 0));
    __publicField14(this, "zeroVector", new Vector3(0, 0, 0));
    __publicField14(this, "lookAtMatrix", new Matrix4());
    __publicField14(this, "tempQuaternion", new Quaternion());
    __publicField14(this, "tempQuaternion2", new Quaternion());
    __publicField14(this, "identityQuaternion", new Quaternion());
    __publicField14(this, "unitX", new Vector3(1, 0, 0));
    __publicField14(this, "unitY", new Vector3(0, 1, 0));
    __publicField14(this, "unitZ", new Vector3(0, 0, 1));
    __publicField14(this, "gizmo");
    __publicField14(this, "picker");
    __publicField14(this, "helper");
    __publicField14(this, "rotationAxis", new Vector3());
    __publicField14(this, "cameraPosition", new Vector3());
    __publicField14(this, "worldPositionStart", new Vector3());
    __publicField14(this, "worldQuaternionStart", new Quaternion());
    __publicField14(this, "worldPosition", new Vector3());
    __publicField14(this, "worldQuaternion", new Quaternion());
    __publicField14(this, "eye", new Vector3());
    __publicField14(this, "camera", null);
    __publicField14(this, "enabled", true);
    __publicField14(this, "axis", null);
    __publicField14(this, "mode", "translate");
    __publicField14(this, "space", "world");
    __publicField14(this, "size", 1);
    __publicField14(this, "dragging", false);
    __publicField14(this, "showX", true);
    __publicField14(this, "showY", true);
    __publicField14(this, "showZ", true);
    __publicField14(this, "updateMatrixWorld", () => {
      let space = this.space;
      if (this.mode === "scale") {
        space = "local";
      }
      const quaternion = space === "local" ? this.worldQuaternion : this.identityQuaternion;
      this.gizmo["translate"].visible = this.mode === "translate";
      this.gizmo["rotate"].visible = this.mode === "rotate";
      this.gizmo["scale"].visible = this.mode === "scale";
      this.helper["translate"].visible = this.mode === "translate";
      this.helper["rotate"].visible = this.mode === "rotate";
      this.helper["scale"].visible = this.mode === "scale";
      let handles = [];
      handles = handles.concat(this.picker[this.mode].children);
      handles = handles.concat(this.gizmo[this.mode].children);
      handles = handles.concat(this.helper[this.mode].children);
      for (let i4 = 0; i4 < handles.length; i4++) {
        const handle = handles[i4];
        handle.visible = true;
        handle.rotation.set(0, 0, 0);
        handle.position.copy(this.worldPosition);
        let factor;
        if (this.camera.isOrthographicCamera) {
          factor = (this.camera.top - this.camera.bottom) / this.camera.zoom;
        } else {
          factor = this.worldPosition.distanceTo(this.cameraPosition) * Math.min(1.9 * Math.tan(Math.PI * this.camera.fov / 360) / this.camera.zoom, 7);
        }
        handle.scale.set(1, 1, 1).multiplyScalar(factor * this.size / 7);
        if (handle.tag === "helper") {
          handle.visible = false;
          if (handle.name === "AXIS") {
            handle.position.copy(this.worldPositionStart);
            handle.visible = !!this.axis;
            if (this.axis === "X") {
              this.tempQuaternion.setFromEuler(this.tempEuler.set(0, 0, 0));
              handle.quaternion.copy(quaternion).multiply(this.tempQuaternion);
              if (Math.abs(this.alignVector.copy(this.unitX).applyQuaternion(quaternion).dot(this.eye)) > 0.9) {
                handle.visible = false;
              }
            }
            if (this.axis === "Y") {
              this.tempQuaternion.setFromEuler(this.tempEuler.set(0, 0, Math.PI / 2));
              handle.quaternion.copy(quaternion).multiply(this.tempQuaternion);
              if (Math.abs(this.alignVector.copy(this.unitY).applyQuaternion(quaternion).dot(this.eye)) > 0.9) {
                handle.visible = false;
              }
            }
            if (this.axis === "Z") {
              this.tempQuaternion.setFromEuler(this.tempEuler.set(0, Math.PI / 2, 0));
              handle.quaternion.copy(quaternion).multiply(this.tempQuaternion);
              if (Math.abs(this.alignVector.copy(this.unitZ).applyQuaternion(quaternion).dot(this.eye)) > 0.9) {
                handle.visible = false;
              }
            }
            if (this.axis === "XYZE") {
              this.tempQuaternion.setFromEuler(this.tempEuler.set(0, Math.PI / 2, 0));
              this.alignVector.copy(this.rotationAxis);
              handle.quaternion.setFromRotationMatrix(
                this.lookAtMatrix.lookAt(this.zeroVector, this.alignVector, this.unitY)
              );
              handle.quaternion.multiply(this.tempQuaternion);
              handle.visible = this.dragging;
            }
            if (this.axis === "E") {
              handle.visible = false;
            }
          } else if (handle.name === "START") {
            handle.position.copy(this.worldPositionStart);
            handle.visible = this.dragging;
          } else if (handle.name === "END") {
            handle.position.copy(this.worldPosition);
            handle.visible = this.dragging;
          } else if (handle.name === "DELTA") {
            handle.position.copy(this.worldPositionStart);
            handle.quaternion.copy(this.worldQuaternionStart);
            this.tempVector.set(1e-10, 1e-10, 1e-10).add(this.worldPositionStart).sub(this.worldPosition).multiplyScalar(-1);
            this.tempVector.applyQuaternion(this.worldQuaternionStart.clone().invert());
            handle.scale.copy(this.tempVector);
            handle.visible = this.dragging;
          } else {
            handle.quaternion.copy(quaternion);
            if (this.dragging) {
              handle.position.copy(this.worldPositionStart);
            } else {
              handle.position.copy(this.worldPosition);
            }
            if (this.axis) {
              handle.visible = this.axis.search(handle.name) !== -1;
            }
          }
          continue;
        }
        handle.quaternion.copy(quaternion);
        if (this.mode === "translate" || this.mode === "scale") {
          const AXIS_HIDE_TRESHOLD = 0.99;
          const PLANE_HIDE_TRESHOLD = 0.2;
          const AXIS_FLIP_TRESHOLD = 0;
          if (handle.name === "X" || handle.name === "XYZX") {
            if (Math.abs(this.alignVector.copy(this.unitX).applyQuaternion(quaternion).dot(this.eye)) > AXIS_HIDE_TRESHOLD) {
              handle.scale.set(1e-10, 1e-10, 1e-10);
              handle.visible = false;
            }
          }
          if (handle.name === "Y" || handle.name === "XYZY") {
            if (Math.abs(this.alignVector.copy(this.unitY).applyQuaternion(quaternion).dot(this.eye)) > AXIS_HIDE_TRESHOLD) {
              handle.scale.set(1e-10, 1e-10, 1e-10);
              handle.visible = false;
            }
          }
          if (handle.name === "Z" || handle.name === "XYZZ") {
            if (Math.abs(this.alignVector.copy(this.unitZ).applyQuaternion(quaternion).dot(this.eye)) > AXIS_HIDE_TRESHOLD) {
              handle.scale.set(1e-10, 1e-10, 1e-10);
              handle.visible = false;
            }
          }
          if (handle.name === "XY") {
            if (Math.abs(this.alignVector.copy(this.unitZ).applyQuaternion(quaternion).dot(this.eye)) < PLANE_HIDE_TRESHOLD) {
              handle.scale.set(1e-10, 1e-10, 1e-10);
              handle.visible = false;
            }
          }
          if (handle.name === "YZ") {
            if (Math.abs(this.alignVector.copy(this.unitX).applyQuaternion(quaternion).dot(this.eye)) < PLANE_HIDE_TRESHOLD) {
              handle.scale.set(1e-10, 1e-10, 1e-10);
              handle.visible = false;
            }
          }
          if (handle.name === "XZ") {
            if (Math.abs(this.alignVector.copy(this.unitY).applyQuaternion(quaternion).dot(this.eye)) < PLANE_HIDE_TRESHOLD) {
              handle.scale.set(1e-10, 1e-10, 1e-10);
              handle.visible = false;
            }
          }
          if (handle.name.search("X") !== -1) {
            if (this.alignVector.copy(this.unitX).applyQuaternion(quaternion).dot(this.eye) < AXIS_FLIP_TRESHOLD) {
              if (handle.tag === "fwd") {
                handle.visible = false;
              } else {
                handle.scale.x *= -1;
              }
            } else if (handle.tag === "bwd") {
              handle.visible = false;
            }
          }
          if (handle.name.search("Y") !== -1) {
            if (this.alignVector.copy(this.unitY).applyQuaternion(quaternion).dot(this.eye) < AXIS_FLIP_TRESHOLD) {
              if (handle.tag === "fwd") {
                handle.visible = false;
              } else {
                handle.scale.y *= -1;
              }
            } else if (handle.tag === "bwd") {
              handle.visible = false;
            }
          }
          if (handle.name.search("Z") !== -1) {
            if (this.alignVector.copy(this.unitZ).applyQuaternion(quaternion).dot(this.eye) < AXIS_FLIP_TRESHOLD) {
              if (handle.tag === "fwd") {
                handle.visible = false;
              } else {
                handle.scale.z *= -1;
              }
            } else if (handle.tag === "bwd") {
              handle.visible = false;
            }
          }
        } else if (this.mode === "rotate") {
          this.tempQuaternion2.copy(quaternion);
          this.alignVector.copy(this.eye).applyQuaternion(this.tempQuaternion.copy(quaternion).invert());
          if (handle.name.search("E") !== -1) {
            handle.quaternion.setFromRotationMatrix(this.lookAtMatrix.lookAt(this.eye, this.zeroVector, this.unitY));
          }
          if (handle.name === "X") {
            this.tempQuaternion.setFromAxisAngle(this.unitX, Math.atan2(-this.alignVector.y, this.alignVector.z));
            this.tempQuaternion.multiplyQuaternions(this.tempQuaternion2, this.tempQuaternion);
            handle.quaternion.copy(this.tempQuaternion);
          }
          if (handle.name === "Y") {
            this.tempQuaternion.setFromAxisAngle(this.unitY, Math.atan2(this.alignVector.x, this.alignVector.z));
            this.tempQuaternion.multiplyQuaternions(this.tempQuaternion2, this.tempQuaternion);
            handle.quaternion.copy(this.tempQuaternion);
          }
          if (handle.name === "Z") {
            this.tempQuaternion.setFromAxisAngle(this.unitZ, Math.atan2(this.alignVector.y, this.alignVector.x));
            this.tempQuaternion.multiplyQuaternions(this.tempQuaternion2, this.tempQuaternion);
            handle.quaternion.copy(this.tempQuaternion);
          }
        }
        handle.visible = handle.visible && (handle.name.indexOf("X") === -1 || this.showX);
        handle.visible = handle.visible && (handle.name.indexOf("Y") === -1 || this.showY);
        handle.visible = handle.visible && (handle.name.indexOf("Z") === -1 || this.showZ);
        handle.visible = handle.visible && (handle.name.indexOf("E") === -1 || this.showX && this.showY && this.showZ);
        handle.material.tempOpacity = handle.material.tempOpacity || handle.material.opacity;
        handle.material.tempColor = handle.material.tempColor || handle.material.color.clone();
        handle.material.color.copy(handle.material.tempColor);
        handle.material.opacity = handle.material.tempOpacity;
        if (!this.enabled) {
          handle.material.opacity *= 0.5;
          handle.material.color.lerp(new Color(1, 1, 1), 0.5);
        } else if (this.axis) {
          if (handle.name === this.axis) {
            handle.material.opacity = 1;
            handle.material.color.lerp(new Color(1, 1, 1), 0.5);
          } else if (this.axis.split("").some(function(a6) {
            return handle.name === a6;
          })) {
            handle.material.opacity = 1;
            handle.material.color.lerp(new Color(1, 1, 1), 0.5);
          } else {
            handle.material.opacity *= 0.25;
            handle.material.color.lerp(new Color(1, 1, 1), 0.5);
          }
        }
      }
      super.updateMatrixWorld();
    });
    const gizmoMaterial = new MeshBasicMaterial({
      depthTest: false,
      depthWrite: false,
      transparent: true,
      side: DoubleSide,
      fog: false,
      toneMapped: false
    });
    const gizmoLineMaterial = new LineBasicMaterial({
      depthTest: false,
      depthWrite: false,
      transparent: true,
      linewidth: 1,
      fog: false,
      toneMapped: false
    });
    const matInvisible = gizmoMaterial.clone();
    matInvisible.opacity = 0.15;
    const matHelper = gizmoMaterial.clone();
    matHelper.opacity = 0.33;
    const matRed = gizmoMaterial.clone();
    matRed.color.set(16711680);
    const matGreen = gizmoMaterial.clone();
    matGreen.color.set(65280);
    const matBlue = gizmoMaterial.clone();
    matBlue.color.set(255);
    const matWhiteTransparent = gizmoMaterial.clone();
    matWhiteTransparent.opacity = 0.25;
    const matYellowTransparent = matWhiteTransparent.clone();
    matYellowTransparent.color.set(16776960);
    const matCyanTransparent = matWhiteTransparent.clone();
    matCyanTransparent.color.set(65535);
    const matMagentaTransparent = matWhiteTransparent.clone();
    matMagentaTransparent.color.set(16711935);
    const matYellow = gizmoMaterial.clone();
    matYellow.color.set(16776960);
    const matLineRed = gizmoLineMaterial.clone();
    matLineRed.color.set(16711680);
    const matLineGreen = gizmoLineMaterial.clone();
    matLineGreen.color.set(65280);
    const matLineBlue = gizmoLineMaterial.clone();
    matLineBlue.color.set(255);
    const matLineCyan = gizmoLineMaterial.clone();
    matLineCyan.color.set(65535);
    const matLineMagenta = gizmoLineMaterial.clone();
    matLineMagenta.color.set(16711935);
    const matLineYellow = gizmoLineMaterial.clone();
    matLineYellow.color.set(16776960);
    const matLineGray = gizmoLineMaterial.clone();
    matLineGray.color.set(7895160);
    const matLineYellowTransparent = matLineYellow.clone();
    matLineYellowTransparent.opacity = 0.25;
    const arrowGeometry = new CylinderGeometry(0, 0.05, 0.2, 12, 1, false);
    const scaleHandleGeometry = new BoxGeometry(0.125, 0.125, 0.125);
    const lineGeometry = new BufferGeometry();
    lineGeometry.setAttribute("position", new Float32BufferAttribute([0, 0, 0, 1, 0, 0], 3));
    const CircleGeometry = (radius, arc) => {
      const geometry3 = new BufferGeometry();
      const vertices = [];
      for (let i4 = 0; i4 <= 64 * arc; ++i4) {
        vertices.push(0, Math.cos(i4 / 32 * Math.PI) * radius, Math.sin(i4 / 32 * Math.PI) * radius);
      }
      geometry3.setAttribute("position", new Float32BufferAttribute(vertices, 3));
      return geometry3;
    };
    const TranslateHelperGeometry = () => {
      const geometry3 = new BufferGeometry();
      geometry3.setAttribute("position", new Float32BufferAttribute([0, 0, 0, 1, 1, 1], 3));
      return geometry3;
    };
    const gizmoTranslate = {
      X: [
        [new Mesh(arrowGeometry, matRed), [1, 0, 0], [0, 0, -Math.PI / 2], null, "fwd"],
        [new Mesh(arrowGeometry, matRed), [1, 0, 0], [0, 0, Math.PI / 2], null, "bwd"],
        [new Line(lineGeometry, matLineRed)]
      ],
      Y: [
        [new Mesh(arrowGeometry, matGreen), [0, 1, 0], null, null, "fwd"],
        [new Mesh(arrowGeometry, matGreen), [0, 1, 0], [Math.PI, 0, 0], null, "bwd"],
        [new Line(lineGeometry, matLineGreen), null, [0, 0, Math.PI / 2]]
      ],
      Z: [
        [new Mesh(arrowGeometry, matBlue), [0, 0, 1], [Math.PI / 2, 0, 0], null, "fwd"],
        [new Mesh(arrowGeometry, matBlue), [0, 0, 1], [-Math.PI / 2, 0, 0], null, "bwd"],
        [new Line(lineGeometry, matLineBlue), null, [0, -Math.PI / 2, 0]]
      ],
      XYZ: [[new Mesh(new OctahedronGeometry(0.1, 0), matWhiteTransparent.clone()), [0, 0, 0], [0, 0, 0]]],
      XY: [
        [new Mesh(new PlaneGeometry(0.295, 0.295), matYellowTransparent.clone()), [0.15, 0.15, 0]],
        [new Line(lineGeometry, matLineYellow), [0.18, 0.3, 0], null, [0.125, 1, 1]],
        [new Line(lineGeometry, matLineYellow), [0.3, 0.18, 0], [0, 0, Math.PI / 2], [0.125, 1, 1]]
      ],
      YZ: [
        [new Mesh(new PlaneGeometry(0.295, 0.295), matCyanTransparent.clone()), [0, 0.15, 0.15], [0, Math.PI / 2, 0]],
        [new Line(lineGeometry, matLineCyan), [0, 0.18, 0.3], [0, 0, Math.PI / 2], [0.125, 1, 1]],
        [new Line(lineGeometry, matLineCyan), [0, 0.3, 0.18], [0, -Math.PI / 2, 0], [0.125, 1, 1]]
      ],
      XZ: [
        [
          new Mesh(new PlaneGeometry(0.295, 0.295), matMagentaTransparent.clone()),
          [0.15, 0, 0.15],
          [-Math.PI / 2, 0, 0]
        ],
        [new Line(lineGeometry, matLineMagenta), [0.18, 0, 0.3], null, [0.125, 1, 1]],
        [new Line(lineGeometry, matLineMagenta), [0.3, 0, 0.18], [0, -Math.PI / 2, 0], [0.125, 1, 1]]
      ]
    };
    const pickerTranslate = {
      X: [[new Mesh(new CylinderGeometry(0.2, 0, 1, 4, 1, false), matInvisible), [0.6, 0, 0], [0, 0, -Math.PI / 2]]],
      Y: [[new Mesh(new CylinderGeometry(0.2, 0, 1, 4, 1, false), matInvisible), [0, 0.6, 0]]],
      Z: [[new Mesh(new CylinderGeometry(0.2, 0, 1, 4, 1, false), matInvisible), [0, 0, 0.6], [Math.PI / 2, 0, 0]]],
      XYZ: [[new Mesh(new OctahedronGeometry(0.2, 0), matInvisible)]],
      XY: [[new Mesh(new PlaneGeometry(0.4, 0.4), matInvisible), [0.2, 0.2, 0]]],
      YZ: [[new Mesh(new PlaneGeometry(0.4, 0.4), matInvisible), [0, 0.2, 0.2], [0, Math.PI / 2, 0]]],
      XZ: [[new Mesh(new PlaneGeometry(0.4, 0.4), matInvisible), [0.2, 0, 0.2], [-Math.PI / 2, 0, 0]]]
    };
    const helperTranslate = {
      START: [[new Mesh(new OctahedronGeometry(0.01, 2), matHelper), null, null, null, "helper"]],
      END: [[new Mesh(new OctahedronGeometry(0.01, 2), matHelper), null, null, null, "helper"]],
      DELTA: [[new Line(TranslateHelperGeometry(), matHelper), null, null, null, "helper"]],
      X: [[new Line(lineGeometry, matHelper.clone()), [-1e3, 0, 0], null, [1e6, 1, 1], "helper"]],
      Y: [[new Line(lineGeometry, matHelper.clone()), [0, -1e3, 0], [0, 0, Math.PI / 2], [1e6, 1, 1], "helper"]],
      Z: [[new Line(lineGeometry, matHelper.clone()), [0, 0, -1e3], [0, -Math.PI / 2, 0], [1e6, 1, 1], "helper"]]
    };
    const gizmoRotate = {
      X: [
        [new Line(CircleGeometry(1, 0.5), matLineRed)],
        [new Mesh(new OctahedronGeometry(0.04, 0), matRed), [0, 0, 0.99], null, [1, 3, 1]]
      ],
      Y: [
        [new Line(CircleGeometry(1, 0.5), matLineGreen), null, [0, 0, -Math.PI / 2]],
        [new Mesh(new OctahedronGeometry(0.04, 0), matGreen), [0, 0, 0.99], null, [3, 1, 1]]
      ],
      Z: [
        [new Line(CircleGeometry(1, 0.5), matLineBlue), null, [0, Math.PI / 2, 0]],
        [new Mesh(new OctahedronGeometry(0.04, 0), matBlue), [0.99, 0, 0], null, [1, 3, 1]]
      ],
      E: [
        [new Line(CircleGeometry(1.25, 1), matLineYellowTransparent), null, [0, Math.PI / 2, 0]],
        [
          new Mesh(new CylinderGeometry(0.03, 0, 0.15, 4, 1, false), matLineYellowTransparent),
          [1.17, 0, 0],
          [0, 0, -Math.PI / 2],
          [1, 1, 1e-3]
        ],
        [
          new Mesh(new CylinderGeometry(0.03, 0, 0.15, 4, 1, false), matLineYellowTransparent),
          [-1.17, 0, 0],
          [0, 0, Math.PI / 2],
          [1, 1, 1e-3]
        ],
        [
          new Mesh(new CylinderGeometry(0.03, 0, 0.15, 4, 1, false), matLineYellowTransparent),
          [0, -1.17, 0],
          [Math.PI, 0, 0],
          [1, 1, 1e-3]
        ],
        [
          new Mesh(new CylinderGeometry(0.03, 0, 0.15, 4, 1, false), matLineYellowTransparent),
          [0, 1.17, 0],
          [0, 0, 0],
          [1, 1, 1e-3]
        ]
      ],
      XYZE: [[new Line(CircleGeometry(1, 1), matLineGray), null, [0, Math.PI / 2, 0]]]
    };
    const helperRotate = {
      AXIS: [[new Line(lineGeometry, matHelper.clone()), [-1e3, 0, 0], null, [1e6, 1, 1], "helper"]]
    };
    const pickerRotate = {
      X: [[new Mesh(new TorusGeometry(1, 0.1, 4, 24), matInvisible), [0, 0, 0], [0, -Math.PI / 2, -Math.PI / 2]]],
      Y: [[new Mesh(new TorusGeometry(1, 0.1, 4, 24), matInvisible), [0, 0, 0], [Math.PI / 2, 0, 0]]],
      Z: [[new Mesh(new TorusGeometry(1, 0.1, 4, 24), matInvisible), [0, 0, 0], [0, 0, -Math.PI / 2]]],
      E: [[new Mesh(new TorusGeometry(1.25, 0.1, 2, 24), matInvisible)]],
      XYZE: [[new Mesh(new SphereGeometry(0.7, 10, 8), matInvisible)]]
    };
    const gizmoScale = {
      X: [
        [new Mesh(scaleHandleGeometry, matRed), [0.8, 0, 0], [0, 0, -Math.PI / 2]],
        [new Line(lineGeometry, matLineRed), null, null, [0.8, 1, 1]]
      ],
      Y: [
        [new Mesh(scaleHandleGeometry, matGreen), [0, 0.8, 0]],
        [new Line(lineGeometry, matLineGreen), null, [0, 0, Math.PI / 2], [0.8, 1, 1]]
      ],
      Z: [
        [new Mesh(scaleHandleGeometry, matBlue), [0, 0, 0.8], [Math.PI / 2, 0, 0]],
        [new Line(lineGeometry, matLineBlue), null, [0, -Math.PI / 2, 0], [0.8, 1, 1]]
      ],
      XY: [
        [new Mesh(scaleHandleGeometry, matYellowTransparent), [0.85, 0.85, 0], null, [2, 2, 0.2]],
        [new Line(lineGeometry, matLineYellow), [0.855, 0.98, 0], null, [0.125, 1, 1]],
        [new Line(lineGeometry, matLineYellow), [0.98, 0.855, 0], [0, 0, Math.PI / 2], [0.125, 1, 1]]
      ],
      YZ: [
        [new Mesh(scaleHandleGeometry, matCyanTransparent), [0, 0.85, 0.85], null, [0.2, 2, 2]],
        [new Line(lineGeometry, matLineCyan), [0, 0.855, 0.98], [0, 0, Math.PI / 2], [0.125, 1, 1]],
        [new Line(lineGeometry, matLineCyan), [0, 0.98, 0.855], [0, -Math.PI / 2, 0], [0.125, 1, 1]]
      ],
      XZ: [
        [new Mesh(scaleHandleGeometry, matMagentaTransparent), [0.85, 0, 0.85], null, [2, 0.2, 2]],
        [new Line(lineGeometry, matLineMagenta), [0.855, 0, 0.98], null, [0.125, 1, 1]],
        [new Line(lineGeometry, matLineMagenta), [0.98, 0, 0.855], [0, -Math.PI / 2, 0], [0.125, 1, 1]]
      ],
      XYZX: [[new Mesh(new BoxGeometry(0.125, 0.125, 0.125), matWhiteTransparent.clone()), [1.1, 0, 0]]],
      XYZY: [[new Mesh(new BoxGeometry(0.125, 0.125, 0.125), matWhiteTransparent.clone()), [0, 1.1, 0]]],
      XYZZ: [[new Mesh(new BoxGeometry(0.125, 0.125, 0.125), matWhiteTransparent.clone()), [0, 0, 1.1]]]
    };
    const pickerScale = {
      X: [[new Mesh(new CylinderGeometry(0.2, 0, 0.8, 4, 1, false), matInvisible), [0.5, 0, 0], [0, 0, -Math.PI / 2]]],
      Y: [[new Mesh(new CylinderGeometry(0.2, 0, 0.8, 4, 1, false), matInvisible), [0, 0.5, 0]]],
      Z: [[new Mesh(new CylinderGeometry(0.2, 0, 0.8, 4, 1, false), matInvisible), [0, 0, 0.5], [Math.PI / 2, 0, 0]]],
      XY: [[new Mesh(scaleHandleGeometry, matInvisible), [0.85, 0.85, 0], null, [3, 3, 0.2]]],
      YZ: [[new Mesh(scaleHandleGeometry, matInvisible), [0, 0.85, 0.85], null, [0.2, 3, 3]]],
      XZ: [[new Mesh(scaleHandleGeometry, matInvisible), [0.85, 0, 0.85], null, [3, 0.2, 3]]],
      XYZX: [[new Mesh(new BoxGeometry(0.2, 0.2, 0.2), matInvisible), [1.1, 0, 0]]],
      XYZY: [[new Mesh(new BoxGeometry(0.2, 0.2, 0.2), matInvisible), [0, 1.1, 0]]],
      XYZZ: [[new Mesh(new BoxGeometry(0.2, 0.2, 0.2), matInvisible), [0, 0, 1.1]]]
    };
    const helperScale = {
      X: [[new Line(lineGeometry, matHelper.clone()), [-1e3, 0, 0], null, [1e6, 1, 1], "helper"]],
      Y: [[new Line(lineGeometry, matHelper.clone()), [0, -1e3, 0], [0, 0, Math.PI / 2], [1e6, 1, 1], "helper"]],
      Z: [[new Line(lineGeometry, matHelper.clone()), [0, 0, -1e3], [0, -Math.PI / 2, 0], [1e6, 1, 1], "helper"]]
    };
    const setupGizmo = (gizmoMap) => {
      const gizmo = new Object3D();
      for (let name in gizmoMap) {
        for (let i4 = gizmoMap[name].length; i4--; ) {
          const object = gizmoMap[name][i4][0].clone();
          const position2 = gizmoMap[name][i4][1];
          const rotation3 = gizmoMap[name][i4][2];
          const scale5 = gizmoMap[name][i4][3];
          const tag = gizmoMap[name][i4][4];
          object.name = name;
          object.tag = tag;
          if (position2) {
            object.position.set(position2[0], position2[1], position2[2]);
          }
          if (rotation3) {
            object.rotation.set(rotation3[0], rotation3[1], rotation3[2]);
          }
          if (scale5) {
            object.scale.set(scale5[0], scale5[1], scale5[2]);
          }
          object.updateMatrix();
          const tempGeometry = object.geometry.clone();
          tempGeometry.applyMatrix4(object.matrix);
          object.geometry = tempGeometry;
          object.renderOrder = Infinity;
          object.position.set(0, 0, 0);
          object.rotation.set(0, 0, 0);
          object.scale.set(1, 1, 1);
          gizmo.add(object);
        }
      }
      return gizmo;
    };
    this.gizmo = {};
    this.picker = {};
    this.helper = {};
    this.add(this.gizmo["translate"] = setupGizmo(gizmoTranslate));
    this.add(this.gizmo["rotate"] = setupGizmo(gizmoRotate));
    this.add(this.gizmo["scale"] = setupGizmo(gizmoScale));
    this.add(this.picker["translate"] = setupGizmo(pickerTranslate));
    this.add(this.picker["rotate"] = setupGizmo(pickerRotate));
    this.add(this.picker["scale"] = setupGizmo(pickerScale));
    this.add(this.helper["translate"] = setupGizmo(helperTranslate));
    this.add(this.helper["rotate"] = setupGizmo(helperRotate));
    this.add(this.helper["scale"] = setupGizmo(helperScale));
    this.picker["translate"].visible = false;
    this.picker["rotate"].visible = false;
    this.picker["scale"].visible = false;
  }
};
var TransformControlsPlane = class extends Mesh {
  constructor() {
    super(
      new PlaneGeometry(1e5, 1e5, 2, 2),
      new MeshBasicMaterial({
        visible: false,
        wireframe: true,
        side: DoubleSide,
        transparent: true,
        opacity: 0.1,
        toneMapped: false
      })
    );
    __publicField14(this, "isTransformControlsPlane", true);
    __publicField14(this, "type", "TransformControlsPlane");
    __publicField14(this, "unitX", new Vector3(1, 0, 0));
    __publicField14(this, "unitY", new Vector3(0, 1, 0));
    __publicField14(this, "unitZ", new Vector3(0, 0, 1));
    __publicField14(this, "tempVector", new Vector3());
    __publicField14(this, "dirVector", new Vector3());
    __publicField14(this, "alignVector", new Vector3());
    __publicField14(this, "tempMatrix", new Matrix4());
    __publicField14(this, "identityQuaternion", new Quaternion());
    __publicField14(this, "cameraQuaternion", new Quaternion());
    __publicField14(this, "worldPosition", new Vector3());
    __publicField14(this, "worldQuaternion", new Quaternion());
    __publicField14(this, "eye", new Vector3());
    __publicField14(this, "axis", null);
    __publicField14(this, "mode", "translate");
    __publicField14(this, "space", "world");
    __publicField14(this, "updateMatrixWorld", () => {
      let space = this.space;
      this.position.copy(this.worldPosition);
      if (this.mode === "scale")
        space = "local";
      this.unitX.set(1, 0, 0).applyQuaternion(space === "local" ? this.worldQuaternion : this.identityQuaternion);
      this.unitY.set(0, 1, 0).applyQuaternion(space === "local" ? this.worldQuaternion : this.identityQuaternion);
      this.unitZ.set(0, 0, 1).applyQuaternion(space === "local" ? this.worldQuaternion : this.identityQuaternion);
      this.alignVector.copy(this.unitY);
      switch (this.mode) {
        case "translate":
        case "scale":
          switch (this.axis) {
            case "X":
              this.alignVector.copy(this.eye).cross(this.unitX);
              this.dirVector.copy(this.unitX).cross(this.alignVector);
              break;
            case "Y":
              this.alignVector.copy(this.eye).cross(this.unitY);
              this.dirVector.copy(this.unitY).cross(this.alignVector);
              break;
            case "Z":
              this.alignVector.copy(this.eye).cross(this.unitZ);
              this.dirVector.copy(this.unitZ).cross(this.alignVector);
              break;
            case "XY":
              this.dirVector.copy(this.unitZ);
              break;
            case "YZ":
              this.dirVector.copy(this.unitX);
              break;
            case "XZ":
              this.alignVector.copy(this.unitZ);
              this.dirVector.copy(this.unitY);
              break;
            case "XYZ":
            case "E":
              this.dirVector.set(0, 0, 0);
              break;
          }
          break;
        case "rotate":
        default:
          this.dirVector.set(0, 0, 0);
      }
      if (this.dirVector.length() === 0) {
        this.quaternion.copy(this.cameraQuaternion);
      } else {
        this.tempMatrix.lookAt(this.tempVector.set(0, 0, 0), this.dirVector, this.alignVector);
        this.quaternion.setFromRotationMatrix(this.tempMatrix);
      }
      super.updateMatrixWorld();
    });
  }
};

// node_modules/three-stdlib/controls/PointerLockControls.js
var __defProp14 = Object.defineProperty;
var __defNormalProp14 = (obj, key, value) => key in obj ? __defProp14(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField15 = (obj, key, value) => {
  __defNormalProp14(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var _euler = new Euler(0, 0, 0, "YXZ");
var _vector3 = new Vector3();
var _changeEvent = { type: "change" };
var _lockEvent = { type: "lock" };
var _unlockEvent = { type: "unlock" };
var _MOUSE_SENSITIVITY = 2e-3;
var _PI_2 = Math.PI / 2;
var PointerLockControls = class extends EventDispatcher2 {
  constructor(camera, domElement) {
    super();
    __publicField15(this, "camera");
    __publicField15(this, "domElement");
    __publicField15(this, "isLocked");
    __publicField15(this, "minPolarAngle");
    __publicField15(this, "maxPolarAngle");
    __publicField15(this, "pointerSpeed");
    __publicField15(this, "onMouseMove", (event) => {
      if (!this.domElement || this.isLocked === false)
        return;
      _euler.setFromQuaternion(this.camera.quaternion);
      _euler.y -= event.movementX * _MOUSE_SENSITIVITY * this.pointerSpeed;
      _euler.x -= event.movementY * _MOUSE_SENSITIVITY * this.pointerSpeed;
      _euler.x = Math.max(_PI_2 - this.maxPolarAngle, Math.min(_PI_2 - this.minPolarAngle, _euler.x));
      this.camera.quaternion.setFromEuler(_euler);
      this.dispatchEvent(_changeEvent);
    });
    __publicField15(this, "onPointerlockChange", () => {
      if (!this.domElement)
        return;
      if (this.domElement.ownerDocument.pointerLockElement === this.domElement) {
        this.dispatchEvent(_lockEvent);
        this.isLocked = true;
      } else {
        this.dispatchEvent(_unlockEvent);
        this.isLocked = false;
      }
    });
    __publicField15(this, "onPointerlockError", () => {
      console.error("THREE.PointerLockControls: Unable to use Pointer Lock API");
    });
    __publicField15(this, "connect", (domElement2) => {
      this.domElement = domElement2 || this.domElement;
      if (!this.domElement)
        return;
      this.domElement.ownerDocument.addEventListener("mousemove", this.onMouseMove);
      this.domElement.ownerDocument.addEventListener("pointerlockchange", this.onPointerlockChange);
      this.domElement.ownerDocument.addEventListener("pointerlockerror", this.onPointerlockError);
    });
    __publicField15(this, "disconnect", () => {
      if (!this.domElement)
        return;
      this.domElement.ownerDocument.removeEventListener("mousemove", this.onMouseMove);
      this.domElement.ownerDocument.removeEventListener("pointerlockchange", this.onPointerlockChange);
      this.domElement.ownerDocument.removeEventListener("pointerlockerror", this.onPointerlockError);
    });
    __publicField15(this, "dispose", () => {
      this.disconnect();
    });
    __publicField15(this, "getObject", () => {
      return this.camera;
    });
    __publicField15(this, "direction", new Vector3(0, 0, -1));
    __publicField15(this, "getDirection", (v5) => {
      return v5.copy(this.direction).applyQuaternion(this.camera.quaternion);
    });
    __publicField15(this, "moveForward", (distance3) => {
      _vector3.setFromMatrixColumn(this.camera.matrix, 0);
      _vector3.crossVectors(this.camera.up, _vector3);
      this.camera.position.addScaledVector(_vector3, distance3);
    });
    __publicField15(this, "moveRight", (distance3) => {
      _vector3.setFromMatrixColumn(this.camera.matrix, 0);
      this.camera.position.addScaledVector(_vector3, distance3);
    });
    __publicField15(this, "lock", () => {
      if (this.domElement)
        this.domElement.requestPointerLock();
    });
    __publicField15(this, "unlock", () => {
      if (this.domElement)
        this.domElement.ownerDocument.exitPointerLock();
    });
    this.camera = camera;
    this.domElement = domElement;
    this.isLocked = false;
    this.minPolarAngle = 0;
    this.maxPolarAngle = Math.PI;
    this.pointerSpeed = 1;
    if (domElement)
      this.connect(domElement);
  }
};

// node_modules/three-stdlib/controls/DeviceOrientationControls.js
var __defProp15 = Object.defineProperty;
var __defNormalProp15 = (obj, key, value) => key in obj ? __defProp15(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField16 = (obj, key, value) => {
  __defNormalProp15(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var DeviceOrientationControls = class extends EventDispatcher2 {
  // radians
  constructor(object) {
    super();
    __publicField16(this, "object");
    __publicField16(this, "changeEvent", { type: "change" });
    __publicField16(this, "EPS", 1e-6);
    __publicField16(this, "enabled", true);
    __publicField16(this, "deviceOrientation", { alpha: 0, beta: 0, gamma: 0 });
    __publicField16(this, "screenOrientation", 0);
    __publicField16(this, "alphaOffset", 0);
    __publicField16(this, "onDeviceOrientationChangeEvent", (event) => {
      this.deviceOrientation = event;
    });
    __publicField16(this, "onScreenOrientationChangeEvent", () => {
      this.screenOrientation = window.orientation || 0;
    });
    __publicField16(this, "zee", new Vector3(0, 0, 1));
    __publicField16(this, "euler", new Euler());
    __publicField16(this, "q0", new Quaternion());
    __publicField16(this, "q1", new Quaternion(-Math.sqrt(0.5), 0, 0, Math.sqrt(0.5)));
    __publicField16(this, "setObjectQuaternion", (quaternion, alpha, beta, gamma, orient) => {
      this.euler.set(beta, alpha, -gamma, "YXZ");
      quaternion.setFromEuler(this.euler);
      quaternion.multiply(this.q1);
      quaternion.multiply(this.q0.setFromAxisAngle(this.zee, -orient));
    });
    __publicField16(this, "connect", () => {
      this.onScreenOrientationChangeEvent();
      if (window.DeviceOrientationEvent !== void 0 && // @ts-ignore
      typeof window.DeviceOrientationEvent.requestPermission === "function") {
        window.DeviceOrientationEvent.requestPermission().then((response) => {
          if (response == "granted") {
            window.addEventListener("orientationchange", this.onScreenOrientationChangeEvent);
            window.addEventListener("deviceorientation", this.onDeviceOrientationChangeEvent);
          }
        }).catch((error) => {
          console.error("THREE.DeviceOrientationControls: Unable to use DeviceOrientation API:", error);
        });
      } else {
        window.addEventListener("orientationchange", this.onScreenOrientationChangeEvent);
        window.addEventListener("deviceorientation", this.onDeviceOrientationChangeEvent);
      }
      this.enabled = true;
    });
    __publicField16(this, "disconnect", () => {
      window.removeEventListener("orientationchange", this.onScreenOrientationChangeEvent);
      window.removeEventListener("deviceorientation", this.onDeviceOrientationChangeEvent);
      this.enabled = false;
    });
    __publicField16(this, "lastQuaternion", new Quaternion());
    __publicField16(this, "update", () => {
      if (this.enabled === false)
        return;
      const device = this.deviceOrientation;
      if (device) {
        const alpha = device.alpha ? MathUtils.degToRad(device.alpha) + this.alphaOffset : 0;
        const beta = device.beta ? MathUtils.degToRad(device.beta) : 0;
        const gamma = device.gamma ? MathUtils.degToRad(device.gamma) : 0;
        const orient = this.screenOrientation ? MathUtils.degToRad(this.screenOrientation) : 0;
        this.setObjectQuaternion(this.object.quaternion, alpha, beta, gamma, orient);
        if (8 * (1 - this.lastQuaternion.dot(this.object.quaternion)) > this.EPS) {
          this.lastQuaternion.copy(this.object.quaternion);
          this.dispatchEvent(this.changeEvent);
        }
      }
    });
    __publicField16(this, "dispose", () => this.disconnect());
    this.object = object;
    this.object.rotation.reorder("YXZ");
    this.connect();
  }
};

// node_modules/three-stdlib/controls/TrackballControls.js
var __defProp16 = Object.defineProperty;
var __defNormalProp16 = (obj, key, value) => key in obj ? __defProp16(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField17 = (obj, key, value) => {
  __defNormalProp16(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var TrackballControls = class extends EventDispatcher2 {
  constructor(object, domElement) {
    super();
    __publicField17(this, "enabled", true);
    __publicField17(this, "screen", { left: 0, top: 0, width: 0, height: 0 });
    __publicField17(this, "rotateSpeed", 1);
    __publicField17(this, "zoomSpeed", 1.2);
    __publicField17(this, "panSpeed", 0.3);
    __publicField17(this, "noRotate", false);
    __publicField17(this, "noZoom", false);
    __publicField17(this, "noPan", false);
    __publicField17(this, "staticMoving", false);
    __publicField17(this, "dynamicDampingFactor", 0.2);
    __publicField17(this, "minDistance", 0);
    __publicField17(this, "maxDistance", Infinity);
    __publicField17(this, "keys", [
      "KeyA",
      "KeyS",
      "KeyD"
      /*D*/
    ]);
    __publicField17(this, "mouseButtons", {
      LEFT: MOUSE.ROTATE,
      MIDDLE: MOUSE.DOLLY,
      RIGHT: MOUSE.PAN
    });
    __publicField17(this, "object");
    __publicField17(this, "domElement");
    __publicField17(this, "cursorZoom", false);
    __publicField17(this, "target", new Vector3());
    __publicField17(this, "mousePosition", new Vector2());
    __publicField17(this, "STATE", {
      NONE: -1,
      ROTATE: 0,
      ZOOM: 1,
      PAN: 2,
      TOUCH_ROTATE: 3,
      TOUCH_ZOOM_PAN: 4
    });
    __publicField17(this, "EPS", 1e-6);
    __publicField17(this, "lastZoom", 1);
    __publicField17(this, "lastPosition", new Vector3());
    __publicField17(this, "cursorVector", new Vector3());
    __publicField17(this, "targetVector", new Vector3());
    __publicField17(this, "_state", this.STATE.NONE);
    __publicField17(this, "_keyState", this.STATE.NONE);
    __publicField17(this, "_eye", new Vector3());
    __publicField17(this, "_movePrev", new Vector2());
    __publicField17(this, "_moveCurr", new Vector2());
    __publicField17(this, "_lastAxis", new Vector3());
    __publicField17(this, "_lastAngle", 0);
    __publicField17(this, "_zoomStart", new Vector2());
    __publicField17(this, "_zoomEnd", new Vector2());
    __publicField17(this, "_touchZoomDistanceStart", 0);
    __publicField17(this, "_touchZoomDistanceEnd", 0);
    __publicField17(this, "_panStart", new Vector2());
    __publicField17(this, "_panEnd", new Vector2());
    __publicField17(this, "target0");
    __publicField17(this, "position0");
    __publicField17(this, "up0");
    __publicField17(this, "zoom0");
    __publicField17(this, "changeEvent", { type: "change" });
    __publicField17(this, "startEvent", { type: "start" });
    __publicField17(this, "endEvent", { type: "end" });
    __publicField17(this, "onScreenVector", new Vector2());
    __publicField17(this, "getMouseOnScreen", (pageX, pageY) => {
      this.onScreenVector.set(
        (pageX - this.screen.left) / this.screen.width,
        (pageY - this.screen.top) / this.screen.height
      );
      return this.onScreenVector;
    });
    __publicField17(this, "onCircleVector", new Vector2());
    __publicField17(this, "getMouseOnCircle", (pageX, pageY) => {
      this.onCircleVector.set(
        (pageX - this.screen.width * 0.5 - this.screen.left) / (this.screen.width * 0.5),
        (this.screen.height + 2 * (this.screen.top - pageY)) / this.screen.width
        // screen.width intentional
      );
      return this.onCircleVector;
    });
    __publicField17(this, "axis", new Vector3());
    __publicField17(this, "quaternion", new Quaternion());
    __publicField17(this, "eyeDirection", new Vector3());
    __publicField17(this, "objectUpDirection", new Vector3());
    __publicField17(this, "objectSidewaysDirection", new Vector3());
    __publicField17(this, "moveDirection", new Vector3());
    __publicField17(this, "angle", 0);
    __publicField17(this, "rotateCamera", () => {
      this.moveDirection.set(this._moveCurr.x - this._movePrev.x, this._moveCurr.y - this._movePrev.y, 0);
      this.angle = this.moveDirection.length();
      if (this.angle) {
        this._eye.copy(this.object.position).sub(this.target);
        this.eyeDirection.copy(this._eye).normalize();
        this.objectUpDirection.copy(this.object.up).normalize();
        this.objectSidewaysDirection.crossVectors(this.objectUpDirection, this.eyeDirection).normalize();
        this.objectUpDirection.setLength(this._moveCurr.y - this._movePrev.y);
        this.objectSidewaysDirection.setLength(this._moveCurr.x - this._movePrev.x);
        this.moveDirection.copy(this.objectUpDirection.add(this.objectSidewaysDirection));
        this.axis.crossVectors(this.moveDirection, this._eye).normalize();
        this.angle *= this.rotateSpeed;
        this.quaternion.setFromAxisAngle(this.axis, this.angle);
        this._eye.applyQuaternion(this.quaternion);
        this.object.up.applyQuaternion(this.quaternion);
        this._lastAxis.copy(this.axis);
        this._lastAngle = this.angle;
      } else if (!this.staticMoving && this._lastAngle) {
        this._lastAngle *= Math.sqrt(1 - this.dynamicDampingFactor);
        this._eye.copy(this.object.position).sub(this.target);
        this.quaternion.setFromAxisAngle(this._lastAxis, this._lastAngle);
        this._eye.applyQuaternion(this.quaternion);
        this.object.up.applyQuaternion(this.quaternion);
      }
      this._movePrev.copy(this._moveCurr);
    });
    __publicField17(this, "zoomCamera", () => {
      let factor;
      if (this._state === this.STATE.TOUCH_ZOOM_PAN) {
        factor = this._touchZoomDistanceStart / this._touchZoomDistanceEnd;
        this._touchZoomDistanceStart = this._touchZoomDistanceEnd;
        if (this.object.isPerspectiveCamera) {
          this._eye.multiplyScalar(factor);
        } else if (this.object.isOrthographicCamera) {
          this.object.zoom /= factor;
          this.object.updateProjectionMatrix();
        } else {
          console.warn("THREE.TrackballControls: Unsupported camera type");
        }
      } else {
        factor = 1 + (this._zoomEnd.y - this._zoomStart.y) * this.zoomSpeed;
        if (Math.abs(factor - 1) > this.EPS && factor > 0) {
          if (this.object.isPerspectiveCamera) {
            if (factor > 1 && this._eye.length() >= this.maxDistance - this.EPS) {
              factor = 1;
            }
            this._eye.multiplyScalar(factor);
          } else if (this.object.isOrthographicCamera) {
            if (factor > 1 && this.object.zoom < this.maxDistance * this.maxDistance) {
              factor = 1;
            }
            this.object.zoom /= factor;
          } else {
            console.warn("THREE.TrackballControls: Unsupported camera type");
          }
        }
        if (this.staticMoving) {
          this._zoomStart.copy(this._zoomEnd);
        } else {
          this._zoomStart.y += (this._zoomEnd.y - this._zoomStart.y) * this.dynamicDampingFactor;
        }
        if (this.cursorZoom) {
          this.targetVector.copy(this.target).project(this.object);
          let worldPos2 = this.cursorVector.set(this.mousePosition.x, this.mousePosition.y, this.targetVector.z).unproject(this.object);
          this.target.lerpVectors(worldPos2, this.target, factor);
        }
        if (this.object.isOrthographicCamera) {
          this.object.updateProjectionMatrix();
        }
      }
    });
    __publicField17(this, "mouseChange", new Vector2());
    __publicField17(this, "objectUp", new Vector3());
    __publicField17(this, "pan", new Vector3());
    __publicField17(this, "panCamera", () => {
      if (!this.domElement)
        return;
      this.mouseChange.copy(this._panEnd).sub(this._panStart);
      if (this.mouseChange.lengthSq() > this.EPS) {
        if (this.object.isOrthographicCamera) {
          const orthoObject = this.object;
          const scale_x = (orthoObject.right - orthoObject.left) / this.object.zoom;
          const scale_y = (orthoObject.top - orthoObject.bottom) / this.object.zoom;
          this.mouseChange.x *= scale_x;
          this.mouseChange.y *= scale_y;
        } else {
          this.mouseChange.multiplyScalar(this._eye.length() * this.panSpeed);
        }
        this.pan.copy(this._eye).cross(this.object.up).setLength(this.mouseChange.x);
        this.pan.add(this.objectUp.copy(this.object.up).setLength(this.mouseChange.y));
        this.object.position.add(this.pan);
        this.target.add(this.pan);
        if (this.staticMoving) {
          this._panStart.copy(this._panEnd);
        } else {
          this._panStart.add(
            this.mouseChange.subVectors(this._panEnd, this._panStart).multiplyScalar(this.dynamicDampingFactor)
          );
        }
      }
    });
    __publicField17(this, "checkDistances", () => {
      if (!this.noZoom || !this.noPan) {
        if (this._eye.lengthSq() > this.maxDistance * this.maxDistance) {
          this.object.position.addVectors(this.target, this._eye.setLength(this.maxDistance));
          this._zoomStart.copy(this._zoomEnd);
        }
        if (this._eye.lengthSq() < this.minDistance * this.minDistance) {
          this.object.position.addVectors(this.target, this._eye.setLength(this.minDistance));
          this._zoomStart.copy(this._zoomEnd);
        }
      }
    });
    __publicField17(this, "handleResize", () => {
      if (!this.domElement)
        return;
      const box = this.domElement.getBoundingClientRect();
      const d2 = this.domElement.ownerDocument.documentElement;
      this.screen.left = box.left + window.pageXOffset - d2.clientLeft;
      this.screen.top = box.top + window.pageYOffset - d2.clientTop;
      this.screen.width = box.width;
      this.screen.height = box.height;
    });
    __publicField17(this, "update", () => {
      this._eye.subVectors(this.object.position, this.target);
      if (!this.noRotate) {
        this.rotateCamera();
      }
      if (!this.noZoom) {
        this.zoomCamera();
      }
      if (!this.noPan) {
        this.panCamera();
      }
      this.object.position.addVectors(this.target, this._eye);
      if (this.object.isPerspectiveCamera) {
        this.checkDistances();
        this.object.lookAt(this.target);
        if (this.lastPosition.distanceToSquared(this.object.position) > this.EPS) {
          this.dispatchEvent(this.changeEvent);
          this.lastPosition.copy(this.object.position);
        }
      } else if (this.object.isOrthographicCamera) {
        this.object.lookAt(this.target);
        if (this.lastPosition.distanceToSquared(this.object.position) > this.EPS || this.lastZoom !== this.object.zoom) {
          this.dispatchEvent(this.changeEvent);
          this.lastPosition.copy(this.object.position);
          this.lastZoom = this.object.zoom;
        }
      } else {
        console.warn("THREE.TrackballControls: Unsupported camera type");
      }
    });
    __publicField17(this, "reset", () => {
      this._state = this.STATE.NONE;
      this._keyState = this.STATE.NONE;
      this.target.copy(this.target0);
      this.object.position.copy(this.position0);
      this.object.up.copy(this.up0);
      this.object.zoom = this.zoom0;
      this.object.updateProjectionMatrix();
      this._eye.subVectors(this.object.position, this.target);
      this.object.lookAt(this.target);
      this.dispatchEvent(this.changeEvent);
      this.lastPosition.copy(this.object.position);
      this.lastZoom = this.object.zoom;
    });
    __publicField17(this, "keydown", (event) => {
      if (this.enabled === false)
        return;
      window.removeEventListener("keydown", this.keydown);
      if (this._keyState !== this.STATE.NONE) {
        return;
      } else if (event.code === this.keys[this.STATE.ROTATE] && !this.noRotate) {
        this._keyState = this.STATE.ROTATE;
      } else if (event.code === this.keys[this.STATE.ZOOM] && !this.noZoom) {
        this._keyState = this.STATE.ZOOM;
      } else if (event.code === this.keys[this.STATE.PAN] && !this.noPan) {
        this._keyState = this.STATE.PAN;
      }
    });
    __publicField17(this, "onPointerDown", (event) => {
      if (this.enabled === false)
        return;
      switch (event.pointerType) {
        case "mouse":
        case "pen":
          this.onMouseDown(event);
          break;
      }
    });
    __publicField17(this, "onPointerMove", (event) => {
      if (this.enabled === false)
        return;
      switch (event.pointerType) {
        case "mouse":
        case "pen":
          this.onMouseMove(event);
          break;
      }
    });
    __publicField17(this, "onPointerUp", (event) => {
      if (this.enabled === false)
        return;
      switch (event.pointerType) {
        case "mouse":
        case "pen":
          this.onMouseUp();
          break;
      }
    });
    __publicField17(this, "keyup", () => {
      if (this.enabled === false)
        return;
      this._keyState = this.STATE.NONE;
      window.addEventListener("keydown", this.keydown);
    });
    __publicField17(this, "onMouseDown", (event) => {
      if (!this.domElement)
        return;
      if (this._state === this.STATE.NONE) {
        switch (event.button) {
          case this.mouseButtons.LEFT:
            this._state = this.STATE.ROTATE;
            break;
          case this.mouseButtons.MIDDLE:
            this._state = this.STATE.ZOOM;
            break;
          case this.mouseButtons.RIGHT:
            this._state = this.STATE.PAN;
            break;
        }
      }
      const state = this._keyState !== this.STATE.NONE ? this._keyState : this._state;
      if (state === this.STATE.ROTATE && !this.noRotate) {
        this._moveCurr.copy(this.getMouseOnCircle(event.pageX, event.pageY));
        this._movePrev.copy(this._moveCurr);
      } else if (state === this.STATE.ZOOM && !this.noZoom) {
        this._zoomStart.copy(this.getMouseOnScreen(event.pageX, event.pageY));
        this._zoomEnd.copy(this._zoomStart);
      } else if (state === this.STATE.PAN && !this.noPan) {
        this._panStart.copy(this.getMouseOnScreen(event.pageX, event.pageY));
        this._panEnd.copy(this._panStart);
      }
      this.domElement.ownerDocument.addEventListener("pointermove", this.onPointerMove);
      this.domElement.ownerDocument.addEventListener("pointerup", this.onPointerUp);
      this.dispatchEvent(this.startEvent);
    });
    __publicField17(this, "onMouseMove", (event) => {
      if (this.enabled === false)
        return;
      const state = this._keyState !== this.STATE.NONE ? this._keyState : this._state;
      if (state === this.STATE.ROTATE && !this.noRotate) {
        this._movePrev.copy(this._moveCurr);
        this._moveCurr.copy(this.getMouseOnCircle(event.pageX, event.pageY));
      } else if (state === this.STATE.ZOOM && !this.noZoom) {
        this._zoomEnd.copy(this.getMouseOnScreen(event.pageX, event.pageY));
      } else if (state === this.STATE.PAN && !this.noPan) {
        this._panEnd.copy(this.getMouseOnScreen(event.pageX, event.pageY));
      }
    });
    __publicField17(this, "onMouseUp", () => {
      if (!this.domElement)
        return;
      if (this.enabled === false)
        return;
      this._state = this.STATE.NONE;
      this.domElement.ownerDocument.removeEventListener("pointermove", this.onPointerMove);
      this.domElement.ownerDocument.removeEventListener("pointerup", this.onPointerUp);
      this.dispatchEvent(this.endEvent);
    });
    __publicField17(this, "mousewheel", (event) => {
      if (this.enabled === false)
        return;
      if (this.noZoom === true)
        return;
      event.preventDefault();
      switch (event.deltaMode) {
        case 2:
          this._zoomStart.y -= event.deltaY * 0.025;
          break;
        case 1:
          this._zoomStart.y -= event.deltaY * 0.01;
          break;
        default:
          this._zoomStart.y -= event.deltaY * 25e-5;
          break;
      }
      this.mousePosition.x = event.offsetX / this.screen.width * 2 - 1;
      this.mousePosition.y = -(event.offsetY / this.screen.height) * 2 + 1;
      this.dispatchEvent(this.startEvent);
      this.dispatchEvent(this.endEvent);
    });
    __publicField17(this, "touchstart", (event) => {
      if (this.enabled === false)
        return;
      event.preventDefault();
      switch (event.touches.length) {
        case 1:
          this._state = this.STATE.TOUCH_ROTATE;
          this._moveCurr.copy(this.getMouseOnCircle(event.touches[0].pageX, event.touches[0].pageY));
          this._movePrev.copy(this._moveCurr);
          break;
        default:
          this._state = this.STATE.TOUCH_ZOOM_PAN;
          const dx = event.touches[0].pageX - event.touches[1].pageX;
          const dy = event.touches[0].pageY - event.touches[1].pageY;
          this._touchZoomDistanceEnd = this._touchZoomDistanceStart = Math.sqrt(dx * dx + dy * dy);
          const x = (event.touches[0].pageX + event.touches[1].pageX) / 2;
          const y = (event.touches[0].pageY + event.touches[1].pageY) / 2;
          this._panStart.copy(this.getMouseOnScreen(x, y));
          this._panEnd.copy(this._panStart);
          break;
      }
      this.dispatchEvent(this.startEvent);
    });
    __publicField17(this, "touchmove", (event) => {
      if (this.enabled === false)
        return;
      event.preventDefault();
      switch (event.touches.length) {
        case 1:
          this._movePrev.copy(this._moveCurr);
          this._moveCurr.copy(this.getMouseOnCircle(event.touches[0].pageX, event.touches[0].pageY));
          break;
        default:
          const dx = event.touches[0].pageX - event.touches[1].pageX;
          const dy = event.touches[0].pageY - event.touches[1].pageY;
          this._touchZoomDistanceEnd = Math.sqrt(dx * dx + dy * dy);
          const x = (event.touches[0].pageX + event.touches[1].pageX) / 2;
          const y = (event.touches[0].pageY + event.touches[1].pageY) / 2;
          this._panEnd.copy(this.getMouseOnScreen(x, y));
          break;
      }
    });
    __publicField17(this, "touchend", (event) => {
      if (this.enabled === false)
        return;
      switch (event.touches.length) {
        case 0:
          this._state = this.STATE.NONE;
          break;
        case 1:
          this._state = this.STATE.TOUCH_ROTATE;
          this._moveCurr.copy(this.getMouseOnCircle(event.touches[0].pageX, event.touches[0].pageY));
          this._movePrev.copy(this._moveCurr);
          break;
      }
      this.dispatchEvent(this.endEvent);
    });
    __publicField17(this, "contextmenu", (event) => {
      if (this.enabled === false)
        return;
      event.preventDefault();
    });
    __publicField17(this, "connect", (domElement2) => {
      if (domElement2 === document) {
        console.error(
          'THREE.OrbitControls: "document" should not be used as the target "domElement". Please use "renderer.domElement" instead.'
        );
      }
      this.domElement = domElement2;
      this.domElement.addEventListener("contextmenu", this.contextmenu);
      this.domElement.addEventListener("pointerdown", this.onPointerDown);
      this.domElement.addEventListener("wheel", this.mousewheel);
      this.domElement.addEventListener("touchstart", this.touchstart);
      this.domElement.addEventListener("touchend", this.touchend);
      this.domElement.addEventListener("touchmove", this.touchmove);
      this.domElement.ownerDocument.addEventListener("pointermove", this.onPointerMove);
      this.domElement.ownerDocument.addEventListener("pointerup", this.onPointerUp);
      window.addEventListener("keydown", this.keydown);
      window.addEventListener("keyup", this.keyup);
      this.handleResize();
    });
    __publicField17(this, "dispose", () => {
      if (!this.domElement)
        return;
      this.domElement.removeEventListener("contextmenu", this.contextmenu);
      this.domElement.removeEventListener("pointerdown", this.onPointerDown);
      this.domElement.removeEventListener("wheel", this.mousewheel);
      this.domElement.removeEventListener("touchstart", this.touchstart);
      this.domElement.removeEventListener("touchend", this.touchend);
      this.domElement.removeEventListener("touchmove", this.touchmove);
      this.domElement.ownerDocument.removeEventListener("pointermove", this.onPointerMove);
      this.domElement.ownerDocument.removeEventListener("pointerup", this.onPointerUp);
      window.removeEventListener("keydown", this.keydown);
      window.removeEventListener("keyup", this.keyup);
    });
    this.object = object;
    this.target0 = this.target.clone();
    this.position0 = this.object.position.clone();
    this.up0 = this.object.up.clone();
    this.zoom0 = this.object.zoom;
    if (domElement !== void 0)
      this.connect(domElement);
    this.update();
  }
};

// node_modules/three-stdlib/controls/OrbitControls.js
var __defProp17 = Object.defineProperty;
var __defNormalProp17 = (obj, key, value) => key in obj ? __defProp17(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField18 = (obj, key, value) => {
  __defNormalProp17(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var _ray = new Ray();
var _plane3 = new Plane();
var TILT_LIMIT = Math.cos(70 * (Math.PI / 180));
var moduloWrapAround = (offset, capacity) => (offset % capacity + capacity) % capacity;
var OrbitControls = class extends EventDispatcher2 {
  constructor(object, domElement) {
    super();
    __publicField18(this, "object");
    __publicField18(this, "domElement");
    __publicField18(this, "enabled", true);
    __publicField18(this, "target", new Vector3());
    __publicField18(this, "minDistance", 0);
    __publicField18(this, "maxDistance", Infinity);
    __publicField18(this, "minZoom", 0);
    __publicField18(this, "maxZoom", Infinity);
    __publicField18(this, "minPolarAngle", 0);
    __publicField18(this, "maxPolarAngle", Math.PI);
    __publicField18(this, "minAzimuthAngle", -Infinity);
    __publicField18(this, "maxAzimuthAngle", Infinity);
    __publicField18(this, "enableDamping", false);
    __publicField18(this, "dampingFactor", 0.05);
    __publicField18(this, "enableZoom", true);
    __publicField18(this, "zoomSpeed", 1);
    __publicField18(this, "enableRotate", true);
    __publicField18(this, "rotateSpeed", 1);
    __publicField18(this, "enablePan", true);
    __publicField18(this, "panSpeed", 1);
    __publicField18(this, "screenSpacePanning", true);
    __publicField18(this, "keyPanSpeed", 7);
    __publicField18(this, "zoomToCursor", false);
    __publicField18(this, "autoRotate", false);
    __publicField18(this, "autoRotateSpeed", 2);
    __publicField18(this, "reverseOrbit", false);
    __publicField18(this, "reverseHorizontalOrbit", false);
    __publicField18(this, "reverseVerticalOrbit", false);
    __publicField18(this, "keys", { LEFT: "ArrowLeft", UP: "ArrowUp", RIGHT: "ArrowRight", BOTTOM: "ArrowDown" });
    __publicField18(this, "mouseButtons", {
      LEFT: MOUSE.ROTATE,
      MIDDLE: MOUSE.DOLLY,
      RIGHT: MOUSE.PAN
    });
    __publicField18(this, "touches", { ONE: TOUCH.ROTATE, TWO: TOUCH.DOLLY_PAN });
    __publicField18(this, "target0");
    __publicField18(this, "position0");
    __publicField18(this, "zoom0");
    __publicField18(this, "_domElementKeyEvents", null);
    __publicField18(this, "getPolarAngle");
    __publicField18(this, "getAzimuthalAngle");
    __publicField18(this, "setPolarAngle");
    __publicField18(this, "setAzimuthalAngle");
    __publicField18(this, "getDistance");
    __publicField18(this, "getZoomScale");
    __publicField18(this, "listenToKeyEvents");
    __publicField18(this, "stopListenToKeyEvents");
    __publicField18(this, "saveState");
    __publicField18(this, "reset");
    __publicField18(this, "update");
    __publicField18(this, "connect");
    __publicField18(this, "dispose");
    __publicField18(this, "dollyIn");
    __publicField18(this, "dollyOut");
    __publicField18(this, "getScale");
    __publicField18(this, "setScale");
    this.object = object;
    this.domElement = domElement;
    this.target0 = this.target.clone();
    this.position0 = this.object.position.clone();
    this.zoom0 = this.object.zoom;
    this.getPolarAngle = () => spherical2.phi;
    this.getAzimuthalAngle = () => spherical2.theta;
    this.setPolarAngle = (value) => {
      let phi = moduloWrapAround(value, 2 * Math.PI);
      let currentPhi = spherical2.phi;
      if (currentPhi < 0)
        currentPhi += 2 * Math.PI;
      if (phi < 0)
        phi += 2 * Math.PI;
      let phiDist = Math.abs(phi - currentPhi);
      if (2 * Math.PI - phiDist < phiDist) {
        if (phi < currentPhi) {
          phi += 2 * Math.PI;
        } else {
          currentPhi += 2 * Math.PI;
        }
      }
      sphericalDelta.phi = phi - currentPhi;
      scope.update();
    };
    this.setAzimuthalAngle = (value) => {
      let theta = moduloWrapAround(value, 2 * Math.PI);
      let currentTheta = spherical2.theta;
      if (currentTheta < 0)
        currentTheta += 2 * Math.PI;
      if (theta < 0)
        theta += 2 * Math.PI;
      let thetaDist = Math.abs(theta - currentTheta);
      if (2 * Math.PI - thetaDist < thetaDist) {
        if (theta < currentTheta) {
          theta += 2 * Math.PI;
        } else {
          currentTheta += 2 * Math.PI;
        }
      }
      sphericalDelta.theta = theta - currentTheta;
      scope.update();
    };
    this.getDistance = () => scope.object.position.distanceTo(scope.target);
    this.listenToKeyEvents = (domElement2) => {
      domElement2.addEventListener("keydown", onKeyDown);
      this._domElementKeyEvents = domElement2;
    };
    this.stopListenToKeyEvents = () => {
      this._domElementKeyEvents.removeEventListener("keydown", onKeyDown);
      this._domElementKeyEvents = null;
    };
    this.saveState = () => {
      scope.target0.copy(scope.target);
      scope.position0.copy(scope.object.position);
      scope.zoom0 = scope.object.zoom;
    };
    this.reset = () => {
      scope.target.copy(scope.target0);
      scope.object.position.copy(scope.position0);
      scope.object.zoom = scope.zoom0;
      scope.object.updateProjectionMatrix();
      scope.dispatchEvent(changeEvent);
      scope.update();
      state = STATE3.NONE;
    };
    this.update = (() => {
      const offset = new Vector3();
      const up = new Vector3(0, 1, 0);
      const quat = new Quaternion().setFromUnitVectors(object.up, up);
      const quatInverse = quat.clone().invert();
      const lastPosition = new Vector3();
      const lastQuaternion = new Quaternion();
      const twoPI = 2 * Math.PI;
      return function update2() {
        const position2 = scope.object.position;
        quat.setFromUnitVectors(object.up, up);
        quatInverse.copy(quat).invert();
        offset.copy(position2).sub(scope.target);
        offset.applyQuaternion(quat);
        spherical2.setFromVector3(offset);
        if (scope.autoRotate && state === STATE3.NONE) {
          rotateLeft(getAutoRotationAngle());
        }
        if (scope.enableDamping) {
          spherical2.theta += sphericalDelta.theta * scope.dampingFactor;
          spherical2.phi += sphericalDelta.phi * scope.dampingFactor;
        } else {
          spherical2.theta += sphericalDelta.theta;
          spherical2.phi += sphericalDelta.phi;
        }
        let min = scope.minAzimuthAngle;
        let max2 = scope.maxAzimuthAngle;
        if (isFinite(min) && isFinite(max2)) {
          if (min < -Math.PI)
            min += twoPI;
          else if (min > Math.PI)
            min -= twoPI;
          if (max2 < -Math.PI)
            max2 += twoPI;
          else if (max2 > Math.PI)
            max2 -= twoPI;
          if (min <= max2) {
            spherical2.theta = Math.max(min, Math.min(max2, spherical2.theta));
          } else {
            spherical2.theta = spherical2.theta > (min + max2) / 2 ? Math.max(min, spherical2.theta) : Math.min(max2, spherical2.theta);
          }
        }
        spherical2.phi = Math.max(scope.minPolarAngle, Math.min(scope.maxPolarAngle, spherical2.phi));
        spherical2.makeSafe();
        if (scope.enableDamping === true) {
          scope.target.addScaledVector(panOffset, scope.dampingFactor);
        } else {
          scope.target.add(panOffset);
        }
        if (scope.zoomToCursor && performCursorZoom || scope.object.isOrthographicCamera) {
          spherical2.radius = clampDistance(spherical2.radius);
        } else {
          spherical2.radius = clampDistance(spherical2.radius * scale5);
        }
        offset.setFromSpherical(spherical2);
        offset.applyQuaternion(quatInverse);
        position2.copy(scope.target).add(offset);
        if (!scope.object.matrixAutoUpdate)
          scope.object.updateMatrix();
        scope.object.lookAt(scope.target);
        if (scope.enableDamping === true) {
          sphericalDelta.theta *= 1 - scope.dampingFactor;
          sphericalDelta.phi *= 1 - scope.dampingFactor;
          panOffset.multiplyScalar(1 - scope.dampingFactor);
        } else {
          sphericalDelta.set(0, 0, 0);
          panOffset.set(0, 0, 0);
        }
        let zoomChanged = false;
        if (scope.zoomToCursor && performCursorZoom) {
          let newRadius = null;
          if (scope.object instanceof PerspectiveCamera && scope.object.isPerspectiveCamera) {
            const prevRadius = offset.length();
            newRadius = clampDistance(prevRadius * scale5);
            const radiusDelta = prevRadius - newRadius;
            scope.object.position.addScaledVector(dollyDirection, radiusDelta);
            scope.object.updateMatrixWorld();
          } else if (scope.object.isOrthographicCamera) {
            const mouseBefore = new Vector3(mouse.x, mouse.y, 0);
            mouseBefore.unproject(scope.object);
            scope.object.zoom = Math.max(scope.minZoom, Math.min(scope.maxZoom, scope.object.zoom / scale5));
            scope.object.updateProjectionMatrix();
            zoomChanged = true;
            const mouseAfter = new Vector3(mouse.x, mouse.y, 0);
            mouseAfter.unproject(scope.object);
            scope.object.position.sub(mouseAfter).add(mouseBefore);
            scope.object.updateMatrixWorld();
            newRadius = offset.length();
          } else {
            console.warn("WARNING: OrbitControls.js encountered an unknown camera type - zoom to cursor disabled.");
            scope.zoomToCursor = false;
          }
          if (newRadius !== null) {
            if (scope.screenSpacePanning) {
              scope.target.set(0, 0, -1).transformDirection(scope.object.matrix).multiplyScalar(newRadius).add(scope.object.position);
            } else {
              _ray.origin.copy(scope.object.position);
              _ray.direction.set(0, 0, -1).transformDirection(scope.object.matrix);
              if (Math.abs(scope.object.up.dot(_ray.direction)) < TILT_LIMIT) {
                object.lookAt(scope.target);
              } else {
                _plane3.setFromNormalAndCoplanarPoint(scope.object.up, scope.target);
                _ray.intersectPlane(_plane3, scope.target);
              }
            }
          }
        } else if (scope.object instanceof OrthographicCamera && scope.object.isOrthographicCamera) {
          zoomChanged = scale5 !== 1;
          if (zoomChanged) {
            scope.object.zoom = Math.max(scope.minZoom, Math.min(scope.maxZoom, scope.object.zoom / scale5));
            scope.object.updateProjectionMatrix();
          }
        }
        scale5 = 1;
        performCursorZoom = false;
        if (zoomChanged || lastPosition.distanceToSquared(scope.object.position) > EPS2 || 8 * (1 - lastQuaternion.dot(scope.object.quaternion)) > EPS2) {
          scope.dispatchEvent(changeEvent);
          lastPosition.copy(scope.object.position);
          lastQuaternion.copy(scope.object.quaternion);
          zoomChanged = false;
          return true;
        }
        return false;
      };
    })();
    this.connect = (domElement2) => {
      scope.domElement = domElement2;
      scope.domElement.style.touchAction = "none";
      scope.domElement.addEventListener("contextmenu", onContextMenu);
      scope.domElement.addEventListener("pointerdown", onPointerDown);
      scope.domElement.addEventListener("pointercancel", onPointerUp);
      scope.domElement.addEventListener("wheel", onMouseWheel);
    };
    this.dispose = () => {
      var _a4, _b3, _c, _d, _e, _f;
      if (scope.domElement) {
        scope.domElement.style.touchAction = "auto";
      }
      (_a4 = scope.domElement) == null ? void 0 : _a4.removeEventListener("contextmenu", onContextMenu);
      (_b3 = scope.domElement) == null ? void 0 : _b3.removeEventListener("pointerdown", onPointerDown);
      (_c = scope.domElement) == null ? void 0 : _c.removeEventListener("pointercancel", onPointerUp);
      (_d = scope.domElement) == null ? void 0 : _d.removeEventListener("wheel", onMouseWheel);
      (_e = scope.domElement) == null ? void 0 : _e.ownerDocument.removeEventListener("pointermove", onPointerMove);
      (_f = scope.domElement) == null ? void 0 : _f.ownerDocument.removeEventListener("pointerup", onPointerUp);
      if (scope._domElementKeyEvents !== null) {
        scope._domElementKeyEvents.removeEventListener("keydown", onKeyDown);
      }
    };
    const scope = this;
    const changeEvent = { type: "change" };
    const startEvent = { type: "start" };
    const endEvent = { type: "end" };
    const STATE3 = {
      NONE: -1,
      ROTATE: 0,
      DOLLY: 1,
      PAN: 2,
      TOUCH_ROTATE: 3,
      TOUCH_PAN: 4,
      TOUCH_DOLLY_PAN: 5,
      TOUCH_DOLLY_ROTATE: 6
    };
    let state = STATE3.NONE;
    const EPS2 = 1e-6;
    const spherical2 = new Spherical();
    const sphericalDelta = new Spherical();
    let scale5 = 1;
    const panOffset = new Vector3();
    const rotateStart = new Vector2();
    const rotateEnd = new Vector2();
    const rotateDelta = new Vector2();
    const panStart = new Vector2();
    const panEnd = new Vector2();
    const panDelta = new Vector2();
    const dollyStart = new Vector2();
    const dollyEnd = new Vector2();
    const dollyDelta = new Vector2();
    const dollyDirection = new Vector3();
    const mouse = new Vector2();
    let performCursorZoom = false;
    const pointers = [];
    const pointerPositions = {};
    function getAutoRotationAngle() {
      return 2 * Math.PI / 60 / 60 * scope.autoRotateSpeed;
    }
    function getZoomScale() {
      return Math.pow(0.95, scope.zoomSpeed);
    }
    function rotateLeft(angle) {
      if (scope.reverseOrbit || scope.reverseHorizontalOrbit) {
        sphericalDelta.theta += angle;
      } else {
        sphericalDelta.theta -= angle;
      }
    }
    function rotateUp(angle) {
      if (scope.reverseOrbit || scope.reverseVerticalOrbit) {
        sphericalDelta.phi += angle;
      } else {
        sphericalDelta.phi -= angle;
      }
    }
    const panLeft = (() => {
      const v5 = new Vector3();
      return function panLeft2(distance3, objectMatrix) {
        v5.setFromMatrixColumn(objectMatrix, 0);
        v5.multiplyScalar(-distance3);
        panOffset.add(v5);
      };
    })();
    const panUp = (() => {
      const v5 = new Vector3();
      return function panUp2(distance3, objectMatrix) {
        if (scope.screenSpacePanning === true) {
          v5.setFromMatrixColumn(objectMatrix, 1);
        } else {
          v5.setFromMatrixColumn(objectMatrix, 0);
          v5.crossVectors(scope.object.up, v5);
        }
        v5.multiplyScalar(distance3);
        panOffset.add(v5);
      };
    })();
    const pan = (() => {
      const offset = new Vector3();
      return function pan2(deltaX, deltaY) {
        const element = scope.domElement;
        if (element && scope.object instanceof PerspectiveCamera && scope.object.isPerspectiveCamera) {
          const position2 = scope.object.position;
          offset.copy(position2).sub(scope.target);
          let targetDistance = offset.length();
          targetDistance *= Math.tan(scope.object.fov / 2 * Math.PI / 180);
          panLeft(2 * deltaX * targetDistance / element.clientHeight, scope.object.matrix);
          panUp(2 * deltaY * targetDistance / element.clientHeight, scope.object.matrix);
        } else if (element && scope.object instanceof OrthographicCamera && scope.object.isOrthographicCamera) {
          panLeft(
            deltaX * (scope.object.right - scope.object.left) / scope.object.zoom / element.clientWidth,
            scope.object.matrix
          );
          panUp(
            deltaY * (scope.object.top - scope.object.bottom) / scope.object.zoom / element.clientHeight,
            scope.object.matrix
          );
        } else {
          console.warn("WARNING: OrbitControls.js encountered an unknown camera type - pan disabled.");
          scope.enablePan = false;
        }
      };
    })();
    function setScale(newScale) {
      if (scope.object instanceof PerspectiveCamera && scope.object.isPerspectiveCamera || scope.object instanceof OrthographicCamera && scope.object.isOrthographicCamera) {
        scale5 = newScale;
      } else {
        console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled.");
        scope.enableZoom = false;
      }
    }
    function dollyOut(dollyScale) {
      setScale(scale5 / dollyScale);
    }
    function dollyIn(dollyScale) {
      setScale(scale5 * dollyScale);
    }
    function updateMouseParameters(event) {
      if (!scope.zoomToCursor || !scope.domElement) {
        return;
      }
      performCursorZoom = true;
      const rect = scope.domElement.getBoundingClientRect();
      const x = event.clientX - rect.left;
      const y = event.clientY - rect.top;
      const w = rect.width;
      const h = rect.height;
      mouse.x = x / w * 2 - 1;
      mouse.y = -(y / h) * 2 + 1;
      dollyDirection.set(mouse.x, mouse.y, 1).unproject(scope.object).sub(scope.object.position).normalize();
    }
    function clampDistance(dist) {
      return Math.max(scope.minDistance, Math.min(scope.maxDistance, dist));
    }
    function handleMouseDownRotate(event) {
      rotateStart.set(event.clientX, event.clientY);
    }
    function handleMouseDownDolly(event) {
      updateMouseParameters(event);
      dollyStart.set(event.clientX, event.clientY);
    }
    function handleMouseDownPan(event) {
      panStart.set(event.clientX, event.clientY);
    }
    function handleMouseMoveRotate(event) {
      rotateEnd.set(event.clientX, event.clientY);
      rotateDelta.subVectors(rotateEnd, rotateStart).multiplyScalar(scope.rotateSpeed);
      const element = scope.domElement;
      if (element) {
        rotateLeft(2 * Math.PI * rotateDelta.x / element.clientHeight);
        rotateUp(2 * Math.PI * rotateDelta.y / element.clientHeight);
      }
      rotateStart.copy(rotateEnd);
      scope.update();
    }
    function handleMouseMoveDolly(event) {
      dollyEnd.set(event.clientX, event.clientY);
      dollyDelta.subVectors(dollyEnd, dollyStart);
      if (dollyDelta.y > 0) {
        dollyOut(getZoomScale());
      } else if (dollyDelta.y < 0) {
        dollyIn(getZoomScale());
      }
      dollyStart.copy(dollyEnd);
      scope.update();
    }
    function handleMouseMovePan(event) {
      panEnd.set(event.clientX, event.clientY);
      panDelta.subVectors(panEnd, panStart).multiplyScalar(scope.panSpeed);
      pan(panDelta.x, panDelta.y);
      panStart.copy(panEnd);
      scope.update();
    }
    function handleMouseWheel(event) {
      updateMouseParameters(event);
      if (event.deltaY < 0) {
        dollyIn(getZoomScale());
      } else if (event.deltaY > 0) {
        dollyOut(getZoomScale());
      }
      scope.update();
    }
    function handleKeyDown(event) {
      let needsUpdate = false;
      switch (event.code) {
        case scope.keys.UP:
          pan(0, scope.keyPanSpeed);
          needsUpdate = true;
          break;
        case scope.keys.BOTTOM:
          pan(0, -scope.keyPanSpeed);
          needsUpdate = true;
          break;
        case scope.keys.LEFT:
          pan(scope.keyPanSpeed, 0);
          needsUpdate = true;
          break;
        case scope.keys.RIGHT:
          pan(-scope.keyPanSpeed, 0);
          needsUpdate = true;
          break;
      }
      if (needsUpdate) {
        event.preventDefault();
        scope.update();
      }
    }
    function handleTouchStartRotate() {
      if (pointers.length == 1) {
        rotateStart.set(pointers[0].pageX, pointers[0].pageY);
      } else {
        const x = 0.5 * (pointers[0].pageX + pointers[1].pageX);
        const y = 0.5 * (pointers[0].pageY + pointers[1].pageY);
        rotateStart.set(x, y);
      }
    }
    function handleTouchStartPan() {
      if (pointers.length == 1) {
        panStart.set(pointers[0].pageX, pointers[0].pageY);
      } else {
        const x = 0.5 * (pointers[0].pageX + pointers[1].pageX);
        const y = 0.5 * (pointers[0].pageY + pointers[1].pageY);
        panStart.set(x, y);
      }
    }
    function handleTouchStartDolly() {
      const dx = pointers[0].pageX - pointers[1].pageX;
      const dy = pointers[0].pageY - pointers[1].pageY;
      const distance3 = Math.sqrt(dx * dx + dy * dy);
      dollyStart.set(0, distance3);
    }
    function handleTouchStartDollyPan() {
      if (scope.enableZoom)
        handleTouchStartDolly();
      if (scope.enablePan)
        handleTouchStartPan();
    }
    function handleTouchStartDollyRotate() {
      if (scope.enableZoom)
        handleTouchStartDolly();
      if (scope.enableRotate)
        handleTouchStartRotate();
    }
    function handleTouchMoveRotate(event) {
      if (pointers.length == 1) {
        rotateEnd.set(event.pageX, event.pageY);
      } else {
        const position2 = getSecondPointerPosition(event);
        const x = 0.5 * (event.pageX + position2.x);
        const y = 0.5 * (event.pageY + position2.y);
        rotateEnd.set(x, y);
      }
      rotateDelta.subVectors(rotateEnd, rotateStart).multiplyScalar(scope.rotateSpeed);
      const element = scope.domElement;
      if (element) {
        rotateLeft(2 * Math.PI * rotateDelta.x / element.clientHeight);
        rotateUp(2 * Math.PI * rotateDelta.y / element.clientHeight);
      }
      rotateStart.copy(rotateEnd);
    }
    function handleTouchMovePan(event) {
      if (pointers.length == 1) {
        panEnd.set(event.pageX, event.pageY);
      } else {
        const position2 = getSecondPointerPosition(event);
        const x = 0.5 * (event.pageX + position2.x);
        const y = 0.5 * (event.pageY + position2.y);
        panEnd.set(x, y);
      }
      panDelta.subVectors(panEnd, panStart).multiplyScalar(scope.panSpeed);
      pan(panDelta.x, panDelta.y);
      panStart.copy(panEnd);
    }
    function handleTouchMoveDolly(event) {
      const position2 = getSecondPointerPosition(event);
      const dx = event.pageX - position2.x;
      const dy = event.pageY - position2.y;
      const distance3 = Math.sqrt(dx * dx + dy * dy);
      dollyEnd.set(0, distance3);
      dollyDelta.set(0, Math.pow(dollyEnd.y / dollyStart.y, scope.zoomSpeed));
      dollyOut(dollyDelta.y);
      dollyStart.copy(dollyEnd);
    }
    function handleTouchMoveDollyPan(event) {
      if (scope.enableZoom)
        handleTouchMoveDolly(event);
      if (scope.enablePan)
        handleTouchMovePan(event);
    }
    function handleTouchMoveDollyRotate(event) {
      if (scope.enableZoom)
        handleTouchMoveDolly(event);
      if (scope.enableRotate)
        handleTouchMoveRotate(event);
    }
    function onPointerDown(event) {
      var _a4, _b3;
      if (scope.enabled === false)
        return;
      if (pointers.length === 0) {
        (_a4 = scope.domElement) == null ? void 0 : _a4.ownerDocument.addEventListener("pointermove", onPointerMove);
        (_b3 = scope.domElement) == null ? void 0 : _b3.ownerDocument.addEventListener("pointerup", onPointerUp);
      }
      addPointer(event);
      if (event.pointerType === "touch") {
        onTouchStart(event);
      } else {
        onMouseDown(event);
      }
    }
    function onPointerMove(event) {
      if (scope.enabled === false)
        return;
      if (event.pointerType === "touch") {
        onTouchMove(event);
      } else {
        onMouseMove(event);
      }
    }
    function onPointerUp(event) {
      var _a4, _b3, _c;
      removePointer(event);
      if (pointers.length === 0) {
        (_a4 = scope.domElement) == null ? void 0 : _a4.releasePointerCapture(event.pointerId);
        (_b3 = scope.domElement) == null ? void 0 : _b3.ownerDocument.removeEventListener("pointermove", onPointerMove);
        (_c = scope.domElement) == null ? void 0 : _c.ownerDocument.removeEventListener("pointerup", onPointerUp);
      }
      scope.dispatchEvent(endEvent);
      state = STATE3.NONE;
    }
    function onMouseDown(event) {
      let mouseAction;
      switch (event.button) {
        case 0:
          mouseAction = scope.mouseButtons.LEFT;
          break;
        case 1:
          mouseAction = scope.mouseButtons.MIDDLE;
          break;
        case 2:
          mouseAction = scope.mouseButtons.RIGHT;
          break;
        default:
          mouseAction = -1;
      }
      switch (mouseAction) {
        case MOUSE.DOLLY:
          if (scope.enableZoom === false)
            return;
          handleMouseDownDolly(event);
          state = STATE3.DOLLY;
          break;
        case MOUSE.ROTATE:
          if (event.ctrlKey || event.metaKey || event.shiftKey) {
            if (scope.enablePan === false)
              return;
            handleMouseDownPan(event);
            state = STATE3.PAN;
          } else {
            if (scope.enableRotate === false)
              return;
            handleMouseDownRotate(event);
            state = STATE3.ROTATE;
          }
          break;
        case MOUSE.PAN:
          if (event.ctrlKey || event.metaKey || event.shiftKey) {
            if (scope.enableRotate === false)
              return;
            handleMouseDownRotate(event);
            state = STATE3.ROTATE;
          } else {
            if (scope.enablePan === false)
              return;
            handleMouseDownPan(event);
            state = STATE3.PAN;
          }
          break;
        default:
          state = STATE3.NONE;
      }
      if (state !== STATE3.NONE) {
        scope.dispatchEvent(startEvent);
      }
    }
    function onMouseMove(event) {
      if (scope.enabled === false)
        return;
      switch (state) {
        case STATE3.ROTATE:
          if (scope.enableRotate === false)
            return;
          handleMouseMoveRotate(event);
          break;
        case STATE3.DOLLY:
          if (scope.enableZoom === false)
            return;
          handleMouseMoveDolly(event);
          break;
        case STATE3.PAN:
          if (scope.enablePan === false)
            return;
          handleMouseMovePan(event);
          break;
      }
    }
    function onMouseWheel(event) {
      if (scope.enabled === false || scope.enableZoom === false || state !== STATE3.NONE && state !== STATE3.ROTATE) {
        return;
      }
      event.preventDefault();
      scope.dispatchEvent(startEvent);
      handleMouseWheel(event);
      scope.dispatchEvent(endEvent);
    }
    function onKeyDown(event) {
      if (scope.enabled === false || scope.enablePan === false)
        return;
      handleKeyDown(event);
    }
    function onTouchStart(event) {
      trackPointer(event);
      switch (pointers.length) {
        case 1:
          switch (scope.touches.ONE) {
            case TOUCH.ROTATE:
              if (scope.enableRotate === false)
                return;
              handleTouchStartRotate();
              state = STATE3.TOUCH_ROTATE;
              break;
            case TOUCH.PAN:
              if (scope.enablePan === false)
                return;
              handleTouchStartPan();
              state = STATE3.TOUCH_PAN;
              break;
            default:
              state = STATE3.NONE;
          }
          break;
        case 2:
          switch (scope.touches.TWO) {
            case TOUCH.DOLLY_PAN:
              if (scope.enableZoom === false && scope.enablePan === false)
                return;
              handleTouchStartDollyPan();
              state = STATE3.TOUCH_DOLLY_PAN;
              break;
            case TOUCH.DOLLY_ROTATE:
              if (scope.enableZoom === false && scope.enableRotate === false)
                return;
              handleTouchStartDollyRotate();
              state = STATE3.TOUCH_DOLLY_ROTATE;
              break;
            default:
              state = STATE3.NONE;
          }
          break;
        default:
          state = STATE3.NONE;
      }
      if (state !== STATE3.NONE) {
        scope.dispatchEvent(startEvent);
      }
    }
    function onTouchMove(event) {
      trackPointer(event);
      switch (state) {
        case STATE3.TOUCH_ROTATE:
          if (scope.enableRotate === false)
            return;
          handleTouchMoveRotate(event);
          scope.update();
          break;
        case STATE3.TOUCH_PAN:
          if (scope.enablePan === false)
            return;
          handleTouchMovePan(event);
          scope.update();
          break;
        case STATE3.TOUCH_DOLLY_PAN:
          if (scope.enableZoom === false && scope.enablePan === false)
            return;
          handleTouchMoveDollyPan(event);
          scope.update();
          break;
        case STATE3.TOUCH_DOLLY_ROTATE:
          if (scope.enableZoom === false && scope.enableRotate === false)
            return;
          handleTouchMoveDollyRotate(event);
          scope.update();
          break;
        default:
          state = STATE3.NONE;
      }
    }
    function onContextMenu(event) {
      if (scope.enabled === false)
        return;
      event.preventDefault();
    }
    function addPointer(event) {
      pointers.push(event);
    }
    function removePointer(event) {
      delete pointerPositions[event.pointerId];
      for (let i4 = 0; i4 < pointers.length; i4++) {
        if (pointers[i4].pointerId == event.pointerId) {
          pointers.splice(i4, 1);
          return;
        }
      }
    }
    function trackPointer(event) {
      let position2 = pointerPositions[event.pointerId];
      if (position2 === void 0) {
        position2 = new Vector2();
        pointerPositions[event.pointerId] = position2;
      }
      position2.set(event.pageX, event.pageY);
    }
    function getSecondPointerPosition(event) {
      const pointer = event.pointerId === pointers[0].pointerId ? pointers[1] : pointers[0];
      return pointerPositions[pointer.pointerId];
    }
    this.dollyIn = (dollyScale = getZoomScale()) => {
      dollyIn(dollyScale);
      scope.update();
    };
    this.dollyOut = (dollyScale = getZoomScale()) => {
      dollyOut(dollyScale);
      scope.update();
    };
    this.getScale = () => {
      return scale5;
    };
    this.setScale = (newScale) => {
      setScale(newScale);
      scope.update();
    };
    this.getZoomScale = () => {
      return getZoomScale();
    };
    if (domElement !== void 0)
      this.connect(domElement);
    this.update();
  }
};
var MapControls = class extends OrbitControls {
  constructor(object, domElement) {
    super(object, domElement);
    this.screenSpacePanning = false;
    this.mouseButtons.LEFT = MOUSE.PAN;
    this.mouseButtons.RIGHT = MOUSE.ROTATE;
    this.touches.ONE = TOUCH.PAN;
    this.touches.TWO = TOUCH.DOLLY_ROTATE;
  }
};

// node_modules/three-stdlib/controls/ArcballControls.js
var __defProp18 = Object.defineProperty;
var __defNormalProp18 = (obj, key, value) => key in obj ? __defProp18(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField19 = (obj, key, value) => {
  __defNormalProp18(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var STATE = {
  IDLE: Symbol(),
  ROTATE: Symbol(),
  PAN: Symbol(),
  SCALE: Symbol(),
  FOV: Symbol(),
  FOCUS: Symbol(),
  ZROTATE: Symbol(),
  TOUCH_MULTI: Symbol(),
  ANIMATION_FOCUS: Symbol(),
  ANIMATION_ROTATE: Symbol()
};
var INPUT = {
  NONE: Symbol(),
  ONE_FINGER: Symbol(),
  ONE_FINGER_SWITCHED: Symbol(),
  TWO_FINGER: Symbol(),
  MULT_FINGER: Symbol(),
  CURSOR: Symbol()
};
var _center = {
  x: 0,
  y: 0
};
var _transformation = {
  camera: new Matrix4(),
  gizmos: new Matrix4()
};
var _changeEvent2 = { type: "change" };
var _startEvent = { type: "start" };
var _endEvent = { type: "end" };
var ArcballControls = class extends EventDispatcher2 {
  constructor(camera, domElement = null, scene = null) {
    super();
    __publicField19(this, "camera");
    __publicField19(this, "domElement");
    __publicField19(this, "scene");
    __publicField19(this, "mouseActions");
    __publicField19(this, "_mouseOp");
    __publicField19(this, "_v2_1");
    __publicField19(this, "_v3_1");
    __publicField19(this, "_v3_2");
    __publicField19(this, "_m4_1");
    __publicField19(this, "_m4_2");
    __publicField19(this, "_quat");
    __publicField19(this, "_translationMatrix");
    __publicField19(this, "_rotationMatrix");
    __publicField19(this, "_scaleMatrix");
    __publicField19(this, "_rotationAxis");
    __publicField19(this, "_cameraMatrixState");
    __publicField19(this, "_cameraProjectionState");
    __publicField19(this, "_fovState");
    __publicField19(this, "_upState");
    __publicField19(this, "_zoomState");
    __publicField19(this, "_nearPos");
    __publicField19(this, "_farPos");
    __publicField19(this, "_gizmoMatrixState");
    __publicField19(this, "_up0");
    __publicField19(this, "_zoom0");
    __publicField19(this, "_fov0");
    __publicField19(this, "_initialNear");
    __publicField19(this, "_nearPos0");
    __publicField19(this, "_initialFar");
    __publicField19(this, "_farPos0");
    __publicField19(this, "_cameraMatrixState0");
    __publicField19(this, "_gizmoMatrixState0");
    __publicField19(this, "_button");
    __publicField19(this, "_touchStart");
    __publicField19(this, "_touchCurrent");
    __publicField19(this, "_input");
    __publicField19(this, "_switchSensibility");
    __publicField19(this, "_startFingerDistance");
    __publicField19(this, "_currentFingerDistance");
    __publicField19(this, "_startFingerRotation");
    __publicField19(this, "_currentFingerRotation");
    __publicField19(this, "_devPxRatio");
    __publicField19(this, "_downValid");
    __publicField19(this, "_nclicks");
    __publicField19(this, "_downEvents");
    __publicField19(this, "_clickStart");
    __publicField19(this, "_maxDownTime");
    __publicField19(this, "_maxInterval");
    __publicField19(this, "_posThreshold");
    __publicField19(this, "_movementThreshold");
    __publicField19(this, "_currentCursorPosition");
    __publicField19(this, "_startCursorPosition");
    __publicField19(this, "_grid");
    __publicField19(this, "_gridPosition");
    __publicField19(this, "_gizmos");
    __publicField19(this, "_curvePts");
    __publicField19(this, "_timeStart");
    __publicField19(this, "_animationId");
    __publicField19(this, "focusAnimationTime");
    __publicField19(this, "_timePrev");
    __publicField19(this, "_timeCurrent");
    __publicField19(this, "_anglePrev");
    __publicField19(this, "_angleCurrent");
    __publicField19(this, "_cursorPosPrev");
    __publicField19(this, "_cursorPosCurr");
    __publicField19(this, "_wPrev");
    __publicField19(this, "_wCurr");
    __publicField19(this, "adjustNearFar");
    __publicField19(this, "scaleFactor");
    __publicField19(this, "dampingFactor");
    __publicField19(this, "wMax");
    __publicField19(this, "enableAnimations");
    __publicField19(this, "enableGrid");
    __publicField19(this, "cursorZoom");
    __publicField19(this, "minFov");
    __publicField19(this, "maxFov");
    __publicField19(this, "enabled");
    __publicField19(this, "enablePan");
    __publicField19(this, "enableRotate");
    __publicField19(this, "enableZoom");
    __publicField19(this, "minDistance");
    __publicField19(this, "maxDistance");
    __publicField19(this, "minZoom");
    __publicField19(this, "maxZoom");
    __publicField19(this, "target");
    __publicField19(this, "_currentTarget");
    __publicField19(this, "_tbRadius");
    __publicField19(this, "_state");
    __publicField19(this, "onWindowResize", () => {
      const scale5 = (this._gizmos.scale.x + this._gizmos.scale.y + this._gizmos.scale.z) / 3;
      if (this.camera) {
        const tbRadius = this.calculateTbRadius(this.camera);
        if (tbRadius !== void 0) {
          this._tbRadius = tbRadius;
        }
      }
      const newRadius = this._tbRadius / scale5;
      const curve = new EllipseCurve(0, 0, newRadius, newRadius);
      const points = curve.getPoints(this._curvePts);
      const curveGeometry = new BufferGeometry().setFromPoints(points);
      for (const gizmo in this._gizmos.children) {
        const child = this._gizmos.children[gizmo];
        child.geometry = curveGeometry;
      }
      this.dispatchEvent(_changeEvent2);
    });
    __publicField19(this, "onContextMenu", (event) => {
      if (!this.enabled) {
        return;
      }
      for (let i4 = 0; i4 < this.mouseActions.length; i4++) {
        if (this.mouseActions[i4].mouse == 2) {
          event.preventDefault();
          break;
        }
      }
    });
    __publicField19(this, "onPointerCancel", () => {
      this._touchStart.splice(0, this._touchStart.length);
      this._touchCurrent.splice(0, this._touchCurrent.length);
      this._input = INPUT.NONE;
    });
    __publicField19(this, "onPointerDown", (event) => {
      if (event.button == 0 && event.isPrimary) {
        this._downValid = true;
        this._downEvents.push(event);
      } else {
        this._downValid = false;
      }
      if (event.pointerType == "touch" && this._input != INPUT.CURSOR) {
        this._touchStart.push(event);
        this._touchCurrent.push(event);
        switch (this._input) {
          case INPUT.NONE:
            this._input = INPUT.ONE_FINGER;
            this.onSinglePanStart(event, "ROTATE");
            window.addEventListener("pointermove", this.onPointerMove);
            window.addEventListener("pointerup", this.onPointerUp);
            break;
          case INPUT.ONE_FINGER:
          case INPUT.ONE_FINGER_SWITCHED:
            this._input = INPUT.TWO_FINGER;
            this.onRotateStart();
            this.onPinchStart();
            this.onDoublePanStart();
            break;
          case INPUT.TWO_FINGER:
            this._input = INPUT.MULT_FINGER;
            this.onTriplePanStart();
            break;
        }
      } else if (event.pointerType != "touch" && this._input == INPUT.NONE) {
        let modifier = null;
        if (event.ctrlKey || event.metaKey) {
          modifier = "CTRL";
        } else if (event.shiftKey) {
          modifier = "SHIFT";
        }
        this._mouseOp = this.getOpFromAction(event.button, modifier);
        if (this._mouseOp) {
          window.addEventListener("pointermove", this.onPointerMove);
          window.addEventListener("pointerup", this.onPointerUp);
          this._input = INPUT.CURSOR;
          this._button = event.button;
          this.onSinglePanStart(event, this._mouseOp);
        }
      }
    });
    __publicField19(this, "onPointerMove", (event) => {
      if (event.pointerType == "touch" && this._input != INPUT.CURSOR) {
        switch (this._input) {
          case INPUT.ONE_FINGER:
            this.updateTouchEvent(event);
            this.onSinglePanMove(event, STATE.ROTATE);
            break;
          case INPUT.ONE_FINGER_SWITCHED:
            const movement = this.calculatePointersDistance(this._touchCurrent[0], event) * this._devPxRatio;
            if (movement >= this._switchSensibility) {
              this._input = INPUT.ONE_FINGER;
              this.updateTouchEvent(event);
              this.onSinglePanStart(event, "ROTATE");
              break;
            }
            break;
          case INPUT.TWO_FINGER:
            this.updateTouchEvent(event);
            this.onRotateMove();
            this.onPinchMove();
            this.onDoublePanMove();
            break;
          case INPUT.MULT_FINGER:
            this.updateTouchEvent(event);
            this.onTriplePanMove();
            break;
        }
      } else if (event.pointerType != "touch" && this._input == INPUT.CURSOR) {
        let modifier = null;
        if (event.ctrlKey || event.metaKey) {
          modifier = "CTRL";
        } else if (event.shiftKey) {
          modifier = "SHIFT";
        }
        const mouseOpState = this.getOpStateFromAction(this._button, modifier);
        if (mouseOpState) {
          this.onSinglePanMove(event, mouseOpState);
        }
      }
      if (this._downValid) {
        const movement = this.calculatePointersDistance(this._downEvents[this._downEvents.length - 1], event) * this._devPxRatio;
        if (movement > this._movementThreshold) {
          this._downValid = false;
        }
      }
    });
    __publicField19(this, "onPointerUp", (event) => {
      if (event.pointerType == "touch" && this._input != INPUT.CURSOR) {
        const nTouch = this._touchCurrent.length;
        for (let i4 = 0; i4 < nTouch; i4++) {
          if (this._touchCurrent[i4].pointerId == event.pointerId) {
            this._touchCurrent.splice(i4, 1);
            this._touchStart.splice(i4, 1);
            break;
          }
        }
        switch (this._input) {
          case INPUT.ONE_FINGER:
          case INPUT.ONE_FINGER_SWITCHED:
            window.removeEventListener("pointermove", this.onPointerMove);
            window.removeEventListener("pointerup", this.onPointerUp);
            this._input = INPUT.NONE;
            this.onSinglePanEnd();
            break;
          case INPUT.TWO_FINGER:
            this.onDoublePanEnd();
            this.onPinchEnd();
            this.onRotateEnd();
            this._input = INPUT.ONE_FINGER_SWITCHED;
            break;
          case INPUT.MULT_FINGER:
            if (this._touchCurrent.length == 0) {
              window.removeEventListener("pointermove", this.onPointerMove);
              window.removeEventListener("pointerup", this.onPointerUp);
              this._input = INPUT.NONE;
              this.onTriplePanEnd();
            }
            break;
        }
      } else if (event.pointerType != "touch" && this._input == INPUT.CURSOR) {
        window.removeEventListener("pointermove", this.onPointerMove);
        window.removeEventListener("pointerup", this.onPointerUp);
        this._input = INPUT.NONE;
        this.onSinglePanEnd();
        this._button = -1;
      }
      if (event.isPrimary) {
        if (this._downValid) {
          const downTime = event.timeStamp - this._downEvents[this._downEvents.length - 1].timeStamp;
          if (downTime <= this._maxDownTime) {
            if (this._nclicks == 0) {
              this._nclicks = 1;
              this._clickStart = performance.now();
            } else {
              const clickInterval = event.timeStamp - this._clickStart;
              const movement = this.calculatePointersDistance(this._downEvents[1], this._downEvents[0]) * this._devPxRatio;
              if (clickInterval <= this._maxInterval && movement <= this._posThreshold) {
                this._nclicks = 0;
                this._downEvents.splice(0, this._downEvents.length);
                this.onDoubleTap(event);
              } else {
                this._nclicks = 1;
                this._downEvents.shift();
                this._clickStart = performance.now();
              }
            }
          } else {
            this._downValid = false;
            this._nclicks = 0;
            this._downEvents.splice(0, this._downEvents.length);
          }
        } else {
          this._nclicks = 0;
          this._downEvents.splice(0, this._downEvents.length);
        }
      }
    });
    __publicField19(this, "onWheel", (event) => {
      var _a4, _b3;
      if (this.enabled && this.enableZoom && this.domElement) {
        let modifier = null;
        if (event.ctrlKey || event.metaKey) {
          modifier = "CTRL";
        } else if (event.shiftKey) {
          modifier = "SHIFT";
        }
        const mouseOp = this.getOpFromAction("WHEEL", modifier);
        if (mouseOp) {
          event.preventDefault();
          this.dispatchEvent(_startEvent);
          const notchDeltaY = 125;
          let sgn = event.deltaY / notchDeltaY;
          let size2 = 1;
          if (sgn > 0) {
            size2 = 1 / this.scaleFactor;
          } else if (sgn < 0) {
            size2 = this.scaleFactor;
          }
          switch (mouseOp) {
            case "ZOOM":
              this.updateTbState(STATE.SCALE, true);
              if (sgn > 0) {
                size2 = 1 / Math.pow(this.scaleFactor, sgn);
              } else if (sgn < 0) {
                size2 = Math.pow(this.scaleFactor, -sgn);
              }
              if (this.cursorZoom && this.enablePan) {
                let scalePoint;
                if (this.camera instanceof OrthographicCamera) {
                  scalePoint = (_a4 = this.unprojectOnTbPlane(this.camera, event.clientX, event.clientY, this.domElement)) == null ? void 0 : _a4.applyQuaternion(this.camera.quaternion).multiplyScalar(1 / this.camera.zoom).add(this._gizmos.position);
                }
                if (this.camera instanceof PerspectiveCamera) {
                  scalePoint = (_b3 = this.unprojectOnTbPlane(this.camera, event.clientX, event.clientY, this.domElement)) == null ? void 0 : _b3.applyQuaternion(this.camera.quaternion).add(this._gizmos.position);
                }
                if (scalePoint !== void 0)
                  this.applyTransformMatrix(this.applyScale(size2, scalePoint));
              } else {
                this.applyTransformMatrix(this.applyScale(size2, this._gizmos.position));
              }
              if (this._grid) {
                this.disposeGrid();
                this.drawGrid();
              }
              this.updateTbState(STATE.IDLE, false);
              this.dispatchEvent(_changeEvent2);
              this.dispatchEvent(_endEvent);
              break;
            case "FOV":
              if (this.camera instanceof PerspectiveCamera) {
                this.updateTbState(STATE.FOV, true);
                if (event.deltaX != 0) {
                  sgn = event.deltaX / notchDeltaY;
                  size2 = 1;
                  if (sgn > 0) {
                    size2 = 1 / Math.pow(this.scaleFactor, sgn);
                  } else if (sgn < 0) {
                    size2 = Math.pow(this.scaleFactor, -sgn);
                  }
                }
                this._v3_1.setFromMatrixPosition(this._cameraMatrixState);
                const x = this._v3_1.distanceTo(this._gizmos.position);
                let xNew = x / size2;
                xNew = MathUtils.clamp(xNew, this.minDistance, this.maxDistance);
                const y = x * Math.tan(MathUtils.DEG2RAD * this.camera.fov * 0.5);
                let newFov = MathUtils.RAD2DEG * (Math.atan(y / xNew) * 2);
                if (newFov > this.maxFov) {
                  newFov = this.maxFov;
                } else if (newFov < this.minFov) {
                  newFov = this.minFov;
                }
                const newDistance = y / Math.tan(MathUtils.DEG2RAD * (newFov / 2));
                size2 = x / newDistance;
                this.setFov(newFov);
                this.applyTransformMatrix(this.applyScale(size2, this._gizmos.position, false));
              }
              if (this._grid) {
                this.disposeGrid();
                this.drawGrid();
              }
              this.updateTbState(STATE.IDLE, false);
              this.dispatchEvent(_changeEvent2);
              this.dispatchEvent(_endEvent);
              break;
          }
        }
      }
    });
    __publicField19(this, "onSinglePanStart", (event, operation) => {
      if (this.enabled && this.domElement) {
        this.dispatchEvent(_startEvent);
        this.setCenter(event.clientX, event.clientY);
        switch (operation) {
          case "PAN":
            if (!this.enablePan)
              return;
            if (this._animationId != -1) {
              cancelAnimationFrame(this._animationId);
              this._animationId = -1;
              this._timeStart = -1;
              this.activateGizmos(false);
              this.dispatchEvent(_changeEvent2);
            }
            if (this.camera) {
              this.updateTbState(STATE.PAN, true);
              const rayDir = this.unprojectOnTbPlane(this.camera, _center.x, _center.y, this.domElement);
              if (rayDir !== void 0) {
                this._startCursorPosition.copy(rayDir);
              }
              if (this.enableGrid) {
                this.drawGrid();
                this.dispatchEvent(_changeEvent2);
              }
            }
            break;
          case "ROTATE":
            if (!this.enableRotate)
              return;
            if (this._animationId != -1) {
              cancelAnimationFrame(this._animationId);
              this._animationId = -1;
              this._timeStart = -1;
            }
            if (this.camera) {
              this.updateTbState(STATE.ROTATE, true);
              const rayDir = this.unprojectOnTbSurface(this.camera, _center.x, _center.y, this.domElement, this._tbRadius);
              if (rayDir !== void 0) {
                this._startCursorPosition.copy(rayDir);
              }
              this.activateGizmos(true);
              if (this.enableAnimations) {
                this._timePrev = this._timeCurrent = performance.now();
                this._angleCurrent = this._anglePrev = 0;
                this._cursorPosPrev.copy(this._startCursorPosition);
                this._cursorPosCurr.copy(this._cursorPosPrev);
                this._wCurr = 0;
                this._wPrev = this._wCurr;
              }
            }
            this.dispatchEvent(_changeEvent2);
            break;
          case "FOV":
            if (!this.enableZoom)
              return;
            if (this.camera instanceof PerspectiveCamera) {
              if (this._animationId != -1) {
                cancelAnimationFrame(this._animationId);
                this._animationId = -1;
                this._timeStart = -1;
                this.activateGizmos(false);
                this.dispatchEvent(_changeEvent2);
              }
              this.updateTbState(STATE.FOV, true);
              this._startCursorPosition.setY(this.getCursorNDC(_center.x, _center.y, this.domElement).y * 0.5);
              this._currentCursorPosition.copy(this._startCursorPosition);
            }
            break;
          case "ZOOM":
            if (!this.enableZoom)
              return;
            if (this._animationId != -1) {
              cancelAnimationFrame(this._animationId);
              this._animationId = -1;
              this._timeStart = -1;
              this.activateGizmos(false);
              this.dispatchEvent(_changeEvent2);
            }
            this.updateTbState(STATE.SCALE, true);
            this._startCursorPosition.setY(this.getCursorNDC(_center.x, _center.y, this.domElement).y * 0.5);
            this._currentCursorPosition.copy(this._startCursorPosition);
            break;
        }
      }
    });
    __publicField19(this, "onSinglePanMove", (event, opState) => {
      if (this.enabled && this.domElement) {
        const restart = opState != this._state;
        this.setCenter(event.clientX, event.clientY);
        switch (opState) {
          case STATE.PAN:
            if (this.enablePan && this.camera) {
              if (restart) {
                this.dispatchEvent(_endEvent);
                this.dispatchEvent(_startEvent);
                this.updateTbState(opState, true);
                const rayDir = this.unprojectOnTbPlane(this.camera, _center.x, _center.y, this.domElement);
                if (rayDir !== void 0) {
                  this._startCursorPosition.copy(rayDir);
                }
                if (this.enableGrid) {
                  this.drawGrid();
                }
                this.activateGizmos(false);
              } else {
                const rayDir = this.unprojectOnTbPlane(this.camera, _center.x, _center.y, this.domElement);
                if (rayDir !== void 0) {
                  this._currentCursorPosition.copy(rayDir);
                }
                this.applyTransformMatrix(this.pan(this._startCursorPosition, this._currentCursorPosition));
              }
            }
            break;
          case STATE.ROTATE:
            if (this.enableRotate && this.camera) {
              if (restart) {
                this.dispatchEvent(_endEvent);
                this.dispatchEvent(_startEvent);
                this.updateTbState(opState, true);
                const rayDir = this.unprojectOnTbSurface(
                  this.camera,
                  _center.x,
                  _center.y,
                  this.domElement,
                  this._tbRadius
                );
                if (rayDir !== void 0) {
                  this._startCursorPosition.copy(rayDir);
                }
                if (this.enableGrid) {
                  this.disposeGrid();
                }
                this.activateGizmos(true);
              } else {
                const rayDir = this.unprojectOnTbSurface(
                  this.camera,
                  _center.x,
                  _center.y,
                  this.domElement,
                  this._tbRadius
                );
                if (rayDir !== void 0) {
                  this._currentCursorPosition.copy(rayDir);
                }
                const distance3 = this._startCursorPosition.distanceTo(this._currentCursorPosition);
                const angle = this._startCursorPosition.angleTo(this._currentCursorPosition);
                const amount = Math.max(distance3 / this._tbRadius, angle);
                this.applyTransformMatrix(
                  this.rotate(this.calculateRotationAxis(this._startCursorPosition, this._currentCursorPosition), amount)
                );
                if (this.enableAnimations) {
                  this._timePrev = this._timeCurrent;
                  this._timeCurrent = performance.now();
                  this._anglePrev = this._angleCurrent;
                  this._angleCurrent = amount;
                  this._cursorPosPrev.copy(this._cursorPosCurr);
                  this._cursorPosCurr.copy(this._currentCursorPosition);
                  this._wPrev = this._wCurr;
                  this._wCurr = this.calculateAngularSpeed(
                    this._anglePrev,
                    this._angleCurrent,
                    this._timePrev,
                    this._timeCurrent
                  );
                }
              }
            }
            break;
          case STATE.SCALE:
            if (this.enableZoom) {
              if (restart) {
                this.dispatchEvent(_endEvent);
                this.dispatchEvent(_startEvent);
                this.updateTbState(opState, true);
                this._startCursorPosition.setY(this.getCursorNDC(_center.x, _center.y, this.domElement).y * 0.5);
                this._currentCursorPosition.copy(this._startCursorPosition);
                if (this.enableGrid) {
                  this.disposeGrid();
                }
                this.activateGizmos(false);
              } else {
                const screenNotches = 8;
                this._currentCursorPosition.setY(this.getCursorNDC(_center.x, _center.y, this.domElement).y * 0.5);
                const movement = this._currentCursorPosition.y - this._startCursorPosition.y;
                let size2 = 1;
                if (movement < 0) {
                  size2 = 1 / Math.pow(this.scaleFactor, -movement * screenNotches);
                } else if (movement > 0) {
                  size2 = Math.pow(this.scaleFactor, movement * screenNotches);
                }
                this.applyTransformMatrix(this.applyScale(size2, this._gizmos.position));
              }
            }
            break;
          case STATE.FOV:
            if (this.enableZoom && this.camera instanceof PerspectiveCamera) {
              if (restart) {
                this.dispatchEvent(_endEvent);
                this.dispatchEvent(_startEvent);
                this.updateTbState(opState, true);
                this._startCursorPosition.setY(this.getCursorNDC(_center.x, _center.y, this.domElement).y * 0.5);
                this._currentCursorPosition.copy(this._startCursorPosition);
                if (this.enableGrid) {
                  this.disposeGrid();
                }
                this.activateGizmos(false);
              } else {
                const screenNotches = 8;
                this._currentCursorPosition.setY(this.getCursorNDC(_center.x, _center.y, this.domElement).y * 0.5);
                const movement = this._currentCursorPosition.y - this._startCursorPosition.y;
                let size2 = 1;
                if (movement < 0) {
                  size2 = 1 / Math.pow(this.scaleFactor, -movement * screenNotches);
                } else if (movement > 0) {
                  size2 = Math.pow(this.scaleFactor, movement * screenNotches);
                }
                this._v3_1.setFromMatrixPosition(this._cameraMatrixState);
                const x = this._v3_1.distanceTo(this._gizmos.position);
                let xNew = x / size2;
                xNew = MathUtils.clamp(xNew, this.minDistance, this.maxDistance);
                const y = x * Math.tan(MathUtils.DEG2RAD * this._fovState * 0.5);
                let newFov = MathUtils.RAD2DEG * (Math.atan(y / xNew) * 2);
                newFov = MathUtils.clamp(newFov, this.minFov, this.maxFov);
                const newDistance = y / Math.tan(MathUtils.DEG2RAD * (newFov / 2));
                size2 = x / newDistance;
                this._v3_2.setFromMatrixPosition(this._gizmoMatrixState);
                this.setFov(newFov);
                this.applyTransformMatrix(this.applyScale(size2, this._v3_2, false));
                const direction2 = this._gizmos.position.clone().sub(this.camera.position).normalize().multiplyScalar(newDistance / x);
                this._m4_1.makeTranslation(direction2.x, direction2.y, direction2.z);
              }
            }
            break;
        }
        this.dispatchEvent(_changeEvent2);
      }
    });
    __publicField19(this, "onSinglePanEnd", () => {
      if (this._state == STATE.ROTATE) {
        if (!this.enableRotate) {
          return;
        }
        if (this.enableAnimations) {
          const deltaTime = performance.now() - this._timeCurrent;
          if (deltaTime < 120) {
            const w = Math.abs((this._wPrev + this._wCurr) / 2);
            const self2 = this;
            this._animationId = window.requestAnimationFrame(function(t3) {
              self2.updateTbState(STATE.ANIMATION_ROTATE, true);
              const rotationAxis = self2.calculateRotationAxis(self2._cursorPosPrev, self2._cursorPosCurr);
              self2.onRotationAnim(t3, rotationAxis, Math.min(w, self2.wMax));
            });
          } else {
            this.updateTbState(STATE.IDLE, false);
            this.activateGizmos(false);
            this.dispatchEvent(_changeEvent2);
          }
        } else {
          this.updateTbState(STATE.IDLE, false);
          this.activateGizmos(false);
          this.dispatchEvent(_changeEvent2);
        }
      } else if (this._state == STATE.PAN || this._state == STATE.IDLE) {
        this.updateTbState(STATE.IDLE, false);
        if (this.enableGrid) {
          this.disposeGrid();
        }
        this.activateGizmos(false);
        this.dispatchEvent(_changeEvent2);
      }
      this.dispatchEvent(_endEvent);
    });
    __publicField19(this, "onDoubleTap", (event) => {
      if (this.enabled && this.enablePan && this.scene && this.camera && this.domElement) {
        this.dispatchEvent(_startEvent);
        this.setCenter(event.clientX, event.clientY);
        const hitP = this.unprojectOnObj(this.getCursorNDC(_center.x, _center.y, this.domElement), this.camera);
        if (hitP && this.enableAnimations) {
          const self2 = this;
          if (this._animationId != -1) {
            window.cancelAnimationFrame(this._animationId);
          }
          this._timeStart = -1;
          this._animationId = window.requestAnimationFrame(function(t3) {
            self2.updateTbState(STATE.ANIMATION_FOCUS, true);
            self2.onFocusAnim(t3, hitP, self2._cameraMatrixState, self2._gizmoMatrixState);
          });
        } else if (hitP && !this.enableAnimations) {
          this.updateTbState(STATE.FOCUS, true);
          this.focus(hitP, this.scaleFactor);
          this.updateTbState(STATE.IDLE, false);
          this.dispatchEvent(_changeEvent2);
        }
      }
      this.dispatchEvent(_endEvent);
    });
    __publicField19(this, "onDoublePanStart", () => {
      if (this.enabled && this.enablePan && this.camera && this.domElement) {
        this.dispatchEvent(_startEvent);
        this.updateTbState(STATE.PAN, true);
        this.setCenter(
          (this._touchCurrent[0].clientX + this._touchCurrent[1].clientX) / 2,
          (this._touchCurrent[0].clientY + this._touchCurrent[1].clientY) / 2
        );
        const rayDir = this.unprojectOnTbPlane(this.camera, _center.x, _center.y, this.domElement, true);
        if (rayDir !== void 0) {
          this._startCursorPosition.copy(rayDir);
        }
        this._currentCursorPosition.copy(this._startCursorPosition);
        this.activateGizmos(false);
      }
    });
    __publicField19(this, "onDoublePanMove", () => {
      if (this.enabled && this.enablePan && this.camera && this.domElement) {
        this.setCenter(
          (this._touchCurrent[0].clientX + this._touchCurrent[1].clientX) / 2,
          (this._touchCurrent[0].clientY + this._touchCurrent[1].clientY) / 2
        );
        if (this._state != STATE.PAN) {
          this.updateTbState(STATE.PAN, true);
          this._startCursorPosition.copy(this._currentCursorPosition);
        }
        const rayDir = this.unprojectOnTbPlane(this.camera, _center.x, _center.y, this.domElement, true);
        if (rayDir !== void 0)
          this._currentCursorPosition.copy(rayDir);
        this.applyTransformMatrix(this.pan(this._startCursorPosition, this._currentCursorPosition, true));
        this.dispatchEvent(_changeEvent2);
      }
    });
    __publicField19(this, "onDoublePanEnd", () => {
      this.updateTbState(STATE.IDLE, false);
      this.dispatchEvent(_endEvent);
    });
    __publicField19(this, "onRotateStart", () => {
      var _a4;
      if (this.enabled && this.enableRotate) {
        this.dispatchEvent(_startEvent);
        this.updateTbState(STATE.ZROTATE, true);
        this._startFingerRotation = this.getAngle(this._touchCurrent[1], this._touchCurrent[0]) + this.getAngle(this._touchStart[1], this._touchStart[0]);
        this._currentFingerRotation = this._startFingerRotation;
        (_a4 = this.camera) == null ? void 0 : _a4.getWorldDirection(this._rotationAxis);
        if (!this.enablePan && !this.enableZoom) {
          this.activateGizmos(true);
        }
      }
    });
    __publicField19(this, "onRotateMove", () => {
      var _a4;
      if (this.enabled && this.enableRotate && this.camera && this.domElement) {
        this.setCenter(
          (this._touchCurrent[0].clientX + this._touchCurrent[1].clientX) / 2,
          (this._touchCurrent[0].clientY + this._touchCurrent[1].clientY) / 2
        );
        let rotationPoint;
        if (this._state != STATE.ZROTATE) {
          this.updateTbState(STATE.ZROTATE, true);
          this._startFingerRotation = this._currentFingerRotation;
        }
        this._currentFingerRotation = this.getAngle(this._touchCurrent[1], this._touchCurrent[0]) + this.getAngle(this._touchStart[1], this._touchStart[0]);
        if (!this.enablePan) {
          rotationPoint = new Vector3().setFromMatrixPosition(this._gizmoMatrixState);
        } else if (this.camera) {
          this._v3_2.setFromMatrixPosition(this._gizmoMatrixState);
          rotationPoint = (_a4 = this.unprojectOnTbPlane(this.camera, _center.x, _center.y, this.domElement)) == null ? void 0 : _a4.applyQuaternion(this.camera.quaternion).multiplyScalar(1 / this.camera.zoom).add(this._v3_2);
        }
        const amount = MathUtils.DEG2RAD * (this._startFingerRotation - this._currentFingerRotation);
        if (rotationPoint !== void 0) {
          this.applyTransformMatrix(this.zRotate(rotationPoint, amount));
        }
        this.dispatchEvent(_changeEvent2);
      }
    });
    __publicField19(this, "onRotateEnd", () => {
      this.updateTbState(STATE.IDLE, false);
      this.activateGizmos(false);
      this.dispatchEvent(_endEvent);
    });
    __publicField19(this, "onPinchStart", () => {
      if (this.enabled && this.enableZoom) {
        this.dispatchEvent(_startEvent);
        this.updateTbState(STATE.SCALE, true);
        this._startFingerDistance = this.calculatePointersDistance(this._touchCurrent[0], this._touchCurrent[1]);
        this._currentFingerDistance = this._startFingerDistance;
        this.activateGizmos(false);
      }
    });
    __publicField19(this, "onPinchMove", () => {
      var _a4, _b3;
      if (this.enabled && this.enableZoom && this.domElement) {
        this.setCenter(
          (this._touchCurrent[0].clientX + this._touchCurrent[1].clientX) / 2,
          (this._touchCurrent[0].clientY + this._touchCurrent[1].clientY) / 2
        );
        const minDistance = 12;
        if (this._state != STATE.SCALE) {
          this._startFingerDistance = this._currentFingerDistance;
          this.updateTbState(STATE.SCALE, true);
        }
        this._currentFingerDistance = Math.max(
          this.calculatePointersDistance(this._touchCurrent[0], this._touchCurrent[1]),
          minDistance * this._devPxRatio
        );
        const amount = this._currentFingerDistance / this._startFingerDistance;
        let scalePoint;
        if (!this.enablePan) {
          scalePoint = this._gizmos.position;
        } else {
          if (this.camera instanceof OrthographicCamera) {
            scalePoint = (_a4 = this.unprojectOnTbPlane(this.camera, _center.x, _center.y, this.domElement)) == null ? void 0 : _a4.applyQuaternion(this.camera.quaternion).multiplyScalar(1 / this.camera.zoom).add(this._gizmos.position);
          } else if (this.camera instanceof PerspectiveCamera) {
            scalePoint = (_b3 = this.unprojectOnTbPlane(this.camera, _center.x, _center.y, this.domElement)) == null ? void 0 : _b3.applyQuaternion(this.camera.quaternion).add(this._gizmos.position);
          }
        }
        if (scalePoint !== void 0) {
          this.applyTransformMatrix(this.applyScale(amount, scalePoint));
        }
        this.dispatchEvent(_changeEvent2);
      }
    });
    __publicField19(this, "onPinchEnd", () => {
      this.updateTbState(STATE.IDLE, false);
      this.dispatchEvent(_endEvent);
    });
    __publicField19(this, "onTriplePanStart", () => {
      if (this.enabled && this.enableZoom && this.domElement) {
        this.dispatchEvent(_startEvent);
        this.updateTbState(STATE.SCALE, true);
        let clientX = 0;
        let clientY = 0;
        const nFingers = this._touchCurrent.length;
        for (let i4 = 0; i4 < nFingers; i4++) {
          clientX += this._touchCurrent[i4].clientX;
          clientY += this._touchCurrent[i4].clientY;
        }
        this.setCenter(clientX / nFingers, clientY / nFingers);
        this._startCursorPosition.setY(this.getCursorNDC(_center.x, _center.y, this.domElement).y * 0.5);
        this._currentCursorPosition.copy(this._startCursorPosition);
      }
    });
    __publicField19(this, "onTriplePanMove", () => {
      if (this.enabled && this.enableZoom && this.camera && this.domElement) {
        let clientX = 0;
        let clientY = 0;
        const nFingers = this._touchCurrent.length;
        for (let i4 = 0; i4 < nFingers; i4++) {
          clientX += this._touchCurrent[i4].clientX;
          clientY += this._touchCurrent[i4].clientY;
        }
        this.setCenter(clientX / nFingers, clientY / nFingers);
        const screenNotches = 8;
        this._currentCursorPosition.setY(this.getCursorNDC(_center.x, _center.y, this.domElement).y * 0.5);
        const movement = this._currentCursorPosition.y - this._startCursorPosition.y;
        let size2 = 1;
        if (movement < 0) {
          size2 = 1 / Math.pow(this.scaleFactor, -movement * screenNotches);
        } else if (movement > 0) {
          size2 = Math.pow(this.scaleFactor, movement * screenNotches);
        }
        this._v3_1.setFromMatrixPosition(this._cameraMatrixState);
        const x = this._v3_1.distanceTo(this._gizmos.position);
        let xNew = x / size2;
        xNew = MathUtils.clamp(xNew, this.minDistance, this.maxDistance);
        const y = x * Math.tan(MathUtils.DEG2RAD * this._fovState * 0.5);
        let newFov = MathUtils.RAD2DEG * (Math.atan(y / xNew) * 2);
        newFov = MathUtils.clamp(newFov, this.minFov, this.maxFov);
        const newDistance = y / Math.tan(MathUtils.DEG2RAD * (newFov / 2));
        size2 = x / newDistance;
        this._v3_2.setFromMatrixPosition(this._gizmoMatrixState);
        this.setFov(newFov);
        this.applyTransformMatrix(this.applyScale(size2, this._v3_2, false));
        const direction2 = this._gizmos.position.clone().sub(this.camera.position).normalize().multiplyScalar(newDistance / x);
        this._m4_1.makeTranslation(direction2.x, direction2.y, direction2.z);
        this.dispatchEvent(_changeEvent2);
      }
    });
    __publicField19(this, "onTriplePanEnd", () => {
      this.updateTbState(STATE.IDLE, false);
      this.dispatchEvent(_endEvent);
    });
    __publicField19(this, "setCenter", (clientX, clientY) => {
      _center.x = clientX;
      _center.y = clientY;
    });
    __publicField19(this, "initializeMouseActions", () => {
      this.setMouseAction("PAN", 0, "CTRL");
      this.setMouseAction("PAN", 2);
      this.setMouseAction("ROTATE", 0);
      this.setMouseAction("ZOOM", "WHEEL");
      this.setMouseAction("ZOOM", 1);
      this.setMouseAction("FOV", "WHEEL", "SHIFT");
      this.setMouseAction("FOV", 1, "SHIFT");
    });
    __publicField19(this, "setMouseAction", (operation, mouse, key = null) => {
      const operationInput = ["PAN", "ROTATE", "ZOOM", "FOV"];
      const mouseInput = [0, 1, 2, "WHEEL"];
      const keyInput = ["CTRL", "SHIFT", null];
      let state;
      if (!operationInput.includes(operation) || !mouseInput.includes(mouse) || !keyInput.includes(key)) {
        return false;
      }
      if (mouse == "WHEEL") {
        if (operation != "ZOOM" && operation != "FOV") {
          return false;
        }
      }
      switch (operation) {
        case "PAN":
          state = STATE.PAN;
          break;
        case "ROTATE":
          state = STATE.ROTATE;
          break;
        case "ZOOM":
          state = STATE.SCALE;
          break;
        case "FOV":
          state = STATE.FOV;
          break;
      }
      const action = {
        operation,
        mouse,
        key,
        state
      };
      for (let i4 = 0; i4 < this.mouseActions.length; i4++) {
        if (this.mouseActions[i4].mouse == action.mouse && this.mouseActions[i4].key == action.key) {
          this.mouseActions.splice(i4, 1, action);
          return true;
        }
      }
      this.mouseActions.push(action);
      return true;
    });
    __publicField19(this, "getOpFromAction", (mouse, key) => {
      let action;
      for (let i4 = 0; i4 < this.mouseActions.length; i4++) {
        action = this.mouseActions[i4];
        if (action.mouse == mouse && action.key == key) {
          return action.operation;
        }
      }
      if (key) {
        for (let i4 = 0; i4 < this.mouseActions.length; i4++) {
          action = this.mouseActions[i4];
          if (action.mouse == mouse && action.key == null) {
            return action.operation;
          }
        }
      }
      return null;
    });
    __publicField19(this, "getOpStateFromAction", (mouse, key) => {
      let action;
      for (let i4 = 0; i4 < this.mouseActions.length; i4++) {
        action = this.mouseActions[i4];
        if (action.mouse == mouse && action.key == key) {
          return action.state;
        }
      }
      if (key) {
        for (let i4 = 0; i4 < this.mouseActions.length; i4++) {
          action = this.mouseActions[i4];
          if (action.mouse == mouse && action.key == null) {
            return action.state;
          }
        }
      }
      return null;
    });
    __publicField19(this, "getAngle", (p1, p2) => {
      return Math.atan2(p2.clientY - p1.clientY, p2.clientX - p1.clientX) * 180 / Math.PI;
    });
    __publicField19(this, "updateTouchEvent", (event) => {
      for (let i4 = 0; i4 < this._touchCurrent.length; i4++) {
        if (this._touchCurrent[i4].pointerId == event.pointerId) {
          this._touchCurrent.splice(i4, 1, event);
          break;
        }
      }
    });
    __publicField19(this, "calculateAngularSpeed", (p0, p1, t0, t1) => {
      const s2 = p1 - p0;
      const t3 = (t1 - t0) / 1e3;
      if (t3 == 0) {
        return 0;
      }
      return s2 / t3;
    });
    __publicField19(this, "calculatePointersDistance", (p0, p1) => {
      return Math.sqrt(Math.pow(p1.clientX - p0.clientX, 2) + Math.pow(p1.clientY - p0.clientY, 2));
    });
    __publicField19(this, "calculateRotationAxis", (vec13, vec23) => {
      this._rotationMatrix.extractRotation(this._cameraMatrixState);
      this._quat.setFromRotationMatrix(this._rotationMatrix);
      this._rotationAxis.crossVectors(vec13, vec23).applyQuaternion(this._quat);
      return this._rotationAxis.normalize().clone();
    });
    __publicField19(this, "calculateTbRadius", (camera2) => {
      const factor = 0.67;
      const distance3 = camera2.position.distanceTo(this._gizmos.position);
      if (camera2 instanceof PerspectiveCamera) {
        const halfFovV = MathUtils.DEG2RAD * camera2.fov * 0.5;
        const halfFovH = Math.atan(camera2.aspect * Math.tan(halfFovV));
        return Math.tan(Math.min(halfFovV, halfFovH)) * distance3 * factor;
      } else if (camera2 instanceof OrthographicCamera) {
        return Math.min(camera2.top, camera2.right) * factor;
      }
    });
    __publicField19(this, "focus", (point, size2, amount = 1) => {
      if (this.camera) {
        const focusPoint = point.clone();
        focusPoint.sub(this._gizmos.position).multiplyScalar(amount);
        this._translationMatrix.makeTranslation(focusPoint.x, focusPoint.y, focusPoint.z);
        const gizmoStateTemp = this._gizmoMatrixState.clone();
        this._gizmoMatrixState.premultiply(this._translationMatrix);
        this._gizmoMatrixState.decompose(this._gizmos.position, this._gizmos.quaternion, this._gizmos.scale);
        const cameraStateTemp = this._cameraMatrixState.clone();
        this._cameraMatrixState.premultiply(this._translationMatrix);
        this._cameraMatrixState.decompose(this.camera.position, this.camera.quaternion, this.camera.scale);
        if (this.enableZoom) {
          this.applyTransformMatrix(this.applyScale(size2, this._gizmos.position));
        }
        this._gizmoMatrixState.copy(gizmoStateTemp);
        this._cameraMatrixState.copy(cameraStateTemp);
      }
    });
    __publicField19(this, "drawGrid", () => {
      if (this.scene) {
        const color = 8947848;
        const multiplier = 3;
        let size2, divisions, maxLength, tick;
        if (this.camera instanceof OrthographicCamera) {
          const width = this.camera.right - this.camera.left;
          const height = this.camera.bottom - this.camera.top;
          maxLength = Math.max(width, height);
          tick = maxLength / 20;
          size2 = maxLength / this.camera.zoom * multiplier;
          divisions = size2 / tick * this.camera.zoom;
        } else if (this.camera instanceof PerspectiveCamera) {
          const distance3 = this.camera.position.distanceTo(this._gizmos.position);
          const halfFovV = MathUtils.DEG2RAD * this.camera.fov * 0.5;
          const halfFovH = Math.atan(this.camera.aspect * Math.tan(halfFovV));
          maxLength = Math.tan(Math.max(halfFovV, halfFovH)) * distance3 * 2;
          tick = maxLength / 20;
          size2 = maxLength * multiplier;
          divisions = size2 / tick;
        }
        if (this._grid == null && this.camera) {
          this._grid = new GridHelper(size2, divisions, color, color);
          this._grid.position.copy(this._gizmos.position);
          this._gridPosition.copy(this._grid.position);
          this._grid.quaternion.copy(this.camera.quaternion);
          this._grid.rotateX(Math.PI * 0.5);
          this.scene.add(this._grid);
        }
      }
    });
    __publicField19(this, "connect", (domElement2) => {
      if (domElement2 === document) {
        console.error(
          'THREE.ArcballControls: "document" should not be used as the target "domElement". Please use "renderer.domElement" instead.'
        );
      }
      this.domElement = domElement2;
      this.domElement.style.touchAction = "none";
      this.domElement.addEventListener("contextmenu", this.onContextMenu);
      this.domElement.addEventListener("pointerdown", this.onPointerDown);
      this.domElement.addEventListener("pointercancel", this.onPointerCancel);
      this.domElement.addEventListener("wheel", this.onWheel);
    });
    __publicField19(this, "dispose", () => {
      var _a4, _b3, _c, _d, _e;
      if (this._animationId != -1) {
        window.cancelAnimationFrame(this._animationId);
      }
      (_a4 = this.domElement) == null ? void 0 : _a4.removeEventListener("pointerdown", this.onPointerDown);
      (_b3 = this.domElement) == null ? void 0 : _b3.removeEventListener("pointercancel", this.onPointerCancel);
      (_c = this.domElement) == null ? void 0 : _c.removeEventListener("wheel", this.onWheel);
      (_d = this.domElement) == null ? void 0 : _d.removeEventListener("contextmenu", this.onContextMenu);
      window.removeEventListener("pointermove", this.onPointerMove);
      window.removeEventListener("pointerup", this.onPointerUp);
      window.removeEventListener("resize", this.onWindowResize);
      (_e = this.scene) == null ? void 0 : _e.remove(this._gizmos);
      this.disposeGrid();
    });
    __publicField19(this, "disposeGrid", () => {
      if (this._grid && this.scene) {
        this.scene.remove(this._grid);
        this._grid = null;
      }
    });
    __publicField19(this, "easeOutCubic", (t3) => {
      return 1 - Math.pow(1 - t3, 3);
    });
    __publicField19(this, "activateGizmos", (isActive) => {
      for (const gizmo of this._gizmos.children) {
        gizmo.material.setValues({ opacity: isActive ? 1 : 0.6 });
      }
    });
    __publicField19(this, "getCursorNDC", (cursorX, cursorY, canvas) => {
      const canvasRect = canvas.getBoundingClientRect();
      this._v2_1.setX((cursorX - canvasRect.left) / canvasRect.width * 2 - 1);
      this._v2_1.setY((canvasRect.bottom - cursorY) / canvasRect.height * 2 - 1);
      return this._v2_1.clone();
    });
    __publicField19(this, "getCursorPosition", (cursorX, cursorY, canvas) => {
      this._v2_1.copy(this.getCursorNDC(cursorX, cursorY, canvas));
      if (this.camera instanceof OrthographicCamera) {
        this._v2_1.x *= (this.camera.right - this.camera.left) * 0.5;
        this._v2_1.y *= (this.camera.top - this.camera.bottom) * 0.5;
      }
      return this._v2_1.clone();
    });
    __publicField19(this, "setCamera", (camera2) => {
      if (camera2) {
        camera2.lookAt(this.target);
        camera2.updateMatrix();
        if (camera2 instanceof PerspectiveCamera) {
          this._fov0 = camera2.fov;
          this._fovState = camera2.fov;
        }
        this._cameraMatrixState0.copy(camera2.matrix);
        this._cameraMatrixState.copy(this._cameraMatrixState0);
        this._cameraProjectionState.copy(camera2.projectionMatrix);
        this._zoom0 = camera2.zoom;
        this._zoomState = this._zoom0;
        this._initialNear = camera2.near;
        this._nearPos0 = camera2.position.distanceTo(this.target) - camera2.near;
        this._nearPos = this._initialNear;
        this._initialFar = camera2.far;
        this._farPos0 = camera2.position.distanceTo(this.target) - camera2.far;
        this._farPos = this._initialFar;
        this._up0.copy(camera2.up);
        this._upState.copy(camera2.up);
        this.camera = camera2;
        this.camera.updateProjectionMatrix();
        const tbRadius = this.calculateTbRadius(camera2);
        if (tbRadius !== void 0) {
          this._tbRadius = tbRadius;
        }
        this.makeGizmos(this.target, this._tbRadius);
      }
    });
    __publicField19(this, "makeGizmos", (tbCenter, tbRadius) => {
      const curve = new EllipseCurve(0, 0, tbRadius, tbRadius);
      const points = curve.getPoints(this._curvePts);
      const curveGeometry = new BufferGeometry().setFromPoints(points);
      const curveMaterialX = new LineBasicMaterial({ color: 16744576, fog: false, transparent: true, opacity: 0.6 });
      const curveMaterialY = new LineBasicMaterial({ color: 8454016, fog: false, transparent: true, opacity: 0.6 });
      const curveMaterialZ = new LineBasicMaterial({ color: 8421631, fog: false, transparent: true, opacity: 0.6 });
      const gizmoX = new Line(curveGeometry, curveMaterialX);
      const gizmoY = new Line(curveGeometry, curveMaterialY);
      const gizmoZ = new Line(curveGeometry, curveMaterialZ);
      const rotation3 = Math.PI * 0.5;
      gizmoX.rotation.x = rotation3;
      gizmoY.rotation.y = rotation3;
      this._gizmoMatrixState0.identity().setPosition(tbCenter);
      this._gizmoMatrixState.copy(this._gizmoMatrixState0);
      if (this.camera && this.camera.zoom != 1) {
        const size2 = 1 / this.camera.zoom;
        this._scaleMatrix.makeScale(size2, size2, size2);
        this._translationMatrix.makeTranslation(-tbCenter.x, -tbCenter.y, -tbCenter.z);
        this._gizmoMatrixState.premultiply(this._translationMatrix).premultiply(this._scaleMatrix);
        this._translationMatrix.makeTranslation(tbCenter.x, tbCenter.y, tbCenter.z);
        this._gizmoMatrixState.premultiply(this._translationMatrix);
      }
      this._gizmoMatrixState.decompose(this._gizmos.position, this._gizmos.quaternion, this._gizmos.scale);
      this._gizmos.clear();
      this._gizmos.add(gizmoX);
      this._gizmos.add(gizmoY);
      this._gizmos.add(gizmoZ);
    });
    __publicField19(this, "onFocusAnim", (time, point, cameraMatrix, gizmoMatrix) => {
      if (this._timeStart == -1) {
        this._timeStart = time;
      }
      if (this._state == STATE.ANIMATION_FOCUS) {
        const deltaTime = time - this._timeStart;
        const animTime = deltaTime / this.focusAnimationTime;
        this._gizmoMatrixState.copy(gizmoMatrix);
        if (animTime >= 1) {
          this._gizmoMatrixState.decompose(this._gizmos.position, this._gizmos.quaternion, this._gizmos.scale);
          this.focus(point, this.scaleFactor);
          this._timeStart = -1;
          this.updateTbState(STATE.IDLE, false);
          this.activateGizmos(false);
          this.dispatchEvent(_changeEvent2);
        } else {
          const amount = this.easeOutCubic(animTime);
          const size2 = 1 - amount + this.scaleFactor * amount;
          this._gizmoMatrixState.decompose(this._gizmos.position, this._gizmos.quaternion, this._gizmos.scale);
          this.focus(point, size2, amount);
          this.dispatchEvent(_changeEvent2);
          const self2 = this;
          this._animationId = window.requestAnimationFrame(function(t3) {
            self2.onFocusAnim(t3, point, cameraMatrix, gizmoMatrix.clone());
          });
        }
      } else {
        this._animationId = -1;
        this._timeStart = -1;
      }
    });
    __publicField19(this, "onRotationAnim", (time, rotationAxis, w0) => {
      if (this._timeStart == -1) {
        this._anglePrev = 0;
        this._angleCurrent = 0;
        this._timeStart = time;
      }
      if (this._state == STATE.ANIMATION_ROTATE) {
        const deltaTime = (time - this._timeStart) / 1e3;
        const w = w0 + -this.dampingFactor * deltaTime;
        if (w > 0) {
          this._angleCurrent = 0.5 * -this.dampingFactor * Math.pow(deltaTime, 2) + w0 * deltaTime + 0;
          this.applyTransformMatrix(this.rotate(rotationAxis, this._angleCurrent));
          this.dispatchEvent(_changeEvent2);
          const self2 = this;
          this._animationId = window.requestAnimationFrame(function(t3) {
            self2.onRotationAnim(t3, rotationAxis, w0);
          });
        } else {
          this._animationId = -1;
          this._timeStart = -1;
          this.updateTbState(STATE.IDLE, false);
          this.activateGizmos(false);
          this.dispatchEvent(_changeEvent2);
        }
      } else {
        this._animationId = -1;
        this._timeStart = -1;
        if (this._state != STATE.ROTATE) {
          this.activateGizmos(false);
          this.dispatchEvent(_changeEvent2);
        }
      }
    });
    __publicField19(this, "pan", (p0, p1, adjust = false) => {
      if (this.camera) {
        const movement = p0.clone().sub(p1);
        if (this.camera instanceof OrthographicCamera) {
          movement.multiplyScalar(1 / this.camera.zoom);
        }
        if (this.camera instanceof PerspectiveCamera && adjust) {
          this._v3_1.setFromMatrixPosition(this._cameraMatrixState0);
          this._v3_2.setFromMatrixPosition(this._gizmoMatrixState0);
          const distanceFactor = this._v3_1.distanceTo(this._v3_2) / this.camera.position.distanceTo(this._gizmos.position);
          movement.multiplyScalar(1 / distanceFactor);
        }
        this._v3_1.set(movement.x, movement.y, 0).applyQuaternion(this.camera.quaternion);
        this._m4_1.makeTranslation(this._v3_1.x, this._v3_1.y, this._v3_1.z);
        this.setTransformationMatrices(this._m4_1, this._m4_1);
      }
      return _transformation;
    });
    __publicField19(this, "reset", () => {
      if (this.camera) {
        this.camera.zoom = this._zoom0;
        if (this.camera instanceof PerspectiveCamera) {
          this.camera.fov = this._fov0;
        }
        this.camera.near = this._nearPos;
        this.camera.far = this._farPos;
        this._cameraMatrixState.copy(this._cameraMatrixState0);
        this._cameraMatrixState.decompose(this.camera.position, this.camera.quaternion, this.camera.scale);
        this.camera.up.copy(this._up0);
        this.camera.updateMatrix();
        this.camera.updateProjectionMatrix();
        this._gizmoMatrixState.copy(this._gizmoMatrixState0);
        this._gizmoMatrixState0.decompose(this._gizmos.position, this._gizmos.quaternion, this._gizmos.scale);
        this._gizmos.updateMatrix();
        const tbRadius = this.calculateTbRadius(this.camera);
        if (tbRadius !== void 0) {
          this._tbRadius = tbRadius;
        }
        this.makeGizmos(this._gizmos.position, this._tbRadius);
        this.camera.lookAt(this._gizmos.position);
        this.updateTbState(STATE.IDLE, false);
        this.dispatchEvent(_changeEvent2);
      }
    });
    __publicField19(this, "rotate", (axis, angle) => {
      const point = this._gizmos.position;
      this._translationMatrix.makeTranslation(-point.x, -point.y, -point.z);
      this._rotationMatrix.makeRotationAxis(axis, -angle);
      this._m4_1.makeTranslation(point.x, point.y, point.z);
      this._m4_1.multiply(this._rotationMatrix);
      this._m4_1.multiply(this._translationMatrix);
      this.setTransformationMatrices(this._m4_1);
      return _transformation;
    });
    __publicField19(this, "copyState", () => {
      if (this.camera) {
        const state = JSON.stringify(
          this.camera instanceof OrthographicCamera ? {
            arcballState: {
              cameraFar: this.camera.far,
              cameraMatrix: this.camera.matrix,
              cameraNear: this.camera.near,
              cameraUp: this.camera.up,
              cameraZoom: this.camera.zoom,
              gizmoMatrix: this._gizmos.matrix
            }
          } : {
            arcballState: {
              cameraFar: this.camera.far,
              cameraFov: this.camera.fov,
              cameraMatrix: this.camera.matrix,
              cameraNear: this.camera.near,
              cameraUp: this.camera.up,
              cameraZoom: this.camera.zoom,
              gizmoMatrix: this._gizmos.matrix
            }
          }
        );
        navigator.clipboard.writeText(state);
      }
    });
    __publicField19(this, "pasteState", () => {
      const self2 = this;
      navigator.clipboard.readText().then(function resolved(value) {
        self2.setStateFromJSON(value);
      });
    });
    __publicField19(this, "saveState", () => {
      if (!this.camera)
        return;
      this._cameraMatrixState0.copy(this.camera.matrix);
      this._gizmoMatrixState0.copy(this._gizmos.matrix);
      this._nearPos = this.camera.near;
      this._farPos = this.camera.far;
      this._zoom0 = this.camera.zoom;
      this._up0.copy(this.camera.up);
      if (this.camera instanceof PerspectiveCamera) {
        this._fov0 = this.camera.fov;
      }
    });
    __publicField19(this, "applyScale", (size2, point, scaleGizmos = true) => {
      if (!this.camera)
        return;
      const scalePoint = point.clone();
      let sizeInverse = 1 / size2;
      if (this.camera instanceof OrthographicCamera) {
        this.camera.zoom = this._zoomState;
        this.camera.zoom *= size2;
        if (this.camera.zoom > this.maxZoom) {
          this.camera.zoom = this.maxZoom;
          sizeInverse = this._zoomState / this.maxZoom;
        } else if (this.camera.zoom < this.minZoom) {
          this.camera.zoom = this.minZoom;
          sizeInverse = this._zoomState / this.minZoom;
        }
        this.camera.updateProjectionMatrix();
        this._v3_1.setFromMatrixPosition(this._gizmoMatrixState);
        this._scaleMatrix.makeScale(sizeInverse, sizeInverse, sizeInverse);
        this._translationMatrix.makeTranslation(-this._v3_1.x, -this._v3_1.y, -this._v3_1.z);
        this._m4_2.makeTranslation(this._v3_1.x, this._v3_1.y, this._v3_1.z).multiply(this._scaleMatrix);
        this._m4_2.multiply(this._translationMatrix);
        scalePoint.sub(this._v3_1);
        const amount = scalePoint.clone().multiplyScalar(sizeInverse);
        scalePoint.sub(amount);
        this._m4_1.makeTranslation(scalePoint.x, scalePoint.y, scalePoint.z);
        this._m4_2.premultiply(this._m4_1);
        this.setTransformationMatrices(this._m4_1, this._m4_2);
        return _transformation;
      }
      if (this.camera instanceof PerspectiveCamera) {
        this._v3_1.setFromMatrixPosition(this._cameraMatrixState);
        this._v3_2.setFromMatrixPosition(this._gizmoMatrixState);
        let distance3 = this._v3_1.distanceTo(scalePoint);
        let amount = distance3 - distance3 * sizeInverse;
        const newDistance = distance3 - amount;
        if (newDistance < this.minDistance) {
          sizeInverse = this.minDistance / distance3;
          amount = distance3 - distance3 * sizeInverse;
        } else if (newDistance > this.maxDistance) {
          sizeInverse = this.maxDistance / distance3;
          amount = distance3 - distance3 * sizeInverse;
        }
        let direction2 = scalePoint.clone().sub(this._v3_1).normalize().multiplyScalar(amount);
        this._m4_1.makeTranslation(direction2.x, direction2.y, direction2.z);
        if (scaleGizmos) {
          const pos = this._v3_2;
          distance3 = pos.distanceTo(scalePoint);
          amount = distance3 - distance3 * sizeInverse;
          direction2 = scalePoint.clone().sub(this._v3_2).normalize().multiplyScalar(amount);
          this._translationMatrix.makeTranslation(pos.x, pos.y, pos.z);
          this._scaleMatrix.makeScale(sizeInverse, sizeInverse, sizeInverse);
          this._m4_2.makeTranslation(direction2.x, direction2.y, direction2.z).multiply(this._translationMatrix);
          this._m4_2.multiply(this._scaleMatrix);
          this._translationMatrix.makeTranslation(-pos.x, -pos.y, -pos.z);
          this._m4_2.multiply(this._translationMatrix);
          this.setTransformationMatrices(this._m4_1, this._m4_2);
        } else {
          this.setTransformationMatrices(this._m4_1);
        }
        return _transformation;
      }
    });
    __publicField19(this, "setFov", (value) => {
      if (this.camera instanceof PerspectiveCamera) {
        this.camera.fov = MathUtils.clamp(value, this.minFov, this.maxFov);
        this.camera.updateProjectionMatrix();
      }
    });
    __publicField19(this, "setTarget", (x, y, z) => {
      if (this.camera) {
        this.target.set(x, y, z);
        this._gizmos.position.set(x, y, z);
        const tbRadius = this.calculateTbRadius(this.camera);
        if (tbRadius !== void 0) {
          this._tbRadius = tbRadius;
        }
        this.makeGizmos(this.target, this._tbRadius);
        this.camera.lookAt(this.target);
      }
    });
    __publicField19(this, "zRotate", (point, angle) => {
      this._rotationMatrix.makeRotationAxis(this._rotationAxis, angle);
      this._translationMatrix.makeTranslation(-point.x, -point.y, -point.z);
      this._m4_1.makeTranslation(point.x, point.y, point.z);
      this._m4_1.multiply(this._rotationMatrix);
      this._m4_1.multiply(this._translationMatrix);
      this._v3_1.setFromMatrixPosition(this._gizmoMatrixState).sub(point);
      this._v3_2.copy(this._v3_1).applyAxisAngle(this._rotationAxis, angle);
      this._v3_2.sub(this._v3_1);
      this._m4_2.makeTranslation(this._v3_2.x, this._v3_2.y, this._v3_2.z);
      this.setTransformationMatrices(this._m4_1, this._m4_2);
      return _transformation;
    });
    __publicField19(this, "unprojectOnObj", (cursor, camera2) => {
      if (!this.scene)
        return null;
      const raycaster = new Raycaster();
      raycaster.near = camera2.near;
      raycaster.far = camera2.far;
      raycaster.setFromCamera(cursor, camera2);
      const intersect = raycaster.intersectObjects(this.scene.children, true);
      for (let i4 = 0; i4 < intersect.length; i4++) {
        if (intersect[i4].object.uuid != this._gizmos.uuid && intersect[i4].face) {
          return intersect[i4].point.clone();
        }
      }
      return null;
    });
    __publicField19(this, "unprojectOnTbSurface", (camera2, cursorX, cursorY, canvas, tbRadius) => {
      if (camera2 instanceof OrthographicCamera) {
        this._v2_1.copy(this.getCursorPosition(cursorX, cursorY, canvas));
        this._v3_1.set(this._v2_1.x, this._v2_1.y, 0);
        const x2 = Math.pow(this._v2_1.x, 2);
        const y2 = Math.pow(this._v2_1.y, 2);
        const r2 = Math.pow(this._tbRadius, 2);
        if (x2 + y2 <= r2 * 0.5) {
          this._v3_1.setZ(Math.sqrt(r2 - (x2 + y2)));
        } else {
          this._v3_1.setZ(r2 * 0.5 / Math.sqrt(x2 + y2));
        }
        return this._v3_1;
      }
      if (camera2 instanceof PerspectiveCamera) {
        this._v2_1.copy(this.getCursorNDC(cursorX, cursorY, canvas));
        this._v3_1.set(this._v2_1.x, this._v2_1.y, -1);
        this._v3_1.applyMatrix4(camera2.projectionMatrixInverse);
        const rayDir = this._v3_1.clone().normalize();
        const cameraGizmoDistance = camera2.position.distanceTo(this._gizmos.position);
        const radius2 = Math.pow(tbRadius, 2);
        const h = this._v3_1.z;
        const l2 = Math.sqrt(Math.pow(this._v3_1.x, 2) + Math.pow(this._v3_1.y, 2));
        if (l2 == 0) {
          rayDir.set(this._v3_1.x, this._v3_1.y, tbRadius);
          return rayDir;
        }
        const m = h / l2;
        const q = cameraGizmoDistance;
        let a6 = Math.pow(m, 2) + 1;
        let b5 = 2 * m * q;
        let c2 = Math.pow(q, 2) - radius2;
        let delta = Math.pow(b5, 2) - 4 * a6 * c2;
        if (delta >= 0) {
          this._v2_1.setX((-b5 - Math.sqrt(delta)) / (2 * a6));
          this._v2_1.setY(m * this._v2_1.x + q);
          const angle = MathUtils.RAD2DEG * this._v2_1.angle();
          if (angle >= 45) {
            const rayLength2 = Math.sqrt(Math.pow(this._v2_1.x, 2) + Math.pow(cameraGizmoDistance - this._v2_1.y, 2));
            rayDir.multiplyScalar(rayLength2);
            rayDir.z += cameraGizmoDistance;
            return rayDir;
          }
        }
        a6 = m;
        b5 = q;
        c2 = -radius2 * 0.5;
        delta = Math.pow(b5, 2) - 4 * a6 * c2;
        this._v2_1.setX((-b5 - Math.sqrt(delta)) / (2 * a6));
        this._v2_1.setY(m * this._v2_1.x + q);
        const rayLength = Math.sqrt(Math.pow(this._v2_1.x, 2) + Math.pow(cameraGizmoDistance - this._v2_1.y, 2));
        rayDir.multiplyScalar(rayLength);
        rayDir.z += cameraGizmoDistance;
        return rayDir;
      }
    });
    __publicField19(this, "unprojectOnTbPlane", (camera2, cursorX, cursorY, canvas, initialDistance = false) => {
      if (camera2 instanceof OrthographicCamera) {
        this._v2_1.copy(this.getCursorPosition(cursorX, cursorY, canvas));
        this._v3_1.set(this._v2_1.x, this._v2_1.y, 0);
        return this._v3_1.clone();
      }
      if (camera2 instanceof PerspectiveCamera) {
        this._v2_1.copy(this.getCursorNDC(cursorX, cursorY, canvas));
        this._v3_1.set(this._v2_1.x, this._v2_1.y, -1);
        this._v3_1.applyMatrix4(camera2.projectionMatrixInverse);
        const rayDir = this._v3_1.clone().normalize();
        const h = this._v3_1.z;
        const l2 = Math.sqrt(Math.pow(this._v3_1.x, 2) + Math.pow(this._v3_1.y, 2));
        let cameraGizmoDistance;
        if (initialDistance) {
          cameraGizmoDistance = this._v3_1.setFromMatrixPosition(this._cameraMatrixState0).distanceTo(this._v3_2.setFromMatrixPosition(this._gizmoMatrixState0));
        } else {
          cameraGizmoDistance = camera2.position.distanceTo(this._gizmos.position);
        }
        if (l2 == 0) {
          rayDir.set(0, 0, 0);
          return rayDir;
        }
        const m = h / l2;
        const q = cameraGizmoDistance;
        const x = -q / m;
        const rayLength = Math.sqrt(Math.pow(q, 2) + Math.pow(x, 2));
        rayDir.multiplyScalar(rayLength);
        rayDir.z = 0;
        return rayDir;
      }
    });
    __publicField19(this, "updateMatrixState", () => {
      if (!this.camera)
        return;
      this._cameraMatrixState.copy(this.camera.matrix);
      this._gizmoMatrixState.copy(this._gizmos.matrix);
      if (this.camera instanceof OrthographicCamera) {
        this._cameraProjectionState.copy(this.camera.projectionMatrix);
        this.camera.updateProjectionMatrix();
        this._zoomState = this.camera.zoom;
      }
      if (this.camera instanceof PerspectiveCamera) {
        this._fovState = this.camera.fov;
      }
    });
    __publicField19(this, "updateTbState", (newState, updateMatrices) => {
      this._state = newState;
      if (updateMatrices) {
        this.updateMatrixState();
      }
    });
    __publicField19(this, "update", () => {
      const EPS2 = 1e-6;
      if (!this.target.equals(this._currentTarget) && this.camera) {
        this._gizmos.position.set(this.target.x, this.target.y, this.target.z);
        const tbRadius = this.calculateTbRadius(this.camera);
        if (tbRadius !== void 0) {
          this._tbRadius = tbRadius;
        }
        this.makeGizmos(this.target, this._tbRadius);
        this._currentTarget.copy(this.target);
      }
      if (!this.camera)
        return;
      if (this.camera instanceof OrthographicCamera) {
        if (this.camera.zoom > this.maxZoom || this.camera.zoom < this.minZoom) {
          const newZoom = MathUtils.clamp(this.camera.zoom, this.minZoom, this.maxZoom);
          this.applyTransformMatrix(this.applyScale(newZoom / this.camera.zoom, this._gizmos.position, true));
        }
      }
      if (this.camera instanceof PerspectiveCamera) {
        const distance3 = this.camera.position.distanceTo(this._gizmos.position);
        if (distance3 > this.maxDistance + EPS2 || distance3 < this.minDistance - EPS2) {
          const newDistance = MathUtils.clamp(distance3, this.minDistance, this.maxDistance);
          this.applyTransformMatrix(this.applyScale(newDistance / distance3, this._gizmos.position));
          this.updateMatrixState();
        }
        if (this.camera.fov < this.minFov || this.camera.fov > this.maxFov) {
          this.camera.fov = MathUtils.clamp(this.camera.fov, this.minFov, this.maxFov);
          this.camera.updateProjectionMatrix();
        }
        const oldRadius = this._tbRadius;
        const tbRadius = this.calculateTbRadius(this.camera);
        if (tbRadius !== void 0) {
          this._tbRadius = tbRadius;
        }
        if (oldRadius < this._tbRadius - EPS2 || oldRadius > this._tbRadius + EPS2) {
          const scale5 = (this._gizmos.scale.x + this._gizmos.scale.y + this._gizmos.scale.z) / 3;
          const newRadius = this._tbRadius / scale5;
          const curve = new EllipseCurve(0, 0, newRadius, newRadius);
          const points = curve.getPoints(this._curvePts);
          const curveGeometry = new BufferGeometry().setFromPoints(points);
          for (const gizmo in this._gizmos.children) {
            const child = this._gizmos.children[gizmo];
            child.geometry = curveGeometry;
          }
        }
      }
      this.camera.lookAt(this._gizmos.position);
    });
    __publicField19(this, "setStateFromJSON", (json) => {
      const state = JSON.parse(json);
      if (state.arcballState && this.camera) {
        this._cameraMatrixState.fromArray(state.arcballState.cameraMatrix.elements);
        this._cameraMatrixState.decompose(this.camera.position, this.camera.quaternion, this.camera.scale);
        this.camera.up.copy(state.arcballState.cameraUp);
        this.camera.near = state.arcballState.cameraNear;
        this.camera.far = state.arcballState.cameraFar;
        this.camera.zoom = state.arcballState.cameraZoom;
        if (this.camera instanceof PerspectiveCamera) {
          this.camera.fov = state.arcballState.cameraFov;
        }
        this._gizmoMatrixState.fromArray(state.arcballState.gizmoMatrix.elements);
        this._gizmoMatrixState.decompose(this._gizmos.position, this._gizmos.quaternion, this._gizmos.scale);
        this.camera.updateMatrix();
        this.camera.updateProjectionMatrix();
        this._gizmos.updateMatrix();
        const tbRadius = this.calculateTbRadius(this.camera);
        if (tbRadius !== void 0) {
          this._tbRadius = tbRadius;
        }
        const gizmoTmp = new Matrix4().copy(this._gizmoMatrixState0);
        this.makeGizmos(this._gizmos.position, this._tbRadius);
        this._gizmoMatrixState0.copy(gizmoTmp);
        this.camera.lookAt(this._gizmos.position);
        this.updateTbState(STATE.IDLE, false);
        this.dispatchEvent(_changeEvent2);
      }
    });
    this.camera = null;
    this.domElement = domElement;
    this.scene = scene;
    this.mouseActions = [];
    this._mouseOp = null;
    this._v2_1 = new Vector2();
    this._v3_1 = new Vector3();
    this._v3_2 = new Vector3();
    this._m4_1 = new Matrix4();
    this._m4_2 = new Matrix4();
    this._quat = new Quaternion();
    this._translationMatrix = new Matrix4();
    this._rotationMatrix = new Matrix4();
    this._scaleMatrix = new Matrix4();
    this._rotationAxis = new Vector3();
    this._cameraMatrixState = new Matrix4();
    this._cameraProjectionState = new Matrix4();
    this._fovState = 1;
    this._upState = new Vector3();
    this._zoomState = 1;
    this._nearPos = 0;
    this._farPos = 0;
    this._gizmoMatrixState = new Matrix4();
    this._up0 = new Vector3();
    this._zoom0 = 1;
    this._fov0 = 0;
    this._initialNear = 0;
    this._nearPos0 = 0;
    this._initialFar = 0;
    this._farPos0 = 0;
    this._cameraMatrixState0 = new Matrix4();
    this._gizmoMatrixState0 = new Matrix4();
    this._button = -1;
    this._touchStart = [];
    this._touchCurrent = [];
    this._input = INPUT.NONE;
    this._switchSensibility = 32;
    this._startFingerDistance = 0;
    this._currentFingerDistance = 0;
    this._startFingerRotation = 0;
    this._currentFingerRotation = 0;
    this._devPxRatio = 0;
    this._downValid = true;
    this._nclicks = 0;
    this._downEvents = [];
    this._clickStart = 0;
    this._maxDownTime = 250;
    this._maxInterval = 300;
    this._posThreshold = 24;
    this._movementThreshold = 24;
    this._currentCursorPosition = new Vector3();
    this._startCursorPosition = new Vector3();
    this._grid = null;
    this._gridPosition = new Vector3();
    this._gizmos = new Group();
    this._curvePts = 128;
    this._timeStart = -1;
    this._animationId = -1;
    this.focusAnimationTime = 500;
    this._timePrev = 0;
    this._timeCurrent = 0;
    this._anglePrev = 0;
    this._angleCurrent = 0;
    this._cursorPosPrev = new Vector3();
    this._cursorPosCurr = new Vector3();
    this._wPrev = 0;
    this._wCurr = 0;
    this.adjustNearFar = false;
    this.scaleFactor = 1.1;
    this.dampingFactor = 25;
    this.wMax = 20;
    this.enableAnimations = true;
    this.enableGrid = false;
    this.cursorZoom = false;
    this.minFov = 5;
    this.maxFov = 90;
    this.enabled = true;
    this.enablePan = true;
    this.enableRotate = true;
    this.enableZoom = true;
    this.minDistance = 0;
    this.maxDistance = Infinity;
    this.minZoom = 0;
    this.maxZoom = Infinity;
    this.target = new Vector3(0, 0, 0);
    this._currentTarget = new Vector3(0, 0, 0);
    this._tbRadius = 1;
    this._state = STATE.IDLE;
    this.setCamera(camera);
    if (this.scene) {
      this.scene.add(this._gizmos);
    }
    this._devPxRatio = window.devicePixelRatio;
    this.initializeMouseActions();
    if (this.domElement)
      this.connect(this.domElement);
    window.addEventListener("resize", this.onWindowResize);
  }
  /**
   * Apply a transformation matrix, to the camera and gizmos
   * @param {Object} transformation Object containing matrices to apply to camera and gizmos
   */
  applyTransformMatrix(transformation) {
    if ((transformation == null ? void 0 : transformation.camera) && this.camera) {
      this._m4_1.copy(this._cameraMatrixState).premultiply(transformation.camera);
      this._m4_1.decompose(this.camera.position, this.camera.quaternion, this.camera.scale);
      this.camera.updateMatrix();
      if (this._state == STATE.ROTATE || this._state == STATE.ZROTATE || this._state == STATE.ANIMATION_ROTATE) {
        this.camera.up.copy(this._upState).applyQuaternion(this.camera.quaternion);
      }
    }
    if (transformation == null ? void 0 : transformation.gizmos) {
      this._m4_1.copy(this._gizmoMatrixState).premultiply(transformation.gizmos);
      this._m4_1.decompose(this._gizmos.position, this._gizmos.quaternion, this._gizmos.scale);
      this._gizmos.updateMatrix();
    }
    if ((this._state == STATE.SCALE || this._state == STATE.FOCUS || this._state == STATE.ANIMATION_FOCUS) && this.camera) {
      const tbRadius = this.calculateTbRadius(this.camera);
      if (tbRadius !== void 0) {
        this._tbRadius = tbRadius;
      }
      if (this.adjustNearFar) {
        const cameraDistance = this.camera.position.distanceTo(this._gizmos.position);
        const bb2 = new Box3();
        bb2.setFromObject(this._gizmos);
        const sphere = new Sphere();
        bb2.getBoundingSphere(sphere);
        const adjustedNearPosition = Math.max(this._nearPos0, sphere.radius + sphere.center.length());
        const regularNearPosition = cameraDistance - this._initialNear;
        const minNearPos = Math.min(adjustedNearPosition, regularNearPosition);
        this.camera.near = cameraDistance - minNearPos;
        const adjustedFarPosition = Math.min(this._farPos0, -sphere.radius + sphere.center.length());
        const regularFarPosition = cameraDistance - this._initialFar;
        const minFarPos = Math.min(adjustedFarPosition, regularFarPosition);
        this.camera.far = cameraDistance - minFarPos;
        this.camera.updateProjectionMatrix();
      } else {
        let update2 = false;
        if (this.camera.near != this._initialNear) {
          this.camera.near = this._initialNear;
          update2 = true;
        }
        if (this.camera.far != this._initialFar) {
          this.camera.far = this._initialFar;
          update2 = true;
        }
        if (update2) {
          this.camera.updateProjectionMatrix();
        }
      }
    }
  }
  /**
   * Set gizmos visibility
   * @param {Boolean} value Value of gizmos visibility
   */
  setGizmosVisible(value) {
    this._gizmos.visible = value;
    this.dispatchEvent(_changeEvent2);
  }
  /**
   * Set values in transformation object
   * @param {Matrix4} camera Transformation to be applied to the camera
   * @param {Matrix4} gizmos Transformation to be applied to gizmos
   */
  setTransformationMatrices(camera = null, gizmos = null) {
    if (camera) {
      if (_transformation.camera) {
        _transformation.camera.copy(camera);
      } else {
        _transformation.camera = camera.clone();
      }
    } else {
      _transformation.camera = null;
    }
    if (gizmos) {
      if (_transformation.gizmos) {
        _transformation.gizmos.copy(gizmos);
      } else {
        _transformation.gizmos = gizmos.clone();
      }
    } else {
      _transformation.gizmos = null;
    }
  }
};

// node_modules/three-stdlib/controls/FlyControls.js
var __defProp19 = Object.defineProperty;
var __defNormalProp19 = (obj, key, value) => key in obj ? __defProp19(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField20 = (obj, key, value) => {
  __defNormalProp19(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
function contextmenu(event) {
  event.preventDefault();
}
var FlyControls = class extends EventDispatcher2 {
  constructor(object, domElement) {
    super();
    __publicField20(this, "object");
    __publicField20(this, "domElement", null);
    __publicField20(this, "movementSpeed", 1);
    __publicField20(this, "rollSpeed", 5e-3);
    __publicField20(this, "dragToLook", false);
    __publicField20(this, "autoForward", false);
    __publicField20(this, "changeEvent", { type: "change" });
    __publicField20(this, "EPS", 1e-6);
    __publicField20(this, "tmpQuaternion", new Quaternion());
    __publicField20(this, "mouseStatus", 0);
    __publicField20(this, "movementSpeedMultiplier", 1);
    __publicField20(this, "moveState", {
      up: 0,
      down: 0,
      left: 0,
      right: 0,
      forward: 0,
      back: 0,
      pitchUp: 0,
      pitchDown: 0,
      yawLeft: 0,
      yawRight: 0,
      rollLeft: 0,
      rollRight: 0
    });
    __publicField20(this, "moveVector", new Vector3(0, 0, 0));
    __publicField20(this, "rotationVector", new Vector3(0, 0, 0));
    __publicField20(this, "keydown", (event) => {
      if (event.altKey) {
        return;
      }
      switch (event.code) {
        case "ShiftLeft":
        case "ShiftRight":
          this.movementSpeedMultiplier = 0.1;
          break;
        case "KeyW":
          this.moveState.forward = 1;
          break;
        case "KeyS":
          this.moveState.back = 1;
          break;
        case "KeyA":
          this.moveState.left = 1;
          break;
        case "KeyD":
          this.moveState.right = 1;
          break;
        case "KeyR":
          this.moveState.up = 1;
          break;
        case "KeyF":
          this.moveState.down = 1;
          break;
        case "ArrowUp":
          this.moveState.pitchUp = 1;
          break;
        case "ArrowDown":
          this.moveState.pitchDown = 1;
          break;
        case "ArrowLeft":
          this.moveState.yawLeft = 1;
          break;
        case "ArrowRight":
          this.moveState.yawRight = 1;
          break;
        case "KeyQ":
          this.moveState.rollLeft = 1;
          break;
        case "KeyE":
          this.moveState.rollRight = 1;
          break;
      }
      this.updateMovementVector();
      this.updateRotationVector();
    });
    __publicField20(this, "keyup", (event) => {
      switch (event.code) {
        case "ShiftLeft":
        case "ShiftRight":
          this.movementSpeedMultiplier = 1;
          break;
        case "KeyW":
          this.moveState.forward = 0;
          break;
        case "KeyS":
          this.moveState.back = 0;
          break;
        case "KeyA":
          this.moveState.left = 0;
          break;
        case "KeyD":
          this.moveState.right = 0;
          break;
        case "KeyR":
          this.moveState.up = 0;
          break;
        case "KeyF":
          this.moveState.down = 0;
          break;
        case "ArrowUp":
          this.moveState.pitchUp = 0;
          break;
        case "ArrowDown":
          this.moveState.pitchDown = 0;
          break;
        case "ArrowLeft":
          this.moveState.yawLeft = 0;
          break;
        case "ArrowRight":
          this.moveState.yawRight = 0;
          break;
        case "KeyQ":
          this.moveState.rollLeft = 0;
          break;
        case "KeyE":
          this.moveState.rollRight = 0;
          break;
      }
      this.updateMovementVector();
      this.updateRotationVector();
    });
    __publicField20(this, "pointerdown", (event) => {
      if (this.dragToLook) {
        this.mouseStatus++;
      } else {
        switch (event.button) {
          case 0:
            this.moveState.forward = 1;
            break;
          case 2:
            this.moveState.back = 1;
            break;
        }
        this.updateMovementVector();
      }
    });
    __publicField20(this, "pointermove", (event) => {
      if (!this.dragToLook || this.mouseStatus > 0) {
        const container = this.getContainerDimensions();
        const halfWidth = container.size[0] / 2;
        const halfHeight = container.size[1] / 2;
        this.moveState.yawLeft = -(event.pageX - container.offset[0] - halfWidth) / halfWidth;
        this.moveState.pitchDown = (event.pageY - container.offset[1] - halfHeight) / halfHeight;
        this.updateRotationVector();
      }
    });
    __publicField20(this, "pointerup", (event) => {
      if (this.dragToLook) {
        this.mouseStatus--;
        this.moveState.yawLeft = this.moveState.pitchDown = 0;
      } else {
        switch (event.button) {
          case 0:
            this.moveState.forward = 0;
            break;
          case 2:
            this.moveState.back = 0;
            break;
        }
        this.updateMovementVector();
      }
      this.updateRotationVector();
    });
    __publicField20(this, "lastQuaternion", new Quaternion());
    __publicField20(this, "lastPosition", new Vector3());
    __publicField20(this, "update", (delta) => {
      const moveMult = delta * this.movementSpeed;
      const rotMult = delta * this.rollSpeed;
      this.object.translateX(this.moveVector.x * moveMult);
      this.object.translateY(this.moveVector.y * moveMult);
      this.object.translateZ(this.moveVector.z * moveMult);
      this.tmpQuaternion.set(this.rotationVector.x * rotMult, this.rotationVector.y * rotMult, this.rotationVector.z * rotMult, 1).normalize();
      this.object.quaternion.multiply(this.tmpQuaternion);
      if (this.lastPosition.distanceToSquared(this.object.position) > this.EPS || 8 * (1 - this.lastQuaternion.dot(this.object.quaternion)) > this.EPS) {
        this.dispatchEvent(this.changeEvent);
        this.lastQuaternion.copy(this.object.quaternion);
        this.lastPosition.copy(this.object.position);
      }
    });
    __publicField20(this, "updateMovementVector", () => {
      const forward = this.moveState.forward || this.autoForward && !this.moveState.back ? 1 : 0;
      this.moveVector.x = -this.moveState.left + this.moveState.right;
      this.moveVector.y = -this.moveState.down + this.moveState.up;
      this.moveVector.z = -forward + this.moveState.back;
    });
    __publicField20(this, "updateRotationVector", () => {
      this.rotationVector.x = -this.moveState.pitchDown + this.moveState.pitchUp;
      this.rotationVector.y = -this.moveState.yawRight + this.moveState.yawLeft;
      this.rotationVector.z = -this.moveState.rollRight + this.moveState.rollLeft;
    });
    __publicField20(this, "getContainerDimensions", () => {
      if (this.domElement != document && !(this.domElement instanceof Document)) {
        return {
          size: [this.domElement.offsetWidth, this.domElement.offsetHeight],
          offset: [this.domElement.offsetLeft, this.domElement.offsetTop]
        };
      } else {
        return {
          size: [window.innerWidth, window.innerHeight],
          offset: [0, 0]
        };
      }
    });
    __publicField20(this, "connect", (domElement2) => {
      this.domElement = domElement2;
      if (!(domElement2 instanceof Document)) {
        domElement2.setAttribute("tabindex", -1);
      }
      this.domElement.addEventListener("contextmenu", contextmenu);
      this.domElement.addEventListener("pointermove", this.pointermove);
      this.domElement.addEventListener("pointerdown", this.pointerdown);
      this.domElement.addEventListener("pointerup", this.pointerup);
      window.addEventListener("keydown", this.keydown);
      window.addEventListener("keyup", this.keyup);
    });
    __publicField20(this, "dispose", () => {
      this.domElement.removeEventListener("contextmenu", contextmenu);
      this.domElement.removeEventListener("pointermove", this.pointermove);
      this.domElement.removeEventListener("pointerdown", this.pointerdown);
      this.domElement.removeEventListener("pointerup", this.pointerup);
      window.removeEventListener("keydown", this.keydown);
      window.removeEventListener("keyup", this.keyup);
    });
    this.object = object;
    if (domElement !== void 0)
      this.connect(domElement);
    this.updateMovementVector();
    this.updateRotationVector();
  }
};

// node_modules/three-stdlib/postprocessing/Pass.js
var __defProp20 = Object.defineProperty;
var __defNormalProp20 = (obj, key, value) => key in obj ? __defProp20(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField21 = (obj, key, value) => {
  __defNormalProp20(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var Pass = class {
  constructor() {
    __publicField21(this, "enabled", true);
    __publicField21(this, "needsSwap", true);
    __publicField21(this, "clear", false);
    __publicField21(this, "renderToScreen", false);
  }
  setSize(width, height) {
  }
  render(renderer, writeBuffer, readBuffer, deltaTime, maskActive) {
    console.error("THREE.Pass: .render() must be implemented in derived pass.");
  }
  dispose() {
  }
};
var FullScreenQuad = class {
  constructor(material) {
    __publicField21(this, "camera", new OrthographicCamera(-1, 1, 1, -1, 0, 1));
    __publicField21(this, "geometry", new PlaneGeometry(2, 2));
    __publicField21(this, "mesh");
    this.mesh = new Mesh(this.geometry, material);
  }
  get material() {
    return this.mesh.material;
  }
  set material(value) {
    this.mesh.material = value;
  }
  dispose() {
    this.mesh.geometry.dispose();
  }
  render(renderer) {
    renderer.render(this.mesh, this.camera);
  }
};

// node_modules/three-stdlib/postprocessing/ShaderPass.js
var __defProp21 = Object.defineProperty;
var __defNormalProp21 = (obj, key, value) => key in obj ? __defProp21(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField22 = (obj, key, value) => {
  __defNormalProp21(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var ShaderPass = class extends Pass {
  constructor(shader, textureID = "tDiffuse") {
    super();
    __publicField22(this, "textureID");
    __publicField22(this, "uniforms");
    __publicField22(this, "material");
    __publicField22(this, "fsQuad");
    this.textureID = textureID;
    if (shader instanceof ShaderMaterial) {
      this.uniforms = shader.uniforms;
      this.material = shader;
    } else {
      this.uniforms = UniformsUtils.clone(shader.uniforms);
      this.material = new ShaderMaterial({
        defines: Object.assign({}, shader.defines),
        uniforms: this.uniforms,
        vertexShader: shader.vertexShader,
        fragmentShader: shader.fragmentShader
      });
    }
    this.fsQuad = new FullScreenQuad(this.material);
  }
  render(renderer, writeBuffer, readBuffer) {
    if (this.uniforms[this.textureID]) {
      this.uniforms[this.textureID].value = readBuffer.texture;
    }
    this.fsQuad.material = this.material;
    if (this.renderToScreen) {
      renderer.setRenderTarget(null);
      this.fsQuad.render(renderer);
    } else {
      renderer.setRenderTarget(writeBuffer);
      if (this.clear)
        renderer.clear(renderer.autoClearColor, renderer.autoClearDepth, renderer.autoClearStencil);
      this.fsQuad.render(renderer);
    }
  }
  dispose() {
    this.fsQuad.dispose();
    this.material.dispose();
  }
};

// node_modules/three-stdlib/shaders/HalftoneShader.js
var HalftoneShader = {
  uniforms: {
    tDiffuse: { value: null },
    shape: { value: 1 },
    radius: { value: 4 },
    rotateR: { value: Math.PI / 12 * 1 },
    rotateG: { value: Math.PI / 12 * 2 },
    rotateB: { value: Math.PI / 12 * 3 },
    scatter: { value: 0 },
    width: { value: 1 },
    height: { value: 1 },
    blending: { value: 1 },
    blendingMode: { value: 1 },
    greyscale: { value: false },
    disable: { value: false }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUV;

    void main() {

    	vUV = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    #define SQRT2_MINUS_ONE 0.41421356
    #define SQRT2_HALF_MINUS_ONE 0.20710678
    #define PI2 6.28318531
    #define SHAPE_DOT 1
    #define SHAPE_ELLIPSE 2
    #define SHAPE_LINE 3
    #define SHAPE_SQUARE 4
    #define BLENDING_LINEAR 1
    #define BLENDING_MULTIPLY 2
    #define BLENDING_ADD 3
    #define BLENDING_LIGHTER 4
    #define BLENDING_DARKER 5
    uniform sampler2D tDiffuse;
    uniform float radius;
    uniform float rotateR;
    uniform float rotateG;
    uniform float rotateB;
    uniform float scatter;
    uniform float width;
    uniform float height;
    uniform int shape;
    uniform bool disable;
    uniform float blending;
    uniform int blendingMode;
    varying vec2 vUV;
    uniform bool greyscale;
    const int samples = 8;

    float blend( float a, float b, float t ) {

    // linear blend
    	return a * ( 1.0 - t ) + b * t;

    }

    float hypot( float x, float y ) {

    // vector magnitude
    	return sqrt( x * x + y * y );

    }

    float rand( vec2 seed ){

    // get pseudo-random number
    return fract( sin( dot( seed.xy, vec2( 12.9898, 78.233 ) ) ) * 43758.5453 );

    }

    float distanceToDotRadius( float channel, vec2 coord, vec2 normal, vec2 p, float angle, float rad_max ) {

    // apply shape-specific transforms
    	float dist = hypot( coord.x - p.x, coord.y - p.y );
    	float rad = channel;

    	if ( shape == SHAPE_DOT ) {

    		rad = pow( abs( rad ), 1.125 ) * rad_max;

    	} else if ( shape == SHAPE_ELLIPSE ) {

    		rad = pow( abs( rad ), 1.125 ) * rad_max;

    		if ( dist != 0.0 ) {
    			float dot_p = abs( ( p.x - coord.x ) / dist * normal.x + ( p.y - coord.y ) / dist * normal.y );
    			dist = ( dist * ( 1.0 - SQRT2_HALF_MINUS_ONE ) ) + dot_p * dist * SQRT2_MINUS_ONE;
    		}

    	} else if ( shape == SHAPE_LINE ) {

    		rad = pow( abs( rad ), 1.5) * rad_max;
    		float dot_p = ( p.x - coord.x ) * normal.x + ( p.y - coord.y ) * normal.y;
    		dist = hypot( normal.x * dot_p, normal.y * dot_p );

    	} else if ( shape == SHAPE_SQUARE ) {

    		float theta = atan( p.y - coord.y, p.x - coord.x ) - angle;
    		float sin_t = abs( sin( theta ) );
    		float cos_t = abs( cos( theta ) );
    		rad = pow( abs( rad ), 1.4 );
    		rad = rad_max * ( rad + ( ( sin_t > cos_t ) ? rad - sin_t * rad : rad - cos_t * rad ) );

    	}

    	return rad - dist;

    }

    struct Cell {

    // grid sample positions
    	vec2 normal;
    	vec2 p1;
    	vec2 p2;
    	vec2 p3;
    	vec2 p4;
    	float samp2;
    	float samp1;
    	float samp3;
    	float samp4;

    };

    vec4 getSample( vec2 point ) {

    // multi-sampled point
    	vec4 tex = texture2D( tDiffuse, vec2( point.x / width, point.y / height ) );
    	float base = rand( vec2( floor( point.x ), floor( point.y ) ) ) * PI2;
    	float step = PI2 / float( samples );
    	float dist = radius * 0.66;

    	for ( int i = 0; i < samples; ++i ) {

    		float r = base + step * float( i );
    		vec2 coord = point + vec2( cos( r ) * dist, sin( r ) * dist );
    		tex += texture2D( tDiffuse, vec2( coord.x / width, coord.y / height ) );

    	}

    	tex /= float( samples ) + 1.0;
    	return tex;

    }

    float getDotColour( Cell c, vec2 p, int channel, float angle, float aa ) {

    // get colour for given point
    	float dist_c_1, dist_c_2, dist_c_3, dist_c_4, res;

    	if ( channel == 0 ) {

    		c.samp1 = getSample( c.p1 ).r;
    		c.samp2 = getSample( c.p2 ).r;
    		c.samp3 = getSample( c.p3 ).r;
    		c.samp4 = getSample( c.p4 ).r;

    	} else if (channel == 1) {

    		c.samp1 = getSample( c.p1 ).g;
    		c.samp2 = getSample( c.p2 ).g;
    		c.samp3 = getSample( c.p3 ).g;
    		c.samp4 = getSample( c.p4 ).g;

    	} else {

    		c.samp1 = getSample( c.p1 ).b;
    		c.samp3 = getSample( c.p3 ).b;
    		c.samp2 = getSample( c.p2 ).b;
    		c.samp4 = getSample( c.p4 ).b;

    	}

    	dist_c_1 = distanceToDotRadius( c.samp1, c.p1, c.normal, p, angle, radius );
    	dist_c_2 = distanceToDotRadius( c.samp2, c.p2, c.normal, p, angle, radius );
    	dist_c_3 = distanceToDotRadius( c.samp3, c.p3, c.normal, p, angle, radius );
    	dist_c_4 = distanceToDotRadius( c.samp4, c.p4, c.normal, p, angle, radius );
    	res = ( dist_c_1 > 0.0 ) ? clamp( dist_c_1 / aa, 0.0, 1.0 ) : 0.0;
    	res += ( dist_c_2 > 0.0 ) ? clamp( dist_c_2 / aa, 0.0, 1.0 ) : 0.0;
    	res += ( dist_c_3 > 0.0 ) ? clamp( dist_c_3 / aa, 0.0, 1.0 ) : 0.0;
    	res += ( dist_c_4 > 0.0 ) ? clamp( dist_c_4 / aa, 0.0, 1.0 ) : 0.0;
    	res = clamp( res, 0.0, 1.0 );

    	return res;

    }

    Cell getReferenceCell( vec2 p, vec2 origin, float grid_angle, float step ) {

    // get containing cell
    	Cell c;

    // calc grid
    	vec2 n = vec2( cos( grid_angle ), sin( grid_angle ) );
    	float threshold = step * 0.5;
    	float dot_normal = n.x * ( p.x - origin.x ) + n.y * ( p.y - origin.y );
    	float dot_line = -n.y * ( p.x - origin.x ) + n.x * ( p.y - origin.y );
    	vec2 offset = vec2( n.x * dot_normal, n.y * dot_normal );
    	float offset_normal = mod( hypot( offset.x, offset.y ), step );
    	float normal_dir = ( dot_normal < 0.0 ) ? 1.0 : -1.0;
    	float normal_scale = ( ( offset_normal < threshold ) ? -offset_normal : step - offset_normal ) * normal_dir;
    	float offset_line = mod( hypot( ( p.x - offset.x ) - origin.x, ( p.y - offset.y ) - origin.y ), step );
    	float line_dir = ( dot_line < 0.0 ) ? 1.0 : -1.0;
    	float line_scale = ( ( offset_line < threshold ) ? -offset_line : step - offset_line ) * line_dir;

    // get closest corner
    	c.normal = n;
    	c.p1.x = p.x - n.x * normal_scale + n.y * line_scale;
    	c.p1.y = p.y - n.y * normal_scale - n.x * line_scale;

    // scatter
    	if ( scatter != 0.0 ) {

    		float off_mag = scatter * threshold * 0.5;
    		float off_angle = rand( vec2( floor( c.p1.x ), floor( c.p1.y ) ) ) * PI2;
    		c.p1.x += cos( off_angle ) * off_mag;
    		c.p1.y += sin( off_angle ) * off_mag;

    	}

    // find corners
    	float normal_step = normal_dir * ( ( offset_normal < threshold ) ? step : -step );
    	float line_step = line_dir * ( ( offset_line < threshold ) ? step : -step );
    	c.p2.x = c.p1.x - n.x * normal_step;
    	c.p2.y = c.p1.y - n.y * normal_step;
    	c.p3.x = c.p1.x + n.y * line_step;
    	c.p3.y = c.p1.y - n.x * line_step;
    	c.p4.x = c.p1.x - n.x * normal_step + n.y * line_step;
    	c.p4.y = c.p1.y - n.y * normal_step - n.x * line_step;

    	return c;

    }

    float blendColour( float a, float b, float t ) {

    // blend colours
    	if ( blendingMode == BLENDING_LINEAR ) {
    		return blend( a, b, 1.0 - t );
    	} else if ( blendingMode == BLENDING_ADD ) {
    		return blend( a, min( 1.0, a + b ), t );
    	} else if ( blendingMode == BLENDING_MULTIPLY ) {
    		return blend( a, max( 0.0, a * b ), t );
    	} else if ( blendingMode == BLENDING_LIGHTER ) {
    		return blend( a, max( a, b ), t );
    	} else if ( blendingMode == BLENDING_DARKER ) {
    		return blend( a, min( a, b ), t );
    	} else {
    		return blend( a, b, 1.0 - t );
    	}

    }

    void main() {

    	if ( ! disable ) {

    // setup
    		vec2 p = vec2( vUV.x * width, vUV.y * height );
    		vec2 origin = vec2( 0, 0 );
    		float aa = ( radius < 2.5 ) ? radius * 0.5 : 1.25;

    // get channel samples
    		Cell cell_r = getReferenceCell( p, origin, rotateR, radius );
    		Cell cell_g = getReferenceCell( p, origin, rotateG, radius );
    		Cell cell_b = getReferenceCell( p, origin, rotateB, radius );
    		float r = getDotColour( cell_r, p, 0, rotateR, aa );
    		float g = getDotColour( cell_g, p, 1, rotateG, aa );
    		float b = getDotColour( cell_b, p, 2, rotateB, aa );

    // blend with original
    		vec4 colour = texture2D( tDiffuse, vUV );
    		r = blendColour( r, colour.r, blending );
    		g = blendColour( g, colour.g, blending );
    		b = blendColour( b, colour.b, blending );

    		if ( greyscale ) {
    			r = g = b = (r + b + g) / 3.0;
    		}

    		gl_FragColor = vec4( r, g, b, 1.0 );

    	} else {

    		gl_FragColor = texture2D( tDiffuse, vUV );

    	}

    }
  `
  )
};

// node_modules/three-stdlib/shaders/SMAAShader.js
var SMAAEdgesShader = {
  defines: {
    SMAA_THRESHOLD: "0.1"
  },
  uniforms: {
    tDiffuse: { value: null },
    resolution: { value: new Vector2(1 / 1024, 1 / 512) }
  },
  vertexShader: (
    /* glsl */
    `
    uniform vec2 resolution;

    varying vec2 vUv;
    varying vec4 vOffset[ 3 ];

    void SMAAEdgeDetectionVS( vec2 texcoord ) {
    	vOffset[ 0 ] = texcoord.xyxy + resolution.xyxy * vec4( -1.0, 0.0, 0.0,  1.0 ); // WebGL port note: Changed sign in W component
    	vOffset[ 1 ] = texcoord.xyxy + resolution.xyxy * vec4(  1.0, 0.0, 0.0, -1.0 ); // WebGL port note: Changed sign in W component
    	vOffset[ 2 ] = texcoord.xyxy + resolution.xyxy * vec4( -2.0, 0.0, 0.0,  2.0 ); // WebGL port note: Changed sign in W component
    }

    void main() {

    	vUv = uv;

    	SMAAEdgeDetectionVS( vUv );

    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform sampler2D tDiffuse;

    varying vec2 vUv;
    varying vec4 vOffset[ 3 ];

    vec4 SMAAColorEdgeDetectionPS( vec2 texcoord, vec4 offset[3], sampler2D colorTex ) {
    	vec2 threshold = vec2( SMAA_THRESHOLD, SMAA_THRESHOLD );

    // Calculate color deltas:
    	vec4 delta;
    	vec3 C = texture2D( colorTex, texcoord ).rgb;

    	vec3 Cleft = texture2D( colorTex, offset[0].xy ).rgb;
    	vec3 t = abs( C - Cleft );
    	delta.x = max( max( t.r, t.g ), t.b );

    	vec3 Ctop = texture2D( colorTex, offset[0].zw ).rgb;
    	t = abs( C - Ctop );
    	delta.y = max( max( t.r, t.g ), t.b );

    // We do the usual threshold:
    	vec2 edges = step( threshold, delta.xy );

    // Then discard if there is no edge:
    	if ( dot( edges, vec2( 1.0, 1.0 ) ) == 0.0 )
    		discard;

    // Calculate right and bottom deltas:
    	vec3 Cright = texture2D( colorTex, offset[1].xy ).rgb;
    	t = abs( C - Cright );
    	delta.z = max( max( t.r, t.g ), t.b );

    	vec3 Cbottom  = texture2D( colorTex, offset[1].zw ).rgb;
    	t = abs( C - Cbottom );
    	delta.w = max( max( t.r, t.g ), t.b );

    // Calculate the maximum delta in the direct neighborhood:
    	float maxDelta = max( max( max( delta.x, delta.y ), delta.z ), delta.w );

    // Calculate left-left and top-top deltas:
    	vec3 Cleftleft  = texture2D( colorTex, offset[2].xy ).rgb;
    	t = abs( C - Cleftleft );
    	delta.z = max( max( t.r, t.g ), t.b );

    	vec3 Ctoptop = texture2D( colorTex, offset[2].zw ).rgb;
    	t = abs( C - Ctoptop );
    	delta.w = max( max( t.r, t.g ), t.b );

    // Calculate the final maximum delta:
    	maxDelta = max( max( maxDelta, delta.z ), delta.w );

    // Local contrast adaptation in action:
    	edges.xy *= step( 0.5 * maxDelta, delta.xy );

    	return vec4( edges, 0.0, 0.0 );
    }

    void main() {

    	gl_FragColor = SMAAColorEdgeDetectionPS( vUv, vOffset, tDiffuse );

    }
  `
  )
};
var SMAAWeightsShader = {
  defines: {
    SMAA_MAX_SEARCH_STEPS: "8",
    SMAA_AREATEX_MAX_DISTANCE: "16",
    SMAA_AREATEX_PIXEL_SIZE: "( 1.0 / vec2( 160.0, 560.0 ) )",
    SMAA_AREATEX_SUBTEX_SIZE: "( 1.0 / 7.0 )"
  },
  uniforms: {
    tDiffuse: { value: null },
    tArea: { value: null },
    tSearch: { value: null },
    resolution: { value: new Vector2(1 / 1024, 1 / 512) }
  },
  vertexShader: (
    /* glsl */
    `
    uniform vec2 resolution;

    varying vec2 vUv;
    varying vec4 vOffset[ 3 ];
    varying vec2 vPixcoord;

    void SMAABlendingWeightCalculationVS( vec2 texcoord ) {
    	vPixcoord = texcoord / resolution;

    // We will use these offsets for the searches later on (see @PSEUDO_GATHER4):
    	vOffset[ 0 ] = texcoord.xyxy + resolution.xyxy * vec4( -0.25, 0.125, 1.25, 0.125 ); // WebGL port note: Changed sign in Y and W components
    	vOffset[ 1 ] = texcoord.xyxy + resolution.xyxy * vec4( -0.125, 0.25, -0.125, -1.25 ); // WebGL port note: Changed sign in Y and W components

    // And these for the searches, they indicate the ends of the loops:
    	vOffset[ 2 ] = vec4( vOffset[ 0 ].xz, vOffset[ 1 ].yw ) + vec4( -2.0, 2.0, -2.0, 2.0 ) * resolution.xxyy * float( SMAA_MAX_SEARCH_STEPS );

    }

    void main() {

    	vUv = uv;

    	SMAABlendingWeightCalculationVS( vUv );

    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    #define SMAASampleLevelZeroOffset( tex, coord, offset ) texture2D( tex, coord + float( offset ) * resolution, 0.0 )

    uniform sampler2D tDiffuse;
    uniform sampler2D tArea;
    uniform sampler2D tSearch;
    uniform vec2 resolution;

    varying vec2 vUv;
    varying vec4 vOffset[3];
    varying vec2 vPixcoord;

    #if __VERSION__ == 100
    vec2 round( vec2 x ) {
    	return sign( x ) * floor( abs( x ) + 0.5 );
    }
    #endif

    float SMAASearchLength( sampler2D searchTex, vec2 e, float bias, float scale ) {
    // Not required if searchTex accesses are set to point:
    // float2 SEARCH_TEX_PIXEL_SIZE = 1.0 / float2(66.0, 33.0);
    // e = float2(bias, 0.0) + 0.5 * SEARCH_TEX_PIXEL_SIZE +
    //     e * float2(scale, 1.0) * float2(64.0, 32.0) * SEARCH_TEX_PIXEL_SIZE;
    	e.r = bias + e.r * scale;
    	return 255.0 * texture2D( searchTex, e, 0.0 ).r;
    }

    float SMAASearchXLeft( sampler2D edgesTex, sampler2D searchTex, vec2 texcoord, float end ) {
    /**
     * @PSEUDO_GATHER4
     * This texcoord has been offset by (-0.25, -0.125) in the vertex shader to
     * sample between edge, thus fetching four edges in a row.
     * Sampling with different offsets in each direction allows to disambiguate
     * which edges are active from the four fetched ones.
     */
    	vec2 e = vec2( 0.0, 1.0 );

    	for ( int i = 0; i < SMAA_MAX_SEARCH_STEPS; i ++ ) { // WebGL port note: Changed while to for
    		e = texture2D( edgesTex, texcoord, 0.0 ).rg;
    		texcoord -= vec2( 2.0, 0.0 ) * resolution;
    		if ( ! ( texcoord.x > end && e.g > 0.8281 && e.r == 0.0 ) ) break;
    	}

    // We correct the previous (-0.25, -0.125) offset we applied:
    	texcoord.x += 0.25 * resolution.x;

    // The searches are bias by 1, so adjust the coords accordingly:
    	texcoord.x += resolution.x;

    // Disambiguate the length added by the last step:
    	texcoord.x += 2.0 * resolution.x; // Undo last step
    	texcoord.x -= resolution.x * SMAASearchLength(searchTex, e, 0.0, 0.5);

    	return texcoord.x;
    }

    float SMAASearchXRight( sampler2D edgesTex, sampler2D searchTex, vec2 texcoord, float end ) {
    	vec2 e = vec2( 0.0, 1.0 );

    	for ( int i = 0; i < SMAA_MAX_SEARCH_STEPS; i ++ ) { // WebGL port note: Changed while to for
    		e = texture2D( edgesTex, texcoord, 0.0 ).rg;
    		texcoord += vec2( 2.0, 0.0 ) * resolution;
    		if ( ! ( texcoord.x < end && e.g > 0.8281 && e.r == 0.0 ) ) break;
    	}

    	texcoord.x -= 0.25 * resolution.x;
    	texcoord.x -= resolution.x;
    	texcoord.x -= 2.0 * resolution.x;
    	texcoord.x += resolution.x * SMAASearchLength( searchTex, e, 0.5, 0.5 );

    	return texcoord.x;
    }

    float SMAASearchYUp( sampler2D edgesTex, sampler2D searchTex, vec2 texcoord, float end ) {
    	vec2 e = vec2( 1.0, 0.0 );

    	for ( int i = 0; i < SMAA_MAX_SEARCH_STEPS; i ++ ) { // WebGL port note: Changed while to for
    		e = texture2D( edgesTex, texcoord, 0.0 ).rg;
    		texcoord += vec2( 0.0, 2.0 ) * resolution; // WebGL port note: Changed sign
    		if ( ! ( texcoord.y > end && e.r > 0.8281 && e.g == 0.0 ) ) break;
    	}

    	texcoord.y -= 0.25 * resolution.y; // WebGL port note: Changed sign
    	texcoord.y -= resolution.y; // WebGL port note: Changed sign
    	texcoord.y -= 2.0 * resolution.y; // WebGL port note: Changed sign
    	texcoord.y += resolution.y * SMAASearchLength( searchTex, e.gr, 0.0, 0.5 ); // WebGL port note: Changed sign

    	return texcoord.y;
    }

    float SMAASearchYDown( sampler2D edgesTex, sampler2D searchTex, vec2 texcoord, float end ) {
    	vec2 e = vec2( 1.0, 0.0 );

    	for ( int i = 0; i < SMAA_MAX_SEARCH_STEPS; i ++ ) { // WebGL port note: Changed while to for
    		e = texture2D( edgesTex, texcoord, 0.0 ).rg;
    		texcoord -= vec2( 0.0, 2.0 ) * resolution; // WebGL port note: Changed sign
    		if ( ! ( texcoord.y < end && e.r > 0.8281 && e.g == 0.0 ) ) break;
    	}

    	texcoord.y += 0.25 * resolution.y; // WebGL port note: Changed sign
    	texcoord.y += resolution.y; // WebGL port note: Changed sign
    	texcoord.y += 2.0 * resolution.y; // WebGL port note: Changed sign
    	texcoord.y -= resolution.y * SMAASearchLength( searchTex, e.gr, 0.5, 0.5 ); // WebGL port note: Changed sign

    	return texcoord.y;
    }

    vec2 SMAAArea( sampler2D areaTex, vec2 dist, float e1, float e2, float offset ) {
    // Rounding prevents precision errors of bilinear filtering:
    	vec2 texcoord = float( SMAA_AREATEX_MAX_DISTANCE ) * round( 4.0 * vec2( e1, e2 ) ) + dist;

    // We do a scale and bias for mapping to texel space:
    	texcoord = SMAA_AREATEX_PIXEL_SIZE * texcoord + ( 0.5 * SMAA_AREATEX_PIXEL_SIZE );

    // Move to proper place, according to the subpixel offset:
    	texcoord.y += SMAA_AREATEX_SUBTEX_SIZE * offset;

    	return texture2D( areaTex, texcoord, 0.0 ).rg;
    }

    vec4 SMAABlendingWeightCalculationPS( vec2 texcoord, vec2 pixcoord, vec4 offset[ 3 ], sampler2D edgesTex, sampler2D areaTex, sampler2D searchTex, ivec4 subsampleIndices ) {
    	vec4 weights = vec4( 0.0, 0.0, 0.0, 0.0 );

    	vec2 e = texture2D( edgesTex, texcoord ).rg;

    	if ( e.g > 0.0 ) { // Edge at north
    		vec2 d;

    // Find the distance to the left:
    		vec2 coords;
    		coords.x = SMAASearchXLeft( edgesTex, searchTex, offset[ 0 ].xy, offset[ 2 ].x );
    		coords.y = offset[ 1 ].y; // offset[1].y = texcoord.y - 0.25 * resolution.y (@CROSSING_OFFSET)
    		d.x = coords.x;

    // Now fetch the left crossing edges, two at a time using bilinear
    // filtering. Sampling at -0.25 (see @CROSSING_OFFSET) enables to
    // discern what value each edge has:
    		float e1 = texture2D( edgesTex, coords, 0.0 ).r;

    // Find the distance to the right:
    		coords.x = SMAASearchXRight( edgesTex, searchTex, offset[ 0 ].zw, offset[ 2 ].y );
    		d.y = coords.x;

    // We want the distances to be in pixel units (doing this here allow to
    // better interleave arithmetic and memory accesses):
    		d = d / resolution.x - pixcoord.x;

    // SMAAArea below needs a sqrt, as the areas texture is compressed
    // quadratically:
    		vec2 sqrt_d = sqrt( abs( d ) );

    // Fetch the right crossing edges:
    		coords.y -= 1.0 * resolution.y; // WebGL port note: Added
    		float e2 = SMAASampleLevelZeroOffset( edgesTex, coords, ivec2( 1, 0 ) ).r;

    // Ok, we know how this pattern looks like, now it is time for getting
    // the actual area:
    		weights.rg = SMAAArea( areaTex, sqrt_d, e1, e2, float( subsampleIndices.y ) );
    	}

    	if ( e.r > 0.0 ) { // Edge at west
    		vec2 d;

    // Find the distance to the top:
    		vec2 coords;

    		coords.y = SMAASearchYUp( edgesTex, searchTex, offset[ 1 ].xy, offset[ 2 ].z );
    		coords.x = offset[ 0 ].x; // offset[1].x = texcoord.x - 0.25 * resolution.x;
    		d.x = coords.y;

    // Fetch the top crossing edges:
    		float e1 = texture2D( edgesTex, coords, 0.0 ).g;

    // Find the distance to the bottom:
    		coords.y = SMAASearchYDown( edgesTex, searchTex, offset[ 1 ].zw, offset[ 2 ].w );
    		d.y = coords.y;

    // We want the distances to be in pixel units:
    		d = d / resolution.y - pixcoord.y;

    // SMAAArea below needs a sqrt, as the areas texture is compressed
    // quadratically:
    		vec2 sqrt_d = sqrt( abs( d ) );

    // Fetch the bottom crossing edges:
    		coords.y -= 1.0 * resolution.y; // WebGL port note: Added
    		float e2 = SMAASampleLevelZeroOffset( edgesTex, coords, ivec2( 0, 1 ) ).g;

    // Get the area for this direction:
    		weights.ba = SMAAArea( areaTex, sqrt_d, e1, e2, float( subsampleIndices.x ) );
    	}

    	return weights;
    }

    void main() {

    	gl_FragColor = SMAABlendingWeightCalculationPS( vUv, vPixcoord, vOffset, tDiffuse, tArea, tSearch, ivec4( 0.0 ) );

    }
  `
  )
};
var SMAABlendShader = {
  uniforms: {
    tDiffuse: { value: null },
    tColor: { value: null },
    resolution: { value: new Vector2(1 / 1024, 1 / 512) }
  },
  vertexShader: (
    /* glsl */
    `
    uniform vec2 resolution;

    varying vec2 vUv;
    varying vec4 vOffset[ 2 ];

    void SMAANeighborhoodBlendingVS( vec2 texcoord ) {
    	vOffset[ 0 ] = texcoord.xyxy + resolution.xyxy * vec4( -1.0, 0.0, 0.0, 1.0 ); // WebGL port note: Changed sign in W component
    	vOffset[ 1 ] = texcoord.xyxy + resolution.xyxy * vec4( 1.0, 0.0, 0.0, -1.0 ); // WebGL port note: Changed sign in W component
    }

    void main() {

    	vUv = uv;

    	SMAANeighborhoodBlendingVS( vUv );

    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform sampler2D tDiffuse;
    uniform sampler2D tColor;
    uniform vec2 resolution;

    varying vec2 vUv;
    varying vec4 vOffset[ 2 ];

    vec4 SMAANeighborhoodBlendingPS( vec2 texcoord, vec4 offset[ 2 ], sampler2D colorTex, sampler2D blendTex ) {
    // Fetch the blending weights for current pixel:
    	vec4 a;
    	a.xz = texture2D( blendTex, texcoord ).xz;
    	a.y = texture2D( blendTex, offset[ 1 ].zw ).g;
    	a.w = texture2D( blendTex, offset[ 1 ].xy ).a;

    // Is there any blending weight with a value greater than 0.0?
    	if ( dot(a, vec4( 1.0, 1.0, 1.0, 1.0 )) < 1e-5 ) {
    		return texture2D( colorTex, texcoord, 0.0 );
    	} else {
    // Up to 4 lines can be crossing a pixel (one through each edge). We
    // favor blending by choosing the line with the maximum weight for each
    // direction:
    		vec2 offset;
    		offset.x = a.a > a.b ? a.a : -a.b; // left vs. right
    		offset.y = a.g > a.r ? -a.g : a.r; // top vs. bottom // WebGL port note: Changed signs

    // Then we go in the direction that has the maximum weight:
    		if ( abs( offset.x ) > abs( offset.y )) { // horizontal vs. vertical
    			offset.y = 0.0;
    		} else {
    			offset.x = 0.0;
    		}

    // Fetch the opposite color and lerp by hand:
    		vec4 C = texture2D( colorTex, texcoord, 0.0 );
    		texcoord += sign( offset ) * resolution;
    		vec4 Cop = texture2D( colorTex, texcoord, 0.0 );
    		float s = abs( offset.x ) > abs( offset.y ) ? abs( offset.x ) : abs( offset.y );

    // WebGL port note: Added gamma correction
    		C.xyz = pow(C.xyz, vec3(2.2));
    		Cop.xyz = pow(Cop.xyz, vec3(2.2));
    		vec4 mixed = mix(C, Cop, s);
    		mixed.xyz = pow(mixed.xyz, vec3(1.0 / 2.2));

    		return mixed;
    	}
    }

    void main() {

    	gl_FragColor = SMAANeighborhoodBlendingPS( vUv, vOffset, tColor, tDiffuse );

    }
  `
  )
};

// node_modules/three-stdlib/shaders/CopyShader.js
var CopyShader = {
  uniforms: {
    tDiffuse: { value: null },
    opacity: { value: 1 }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform float opacity;

    uniform sampler2D tDiffuse;

    varying vec2 vUv;

    void main() {

    	vec4 texel = texture2D( tDiffuse, vUv );
    	gl_FragColor = opacity * texel;

    }
  `
  )
};

// node_modules/three-stdlib/shaders/SSAOShader.js
var SSAOShader = {
  defines: {
    PERSPECTIVE_CAMERA: 1,
    KERNEL_SIZE: 32
  },
  uniforms: {
    tDiffuse: { value: null },
    tNormal: { value: null },
    tDepth: { value: null },
    tNoise: { value: null },
    kernel: { value: null },
    cameraNear: { value: null },
    cameraFar: { value: null },
    resolution: { value: new Vector2() },
    cameraProjectionMatrix: { value: new Matrix4() },
    cameraInverseProjectionMatrix: { value: new Matrix4() },
    kernelRadius: { value: 8 },
    minDistance: { value: 5e-3 },
    maxDistance: { value: 0.05 }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;

    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform sampler2D tDiffuse;
    uniform sampler2D tNormal;
    uniform sampler2D tDepth;
    uniform sampler2D tNoise;

    uniform vec3 kernel[ KERNEL_SIZE ];

    uniform vec2 resolution;

    uniform float cameraNear;
    uniform float cameraFar;
    uniform mat4 cameraProjectionMatrix;
    uniform mat4 cameraInverseProjectionMatrix;

    uniform float kernelRadius;
    uniform float minDistance; // avoid artifacts caused by neighbour fragments with minimal depth difference
    uniform float maxDistance; // avoid the influence of fragments which are too far away

    varying vec2 vUv;

    #include <packing>

    float getDepth( const in vec2 screenPosition ) {

    	return texture2D( tDepth, screenPosition ).x;

    }

    float getLinearDepth( const in vec2 screenPosition ) {

    	#if PERSPECTIVE_CAMERA == 1

    		float fragCoordZ = texture2D( tDepth, screenPosition ).x;
    		float viewZ = perspectiveDepthToViewZ( fragCoordZ, cameraNear, cameraFar );
    		return viewZToOrthographicDepth( viewZ, cameraNear, cameraFar );

    	#else

    		return texture2D( tDepth, screenPosition ).x;

    	#endif

    }

    float getViewZ( const in float depth ) {

    	#if PERSPECTIVE_CAMERA == 1

    		return perspectiveDepthToViewZ( depth, cameraNear, cameraFar );

    	#else

    		return orthographicDepthToViewZ( depth, cameraNear, cameraFar );

    	#endif

    }

    vec3 getViewPosition( const in vec2 screenPosition, const in float depth, const in float viewZ ) {

    	float clipW = cameraProjectionMatrix[2][3] * viewZ + cameraProjectionMatrix[3][3];

    	vec4 clipPosition = vec4( ( vec3( screenPosition, depth ) - 0.5 ) * 2.0, 1.0 );

    	clipPosition *= clipW; // unprojection.

    	return ( cameraInverseProjectionMatrix * clipPosition ).xyz;

    }

    vec3 getViewNormal( const in vec2 screenPosition ) {

    	return unpackRGBToNormal( texture2D( tNormal, screenPosition ).xyz );

    }

    void main() {

    	float depth = getDepth( vUv );
    	float viewZ = getViewZ( depth );

    	vec3 viewPosition = getViewPosition( vUv, depth, viewZ );
    	vec3 viewNormal = getViewNormal( vUv );

     vec2 noiseScale = vec2( resolution.x / 4.0, resolution.y / 4.0 );
    	vec3 random = texture2D( tNoise, vUv * noiseScale ).xyz;

    // compute matrix used to reorient a kernel vector

    	vec3 tangent = normalize( random - viewNormal * dot( random, viewNormal ) );
    	vec3 bitangent = cross( viewNormal, tangent );
    	mat3 kernelMatrix = mat3( tangent, bitangent, viewNormal );

     float occlusion = 0.0;

     for ( int i = 0; i < KERNEL_SIZE; i ++ ) {

    		vec3 sampleVector = kernelMatrix * kernel[ i ]; // reorient sample vector in view space
    		vec3 samplePoint = viewPosition + ( sampleVector * kernelRadius ); // calculate sample point

    		vec4 samplePointNDC = cameraProjectionMatrix * vec4( samplePoint, 1.0 ); // project point and calculate NDC
    		samplePointNDC /= samplePointNDC.w;

    		vec2 samplePointUv = samplePointNDC.xy * 0.5 + 0.5; // compute uv coordinates

    		float realDepth = getLinearDepth( samplePointUv ); // get linear depth from depth texture
    		float sampleDepth = viewZToOrthographicDepth( samplePoint.z, cameraNear, cameraFar ); // compute linear depth of the sample view Z value
    		float delta = sampleDepth - realDepth;

    		if ( delta > minDistance && delta < maxDistance ) { // if fragment is before sample point, increase occlusion

    			occlusion += 1.0;

    		}

    	}

    	occlusion = clamp( occlusion / float( KERNEL_SIZE ), 0.0, 1.0 );

    	gl_FragColor = vec4( vec3( 1.0 - occlusion ), 1.0 );

    }
  `
  )
};
var SSAODepthShader = {
  defines: {
    PERSPECTIVE_CAMERA: 1
  },
  uniforms: {
    tDepth: { value: null },
    cameraNear: { value: null },
    cameraFar: { value: null }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform sampler2D tDepth;

    uniform float cameraNear;
    uniform float cameraFar;

    varying vec2 vUv;

    #include <packing>

    float getLinearDepth( const in vec2 screenPosition ) {

    	#if PERSPECTIVE_CAMERA == 1

    		float fragCoordZ = texture2D( tDepth, screenPosition ).x;
    		float viewZ = perspectiveDepthToViewZ( fragCoordZ, cameraNear, cameraFar );
    		return viewZToOrthographicDepth( viewZ, cameraNear, cameraFar );

    	#else

    		return texture2D( tDepth, screenPosition ).x;

    	#endif

    }

    void main() {

    	float depth = getLinearDepth( vUv );
    	gl_FragColor = vec4( vec3( 1.0 - depth ), 1.0 );

    }
  `
  )
};
var SSAOBlurShader = {
  uniforms: {
    tDiffuse: { value: null },
    resolution: { value: new Vector2() }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform sampler2D tDiffuse;

    uniform vec2 resolution;

    varying vec2 vUv;

    void main() {

    	vec2 texelSize = ( 1.0 / resolution );
    	float result = 0.0;

    	for ( int i = - 2; i <= 2; i ++ ) {

    		for ( int j = - 2; j <= 2; j ++ ) {

    			vec2 offset = ( vec2( float( i ), float( j ) ) ) * texelSize;
    			result += texture2D( tDiffuse, vUv + offset ).r;

    		}

    	}

    	gl_FragColor = vec4( vec3( result / ( 5.0 * 5.0 ) ), 1.0 );

    }
  `
  )
};

// node_modules/three-stdlib/postprocessing/SSAOPass.js
var __defProp22 = Object.defineProperty;
var __defNormalProp22 = (obj, key, value) => key in obj ? __defProp22(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField23 = (obj, key, value) => {
  __defNormalProp22(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var SSAOPass = (() => {
  const _SSAOPass = class extends Pass {
    constructor(scene, camera, width, height) {
      super();
      this.width = width !== void 0 ? width : 512;
      this.height = height !== void 0 ? height : 512;
      this.clear = true;
      this.camera = camera;
      this.scene = scene;
      this.kernelRadius = 8;
      this.kernelSize = 32;
      this.kernel = [];
      this.noiseTexture = null;
      this.output = 0;
      this.minDistance = 5e-3;
      this.maxDistance = 0.1;
      this._visibilityCache = /* @__PURE__ */ new Map();
      this.generateSampleKernel();
      this.generateRandomKernelRotations();
      const depthTexture = new DepthTexture();
      depthTexture.format = DepthStencilFormat;
      depthTexture.type = UnsignedInt248Type;
      this.beautyRenderTarget = new WebGLRenderTarget(this.width, this.height);
      this.normalRenderTarget = new WebGLRenderTarget(this.width, this.height, {
        minFilter: NearestFilter,
        magFilter: NearestFilter,
        depthTexture
      });
      this.ssaoRenderTarget = new WebGLRenderTarget(this.width, this.height);
      this.blurRenderTarget = this.ssaoRenderTarget.clone();
      if (SSAOShader === void 0) {
        console.error("THREE.SSAOPass: The pass relies on SSAOShader.");
      }
      this.ssaoMaterial = new ShaderMaterial({
        defines: Object.assign({}, SSAOShader.defines),
        uniforms: UniformsUtils.clone(SSAOShader.uniforms),
        vertexShader: SSAOShader.vertexShader,
        fragmentShader: SSAOShader.fragmentShader,
        blending: NoBlending
      });
      this.ssaoMaterial.uniforms["tDiffuse"].value = this.beautyRenderTarget.texture;
      this.ssaoMaterial.uniforms["tNormal"].value = this.normalRenderTarget.texture;
      this.ssaoMaterial.uniforms["tDepth"].value = this.normalRenderTarget.depthTexture;
      this.ssaoMaterial.uniforms["tNoise"].value = this.noiseTexture;
      this.ssaoMaterial.uniforms["kernel"].value = this.kernel;
      this.ssaoMaterial.uniforms["cameraNear"].value = this.camera.near;
      this.ssaoMaterial.uniforms["cameraFar"].value = this.camera.far;
      this.ssaoMaterial.uniforms["resolution"].value.set(this.width, this.height);
      this.ssaoMaterial.uniforms["cameraProjectionMatrix"].value.copy(this.camera.projectionMatrix);
      this.ssaoMaterial.uniforms["cameraInverseProjectionMatrix"].value.copy(this.camera.projectionMatrixInverse);
      this.normalMaterial = new MeshNormalMaterial();
      this.normalMaterial.blending = NoBlending;
      this.blurMaterial = new ShaderMaterial({
        defines: Object.assign({}, SSAOBlurShader.defines),
        uniforms: UniformsUtils.clone(SSAOBlurShader.uniforms),
        vertexShader: SSAOBlurShader.vertexShader,
        fragmentShader: SSAOBlurShader.fragmentShader
      });
      this.blurMaterial.uniforms["tDiffuse"].value = this.ssaoRenderTarget.texture;
      this.blurMaterial.uniforms["resolution"].value.set(this.width, this.height);
      this.depthRenderMaterial = new ShaderMaterial({
        defines: Object.assign({}, SSAODepthShader.defines),
        uniforms: UniformsUtils.clone(SSAODepthShader.uniforms),
        vertexShader: SSAODepthShader.vertexShader,
        fragmentShader: SSAODepthShader.fragmentShader,
        blending: NoBlending
      });
      this.depthRenderMaterial.uniforms["tDepth"].value = this.normalRenderTarget.depthTexture;
      this.depthRenderMaterial.uniforms["cameraNear"].value = this.camera.near;
      this.depthRenderMaterial.uniforms["cameraFar"].value = this.camera.far;
      this.copyMaterial = new ShaderMaterial({
        uniforms: UniformsUtils.clone(CopyShader.uniforms),
        vertexShader: CopyShader.vertexShader,
        fragmentShader: CopyShader.fragmentShader,
        transparent: true,
        depthTest: false,
        depthWrite: false,
        blendSrc: DstColorFactor,
        blendDst: ZeroFactor,
        blendEquation: AddEquation,
        blendSrcAlpha: DstAlphaFactor,
        blendDstAlpha: ZeroFactor,
        blendEquationAlpha: AddEquation
      });
      this.fsQuad = new FullScreenQuad(null);
      this.originalClearColor = new Color();
    }
    dispose() {
      this.beautyRenderTarget.dispose();
      this.normalRenderTarget.dispose();
      this.ssaoRenderTarget.dispose();
      this.blurRenderTarget.dispose();
      this.normalMaterial.dispose();
      this.blurMaterial.dispose();
      this.copyMaterial.dispose();
      this.depthRenderMaterial.dispose();
      this.fsQuad.dispose();
    }
    render(renderer, writeBuffer) {
      renderer.setRenderTarget(this.beautyRenderTarget);
      renderer.clear();
      renderer.render(this.scene, this.camera);
      this.overrideVisibility();
      this.renderOverride(renderer, this.normalMaterial, this.normalRenderTarget, 7829503, 1);
      this.restoreVisibility();
      this.ssaoMaterial.uniforms["kernelRadius"].value = this.kernelRadius;
      this.ssaoMaterial.uniforms["minDistance"].value = this.minDistance;
      this.ssaoMaterial.uniforms["maxDistance"].value = this.maxDistance;
      this.renderPass(renderer, this.ssaoMaterial, this.ssaoRenderTarget);
      this.renderPass(renderer, this.blurMaterial, this.blurRenderTarget);
      switch (this.output) {
        case _SSAOPass.OUTPUT.SSAO:
          this.copyMaterial.uniforms["tDiffuse"].value = this.ssaoRenderTarget.texture;
          this.copyMaterial.blending = NoBlending;
          this.renderPass(renderer, this.copyMaterial, this.renderToScreen ? null : writeBuffer);
          break;
        case _SSAOPass.OUTPUT.Blur:
          this.copyMaterial.uniforms["tDiffuse"].value = this.blurRenderTarget.texture;
          this.copyMaterial.blending = NoBlending;
          this.renderPass(renderer, this.copyMaterial, this.renderToScreen ? null : writeBuffer);
          break;
        case _SSAOPass.OUTPUT.Beauty:
          this.copyMaterial.uniforms["tDiffuse"].value = this.beautyRenderTarget.texture;
          this.copyMaterial.blending = NoBlending;
          this.renderPass(renderer, this.copyMaterial, this.renderToScreen ? null : writeBuffer);
          break;
        case _SSAOPass.OUTPUT.Depth:
          this.renderPass(renderer, this.depthRenderMaterial, this.renderToScreen ? null : writeBuffer);
          break;
        case _SSAOPass.OUTPUT.Normal:
          this.copyMaterial.uniforms["tDiffuse"].value = this.normalRenderTarget.texture;
          this.copyMaterial.blending = NoBlending;
          this.renderPass(renderer, this.copyMaterial, this.renderToScreen ? null : writeBuffer);
          break;
        case _SSAOPass.OUTPUT.Default:
          this.copyMaterial.uniforms["tDiffuse"].value = this.beautyRenderTarget.texture;
          this.copyMaterial.blending = NoBlending;
          this.renderPass(renderer, this.copyMaterial, this.renderToScreen ? null : writeBuffer);
          this.copyMaterial.uniforms["tDiffuse"].value = this.blurRenderTarget.texture;
          this.copyMaterial.blending = CustomBlending;
          this.renderPass(renderer, this.copyMaterial, this.renderToScreen ? null : writeBuffer);
          break;
        default:
          console.warn("THREE.SSAOPass: Unknown output type.");
      }
    }
    renderPass(renderer, passMaterial, renderTarget, clearColor, clearAlpha) {
      renderer.getClearColor(this.originalClearColor);
      const originalClearAlpha = renderer.getClearAlpha();
      const originalAutoClear = renderer.autoClear;
      renderer.setRenderTarget(renderTarget);
      renderer.autoClear = false;
      if (clearColor !== void 0 && clearColor !== null) {
        renderer.setClearColor(clearColor);
        renderer.setClearAlpha(clearAlpha || 0);
        renderer.clear();
      }
      this.fsQuad.material = passMaterial;
      this.fsQuad.render(renderer);
      renderer.autoClear = originalAutoClear;
      renderer.setClearColor(this.originalClearColor);
      renderer.setClearAlpha(originalClearAlpha);
    }
    renderOverride(renderer, overrideMaterial, renderTarget, clearColor, clearAlpha) {
      renderer.getClearColor(this.originalClearColor);
      const originalClearAlpha = renderer.getClearAlpha();
      const originalAutoClear = renderer.autoClear;
      renderer.setRenderTarget(renderTarget);
      renderer.autoClear = false;
      clearColor = overrideMaterial.clearColor || clearColor;
      clearAlpha = overrideMaterial.clearAlpha || clearAlpha;
      if (clearColor !== void 0 && clearColor !== null) {
        renderer.setClearColor(clearColor);
        renderer.setClearAlpha(clearAlpha || 0);
        renderer.clear();
      }
      this.scene.overrideMaterial = overrideMaterial;
      renderer.render(this.scene, this.camera);
      this.scene.overrideMaterial = null;
      renderer.autoClear = originalAutoClear;
      renderer.setClearColor(this.originalClearColor);
      renderer.setClearAlpha(originalClearAlpha);
    }
    setSize(width, height) {
      this.width = width;
      this.height = height;
      this.beautyRenderTarget.setSize(width, height);
      this.ssaoRenderTarget.setSize(width, height);
      this.normalRenderTarget.setSize(width, height);
      this.blurRenderTarget.setSize(width, height);
      this.ssaoMaterial.uniforms["resolution"].value.set(width, height);
      this.ssaoMaterial.uniforms["cameraProjectionMatrix"].value.copy(this.camera.projectionMatrix);
      this.ssaoMaterial.uniforms["cameraInverseProjectionMatrix"].value.copy(this.camera.projectionMatrixInverse);
      this.blurMaterial.uniforms["resolution"].value.set(width, height);
    }
    generateSampleKernel() {
      const kernelSize = this.kernelSize;
      const kernel = this.kernel;
      for (let i4 = 0; i4 < kernelSize; i4++) {
        const sample = new Vector3();
        sample.x = Math.random() * 2 - 1;
        sample.y = Math.random() * 2 - 1;
        sample.z = Math.random();
        sample.normalize();
        let scale5 = i4 / kernelSize;
        scale5 = MathUtils.lerp(0.1, 1, scale5 * scale5);
        sample.multiplyScalar(scale5);
        kernel.push(sample);
      }
    }
    generateRandomKernelRotations() {
      const width = 4, height = 4;
      if (SimplexNoise === void 0) {
        console.error("THREE.SSAOPass: The pass relies on SimplexNoise.");
      }
      const simplex = new SimplexNoise();
      const size2 = width * height;
      const data = new Float32Array(size2);
      for (let i4 = 0; i4 < size2; i4++) {
        const x = Math.random() * 2 - 1;
        const y = Math.random() * 2 - 1;
        const z = 0;
        data[i4] = simplex.noise3d(x, y, z);
      }
      this.noiseTexture = new DataTexture(data, width, height, RedFormat, FloatType);
      this.noiseTexture.wrapS = RepeatWrapping;
      this.noiseTexture.wrapT = RepeatWrapping;
      this.noiseTexture.needsUpdate = true;
    }
    overrideVisibility() {
      const scene = this.scene;
      const cache = this._visibilityCache;
      scene.traverse(function(object) {
        cache.set(object, object.visible);
        if (object.isPoints || object.isLine)
          object.visible = false;
      });
    }
    restoreVisibility() {
      const scene = this.scene;
      const cache = this._visibilityCache;
      scene.traverse(function(object) {
        const visible = cache.get(object);
        object.visible = visible;
      });
      cache.clear();
    }
  };
  let SSAOPass2 = _SSAOPass;
  __publicField23(SSAOPass2, "OUTPUT", {
    Default: 0,
    SSAO: 1,
    Blur: 2,
    Beauty: 3,
    Depth: 4,
    Normal: 5
  });
  return SSAOPass2;
})();

// node_modules/three-stdlib/shaders/LuminosityHighPassShader.js
var LuminosityHighPassShader = {
  shaderID: "luminosityHighPass",
  uniforms: {
    tDiffuse: { value: null },
    luminosityThreshold: { value: 1 },
    smoothWidth: { value: 1 },
    defaultColor: { value: new Color(0) },
    defaultOpacity: { value: 0 }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;

    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform sampler2D tDiffuse;
    uniform vec3 defaultColor;
    uniform float defaultOpacity;
    uniform float luminosityThreshold;
    uniform float smoothWidth;

    varying vec2 vUv;

    void main() {

    	vec4 texel = texture2D( tDiffuse, vUv );

    	vec3 luma = vec3( 0.299, 0.587, 0.114 );

    	float v = dot( texel.xyz, luma );

    	vec4 outputColor = vec4( defaultColor.rgb, defaultOpacity );

    	float alpha = smoothstep( luminosityThreshold, luminosityThreshold + smoothWidth, v );

    	gl_FragColor = mix( outputColor, texel, alpha );

    }
  `
  )
};

// node_modules/three-stdlib/postprocessing/UnrealBloomPass.js
var __defProp23 = Object.defineProperty;
var __defNormalProp23 = (obj, key, value) => key in obj ? __defProp23(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField24 = (obj, key, value) => {
  __defNormalProp23(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var UnrealBloomPass = (() => {
  const _UnrealBloomPass = class extends Pass {
    constructor(resolution, strength, radius, threshold) {
      super();
      this.strength = strength !== void 0 ? strength : 1;
      this.radius = radius;
      this.threshold = threshold;
      this.resolution = resolution !== void 0 ? new Vector2(resolution.x, resolution.y) : new Vector2(256, 256);
      this.clearColor = new Color(0, 0, 0);
      this.renderTargetsHorizontal = [];
      this.renderTargetsVertical = [];
      this.nMips = 5;
      let resx = Math.round(this.resolution.x / 2);
      let resy = Math.round(this.resolution.y / 2);
      this.renderTargetBright = new WebGLRenderTarget(resx, resy, { type: HalfFloatType });
      this.renderTargetBright.texture.name = "UnrealBloomPass.bright";
      this.renderTargetBright.texture.generateMipmaps = false;
      for (let i4 = 0; i4 < this.nMips; i4++) {
        const renderTargetHorizonal = new WebGLRenderTarget(resx, resy, { type: HalfFloatType });
        renderTargetHorizonal.texture.name = "UnrealBloomPass.h" + i4;
        renderTargetHorizonal.texture.generateMipmaps = false;
        this.renderTargetsHorizontal.push(renderTargetHorizonal);
        const renderTargetVertical = new WebGLRenderTarget(resx, resy, { type: HalfFloatType });
        renderTargetVertical.texture.name = "UnrealBloomPass.v" + i4;
        renderTargetVertical.texture.generateMipmaps = false;
        this.renderTargetsVertical.push(renderTargetVertical);
        resx = Math.round(resx / 2);
        resy = Math.round(resy / 2);
      }
      const highPassShader = LuminosityHighPassShader;
      this.highPassUniforms = UniformsUtils.clone(highPassShader.uniforms);
      this.highPassUniforms["luminosityThreshold"].value = threshold;
      this.highPassUniforms["smoothWidth"].value = 0.01;
      this.materialHighPassFilter = new ShaderMaterial({
        uniforms: this.highPassUniforms,
        vertexShader: highPassShader.vertexShader,
        fragmentShader: highPassShader.fragmentShader,
        defines: {}
      });
      this.separableBlurMaterials = [];
      const kernelSizeArray = [3, 5, 7, 9, 11];
      resx = Math.round(this.resolution.x / 2);
      resy = Math.round(this.resolution.y / 2);
      for (let i4 = 0; i4 < this.nMips; i4++) {
        this.separableBlurMaterials.push(this.getSeperableBlurMaterial(kernelSizeArray[i4]));
        this.separableBlurMaterials[i4].uniforms["texSize"].value = new Vector2(resx, resy);
        resx = Math.round(resx / 2);
        resy = Math.round(resy / 2);
      }
      this.compositeMaterial = this.getCompositeMaterial(this.nMips);
      this.compositeMaterial.uniforms["blurTexture1"].value = this.renderTargetsVertical[0].texture;
      this.compositeMaterial.uniforms["blurTexture2"].value = this.renderTargetsVertical[1].texture;
      this.compositeMaterial.uniforms["blurTexture3"].value = this.renderTargetsVertical[2].texture;
      this.compositeMaterial.uniforms["blurTexture4"].value = this.renderTargetsVertical[3].texture;
      this.compositeMaterial.uniforms["blurTexture5"].value = this.renderTargetsVertical[4].texture;
      this.compositeMaterial.uniforms["bloomStrength"].value = strength;
      this.compositeMaterial.uniforms["bloomRadius"].value = 0.1;
      this.compositeMaterial.needsUpdate = true;
      const bloomFactors = [1, 0.8, 0.6, 0.4, 0.2];
      this.compositeMaterial.uniforms["bloomFactors"].value = bloomFactors;
      this.bloomTintColors = [
        new Vector3(1, 1, 1),
        new Vector3(1, 1, 1),
        new Vector3(1, 1, 1),
        new Vector3(1, 1, 1),
        new Vector3(1, 1, 1)
      ];
      this.compositeMaterial.uniforms["bloomTintColors"].value = this.bloomTintColors;
      const copyShader = CopyShader;
      this.copyUniforms = UniformsUtils.clone(copyShader.uniforms);
      this.copyUniforms["opacity"].value = 1;
      this.materialCopy = new ShaderMaterial({
        uniforms: this.copyUniforms,
        vertexShader: copyShader.vertexShader,
        fragmentShader: copyShader.fragmentShader,
        blending: AdditiveBlending,
        depthTest: false,
        depthWrite: false,
        transparent: true
      });
      this.enabled = true;
      this.needsSwap = false;
      this._oldClearColor = new Color();
      this.oldClearAlpha = 1;
      this.basic = new MeshBasicMaterial();
      this.fsQuad = new FullScreenQuad(null);
    }
    dispose() {
      for (let i4 = 0; i4 < this.renderTargetsHorizontal.length; i4++) {
        this.renderTargetsHorizontal[i4].dispose();
      }
      for (let i4 = 0; i4 < this.renderTargetsVertical.length; i4++) {
        this.renderTargetsVertical[i4].dispose();
      }
      this.renderTargetBright.dispose();
      for (let i4 = 0; i4 < this.separableBlurMaterials.length; i4++) {
        this.separableBlurMaterials[i4].dispose();
      }
      this.compositeMaterial.dispose();
      this.materialCopy.dispose();
      this.basic.dispose();
      this.fsQuad.dispose();
    }
    setSize(width, height) {
      let resx = Math.round(width / 2);
      let resy = Math.round(height / 2);
      this.renderTargetBright.setSize(resx, resy);
      for (let i4 = 0; i4 < this.nMips; i4++) {
        this.renderTargetsHorizontal[i4].setSize(resx, resy);
        this.renderTargetsVertical[i4].setSize(resx, resy);
        this.separableBlurMaterials[i4].uniforms["texSize"].value = new Vector2(resx, resy);
        resx = Math.round(resx / 2);
        resy = Math.round(resy / 2);
      }
    }
    render(renderer, writeBuffer, readBuffer, deltaTime, maskActive) {
      renderer.getClearColor(this._oldClearColor);
      this.oldClearAlpha = renderer.getClearAlpha();
      const oldAutoClear = renderer.autoClear;
      renderer.autoClear = false;
      renderer.setClearColor(this.clearColor, 0);
      if (maskActive)
        renderer.state.buffers.stencil.setTest(false);
      if (this.renderToScreen) {
        this.fsQuad.material = this.basic;
        this.basic.map = readBuffer.texture;
        renderer.setRenderTarget(null);
        renderer.clear();
        this.fsQuad.render(renderer);
      }
      this.highPassUniforms["tDiffuse"].value = readBuffer.texture;
      this.highPassUniforms["luminosityThreshold"].value = this.threshold;
      this.fsQuad.material = this.materialHighPassFilter;
      renderer.setRenderTarget(this.renderTargetBright);
      renderer.clear();
      this.fsQuad.render(renderer);
      let inputRenderTarget = this.renderTargetBright;
      for (let i4 = 0; i4 < this.nMips; i4++) {
        this.fsQuad.material = this.separableBlurMaterials[i4];
        this.separableBlurMaterials[i4].uniforms["colorTexture"].value = inputRenderTarget.texture;
        this.separableBlurMaterials[i4].uniforms["direction"].value = _UnrealBloomPass.BlurDirectionX;
        renderer.setRenderTarget(this.renderTargetsHorizontal[i4]);
        renderer.clear();
        this.fsQuad.render(renderer);
        this.separableBlurMaterials[i4].uniforms["colorTexture"].value = this.renderTargetsHorizontal[i4].texture;
        this.separableBlurMaterials[i4].uniforms["direction"].value = _UnrealBloomPass.BlurDirectionY;
        renderer.setRenderTarget(this.renderTargetsVertical[i4]);
        renderer.clear();
        this.fsQuad.render(renderer);
        inputRenderTarget = this.renderTargetsVertical[i4];
      }
      this.fsQuad.material = this.compositeMaterial;
      this.compositeMaterial.uniforms["bloomStrength"].value = this.strength;
      this.compositeMaterial.uniforms["bloomRadius"].value = this.radius;
      this.compositeMaterial.uniforms["bloomTintColors"].value = this.bloomTintColors;
      renderer.setRenderTarget(this.renderTargetsHorizontal[0]);
      renderer.clear();
      this.fsQuad.render(renderer);
      this.fsQuad.material = this.materialCopy;
      this.copyUniforms["tDiffuse"].value = this.renderTargetsHorizontal[0].texture;
      if (maskActive)
        renderer.state.buffers.stencil.setTest(true);
      if (this.renderToScreen) {
        renderer.setRenderTarget(null);
        this.fsQuad.render(renderer);
      } else {
        renderer.setRenderTarget(readBuffer);
        this.fsQuad.render(renderer);
      }
      renderer.setClearColor(this._oldClearColor, this.oldClearAlpha);
      renderer.autoClear = oldAutoClear;
    }
    getSeperableBlurMaterial(kernelRadius) {
      return new ShaderMaterial({
        defines: {
          KERNEL_RADIUS: kernelRadius,
          SIGMA: kernelRadius
        },
        uniforms: {
          colorTexture: { value: null },
          texSize: { value: new Vector2(0.5, 0.5) },
          direction: { value: new Vector2(0.5, 0.5) }
        },
        vertexShader: `varying vec2 vUv;
				void main() {
					vUv = uv;
					gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );
				}`,
        fragmentShader: `#include <common>
				varying vec2 vUv;
				uniform sampler2D colorTexture;
				uniform vec2 texSize;
				uniform vec2 direction;

				float gaussianPdf(in float x, in float sigma) {
					return 0.39894 * exp( -0.5 * x * x/( sigma * sigma))/sigma;
				}
				void main() {
					vec2 invSize = 1.0 / texSize;
					float fSigma = float(SIGMA);
					float weightSum = gaussianPdf(0.0, fSigma);
					vec3 diffuseSum = texture2D( colorTexture, vUv).rgb * weightSum;
					for( int i = 1; i < KERNEL_RADIUS; i ++ ) {
						float x = float(i);
						float w = gaussianPdf(x, fSigma);
						vec2 uvOffset = direction * invSize * x;
						vec3 sample1 = texture2D( colorTexture, vUv + uvOffset).rgb;
						vec3 sample2 = texture2D( colorTexture, vUv - uvOffset).rgb;
						diffuseSum += (sample1 + sample2) * w;
						weightSum += 2.0 * w;
					}
					gl_FragColor = vec4(diffuseSum/weightSum, 1.0);
				}`
      });
    }
    getCompositeMaterial(nMips) {
      return new ShaderMaterial({
        defines: {
          NUM_MIPS: nMips
        },
        uniforms: {
          blurTexture1: { value: null },
          blurTexture2: { value: null },
          blurTexture3: { value: null },
          blurTexture4: { value: null },
          blurTexture5: { value: null },
          bloomStrength: { value: 1 },
          bloomFactors: { value: null },
          bloomTintColors: { value: null },
          bloomRadius: { value: 0 }
        },
        vertexShader: `varying vec2 vUv;
				void main() {
					vUv = uv;
					gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );
				}`,
        fragmentShader: `varying vec2 vUv;
				uniform sampler2D blurTexture1;
				uniform sampler2D blurTexture2;
				uniform sampler2D blurTexture3;
				uniform sampler2D blurTexture4;
				uniform sampler2D blurTexture5;
				uniform float bloomStrength;
				uniform float bloomRadius;
				uniform float bloomFactors[NUM_MIPS];
				uniform vec3 bloomTintColors[NUM_MIPS];

				float lerpBloomFactor(const in float factor) {
					float mirrorFactor = 1.2 - factor;
					return mix(factor, mirrorFactor, bloomRadius);
				}

				void main() {
					gl_FragColor = bloomStrength * ( lerpBloomFactor(bloomFactors[0]) * vec4(bloomTintColors[0], 1.0) * texture2D(blurTexture1, vUv) +
						lerpBloomFactor(bloomFactors[1]) * vec4(bloomTintColors[1], 1.0) * texture2D(blurTexture2, vUv) +
						lerpBloomFactor(bloomFactors[2]) * vec4(bloomTintColors[2], 1.0) * texture2D(blurTexture3, vUv) +
						lerpBloomFactor(bloomFactors[3]) * vec4(bloomTintColors[3], 1.0) * texture2D(blurTexture4, vUv) +
						lerpBloomFactor(bloomFactors[4]) * vec4(bloomTintColors[4], 1.0) * texture2D(blurTexture5, vUv) );
				}`
      });
    }
  };
  let UnrealBloomPass2 = _UnrealBloomPass;
  __publicField24(UnrealBloomPass2, "BlurDirectionX", new Vector2(1, 0));
  __publicField24(UnrealBloomPass2, "BlurDirectionY", new Vector2(0, 1));
  return UnrealBloomPass2;
})();

// node_modules/three-stdlib/shaders/SAOShader.js
var SAOShader = {
  defines: {
    NUM_SAMPLES: 7,
    NUM_RINGS: 4,
    NORMAL_TEXTURE: 0,
    DIFFUSE_TEXTURE: 0,
    DEPTH_PACKING: 1,
    PERSPECTIVE_CAMERA: 1
  },
  uniforms: {
    tDepth: { value: null },
    tDiffuse: { value: null },
    tNormal: { value: null },
    size: { value: new Vector2(512, 512) },
    cameraNear: { value: 1 },
    cameraFar: { value: 100 },
    cameraProjectionMatrix: { value: new Matrix4() },
    cameraInverseProjectionMatrix: { value: new Matrix4() },
    scale: { value: 1 },
    intensity: { value: 0.1 },
    bias: { value: 0.5 },
    minResolution: { value: 0 },
    kernelRadius: { value: 100 },
    randomSeed: { value: 0 }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {
    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );
    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    #include <common>

    varying vec2 vUv;

    #if DIFFUSE_TEXTURE == 1
    uniform sampler2D tDiffuse;
    #endif

    uniform sampler2D tDepth;

    #if NORMAL_TEXTURE == 1
    uniform sampler2D tNormal;
    #endif

    uniform float cameraNear;
    uniform float cameraFar;
    uniform mat4 cameraProjectionMatrix;
    uniform mat4 cameraInverseProjectionMatrix;

    uniform float scale;
    uniform float intensity;
    uniform float bias;
    uniform float kernelRadius;
    uniform float minResolution;
    uniform vec2 size;
    uniform float randomSeed;

    // RGBA depth

    #include <packing>

    vec4 getDefaultColor( const in vec2 screenPosition ) {
    	#if DIFFUSE_TEXTURE == 1
    	return texture2D( tDiffuse, vUv );
    	#else
    	return vec4( 1.0 );
    	#endif
    }

    float getDepth( const in vec2 screenPosition ) {
    	#if DEPTH_PACKING == 1
    	return unpackRGBAToDepth( texture2D( tDepth, screenPosition ) );
    	#else
    	return texture2D( tDepth, screenPosition ).x;
    	#endif
    }

    float getViewZ( const in float depth ) {
    	#if PERSPECTIVE_CAMERA == 1
    	return perspectiveDepthToViewZ( depth, cameraNear, cameraFar );
    	#else
    	return orthographicDepthToViewZ( depth, cameraNear, cameraFar );
    	#endif
    }

    vec3 getViewPosition( const in vec2 screenPosition, const in float depth, const in float viewZ ) {
    	float clipW = cameraProjectionMatrix[2][3] * viewZ + cameraProjectionMatrix[3][3];
    	vec4 clipPosition = vec4( ( vec3( screenPosition, depth ) - 0.5 ) * 2.0, 1.0 );
    	clipPosition *= clipW; // unprojection.

    	return ( cameraInverseProjectionMatrix * clipPosition ).xyz;
    }

    vec3 getViewNormal( const in vec3 viewPosition, const in vec2 screenPosition ) {
    	#if NORMAL_TEXTURE == 1
    	return unpackRGBToNormal( texture2D( tNormal, screenPosition ).xyz );
    	#else
    	return normalize( cross( dFdx( viewPosition ), dFdy( viewPosition ) ) );
    	#endif
    }

    float scaleDividedByCameraFar;
    float minResolutionMultipliedByCameraFar;

    float getOcclusion( const in vec3 centerViewPosition, const in vec3 centerViewNormal, const in vec3 sampleViewPosition ) {
    	vec3 viewDelta = sampleViewPosition - centerViewPosition;
    	float viewDistance = length( viewDelta );
    	float scaledScreenDistance = scaleDividedByCameraFar * viewDistance;

    	return max(0.0, (dot(centerViewNormal, viewDelta) - minResolutionMultipliedByCameraFar) / scaledScreenDistance - bias) / (1.0 + pow2( scaledScreenDistance ) );
    }

    // moving costly divides into consts
    const float ANGLE_STEP = PI2 * float( NUM_RINGS ) / float( NUM_SAMPLES );
    const float INV_NUM_SAMPLES = 1.0 / float( NUM_SAMPLES );

    float getAmbientOcclusion( const in vec3 centerViewPosition ) {
    	// precompute some variables require in getOcclusion.
    	scaleDividedByCameraFar = scale / cameraFar;
    	minResolutionMultipliedByCameraFar = minResolution * cameraFar;
    	vec3 centerViewNormal = getViewNormal( centerViewPosition, vUv );

    	// jsfiddle that shows sample pattern: https://jsfiddle.net/a16ff1p7/
    	float angle = rand( vUv + randomSeed ) * PI2;
    	vec2 radius = vec2( kernelRadius * INV_NUM_SAMPLES ) / size;
    	vec2 radiusStep = radius;

    	float occlusionSum = 0.0;
    	float weightSum = 0.0;

    	for( int i = 0; i < NUM_SAMPLES; i ++ ) {
    		vec2 sampleUv = vUv + vec2( cos( angle ), sin( angle ) ) * radius;
    		radius += radiusStep;
    		angle += ANGLE_STEP;

    		float sampleDepth = getDepth( sampleUv );
    		if( sampleDepth >= ( 1.0 - EPSILON ) ) {
    			continue;
    		}

    		float sampleViewZ = getViewZ( sampleDepth );
    		vec3 sampleViewPosition = getViewPosition( sampleUv, sampleDepth, sampleViewZ );
    		occlusionSum += getOcclusion( centerViewPosition, centerViewNormal, sampleViewPosition );
    		weightSum += 1.0;
    	}

    	if( weightSum == 0.0 ) discard;

    	return occlusionSum * ( intensity / weightSum );
    }

    void main() {
    	float centerDepth = getDepth( vUv );
    	if( centerDepth >= ( 1.0 - EPSILON ) ) {
    		discard;
    	}

    	float centerViewZ = getViewZ( centerDepth );
    	vec3 viewPosition = getViewPosition( vUv, centerDepth, centerViewZ );

    	float ambientOcclusion = getAmbientOcclusion( viewPosition );

    	gl_FragColor = getDefaultColor( vUv );
    	gl_FragColor.xyz *=  1.0 - ambientOcclusion;
    }
  `
  )
};

// node_modules/three-stdlib/shaders/DepthLimitedBlurShader.js
var DepthLimitedBlurShader = {
  defines: {
    KERNEL_RADIUS: 4,
    DEPTH_PACKING: 1,
    PERSPECTIVE_CAMERA: 1
  },
  uniforms: {
    tDiffuse: { value: null },
    size: { value: new Vector2(512, 512) },
    sampleUvOffsets: { value: [new Vector2(0, 0)] },
    sampleWeights: { value: [1] },
    tDepth: { value: null },
    cameraNear: { value: 10 },
    cameraFar: { value: 1e3 },
    depthCutoff: { value: 10 }
  },
  vertexShader: (
    /* glsl */
    `
    #include <common>

    uniform vec2 size;

    varying vec2 vUv;
    varying vec2 vInvSize;

    void main() {
    	vUv = uv;
    	vInvSize = 1.0 / size;

    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );
    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    #include <common>
    #include <packing>

    uniform sampler2D tDiffuse;
    uniform sampler2D tDepth;

    uniform float cameraNear;
    uniform float cameraFar;
    uniform float depthCutoff;

    uniform vec2 sampleUvOffsets[ KERNEL_RADIUS + 1 ];
    uniform float sampleWeights[ KERNEL_RADIUS + 1 ];

    varying vec2 vUv;
    varying vec2 vInvSize;

    float getDepth( const in vec2 screenPosition ) {
    	#if DEPTH_PACKING == 1
    	return unpackRGBAToDepth( texture2D( tDepth, screenPosition ) );
    	#else
    	return texture2D( tDepth, screenPosition ).x;
    	#endif
    }

    float getViewZ( const in float depth ) {
    	#if PERSPECTIVE_CAMERA == 1
    	return perspectiveDepthToViewZ( depth, cameraNear, cameraFar );
    	#else
    	return orthographicDepthToViewZ( depth, cameraNear, cameraFar );
    	#endif
    }

    void main() {
    	float depth = getDepth( vUv );
    	if( depth >= ( 1.0 - EPSILON ) ) {
    		discard;
    	}

    	float centerViewZ = -getViewZ( depth );
    	bool rBreak = false, lBreak = false;

    	float weightSum = sampleWeights[0];
    	vec4 diffuseSum = texture2D( tDiffuse, vUv ) * weightSum;

    	for( int i = 1; i <= KERNEL_RADIUS; i ++ ) {

    		float sampleWeight = sampleWeights[i];
    		vec2 sampleUvOffset = sampleUvOffsets[i] * vInvSize;

    		vec2 sampleUv = vUv + sampleUvOffset;
    		float viewZ = -getViewZ( getDepth( sampleUv ) );

    		if( abs( viewZ - centerViewZ ) > depthCutoff ) rBreak = true;

    		if( ! rBreak ) {
    			diffuseSum += texture2D( tDiffuse, sampleUv ) * sampleWeight;
    			weightSum += sampleWeight;
    		}

    		sampleUv = vUv - sampleUvOffset;
    		viewZ = -getViewZ( getDepth( sampleUv ) );

    		if( abs( viewZ - centerViewZ ) > depthCutoff ) lBreak = true;

    		if( ! lBreak ) {
    			diffuseSum += texture2D( tDiffuse, sampleUv ) * sampleWeight;
    			weightSum += sampleWeight;
    		}

    	}

    	gl_FragColor = diffuseSum / weightSum;
    }
  `
  )
};
var BlurShaderUtils = {
  createSampleWeights: (kernelRadius, stdDev) => {
    const gaussian = (x, stdDev2) => {
      return Math.exp(-(x * x) / (2 * (stdDev2 * stdDev2))) / (Math.sqrt(2 * Math.PI) * stdDev2);
    };
    const weights = [];
    for (let i4 = 0; i4 <= kernelRadius; i4++) {
      weights.push(gaussian(i4, stdDev));
    }
    return weights;
  },
  createSampleOffsets: (kernelRadius, uvIncrement) => {
    const offsets = [];
    for (let i4 = 0; i4 <= kernelRadius; i4++) {
      offsets.push(uvIncrement.clone().multiplyScalar(i4));
    }
    return offsets;
  },
  configure: (shader, kernelRadius, stdDev, uvIncrement) => {
    shader.defines["KERNEL_RADIUS"] = kernelRadius;
    shader.uniforms["sampleUvOffsets"].value = BlurShaderUtils.createSampleOffsets(kernelRadius, uvIncrement);
    shader.uniforms["sampleWeights"].value = BlurShaderUtils.createSampleWeights(kernelRadius, stdDev);
    shader.needsUpdate = true;
  }
};

// node_modules/three-stdlib/postprocessing/SAOPass.js
var __defProp24 = Object.defineProperty;
var __defNormalProp24 = (obj, key, value) => key in obj ? __defProp24(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField25 = (obj, key, value) => {
  __defNormalProp24(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var SAOPass = (() => {
  class SAOPass2 extends Pass {
    constructor(scene, camera, useDepthTexture = false, useNormals = false, resolution = new Vector2(256, 256)) {
      super();
      this.scene = scene;
      this.camera = camera;
      this.clear = true;
      this.needsSwap = false;
      this.supportsDepthTextureExtension = useDepthTexture;
      this.supportsNormalTexture = useNormals;
      this.originalClearColor = new Color();
      this._oldClearColor = new Color();
      this.oldClearAlpha = 1;
      this.params = {
        output: 0,
        saoBias: 0.5,
        saoIntensity: 0.18,
        saoScale: 1,
        saoKernelRadius: 100,
        saoMinResolution: 0,
        saoBlur: true,
        saoBlurRadius: 8,
        saoBlurStdDev: 4,
        saoBlurDepthCutoff: 0.01
      };
      this.resolution = new Vector2(resolution.x, resolution.y);
      this.saoRenderTarget = new WebGLRenderTarget(this.resolution.x, this.resolution.y, { type: HalfFloatType });
      this.blurIntermediateRenderTarget = this.saoRenderTarget.clone();
      this.beautyRenderTarget = this.saoRenderTarget.clone();
      this.normalRenderTarget = new WebGLRenderTarget(this.resolution.x, this.resolution.y, {
        minFilter: NearestFilter,
        magFilter: NearestFilter,
        type: HalfFloatType
      });
      this.depthRenderTarget = this.normalRenderTarget.clone();
      let depthTexture;
      if (this.supportsDepthTextureExtension) {
        depthTexture = new DepthTexture();
        depthTexture.type = UnsignedShortType;
        this.beautyRenderTarget.depthTexture = depthTexture;
        this.beautyRenderTarget.depthBuffer = true;
      }
      this.depthMaterial = new MeshDepthMaterial();
      this.depthMaterial.depthPacking = RGBADepthPacking;
      this.depthMaterial.blending = NoBlending;
      this.normalMaterial = new MeshNormalMaterial();
      this.normalMaterial.blending = NoBlending;
      this.saoMaterial = new ShaderMaterial({
        defines: Object.assign({}, SAOShader.defines),
        fragmentShader: SAOShader.fragmentShader,
        vertexShader: SAOShader.vertexShader,
        uniforms: UniformsUtils.clone(SAOShader.uniforms)
      });
      this.saoMaterial.extensions.derivatives = true;
      this.saoMaterial.defines["DEPTH_PACKING"] = this.supportsDepthTextureExtension ? 0 : 1;
      this.saoMaterial.defines["NORMAL_TEXTURE"] = this.supportsNormalTexture ? 1 : 0;
      this.saoMaterial.defines["PERSPECTIVE_CAMERA"] = this.camera.isPerspectiveCamera ? 1 : 0;
      this.saoMaterial.uniforms["tDepth"].value = this.supportsDepthTextureExtension ? depthTexture : this.depthRenderTarget.texture;
      this.saoMaterial.uniforms["tNormal"].value = this.normalRenderTarget.texture;
      this.saoMaterial.uniforms["size"].value.set(this.resolution.x, this.resolution.y);
      this.saoMaterial.uniforms["cameraInverseProjectionMatrix"].value.copy(this.camera.projectionMatrixInverse);
      this.saoMaterial.uniforms["cameraProjectionMatrix"].value = this.camera.projectionMatrix;
      this.saoMaterial.blending = NoBlending;
      this.vBlurMaterial = new ShaderMaterial({
        uniforms: UniformsUtils.clone(DepthLimitedBlurShader.uniforms),
        defines: Object.assign({}, DepthLimitedBlurShader.defines),
        vertexShader: DepthLimitedBlurShader.vertexShader,
        fragmentShader: DepthLimitedBlurShader.fragmentShader
      });
      this.vBlurMaterial.defines["DEPTH_PACKING"] = this.supportsDepthTextureExtension ? 0 : 1;
      this.vBlurMaterial.defines["PERSPECTIVE_CAMERA"] = this.camera.isPerspectiveCamera ? 1 : 0;
      this.vBlurMaterial.uniforms["tDiffuse"].value = this.saoRenderTarget.texture;
      this.vBlurMaterial.uniforms["tDepth"].value = this.supportsDepthTextureExtension ? depthTexture : this.depthRenderTarget.texture;
      this.vBlurMaterial.uniforms["size"].value.set(this.resolution.x, this.resolution.y);
      this.vBlurMaterial.blending = NoBlending;
      this.hBlurMaterial = new ShaderMaterial({
        uniforms: UniformsUtils.clone(DepthLimitedBlurShader.uniforms),
        defines: Object.assign({}, DepthLimitedBlurShader.defines),
        vertexShader: DepthLimitedBlurShader.vertexShader,
        fragmentShader: DepthLimitedBlurShader.fragmentShader
      });
      this.hBlurMaterial.defines["DEPTH_PACKING"] = this.supportsDepthTextureExtension ? 0 : 1;
      this.hBlurMaterial.defines["PERSPECTIVE_CAMERA"] = this.camera.isPerspectiveCamera ? 1 : 0;
      this.hBlurMaterial.uniforms["tDiffuse"].value = this.blurIntermediateRenderTarget.texture;
      this.hBlurMaterial.uniforms["tDepth"].value = this.supportsDepthTextureExtension ? depthTexture : this.depthRenderTarget.texture;
      this.hBlurMaterial.uniforms["size"].value.set(this.resolution.x, this.resolution.y);
      this.hBlurMaterial.blending = NoBlending;
      this.materialCopy = new ShaderMaterial({
        uniforms: UniformsUtils.clone(CopyShader.uniforms),
        vertexShader: CopyShader.vertexShader,
        fragmentShader: CopyShader.fragmentShader,
        blending: NoBlending
      });
      this.materialCopy.transparent = true;
      this.materialCopy.depthTest = false;
      this.materialCopy.depthWrite = false;
      this.materialCopy.blending = CustomBlending;
      this.materialCopy.blendSrc = DstColorFactor;
      this.materialCopy.blendDst = ZeroFactor;
      this.materialCopy.blendEquation = AddEquation;
      this.materialCopy.blendSrcAlpha = DstAlphaFactor;
      this.materialCopy.blendDstAlpha = ZeroFactor;
      this.materialCopy.blendEquationAlpha = AddEquation;
      this.depthCopy = new ShaderMaterial({
        uniforms: UniformsUtils.clone(UnpackDepthRGBAShader.uniforms),
        vertexShader: UnpackDepthRGBAShader.vertexShader,
        fragmentShader: UnpackDepthRGBAShader.fragmentShader,
        blending: NoBlending
      });
      this.fsQuad = new FullScreenQuad(null);
    }
    render(renderer, writeBuffer, readBuffer) {
      if (this.renderToScreen) {
        this.materialCopy.blending = NoBlending;
        this.materialCopy.uniforms["tDiffuse"].value = readBuffer.texture;
        this.materialCopy.needsUpdate = true;
        this.renderPass(renderer, this.materialCopy, null);
      }
      if (this.params.output === 1) {
        return;
      }
      renderer.getClearColor(this._oldClearColor);
      this.oldClearAlpha = renderer.getClearAlpha();
      const oldAutoClear = renderer.autoClear;
      renderer.autoClear = false;
      renderer.setRenderTarget(this.depthRenderTarget);
      renderer.clear();
      this.saoMaterial.uniforms["bias"].value = this.params.saoBias;
      this.saoMaterial.uniforms["intensity"].value = this.params.saoIntensity;
      this.saoMaterial.uniforms["scale"].value = this.params.saoScale;
      this.saoMaterial.uniforms["kernelRadius"].value = this.params.saoKernelRadius;
      this.saoMaterial.uniforms["minResolution"].value = this.params.saoMinResolution;
      this.saoMaterial.uniforms["cameraNear"].value = this.camera.near;
      this.saoMaterial.uniforms["cameraFar"].value = this.camera.far;
      const depthCutoff = this.params.saoBlurDepthCutoff * (this.camera.far - this.camera.near);
      this.vBlurMaterial.uniforms["depthCutoff"].value = depthCutoff;
      this.hBlurMaterial.uniforms["depthCutoff"].value = depthCutoff;
      this.vBlurMaterial.uniforms["cameraNear"].value = this.camera.near;
      this.vBlurMaterial.uniforms["cameraFar"].value = this.camera.far;
      this.hBlurMaterial.uniforms["cameraNear"].value = this.camera.near;
      this.hBlurMaterial.uniforms["cameraFar"].value = this.camera.far;
      this.params.saoBlurRadius = Math.floor(this.params.saoBlurRadius);
      if (this.prevStdDev !== this.params.saoBlurStdDev || this.prevNumSamples !== this.params.saoBlurRadius) {
        BlurShaderUtils.configure(
          this.vBlurMaterial,
          this.params.saoBlurRadius,
          this.params.saoBlurStdDev,
          new Vector2(0, 1)
        );
        BlurShaderUtils.configure(
          this.hBlurMaterial,
          this.params.saoBlurRadius,
          this.params.saoBlurStdDev,
          new Vector2(1, 0)
        );
        this.prevStdDev = this.params.saoBlurStdDev;
        this.prevNumSamples = this.params.saoBlurRadius;
      }
      renderer.setClearColor(0);
      renderer.setRenderTarget(this.beautyRenderTarget);
      renderer.clear();
      renderer.render(this.scene, this.camera);
      if (!this.supportsDepthTextureExtension) {
        this.renderOverride(renderer, this.depthMaterial, this.depthRenderTarget, 0, 1);
      }
      if (this.supportsNormalTexture) {
        this.renderOverride(renderer, this.normalMaterial, this.normalRenderTarget, 7829503, 1);
      }
      this.renderPass(renderer, this.saoMaterial, this.saoRenderTarget, 16777215, 1);
      if (this.params.saoBlur) {
        this.renderPass(renderer, this.vBlurMaterial, this.blurIntermediateRenderTarget, 16777215, 1);
        this.renderPass(renderer, this.hBlurMaterial, this.saoRenderTarget, 16777215, 1);
      }
      let outputMaterial = this.materialCopy;
      if (this.params.output === 3) {
        if (this.supportsDepthTextureExtension) {
          this.materialCopy.uniforms["tDiffuse"].value = this.beautyRenderTarget.depthTexture;
          this.materialCopy.needsUpdate = true;
        } else {
          this.depthCopy.uniforms["tDiffuse"].value = this.depthRenderTarget.texture;
          this.depthCopy.needsUpdate = true;
          outputMaterial = this.depthCopy;
        }
      } else if (this.params.output === 4) {
        this.materialCopy.uniforms["tDiffuse"].value = this.normalRenderTarget.texture;
        this.materialCopy.needsUpdate = true;
      } else {
        this.materialCopy.uniforms["tDiffuse"].value = this.saoRenderTarget.texture;
        this.materialCopy.needsUpdate = true;
      }
      if (this.params.output === 0) {
        outputMaterial.blending = CustomBlending;
      } else {
        outputMaterial.blending = NoBlending;
      }
      this.renderPass(renderer, outputMaterial, this.renderToScreen ? null : readBuffer);
      renderer.setClearColor(this._oldClearColor, this.oldClearAlpha);
      renderer.autoClear = oldAutoClear;
    }
    renderPass(renderer, passMaterial, renderTarget, clearColor, clearAlpha) {
      renderer.getClearColor(this.originalClearColor);
      const originalClearAlpha = renderer.getClearAlpha();
      const originalAutoClear = renderer.autoClear;
      renderer.setRenderTarget(renderTarget);
      renderer.autoClear = false;
      if (clearColor !== void 0 && clearColor !== null) {
        renderer.setClearColor(clearColor);
        renderer.setClearAlpha(clearAlpha || 0);
        renderer.clear();
      }
      this.fsQuad.material = passMaterial;
      this.fsQuad.render(renderer);
      renderer.autoClear = originalAutoClear;
      renderer.setClearColor(this.originalClearColor);
      renderer.setClearAlpha(originalClearAlpha);
    }
    renderOverride(renderer, overrideMaterial, renderTarget, clearColor, clearAlpha) {
      renderer.getClearColor(this.originalClearColor);
      const originalClearAlpha = renderer.getClearAlpha();
      const originalAutoClear = renderer.autoClear;
      renderer.setRenderTarget(renderTarget);
      renderer.autoClear = false;
      clearColor = overrideMaterial.clearColor || clearColor;
      clearAlpha = overrideMaterial.clearAlpha || clearAlpha;
      if (clearColor !== void 0 && clearColor !== null) {
        renderer.setClearColor(clearColor);
        renderer.setClearAlpha(clearAlpha || 0);
        renderer.clear();
      }
      this.scene.overrideMaterial = overrideMaterial;
      renderer.render(this.scene, this.camera);
      this.scene.overrideMaterial = null;
      renderer.autoClear = originalAutoClear;
      renderer.setClearColor(this.originalClearColor);
      renderer.setClearAlpha(originalClearAlpha);
    }
    setSize(width, height) {
      this.beautyRenderTarget.setSize(width, height);
      this.saoRenderTarget.setSize(width, height);
      this.blurIntermediateRenderTarget.setSize(width, height);
      this.normalRenderTarget.setSize(width, height);
      this.depthRenderTarget.setSize(width, height);
      this.saoMaterial.uniforms["size"].value.set(width, height);
      this.saoMaterial.uniforms["cameraInverseProjectionMatrix"].value.copy(this.camera.projectionMatrixInverse);
      this.saoMaterial.uniforms["cameraProjectionMatrix"].value = this.camera.projectionMatrix;
      this.saoMaterial.needsUpdate = true;
      this.vBlurMaterial.uniforms["size"].value.set(width, height);
      this.vBlurMaterial.needsUpdate = true;
      this.hBlurMaterial.uniforms["size"].value.set(width, height);
      this.hBlurMaterial.needsUpdate = true;
    }
    dispose() {
      this.saoRenderTarget.dispose();
      this.blurIntermediateRenderTarget.dispose();
      this.beautyRenderTarget.dispose();
      this.normalRenderTarget.dispose();
      this.depthRenderTarget.dispose();
      this.depthMaterial.dispose();
      this.normalMaterial.dispose();
      this.saoMaterial.dispose();
      this.vBlurMaterial.dispose();
      this.hBlurMaterial.dispose();
      this.materialCopy.dispose();
      this.depthCopy.dispose();
      this.fsQuad.dispose();
    }
  }
  __publicField25(SAOPass2, "OUTPUT", {
    Beauty: 1,
    Default: 0,
    SAO: 2,
    Depth: 3,
    Normal: 4
  });
  return SAOPass2;
})();

// node_modules/three-stdlib/postprocessing/MaskPass.js
var __defProp25 = Object.defineProperty;
var __defNormalProp25 = (obj, key, value) => key in obj ? __defProp25(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField26 = (obj, key, value) => {
  __defNormalProp25(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var MaskPass = class extends Pass {
  constructor(scene, camera) {
    super();
    __publicField26(this, "scene");
    __publicField26(this, "camera");
    __publicField26(this, "inverse");
    this.scene = scene;
    this.camera = camera;
    this.clear = true;
    this.needsSwap = false;
    this.inverse = false;
  }
  render(renderer, writeBuffer, readBuffer) {
    const context12 = renderer.getContext();
    const state = renderer.state;
    state.buffers.color.setMask(false);
    state.buffers.depth.setMask(false);
    state.buffers.color.setLocked(true);
    state.buffers.depth.setLocked(true);
    let writeValue, clearValue;
    if (this.inverse) {
      writeValue = 0;
      clearValue = 1;
    } else {
      writeValue = 1;
      clearValue = 0;
    }
    state.buffers.stencil.setTest(true);
    state.buffers.stencil.setOp(context12.REPLACE, context12.REPLACE, context12.REPLACE);
    state.buffers.stencil.setFunc(context12.ALWAYS, writeValue, 4294967295);
    state.buffers.stencil.setClear(clearValue);
    state.buffers.stencil.setLocked(true);
    renderer.setRenderTarget(readBuffer);
    if (this.clear)
      renderer.clear();
    renderer.render(this.scene, this.camera);
    renderer.setRenderTarget(writeBuffer);
    if (this.clear)
      renderer.clear();
    renderer.render(this.scene, this.camera);
    state.buffers.color.setLocked(false);
    state.buffers.depth.setLocked(false);
    state.buffers.stencil.setLocked(false);
    state.buffers.stencil.setFunc(context12.EQUAL, 1, 4294967295);
    state.buffers.stencil.setOp(context12.KEEP, context12.KEEP, context12.KEEP);
    state.buffers.stencil.setLocked(true);
  }
};
var ClearMaskPass = class extends Pass {
  constructor() {
    super();
    this.needsSwap = false;
  }
  render(renderer) {
    renderer.state.buffers.stencil.setLocked(false);
    renderer.state.buffers.stencil.setTest(false);
  }
};

// node_modules/three-stdlib/postprocessing/EffectComposer.js
var __defProp26 = Object.defineProperty;
var __defNormalProp26 = (obj, key, value) => key in obj ? __defProp26(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField27 = (obj, key, value) => {
  __defNormalProp26(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var EffectComposer = class {
  constructor(renderer, renderTarget) {
    __publicField27(this, "renderer");
    __publicField27(this, "_pixelRatio");
    __publicField27(this, "_width");
    __publicField27(this, "_height");
    __publicField27(this, "renderTarget1");
    __publicField27(this, "renderTarget2");
    __publicField27(this, "writeBuffer");
    __publicField27(this, "readBuffer");
    __publicField27(this, "renderToScreen");
    __publicField27(this, "passes", []);
    __publicField27(this, "copyPass");
    __publicField27(this, "clock");
    this.renderer = renderer;
    if (renderTarget === void 0) {
      const parameters = {
        minFilter: LinearFilter,
        magFilter: LinearFilter,
        format: RGBAFormat
      };
      const size2 = renderer.getSize(new Vector2());
      this._pixelRatio = renderer.getPixelRatio();
      this._width = size2.width;
      this._height = size2.height;
      renderTarget = new WebGLRenderTarget(
        this._width * this._pixelRatio,
        this._height * this._pixelRatio,
        parameters
      );
      renderTarget.texture.name = "EffectComposer.rt1";
    } else {
      this._pixelRatio = 1;
      this._width = renderTarget.width;
      this._height = renderTarget.height;
    }
    this.renderTarget1 = renderTarget;
    this.renderTarget2 = renderTarget.clone();
    this.renderTarget2.texture.name = "EffectComposer.rt2";
    this.writeBuffer = this.renderTarget1;
    this.readBuffer = this.renderTarget2;
    this.renderToScreen = true;
    if (CopyShader === void 0) {
      console.error("THREE.EffectComposer relies on CopyShader");
    }
    if (ShaderPass === void 0) {
      console.error("THREE.EffectComposer relies on ShaderPass");
    }
    this.copyPass = new ShaderPass(CopyShader);
    this.copyPass.material.blending = NoBlending;
    this.clock = new Clock();
  }
  swapBuffers() {
    const tmp = this.readBuffer;
    this.readBuffer = this.writeBuffer;
    this.writeBuffer = tmp;
  }
  addPass(pass) {
    this.passes.push(pass);
    pass.setSize(this._width * this._pixelRatio, this._height * this._pixelRatio);
  }
  insertPass(pass, index2) {
    this.passes.splice(index2, 0, pass);
    pass.setSize(this._width * this._pixelRatio, this._height * this._pixelRatio);
  }
  removePass(pass) {
    const index2 = this.passes.indexOf(pass);
    if (index2 !== -1) {
      this.passes.splice(index2, 1);
    }
  }
  isLastEnabledPass(passIndex) {
    for (let i4 = passIndex + 1; i4 < this.passes.length; i4++) {
      if (this.passes[i4].enabled) {
        return false;
      }
    }
    return true;
  }
  render(deltaTime) {
    if (deltaTime === void 0) {
      deltaTime = this.clock.getDelta();
    }
    const currentRenderTarget = this.renderer.getRenderTarget();
    let maskActive = false;
    const il = this.passes.length;
    for (let i4 = 0; i4 < il; i4++) {
      const pass = this.passes[i4];
      if (pass.enabled === false)
        continue;
      pass.renderToScreen = this.renderToScreen && this.isLastEnabledPass(i4);
      pass.render(this.renderer, this.writeBuffer, this.readBuffer, deltaTime, maskActive);
      if (pass.needsSwap) {
        if (maskActive) {
          const context12 = this.renderer.getContext();
          const stencil = this.renderer.state.buffers.stencil;
          stencil.setFunc(context12.NOTEQUAL, 1, 4294967295);
          this.copyPass.render(this.renderer, this.writeBuffer, this.readBuffer, deltaTime);
          stencil.setFunc(context12.EQUAL, 1, 4294967295);
        }
        this.swapBuffers();
      }
      if (MaskPass !== void 0) {
        if (pass instanceof MaskPass) {
          maskActive = true;
        } else if (pass instanceof ClearMaskPass) {
          maskActive = false;
        }
      }
    }
    this.renderer.setRenderTarget(currentRenderTarget);
  }
  reset(renderTarget) {
    if (renderTarget === void 0) {
      const size2 = this.renderer.getSize(new Vector2());
      this._pixelRatio = this.renderer.getPixelRatio();
      this._width = size2.width;
      this._height = size2.height;
      renderTarget = this.renderTarget1.clone();
      renderTarget.setSize(this._width * this._pixelRatio, this._height * this._pixelRatio);
    }
    this.renderTarget1.dispose();
    this.renderTarget2.dispose();
    this.renderTarget1 = renderTarget;
    this.renderTarget2 = renderTarget.clone();
    this.writeBuffer = this.renderTarget1;
    this.readBuffer = this.renderTarget2;
  }
  setSize(width, height) {
    this._width = width;
    this._height = height;
    const effectiveWidth = this._width * this._pixelRatio;
    const effectiveHeight = this._height * this._pixelRatio;
    this.renderTarget1.setSize(effectiveWidth, effectiveHeight);
    this.renderTarget2.setSize(effectiveWidth, effectiveHeight);
    for (let i4 = 0; i4 < this.passes.length; i4++) {
      this.passes[i4].setSize(effectiveWidth, effectiveHeight);
    }
  }
  setPixelRatio(pixelRatio) {
    this._pixelRatio = pixelRatio;
    this.setSize(this._width, this._height);
  }
  dispose() {
    this.renderTarget1.dispose();
    this.renderTarget2.dispose();
    this.copyPass.dispose();
  }
};

// node_modules/three-stdlib/shaders/DotScreenShader.js
var DotScreenShader = {
  uniforms: {
    tDiffuse: { value: null },
    tSize: { value: new Vector2(256, 256) },
    center: { value: new Vector2(0.5, 0.5) },
    angle: { value: 1.57 },
    scale: { value: 1 }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform vec2 center;
    uniform float angle;
    uniform float scale;
    uniform vec2 tSize;

    uniform sampler2D tDiffuse;

    varying vec2 vUv;

    float pattern() {

    	float s = sin( angle ), c = cos( angle );

    	vec2 tex = vUv * tSize - center;
    	vec2 point = vec2( c * tex.x - s * tex.y, s * tex.x + c * tex.y ) * scale;

    	return ( sin( point.x ) * sin( point.y ) ) * 4.0;

    }

    void main() {

    	vec4 color = texture2D( tDiffuse, vUv );

    	float average = ( color.r + color.g + color.b ) / 3.0;

    	gl_FragColor = vec4( vec3( average * 10.0 - 5.0 + pattern() ), color.a );

    }
  `
  )
};

// node_modules/three-stdlib/shaders/SSRShader.js
var SSRShader = {
  defines: {
    MAX_STEP: 0,
    isPerspectiveCamera: true,
    isDistanceAttenuation: true,
    isFresnel: true,
    isInfiniteThick: false,
    isSelective: false
  },
  uniforms: {
    tDiffuse: { value: null },
    tNormal: { value: null },
    tMetalness: { value: null },
    tDepth: { value: null },
    cameraNear: { value: null },
    cameraFar: { value: null },
    resolution: { value: new Vector2() },
    cameraProjectionMatrix: { value: new Matrix4() },
    cameraInverseProjectionMatrix: { value: new Matrix4() },
    opacity: { value: 0.5 },
    maxDistance: { value: 180 },
    cameraRange: { value: 0 },
    surfDist: { value: 7e-3 },
    thickTolerance: { value: 0.03 }
  },
  vertexShader: (
    /* glsl */
    `

    varying vec2 vUv;

    void main() {

			vUv = uv;

			gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }

  `
  ),
  fragmentShader: (
    /* glsl */
    `
		// precision highp float;
		precision highp sampler2D;
		varying vec2 vUv;
		uniform sampler2D tDepth;
		uniform sampler2D tNormal;
		uniform sampler2D tMetalness;
		uniform sampler2D tDiffuse;
		uniform float cameraRange;
		uniform vec2 resolution;
		uniform float opacity;
		uniform float cameraNear;
		uniform float cameraFar;
		uniform float maxDistance;
		uniform float surfDist;
		uniform mat4 cameraProjectionMatrix;
		uniform mat4 cameraInverseProjectionMatrix;
		uniform float thickTolerance;
		#include <packing>
		float pointToLineDistance(vec3 x0, vec3 x1, vec3 x2) {
			//x0: point, x1: linePointA, x2: linePointB
			//https://mathworld.wolfram.com/Point-LineDistance3-Dimensional.html
			return length(cross(x0-x1,x0-x2))/length(x2-x1);
		}
		float pointPlaneDistance(vec3 point,vec3 planePoint,vec3 planeNormal){
			// https://mathworld.wolfram.com/Point-PlaneDistance.html
			//// https://en.wikipedia.org/wiki/Plane_(geometry)
			//// http://paulbourke.net/geometry/pointlineplane/
			float a=planeNormal.x,b=planeNormal.y,c=planeNormal.z;
			float x0=point.x,y0=point.y,z0=point.z;
			float x=planePoint.x,y=planePoint.y,z=planePoint.z;
			float d=-(a*x+b*y+c*z);
			float distance=(a*x0+b*y0+c*z0+d)/sqrt(a*a+b*b+c*c);
			return distance;
		}
		float getDepth( const in vec2 uv ) {
			return texture2D( tDepth, uv ).x;
		}
		float getViewZ( const in float depth ) {
			#ifdef isPerspectiveCamera
				return perspectiveDepthToViewZ( depth, cameraNear, cameraFar );
			#else
				return orthographicDepthToViewZ( depth, cameraNear, cameraFar );
			#endif
		}
		vec3 getViewPosition( const in vec2 uv, const in float depth/*clip space*/, const in float clipW ) {
			vec4 clipPosition = vec4( ( vec3( uv, depth ) - 0.5 ) * 2.0, 1.0 );//ndc
			clipPosition *= clipW; //clip
			return ( cameraInverseProjectionMatrix * clipPosition ).xyz;//view
		}
		vec3 getViewNormal( const in vec2 uv ) {
			return unpackRGBToNormal( texture2D( tNormal, uv ).xyz );
		}
		vec2 viewPositionToXY(vec3 viewPosition){
			vec2 xy;
			vec4 clip=cameraProjectionMatrix*vec4(viewPosition,1);
			xy=clip.xy;//clip
			float clipW=clip.w;
			xy/=clipW;//NDC
			xy=(xy+1.)/2.;//uv
			xy*=resolution;//screen
			return xy;
		}
		void main(){
			#ifdef isSelective
				float metalness=texture2D(tMetalness,vUv).r;
				if(metalness==0.) return;
			#endif

			float depth = getDepth( vUv );
			float viewZ = getViewZ( depth );
			if(-viewZ>=cameraFar) return;

			float clipW = cameraProjectionMatrix[2][3] * viewZ+cameraProjectionMatrix[3][3];
			vec3 viewPosition=getViewPosition( vUv, depth, clipW );

			vec2 d0=gl_FragCoord.xy;
			vec2 d1;

			vec3 viewNormal=getViewNormal( vUv );

			#ifdef isPerspectiveCamera
				vec3 viewIncidenceDir=normalize(viewPosition);
				vec3 viewReflectDir=reflect(viewIncidenceDir,viewNormal);
			#else
				vec3 viewIncidenceDir=vec3(0,0,-1);
				vec3 viewReflectDir=reflect(viewIncidenceDir,viewNormal);
			#endif

			float maxReflectRayLen=maxDistance/dot(-viewIncidenceDir,viewNormal);
			// dot(a,b)==length(a)*length(b)*cos(theta) // https://www.mathsisfun.com/algebra/vectors-dot-product.html
			// if(a.isNormalized&&b.isNormalized) dot(a,b)==cos(theta)
			// maxDistance/maxReflectRayLen=cos(theta)
			// maxDistance/maxReflectRayLen==dot(a,b)
			// maxReflectRayLen==maxDistance/dot(a,b)

			vec3 d1viewPosition=viewPosition+viewReflectDir*maxReflectRayLen;
			#ifdef isPerspectiveCamera
				if(d1viewPosition.z>-cameraNear){
					//https://tutorial.math.lamar.edu/Classes/CalcIII/EqnsOfLines.aspx
					float t=(-cameraNear-viewPosition.z)/viewReflectDir.z;
					d1viewPosition=viewPosition+viewReflectDir*t;
				}
			#endif
			d1=viewPositionToXY(d1viewPosition);

			float totalLen=length(d1-d0);
			float xLen=d1.x-d0.x;
			float yLen=d1.y-d0.y;
			float totalStep=max(abs(xLen),abs(yLen));
			float xSpan=xLen/totalStep;
			float ySpan=yLen/totalStep;
			for(float i=0.;i<MAX_STEP;i++){
				if(i>=totalStep) break;
				vec2 xy=vec2(d0.x+i*xSpan,d0.y+i*ySpan);
				if(xy.x<0.||xy.x>resolution.x||xy.y<0.||xy.y>resolution.y) break;
				float s=length(xy-d0)/totalLen;
				vec2 uv=xy/resolution;

				float d = getDepth(uv);
				float vZ = getViewZ( d );
				if(-vZ>=cameraFar) continue;
				float cW = cameraProjectionMatrix[2][3] * vZ+cameraProjectionMatrix[3][3];
				vec3 vP=getViewPosition( uv, d, cW );

				#ifdef isPerspectiveCamera
					// https://www.comp.nus.edu.sg/~lowkl/publications/lowk_persp_interp_techrep.pdf
					float recipVPZ=1./viewPosition.z;
					float viewReflectRayZ=1./(recipVPZ+s*(1./d1viewPosition.z-recipVPZ));
					float sD=surfDist*cW;
				#else
					float viewReflectRayZ=viewPosition.z+s*(d1viewPosition.z-viewPosition.z);
					float sD=surfDist;
				#endif
				if(viewReflectRayZ-sD>vZ) continue;

				#ifdef isInfiniteThick
					if(viewReflectRayZ+thickTolerance*clipW<vP.z) break;
				#endif
				float away=pointToLineDistance(vP,viewPosition,d1viewPosition);

				float op=opacity;

				if(away<sD){
					vec3 vN=getViewNormal( uv );
					if(dot(viewReflectDir,vN)>=0.) continue;
					float distance=pointPlaneDistance(vP,viewPosition,viewNormal);
					if(distance>maxDistance) break;
					#ifdef isDistanceAttenuation
						float ratio=1.-(distance/maxDistance);
						float attenuation=ratio*ratio;
						op=opacity*attenuation;
					#endif
					#ifdef isFresnel
						float fresnel=(dot(viewIncidenceDir,viewReflectDir)+1.)/2.;
						op*=fresnel;
					#endif
					vec4 reflectColor=texture2D(tDiffuse,uv);
					gl_FragColor.xyz=reflectColor.xyz;
					gl_FragColor.a=op;
					break;
				}
			}
		}
	`
  )
};
var SSRDepthShader = {
  defines: {
    PERSPECTIVE_CAMERA: 1
  },
  uniforms: {
    tDepth: { value: null },
    cameraNear: { value: null },
    cameraFar: { value: null }
  },
  vertexShader: (
    /* glsl */
    `

    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }

  `
  ),
  fragmentShader: (
    /* glsl */
    `

    uniform sampler2D tDepth;

    uniform float cameraNear;
    uniform float cameraFar;

    varying vec2 vUv;

    #include <packing>

		float getLinearDepth( const in vec2 uv ) {

			#if PERSPECTIVE_CAMERA == 1

				float fragCoordZ = texture2D( tDepth, uv ).x;
				float viewZ = perspectiveDepthToViewZ( fragCoordZ, cameraNear, cameraFar );
				return viewZToOrthographicDepth( viewZ, cameraNear, cameraFar );

			#else

				return texture2D( tDepth, uv ).x;

			#endif

		}

    void main() {

    	float depth = getLinearDepth( vUv );
			float d = 1.0 - depth;
			// d=(d-.999)*1000.;
    	gl_FragColor = vec4( vec3( d ), 1.0 );

    }

  `
  )
};
var SSRBlurShader = {
  uniforms: {
    tDiffuse: { value: null },
    resolution: { value: new Vector2() },
    opacity: { value: 0.5 }
  },
  vertexShader: (
    /* glsl */
    `

    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }

  `
  ),
  fragmentShader: (
    /* glsl */
    `

    uniform sampler2D tDiffuse;
    uniform vec2 resolution;
    varying vec2 vUv;
    void main() {
			//reverse engineering from PhotoShop blur filter, then change coefficient

    	vec2 texelSize = ( 1.0 / resolution );

			vec4 c=texture2D(tDiffuse,vUv);

			vec2 offset;

			offset=(vec2(-1,0))*texelSize;
			vec4 cl=texture2D(tDiffuse,vUv+offset);

			offset=(vec2(1,0))*texelSize;
			vec4 cr=texture2D(tDiffuse,vUv+offset);

			offset=(vec2(0,-1))*texelSize;
			vec4 cb=texture2D(tDiffuse,vUv+offset);

			offset=(vec2(0,1))*texelSize;
			vec4 ct=texture2D(tDiffuse,vUv+offset);

			// float coeCenter=.5;
			// float coeSide=.125;
			float coeCenter=.2;
			float coeSide=.2;
			float a=c.a*coeCenter+cl.a*coeSide+cr.a*coeSide+cb.a*coeSide+ct.a*coeSide;
			vec3 rgb=(c.rgb*c.a*coeCenter+cl.rgb*cl.a*coeSide+cr.rgb*cr.a*coeSide+cb.rgb*cb.a*coeSide+ct.rgb*ct.a*coeSide)/a;
			gl_FragColor=vec4(rgb,a);

		}
	`
  )
};

// node_modules/three-stdlib/postprocessing/SSRPass.js
var __defProp27 = Object.defineProperty;
var __defNormalProp27 = (obj, key, value) => key in obj ? __defProp27(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField28 = (obj, key, value) => {
  __defNormalProp27(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var SSRPass = (() => {
  const _SSRPass = class extends Pass {
    constructor({ renderer, scene, camera, width, height, selects, bouncing = false, groundReflector }) {
      super();
      this.width = width !== void 0 ? width : 512;
      this.height = height !== void 0 ? height : 512;
      this.clear = true;
      this.renderer = renderer;
      this.scene = scene;
      this.camera = camera;
      this.groundReflector = groundReflector;
      this.opacity = SSRShader.uniforms.opacity.value;
      this.output = 0;
      this.maxDistance = SSRShader.uniforms.maxDistance.value;
      this.thickness = SSRShader.uniforms.thickness.value;
      this.tempColor = new Color();
      this._selects = selects;
      this.selective = Array.isArray(this._selects);
      Object.defineProperty(this, "selects", {
        get() {
          return this._selects;
        },
        set(val) {
          if (this._selects === val)
            return;
          this._selects = val;
          if (Array.isArray(val)) {
            this.selective = true;
            this.ssrMaterial.defines.SELECTIVE = true;
            this.ssrMaterial.needsUpdate = true;
          } else {
            this.selective = false;
            this.ssrMaterial.defines.SELECTIVE = false;
            this.ssrMaterial.needsUpdate = true;
          }
        }
      });
      this._bouncing = bouncing;
      Object.defineProperty(this, "bouncing", {
        get() {
          return this._bouncing;
        },
        set(val) {
          if (this._bouncing === val)
            return;
          this._bouncing = val;
          if (val) {
            this.ssrMaterial.uniforms["tDiffuse"].value = this.prevRenderTarget.texture;
          } else {
            this.ssrMaterial.uniforms["tDiffuse"].value = this.beautyRenderTarget.texture;
          }
        }
      });
      this.blur = true;
      this._distanceAttenuation = SSRShader.defines.DISTANCE_ATTENUATION;
      Object.defineProperty(this, "distanceAttenuation", {
        get() {
          return this._distanceAttenuation;
        },
        set(val) {
          if (this._distanceAttenuation === val)
            return;
          this._distanceAttenuation = val;
          this.ssrMaterial.defines.DISTANCE_ATTENUATION = val;
          this.ssrMaterial.needsUpdate = true;
        }
      });
      this._fresnel = SSRShader.defines.FRESNEL;
      Object.defineProperty(this, "fresnel", {
        get() {
          return this._fresnel;
        },
        set(val) {
          if (this._fresnel === val)
            return;
          this._fresnel = val;
          this.ssrMaterial.defines.FRESNEL = val;
          this.ssrMaterial.needsUpdate = true;
        }
      });
      this._infiniteThick = SSRShader.defines.INFINITE_THICK;
      Object.defineProperty(this, "infiniteThick", {
        get() {
          return this._infiniteThick;
        },
        set(val) {
          if (this._infiniteThick === val)
            return;
          this._infiniteThick = val;
          this.ssrMaterial.defines.INFINITE_THICK = val;
          this.ssrMaterial.needsUpdate = true;
        }
      });
      const depthTexture = new DepthTexture();
      depthTexture.type = UnsignedShortType;
      depthTexture.minFilter = NearestFilter;
      depthTexture.magFilter = NearestFilter;
      this.beautyRenderTarget = new WebGLRenderTarget(this.width, this.height, {
        minFilter: NearestFilter,
        magFilter: NearestFilter,
        type: HalfFloatType,
        depthTexture,
        depthBuffer: true
      });
      this.prevRenderTarget = new WebGLRenderTarget(this.width, this.height, {
        minFilter: NearestFilter,
        magFilter: NearestFilter
      });
      this.normalRenderTarget = new WebGLRenderTarget(this.width, this.height, {
        minFilter: NearestFilter,
        magFilter: NearestFilter,
        type: HalfFloatType
      });
      this.metalnessRenderTarget = new WebGLRenderTarget(this.width, this.height, {
        minFilter: NearestFilter,
        magFilter: NearestFilter,
        type: HalfFloatType
      });
      this.ssrRenderTarget = new WebGLRenderTarget(this.width, this.height, {
        minFilter: NearestFilter,
        magFilter: NearestFilter
      });
      this.blurRenderTarget = this.ssrRenderTarget.clone();
      this.blurRenderTarget2 = this.ssrRenderTarget.clone();
      this.ssrMaterial = new ShaderMaterial({
        defines: Object.assign({}, SSRShader.defines, {
          MAX_STEP: Math.sqrt(this.width * this.width + this.height * this.height)
        }),
        uniforms: UniformsUtils.clone(SSRShader.uniforms),
        vertexShader: SSRShader.vertexShader,
        fragmentShader: SSRShader.fragmentShader,
        blending: NoBlending
      });
      this.ssrMaterial.uniforms["tDiffuse"].value = this.beautyRenderTarget.texture;
      this.ssrMaterial.uniforms["tNormal"].value = this.normalRenderTarget.texture;
      this.ssrMaterial.defines.SELECTIVE = this.selective;
      this.ssrMaterial.needsUpdate = true;
      this.ssrMaterial.uniforms["tMetalness"].value = this.metalnessRenderTarget.texture;
      this.ssrMaterial.uniforms["tDepth"].value = this.beautyRenderTarget.depthTexture;
      this.ssrMaterial.uniforms["cameraNear"].value = this.camera.near;
      this.ssrMaterial.uniforms["cameraFar"].value = this.camera.far;
      this.ssrMaterial.uniforms["thickness"].value = this.thickness;
      this.ssrMaterial.uniforms["resolution"].value.set(this.width, this.height);
      this.ssrMaterial.uniforms["cameraProjectionMatrix"].value.copy(this.camera.projectionMatrix);
      this.ssrMaterial.uniforms["cameraInverseProjectionMatrix"].value.copy(this.camera.projectionMatrixInverse);
      this.normalMaterial = new MeshNormalMaterial();
      this.normalMaterial.blending = NoBlending;
      this.metalnessOnMaterial = new MeshBasicMaterial({
        color: "white"
      });
      this.metalnessOffMaterial = new MeshBasicMaterial({
        color: "black"
      });
      this.blurMaterial = new ShaderMaterial({
        defines: Object.assign({}, SSRBlurShader.defines),
        uniforms: UniformsUtils.clone(SSRBlurShader.uniforms),
        vertexShader: SSRBlurShader.vertexShader,
        fragmentShader: SSRBlurShader.fragmentShader
      });
      this.blurMaterial.uniforms["tDiffuse"].value = this.ssrRenderTarget.texture;
      this.blurMaterial.uniforms["resolution"].value.set(this.width, this.height);
      this.blurMaterial2 = new ShaderMaterial({
        defines: Object.assign({}, SSRBlurShader.defines),
        uniforms: UniformsUtils.clone(SSRBlurShader.uniforms),
        vertexShader: SSRBlurShader.vertexShader,
        fragmentShader: SSRBlurShader.fragmentShader
      });
      this.blurMaterial2.uniforms["tDiffuse"].value = this.blurRenderTarget.texture;
      this.blurMaterial2.uniforms["resolution"].value.set(this.width, this.height);
      this.depthRenderMaterial = new ShaderMaterial({
        defines: Object.assign({}, SSRDepthShader.defines),
        uniforms: UniformsUtils.clone(SSRDepthShader.uniforms),
        vertexShader: SSRDepthShader.vertexShader,
        fragmentShader: SSRDepthShader.fragmentShader,
        blending: NoBlending
      });
      this.depthRenderMaterial.uniforms["tDepth"].value = this.beautyRenderTarget.depthTexture;
      this.depthRenderMaterial.uniforms["cameraNear"].value = this.camera.near;
      this.depthRenderMaterial.uniforms["cameraFar"].value = this.camera.far;
      this.copyMaterial = new ShaderMaterial({
        uniforms: UniformsUtils.clone(CopyShader.uniforms),
        vertexShader: CopyShader.vertexShader,
        fragmentShader: CopyShader.fragmentShader,
        transparent: true,
        depthTest: false,
        depthWrite: false,
        blendSrc: SrcAlphaFactor,
        blendDst: OneMinusSrcAlphaFactor,
        blendEquation: AddEquation,
        blendSrcAlpha: SrcAlphaFactor,
        blendDstAlpha: OneMinusSrcAlphaFactor,
        blendEquationAlpha: AddEquation
        // premultipliedAlpha:true,
      });
      this.fsQuad = new FullScreenQuad(null);
      this.originalClearColor = new Color();
    }
    dispose() {
      this.beautyRenderTarget.dispose();
      this.prevRenderTarget.dispose();
      this.normalRenderTarget.dispose();
      this.metalnessRenderTarget.dispose();
      this.ssrRenderTarget.dispose();
      this.blurRenderTarget.dispose();
      this.blurRenderTarget2.dispose();
      this.normalMaterial.dispose();
      this.metalnessOnMaterial.dispose();
      this.metalnessOffMaterial.dispose();
      this.blurMaterial.dispose();
      this.blurMaterial2.dispose();
      this.copyMaterial.dispose();
      this.depthRenderMaterial.dispose();
      this.fsQuad.dispose();
    }
    render(renderer, writeBuffer) {
      renderer.setRenderTarget(this.beautyRenderTarget);
      renderer.clear();
      if (this.groundReflector) {
        this.groundReflector.visible = false;
        this.groundReflector.doRender(this.renderer, this.scene, this.camera);
        this.groundReflector.visible = true;
      }
      renderer.render(this.scene, this.camera);
      if (this.groundReflector)
        this.groundReflector.visible = false;
      this.renderOverride(renderer, this.normalMaterial, this.normalRenderTarget, 0, 0);
      if (this.selective) {
        this.renderMetalness(renderer, this.metalnessOnMaterial, this.metalnessRenderTarget, 0, 0);
      }
      this.ssrMaterial.uniforms["opacity"].value = this.opacity;
      this.ssrMaterial.uniforms["maxDistance"].value = this.maxDistance;
      this.ssrMaterial.uniforms["thickness"].value = this.thickness;
      this.renderPass(renderer, this.ssrMaterial, this.ssrRenderTarget);
      if (this.blur) {
        this.renderPass(renderer, this.blurMaterial, this.blurRenderTarget);
        this.renderPass(renderer, this.blurMaterial2, this.blurRenderTarget2);
      }
      switch (this.output) {
        case _SSRPass.OUTPUT.Default:
          if (this.bouncing) {
            this.copyMaterial.uniforms["tDiffuse"].value = this.beautyRenderTarget.texture;
            this.copyMaterial.blending = NoBlending;
            this.renderPass(renderer, this.copyMaterial, this.prevRenderTarget);
            if (this.blur)
              this.copyMaterial.uniforms["tDiffuse"].value = this.blurRenderTarget2.texture;
            else
              this.copyMaterial.uniforms["tDiffuse"].value = this.ssrRenderTarget.texture;
            this.copyMaterial.blending = NormalBlending;
            this.renderPass(renderer, this.copyMaterial, this.prevRenderTarget);
            this.copyMaterial.uniforms["tDiffuse"].value = this.prevRenderTarget.texture;
            this.copyMaterial.blending = NoBlending;
            this.renderPass(renderer, this.copyMaterial, this.renderToScreen ? null : writeBuffer);
          } else {
            this.copyMaterial.uniforms["tDiffuse"].value = this.beautyRenderTarget.texture;
            this.copyMaterial.blending = NoBlending;
            this.renderPass(renderer, this.copyMaterial, this.renderToScreen ? null : writeBuffer);
            if (this.blur)
              this.copyMaterial.uniforms["tDiffuse"].value = this.blurRenderTarget2.texture;
            else
              this.copyMaterial.uniforms["tDiffuse"].value = this.ssrRenderTarget.texture;
            this.copyMaterial.blending = NormalBlending;
            this.renderPass(renderer, this.copyMaterial, this.renderToScreen ? null : writeBuffer);
          }
          break;
        case _SSRPass.OUTPUT.SSR:
          if (this.blur)
            this.copyMaterial.uniforms["tDiffuse"].value = this.blurRenderTarget2.texture;
          else
            this.copyMaterial.uniforms["tDiffuse"].value = this.ssrRenderTarget.texture;
          this.copyMaterial.blending = NoBlending;
          this.renderPass(renderer, this.copyMaterial, this.renderToScreen ? null : writeBuffer);
          if (this.bouncing) {
            if (this.blur)
              this.copyMaterial.uniforms["tDiffuse"].value = this.blurRenderTarget2.texture;
            else
              this.copyMaterial.uniforms["tDiffuse"].value = this.beautyRenderTarget.texture;
            this.copyMaterial.blending = NoBlending;
            this.renderPass(renderer, this.copyMaterial, this.prevRenderTarget);
            this.copyMaterial.uniforms["tDiffuse"].value = this.ssrRenderTarget.texture;
            this.copyMaterial.blending = NormalBlending;
            this.renderPass(renderer, this.copyMaterial, this.prevRenderTarget);
          }
          break;
        case _SSRPass.OUTPUT.Beauty:
          this.copyMaterial.uniforms["tDiffuse"].value = this.beautyRenderTarget.texture;
          this.copyMaterial.blending = NoBlending;
          this.renderPass(renderer, this.copyMaterial, this.renderToScreen ? null : writeBuffer);
          break;
        case _SSRPass.OUTPUT.Depth:
          this.renderPass(renderer, this.depthRenderMaterial, this.renderToScreen ? null : writeBuffer);
          break;
        case _SSRPass.OUTPUT.Normal:
          this.copyMaterial.uniforms["tDiffuse"].value = this.normalRenderTarget.texture;
          this.copyMaterial.blending = NoBlending;
          this.renderPass(renderer, this.copyMaterial, this.renderToScreen ? null : writeBuffer);
          break;
        case _SSRPass.OUTPUT.Metalness:
          this.copyMaterial.uniforms["tDiffuse"].value = this.metalnessRenderTarget.texture;
          this.copyMaterial.blending = NoBlending;
          this.renderPass(renderer, this.copyMaterial, this.renderToScreen ? null : writeBuffer);
          break;
        default:
          console.warn("THREE.SSRPass: Unknown output type.");
      }
    }
    renderPass(renderer, passMaterial, renderTarget, clearColor, clearAlpha) {
      this.originalClearColor.copy(renderer.getClearColor(this.tempColor));
      const originalClearAlpha = renderer.getClearAlpha(this.tempColor);
      const originalAutoClear = renderer.autoClear;
      renderer.setRenderTarget(renderTarget);
      renderer.autoClear = false;
      if (clearColor !== void 0 && clearColor !== null) {
        renderer.setClearColor(clearColor);
        renderer.setClearAlpha(clearAlpha || 0);
        renderer.clear();
      }
      this.fsQuad.material = passMaterial;
      this.fsQuad.render(renderer);
      renderer.autoClear = originalAutoClear;
      renderer.setClearColor(this.originalClearColor);
      renderer.setClearAlpha(originalClearAlpha);
    }
    renderOverride(renderer, overrideMaterial, renderTarget, clearColor, clearAlpha) {
      this.originalClearColor.copy(renderer.getClearColor(this.tempColor));
      const originalClearAlpha = renderer.getClearAlpha(this.tempColor);
      const originalAutoClear = renderer.autoClear;
      renderer.setRenderTarget(renderTarget);
      renderer.autoClear = false;
      clearColor = overrideMaterial.clearColor || clearColor;
      clearAlpha = overrideMaterial.clearAlpha || clearAlpha;
      if (clearColor !== void 0 && clearColor !== null) {
        renderer.setClearColor(clearColor);
        renderer.setClearAlpha(clearAlpha || 0);
        renderer.clear();
      }
      this.scene.overrideMaterial = overrideMaterial;
      renderer.render(this.scene, this.camera);
      this.scene.overrideMaterial = null;
      renderer.autoClear = originalAutoClear;
      renderer.setClearColor(this.originalClearColor);
      renderer.setClearAlpha(originalClearAlpha);
    }
    renderMetalness(renderer, overrideMaterial, renderTarget, clearColor, clearAlpha) {
      this.originalClearColor.copy(renderer.getClearColor(this.tempColor));
      const originalClearAlpha = renderer.getClearAlpha(this.tempColor);
      const originalAutoClear = renderer.autoClear;
      renderer.setRenderTarget(renderTarget);
      renderer.autoClear = false;
      clearColor = overrideMaterial.clearColor || clearColor;
      clearAlpha = overrideMaterial.clearAlpha || clearAlpha;
      if (clearColor !== void 0 && clearColor !== null) {
        renderer.setClearColor(clearColor);
        renderer.setClearAlpha(clearAlpha || 0);
        renderer.clear();
      }
      this.scene.traverseVisible((child) => {
        child._SSRPassBackupMaterial = child.material;
        if (this._selects.includes(child)) {
          child.material = this.metalnessOnMaterial;
        } else {
          child.material = this.metalnessOffMaterial;
        }
      });
      renderer.render(this.scene, this.camera);
      this.scene.traverseVisible((child) => {
        child.material = child._SSRPassBackupMaterial;
      });
      renderer.autoClear = originalAutoClear;
      renderer.setClearColor(this.originalClearColor);
      renderer.setClearAlpha(originalClearAlpha);
    }
    setSize(width, height) {
      this.width = width;
      this.height = height;
      this.ssrMaterial.defines.MAX_STEP = Math.sqrt(width * width + height * height);
      this.ssrMaterial.needsUpdate = true;
      this.beautyRenderTarget.setSize(width, height);
      this.prevRenderTarget.setSize(width, height);
      this.ssrRenderTarget.setSize(width, height);
      this.normalRenderTarget.setSize(width, height);
      this.metalnessRenderTarget.setSize(width, height);
      this.blurRenderTarget.setSize(width, height);
      this.blurRenderTarget2.setSize(width, height);
      this.ssrMaterial.uniforms["resolution"].value.set(width, height);
      this.ssrMaterial.uniforms["cameraProjectionMatrix"].value.copy(this.camera.projectionMatrix);
      this.ssrMaterial.uniforms["cameraInverseProjectionMatrix"].value.copy(this.camera.projectionMatrixInverse);
      this.blurMaterial.uniforms["resolution"].value.set(width, height);
      this.blurMaterial2.uniforms["resolution"].value.set(width, height);
    }
  };
  let SSRPass2 = _SSRPass;
  __publicField28(SSRPass2, "OUTPUT", {
    Default: 0,
    SSR: 1,
    Beauty: 3,
    Depth: 4,
    Normal: 5,
    Metalness: 7
  });
  return SSRPass2;
})();

// node_modules/three-stdlib/postprocessing/RenderPass.js
var __defProp28 = Object.defineProperty;
var __defNormalProp28 = (obj, key, value) => key in obj ? __defProp28(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField29 = (obj, key, value) => {
  __defNormalProp28(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var RenderPass = class extends Pass {
  constructor(scene, camera, overrideMaterial, clearColor, clearAlpha = 0) {
    super();
    __publicField29(this, "scene");
    __publicField29(this, "camera");
    __publicField29(this, "overrideMaterial");
    __publicField29(this, "clearColor");
    __publicField29(this, "clearAlpha");
    __publicField29(this, "clearDepth", false);
    __publicField29(this, "_oldClearColor", new Color());
    this.scene = scene;
    this.camera = camera;
    this.overrideMaterial = overrideMaterial;
    this.clearColor = clearColor;
    this.clearAlpha = clearAlpha;
    this.clear = true;
    this.needsSwap = false;
  }
  render(renderer, writeBuffer, readBuffer) {
    let oldAutoClear = renderer.autoClear;
    renderer.autoClear = false;
    let oldClearAlpha;
    let oldOverrideMaterial = null;
    if (this.overrideMaterial !== void 0) {
      oldOverrideMaterial = this.scene.overrideMaterial;
      this.scene.overrideMaterial = this.overrideMaterial;
    }
    if (this.clearColor) {
      renderer.getClearColor(this._oldClearColor);
      oldClearAlpha = renderer.getClearAlpha();
      renderer.setClearColor(this.clearColor, this.clearAlpha);
    }
    if (this.clearDepth) {
      renderer.clearDepth();
    }
    renderer.setRenderTarget(this.renderToScreen ? null : readBuffer);
    if (this.clear)
      renderer.clear(renderer.autoClearColor, renderer.autoClearDepth, renderer.autoClearStencil);
    renderer.render(this.scene, this.camera);
    if (this.clearColor) {
      renderer.setClearColor(this._oldClearColor, oldClearAlpha);
    }
    if (this.overrideMaterial !== void 0) {
      this.scene.overrideMaterial = oldOverrideMaterial;
    }
    renderer.autoClear = oldAutoClear;
  }
};

// node_modules/three-stdlib/shaders/ConvolutionShader.js
var ConvolutionShader = {
  defines: {
    KERNEL_SIZE_FLOAT: "25.0",
    KERNEL_SIZE_INT: "25"
  },
  uniforms: {
    tDiffuse: { value: null },
    uImageIncrement: { value: new Vector2(1953125e-9, 0) },
    cKernel: { value: [] }
  },
  vertexShader: (
    /* glsl */
    `
    uniform vec2 uImageIncrement;

    varying vec2 vUv;

    void main() {

    	vUv = uv - ( ( KERNEL_SIZE_FLOAT - 1.0 ) / 2.0 ) * uImageIncrement;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform float cKernel[ KERNEL_SIZE_INT ];

    uniform sampler2D tDiffuse;
    uniform vec2 uImageIncrement;

    varying vec2 vUv;

    void main() {

    	vec2 imageCoord = vUv;
    	vec4 sum = vec4( 0.0, 0.0, 0.0, 0.0 );

    	for( int i = 0; i < KERNEL_SIZE_INT; i ++ ) {

    		sum += texture2D( tDiffuse, imageCoord ) * cKernel[ i ];
    		imageCoord += uImageIncrement;

    	}

    	gl_FragColor = sum;

    }
  `
  ),
  buildKernel: function(sigma) {
    function gauss(x, sigma2) {
      return Math.exp(-(x * x) / (2 * sigma2 * sigma2));
    }
    const kMaxKernelSize = 25;
    const kernelSize = Math.min(2 * Math.ceil(sigma * 3) + 1, kMaxKernelSize);
    const halfWidth = (kernelSize - 1) * 0.5;
    const values = new Array(kernelSize);
    let sum = 0;
    for (let i4 = 0; i4 < kernelSize; ++i4) {
      values[i4] = gauss(i4 - halfWidth, sigma);
      sum += values[i4];
    }
    for (let i4 = 0; i4 < kernelSize; ++i4)
      values[i4] /= sum;
    return values;
  }
};

// node_modules/three-stdlib/_polyfill/LoaderUtils.js
function decodeText(array) {
  if (typeof TextDecoder !== "undefined") {
    return new TextDecoder().decode(array);
  }
  let s2 = "";
  for (let i4 = 0, il = array.length; i4 < il; i4++) {
    s2 += String.fromCharCode(array[i4]);
  }
  try {
    return decodeURIComponent(escape(s2));
  } catch (e2) {
    return s2;
  }
}

// node_modules/three-stdlib/loaders/GLTFLoader.js
var SRGBColorSpace2 = "srgb";
var LinearSRGBColorSpace2 = "srgb-linear";
var sRGBEncoding = 3001;
var LinearEncoding = 3e3;
var GLTFLoader = class extends Loader {
  constructor(manager) {
    super(manager);
    this.dracoLoader = null;
    this.ktx2Loader = null;
    this.meshoptDecoder = null;
    this.pluginCallbacks = [];
    this.register(function(parser) {
      return new GLTFMaterialsClearcoatExtension2(parser);
    });
    this.register(function(parser) {
      return new GLTFMaterialsDispersionExtension(parser);
    });
    this.register(function(parser) {
      return new GLTFTextureBasisUExtension(parser);
    });
    this.register(function(parser) {
      return new GLTFTextureWebPExtension(parser);
    });
    this.register(function(parser) {
      return new GLTFTextureAVIFExtension(parser);
    });
    this.register(function(parser) {
      return new GLTFMaterialsSheenExtension2(parser);
    });
    this.register(function(parser) {
      return new GLTFMaterialsTransmissionExtension2(parser);
    });
    this.register(function(parser) {
      return new GLTFMaterialsVolumeExtension2(parser);
    });
    this.register(function(parser) {
      return new GLTFMaterialsIorExtension2(parser);
    });
    this.register(function(parser) {
      return new GLTFMaterialsEmissiveStrengthExtension2(parser);
    });
    this.register(function(parser) {
      return new GLTFMaterialsSpecularExtension2(parser);
    });
    this.register(function(parser) {
      return new GLTFMaterialsIridescenceExtension2(parser);
    });
    this.register(function(parser) {
      return new GLTFMaterialsAnisotropyExtension2(parser);
    });
    this.register(function(parser) {
      return new GLTFMaterialsBumpExtension(parser);
    });
    this.register(function(parser) {
      return new GLTFLightsExtension(parser);
    });
    this.register(function(parser) {
      return new GLTFMeshoptCompression(parser);
    });
    this.register(function(parser) {
      return new GLTFMeshGpuInstancing(parser);
    });
  }
  load(url, onLoad, onProgress, onError) {
    const scope = this;
    let resourcePath;
    if (this.resourcePath !== "") {
      resourcePath = this.resourcePath;
    } else if (this.path !== "") {
      const relativeUrl = LoaderUtils.extractUrlBase(url);
      resourcePath = LoaderUtils.resolveURL(relativeUrl, this.path);
    } else {
      resourcePath = LoaderUtils.extractUrlBase(url);
    }
    this.manager.itemStart(url);
    const _onError = function(e2) {
      if (onError) {
        onError(e2);
      } else {
        console.error(e2);
      }
      scope.manager.itemError(url);
      scope.manager.itemEnd(url);
    };
    const loader2 = new FileLoader(this.manager);
    loader2.setPath(this.path);
    loader2.setResponseType("arraybuffer");
    loader2.setRequestHeader(this.requestHeader);
    loader2.setWithCredentials(this.withCredentials);
    loader2.load(
      url,
      function(data) {
        try {
          scope.parse(
            data,
            resourcePath,
            function(gltf) {
              onLoad(gltf);
              scope.manager.itemEnd(url);
            },
            _onError
          );
        } catch (e2) {
          _onError(e2);
        }
      },
      onProgress,
      _onError
    );
  }
  setDRACOLoader(dracoLoader2) {
    this.dracoLoader = dracoLoader2;
    return this;
  }
  setDDSLoader() {
    throw new Error('THREE.GLTFLoader: "MSFT_texture_dds" no longer supported. Please update to "KHR_texture_basisu".');
  }
  setKTX2Loader(ktx2Loader) {
    this.ktx2Loader = ktx2Loader;
    return this;
  }
  setMeshoptDecoder(meshoptDecoder) {
    this.meshoptDecoder = meshoptDecoder;
    return this;
  }
  register(callback) {
    if (this.pluginCallbacks.indexOf(callback) === -1) {
      this.pluginCallbacks.push(callback);
    }
    return this;
  }
  unregister(callback) {
    if (this.pluginCallbacks.indexOf(callback) !== -1) {
      this.pluginCallbacks.splice(this.pluginCallbacks.indexOf(callback), 1);
    }
    return this;
  }
  parse(data, path, onLoad, onError) {
    let json;
    const extensions2 = {};
    const plugins = {};
    if (typeof data === "string") {
      json = JSON.parse(data);
    } else if (data instanceof ArrayBuffer) {
      const magic = decodeText(new Uint8Array(data.slice(0, 4)));
      if (magic === BINARY_EXTENSION_HEADER_MAGIC) {
        try {
          extensions2[EXTENSIONS.KHR_BINARY_GLTF] = new GLTFBinaryExtension(data);
        } catch (error) {
          if (onError)
            onError(error);
          return;
        }
        json = JSON.parse(extensions2[EXTENSIONS.KHR_BINARY_GLTF].content);
      } else {
        json = JSON.parse(decodeText(new Uint8Array(data)));
      }
    } else {
      json = data;
    }
    if (json.asset === void 0 || json.asset.version[0] < 2) {
      if (onError)
        onError(new Error("THREE.GLTFLoader: Unsupported asset. glTF versions >=2.0 are supported."));
      return;
    }
    const parser = new GLTFParser(json, {
      path: path || this.resourcePath || "",
      crossOrigin: this.crossOrigin,
      requestHeader: this.requestHeader,
      manager: this.manager,
      ktx2Loader: this.ktx2Loader,
      meshoptDecoder: this.meshoptDecoder
    });
    parser.fileLoader.setRequestHeader(this.requestHeader);
    for (let i4 = 0; i4 < this.pluginCallbacks.length; i4++) {
      const plugin = this.pluginCallbacks[i4](parser);
      if (!plugin.name)
        console.error("THREE.GLTFLoader: Invalid plugin found: missing name");
      plugins[plugin.name] = plugin;
      extensions2[plugin.name] = true;
    }
    if (json.extensionsUsed) {
      for (let i4 = 0; i4 < json.extensionsUsed.length; ++i4) {
        const extensionName = json.extensionsUsed[i4];
        const extensionsRequired = json.extensionsRequired || [];
        switch (extensionName) {
          case EXTENSIONS.KHR_MATERIALS_UNLIT:
            extensions2[extensionName] = new GLTFMaterialsUnlitExtension2();
            break;
          case EXTENSIONS.KHR_DRACO_MESH_COMPRESSION:
            extensions2[extensionName] = new GLTFDracoMeshCompressionExtension(json, this.dracoLoader);
            break;
          case EXTENSIONS.KHR_TEXTURE_TRANSFORM:
            extensions2[extensionName] = new GLTFTextureTransformExtension();
            break;
          case EXTENSIONS.KHR_MESH_QUANTIZATION:
            extensions2[extensionName] = new GLTFMeshQuantizationExtension();
            break;
          default:
            if (extensionsRequired.indexOf(extensionName) >= 0 && plugins[extensionName] === void 0) {
              console.warn('THREE.GLTFLoader: Unknown extension "' + extensionName + '".');
            }
        }
      }
    }
    parser.setExtensions(extensions2);
    parser.setPlugins(plugins);
    parser.parse(onLoad, onError);
  }
  parseAsync(data, path) {
    const scope = this;
    return new Promise(function(resolve, reject) {
      scope.parse(data, path, resolve, reject);
    });
  }
};
function GLTFRegistry() {
  let objects = {};
  return {
    get: function(key) {
      return objects[key];
    },
    add: function(key, object) {
      objects[key] = object;
    },
    remove: function(key) {
      delete objects[key];
    },
    removeAll: function() {
      objects = {};
    }
  };
}
var EXTENSIONS = {
  KHR_BINARY_GLTF: "KHR_binary_glTF",
  KHR_DRACO_MESH_COMPRESSION: "KHR_draco_mesh_compression",
  KHR_LIGHTS_PUNCTUAL: "KHR_lights_punctual",
  KHR_MATERIALS_CLEARCOAT: "KHR_materials_clearcoat",
  KHR_MATERIALS_DISPERSION: "KHR_materials_dispersion",
  KHR_MATERIALS_IOR: "KHR_materials_ior",
  KHR_MATERIALS_SHEEN: "KHR_materials_sheen",
  KHR_MATERIALS_SPECULAR: "KHR_materials_specular",
  KHR_MATERIALS_TRANSMISSION: "KHR_materials_transmission",
  KHR_MATERIALS_IRIDESCENCE: "KHR_materials_iridescence",
  KHR_MATERIALS_ANISOTROPY: "KHR_materials_anisotropy",
  KHR_MATERIALS_UNLIT: "KHR_materials_unlit",
  KHR_MATERIALS_VOLUME: "KHR_materials_volume",
  KHR_TEXTURE_BASISU: "KHR_texture_basisu",
  KHR_TEXTURE_TRANSFORM: "KHR_texture_transform",
  KHR_MESH_QUANTIZATION: "KHR_mesh_quantization",
  KHR_MATERIALS_EMISSIVE_STRENGTH: "KHR_materials_emissive_strength",
  EXT_MATERIALS_BUMP: "EXT_materials_bump",
  EXT_TEXTURE_WEBP: "EXT_texture_webp",
  EXT_TEXTURE_AVIF: "EXT_texture_avif",
  EXT_MESHOPT_COMPRESSION: "EXT_meshopt_compression",
  EXT_MESH_GPU_INSTANCING: "EXT_mesh_gpu_instancing"
};
var GLTFLightsExtension = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.KHR_LIGHTS_PUNCTUAL;
    this.cache = { refs: {}, uses: {} };
  }
  _markDefs() {
    const parser = this.parser;
    const nodeDefs = this.parser.json.nodes || [];
    for (let nodeIndex = 0, nodeLength = nodeDefs.length; nodeIndex < nodeLength; nodeIndex++) {
      const nodeDef = nodeDefs[nodeIndex];
      if (nodeDef.extensions && nodeDef.extensions[this.name] && nodeDef.extensions[this.name].light !== void 0) {
        parser._addNodeRef(this.cache, nodeDef.extensions[this.name].light);
      }
    }
  }
  _loadLight(lightIndex) {
    const parser = this.parser;
    const cacheKey = "light:" + lightIndex;
    let dependency = parser.cache.get(cacheKey);
    if (dependency)
      return dependency;
    const json = parser.json;
    const extensions2 = json.extensions && json.extensions[this.name] || {};
    const lightDefs = extensions2.lights || [];
    const lightDef = lightDefs[lightIndex];
    let lightNode;
    const color = new Color(16777215);
    if (lightDef.color !== void 0)
      color.setRGB(lightDef.color[0], lightDef.color[1], lightDef.color[2], LinearSRGBColorSpace2);
    const range = lightDef.range !== void 0 ? lightDef.range : 0;
    switch (lightDef.type) {
      case "directional":
        lightNode = new DirectionalLight(color);
        lightNode.target.position.set(0, 0, -1);
        lightNode.add(lightNode.target);
        break;
      case "point":
        lightNode = new PointLight(color);
        lightNode.distance = range;
        break;
      case "spot":
        lightNode = new SpotLight(color);
        lightNode.distance = range;
        lightDef.spot = lightDef.spot || {};
        lightDef.spot.innerConeAngle = lightDef.spot.innerConeAngle !== void 0 ? lightDef.spot.innerConeAngle : 0;
        lightDef.spot.outerConeAngle = lightDef.spot.outerConeAngle !== void 0 ? lightDef.spot.outerConeAngle : Math.PI / 4;
        lightNode.angle = lightDef.spot.outerConeAngle;
        lightNode.penumbra = 1 - lightDef.spot.innerConeAngle / lightDef.spot.outerConeAngle;
        lightNode.target.position.set(0, 0, -1);
        lightNode.add(lightNode.target);
        break;
      default:
        throw new Error("THREE.GLTFLoader: Unexpected light type: " + lightDef.type);
    }
    lightNode.position.set(0, 0, 0);
    lightNode.decay = 2;
    assignExtrasToUserData(lightNode, lightDef);
    if (lightDef.intensity !== void 0)
      lightNode.intensity = lightDef.intensity;
    lightNode.name = parser.createUniqueName(lightDef.name || "light_" + lightIndex);
    dependency = Promise.resolve(lightNode);
    parser.cache.add(cacheKey, dependency);
    return dependency;
  }
  getDependency(type, index2) {
    if (type !== "light")
      return;
    return this._loadLight(index2);
  }
  createNodeAttachment(nodeIndex) {
    const self2 = this;
    const parser = this.parser;
    const json = parser.json;
    const nodeDef = json.nodes[nodeIndex];
    const lightDef = nodeDef.extensions && nodeDef.extensions[this.name] || {};
    const lightIndex = lightDef.light;
    if (lightIndex === void 0)
      return null;
    return this._loadLight(lightIndex).then(function(light) {
      return parser._getNodeRef(self2.cache, lightIndex, light);
    });
  }
};
var GLTFMaterialsUnlitExtension2 = class {
  constructor() {
    this.name = EXTENSIONS.KHR_MATERIALS_UNLIT;
  }
  getMaterialType() {
    return MeshBasicMaterial;
  }
  extendParams(materialParams, materialDef, parser) {
    const pending = [];
    materialParams.color = new Color(1, 1, 1);
    materialParams.opacity = 1;
    const metallicRoughness = materialDef.pbrMetallicRoughness;
    if (metallicRoughness) {
      if (Array.isArray(metallicRoughness.baseColorFactor)) {
        const array = metallicRoughness.baseColorFactor;
        materialParams.color.setRGB(array[0], array[1], array[2], LinearSRGBColorSpace2);
        materialParams.opacity = array[3];
      }
      if (metallicRoughness.baseColorTexture !== void 0) {
        pending.push(parser.assignTexture(materialParams, "map", metallicRoughness.baseColorTexture, SRGBColorSpace2));
      }
    }
    return Promise.all(pending);
  }
};
var GLTFMaterialsEmissiveStrengthExtension2 = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.KHR_MATERIALS_EMISSIVE_STRENGTH;
  }
  extendMaterialParams(materialIndex, materialParams) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name]) {
      return Promise.resolve();
    }
    const emissiveStrength = materialDef.extensions[this.name].emissiveStrength;
    if (emissiveStrength !== void 0) {
      materialParams.emissiveIntensity = emissiveStrength;
    }
    return Promise.resolve();
  }
};
var GLTFMaterialsClearcoatExtension2 = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.KHR_MATERIALS_CLEARCOAT;
  }
  getMaterialType(materialIndex) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name])
      return null;
    return MeshPhysicalMaterial;
  }
  extendMaterialParams(materialIndex, materialParams) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name]) {
      return Promise.resolve();
    }
    const pending = [];
    const extension = materialDef.extensions[this.name];
    if (extension.clearcoatFactor !== void 0) {
      materialParams.clearcoat = extension.clearcoatFactor;
    }
    if (extension.clearcoatTexture !== void 0) {
      pending.push(parser.assignTexture(materialParams, "clearcoatMap", extension.clearcoatTexture));
    }
    if (extension.clearcoatRoughnessFactor !== void 0) {
      materialParams.clearcoatRoughness = extension.clearcoatRoughnessFactor;
    }
    if (extension.clearcoatRoughnessTexture !== void 0) {
      pending.push(parser.assignTexture(materialParams, "clearcoatRoughnessMap", extension.clearcoatRoughnessTexture));
    }
    if (extension.clearcoatNormalTexture !== void 0) {
      pending.push(parser.assignTexture(materialParams, "clearcoatNormalMap", extension.clearcoatNormalTexture));
      if (extension.clearcoatNormalTexture.scale !== void 0) {
        const scale5 = extension.clearcoatNormalTexture.scale;
        materialParams.clearcoatNormalScale = new Vector2(scale5, scale5);
      }
    }
    return Promise.all(pending);
  }
};
var GLTFMaterialsDispersionExtension = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.KHR_MATERIALS_DISPERSION;
  }
  getMaterialType(materialIndex) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name])
      return null;
    return MeshPhysicalMaterial;
  }
  extendMaterialParams(materialIndex, materialParams) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name]) {
      return Promise.resolve();
    }
    const extension = materialDef.extensions[this.name];
    materialParams.dispersion = extension.dispersion !== void 0 ? extension.dispersion : 0;
    return Promise.resolve();
  }
};
var GLTFMaterialsIridescenceExtension2 = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.KHR_MATERIALS_IRIDESCENCE;
  }
  getMaterialType(materialIndex) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name])
      return null;
    return MeshPhysicalMaterial;
  }
  extendMaterialParams(materialIndex, materialParams) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name]) {
      return Promise.resolve();
    }
    const pending = [];
    const extension = materialDef.extensions[this.name];
    if (extension.iridescenceFactor !== void 0) {
      materialParams.iridescence = extension.iridescenceFactor;
    }
    if (extension.iridescenceTexture !== void 0) {
      pending.push(parser.assignTexture(materialParams, "iridescenceMap", extension.iridescenceTexture));
    }
    if (extension.iridescenceIor !== void 0) {
      materialParams.iridescenceIOR = extension.iridescenceIor;
    }
    if (materialParams.iridescenceThicknessRange === void 0) {
      materialParams.iridescenceThicknessRange = [100, 400];
    }
    if (extension.iridescenceThicknessMinimum !== void 0) {
      materialParams.iridescenceThicknessRange[0] = extension.iridescenceThicknessMinimum;
    }
    if (extension.iridescenceThicknessMaximum !== void 0) {
      materialParams.iridescenceThicknessRange[1] = extension.iridescenceThicknessMaximum;
    }
    if (extension.iridescenceThicknessTexture !== void 0) {
      pending.push(
        parser.assignTexture(materialParams, "iridescenceThicknessMap", extension.iridescenceThicknessTexture)
      );
    }
    return Promise.all(pending);
  }
};
var GLTFMaterialsSheenExtension2 = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.KHR_MATERIALS_SHEEN;
  }
  getMaterialType(materialIndex) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name])
      return null;
    return MeshPhysicalMaterial;
  }
  extendMaterialParams(materialIndex, materialParams) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name]) {
      return Promise.resolve();
    }
    const pending = [];
    materialParams.sheenColor = new Color(0, 0, 0);
    materialParams.sheenRoughness = 0;
    materialParams.sheen = 1;
    const extension = materialDef.extensions[this.name];
    if (extension.sheenColorFactor !== void 0) {
      const colorFactor = extension.sheenColorFactor;
      materialParams.sheenColor.setRGB(colorFactor[0], colorFactor[1], colorFactor[2], LinearSRGBColorSpace2);
    }
    if (extension.sheenRoughnessFactor !== void 0) {
      materialParams.sheenRoughness = extension.sheenRoughnessFactor;
    }
    if (extension.sheenColorTexture !== void 0) {
      pending.push(parser.assignTexture(materialParams, "sheenColorMap", extension.sheenColorTexture, SRGBColorSpace2));
    }
    if (extension.sheenRoughnessTexture !== void 0) {
      pending.push(parser.assignTexture(materialParams, "sheenRoughnessMap", extension.sheenRoughnessTexture));
    }
    return Promise.all(pending);
  }
};
var GLTFMaterialsTransmissionExtension2 = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.KHR_MATERIALS_TRANSMISSION;
  }
  getMaterialType(materialIndex) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name])
      return null;
    return MeshPhysicalMaterial;
  }
  extendMaterialParams(materialIndex, materialParams) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name]) {
      return Promise.resolve();
    }
    const pending = [];
    const extension = materialDef.extensions[this.name];
    if (extension.transmissionFactor !== void 0) {
      materialParams.transmission = extension.transmissionFactor;
    }
    if (extension.transmissionTexture !== void 0) {
      pending.push(parser.assignTexture(materialParams, "transmissionMap", extension.transmissionTexture));
    }
    return Promise.all(pending);
  }
};
var GLTFMaterialsVolumeExtension2 = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.KHR_MATERIALS_VOLUME;
  }
  getMaterialType(materialIndex) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name])
      return null;
    return MeshPhysicalMaterial;
  }
  extendMaterialParams(materialIndex, materialParams) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name]) {
      return Promise.resolve();
    }
    const pending = [];
    const extension = materialDef.extensions[this.name];
    materialParams.thickness = extension.thicknessFactor !== void 0 ? extension.thicknessFactor : 0;
    if (extension.thicknessTexture !== void 0) {
      pending.push(parser.assignTexture(materialParams, "thicknessMap", extension.thicknessTexture));
    }
    materialParams.attenuationDistance = extension.attenuationDistance || Infinity;
    const colorArray = extension.attenuationColor || [1, 1, 1];
    materialParams.attenuationColor = new Color().setRGB(
      colorArray[0],
      colorArray[1],
      colorArray[2],
      LinearSRGBColorSpace2
    );
    return Promise.all(pending);
  }
};
var GLTFMaterialsIorExtension2 = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.KHR_MATERIALS_IOR;
  }
  getMaterialType(materialIndex) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name])
      return null;
    return MeshPhysicalMaterial;
  }
  extendMaterialParams(materialIndex, materialParams) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name]) {
      return Promise.resolve();
    }
    const extension = materialDef.extensions[this.name];
    materialParams.ior = extension.ior !== void 0 ? extension.ior : 1.5;
    return Promise.resolve();
  }
};
var GLTFMaterialsSpecularExtension2 = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.KHR_MATERIALS_SPECULAR;
  }
  getMaterialType(materialIndex) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name])
      return null;
    return MeshPhysicalMaterial;
  }
  extendMaterialParams(materialIndex, materialParams) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name]) {
      return Promise.resolve();
    }
    const pending = [];
    const extension = materialDef.extensions[this.name];
    materialParams.specularIntensity = extension.specularFactor !== void 0 ? extension.specularFactor : 1;
    if (extension.specularTexture !== void 0) {
      pending.push(parser.assignTexture(materialParams, "specularIntensityMap", extension.specularTexture));
    }
    const colorArray = extension.specularColorFactor || [1, 1, 1];
    materialParams.specularColor = new Color().setRGB(colorArray[0], colorArray[1], colorArray[2], LinearSRGBColorSpace2);
    if (extension.specularColorTexture !== void 0) {
      pending.push(
        parser.assignTexture(materialParams, "specularColorMap", extension.specularColorTexture, SRGBColorSpace2)
      );
    }
    return Promise.all(pending);
  }
};
var GLTFMaterialsBumpExtension = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.EXT_MATERIALS_BUMP;
  }
  getMaterialType(materialIndex) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name])
      return null;
    return MeshPhysicalMaterial;
  }
  extendMaterialParams(materialIndex, materialParams) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name]) {
      return Promise.resolve();
    }
    const pending = [];
    const extension = materialDef.extensions[this.name];
    materialParams.bumpScale = extension.bumpFactor !== void 0 ? extension.bumpFactor : 1;
    if (extension.bumpTexture !== void 0) {
      pending.push(parser.assignTexture(materialParams, "bumpMap", extension.bumpTexture));
    }
    return Promise.all(pending);
  }
};
var GLTFMaterialsAnisotropyExtension2 = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.KHR_MATERIALS_ANISOTROPY;
  }
  getMaterialType(materialIndex) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name])
      return null;
    return MeshPhysicalMaterial;
  }
  extendMaterialParams(materialIndex, materialParams) {
    const parser = this.parser;
    const materialDef = parser.json.materials[materialIndex];
    if (!materialDef.extensions || !materialDef.extensions[this.name]) {
      return Promise.resolve();
    }
    const pending = [];
    const extension = materialDef.extensions[this.name];
    if (extension.anisotropyStrength !== void 0) {
      materialParams.anisotropy = extension.anisotropyStrength;
    }
    if (extension.anisotropyRotation !== void 0) {
      materialParams.anisotropyRotation = extension.anisotropyRotation;
    }
    if (extension.anisotropyTexture !== void 0) {
      pending.push(parser.assignTexture(materialParams, "anisotropyMap", extension.anisotropyTexture));
    }
    return Promise.all(pending);
  }
};
var GLTFTextureBasisUExtension = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.KHR_TEXTURE_BASISU;
  }
  loadTexture(textureIndex) {
    const parser = this.parser;
    const json = parser.json;
    const textureDef = json.textures[textureIndex];
    if (!textureDef.extensions || !textureDef.extensions[this.name]) {
      return null;
    }
    const extension = textureDef.extensions[this.name];
    const loader2 = parser.options.ktx2Loader;
    if (!loader2) {
      if (json.extensionsRequired && json.extensionsRequired.indexOf(this.name) >= 0) {
        throw new Error("THREE.GLTFLoader: setKTX2Loader must be called before loading KTX2 textures");
      } else {
        return null;
      }
    }
    return parser.loadTextureImage(textureIndex, extension.source, loader2);
  }
};
var GLTFTextureWebPExtension = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.EXT_TEXTURE_WEBP;
    this.isSupported = null;
  }
  loadTexture(textureIndex) {
    const name = this.name;
    const parser = this.parser;
    const json = parser.json;
    const textureDef = json.textures[textureIndex];
    if (!textureDef.extensions || !textureDef.extensions[name]) {
      return null;
    }
    const extension = textureDef.extensions[name];
    const source = json.images[extension.source];
    let loader2 = parser.textureLoader;
    if (source.uri) {
      const handler = parser.options.manager.getHandler(source.uri);
      if (handler !== null)
        loader2 = handler;
    }
    return this.detectSupport().then(function(isSupported) {
      if (isSupported)
        return parser.loadTextureImage(textureIndex, extension.source, loader2);
      if (json.extensionsRequired && json.extensionsRequired.indexOf(name) >= 0) {
        throw new Error("THREE.GLTFLoader: WebP required by asset but unsupported.");
      }
      return parser.loadTexture(textureIndex);
    });
  }
  detectSupport() {
    if (!this.isSupported) {
      this.isSupported = new Promise(function(resolve) {
        const image = new Image();
        image.src = "data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA";
        image.onload = image.onerror = function() {
          resolve(image.height === 1);
        };
      });
    }
    return this.isSupported;
  }
};
var GLTFTextureAVIFExtension = class {
  constructor(parser) {
    this.parser = parser;
    this.name = EXTENSIONS.EXT_TEXTURE_AVIF;
    this.isSupported = null;
  }
  loadTexture(textureIndex) {
    const name = this.name;
    const parser = this.parser;
    const json = parser.json;
    const textureDef = json.textures[textureIndex];
    if (!textureDef.extensions || !textureDef.extensions[name]) {
      return null;
    }
    const extension = textureDef.extensions[name];
    const source = json.images[extension.source];
    let loader2 = parser.textureLoader;
    if (source.uri) {
      const handler = parser.options.manager.getHandler(source.uri);
      if (handler !== null)
        loader2 = handler;
    }
    return this.detectSupport().then(function(isSupported) {
      if (isSupported)
        return parser.loadTextureImage(textureIndex, extension.source, loader2);
      if (json.extensionsRequired && json.extensionsRequired.indexOf(name) >= 0) {
        throw new Error("THREE.GLTFLoader: AVIF required by asset but unsupported.");
      }
      return parser.loadTexture(textureIndex);
    });
  }
  detectSupport() {
    if (!this.isSupported) {
      this.isSupported = new Promise(function(resolve) {
        const image = new Image();
        image.src = "data:image/avif;base64,AAAAIGZ0eXBhdmlmAAAAAGF2aWZtaWYxbWlhZk1BMUIAAADybWV0YQAAAAAAAAAoaGRscgAAAAAAAAAAcGljdAAAAAAAAAAAAAAAAGxpYmF2aWYAAAAADnBpdG0AAAAAAAEAAAAeaWxvYwAAAABEAAABAAEAAAABAAABGgAAABcAAAAoaWluZgAAAAAAAQAAABppbmZlAgAAAAABAABhdjAxQ29sb3IAAAAAamlwcnAAAABLaXBjbwAAABRpc3BlAAAAAAAAAAEAAAABAAAAEHBpeGkAAAAAAwgICAAAAAxhdjFDgQAMAAAAABNjb2xybmNseAACAAIABoAAAAAXaXBtYQAAAAAAAAABAAEEAQKDBAAAAB9tZGF0EgAKCBgABogQEDQgMgkQAAAAB8dSLfI=";
        image.onload = image.onerror = function() {
          resolve(image.height === 1);
        };
      });
    }
    return this.isSupported;
  }
};
var GLTFMeshoptCompression = class {
  constructor(parser) {
    this.name = EXTENSIONS.EXT_MESHOPT_COMPRESSION;
    this.parser = parser;
  }
  loadBufferView(index2) {
    const json = this.parser.json;
    const bufferView = json.bufferViews[index2];
    if (bufferView.extensions && bufferView.extensions[this.name]) {
      const extensionDef = bufferView.extensions[this.name];
      const buffer2 = this.parser.getDependency("buffer", extensionDef.buffer);
      const decoder = this.parser.options.meshoptDecoder;
      if (!decoder || !decoder.supported) {
        if (json.extensionsRequired && json.extensionsRequired.indexOf(this.name) >= 0) {
          throw new Error("THREE.GLTFLoader: setMeshoptDecoder must be called before loading compressed files");
        } else {
          return null;
        }
      }
      return buffer2.then(function(res) {
        const byteOffset = extensionDef.byteOffset || 0;
        const byteLength = extensionDef.byteLength || 0;
        const count = extensionDef.count;
        const stride = extensionDef.byteStride;
        const source = new Uint8Array(res, byteOffset, byteLength);
        if (decoder.decodeGltfBufferAsync) {
          return decoder.decodeGltfBufferAsync(count, stride, source, extensionDef.mode, extensionDef.filter).then(function(res2) {
            return res2.buffer;
          });
        } else {
          return decoder.ready.then(function() {
            const result = new ArrayBuffer(count * stride);
            decoder.decodeGltfBuffer(
              new Uint8Array(result),
              count,
              stride,
              source,
              extensionDef.mode,
              extensionDef.filter
            );
            return result;
          });
        }
      });
    } else {
      return null;
    }
  }
};
var GLTFMeshGpuInstancing = class {
  constructor(parser) {
    this.name = EXTENSIONS.EXT_MESH_GPU_INSTANCING;
    this.parser = parser;
  }
  createNodeMesh(nodeIndex) {
    const json = this.parser.json;
    const nodeDef = json.nodes[nodeIndex];
    if (!nodeDef.extensions || !nodeDef.extensions[this.name] || nodeDef.mesh === void 0) {
      return null;
    }
    const meshDef = json.meshes[nodeDef.mesh];
    for (const primitive of meshDef.primitives) {
      if (primitive.mode !== WEBGL_CONSTANTS2.TRIANGLES && primitive.mode !== WEBGL_CONSTANTS2.TRIANGLE_STRIP && primitive.mode !== WEBGL_CONSTANTS2.TRIANGLE_FAN && primitive.mode !== void 0) {
        return null;
      }
    }
    const extensionDef = nodeDef.extensions[this.name];
    const attributesDef = extensionDef.attributes;
    const pending = [];
    const attributes = {};
    for (const key in attributesDef) {
      pending.push(
        this.parser.getDependency("accessor", attributesDef[key]).then((accessor) => {
          attributes[key] = accessor;
          return attributes[key];
        })
      );
    }
    if (pending.length < 1) {
      return null;
    }
    pending.push(this.parser.createNodeMesh(nodeIndex));
    return Promise.all(pending).then((results) => {
      const nodeObject = results.pop();
      const meshes = nodeObject.isGroup ? nodeObject.children : [nodeObject];
      const count = results[0].count;
      const instancedMeshes = [];
      for (const mesh of meshes) {
        const m = new Matrix4();
        const p2 = new Vector3();
        const q = new Quaternion();
        const s2 = new Vector3(1, 1, 1);
        const instancedMesh = new InstancedMesh(mesh.geometry, mesh.material, count);
        for (let i4 = 0; i4 < count; i4++) {
          if (attributes.TRANSLATION) {
            p2.fromBufferAttribute(attributes.TRANSLATION, i4);
          }
          if (attributes.ROTATION) {
            q.fromBufferAttribute(attributes.ROTATION, i4);
          }
          if (attributes.SCALE) {
            s2.fromBufferAttribute(attributes.SCALE, i4);
          }
          instancedMesh.setMatrixAt(i4, m.compose(p2, q, s2));
        }
        for (const attributeName in attributes) {
          if (attributeName === "_COLOR_0") {
            const attr = attributes[attributeName];
            instancedMesh.instanceColor = new InstancedBufferAttribute(attr.array, attr.itemSize, attr.normalized);
          } else if (attributeName !== "TRANSLATION" && attributeName !== "ROTATION" && attributeName !== "SCALE") {
            mesh.geometry.setAttribute(attributeName, attributes[attributeName]);
          }
        }
        Object3D.prototype.copy.call(instancedMesh, mesh);
        this.parser.assignFinalMaterial(instancedMesh);
        instancedMeshes.push(instancedMesh);
      }
      if (nodeObject.isGroup) {
        nodeObject.clear();
        nodeObject.add(...instancedMeshes);
        return nodeObject;
      }
      return instancedMeshes[0];
    });
  }
};
var BINARY_EXTENSION_HEADER_MAGIC = "glTF";
var BINARY_EXTENSION_HEADER_LENGTH = 12;
var BINARY_EXTENSION_CHUNK_TYPES = { JSON: 1313821514, BIN: 5130562 };
var GLTFBinaryExtension = class {
  constructor(data) {
    this.name = EXTENSIONS.KHR_BINARY_GLTF;
    this.content = null;
    this.body = null;
    const headerView = new DataView(data, 0, BINARY_EXTENSION_HEADER_LENGTH);
    this.header = {
      magic: decodeText(new Uint8Array(data.slice(0, 4))),
      version: headerView.getUint32(4, true),
      length: headerView.getUint32(8, true)
    };
    if (this.header.magic !== BINARY_EXTENSION_HEADER_MAGIC) {
      throw new Error("THREE.GLTFLoader: Unsupported glTF-Binary header.");
    } else if (this.header.version < 2) {
      throw new Error("THREE.GLTFLoader: Legacy binary file detected.");
    }
    const chunkContentsLength = this.header.length - BINARY_EXTENSION_HEADER_LENGTH;
    const chunkView = new DataView(data, BINARY_EXTENSION_HEADER_LENGTH);
    let chunkIndex = 0;
    while (chunkIndex < chunkContentsLength) {
      const chunkLength = chunkView.getUint32(chunkIndex, true);
      chunkIndex += 4;
      const chunkType = chunkView.getUint32(chunkIndex, true);
      chunkIndex += 4;
      if (chunkType === BINARY_EXTENSION_CHUNK_TYPES.JSON) {
        const contentArray = new Uint8Array(data, BINARY_EXTENSION_HEADER_LENGTH + chunkIndex, chunkLength);
        this.content = decodeText(contentArray);
      } else if (chunkType === BINARY_EXTENSION_CHUNK_TYPES.BIN) {
        const byteOffset = BINARY_EXTENSION_HEADER_LENGTH + chunkIndex;
        this.body = data.slice(byteOffset, byteOffset + chunkLength);
      }
      chunkIndex += chunkLength;
    }
    if (this.content === null) {
      throw new Error("THREE.GLTFLoader: JSON content not found.");
    }
  }
};
var GLTFDracoMeshCompressionExtension = class {
  constructor(json, dracoLoader2) {
    if (!dracoLoader2) {
      throw new Error("THREE.GLTFLoader: No DRACOLoader instance provided.");
    }
    this.name = EXTENSIONS.KHR_DRACO_MESH_COMPRESSION;
    this.json = json;
    this.dracoLoader = dracoLoader2;
    this.dracoLoader.preload();
  }
  decodePrimitive(primitive, parser) {
    const json = this.json;
    const dracoLoader2 = this.dracoLoader;
    const bufferViewIndex = primitive.extensions[this.name].bufferView;
    const gltfAttributeMap = primitive.extensions[this.name].attributes;
    const threeAttributeMap = {};
    const attributeNormalizedMap = {};
    const attributeTypeMap = {};
    for (const attributeName in gltfAttributeMap) {
      const threeAttributeName = ATTRIBUTES[attributeName] || attributeName.toLowerCase();
      threeAttributeMap[threeAttributeName] = gltfAttributeMap[attributeName];
    }
    for (const attributeName in primitive.attributes) {
      const threeAttributeName = ATTRIBUTES[attributeName] || attributeName.toLowerCase();
      if (gltfAttributeMap[attributeName] !== void 0) {
        const accessorDef = json.accessors[primitive.attributes[attributeName]];
        const componentType = WEBGL_COMPONENT_TYPES[accessorDef.componentType];
        attributeTypeMap[threeAttributeName] = componentType.name;
        attributeNormalizedMap[threeAttributeName] = accessorDef.normalized === true;
      }
    }
    return parser.getDependency("bufferView", bufferViewIndex).then(function(bufferView) {
      return new Promise(function(resolve, reject) {
        dracoLoader2.decodeDracoFile(
          bufferView,
          function(geometry3) {
            for (const attributeName in geometry3.attributes) {
              const attribute = geometry3.attributes[attributeName];
              const normalized = attributeNormalizedMap[attributeName];
              if (normalized !== void 0)
                attribute.normalized = normalized;
            }
            resolve(geometry3);
          },
          threeAttributeMap,
          attributeTypeMap,
          LinearSRGBColorSpace2,
          reject
        );
      });
    });
  }
};
var GLTFTextureTransformExtension = class {
  constructor() {
    this.name = EXTENSIONS.KHR_TEXTURE_TRANSFORM;
  }
  extendTexture(texture, transform) {
    if ((transform.texCoord === void 0 || transform.texCoord === texture.channel) && transform.offset === void 0 && transform.rotation === void 0 && transform.scale === void 0) {
      return texture;
    }
    texture = texture.clone();
    if (transform.texCoord !== void 0) {
      texture.channel = transform.texCoord;
    }
    if (transform.offset !== void 0) {
      texture.offset.fromArray(transform.offset);
    }
    if (transform.rotation !== void 0) {
      texture.rotation = transform.rotation;
    }
    if (transform.scale !== void 0) {
      texture.repeat.fromArray(transform.scale);
    }
    texture.needsUpdate = true;
    return texture;
  }
};
var GLTFMeshQuantizationExtension = class {
  constructor() {
    this.name = EXTENSIONS.KHR_MESH_QUANTIZATION;
  }
};
var GLTFCubicSplineInterpolant = class extends Interpolant {
  constructor(parameterPositions, sampleValues, sampleSize, resultBuffer) {
    super(parameterPositions, sampleValues, sampleSize, resultBuffer);
  }
  copySampleValue_(index2) {
    const result = this.resultBuffer, values = this.sampleValues, valueSize = this.valueSize, offset = index2 * valueSize * 3 + valueSize;
    for (let i4 = 0; i4 !== valueSize; i4++) {
      result[i4] = values[offset + i4];
    }
    return result;
  }
  interpolate_(i1, t0, t3, t1) {
    const result = this.resultBuffer;
    const values = this.sampleValues;
    const stride = this.valueSize;
    const stride2 = stride * 2;
    const stride3 = stride * 3;
    const td2 = t1 - t0;
    const p2 = (t3 - t0) / td2;
    const pp = p2 * p2;
    const ppp = pp * p2;
    const offset1 = i1 * stride3;
    const offset0 = offset1 - stride3;
    const s2 = -2 * ppp + 3 * pp;
    const s3 = ppp - pp;
    const s0 = 1 - s2;
    const s1 = s3 - pp + p2;
    for (let i4 = 0; i4 !== stride; i4++) {
      const p0 = values[offset0 + i4 + stride];
      const m0 = values[offset0 + i4 + stride2] * td2;
      const p1 = values[offset1 + i4 + stride];
      const m1 = values[offset1 + i4] * td2;
      result[i4] = s0 * p0 + s1 * m0 + s2 * p1 + s3 * m1;
    }
    return result;
  }
};
var _q4 = new Quaternion();
var GLTFCubicSplineQuaternionInterpolant = class extends GLTFCubicSplineInterpolant {
  interpolate_(i1, t0, t3, t1) {
    const result = super.interpolate_(i1, t0, t3, t1);
    _q4.fromArray(result).normalize().toArray(result);
    return result;
  }
};
var WEBGL_CONSTANTS2 = {
  FLOAT: 5126,
  //FLOAT_MAT2: 35674,
  FLOAT_MAT3: 35675,
  FLOAT_MAT4: 35676,
  FLOAT_VEC2: 35664,
  FLOAT_VEC3: 35665,
  FLOAT_VEC4: 35666,
  LINEAR: 9729,
  REPEAT: 10497,
  SAMPLER_2D: 35678,
  POINTS: 0,
  LINES: 1,
  LINE_LOOP: 2,
  LINE_STRIP: 3,
  TRIANGLES: 4,
  TRIANGLE_STRIP: 5,
  TRIANGLE_FAN: 6,
  UNSIGNED_BYTE: 5121,
  UNSIGNED_SHORT: 5123
};
var WEBGL_COMPONENT_TYPES = {
  5120: Int8Array,
  5121: Uint8Array,
  5122: Int16Array,
  5123: Uint16Array,
  5125: Uint32Array,
  5126: Float32Array
};
var WEBGL_FILTERS = {
  9728: NearestFilter,
  9729: LinearFilter,
  9984: NearestMipmapNearestFilter,
  9985: LinearMipmapNearestFilter,
  9986: NearestMipmapLinearFilter,
  9987: LinearMipmapLinearFilter
};
var WEBGL_WRAPPINGS = {
  33071: ClampToEdgeWrapping,
  33648: MirroredRepeatWrapping,
  10497: RepeatWrapping
};
var WEBGL_TYPE_SIZES = {
  SCALAR: 1,
  VEC2: 2,
  VEC3: 3,
  VEC4: 4,
  MAT2: 4,
  MAT3: 9,
  MAT4: 16
};
var ATTRIBUTES = {
  POSITION: "position",
  NORMAL: "normal",
  TANGENT: "tangent",
  // uv => uv1, 4 uv channels
  // https://github.com/mrdoob/three.js/pull/25943
  // https://github.com/mrdoob/three.js/pull/25788
  ...version >= 152 ? {
    TEXCOORD_0: "uv",
    TEXCOORD_1: "uv1",
    TEXCOORD_2: "uv2",
    TEXCOORD_3: "uv3"
  } : {
    TEXCOORD_0: "uv",
    TEXCOORD_1: "uv2"
  },
  COLOR_0: "color",
  WEIGHTS_0: "skinWeight",
  JOINTS_0: "skinIndex"
};
var PATH_PROPERTIES2 = {
  scale: "scale",
  translation: "position",
  rotation: "quaternion",
  weights: "morphTargetInfluences"
};
var INTERPOLATION = {
  CUBICSPLINE: void 0,
  // We use a custom interpolant (GLTFCubicSplineInterpolation) for CUBICSPLINE tracks. Each
  // keyframe track will be initialized with a default interpolation type, then modified.
  LINEAR: InterpolateLinear,
  STEP: InterpolateDiscrete
};
var ALPHA_MODES = {
  OPAQUE: "OPAQUE",
  MASK: "MASK",
  BLEND: "BLEND"
};
function createDefaultMaterial(cache) {
  if (cache["DefaultMaterial"] === void 0) {
    cache["DefaultMaterial"] = new MeshStandardMaterial({
      color: 16777215,
      emissive: 0,
      metalness: 1,
      roughness: 1,
      transparent: false,
      depthTest: true,
      side: FrontSide
    });
  }
  return cache["DefaultMaterial"];
}
function addUnknownExtensionsToUserData(knownExtensions, object, objectDef) {
  for (const name in objectDef.extensions) {
    if (knownExtensions[name] === void 0) {
      object.userData.gltfExtensions = object.userData.gltfExtensions || {};
      object.userData.gltfExtensions[name] = objectDef.extensions[name];
    }
  }
}
function assignExtrasToUserData(object, gltfDef) {
  if (gltfDef.extras !== void 0) {
    if (typeof gltfDef.extras === "object") {
      Object.assign(object.userData, gltfDef.extras);
    } else {
      console.warn("THREE.GLTFLoader: Ignoring primitive type .extras, " + gltfDef.extras);
    }
  }
}
function addMorphTargets(geometry3, targets, parser) {
  let hasMorphPosition = false;
  let hasMorphNormal = false;
  let hasMorphColor = false;
  for (let i4 = 0, il = targets.length; i4 < il; i4++) {
    const target2 = targets[i4];
    if (target2.POSITION !== void 0)
      hasMorphPosition = true;
    if (target2.NORMAL !== void 0)
      hasMorphNormal = true;
    if (target2.COLOR_0 !== void 0)
      hasMorphColor = true;
    if (hasMorphPosition && hasMorphNormal && hasMorphColor)
      break;
  }
  if (!hasMorphPosition && !hasMorphNormal && !hasMorphColor)
    return Promise.resolve(geometry3);
  const pendingPositionAccessors = [];
  const pendingNormalAccessors = [];
  const pendingColorAccessors = [];
  for (let i4 = 0, il = targets.length; i4 < il; i4++) {
    const target2 = targets[i4];
    if (hasMorphPosition) {
      const pendingAccessor = target2.POSITION !== void 0 ? parser.getDependency("accessor", target2.POSITION) : geometry3.attributes.position;
      pendingPositionAccessors.push(pendingAccessor);
    }
    if (hasMorphNormal) {
      const pendingAccessor = target2.NORMAL !== void 0 ? parser.getDependency("accessor", target2.NORMAL) : geometry3.attributes.normal;
      pendingNormalAccessors.push(pendingAccessor);
    }
    if (hasMorphColor) {
      const pendingAccessor = target2.COLOR_0 !== void 0 ? parser.getDependency("accessor", target2.COLOR_0) : geometry3.attributes.color;
      pendingColorAccessors.push(pendingAccessor);
    }
  }
  return Promise.all([
    Promise.all(pendingPositionAccessors),
    Promise.all(pendingNormalAccessors),
    Promise.all(pendingColorAccessors)
  ]).then(function(accessors) {
    const morphPositions = accessors[0];
    const morphNormals = accessors[1];
    const morphColors = accessors[2];
    if (hasMorphPosition)
      geometry3.morphAttributes.position = morphPositions;
    if (hasMorphNormal)
      geometry3.morphAttributes.normal = morphNormals;
    if (hasMorphColor)
      geometry3.morphAttributes.color = morphColors;
    geometry3.morphTargetsRelative = true;
    return geometry3;
  });
}
function updateMorphTargets(mesh, meshDef) {
  mesh.updateMorphTargets();
  if (meshDef.weights !== void 0) {
    for (let i4 = 0, il = meshDef.weights.length; i4 < il; i4++) {
      mesh.morphTargetInfluences[i4] = meshDef.weights[i4];
    }
  }
  if (meshDef.extras && Array.isArray(meshDef.extras.targetNames)) {
    const targetNames = meshDef.extras.targetNames;
    if (mesh.morphTargetInfluences.length === targetNames.length) {
      mesh.morphTargetDictionary = {};
      for (let i4 = 0, il = targetNames.length; i4 < il; i4++) {
        mesh.morphTargetDictionary[targetNames[i4]] = i4;
      }
    } else {
      console.warn("THREE.GLTFLoader: Invalid extras.targetNames length. Ignoring names.");
    }
  }
}
function createPrimitiveKey(primitiveDef) {
  let geometryKey;
  const dracoExtension = primitiveDef.extensions && primitiveDef.extensions[EXTENSIONS.KHR_DRACO_MESH_COMPRESSION];
  if (dracoExtension) {
    geometryKey = "draco:" + dracoExtension.bufferView + ":" + dracoExtension.indices + ":" + createAttributesKey(dracoExtension.attributes);
  } else {
    geometryKey = primitiveDef.indices + ":" + createAttributesKey(primitiveDef.attributes) + ":" + primitiveDef.mode;
  }
  if (primitiveDef.targets !== void 0) {
    for (let i4 = 0, il = primitiveDef.targets.length; i4 < il; i4++) {
      geometryKey += ":" + createAttributesKey(primitiveDef.targets[i4]);
    }
  }
  return geometryKey;
}
function createAttributesKey(attributes) {
  let attributesKey = "";
  const keys = Object.keys(attributes).sort();
  for (let i4 = 0, il = keys.length; i4 < il; i4++) {
    attributesKey += keys[i4] + ":" + attributes[keys[i4]] + ";";
  }
  return attributesKey;
}
function getNormalizedComponentScale(constructor) {
  switch (constructor) {
    case Int8Array:
      return 1 / 127;
    case Uint8Array:
      return 1 / 255;
    case Int16Array:
      return 1 / 32767;
    case Uint16Array:
      return 1 / 65535;
    default:
      throw new Error("THREE.GLTFLoader: Unsupported normalized accessor component type.");
  }
}
function getImageURIMimeType(uri) {
  if (uri.search(/\.jpe?g($|\?)/i) > 0 || uri.search(/^data\:image\/jpeg/) === 0)
    return "image/jpeg";
  if (uri.search(/\.webp($|\?)/i) > 0 || uri.search(/^data\:image\/webp/) === 0)
    return "image/webp";
  return "image/png";
}
var _identityMatrix2 = new Matrix4();
var GLTFParser = class {
  constructor(json = {}, options = {}) {
    this.json = json;
    this.extensions = {};
    this.plugins = {};
    this.options = options;
    this.cache = new GLTFRegistry();
    this.associations = /* @__PURE__ */ new Map();
    this.primitiveCache = {};
    this.nodeCache = {};
    this.meshCache = { refs: {}, uses: {} };
    this.cameraCache = { refs: {}, uses: {} };
    this.lightCache = { refs: {}, uses: {} };
    this.sourceCache = {};
    this.textureCache = {};
    this.nodeNamesUsed = {};
    let isSafari = false;
    let isFirefox = false;
    let firefoxVersion = -1;
    if (typeof navigator !== "undefined" && typeof navigator.userAgent !== "undefined") {
      isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent) === true;
      isFirefox = navigator.userAgent.indexOf("Firefox") > -1;
      firefoxVersion = isFirefox ? navigator.userAgent.match(/Firefox\/([0-9]+)\./)[1] : -1;
    }
    if (typeof createImageBitmap === "undefined" || isSafari || isFirefox && firefoxVersion < 98) {
      this.textureLoader = new TextureLoader(this.options.manager);
    } else {
      this.textureLoader = new ImageBitmapLoader(this.options.manager);
    }
    this.textureLoader.setCrossOrigin(this.options.crossOrigin);
    this.textureLoader.setRequestHeader(this.options.requestHeader);
    this.fileLoader = new FileLoader(this.options.manager);
    this.fileLoader.setResponseType("arraybuffer");
    if (this.options.crossOrigin === "use-credentials") {
      this.fileLoader.setWithCredentials(true);
    }
  }
  setExtensions(extensions2) {
    this.extensions = extensions2;
  }
  setPlugins(plugins) {
    this.plugins = plugins;
  }
  parse(onLoad, onError) {
    const parser = this;
    const json = this.json;
    const extensions2 = this.extensions;
    this.cache.removeAll();
    this.nodeCache = {};
    this._invokeAll(function(ext) {
      return ext._markDefs && ext._markDefs();
    });
    Promise.all(
      this._invokeAll(function(ext) {
        return ext.beforeRoot && ext.beforeRoot();
      })
    ).then(function() {
      return Promise.all([
        parser.getDependencies("scene"),
        parser.getDependencies("animation"),
        parser.getDependencies("camera")
      ]);
    }).then(function(dependencies) {
      const result = {
        scene: dependencies[0][json.scene || 0],
        scenes: dependencies[0],
        animations: dependencies[1],
        cameras: dependencies[2],
        asset: json.asset,
        parser,
        userData: {}
      };
      addUnknownExtensionsToUserData(extensions2, result, json);
      assignExtrasToUserData(result, json);
      return Promise.all(
        parser._invokeAll(function(ext) {
          return ext.afterRoot && ext.afterRoot(result);
        })
      ).then(function() {
        for (const scene of result.scenes) {
          scene.updateMatrixWorld();
        }
        onLoad(result);
      });
    }).catch(onError);
  }
  /**
   * Marks the special nodes/meshes in json for efficient parse.
   */
  _markDefs() {
    const nodeDefs = this.json.nodes || [];
    const skinDefs = this.json.skins || [];
    const meshDefs = this.json.meshes || [];
    for (let skinIndex = 0, skinLength = skinDefs.length; skinIndex < skinLength; skinIndex++) {
      const joints = skinDefs[skinIndex].joints;
      for (let i4 = 0, il = joints.length; i4 < il; i4++) {
        nodeDefs[joints[i4]].isBone = true;
      }
    }
    for (let nodeIndex = 0, nodeLength = nodeDefs.length; nodeIndex < nodeLength; nodeIndex++) {
      const nodeDef = nodeDefs[nodeIndex];
      if (nodeDef.mesh !== void 0) {
        this._addNodeRef(this.meshCache, nodeDef.mesh);
        if (nodeDef.skin !== void 0) {
          meshDefs[nodeDef.mesh].isSkinnedMesh = true;
        }
      }
      if (nodeDef.camera !== void 0) {
        this._addNodeRef(this.cameraCache, nodeDef.camera);
      }
    }
  }
  /**
   * Counts references to shared node / Object3D resources. These resources
   * can be reused, or "instantiated", at multiple nodes in the scene
   * hierarchy. Mesh, Camera, and Light instances are instantiated and must
   * be marked. Non-scenegraph resources (like Materials, Geometries, and
   * Textures) can be reused directly and are not marked here.
   *
   * Example: CesiumMilkTruck sample model reuses "Wheel" meshes.
   */
  _addNodeRef(cache, index2) {
    if (index2 === void 0)
      return;
    if (cache.refs[index2] === void 0) {
      cache.refs[index2] = cache.uses[index2] = 0;
    }
    cache.refs[index2]++;
  }
  /** Returns a reference to a shared resource, cloning it if necessary. */
  _getNodeRef(cache, index2, object) {
    if (cache.refs[index2] <= 1)
      return object;
    const ref = object.clone();
    const updateMappings = (original, clone2) => {
      const mappings = this.associations.get(original);
      if (mappings != null) {
        this.associations.set(clone2, mappings);
      }
      for (const [i4, child] of original.children.entries()) {
        updateMappings(child, clone2.children[i4]);
      }
    };
    updateMappings(object, ref);
    ref.name += "_instance_" + cache.uses[index2]++;
    return ref;
  }
  _invokeOne(func) {
    const extensions2 = Object.values(this.plugins);
    extensions2.push(this);
    for (let i4 = 0; i4 < extensions2.length; i4++) {
      const result = func(extensions2[i4]);
      if (result)
        return result;
    }
    return null;
  }
  _invokeAll(func) {
    const extensions2 = Object.values(this.plugins);
    extensions2.unshift(this);
    const pending = [];
    for (let i4 = 0; i4 < extensions2.length; i4++) {
      const result = func(extensions2[i4]);
      if (result)
        pending.push(result);
    }
    return pending;
  }
  /**
   * Requests the specified dependency asynchronously, with caching.
   * @param {string} type
   * @param {number} index
   * @return {Promise<Object3D|Material|THREE.Texture|AnimationClip|ArrayBuffer|Object>}
   */
  getDependency(type, index2) {
    const cacheKey = type + ":" + index2;
    let dependency = this.cache.get(cacheKey);
    if (!dependency) {
      switch (type) {
        case "scene":
          dependency = this.loadScene(index2);
          break;
        case "node":
          dependency = this._invokeOne(function(ext) {
            return ext.loadNode && ext.loadNode(index2);
          });
          break;
        case "mesh":
          dependency = this._invokeOne(function(ext) {
            return ext.loadMesh && ext.loadMesh(index2);
          });
          break;
        case "accessor":
          dependency = this.loadAccessor(index2);
          break;
        case "bufferView":
          dependency = this._invokeOne(function(ext) {
            return ext.loadBufferView && ext.loadBufferView(index2);
          });
          break;
        case "buffer":
          dependency = this.loadBuffer(index2);
          break;
        case "material":
          dependency = this._invokeOne(function(ext) {
            return ext.loadMaterial && ext.loadMaterial(index2);
          });
          break;
        case "texture":
          dependency = this._invokeOne(function(ext) {
            return ext.loadTexture && ext.loadTexture(index2);
          });
          break;
        case "skin":
          dependency = this.loadSkin(index2);
          break;
        case "animation":
          dependency = this._invokeOne(function(ext) {
            return ext.loadAnimation && ext.loadAnimation(index2);
          });
          break;
        case "camera":
          dependency = this.loadCamera(index2);
          break;
        default:
          dependency = this._invokeOne(function(ext) {
            return ext != this && ext.getDependency && ext.getDependency(type, index2);
          });
          if (!dependency) {
            throw new Error("Unknown type: " + type);
          }
          break;
      }
      this.cache.add(cacheKey, dependency);
    }
    return dependency;
  }
  /**
   * Requests all dependencies of the specified type asynchronously, with caching.
   * @param {string} type
   * @return {Promise<Array<Object>>}
   */
  getDependencies(type) {
    let dependencies = this.cache.get(type);
    if (!dependencies) {
      const parser = this;
      const defs = this.json[type + (type === "mesh" ? "es" : "s")] || [];
      dependencies = Promise.all(
        defs.map(function(def, index2) {
          return parser.getDependency(type, index2);
        })
      );
      this.cache.add(type, dependencies);
    }
    return dependencies;
  }
  /**
   * Specification: https://github.com/KhronosGroup/glTF/blob/master/specification/2.0/README.md#buffers-and-buffer-views
   * @param {number} bufferIndex
   * @return {Promise<ArrayBuffer>}
   */
  loadBuffer(bufferIndex) {
    const bufferDef = this.json.buffers[bufferIndex];
    const loader2 = this.fileLoader;
    if (bufferDef.type && bufferDef.type !== "arraybuffer") {
      throw new Error("THREE.GLTFLoader: " + bufferDef.type + " buffer type is not supported.");
    }
    if (bufferDef.uri === void 0 && bufferIndex === 0) {
      return Promise.resolve(this.extensions[EXTENSIONS.KHR_BINARY_GLTF].body);
    }
    const options = this.options;
    return new Promise(function(resolve, reject) {
      loader2.load(LoaderUtils.resolveURL(bufferDef.uri, options.path), resolve, void 0, function() {
        reject(new Error('THREE.GLTFLoader: Failed to load buffer "' + bufferDef.uri + '".'));
      });
    });
  }
  /**
   * Specification: https://github.com/KhronosGroup/glTF/blob/master/specification/2.0/README.md#buffers-and-buffer-views
   * @param {number} bufferViewIndex
   * @return {Promise<ArrayBuffer>}
   */
  loadBufferView(bufferViewIndex) {
    const bufferViewDef = this.json.bufferViews[bufferViewIndex];
    return this.getDependency("buffer", bufferViewDef.buffer).then(function(buffer2) {
      const byteLength = bufferViewDef.byteLength || 0;
      const byteOffset = bufferViewDef.byteOffset || 0;
      return buffer2.slice(byteOffset, byteOffset + byteLength);
    });
  }
  /**
   * Specification: https://github.com/KhronosGroup/glTF/blob/master/specification/2.0/README.md#accessors
   * @param {number} accessorIndex
   * @return {Promise<BufferAttribute|InterleavedBufferAttribute>}
   */
  loadAccessor(accessorIndex) {
    const parser = this;
    const json = this.json;
    const accessorDef = this.json.accessors[accessorIndex];
    if (accessorDef.bufferView === void 0 && accessorDef.sparse === void 0) {
      const itemSize = WEBGL_TYPE_SIZES[accessorDef.type];
      const TypedArray = WEBGL_COMPONENT_TYPES[accessorDef.componentType];
      const normalized = accessorDef.normalized === true;
      const array = new TypedArray(accessorDef.count * itemSize);
      return Promise.resolve(new BufferAttribute(array, itemSize, normalized));
    }
    const pendingBufferViews = [];
    if (accessorDef.bufferView !== void 0) {
      pendingBufferViews.push(this.getDependency("bufferView", accessorDef.bufferView));
    } else {
      pendingBufferViews.push(null);
    }
    if (accessorDef.sparse !== void 0) {
      pendingBufferViews.push(this.getDependency("bufferView", accessorDef.sparse.indices.bufferView));
      pendingBufferViews.push(this.getDependency("bufferView", accessorDef.sparse.values.bufferView));
    }
    return Promise.all(pendingBufferViews).then(function(bufferViews) {
      const bufferView = bufferViews[0];
      const itemSize = WEBGL_TYPE_SIZES[accessorDef.type];
      const TypedArray = WEBGL_COMPONENT_TYPES[accessorDef.componentType];
      const elementBytes = TypedArray.BYTES_PER_ELEMENT;
      const itemBytes = elementBytes * itemSize;
      const byteOffset = accessorDef.byteOffset || 0;
      const byteStride = accessorDef.bufferView !== void 0 ? json.bufferViews[accessorDef.bufferView].byteStride : void 0;
      const normalized = accessorDef.normalized === true;
      let array, bufferAttribute;
      if (byteStride && byteStride !== itemBytes) {
        const ibSlice = Math.floor(byteOffset / byteStride);
        const ibCacheKey = "InterleavedBuffer:" + accessorDef.bufferView + ":" + accessorDef.componentType + ":" + ibSlice + ":" + accessorDef.count;
        let ib = parser.cache.get(ibCacheKey);
        if (!ib) {
          array = new TypedArray(bufferView, ibSlice * byteStride, accessorDef.count * byteStride / elementBytes);
          ib = new InterleavedBuffer(array, byteStride / elementBytes);
          parser.cache.add(ibCacheKey, ib);
        }
        bufferAttribute = new InterleavedBufferAttribute(
          ib,
          itemSize,
          byteOffset % byteStride / elementBytes,
          normalized
        );
      } else {
        if (bufferView === null) {
          array = new TypedArray(accessorDef.count * itemSize);
        } else {
          array = new TypedArray(bufferView, byteOffset, accessorDef.count * itemSize);
        }
        bufferAttribute = new BufferAttribute(array, itemSize, normalized);
      }
      if (accessorDef.sparse !== void 0) {
        const itemSizeIndices = WEBGL_TYPE_SIZES.SCALAR;
        const TypedArrayIndices = WEBGL_COMPONENT_TYPES[accessorDef.sparse.indices.componentType];
        const byteOffsetIndices = accessorDef.sparse.indices.byteOffset || 0;
        const byteOffsetValues = accessorDef.sparse.values.byteOffset || 0;
        const sparseIndices = new TypedArrayIndices(
          bufferViews[1],
          byteOffsetIndices,
          accessorDef.sparse.count * itemSizeIndices
        );
        const sparseValues = new TypedArray(bufferViews[2], byteOffsetValues, accessorDef.sparse.count * itemSize);
        if (bufferView !== null) {
          bufferAttribute = new BufferAttribute(
            bufferAttribute.array.slice(),
            bufferAttribute.itemSize,
            bufferAttribute.normalized
          );
        }
        for (let i4 = 0, il = sparseIndices.length; i4 < il; i4++) {
          const index2 = sparseIndices[i4];
          bufferAttribute.setX(index2, sparseValues[i4 * itemSize]);
          if (itemSize >= 2)
            bufferAttribute.setY(index2, sparseValues[i4 * itemSize + 1]);
          if (itemSize >= 3)
            bufferAttribute.setZ(index2, sparseValues[i4 * itemSize + 2]);
          if (itemSize >= 4)
            bufferAttribute.setW(index2, sparseValues[i4 * itemSize + 3]);
          if (itemSize >= 5)
            throw new Error("THREE.GLTFLoader: Unsupported itemSize in sparse BufferAttribute.");
        }
      }
      return bufferAttribute;
    });
  }
  /**
   * Specification: https://github.com/KhronosGroup/glTF/tree/master/specification/2.0#textures
   * @param {number} textureIndex
   * @return {Promise<THREE.Texture|null>}
   */
  loadTexture(textureIndex) {
    const json = this.json;
    const options = this.options;
    const textureDef = json.textures[textureIndex];
    const sourceIndex = textureDef.source;
    const sourceDef = json.images[sourceIndex];
    let loader2 = this.textureLoader;
    if (sourceDef.uri) {
      const handler = options.manager.getHandler(sourceDef.uri);
      if (handler !== null)
        loader2 = handler;
    }
    return this.loadTextureImage(textureIndex, sourceIndex, loader2);
  }
  loadTextureImage(textureIndex, sourceIndex, loader2) {
    const parser = this;
    const json = this.json;
    const textureDef = json.textures[textureIndex];
    const sourceDef = json.images[sourceIndex];
    const cacheKey = (sourceDef.uri || sourceDef.bufferView) + ":" + textureDef.sampler;
    if (this.textureCache[cacheKey]) {
      return this.textureCache[cacheKey];
    }
    const promise = this.loadImageSource(sourceIndex, loader2).then(function(texture) {
      texture.flipY = false;
      texture.name = textureDef.name || sourceDef.name || "";
      if (texture.name === "" && typeof sourceDef.uri === "string" && sourceDef.uri.startsWith("data:image/") === false) {
        texture.name = sourceDef.uri;
      }
      const samplers = json.samplers || {};
      const sampler = samplers[textureDef.sampler] || {};
      texture.magFilter = WEBGL_FILTERS[sampler.magFilter] || LinearFilter;
      texture.minFilter = WEBGL_FILTERS[sampler.minFilter] || LinearMipmapLinearFilter;
      texture.wrapS = WEBGL_WRAPPINGS[sampler.wrapS] || RepeatWrapping;
      texture.wrapT = WEBGL_WRAPPINGS[sampler.wrapT] || RepeatWrapping;
      parser.associations.set(texture, { textures: textureIndex });
      return texture;
    }).catch(function() {
      return null;
    });
    this.textureCache[cacheKey] = promise;
    return promise;
  }
  loadImageSource(sourceIndex, loader2) {
    const parser = this;
    const json = this.json;
    const options = this.options;
    if (this.sourceCache[sourceIndex] !== void 0) {
      return this.sourceCache[sourceIndex].then((texture) => texture.clone());
    }
    const sourceDef = json.images[sourceIndex];
    const URL2 = self.URL || self.webkitURL;
    let sourceURI = sourceDef.uri || "";
    let isObjectURL = false;
    if (sourceDef.bufferView !== void 0) {
      sourceURI = parser.getDependency("bufferView", sourceDef.bufferView).then(function(bufferView) {
        isObjectURL = true;
        const blob = new Blob([bufferView], { type: sourceDef.mimeType });
        sourceURI = URL2.createObjectURL(blob);
        return sourceURI;
      });
    } else if (sourceDef.uri === void 0) {
      throw new Error("THREE.GLTFLoader: Image " + sourceIndex + " is missing URI and bufferView");
    }
    const promise = Promise.resolve(sourceURI).then(function(sourceURI2) {
      return new Promise(function(resolve, reject) {
        let onLoad = resolve;
        if (loader2.isImageBitmapLoader === true) {
          onLoad = function(imageBitmap) {
            const texture = new Texture(imageBitmap);
            texture.needsUpdate = true;
            resolve(texture);
          };
        }
        loader2.load(LoaderUtils.resolveURL(sourceURI2, options.path), onLoad, void 0, reject);
      });
    }).then(function(texture) {
      if (isObjectURL === true) {
        URL2.revokeObjectURL(sourceURI);
      }
      assignExtrasToUserData(texture, sourceDef);
      texture.userData.mimeType = sourceDef.mimeType || getImageURIMimeType(sourceDef.uri);
      return texture;
    }).catch(function(error) {
      console.error("THREE.GLTFLoader: Couldn't load texture", sourceURI);
      throw error;
    });
    this.sourceCache[sourceIndex] = promise;
    return promise;
  }
  /**
   * Asynchronously assigns a texture to the given material parameters.
   * @param {Object} materialParams
   * @param {string} mapName
   * @param {Object} mapDef
   * @return {Promise<Texture>}
   */
  assignTexture(materialParams, mapName, mapDef, colorSpace) {
    const parser = this;
    return this.getDependency("texture", mapDef.index).then(function(texture) {
      if (!texture)
        return null;
      if (mapDef.texCoord !== void 0 && mapDef.texCoord > 0) {
        texture = texture.clone();
        texture.channel = mapDef.texCoord;
      }
      if (parser.extensions[EXTENSIONS.KHR_TEXTURE_TRANSFORM]) {
        const transform = mapDef.extensions !== void 0 ? mapDef.extensions[EXTENSIONS.KHR_TEXTURE_TRANSFORM] : void 0;
        if (transform) {
          const gltfReference = parser.associations.get(texture);
          texture = parser.extensions[EXTENSIONS.KHR_TEXTURE_TRANSFORM].extendTexture(texture, transform);
          parser.associations.set(texture, gltfReference);
        }
      }
      if (colorSpace !== void 0) {
        if (typeof colorSpace === "number")
          colorSpace = colorSpace === sRGBEncoding ? SRGBColorSpace2 : LinearSRGBColorSpace2;
        if ("colorSpace" in texture)
          texture.colorSpace = colorSpace;
        else
          texture.encoding = colorSpace === SRGBColorSpace2 ? sRGBEncoding : LinearEncoding;
      }
      materialParams[mapName] = texture;
      return texture;
    });
  }
  /**
   * Assigns final material to a Mesh, Line, or Points instance. The instance
   * already has a material (generated from the glTF material options alone)
   * but reuse of the same glTF material may require multiple threejs materials
   * to accommodate different primitive types, defines, etc. New materials will
   * be created if necessary, and reused from a cache.
   * @param  {Object3D} mesh Mesh, Line, or Points instance.
   */
  assignFinalMaterial(mesh) {
    const geometry3 = mesh.geometry;
    let material = mesh.material;
    const useDerivativeTangents = geometry3.attributes.tangent === void 0;
    const useVertexColors = geometry3.attributes.color !== void 0;
    const useFlatShading = geometry3.attributes.normal === void 0;
    if (mesh.isPoints) {
      const cacheKey = "PointsMaterial:" + material.uuid;
      let pointsMaterial = this.cache.get(cacheKey);
      if (!pointsMaterial) {
        pointsMaterial = new PointsMaterial();
        Material.prototype.copy.call(pointsMaterial, material);
        pointsMaterial.color.copy(material.color);
        pointsMaterial.map = material.map;
        pointsMaterial.sizeAttenuation = false;
        this.cache.add(cacheKey, pointsMaterial);
      }
      material = pointsMaterial;
    } else if (mesh.isLine) {
      const cacheKey = "LineBasicMaterial:" + material.uuid;
      let lineMaterial = this.cache.get(cacheKey);
      if (!lineMaterial) {
        lineMaterial = new LineBasicMaterial();
        Material.prototype.copy.call(lineMaterial, material);
        lineMaterial.color.copy(material.color);
        lineMaterial.map = material.map;
        this.cache.add(cacheKey, lineMaterial);
      }
      material = lineMaterial;
    }
    if (useDerivativeTangents || useVertexColors || useFlatShading) {
      let cacheKey = "ClonedMaterial:" + material.uuid + ":";
      if (useDerivativeTangents)
        cacheKey += "derivative-tangents:";
      if (useVertexColors)
        cacheKey += "vertex-colors:";
      if (useFlatShading)
        cacheKey += "flat-shading:";
      let cachedMaterial = this.cache.get(cacheKey);
      if (!cachedMaterial) {
        cachedMaterial = material.clone();
        if (useVertexColors)
          cachedMaterial.vertexColors = true;
        if (useFlatShading)
          cachedMaterial.flatShading = true;
        if (useDerivativeTangents) {
          if (cachedMaterial.normalScale)
            cachedMaterial.normalScale.y *= -1;
          if (cachedMaterial.clearcoatNormalScale)
            cachedMaterial.clearcoatNormalScale.y *= -1;
        }
        this.cache.add(cacheKey, cachedMaterial);
        this.associations.set(cachedMaterial, this.associations.get(material));
      }
      material = cachedMaterial;
    }
    mesh.material = material;
  }
  getMaterialType() {
    return MeshStandardMaterial;
  }
  /**
   * Specification: https://github.com/KhronosGroup/glTF/blob/master/specification/2.0/README.md#materials
   * @param {number} materialIndex
   * @return {Promise<Material>}
   */
  loadMaterial(materialIndex) {
    const parser = this;
    const json = this.json;
    const extensions2 = this.extensions;
    const materialDef = json.materials[materialIndex];
    let materialType;
    const materialParams = {};
    const materialExtensions = materialDef.extensions || {};
    const pending = [];
    if (materialExtensions[EXTENSIONS.KHR_MATERIALS_UNLIT]) {
      const kmuExtension = extensions2[EXTENSIONS.KHR_MATERIALS_UNLIT];
      materialType = kmuExtension.getMaterialType();
      pending.push(kmuExtension.extendParams(materialParams, materialDef, parser));
    } else {
      const metallicRoughness = materialDef.pbrMetallicRoughness || {};
      materialParams.color = new Color(1, 1, 1);
      materialParams.opacity = 1;
      if (Array.isArray(metallicRoughness.baseColorFactor)) {
        const array = metallicRoughness.baseColorFactor;
        materialParams.color.setRGB(array[0], array[1], array[2], LinearSRGBColorSpace2);
        materialParams.opacity = array[3];
      }
      if (metallicRoughness.baseColorTexture !== void 0) {
        pending.push(parser.assignTexture(materialParams, "map", metallicRoughness.baseColorTexture, SRGBColorSpace2));
      }
      materialParams.metalness = metallicRoughness.metallicFactor !== void 0 ? metallicRoughness.metallicFactor : 1;
      materialParams.roughness = metallicRoughness.roughnessFactor !== void 0 ? metallicRoughness.roughnessFactor : 1;
      if (metallicRoughness.metallicRoughnessTexture !== void 0) {
        pending.push(parser.assignTexture(materialParams, "metalnessMap", metallicRoughness.metallicRoughnessTexture));
        pending.push(parser.assignTexture(materialParams, "roughnessMap", metallicRoughness.metallicRoughnessTexture));
      }
      materialType = this._invokeOne(function(ext) {
        return ext.getMaterialType && ext.getMaterialType(materialIndex);
      });
      pending.push(
        Promise.all(
          this._invokeAll(function(ext) {
            return ext.extendMaterialParams && ext.extendMaterialParams(materialIndex, materialParams);
          })
        )
      );
    }
    if (materialDef.doubleSided === true) {
      materialParams.side = DoubleSide;
    }
    const alphaMode = materialDef.alphaMode || ALPHA_MODES.OPAQUE;
    if (alphaMode === ALPHA_MODES.BLEND) {
      materialParams.transparent = true;
      materialParams.depthWrite = false;
    } else {
      materialParams.transparent = false;
      if (alphaMode === ALPHA_MODES.MASK) {
        materialParams.alphaTest = materialDef.alphaCutoff !== void 0 ? materialDef.alphaCutoff : 0.5;
      }
    }
    if (materialDef.normalTexture !== void 0 && materialType !== MeshBasicMaterial) {
      pending.push(parser.assignTexture(materialParams, "normalMap", materialDef.normalTexture));
      materialParams.normalScale = new Vector2(1, 1);
      if (materialDef.normalTexture.scale !== void 0) {
        const scale5 = materialDef.normalTexture.scale;
        materialParams.normalScale.set(scale5, scale5);
      }
    }
    if (materialDef.occlusionTexture !== void 0 && materialType !== MeshBasicMaterial) {
      pending.push(parser.assignTexture(materialParams, "aoMap", materialDef.occlusionTexture));
      if (materialDef.occlusionTexture.strength !== void 0) {
        materialParams.aoMapIntensity = materialDef.occlusionTexture.strength;
      }
    }
    if (materialDef.emissiveFactor !== void 0 && materialType !== MeshBasicMaterial) {
      const emissiveFactor = materialDef.emissiveFactor;
      materialParams.emissive = new Color().setRGB(
        emissiveFactor[0],
        emissiveFactor[1],
        emissiveFactor[2],
        LinearSRGBColorSpace2
      );
    }
    if (materialDef.emissiveTexture !== void 0 && materialType !== MeshBasicMaterial) {
      pending.push(parser.assignTexture(materialParams, "emissiveMap", materialDef.emissiveTexture, SRGBColorSpace2));
    }
    return Promise.all(pending).then(function() {
      const material = new materialType(materialParams);
      if (materialDef.name)
        material.name = materialDef.name;
      assignExtrasToUserData(material, materialDef);
      parser.associations.set(material, { materials: materialIndex });
      if (materialDef.extensions)
        addUnknownExtensionsToUserData(extensions2, material, materialDef);
      return material;
    });
  }
  /** When Object3D instances are targeted by animation, they need unique names. */
  createUniqueName(originalName) {
    const sanitizedName = PropertyBinding.sanitizeNodeName(originalName || "");
    if (sanitizedName in this.nodeNamesUsed) {
      return sanitizedName + "_" + ++this.nodeNamesUsed[sanitizedName];
    } else {
      this.nodeNamesUsed[sanitizedName] = 0;
      return sanitizedName;
    }
  }
  /**
   * Specification: https://github.com/KhronosGroup/glTF/blob/master/specification/2.0/README.md#geometry
   *
   * Creates BufferGeometries from primitives.
   *
   * @param {Array<GLTF.Primitive>} primitives
   * @return {Promise<Array<BufferGeometry>>}
   */
  loadGeometries(primitives) {
    const parser = this;
    const extensions2 = this.extensions;
    const cache = this.primitiveCache;
    function createDracoPrimitive(primitive) {
      return extensions2[EXTENSIONS.KHR_DRACO_MESH_COMPRESSION].decodePrimitive(primitive, parser).then(function(geometry3) {
        return addPrimitiveAttributes(geometry3, primitive, parser);
      });
    }
    const pending = [];
    for (let i4 = 0, il = primitives.length; i4 < il; i4++) {
      const primitive = primitives[i4];
      const cacheKey = createPrimitiveKey(primitive);
      const cached = cache[cacheKey];
      if (cached) {
        pending.push(cached.promise);
      } else {
        let geometryPromise;
        if (primitive.extensions && primitive.extensions[EXTENSIONS.KHR_DRACO_MESH_COMPRESSION]) {
          geometryPromise = createDracoPrimitive(primitive);
        } else {
          geometryPromise = addPrimitiveAttributes(new BufferGeometry(), primitive, parser);
        }
        cache[cacheKey] = { primitive, promise: geometryPromise };
        pending.push(geometryPromise);
      }
    }
    return Promise.all(pending);
  }
  /**
   * Specification: https://github.com/KhronosGroup/glTF/blob/master/specification/2.0/README.md#meshes
   * @param {number} meshIndex
   * @return {Promise<Group|Mesh|SkinnedMesh>}
   */
  loadMesh(meshIndex) {
    const parser = this;
    const json = this.json;
    const extensions2 = this.extensions;
    const meshDef = json.meshes[meshIndex];
    const primitives = meshDef.primitives;
    const pending = [];
    for (let i4 = 0, il = primitives.length; i4 < il; i4++) {
      const material = primitives[i4].material === void 0 ? createDefaultMaterial(this.cache) : this.getDependency("material", primitives[i4].material);
      pending.push(material);
    }
    pending.push(parser.loadGeometries(primitives));
    return Promise.all(pending).then(function(results) {
      const materials = results.slice(0, results.length - 1);
      const geometries = results[results.length - 1];
      const meshes = [];
      for (let i4 = 0, il = geometries.length; i4 < il; i4++) {
        const geometry3 = geometries[i4];
        const primitive = primitives[i4];
        let mesh;
        const material = materials[i4];
        if (primitive.mode === WEBGL_CONSTANTS2.TRIANGLES || primitive.mode === WEBGL_CONSTANTS2.TRIANGLE_STRIP || primitive.mode === WEBGL_CONSTANTS2.TRIANGLE_FAN || primitive.mode === void 0) {
          mesh = meshDef.isSkinnedMesh === true ? new SkinnedMesh(geometry3, material) : new Mesh(geometry3, material);
          if (mesh.isSkinnedMesh === true) {
            mesh.normalizeSkinWeights();
          }
          if (primitive.mode === WEBGL_CONSTANTS2.TRIANGLE_STRIP) {
            mesh.geometry = toTrianglesDrawMode(mesh.geometry, TriangleStripDrawMode);
          } else if (primitive.mode === WEBGL_CONSTANTS2.TRIANGLE_FAN) {
            mesh.geometry = toTrianglesDrawMode(mesh.geometry, TriangleFanDrawMode);
          }
        } else if (primitive.mode === WEBGL_CONSTANTS2.LINES) {
          mesh = new LineSegments(geometry3, material);
        } else if (primitive.mode === WEBGL_CONSTANTS2.LINE_STRIP) {
          mesh = new Line(geometry3, material);
        } else if (primitive.mode === WEBGL_CONSTANTS2.LINE_LOOP) {
          mesh = new LineLoop(geometry3, material);
        } else if (primitive.mode === WEBGL_CONSTANTS2.POINTS) {
          mesh = new Points(geometry3, material);
        } else {
          throw new Error("THREE.GLTFLoader: Primitive mode unsupported: " + primitive.mode);
        }
        if (Object.keys(mesh.geometry.morphAttributes).length > 0) {
          updateMorphTargets(mesh, meshDef);
        }
        mesh.name = parser.createUniqueName(meshDef.name || "mesh_" + meshIndex);
        assignExtrasToUserData(mesh, meshDef);
        if (primitive.extensions)
          addUnknownExtensionsToUserData(extensions2, mesh, primitive);
        parser.assignFinalMaterial(mesh);
        meshes.push(mesh);
      }
      for (let i4 = 0, il = meshes.length; i4 < il; i4++) {
        parser.associations.set(meshes[i4], {
          meshes: meshIndex,
          primitives: i4
        });
      }
      if (meshes.length === 1) {
        if (meshDef.extensions)
          addUnknownExtensionsToUserData(extensions2, meshes[0], meshDef);
        return meshes[0];
      }
      const group = new Group();
      if (meshDef.extensions)
        addUnknownExtensionsToUserData(extensions2, group, meshDef);
      parser.associations.set(group, { meshes: meshIndex });
      for (let i4 = 0, il = meshes.length; i4 < il; i4++) {
        group.add(meshes[i4]);
      }
      return group;
    });
  }
  /**
   * Specification: https://github.com/KhronosGroup/glTF/tree/master/specification/2.0#cameras
   * @param {number} cameraIndex
   * @return {Promise<THREE.Camera>}
   */
  loadCamera(cameraIndex) {
    let camera;
    const cameraDef = this.json.cameras[cameraIndex];
    const params = cameraDef[cameraDef.type];
    if (!params) {
      console.warn("THREE.GLTFLoader: Missing camera parameters.");
      return;
    }
    if (cameraDef.type === "perspective") {
      camera = new PerspectiveCamera(
        MathUtils.radToDeg(params.yfov),
        params.aspectRatio || 1,
        params.znear || 1,
        params.zfar || 2e6
      );
    } else if (cameraDef.type === "orthographic") {
      camera = new OrthographicCamera(-params.xmag, params.xmag, params.ymag, -params.ymag, params.znear, params.zfar);
    }
    if (cameraDef.name)
      camera.name = this.createUniqueName(cameraDef.name);
    assignExtrasToUserData(camera, cameraDef);
    return Promise.resolve(camera);
  }
  /**
   * Specification: https://github.com/KhronosGroup/glTF/tree/master/specification/2.0#skins
   * @param {number} skinIndex
   * @return {Promise<Skeleton>}
   */
  loadSkin(skinIndex) {
    const skinDef = this.json.skins[skinIndex];
    const pending = [];
    for (let i4 = 0, il = skinDef.joints.length; i4 < il; i4++) {
      pending.push(this._loadNodeShallow(skinDef.joints[i4]));
    }
    if (skinDef.inverseBindMatrices !== void 0) {
      pending.push(this.getDependency("accessor", skinDef.inverseBindMatrices));
    } else {
      pending.push(null);
    }
    return Promise.all(pending).then(function(results) {
      const inverseBindMatrices = results.pop();
      const jointNodes = results;
      const bones = [];
      const boneInverses = [];
      for (let i4 = 0, il = jointNodes.length; i4 < il; i4++) {
        const jointNode = jointNodes[i4];
        if (jointNode) {
          bones.push(jointNode);
          const mat2 = new Matrix4();
          if (inverseBindMatrices !== null) {
            mat2.fromArray(inverseBindMatrices.array, i4 * 16);
          }
          boneInverses.push(mat2);
        } else {
          console.warn('THREE.GLTFLoader: Joint "%s" could not be found.', skinDef.joints[i4]);
        }
      }
      return new Skeleton(bones, boneInverses);
    });
  }
  /**
   * Specification: https://github.com/KhronosGroup/glTF/tree/master/specification/2.0#animations
   * @param {number} animationIndex
   * @return {Promise<AnimationClip>}
   */
  loadAnimation(animationIndex) {
    const json = this.json;
    const parser = this;
    const animationDef = json.animations[animationIndex];
    const animationName = animationDef.name ? animationDef.name : "animation_" + animationIndex;
    const pendingNodes = [];
    const pendingInputAccessors = [];
    const pendingOutputAccessors = [];
    const pendingSamplers = [];
    const pendingTargets = [];
    for (let i4 = 0, il = animationDef.channels.length; i4 < il; i4++) {
      const channel = animationDef.channels[i4];
      const sampler = animationDef.samplers[channel.sampler];
      const target2 = channel.target;
      const name = target2.node;
      const input = animationDef.parameters !== void 0 ? animationDef.parameters[sampler.input] : sampler.input;
      const output = animationDef.parameters !== void 0 ? animationDef.parameters[sampler.output] : sampler.output;
      if (target2.node === void 0)
        continue;
      pendingNodes.push(this.getDependency("node", name));
      pendingInputAccessors.push(this.getDependency("accessor", input));
      pendingOutputAccessors.push(this.getDependency("accessor", output));
      pendingSamplers.push(sampler);
      pendingTargets.push(target2);
    }
    return Promise.all([
      Promise.all(pendingNodes),
      Promise.all(pendingInputAccessors),
      Promise.all(pendingOutputAccessors),
      Promise.all(pendingSamplers),
      Promise.all(pendingTargets)
    ]).then(function(dependencies) {
      const nodes = dependencies[0];
      const inputAccessors = dependencies[1];
      const outputAccessors = dependencies[2];
      const samplers = dependencies[3];
      const targets = dependencies[4];
      const tracks = [];
      for (let i4 = 0, il = nodes.length; i4 < il; i4++) {
        const node = nodes[i4];
        const inputAccessor = inputAccessors[i4];
        const outputAccessor = outputAccessors[i4];
        const sampler = samplers[i4];
        const target2 = targets[i4];
        if (node === void 0)
          continue;
        if (node.updateMatrix) {
          node.updateMatrix();
        }
        const createdTracks = parser._createAnimationTracks(node, inputAccessor, outputAccessor, sampler, target2);
        if (createdTracks) {
          for (let k = 0; k < createdTracks.length; k++) {
            tracks.push(createdTracks[k]);
          }
        }
      }
      return new AnimationClip(animationName, void 0, tracks);
    });
  }
  createNodeMesh(nodeIndex) {
    const json = this.json;
    const parser = this;
    const nodeDef = json.nodes[nodeIndex];
    if (nodeDef.mesh === void 0)
      return null;
    return parser.getDependency("mesh", nodeDef.mesh).then(function(mesh) {
      const node = parser._getNodeRef(parser.meshCache, nodeDef.mesh, mesh);
      if (nodeDef.weights !== void 0) {
        node.traverse(function(o2) {
          if (!o2.isMesh)
            return;
          for (let i4 = 0, il = nodeDef.weights.length; i4 < il; i4++) {
            o2.morphTargetInfluences[i4] = nodeDef.weights[i4];
          }
        });
      }
      return node;
    });
  }
  /**
   * Specification: https://github.com/KhronosGroup/glTF/tree/master/specification/2.0#nodes-and-hierarchy
   * @param {number} nodeIndex
   * @return {Promise<Object3D>}
   */
  loadNode(nodeIndex) {
    const json = this.json;
    const parser = this;
    const nodeDef = json.nodes[nodeIndex];
    const nodePending = parser._loadNodeShallow(nodeIndex);
    const childPending = [];
    const childrenDef = nodeDef.children || [];
    for (let i4 = 0, il = childrenDef.length; i4 < il; i4++) {
      childPending.push(parser.getDependency("node", childrenDef[i4]));
    }
    const skeletonPending = nodeDef.skin === void 0 ? Promise.resolve(null) : parser.getDependency("skin", nodeDef.skin);
    return Promise.all([nodePending, Promise.all(childPending), skeletonPending]).then(function(results) {
      const node = results[0];
      const children = results[1];
      const skeleton = results[2];
      if (skeleton !== null) {
        node.traverse(function(mesh) {
          if (!mesh.isSkinnedMesh)
            return;
          mesh.bind(skeleton, _identityMatrix2);
        });
      }
      for (let i4 = 0, il = children.length; i4 < il; i4++) {
        node.add(children[i4]);
      }
      return node;
    });
  }
  // ._loadNodeShallow() parses a single node.
  // skin and child nodes are created and added in .loadNode() (no '_' prefix).
  _loadNodeShallow(nodeIndex) {
    const json = this.json;
    const extensions2 = this.extensions;
    const parser = this;
    if (this.nodeCache[nodeIndex] !== void 0) {
      return this.nodeCache[nodeIndex];
    }
    const nodeDef = json.nodes[nodeIndex];
    const nodeName = nodeDef.name ? parser.createUniqueName(nodeDef.name) : "";
    const pending = [];
    const meshPromise = parser._invokeOne(function(ext) {
      return ext.createNodeMesh && ext.createNodeMesh(nodeIndex);
    });
    if (meshPromise) {
      pending.push(meshPromise);
    }
    if (nodeDef.camera !== void 0) {
      pending.push(
        parser.getDependency("camera", nodeDef.camera).then(function(camera) {
          return parser._getNodeRef(parser.cameraCache, nodeDef.camera, camera);
        })
      );
    }
    parser._invokeAll(function(ext) {
      return ext.createNodeAttachment && ext.createNodeAttachment(nodeIndex);
    }).forEach(function(promise) {
      pending.push(promise);
    });
    this.nodeCache[nodeIndex] = Promise.all(pending).then(function(objects) {
      let node;
      if (nodeDef.isBone === true) {
        node = new Bone();
      } else if (objects.length > 1) {
        node = new Group();
      } else if (objects.length === 1) {
        node = objects[0];
      } else {
        node = new Object3D();
      }
      if (node !== objects[0]) {
        for (let i4 = 0, il = objects.length; i4 < il; i4++) {
          node.add(objects[i4]);
        }
      }
      if (nodeDef.name) {
        node.userData.name = nodeDef.name;
        node.name = nodeName;
      }
      assignExtrasToUserData(node, nodeDef);
      if (nodeDef.extensions)
        addUnknownExtensionsToUserData(extensions2, node, nodeDef);
      if (nodeDef.matrix !== void 0) {
        const matrix6 = new Matrix4();
        matrix6.fromArray(nodeDef.matrix);
        node.applyMatrix4(matrix6);
      } else {
        if (nodeDef.translation !== void 0) {
          node.position.fromArray(nodeDef.translation);
        }
        if (nodeDef.rotation !== void 0) {
          node.quaternion.fromArray(nodeDef.rotation);
        }
        if (nodeDef.scale !== void 0) {
          node.scale.fromArray(nodeDef.scale);
        }
      }
      if (!parser.associations.has(node)) {
        parser.associations.set(node, {});
      }
      parser.associations.get(node).nodes = nodeIndex;
      return node;
    });
    return this.nodeCache[nodeIndex];
  }
  /**
   * Specification: https://github.com/KhronosGroup/glTF/tree/master/specification/2.0#scenes
   * @param {number} sceneIndex
   * @return {Promise<Group>}
   */
  loadScene(sceneIndex) {
    const extensions2 = this.extensions;
    const sceneDef = this.json.scenes[sceneIndex];
    const parser = this;
    const scene = new Group();
    if (sceneDef.name)
      scene.name = parser.createUniqueName(sceneDef.name);
    assignExtrasToUserData(scene, sceneDef);
    if (sceneDef.extensions)
      addUnknownExtensionsToUserData(extensions2, scene, sceneDef);
    const nodeIds = sceneDef.nodes || [];
    const pending = [];
    for (let i4 = 0, il = nodeIds.length; i4 < il; i4++) {
      pending.push(parser.getDependency("node", nodeIds[i4]));
    }
    return Promise.all(pending).then(function(nodes) {
      for (let i4 = 0, il = nodes.length; i4 < il; i4++) {
        scene.add(nodes[i4]);
      }
      const reduceAssociations = (node) => {
        const reducedAssociations = /* @__PURE__ */ new Map();
        for (const [key, value] of parser.associations) {
          if (key instanceof Material || key instanceof Texture) {
            reducedAssociations.set(key, value);
          }
        }
        node.traverse((node2) => {
          const mappings = parser.associations.get(node2);
          if (mappings != null) {
            reducedAssociations.set(node2, mappings);
          }
        });
        return reducedAssociations;
      };
      parser.associations = reduceAssociations(scene);
      return scene;
    });
  }
  _createAnimationTracks(node, inputAccessor, outputAccessor, sampler, target2) {
    const tracks = [];
    const targetName = node.name ? node.name : node.uuid;
    const targetNames = [];
    if (PATH_PROPERTIES2[target2.path] === PATH_PROPERTIES2.weights) {
      node.traverse(function(object) {
        if (object.morphTargetInfluences) {
          targetNames.push(object.name ? object.name : object.uuid);
        }
      });
    } else {
      targetNames.push(targetName);
    }
    let TypedKeyframeTrack;
    switch (PATH_PROPERTIES2[target2.path]) {
      case PATH_PROPERTIES2.weights:
        TypedKeyframeTrack = NumberKeyframeTrack;
        break;
      case PATH_PROPERTIES2.rotation:
        TypedKeyframeTrack = QuaternionKeyframeTrack;
        break;
      case PATH_PROPERTIES2.position:
      case PATH_PROPERTIES2.scale:
        TypedKeyframeTrack = VectorKeyframeTrack;
        break;
      default:
        switch (outputAccessor.itemSize) {
          case 1:
            TypedKeyframeTrack = NumberKeyframeTrack;
            break;
          case 2:
          case 3:
          default:
            TypedKeyframeTrack = VectorKeyframeTrack;
            break;
        }
        break;
    }
    const interpolation = sampler.interpolation !== void 0 ? INTERPOLATION[sampler.interpolation] : InterpolateLinear;
    const outputArray = this._getArrayFromAccessor(outputAccessor);
    for (let j = 0, jl = targetNames.length; j < jl; j++) {
      const track = new TypedKeyframeTrack(
        targetNames[j] + "." + PATH_PROPERTIES2[target2.path],
        inputAccessor.array,
        outputArray,
        interpolation
      );
      if (sampler.interpolation === "CUBICSPLINE") {
        this._createCubicSplineTrackInterpolant(track);
      }
      tracks.push(track);
    }
    return tracks;
  }
  _getArrayFromAccessor(accessor) {
    let outputArray = accessor.array;
    if (accessor.normalized) {
      const scale5 = getNormalizedComponentScale(outputArray.constructor);
      const scaled = new Float32Array(outputArray.length);
      for (let j = 0, jl = outputArray.length; j < jl; j++) {
        scaled[j] = outputArray[j] * scale5;
      }
      outputArray = scaled;
    }
    return outputArray;
  }
  _createCubicSplineTrackInterpolant(track) {
    track.createInterpolant = function InterpolantFactoryMethodGLTFCubicSpline(result) {
      const interpolantType = this instanceof QuaternionKeyframeTrack ? GLTFCubicSplineQuaternionInterpolant : GLTFCubicSplineInterpolant;
      return new interpolantType(this.times, this.values, this.getValueSize() / 3, result);
    };
    track.createInterpolant.isInterpolantFactoryMethodGLTFCubicSpline = true;
  }
};
function computeBounds(geometry3, primitiveDef, parser) {
  const attributes = primitiveDef.attributes;
  const box = new Box3();
  if (attributes.POSITION !== void 0) {
    const accessor = parser.json.accessors[attributes.POSITION];
    const min = accessor.min;
    const max2 = accessor.max;
    if (min !== void 0 && max2 !== void 0) {
      box.set(new Vector3(min[0], min[1], min[2]), new Vector3(max2[0], max2[1], max2[2]));
      if (accessor.normalized) {
        const boxScale = getNormalizedComponentScale(WEBGL_COMPONENT_TYPES[accessor.componentType]);
        box.min.multiplyScalar(boxScale);
        box.max.multiplyScalar(boxScale);
      }
    } else {
      console.warn("THREE.GLTFLoader: Missing min/max properties for accessor POSITION.");
      return;
    }
  } else {
    return;
  }
  const targets = primitiveDef.targets;
  if (targets !== void 0) {
    const maxDisplacement = new Vector3();
    const vector = new Vector3();
    for (let i4 = 0, il = targets.length; i4 < il; i4++) {
      const target2 = targets[i4];
      if (target2.POSITION !== void 0) {
        const accessor = parser.json.accessors[target2.POSITION];
        const min = accessor.min;
        const max2 = accessor.max;
        if (min !== void 0 && max2 !== void 0) {
          vector.setX(Math.max(Math.abs(min[0]), Math.abs(max2[0])));
          vector.setY(Math.max(Math.abs(min[1]), Math.abs(max2[1])));
          vector.setZ(Math.max(Math.abs(min[2]), Math.abs(max2[2])));
          if (accessor.normalized) {
            const boxScale = getNormalizedComponentScale(WEBGL_COMPONENT_TYPES[accessor.componentType]);
            vector.multiplyScalar(boxScale);
          }
          maxDisplacement.max(vector);
        } else {
          console.warn("THREE.GLTFLoader: Missing min/max properties for accessor POSITION.");
        }
      }
    }
    box.expandByVector(maxDisplacement);
  }
  geometry3.boundingBox = box;
  const sphere = new Sphere();
  box.getCenter(sphere.center);
  sphere.radius = box.min.distanceTo(box.max) / 2;
  geometry3.boundingSphere = sphere;
}
function addPrimitiveAttributes(geometry3, primitiveDef, parser) {
  const attributes = primitiveDef.attributes;
  const pending = [];
  function assignAttributeAccessor(accessorIndex, attributeName) {
    return parser.getDependency("accessor", accessorIndex).then(function(accessor) {
      geometry3.setAttribute(attributeName, accessor);
    });
  }
  for (const gltfAttributeName in attributes) {
    const threeAttributeName = ATTRIBUTES[gltfAttributeName] || gltfAttributeName.toLowerCase();
    if (threeAttributeName in geometry3.attributes)
      continue;
    pending.push(assignAttributeAccessor(attributes[gltfAttributeName], threeAttributeName));
  }
  if (primitiveDef.indices !== void 0 && !geometry3.index) {
    const accessor = parser.getDependency("accessor", primitiveDef.indices).then(function(accessor2) {
      geometry3.setIndex(accessor2);
    });
    pending.push(accessor);
  }
  assignExtrasToUserData(geometry3, primitiveDef);
  computeBounds(geometry3, primitiveDef, parser);
  return Promise.all(pending).then(function() {
    return primitiveDef.targets !== void 0 ? addMorphTargets(geometry3, primitiveDef.targets, parser) : geometry3;
  });
}

// node_modules/three-stdlib/webxr/OculusHandPointerModel.js
var YAXIS = new Vector3(0, 1, 0);
var ZAXIS = new Vector3(0, 0, 1);

// node_modules/three-stdlib/webxr/VRButton.js
var __defProp29 = Object.defineProperty;
var __defNormalProp29 = (obj, key, value) => key in obj ? __defProp29(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField30 = (obj, key, value) => {
  __defNormalProp29(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var VRButton = (() => {
  const _VRButton = class {
    static createButton(renderer, sessionInit = {}) {
      const button = document.createElement("button");
      function showEnterVR() {
        let currentSession = null;
        async function onSessionStarted(session) {
          session.addEventListener("end", onSessionEnded);
          await renderer.xr.setSession(session);
          button.textContent = "EXIT VR";
          currentSession = session;
        }
        function onSessionEnded() {
          currentSession.removeEventListener("end", onSessionEnded);
          button.textContent = "ENTER VR";
          currentSession = null;
        }
        button.style.display = "";
        button.style.cursor = "pointer";
        button.style.left = "calc(50% - 50px)";
        button.style.width = "100px";
        button.textContent = "ENTER VR";
        button.onmouseenter = () => {
          button.style.opacity = "1.0";
        };
        button.onmouseleave = () => {
          button.style.opacity = "0.5";
        };
        button.onclick = () => {
          var _a4;
          if (currentSession === null) {
            const optionalFeatures = [sessionInit.optionalFeatures, "local-floor", "bounded-floor", "hand-tracking"].flat().filter(Boolean);
            (_a4 = navigator.xr) == null ? void 0 : _a4.requestSession("immersive-vr", { ...sessionInit, optionalFeatures }).then(onSessionStarted);
          } else {
            currentSession.end();
          }
        };
      }
      function disableButton() {
        button.style.display = "";
        button.style.cursor = "auto";
        button.style.left = "calc(50% - 75px)";
        button.style.width = "150px";
        button.onmouseenter = null;
        button.onmouseleave = null;
        button.onclick = null;
      }
      function showWebXRNotFound() {
        disableButton();
        button.textContent = "VR NOT SUPPORTED";
      }
      function stylizeElement(element) {
        element.style.position = "absolute";
        element.style.bottom = "20px";
        element.style.padding = "12px 6px";
        element.style.border = "1px solid #fff";
        element.style.borderRadius = "4px";
        element.style.background = "rgba(0,0,0,0.1)";
        element.style.color = "#fff";
        element.style.font = "normal 13px sans-serif";
        element.style.textAlign = "center";
        element.style.opacity = "0.5";
        element.style.outline = "none";
        element.style.zIndex = "999";
      }
      if ("xr" in navigator) {
        stylizeElement(button);
        button.id = "VRButton";
        button.style.display = "none";
        navigator.xr.isSessionSupported("immersive-vr").then((supported) => {
          supported ? showEnterVR() : showWebXRNotFound();
          if (supported && _VRButton.xrSessionIsGranted) {
            button.click();
          }
        });
        return button;
      } else {
        const message = document.createElement("a");
        if (window.isSecureContext === false) {
          message.href = document.location.href.replace(/^http:/, "https:");
          message.innerHTML = "WEBXR NEEDS HTTPS";
        } else {
          message.href = "https://immersiveweb.dev/";
          message.innerHTML = "WEBXR NOT AVAILABLE";
        }
        message.style.left = "calc(50% - 90px)";
        message.style.width = "180px";
        message.style.textDecoration = "none";
        stylizeElement(message);
        return message;
      }
    }
    static registerSessionGrantedListener() {
      if (typeof navigator !== "undefined" && "xr" in navigator) {
        navigator.xr.addEventListener("sessiongranted", () => {
          _VRButton.xrSessionIsGranted = true;
        });
      }
    }
  };
  let VRButton2 = _VRButton;
  __publicField30(VRButton2, "xrSessionIsGranted", false);
  VRButton2.registerSessionGrantedListener();
  return VRButton2;
})();

// node_modules/three-stdlib/libs/MotionControllers.js
var MotionControllerConstants = {
  Handedness: {
    NONE: "none",
    LEFT: "left",
    RIGHT: "right"
  },
  ComponentState: {
    DEFAULT: "default",
    TOUCHED: "touched",
    PRESSED: "pressed"
  },
  ComponentProperty: {
    BUTTON: "button",
    X_AXIS: "xAxis",
    Y_AXIS: "yAxis",
    STATE: "state"
  },
  ComponentType: {
    TRIGGER: "trigger",
    SQUEEZE: "squeeze",
    TOUCHPAD: "touchpad",
    THUMBSTICK: "thumbstick",
    BUTTON: "button"
  },
  ButtonTouchThreshold: 0.05,
  AxisTouchThreshold: 0.1,
  VisualResponseProperty: {
    TRANSFORM: "transform",
    VISIBILITY: "visibility"
  }
};
var defaultComponentValues = {
  xAxis: 0,
  yAxis: 0,
  button: 0,
  state: MotionControllerConstants.ComponentState.DEFAULT
};

// node_modules/three-stdlib/webxr/XRHandPrimitiveModel.js
var _matrix4 = new Matrix4();
var _vector4 = new Vector3();

// node_modules/three-stdlib/geometries/RoundedBoxGeometry.js
var tempNormal = new Vector3();

// node_modules/three-stdlib/geometries/DecalGeometry.js
var DecalGeometry = class extends BufferGeometry {
  constructor(mesh, position2, orientation, size2) {
    super();
    const vertices = [];
    const normals = [];
    const uvs = [];
    const plane = new Vector3();
    const projectorMatrix = new Matrix4();
    projectorMatrix.makeRotationFromEuler(orientation);
    projectorMatrix.setPosition(position2);
    const projectorMatrixInverse = new Matrix4();
    projectorMatrixInverse.copy(projectorMatrix).invert();
    generate();
    this.setAttribute("position", new Float32BufferAttribute(vertices, 3));
    this.setAttribute("normal", new Float32BufferAttribute(normals, 3));
    this.setAttribute("uv", new Float32BufferAttribute(uvs, 2));
    function generate() {
      let i4;
      let decalVertices = [];
      const vertex = new Vector3();
      const normal2 = new Vector3();
      if (mesh.geometry.isGeometry === true) {
        console.error("THREE.DecalGeometry no longer supports THREE.Geometry. Use BufferGeometry instead.");
        return;
      }
      const geometry3 = mesh.geometry;
      const positionAttribute = geometry3.attributes.position;
      const normalAttribute = geometry3.attributes.normal;
      if (geometry3.index !== null) {
        const index2 = geometry3.index;
        for (i4 = 0; i4 < index2.count; i4++) {
          vertex.fromBufferAttribute(positionAttribute, index2.getX(i4));
          normal2.fromBufferAttribute(normalAttribute, index2.getX(i4));
          pushDecalVertex(decalVertices, vertex, normal2);
        }
      } else {
        for (i4 = 0; i4 < positionAttribute.count; i4++) {
          vertex.fromBufferAttribute(positionAttribute, i4);
          normal2.fromBufferAttribute(normalAttribute, i4);
          pushDecalVertex(decalVertices, vertex, normal2);
        }
      }
      decalVertices = clipGeometry(decalVertices, plane.set(1, 0, 0));
      decalVertices = clipGeometry(decalVertices, plane.set(-1, 0, 0));
      decalVertices = clipGeometry(decalVertices, plane.set(0, 1, 0));
      decalVertices = clipGeometry(decalVertices, plane.set(0, -1, 0));
      decalVertices = clipGeometry(decalVertices, plane.set(0, 0, 1));
      decalVertices = clipGeometry(decalVertices, plane.set(0, 0, -1));
      for (i4 = 0; i4 < decalVertices.length; i4++) {
        const decalVertex = decalVertices[i4];
        uvs.push(0.5 + decalVertex.position.x / size2.x, 0.5 + decalVertex.position.y / size2.y);
        decalVertex.position.applyMatrix4(projectorMatrix);
        vertices.push(decalVertex.position.x, decalVertex.position.y, decalVertex.position.z);
        normals.push(decalVertex.normal.x, decalVertex.normal.y, decalVertex.normal.z);
      }
    }
    function pushDecalVertex(decalVertices, vertex, normal2) {
      vertex.applyMatrix4(mesh.matrixWorld);
      vertex.applyMatrix4(projectorMatrixInverse);
      normal2.transformDirection(mesh.matrixWorld);
      decalVertices.push(new DecalVertex(vertex.clone(), normal2.clone()));
    }
    function clipGeometry(inVertices, plane2) {
      const outVertices = [];
      const s2 = 0.5 * Math.abs(size2.dot(plane2));
      for (let i4 = 0; i4 < inVertices.length; i4 += 3) {
        let v1Out, v2Out, v3Out, total = 0;
        let nV1, nV2, nV3, nV4;
        const d1 = inVertices[i4 + 0].position.dot(plane2) - s2;
        const d2 = inVertices[i4 + 1].position.dot(plane2) - s2;
        const d3 = inVertices[i4 + 2].position.dot(plane2) - s2;
        v1Out = d1 > 0;
        v2Out = d2 > 0;
        v3Out = d3 > 0;
        total = (v1Out ? 1 : 0) + (v2Out ? 1 : 0) + (v3Out ? 1 : 0);
        switch (total) {
          case 0: {
            outVertices.push(inVertices[i4]);
            outVertices.push(inVertices[i4 + 1]);
            outVertices.push(inVertices[i4 + 2]);
            break;
          }
          case 1: {
            if (v1Out) {
              nV1 = inVertices[i4 + 1];
              nV2 = inVertices[i4 + 2];
              nV3 = clip(inVertices[i4], nV1, plane2, s2);
              nV4 = clip(inVertices[i4], nV2, plane2, s2);
            }
            if (v2Out) {
              nV1 = inVertices[i4];
              nV2 = inVertices[i4 + 2];
              nV3 = clip(inVertices[i4 + 1], nV1, plane2, s2);
              nV4 = clip(inVertices[i4 + 1], nV2, plane2, s2);
              outVertices.push(nV3);
              outVertices.push(nV2.clone());
              outVertices.push(nV1.clone());
              outVertices.push(nV2.clone());
              outVertices.push(nV3.clone());
              outVertices.push(nV4);
              break;
            }
            if (v3Out) {
              nV1 = inVertices[i4];
              nV2 = inVertices[i4 + 1];
              nV3 = clip(inVertices[i4 + 2], nV1, plane2, s2);
              nV4 = clip(inVertices[i4 + 2], nV2, plane2, s2);
            }
            outVertices.push(nV1.clone());
            outVertices.push(nV2.clone());
            outVertices.push(nV3);
            outVertices.push(nV4);
            outVertices.push(nV3.clone());
            outVertices.push(nV2.clone());
            break;
          }
          case 2: {
            if (!v1Out) {
              nV1 = inVertices[i4].clone();
              nV2 = clip(nV1, inVertices[i4 + 1], plane2, s2);
              nV3 = clip(nV1, inVertices[i4 + 2], plane2, s2);
              outVertices.push(nV1);
              outVertices.push(nV2);
              outVertices.push(nV3);
            }
            if (!v2Out) {
              nV1 = inVertices[i4 + 1].clone();
              nV2 = clip(nV1, inVertices[i4 + 2], plane2, s2);
              nV3 = clip(nV1, inVertices[i4], plane2, s2);
              outVertices.push(nV1);
              outVertices.push(nV2);
              outVertices.push(nV3);
            }
            if (!v3Out) {
              nV1 = inVertices[i4 + 2].clone();
              nV2 = clip(nV1, inVertices[i4], plane2, s2);
              nV3 = clip(nV1, inVertices[i4 + 1], plane2, s2);
              outVertices.push(nV1);
              outVertices.push(nV2);
              outVertices.push(nV3);
            }
            break;
          }
        }
      }
      return outVertices;
    }
    function clip(v0, v13, p2, s2) {
      const d0 = v0.position.dot(p2) - s2;
      const d1 = v13.position.dot(p2) - s2;
      const s0 = d0 / (d0 - d1);
      const v5 = new DecalVertex(
        new Vector3(
          v0.position.x + s0 * (v13.position.x - v0.position.x),
          v0.position.y + s0 * (v13.position.y - v0.position.y),
          v0.position.z + s0 * (v13.position.z - v0.position.z)
        ),
        new Vector3(
          v0.normal.x + s0 * (v13.normal.x - v0.normal.x),
          v0.normal.y + s0 * (v13.normal.y - v0.normal.y),
          v0.normal.z + s0 * (v13.normal.z - v0.normal.z)
        )
      );
      return v5;
    }
  }
};
var DecalVertex = class {
  constructor(position2, normal2) {
    this.position = position2;
    this.normal = normal2;
  }
  clone() {
    return new this.constructor(this.position.clone(), this.normal.clone());
  }
};

// node_modules/three-stdlib/geometries/TextGeometry.js
var TextGeometry = class extends ExtrudeGeometry {
  constructor(text, parameters = {}) {
    const {
      bevelEnabled = false,
      bevelSize = 8,
      bevelThickness = 10,
      font,
      height = 50,
      size: size2 = 100,
      lineHeight = 1,
      letterSpacing = 0,
      ...rest
    } = parameters;
    if (font === void 0) {
      super();
    } else {
      const shapes = font.generateShapes(text, size2, { lineHeight, letterSpacing });
      super(shapes, { ...rest, bevelEnabled, bevelSize, bevelThickness, depth: height });
    }
    this.type = "TextGeometry";
  }
};

// node_modules/three-stdlib/csm/CSMFrustum.js
var inverseProjectionMatrix = new Matrix4();
var CSMFrustum = class _CSMFrustum {
  constructor(data) {
    data = data || {};
    this.vertices = {
      near: [new Vector3(), new Vector3(), new Vector3(), new Vector3()],
      far: [new Vector3(), new Vector3(), new Vector3(), new Vector3()]
    };
    if (data.projectionMatrix !== void 0) {
      this.setFromProjectionMatrix(data.projectionMatrix, data.maxFar || 1e4);
    }
  }
  setFromProjectionMatrix(projectionMatrix, maxFar) {
    const isOrthographic2 = projectionMatrix.elements[2 * 4 + 3] === 0;
    inverseProjectionMatrix.copy(projectionMatrix).invert();
    this.vertices.near[0].set(1, 1, -1);
    this.vertices.near[1].set(1, -1, -1);
    this.vertices.near[2].set(-1, -1, -1);
    this.vertices.near[3].set(-1, 1, -1);
    this.vertices.near.forEach(function(v5) {
      v5.applyMatrix4(inverseProjectionMatrix);
    });
    this.vertices.far[0].set(1, 1, 1);
    this.vertices.far[1].set(1, -1, 1);
    this.vertices.far[2].set(-1, -1, 1);
    this.vertices.far[3].set(-1, 1, 1);
    this.vertices.far.forEach(function(v5) {
      v5.applyMatrix4(inverseProjectionMatrix);
      const absZ = Math.abs(v5.z);
      if (isOrthographic2) {
        v5.z *= Math.min(maxFar / absZ, 1);
      } else {
        v5.multiplyScalar(Math.min(maxFar / absZ, 1));
      }
    });
    return this.vertices;
  }
  split(breaks, target2) {
    while (breaks.length > target2.length) {
      target2.push(new _CSMFrustum());
    }
    target2.length = breaks.length;
    for (let i4 = 0; i4 < breaks.length; i4++) {
      const cascade = target2[i4];
      if (i4 === 0) {
        for (let j = 0; j < 4; j++) {
          cascade.vertices.near[j].copy(this.vertices.near[j]);
        }
      } else {
        for (let j = 0; j < 4; j++) {
          cascade.vertices.near[j].lerpVectors(this.vertices.near[j], this.vertices.far[j], breaks[i4 - 1]);
        }
      }
      if (i4 === breaks.length - 1) {
        for (let j = 0; j < 4; j++) {
          cascade.vertices.far[j].copy(this.vertices.far[j]);
        }
      } else {
        for (let j = 0; j < 4; j++) {
          cascade.vertices.far[j].lerpVectors(this.vertices.near[j], this.vertices.far[j], breaks[i4]);
        }
      }
    }
  }
  toSpace(cameraMatrix, target2) {
    for (let i4 = 0; i4 < 4; i4++) {
      target2.vertices.near[i4].copy(this.vertices.near[i4]).applyMatrix4(cameraMatrix);
      target2.vertices.far[i4].copy(this.vertices.far[i4]).applyMatrix4(cameraMatrix);
    }
  }
};

// node_modules/three-stdlib/csm/CSM.js
var _cameraToLightMatrix = new Matrix4();
var _lightSpaceFrustum = new CSMFrustum();
var _center2 = new Vector3();
var _bbox = new Box3();

// node_modules/three-stdlib/shaders/ColorCorrectionShader.js
var ColorCorrectionShader = {
  uniforms: {
    tDiffuse: { value: null },
    powRGB: { value: new Vector3(2, 2, 2) },
    mulRGB: { value: new Vector3(1, 1, 1) },
    addRGB: { value: new Vector3(0, 0, 0) }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;

    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform sampler2D tDiffuse;
    uniform vec3 powRGB;
    uniform vec3 mulRGB;
    uniform vec3 addRGB;

    varying vec2 vUv;

    void main() {

    	gl_FragColor = texture2D( tDiffuse, vUv );
    	gl_FragColor.rgb = mulRGB * pow( ( gl_FragColor.rgb + addRGB ), powRGB );

    }
  `
  )
};

// node_modules/three-stdlib/shaders/ColorifyShader.js
var ColorifyShader = {
  uniforms: {
    tDiffuse: { value: null },
    color: { value: new Color(16777215) }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform vec3 color;
    uniform sampler2D tDiffuse;

    varying vec2 vUv;

    void main() {

    	vec4 texel = texture2D( tDiffuse, vUv );

    	vec3 luma = vec3( 0.299, 0.587, 0.114 );
    	float v = dot( texel.xyz, luma );

    	gl_FragColor = vec4( v * color, texel.w );

    }
  `
  )
};

// node_modules/three-stdlib/shaders/FXAAShader.js
var FXAAShader = {
  uniforms: {
    tDiffuse: { value: null },
    resolution: { value: new Vector2(1 / 1024, 1 / 512) }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    precision highp float;
    
    uniform sampler2D tDiffuse;
    
    uniform vec2 resolution;
    
    varying vec2 vUv;
    
    // FXAA 3.11 implementation by NVIDIA, ported to WebGL by Agost Biro (biro@archilogic.com)
    
    //----------------------------------------------------------------------------------
    // File:        es3-keplerFXAAassetsshaders/FXAA_DefaultES.frag
    // SDK Version: v3.00
    // Email:       gameworks@nvidia.com
    // Site:        http://developer.nvidia.com/
    //
    // Copyright (c) 2014-2015, NVIDIA CORPORATION. All rights reserved.
    //
    // Redistribution and use in source and binary forms, with or without
    // modification, are permitted provided that the following conditions
    // are met:
    //  * Redistributions of source code must retain the above copyright
    //    notice, this list of conditions and the following disclaimer.
    //  * Redistributions in binary form must reproduce the above copyright
    //    notice, this list of conditions and the following disclaimer in the
    //    documentation and/or other materials provided with the distribution.
    //  * Neither the name of NVIDIA CORPORATION nor the names of its
    //    contributors may be used to endorse or promote products derived
    //    from this software without specific prior written permission.
    //
    // THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AS IS AND ANY
    // EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    // IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
    // PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
    // CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
    // EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
    // PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
    // PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
    // OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    // (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
    // OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
    //
    //----------------------------------------------------------------------------------
    
    #define FXAA_PC 1
    #define FXAA_GLSL_100 1
    #define FXAA_QUALITY_PRESET 12
    
    #define FXAA_GREEN_AS_LUMA 1
    
    /*--------------------------------------------------------------------------*/
    #ifndef FXAA_PC_CONSOLE
        //
        // The console algorithm for PC is included
        // for developers targeting really low spec machines.
        // Likely better to just run FXAA_PC, and use a really low preset.
        //
        #define FXAA_PC_CONSOLE 0
    #endif
    /*--------------------------------------------------------------------------*/
    #ifndef FXAA_GLSL_120
        #define FXAA_GLSL_120 0
    #endif
    /*--------------------------------------------------------------------------*/
    #ifndef FXAA_GLSL_130
        #define FXAA_GLSL_130 0
    #endif
    /*--------------------------------------------------------------------------*/
    #ifndef FXAA_HLSL_3
        #define FXAA_HLSL_3 0
    #endif
    /*--------------------------------------------------------------------------*/
    #ifndef FXAA_HLSL_4
        #define FXAA_HLSL_4 0
    #endif
    /*--------------------------------------------------------------------------*/
    #ifndef FXAA_HLSL_5
        #define FXAA_HLSL_5 0
    #endif
    /*==========================================================================*/
    #ifndef FXAA_GREEN_AS_LUMA
        //
        // For those using non-linear color,
        // and either not able to get luma in alpha, or not wanting to,
        // this enables FXAA to run using green as a proxy for luma.
        // So with this enabled, no need to pack luma in alpha.
        //
        // This will turn off AA on anything which lacks some amount of green.
        // Pure red and blue or combination of only R and B, will get no AA.
        //
        // Might want to lower the settings for both,
        //    fxaaConsoleEdgeThresholdMin
        //    fxaaQualityEdgeThresholdMin
        // In order to insure AA does not get turned off on colors
        // which contain a minor amount of green.
        //
        // 1 = On.
        // 0 = Off.
        //
        #define FXAA_GREEN_AS_LUMA 0
    #endif
    /*--------------------------------------------------------------------------*/
    #ifndef FXAA_EARLY_EXIT
        //
        // Controls algorithms early exit path.
        // On PS3 turning this ON adds 2 cycles to the shader.
        // On 360 turning this OFF adds 10ths of a millisecond to the shader.
        // Turning this off on console will result in a more blurry image.
        // So this defaults to on.
        //
        // 1 = On.
        // 0 = Off.
        //
        #define FXAA_EARLY_EXIT 1
    #endif
    /*--------------------------------------------------------------------------*/
    #ifndef FXAA_DISCARD
        //
        // Only valid for PC OpenGL currently.
        // Probably will not work when FXAA_GREEN_AS_LUMA = 1.
        //
        // 1 = Use discard on pixels which dont need AA.
        //     For APIs which enable concurrent TEX+ROP from same surface.
        // 0 = Return unchanged color on pixels which dont need AA.
        //
        #define FXAA_DISCARD 0
    #endif
    /*--------------------------------------------------------------------------*/
    #ifndef FXAA_FAST_PIXEL_OFFSET
        //
        // Used for GLSL 120 only.
        //
        // 1 = GL API supports fast pixel offsets
        // 0 = do not use fast pixel offsets
        //
        #ifdef GL_EXT_gpu_shader4
            #define FXAA_FAST_PIXEL_OFFSET 1
        #endif
        #ifdef GL_NV_gpu_shader5
            #define FXAA_FAST_PIXEL_OFFSET 1
        #endif
        #ifdef GL_ARB_gpu_shader5
            #define FXAA_FAST_PIXEL_OFFSET 1
        #endif
        #ifndef FXAA_FAST_PIXEL_OFFSET
            #define FXAA_FAST_PIXEL_OFFSET 0
        #endif
    #endif
    /*--------------------------------------------------------------------------*/
    #ifndef FXAA_GATHER4_ALPHA
        //
        // 1 = API supports gather4 on alpha channel.
        // 0 = API does not support gather4 on alpha channel.
        //
        #if (FXAA_HLSL_5 == 1)
            #define FXAA_GATHER4_ALPHA 1
        #endif
        #ifdef GL_ARB_gpu_shader5
            #define FXAA_GATHER4_ALPHA 1
        #endif
        #ifdef GL_NV_gpu_shader5
            #define FXAA_GATHER4_ALPHA 1
        #endif
        #ifndef FXAA_GATHER4_ALPHA
            #define FXAA_GATHER4_ALPHA 0
        #endif
    #endif
    
    
    /*============================================================================
                            FXAA QUALITY - TUNING KNOBS
    ------------------------------------------------------------------------------
    NOTE the other tuning knobs are now in the shader function inputs!
    ============================================================================*/
    #ifndef FXAA_QUALITY_PRESET
        //
        // Choose the quality preset.
        // This needs to be compiled into the shader as it effects code.
        // Best option to include multiple presets is to
        // in each shader define the preset, then include this file.
        //
        // OPTIONS
        // -----------------------------------------------------------------------
        // 10 to 15 - default medium dither (10=fastest, 15=highest quality)
        // 20 to 29 - less dither, more expensive (20=fastest, 29=highest quality)
        // 39       - no dither, very expensive
        //
        // NOTES
        // -----------------------------------------------------------------------
        // 12 = slightly faster then FXAA 3.9 and higher edge quality (default)
        // 13 = about same speed as FXAA 3.9 and better than 12
        // 23 = closest to FXAA 3.9 visually and performance wise
        //  _ = the lowest digit is directly related to performance
        // _  = the highest digit is directly related to style
        //
        #define FXAA_QUALITY_PRESET 12
    #endif
    
    
    /*============================================================================
    
                               FXAA QUALITY - PRESETS
    
    ============================================================================*/
    
    /*============================================================================
                         FXAA QUALITY - MEDIUM DITHER PRESETS
    ============================================================================*/
    #if (FXAA_QUALITY_PRESET == 10)
        #define FXAA_QUALITY_PS 3
        #define FXAA_QUALITY_P0 1.5
        #define FXAA_QUALITY_P1 3.0
        #define FXAA_QUALITY_P2 12.0
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_QUALITY_PRESET == 11)
        #define FXAA_QUALITY_PS 4
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.5
        #define FXAA_QUALITY_P2 3.0
        #define FXAA_QUALITY_P3 12.0
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_QUALITY_PRESET == 12)
        #define FXAA_QUALITY_PS 5
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.5
        #define FXAA_QUALITY_P2 2.0
        #define FXAA_QUALITY_P3 4.0
        #define FXAA_QUALITY_P4 12.0
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_QUALITY_PRESET == 13)
        #define FXAA_QUALITY_PS 6
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.5
        #define FXAA_QUALITY_P2 2.0
        #define FXAA_QUALITY_P3 2.0
        #define FXAA_QUALITY_P4 4.0
        #define FXAA_QUALITY_P5 12.0
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_QUALITY_PRESET == 14)
        #define FXAA_QUALITY_PS 7
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.5
        #define FXAA_QUALITY_P2 2.0
        #define FXAA_QUALITY_P3 2.0
        #define FXAA_QUALITY_P4 2.0
        #define FXAA_QUALITY_P5 4.0
        #define FXAA_QUALITY_P6 12.0
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_QUALITY_PRESET == 15)
        #define FXAA_QUALITY_PS 8
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.5
        #define FXAA_QUALITY_P2 2.0
        #define FXAA_QUALITY_P3 2.0
        #define FXAA_QUALITY_P4 2.0
        #define FXAA_QUALITY_P5 2.0
        #define FXAA_QUALITY_P6 4.0
        #define FXAA_QUALITY_P7 12.0
    #endif
    
    /*============================================================================
                         FXAA QUALITY - LOW DITHER PRESETS
    ============================================================================*/
    #if (FXAA_QUALITY_PRESET == 20)
        #define FXAA_QUALITY_PS 3
        #define FXAA_QUALITY_P0 1.5
        #define FXAA_QUALITY_P1 2.0
        #define FXAA_QUALITY_P2 8.0
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_QUALITY_PRESET == 21)
        #define FXAA_QUALITY_PS 4
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.5
        #define FXAA_QUALITY_P2 2.0
        #define FXAA_QUALITY_P3 8.0
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_QUALITY_PRESET == 22)
        #define FXAA_QUALITY_PS 5
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.5
        #define FXAA_QUALITY_P2 2.0
        #define FXAA_QUALITY_P3 2.0
        #define FXAA_QUALITY_P4 8.0
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_QUALITY_PRESET == 23)
        #define FXAA_QUALITY_PS 6
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.5
        #define FXAA_QUALITY_P2 2.0
        #define FXAA_QUALITY_P3 2.0
        #define FXAA_QUALITY_P4 2.0
        #define FXAA_QUALITY_P5 8.0
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_QUALITY_PRESET == 24)
        #define FXAA_QUALITY_PS 7
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.5
        #define FXAA_QUALITY_P2 2.0
        #define FXAA_QUALITY_P3 2.0
        #define FXAA_QUALITY_P4 2.0
        #define FXAA_QUALITY_P5 3.0
        #define FXAA_QUALITY_P6 8.0
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_QUALITY_PRESET == 25)
        #define FXAA_QUALITY_PS 8
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.5
        #define FXAA_QUALITY_P2 2.0
        #define FXAA_QUALITY_P3 2.0
        #define FXAA_QUALITY_P4 2.0
        #define FXAA_QUALITY_P5 2.0
        #define FXAA_QUALITY_P6 4.0
        #define FXAA_QUALITY_P7 8.0
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_QUALITY_PRESET == 26)
        #define FXAA_QUALITY_PS 9
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.5
        #define FXAA_QUALITY_P2 2.0
        #define FXAA_QUALITY_P3 2.0
        #define FXAA_QUALITY_P4 2.0
        #define FXAA_QUALITY_P5 2.0
        #define FXAA_QUALITY_P6 2.0
        #define FXAA_QUALITY_P7 4.0
        #define FXAA_QUALITY_P8 8.0
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_QUALITY_PRESET == 27)
        #define FXAA_QUALITY_PS 10
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.5
        #define FXAA_QUALITY_P2 2.0
        #define FXAA_QUALITY_P3 2.0
        #define FXAA_QUALITY_P4 2.0
        #define FXAA_QUALITY_P5 2.0
        #define FXAA_QUALITY_P6 2.0
        #define FXAA_QUALITY_P7 2.0
        #define FXAA_QUALITY_P8 4.0
        #define FXAA_QUALITY_P9 8.0
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_QUALITY_PRESET == 28)
        #define FXAA_QUALITY_PS 11
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.5
        #define FXAA_QUALITY_P2 2.0
        #define FXAA_QUALITY_P3 2.0
        #define FXAA_QUALITY_P4 2.0
        #define FXAA_QUALITY_P5 2.0
        #define FXAA_QUALITY_P6 2.0
        #define FXAA_QUALITY_P7 2.0
        #define FXAA_QUALITY_P8 2.0
        #define FXAA_QUALITY_P9 4.0
        #define FXAA_QUALITY_P10 8.0
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_QUALITY_PRESET == 29)
        #define FXAA_QUALITY_PS 12
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.5
        #define FXAA_QUALITY_P2 2.0
        #define FXAA_QUALITY_P3 2.0
        #define FXAA_QUALITY_P4 2.0
        #define FXAA_QUALITY_P5 2.0
        #define FXAA_QUALITY_P6 2.0
        #define FXAA_QUALITY_P7 2.0
        #define FXAA_QUALITY_P8 2.0
        #define FXAA_QUALITY_P9 2.0
        #define FXAA_QUALITY_P10 4.0
        #define FXAA_QUALITY_P11 8.0
    #endif
    
    /*============================================================================
                         FXAA QUALITY - EXTREME QUALITY
    ============================================================================*/
    #if (FXAA_QUALITY_PRESET == 39)
        #define FXAA_QUALITY_PS 12
        #define FXAA_QUALITY_P0 1.0
        #define FXAA_QUALITY_P1 1.0
        #define FXAA_QUALITY_P2 1.0
        #define FXAA_QUALITY_P3 1.0
        #define FXAA_QUALITY_P4 1.0
        #define FXAA_QUALITY_P5 1.5
        #define FXAA_QUALITY_P6 2.0
        #define FXAA_QUALITY_P7 2.0
        #define FXAA_QUALITY_P8 2.0
        #define FXAA_QUALITY_P9 2.0
        #define FXAA_QUALITY_P10 4.0
        #define FXAA_QUALITY_P11 8.0
    #endif
    
    
    
    /*============================================================================
    
                                    API PORTING
    
    ============================================================================*/
    #if (FXAA_GLSL_100 == 1) || (FXAA_GLSL_120 == 1) || (FXAA_GLSL_130 == 1)
        #define FxaaBool bool
        #define FxaaDiscard discard
        #define FxaaFloat float
        #define FxaaFloat2 vec2
        #define FxaaFloat3 vec3
        #define FxaaFloat4 vec4
        #define FxaaHalf float
        #define FxaaHalf2 vec2
        #define FxaaHalf3 vec3
        #define FxaaHalf4 vec4
        #define FxaaInt2 ivec2
        #define FxaaSat(x) clamp(x, 0.0, 1.0)
        #define FxaaTex sampler2D
    #else
        #define FxaaBool bool
        #define FxaaDiscard clip(-1)
        #define FxaaFloat float
        #define FxaaFloat2 float2
        #define FxaaFloat3 float3
        #define FxaaFloat4 float4
        #define FxaaHalf half
        #define FxaaHalf2 half2
        #define FxaaHalf3 half3
        #define FxaaHalf4 half4
        #define FxaaSat(x) saturate(x)
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_GLSL_100 == 1)
      #define FxaaTexTop(t, p) texture2D(t, p, 0.0)
      #define FxaaTexOff(t, p, o, r) texture2D(t, p + (o * r), 0.0)
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_GLSL_120 == 1)
        // Requires,
        //  #version 120
        // And at least,
        //  #extension GL_EXT_gpu_shader4 : enable
        //  (or set FXAA_FAST_PIXEL_OFFSET 1 to work like DX9)
        #define FxaaTexTop(t, p) texture2DLod(t, p, 0.0)
        #if (FXAA_FAST_PIXEL_OFFSET == 1)
            #define FxaaTexOff(t, p, o, r) texture2DLodOffset(t, p, 0.0, o)
        #else
            #define FxaaTexOff(t, p, o, r) texture2DLod(t, p + (o * r), 0.0)
        #endif
        #if (FXAA_GATHER4_ALPHA == 1)
            // use #extension GL_ARB_gpu_shader5 : enable
            #define FxaaTexAlpha4(t, p) textureGather(t, p, 3)
            #define FxaaTexOffAlpha4(t, p, o) textureGatherOffset(t, p, o, 3)
            #define FxaaTexGreen4(t, p) textureGather(t, p, 1)
            #define FxaaTexOffGreen4(t, p, o) textureGatherOffset(t, p, o, 1)
        #endif
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_GLSL_130 == 1)
        // Requires "#version 130" or better
        #define FxaaTexTop(t, p) textureLod(t, p, 0.0)
        #define FxaaTexOff(t, p, o, r) textureLodOffset(t, p, 0.0, o)
        #if (FXAA_GATHER4_ALPHA == 1)
            // use #extension GL_ARB_gpu_shader5 : enable
            #define FxaaTexAlpha4(t, p) textureGather(t, p, 3)
            #define FxaaTexOffAlpha4(t, p, o) textureGatherOffset(t, p, o, 3)
            #define FxaaTexGreen4(t, p) textureGather(t, p, 1)
            #define FxaaTexOffGreen4(t, p, o) textureGatherOffset(t, p, o, 1)
        #endif
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_HLSL_3 == 1)
        #define FxaaInt2 float2
        #define FxaaTex sampler2D
        #define FxaaTexTop(t, p) tex2Dlod(t, float4(p, 0.0, 0.0))
        #define FxaaTexOff(t, p, o, r) tex2Dlod(t, float4(p + (o * r), 0, 0))
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_HLSL_4 == 1)
        #define FxaaInt2 int2
        struct FxaaTex { SamplerState smpl; Texture2D tex; };
        #define FxaaTexTop(t, p) t.tex.SampleLevel(t.smpl, p, 0.0)
        #define FxaaTexOff(t, p, o, r) t.tex.SampleLevel(t.smpl, p, 0.0, o)
    #endif
    /*--------------------------------------------------------------------------*/
    #if (FXAA_HLSL_5 == 1)
        #define FxaaInt2 int2
        struct FxaaTex { SamplerState smpl; Texture2D tex; };
        #define FxaaTexTop(t, p) t.tex.SampleLevel(t.smpl, p, 0.0)
        #define FxaaTexOff(t, p, o, r) t.tex.SampleLevel(t.smpl, p, 0.0, o)
        #define FxaaTexAlpha4(t, p) t.tex.GatherAlpha(t.smpl, p)
        #define FxaaTexOffAlpha4(t, p, o) t.tex.GatherAlpha(t.smpl, p, o)
        #define FxaaTexGreen4(t, p) t.tex.GatherGreen(t.smpl, p)
        #define FxaaTexOffGreen4(t, p, o) t.tex.GatherGreen(t.smpl, p, o)
    #endif
    
    
    /*============================================================================
                       GREEN AS LUMA OPTION SUPPORT FUNCTION
    ============================================================================*/
    #if (FXAA_GREEN_AS_LUMA == 0)
        FxaaFloat FxaaLuma(FxaaFloat4 rgba) { return rgba.w; }
    #else
        FxaaFloat FxaaLuma(FxaaFloat4 rgba) { return rgba.y; }
    #endif
    
    
    
    
    /*============================================================================
    
                                 FXAA3 QUALITY - PC
    
    ============================================================================*/
    #if (FXAA_PC == 1)
    /*--------------------------------------------------------------------------*/
    FxaaFloat4 FxaaPixelShader(
        //
        // Use noperspective interpolation here (turn off perspective interpolation).
        // {xy} = center of pixel
        FxaaFloat2 pos,
        //
        // Used only for FXAA Console, and not used on the 360 version.
        // Use noperspective interpolation here (turn off perspective interpolation).
        // {xy_} = upper left of pixel
        // {_zw} = lower right of pixel
        FxaaFloat4 fxaaConsolePosPos,
        //
        // Input color texture.
        // {rgb_} = color in linear or perceptual color space
        // if (FXAA_GREEN_AS_LUMA == 0)
        //     {__a} = luma in perceptual color space (not linear)
        FxaaTex tex,
        //
        // Only used on the optimized 360 version of FXAA Console.
        // For everything but 360, just use the same input here as for "tex".
        // For 360, same texture, just alias with a 2nd sampler.
        // This sampler needs to have an exponent bias of -1.
        FxaaTex fxaaConsole360TexExpBiasNegOne,
        //
        // Only used on the optimized 360 version of FXAA Console.
        // For everything but 360, just use the same input here as for "tex".
        // For 360, same texture, just alias with a 3nd sampler.
        // This sampler needs to have an exponent bias of -2.
        FxaaTex fxaaConsole360TexExpBiasNegTwo,
        //
        // Only used on FXAA Quality.
        // This must be from a constant/uniform.
        // {x_} = 1.0/screenWidthInPixels
        // {_y} = 1.0/screenHeightInPixels
        FxaaFloat2 fxaaQualityRcpFrame,
        //
        // Only used on FXAA Console.
        // This must be from a constant/uniform.
        // This effects sub-pixel AA quality and inversely sharpness.
        //   Where N ranges between,
        //     N = 0.50 (default)
        //     N = 0.33 (sharper)
        // {x__} = -N/screenWidthInPixels
        // {_y_} = -N/screenHeightInPixels
        // {_z_} =  N/screenWidthInPixels
        // {__w} =  N/screenHeightInPixels
        FxaaFloat4 fxaaConsoleRcpFrameOpt,
        //
        // Only used on FXAA Console.
        // Not used on 360, but used on PS3 and PC.
        // This must be from a constant/uniform.
        // {x__} = -2.0/screenWidthInPixels
        // {_y_} = -2.0/screenHeightInPixels
        // {_z_} =  2.0/screenWidthInPixels
        // {__w} =  2.0/screenHeightInPixels
        FxaaFloat4 fxaaConsoleRcpFrameOpt2,
        //
        // Only used on FXAA Console.
        // Only used on 360 in place of fxaaConsoleRcpFrameOpt2.
        // This must be from a constant/uniform.
        // {x__} =  8.0/screenWidthInPixels
        // {_y_} =  8.0/screenHeightInPixels
        // {_z_} = -4.0/screenWidthInPixels
        // {__w} = -4.0/screenHeightInPixels
        FxaaFloat4 fxaaConsole360RcpFrameOpt2,
        //
        // Only used on FXAA Quality.
        // This used to be the FXAA_QUALITY_SUBPIX define.
        // It is here now to allow easier tuning.
        // Choose the amount of sub-pixel aliasing removal.
        // This can effect sharpness.
        //   1.00 - upper limit (softer)
        //   0.75 - default amount of filtering
        //   0.50 - lower limit (sharper, less sub-pixel aliasing removal)
        //   0.25 - almost off
        //   0.00 - completely off
        FxaaFloat fxaaQualitySubpix,
        //
        // Only used on FXAA Quality.
        // This used to be the FXAA_QUALITY_EDGE_THRESHOLD define.
        // It is here now to allow easier tuning.
        // The minimum amount of local contrast required to apply algorithm.
        //   0.333 - too little (faster)
        //   0.250 - low quality
        //   0.166 - default
        //   0.125 - high quality
        //   0.063 - overkill (slower)
        FxaaFloat fxaaQualityEdgeThreshold,
        //
        // Only used on FXAA Quality.
        // This used to be the FXAA_QUALITY_EDGE_THRESHOLD_MIN define.
        // It is here now to allow easier tuning.
        // Trims the algorithm from processing darks.
        //   0.0833 - upper limit (default, the start of visible unfiltered edges)
        //   0.0625 - high quality (faster)
        //   0.0312 - visible limit (slower)
        // Special notes when using FXAA_GREEN_AS_LUMA,
        //   Likely want to set this to zero.
        //   As colors that are mostly not-green
        //   will appear very dark in the green channel!
        //   Tune by looking at mostly non-green content,
        //   then start at zero and increase until aliasing is a problem.
        FxaaFloat fxaaQualityEdgeThresholdMin,
        //
        // Only used on FXAA Console.
        // This used to be the FXAA_CONSOLE_EDGE_SHARPNESS define.
        // It is here now to allow easier tuning.
        // This does not effect PS3, as this needs to be compiled in.
        //   Use FXAA_CONSOLE_PS3_EDGE_SHARPNESS for PS3.
        //   Due to the PS3 being ALU bound,
        //   there are only three safe values here: 2 and 4 and 8.
        //   These options use the shaders ability to a free *|/ by 2|4|8.
        // For all other platforms can be a non-power of two.
        //   8.0 is sharper (default!!!)
        //   4.0 is softer
        //   2.0 is really soft (good only for vector graphics inputs)
        FxaaFloat fxaaConsoleEdgeSharpness,
        //
        // Only used on FXAA Console.
        // This used to be the FXAA_CONSOLE_EDGE_THRESHOLD define.
        // It is here now to allow easier tuning.
        // This does not effect PS3, as this needs to be compiled in.
        //   Use FXAA_CONSOLE_PS3_EDGE_THRESHOLD for PS3.
        //   Due to the PS3 being ALU bound,
        //   there are only two safe values here: 1/4 and 1/8.
        //   These options use the shaders ability to a free *|/ by 2|4|8.
        // The console setting has a different mapping than the quality setting.
        // Other platforms can use other values.
        //   0.125 leaves less aliasing, but is softer (default!!!)
        //   0.25 leaves more aliasing, and is sharper
        FxaaFloat fxaaConsoleEdgeThreshold,
        //
        // Only used on FXAA Console.
        // This used to be the FXAA_CONSOLE_EDGE_THRESHOLD_MIN define.
        // It is here now to allow easier tuning.
        // Trims the algorithm from processing darks.
        // The console setting has a different mapping than the quality setting.
        // This only applies when FXAA_EARLY_EXIT is 1.
        // This does not apply to PS3,
        // PS3 was simplified to avoid more shader instructions.
        //   0.06 - faster but more aliasing in darks
        //   0.05 - default
        //   0.04 - slower and less aliasing in darks
        // Special notes when using FXAA_GREEN_AS_LUMA,
        //   Likely want to set this to zero.
        //   As colors that are mostly not-green
        //   will appear very dark in the green channel!
        //   Tune by looking at mostly non-green content,
        //   then start at zero and increase until aliasing is a problem.
        FxaaFloat fxaaConsoleEdgeThresholdMin,
        //
        // Extra constants for 360 FXAA Console only.
        // Use zeros or anything else for other platforms.
        // These must be in physical constant registers and NOT immediates.
        // Immediates will result in compiler un-optimizing.
        // {xyzw} = float4(1.0, -1.0, 0.25, -0.25)
        FxaaFloat4 fxaaConsole360ConstDir
    ) {
    /*--------------------------------------------------------------------------*/
        FxaaFloat2 posM;
        posM.x = pos.x;
        posM.y = pos.y;
        #if (FXAA_GATHER4_ALPHA == 1)
            #if (FXAA_DISCARD == 0)
                FxaaFloat4 rgbyM = FxaaTexTop(tex, posM);
                #if (FXAA_GREEN_AS_LUMA == 0)
                    #define lumaM rgbyM.w
                #else
                    #define lumaM rgbyM.y
                #endif
            #endif
            #if (FXAA_GREEN_AS_LUMA == 0)
                FxaaFloat4 luma4A = FxaaTexAlpha4(tex, posM);
                FxaaFloat4 luma4B = FxaaTexOffAlpha4(tex, posM, FxaaInt2(-1, -1));
            #else
                FxaaFloat4 luma4A = FxaaTexGreen4(tex, posM);
                FxaaFloat4 luma4B = FxaaTexOffGreen4(tex, posM, FxaaInt2(-1, -1));
            #endif
            #if (FXAA_DISCARD == 1)
                #define lumaM luma4A.w
            #endif
            #define lumaE luma4A.z
            #define lumaS luma4A.x
            #define lumaSE luma4A.y
            #define lumaNW luma4B.w
            #define lumaN luma4B.z
            #define lumaW luma4B.x
        #else
            FxaaFloat4 rgbyM = FxaaTexTop(tex, posM);
            #if (FXAA_GREEN_AS_LUMA == 0)
                #define lumaM rgbyM.w
            #else
                #define lumaM rgbyM.y
            #endif
            #if (FXAA_GLSL_100 == 1)
              FxaaFloat lumaS = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2( 0.0, 1.0), fxaaQualityRcpFrame.xy));
              FxaaFloat lumaE = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2( 1.0, 0.0), fxaaQualityRcpFrame.xy));
              FxaaFloat lumaN = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2( 0.0,-1.0), fxaaQualityRcpFrame.xy));
              FxaaFloat lumaW = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2(-1.0, 0.0), fxaaQualityRcpFrame.xy));
            #else
              FxaaFloat lumaS = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2( 0, 1), fxaaQualityRcpFrame.xy));
              FxaaFloat lumaE = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2( 1, 0), fxaaQualityRcpFrame.xy));
              FxaaFloat lumaN = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2( 0,-1), fxaaQualityRcpFrame.xy));
              FxaaFloat lumaW = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2(-1, 0), fxaaQualityRcpFrame.xy));
            #endif
        #endif
    /*--------------------------------------------------------------------------*/
        FxaaFloat maxSM = max(lumaS, lumaM);
        FxaaFloat minSM = min(lumaS, lumaM);
        FxaaFloat maxESM = max(lumaE, maxSM);
        FxaaFloat minESM = min(lumaE, minSM);
        FxaaFloat maxWN = max(lumaN, lumaW);
        FxaaFloat minWN = min(lumaN, lumaW);
        FxaaFloat rangeMax = max(maxWN, maxESM);
        FxaaFloat rangeMin = min(minWN, minESM);
        FxaaFloat rangeMaxScaled = rangeMax * fxaaQualityEdgeThreshold;
        FxaaFloat range = rangeMax - rangeMin;
        FxaaFloat rangeMaxClamped = max(fxaaQualityEdgeThresholdMin, rangeMaxScaled);
        FxaaBool earlyExit = range < rangeMaxClamped;
    /*--------------------------------------------------------------------------*/
        if(earlyExit)
            #if (FXAA_DISCARD == 1)
                FxaaDiscard;
            #else
                return rgbyM;
            #endif
    /*--------------------------------------------------------------------------*/
        #if (FXAA_GATHER4_ALPHA == 0)
            #if (FXAA_GLSL_100 == 1)
              FxaaFloat lumaNW = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2(-1.0,-1.0), fxaaQualityRcpFrame.xy));
              FxaaFloat lumaSE = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2( 1.0, 1.0), fxaaQualityRcpFrame.xy));
              FxaaFloat lumaNE = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2( 1.0,-1.0), fxaaQualityRcpFrame.xy));
              FxaaFloat lumaSW = FxaaLuma(FxaaTexOff(tex, posM, FxaaFloat2(-1.0, 1.0), fxaaQualityRcpFrame.xy));
            #else
              FxaaFloat lumaNW = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2(-1,-1), fxaaQualityRcpFrame.xy));
              FxaaFloat lumaSE = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2( 1, 1), fxaaQualityRcpFrame.xy));
              FxaaFloat lumaNE = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2( 1,-1), fxaaQualityRcpFrame.xy));
              FxaaFloat lumaSW = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2(-1, 1), fxaaQualityRcpFrame.xy));
            #endif
        #else
            FxaaFloat lumaNE = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2(1, -1), fxaaQualityRcpFrame.xy));
            FxaaFloat lumaSW = FxaaLuma(FxaaTexOff(tex, posM, FxaaInt2(-1, 1), fxaaQualityRcpFrame.xy));
        #endif
    /*--------------------------------------------------------------------------*/
        FxaaFloat lumaNS = lumaN + lumaS;
        FxaaFloat lumaWE = lumaW + lumaE;
        FxaaFloat subpixRcpRange = 1.0/range;
        FxaaFloat subpixNSWE = lumaNS + lumaWE;
        FxaaFloat edgeHorz1 = (-2.0 * lumaM) + lumaNS;
        FxaaFloat edgeVert1 = (-2.0 * lumaM) + lumaWE;
    /*--------------------------------------------------------------------------*/
        FxaaFloat lumaNESE = lumaNE + lumaSE;
        FxaaFloat lumaNWNE = lumaNW + lumaNE;
        FxaaFloat edgeHorz2 = (-2.0 * lumaE) + lumaNESE;
        FxaaFloat edgeVert2 = (-2.0 * lumaN) + lumaNWNE;
    /*--------------------------------------------------------------------------*/
        FxaaFloat lumaNWSW = lumaNW + lumaSW;
        FxaaFloat lumaSWSE = lumaSW + lumaSE;
        FxaaFloat edgeHorz4 = (abs(edgeHorz1) * 2.0) + abs(edgeHorz2);
        FxaaFloat edgeVert4 = (abs(edgeVert1) * 2.0) + abs(edgeVert2);
        FxaaFloat edgeHorz3 = (-2.0 * lumaW) + lumaNWSW;
        FxaaFloat edgeVert3 = (-2.0 * lumaS) + lumaSWSE;
        FxaaFloat edgeHorz = abs(edgeHorz3) + edgeHorz4;
        FxaaFloat edgeVert = abs(edgeVert3) + edgeVert4;
    /*--------------------------------------------------------------------------*/
        FxaaFloat subpixNWSWNESE = lumaNWSW + lumaNESE;
        FxaaFloat lengthSign = fxaaQualityRcpFrame.x;
        FxaaBool horzSpan = edgeHorz >= edgeVert;
        FxaaFloat subpixA = subpixNSWE * 2.0 + subpixNWSWNESE;
    /*--------------------------------------------------------------------------*/
        if(!horzSpan) lumaN = lumaW;
        if(!horzSpan) lumaS = lumaE;
        if(horzSpan) lengthSign = fxaaQualityRcpFrame.y;
        FxaaFloat subpixB = (subpixA * (1.0/12.0)) - lumaM;
    /*--------------------------------------------------------------------------*/
        FxaaFloat gradientN = lumaN - lumaM;
        FxaaFloat gradientS = lumaS - lumaM;
        FxaaFloat lumaNN = lumaN + lumaM;
        FxaaFloat lumaSS = lumaS + lumaM;
        FxaaBool pairN = abs(gradientN) >= abs(gradientS);
        FxaaFloat gradient = max(abs(gradientN), abs(gradientS));
        if(pairN) lengthSign = -lengthSign;
        FxaaFloat subpixC = FxaaSat(abs(subpixB) * subpixRcpRange);
    /*--------------------------------------------------------------------------*/
        FxaaFloat2 posB;
        posB.x = posM.x;
        posB.y = posM.y;
        FxaaFloat2 offNP;
        offNP.x = (!horzSpan) ? 0.0 : fxaaQualityRcpFrame.x;
        offNP.y = ( horzSpan) ? 0.0 : fxaaQualityRcpFrame.y;
        if(!horzSpan) posB.x += lengthSign * 0.5;
        if( horzSpan) posB.y += lengthSign * 0.5;
    /*--------------------------------------------------------------------------*/
        FxaaFloat2 posN;
        posN.x = posB.x - offNP.x * FXAA_QUALITY_P0;
        posN.y = posB.y - offNP.y * FXAA_QUALITY_P0;
        FxaaFloat2 posP;
        posP.x = posB.x + offNP.x * FXAA_QUALITY_P0;
        posP.y = posB.y + offNP.y * FXAA_QUALITY_P0;
        FxaaFloat subpixD = ((-2.0)*subpixC) + 3.0;
        FxaaFloat lumaEndN = FxaaLuma(FxaaTexTop(tex, posN));
        FxaaFloat subpixE = subpixC * subpixC;
        FxaaFloat lumaEndP = FxaaLuma(FxaaTexTop(tex, posP));
    /*--------------------------------------------------------------------------*/
        if(!pairN) lumaNN = lumaSS;
        FxaaFloat gradientScaled = gradient * 1.0/4.0;
        FxaaFloat lumaMM = lumaM - lumaNN * 0.5;
        FxaaFloat subpixF = subpixD * subpixE;
        FxaaBool lumaMLTZero = lumaMM < 0.0;
    /*--------------------------------------------------------------------------*/
        lumaEndN -= lumaNN * 0.5;
        lumaEndP -= lumaNN * 0.5;
        FxaaBool doneN = abs(lumaEndN) >= gradientScaled;
        FxaaBool doneP = abs(lumaEndP) >= gradientScaled;
        if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P1;
        if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P1;
        FxaaBool doneNP = (!doneN) || (!doneP);
        if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P1;
        if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P1;
    /*--------------------------------------------------------------------------*/
        if(doneNP) {
            if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
            if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
            if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
            if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
            doneN = abs(lumaEndN) >= gradientScaled;
            doneP = abs(lumaEndP) >= gradientScaled;
            if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P2;
            if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P2;
            doneNP = (!doneN) || (!doneP);
            if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P2;
            if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P2;
    /*--------------------------------------------------------------------------*/
            #if (FXAA_QUALITY_PS > 3)
            if(doneNP) {
                if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                doneN = abs(lumaEndN) >= gradientScaled;
                doneP = abs(lumaEndP) >= gradientScaled;
                if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P3;
                if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P3;
                doneNP = (!doneN) || (!doneP);
                if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P3;
                if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P3;
    /*--------------------------------------------------------------------------*/
                #if (FXAA_QUALITY_PS > 4)
                if(doneNP) {
                    if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                    if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                    if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                    if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                    doneN = abs(lumaEndN) >= gradientScaled;
                    doneP = abs(lumaEndP) >= gradientScaled;
                    if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P4;
                    if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P4;
                    doneNP = (!doneN) || (!doneP);
                    if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P4;
                    if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P4;
    /*--------------------------------------------------------------------------*/
                    #if (FXAA_QUALITY_PS > 5)
                    if(doneNP) {
                        if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                        if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                        if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                        if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                        doneN = abs(lumaEndN) >= gradientScaled;
                        doneP = abs(lumaEndP) >= gradientScaled;
                        if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P5;
                        if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P5;
                        doneNP = (!doneN) || (!doneP);
                        if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P5;
                        if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P5;
    /*--------------------------------------------------------------------------*/
                        #if (FXAA_QUALITY_PS > 6)
                        if(doneNP) {
                            if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                            if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                            if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                            if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                            doneN = abs(lumaEndN) >= gradientScaled;
                            doneP = abs(lumaEndP) >= gradientScaled;
                            if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P6;
                            if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P6;
                            doneNP = (!doneN) || (!doneP);
                            if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P6;
                            if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P6;
    /*--------------------------------------------------------------------------*/
                            #if (FXAA_QUALITY_PS > 7)
                            if(doneNP) {
                                if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                                if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                                if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                                if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                                doneN = abs(lumaEndN) >= gradientScaled;
                                doneP = abs(lumaEndP) >= gradientScaled;
                                if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P7;
                                if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P7;
                                doneNP = (!doneN) || (!doneP);
                                if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P7;
                                if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P7;
    /*--------------------------------------------------------------------------*/
        #if (FXAA_QUALITY_PS > 8)
        if(doneNP) {
            if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
            if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
            if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
            if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
            doneN = abs(lumaEndN) >= gradientScaled;
            doneP = abs(lumaEndP) >= gradientScaled;
            if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P8;
            if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P8;
            doneNP = (!doneN) || (!doneP);
            if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P8;
            if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P8;
    /*--------------------------------------------------------------------------*/
            #if (FXAA_QUALITY_PS > 9)
            if(doneNP) {
                if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                doneN = abs(lumaEndN) >= gradientScaled;
                doneP = abs(lumaEndP) >= gradientScaled;
                if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P9;
                if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P9;
                doneNP = (!doneN) || (!doneP);
                if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P9;
                if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P9;
    /*--------------------------------------------------------------------------*/
                #if (FXAA_QUALITY_PS > 10)
                if(doneNP) {
                    if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                    if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                    if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                    if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                    doneN = abs(lumaEndN) >= gradientScaled;
                    doneP = abs(lumaEndP) >= gradientScaled;
                    if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P10;
                    if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P10;
                    doneNP = (!doneN) || (!doneP);
                    if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P10;
                    if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P10;
    /*--------------------------------------------------------------------------*/
                    #if (FXAA_QUALITY_PS > 11)
                    if(doneNP) {
                        if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                        if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                        if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                        if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                        doneN = abs(lumaEndN) >= gradientScaled;
                        doneP = abs(lumaEndP) >= gradientScaled;
                        if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P11;
                        if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P11;
                        doneNP = (!doneN) || (!doneP);
                        if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P11;
                        if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P11;
    /*--------------------------------------------------------------------------*/
                        #if (FXAA_QUALITY_PS > 12)
                        if(doneNP) {
                            if(!doneN) lumaEndN = FxaaLuma(FxaaTexTop(tex, posN.xy));
                            if(!doneP) lumaEndP = FxaaLuma(FxaaTexTop(tex, posP.xy));
                            if(!doneN) lumaEndN = lumaEndN - lumaNN * 0.5;
                            if(!doneP) lumaEndP = lumaEndP - lumaNN * 0.5;
                            doneN = abs(lumaEndN) >= gradientScaled;
                            doneP = abs(lumaEndP) >= gradientScaled;
                            if(!doneN) posN.x -= offNP.x * FXAA_QUALITY_P12;
                            if(!doneN) posN.y -= offNP.y * FXAA_QUALITY_P12;
                            doneNP = (!doneN) || (!doneP);
                            if(!doneP) posP.x += offNP.x * FXAA_QUALITY_P12;
                            if(!doneP) posP.y += offNP.y * FXAA_QUALITY_P12;
    /*--------------------------------------------------------------------------*/
                        }
                        #endif
    /*--------------------------------------------------------------------------*/
                    }
                    #endif
    /*--------------------------------------------------------------------------*/
                }
                #endif
    /*--------------------------------------------------------------------------*/
            }
            #endif
    /*--------------------------------------------------------------------------*/
        }
        #endif
    /*--------------------------------------------------------------------------*/
                            }
                            #endif
    /*--------------------------------------------------------------------------*/
                        }
                        #endif
    /*--------------------------------------------------------------------------*/
                    }
                    #endif
    /*--------------------------------------------------------------------------*/
                }
                #endif
    /*--------------------------------------------------------------------------*/
            }
            #endif
    /*--------------------------------------------------------------------------*/
        }
    /*--------------------------------------------------------------------------*/
        FxaaFloat dstN = posM.x - posN.x;
        FxaaFloat dstP = posP.x - posM.x;
        if(!horzSpan) dstN = posM.y - posN.y;
        if(!horzSpan) dstP = posP.y - posM.y;
    /*--------------------------------------------------------------------------*/
        FxaaBool goodSpanN = (lumaEndN < 0.0) != lumaMLTZero;
        FxaaFloat spanLength = (dstP + dstN);
        FxaaBool goodSpanP = (lumaEndP < 0.0) != lumaMLTZero;
        FxaaFloat spanLengthRcp = 1.0/spanLength;
    /*--------------------------------------------------------------------------*/
        FxaaBool directionN = dstN < dstP;
        FxaaFloat dst = min(dstN, dstP);
        FxaaBool goodSpan = directionN ? goodSpanN : goodSpanP;
        FxaaFloat subpixG = subpixF * subpixF;
        FxaaFloat pixelOffset = (dst * (-spanLengthRcp)) + 0.5;
        FxaaFloat subpixH = subpixG * fxaaQualitySubpix;
    /*--------------------------------------------------------------------------*/
        FxaaFloat pixelOffsetGood = goodSpan ? pixelOffset : 0.0;
        FxaaFloat pixelOffsetSubpix = max(pixelOffsetGood, subpixH);
        if(!horzSpan) posM.x += pixelOffsetSubpix * lengthSign;
        if( horzSpan) posM.y += pixelOffsetSubpix * lengthSign;
        #if (FXAA_DISCARD == 1)
            return FxaaTexTop(tex, posM);
        #else
            return FxaaFloat4(FxaaTexTop(tex, posM).xyz, lumaM);
        #endif
    }
    /*==========================================================================*/
    #endif
    
    void main() {
      gl_FragColor = FxaaPixelShader(
        vUv,
        vec4(0.0),
        tDiffuse,
        tDiffuse,
        tDiffuse,
        resolution,
        vec4(0.0),
        vec4(0.0),
        vec4(0.0),
        0.75,
        0.166,
        0.0833,
        0.0,
        0.0,
        0.0,
        vec4(0.0)
      );
    
      // TODO avoid querying texture twice for same texel
      gl_FragColor.a = texture2D(tDiffuse, vUv).a;
    }
  `
  )
};

// node_modules/three-stdlib/shaders/FreiChenShader.js
var FreiChenShader = {
  uniforms: {
    tDiffuse: { value: null },
    aspect: { value: new Vector2(512, 512) }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform sampler2D tDiffuse;
    varying vec2 vUv;

    uniform vec2 aspect;

    vec2 texel = vec2(1.0 / aspect.x, 1.0 / aspect.y);

    mat3 G[9];

    // hard coded matrix values!!!! as suggested in https://github.com/neilmendoza/ofxPostProcessing/blob/master/src/EdgePass.cpp#L45

    const mat3 g0 = mat3( 0.3535533845424652, 0, -0.3535533845424652, 0.5, 0, -0.5, 0.3535533845424652, 0, -0.3535533845424652 );
    const mat3 g1 = mat3( 0.3535533845424652, 0.5, 0.3535533845424652, 0, 0, 0, -0.3535533845424652, -0.5, -0.3535533845424652 );
    const mat3 g2 = mat3( 0, 0.3535533845424652, -0.5, -0.3535533845424652, 0, 0.3535533845424652, 0.5, -0.3535533845424652, 0 );
    const mat3 g3 = mat3( 0.5, -0.3535533845424652, 0, -0.3535533845424652, 0, 0.3535533845424652, 0, 0.3535533845424652, -0.5 );
    const mat3 g4 = mat3( 0, -0.5, 0, 0.5, 0, 0.5, 0, -0.5, 0 );
    const mat3 g5 = mat3( -0.5, 0, 0.5, 0, 0, 0, 0.5, 0, -0.5 );
    const mat3 g6 = mat3( 0.1666666716337204, -0.3333333432674408, 0.1666666716337204, -0.3333333432674408, 0.6666666865348816, -0.3333333432674408, 0.1666666716337204, -0.3333333432674408, 0.1666666716337204 );
    const mat3 g7 = mat3( -0.3333333432674408, 0.1666666716337204, -0.3333333432674408, 0.1666666716337204, 0.6666666865348816, 0.1666666716337204, -0.3333333432674408, 0.1666666716337204, -0.3333333432674408 );
    const mat3 g8 = mat3( 0.3333333432674408, 0.3333333432674408, 0.3333333432674408, 0.3333333432674408, 0.3333333432674408, 0.3333333432674408, 0.3333333432674408, 0.3333333432674408, 0.3333333432674408 );

    void main(void)
    {

    	G[0] = g0,
    	G[1] = g1,
    	G[2] = g2,
    	G[3] = g3,
    	G[4] = g4,
    	G[5] = g5,
    	G[6] = g6,
    	G[7] = g7,
    	G[8] = g8;

    	mat3 I;
    	float cnv[9];
    	vec3 sample;

    /* fetch the 3x3 neighbourhood and use the RGB vectors length as intensity value */
    	for (float i=0.0; i<3.0; i++) {
    		for (float j=0.0; j<3.0; j++) {
    			sample = texture2D(tDiffuse, vUv + texel * vec2(i-1.0,j-1.0) ).rgb;
    			I[int(i)][int(j)] = length(sample);
    		}
    	}

    /* calculate the convolution values for all the masks */
    	for (int i=0; i<9; i++) {
    		float dp3 = dot(G[i][0], I[0]) + dot(G[i][1], I[1]) + dot(G[i][2], I[2]);
    		cnv[i] = dp3 * dp3;
    	}

    	float M = (cnv[0] + cnv[1]) + (cnv[2] + cnv[3]);
    	float S = (cnv[4] + cnv[5]) + (cnv[6] + cnv[7]) + (cnv[8] + M);

    	gl_FragColor = vec4(vec3(sqrt(M/S)), 1.0);
    }
  `
  )
};

// node_modules/three-stdlib/shaders/GammaCorrectionShader.js
var GammaCorrectionShader = {
  uniforms: {
    tDiffuse: { value: null }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform sampler2D tDiffuse;

    varying vec2 vUv;

    void main() {

    	vec4 tex = texture2D( tDiffuse, vUv );

    	#ifdef LinearTosRGB
    		gl_FragColor = LinearTosRGB( tex );
    	#else
    		gl_FragColor = sRGBTransferOETF( tex );
    	#endif

    }
  `
  )
};

// node_modules/three-stdlib/shaders/GodRaysShader.js
var GodRaysGenerateShader = {
  uniforms: {
    tInput: {
      value: null
    },
    fStepSize: {
      value: 1
    },
    vSunPositionScreenSpace: {
      value: new Vector3()
    }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

     vUv = uv;
     gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    #define TAPS_PER_PASS 6.0

    varying vec2 vUv;

    uniform sampler2D tInput;

    uniform vec3 vSunPositionScreenSpace;
    uniform float fStepSize; // filter step size

    void main() {

    // delta from current pixel to "sun" position

    	vec2 delta = vSunPositionScreenSpace.xy - vUv;
    	float dist = length( delta );

    // Step vector (uv space)

    	vec2 stepv = fStepSize * delta / dist;

    // Number of iterations between pixel and sun

    	float iters = dist/fStepSize;

    	vec2 uv = vUv.xy;
    	float col = 0.0;

    // This breaks ANGLE in Chrome 22
    //	- see http://code.google.com/p/chromium/issues/detail?id=153105

    /*
		// Unrolling didnt do much on my hardware (ATI Mobility Radeon 3450),
		// so ive just left the loop

		for ( float i = 0.0; i < TAPS_PER_PASS; i += 1.0 ) {

		// Accumulate samples, making sure we dont walk past the light source.

		// The check for uv.y < 1 would not be necessary with "border" UV wrap
		// mode, with a black border color. I dont think this is currently
		// exposed by three.js. As a result there might be artifacts when the
		// sun is to the left, right or bottom of screen as these cases are
		// not specifically handled.

		col += ( i <= iters && uv.y < 1.0 ? texture2D( tInput, uv ).r : 0.0 );
		uv += stepv;

		}
		*/

    // Unrolling loop manually makes it work in ANGLE

    	float f = min( 1.0, max( vSunPositionScreenSpace.z / 1000.0, 0.0 ) ); // used to fade out godrays

    	if ( 0.0 <= iters && uv.y < 1.0 ) col += texture2D( tInput, uv ).r * f;
    	uv += stepv;

    	if ( 1.0 <= iters && uv.y < 1.0 ) col += texture2D( tInput, uv ).r * f;
    	uv += stepv;

    	if ( 2.0 <= iters && uv.y < 1.0 ) col += texture2D( tInput, uv ).r * f;
    	uv += stepv;

    	if ( 3.0 <= iters && uv.y < 1.0 ) col += texture2D( tInput, uv ).r * f;
    	uv += stepv;

    	if ( 4.0 <= iters && uv.y < 1.0 ) col += texture2D( tInput, uv ).r * f;
    	uv += stepv;

    	if ( 5.0 <= iters && uv.y < 1.0 ) col += texture2D( tInput, uv ).r * f;
    	uv += stepv;

    // Should technically be dividing by iters but TAPS_PER_PASS smooths out
    // objectionable artifacts, in particular near the sun position. The side
    // effect is that the result is darker than it should be around the sun, as
    // TAPS_PER_PASS is greater than the number of samples actually accumulated.
    // When the result is inverted (in the shader godrays_combine this produces
    // a slight bright spot at the position of the sun, even when it is occluded.

    	gl_FragColor = vec4( col/TAPS_PER_PASS );
    	gl_FragColor.a = 1.0;

    }
  `
  )
};
var GodRaysFakeSunShader = {
  uniforms: {
    vSunPositionScreenSpace: {
      value: new Vector3()
    },
    fAspect: {
      value: 1
    },
    sunColor: {
      value: new Color(16772608)
    },
    bgColor: {
      value: new Color(0)
    }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    varying vec2 vUv;

    uniform vec3 vSunPositionScreenSpace;
    uniform float fAspect;

    uniform vec3 sunColor;
    uniform vec3 bgColor;

    void main() {

    	vec2 diff = vUv - vSunPositionScreenSpace.xy;

    // Correct for aspect ratio

    	diff.x *= fAspect;

    	float prop = clamp( length( diff ) / 0.5, 0.0, 1.0 );
    	prop = 0.35 * pow( 1.0 - prop, 3.0 );

    	gl_FragColor.xyz = ( vSunPositionScreenSpace.z > 0.0 ) ? mix( sunColor, bgColor, 1.0 - prop ) : bgColor;
    	gl_FragColor.w = 1.0;

    }
  `
  )
};

// node_modules/three-stdlib/shaders/HorizontalBlurShader.js
var HorizontalBlurShader = {
  uniforms: {
    tDiffuse: { value: null },
    h: { value: 1 / 512 }
  },
  vertexShader: (
    /* glsl */
    `
      varying vec2 vUv;

      void main() {

        vUv = uv;
        gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

      }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform sampler2D tDiffuse;
    uniform float h;

    varying vec2 vUv;

    void main() {

    	vec4 sum = vec4( 0.0 );

    	sum += texture2D( tDiffuse, vec2( vUv.x - 4.0 * h, vUv.y ) ) * 0.051;
    	sum += texture2D( tDiffuse, vec2( vUv.x - 3.0 * h, vUv.y ) ) * 0.0918;
    	sum += texture2D( tDiffuse, vec2( vUv.x - 2.0 * h, vUv.y ) ) * 0.12245;
    	sum += texture2D( tDiffuse, vec2( vUv.x - 1.0 * h, vUv.y ) ) * 0.1531;
    	sum += texture2D( tDiffuse, vec2( vUv.x, vUv.y ) ) * 0.1633;
    	sum += texture2D( tDiffuse, vec2( vUv.x + 1.0 * h, vUv.y ) ) * 0.1531;
    	sum += texture2D( tDiffuse, vec2( vUv.x + 2.0 * h, vUv.y ) ) * 0.12245;
    	sum += texture2D( tDiffuse, vec2( vUv.x + 3.0 * h, vUv.y ) ) * 0.0918;
    	sum += texture2D( tDiffuse, vec2( vUv.x + 4.0 * h, vUv.y ) ) * 0.051;

    	gl_FragColor = sum;

    }
  `
  )
};

// node_modules/three-stdlib/shaders/HorizontalTiltShiftShader.js
var HorizontalTiltShiftShader = {
  uniforms: {
    tDiffuse: { value: null },
    h: { value: 1 / 512 },
    r: { value: 0.35 }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform sampler2D tDiffuse;
    uniform float h;
    uniform float r;

    varying vec2 vUv;

    void main() {

    	vec4 sum = vec4( 0.0 );

    	float hh = h * abs( r - vUv.y );

    	sum += texture2D( tDiffuse, vec2( vUv.x - 4.0 * hh, vUv.y ) ) * 0.051;
    	sum += texture2D( tDiffuse, vec2( vUv.x - 3.0 * hh, vUv.y ) ) * 0.0918;
    	sum += texture2D( tDiffuse, vec2( vUv.x - 2.0 * hh, vUv.y ) ) * 0.12245;
    	sum += texture2D( tDiffuse, vec2( vUv.x - 1.0 * hh, vUv.y ) ) * 0.1531;
    	sum += texture2D( tDiffuse, vec2( vUv.x, vUv.y ) ) * 0.1633;
    	sum += texture2D( tDiffuse, vec2( vUv.x + 1.0 * hh, vUv.y ) ) * 0.1531;
    	sum += texture2D( tDiffuse, vec2( vUv.x + 2.0 * hh, vUv.y ) ) * 0.12245;
    	sum += texture2D( tDiffuse, vec2( vUv.x + 3.0 * hh, vUv.y ) ) * 0.0918;
    	sum += texture2D( tDiffuse, vec2( vUv.x + 4.0 * hh, vUv.y ) ) * 0.051;

    	gl_FragColor = sum;

    }
  `
  )
};

// node_modules/three-stdlib/shaders/NormalMapShader.js
var NormalMapShader = {
  uniforms: {
    heightMap: { value: null },
    resolution: { value: new Vector2(512, 512) },
    scale: { value: new Vector2(1, 1) },
    height: { value: 0.05 }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;
    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform float height;
    uniform vec2 resolution;
    uniform sampler2D heightMap;

    varying vec2 vUv;

    void main() {

    	float val = texture2D( heightMap, vUv ).x;

    	float valU = texture2D( heightMap, vUv + vec2( 1.0 / resolution.x, 0.0 ) ).x;
    	float valV = texture2D( heightMap, vUv + vec2( 0.0, 1.0 / resolution.y ) ).x;

    	gl_FragColor = vec4( ( 0.5 * normalize( vec3( val - valU, val - valV, height  ) ) + 0.5 ), 1.0 );

    }
  `
  )
};

// node_modules/three-stdlib/shaders/SobelOperatorShader.js
var SobelOperatorShader = {
  uniforms: {
    tDiffuse: { value: null },
    resolution: { value: new Vector2() }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec2 vUv;

    void main() {

    	vUv = uv;

    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform sampler2D tDiffuse;
    uniform vec2 resolution;
    varying vec2 vUv;

    void main() {

    	vec2 texel = vec2( 1.0 / resolution.x, 1.0 / resolution.y );

    // kernel definition (in glsl matrices are filled in column-major order)

    	const mat3 Gx = mat3( -1, -2, -1, 0, 0, 0, 1, 2, 1 ); // x direction kernel
    	const mat3 Gy = mat3( -1, 0, 1, -2, 0, 2, -1, 0, 1 ); // y direction kernel

    // fetch the 3x3 neighbourhood of a fragment

    // first column

    	float tx0y0 = texture2D( tDiffuse, vUv + texel * vec2( -1, -1 ) ).r;
    	float tx0y1 = texture2D( tDiffuse, vUv + texel * vec2( -1,  0 ) ).r;
    	float tx0y2 = texture2D( tDiffuse, vUv + texel * vec2( -1,  1 ) ).r;

    // second column

    	float tx1y0 = texture2D( tDiffuse, vUv + texel * vec2(  0, -1 ) ).r;
    	float tx1y1 = texture2D( tDiffuse, vUv + texel * vec2(  0,  0 ) ).r;
    	float tx1y2 = texture2D( tDiffuse, vUv + texel * vec2(  0,  1 ) ).r;

    // third column

    	float tx2y0 = texture2D( tDiffuse, vUv + texel * vec2(  1, -1 ) ).r;
    	float tx2y1 = texture2D( tDiffuse, vUv + texel * vec2(  1,  0 ) ).r;
    	float tx2y2 = texture2D( tDiffuse, vUv + texel * vec2(  1,  1 ) ).r;

    // gradient value in x direction

    	float valueGx = Gx[0][0] * tx0y0 + Gx[1][0] * tx1y0 + Gx[2][0] * tx2y0 + 
    		Gx[0][1] * tx0y1 + Gx[1][1] * tx1y1 + Gx[2][1] * tx2y1 + 
    		Gx[0][2] * tx0y2 + Gx[1][2] * tx1y2 + Gx[2][2] * tx2y2; 

    // gradient value in y direction

    	float valueGy = Gy[0][0] * tx0y0 + Gy[1][0] * tx1y0 + Gy[2][0] * tx2y0 + 
    		Gy[0][1] * tx0y1 + Gy[1][1] * tx1y1 + Gy[2][1] * tx2y1 + 
    		Gy[0][2] * tx0y2 + Gy[1][2] * tx1y2 + Gy[2][2] * tx2y2; 

    // magnitute of the total gradient

    	float G = sqrt( ( valueGx * valueGx ) + ( valueGy * valueGy ) );

    	gl_FragColor = vec4( vec3( G ), 1 );

    }
  `
  )
};

// node_modules/three-stdlib/shaders/ToonShader.js
var ToonShader1 = {
  uniforms: {
    uDirLightPos: { value: new Vector3() },
    uDirLightColor: { value: new Color(15658734) },
    uAmbientLightColor: { value: new Color(328965) },
    uBaseColor: { value: new Color(16777215) }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec3 vNormal;
    varying vec3 vRefract;

    void main() {

    	vec4 worldPosition = modelMatrix * vec4( position, 1.0 );
    	vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );
    	vec3 worldNormal = normalize ( mat3( modelMatrix[0].xyz, modelMatrix[1].xyz, modelMatrix[2].xyz ) * normal );

    	vNormal = normalize( normalMatrix * normal );

    	vec3 I = worldPosition.xyz - cameraPosition;
    	vRefract = refract( normalize( I ), worldNormal, 1.02 );

    	gl_Position = projectionMatrix * mvPosition;

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform vec3 uBaseColor;

    uniform vec3 uDirLightPos;
    uniform vec3 uDirLightColor;

    uniform vec3 uAmbientLightColor;

    varying vec3 vNormal;

    varying vec3 vRefract;

    void main() {

    	float directionalLightWeighting = max( dot( normalize( vNormal ), uDirLightPos ), 0.0);
    	vec3 lightWeighting = uAmbientLightColor + uDirLightColor * directionalLightWeighting;

    	float intensity = smoothstep( - 0.5, 1.0, pow( length(lightWeighting), 20.0 ) );
    	intensity += length(lightWeighting) * 0.2;

    	float cameraWeighting = dot( normalize( vNormal ), vRefract );
    	intensity += pow( 1.0 - length( cameraWeighting ), 6.0 );
    	intensity = intensity * 0.2 + 0.3;

    	if ( intensity < 0.50 ) {

    		gl_FragColor = vec4( 2.0 * intensity * uBaseColor, 1.0 );

    	} else {

    		gl_FragColor = vec4( 1.0 - 2.0 * ( 1.0 - intensity ) * ( 1.0 - uBaseColor ), 1.0 );

    }

    }
  `
  )
};
var ToonShader2 = {
  uniforms: {
    uDirLightPos: { value: new Vector3() },
    uDirLightColor: { value: new Color(15658734) },
    uAmbientLightColor: { value: new Color(328965) },
    uBaseColor: { value: new Color(15658734) },
    uLineColor1: { value: new Color(8421504) },
    uLineColor2: { value: new Color(0) },
    uLineColor3: { value: new Color(0) },
    uLineColor4: { value: new Color(0) }
  },
  vertexShader: (
    /* glsl */
    `
    varying vec3 vNormal;

    void main() {

    	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );
    	vNormal = normalize( normalMatrix * normal );

    }
  `
  ),
  fragmentShader: (
    /* glsl */
    `
    uniform vec3 uBaseColor;
    uniform vec3 uLineColor1;
    uniform vec3 uLineColor2;
    uniform vec3 uLineColor3;
    uniform vec3 uLineColor4;

    uniform vec3 uDirLightPos;
    uniform vec3 uDirLightColor;

    uniform vec3 uAmbientLightColor;

    varying vec3 vNormal;

    void main() {

    	float camera = max( dot( normalize( vNormal ), vec3( 0.0, 0.0, 1.0 ) ), 0.4);
    	float light = max( dot( normalize( vNormal ), uDirLightPos ), 0.0);

    	gl_FragColor = vec4( uB