'use strict';

var middlewareExpectContinue = require('@aws-sdk/middleware-expect-continue');
var middlewareFlexibleChecksums = require('@aws-sdk/middleware-flexible-checksums');
var middlewareHostHeader = require('@aws-sdk/middleware-host-header');
var middlewareLogger = require('@aws-sdk/middleware-logger');
var middlewareRecursionDetection = require('@aws-sdk/middleware-recursion-detection');
var middlewareSdkS3 = require('@aws-sdk/middleware-sdk-s3');
var middlewareUserAgent = require('@aws-sdk/middleware-user-agent');
var configResolver = require('@smithy/config-resolver');
var core = require('@smithy/core');
var schema = require('@smithy/core/schema');
var eventstreamSerdeConfigResolver = require('@smithy/eventstream-serde-config-resolver');
var middlewareContentLength = require('@smithy/middleware-content-length');
var middlewareEndpoint = require('@smithy/middleware-endpoint');
var middlewareRetry = require('@smithy/middleware-retry');
var smithyClient = require('@smithy/smithy-client');
var httpAuthSchemeProvider = require('./auth/httpAuthSchemeProvider');
var runtimeConfig = require('./runtimeConfig');
var regionConfigResolver = require('@aws-sdk/region-config-resolver');
var protocolHttp = require('@smithy/protocol-http');
var middlewareSsec = require('@aws-sdk/middleware-ssec');
var middlewareLocationConstraint = require('@aws-sdk/middleware-location-constraint');
var utilWaiter = require('@smithy/util-waiter');

const resolveClientEndpointParameters = (options) => {
    return Object.assign(options, {
        useFipsEndpoint: options.useFipsEndpoint ?? false,
        useDualstackEndpoint: options.useDualstackEndpoint ?? false,
        forcePathStyle: options.forcePathStyle ?? false,
        useAccelerateEndpoint: options.useAccelerateEndpoint ?? false,
        useGlobalEndpoint: options.useGlobalEndpoint ?? false,
        disableMultiregionAccessPoints: options.disableMultiregionAccessPoints ?? false,
        defaultSigningName: "s3",
    });
};
const commonParams = {
    ForcePathStyle: { type: "clientContextParams", name: "forcePathStyle" },
    UseArnRegion: { type: "clientContextParams", name: "useArnRegion" },
    DisableMultiRegionAccessPoints: { type: "clientContextParams", name: "disableMultiregionAccessPoints" },
    Accelerate: { type: "clientContextParams", name: "useAccelerateEndpoint" },
    DisableS3ExpressSessionAuth: { type: "clientContextParams", name: "disableS3ExpressSessionAuth" },
    UseGlobalEndpoint: { type: "builtInParams", name: "useGlobalEndpoint" },
    UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
    Endpoint: { type: "builtInParams", name: "endpoint" },
    Region: { type: "builtInParams", name: "region" },
    UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
};

let S3ServiceException$1 = class S3ServiceException extends smithyClient.ServiceException {
    constructor(options) {
        super(options);
        Object.setPrototypeOf(this, S3ServiceException.prototype);
    }
};

let NoSuchUpload$1 = class NoSuchUpload extends S3ServiceException$1 {
    name = "NoSuchUpload";
    $fault = "client";
    constructor(opts) {
        super({
            name: "NoSuchUpload",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NoSuchUpload.prototype);
    }
};
let ObjectNotInActiveTierError$1 = class ObjectNotInActiveTierError extends S3ServiceException$1 {
    name = "ObjectNotInActiveTierError";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ObjectNotInActiveTierError",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ObjectNotInActiveTierError.prototype);
    }
};
let BucketAlreadyExists$1 = class BucketAlreadyExists extends S3ServiceException$1 {
    name = "BucketAlreadyExists";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BucketAlreadyExists",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BucketAlreadyExists.prototype);
    }
};
let BucketAlreadyOwnedByYou$1 = class BucketAlreadyOwnedByYou extends S3ServiceException$1 {
    name = "BucketAlreadyOwnedByYou";
    $fault = "client";
    constructor(opts) {
        super({
            name: "BucketAlreadyOwnedByYou",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, BucketAlreadyOwnedByYou.prototype);
    }
};
let NoSuchBucket$1 = class NoSuchBucket extends S3ServiceException$1 {
    name = "NoSuchBucket";
    $fault = "client";
    constructor(opts) {
        super({
            name: "NoSuchBucket",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NoSuchBucket.prototype);
    }
};
let InvalidObjectState$1 = class InvalidObjectState extends S3ServiceException$1 {
    name = "InvalidObjectState";
    $fault = "client";
    StorageClass;
    AccessTier;
    constructor(opts) {
        super({
            name: "InvalidObjectState",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidObjectState.prototype);
        this.StorageClass = opts.StorageClass;
        this.AccessTier = opts.AccessTier;
    }
};
let NoSuchKey$1 = class NoSuchKey extends S3ServiceException$1 {
    name = "NoSuchKey";
    $fault = "client";
    constructor(opts) {
        super({
            name: "NoSuchKey",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NoSuchKey.prototype);
    }
};
let NotFound$1 = class NotFound extends S3ServiceException$1 {
    name = "NotFound";
    $fault = "client";
    constructor(opts) {
        super({
            name: "NotFound",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NotFound.prototype);
    }
};
let EncryptionTypeMismatch$1 = class EncryptionTypeMismatch extends S3ServiceException$1 {
    name = "EncryptionTypeMismatch";
    $fault = "client";
    constructor(opts) {
        super({
            name: "EncryptionTypeMismatch",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, EncryptionTypeMismatch.prototype);
    }
};
let InvalidRequest$1 = class InvalidRequest extends S3ServiceException$1 {
    name = "InvalidRequest";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidRequest",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidRequest.prototype);
    }
};
let InvalidWriteOffset$1 = class InvalidWriteOffset extends S3ServiceException$1 {
    name = "InvalidWriteOffset";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidWriteOffset",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidWriteOffset.prototype);
    }
};
let TooManyParts$1 = class TooManyParts extends S3ServiceException$1 {
    name = "TooManyParts";
    $fault = "client";
    constructor(opts) {
        super({
            name: "TooManyParts",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TooManyParts.prototype);
    }
};
let IdempotencyParameterMismatch$1 = class IdempotencyParameterMismatch extends S3ServiceException$1 {
    name = "IdempotencyParameterMismatch";
    $fault = "client";
    constructor(opts) {
        super({
            name: "IdempotencyParameterMismatch",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, IdempotencyParameterMismatch.prototype);
    }
};
let ObjectAlreadyInActiveTierError$1 = class ObjectAlreadyInActiveTierError extends S3ServiceException$1 {
    name = "ObjectAlreadyInActiveTierError";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ObjectAlreadyInActiveTierError",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ObjectAlreadyInActiveTierError.prototype);
    }
};

const _A = "Account";
const _AAO = "AnalyticsAndOperator";
const _AC = "AccelerateConfiguration";
const _ACL = "AccessControlList";
const _ACL_ = "ACL";
const _ACLn = "AnalyticsConfigurationList";
const _ACP = "AccessControlPolicy";
const _ACT = "AccessControlTranslation";
const _ACn = "AnalyticsConfiguration";
const _AD = "AbortDate";
const _AED = "AnalyticsExportDestination";
const _AF = "AnalyticsFilter";
const _AH = "AllowedHeaders";
const _AHl = "AllowedHeader";
const _AI = "AccountId";
const _AIMU = "AbortIncompleteMultipartUpload";
const _AKI = "AccessKeyId";
const _AM = "AllowedMethods";
const _AMU = "AbortMultipartUpload";
const _AMUO = "AbortMultipartUploadOutput";
const _AMUR = "AbortMultipartUploadRequest";
const _AMl = "AllowedMethod";
const _AO = "AllowedOrigins";
const _AOl = "AllowedOrigin";
const _APA = "AccessPointAlias";
const _APAc = "AccessPointArn";
const _AQRD = "AllowQuotedRecordDelimiter";
const _AR = "AcceptRanges";
const _ARI = "AbortRuleId";
const _AS = "AbacStatus";
const _ASBD = "AnalyticsS3BucketDestination";
const _ASSEBD = "ApplyServerSideEncryptionByDefault";
const _ASr = "ArchiveStatus";
const _AT = "AccessTier";
const _An = "And";
const _B = "Bucket";
const _BA = "BucketArn";
const _BAE = "BucketAlreadyExists";
const _BAI = "BucketAccountId";
const _BAOBY = "BucketAlreadyOwnedByYou";
const _BET = "BlockedEncryptionTypes";
const _BGR = "BypassGovernanceRetention";
const _BI = "BucketInfo";
const _BKE = "BucketKeyEnabled";
const _BLC = "BucketLifecycleConfiguration";
const _BLN = "BucketLocationName";
const _BLS = "BucketLoggingStatus";
const _BLT = "BucketLocationType";
const _BN = "BucketName";
const _BP = "BytesProcessed";
const _BPA = "BlockPublicAcls";
const _BPP = "BlockPublicPolicy";
const _BR = "BucketRegion";
const _BRy = "BytesReturned";
const _BS = "BytesScanned";
const _Bo = "Body";
const _Bu = "Buckets";
const _C = "Checksum";
const _CA = "ChecksumAlgorithm";
const _CACL = "CannedACL";
const _CB = "CreateBucket";
const _CBC = "CreateBucketConfiguration";
const _CBMC = "CreateBucketMetadataConfiguration";
const _CBMCR = "CreateBucketMetadataConfigurationRequest";
const _CBMTC = "CreateBucketMetadataTableConfiguration";
const _CBMTCR = "CreateBucketMetadataTableConfigurationRequest";
const _CBO = "CreateBucketOutput";
const _CBR = "CreateBucketRequest";
const _CC = "CacheControl";
const _CCRC = "ChecksumCRC32";
const _CCRCC = "ChecksumCRC32C";
const _CCRCNVME = "ChecksumCRC64NVME";
const _CC_ = "Cache-Control";
const _CD = "CreationDate";
const _CD_ = "Content-Disposition";
const _CDo = "ContentDisposition";
const _CE = "ContinuationEvent";
const _CE_ = "Content-Encoding";
const _CEo = "ContentEncoding";
const _CF = "CloudFunction";
const _CFC = "CloudFunctionConfiguration";
const _CL = "ContentLanguage";
const _CL_ = "Content-Language";
const _CL__ = "Content-Length";
const _CLo = "ContentLength";
const _CM = "Content-MD5";
const _CMD = "ContentMD5";
const _CMU = "CompletedMultipartUpload";
const _CMUO = "CompleteMultipartUploadOutput";
const _CMUOr = "CreateMultipartUploadOutput";
const _CMUR = "CompleteMultipartUploadResult";
const _CMURo = "CompleteMultipartUploadRequest";
const _CMURr = "CreateMultipartUploadRequest";
const _CMUo = "CompleteMultipartUpload";
const _CMUr = "CreateMultipartUpload";
const _CMh = "ChecksumMode";
const _CO = "CopyObject";
const _COO = "CopyObjectOutput";
const _COR = "CopyObjectResult";
const _CORSC = "CORSConfiguration";
const _CORSR = "CORSRules";
const _CORSRu = "CORSRule";
const _CORo = "CopyObjectRequest";
const _CP = "CommonPrefix";
const _CPL = "CommonPrefixList";
const _CPLo = "CompletedPartList";
const _CPR = "CopyPartResult";
const _CPo = "CompletedPart";
const _CPom = "CommonPrefixes";
const _CR = "ContentRange";
const _CRSBA = "ConfirmRemoveSelfBucketAccess";
const _CR_ = "Content-Range";
const _CS = "CopySource";
const _CSHA = "ChecksumSHA1";
const _CSHAh = "ChecksumSHA256";
const _CSIM = "CopySourceIfMatch";
const _CSIMS = "CopySourceIfModifiedSince";
const _CSINM = "CopySourceIfNoneMatch";
const _CSIUS = "CopySourceIfUnmodifiedSince";
const _CSO = "CreateSessionOutput";
const _CSR = "CreateSessionResult";
const _CSRo = "CopySourceRange";
const _CSRr = "CreateSessionRequest";
const _CSSSECA = "CopySourceSSECustomerAlgorithm";
const _CSSSECK = "CopySourceSSECustomerKey";
const _CSSSECKMD = "CopySourceSSECustomerKeyMD5";
const _CSV = "CSV";
const _CSVI = "CopySourceVersionId";
const _CSVIn = "CSVInput";
const _CSVO = "CSVOutput";
const _CSo = "ConfigurationState";
const _CSr = "CreateSession";
const _CT = "ChecksumType";
const _CT_ = "Content-Type";
const _CTl = "ClientToken";
const _CTo = "ContentType";
const _CTom = "CompressionType";
const _CTon = "ContinuationToken";
const _Co = "Condition";
const _Cod = "Code";
const _Com = "Comments";
const _Con = "Contents";
const _Cont = "Cont";
const _Cr = "Credentials";
const _D = "Days";
const _DAI = "DaysAfterInitiation";
const _DB = "DeleteBucket";
const _DBAC = "DeleteBucketAnalyticsConfiguration";
const _DBACR = "DeleteBucketAnalyticsConfigurationRequest";
const _DBC = "DeleteBucketCors";
const _DBCR = "DeleteBucketCorsRequest";
const _DBE = "DeleteBucketEncryption";
const _DBER = "DeleteBucketEncryptionRequest";
const _DBIC = "DeleteBucketInventoryConfiguration";
const _DBICR = "DeleteBucketInventoryConfigurationRequest";
const _DBITC = "DeleteBucketIntelligentTieringConfiguration";
const _DBITCR = "DeleteBucketIntelligentTieringConfigurationRequest";
const _DBL = "DeleteBucketLifecycle";
const _DBLR = "DeleteBucketLifecycleRequest";
const _DBMC = "DeleteBucketMetadataConfiguration";
const _DBMCR = "DeleteBucketMetadataConfigurationRequest";
const _DBMCRe = "DeleteBucketMetricsConfigurationRequest";
const _DBMCe = "DeleteBucketMetricsConfiguration";
const _DBMTC = "DeleteBucketMetadataTableConfiguration";
const _DBMTCR = "DeleteBucketMetadataTableConfigurationRequest";
const _DBOC = "DeleteBucketOwnershipControls";
const _DBOCR = "DeleteBucketOwnershipControlsRequest";
const _DBP = "DeleteBucketPolicy";
const _DBPR = "DeleteBucketPolicyRequest";
const _DBR = "DeleteBucketRequest";
const _DBRR = "DeleteBucketReplicationRequest";
const _DBRe = "DeleteBucketReplication";
const _DBT = "DeleteBucketTagging";
const _DBTR = "DeleteBucketTaggingRequest";
const _DBW = "DeleteBucketWebsite";
const _DBWR = "DeleteBucketWebsiteRequest";
const _DE = "DataExport";
const _DIM = "DestinationIfMatch";
const _DIMS = "DestinationIfModifiedSince";
const _DINM = "DestinationIfNoneMatch";
const _DIUS = "DestinationIfUnmodifiedSince";
const _DM = "DeleteMarker";
const _DME = "DeleteMarkerEntry";
const _DMR = "DeleteMarkerReplication";
const _DMVI = "DeleteMarkerVersionId";
const _DMe = "DeleteMarkers";
const _DN = "DisplayName";
const _DO = "DeletedObject";
const _DOO = "DeleteObjectOutput";
const _DOOe = "DeleteObjectsOutput";
const _DOR = "DeleteObjectRequest";
const _DORe = "DeleteObjectsRequest";
const _DOT = "DeleteObjectTagging";
const _DOTO = "DeleteObjectTaggingOutput";
const _DOTR = "DeleteObjectTaggingRequest";
const _DOe = "DeletedObjects";
const _DOel = "DeleteObject";
const _DOele = "DeleteObjects";
const _DPAB = "DeletePublicAccessBlock";
const _DPABR = "DeletePublicAccessBlockRequest";
const _DR = "DataRedundancy";
const _DRe = "DefaultRetention";
const _DRel = "DeleteResult";
const _DRes = "DestinationResult";
const _Da = "Date";
const _De = "Delete";
const _Del = "Deleted";
const _Deli = "Delimiter";
const _Des = "Destination";
const _Desc = "Description";
const _Det = "Details";
const _E = "Expiration";
const _EA = "EmailAddress";
const _EBC = "EventBridgeConfiguration";
const _EBO = "ExpectedBucketOwner";
const _EC = "EncryptionConfiguration";
const _ECr = "ErrorCode";
const _ED = "ErrorDetails";
const _EDr = "ErrorDocument";
const _EE = "EndEvent";
const _EH = "ExposeHeaders";
const _EHx = "ExposeHeader";
const _EM = "ErrorMessage";
const _EODM = "ExpiredObjectDeleteMarker";
const _EOR = "ExistingObjectReplication";
const _ES = "ExpiresString";
const _ESBO = "ExpectedSourceBucketOwner";
const _ET = "EncryptionType";
const _ETL = "EncryptionTypeList";
const _ETM = "EncryptionTypeMismatch";
const _ETa = "ETag";
const _ETn = "EncodingType";
const _ETv = "EventThreshold";
const _ETx = "ExpressionType";
const _En = "Encryption";
const _Ena = "Enabled";
const _End = "End";
const _Er = "Errors";
const _Err = "Error";
const _Ev = "Events";
const _Eve = "Event";
const _Ex = "Expires";
const _Exp = "Expression";
const _F = "Filter";
const _FD = "FieldDelimiter";
const _FHI = "FileHeaderInfo";
const _FO = "FetchOwner";
const _FR = "FilterRule";
const _FRL = "FilterRuleList";
const _FRi = "FilterRules";
const _Fi = "Field";
const _Fo = "Format";
const _Fr = "Frequency";
const _G = "Grants";
const _GBA = "GetBucketAbac";
const _GBAC = "GetBucketAccelerateConfiguration";
const _GBACO = "GetBucketAccelerateConfigurationOutput";
const _GBACOe = "GetBucketAnalyticsConfigurationOutput";
const _GBACR = "GetBucketAccelerateConfigurationRequest";
const _GBACRe = "GetBucketAnalyticsConfigurationRequest";
const _GBACe = "GetBucketAnalyticsConfiguration";
const _GBAO = "GetBucketAbacOutput";
const _GBAOe = "GetBucketAclOutput";
const _GBAR = "GetBucketAbacRequest";
const _GBARe = "GetBucketAclRequest";
const _GBAe = "GetBucketAcl";
const _GBC = "GetBucketCors";
const _GBCO = "GetBucketCorsOutput";
const _GBCR = "GetBucketCorsRequest";
const _GBE = "GetBucketEncryption";
const _GBEO = "GetBucketEncryptionOutput";
const _GBER = "GetBucketEncryptionRequest";
const _GBIC = "GetBucketInventoryConfiguration";
const _GBICO = "GetBucketInventoryConfigurationOutput";
const _GBICR = "GetBucketInventoryConfigurationRequest";
const _GBITC = "GetBucketIntelligentTieringConfiguration";
const _GBITCO = "GetBucketIntelligentTieringConfigurationOutput";
const _GBITCR = "GetBucketIntelligentTieringConfigurationRequest";
const _GBL = "GetBucketLocation";
const _GBLC = "GetBucketLifecycleConfiguration";
const _GBLCO = "GetBucketLifecycleConfigurationOutput";
const _GBLCR = "GetBucketLifecycleConfigurationRequest";
const _GBLO = "GetBucketLocationOutput";
const _GBLOe = "GetBucketLoggingOutput";
const _GBLR = "GetBucketLocationRequest";
const _GBLRe = "GetBucketLoggingRequest";
const _GBLe = "GetBucketLogging";
const _GBMC = "GetBucketMetadataConfiguration";
const _GBMCO = "GetBucketMetadataConfigurationOutput";
const _GBMCOe = "GetBucketMetricsConfigurationOutput";
const _GBMCR = "GetBucketMetadataConfigurationResult";
const _GBMCRe = "GetBucketMetadataConfigurationRequest";
const _GBMCRet = "GetBucketMetricsConfigurationRequest";
const _GBMCe = "GetBucketMetricsConfiguration";
const _GBMTC = "GetBucketMetadataTableConfiguration";
const _GBMTCO = "GetBucketMetadataTableConfigurationOutput";
const _GBMTCR = "GetBucketMetadataTableConfigurationResult";
const _GBMTCRe = "GetBucketMetadataTableConfigurationRequest";
const _GBNC = "GetBucketNotificationConfiguration";
const _GBNCR = "GetBucketNotificationConfigurationRequest";
const _GBOC = "GetBucketOwnershipControls";
const _GBOCO = "GetBucketOwnershipControlsOutput";
const _GBOCR = "GetBucketOwnershipControlsRequest";
const _GBP = "GetBucketPolicy";
const _GBPO = "GetBucketPolicyOutput";
const _GBPR = "GetBucketPolicyRequest";
const _GBPS = "GetBucketPolicyStatus";
const _GBPSO = "GetBucketPolicyStatusOutput";
const _GBPSR = "GetBucketPolicyStatusRequest";
const _GBR = "GetBucketReplication";
const _GBRO = "GetBucketReplicationOutput";
const _GBRP = "GetBucketRequestPayment";
const _GBRPO = "GetBucketRequestPaymentOutput";
const _GBRPR = "GetBucketRequestPaymentRequest";
const _GBRR = "GetBucketReplicationRequest";
const _GBT = "GetBucketTagging";
const _GBTO = "GetBucketTaggingOutput";
const _GBTR = "GetBucketTaggingRequest";
const _GBV = "GetBucketVersioning";
const _GBVO = "GetBucketVersioningOutput";
const _GBVR = "GetBucketVersioningRequest";
const _GBW = "GetBucketWebsite";
const _GBWO = "GetBucketWebsiteOutput";
const _GBWR = "GetBucketWebsiteRequest";
const _GFC = "GrantFullControl";
const _GJP = "GlacierJobParameters";
const _GO = "GetObject";
const _GOA = "GetObjectAcl";
const _GOAO = "GetObjectAclOutput";
const _GOAOe = "GetObjectAttributesOutput";
const _GOAP = "GetObjectAttributesParts";
const _GOAR = "GetObjectAclRequest";
const _GOARe = "GetObjectAttributesResponse";
const _GOARet = "GetObjectAttributesRequest";
const _GOAe = "GetObjectAttributes";
const _GOLC = "GetObjectLockConfiguration";
const _GOLCO = "GetObjectLockConfigurationOutput";
const _GOLCR = "GetObjectLockConfigurationRequest";
const _GOLH = "GetObjectLegalHold";
const _GOLHO = "GetObjectLegalHoldOutput";
const _GOLHR = "GetObjectLegalHoldRequest";
const _GOO = "GetObjectOutput";
const _GOR = "GetObjectRequest";
const _GORO = "GetObjectRetentionOutput";
const _GORR = "GetObjectRetentionRequest";
const _GORe = "GetObjectRetention";
const _GOT = "GetObjectTagging";
const _GOTO = "GetObjectTaggingOutput";
const _GOTOe = "GetObjectTorrentOutput";
const _GOTR = "GetObjectTaggingRequest";
const _GOTRe = "GetObjectTorrentRequest";
const _GOTe = "GetObjectTorrent";
const _GPAB = "GetPublicAccessBlock";
const _GPABO = "GetPublicAccessBlockOutput";
const _GPABR = "GetPublicAccessBlockRequest";
const _GR = "GrantRead";
const _GRACP = "GrantReadACP";
const _GW = "GrantWrite";
const _GWACP = "GrantWriteACP";
const _Gr = "Grant";
const _Gra = "Grantee";
const _HB = "HeadBucket";
const _HBO = "HeadBucketOutput";
const _HBR = "HeadBucketRequest";
const _HECRE = "HttpErrorCodeReturnedEquals";
const _HN = "HostName";
const _HO = "HeadObject";
const _HOO = "HeadObjectOutput";
const _HOR = "HeadObjectRequest";
const _HRC = "HttpRedirectCode";
const _I = "Id";
const _IC = "InventoryConfiguration";
const _ICL = "InventoryConfigurationList";
const _ID = "ID";
const _IDn = "IndexDocument";
const _IDnv = "InventoryDestination";
const _IE = "IsEnabled";
const _IEn = "InventoryEncryption";
const _IF = "InventoryFilter";
const _IL = "IsLatest";
const _IM = "IfMatch";
const _IMIT = "IfMatchInitiatedTime";
const _IMLMT = "IfMatchLastModifiedTime";
const _IMS = "IfMatchSize";
const _IMS_ = "If-Modified-Since";
const _IMSf = "IfModifiedSince";
const _IMUR = "InitiateMultipartUploadResult";
const _IM_ = "If-Match";
const _INM = "IfNoneMatch";
const _INM_ = "If-None-Match";
const _IOF = "InventoryOptionalFields";
const _IOS = "InvalidObjectState";
const _IOV = "IncludedObjectVersions";
const _IP = "IsPublic";
const _IPA = "IgnorePublicAcls";
const _IPM = "IdempotencyParameterMismatch";
const _IR = "InvalidRequest";
const _IRIP = "IsRestoreInProgress";
const _IS = "InputSerialization";
const _ISBD = "InventoryS3BucketDestination";
const _ISn = "InventorySchedule";
const _IT = "IsTruncated";
const _ITAO = "IntelligentTieringAndOperator";
const _ITC = "IntelligentTieringConfiguration";
const _ITCL = "IntelligentTieringConfigurationList";
const _ITCR = "InventoryTableConfigurationResult";
const _ITCU = "InventoryTableConfigurationUpdates";
const _ITCn = "InventoryTableConfiguration";
const _ITF = "IntelligentTieringFilter";
const _IUS = "IfUnmodifiedSince";
const _IUS_ = "If-Unmodified-Since";
const _IWO = "InvalidWriteOffset";
const _In = "Initiator";
const _Ini = "Initiated";
const _JSON = "JSON";
const _JSONI = "JSONInput";
const _JSONO = "JSONOutput";
const _JTC = "JournalTableConfiguration";
const _JTCR = "JournalTableConfigurationResult";
const _JTCU = "JournalTableConfigurationUpdates";
const _K = "Key";
const _KC = "KeyCount";
const _KI = "KeyId";
const _KKA = "KmsKeyArn";
const _KM = "KeyMarker";
const _KMSC = "KMSContext";
const _KMSKI = "KMSKeyId";
const _KMSMKID = "KMSMasterKeyID";
const _KPE = "KeyPrefixEquals";
const _L = "Location";
const _LAMBR = "ListAllMyBucketsResult";
const _LAMDBR = "ListAllMyDirectoryBucketsResult";
const _LB = "ListBuckets";
const _LBAC = "ListBucketAnalyticsConfigurations";
const _LBACO = "ListBucketAnalyticsConfigurationsOutput";
const _LBACR = "ListBucketAnalyticsConfigurationResult";
const _LBACRi = "ListBucketAnalyticsConfigurationsRequest";
const _LBIC = "ListBucketInventoryConfigurations";
const _LBICO = "ListBucketInventoryConfigurationsOutput";
const _LBICR = "ListBucketInventoryConfigurationsRequest";
const _LBITC = "ListBucketIntelligentTieringConfigurations";
const _LBITCO = "ListBucketIntelligentTieringConfigurationsOutput";
const _LBITCR = "ListBucketIntelligentTieringConfigurationsRequest";
const _LBMC = "ListBucketMetricsConfigurations";
const _LBMCO = "ListBucketMetricsConfigurationsOutput";
const _LBMCR = "ListBucketMetricsConfigurationsRequest";
const _LBO = "ListBucketsOutput";
const _LBR = "ListBucketsRequest";
const _LBRi = "ListBucketResult";
const _LC = "LocationConstraint";
const _LCi = "LifecycleConfiguration";
const _LDB = "ListDirectoryBuckets";
const _LDBO = "ListDirectoryBucketsOutput";
const _LDBR = "ListDirectoryBucketsRequest";
const _LE = "LoggingEnabled";
const _LEi = "LifecycleExpiration";
const _LFA = "LambdaFunctionArn";
const _LFC = "LambdaFunctionConfiguration";
const _LFCL = "LambdaFunctionConfigurationList";
const _LFCa = "LambdaFunctionConfigurations";
const _LH = "LegalHold";
const _LI = "LocationInfo";
const _LICR = "ListInventoryConfigurationsResult";
const _LM = "LastModified";
const _LMCR = "ListMetricsConfigurationsResult";
const _LMT = "LastModifiedTime";
const _LMU = "ListMultipartUploads";
const _LMUO = "ListMultipartUploadsOutput";
const _LMUR = "ListMultipartUploadsResult";
const _LMURi = "ListMultipartUploadsRequest";
const _LM_ = "Last-Modified";
const _LO = "ListObjects";
const _LOO = "ListObjectsOutput";
const _LOR = "ListObjectsRequest";
const _LOV = "ListObjectsV2";
const _LOVO = "ListObjectsV2Output";
const _LOVOi = "ListObjectVersionsOutput";
const _LOVR = "ListObjectsV2Request";
const _LOVRi = "ListObjectVersionsRequest";
const _LOVi = "ListObjectVersions";
const _LP = "ListParts";
const _LPO = "ListPartsOutput";
const _LPR = "ListPartsResult";
const _LPRi = "ListPartsRequest";
const _LR = "LifecycleRule";
const _LRAO = "LifecycleRuleAndOperator";
const _LRF = "LifecycleRuleFilter";
const _LRi = "LifecycleRules";
const _LVR = "ListVersionsResult";
const _M = "Metadata";
const _MAO = "MetricsAndOperator";
const _MAS = "MaxAgeSeconds";
const _MB = "MaxBuckets";
const _MC = "MetadataConfiguration";
const _MCL = "MetricsConfigurationList";
const _MCR = "MetadataConfigurationResult";
const _MCe = "MetricsConfiguration";
const _MD = "MetadataDirective";
const _MDB = "MaxDirectoryBuckets";
const _MDf = "MfaDelete";
const _ME = "MetadataEntry";
const _MF = "MetricsFilter";
const _MFA = "MFA";
const _MFAD = "MFADelete";
const _MK = "MaxKeys";
const _MM = "MissingMeta";
const _MOS = "MpuObjectSize";
const _MP = "MaxParts";
const _MTC = "MetadataTableConfiguration";
const _MTCR = "MetadataTableConfigurationResult";
const _MTEC = "MetadataTableEncryptionConfiguration";
const _MU = "MultipartUpload";
const _MUL = "MultipartUploadList";
const _MUa = "MaxUploads";
const _Ma = "Marker";
const _Me = "Metrics";
const _Mes = "Message";
const _Mi = "Minutes";
const _Mo = "Mode";
const _N = "Name";
const _NC = "NotificationConfiguration";
const _NCF = "NotificationConfigurationFilter";
const _NCT = "NextContinuationToken";
const _ND = "NoncurrentDays";
const _NF = "NotFound";
const _NKM = "NextKeyMarker";
const _NM = "NextMarker";
const _NNV = "NewerNoncurrentVersions";
const _NPNM = "NextPartNumberMarker";
const _NSB = "NoSuchBucket";
const _NSK = "NoSuchKey";
const _NSU = "NoSuchUpload";
const _NUIM = "NextUploadIdMarker";
const _NVE = "NoncurrentVersionExpiration";
const _NVIM = "NextVersionIdMarker";
const _NVT = "NoncurrentVersionTransitions";
const _NVTL = "NoncurrentVersionTransitionList";
const _NVTo = "NoncurrentVersionTransition";
const _O = "Owner";
const _OA = "ObjectAttributes";
const _OAIATE = "ObjectAlreadyInActiveTierError";
const _OC = "OwnershipControls";
const _OCR = "OwnershipControlsRule";
const _OCRw = "OwnershipControlsRules";
const _OF = "OptionalFields";
const _OI = "ObjectIdentifier";
const _OIL = "ObjectIdentifierList";
const _OL = "OutputLocation";
const _OLC = "ObjectLockConfiguration";
const _OLE = "ObjectLockEnabled";
const _OLEFB = "ObjectLockEnabledForBucket";
const _OLLH = "ObjectLockLegalHold";
const _OLLHS = "ObjectLockLegalHoldStatus";
const _OLM = "ObjectLockMode";
const _OLR = "ObjectLockRetention";
const _OLRUD = "ObjectLockRetainUntilDate";
const _OLRb = "ObjectLockRule";
const _OLb = "ObjectList";
const _ONIATE = "ObjectNotInActiveTierError";
const _OO = "ObjectOwnership";
const _OOA = "OptionalObjectAttributes";
const _OP = "ObjectParts";
const _OPb = "ObjectPart";
const _OS = "ObjectSize";
const _OSGT = "ObjectSizeGreaterThan";
const _OSLT = "ObjectSizeLessThan";
const _OSV = "OutputSchemaVersion";
const _OSu = "OutputSerialization";
const _OV = "ObjectVersion";
const _OVL = "ObjectVersionList";
const _Ob = "Objects";
const _Obj = "Object";
const _P = "Prefix";
const _PABC = "PublicAccessBlockConfiguration";
const _PBA = "PutBucketAbac";
const _PBAC = "PutBucketAccelerateConfiguration";
const _PBACR = "PutBucketAccelerateConfigurationRequest";
const _PBACRu = "PutBucketAnalyticsConfigurationRequest";
const _PBACu = "PutBucketAnalyticsConfiguration";
const _PBAR = "PutBucketAbacRequest";
const _PBARu = "PutBucketAclRequest";
const _PBAu = "PutBucketAcl";
const _PBC = "PutBucketCors";
const _PBCR = "PutBucketCorsRequest";
const _PBE = "PutBucketEncryption";
const _PBER = "PutBucketEncryptionRequest";
const _PBIC = "PutBucketInventoryConfiguration";
const _PBICR = "PutBucketInventoryConfigurationRequest";
const _PBITC = "PutBucketIntelligentTieringConfiguration";
const _PBITCR = "PutBucketIntelligentTieringConfigurationRequest";
const _PBL = "PutBucketLogging";
const _PBLC = "PutBucketLifecycleConfiguration";
const _PBLCO = "PutBucketLifecycleConfigurationOutput";
const _PBLCR = "PutBucketLifecycleConfigurationRequest";
const _PBLR = "PutBucketLoggingRequest";
const _PBMC = "PutBucketMetricsConfiguration";
const _PBMCR = "PutBucketMetricsConfigurationRequest";
const _PBNC = "PutBucketNotificationConfiguration";
const _PBNCR = "PutBucketNotificationConfigurationRequest";
const _PBOC = "PutBucketOwnershipControls";
const _PBOCR = "PutBucketOwnershipControlsRequest";
const _PBP = "PutBucketPolicy";
const _PBPR = "PutBucketPolicyRequest";
const _PBR = "PutBucketReplication";
const _PBRP = "PutBucketRequestPayment";
const _PBRPR = "PutBucketRequestPaymentRequest";
const _PBRR = "PutBucketReplicationRequest";
const _PBT = "PutBucketTagging";
const _PBTR = "PutBucketTaggingRequest";
const _PBV = "PutBucketVersioning";
const _PBVR = "PutBucketVersioningRequest";
const _PBW = "PutBucketWebsite";
const _PBWR = "PutBucketWebsiteRequest";
const _PC = "PartsCount";
const _PDS = "PartitionDateSource";
const _PE = "ProgressEvent";
const _PI = "ParquetInput";
const _PL = "PartsList";
const _PN = "PartNumber";
const _PNM = "PartNumberMarker";
const _PO = "PutObject";
const _POA = "PutObjectAcl";
const _POAO = "PutObjectAclOutput";
const _POAR = "PutObjectAclRequest";
const _POLC = "PutObjectLockConfiguration";
const _POLCO = "PutObjectLockConfigurationOutput";
const _POLCR = "PutObjectLockConfigurationRequest";
const _POLH = "PutObjectLegalHold";
const _POLHO = "PutObjectLegalHoldOutput";
const _POLHR = "PutObjectLegalHoldRequest";
const _POO = "PutObjectOutput";
const _POR = "PutObjectRequest";
const _PORO = "PutObjectRetentionOutput";
const _PORR = "PutObjectRetentionRequest";
const _PORu = "PutObjectRetention";
const _POT = "PutObjectTagging";
const _POTO = "PutObjectTaggingOutput";
const _POTR = "PutObjectTaggingRequest";
const _PP = "PartitionedPrefix";
const _PPAB = "PutPublicAccessBlock";
const _PPABR = "PutPublicAccessBlockRequest";
const _PS = "PolicyStatus";
const _Pa = "Parts";
const _Par = "Part";
const _Parq = "Parquet";
const _Pay = "Payer";
const _Payl = "Payload";
const _Pe = "Permission";
const _Po = "Policy";
const _Pr = "Progress";
const _Pri = "Priority";
const _Pro = "Protocol";
const _Q = "Quiet";
const _QA = "QueueArn";
const _QC = "QuoteCharacter";
const _QCL = "QueueConfigurationList";
const _QCu = "QueueConfigurations";
const _QCue = "QueueConfiguration";
const _QEC = "QuoteEscapeCharacter";
const _QF = "QuoteFields";
const _Qu = "Queue";
const _R = "Rules";
const _RART = "RedirectAllRequestsTo";
const _RC = "RequestCharged";
const _RCC = "ResponseCacheControl";
const _RCD = "ResponseContentDisposition";
const _RCE = "ResponseContentEncoding";
const _RCL = "ResponseContentLanguage";
const _RCT = "ResponseContentType";
const _RCe = "ReplicationConfiguration";
const _RD = "RecordDelimiter";
const _RE = "ResponseExpires";
const _RED = "RestoreExpiryDate";
const _REe = "RecordExpiration";
const _REec = "RecordsEvent";
const _RKKID = "ReplicaKmsKeyID";
const _RKPW = "ReplaceKeyPrefixWith";
const _RKW = "ReplaceKeyWith";
const _RM = "ReplicaModifications";
const _RO = "RenameObject";
const _ROO = "RenameObjectOutput";
const _ROOe = "RestoreObjectOutput";
const _ROP = "RestoreOutputPath";
const _ROR = "RenameObjectRequest";
const _RORe = "RestoreObjectRequest";
const _ROe = "RestoreObject";
const _RP = "RequestPayer";
const _RPB = "RestrictPublicBuckets";
const _RPC = "RequestPaymentConfiguration";
const _RPe = "RequestProgress";
const _RR = "RoutingRules";
const _RRAO = "ReplicationRuleAndOperator";
const _RRF = "ReplicationRuleFilter";
const _RRe = "ReplicationRule";
const _RRep = "ReplicationRules";
const _RReq = "RequestRoute";
const _RRes = "RestoreRequest";
const _RRo = "RoutingRule";
const _RS = "ReplicationStatus";
const _RSe = "RestoreStatus";
const _RSen = "RenameSource";
const _RT = "ReplicationTime";
const _RTV = "ReplicationTimeValue";
const _RTe = "RequestToken";
const _RUD = "RetainUntilDate";
const _Ra = "Range";
const _Re = "Restore";
const _Rec = "Records";
const _Red = "Redirect";
const _Ret = "Retention";
const _Ro = "Role";
const _Ru = "Rule";
const _S = "Status";
const _SA = "StartAfter";
const _SAK = "SecretAccessKey";
const _SAs = "SseAlgorithm";
const _SB = "StreamingBlob";
const _SBD = "S3BucketDestination";
const _SC = "StorageClass";
const _SCA = "StorageClassAnalysis";
const _SCADE = "StorageClassAnalysisDataExport";
const _SCV = "SessionCredentialValue";
const _SCe = "SessionCredentials";
const _SCt = "StatusCode";
const _SDV = "SkipDestinationValidation";
const _SE = "StatsEvent";
const _SIM = "SourceIfMatch";
const _SIMS = "SourceIfModifiedSince";
const _SINM = "SourceIfNoneMatch";
const _SIUS = "SourceIfUnmodifiedSince";
const _SK = "SSE-KMS";
const _SKEO = "SseKmsEncryptedObjects";
const _SKF = "S3KeyFilter";
const _SKe = "S3Key";
const _SL = "S3Location";
const _SM = "SessionMode";
const _SOC = "SelectObjectContent";
const _SOCES = "SelectObjectContentEventStream";
const _SOCO = "SelectObjectContentOutput";
const _SOCR = "SelectObjectContentRequest";
const _SP = "SelectParameters";
const _SPi = "SimplePrefix";
const _SR = "ScanRange";
const _SS = "SSE-S3";
const _SSC = "SourceSelectionCriteria";
const _SSE = "ServerSideEncryption";
const _SSEA = "SSEAlgorithm";
const _SSEBD = "ServerSideEncryptionByDefault";
const _SSEC = "ServerSideEncryptionConfiguration";
const _SSECA = "SSECustomerAlgorithm";
const _SSECK = "SSECustomerKey";
const _SSECKMD = "SSECustomerKeyMD5";
const _SSEKMS = "SSEKMS";
const _SSEKMSEC = "SSEKMSEncryptionContext";
const _SSEKMSKI = "SSEKMSKeyId";
const _SSER = "ServerSideEncryptionRule";
const _SSERe = "ServerSideEncryptionRules";
const _SSES = "SSES3";
const _ST = "SessionToken";
const _STD = "S3TablesDestination";
const _STDR = "S3TablesDestinationResult";
const _S_ = "S3";
const _Sc = "Schedule";
const _Si = "Size";
const _St = "Start";
const _Sta = "Stats";
const _Su = "Suffix";
const _T = "Tags";
const _TA = "TableArn";
const _TAo = "TopicArn";
const _TB = "TargetBucket";
const _TBA = "TableBucketArn";
const _TBT = "TableBucketType";
const _TC = "TagCount";
const _TCL = "TopicConfigurationList";
const _TCo = "TopicConfigurations";
const _TCop = "TopicConfiguration";
const _TD = "TaggingDirective";
const _TDMOS = "TransitionDefaultMinimumObjectSize";
const _TG = "TargetGrants";
const _TGa = "TargetGrant";
const _TL = "TieringList";
const _TLr = "TransitionList";
const _TMP = "TooManyParts";
const _TN = "TableNamespace";
const _TNa = "TableName";
const _TOKF = "TargetObjectKeyFormat";
const _TP = "TargetPrefix";
const _TPC = "TotalPartsCount";
const _TS = "TagSet";
const _TSa = "TableStatus";
const _Ta = "Tag";
const _Tag = "Tagging";
const _Ti = "Tier";
const _Tie = "Tierings";
const _Tier = "Tiering";
const _Tim = "Time";
const _To = "Token";
const _Top = "Topic";
const _Tr = "Transitions";
const _Tra = "Transition";
const _Ty = "Type";
const _U = "Uploads";
const _UBMITC = "UpdateBucketMetadataInventoryTableConfiguration";
const _UBMITCR = "UpdateBucketMetadataInventoryTableConfigurationRequest";
const _UBMJTC = "UpdateBucketMetadataJournalTableConfiguration";
const _UBMJTCR = "UpdateBucketMetadataJournalTableConfigurationRequest";
const _UI = "UploadId";
const _UIM = "UploadIdMarker";
const _UM = "UserMetadata";
const _UP = "UploadPart";
const _UPC = "UploadPartCopy";
const _UPCO = "UploadPartCopyOutput";
const _UPCR = "UploadPartCopyRequest";
const _UPO = "UploadPartOutput";
const _UPR = "UploadPartRequest";
const _URI = "URI";
const _Up = "Upload";
const _V = "Value";
const _VC = "VersioningConfiguration";
const _VI = "VersionId";
const _VIM = "VersionIdMarker";
const _Ve = "Versions";
const _Ver = "Version";
const _WC = "WebsiteConfiguration";
const _WGOR = "WriteGetObjectResponse";
const _WGORR = "WriteGetObjectResponseRequest";
const _WOB = "WriteOffsetBytes";
const _WRL = "WebsiteRedirectLocation";
const _Y = "Years";
const _ar = "accept-ranges";
const _br = "bucket-region";
const _c = "client";
const _ct = "continuation-token";
const _d = "delimiter";
const _e = "error";
const _eP = "eventPayload";
const _en = "endpoint";
const _et = "encoding-type";
const _fo = "fetch-owner";
const _h = "http";
const _hE = "httpError";
const _hH = "httpHeader";
const _hL = "hostLabel";
const _hP = "httpPayload";
const _hPH = "httpPrefixHeaders";
const _hQ = "httpQuery";
const _hi = "http://www.w3.org/2001/XMLSchema-instance";
const _i = "id";
const _iT = "idempotencyToken";
const _km = "key-marker";
const _m = "marker";
const _mb = "max-buckets";
const _mdb = "max-directory-buckets";
const _mk = "max-keys";
const _mp = "max-parts";
const _mu = "max-uploads";
const _p = "prefix";
const _pN = "partNumber";
const _pnm = "part-number-marker";
const _rcc = "response-cache-control";
const _rcd = "response-content-disposition";
const _rce = "response-content-encoding";
const _rcl = "response-content-language";
const _rct = "response-content-type";
const _re = "response-expires";
const _s = "streaming";
const _sa = "start-after";
const _sm = "smithy.ts.sdk.synthetic.com.amazonaws.s3";
const _uI = "uploadId";
const _uim = "upload-id-marker";
const _vI = "versionId";
const _vim = "version-id-marker";
const _x = "xsi";
const _xA = "xmlAttribute";
const _xF = "xmlFlattened";
const _xN = "xmlName";
const _xNm = "xmlNamespace";
const _xaa = "x-amz-acl";
const _xaad = "x-amz-abort-date";
const _xaapa = "x-amz-access-point-alias";
const _xaari = "x-amz-abort-rule-id";
const _xaas = "x-amz-archive-status";
const _xaba = "x-amz-bucket-arn";
const _xabgr = "x-amz-bypass-governance-retention";
const _xabln = "x-amz-bucket-location-name";
const _xablt = "x-amz-bucket-location-type";
const _xabole = "x-amz-bucket-object-lock-enabled";
const _xabolt = "x-amz-bucket-object-lock-token";
const _xabr = "x-amz-bucket-region";
const _xaca = "x-amz-checksum-algorithm";
const _xacc = "x-amz-checksum-crc32";
const _xacc_ = "x-amz-checksum-crc32c";
const _xacc__ = "x-amz-checksum-crc64nvme";
const _xacm = "x-amz-checksum-mode";
const _xacrsba = "x-amz-confirm-remove-self-bucket-access";
const _xacs = "x-amz-checksum-sha1";
const _xacs_ = "x-amz-checksum-sha256";
const _xacs__ = "x-amz-copy-source";
const _xacsim = "x-amz-copy-source-if-match";
const _xacsims = "x-amz-copy-source-if-modified-since";
const _xacsinm = "x-amz-copy-source-if-none-match";
const _xacsius = "x-amz-copy-source-if-unmodified-since";
const _xacsm = "x-amz-create-session-mode";
const _xacsr = "x-amz-copy-source-range";
const _xacssseca = "x-amz-copy-source-server-side-encryption-customer-algorithm";
const _xacssseck = "x-amz-copy-source-server-side-encryption-customer-key";
const _xacssseckM = "x-amz-copy-source-server-side-encryption-customer-key-MD5";
const _xacsvi = "x-amz-copy-source-version-id";
const _xact = "x-amz-checksum-type";
const _xact_ = "x-amz-client-token";
const _xadm = "x-amz-delete-marker";
const _xae = "x-amz-expiration";
const _xaebo = "x-amz-expected-bucket-owner";
const _xafec = "x-amz-fwd-error-code";
const _xafem = "x-amz-fwd-error-message";
const _xafhCC = "x-amz-fwd-header-Cache-Control";
const _xafhCD = "x-amz-fwd-header-Content-Disposition";
const _xafhCE = "x-amz-fwd-header-Content-Encoding";
const _xafhCL = "x-amz-fwd-header-Content-Language";
const _xafhCR = "x-amz-fwd-header-Content-Range";
const _xafhCT = "x-amz-fwd-header-Content-Type";
const _xafhE = "x-amz-fwd-header-ETag";
const _xafhE_ = "x-amz-fwd-header-Expires";
const _xafhLM = "x-amz-fwd-header-Last-Modified";
const _xafhar = "x-amz-fwd-header-accept-ranges";
const _xafhxacc = "x-amz-fwd-header-x-amz-checksum-crc32";
const _xafhxacc_ = "x-amz-fwd-header-x-amz-checksum-crc32c";
const _xafhxacc__ = "x-amz-fwd-header-x-amz-checksum-crc64nvme";
const _xafhxacs = "x-amz-fwd-header-x-amz-checksum-sha1";
const _xafhxacs_ = "x-amz-fwd-header-x-amz-checksum-sha256";
const _xafhxadm = "x-amz-fwd-header-x-amz-delete-marker";
const _xafhxae = "x-amz-fwd-header-x-amz-expiration";
const _xafhxamm = "x-amz-fwd-header-x-amz-missing-meta";
const _xafhxampc = "x-amz-fwd-header-x-amz-mp-parts-count";
const _xafhxaollh = "x-amz-fwd-header-x-amz-object-lock-legal-hold";
const _xafhxaolm = "x-amz-fwd-header-x-amz-object-lock-mode";
const _xafhxaolrud = "x-amz-fwd-header-x-amz-object-lock-retain-until-date";
const _xafhxar = "x-amz-fwd-header-x-amz-restore";
const _xafhxarc = "x-amz-fwd-header-x-amz-request-charged";
const _xafhxars = "x-amz-fwd-header-x-amz-replication-status";
const _xafhxasc = "x-amz-fwd-header-x-amz-storage-class";
const _xafhxasse = "x-amz-fwd-header-x-amz-server-side-encryption";
const _xafhxasseakki = "x-amz-fwd-header-x-amz-server-side-encryption-aws-kms-key-id";
const _xafhxassebke = "x-amz-fwd-header-x-amz-server-side-encryption-bucket-key-enabled";
const _xafhxasseca = "x-amz-fwd-header-x-amz-server-side-encryption-customer-algorithm";
const _xafhxasseckM = "x-amz-fwd-header-x-amz-server-side-encryption-customer-key-MD5";
const _xafhxatc = "x-amz-fwd-header-x-amz-tagging-count";
const _xafhxavi = "x-amz-fwd-header-x-amz-version-id";
const _xafs = "x-amz-fwd-status";
const _xagfc = "x-amz-grant-full-control";
const _xagr = "x-amz-grant-read";
const _xagra = "x-amz-grant-read-acp";
const _xagw = "x-amz-grant-write";
const _xagwa = "x-amz-grant-write-acp";
const _xaimit = "x-amz-if-match-initiated-time";
const _xaimlmt = "x-amz-if-match-last-modified-time";
const _xaims = "x-amz-if-match-size";
const _xam = "x-amz-meta-";
const _xam_ = "x-amz-mfa";
const _xamd = "x-amz-metadata-directive";
const _xamm = "x-amz-missing-meta";
const _xamos = "x-amz-mp-object-size";
const _xamp = "x-amz-max-parts";
const _xampc = "x-amz-mp-parts-count";
const _xaoa = "x-amz-object-attributes";
const _xaollh = "x-amz-object-lock-legal-hold";
const _xaolm = "x-amz-object-lock-mode";
const _xaolrud = "x-amz-object-lock-retain-until-date";
const _xaoo = "x-amz-object-ownership";
const _xaooa = "x-amz-optional-object-attributes";
const _xaos = "x-amz-object-size";
const _xapnm = "x-amz-part-number-marker";
const _xar = "x-amz-restore";
const _xarc = "x-amz-request-charged";
const _xarop = "x-amz-restore-output-path";
const _xarp = "x-amz-request-payer";
const _xarr = "x-amz-request-route";
const _xars = "x-amz-replication-status";
const _xars_ = "x-amz-rename-source";
const _xarsim = "x-amz-rename-source-if-match";
const _xarsims = "x-amz-rename-source-if-modified-since";
const _xarsinm = "x-amz-rename-source-if-none-match";
const _xarsius = "x-amz-rename-source-if-unmodified-since";
const _xart = "x-amz-request-token";
const _xasc = "x-amz-storage-class";
const _xasca = "x-amz-sdk-checksum-algorithm";
const _xasdv = "x-amz-skip-destination-validation";
const _xasebo = "x-amz-source-expected-bucket-owner";
const _xasse = "x-amz-server-side-encryption";
const _xasseakki = "x-amz-server-side-encryption-aws-kms-key-id";
const _xassebke = "x-amz-server-side-encryption-bucket-key-enabled";
const _xassec = "x-amz-server-side-encryption-context";
const _xasseca = "x-amz-server-side-encryption-customer-algorithm";
const _xasseck = "x-amz-server-side-encryption-customer-key";
const _xasseckM = "x-amz-server-side-encryption-customer-key-MD5";
const _xat = "x-amz-tagging";
const _xatc = "x-amz-tagging-count";
const _xatd = "x-amz-tagging-directive";
const _xatdmos = "x-amz-transition-default-minimum-object-size";
const _xavi = "x-amz-version-id";
const _xawob = "x-amz-write-offset-bytes";
const _xawrl = "x-amz-website-redirect-location";
const _xs = "xsi:type";
const n0 = "com.amazonaws.s3";
var CopySourceSSECustomerKey = [0, n0, _CSSSECK, 8, 0];
var SessionCredentialValue = [0, n0, _SCV, 8, 0];
var SSECustomerKey = [0, n0, _SSECK, 8, 0];
var SSEKMSEncryptionContext = [0, n0, _SSEKMSEC, 8, 0];
var SSEKMSKeyId = [0, n0, _SSEKMSKI, 8, 0];
var StreamingBlob = [0, n0, _SB, { [_s]: 1 }, 42];
var AbacStatus = [3, n0, _AS, 0, [_S], [0]];
var AbortIncompleteMultipartUpload = [3, n0, _AIMU, 0, [_DAI], [1]];
var AbortMultipartUploadOutput = [3, n0, _AMUO, 0, [_RC], [[0, { [_hH]: _xarc }]]];
var AbortMultipartUploadRequest = [
    3,
    n0,
    _AMUR,
    0,
    [_B, _K, _UI, _RP, _EBO, _IMIT],
    [
        [0, 1],
        [0, 1],
        [0, { [_hQ]: _uI }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xaebo }],
        [6, { [_hH]: _xaimit }],
    ],
];
var AccelerateConfiguration = [3, n0, _AC, 0, [_S], [0]];
var AccessControlPolicy = [
    3,
    n0,
    _ACP,
    0,
    [_G, _O],
    [[() => Grants, { [_xN]: _ACL }], () => Owner],
];
var AccessControlTranslation = [3, n0, _ACT, 0, [_O], [0]];
var AnalyticsAndOperator = [
    3,
    n0,
    _AAO,
    0,
    [_P, _T],
    [0, [() => TagSet, { [_xN]: _Ta, [_xF]: 1 }]],
];
var AnalyticsConfiguration = [
    3,
    n0,
    _ACn,
    0,
    [_I, _F, _SCA],
    [0, [() => AnalyticsFilter, 0], () => StorageClassAnalysis],
];
var AnalyticsExportDestination = [
    3,
    n0,
    _AED,
    0,
    [_SBD],
    [() => AnalyticsS3BucketDestination],
];
var AnalyticsS3BucketDestination = [3, n0, _ASBD, 0, [_Fo, _BAI, _B, _P], [0, 0, 0, 0]];
var BlockedEncryptionTypes = [
    3,
    n0,
    _BET,
    0,
    [_ET],
    [[() => EncryptionTypeList, { [_xF]: 1 }]],
];
var Bucket = [3, n0, _B, 0, [_N, _CD, _BR, _BA], [0, 4, 0, 0]];
var BucketAlreadyExists = [-3, n0, _BAE, { [_e]: _c, [_hE]: 409 }, [], []];
schema.TypeRegistry.for(n0).registerError(BucketAlreadyExists, BucketAlreadyExists$1);
var BucketAlreadyOwnedByYou = [-3, n0, _BAOBY, { [_e]: _c, [_hE]: 409 }, [], []];
schema.TypeRegistry.for(n0).registerError(BucketAlreadyOwnedByYou, BucketAlreadyOwnedByYou$1);
var BucketInfo = [3, n0, _BI, 0, [_DR, _Ty], [0, 0]];
var BucketLifecycleConfiguration = [
    3,
    n0,
    _BLC,
    0,
    [_R],
    [[() => LifecycleRules, { [_xN]: _Ru, [_xF]: 1 }]],
];
var BucketLoggingStatus = [3, n0, _BLS, 0, [_LE], [[() => LoggingEnabled, 0]]];
var Checksum = [
    3,
    n0,
    _C,
    0,
    [_CCRC, _CCRCC, _CCRCNVME, _CSHA, _CSHAh, _CT],
    [0, 0, 0, 0, 0, 0],
];
var CommonPrefix = [3, n0, _CP, 0, [_P], [0]];
var CompletedMultipartUpload = [
    3,
    n0,
    _CMU,
    0,
    [_Pa],
    [[() => CompletedPartList, { [_xN]: _Par, [_xF]: 1 }]],
];
var CompletedPart = [
    3,
    n0,
    _CPo,
    0,
    [_ETa, _CCRC, _CCRCC, _CCRCNVME, _CSHA, _CSHAh, _PN],
    [0, 0, 0, 0, 0, 0, 1],
];
var CompleteMultipartUploadOutput = [
    3,
    n0,
    _CMUO,
    { [_xN]: _CMUR },
    [_L, _B, _K, _E, _ETa, _CCRC, _CCRCC, _CCRCNVME, _CSHA, _CSHAh, _CT, _SSE, _VI, _SSEKMSKI, _BKE, _RC],
    [
        0,
        0,
        0,
        [0, { [_hH]: _xae }],
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        [0, { [_hH]: _xasse }],
        [0, { [_hH]: _xavi }],
        [() => SSEKMSKeyId, { [_hH]: _xasseakki }],
        [2, { [_hH]: _xassebke }],
        [0, { [_hH]: _xarc }],
    ],
];
var CompleteMultipartUploadRequest = [
    3,
    n0,
    _CMURo,
    0,
    [
        _B,
        _K,
        _MU,
        _UI,
        _CCRC,
        _CCRCC,
        _CCRCNVME,
        _CSHA,
        _CSHAh,
        _CT,
        _MOS,
        _RP,
        _EBO,
        _IM,
        _INM,
        _SSECA,
        _SSECK,
        _SSECKMD,
    ],
    [
        [0, 1],
        [0, 1],
        [() => CompletedMultipartUpload, { [_xN]: _CMUo, [_hP]: 1 }],
        [0, { [_hQ]: _uI }],
        [0, { [_hH]: _xacc }],
        [0, { [_hH]: _xacc_ }],
        [0, { [_hH]: _xacc__ }],
        [0, { [_hH]: _xacs }],
        [0, { [_hH]: _xacs_ }],
        [0, { [_hH]: _xact }],
        [1, { [_hH]: _xamos }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _IM_ }],
        [0, { [_hH]: _INM_ }],
        [0, { [_hH]: _xasseca }],
        [() => SSECustomerKey, { [_hH]: _xasseck }],
        [0, { [_hH]: _xasseckM }],
    ],
];
var Condition = [3, n0, _Co, 0, [_HECRE, _KPE], [0, 0]];
var ContinuationEvent = [3, n0, _CE, 0, [], []];
var CopyObjectOutput = [
    3,
    n0,
    _COO,
    0,
    [_COR, _E, _CSVI, _VI, _SSE, _SSECA, _SSECKMD, _SSEKMSKI, _SSEKMSEC, _BKE, _RC],
    [
        [() => CopyObjectResult, 16],
        [0, { [_hH]: _xae }],
        [0, { [_hH]: _xacsvi }],
        [0, { [_hH]: _xavi }],
        [0, { [_hH]: _xasse }],
        [0, { [_hH]: _xasseca }],
        [0, { [_hH]: _xasseckM }],
        [() => SSEKMSKeyId, { [_hH]: _xasseakki }],
        [() => SSEKMSEncryptionContext, { [_hH]: _xassec }],
        [2, { [_hH]: _xassebke }],
        [0, { [_hH]: _xarc }],
    ],
];
var CopyObjectRequest = [
    3,
    n0,
    _CORo,
    0,
    [
        _ACL_,
        _B,
        _CC,
        _CA,
        _CDo,
        _CEo,
        _CL,
        _CTo,
        _CS,
        _CSIM,
        _CSIMS,
        _CSINM,
        _CSIUS,
        _Ex,
        _GFC,
        _GR,
        _GRACP,
        _GWACP,
        _IM,
        _INM,
        _K,
        _M,
        _MD,
        _TD,
        _SSE,
        _SC,
        _WRL,
        _SSECA,
        _SSECK,
        _SSECKMD,
        _SSEKMSKI,
        _SSEKMSEC,
        _BKE,
        _CSSSECA,
        _CSSSECK,
        _CSSSECKMD,
        _RP,
        _Tag,
        _OLM,
        _OLRUD,
        _OLLHS,
        _EBO,
        _ESBO,
    ],
    [
        [0, { [_hH]: _xaa }],
        [0, 1],
        [0, { [_hH]: _CC_ }],
        [0, { [_hH]: _xaca }],
        [0, { [_hH]: _CD_ }],
        [0, { [_hH]: _CE_ }],
        [0, { [_hH]: _CL_ }],
        [0, { [_hH]: _CT_ }],
        [0, { [_hH]: _xacs__ }],
        [0, { [_hH]: _xacsim }],
        [4, { [_hH]: _xacsims }],
        [0, { [_hH]: _xacsinm }],
        [4, { [_hH]: _xacsius }],
        [4, { [_hH]: _Ex }],
        [0, { [_hH]: _xagfc }],
        [0, { [_hH]: _xagr }],
        [0, { [_hH]: _xagra }],
        [0, { [_hH]: _xagwa }],
        [0, { [_hH]: _IM_ }],
        [0, { [_hH]: _INM_ }],
        [0, 1],
        [128 | 0, { [_hPH]: _xam }],
        [0, { [_hH]: _xamd }],
        [0, { [_hH]: _xatd }],
        [0, { [_hH]: _xasse }],
        [0, { [_hH]: _xasc }],
        [0, { [_hH]: _xawrl }],
        [0, { [_hH]: _xasseca }],
        [() => SSECustomerKey, { [_hH]: _xasseck }],
        [0, { [_hH]: _xasseckM }],
        [() => SSEKMSKeyId, { [_hH]: _xasseakki }],
        [() => SSEKMSEncryptionContext, { [_hH]: _xassec }],
        [2, { [_hH]: _xassebke }],
        [0, { [_hH]: _xacssseca }],
        [() => CopySourceSSECustomerKey, { [_hH]: _xacssseck }],
        [0, { [_hH]: _xacssseckM }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xat }],
        [0, { [_hH]: _xaolm }],
        [5, { [_hH]: _xaolrud }],
        [0, { [_hH]: _xaollh }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _xasebo }],
    ],
];
var CopyObjectResult = [
    3,
    n0,
    _COR,
    0,
    [_ETa, _LM, _CT, _CCRC, _CCRCC, _CCRCNVME, _CSHA, _CSHAh],
    [0, 4, 0, 0, 0, 0, 0, 0],
];
var CopyPartResult = [
    3,
    n0,
    _CPR,
    0,
    [_ETa, _LM, _CCRC, _CCRCC, _CCRCNVME, _CSHA, _CSHAh],
    [0, 4, 0, 0, 0, 0, 0],
];
var CORSConfiguration = [
    3,
    n0,
    _CORSC,
    0,
    [_CORSR],
    [[() => CORSRules, { [_xN]: _CORSRu, [_xF]: 1 }]],
];
var CORSRule = [
    3,
    n0,
    _CORSRu,
    0,
    [_ID, _AH, _AM, _AO, _EH, _MAS],
    [
        0,
        [64 | 0, { [_xN]: _AHl, [_xF]: 1 }],
        [64 | 0, { [_xN]: _AMl, [_xF]: 1 }],
        [64 | 0, { [_xN]: _AOl, [_xF]: 1 }],
        [64 | 0, { [_xN]: _EHx, [_xF]: 1 }],
        1,
    ],
];
var CreateBucketConfiguration = [
    3,
    n0,
    _CBC,
    0,
    [_LC, _L, _B, _T],
    [0, () => LocationInfo, () => BucketInfo, [() => TagSet, 0]],
];
var CreateBucketMetadataConfigurationRequest = [
    3,
    n0,
    _CBMCR,
    0,
    [_B, _CMD, _CA, _MC, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [() => MetadataConfiguration, { [_xN]: _MC, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
    ],
];
var CreateBucketMetadataTableConfigurationRequest = [
    3,
    n0,
    _CBMTCR,
    0,
    [_B, _CMD, _CA, _MTC, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [() => MetadataTableConfiguration, { [_xN]: _MTC, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
    ],
];
var CreateBucketOutput = [
    3,
    n0,
    _CBO,
    0,
    [_L, _BA],
    [
        [0, { [_hH]: _L }],
        [0, { [_hH]: _xaba }],
    ],
];
var CreateBucketRequest = [
    3,
    n0,
    _CBR,
    0,
    [_ACL_, _B, _CBC, _GFC, _GR, _GRACP, _GW, _GWACP, _OLEFB, _OO],
    [
        [0, { [_hH]: _xaa }],
        [0, 1],
        [() => CreateBucketConfiguration, { [_xN]: _CBC, [_hP]: 1 }],
        [0, { [_hH]: _xagfc }],
        [0, { [_hH]: _xagr }],
        [0, { [_hH]: _xagra }],
        [0, { [_hH]: _xagw }],
        [0, { [_hH]: _xagwa }],
        [2, { [_hH]: _xabole }],
        [0, { [_hH]: _xaoo }],
    ],
];
var CreateMultipartUploadOutput = [
    3,
    n0,
    _CMUOr,
    { [_xN]: _IMUR },
    [_AD, _ARI, _B, _K, _UI, _SSE, _SSECA, _SSECKMD, _SSEKMSKI, _SSEKMSEC, _BKE, _RC, _CA, _CT],
    [
        [4, { [_hH]: _xaad }],
        [0, { [_hH]: _xaari }],
        [0, { [_xN]: _B }],
        0,
        0,
        [0, { [_hH]: _xasse }],
        [0, { [_hH]: _xasseca }],
        [0, { [_hH]: _xasseckM }],
        [() => SSEKMSKeyId, { [_hH]: _xasseakki }],
        [() => SSEKMSEncryptionContext, { [_hH]: _xassec }],
        [2, { [_hH]: _xassebke }],
        [0, { [_hH]: _xarc }],
        [0, { [_hH]: _xaca }],
        [0, { [_hH]: _xact }],
    ],
];
var CreateMultipartUploadRequest = [
    3,
    n0,
    _CMURr,
    0,
    [
        _ACL_,
        _B,
        _CC,
        _CDo,
        _CEo,
        _CL,
        _CTo,
        _Ex,
        _GFC,
        _GR,
        _GRACP,
        _GWACP,
        _K,
        _M,
        _SSE,
        _SC,
        _WRL,
        _SSECA,
        _SSECK,
        _SSECKMD,
        _SSEKMSKI,
        _SSEKMSEC,
        _BKE,
        _RP,
        _Tag,
        _OLM,
        _OLRUD,
        _OLLHS,
        _EBO,
        _CA,
        _CT,
    ],
    [
        [0, { [_hH]: _xaa }],
        [0, 1],
        [0, { [_hH]: _CC_ }],
        [0, { [_hH]: _CD_ }],
        [0, { [_hH]: _CE_ }],
        [0, { [_hH]: _CL_ }],
        [0, { [_hH]: _CT_ }],
        [4, { [_hH]: _Ex }],
        [0, { [_hH]: _xagfc }],
        [0, { [_hH]: _xagr }],
        [0, { [_hH]: _xagra }],
        [0, { [_hH]: _xagwa }],
        [0, 1],
        [128 | 0, { [_hPH]: _xam }],
        [0, { [_hH]: _xasse }],
        [0, { [_hH]: _xasc }],
        [0, { [_hH]: _xawrl }],
        [0, { [_hH]: _xasseca }],
        [() => SSECustomerKey, { [_hH]: _xasseck }],
        [0, { [_hH]: _xasseckM }],
        [() => SSEKMSKeyId, { [_hH]: _xasseakki }],
        [() => SSEKMSEncryptionContext, { [_hH]: _xassec }],
        [2, { [_hH]: _xassebke }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xat }],
        [0, { [_hH]: _xaolm }],
        [5, { [_hH]: _xaolrud }],
        [0, { [_hH]: _xaollh }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _xaca }],
        [0, { [_hH]: _xact }],
    ],
];
var CreateSessionOutput = [
    3,
    n0,
    _CSO,
    { [_xN]: _CSR },
    [_SSE, _SSEKMSKI, _SSEKMSEC, _BKE, _Cr],
    [
        [0, { [_hH]: _xasse }],
        [() => SSEKMSKeyId, { [_hH]: _xasseakki }],
        [() => SSEKMSEncryptionContext, { [_hH]: _xassec }],
        [2, { [_hH]: _xassebke }],
        [() => SessionCredentials, { [_xN]: _Cr }],
    ],
];
var CreateSessionRequest = [
    3,
    n0,
    _CSRr,
    0,
    [_SM, _B, _SSE, _SSEKMSKI, _SSEKMSEC, _BKE],
    [
        [0, { [_hH]: _xacsm }],
        [0, 1],
        [0, { [_hH]: _xasse }],
        [() => SSEKMSKeyId, { [_hH]: _xasseakki }],
        [() => SSEKMSEncryptionContext, { [_hH]: _xassec }],
        [2, { [_hH]: _xassebke }],
    ],
];
var CSVInput = [
    3,
    n0,
    _CSVIn,
    0,
    [_FHI, _Com, _QEC, _RD, _FD, _QC, _AQRD],
    [0, 0, 0, 0, 0, 0, 2],
];
var CSVOutput = [3, n0, _CSVO, 0, [_QF, _QEC, _RD, _FD, _QC], [0, 0, 0, 0, 0]];
var DefaultRetention = [3, n0, _DRe, 0, [_Mo, _D, _Y], [0, 1, 1]];
var Delete = [
    3,
    n0,
    _De,
    0,
    [_Ob, _Q],
    [[() => ObjectIdentifierList, { [_xN]: _Obj, [_xF]: 1 }], 2],
];
var DeleteBucketAnalyticsConfigurationRequest = [
    3,
    n0,
    _DBACR,
    0,
    [_B, _I, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _i }],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeleteBucketCorsRequest = [
    3,
    n0,
    _DBCR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeleteBucketEncryptionRequest = [
    3,
    n0,
    _DBER,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeleteBucketIntelligentTieringConfigurationRequest = [
    3,
    n0,
    _DBITCR,
    0,
    [_B, _I, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _i }],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeleteBucketInventoryConfigurationRequest = [
    3,
    n0,
    _DBICR,
    0,
    [_B, _I, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _i }],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeleteBucketLifecycleRequest = [
    3,
    n0,
    _DBLR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeleteBucketMetadataConfigurationRequest = [
    3,
    n0,
    _DBMCR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeleteBucketMetadataTableConfigurationRequest = [
    3,
    n0,
    _DBMTCR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeleteBucketMetricsConfigurationRequest = [
    3,
    n0,
    _DBMCRe,
    0,
    [_B, _I, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _i }],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeleteBucketOwnershipControlsRequest = [
    3,
    n0,
    _DBOCR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeleteBucketPolicyRequest = [
    3,
    n0,
    _DBPR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeleteBucketReplicationRequest = [
    3,
    n0,
    _DBRR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeleteBucketRequest = [
    3,
    n0,
    _DBR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeleteBucketTaggingRequest = [
    3,
    n0,
    _DBTR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeleteBucketWebsiteRequest = [
    3,
    n0,
    _DBWR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeletedObject = [3, n0, _DO, 0, [_K, _VI, _DM, _DMVI], [0, 0, 2, 0]];
var DeleteMarkerEntry = [
    3,
    n0,
    _DME,
    0,
    [_O, _K, _VI, _IL, _LM],
    [() => Owner, 0, 0, 2, 4],
];
var DeleteMarkerReplication = [3, n0, _DMR, 0, [_S], [0]];
var DeleteObjectOutput = [
    3,
    n0,
    _DOO,
    0,
    [_DM, _VI, _RC],
    [
        [2, { [_hH]: _xadm }],
        [0, { [_hH]: _xavi }],
        [0, { [_hH]: _xarc }],
    ],
];
var DeleteObjectRequest = [
    3,
    n0,
    _DOR,
    0,
    [_B, _K, _MFA, _VI, _RP, _BGR, _EBO, _IM, _IMLMT, _IMS],
    [
        [0, 1],
        [0, 1],
        [0, { [_hH]: _xam_ }],
        [0, { [_hQ]: _vI }],
        [0, { [_hH]: _xarp }],
        [2, { [_hH]: _xabgr }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _IM_ }],
        [6, { [_hH]: _xaimlmt }],
        [1, { [_hH]: _xaims }],
    ],
];
var DeleteObjectsOutput = [
    3,
    n0,
    _DOOe,
    { [_xN]: _DRel },
    [_Del, _RC, _Er],
    [
        [() => DeletedObjects, { [_xF]: 1 }],
        [0, { [_hH]: _xarc }],
        [() => Errors, { [_xN]: _Err, [_xF]: 1 }],
    ],
];
var DeleteObjectsRequest = [
    3,
    n0,
    _DORe,
    0,
    [_B, _De, _MFA, _RP, _BGR, _EBO, _CA],
    [
        [0, 1],
        [() => Delete, { [_xN]: _De, [_hP]: 1 }],
        [0, { [_hH]: _xam_ }],
        [0, { [_hH]: _xarp }],
        [2, { [_hH]: _xabgr }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _xasca }],
    ],
];
var DeleteObjectTaggingOutput = [3, n0, _DOTO, 0, [_VI], [[0, { [_hH]: _xavi }]]];
var DeleteObjectTaggingRequest = [
    3,
    n0,
    _DOTR,
    0,
    [_B, _K, _VI, _EBO],
    [
        [0, 1],
        [0, 1],
        [0, { [_hQ]: _vI }],
        [0, { [_hH]: _xaebo }],
    ],
];
var DeletePublicAccessBlockRequest = [
    3,
    n0,
    _DPABR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var Destination = [
    3,
    n0,
    _Des,
    0,
    [_B, _A, _SC, _ACT, _EC, _RT, _Me],
    [0, 0, 0, () => AccessControlTranslation, () => EncryptionConfiguration, () => ReplicationTime, () => Metrics],
];
var DestinationResult = [3, n0, _DRes, 0, [_TBT, _TBA, _TN], [0, 0, 0]];
var Encryption = [3, n0, _En, 0, [_ET, _KMSKI, _KMSC], [0, [() => SSEKMSKeyId, 0], 0]];
var EncryptionConfiguration = [3, n0, _EC, 0, [_RKKID], [0]];
var EncryptionTypeMismatch = [-3, n0, _ETM, { [_e]: _c, [_hE]: 400 }, [], []];
schema.TypeRegistry.for(n0).registerError(EncryptionTypeMismatch, EncryptionTypeMismatch$1);
var EndEvent = [3, n0, _EE, 0, [], []];
var _Error = [3, n0, _Err, 0, [_K, _VI, _Cod, _Mes], [0, 0, 0, 0]];
var ErrorDetails = [3, n0, _ED, 0, [_ECr, _EM], [0, 0]];
var ErrorDocument = [3, n0, _EDr, 0, [_K], [0]];
var EventBridgeConfiguration = [3, n0, _EBC, 0, [], []];
var ExistingObjectReplication = [3, n0, _EOR, 0, [_S], [0]];
var FilterRule = [3, n0, _FR, 0, [_N, _V], [0, 0]];
var GetBucketAbacOutput = [3, n0, _GBAO, 0, [_AS], [[() => AbacStatus, 16]]];
var GetBucketAbacRequest = [
    3,
    n0,
    _GBAR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketAccelerateConfigurationOutput = [
    3,
    n0,
    _GBACO,
    { [_xN]: _AC },
    [_S, _RC],
    [0, [0, { [_hH]: _xarc }]],
];
var GetBucketAccelerateConfigurationRequest = [
    3,
    n0,
    _GBACR,
    0,
    [_B, _EBO, _RP],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _xarp }],
    ],
];
var GetBucketAclOutput = [
    3,
    n0,
    _GBAOe,
    { [_xN]: _ACP },
    [_O, _G],
    [() => Owner, [() => Grants, { [_xN]: _ACL }]],
];
var GetBucketAclRequest = [
    3,
    n0,
    _GBARe,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketAnalyticsConfigurationOutput = [
    3,
    n0,
    _GBACOe,
    0,
    [_ACn],
    [[() => AnalyticsConfiguration, 16]],
];
var GetBucketAnalyticsConfigurationRequest = [
    3,
    n0,
    _GBACRe,
    0,
    [_B, _I, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _i }],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketCorsOutput = [
    3,
    n0,
    _GBCO,
    { [_xN]: _CORSC },
    [_CORSR],
    [[() => CORSRules, { [_xN]: _CORSRu, [_xF]: 1 }]],
];
var GetBucketCorsRequest = [
    3,
    n0,
    _GBCR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketEncryptionOutput = [
    3,
    n0,
    _GBEO,
    0,
    [_SSEC],
    [[() => ServerSideEncryptionConfiguration, 16]],
];
var GetBucketEncryptionRequest = [
    3,
    n0,
    _GBER,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketIntelligentTieringConfigurationOutput = [
    3,
    n0,
    _GBITCO,
    0,
    [_ITC],
    [[() => IntelligentTieringConfiguration, 16]],
];
var GetBucketIntelligentTieringConfigurationRequest = [
    3,
    n0,
    _GBITCR,
    0,
    [_B, _I, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _i }],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketInventoryConfigurationOutput = [
    3,
    n0,
    _GBICO,
    0,
    [_IC],
    [[() => InventoryConfiguration, 16]],
];
var GetBucketInventoryConfigurationRequest = [
    3,
    n0,
    _GBICR,
    0,
    [_B, _I, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _i }],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketLifecycleConfigurationOutput = [
    3,
    n0,
    _GBLCO,
    { [_xN]: _LCi },
    [_R, _TDMOS],
    [
        [() => LifecycleRules, { [_xN]: _Ru, [_xF]: 1 }],
        [0, { [_hH]: _xatdmos }],
    ],
];
var GetBucketLifecycleConfigurationRequest = [
    3,
    n0,
    _GBLCR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketLocationOutput = [3, n0, _GBLO, { [_xN]: _LC }, [_LC], [0]];
var GetBucketLocationRequest = [
    3,
    n0,
    _GBLR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketLoggingOutput = [
    3,
    n0,
    _GBLOe,
    { [_xN]: _BLS },
    [_LE],
    [[() => LoggingEnabled, 0]],
];
var GetBucketLoggingRequest = [
    3,
    n0,
    _GBLRe,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketMetadataConfigurationOutput = [
    3,
    n0,
    _GBMCO,
    0,
    [_GBMCR],
    [[() => GetBucketMetadataConfigurationResult, 16]],
];
var GetBucketMetadataConfigurationRequest = [
    3,
    n0,
    _GBMCRe,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketMetadataConfigurationResult = [
    3,
    n0,
    _GBMCR,
    0,
    [_MCR],
    [() => MetadataConfigurationResult],
];
var GetBucketMetadataTableConfigurationOutput = [
    3,
    n0,
    _GBMTCO,
    0,
    [_GBMTCR],
    [[() => GetBucketMetadataTableConfigurationResult, 16]],
];
var GetBucketMetadataTableConfigurationRequest = [
    3,
    n0,
    _GBMTCRe,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketMetadataTableConfigurationResult = [
    3,
    n0,
    _GBMTCR,
    0,
    [_MTCR, _S, _Err],
    [() => MetadataTableConfigurationResult, 0, () => ErrorDetails],
];
var GetBucketMetricsConfigurationOutput = [
    3,
    n0,
    _GBMCOe,
    0,
    [_MCe],
    [[() => MetricsConfiguration, 16]],
];
var GetBucketMetricsConfigurationRequest = [
    3,
    n0,
    _GBMCRet,
    0,
    [_B, _I, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _i }],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketNotificationConfigurationRequest = [
    3,
    n0,
    _GBNCR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketOwnershipControlsOutput = [
    3,
    n0,
    _GBOCO,
    0,
    [_OC],
    [[() => OwnershipControls, 16]],
];
var GetBucketOwnershipControlsRequest = [
    3,
    n0,
    _GBOCR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketPolicyOutput = [3, n0, _GBPO, 0, [_Po], [[0, 16]]];
var GetBucketPolicyRequest = [
    3,
    n0,
    _GBPR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketPolicyStatusOutput = [3, n0, _GBPSO, 0, [_PS], [[() => PolicyStatus, 16]]];
var GetBucketPolicyStatusRequest = [
    3,
    n0,
    _GBPSR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketReplicationOutput = [
    3,
    n0,
    _GBRO,
    0,
    [_RCe],
    [[() => ReplicationConfiguration, 16]],
];
var GetBucketReplicationRequest = [
    3,
    n0,
    _GBRR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketRequestPaymentOutput = [3, n0, _GBRPO, { [_xN]: _RPC }, [_Pay], [0]];
var GetBucketRequestPaymentRequest = [
    3,
    n0,
    _GBRPR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketTaggingOutput = [3, n0, _GBTO, { [_xN]: _Tag }, [_TS], [[() => TagSet, 0]]];
var GetBucketTaggingRequest = [
    3,
    n0,
    _GBTR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketVersioningOutput = [
    3,
    n0,
    _GBVO,
    { [_xN]: _VC },
    [_S, _MFAD],
    [0, [0, { [_xN]: _MDf }]],
];
var GetBucketVersioningRequest = [
    3,
    n0,
    _GBVR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetBucketWebsiteOutput = [
    3,
    n0,
    _GBWO,
    { [_xN]: _WC },
    [_RART, _IDn, _EDr, _RR],
    [() => RedirectAllRequestsTo, () => IndexDocument, () => ErrorDocument, [() => RoutingRules, 0]],
];
var GetBucketWebsiteRequest = [
    3,
    n0,
    _GBWR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetObjectAclOutput = [
    3,
    n0,
    _GOAO,
    { [_xN]: _ACP },
    [_O, _G, _RC],
    [() => Owner, [() => Grants, { [_xN]: _ACL }], [0, { [_hH]: _xarc }]],
];
var GetObjectAclRequest = [
    3,
    n0,
    _GOAR,
    0,
    [_B, _K, _VI, _RP, _EBO],
    [
        [0, 1],
        [0, 1],
        [0, { [_hQ]: _vI }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetObjectAttributesOutput = [
    3,
    n0,
    _GOAOe,
    { [_xN]: _GOARe },
    [_DM, _LM, _VI, _RC, _ETa, _C, _OP, _SC, _OS],
    [
        [2, { [_hH]: _xadm }],
        [4, { [_hH]: _LM_ }],
        [0, { [_hH]: _xavi }],
        [0, { [_hH]: _xarc }],
        0,
        () => Checksum,
        [() => GetObjectAttributesParts, 0],
        0,
        1,
    ],
];
var GetObjectAttributesParts = [
    3,
    n0,
    _GOAP,
    0,
    [_TPC, _PNM, _NPNM, _MP, _IT, _Pa],
    [[1, { [_xN]: _PC }], 0, 0, 1, 2, [() => PartsList, { [_xN]: _Par, [_xF]: 1 }]],
];
var GetObjectAttributesRequest = [
    3,
    n0,
    _GOARet,
    0,
    [_B, _K, _VI, _MP, _PNM, _SSECA, _SSECK, _SSECKMD, _RP, _EBO, _OA],
    [
        [0, 1],
        [0, 1],
        [0, { [_hQ]: _vI }],
        [1, { [_hH]: _xamp }],
        [0, { [_hH]: _xapnm }],
        [0, { [_hH]: _xasseca }],
        [() => SSECustomerKey, { [_hH]: _xasseck }],
        [0, { [_hH]: _xasseckM }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xaebo }],
        [64 | 0, { [_hH]: _xaoa }],
    ],
];
var GetObjectLegalHoldOutput = [
    3,
    n0,
    _GOLHO,
    0,
    [_LH],
    [[() => ObjectLockLegalHold, { [_xN]: _LH, [_hP]: 1 }]],
];
var GetObjectLegalHoldRequest = [
    3,
    n0,
    _GOLHR,
    0,
    [_B, _K, _VI, _RP, _EBO],
    [
        [0, 1],
        [0, 1],
        [0, { [_hQ]: _vI }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetObjectLockConfigurationOutput = [
    3,
    n0,
    _GOLCO,
    0,
    [_OLC],
    [[() => ObjectLockConfiguration, 16]],
];
var GetObjectLockConfigurationRequest = [
    3,
    n0,
    _GOLCR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetObjectOutput = [
    3,
    n0,
    _GOO,
    0,
    [
        _Bo,
        _DM,
        _AR,
        _E,
        _Re,
        _LM,
        _CLo,
        _ETa,
        _CCRC,
        _CCRCC,
        _CCRCNVME,
        _CSHA,
        _CSHAh,
        _CT,
        _MM,
        _VI,
        _CC,
        _CDo,
        _CEo,
        _CL,
        _CR,
        _CTo,
        _Ex,
        _ES,
        _WRL,
        _SSE,
        _M,
        _SSECA,
        _SSECKMD,
        _SSEKMSKI,
        _BKE,
        _SC,
        _RC,
        _RS,
        _PC,
        _TC,
        _OLM,
        _OLRUD,
        _OLLHS,
    ],
    [
        [() => StreamingBlob, 16],
        [2, { [_hH]: _xadm }],
        [0, { [_hH]: _ar }],
        [0, { [_hH]: _xae }],
        [0, { [_hH]: _xar }],
        [4, { [_hH]: _LM_ }],
        [1, { [_hH]: _CL__ }],
        [0, { [_hH]: _ETa }],
        [0, { [_hH]: _xacc }],
        [0, { [_hH]: _xacc_ }],
        [0, { [_hH]: _xacc__ }],
        [0, { [_hH]: _xacs }],
        [0, { [_hH]: _xacs_ }],
        [0, { [_hH]: _xact }],
        [1, { [_hH]: _xamm }],
        [0, { [_hH]: _xavi }],
        [0, { [_hH]: _CC_ }],
        [0, { [_hH]: _CD_ }],
        [0, { [_hH]: _CE_ }],
        [0, { [_hH]: _CL_ }],
        [0, { [_hH]: _CR_ }],
        [0, { [_hH]: _CT_ }],
        [4, { [_hH]: _Ex }],
        [0, { [_hH]: _ES }],
        [0, { [_hH]: _xawrl }],
        [0, { [_hH]: _xasse }],
        [128 | 0, { [_hPH]: _xam }],
        [0, { [_hH]: _xasseca }],
        [0, { [_hH]: _xasseckM }],
        [() => SSEKMSKeyId, { [_hH]: _xasseakki }],
        [2, { [_hH]: _xassebke }],
        [0, { [_hH]: _xasc }],
        [0, { [_hH]: _xarc }],
        [0, { [_hH]: _xars }],
        [1, { [_hH]: _xampc }],
        [1, { [_hH]: _xatc }],
        [0, { [_hH]: _xaolm }],
        [5, { [_hH]: _xaolrud }],
        [0, { [_hH]: _xaollh }],
    ],
];
var GetObjectRequest = [
    3,
    n0,
    _GOR,
    0,
    [
        _B,
        _IM,
        _IMSf,
        _INM,
        _IUS,
        _K,
        _Ra,
        _RCC,
        _RCD,
        _RCE,
        _RCL,
        _RCT,
        _RE,
        _VI,
        _SSECA,
        _SSECK,
        _SSECKMD,
        _RP,
        _PN,
        _EBO,
        _CMh,
    ],
    [
        [0, 1],
        [0, { [_hH]: _IM_ }],
        [4, { [_hH]: _IMS_ }],
        [0, { [_hH]: _INM_ }],
        [4, { [_hH]: _IUS_ }],
        [0, 1],
        [0, { [_hH]: _Ra }],
        [0, { [_hQ]: _rcc }],
        [0, { [_hQ]: _rcd }],
        [0, { [_hQ]: _rce }],
        [0, { [_hQ]: _rcl }],
        [0, { [_hQ]: _rct }],
        [6, { [_hQ]: _re }],
        [0, { [_hQ]: _vI }],
        [0, { [_hH]: _xasseca }],
        [() => SSECustomerKey, { [_hH]: _xasseck }],
        [0, { [_hH]: _xasseckM }],
        [0, { [_hH]: _xarp }],
        [1, { [_hQ]: _pN }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _xacm }],
    ],
];
var GetObjectRetentionOutput = [
    3,
    n0,
    _GORO,
    0,
    [_Ret],
    [[() => ObjectLockRetention, { [_xN]: _Ret, [_hP]: 1 }]],
];
var GetObjectRetentionRequest = [
    3,
    n0,
    _GORR,
    0,
    [_B, _K, _VI, _RP, _EBO],
    [
        [0, 1],
        [0, 1],
        [0, { [_hQ]: _vI }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetObjectTaggingOutput = [
    3,
    n0,
    _GOTO,
    { [_xN]: _Tag },
    [_VI, _TS],
    [
        [0, { [_hH]: _xavi }],
        [() => TagSet, 0],
    ],
];
var GetObjectTaggingRequest = [
    3,
    n0,
    _GOTR,
    0,
    [_B, _K, _VI, _EBO, _RP],
    [
        [0, 1],
        [0, 1],
        [0, { [_hQ]: _vI }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _xarp }],
    ],
];
var GetObjectTorrentOutput = [
    3,
    n0,
    _GOTOe,
    0,
    [_Bo, _RC],
    [
        [() => StreamingBlob, 16],
        [0, { [_hH]: _xarc }],
    ],
];
var GetObjectTorrentRequest = [
    3,
    n0,
    _GOTRe,
    0,
    [_B, _K, _RP, _EBO],
    [
        [0, 1],
        [0, 1],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xaebo }],
    ],
];
var GetPublicAccessBlockOutput = [
    3,
    n0,
    _GPABO,
    0,
    [_PABC],
    [[() => PublicAccessBlockConfiguration, 16]],
];
var GetPublicAccessBlockRequest = [
    3,
    n0,
    _GPABR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var GlacierJobParameters = [3, n0, _GJP, 0, [_Ti], [0]];
var Grant = [3, n0, _Gr, 0, [_Gra, _Pe], [[() => Grantee, { [_xNm]: [_x, _hi] }], 0]];
var Grantee = [
    3,
    n0,
    _Gra,
    0,
    [_DN, _EA, _ID, _URI, _Ty],
    [0, 0, 0, 0, [0, { [_xN]: _xs, [_xA]: 1 }]],
];
var HeadBucketOutput = [
    3,
    n0,
    _HBO,
    0,
    [_BA, _BLT, _BLN, _BR, _APA],
    [
        [0, { [_hH]: _xaba }],
        [0, { [_hH]: _xablt }],
        [0, { [_hH]: _xabln }],
        [0, { [_hH]: _xabr }],
        [2, { [_hH]: _xaapa }],
    ],
];
var HeadBucketRequest = [
    3,
    n0,
    _HBR,
    0,
    [_B, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _xaebo }],
    ],
];
var HeadObjectOutput = [
    3,
    n0,
    _HOO,
    0,
    [
        _DM,
        _AR,
        _E,
        _Re,
        _ASr,
        _LM,
        _CLo,
        _CCRC,
        _CCRCC,
        _CCRCNVME,
        _CSHA,
        _CSHAh,
        _CT,
        _ETa,
        _MM,
        _VI,
        _CC,
        _CDo,
        _CEo,
        _CL,
        _CTo,
        _CR,
        _Ex,
        _ES,
        _WRL,
        _SSE,
        _M,
        _SSECA,
        _SSECKMD,
        _SSEKMSKI,
        _BKE,
        _SC,
        _RC,
        _RS,
        _PC,
        _TC,
        _OLM,
        _OLRUD,
        _OLLHS,
    ],
    [
        [2, { [_hH]: _xadm }],
        [0, { [_hH]: _ar }],
        [0, { [_hH]: _xae }],
        [0, { [_hH]: _xar }],
        [0, { [_hH]: _xaas }],
        [4, { [_hH]: _LM_ }],
        [1, { [_hH]: _CL__ }],
        [0, { [_hH]: _xacc }],
        [0, { [_hH]: _xacc_ }],
        [0, { [_hH]: _xacc__ }],
        [0, { [_hH]: _xacs }],
        [0, { [_hH]: _xacs_ }],
        [0, { [_hH]: _xact }],
        [0, { [_hH]: _ETa }],
        [1, { [_hH]: _xamm }],
        [0, { [_hH]: _xavi }],
        [0, { [_hH]: _CC_ }],
        [0, { [_hH]: _CD_ }],
        [0, { [_hH]: _CE_ }],
        [0, { [_hH]: _CL_ }],
        [0, { [_hH]: _CT_ }],
        [0, { [_hH]: _CR_ }],
        [4, { [_hH]: _Ex }],
        [0, { [_hH]: _ES }],
        [0, { [_hH]: _xawrl }],
        [0, { [_hH]: _xasse }],
        [128 | 0, { [_hPH]: _xam }],
        [0, { [_hH]: _xasseca }],
        [0, { [_hH]: _xasseckM }],
        [() => SSEKMSKeyId, { [_hH]: _xasseakki }],
        [2, { [_hH]: _xassebke }],
        [0, { [_hH]: _xasc }],
        [0, { [_hH]: _xarc }],
        [0, { [_hH]: _xars }],
        [1, { [_hH]: _xampc }],
        [1, { [_hH]: _xatc }],
        [0, { [_hH]: _xaolm }],
        [5, { [_hH]: _xaolrud }],
        [0, { [_hH]: _xaollh }],
    ],
];
var HeadObjectRequest = [
    3,
    n0,
    _HOR,
    0,
    [
        _B,
        _IM,
        _IMSf,
        _INM,
        _IUS,
        _K,
        _Ra,
        _RCC,
        _RCD,
        _RCE,
        _RCL,
        _RCT,
        _RE,
        _VI,
        _SSECA,
        _SSECK,
        _SSECKMD,
        _RP,
        _PN,
        _EBO,
        _CMh,
    ],
    [
        [0, 1],
        [0, { [_hH]: _IM_ }],
        [4, { [_hH]: _IMS_ }],
        [0, { [_hH]: _INM_ }],
        [4, { [_hH]: _IUS_ }],
        [0, 1],
        [0, { [_hH]: _Ra }],
        [0, { [_hQ]: _rcc }],
        [0, { [_hQ]: _rcd }],
        [0, { [_hQ]: _rce }],
        [0, { [_hQ]: _rcl }],
        [0, { [_hQ]: _rct }],
        [6, { [_hQ]: _re }],
        [0, { [_hQ]: _vI }],
        [0, { [_hH]: _xasseca }],
        [() => SSECustomerKey, { [_hH]: _xasseck }],
        [0, { [_hH]: _xasseckM }],
        [0, { [_hH]: _xarp }],
        [1, { [_hQ]: _pN }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _xacm }],
    ],
];
var IdempotencyParameterMismatch = [-3, n0, _IPM, { [_e]: _c, [_hE]: 400 }, [], []];
schema.TypeRegistry.for(n0).registerError(IdempotencyParameterMismatch, IdempotencyParameterMismatch$1);
var IndexDocument = [3, n0, _IDn, 0, [_Su], [0]];
var Initiator = [3, n0, _In, 0, [_ID, _DN], [0, 0]];
var InputSerialization = [
    3,
    n0,
    _IS,
    0,
    [_CSV, _CTom, _JSON, _Parq],
    [() => CSVInput, 0, () => JSONInput, () => ParquetInput],
];
var IntelligentTieringAndOperator = [
    3,
    n0,
    _ITAO,
    0,
    [_P, _T],
    [0, [() => TagSet, { [_xN]: _Ta, [_xF]: 1 }]],
];
var IntelligentTieringConfiguration = [
    3,
    n0,
    _ITC,
    0,
    [_I, _F, _S, _Tie],
    [0, [() => IntelligentTieringFilter, 0], 0, [() => TieringList, { [_xN]: _Tier, [_xF]: 1 }]],
];
var IntelligentTieringFilter = [
    3,
    n0,
    _ITF,
    0,
    [_P, _Ta, _An],
    [0, () => Tag, [() => IntelligentTieringAndOperator, 0]],
];
var InvalidObjectState = [-3, n0, _IOS, { [_e]: _c, [_hE]: 403 }, [_SC, _AT], [0, 0]];
schema.TypeRegistry.for(n0).registerError(InvalidObjectState, InvalidObjectState$1);
var InvalidRequest = [-3, n0, _IR, { [_e]: _c, [_hE]: 400 }, [], []];
schema.TypeRegistry.for(n0).registerError(InvalidRequest, InvalidRequest$1);
var InvalidWriteOffset = [-3, n0, _IWO, { [_e]: _c, [_hE]: 400 }, [], []];
schema.TypeRegistry.for(n0).registerError(InvalidWriteOffset, InvalidWriteOffset$1);
var InventoryConfiguration = [
    3,
    n0,
    _IC,
    0,
    [_Des, _IE, _F, _I, _IOV, _OF, _Sc],
    [
        [() => InventoryDestination, 0],
        2,
        () => InventoryFilter,
        0,
        0,
        [() => InventoryOptionalFields, 0],
        () => InventorySchedule,
    ],
];
var InventoryDestination = [
    3,
    n0,
    _IDnv,
    0,
    [_SBD],
    [[() => InventoryS3BucketDestination, 0]],
];
var InventoryEncryption = [
    3,
    n0,
    _IEn,
    0,
    [_SSES, _SSEKMS],
    [
        [() => SSES3, { [_xN]: _SS }],
        [() => SSEKMS, { [_xN]: _SK }],
    ],
];
var InventoryFilter = [3, n0, _IF, 0, [_P], [0]];
var InventoryS3BucketDestination = [
    3,
    n0,
    _ISBD,
    0,
    [_AI, _B, _Fo, _P, _En],
    [0, 0, 0, 0, [() => InventoryEncryption, 0]],
];
var InventorySchedule = [3, n0, _ISn, 0, [_Fr], [0]];
var InventoryTableConfiguration = [
    3,
    n0,
    _ITCn,
    0,
    [_CSo, _EC],
    [0, () => MetadataTableEncryptionConfiguration],
];
var InventoryTableConfigurationResult = [
    3,
    n0,
    _ITCR,
    0,
    [_CSo, _TSa, _Err, _TNa, _TA],
    [0, 0, () => ErrorDetails, 0, 0],
];
var InventoryTableConfigurationUpdates = [
    3,
    n0,
    _ITCU,
    0,
    [_CSo, _EC],
    [0, () => MetadataTableEncryptionConfiguration],
];
var JournalTableConfiguration = [
    3,
    n0,
    _JTC,
    0,
    [_REe, _EC],
    [() => RecordExpiration, () => MetadataTableEncryptionConfiguration],
];
var JournalTableConfigurationResult = [
    3,
    n0,
    _JTCR,
    0,
    [_TSa, _Err, _TNa, _TA, _REe],
    [0, () => ErrorDetails, 0, 0, () => RecordExpiration],
];
var JournalTableConfigurationUpdates = [
    3,
    n0,
    _JTCU,
    0,
    [_REe],
    [() => RecordExpiration],
];
var JSONInput = [3, n0, _JSONI, 0, [_Ty], [0]];
var JSONOutput = [3, n0, _JSONO, 0, [_RD], [0]];
var LambdaFunctionConfiguration = [
    3,
    n0,
    _LFC,
    0,
    [_I, _LFA, _Ev, _F],
    [0, [0, { [_xN]: _CF }], [64 | 0, { [_xN]: _Eve, [_xF]: 1 }], [() => NotificationConfigurationFilter, 0]],
];
var LifecycleExpiration = [3, n0, _LEi, 0, [_Da, _D, _EODM], [5, 1, 2]];
var LifecycleRule = [
    3,
    n0,
    _LR,
    0,
    [_E, _ID, _P, _F, _S, _Tr, _NVT, _NVE, _AIMU],
    [
        () => LifecycleExpiration,
        0,
        0,
        [() => LifecycleRuleFilter, 0],
        0,
        [() => TransitionList, { [_xN]: _Tra, [_xF]: 1 }],
        [() => NoncurrentVersionTransitionList, { [_xN]: _NVTo, [_xF]: 1 }],
        () => NoncurrentVersionExpiration,
        () => AbortIncompleteMultipartUpload,
    ],
];
var LifecycleRuleAndOperator = [
    3,
    n0,
    _LRAO,
    0,
    [_P, _T, _OSGT, _OSLT],
    [0, [() => TagSet, { [_xN]: _Ta, [_xF]: 1 }], 1, 1],
];
var LifecycleRuleFilter = [
    3,
    n0,
    _LRF,
    0,
    [_P, _Ta, _OSGT, _OSLT, _An],
    [0, () => Tag, 1, 1, [() => LifecycleRuleAndOperator, 0]],
];
var ListBucketAnalyticsConfigurationsOutput = [
    3,
    n0,
    _LBACO,
    { [_xN]: _LBACR },
    [_IT, _CTon, _NCT, _ACLn],
    [2, 0, 0, [() => AnalyticsConfigurationList, { [_xN]: _ACn, [_xF]: 1 }]],
];
var ListBucketAnalyticsConfigurationsRequest = [
    3,
    n0,
    _LBACRi,
    0,
    [_B, _CTon, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _ct }],
        [0, { [_hH]: _xaebo }],
    ],
];
var ListBucketIntelligentTieringConfigurationsOutput = [
    3,
    n0,
    _LBITCO,
    0,
    [_IT, _CTon, _NCT, _ITCL],
    [2, 0, 0, [() => IntelligentTieringConfigurationList, { [_xN]: _ITC, [_xF]: 1 }]],
];
var ListBucketIntelligentTieringConfigurationsRequest = [
    3,
    n0,
    _LBITCR,
    0,
    [_B, _CTon, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _ct }],
        [0, { [_hH]: _xaebo }],
    ],
];
var ListBucketInventoryConfigurationsOutput = [
    3,
    n0,
    _LBICO,
    { [_xN]: _LICR },
    [_CTon, _ICL, _IT, _NCT],
    [0, [() => InventoryConfigurationList, { [_xN]: _IC, [_xF]: 1 }], 2, 0],
];
var ListBucketInventoryConfigurationsRequest = [
    3,
    n0,
    _LBICR,
    0,
    [_B, _CTon, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _ct }],
        [0, { [_hH]: _xaebo }],
    ],
];
var ListBucketMetricsConfigurationsOutput = [
    3,
    n0,
    _LBMCO,
    { [_xN]: _LMCR },
    [_IT, _CTon, _NCT, _MCL],
    [2, 0, 0, [() => MetricsConfigurationList, { [_xN]: _MCe, [_xF]: 1 }]],
];
var ListBucketMetricsConfigurationsRequest = [
    3,
    n0,
    _LBMCR,
    0,
    [_B, _CTon, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _ct }],
        [0, { [_hH]: _xaebo }],
    ],
];
var ListBucketsOutput = [
    3,
    n0,
    _LBO,
    { [_xN]: _LAMBR },
    [_Bu, _O, _CTon, _P],
    [[() => Buckets, 0], () => Owner, 0, 0],
];
var ListBucketsRequest = [
    3,
    n0,
    _LBR,
    0,
    [_MB, _CTon, _P, _BR],
    [
        [1, { [_hQ]: _mb }],
        [0, { [_hQ]: _ct }],
        [0, { [_hQ]: _p }],
        [0, { [_hQ]: _br }],
    ],
];
var ListDirectoryBucketsOutput = [
    3,
    n0,
    _LDBO,
    { [_xN]: _LAMDBR },
    [_Bu, _CTon],
    [[() => Buckets, 0], 0],
];
var ListDirectoryBucketsRequest = [
    3,
    n0,
    _LDBR,
    0,
    [_CTon, _MDB],
    [
        [0, { [_hQ]: _ct }],
        [1, { [_hQ]: _mdb }],
    ],
];
var ListMultipartUploadsOutput = [
    3,
    n0,
    _LMUO,
    { [_xN]: _LMUR },
    [_B, _KM, _UIM, _NKM, _P, _Deli, _NUIM, _MUa, _IT, _U, _CPom, _ETn, _RC],
    [
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        1,
        2,
        [() => MultipartUploadList, { [_xN]: _Up, [_xF]: 1 }],
        [() => CommonPrefixList, { [_xF]: 1 }],
        0,
        [0, { [_hH]: _xarc }],
    ],
];
var ListMultipartUploadsRequest = [
    3,
    n0,
    _LMURi,
    0,
    [_B, _Deli, _ETn, _KM, _MUa, _P, _UIM, _EBO, _RP],
    [
        [0, 1],
        [0, { [_hQ]: _d }],
        [0, { [_hQ]: _et }],
        [0, { [_hQ]: _km }],
        [1, { [_hQ]: _mu }],
        [0, { [_hQ]: _p }],
        [0, { [_hQ]: _uim }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _xarp }],
    ],
];
var ListObjectsOutput = [
    3,
    n0,
    _LOO,
    { [_xN]: _LBRi },
    [_IT, _Ma, _NM, _Con, _N, _P, _Deli, _MK, _CPom, _ETn, _RC],
    [
        2,
        0,
        0,
        [() => ObjectList, { [_xF]: 1 }],
        0,
        0,
        0,
        1,
        [() => CommonPrefixList, { [_xF]: 1 }],
        0,
        [0, { [_hH]: _xarc }],
    ],
];
var ListObjectsRequest = [
    3,
    n0,
    _LOR,
    0,
    [_B, _Deli, _ETn, _Ma, _MK, _P, _RP, _EBO, _OOA],
    [
        [0, 1],
        [0, { [_hQ]: _d }],
        [0, { [_hQ]: _et }],
        [0, { [_hQ]: _m }],
        [1, { [_hQ]: _mk }],
        [0, { [_hQ]: _p }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xaebo }],
        [64 | 0, { [_hH]: _xaooa }],
    ],
];
var ListObjectsV2Output = [
    3,
    n0,
    _LOVO,
    { [_xN]: _LBRi },
    [_IT, _Con, _N, _P, _Deli, _MK, _CPom, _ETn, _KC, _CTon, _NCT, _SA, _RC],
    [
        2,
        [() => ObjectList, { [_xF]: 1 }],
        0,
        0,
        0,
        1,
        [() => CommonPrefixList, { [_xF]: 1 }],
        0,
        1,
        0,
        0,
        0,
        [0, { [_hH]: _xarc }],
    ],
];
var ListObjectsV2Request = [
    3,
    n0,
    _LOVR,
    0,
    [_B, _Deli, _ETn, _MK, _P, _CTon, _FO, _SA, _RP, _EBO, _OOA],
    [
        [0, 1],
        [0, { [_hQ]: _d }],
        [0, { [_hQ]: _et }],
        [1, { [_hQ]: _mk }],
        [0, { [_hQ]: _p }],
        [0, { [_hQ]: _ct }],
        [2, { [_hQ]: _fo }],
        [0, { [_hQ]: _sa }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xaebo }],
        [64 | 0, { [_hH]: _xaooa }],
    ],
];
var ListObjectVersionsOutput = [
    3,
    n0,
    _LOVOi,
    { [_xN]: _LVR },
    [_IT, _KM, _VIM, _NKM, _NVIM, _Ve, _DMe, _N, _P, _Deli, _MK, _CPom, _ETn, _RC],
    [
        2,
        0,
        0,
        0,
        0,
        [() => ObjectVersionList, { [_xN]: _Ver, [_xF]: 1 }],
        [() => DeleteMarkers, { [_xN]: _DM, [_xF]: 1 }],
        0,
        0,
        0,
        1,
        [() => CommonPrefixList, { [_xF]: 1 }],
        0,
        [0, { [_hH]: _xarc }],
    ],
];
var ListObjectVersionsRequest = [
    3,
    n0,
    _LOVRi,
    0,
    [_B, _Deli, _ETn, _KM, _MK, _P, _VIM, _EBO, _RP, _OOA],
    [
        [0, 1],
        [0, { [_hQ]: _d }],
        [0, { [_hQ]: _et }],
        [0, { [_hQ]: _km }],
        [1, { [_hQ]: _mk }],
        [0, { [_hQ]: _p }],
        [0, { [_hQ]: _vim }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _xarp }],
        [64 | 0, { [_hH]: _xaooa }],
    ],
];
var ListPartsOutput = [
    3,
    n0,
    _LPO,
    { [_xN]: _LPR },
    [_AD, _ARI, _B, _K, _UI, _PNM, _NPNM, _MP, _IT, _Pa, _In, _O, _SC, _RC, _CA, _CT],
    [
        [4, { [_hH]: _xaad }],
        [0, { [_hH]: _xaari }],
        0,
        0,
        0,
        0,
        0,
        1,
        2,
        [() => Parts, { [_xN]: _Par, [_xF]: 1 }],
        () => Initiator,
        () => Owner,
        0,
        [0, { [_hH]: _xarc }],
        0,
        0,
    ],
];
var ListPartsRequest = [
    3,
    n0,
    _LPRi,
    0,
    [_B, _K, _MP, _PNM, _UI, _RP, _EBO, _SSECA, _SSECK, _SSECKMD],
    [
        [0, 1],
        [0, 1],
        [1, { [_hQ]: _mp }],
        [0, { [_hQ]: _pnm }],
        [0, { [_hQ]: _uI }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _xasseca }],
        [() => SSECustomerKey, { [_hH]: _xasseck }],
        [0, { [_hH]: _xasseckM }],
    ],
];
var LocationInfo = [3, n0, _LI, 0, [_Ty, _N], [0, 0]];
var LoggingEnabled = [
    3,
    n0,
    _LE,
    0,
    [_TB, _TG, _TP, _TOKF],
    [0, [() => TargetGrants, 0], 0, [() => TargetObjectKeyFormat, 0]],
];
var MetadataConfiguration = [
    3,
    n0,
    _MC,
    0,
    [_JTC, _ITCn],
    [() => JournalTableConfiguration, () => InventoryTableConfiguration],
];
var MetadataConfigurationResult = [
    3,
    n0,
    _MCR,
    0,
    [_DRes, _JTCR, _ITCR],
    [() => DestinationResult, () => JournalTableConfigurationResult, () => InventoryTableConfigurationResult],
];
var MetadataEntry = [3, n0, _ME, 0, [_N, _V], [0, 0]];
var MetadataTableConfiguration = [3, n0, _MTC, 0, [_STD], [() => S3TablesDestination]];
var MetadataTableConfigurationResult = [
    3,
    n0,
    _MTCR,
    0,
    [_STDR],
    [() => S3TablesDestinationResult],
];
var MetadataTableEncryptionConfiguration = [3, n0, _MTEC, 0, [_SAs, _KKA], [0, 0]];
var Metrics = [3, n0, _Me, 0, [_S, _ETv], [0, () => ReplicationTimeValue]];
var MetricsAndOperator = [
    3,
    n0,
    _MAO,
    0,
    [_P, _T, _APAc],
    [0, [() => TagSet, { [_xN]: _Ta, [_xF]: 1 }], 0],
];
var MetricsConfiguration = [3, n0, _MCe, 0, [_I, _F], [0, [() => MetricsFilter, 0]]];
var MultipartUpload = [
    3,
    n0,
    _MU,
    0,
    [_UI, _K, _Ini, _SC, _O, _In, _CA, _CT],
    [0, 0, 4, 0, () => Owner, () => Initiator, 0, 0],
];
var NoncurrentVersionExpiration = [3, n0, _NVE, 0, [_ND, _NNV], [1, 1]];
var NoncurrentVersionTransition = [3, n0, _NVTo, 0, [_ND, _SC, _NNV], [1, 0, 1]];
var NoSuchBucket = [-3, n0, _NSB, { [_e]: _c, [_hE]: 404 }, [], []];
schema.TypeRegistry.for(n0).registerError(NoSuchBucket, NoSuchBucket$1);
var NoSuchKey = [-3, n0, _NSK, { [_e]: _c, [_hE]: 404 }, [], []];
schema.TypeRegistry.for(n0).registerError(NoSuchKey, NoSuchKey$1);
var NoSuchUpload = [-3, n0, _NSU, { [_e]: _c, [_hE]: 404 }, [], []];
schema.TypeRegistry.for(n0).registerError(NoSuchUpload, NoSuchUpload$1);
var NotFound = [-3, n0, _NF, { [_e]: _c }, [], []];
schema.TypeRegistry.for(n0).registerError(NotFound, NotFound$1);
var NotificationConfiguration = [
    3,
    n0,
    _NC,
    0,
    [_TCo, _QCu, _LFCa, _EBC],
    [
        [() => TopicConfigurationList, { [_xN]: _TCop, [_xF]: 1 }],
        [() => QueueConfigurationList, { [_xN]: _QCue, [_xF]: 1 }],
        [() => LambdaFunctionConfigurationList, { [_xN]: _CFC, [_xF]: 1 }],
        () => EventBridgeConfiguration,
    ],
];
var NotificationConfigurationFilter = [
    3,
    n0,
    _NCF,
    0,
    [_K],
    [[() => S3KeyFilter, { [_xN]: _SKe }]],
];
var _Object = [
    3,
    n0,
    _Obj,
    0,
    [_K, _LM, _ETa, _CA, _CT, _Si, _SC, _O, _RSe],
    [0, 4, 0, [64 | 0, { [_xF]: 1 }], 0, 1, 0, () => Owner, () => RestoreStatus],
];
var ObjectAlreadyInActiveTierError = [-3, n0, _OAIATE, { [_e]: _c, [_hE]: 403 }, [], []];
schema.TypeRegistry.for(n0).registerError(ObjectAlreadyInActiveTierError, ObjectAlreadyInActiveTierError$1);
var ObjectIdentifier = [3, n0, _OI, 0, [_K, _VI, _ETa, _LMT, _Si], [0, 0, 0, 6, 1]];
var ObjectLockConfiguration = [3, n0, _OLC, 0, [_OLE, _Ru], [0, () => ObjectLockRule]];
var ObjectLockLegalHold = [3, n0, _OLLH, 0, [_S], [0]];
var ObjectLockRetention = [3, n0, _OLR, 0, [_Mo, _RUD], [0, 5]];
var ObjectLockRule = [3, n0, _OLRb, 0, [_DRe], [() => DefaultRetention]];
var ObjectNotInActiveTierError = [-3, n0, _ONIATE, { [_e]: _c, [_hE]: 403 }, [], []];
schema.TypeRegistry.for(n0).registerError(ObjectNotInActiveTierError, ObjectNotInActiveTierError$1);
var ObjectPart = [
    3,
    n0,
    _OPb,
    0,
    [_PN, _Si, _CCRC, _CCRCC, _CCRCNVME, _CSHA, _CSHAh],
    [1, 1, 0, 0, 0, 0, 0],
];
var ObjectVersion = [
    3,
    n0,
    _OV,
    0,
    [_ETa, _CA, _CT, _Si, _SC, _K, _VI, _IL, _LM, _O, _RSe],
    [0, [64 | 0, { [_xF]: 1 }], 0, 1, 0, 0, 0, 2, 4, () => Owner, () => RestoreStatus],
];
var OutputLocation = [3, n0, _OL, 0, [_S_], [[() => S3Location, 0]]];
var OutputSerialization = [
    3,
    n0,
    _OSu,
    0,
    [_CSV, _JSON],
    [() => CSVOutput, () => JSONOutput],
];
var Owner = [3, n0, _O, 0, [_DN, _ID], [0, 0]];
var OwnershipControls = [
    3,
    n0,
    _OC,
    0,
    [_R],
    [[() => OwnershipControlsRules, { [_xN]: _Ru, [_xF]: 1 }]],
];
var OwnershipControlsRule = [3, n0, _OCR, 0, [_OO], [0]];
var ParquetInput = [3, n0, _PI, 0, [], []];
var Part = [
    3,
    n0,
    _Par,
    0,
    [_PN, _LM, _ETa, _Si, _CCRC, _CCRCC, _CCRCNVME, _CSHA, _CSHAh],
    [1, 4, 0, 1, 0, 0, 0, 0, 0],
];
var PartitionedPrefix = [3, n0, _PP, { [_xN]: _PP }, [_PDS], [0]];
var PolicyStatus = [3, n0, _PS, 0, [_IP], [[2, { [_xN]: _IP }]]];
var Progress = [3, n0, _Pr, 0, [_BS, _BP, _BRy], [1, 1, 1]];
var ProgressEvent = [3, n0, _PE, 0, [_Det], [[() => Progress, { [_eP]: 1 }]]];
var PublicAccessBlockConfiguration = [
    3,
    n0,
    _PABC,
    0,
    [_BPA, _IPA, _BPP, _RPB],
    [
        [2, { [_xN]: _BPA }],
        [2, { [_xN]: _IPA }],
        [2, { [_xN]: _BPP }],
        [2, { [_xN]: _RPB }],
    ],
];
var PutBucketAbacRequest = [
    3,
    n0,
    _PBAR,
    0,
    [_B, _CMD, _CA, _EBO, _AS],
    [
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [0, { [_hH]: _xaebo }],
        [() => AbacStatus, { [_xN]: _AS, [_hP]: 1 }],
    ],
];
var PutBucketAccelerateConfigurationRequest = [
    3,
    n0,
    _PBACR,
    0,
    [_B, _AC, _EBO, _CA],
    [
        [0, 1],
        [() => AccelerateConfiguration, { [_xN]: _AC, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _xasca }],
    ],
];
var PutBucketAclRequest = [
    3,
    n0,
    _PBARu,
    0,
    [_ACL_, _ACP, _B, _CMD, _CA, _GFC, _GR, _GRACP, _GW, _GWACP, _EBO],
    [
        [0, { [_hH]: _xaa }],
        [() => AccessControlPolicy, { [_xN]: _ACP, [_hP]: 1 }],
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [0, { [_hH]: _xagfc }],
        [0, { [_hH]: _xagr }],
        [0, { [_hH]: _xagra }],
        [0, { [_hH]: _xagw }],
        [0, { [_hH]: _xagwa }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutBucketAnalyticsConfigurationRequest = [
    3,
    n0,
    _PBACRu,
    0,
    [_B, _I, _ACn, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _i }],
        [() => AnalyticsConfiguration, { [_xN]: _ACn, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutBucketCorsRequest = [
    3,
    n0,
    _PBCR,
    0,
    [_B, _CORSC, _CMD, _CA, _EBO],
    [
        [0, 1],
        [() => CORSConfiguration, { [_xN]: _CORSC, [_hP]: 1 }],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutBucketEncryptionRequest = [
    3,
    n0,
    _PBER,
    0,
    [_B, _CMD, _CA, _SSEC, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [() => ServerSideEncryptionConfiguration, { [_xN]: _SSEC, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutBucketIntelligentTieringConfigurationRequest = [
    3,
    n0,
    _PBITCR,
    0,
    [_B, _I, _EBO, _ITC],
    [
        [0, 1],
        [0, { [_hQ]: _i }],
        [0, { [_hH]: _xaebo }],
        [() => IntelligentTieringConfiguration, { [_xN]: _ITC, [_hP]: 1 }],
    ],
];
var PutBucketInventoryConfigurationRequest = [
    3,
    n0,
    _PBICR,
    0,
    [_B, _I, _IC, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _i }],
        [() => InventoryConfiguration, { [_xN]: _IC, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutBucketLifecycleConfigurationOutput = [
    3,
    n0,
    _PBLCO,
    0,
    [_TDMOS],
    [[0, { [_hH]: _xatdmos }]],
];
var PutBucketLifecycleConfigurationRequest = [
    3,
    n0,
    _PBLCR,
    0,
    [_B, _CA, _LCi, _EBO, _TDMOS],
    [
        [0, 1],
        [0, { [_hH]: _xasca }],
        [() => BucketLifecycleConfiguration, { [_xN]: _LCi, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _xatdmos }],
    ],
];
var PutBucketLoggingRequest = [
    3,
    n0,
    _PBLR,
    0,
    [_B, _BLS, _CMD, _CA, _EBO],
    [
        [0, 1],
        [() => BucketLoggingStatus, { [_xN]: _BLS, [_hP]: 1 }],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutBucketMetricsConfigurationRequest = [
    3,
    n0,
    _PBMCR,
    0,
    [_B, _I, _MCe, _EBO],
    [
        [0, 1],
        [0, { [_hQ]: _i }],
        [() => MetricsConfiguration, { [_xN]: _MCe, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutBucketNotificationConfigurationRequest = [
    3,
    n0,
    _PBNCR,
    0,
    [_B, _NC, _EBO, _SDV],
    [
        [0, 1],
        [() => NotificationConfiguration, { [_xN]: _NC, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
        [2, { [_hH]: _xasdv }],
    ],
];
var PutBucketOwnershipControlsRequest = [
    3,
    n0,
    _PBOCR,
    0,
    [_B, _CMD, _EBO, _OC, _CA],
    [
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xaebo }],
        [() => OwnershipControls, { [_xN]: _OC, [_hP]: 1 }],
        [0, { [_hH]: _xasca }],
    ],
];
var PutBucketPolicyRequest = [
    3,
    n0,
    _PBPR,
    0,
    [_B, _CMD, _CA, _CRSBA, _Po, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [2, { [_hH]: _xacrsba }],
        [0, 16],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutBucketReplicationRequest = [
    3,
    n0,
    _PBRR,
    0,
    [_B, _CMD, _CA, _RCe, _To, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [() => ReplicationConfiguration, { [_xN]: _RCe, [_hP]: 1 }],
        [0, { [_hH]: _xabolt }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutBucketRequestPaymentRequest = [
    3,
    n0,
    _PBRPR,
    0,
    [_B, _CMD, _CA, _RPC, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [() => RequestPaymentConfiguration, { [_xN]: _RPC, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutBucketTaggingRequest = [
    3,
    n0,
    _PBTR,
    0,
    [_B, _CMD, _CA, _Tag, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [() => Tagging, { [_xN]: _Tag, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutBucketVersioningRequest = [
    3,
    n0,
    _PBVR,
    0,
    [_B, _CMD, _CA, _MFA, _VC, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [0, { [_hH]: _xam_ }],
        [() => VersioningConfiguration, { [_xN]: _VC, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutBucketWebsiteRequest = [
    3,
    n0,
    _PBWR,
    0,
    [_B, _CMD, _CA, _WC, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [() => WebsiteConfiguration, { [_xN]: _WC, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutObjectAclOutput = [3, n0, _POAO, 0, [_RC], [[0, { [_hH]: _xarc }]]];
var PutObjectAclRequest = [
    3,
    n0,
    _POAR,
    0,
    [_ACL_, _ACP, _B, _CMD, _CA, _GFC, _GR, _GRACP, _GW, _GWACP, _K, _RP, _VI, _EBO],
    [
        [0, { [_hH]: _xaa }],
        [() => AccessControlPolicy, { [_xN]: _ACP, [_hP]: 1 }],
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [0, { [_hH]: _xagfc }],
        [0, { [_hH]: _xagr }],
        [0, { [_hH]: _xagra }],
        [0, { [_hH]: _xagw }],
        [0, { [_hH]: _xagwa }],
        [0, 1],
        [0, { [_hH]: _xarp }],
        [0, { [_hQ]: _vI }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutObjectLegalHoldOutput = [3, n0, _POLHO, 0, [_RC], [[0, { [_hH]: _xarc }]]];
var PutObjectLegalHoldRequest = [
    3,
    n0,
    _POLHR,
    0,
    [_B, _K, _LH, _RP, _VI, _CMD, _CA, _EBO],
    [
        [0, 1],
        [0, 1],
        [() => ObjectLockLegalHold, { [_xN]: _LH, [_hP]: 1 }],
        [0, { [_hH]: _xarp }],
        [0, { [_hQ]: _vI }],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutObjectLockConfigurationOutput = [3, n0, _POLCO, 0, [_RC], [[0, { [_hH]: _xarc }]]];
var PutObjectLockConfigurationRequest = [
    3,
    n0,
    _POLCR,
    0,
    [_B, _OLC, _RP, _To, _CMD, _CA, _EBO],
    [
        [0, 1],
        [() => ObjectLockConfiguration, { [_xN]: _OLC, [_hP]: 1 }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xabolt }],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutObjectOutput = [
    3,
    n0,
    _POO,
    0,
    [
        _E,
        _ETa,
        _CCRC,
        _CCRCC,
        _CCRCNVME,
        _CSHA,
        _CSHAh,
        _CT,
        _SSE,
        _VI,
        _SSECA,
        _SSECKMD,
        _SSEKMSKI,
        _SSEKMSEC,
        _BKE,
        _Si,
        _RC,
    ],
    [
        [0, { [_hH]: _xae }],
        [0, { [_hH]: _ETa }],
        [0, { [_hH]: _xacc }],
        [0, { [_hH]: _xacc_ }],
        [0, { [_hH]: _xacc__ }],
        [0, { [_hH]: _xacs }],
        [0, { [_hH]: _xacs_ }],
        [0, { [_hH]: _xact }],
        [0, { [_hH]: _xasse }],
        [0, { [_hH]: _xavi }],
        [0, { [_hH]: _xasseca }],
        [0, { [_hH]: _xasseckM }],
        [() => SSEKMSKeyId, { [_hH]: _xasseakki }],
        [() => SSEKMSEncryptionContext, { [_hH]: _xassec }],
        [2, { [_hH]: _xassebke }],
        [1, { [_hH]: _xaos }],
        [0, { [_hH]: _xarc }],
    ],
];
var PutObjectRequest = [
    3,
    n0,
    _POR,
    0,
    [
        _ACL_,
        _Bo,
        _B,
        _CC,
        _CDo,
        _CEo,
        _CL,
        _CLo,
        _CMD,
        _CTo,
        _CA,
        _CCRC,
        _CCRCC,
        _CCRCNVME,
        _CSHA,
        _CSHAh,
        _Ex,
        _IM,
        _INM,
        _GFC,
        _GR,
        _GRACP,
        _GWACP,
        _K,
        _WOB,
        _M,
        _SSE,
        _SC,
        _WRL,
        _SSECA,
        _SSECK,
        _SSECKMD,
        _SSEKMSKI,
        _SSEKMSEC,
        _BKE,
        _RP,
        _Tag,
        _OLM,
        _OLRUD,
        _OLLHS,
        _EBO,
    ],
    [
        [0, { [_hH]: _xaa }],
        [() => StreamingBlob, 16],
        [0, 1],
        [0, { [_hH]: _CC_ }],
        [0, { [_hH]: _CD_ }],
        [0, { [_hH]: _CE_ }],
        [0, { [_hH]: _CL_ }],
        [1, { [_hH]: _CL__ }],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _CT_ }],
        [0, { [_hH]: _xasca }],
        [0, { [_hH]: _xacc }],
        [0, { [_hH]: _xacc_ }],
        [0, { [_hH]: _xacc__ }],
        [0, { [_hH]: _xacs }],
        [0, { [_hH]: _xacs_ }],
        [4, { [_hH]: _Ex }],
        [0, { [_hH]: _IM_ }],
        [0, { [_hH]: _INM_ }],
        [0, { [_hH]: _xagfc }],
        [0, { [_hH]: _xagr }],
        [0, { [_hH]: _xagra }],
        [0, { [_hH]: _xagwa }],
        [0, 1],
        [1, { [_hH]: _xawob }],
        [128 | 0, { [_hPH]: _xam }],
        [0, { [_hH]: _xasse }],
        [0, { [_hH]: _xasc }],
        [0, { [_hH]: _xawrl }],
        [0, { [_hH]: _xasseca }],
        [() => SSECustomerKey, { [_hH]: _xasseck }],
        [0, { [_hH]: _xasseckM }],
        [() => SSEKMSKeyId, { [_hH]: _xasseakki }],
        [() => SSEKMSEncryptionContext, { [_hH]: _xassec }],
        [2, { [_hH]: _xassebke }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xat }],
        [0, { [_hH]: _xaolm }],
        [5, { [_hH]: _xaolrud }],
        [0, { [_hH]: _xaollh }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutObjectRetentionOutput = [3, n0, _PORO, 0, [_RC], [[0, { [_hH]: _xarc }]]];
var PutObjectRetentionRequest = [
    3,
    n0,
    _PORR,
    0,
    [_B, _K, _Ret, _RP, _VI, _BGR, _CMD, _CA, _EBO],
    [
        [0, 1],
        [0, 1],
        [() => ObjectLockRetention, { [_xN]: _Ret, [_hP]: 1 }],
        [0, { [_hH]: _xarp }],
        [0, { [_hQ]: _vI }],
        [2, { [_hH]: _xabgr }],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [0, { [_hH]: _xaebo }],
    ],
];
var PutObjectTaggingOutput = [3, n0, _POTO, 0, [_VI], [[0, { [_hH]: _xavi }]]];
var PutObjectTaggingRequest = [
    3,
    n0,
    _POTR,
    0,
    [_B, _K, _VI, _CMD, _CA, _Tag, _EBO, _RP],
    [
        [0, 1],
        [0, 1],
        [0, { [_hQ]: _vI }],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [() => Tagging, { [_xN]: _Tag, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _xarp }],
    ],
];
var PutPublicAccessBlockRequest = [
    3,
    n0,
    _PPABR,
    0,
    [_B, _CMD, _CA, _PABC, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [() => PublicAccessBlockConfiguration, { [_xN]: _PABC, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
    ],
];
var QueueConfiguration = [
    3,
    n0,
    _QCue,
    0,
    [_I, _QA, _Ev, _F],
    [0, [0, { [_xN]: _Qu }], [64 | 0, { [_xN]: _Eve, [_xF]: 1 }], [() => NotificationConfigurationFilter, 0]],
];
var RecordExpiration = [3, n0, _REe, 0, [_E, _D], [0, 1]];
var RecordsEvent = [3, n0, _REec, 0, [_Payl], [[21, { [_eP]: 1 }]]];
var Redirect = [3, n0, _Red, 0, [_HN, _HRC, _Pro, _RKPW, _RKW], [0, 0, 0, 0, 0]];
var RedirectAllRequestsTo = [3, n0, _RART, 0, [_HN, _Pro], [0, 0]];
var RenameObjectOutput = [3, n0, _ROO, 0, [], []];
var RenameObjectRequest = [
    3,
    n0,
    _ROR,
    0,
    [_B, _K, _RSen, _DIM, _DINM, _DIMS, _DIUS, _SIM, _SINM, _SIMS, _SIUS, _CTl],
    [
        [0, 1],
        [0, 1],
        [0, { [_hH]: _xars_ }],
        [0, { [_hH]: _IM_ }],
        [0, { [_hH]: _INM_ }],
        [4, { [_hH]: _IMS_ }],
        [4, { [_hH]: _IUS_ }],
        [0, { [_hH]: _xarsim }],
        [0, { [_hH]: _xarsinm }],
        [6, { [_hH]: _xarsims }],
        [6, { [_hH]: _xarsius }],
        [0, { [_hH]: _xact_, [_iT]: 1 }],
    ],
];
var ReplicaModifications = [3, n0, _RM, 0, [_S], [0]];
var ReplicationConfiguration = [
    3,
    n0,
    _RCe,
    0,
    [_Ro, _R],
    [0, [() => ReplicationRules, { [_xN]: _Ru, [_xF]: 1 }]],
];
var ReplicationRule = [
    3,
    n0,
    _RRe,
    0,
    [_ID, _Pri, _P, _F, _S, _SSC, _EOR, _Des, _DMR],
    [
        0,
        1,
        0,
        [() => ReplicationRuleFilter, 0],
        0,
        () => SourceSelectionCriteria,
        () => ExistingObjectReplication,
        () => Destination,
        () => DeleteMarkerReplication,
    ],
];
var ReplicationRuleAndOperator = [
    3,
    n0,
    _RRAO,
    0,
    [_P, _T],
    [0, [() => TagSet, { [_xN]: _Ta, [_xF]: 1 }]],
];
var ReplicationRuleFilter = [
    3,
    n0,
    _RRF,
    0,
    [_P, _Ta, _An],
    [0, () => Tag, [() => ReplicationRuleAndOperator, 0]],
];
var ReplicationTime = [3, n0, _RT, 0, [_S, _Tim], [0, () => ReplicationTimeValue]];
var ReplicationTimeValue = [3, n0, _RTV, 0, [_Mi], [1]];
var RequestPaymentConfiguration = [3, n0, _RPC, 0, [_Pay], [0]];
var RequestProgress = [3, n0, _RPe, 0, [_Ena], [2]];
var RestoreObjectOutput = [
    3,
    n0,
    _ROOe,
    0,
    [_RC, _ROP],
    [
        [0, { [_hH]: _xarc }],
        [0, { [_hH]: _xarop }],
    ],
];
var RestoreObjectRequest = [
    3,
    n0,
    _RORe,
    0,
    [_B, _K, _VI, _RRes, _RP, _CA, _EBO],
    [
        [0, 1],
        [0, 1],
        [0, { [_hQ]: _vI }],
        [() => RestoreRequest, { [_hP]: 1, [_xN]: _RRes }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xasca }],
        [0, { [_hH]: _xaebo }],
    ],
];
var RestoreRequest = [
    3,
    n0,
    _RRes,
    0,
    [_D, _GJP, _Ty, _Ti, _Desc, _SP, _OL],
    [1, () => GlacierJobParameters, 0, 0, 0, () => SelectParameters, [() => OutputLocation, 0]],
];
var RestoreStatus = [3, n0, _RSe, 0, [_IRIP, _RED], [2, 4]];
var RoutingRule = [3, n0, _RRo, 0, [_Co, _Red], [() => Condition, () => Redirect]];
var S3KeyFilter = [
    3,
    n0,
    _SKF,
    0,
    [_FRi],
    [[() => FilterRuleList, { [_xN]: _FR, [_xF]: 1 }]],
];
var S3Location = [
    3,
    n0,
    _SL,
    0,
    [_BN, _P, _En, _CACL, _ACL, _Tag, _UM, _SC],
    [0, 0, [() => Encryption, 0], 0, [() => Grants, 0], [() => Tagging, 0], [() => UserMetadata, 0], 0],
];
var S3TablesDestination = [3, n0, _STD, 0, [_TBA, _TNa], [0, 0]];
var S3TablesDestinationResult = [3, n0, _STDR, 0, [_TBA, _TNa, _TA, _TN], [0, 0, 0, 0]];
var ScanRange = [3, n0, _SR, 0, [_St, _End], [1, 1]];
var SelectObjectContentOutput = [
    3,
    n0,
    _SOCO,
    0,
    [_Payl],
    [[() => SelectObjectContentEventStream, 16]],
];
var SelectObjectContentRequest = [
    3,
    n0,
    _SOCR,
    0,
    [_B, _K, _SSECA, _SSECK, _SSECKMD, _Exp, _ETx, _RPe, _IS, _OSu, _SR, _EBO],
    [
        [0, 1],
        [0, 1],
        [0, { [_hH]: _xasseca }],
        [() => SSECustomerKey, { [_hH]: _xasseck }],
        [0, { [_hH]: _xasseckM }],
        0,
        0,
        () => RequestProgress,
        () => InputSerialization,
        () => OutputSerialization,
        () => ScanRange,
        [0, { [_hH]: _xaebo }],
    ],
];
var SelectParameters = [
    3,
    n0,
    _SP,
    0,
    [_IS, _ETx, _Exp, _OSu],
    [() => InputSerialization, 0, 0, () => OutputSerialization],
];
var ServerSideEncryptionByDefault = [
    3,
    n0,
    _SSEBD,
    0,
    [_SSEA, _KMSMKID],
    [0, [() => SSEKMSKeyId, 0]],
];
var ServerSideEncryptionConfiguration = [
    3,
    n0,
    _SSEC,
    0,
    [_R],
    [[() => ServerSideEncryptionRules, { [_xN]: _Ru, [_xF]: 1 }]],
];
var ServerSideEncryptionRule = [
    3,
    n0,
    _SSER,
    0,
    [_ASSEBD, _BKE, _BET],
    [[() => ServerSideEncryptionByDefault, 0], 2, [() => BlockedEncryptionTypes, 0]],
];
var SessionCredentials = [
    3,
    n0,
    _SCe,
    0,
    [_AKI, _SAK, _ST, _E],
    [
        [0, { [_xN]: _AKI }],
        [() => SessionCredentialValue, { [_xN]: _SAK }],
        [() => SessionCredentialValue, { [_xN]: _ST }],
        [4, { [_xN]: _E }],
    ],
];
var SimplePrefix = [3, n0, _SPi, { [_xN]: _SPi }, [], []];
var SourceSelectionCriteria = [
    3,
    n0,
    _SSC,
    0,
    [_SKEO, _RM],
    [() => SseKmsEncryptedObjects, () => ReplicaModifications],
];
var SSEKMS = [3, n0, _SSEKMS, { [_xN]: _SK }, [_KI], [[() => SSEKMSKeyId, 0]]];
var SseKmsEncryptedObjects = [3, n0, _SKEO, 0, [_S], [0]];
var SSES3 = [3, n0, _SSES, { [_xN]: _SS }, [], []];
var Stats = [3, n0, _Sta, 0, [_BS, _BP, _BRy], [1, 1, 1]];
var StatsEvent = [3, n0, _SE, 0, [_Det], [[() => Stats, { [_eP]: 1 }]]];
var StorageClassAnalysis = [
    3,
    n0,
    _SCA,
    0,
    [_DE],
    [() => StorageClassAnalysisDataExport],
];
var StorageClassAnalysisDataExport = [
    3,
    n0,
    _SCADE,
    0,
    [_OSV, _Des],
    [0, () => AnalyticsExportDestination],
];
var Tag = [3, n0, _Ta, 0, [_K, _V], [0, 0]];
var Tagging = [3, n0, _Tag, 0, [_TS], [[() => TagSet, 0]]];
var TargetGrant = [
    3,
    n0,
    _TGa,
    0,
    [_Gra, _Pe],
    [[() => Grantee, { [_xNm]: [_x, _hi] }], 0],
];
var TargetObjectKeyFormat = [
    3,
    n0,
    _TOKF,
    0,
    [_SPi, _PP],
    [
        [() => SimplePrefix, { [_xN]: _SPi }],
        [() => PartitionedPrefix, { [_xN]: _PP }],
    ],
];
var Tiering = [3, n0, _Tier, 0, [_D, _AT], [1, 0]];
var TooManyParts = [-3, n0, _TMP, { [_e]: _c, [_hE]: 400 }, [], []];
schema.TypeRegistry.for(n0).registerError(TooManyParts, TooManyParts$1);
var TopicConfiguration = [
    3,
    n0,
    _TCop,
    0,
    [_I, _TAo, _Ev, _F],
    [0, [0, { [_xN]: _Top }], [64 | 0, { [_xN]: _Eve, [_xF]: 1 }], [() => NotificationConfigurationFilter, 0]],
];
var Transition = [3, n0, _Tra, 0, [_Da, _D, _SC], [5, 1, 0]];
var UpdateBucketMetadataInventoryTableConfigurationRequest = [
    3,
    n0,
    _UBMITCR,
    0,
    [_B, _CMD, _CA, _ITCn, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [() => InventoryTableConfigurationUpdates, { [_xN]: _ITCn, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
    ],
];
var UpdateBucketMetadataJournalTableConfigurationRequest = [
    3,
    n0,
    _UBMJTCR,
    0,
    [_B, _CMD, _CA, _JTC, _EBO],
    [
        [0, 1],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [() => JournalTableConfigurationUpdates, { [_xN]: _JTC, [_hP]: 1 }],
        [0, { [_hH]: _xaebo }],
    ],
];
var UploadPartCopyOutput = [
    3,
    n0,
    _UPCO,
    0,
    [_CSVI, _CPR, _SSE, _SSECA, _SSECKMD, _SSEKMSKI, _BKE, _RC],
    [
        [0, { [_hH]: _xacsvi }],
        [() => CopyPartResult, 16],
        [0, { [_hH]: _xasse }],
        [0, { [_hH]: _xasseca }],
        [0, { [_hH]: _xasseckM }],
        [() => SSEKMSKeyId, { [_hH]: _xasseakki }],
        [2, { [_hH]: _xassebke }],
        [0, { [_hH]: _xarc }],
    ],
];
var UploadPartCopyRequest = [
    3,
    n0,
    _UPCR,
    0,
    [
        _B,
        _CS,
        _CSIM,
        _CSIMS,
        _CSINM,
        _CSIUS,
        _CSRo,
        _K,
        _PN,
        _UI,
        _SSECA,
        _SSECK,
        _SSECKMD,
        _CSSSECA,
        _CSSSECK,
        _CSSSECKMD,
        _RP,
        _EBO,
        _ESBO,
    ],
    [
        [0, 1],
        [0, { [_hH]: _xacs__ }],
        [0, { [_hH]: _xacsim }],
        [4, { [_hH]: _xacsims }],
        [0, { [_hH]: _xacsinm }],
        [4, { [_hH]: _xacsius }],
        [0, { [_hH]: _xacsr }],
        [0, 1],
        [1, { [_hQ]: _pN }],
        [0, { [_hQ]: _uI }],
        [0, { [_hH]: _xasseca }],
        [() => SSECustomerKey, { [_hH]: _xasseck }],
        [0, { [_hH]: _xasseckM }],
        [0, { [_hH]: _xacssseca }],
        [() => CopySourceSSECustomerKey, { [_hH]: _xacssseck }],
        [0, { [_hH]: _xacssseckM }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xaebo }],
        [0, { [_hH]: _xasebo }],
    ],
];
var UploadPartOutput = [
    3,
    n0,
    _UPO,
    0,
    [_SSE, _ETa, _CCRC, _CCRCC, _CCRCNVME, _CSHA, _CSHAh, _SSECA, _SSECKMD, _SSEKMSKI, _BKE, _RC],
    [
        [0, { [_hH]: _xasse }],
        [0, { [_hH]: _ETa }],
        [0, { [_hH]: _xacc }],
        [0, { [_hH]: _xacc_ }],
        [0, { [_hH]: _xacc__ }],
        [0, { [_hH]: _xacs }],
        [0, { [_hH]: _xacs_ }],
        [0, { [_hH]: _xasseca }],
        [0, { [_hH]: _xasseckM }],
        [() => SSEKMSKeyId, { [_hH]: _xasseakki }],
        [2, { [_hH]: _xassebke }],
        [0, { [_hH]: _xarc }],
    ],
];
var UploadPartRequest = [
    3,
    n0,
    _UPR,
    0,
    [
        _Bo,
        _B,
        _CLo,
        _CMD,
        _CA,
        _CCRC,
        _CCRCC,
        _CCRCNVME,
        _CSHA,
        _CSHAh,
        _K,
        _PN,
        _UI,
        _SSECA,
        _SSECK,
        _SSECKMD,
        _RP,
        _EBO,
    ],
    [
        [() => StreamingBlob, 16],
        [0, 1],
        [1, { [_hH]: _CL__ }],
        [0, { [_hH]: _CM }],
        [0, { [_hH]: _xasca }],
        [0, { [_hH]: _xacc }],
        [0, { [_hH]: _xacc_ }],
        [0, { [_hH]: _xacc__ }],
        [0, { [_hH]: _xacs }],
        [0, { [_hH]: _xacs_ }],
        [0, 1],
        [1, { [_hQ]: _pN }],
        [0, { [_hQ]: _uI }],
        [0, { [_hH]: _xasseca }],
        [() => SSECustomerKey, { [_hH]: _xasseck }],
        [0, { [_hH]: _xasseckM }],
        [0, { [_hH]: _xarp }],
        [0, { [_hH]: _xaebo }],
    ],
];
var VersioningConfiguration = [3, n0, _VC, 0, [_MFAD, _S], [[0, { [_xN]: _MDf }], 0]];
var WebsiteConfiguration = [
    3,
    n0,
    _WC,
    0,
    [_EDr, _IDn, _RART, _RR],
    [() => ErrorDocument, () => IndexDocument, () => RedirectAllRequestsTo, [() => RoutingRules, 0]],
];
var WriteGetObjectResponseRequest = [
    3,
    n0,
    _WGORR,
    0,
    [
        _RReq,
        _RTe,
        _Bo,
        _SCt,
        _ECr,
        _EM,
        _AR,
        _CC,
        _CDo,
        _CEo,
        _CL,
        _CLo,
        _CR,
        _CTo,
        _CCRC,
        _CCRCC,
        _CCRCNVME,
        _CSHA,
        _CSHAh,
        _DM,
        _ETa,
        _Ex,
        _E,
        _LM,
        _MM,
        _M,
        _OLM,
        _OLLHS,
        _OLRUD,
        _PC,
        _RS,
        _RC,
        _Re,
        _SSE,
        _SSECA,
        _SSEKMSKI,
        _SSECKMD,
        _SC,
        _TC,
        _VI,
        _BKE,
    ],
    [
        [0, { [_hL]: 1, [_hH]: _xarr }],
        [0, { [_hH]: _xart }],
        [() => StreamingBlob, 16],
        [1, { [_hH]: _xafs }],
        [0, { [_hH]: _xafec }],
        [0, { [_hH]: _xafem }],
        [0, { [_hH]: _xafhar }],
        [0, { [_hH]: _xafhCC }],
        [0, { [_hH]: _xafhCD }],
        [0, { [_hH]: _xafhCE }],
        [0, { [_hH]: _xafhCL }],
        [1, { [_hH]: _CL__ }],
        [0, { [_hH]: _xafhCR }],
        [0, { [_hH]: _xafhCT }],
        [0, { [_hH]: _xafhxacc }],
        [0, { [_hH]: _xafhxacc_ }],
        [0, { [_hH]: _xafhxacc__ }],
        [0, { [_hH]: _xafhxacs }],
        [0, { [_hH]: _xafhxacs_ }],
        [2, { [_hH]: _xafhxadm }],
        [0, { [_hH]: _xafhE }],
        [4, { [_hH]: _xafhE_ }],
        [0, { [_hH]: _xafhxae }],
        [4, { [_hH]: _xafhLM }],
        [1, { [_hH]: _xafhxamm }],
        [128 | 0, { [_hPH]: _xam }],
        [0, { [_hH]: _xafhxaolm }],
        [0, { [_hH]: _xafhxaollh }],
        [5, { [_hH]: _xafhxaolrud }],
        [1, { [_hH]: _xafhxampc }],
        [0, { [_hH]: _xafhxars }],
        [0, { [_hH]: _xafhxarc }],
        [0, { [_hH]: _xafhxar }],
        [0, { [_hH]: _xafhxasse }],
        [0, { [_hH]: _xafhxasseca }],
        [() => SSEKMSKeyId, { [_hH]: _xafhxasseakki }],
        [0, { [_hH]: _xafhxasseckM }],
        [0, { [_hH]: _xafhxasc }],
        [1, { [_hH]: _xafhxatc }],
        [0, { [_hH]: _xafhxavi }],
        [2, { [_hH]: _xafhxassebke }],
    ],
];
var __Unit = "unit";
var S3ServiceException = [-3, _sm, "S3ServiceException", 0, [], []];
schema.TypeRegistry.for(_sm).registerError(S3ServiceException, S3ServiceException$1);
var AnalyticsConfigurationList = [1, n0, _ACLn, 0, [() => AnalyticsConfiguration, 0]];
var Buckets = [1, n0, _Bu, 0, [() => Bucket, { [_xN]: _B }]];
var CommonPrefixList = [1, n0, _CPL, 0, () => CommonPrefix];
var CompletedPartList = [1, n0, _CPLo, 0, () => CompletedPart];
var CORSRules = [1, n0, _CORSR, 0, [() => CORSRule, 0]];
var DeletedObjects = [1, n0, _DOe, 0, () => DeletedObject];
var DeleteMarkers = [1, n0, _DMe, 0, () => DeleteMarkerEntry];
var EncryptionTypeList = [1, n0, _ETL, 0, [0, { [_xN]: _ET }]];
var Errors = [1, n0, _Er, 0, () => _Error];
var FilterRuleList = [1, n0, _FRL, 0, () => FilterRule];
var Grants = [1, n0, _G, 0, [() => Grant, { [_xN]: _Gr }]];
var IntelligentTieringConfigurationList = [
    1,
    n0,
    _ITCL,
    0,
    [() => IntelligentTieringConfiguration, 0],
];
var InventoryConfigurationList = [1, n0, _ICL, 0, [() => InventoryConfiguration, 0]];
var InventoryOptionalFields = [1, n0, _IOF, 0, [0, { [_xN]: _Fi }]];
var LambdaFunctionConfigurationList = [
    1,
    n0,
    _LFCL,
    0,
    [() => LambdaFunctionConfiguration, 0],
];
var LifecycleRules = [1, n0, _LRi, 0, [() => LifecycleRule, 0]];
var MetricsConfigurationList = [1, n0, _MCL, 0, [() => MetricsConfiguration, 0]];
var MultipartUploadList = [1, n0, _MUL, 0, () => MultipartUpload];
var NoncurrentVersionTransitionList = [1, n0, _NVTL, 0, () => NoncurrentVersionTransition];
var ObjectIdentifierList = [1, n0, _OIL, 0, () => ObjectIdentifier];
var ObjectList = [1, n0, _OLb, 0, [() => _Object, 0]];
var ObjectVersionList = [1, n0, _OVL, 0, [() => ObjectVersion, 0]];
var OwnershipControlsRules = [1, n0, _OCRw, 0, () => OwnershipControlsRule];
var Parts = [1, n0, _Pa, 0, () => Part];
var PartsList = [1, n0, _PL, 0, () => ObjectPart];
var QueueConfigurationList = [1, n0, _QCL, 0, [() => QueueConfiguration, 0]];
var ReplicationRules = [1, n0, _RRep, 0, [() => ReplicationRule, 0]];
var RoutingRules = [1, n0, _RR, 0, [() => RoutingRule, { [_xN]: _RRo }]];
var ServerSideEncryptionRules = [1, n0, _SSERe, 0, [() => ServerSideEncryptionRule, 0]];
var TagSet = [1, n0, _TS, 0, [() => Tag, { [_xN]: _Ta }]];
var TargetGrants = [1, n0, _TG, 0, [() => TargetGrant, { [_xN]: _Gr }]];
var TieringList = [1, n0, _TL, 0, () => Tiering];
var TopicConfigurationList = [1, n0, _TCL, 0, [() => TopicConfiguration, 0]];
var TransitionList = [1, n0, _TLr, 0, () => Transition];
var UserMetadata = [1, n0, _UM, 0, [() => MetadataEntry, { [_xN]: _ME }]];
var AnalyticsFilter = [
    3,
    n0,
    _AF,
    0,
    [_P, _Ta, _An],
    [0, () => Tag, [() => AnalyticsAndOperator, 0]],
];
var MetricsFilter = [
    3,
    n0,
    _MF,
    0,
    [_P, _Ta, _APAc, _An],
    [0, () => Tag, 0, [() => MetricsAndOperator, 0]],
];
var SelectObjectContentEventStream = [
    3,
    n0,
    _SOCES,
    { [_s]: 1 },
    [_Rec, _Sta, _Pr, _Cont, _End],
    [[() => RecordsEvent, 0], [() => StatsEvent, 0], [() => ProgressEvent, 0], () => ContinuationEvent, () => EndEvent],
];
var AbortMultipartUpload = [
    9,
    n0,
    _AMU,
    { [_h]: ["DELETE", "/{Key+}?x-id=AbortMultipartUpload", 204] },
    () => AbortMultipartUploadRequest,
    () => AbortMultipartUploadOutput,
];
var CompleteMultipartUpload = [
    9,
    n0,
    _CMUo,
    { [_h]: ["POST", "/{Key+}", 200] },
    () => CompleteMultipartUploadRequest,
    () => CompleteMultipartUploadOutput,
];
var CopyObject = [
    9,
    n0,
    _CO,
    { [_h]: ["PUT", "/{Key+}?x-id=CopyObject", 200] },
    () => CopyObjectRequest,
    () => CopyObjectOutput,
];
var CreateBucket = [
    9,
    n0,
    _CB,
    { [_h]: ["PUT", "/", 200] },
    () => CreateBucketRequest,
    () => CreateBucketOutput,
];
var CreateBucketMetadataConfiguration = [
    9,
    n0,
    _CBMC,
    { [_h]: ["POST", "/?metadataConfiguration", 200] },
    () => CreateBucketMetadataConfigurationRequest,
    () => __Unit,
];
var CreateBucketMetadataTableConfiguration = [
    9,
    n0,
    _CBMTC,
    { [_h]: ["POST", "/?metadataTable", 200] },
    () => CreateBucketMetadataTableConfigurationRequest,
    () => __Unit,
];
var CreateMultipartUpload = [
    9,
    n0,
    _CMUr,
    { [_h]: ["POST", "/{Key+}?uploads", 200] },
    () => CreateMultipartUploadRequest,
    () => CreateMultipartUploadOutput,
];
var CreateSession = [
    9,
    n0,
    _CSr,
    { [_h]: ["GET", "/?session", 200] },
    () => CreateSessionRequest,
    () => CreateSessionOutput,
];
var DeleteBucket = [
    9,
    n0,
    _DB,
    { [_h]: ["DELETE", "/", 204] },
    () => DeleteBucketRequest,
    () => __Unit,
];
var DeleteBucketAnalyticsConfiguration = [
    9,
    n0,
    _DBAC,
    { [_h]: ["DELETE", "/?analytics", 204] },
    () => DeleteBucketAnalyticsConfigurationRequest,
    () => __Unit,
];
var DeleteBucketCors = [
    9,
    n0,
    _DBC,
    { [_h]: ["DELETE", "/?cors", 204] },
    () => DeleteBucketCorsRequest,
    () => __Unit,
];
var DeleteBucketEncryption = [
    9,
    n0,
    _DBE,
    { [_h]: ["DELETE", "/?encryption", 204] },
    () => DeleteBucketEncryptionRequest,
    () => __Unit,
];
var DeleteBucketIntelligentTieringConfiguration = [
    9,
    n0,
    _DBITC,
    { [_h]: ["DELETE", "/?intelligent-tiering", 204] },
    () => DeleteBucketIntelligentTieringConfigurationRequest,
    () => __Unit,
];
var DeleteBucketInventoryConfiguration = [
    9,
    n0,
    _DBIC,
    { [_h]: ["DELETE", "/?inventory", 204] },
    () => DeleteBucketInventoryConfigurationRequest,
    () => __Unit,
];
var DeleteBucketLifecycle = [
    9,
    n0,
    _DBL,
    { [_h]: ["DELETE", "/?lifecycle", 204] },
    () => DeleteBucketLifecycleRequest,
    () => __Unit,
];
var DeleteBucketMetadataConfiguration = [
    9,
    n0,
    _DBMC,
    { [_h]: ["DELETE", "/?metadataConfiguration", 204] },
    () => DeleteBucketMetadataConfigurationRequest,
    () => __Unit,
];
var DeleteBucketMetadataTableConfiguration = [
    9,
    n0,
    _DBMTC,
    { [_h]: ["DELETE", "/?metadataTable", 204] },
    () => DeleteBucketMetadataTableConfigurationRequest,
    () => __Unit,
];
var DeleteBucketMetricsConfiguration = [
    9,
    n0,
    _DBMCe,
    { [_h]: ["DELETE", "/?metrics", 204] },
    () => DeleteBucketMetricsConfigurationRequest,
    () => __Unit,
];
var DeleteBucketOwnershipControls = [
    9,
    n0,
    _DBOC,
    { [_h]: ["DELETE", "/?ownershipControls", 204] },
    () => DeleteBucketOwnershipControlsRequest,
    () => __Unit,
];
var DeleteBucketPolicy = [
    9,
    n0,
    _DBP,
    { [_h]: ["DELETE", "/?policy", 204] },
    () => DeleteBucketPolicyRequest,
    () => __Unit,
];
var DeleteBucketReplication = [
    9,
    n0,
    _DBRe,
    { [_h]: ["DELETE", "/?replication", 204] },
    () => DeleteBucketReplicationRequest,
    () => __Unit,
];
var DeleteBucketTagging = [
    9,
    n0,
    _DBT,
    { [_h]: ["DELETE", "/?tagging", 204] },
    () => DeleteBucketTaggingRequest,
    () => __Unit,
];
var DeleteBucketWebsite = [
    9,
    n0,
    _DBW,
    { [_h]: ["DELETE", "/?website", 204] },
    () => DeleteBucketWebsiteRequest,
    () => __Unit,
];
var DeleteObject = [
    9,
    n0,
    _DOel,
    { [_h]: ["DELETE", "/{Key+}?x-id=DeleteObject", 204] },
    () => DeleteObjectRequest,
    () => DeleteObjectOutput,
];
var DeleteObjects = [
    9,
    n0,
    _DOele,
    { [_h]: ["POST", "/?delete", 200] },
    () => DeleteObjectsRequest,
    () => DeleteObjectsOutput,
];
var DeleteObjectTagging = [
    9,
    n0,
    _DOT,
    { [_h]: ["DELETE", "/{Key+}?tagging", 204] },
    () => DeleteObjectTaggingRequest,
    () => DeleteObjectTaggingOutput,
];
var DeletePublicAccessBlock = [
    9,
    n0,
    _DPAB,
    { [_h]: ["DELETE", "/?publicAccessBlock", 204] },
    () => DeletePublicAccessBlockRequest,
    () => __Unit,
];
var GetBucketAbac = [
    9,
    n0,
    _GBA,
    { [_h]: ["GET", "/?abac", 200] },
    () => GetBucketAbacRequest,
    () => GetBucketAbacOutput,
];
var GetBucketAccelerateConfiguration = [
    9,
    n0,
    _GBAC,
    { [_h]: ["GET", "/?accelerate", 200] },
    () => GetBucketAccelerateConfigurationRequest,
    () => GetBucketAccelerateConfigurationOutput,
];
var GetBucketAcl = [
    9,
    n0,
    _GBAe,
    { [_h]: ["GET", "/?acl", 200] },
    () => GetBucketAclRequest,
    () => GetBucketAclOutput,
];
var GetBucketAnalyticsConfiguration = [
    9,
    n0,
    _GBACe,
    { [_h]: ["GET", "/?analytics&x-id=GetBucketAnalyticsConfiguration", 200] },
    () => GetBucketAnalyticsConfigurationRequest,
    () => GetBucketAnalyticsConfigurationOutput,
];
var GetBucketCors = [
    9,
    n0,
    _GBC,
    { [_h]: ["GET", "/?cors", 200] },
    () => GetBucketCorsRequest,
    () => GetBucketCorsOutput,
];
var GetBucketEncryption = [
    9,
    n0,
    _GBE,
    { [_h]: ["GET", "/?encryption", 200] },
    () => GetBucketEncryptionRequest,
    () => GetBucketEncryptionOutput,
];
var GetBucketIntelligentTieringConfiguration = [
    9,
    n0,
    _GBITC,
    { [_h]: ["GET", "/?intelligent-tiering&x-id=GetBucketIntelligentTieringConfiguration", 200] },
    () => GetBucketIntelligentTieringConfigurationRequest,
    () => GetBucketIntelligentTieringConfigurationOutput,
];
var GetBucketInventoryConfiguration = [
    9,
    n0,
    _GBIC,
    { [_h]: ["GET", "/?inventory&x-id=GetBucketInventoryConfiguration", 200] },
    () => GetBucketInventoryConfigurationRequest,
    () => GetBucketInventoryConfigurationOutput,
];
var GetBucketLifecycleConfiguration = [
    9,
    n0,
    _GBLC,
    { [_h]: ["GET", "/?lifecycle", 200] },
    () => GetBucketLifecycleConfigurationRequest,
    () => GetBucketLifecycleConfigurationOutput,
];
var GetBucketLocation = [
    9,
    n0,
    _GBL,
    { [_h]: ["GET", "/?location", 200] },
    () => GetBucketLocationRequest,
    () => GetBucketLocationOutput,
];
var GetBucketLogging = [
    9,
    n0,
    _GBLe,
    { [_h]: ["GET", "/?logging", 200] },
    () => GetBucketLoggingRequest,
    () => GetBucketLoggingOutput,
];
var GetBucketMetadataConfiguration = [
    9,
    n0,
    _GBMC,
    { [_h]: ["GET", "/?metadataConfiguration", 200] },
    () => GetBucketMetadataConfigurationRequest,
    () => GetBucketMetadataConfigurationOutput,
];
var GetBucketMetadataTableConfiguration = [
    9,
    n0,
    _GBMTC,
    { [_h]: ["GET", "/?metadataTable", 200] },
    () => GetBucketMetadataTableConfigurationRequest,
    () => GetBucketMetadataTableConfigurationOutput,
];
var GetBucketMetricsConfiguration = [
    9,
    n0,
    _GBMCe,
    { [_h]: ["GET", "/?metrics&x-id=GetBucketMetricsConfiguration", 200] },
    () => GetBucketMetricsConfigurationRequest,
    () => GetBucketMetricsConfigurationOutput,
];
var GetBucketNotificationConfiguration = [
    9,
    n0,
    _GBNC,
    { [_h]: ["GET", "/?notification", 200] },
    () => GetBucketNotificationConfigurationRequest,
    () => NotificationConfiguration,
];
var GetBucketOwnershipControls = [
    9,
    n0,
    _GBOC,
    { [_h]: ["GET", "/?ownershipControls", 200] },
    () => GetBucketOwnershipControlsRequest,
    () => GetBucketOwnershipControlsOutput,
];
var GetBucketPolicy = [
    9,
    n0,
    _GBP,
    { [_h]: ["GET", "/?policy", 200] },
    () => GetBucketPolicyRequest,
    () => GetBucketPolicyOutput,
];
var GetBucketPolicyStatus = [
    9,
    n0,
    _GBPS,
    { [_h]: ["GET", "/?policyStatus", 200] },
    () => GetBucketPolicyStatusRequest,
    () => GetBucketPolicyStatusOutput,
];
var GetBucketReplication = [
    9,
    n0,
    _GBR,
    { [_h]: ["GET", "/?replication", 200] },
    () => GetBucketReplicationRequest,
    () => GetBucketReplicationOutput,
];
var GetBucketRequestPayment = [
    9,
    n0,
    _GBRP,
    { [_h]: ["GET", "/?requestPayment", 200] },
    () => GetBucketRequestPaymentRequest,
    () => GetBucketRequestPaymentOutput,
];
var GetBucketTagging = [
    9,
    n0,
    _GBT,
    { [_h]: ["GET", "/?tagging", 200] },
    () => GetBucketTaggingRequest,
    () => GetBucketTaggingOutput,
];
var GetBucketVersioning = [
    9,
    n0,
    _GBV,
    { [_h]: ["GET", "/?versioning", 200] },
    () => GetBucketVersioningRequest,
    () => GetBucketVersioningOutput,
];
var GetBucketWebsite = [
    9,
    n0,
    _GBW,
    { [_h]: ["GET", "/?website", 200] },
    () => GetBucketWebsiteRequest,
    () => GetBucketWebsiteOutput,
];
var GetObject = [
    9,
    n0,
    _GO,
    { [_h]: ["GET", "/{Key+}?x-id=GetObject", 200] },
    () => GetObjectRequest,
    () => GetObjectOutput,
];
var GetObjectAcl = [
    9,
    n0,
    _GOA,
    { [_h]: ["GET", "/{Key+}?acl", 200] },
    () => GetObjectAclRequest,
    () => GetObjectAclOutput,
];
var GetObjectAttributes = [
    9,
    n0,
    _GOAe,
    { [_h]: ["GET", "/{Key+}?attributes", 200] },
    () => GetObjectAttributesRequest,
    () => GetObjectAttributesOutput,
];
var GetObjectLegalHold = [
    9,
    n0,
    _GOLH,
    { [_h]: ["GET", "/{Key+}?legal-hold", 200] },
    () => GetObjectLegalHoldRequest,
    () => GetObjectLegalHoldOutput,
];
var GetObjectLockConfiguration = [
    9,
    n0,
    _GOLC,
    { [_h]: ["GET", "/?object-lock", 200] },
    () => GetObjectLockConfigurationRequest,
    () => GetObjectLockConfigurationOutput,
];
var GetObjectRetention = [
    9,
    n0,
    _GORe,
    { [_h]: ["GET", "/{Key+}?retention", 200] },
    () => GetObjectRetentionRequest,
    () => GetObjectRetentionOutput,
];
var GetObjectTagging = [
    9,
    n0,
    _GOT,
    { [_h]: ["GET", "/{Key+}?tagging", 200] },
    () => GetObjectTaggingRequest,
    () => GetObjectTaggingOutput,
];
var GetObjectTorrent = [
    9,
    n0,
    _GOTe,
    { [_h]: ["GET", "/{Key+}?torrent", 200] },
    () => GetObjectTorrentRequest,
    () => GetObjectTorrentOutput,
];
var GetPublicAccessBlock = [
    9,
    n0,
    _GPAB,
    { [_h]: ["GET", "/?publicAccessBlock", 200] },
    () => GetPublicAccessBlockRequest,
    () => GetPublicAccessBlockOutput,
];
var HeadBucket = [
    9,
    n0,
    _HB,
    { [_h]: ["HEAD", "/", 200] },
    () => HeadBucketRequest,
    () => HeadBucketOutput,
];
var HeadObject = [
    9,
    n0,
    _HO,
    { [_h]: ["HEAD", "/{Key+}", 200] },
    () => HeadObjectRequest,
    () => HeadObjectOutput,
];
var ListBucketAnalyticsConfigurations = [
    9,
    n0,
    _LBAC,
    { [_h]: ["GET", "/?analytics&x-id=ListBucketAnalyticsConfigurations", 200] },
    () => ListBucketAnalyticsConfigurationsRequest,
    () => ListBucketAnalyticsConfigurationsOutput,
];
var ListBucketIntelligentTieringConfigurations = [
    9,
    n0,
    _LBITC,
    { [_h]: ["GET", "/?intelligent-tiering&x-id=ListBucketIntelligentTieringConfigurations", 200] },
    () => ListBucketIntelligentTieringConfigurationsRequest,
    () => ListBucketIntelligentTieringConfigurationsOutput,
];
var ListBucketInventoryConfigurations = [
    9,
    n0,
    _LBIC,
    { [_h]: ["GET", "/?inventory&x-id=ListBucketInventoryConfigurations", 200] },
    () => ListBucketInventoryConfigurationsRequest,
    () => ListBucketInventoryConfigurationsOutput,
];
var ListBucketMetricsConfigurations = [
    9,
    n0,
    _LBMC,
    { [_h]: ["GET", "/?metrics&x-id=ListBucketMetricsConfigurations", 200] },
    () => ListBucketMetricsConfigurationsRequest,
    () => ListBucketMetricsConfigurationsOutput,
];
var ListBuckets = [
    9,
    n0,
    _LB,
    { [_h]: ["GET", "/?x-id=ListBuckets", 200] },
    () => ListBucketsRequest,
    () => ListBucketsOutput,
];
var ListDirectoryBuckets = [
    9,
    n0,
    _LDB,
    { [_h]: ["GET", "/?x-id=ListDirectoryBuckets", 200] },
    () => ListDirectoryBucketsRequest,
    () => ListDirectoryBucketsOutput,
];
var ListMultipartUploads = [
    9,
    n0,
    _LMU,
    { [_h]: ["GET", "/?uploads", 200] },
    () => ListMultipartUploadsRequest,
    () => ListMultipartUploadsOutput,
];
var ListObjects = [
    9,
    n0,
    _LO,
    { [_h]: ["GET", "/", 200] },
    () => ListObjectsRequest,
    () => ListObjectsOutput,
];
var ListObjectsV2 = [
    9,
    n0,
    _LOV,
    { [_h]: ["GET", "/?list-type=2", 200] },
    () => ListObjectsV2Request,
    () => ListObjectsV2Output,
];
var ListObjectVersions = [
    9,
    n0,
    _LOVi,
    { [_h]: ["GET", "/?versions", 200] },
    () => ListObjectVersionsRequest,
    () => ListObjectVersionsOutput,
];
var ListParts = [
    9,
    n0,
    _LP,
    { [_h]: ["GET", "/{Key+}?x-id=ListParts", 200] },
    () => ListPartsRequest,
    () => ListPartsOutput,
];
var PutBucketAbac = [
    9,
    n0,
    _PBA,
    { [_h]: ["PUT", "/?abac", 200] },
    () => PutBucketAbacRequest,
    () => __Unit,
];
var PutBucketAccelerateConfiguration = [
    9,
    n0,
    _PBAC,
    { [_h]: ["PUT", "/?accelerate", 200] },
    () => PutBucketAccelerateConfigurationRequest,
    () => __Unit,
];
var PutBucketAcl = [
    9,
    n0,
    _PBAu,
    { [_h]: ["PUT", "/?acl", 200] },
    () => PutBucketAclRequest,
    () => __Unit,
];
var PutBucketAnalyticsConfiguration = [
    9,
    n0,
    _PBACu,
    { [_h]: ["PUT", "/?analytics", 200] },
    () => PutBucketAnalyticsConfigurationRequest,
    () => __Unit,
];
var PutBucketCors = [
    9,
    n0,
    _PBC,
    { [_h]: ["PUT", "/?cors", 200] },
    () => PutBucketCorsRequest,
    () => __Unit,
];
var PutBucketEncryption = [
    9,
    n0,
    _PBE,
    { [_h]: ["PUT", "/?encryption", 200] },
    () => PutBucketEncryptionRequest,
    () => __Unit,
];
var PutBucketIntelligentTieringConfiguration = [
    9,
    n0,
    _PBITC,
    { [_h]: ["PUT", "/?intelligent-tiering", 200] },
    () => PutBucketIntelligentTieringConfigurationRequest,
    () => __Unit,
];
var PutBucketInventoryConfiguration = [
    9,
    n0,
    _PBIC,
    { [_h]: ["PUT", "/?inventory", 200] },
    () => PutBucketInventoryConfigurationRequest,
    () => __Unit,
];
var PutBucketLifecycleConfiguration = [
    9,
    n0,
    _PBLC,
    { [_h]: ["PUT", "/?lifecycle", 200] },
    () => PutBucketLifecycleConfigurationRequest,
    () => PutBucketLifecycleConfigurationOutput,
];
var PutBucketLogging = [
    9,
    n0,
    _PBL,
    { [_h]: ["PUT", "/?logging", 200] },
    () => PutBucketLoggingRequest,
    () => __Unit,
];
var PutBucketMetricsConfiguration = [
    9,
    n0,
    _PBMC,
    { [_h]: ["PUT", "/?metrics", 200] },
    () => PutBucketMetricsConfigurationRequest,
    () => __Unit,
];
var PutBucketNotificationConfiguration = [
    9,
    n0,
    _PBNC,
    { [_h]: ["PUT", "/?notification", 200] },
    () => PutBucketNotificationConfigurationRequest,
    () => __Unit,
];
var PutBucketOwnershipControls = [
    9,
    n0,
    _PBOC,
    { [_h]: ["PUT", "/?ownershipControls", 200] },
    () => PutBucketOwnershipControlsRequest,
    () => __Unit,
];
var PutBucketPolicy = [
    9,
    n0,
    _PBP,
    { [_h]: ["PUT", "/?policy", 200] },
    () => PutBucketPolicyRequest,
    () => __Unit,
];
var PutBucketReplication = [
    9,
    n0,
    _PBR,
    { [_h]: ["PUT", "/?replication", 200] },
    () => PutBucketReplicationRequest,
    () => __Unit,
];
var PutBucketRequestPayment = [
    9,
    n0,
    _PBRP,
    { [_h]: ["PUT", "/?requestPayment", 200] },
    () => PutBucketRequestPaymentRequest,
    () => __Unit,
];
var PutBucketTagging = [
    9,
    n0,
    _PBT,
    { [_h]: ["PUT", "/?tagging", 200] },
    () => PutBucketTaggingRequest,
    () => __Unit,
];
var PutBucketVersioning = [
    9,
    n0,
    _PBV,
    { [_h]: ["PUT", "/?versioning", 200] },
    () => PutBucketVersioningRequest,
    () => __Unit,
];
var PutBucketWebsite = [
    9,
    n0,
    _PBW,
    { [_h]: ["PUT", "/?website", 200] },
    () => PutBucketWebsiteRequest,
    () => __Unit,
];
var PutObject = [
    9,
    n0,
    _PO,
    { [_h]: ["PUT", "/{Key+}?x-id=PutObject", 200] },
    () => PutObjectRequest,
    () => PutObjectOutput,
];
var PutObjectAcl = [
    9,
    n0,
    _POA,
    { [_h]: ["PUT", "/{Key+}?acl", 200] },
    () => PutObjectAclRequest,
    () => PutObjectAclOutput,
];
var PutObjectLegalHold = [
    9,
    n0,
    _POLH,
    { [_h]: ["PUT", "/{Key+}?legal-hold", 200] },
    () => PutObjectLegalHoldRequest,
    () => PutObjectLegalHoldOutput,
];
var PutObjectLockConfiguration = [
    9,
    n0,
    _POLC,
    { [_h]: ["PUT", "/?object-lock", 200] },
    () => PutObjectLockConfigurationRequest,
    () => PutObjectLockConfigurationOutput,
];
var PutObjectRetention = [
    9,
    n0,
    _PORu,
    { [_h]: ["PUT", "/{Key+}?retention", 200] },
    () => PutObjectRetentionRequest,
    () => PutObjectRetentionOutput,
];
var PutObjectTagging = [
    9,
    n0,
    _POT,
    { [_h]: ["PUT", "/{Key+}?tagging", 200] },
    () => PutObjectTaggingRequest,
    () => PutObjectTaggingOutput,
];
var PutPublicAccessBlock = [
    9,
    n0,
    _PPAB,
    { [_h]: ["PUT", "/?publicAccessBlock", 200] },
    () => PutPublicAccessBlockRequest,
    () => __Unit,
];
var RenameObject = [
    9,
    n0,
    _RO,
    { [_h]: ["PUT", "/{Key+}?renameObject", 200] },
    () => RenameObjectRequest,
    () => RenameObjectOutput,
];
var RestoreObject = [
    9,
    n0,
    _ROe,
    { [_h]: ["POST", "/{Key+}?restore", 200] },
    () => RestoreObjectRequest,
    () => RestoreObjectOutput,
];
var SelectObjectContent = [
    9,
    n0,
    _SOC,
    { [_h]: ["POST", "/{Key+}?select&select-type=2", 200] },
    () => SelectObjectContentRequest,
    () => SelectObjectContentOutput,
];
var UpdateBucketMetadataInventoryTableConfiguration = [
    9,
    n0,
    _UBMITC,
    { [_h]: ["PUT", "/?metadataInventoryTable", 200] },
    () => UpdateBucketMetadataInventoryTableConfigurationRequest,
    () => __Unit,
];
var UpdateBucketMetadataJournalTableConfiguration = [
    9,
    n0,
    _UBMJTC,
    { [_h]: ["PUT", "/?metadataJournalTable", 200] },
    () => UpdateBucketMetadataJournalTableConfigurationRequest,
    () => __Unit,
];
var UploadPart = [
    9,
    n0,
    _UP,
    { [_h]: ["PUT", "/{Key+}?x-id=UploadPart", 200] },
    () => UploadPartRequest,
    () => UploadPartOutput,
];
var UploadPartCopy = [
    9,
    n0,
    _UPC,
    { [_h]: ["PUT", "/{Key+}?x-id=UploadPartCopy", 200] },
    () => UploadPartCopyRequest,
    () => UploadPartCopyOutput,
];
var WriteGetObjectResponse = [
    9,
    n0,
    _WGOR,
    { [_en]: ["{RequestRoute}."], [_h]: ["POST", "/WriteGetObjectResponse", 200] },
    () => WriteGetObjectResponseRequest,
    () => __Unit,
];

class CreateSessionCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    DisableS3ExpressSessionAuth: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "CreateSession", {})
    .n("S3Client", "CreateSessionCommand")
    .sc(CreateSession)
    .build() {
}

const getHttpAuthExtensionConfiguration = (runtimeConfig) => {
    const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
    let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
    let _credentials = runtimeConfig.credentials;
    return {
        setHttpAuthScheme(httpAuthScheme) {
            const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
            if (index === -1) {
                _httpAuthSchemes.push(httpAuthScheme);
            }
            else {
                _httpAuthSchemes.splice(index, 1, httpAuthScheme);
            }
        },
        httpAuthSchemes() {
            return _httpAuthSchemes;
        },
        setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
            _httpAuthSchemeProvider = httpAuthSchemeProvider;
        },
        httpAuthSchemeProvider() {
            return _httpAuthSchemeProvider;
        },
        setCredentials(credentials) {
            _credentials = credentials;
        },
        credentials() {
            return _credentials;
        },
    };
};
const resolveHttpAuthRuntimeConfig = (config) => {
    return {
        httpAuthSchemes: config.httpAuthSchemes(),
        httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
        credentials: config.credentials(),
    };
};

const resolveRuntimeExtensions = (runtimeConfig, extensions) => {
    const extensionConfiguration = Object.assign(regionConfigResolver.getAwsRegionExtensionConfiguration(runtimeConfig), smithyClient.getDefaultExtensionConfiguration(runtimeConfig), protocolHttp.getHttpHandlerExtensionConfiguration(runtimeConfig), getHttpAuthExtensionConfiguration(runtimeConfig));
    extensions.forEach((extension) => extension.configure(extensionConfiguration));
    return Object.assign(runtimeConfig, regionConfigResolver.resolveAwsRegionExtensionConfiguration(extensionConfiguration), smithyClient.resolveDefaultRuntimeConfig(extensionConfiguration), protocolHttp.resolveHttpHandlerRuntimeConfig(extensionConfiguration), resolveHttpAuthRuntimeConfig(extensionConfiguration));
};

class S3Client extends smithyClient.Client {
    config;
    constructor(...[configuration]) {
        const _config_0 = runtimeConfig.getRuntimeConfig(configuration || {});
        super(_config_0);
        this.initConfig = _config_0;
        const _config_1 = resolveClientEndpointParameters(_config_0);
        const _config_2 = middlewareUserAgent.resolveUserAgentConfig(_config_1);
        const _config_3 = middlewareFlexibleChecksums.resolveFlexibleChecksumsConfig(_config_2);
        const _config_4 = middlewareRetry.resolveRetryConfig(_config_3);
        const _config_5 = configResolver.resolveRegionConfig(_config_4);
        const _config_6 = middlewareHostHeader.resolveHostHeaderConfig(_config_5);
        const _config_7 = middlewareEndpoint.resolveEndpointConfig(_config_6);
        const _config_8 = eventstreamSerdeConfigResolver.resolveEventStreamSerdeConfig(_config_7);
        const _config_9 = httpAuthSchemeProvider.resolveHttpAuthSchemeConfig(_config_8);
        const _config_10 = middlewareSdkS3.resolveS3Config(_config_9, { session: [() => this, CreateSessionCommand] });
        const _config_11 = resolveRuntimeExtensions(_config_10, configuration?.extensions || []);
        this.config = _config_11;
        this.middlewareStack.use(schema.getSchemaSerdePlugin(this.config));
        this.middlewareStack.use(middlewareUserAgent.getUserAgentPlugin(this.config));
        this.middlewareStack.use(middlewareRetry.getRetryPlugin(this.config));
        this.middlewareStack.use(middlewareContentLength.getContentLengthPlugin(this.config));
        this.middlewareStack.use(middlewareHostHeader.getHostHeaderPlugin(this.config));
        this.middlewareStack.use(middlewareLogger.getLoggerPlugin(this.config));
        this.middlewareStack.use(middlewareRecursionDetection.getRecursionDetectionPlugin(this.config));
        this.middlewareStack.use(core.getHttpAuthSchemeEndpointRuleSetPlugin(this.config, {
            httpAuthSchemeParametersProvider: httpAuthSchemeProvider.defaultS3HttpAuthSchemeParametersProvider,
            identityProviderConfigProvider: async (config) => new core.DefaultIdentityProviderConfig({
                "aws.auth#sigv4": config.credentials,
                "aws.auth#sigv4a": config.credentials,
            }),
        }));
        this.middlewareStack.use(core.getHttpSigningPlugin(this.config));
        this.middlewareStack.use(middlewareSdkS3.getValidateBucketNamePlugin(this.config));
        this.middlewareStack.use(middlewareExpectContinue.getAddExpectContinuePlugin(this.config));
        this.middlewareStack.use(middlewareSdkS3.getRegionRedirectMiddlewarePlugin(this.config));
        this.middlewareStack.use(middlewareSdkS3.getS3ExpressPlugin(this.config));
        this.middlewareStack.use(middlewareSdkS3.getS3ExpressHttpSigningPlugin(this.config));
    }
    destroy() {
        super.destroy();
    }
}

class AbortMultipartUploadCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Key: { type: "contextParams", name: "Key" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "AbortMultipartUpload", {})
    .n("S3Client", "AbortMultipartUploadCommand")
    .sc(AbortMultipartUpload)
    .build() {
}

class CompleteMultipartUploadCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Key: { type: "contextParams", name: "Key" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
        middlewareSsec.getSsecPlugin(config),
    ];
})
    .s("AmazonS3", "CompleteMultipartUpload", {})
    .n("S3Client", "CompleteMultipartUploadCommand")
    .sc(CompleteMultipartUpload)
    .build() {
}

class CopyObjectCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    DisableS3ExpressSessionAuth: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
    Key: { type: "contextParams", name: "Key" },
    CopySource: { type: "contextParams", name: "CopySource" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
        middlewareSsec.getSsecPlugin(config),
    ];
})
    .s("AmazonS3", "CopyObject", {})
    .n("S3Client", "CopyObjectCommand")
    .sc(CopyObject)
    .build() {
}

class CreateBucketCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    DisableAccessPoints: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
        middlewareLocationConstraint.getLocationConstraintPlugin(config),
    ];
})
    .s("AmazonS3", "CreateBucket", {})
    .n("S3Client", "CreateBucketCommand")
    .sc(CreateBucket)
    .build() {
}

class CreateBucketMetadataConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "CreateBucketMetadataConfiguration", {})
    .n("S3Client", "CreateBucketMetadataConfigurationCommand")
    .sc(CreateBucketMetadataConfiguration)
    .build() {
}

class CreateBucketMetadataTableConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "CreateBucketMetadataTableConfiguration", {})
    .n("S3Client", "CreateBucketMetadataTableConfigurationCommand")
    .sc(CreateBucketMetadataTableConfiguration)
    .build() {
}

class CreateMultipartUploadCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Key: { type: "contextParams", name: "Key" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
        middlewareSsec.getSsecPlugin(config),
    ];
})
    .s("AmazonS3", "CreateMultipartUpload", {})
    .n("S3Client", "CreateMultipartUploadCommand")
    .sc(CreateMultipartUpload)
    .build() {
}

class DeleteBucketAnalyticsConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucketAnalyticsConfiguration", {})
    .n("S3Client", "DeleteBucketAnalyticsConfigurationCommand")
    .sc(DeleteBucketAnalyticsConfiguration)
    .build() {
}

class DeleteBucketCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucket", {})
    .n("S3Client", "DeleteBucketCommand")
    .sc(DeleteBucket)
    .build() {
}

class DeleteBucketCorsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucketCors", {})
    .n("S3Client", "DeleteBucketCorsCommand")
    .sc(DeleteBucketCors)
    .build() {
}

class DeleteBucketEncryptionCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucketEncryption", {})
    .n("S3Client", "DeleteBucketEncryptionCommand")
    .sc(DeleteBucketEncryption)
    .build() {
}

class DeleteBucketIntelligentTieringConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucketIntelligentTieringConfiguration", {})
    .n("S3Client", "DeleteBucketIntelligentTieringConfigurationCommand")
    .sc(DeleteBucketIntelligentTieringConfiguration)
    .build() {
}

class DeleteBucketInventoryConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucketInventoryConfiguration", {})
    .n("S3Client", "DeleteBucketInventoryConfigurationCommand")
    .sc(DeleteBucketInventoryConfiguration)
    .build() {
}

class DeleteBucketLifecycleCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucketLifecycle", {})
    .n("S3Client", "DeleteBucketLifecycleCommand")
    .sc(DeleteBucketLifecycle)
    .build() {
}

class DeleteBucketMetadataConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucketMetadataConfiguration", {})
    .n("S3Client", "DeleteBucketMetadataConfigurationCommand")
    .sc(DeleteBucketMetadataConfiguration)
    .build() {
}

class DeleteBucketMetadataTableConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucketMetadataTableConfiguration", {})
    .n("S3Client", "DeleteBucketMetadataTableConfigurationCommand")
    .sc(DeleteBucketMetadataTableConfiguration)
    .build() {
}

class DeleteBucketMetricsConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucketMetricsConfiguration", {})
    .n("S3Client", "DeleteBucketMetricsConfigurationCommand")
    .sc(DeleteBucketMetricsConfiguration)
    .build() {
}

class DeleteBucketOwnershipControlsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucketOwnershipControls", {})
    .n("S3Client", "DeleteBucketOwnershipControlsCommand")
    .sc(DeleteBucketOwnershipControls)
    .build() {
}

class DeleteBucketPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucketPolicy", {})
    .n("S3Client", "DeleteBucketPolicyCommand")
    .sc(DeleteBucketPolicy)
    .build() {
}

class DeleteBucketReplicationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucketReplication", {})
    .n("S3Client", "DeleteBucketReplicationCommand")
    .sc(DeleteBucketReplication)
    .build() {
}

class DeleteBucketTaggingCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucketTagging", {})
    .n("S3Client", "DeleteBucketTaggingCommand")
    .sc(DeleteBucketTagging)
    .build() {
}

class DeleteBucketWebsiteCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeleteBucketWebsite", {})
    .n("S3Client", "DeleteBucketWebsiteCommand")
    .sc(DeleteBucketWebsite)
    .build() {
}

class DeleteObjectCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Key: { type: "contextParams", name: "Key" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "DeleteObject", {})
    .n("S3Client", "DeleteObjectCommand")
    .sc(DeleteObject)
    .build() {
}

class DeleteObjectsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
    ];
})
    .s("AmazonS3", "DeleteObjects", {})
    .n("S3Client", "DeleteObjectsCommand")
    .sc(DeleteObjects)
    .build() {
}

class DeleteObjectTaggingCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "DeleteObjectTagging", {})
    .n("S3Client", "DeleteObjectTaggingCommand")
    .sc(DeleteObjectTagging)
    .build() {
}

class DeletePublicAccessBlockCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "DeletePublicAccessBlock", {})
    .n("S3Client", "DeletePublicAccessBlockCommand")
    .sc(DeletePublicAccessBlock)
    .build() {
}

class GetBucketAbacCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketAbac", {})
    .n("S3Client", "GetBucketAbacCommand")
    .sc(GetBucketAbac)
    .build() {
}

class GetBucketAccelerateConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketAccelerateConfiguration", {})
    .n("S3Client", "GetBucketAccelerateConfigurationCommand")
    .sc(GetBucketAccelerateConfiguration)
    .build() {
}

class GetBucketAclCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketAcl", {})
    .n("S3Client", "GetBucketAclCommand")
    .sc(GetBucketAcl)
    .build() {
}

class GetBucketAnalyticsConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketAnalyticsConfiguration", {})
    .n("S3Client", "GetBucketAnalyticsConfigurationCommand")
    .sc(GetBucketAnalyticsConfiguration)
    .build() {
}

class GetBucketCorsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketCors", {})
    .n("S3Client", "GetBucketCorsCommand")
    .sc(GetBucketCors)
    .build() {
}

class GetBucketEncryptionCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketEncryption", {})
    .n("S3Client", "GetBucketEncryptionCommand")
    .sc(GetBucketEncryption)
    .build() {
}

class GetBucketIntelligentTieringConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketIntelligentTieringConfiguration", {})
    .n("S3Client", "GetBucketIntelligentTieringConfigurationCommand")
    .sc(GetBucketIntelligentTieringConfiguration)
    .build() {
}

class GetBucketInventoryConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketInventoryConfiguration", {})
    .n("S3Client", "GetBucketInventoryConfigurationCommand")
    .sc(GetBucketInventoryConfiguration)
    .build() {
}

class GetBucketLifecycleConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketLifecycleConfiguration", {})
    .n("S3Client", "GetBucketLifecycleConfigurationCommand")
    .sc(GetBucketLifecycleConfiguration)
    .build() {
}

class GetBucketLocationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketLocation", {})
    .n("S3Client", "GetBucketLocationCommand")
    .sc(GetBucketLocation)
    .build() {
}

class GetBucketLoggingCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketLogging", {})
    .n("S3Client", "GetBucketLoggingCommand")
    .sc(GetBucketLogging)
    .build() {
}

class GetBucketMetadataConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketMetadataConfiguration", {})
    .n("S3Client", "GetBucketMetadataConfigurationCommand")
    .sc(GetBucketMetadataConfiguration)
    .build() {
}

class GetBucketMetadataTableConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketMetadataTableConfiguration", {})
    .n("S3Client", "GetBucketMetadataTableConfigurationCommand")
    .sc(GetBucketMetadataTableConfiguration)
    .build() {
}

class GetBucketMetricsConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketMetricsConfiguration", {})
    .n("S3Client", "GetBucketMetricsConfigurationCommand")
    .sc(GetBucketMetricsConfiguration)
    .build() {
}

class GetBucketNotificationConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketNotificationConfiguration", {})
    .n("S3Client", "GetBucketNotificationConfigurationCommand")
    .sc(GetBucketNotificationConfiguration)
    .build() {
}

class GetBucketOwnershipControlsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketOwnershipControls", {})
    .n("S3Client", "GetBucketOwnershipControlsCommand")
    .sc(GetBucketOwnershipControls)
    .build() {
}

class GetBucketPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketPolicy", {})
    .n("S3Client", "GetBucketPolicyCommand")
    .sc(GetBucketPolicy)
    .build() {
}

class GetBucketPolicyStatusCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketPolicyStatus", {})
    .n("S3Client", "GetBucketPolicyStatusCommand")
    .sc(GetBucketPolicyStatus)
    .build() {
}

class GetBucketReplicationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketReplication", {})
    .n("S3Client", "GetBucketReplicationCommand")
    .sc(GetBucketReplication)
    .build() {
}

class GetBucketRequestPaymentCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketRequestPayment", {})
    .n("S3Client", "GetBucketRequestPaymentCommand")
    .sc(GetBucketRequestPayment)
    .build() {
}

class GetBucketTaggingCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketTagging", {})
    .n("S3Client", "GetBucketTaggingCommand")
    .sc(GetBucketTagging)
    .build() {
}

class GetBucketVersioningCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketVersioning", {})
    .n("S3Client", "GetBucketVersioningCommand")
    .sc(GetBucketVersioning)
    .build() {
}

class GetBucketWebsiteCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetBucketWebsite", {})
    .n("S3Client", "GetBucketWebsiteCommand")
    .sc(GetBucketWebsite)
    .build() {
}

class GetObjectAclCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Key: { type: "contextParams", name: "Key" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetObjectAcl", {})
    .n("S3Client", "GetObjectAclCommand")
    .sc(GetObjectAcl)
    .build() {
}

class GetObjectAttributesCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
        middlewareSsec.getSsecPlugin(config),
    ];
})
    .s("AmazonS3", "GetObjectAttributes", {})
    .n("S3Client", "GetObjectAttributesCommand")
    .sc(GetObjectAttributes)
    .build() {
}

class GetObjectCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Key: { type: "contextParams", name: "Key" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestChecksumRequired: false,
            requestValidationModeMember: "ChecksumMode",
            responseAlgorithms: ["CRC64NVME", "CRC32", "CRC32C", "SHA256", "SHA1"],
        }),
        middlewareSsec.getSsecPlugin(config),
        middlewareSdkS3.getS3ExpiresMiddlewarePlugin(config),
    ];
})
    .s("AmazonS3", "GetObject", {})
    .n("S3Client", "GetObjectCommand")
    .sc(GetObject)
    .build() {
}

class GetObjectLegalHoldCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetObjectLegalHold", {})
    .n("S3Client", "GetObjectLegalHoldCommand")
    .sc(GetObjectLegalHold)
    .build() {
}

class GetObjectLockConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetObjectLockConfiguration", {})
    .n("S3Client", "GetObjectLockConfigurationCommand")
    .sc(GetObjectLockConfiguration)
    .build() {
}

class GetObjectRetentionCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetObjectRetention", {})
    .n("S3Client", "GetObjectRetentionCommand")
    .sc(GetObjectRetention)
    .build() {
}

class GetObjectTaggingCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetObjectTagging", {})
    .n("S3Client", "GetObjectTaggingCommand")
    .sc(GetObjectTagging)
    .build() {
}

class GetObjectTorrentCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "GetObjectTorrent", {})
    .n("S3Client", "GetObjectTorrentCommand")
    .sc(GetObjectTorrent)
    .build() {
}

class GetPublicAccessBlockCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "GetPublicAccessBlock", {})
    .n("S3Client", "GetPublicAccessBlockCommand")
    .sc(GetPublicAccessBlock)
    .build() {
}

class HeadBucketCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "HeadBucket", {})
    .n("S3Client", "HeadBucketCommand")
    .sc(HeadBucket)
    .build() {
}

class HeadObjectCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Key: { type: "contextParams", name: "Key" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
        middlewareSsec.getSsecPlugin(config),
        middlewareSdkS3.getS3ExpiresMiddlewarePlugin(config),
    ];
})
    .s("AmazonS3", "HeadObject", {})
    .n("S3Client", "HeadObjectCommand")
    .sc(HeadObject)
    .build() {
}

class ListBucketAnalyticsConfigurationsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "ListBucketAnalyticsConfigurations", {})
    .n("S3Client", "ListBucketAnalyticsConfigurationsCommand")
    .sc(ListBucketAnalyticsConfigurations)
    .build() {
}

class ListBucketIntelligentTieringConfigurationsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "ListBucketIntelligentTieringConfigurations", {})
    .n("S3Client", "ListBucketIntelligentTieringConfigurationsCommand")
    .sc(ListBucketIntelligentTieringConfigurations)
    .build() {
}

class ListBucketInventoryConfigurationsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "ListBucketInventoryConfigurations", {})
    .n("S3Client", "ListBucketInventoryConfigurationsCommand")
    .sc(ListBucketInventoryConfigurations)
    .build() {
}

class ListBucketMetricsConfigurationsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "ListBucketMetricsConfigurations", {})
    .n("S3Client", "ListBucketMetricsConfigurationsCommand")
    .sc(ListBucketMetricsConfigurations)
    .build() {
}

class ListBucketsCommand extends smithyClient.Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "ListBuckets", {})
    .n("S3Client", "ListBucketsCommand")
    .sc(ListBuckets)
    .build() {
}

class ListDirectoryBucketsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "ListDirectoryBuckets", {})
    .n("S3Client", "ListDirectoryBucketsCommand")
    .sc(ListDirectoryBuckets)
    .build() {
}

class ListMultipartUploadsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Prefix: { type: "contextParams", name: "Prefix" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "ListMultipartUploads", {})
    .n("S3Client", "ListMultipartUploadsCommand")
    .sc(ListMultipartUploads)
    .build() {
}

class ListObjectsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Prefix: { type: "contextParams", name: "Prefix" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "ListObjects", {})
    .n("S3Client", "ListObjectsCommand")
    .sc(ListObjects)
    .build() {
}

class ListObjectsV2Command extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Prefix: { type: "contextParams", name: "Prefix" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "ListObjectsV2", {})
    .n("S3Client", "ListObjectsV2Command")
    .sc(ListObjectsV2)
    .build() {
}

class ListObjectVersionsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Prefix: { type: "contextParams", name: "Prefix" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "ListObjectVersions", {})
    .n("S3Client", "ListObjectVersionsCommand")
    .sc(ListObjectVersions)
    .build() {
}

class ListPartsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Key: { type: "contextParams", name: "Key" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
        middlewareSsec.getSsecPlugin(config),
    ];
})
    .s("AmazonS3", "ListParts", {})
    .n("S3Client", "ListPartsCommand")
    .sc(ListParts)
    .build() {
}

class PutBucketAbacCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: false,
        }),
    ];
})
    .s("AmazonS3", "PutBucketAbac", {})
    .n("S3Client", "PutBucketAbacCommand")
    .sc(PutBucketAbac)
    .build() {
}

class PutBucketAccelerateConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: false,
        }),
    ];
})
    .s("AmazonS3", "PutBucketAccelerateConfiguration", {})
    .n("S3Client", "PutBucketAccelerateConfigurationCommand")
    .sc(PutBucketAccelerateConfiguration)
    .build() {
}

class PutBucketAclCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "PutBucketAcl", {})
    .n("S3Client", "PutBucketAclCommand")
    .sc(PutBucketAcl)
    .build() {
}

class PutBucketAnalyticsConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "PutBucketAnalyticsConfiguration", {})
    .n("S3Client", "PutBucketAnalyticsConfigurationCommand")
    .sc(PutBucketAnalyticsConfiguration)
    .build() {
}

class PutBucketCorsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "PutBucketCors", {})
    .n("S3Client", "PutBucketCorsCommand")
    .sc(PutBucketCors)
    .build() {
}

class PutBucketEncryptionCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "PutBucketEncryption", {})
    .n("S3Client", "PutBucketEncryptionCommand")
    .sc(PutBucketEncryption)
    .build() {
}

class PutBucketIntelligentTieringConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "PutBucketIntelligentTieringConfiguration", {})
    .n("S3Client", "PutBucketIntelligentTieringConfigurationCommand")
    .sc(PutBucketIntelligentTieringConfiguration)
    .build() {
}

class PutBucketInventoryConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "PutBucketInventoryConfiguration", {})
    .n("S3Client", "PutBucketInventoryConfigurationCommand")
    .sc(PutBucketInventoryConfiguration)
    .build() {
}

class PutBucketLifecycleConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
    ];
})
    .s("AmazonS3", "PutBucketLifecycleConfiguration", {})
    .n("S3Client", "PutBucketLifecycleConfigurationCommand")
    .sc(PutBucketLifecycleConfiguration)
    .build() {
}

class PutBucketLoggingCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "PutBucketLogging", {})
    .n("S3Client", "PutBucketLoggingCommand")
    .sc(PutBucketLogging)
    .build() {
}

class PutBucketMetricsConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "PutBucketMetricsConfiguration", {})
    .n("S3Client", "PutBucketMetricsConfigurationCommand")
    .sc(PutBucketMetricsConfiguration)
    .build() {
}

class PutBucketNotificationConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "PutBucketNotificationConfiguration", {})
    .n("S3Client", "PutBucketNotificationConfigurationCommand")
    .sc(PutBucketNotificationConfiguration)
    .build() {
}

class PutBucketOwnershipControlsCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "PutBucketOwnershipControls", {})
    .n("S3Client", "PutBucketOwnershipControlsCommand")
    .sc(PutBucketOwnershipControls)
    .build() {
}

class PutBucketPolicyCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "PutBucketPolicy", {})
    .n("S3Client", "PutBucketPolicyCommand")
    .sc(PutBucketPolicy)
    .build() {
}

class PutBucketReplicationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "PutBucketReplication", {})
    .n("S3Client", "PutBucketReplicationCommand")
    .sc(PutBucketReplication)
    .build() {
}

class PutBucketRequestPaymentCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "PutBucketRequestPayment", {})
    .n("S3Client", "PutBucketRequestPaymentCommand")
    .sc(PutBucketRequestPayment)
    .build() {
}

class PutBucketTaggingCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "PutBucketTagging", {})
    .n("S3Client", "PutBucketTaggingCommand")
    .sc(PutBucketTagging)
    .build() {
}

class PutBucketVersioningCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "PutBucketVersioning", {})
    .n("S3Client", "PutBucketVersioningCommand")
    .sc(PutBucketVersioning)
    .build() {
}

class PutBucketWebsiteCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "PutBucketWebsite", {})
    .n("S3Client", "PutBucketWebsiteCommand")
    .sc(PutBucketWebsite)
    .build() {
}

class PutObjectAclCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Key: { type: "contextParams", name: "Key" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
    ];
})
    .s("AmazonS3", "PutObjectAcl", {})
    .n("S3Client", "PutObjectAclCommand")
    .sc(PutObjectAcl)
    .build() {
}

class PutObjectCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Key: { type: "contextParams", name: "Key" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: false,
        }),
        middlewareSdkS3.getCheckContentLengthHeaderPlugin(config),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
        middlewareSsec.getSsecPlugin(config),
    ];
})
    .s("AmazonS3", "PutObject", {})
    .n("S3Client", "PutObjectCommand")
    .sc(PutObject)
    .build() {
}

class PutObjectLegalHoldCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
    ];
})
    .s("AmazonS3", "PutObjectLegalHold", {})
    .n("S3Client", "PutObjectLegalHoldCommand")
    .sc(PutObjectLegalHold)
    .build() {
}

class PutObjectLockConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
    ];
})
    .s("AmazonS3", "PutObjectLockConfiguration", {})
    .n("S3Client", "PutObjectLockConfigurationCommand")
    .sc(PutObjectLockConfiguration)
    .build() {
}

class PutObjectRetentionCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
    ];
})
    .s("AmazonS3", "PutObjectRetention", {})
    .n("S3Client", "PutObjectRetentionCommand")
    .sc(PutObjectRetention)
    .build() {
}

class PutObjectTaggingCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
    ];
})
    .s("AmazonS3", "PutObjectTagging", {})
    .n("S3Client", "PutObjectTaggingCommand")
    .sc(PutObjectTagging)
    .build() {
}

class PutPublicAccessBlockCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "PutPublicAccessBlock", {})
    .n("S3Client", "PutPublicAccessBlockCommand")
    .sc(PutPublicAccessBlock)
    .build() {
}

class RenameObjectCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Key: { type: "contextParams", name: "Key" },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()), middlewareSdkS3.getThrow200ExceptionsPlugin(config)];
})
    .s("AmazonS3", "RenameObject", {})
    .n("S3Client", "RenameObjectCommand")
    .sc(RenameObject)
    .build() {
}

class RestoreObjectCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: false,
        }),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
    ];
})
    .s("AmazonS3", "RestoreObject", {})
    .n("S3Client", "RestoreObjectCommand")
    .sc(RestoreObject)
    .build() {
}

class SelectObjectContentCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
        middlewareSsec.getSsecPlugin(config),
    ];
})
    .s("AmazonS3", "SelectObjectContent", {
    eventStream: {
        output: true,
    },
})
    .n("S3Client", "SelectObjectContentCommand")
    .sc(SelectObjectContent)
    .build() {
}

class UpdateBucketMetadataInventoryTableConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "UpdateBucketMetadataInventoryTableConfiguration", {})
    .n("S3Client", "UpdateBucketMetadataInventoryTableConfigurationCommand")
    .sc(UpdateBucketMetadataInventoryTableConfiguration)
    .build() {
}

class UpdateBucketMetadataJournalTableConfigurationCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseS3ExpressControlEndpoint: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: true,
        }),
    ];
})
    .s("AmazonS3", "UpdateBucketMetadataJournalTableConfiguration", {})
    .n("S3Client", "UpdateBucketMetadataJournalTableConfigurationCommand")
    .sc(UpdateBucketMetadataJournalTableConfiguration)
    .build() {
}

class UploadPartCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    Bucket: { type: "contextParams", name: "Bucket" },
    Key: { type: "contextParams", name: "Key" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareFlexibleChecksums.getFlexibleChecksumsPlugin(config, {
            requestAlgorithmMember: { httpHeader: "x-amz-sdk-checksum-algorithm", name: "ChecksumAlgorithm" },
            requestChecksumRequired: false,
        }),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
        middlewareSsec.getSsecPlugin(config),
    ];
})
    .s("AmazonS3", "UploadPart", {})
    .n("S3Client", "UploadPartCommand")
    .sc(UploadPart)
    .build() {
}

class UploadPartCopyCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    DisableS3ExpressSessionAuth: { type: "staticContextParams", value: true },
    Bucket: { type: "contextParams", name: "Bucket" },
})
    .m(function (Command, cs, config, o) {
    return [
        middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
        middlewareSdkS3.getThrow200ExceptionsPlugin(config),
        middlewareSsec.getSsecPlugin(config),
    ];
})
    .s("AmazonS3", "UploadPartCopy", {})
    .n("S3Client", "UploadPartCopyCommand")
    .sc(UploadPartCopy)
    .build() {
}

class WriteGetObjectResponseCommand extends smithyClient.Command
    .classBuilder()
    .ep({
    ...commonParams,
    UseObjectLambdaEndpoint: { type: "staticContextParams", value: true },
})
    .m(function (Command, cs, config, o) {
    return [middlewareEndpoint.getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonS3", "WriteGetObjectResponse", {})
    .n("S3Client", "WriteGetObjectResponseCommand")
    .sc(WriteGetObjectResponse)
    .build() {
}

const commands = {
    AbortMultipartUploadCommand,
    CompleteMultipartUploadCommand,
    CopyObjectCommand,
    CreateBucketCommand,
    CreateBucketMetadataConfigurationCommand,
    CreateBucketMetadataTableConfigurationCommand,
    CreateMultipartUploadCommand,
    CreateSessionCommand,
    DeleteBucketCommand,
    DeleteBucketAnalyticsConfigurationCommand,
    DeleteBucketCorsCommand,
    DeleteBucketEncryptionCommand,
    DeleteBucketIntelligentTieringConfigurationCommand,
    DeleteBucketInventoryConfigurationCommand,
    DeleteBucketLifecycleCommand,
    DeleteBucketMetadataConfigurationCommand,
    DeleteBucketMetadataTableConfigurationCommand,
    DeleteBucketMetricsConfigurationCommand,
    DeleteBucketOwnershipControlsCommand,
    DeleteBucketPolicyCommand,
    DeleteBucketReplicationCommand,
    DeleteBucketTaggingCommand,
    DeleteBucketWebsiteCommand,
    DeleteObjectCommand,
    DeleteObjectsCommand,
    DeleteObjectTaggingCommand,
    DeletePublicAccessBlockCommand,
    GetBucketAbacCommand,
    GetBucketAccelerateConfigurationCommand,
    GetBucketAclCommand,
    GetBucketAnalyticsConfigurationCommand,
    GetBucketCorsCommand,
    GetBucketEncryptionCommand,
    GetBucketIntelligentTieringConfigurationCommand,
    GetBucketInventoryConfigurationCommand,
    GetBucketLifecycleConfigurationCommand,
    GetBucketLocationCommand,
    GetBucketLoggingCommand,
    GetBucketMetadataConfigurationCommand,
    GetBucketMetadataTableConfigurationCommand,
    GetBucketMetricsConfigurationCommand,
    GetBucketNotificationConfigurationCommand,
    GetBucketOwnershipControlsCommand,
    GetBucketPolicyCommand,
    GetBucketPolicyStatusCommand,
    GetBucketReplicationCommand,
    GetBucketRequestPaymentCommand,
    GetBucketTaggingCommand,
    GetBucketVersioningCommand,
    GetBucketWebsiteCommand,
    GetObjectCommand,
    GetObjectAclCommand,
    GetObjectAttributesCommand,
    GetObjectLegalHoldCommand,
    GetObjectLockConfigurationCommand,
    GetObjectRetentionCommand,
    GetObjectTaggingCommand,
    GetObjectTorrentCommand,
    GetPublicAccessBlockCommand,
    HeadBucketCommand,
    HeadObjectCommand,
    ListBucketAnalyticsConfigurationsCommand,
    ListBucketIntelligentTieringConfigurationsCommand,
    ListBucketInventoryConfigurationsCommand,
    ListBucketMetricsConfigurationsCommand,
    ListBucketsCommand,
    ListDirectoryBucketsCommand,
    ListMultipartUploadsCommand,
    ListObjectsCommand,
    ListObjectsV2Command,
    ListObjectVersionsCommand,
    ListPartsCommand,
    PutBucketAbacCommand,
    PutBucketAccelerateConfigurationCommand,
    PutBucketAclCommand,
    PutBucketAnalyticsConfigurationCommand,
    PutBucketCorsCommand,
    PutBucketEncryptionCommand,
    PutBucketIntelligentTieringConfigurationCommand,
    PutBucketInventoryConfigurationCommand,
    PutBucketLifecycleConfigurationCommand,
    PutBucketLoggingCommand,
    PutBucketMetricsConfigurationCommand,
    PutBucketNotificationConfigurationCommand,
    PutBucketOwnershipControlsCommand,
    PutBucketPolicyCommand,
    PutBucketReplicationCommand,
    PutBucketRequestPaymentCommand,
    PutBucketTaggingCommand,
    PutBucketVersioningCommand,
    PutBucketWebsiteCommand,
    PutObjectCommand,
    PutObjectAclCommand,
    PutObjectLegalHoldCommand,
    PutObjectLockConfigurationCommand,
    PutObjectRetentionCommand,
    PutObjectTaggingCommand,
    PutPublicAccessBlockCommand,
    RenameObjectCommand,
    RestoreObjectCommand,
    SelectObjectContentCommand,
    UpdateBucketMetadataInventoryTableConfigurationCommand,
    UpdateBucketMetadataJournalTableConfigurationCommand,
    UploadPartCommand,
    UploadPartCopyCommand,
    WriteGetObjectResponseCommand,
};
class S3 extends S3Client {
}
smithyClient.createAggregatedClient(commands, S3);

const paginateListBuckets = core.createPaginator(S3Client, ListBucketsCommand, "ContinuationToken", "ContinuationToken", "MaxBuckets");

const paginateListDirectoryBuckets = core.createPaginator(S3Client, ListDirectoryBucketsCommand, "ContinuationToken", "ContinuationToken", "MaxDirectoryBuckets");

const paginateListObjectsV2 = core.createPaginator(S3Client, ListObjectsV2Command, "ContinuationToken", "NextContinuationToken", "MaxKeys");

const paginateListParts = core.createPaginator(S3Client, ListPartsCommand, "PartNumberMarker", "NextPartNumberMarker", "MaxParts");

const checkState$3 = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new HeadBucketCommand(input));
        reason = result;
        return { state: utilWaiter.WaiterState.SUCCESS, reason };
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "NotFound") {
            return { state: utilWaiter.WaiterState.RETRY, reason };
        }
    }
    return { state: utilWaiter.WaiterState.RETRY, reason };
};
const waitForBucketExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    return utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState$3);
};
const waitUntilBucketExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    const result = await utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState$3);
    return utilWaiter.checkExceptions(result);
};

const checkState$2 = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new HeadBucketCommand(input));
        reason = result;
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "NotFound") {
            return { state: utilWaiter.WaiterState.SUCCESS, reason };
        }
    }
    return { state: utilWaiter.WaiterState.RETRY, reason };
};
const waitForBucketNotExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    return utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState$2);
};
const waitUntilBucketNotExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    const result = await utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState$2);
    return utilWaiter.checkExceptions(result);
};

const checkState$1 = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new HeadObjectCommand(input));
        reason = result;
        return { state: utilWaiter.WaiterState.SUCCESS, reason };
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "NotFound") {
            return { state: utilWaiter.WaiterState.RETRY, reason };
        }
    }
    return { state: utilWaiter.WaiterState.RETRY, reason };
};
const waitForObjectExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    return utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState$1);
};
const waitUntilObjectExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    const result = await utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState$1);
    return utilWaiter.checkExceptions(result);
};

const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new HeadObjectCommand(input));
        reason = result;
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "NotFound") {
            return { state: utilWaiter.WaiterState.SUCCESS, reason };
        }
    }
    return { state: utilWaiter.WaiterState.RETRY, reason };
};
const waitForObjectNotExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    return utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
const waitUntilObjectNotExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    const result = await utilWaiter.createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return utilWaiter.checkExceptions(result);
};

const BucketAbacStatus = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
const RequestCharged = {
    requester: "requester",
};
const RequestPayer = {
    requester: "requester",
};
const BucketAccelerateStatus = {
    Enabled: "Enabled",
    Suspended: "Suspended",
};
const Type = {
    AmazonCustomerByEmail: "AmazonCustomerByEmail",
    CanonicalUser: "CanonicalUser",
    Group: "Group",
};
const Permission = {
    FULL_CONTROL: "FULL_CONTROL",
    READ: "READ",
    READ_ACP: "READ_ACP",
    WRITE: "WRITE",
    WRITE_ACP: "WRITE_ACP",
};
const OwnerOverride = {
    Destination: "Destination",
};
const ChecksumType = {
    COMPOSITE: "COMPOSITE",
    FULL_OBJECT: "FULL_OBJECT",
};
const ServerSideEncryption = {
    AES256: "AES256",
    aws_fsx: "aws:fsx",
    aws_kms: "aws:kms",
    aws_kms_dsse: "aws:kms:dsse",
};
const ObjectCannedACL = {
    authenticated_read: "authenticated-read",
    aws_exec_read: "aws-exec-read",
    bucket_owner_full_control: "bucket-owner-full-control",
    bucket_owner_read: "bucket-owner-read",
    private: "private",
    public_read: "public-read",
    public_read_write: "public-read-write",
};
const ChecksumAlgorithm = {
    CRC32: "CRC32",
    CRC32C: "CRC32C",
    CRC64NVME: "CRC64NVME",
    SHA1: "SHA1",
    SHA256: "SHA256",
};
const MetadataDirective = {
    COPY: "COPY",
    REPLACE: "REPLACE",
};
const ObjectLockLegalHoldStatus = {
    OFF: "OFF",
    ON: "ON",
};
const ObjectLockMode = {
    COMPLIANCE: "COMPLIANCE",
    GOVERNANCE: "GOVERNANCE",
};
const StorageClass = {
    DEEP_ARCHIVE: "DEEP_ARCHIVE",
    EXPRESS_ONEZONE: "EXPRESS_ONEZONE",
    FSX_ONTAP: "FSX_ONTAP",
    FSX_OPENZFS: "FSX_OPENZFS",
    GLACIER: "GLACIER",
    GLACIER_IR: "GLACIER_IR",
    INTELLIGENT_TIERING: "INTELLIGENT_TIERING",
    ONEZONE_IA: "ONEZONE_IA",
    OUTPOSTS: "OUTPOSTS",
    REDUCED_REDUNDANCY: "REDUCED_REDUNDANCY",
    SNOW: "SNOW",
    STANDARD: "STANDARD",
    STANDARD_IA: "STANDARD_IA",
};
const TaggingDirective = {
    COPY: "COPY",
    REPLACE: "REPLACE",
};
const BucketCannedACL = {
    authenticated_read: "authenticated-read",
    private: "private",
    public_read: "public-read",
    public_read_write: "public-read-write",
};
const DataRedundancy = {
    SingleAvailabilityZone: "SingleAvailabilityZone",
    SingleLocalZone: "SingleLocalZone",
};
const BucketType = {
    Directory: "Directory",
};
const LocationType = {
    AvailabilityZone: "AvailabilityZone",
    LocalZone: "LocalZone",
};
const BucketLocationConstraint = {
    EU: "EU",
    af_south_1: "af-south-1",
    ap_east_1: "ap-east-1",
    ap_northeast_1: "ap-northeast-1",
    ap_northeast_2: "ap-northeast-2",
    ap_northeast_3: "ap-northeast-3",
    ap_south_1: "ap-south-1",
    ap_south_2: "ap-south-2",
    ap_southeast_1: "ap-southeast-1",
    ap_southeast_2: "ap-southeast-2",
    ap_southeast_3: "ap-southeast-3",
    ap_southeast_4: "ap-southeast-4",
    ap_southeast_5: "ap-southeast-5",
    ca_central_1: "ca-central-1",
    cn_north_1: "cn-north-1",
    cn_northwest_1: "cn-northwest-1",
    eu_central_1: "eu-central-1",
    eu_central_2: "eu-central-2",
    eu_north_1: "eu-north-1",
    eu_south_1: "eu-south-1",
    eu_south_2: "eu-south-2",
    eu_west_1: "eu-west-1",
    eu_west_2: "eu-west-2",
    eu_west_3: "eu-west-3",
    il_central_1: "il-central-1",
    me_central_1: "me-central-1",
    me_south_1: "me-south-1",
    sa_east_1: "sa-east-1",
    us_east_2: "us-east-2",
    us_gov_east_1: "us-gov-east-1",
    us_gov_west_1: "us-gov-west-1",
    us_west_1: "us-west-1",
    us_west_2: "us-west-2",
};
const ObjectOwnership = {
    BucketOwnerEnforced: "BucketOwnerEnforced",
    BucketOwnerPreferred: "BucketOwnerPreferred",
    ObjectWriter: "ObjectWriter",
};
const InventoryConfigurationState = {
    DISABLED: "DISABLED",
    ENABLED: "ENABLED",
};
const TableSseAlgorithm = {
    AES256: "AES256",
    aws_kms: "aws:kms",
};
const ExpirationState = {
    DISABLED: "DISABLED",
    ENABLED: "ENABLED",
};
const SessionMode = {
    ReadOnly: "ReadOnly",
    ReadWrite: "ReadWrite",
};
const AnalyticsS3ExportFileFormat = {
    CSV: "CSV",
};
const StorageClassAnalysisSchemaVersion = {
    V_1: "V_1",
};
const EncryptionType = {
    NONE: "NONE",
    SSE_C: "SSE-C",
};
const IntelligentTieringStatus = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
const IntelligentTieringAccessTier = {
    ARCHIVE_ACCESS: "ARCHIVE_ACCESS",
    DEEP_ARCHIVE_ACCESS: "DEEP_ARCHIVE_ACCESS",
};
const InventoryFormat = {
    CSV: "CSV",
    ORC: "ORC",
    Parquet: "Parquet",
};
const InventoryIncludedObjectVersions = {
    All: "All",
    Current: "Current",
};
const InventoryOptionalField = {
    BucketKeyStatus: "BucketKeyStatus",
    ChecksumAlgorithm: "ChecksumAlgorithm",
    ETag: "ETag",
    EncryptionStatus: "EncryptionStatus",
    IntelligentTieringAccessTier: "IntelligentTieringAccessTier",
    IsMultipartUploaded: "IsMultipartUploaded",
    LastModifiedDate: "LastModifiedDate",
    LifecycleExpirationDate: "LifecycleExpirationDate",
    ObjectAccessControlList: "ObjectAccessControlList",
    ObjectLockLegalHoldStatus: "ObjectLockLegalHoldStatus",
    ObjectLockMode: "ObjectLockMode",
    ObjectLockRetainUntilDate: "ObjectLockRetainUntilDate",
    ObjectOwner: "ObjectOwner",
    ReplicationStatus: "ReplicationStatus",
    Size: "Size",
    StorageClass: "StorageClass",
};
const InventoryFrequency = {
    Daily: "Daily",
    Weekly: "Weekly",
};
const TransitionStorageClass = {
    DEEP_ARCHIVE: "DEEP_ARCHIVE",
    GLACIER: "GLACIER",
    GLACIER_IR: "GLACIER_IR",
    INTELLIGENT_TIERING: "INTELLIGENT_TIERING",
    ONEZONE_IA: "ONEZONE_IA",
    STANDARD_IA: "STANDARD_IA",
};
const ExpirationStatus = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
const TransitionDefaultMinimumObjectSize = {
    all_storage_classes_128K: "all_storage_classes_128K",
    varies_by_storage_class: "varies_by_storage_class",
};
const BucketLogsPermission = {
    FULL_CONTROL: "FULL_CONTROL",
    READ: "READ",
    WRITE: "WRITE",
};
const PartitionDateSource = {
    DeliveryTime: "DeliveryTime",
    EventTime: "EventTime",
};
const S3TablesBucketType = {
    aws: "aws",
    customer: "customer",
};
const Event = {
    s3_IntelligentTiering: "s3:IntelligentTiering",
    s3_LifecycleExpiration_: "s3:LifecycleExpiration:*",
    s3_LifecycleExpiration_Delete: "s3:LifecycleExpiration:Delete",
    s3_LifecycleExpiration_DeleteMarkerCreated: "s3:LifecycleExpiration:DeleteMarkerCreated",
    s3_LifecycleTransition: "s3:LifecycleTransition",
    s3_ObjectAcl_Put: "s3:ObjectAcl:Put",
    s3_ObjectCreated_: "s3:ObjectCreated:*",
    s3_ObjectCreated_CompleteMultipartUpload: "s3:ObjectCreated:CompleteMultipartUpload",
    s3_ObjectCreated_Copy: "s3:ObjectCreated:Copy",
    s3_ObjectCreated_Post: "s3:ObjectCreated:Post",
    s3_ObjectCreated_Put: "s3:ObjectCreated:Put",
    s3_ObjectRemoved_: "s3:ObjectRemoved:*",
    s3_ObjectRemoved_Delete: "s3:ObjectRemoved:Delete",
    s3_ObjectRemoved_DeleteMarkerCreated: "s3:ObjectRemoved:DeleteMarkerCreated",
    s3_ObjectRestore_: "s3:ObjectRestore:*",
    s3_ObjectRestore_Completed: "s3:ObjectRestore:Completed",
    s3_ObjectRestore_Delete: "s3:ObjectRestore:Delete",
    s3_ObjectRestore_Post: "s3:ObjectRestore:Post",
    s3_ObjectTagging_: "s3:ObjectTagging:*",
    s3_ObjectTagging_Delete: "s3:ObjectTagging:Delete",
    s3_ObjectTagging_Put: "s3:ObjectTagging:Put",
    s3_ReducedRedundancyLostObject: "s3:ReducedRedundancyLostObject",
    s3_Replication_: "s3:Replication:*",
    s3_Replication_OperationFailedReplication: "s3:Replication:OperationFailedReplication",
    s3_Replication_OperationMissedThreshold: "s3:Replication:OperationMissedThreshold",
    s3_Replication_OperationNotTracked: "s3:Replication:OperationNotTracked",
    s3_Replication_OperationReplicatedAfterThreshold: "s3:Replication:OperationReplicatedAfterThreshold",
};
const FilterRuleName = {
    prefix: "prefix",
    suffix: "suffix",
};
const DeleteMarkerReplicationStatus = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
const MetricsStatus = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
const ReplicationTimeStatus = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
const ExistingObjectReplicationStatus = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
const ReplicaModificationsStatus = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
const SseKmsEncryptedObjectsStatus = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
const ReplicationRuleStatus = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
const Payer = {
    BucketOwner: "BucketOwner",
    Requester: "Requester",
};
const MFADeleteStatus = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
const BucketVersioningStatus = {
    Enabled: "Enabled",
    Suspended: "Suspended",
};
const Protocol = {
    http: "http",
    https: "https",
};
const ReplicationStatus = {
    COMPLETE: "COMPLETE",
    COMPLETED: "COMPLETED",
    FAILED: "FAILED",
    PENDING: "PENDING",
    REPLICA: "REPLICA",
};
const ChecksumMode = {
    ENABLED: "ENABLED",
};
const ObjectAttributes = {
    CHECKSUM: "Checksum",
    ETAG: "ETag",
    OBJECT_PARTS: "ObjectParts",
    OBJECT_SIZE: "ObjectSize",
    STORAGE_CLASS: "StorageClass",
};
const ObjectLockEnabled = {
    Enabled: "Enabled",
};
const ObjectLockRetentionMode = {
    COMPLIANCE: "COMPLIANCE",
    GOVERNANCE: "GOVERNANCE",
};
const ArchiveStatus = {
    ARCHIVE_ACCESS: "ARCHIVE_ACCESS",
    DEEP_ARCHIVE_ACCESS: "DEEP_ARCHIVE_ACCESS",
};
const EncodingType = {
    url: "url",
};
const ObjectStorageClass = {
    DEEP_ARCHIVE: "DEEP_ARCHIVE",
    EXPRESS_ONEZONE: "EXPRESS_ONEZONE",
    FSX_ONTAP: "FSX_ONTAP",
    FSX_OPENZFS: "FSX_OPENZFS",
    GLACIER: "GLACIER",
    GLACIER_IR: "GLACIER_IR",
    INTELLIGENT_TIERING: "INTELLIGENT_TIERING",
    ONEZONE_IA: "ONEZONE_IA",
    OUTPOSTS: "OUTPOSTS",
    REDUCED_REDUNDANCY: "REDUCED_REDUNDANCY",
    SNOW: "SNOW",
    STANDARD: "STANDARD",
    STANDARD_IA: "STANDARD_IA",
};
const OptionalObjectAttributes = {
    RESTORE_STATUS: "RestoreStatus",
};
const ObjectVersionStorageClass = {
    STANDARD: "STANDARD",
};
const MFADelete = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
const Tier = {
    Bulk: "Bulk",
    Expedited: "Expedited",
    Standard: "Standard",
};
const ExpressionType = {
    SQL: "SQL",
};
const CompressionType = {
    BZIP2: "BZIP2",
    GZIP: "GZIP",
    NONE: "NONE",
};
const FileHeaderInfo = {
    IGNORE: "IGNORE",
    NONE: "NONE",
    USE: "USE",
};
const JSONType = {
    DOCUMENT: "DOCUMENT",
    LINES: "LINES",
};
const QuoteFields = {
    ALWAYS: "ALWAYS",
    ASNEEDED: "ASNEEDED",
};
const RestoreRequestType = {
    SELECT: "SELECT",
};

Object.defineProperty(exports, "$Command", {
    enumerable: true,
    get: function () { return smithyClient.Command; }
});
Object.defineProperty(exports, "__Client", {
    enumerable: true,
    get: function () { return smithyClient.Client; }
});
exports.AbortMultipartUploadCommand = AbortMultipartUploadCommand;
exports.AnalyticsS3ExportFileFormat = AnalyticsS3ExportFileFormat;
exports.ArchiveStatus = ArchiveStatus;
exports.BucketAbacStatus = BucketAbacStatus;
exports.BucketAccelerateStatus = BucketAccelerateStatus;
exports.BucketAlreadyExists = BucketAlreadyExists$1;
exports.BucketAlreadyOwnedByYou = BucketAlreadyOwnedByYou$1;
exports.BucketCannedACL = BucketCannedACL;
exports.BucketLocationConstraint = BucketLocationConstraint;
exports.BucketLogsPermission = BucketLogsPermission;
exports.BucketType = BucketType;
exports.BucketVersioningStatus = BucketVersioningStatus;
exports.ChecksumAlgorithm = ChecksumAlgorithm;
exports.ChecksumMode = ChecksumMode;
exports.ChecksumType = ChecksumType;
exports.CompleteMultipartUploadCommand = CompleteMultipartUploadCommand;
exports.CompressionType = CompressionType;
exports.CopyObjectCommand = CopyObjectCommand;
exports.CreateBucketCommand = CreateBucketCommand;
exports.CreateBucketMetadataConfigurationCommand = CreateBucketMetadataConfigurationCommand;
exports.CreateBucketMetadataTableConfigurationCommand = CreateBucketMetadataTableConfigurationCommand;
exports.CreateMultipartUploadCommand = CreateMultipartUploadCommand;
exports.CreateSessionCommand = CreateSessionCommand;
exports.DataRedundancy = DataRedundancy;
exports.DeleteBucketAnalyticsConfigurationCommand = DeleteBucketAnalyticsConfigurationCommand;
exports.DeleteBucketCommand = DeleteBucketCommand;
exports.DeleteBucketCorsCommand = DeleteBucketCorsCommand;
exports.DeleteBucketEncryptionCommand = DeleteBucketEncryptionCommand;
exports.DeleteBucketIntelligentTieringConfigurationCommand = DeleteBucketIntelligentTieringConfigurationCommand;
exports.DeleteBucketInventoryConfigurationCommand = DeleteBucketInventoryConfigurationCommand;
exports.DeleteBucketLifecycleCommand = DeleteBucketLifecycleCommand;
exports.DeleteBucketMetadataConfigurationCommand = DeleteBucketMetadataConfigurationCommand;
exports.DeleteBucketMetadataTableConfigurationCommand = DeleteBucketMetadataTableConfigurationCommand;
exports.DeleteBucketMetricsConfigurationCommand = DeleteBucketMetricsConfigurationCommand;
exports.DeleteBucketOwnershipControlsCommand = DeleteBucketOwnershipControlsCommand;
exports.DeleteBucketPolicyCommand = DeleteBucketPolicyCommand;
exports.DeleteBucketReplicationCommand = DeleteBucketReplicationCommand;
exports.DeleteBucketTaggingCommand = DeleteBucketTaggingCommand;
exports.DeleteBucketWebsiteCommand = DeleteBucketWebsiteCommand;
exports.DeleteMarkerReplicationStatus = DeleteMarkerReplicationStatus;
exports.DeleteObjectCommand = DeleteObjectCommand;
exports.DeleteObjectTaggingCommand = DeleteObjectTaggingCommand;
exports.DeleteObjectsCommand = DeleteObjectsCommand;
exports.DeletePublicAccessBlockCommand = DeletePublicAccessBlockCommand;
exports.EncodingType = EncodingType;
exports.EncryptionType = EncryptionType;
exports.EncryptionTypeMismatch = EncryptionTypeMismatch$1;
exports.Event = Event;
exports.ExistingObjectReplicationStatus = ExistingObjectReplicationStatus;
exports.ExpirationState = ExpirationState;
exports.ExpirationStatus = ExpirationStatus;
exports.ExpressionType = ExpressionType;
exports.FileHeaderInfo = FileHeaderInfo;
exports.FilterRuleName = FilterRuleName;
exports.GetBucketAbacCommand = GetBucketAbacCommand;
exports.GetBucketAccelerateConfigurationCommand = GetBucketAccelerateConfigurationCommand;
exports.GetBucketAclCommand = GetBucketAclCommand;
exports.GetBucketAnalyticsConfigurationCommand = GetBucketAnalyticsConfigurationCommand;
exports.GetBucketCorsCommand = GetBucketCorsCommand;
exports.GetBucketEncryptionCommand = GetBucketEncryptionCommand;
exports.GetBucketIntelligentTieringConfigurationCommand = GetBucketIntelligentTieringConfigurationCommand;
exports.GetBucketInventoryConfigurationCommand = GetBucketInventoryConfigurationCommand;
exports.GetBucketLifecycleConfigurationCommand = GetBucketLifecycleConfigurationCommand;
exports.GetBucketLocationCommand = GetBucketLocationCommand;
exports.GetBucketLoggingCommand = GetBucketLoggingCommand;
exports.GetBucketMetadataConfigurationCommand = GetBucketMetadataConfigurationCommand;
exports.GetBucketMetadataTableConfigurationCommand = GetBucketMetadataTableConfigurationCommand;
exports.GetBucketMetricsConfigurationCommand = GetBucketMetricsConfigurationCommand;
exports.GetBucketNotificationConfigurationCommand = GetBucketNotificationConfigurationCommand;
exports.GetBucketOwnershipControlsCommand = GetBucketOwnershipControlsCommand;
exports.GetBucketPolicyCommand = GetBucketPolicyCommand;
exports.GetBucketPolicyStatusCommand = GetBucketPolicyStatusCommand;
exports.GetBucketReplicationCommand = GetBucketReplicationCommand;
exports.GetBucketRequestPaymentCommand = GetBucketRequestPaymentCommand;
exports.GetBucketTaggingCommand = GetBucketTaggingCommand;
exports.GetBucketVersioningCommand = GetBucketVersioningCommand;
exports.GetBucketWebsiteCommand = GetBucketWebsiteCommand;
exports.GetObjectAclCommand = GetObjectAclCommand;
exports.GetObjectAttributesCommand = GetObjectAttributesCommand;
exports.GetObjectCommand = GetObjectCommand;
exports.GetObjectLegalHoldCommand = GetObjectLegalHoldCommand;
exports.GetObjectLockConfigurationCommand = GetObjectLockConfigurationCommand;
exports.GetObjectRetentionCommand = GetObjectRetentionCommand;
exports.GetObjectTaggingCommand = GetObjectTaggingCommand;
exports.GetObjectTorrentCommand = GetObjectTorrentCommand;
exports.GetPublicAccessBlockCommand = GetPublicAccessBlockCommand;
exports.HeadBucketCommand = HeadBucketCommand;
exports.HeadObjectCommand = HeadObjectCommand;
exports.IdempotencyParameterMismatch = IdempotencyParameterMismatch$1;
exports.IntelligentTieringAccessTier = IntelligentTieringAccessTier;
exports.IntelligentTieringStatus = IntelligentTieringStatus;
exports.InvalidObjectState = InvalidObjectState$1;
exports.InvalidRequest = InvalidRequest$1;
exports.InvalidWriteOffset = InvalidWriteOffset$1;
exports.InventoryConfigurationState = InventoryConfigurationState;
exports.InventoryFormat = InventoryFormat;
exports.InventoryFrequency = InventoryFrequency;
exports.InventoryIncludedObjectVersions = InventoryIncludedObjectVersions;
exports.InventoryOptionalField = InventoryOptionalField;
exports.JSONType = JSONType;
exports.ListBucketAnalyticsConfigurationsCommand = ListBucketAnalyticsConfigurationsCommand;
exports.ListBucketIntelligentTieringConfigurationsCommand = ListBucketIntelligentTieringConfigurationsCommand;
exports.ListBucketInventoryConfigurationsCommand = ListBucketInventoryConfigurationsCommand;
exports.ListBucketMetricsConfigurationsCommand = ListBucketMetricsConfigurationsCommand;
exports.ListBucketsCommand = ListBucketsCommand;
exports.ListDirectoryBucketsCommand = ListDirectoryBucketsCommand;
exports.ListMultipartUploadsCommand = ListMultipartUploadsCommand;
exports.ListObjectVersionsCommand = ListObjectVersionsCommand;
exports.ListObjectsCommand = ListObjectsCommand;
exports.ListObjectsV2Command = ListObjectsV2Command;
exports.ListPartsCommand = ListPartsCommand;
exports.LocationType = LocationType;
exports.MFADelete = MFADelete;
exports.MFADeleteStatus = MFADeleteStatus;
exports.MetadataDirective = MetadataDirective;
exports.MetricsStatus = MetricsStatus;
exports.NoSuchBucket = NoSuchBucket$1;
exports.NoSuchKey = NoSuchKey$1;
exports.NoSuchUpload = NoSuchUpload$1;
exports.NotFound = NotFound$1;
exports.ObjectAlreadyInActiveTierError = ObjectAlreadyInActiveTierError$1;
exports.ObjectAttributes = ObjectAttributes;
exports.ObjectCannedACL = ObjectCannedACL;
exports.ObjectLockEnabled = ObjectLockEnabled;
exports.ObjectLockLegalHoldStatus = ObjectLockLegalHoldStatus;
exports.ObjectLockMode = ObjectLockMode;
exports.ObjectLockRetentionMode = ObjectLockRetentionMode;
exports.ObjectNotInActiveTierError = ObjectNotInActiveTierError$1;
exports.ObjectOwnership = ObjectOwnership;
exports.ObjectStorageClass = ObjectStorageClass;
exports.ObjectVersionStorageClass = ObjectVersionStorageClass;
exports.OptionalObjectAttributes = OptionalObjectAttributes;
exports.OwnerOverride = OwnerOverride;
exports.PartitionDateSource = PartitionDateSource;
exports.Payer = Payer;
exports.Permission = Permission;
exports.Protocol = Protocol;
exports.PutBucketAbacCommand = PutBucketAbacCommand;
exports.PutBucketAccelerateConfigurationCommand = PutBucketAccelerateConfigurationCommand;
exports.PutBucketAclCommand = PutBucketAclCommand;
exports.PutBucketAnalyticsConfigurationCommand = PutBucketAnalyticsConfigurationCommand;
exports.PutBucketCorsCommand = PutBucketCorsCommand;
exports.PutBucketEncryptionCommand = PutBucketEncryptionCommand;
exports.PutBucketIntelligentTieringConfigurationCommand = PutBucketIntelligentTieringConfigurationCommand;
exports.PutBucketInventoryConfigurationCommand = PutBucketInventoryConfigurationCommand;
exports.PutBucketLifecycleConfigurationCommand = PutBucketLifecycleConfigurationCommand;
exports.PutBucketLoggingCommand = PutBucketLoggingCommand;
exports.PutBucketMetricsConfigurationCommand = PutBucketMetricsConfigurationCommand;
exports.PutBucketNotificationConfigurationCommand = PutBucketNotificationConfigurationCommand;
exports.PutBucketOwnershipControlsCommand = PutBucketOwnershipControlsCommand;
exports.PutBucketPolicyCommand = PutBucketPolicyCommand;
exports.PutBucketReplicationCommand = PutBucketReplicationCommand;
exports.PutBucketRequestPaymentCommand = PutBucketRequestPaymentCommand;
exports.PutBucketTaggingCommand = PutBucketTaggingCommand;
exports.PutBucketVersioningCommand = PutBucketVersioningCommand;
exports.PutBucketWebsiteCommand = PutBucketWebsiteCommand;
exports.PutObjectAclCommand = PutObjectAclCommand;
exports.PutObjectCommand = PutObjectCommand;
exports.PutObjectLegalHoldCommand = PutObjectLegalHoldCommand;
exports.PutObjectLockConfigurationCommand = PutObjectLockConfigurationCommand;
exports.PutObjectRetentionCommand = PutObjectRetentionCommand;
exports.PutObjectTaggingCommand = PutObjectTaggingCommand;
exports.PutPublicAccessBlockCommand = PutPublicAccessBlockCommand;
exports.QuoteFields = QuoteFields;
exports.RenameObjectCommand = RenameObjectCommand;
exports.ReplicaModificationsStatus = ReplicaModificationsStatus;
exports.ReplicationRuleStatus = ReplicationRuleStatus;
exports.ReplicationStatus = ReplicationStatus;
exports.ReplicationTimeStatus = ReplicationTimeStatus;
exports.RequestCharged = RequestCharged;
exports.RequestPayer = RequestPayer;
exports.RestoreObjectCommand = RestoreObjectCommand;
exports.RestoreRequestType = RestoreRequestType;
exports.S3 = S3;
exports.S3Client = S3Client;
exports.S3ServiceException = S3ServiceException$1;
exports.S3TablesBucketType = S3TablesBucketType;
exports.SelectObjectContentCommand = SelectObjectContentCommand;
exports.ServerSideEncryption = ServerSideEncryption;
exports.SessionMode = SessionMode;
exports.SseKmsEncryptedObjectsStatus = SseKmsEncryptedObjectsStatus;
exports.StorageClass = StorageClass;
exports.StorageClassAnalysisSchemaVersion = StorageClassAnalysisSchemaVersion;
exports.TableSseAlgorithm = TableSseAlgorithm;
exports.TaggingDirective = TaggingDirective;
exports.Tier = Tier;
exports.TooManyParts = TooManyParts$1;
exports.TransitionDefaultMinimumObjectSize = TransitionDefaultMinimumObjectSize;
exports.TransitionStorageClass = TransitionStorageClass;
exports.Type = Type;
exports.UpdateBucketMetadataInventoryTableConfigurationCommand = UpdateBucketMetadataInventoryTableConfigurationCommand;
exports.UpdateBucketMetadataJournalTableConfigurationCommand = UpdateBucketMetadataJournalTableConfigurationCommand;
exports.UploadPartCommand = UploadPartCommand;
exports.UploadPartCopyCommand = UploadPartCopyCommand;
exports.WriteGetObjectResponseCommand = WriteGetObjectResponseCommand;
exports.paginateListBuckets = paginateListBuckets;
exports.paginateListDirectoryBuckets = paginateListDirectoryBuckets;
exports.paginateListObjectsV2 = paginateListObjectsV2;
exports.paginateListParts = paginateListParts;
exports.waitForBucketExists = waitForBucketExists;
exports.waitForBucketNotExists = waitForBucketNotExists;
exports.waitForObjectExists = waitForObjectExists;
exports.waitForObjectNotExists = waitForObjectNotExists;
exports.waitUntilBucketExists = waitUntilBucketExists;
exports.waitUntilBucketNotExists = waitUntilBucketNotExists;
exports.waitUntilObjectExists = waitUntilObjectExists;
exports.waitUntilObjectNotExists = waitUntilObjectNotExists;
